(ns dda.clj-threats.framework.sanitize
  (:require
   [clojure.set :as se]
   [clojure.spec.alpha :as s]
   [orchestra.core :refer [defn-spec]]))

(defn-spec seq-intersection-some? boolean?
  [seq1 sequential?
   seq2 sequential?]
  (not (empty? (se/intersection (set seq1) (set seq2)))))

(defn-spec seq-contains? boolean?
  [seq sequential?
   item string?]
  (some #(= item %) seq))

(defn-spec add-id-to-leaf map?
  [outer-key keyword?
   leaf map?]
    (merge {:id (name outer-key)}
           leaf))

(defn-spec contains-in? boolean?
  [map map?
   keys (s/+ keyword?)]
  (some? (get-in map keys)))

(defn-spec add-id-to-submap map?
  [function fn?
   input map?]
  (reduce-kv
   (fn [m k v]
     (assoc
      m k (if (map? v)
            (apply function [k v])
            v)))
   {} input))

(defn-spec add-id-to-map-seq sequential?
  [function fn?
   input sequential?]
  (map
   (fn [elem]
     (if (map? elem)
       (add-id-to-submap function elem)
       elem))
   input))

(defn replace-nil-by-empty-map 
  [value key-to-consider]
  (if (and (map? value) (contains? value key-to-consider) (nil? (get value key-to-consider)))
    (merge value {key-to-consider {}})
    value))

(defn add-id-values 
  [value key-to-consider]
  (if (and (map? value) (contains? value key-to-consider) (map? (get value key-to-consider)))
    (merge value {key-to-consider (add-id-to-submap add-id-to-leaf (get value key-to-consider))})
    value))