(ns dda.clj-threats.domain.rule.processed-data
  (:require
   [orchestra.core :refer [defn-spec]]
   [dda.clj-threats.domain.rule.model :as m]
   [dda.clj-threats.domain.scored-attack-tree :as sat]
   [dda.clj-threats.domain.threagile :as ta]))

(defn-spec user-input-data-assets ::m/threat
  [technical-asset ::ta/technical-asset
   threagile ::ta/threagile
   attacks ::sat/attacks]
  (let [processed-asset-set (:data_assets_processed technical-asset)
        assets-under-threat (ta/data-asset-filtered
                             processed-asset-set
                             (fn [x] (some #(= "user-input" %) (:tags x)))
                             threagile)
        first-asset (first assets-under-threat)]
    (when (not-empty assets-under-threat)
      {:id (str "silent-typo-squatting: " (:id technical-asset))
       :data-asset first-asset
       :attack (get-in attacks [:attacks_used :silent-typo-squatting])})))