(ns dda.clj-threats.domain.threagile.boundary
  (:require
   [clojure.spec.alpha :as s]
   [orchestra.core :refer [defn-spec]]
   [dda.c4k-common.predicate :as cp]))

(s/def ::name keyword?)
(s/def ::id string?)
(s/def ::description string?)
(s/def ::technical_assets_inside (s/* string?))

(s/def ::trust_boundary (s/keys :req-un [::id]
                                :opt-un [::description ::technical_assets_inside]))

(s/def ::trust_boundaries (s/map-of ::name ::trust_boundary))
