(ns dda.clj-threats.domain.report.management-summary
  (:require
   [orchestra.core :refer [defn-spec]]
   [dda.c4k-common.common :as cm]
   [dda.clj-threats.domain.score :as sc]
   [dda.clj-threats.domain.attack-tree :as ak]
   [dda.clj-threats.domain.threagile :as ta]
   [dda.clj-threats.domain.rules :as ru]
   [dda.clj-threats.domain.report.model :as mod]))

(defn-spec threat-overview ::mod/document
  [with-or-out #{"with" "without"}
   threagile ::ta/threagile
   attacks ::ak/attacks
   threats ::ru/threats]
  {:path (str "management-summary-" with-or-out ".adoc")
   :dir ""
   :lines
   (cm/concat-vec
    (when (pos? (count threats))
      (cm/concat-vec
       [(str "= Threat Overview " with-or-out " Mitigation")
        ""
        "[mermaid, format=png]"
        "...."
        "---"
        "config:"
        "  quadrantChart:"
        "    chartWidth: 400"
        "    chartHeight: 400"
        "  theme: base"
        "---"
        "quadrantChart"
        "  x-axis Likelihood Low --> High"
        "  y-axis Impact Low --> High"]
       (map
        (fn [x]
          (let [threat-id (get-in x [:attack :id])
                dread-score (get-in x [:attack :score])
                il-score (sc/impact-likelihood-score dread-score)
                {:keys [impact likelihood]} il-score]
            (str "  " threat-id
                 ": [" (* 0.01 likelihood)
                 "," (* 0.01 impact) "]")))
        threats)
       ["...."
        ""]
       (when (= with-or-out "with")
         (cm/concat-vec 
          [".Mitigations active:"]
          (map (fn [x] (str "* " x)) (get-in attacks [:mitigations_active]))
          [""])))))})

(defn-spec management-summary ::mod/document
  [threagile ::ta/threagile
   attacks ::ak/attacks
   threats-with-mitigation ::ru/threats
   threats-without-mitigation ::ru/threats]
  (let [childs (cm/concat-vec
                [(threat-overview "without" threagile attacks threats-without-mitigation)]
                [(threat-overview "with" threagile attacks threats-with-mitigation)])]
    {:path "management-summary.adoc"
     :dir ""
     :lines
     (cm/concat-vec
      (when (or (contains? threagile :management_summary_comment) (pos? (count threats-without-mitigation)))
        ["= Management Summary"
         ""])
      (when (contains? threagile :management_summary_comment)
        [(get-in threagile [:management_summary_comment])
         ""])
      (map mod/include-child childs))
     :childs childs
     }))
