(ns dda.clj-threats.domain.threagile.data-asset
  (:require
   [clojure.spec.alpha :as s]
   [orchestra.core :refer [defn-spec]]
   [dda.c4k-common.predicate :as cp]))

(s/def ::name keyword?)
(s/def ::id string?)
(s/def ::description string?)
(s/def ::owner string?)
(s/def ::tags (s/* string?))

(s/def ::data-asset (s/keys :req-un [::id ::description ::owner ::tags]
                            :opt-un []))

(s/def ::data_assets (s/map-of ::name ::data-asset))
