(ns dda.clj-threats.domain.rule.communication
  (:require
   [orchestra.core :refer [defn-spec]]
   [dda.clj-threats.domain.rule.model :as m]
   [dda.clj-threats.domain.scored-attack-tree :as sat]
   [dda.clj-threats.domain.threagile :as ta]))

(defn-spec reference-containing-assets ::m/threat
  [source ::ta/technical-asset
   target ::ta/technical-asset
   link ::ta/link
   assets-affected ::m/data-asset-ids
   threagile ::ta/threagile
   attacks ::sat/attacks]
  (let [activity-pub-assets (ta/data-asset-filtered
                             assets-affected
                             (fn [x] (some #(= "activity-pub" %) (:tags x)))
                             threagile)
        first-asset (first activity-pub-assets)]
    (when (pos? (count activity-pub-assets))
      {:id (str "dos-unintended-proxy-threat: " (:id source) " -> " (:id target))
       :data-asset first-asset
       :link link
       :attack (get-in attacks [:attacks_used :dos-unintended-proxy-or-intermediary])})))

(defn-spec order-related-assets ::m/threat
  [source ::ta/technical-asset
   target ::ta/technical-asset
   link ::ta/link
   assets-affected ::m/data-asset-ids
   threagile ::ta/threagile
   attacks ::sat/attacks]
  (let [in-order-assets (ta/data-asset-filtered
                         assets-affected
                         (fn [x] (some #(= "in-order-activities" %) (:tags x)))
                         threagile)
        first-asset (first in-order-assets)]
    (when (pos? (count in-order-assets))
      {:id (str "out-of-order-threat: " (:id source) " -> " (:id target))
       :data-asset first-asset
       :link link
       :attack (get-in attacks [:attacks_used :activity-out-of-order-attack])})))

(defn-spec dos-requests ::m/threat
  [source ::ta/technical-asset
   target ::ta/technical-asset
   link ::ta/link
   assets-affected ::m/data-asset-ids
   threagile ::ta/threagile
   attacks ::sat/attacks]
  (let [in-order-assets (ta/data-asset-filtered
                         assets-affected
                         (fn [x] true)
                         threagile)
        first-asset (first in-order-assets)]
    (when (pos? (count in-order-assets))
      {:id (str "dos-by-rate: " (:id source) " -> " (:id target))
       :data-asset first-asset
       :link link
       :attack (get-in attacks [:attacks_used :dos-by-rate])})))