(ns dda.clj-threats.domain.rule.authentication
  (:require
   [orchestra.core :refer [defn-spec]]
   [dda.clj-threats.domain.rule.model :as m]
   [dda.clj-threats.domain.scored-attack-tree :as sat]
   [dda.clj-threats.domain.threagile :as ta]))

(defn-spec verify-incoming-data-assets ::m/threat
  [source ::ta/technical-asset
   target ::ta/technical-asset
   link ::ta/link
   assets-affected ::m/data-asset-ids
   threagile ::ta/threagile
   attacks ::sat/attacks]
  (let [processed-asset-set (set (:data_assets_processed target))
        assets-under-threat (ta/data-asset-filtered
                             assets-affected
                             (fn [x] (contains? processed-asset-set (:id x)))
                             threagile)
        first-asset (first assets-under-threat)]
    (when (not-empty assets-under-threat)
      {:id (str "verify-incoming-data: " (:id source) " -> " (:id target))
       :data-asset first-asset
       :link link
       :attack (get-in attacks [:attacks_used :malicious-activities])})))