(ns dda.clj-threats.domain.report.threats
  (:require
   [clojure.spec.alpha :as s]
   [orchestra.core :refer [defn-spec]]
   [dda.c4k-common.common :as cm]
   [dda.clj-threats.domain.threagile :as ta]
   [dda.clj-threats.domain.attack-tree :as at]
   [dda.clj-threats.domain.rules :as ru]
   [dda.clj-threats.domain.report.model :as mod]))

(defn-spec threat ::mod/document
  [threagile ::ta/threagile
   attacks ::at/attacks
   threat-entry ::ru/threat]
  (let [id (get-in threat-entry [:attack :id])
        {:keys [data-asset attack link]} threat-entry
        childs []]
    
    {:path (str "threat-" (hash id ) ".adoc")
     :dir ""
     :lines
     (cm/concat-vec
      [(str "= " id)
       ""
       (str "1. data asset affected: " (:id data-asset))
       (str "2. threat: " (:id attack) ", cwe: " (:cwe attack) ", owasp: " (:owasp-asvs attack))
       (str "3. score: " (:score attack))
       ""]
      (map mod/include-child childs))
     :childs childs}))

(defn-spec threats ::mod/document
  [threagile ::ta/threagile
   attacks ::at/attacks
   most-important-threats ::ru/threats]
  (let [childs (map #(threat threagile attacks %)  most-important-threats)]
    {:path "threats.adoc"
     :dir ""
     :lines
     (cm/concat-vec
      ["= Threats"
       ""]
      (map mod/include-child childs))
     :childs childs}))