(ns dda.clj-threats.domain.attack-tree
  (:require
   [clojure.spec.alpha :as s]
   [clojure.walk :as w]
   [orchestra.core :refer [defn-spec]]
   [dda.clj-threats.framework.sanitize :as san]
   [dda.clj-threats.domain.score :as sc]
   [dda.clj-threats.infra.attack-tree-repo :as repo]))

(s/def ::id string?)
(s/def ::title string?)
(s/def ::description string?)
(s/def ::owasp-asvs string?)
(s/def ::owasp-cheatsheet-url string?)
(s/def ::cwe string?)
(s/def ::mitigation string?)
(s/def ::stride #{"Spoofing", "Tampering", "Repudiation", "InformationDisclosure", "DOS", "ElevationOfPrivilege"})
(s/def ::composition #{:or :and})
(s/def ::or (s/map-of keyword? ::node))
(s/def ::and (s/map-of keyword? ::node))
(s/def ::childs (s/or :or (s/keys :req-un [::or])
                      :and (s/keys :req-un [::and])))
(s/def ::active_when (s/* ::mitigation))

(s/def ::node (s/keys :req-un [::id]
                      :opt-un [::title ::description ::stride ::owasp-asvs ::owasp-cheatsheet-url 
                               ::cwe ::sc/score ::childs ::active_when]))

(s/def ::mitigations_active (s/* ::mitigation))
(s/def ::attack-name keyword?)
(s/def ::attacks_used (s/map-of ::attack-name ::node))
(s/def ::attacks (s/keys :req-un [::attacks_used]
                         :opt-un [::mitigations_active]))

(defn-spec get-attacks ::attacks
  [path string?]
  (->>
   (repo/get-attack-tree path)
   (w/prewalk (fn [x] (san/add-id-values x :attacks_used)))
   (w/prewalk (fn [x] (san/add-id-values x :and)))
   (w/prewalk (fn [x] (san/add-id-values x :or)))
   ))
