(ns dda.clj-threats.domain.report.trust-boundary
  (:require
   [orchestra.core :refer [defn-spec]]
   [dda.c4k-common.common :as cm]
   [dda.clj-threats.domain.threagile :as ta]
   [dda.clj-threats.domain.threagile.technical-asset :as tas]
   [dda.clj-threats.domain.threagile.boundary :as by]
   [dda.clj-threats.domain.report.model :as mod]))


(defn-spec text-relation ::mod/lines
  [threagile ::ta/threagile]
  (let [technical-assets (vals (:technical_assets threagile))
        technical-assets-in-scope (filter (fn [x] (not (:out_of_scope x))) technical-assets)]
    (flatten
     (map (fn [technical-asset]
            (let [com-links (:communication_links technical-asset)
                  targets (set (map (fn [com-link] (:target com-link)) (vals com-links)))]
              (map (fn [target]
                     (str ". " (:id technical-asset) " -> " target))
                   targets)))
          technical-assets-in-scope))))

(defn-spec c4-relation ::mod/lines
  [threagile ::ta/threagile]
  (let [technical-assets (vals (:technical_assets threagile))
        technical-assets-in-scope (filter (fn [x] (not (:out_of_scope x))) technical-assets)]
    (flatten 
     (map (fn [technical-asset] 
            (let [com-links (:communication_links technical-asset)
                  targets (set (map (fn [com-link] (:target com-link)) (vals com-links)))]
              (map (fn [target] 
                     (str "    Rel(" (:id technical-asset) "," target ",\"" 
                          (:id technical-asset) " -> " target "\")"))
                   targets)))
          technical-assets-in-scope))))

(defn-spec c4-system ::mod/lines
  [technical-asset-id ::tas/id
   threagile ::ta/threagile]
  (let [technical-asset (ta/get-technical-asset technical-asset-id threagile)
        {:keys [id description]} technical-asset]
    (str "        System(" id ",\"" id "\",\"" description "\")")))

(defn-spec trust-boundary ::mod/lines
  [boundary ::by/trust_boundary
   threagile ::ta/threagile]
  (let [{:keys [id technical_assets_inside]} boundary]
    (cm/concat-vec
     [(str "    Boundary(" id ", \"" id "\", \"Trust Boundary\") {")]
     (map (fn [x] (c4-system x threagile)) technical_assets_inside)
     ["    }"])))

(defn-spec trust-boundaries ::mod/document
  [threagile ::ta/threagile]
  (let [{:keys [title trust_boundaries]} threagile
        childs []]
    {:path "trust-boundary.adoc"
     :dir ""
     :lines
     (cm/concat-vec
      ["= Trust Boundaries"
       ""
       "[mermaid, format=png]"
       "...."
       "C4Context"
       (str "    title Data Flow for \"" title "\"")]
      (flatten (map (fn [x] (trust-boundary x threagile)) (vals trust_boundaries)))
      (c4-relation threagile)
      ["...."
       ""
       "== Communications"
       ""]
      (text-relation threagile)
      [""]
      (map mod/include-child childs))
     :childs childs
     }))
