(ns dda.clj-threats.infra.includes
  (:require
   [clojure.string :as cs]
   [orchestra.core :refer [defn-spec]]
   [dda.c4k-common.yaml :as yaml]))


(defn-spec load-includes string?
  [includes map?]
  (cs/join
   "\n"
   (map slurp (:includes includes))))

(defn-spec expand-includes string?
  [document string?]
  (cs/join
   "\n"
   (map
    (fn [line]
      (if (cs/starts-with? (cs/trim line) "includes:")
        (load-includes (yaml/from-string line))
        line))
    (cs/split document #"\n\s*\n"))))