(ns dda.clj-threats.domain.threagile.communication-link
  (:require
   [clojure.spec.alpha :as s]
   [orchestra.core :refer [defn-spec]]
   [dda.c4k-common.predicate :as cp]))

(s/def ::name keyword?)
(s/def ::target string?)
(s/def ::description string?)
(s/def ::data_assets_sent (s/* string?))
(s/def ::data_assets_received (s/* string?))

(s/def ::communication-link
  (s/keys :req-un [::id ::description ::data_assets_received ::data_assets_sent]
          :opt-un []))

(s/def ::communication_links (s/map-of ::name ::communication-link))
