(ns dda.clj-threats.domain.threat-tree
  (:require
   [clojure.spec.alpha :as s]
   [orchestra.core :refer [defn-spec]]
   [dda.c4k-common.predicate :as cp]
   [dda.clj-threats.domain.threagile :as ta]
   [dda.clj-threats.domain.attack-tree :as attack]
   ))

(s/def ::id string?)
(s/def ::cross-trust-boundary boolean?)
(s/def ::threat (s/keys :req-un [::id]))
(s/def ::threats (s/* ::threat))

(defn-spec calculate-threat-tree ::threats
  [threagile ::ta/threagile
   attack-tree ::attack/node])