(ns dda.clj-threats.domain.scored-attack-tree
  (:require
   [clojure.spec.alpha :as s]
   [clojure.walk :as w]
   [orchestra.core :refer [defn-spec]]
   [dda.clj-threats.domain.score :as sc]
   [dda.clj-threats.domain.attack-tree :as at]))

(s/def ::childs (s/or :or (s/keys :req-un [::or ::sc/score])
                      :and (s/keys :req-un [::and ::sc/score])))
(s/def ::node (s/keys :req-un [::at/id ::sc/score]
                      :opt-un [::at/title ::at/description ::at/stride ::at/owasp-asvs 
                               ::at/owasp-cheatsheet-url ::at/cwe ::childs 
                               ::at/active_when]))
(s/def ::attacks_used (s/map-of ::at/attack-name ::node))

(s/def ::attacks (s/keys :req-un [::attacks_used]
                         :opt-un [::at/mitigations_active]))

(defn-spec calc-scores ::attacks
  [active-elems ::at/active_when
   atree ::at/attacks]
  (let [active-atree (w/postwalk (fn [x] (sc/filter-inactive-childs active-elems x)) atree)]
    (w/postwalk sc/score-for-leaf active-atree)))