(ns dda.clj-threats.domain.report.model
  (:require
   [orchestra.core :refer [defn-spec]]
   [clojure.spec.alpha :as s]))

(s/def ::path string?)
(s/def ::line string?)
(s/def ::lines (s/* ::line))
(s/def ::childs (s/* ::document))
(s/def ::document (s/keys :req-un [::path ::lines]
                          :opt-un [::childs]))

(defn-spec include-child string?
  [child ::document]
  (str "include::" (:path child) "[leveloffset=+1]"))