(ns dda.clj-threats.domain.rules
  (:require
   [clojure.spec.alpha :as s]
   [orchestra.core :refer [defn-spec]]
   [dda.c4k-common.common :as cm]
   [dda.clj-threats.domain.threagile.data-asset :as da]
   [dda.clj-threats.domain.attack-tree :as at]
   [dda.clj-threats.domain.scored-attack-tree :as sat]
   [dda.clj-threats.domain.threagile :as ta]))

(s/def id string?)
(s/def ::threat (s/keys :req-un [::id ::da/data_asset ::sat/node]))
(s/def ::threats (s/* ::threat))

(defn-spec comm-threats-for-out-of-order ::threats
  [comms ::ta/communications
   threagile ::ta/threagile
   attacks ::at/attacks]
  (cm/concat-vec
   (for [comm comms
         :let [source (:source comm)
               target (:target comm)
               link (:link comm)
               id (str (get-in link [:id]) ": " (:id source) " -> " (:id target))
               is-cross-boundary? (ta/cross-boundary?
                                   source target threagile)
               in-order-assets (ta/data-asset-filtered
                                (get-in link [:data_assets_received])
                                (fn [x] (some #(= "in-order-actions" %) (:tags x)))
                                threagile)]
         :when (and is-cross-boundary? 
                    (pos? (count in-order-assets)))]
     {:id id
      :data_asset
      (first in-order-assets)
      :node
      (get-in attacks [:attacks_used :activity-out-of-order-attack])})))

(defn-spec calculate-threats ::threats
  [threagile ::ta/threagile
   attacks ::at/attacks
   ]
  (-> (ta/communication-links threagile)
       (comm-threats-for-out-of-order threagile attacks)))