(ns dda.clj-threats.domain.report.threats
  (:require
   [orchestra.core :refer [defn-spec]]
   [dda.c4k-common.common :as cm]
   [dda.clj-threats.domain.threagile :as ta]
   [dda.clj-threats.domain.attack-tree :as at]
   [dda.clj-threats.domain.rules :as ru]
   [dda.clj-threats.domain.report.model :as mod]))


(defn-spec threat ::mod/document
  [threagile ::ta/threagile
   attacks ::at/attacks
   threat ::ru/threat]
  (let [{:keys [id data_asset node]} threat
        childs []]
    {:path (str "threat-" (hash id )".adoc")
     :dir ""
     :lines
     (cm/concat-vec
      [(str "= " id)
       ""
       (str "1. data asset affected: " (:id data_asset))
       (str "2. threat: " (:id node) ", cwe: " (:cwe node) ", owasp: " (:owasp-asvs node))
       (str "3. score: " (:score node))
       ""]
      (map mod/include-child childs))
     :childs childs}))


(defn-spec threats ::mod/document
  [threagile ::ta/threagile
   attacks ::at/attacks
   threats-with-mitigation ::ru/threats]
  (let [childs (map #(threat threagile attacks %) threats-with-mitigation)]
    {:path "threats.adoc"
     :dir ""
     :lines
     (cm/concat-vec
      ["= Threats"
       ""]
      (map mod/include-child childs))
     :childs childs}))