(ns dda.clj-threats.domain.report.management-summary
  (:require
   [orchestra.core :refer [defn-spec]]
   [dda.c4k-common.common :as cm]
   [dda.clj-threats.domain.attack-tree :as ak]
   [dda.clj-threats.domain.threagile :as ta]
   [dda.clj-threats.domain.rules :as ru]
   [dda.clj-threats.domain.report.model :as mod]))

(defn-spec threat-overview ::mod/document
  [with-or-out #{"with" "without"}
   threagile ::ta/threagile
   attacks ::ak/attacks
   threats ::ru/threats]
  {:path (str "management-summary-" with-or-out ".adoc")
   :dir ""
   :lines
   (cm/concat-vec
    (when (pos? (count threats))
      (cm/concat-vec
       [(str "= Threat Overview " with-or-out " Mitigation")
        ""
        "[mermaid, format=png]"
        "...."
        "---"
        "config:"
        "  quadrantChart:"
        "    chartWidth: 400"
        "    chartHeight: 400"
        "  theme: base"
        "---"
        "quadrantChart"
        "  x-axis Risk Low --> High"
        "  y-axis Damage Low --> High"
        "  quadrant-1 Urgent"
        "  quadrant-2 Low risk high damage"
        "  quadrant-3 Low urgency"
        "  quadrant-4 Low damage high risk"]
       (map
        (fn [x]
          (let [threat-id (get-in x [:node :id])
                attack-score (get-in x [:node :score])
                {:keys [Damage Reproducibility Exploitability AffectedUsers Discoverability]} attack-score]
            (str "  Point " threat-id
                 ": [" (* 0.0025 (+ Reproducibility Exploitability AffectedUsers Discoverability))
                 "," (* 0.01 Damage) "]")))
        threats)
       ["...."
        ""]
       (when (= with-or-out "with")
         (cm/concat-vec 
          [".Mitigations active:"]
          (map (fn [x] (str "* " x)) (get-in attacks [:mitigations_active]))
          [""])))))})

(defn-spec management-summary ::mod/document
  [threagile ::ta/threagile
   attacks ::ak/attacks
   threats-with-mitigation ::ru/threats
   threats-without-mitigation ::ru/threats]
  (let [childs (cm/concat-vec
                [(threat-overview "without" threagile attacks threats-without-mitigation)]
                [(threat-overview "with" threagile attacks threats-with-mitigation)])]
    {:path "management-summary.adoc"
     :dir ""
     :lines
     (cm/concat-vec
      (when (or (contains? threagile :management_summary_comment) (pos? (count threats-without-mitigation)))
        ["= Management Summary"
         ""])
      (when (contains? threagile :management_summary_comment)
        [(get-in threagile [:management_summary_comment])
         ""])
      (map mod/include-child childs))
     :childs childs
     }))
