# clj-threats
[![Clojars Project](https://img.shields.io/clojars/v/org.domaindrivenarchitecture/cls-threats.svg)](https://clojars.org/org.domaindrivenarchitecture/cls-threats) [![pipeline status](https://gitlab.com/domaindrivenarchitecture/cls-threats/badges/master/pipeline.svg)](https://gitlab.com/domaindrivenarchitecture/cls-threats/-/commits/main) 

[<img src="https://domaindrivenarchitecture.org/img/delta-chat.svg" width=20 alt="DeltaChat"> chat over e-mail](mailto:buero@meissa-gmbh.de?subject=community-chat) | [<img src="https://meissa.de/images/parts/contact/mastodon36_hue9b2464f10b18e134322af482b9c915e_5501_filter_14705073121015236177.png" width=20 alt="M"> meissa@social.meissa-gmbh.de](https://social.meissa-gmbh.de/@meissa) | [Blog](https://domaindrivenarchitecture.org) | [Website](https://meissa.de)

## Rational

Threagile provides a very DevOps way to do risk audits. But threagile also has room for improvement. For this reason we reimplemented & enhanced:

1. clj-threats uses the threagile model as foundation. But there where some sanitation to make live easier:
   1. Use key as id:   
    ```yaml
    data_assets:
        star-count:
            description: stars belonging to an repository & given by local and distant users
            usage: business
    ```
    will result in   
    ```yaml
    data_assets:
        star-count:
            id: "star-count"
            description: stars belonging to an repository & given by local and distant users
            usage: business
    ```
2. We support `include` and yaml 1.2
3. We think, collected  domain knowledge is the real value of a tool
4. We use attack trees in `well-known-attack-tree-lib` to collect the threat knowledge.
5. We think it is important to be able to provide a binary cli tool ready to use. For this reason our tool generates adoc & dot sources. This sources can be converted by any adoc generator set to pdf & html.

## Test the tool

```bash
clj-threats example/forgejo-example.yaml example/attacks-used.yaml

podman-compose -f report/kroki-compose.yaml up -d
./dtcw generatePDF
podman-compose -f report/kroki-compose.yaml down
```

## Development & mirrors

Development happens at: https://repo.prod.meissa.de/meissa/clj-threats

Mirrors are:

* https://codeberg.org/meissa/clj-threats (Issues and PR)
* https://gitlab.com/domaindrivenarchitecture/clj-threats (CI)

For more details about our repository model see: https://repo.prod.meissa.de/meissa/federate-your-repos

## License

Copyright © 2023-2025 meissa GmbH
Licensed under the [Apache License, Version 2.0](LICENSE) (the "License")
Pls. find licenses of our subcomponents [here](doc/SUBCOMPONENT_LICENSE)
