# convention 4 kubernetes: c4k-website

[![Clojars Project](https://img.shields.io/clojars/v/org.domaindrivenarchitecture/c4k-website.svg)](https://clojars.org/org.domaindrivenarchitecture/c4k-website) [![pipeline status](https://gitlab.com/domaindrivenarchitecture/c4k-website/badges/master/pipeline.svg)](https://gitlab.com/domaindrivenarchitecture/c4k-website/-/commits/main) 

[<img src="https://domaindrivenarchitecture.org/img/delta-chat.svg" width=20 alt="DeltaChat"> chat over e-mail](mailto:buero@meissa-gmbh.de?subject=community-chat) | [<img src="https://meissa-gmbh.de/img/community/Mastodon_Logotype.svg" width=20 alt="team@social.meissa-gmbh.de"> team@social.meissa-gmbh.de](https://social.meissa-gmbh.de/@team) | [Website & Blog](https://domaindrivenarchitecture.org)

## Purpose

Delivering cryogen generated static sites with the push of a few buttons.

c4k-website generates configuration files for multiple nginx webservers, and
corresponding cryogen static site generator build containers. This automatically downloads a `<branch>.zip` from a specified gitea API url. You need an authorization token to access the specified gitea user account. The build container is based on clojure:lein.  

Following the example in valid-config.edn and valid-auth.edn you can add as many websites as you like (provided you have the DNS Routes set up). One set of configmaps, deployment, services etc will be created for each element in the :websites and :auth list.  

Configs generated by c4k-website consists of the following parts:

* nginx deployment + configmap + service + ingress + certificate definitions
* nginx deployment has init container, building the website at startup time
* cron job for building and build secret for storing auth data
* respective volume claims

## Status

Stable - we use this setup on production.

## Try out

Click on the image to try out in your browser:

[![Try it out](doc/tryItOut.png "Try out yourself")](https://domaindrivenarchitecture.org/pages/dda-provision/c4k-website/)

Your input will stay in your browser. No server interaction is required.

You will also be able to try out on cli:
```
target/graalvm/c4k-website src/test/resources/website-test/valid-config.yaml src/test/resources/website-test/valid-auth.yaml | kubeval -
target/graalvm/c4k-website src/test/resources/website-test/valid-config.yaml src/test/resources/website-test/valid-auth.yaml | kubectl apply -f -
```


## Usage

You need:

* DNS routes matching the fqdns in the lists
* cryogen as a static site generator
* a cryogen project ready to build
* a gitea account which holds the buildable project
* an authorization token for that account
* and a kubernetes cluster provisioned by [provs]

Add a unique identifier for each website to config.edn and auth.edn (e.g. domain-name).  
Add the list of fqdns, your gitea host, name of the website repo and the respective branch name (usually "main") to config.edn.  
Add auth token and gitea user with access to the website repo to auth.edn.  
Let c4k-website generate your .yaml file.  
Apply this file on your cluster with `kubectl apply -f yourApp.yaml`.  
Done.

### Script Execution

Optionally you can specify a trusted script in your config.edn.  

1. `sha256sum` "/path/to/your/script/file"
2. copy the output of this command
3. add the :sha256-output "hash-of-file file.name" :key value pair to the respective collection in :websites.

Also, see the example in valid-config.edn. The script file needs to exist in the `<branch>.zip` and path specification to the script file should be relative to the root of the unzipped folder. Scripts can be of any type - as long as an according shebang exists in the first line.

```bash
sha256sum your-script-file #  use output of this call
sha256sum scripts/your-script-file #  or this
sha256sum scripts/foo/bar/your-script-file #  or this
```

### resource requests and limits

You may want to adjust the resource requests and limits of the build and init containers to your specific scenario.

## License

Copyright © 2022 meissa GmbH
Licensed under the [Apache License, Version 2.0](LICENSE) (the "License")
Pls. find licenses of our subcomponents [here](doc/SUBCOMPONENT_LICENSE)

[provs]: https://gitlab.com/domaindrivenarchitecture/provs/
