(ns dda.build.terragrunt.domain
  (:require [clojure.spec.alpha :as s]
            [orchestra.core :refer [defn-spec]]
            [dda.build.devops.domain :as d]))

(s/def ::devops
  (s/keys :req-un [::name ::stage ::project-root-path ::build-dir-name ::debug ::dry-run ::module]
          :opt-un []))

(defn-spec clean-build-dir-command seq?
  [devops ::devops]
  ["rm"  "-rf" (d/build-path (dissoc devops :module))])

(defn-spec copy-terragrunt-command seq?
  [devops ::devops]
  (let [{:keys [module]} devops
        devops-wo-module (dissoc devops :module)]
    [["bash" "-c" (str "cp *.hcl " (d/build-path devops-wo-module))]
     ["cp" "-r" module (d/build-path devops-wo-module)]]))

(defn-spec terragrunt-plan-command seq?
  [devops ::devops]
  [[{:dir (d/build-path devops)} "terragrunt" "init"]
   [{:dir (d/build-path devops)} "terragrunt" "plan"]])

(defn-spec terragrunt-apply-command seq?
  [devops ::devops]
  [[{:dir (d/build-path devops)} "terragrunt" "init"]
   [{:dir (d/build-path devops)} "terragrunt" "apply"]])

(defn-spec terragrunt-destroy-command seq?
  [devops ::devops]
  [[{:dir (d/build-path devops)} "terragrunt" "init"]
   [{:dir (d/build-path devops)} "terragrunt" "destroy"]])
