(ns
 com.palletops.awaze.sts
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.sts :as sts]
  [com.palletops.awaze.beans.securitytoken :as securitytoken]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :sts
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient
   credentials__1792__auto__))
 (clojure.core/defmulti
  sts
  (clojure.core/fn sts [m__1874__auto__] (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   sts
   :assume-role
   [m11114]
   (clojure.core/let
    [credentials11115 (:credentials m11114) args11116 (:args m11114)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client11117
      (com.palletops.awaze.common/aws-client :sts credentials11115)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client11117
       assumeRole
       (securitytoken/assume-role-request
        (clojure.core/nth args11116 0)))))))
  (clojure.core/defn
   assume-role-map
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         serial-number
                         custom-request-headers
                         sdk-client-execution-timeout
                         token-code
                         sdk-request-timeout
                         custom-query-parameters
                         policy
                         role-arn
                         external-id
                         read-limit
                         general-progress-listener
                         clone-source
                         role-session-name
                         clone-root]}]]),
    :doc "Generate map for assumeRole"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :assume-role,
     :credentials credentials__1842__auto__,
     :client :sts}))
  (clojure.core/defn
   assume-role
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         serial-number
                         custom-request-headers
                         sdk-client-execution-timeout
                         token-code
                         sdk-request-timeout
                         custom-query-parameters
                         policy
                         role-arn
                         external-id
                         read-limit
                         general-progress-listener
                         clone-source
                         role-session-name
                         clone-root]}]]),
    :doc "Call assumeRole"}
   [credentials11119 & args11120]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client11121
     (com.palletops.awaze.common/aws-client :sts credentials11119)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client11121
      assumeRole
      (securitytoken/assume-role-request
       (clojure.core/nth args11120 0)))))))
 (do
  (clojure.core/defmethod
   sts
   :assume-role-with-saml
   [m11122]
   (clojure.core/let
    [credentials11123 (:credentials m11122) args11124 (:args m11122)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client11125
      (com.palletops.awaze.common/aws-client :sts credentials11123)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client11125
       assumeRoleWithSAML
       (securitytoken/assume-role-with-samlrequest
        (clojure.core/nth args11124 0)))))))
  (clojure.core/defn
   assume-role-with-saml-map
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         custom-request-headers
                         sdk-client-execution-timeout
                         principal-arn
                         sdk-request-timeout
                         custom-query-parameters
                         samlassertion
                         policy
                         role-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for assumeRoleWithSAML"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :assume-role-with-saml,
     :credentials credentials__1842__auto__,
     :client :sts}))
  (clojure.core/defn
   assume-role-with-saml
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         custom-request-headers
                         sdk-client-execution-timeout
                         principal-arn
                         sdk-request-timeout
                         custom-query-parameters
                         samlassertion
                         policy
                         role-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call assumeRoleWithSAML"}
   [credentials11127 & args11128]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client11129
     (com.palletops.awaze.common/aws-client :sts credentials11127)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client11129
      assumeRoleWithSAML
      (securitytoken/assume-role-with-samlrequest
       (clojure.core/nth args11128 0)))))))
 (do
  (clojure.core/defmethod
   sts
   :assume-role-with-web-identity
   [m11130]
   (clojure.core/let
    [credentials11131 (:credentials m11130) args11132 (:args m11130)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client11133
      (com.palletops.awaze.common/aws-client :sts credentials11131)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client11133
       assumeRoleWithWebIdentity
       (securitytoken/assume-role-with-web-identity-request
        (clojure.core/nth args11132 0)))))))
  (clojure.core/defn
   assume-role-with-web-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         custom-request-headers
                         sdk-client-execution-timeout
                         provider-id
                         sdk-request-timeout
                         custom-query-parameters
                         policy
                         role-arn
                         read-limit
                         general-progress-listener
                         web-identity-token
                         clone-source
                         role-session-name
                         clone-root]}]]),
    :doc "Generate map for assumeRoleWithWebIdentity"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :assume-role-with-web-identity,
     :credentials credentials__1842__auto__,
     :client :sts}))
  (clojure.core/defn
   assume-role-with-web-identity
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         custom-request-headers
                         sdk-client-execution-timeout
                         provider-id
                         sdk-request-timeout
                         custom-query-parameters
                         policy
                         role-arn
                         read-limit
                         general-progress-listener
                         web-identity-token
                         clone-source
                         role-session-name
                         clone-root]}]]),
    :doc "Call assumeRoleWithWebIdentity"}
   [credentials11135 & args11136]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client11137
     (com.palletops.awaze.common/aws-client :sts credentials11135)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client11137
      assumeRoleWithWebIdentity
      (securitytoken/assume-role-with-web-identity-request
       (clojure.core/nth args11136 0)))))))
 (do
  (clojure.core/defmethod
   sts
   :decode-authorization-message
   [m11138]
   (clojure.core/let
    [credentials11139 (:credentials m11138) args11140 (:args m11138)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client11141
      (com.palletops.awaze.common/aws-client :sts credentials11139)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client11141
       decodeAuthorizationMessage
       (securitytoken/decode-authorization-message-request
        (clojure.core/nth args11140 0)))))))
  (clojure.core/defn
   decode-authorization-message-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         encoded-message
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for decodeAuthorizationMessage"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :decode-authorization-message,
     :credentials credentials__1842__auto__,
     :client :sts}))
  (clojure.core/defn
   decode-authorization-message
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         encoded-message
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call decodeAuthorizationMessage"}
   [credentials11143 & args11144]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client11145
     (com.palletops.awaze.common/aws-client :sts credentials11143)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client11145
      decodeAuthorizationMessage
      (securitytoken/decode-authorization-message-request
       (clojure.core/nth args11144 0)))))))
 (do
  (clojure.core/defmethod
   sts
   :get-federation-token
   [m11146]
   (clojure.core/let
    [credentials11147 (:credentials m11146) args11148 (:args m11146)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client11149
      (com.palletops.awaze.common/aws-client :sts credentials11147)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client11149
       getFederationToken
       (securitytoken/get-federation-token-request
        (clojure.core/nth args11148 0)))))))
  (clojure.core/defn
   get-federation-token-map
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         policy
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getFederationToken"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-federation-token,
     :credentials credentials__1842__auto__,
     :client :sts}))
  (clojure.core/defn
   get-federation-token
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         policy
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getFederationToken"}
   [credentials11151 & args11152]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client11153
     (com.palletops.awaze.common/aws-client :sts credentials11151)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client11153
      getFederationToken
      (securitytoken/get-federation-token-request
       (clojure.core/nth args11152 0)))))))
 (do
  (clojure.core/defmethod
   sts
   :get-session-token
   [m11154]
   (clojure.core/let
    [credentials11155 (:credentials m11154) args11156 (:args m11154)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client11157
      (com.palletops.awaze.common/aws-client :sts credentials11155)]
     (clojure.core/case
      (clojure.core/count args11156)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client11157
        getSessionToken
        (securitytoken/get-session-token-request
         (clojure.core/nth args11156 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client11157
        getSessionToken))))))
  (clojure.core/defn
   get-session-token-map
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         serial-number
                         custom-request-headers
                         sdk-client-execution-timeout
                         token-code
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for getSessionToken, getSessionToken"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-session-token,
     :credentials credentials__1842__auto__,
     :client :sts})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-session-token,
     :credentials credentials__1842__auto__,
     :client :sts}))
  (clojure.core/defn
   get-session-token
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         serial-number
                         custom-request-headers
                         sdk-client-execution-timeout
                         token-code
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call getSessionToken, getSessionToken"}
   [credentials11159 & args11160]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client11161
     (com.palletops.awaze.common/aws-client :sts credentials11159)]
    (clojure.core/case
     (clojure.core/count args11160)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client11161
       getSessionToken
       (securitytoken/get-session-token-request
        (clojure.core/nth args11160 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client11161
       getSessionToken)))))))
