(ns
 com.palletops.awaze.storagegateway
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.storagegateway :as storagegateway]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :storagegateway
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.storagegateway.AWSStorageGatewayClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.Tag}
tag
  [m7010]
  (clojure.core/let
   [bean7009 (new com.amazonaws.services.storagegateway.model.Tag)]
   (clojure.core/let
    [v7011 (:key m7010 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7011 :com.palletops.awaze.client-builder/undef)
     (. bean7009 setKey (clojure.core/str v7011))))
   (clojure.core/let
    [v7011 (:value m7010 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7011 :com.palletops.awaze.client-builder/undef)
     (. bean7009 setValue (clojure.core/str v7011))))
   bean7009))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.UpdateChapCredentialsRequest}
update-chap-credentials-request
  [m7013]
  (clojure.core/let
   [bean7012
    (new
     com.amazonaws.services.storagegateway.model.UpdateChapCredentialsRequest)]
   (clojure.core/let
    [v7014
     (:target-arn m7013 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7014 :com.palletops.awaze.client-builder/undef)
     (. bean7012 setTargetARN (clojure.core/str v7014))))
   (clojure.core/let
    [v7014
     (:secret-to-authenticate-initiator
      m7013
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7014 :com.palletops.awaze.client-builder/undef)
     (.
      bean7012
      setSecretToAuthenticateInitiator
      (clojure.core/str v7014))))
   (clojure.core/let
    [v7014
     (:initiator-name m7013 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7014 :com.palletops.awaze.client-builder/undef)
     (. bean7012 setInitiatorName (clojure.core/str v7014))))
   (clojure.core/let
    [v7014
     (:secret-to-authenticate-target
      m7013
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7014 :com.palletops.awaze.client-builder/undef)
     (.
      bean7012
      setSecretToAuthenticateTarget
      (clojure.core/str v7014))))
   bean7012))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.AddWorkingStorageRequest}
add-working-storage-request
  [m7016]
  (clojure.core/let
   [bean7015
    (new
     com.amazonaws.services.storagegateway.model.AddWorkingStorageRequest)]
   (clojure.core/let
    [v7017
     (:gateway-arn m7016 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7017 :com.palletops.awaze.client-builder/undef)
     (. bean7015 setGatewayARN (clojure.core/str v7017))))
   (clojure.core/let
    [v7017
     (:disk-ids m7016 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7017 :com.palletops.awaze.client-builder/undef)
     (.
      bean7015
      setDiskIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7177] (clojure.core/str arg7177))
 v7017))))
   bean7015))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeGatewayInformationRequest}
describe-gateway-information-request
  [m7019]
  (clojure.core/let
   [bean7018
    (new
     com.amazonaws.services.storagegateway.model.DescribeGatewayInformationRequest)]
   (clojure.core/let
    [v7020
     (:gateway-arn m7019 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7020 :com.palletops.awaze.client-builder/undef)
     (. bean7018 setGatewayARN (clojure.core/str v7020))))
   bean7018))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DeleteTapeRequest}
delete-tape-request
  [m7022]
  (clojure.core/let
   [bean7021
    (new
     com.amazonaws.services.storagegateway.model.DeleteTapeRequest)]
   (clojure.core/let
    [v7023
     (:gateway-arn m7022 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7023 :com.palletops.awaze.client-builder/undef)
     (. bean7021 setGatewayARN (clojure.core/str v7023))))
   (clojure.core/let
    [v7023
     (:tape-arn m7022 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7023 :com.palletops.awaze.client-builder/undef)
     (. bean7021 setTapeARN (clojure.core/str v7023))))
   bean7021))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeSnapshotScheduleRequest}
describe-snapshot-schedule-request
  [m7025]
  (clojure.core/let
   [bean7024
    (new
     com.amazonaws.services.storagegateway.model.DescribeSnapshotScheduleRequest)]
   (clojure.core/let
    [v7026
     (:volume-arn m7025 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7026 :com.palletops.awaze.client-builder/undef)
     (. bean7024 setVolumeARN (clojure.core/str v7026))))
   bean7024))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.CreateTapesRequest}
create-tapes-request
  [m7028]
  (clojure.core/let
   [bean7027
    (new
     com.amazonaws.services.storagegateway.model.CreateTapesRequest)]
   (clojure.core/let
    [v7029
     (:client-token m7028 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7029 :com.palletops.awaze.client-builder/undef)
     (. bean7027 setClientToken (clojure.core/str v7029))))
   (clojure.core/let
    [v7029
     (:gateway-arn m7028 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7029 :com.palletops.awaze.client-builder/undef)
     (. bean7027 setGatewayARN (clojure.core/str v7029))))
   (clojure.core/let
    [v7029
     (:tape-size-in-bytes
      m7028
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7029 :com.palletops.awaze.client-builder/undef)
     (. bean7027 setTapeSizeInBytes (clojure.core/long v7029))))
   (clojure.core/let
    [v7029
     (:num-tapes-to-create
      m7028
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7029 :com.palletops.awaze.client-builder/undef)
     (. bean7027 setNumTapesToCreate (clojure.core/int v7029))))
   (clojure.core/let
    [v7029
     (:tape-barcode-prefix
      m7028
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7029 :com.palletops.awaze.client-builder/undef)
     (. bean7027 setTapeBarcodePrefix (clojure.core/str v7029))))
   bean7027))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DeleteChapCredentialsRequest}
delete-chap-credentials-request
  [m7031]
  (clojure.core/let
   [bean7030
    (new
     com.amazonaws.services.storagegateway.model.DeleteChapCredentialsRequest)]
   (clojure.core/let
    [v7032
     (:target-arn m7031 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7032 :com.palletops.awaze.client-builder/undef)
     (. bean7030 setTargetARN (clojure.core/str v7032))))
   (clojure.core/let
    [v7032
     (:initiator-name m7031 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7032 :com.palletops.awaze.client-builder/undef)
     (. bean7030 setInitiatorName (clojure.core/str v7032))))
   bean7030))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.CancelArchivalRequest}
cancel-archival-request
  [m7034]
  (clojure.core/let
   [bean7033
    (new
     com.amazonaws.services.storagegateway.model.CancelArchivalRequest)]
   (clojure.core/let
    [v7035
     (:gateway-arn m7034 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7035 :com.palletops.awaze.client-builder/undef)
     (. bean7033 setGatewayARN (clojure.core/str v7035))))
   (clojure.core/let
    [v7035
     (:tape-arn m7034 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7035 :com.palletops.awaze.client-builder/undef)
     (. bean7033 setTapeARN (clojure.core/str v7035))))
   bean7033))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.CancelRetrievalRequest}
cancel-retrieval-request
  [m7037]
  (clojure.core/let
   [bean7036
    (new
     com.amazonaws.services.storagegateway.model.CancelRetrievalRequest)]
   (clojure.core/let
    [v7038
     (:gateway-arn m7037 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7038 :com.palletops.awaze.client-builder/undef)
     (. bean7036 setGatewayARN (clojure.core/str v7038))))
   (clojure.core/let
    [v7038
     (:tape-arn m7037 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7038 :com.palletops.awaze.client-builder/undef)
     (. bean7036 setTapeARN (clojure.core/str v7038))))
   bean7036))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DeleteVolumeRequest}
delete-volume-request
  [m7040]
  (clojure.core/let
   [bean7039
    (new
     com.amazonaws.services.storagegateway.model.DeleteVolumeRequest)]
   (clojure.core/let
    [v7041
     (:volume-arn m7040 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7041 :com.palletops.awaze.client-builder/undef)
     (. bean7039 setVolumeARN (clojure.core/str v7041))))
   bean7039))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeStorediSCSIVolumesRequest}
describe-storedi-scsivolumes-request
  [m7043]
  (clojure.core/let
   [bean7042
    (new
     com.amazonaws.services.storagegateway.model.DescribeStorediSCSIVolumesRequest)]
   (clojure.core/let
    [v7044
     (:volume-arns m7043 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7044 :com.palletops.awaze.client-builder/undef)
     (.
      bean7042
      setVolumeARNs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7178] (clojure.core/str arg7178))
 v7044))))
   bean7042))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.AddTagsToResourceRequest}
add-tags-to-resource-request
  [m7046]
  (clojure.core/let
   [bean7045
    (new
     com.amazonaws.services.storagegateway.model.AddTagsToResourceRequest)]
   (clojure.core/let
    [v7047 (:tags m7046 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7047 :com.palletops.awaze.client-builder/undef)
     (.
      bean7045
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7179] (storagegateway/tag arg7179))
 v7047))))
   (clojure.core/let
    [v7047
     (:resource-arn m7046 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7047 :com.palletops.awaze.client-builder/undef)
     (. bean7045 setResourceARN (clojure.core/str v7047))))
   bean7045))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.CreateCachediSCSIVolumeRequest}
create-cachedi-scsivolume-request
  [m7049]
  (clojure.core/let
   [bean7048
    (new
     com.amazonaws.services.storagegateway.model.CreateCachediSCSIVolumeRequest)]
   (clojure.core/let
    [v7050
     (:network-interface-id
      m7049
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7050 :com.palletops.awaze.client-builder/undef)
     (. bean7048 setNetworkInterfaceId (clojure.core/str v7050))))
   (clojure.core/let
    [v7050
     (:client-token m7049 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7050 :com.palletops.awaze.client-builder/undef)
     (. bean7048 setClientToken (clojure.core/str v7050))))
   (clojure.core/let
    [v7050
     (:snapshot-id m7049 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7050 :com.palletops.awaze.client-builder/undef)
     (. bean7048 setSnapshotId (clojure.core/str v7050))))
   (clojure.core/let
    [v7050
     (:gateway-arn m7049 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7050 :com.palletops.awaze.client-builder/undef)
     (. bean7048 setGatewayARN (clojure.core/str v7050))))
   (clojure.core/let
    [v7050
     (:volume-size-in-bytes
      m7049
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7050 :com.palletops.awaze.client-builder/undef)
     (. bean7048 setVolumeSizeInBytes (clojure.core/long v7050))))
   (clojure.core/let
    [v7050
     (:target-name m7049 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7050 :com.palletops.awaze.client-builder/undef)
     (. bean7048 setTargetName (clojure.core/str v7050))))
   bean7048))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.RetrieveTapeArchiveRequest}
retrieve-tape-archive-request
  [m7052]
  (clojure.core/let
   [bean7051
    (new
     com.amazonaws.services.storagegateway.model.RetrieveTapeArchiveRequest)]
   (clojure.core/let
    [v7053
     (:gateway-arn m7052 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7053 :com.palletops.awaze.client-builder/undef)
     (. bean7051 setGatewayARN (clojure.core/str v7053))))
   (clojure.core/let
    [v7053
     (:tape-arn m7052 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7053 :com.palletops.awaze.client-builder/undef)
     (. bean7051 setTapeARN (clojure.core/str v7053))))
   bean7051))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.AddUploadBufferRequest}
add-upload-buffer-request
  [m7055]
  (clojure.core/let
   [bean7054
    (new
     com.amazonaws.services.storagegateway.model.AddUploadBufferRequest)]
   (clojure.core/let
    [v7056
     (:gateway-arn m7055 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7056 :com.palletops.awaze.client-builder/undef)
     (. bean7054 setGatewayARN (clojure.core/str v7056))))
   (clojure.core/let
    [v7056
     (:disk-ids m7055 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7056 :com.palletops.awaze.client-builder/undef)
     (.
      bean7054
      setDiskIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7180] (clojure.core/str arg7180))
 v7056))))
   bean7054))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.ListVolumesRequest}
list-volumes-request
  [m7058]
  (clojure.core/let
   [bean7057
    (new
     com.amazonaws.services.storagegateway.model.ListVolumesRequest)]
   (clojure.core/let
    [v7059 (:limit m7058 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7059 :com.palletops.awaze.client-builder/undef)
     (. bean7057 setLimit (clojure.core/int v7059))))
   (clojure.core/let
    [v7059 (:marker m7058 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7059 :com.palletops.awaze.client-builder/undef)
     (. bean7057 setMarker (clojure.core/str v7059))))
   (clojure.core/let
    [v7059
     (:gateway-arn m7058 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7059 :com.palletops.awaze.client-builder/undef)
     (. bean7057 setGatewayARN (clojure.core/str v7059))))
   bean7057))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeTapeArchivesRequest}
describe-tape-archives-request
  [m7061]
  (clojure.core/let
   [bean7060
    (new
     com.amazonaws.services.storagegateway.model.DescribeTapeArchivesRequest)]
   (clojure.core/let
    [v7062 (:limit m7061 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7062 :com.palletops.awaze.client-builder/undef)
     (. bean7060 setLimit (clojure.core/int v7062))))
   (clojure.core/let
    [v7062 (:marker m7061 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7062 :com.palletops.awaze.client-builder/undef)
     (. bean7060 setMarker (clojure.core/str v7062))))
   (clojure.core/let
    [v7062
     (:tape-arns m7061 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7062 :com.palletops.awaze.client-builder/undef)
     (.
      bean7060
      setTapeARNs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7181] (clojure.core/str arg7181))
 v7062))))
   bean7060))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeUploadBufferRequest}
describe-upload-buffer-request
  [m7064]
  (clojure.core/let
   [bean7063
    (new
     com.amazonaws.services.storagegateway.model.DescribeUploadBufferRequest)]
   (clojure.core/let
    [v7065
     (:gateway-arn m7064 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7065 :com.palletops.awaze.client-builder/undef)
     (. bean7063 setGatewayARN (clojure.core/str v7065))))
   bean7063))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.ListLocalDisksRequest}
list-local-disks-request
  [m7067]
  (clojure.core/let
   [bean7066
    (new
     com.amazonaws.services.storagegateway.model.ListLocalDisksRequest)]
   (clojure.core/let
    [v7068
     (:gateway-arn m7067 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7068 :com.palletops.awaze.client-builder/undef)
     (. bean7066 setGatewayARN (clojure.core/str v7068))))
   bean7066))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.UpdateVTLDeviceTypeRequest}
update-vtldevice-type-request
  [m7070]
  (clojure.core/let
   [bean7069
    (new
     com.amazonaws.services.storagegateway.model.UpdateVTLDeviceTypeRequest)]
   (clojure.core/let
    [v7071
     (:vtldevice-arn m7070 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7071 :com.palletops.awaze.client-builder/undef)
     (. bean7069 setVTLDeviceARN (clojure.core/str v7071))))
   (clojure.core/let
    [v7071
     (:device-type m7070 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7071 :com.palletops.awaze.client-builder/undef)
     (. bean7069 setDeviceType (clojure.core/str v7071))))
   bean7069))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeTapeRecoveryPointsRequest}
describe-tape-recovery-points-request
  [m7073]
  (clojure.core/let
   [bean7072
    (new
     com.amazonaws.services.storagegateway.model.DescribeTapeRecoveryPointsRequest)]
   (clojure.core/let
    [v7074 (:limit m7073 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7074 :com.palletops.awaze.client-builder/undef)
     (. bean7072 setLimit (clojure.core/int v7074))))
   (clojure.core/let
    [v7074 (:marker m7073 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7074 :com.palletops.awaze.client-builder/undef)
     (. bean7072 setMarker (clojure.core/str v7074))))
   (clojure.core/let
    [v7074
     (:gateway-arn m7073 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7074 :com.palletops.awaze.client-builder/undef)
     (. bean7072 setGatewayARN (clojure.core/str v7074))))
   bean7072))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DeleteTapeArchiveRequest}
delete-tape-archive-request
  [m7076]
  (clojure.core/let
   [bean7075
    (new
     com.amazonaws.services.storagegateway.model.DeleteTapeArchiveRequest)]
   (clojure.core/let
    [v7077
     (:tape-arn m7076 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7077 :com.palletops.awaze.client-builder/undef)
     (. bean7075 setTapeARN (clojure.core/str v7077))))
   bean7075))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DeleteBandwidthRateLimitRequest}
delete-bandwidth-rate-limit-request
  [m7079]
  (clojure.core/let
   [bean7078
    (new
     com.amazonaws.services.storagegateway.model.DeleteBandwidthRateLimitRequest)]
   (clojure.core/let
    [v7080
     (:gateway-arn m7079 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7080 :com.palletops.awaze.client-builder/undef)
     (. bean7078 setGatewayARN (clojure.core/str v7080))))
   (clojure.core/let
    [v7080
     (:bandwidth-type m7079 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7080 :com.palletops.awaze.client-builder/undef)
     (. bean7078 setBandwidthType (clojure.core/str v7080))))
   bean7078))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DisableGatewayRequest}
disable-gateway-request
  [m7082]
  (clojure.core/let
   [bean7081
    (new
     com.amazonaws.services.storagegateway.model.DisableGatewayRequest)]
   (clojure.core/let
    [v7083
     (:gateway-arn m7082 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7083 :com.palletops.awaze.client-builder/undef)
     (. bean7081 setGatewayARN (clojure.core/str v7083))))
   bean7081))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DeleteGatewayRequest}
delete-gateway-request
  [m7085]
  (clojure.core/let
   [bean7084
    (new
     com.amazonaws.services.storagegateway.model.DeleteGatewayRequest)]
   (clojure.core/let
    [v7086
     (:gateway-arn m7085 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7086 :com.palletops.awaze.client-builder/undef)
     (. bean7084 setGatewayARN (clojure.core/str v7086))))
   bean7084))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.ActivateGatewayRequest}
activate-gateway-request
  [m7088]
  (clojure.core/let
   [bean7087
    (new
     com.amazonaws.services.storagegateway.model.ActivateGatewayRequest)]
   (clojure.core/let
    [v7089
     (:gateway-name m7088 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7089 :com.palletops.awaze.client-builder/undef)
     (. bean7087 setGatewayName (clojure.core/str v7089))))
   (clojure.core/let
    [v7089
     (:gateway-timezone
      m7088
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7089 :com.palletops.awaze.client-builder/undef)
     (. bean7087 setGatewayTimezone (clojure.core/str v7089))))
   (clojure.core/let
    [v7089
     (:gateway-region m7088 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7089 :com.palletops.awaze.client-builder/undef)
     (. bean7087 setGatewayRegion (clojure.core/str v7089))))
   (clojure.core/let
    [v7089
     (:gateway-type m7088 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7089 :com.palletops.awaze.client-builder/undef)
     (. bean7087 setGatewayType (clojure.core/str v7089))))
   (clojure.core/let
    [v7089
     (:tape-drive-type
      m7088
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7089 :com.palletops.awaze.client-builder/undef)
     (. bean7087 setTapeDriveType (clojure.core/str v7089))))
   (clojure.core/let
    [v7089
     (:medium-changer-type
      m7088
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7089 :com.palletops.awaze.client-builder/undef)
     (. bean7087 setMediumChangerType (clojure.core/str v7089))))
   (clojure.core/let
    [v7089
     (:activation-key m7088 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7089 :com.palletops.awaze.client-builder/undef)
     (. bean7087 setActivationKey (clojure.core/str v7089))))
   bean7087))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeMaintenanceStartTimeRequest}
describe-maintenance-start-time-request
  [m7091]
  (clojure.core/let
   [bean7090
    (new
     com.amazonaws.services.storagegateway.model.DescribeMaintenanceStartTimeRequest)]
   (clojure.core/let
    [v7092
     (:gateway-arn m7091 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7092 :com.palletops.awaze.client-builder/undef)
     (. bean7090 setGatewayARN (clojure.core/str v7092))))
   bean7090))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeBandwidthRateLimitRequest}
describe-bandwidth-rate-limit-request
  [m7094]
  (clojure.core/let
   [bean7093
    (new
     com.amazonaws.services.storagegateway.model.DescribeBandwidthRateLimitRequest)]
   (clojure.core/let
    [v7095
     (:gateway-arn m7094 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7095 :com.palletops.awaze.client-builder/undef)
     (. bean7093 setGatewayARN (clojure.core/str v7095))))
   bean7093))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeTapesRequest}
describe-tapes-request
  [m7097]
  (clojure.core/let
   [bean7096
    (new
     com.amazonaws.services.storagegateway.model.DescribeTapesRequest)]
   (clojure.core/let
    [v7098 (:limit m7097 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7098 :com.palletops.awaze.client-builder/undef)
     (. bean7096 setLimit (clojure.core/int v7098))))
   (clojure.core/let
    [v7098 (:marker m7097 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7098 :com.palletops.awaze.client-builder/undef)
     (. bean7096 setMarker (clojure.core/str v7098))))
   (clojure.core/let
    [v7098
     (:gateway-arn m7097 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7098 :com.palletops.awaze.client-builder/undef)
     (. bean7096 setGatewayARN (clojure.core/str v7098))))
   (clojure.core/let
    [v7098
     (:tape-arns m7097 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7098 :com.palletops.awaze.client-builder/undef)
     (.
      bean7096
      setTapeARNs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7182] (clojure.core/str arg7182))
 v7098))))
   bean7096))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.StartGatewayRequest}
start-gateway-request
  [m7100]
  (clojure.core/let
   [bean7099
    (new
     com.amazonaws.services.storagegateway.model.StartGatewayRequest)]
   (clojure.core/let
    [v7101
     (:gateway-arn m7100 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7101 :com.palletops.awaze.client-builder/undef)
     (. bean7099 setGatewayARN (clojure.core/str v7101))))
   bean7099))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.UpdateSnapshotScheduleRequest}
update-snapshot-schedule-request
  [m7103]
  (clojure.core/let
   [bean7102
    (new
     com.amazonaws.services.storagegateway.model.UpdateSnapshotScheduleRequest)]
   (clojure.core/let
    [v7104
     (:description m7103 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7104 :com.palletops.awaze.client-builder/undef)
     (. bean7102 setDescription (clojure.core/str v7104))))
   (clojure.core/let
    [v7104
     (:volume-arn m7103 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7104 :com.palletops.awaze.client-builder/undef)
     (. bean7102 setVolumeARN (clojure.core/str v7104))))
   (clojure.core/let
    [v7104
     (:start-at m7103 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7104 :com.palletops.awaze.client-builder/undef)
     (. bean7102 setStartAt (clojure.core/int v7104))))
   (clojure.core/let
    [v7104
     (:recurrence-in-hours
      m7103
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7104 :com.palletops.awaze.client-builder/undef)
     (. bean7102 setRecurrenceInHours (clojure.core/int v7104))))
   bean7102))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.UpdateBandwidthRateLimitRequest}
update-bandwidth-rate-limit-request
  [m7106]
  (clojure.core/let
   [bean7105
    (new
     com.amazonaws.services.storagegateway.model.UpdateBandwidthRateLimitRequest)]
   (clojure.core/let
    [v7107
     (:gateway-arn m7106 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7107 :com.palletops.awaze.client-builder/undef)
     (. bean7105 setGatewayARN (clojure.core/str v7107))))
   (clojure.core/let
    [v7107
     (:average-upload-rate-limit-in-bits-per-sec
      m7106
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7107 :com.palletops.awaze.client-builder/undef)
     (.
      bean7105
      setAverageUploadRateLimitInBitsPerSec
      (clojure.core/long v7107))))
   (clojure.core/let
    [v7107
     (:average-download-rate-limit-in-bits-per-sec
      m7106
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7107 :com.palletops.awaze.client-builder/undef)
     (.
      bean7105
      setAverageDownloadRateLimitInBitsPerSec
      (clojure.core/long v7107))))
   bean7105))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.UpdateGatewaySoftwareNowRequest}
update-gateway-software-now-request
  [m7109]
  (clojure.core/let
   [bean7108
    (new
     com.amazonaws.services.storagegateway.model.UpdateGatewaySoftwareNowRequest)]
   (clojure.core/let
    [v7110
     (:gateway-arn m7109 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7110 :com.palletops.awaze.client-builder/undef)
     (. bean7108 setGatewayARN (clojure.core/str v7110))))
   bean7108))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.CreateStorediSCSIVolumeRequest}
create-storedi-scsivolume-request
  [m7112]
  (clojure.core/let
   [bean7111
    (new
     com.amazonaws.services.storagegateway.model.CreateStorediSCSIVolumeRequest)]
   (clojure.core/let
    [v7113
     (:network-interface-id
      m7112
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7113 :com.palletops.awaze.client-builder/undef)
     (. bean7111 setNetworkInterfaceId (clojure.core/str v7113))))
   (clojure.core/let
    [v7113
     (:snapshot-id m7112 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7113 :com.palletops.awaze.client-builder/undef)
     (. bean7111 setSnapshotId (clojure.core/str v7113))))
   (clojure.core/let
    [v7113
     (:gateway-arn m7112 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7113 :com.palletops.awaze.client-builder/undef)
     (. bean7111 setGatewayARN (clojure.core/str v7113))))
   (clojure.core/let
    [v7113 (:disk-id m7112 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7113 :com.palletops.awaze.client-builder/undef)
     (. bean7111 setDiskId (clojure.core/str v7113))))
   (clojure.core/let
    [v7113
     (:preserve-existing-data
      m7112
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7113 :com.palletops.awaze.client-builder/undef)
     (. bean7111 setPreserveExistingData (clojure.core/boolean v7113))))
   (clojure.core/let
    [v7113
     (:target-name m7112 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7113 :com.palletops.awaze.client-builder/undef)
     (. bean7111 setTargetName (clojure.core/str v7113))))
   bean7111))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.UpdateGatewayInformationRequest}
update-gateway-information-request
  [m7115]
  (clojure.core/let
   [bean7114
    (new
     com.amazonaws.services.storagegateway.model.UpdateGatewayInformationRequest)]
   (clojure.core/let
    [v7116
     (:gateway-name m7115 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7116 :com.palletops.awaze.client-builder/undef)
     (. bean7114 setGatewayName (clojure.core/str v7116))))
   (clojure.core/let
    [v7116
     (:gateway-timezone
      m7115
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7116 :com.palletops.awaze.client-builder/undef)
     (. bean7114 setGatewayTimezone (clojure.core/str v7116))))
   (clojure.core/let
    [v7116
     (:gateway-arn m7115 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7116 :com.palletops.awaze.client-builder/undef)
     (. bean7114 setGatewayARN (clojure.core/str v7116))))
   bean7114))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DeleteSnapshotScheduleRequest}
delete-snapshot-schedule-request
  [m7118]
  (clojure.core/let
   [bean7117
    (new
     com.amazonaws.services.storagegateway.model.DeleteSnapshotScheduleRequest)]
   (clojure.core/let
    [v7119
     (:volume-arn m7118 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7119 :com.palletops.awaze.client-builder/undef)
     (. bean7117 setVolumeARN (clojure.core/str v7119))))
   bean7117))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeCacheRequest}
describe-cache-request
  [m7121]
  (clojure.core/let
   [bean7120
    (new
     com.amazonaws.services.storagegateway.model.DescribeCacheRequest)]
   (clojure.core/let
    [v7122
     (:gateway-arn m7121 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7122 :com.palletops.awaze.client-builder/undef)
     (. bean7120 setGatewayARN (clojure.core/str v7122))))
   bean7120))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeChapCredentialsRequest}
describe-chap-credentials-request
  [m7124]
  (clojure.core/let
   [bean7123
    (new
     com.amazonaws.services.storagegateway.model.DescribeChapCredentialsRequest)]
   (clojure.core/let
    [v7125
     (:target-arn m7124 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7125 :com.palletops.awaze.client-builder/undef)
     (. bean7123 setTargetARN (clojure.core/str v7125))))
   bean7123))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.ListVolumeRecoveryPointsRequest}
list-volume-recovery-points-request
  [m7127]
  (clojure.core/let
   [bean7126
    (new
     com.amazonaws.services.storagegateway.model.ListVolumeRecoveryPointsRequest)]
   (clojure.core/let
    [v7128
     (:gateway-arn m7127 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7128 :com.palletops.awaze.client-builder/undef)
     (. bean7126 setGatewayARN (clojure.core/str v7128))))
   bean7126))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.RemoveTagsFromResourceRequest}
remove-tags-from-resource-request
  [m7130]
  (clojure.core/let
   [bean7129
    (new
     com.amazonaws.services.storagegateway.model.RemoveTagsFromResourceRequest)]
   (clojure.core/let
    [v7131
     (:resource-arn m7130 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7131 :com.palletops.awaze.client-builder/undef)
     (. bean7129 setResourceARN (clojure.core/str v7131))))
   (clojure.core/let
    [v7131
     (:tag-keys m7130 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7131 :com.palletops.awaze.client-builder/undef)
     (.
      bean7129
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7183] (clojure.core/str arg7183))
 v7131))))
   bean7129))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.CreateTapeWithBarcodeRequest}
create-tape-with-barcode-request
  [m7133]
  (clojure.core/let
   [bean7132
    (new
     com.amazonaws.services.storagegateway.model.CreateTapeWithBarcodeRequest)]
   (clojure.core/let
    [v7134
     (:gateway-arn m7133 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7134 :com.palletops.awaze.client-builder/undef)
     (. bean7132 setGatewayARN (clojure.core/str v7134))))
   (clojure.core/let
    [v7134
     (:tape-size-in-bytes
      m7133
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7134 :com.palletops.awaze.client-builder/undef)
     (. bean7132 setTapeSizeInBytes (clojure.core/long v7134))))
   (clojure.core/let
    [v7134
     (:tape-barcode m7133 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7134 :com.palletops.awaze.client-builder/undef)
     (. bean7132 setTapeBarcode (clojure.core/str v7134))))
   bean7132))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.AddCacheRequest}
add-cache-request
  [m7136]
  (clojure.core/let
   [bean7135
    (new com.amazonaws.services.storagegateway.model.AddCacheRequest)]
   (clojure.core/let
    [v7137
     (:gateway-arn m7136 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7137 :com.palletops.awaze.client-builder/undef)
     (. bean7135 setGatewayARN (clojure.core/str v7137))))
   (clojure.core/let
    [v7137
     (:disk-ids m7136 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7137 :com.palletops.awaze.client-builder/undef)
     (.
      bean7135
      setDiskIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7184] (clojure.core/str arg7184))
 v7137))))
   bean7135))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.ListGatewaysRequest}
list-gateways-request
  [m7139]
  (clojure.core/let
   [bean7138
    (new
     com.amazonaws.services.storagegateway.model.ListGatewaysRequest)]
   (clojure.core/let
    [v7140 (:limit m7139 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7140 :com.palletops.awaze.client-builder/undef)
     (. bean7138 setLimit (clojure.core/int v7140))))
   (clojure.core/let
    [v7140 (:marker m7139 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7140 :com.palletops.awaze.client-builder/undef)
     (. bean7138 setMarker (clojure.core/str v7140))))
   bean7138))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.ListTagsForResourceRequest}
list-tags-for-resource-request
  [m7142]
  (clojure.core/let
   [bean7141
    (new
     com.amazonaws.services.storagegateway.model.ListTagsForResourceRequest)]
   (clojure.core/let
    [v7143 (:limit m7142 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7143 :com.palletops.awaze.client-builder/undef)
     (. bean7141 setLimit (clojure.core/int v7143))))
   (clojure.core/let
    [v7143 (:marker m7142 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7143 :com.palletops.awaze.client-builder/undef)
     (. bean7141 setMarker (clojure.core/str v7143))))
   (clojure.core/let
    [v7143
     (:resource-arn m7142 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7143 :com.palletops.awaze.client-builder/undef)
     (. bean7141 setResourceARN (clojure.core/str v7143))))
   bean7141))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.RetrieveTapeRecoveryPointRequest}
retrieve-tape-recovery-point-request
  [m7145]
  (clojure.core/let
   [bean7144
    (new
     com.amazonaws.services.storagegateway.model.RetrieveTapeRecoveryPointRequest)]
   (clojure.core/let
    [v7146
     (:gateway-arn m7145 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7146 :com.palletops.awaze.client-builder/undef)
     (. bean7144 setGatewayARN (clojure.core/str v7146))))
   (clojure.core/let
    [v7146
     (:tape-arn m7145 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7146 :com.palletops.awaze.client-builder/undef)
     (. bean7144 setTapeARN (clojure.core/str v7146))))
   bean7144))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.UpdateMaintenanceStartTimeRequest}
update-maintenance-start-time-request
  [m7148]
  (clojure.core/let
   [bean7147
    (new
     com.amazonaws.services.storagegateway.model.UpdateMaintenanceStartTimeRequest)]
   (clojure.core/let
    [v7149
     (:day-of-week m7148 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7149 :com.palletops.awaze.client-builder/undef)
     (. bean7147 setDayOfWeek (clojure.core/int v7149))))
   (clojure.core/let
    [v7149
     (:hour-of-day m7148 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7149 :com.palletops.awaze.client-builder/undef)
     (. bean7147 setHourOfDay (clojure.core/int v7149))))
   (clojure.core/let
    [v7149
     (:minute-of-hour m7148 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7149 :com.palletops.awaze.client-builder/undef)
     (. bean7147 setMinuteOfHour (clojure.core/int v7149))))
   (clojure.core/let
    [v7149
     (:gateway-arn m7148 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7149 :com.palletops.awaze.client-builder/undef)
     (. bean7147 setGatewayARN (clojure.core/str v7149))))
   bean7147))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.ResetCacheRequest}
reset-cache-request
  [m7151]
  (clojure.core/let
   [bean7150
    (new
     com.amazonaws.services.storagegateway.model.ResetCacheRequest)]
   (clojure.core/let
    [v7152
     (:gateway-arn m7151 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7152 :com.palletops.awaze.client-builder/undef)
     (. bean7150 setGatewayARN (clojure.core/str v7152))))
   bean7150))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeVTLDevicesRequest}
describe-vtldevices-request
  [m7154]
  (clojure.core/let
   [bean7153
    (new
     com.amazonaws.services.storagegateway.model.DescribeVTLDevicesRequest)]
   (clojure.core/let
    [v7155 (:limit m7154 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7155 :com.palletops.awaze.client-builder/undef)
     (. bean7153 setLimit (clojure.core/int v7155))))
   (clojure.core/let
    [v7155 (:marker m7154 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7155 :com.palletops.awaze.client-builder/undef)
     (. bean7153 setMarker (clojure.core/str v7155))))
   (clojure.core/let
    [v7155
     (:gateway-arn m7154 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7155 :com.palletops.awaze.client-builder/undef)
     (. bean7153 setGatewayARN (clojure.core/str v7155))))
   (clojure.core/let
    [v7155
     (:vtldevice-arns m7154 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7155 :com.palletops.awaze.client-builder/undef)
     (.
      bean7153
      setVTLDeviceARNs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7233] (clojure.core/str arg7233))
 v7155))))
   bean7153))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeCachediSCSIVolumesRequest}
describe-cachedi-scsivolumes-request
  [m7157]
  (clojure.core/let
   [bean7156
    (new
     com.amazonaws.services.storagegateway.model.DescribeCachediSCSIVolumesRequest)]
   (clojure.core/let
    [v7158
     (:volume-arns m7157 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7158 :com.palletops.awaze.client-builder/undef)
     (.
      bean7156
      setVolumeARNs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7234] (clojure.core/str arg7234))
 v7158))))
   bean7156))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.SetLocalConsolePasswordRequest}
set-local-console-password-request
  [m7160]
  (clojure.core/let
   [bean7159
    (new
     com.amazonaws.services.storagegateway.model.SetLocalConsolePasswordRequest)]
   (clojure.core/let
    [v7161
     (:local-console-password
      m7160
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7161 :com.palletops.awaze.client-builder/undef)
     (. bean7159 setLocalConsolePassword (clojure.core/str v7161))))
   (clojure.core/let
    [v7161
     (:gateway-arn m7160 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7161 :com.palletops.awaze.client-builder/undef)
     (. bean7159 setGatewayARN (clojure.core/str v7161))))
   bean7159))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.CreateSnapshotFromVolumeRecoveryPointRequest}
create-snapshot-from-volume-recovery-point-request
  [m7163]
  (clojure.core/let
   [bean7162
    (new
     com.amazonaws.services.storagegateway.model.CreateSnapshotFromVolumeRecoveryPointRequest)]
   (clojure.core/let
    [v7164
     (:volume-arn m7163 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7164 :com.palletops.awaze.client-builder/undef)
     (. bean7162 setVolumeARN (clojure.core/str v7164))))
   (clojure.core/let
    [v7164
     (:snapshot-description
      m7163
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7164 :com.palletops.awaze.client-builder/undef)
     (. bean7162 setSnapshotDescription (clojure.core/str v7164))))
   bean7162))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.CreateSnapshotRequest}
create-snapshot-request
  [m7166]
  (clojure.core/let
   [bean7165
    (new
     com.amazonaws.services.storagegateway.model.CreateSnapshotRequest)]
   (clojure.core/let
    [v7167
     (:volume-arn m7166 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7167 :com.palletops.awaze.client-builder/undef)
     (. bean7165 setVolumeARN (clojure.core/str v7167))))
   (clojure.core/let
    [v7167
     (:snapshot-description
      m7166
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7167 :com.palletops.awaze.client-builder/undef)
     (. bean7165 setSnapshotDescription (clojure.core/str v7167))))
   bean7165))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeWorkingStorageRequest}
describe-working-storage-request
  [m7169]
  (clojure.core/let
   [bean7168
    (new
     com.amazonaws.services.storagegateway.model.DescribeWorkingStorageRequest)]
   (clojure.core/let
    [v7170
     (:gateway-arn m7169 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7170 :com.palletops.awaze.client-builder/undef)
     (. bean7168 setGatewayARN (clojure.core/str v7170))))
   bean7168))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.ListVolumeInitiatorsRequest}
list-volume-initiators-request
  [m7172]
  (clojure.core/let
   [bean7171
    (new
     com.amazonaws.services.storagegateway.model.ListVolumeInitiatorsRequest)]
   (clojure.core/let
    [v7173
     (:volume-arn m7172 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7173 :com.palletops.awaze.client-builder/undef)
     (. bean7171 setVolumeARN (clojure.core/str v7173))))
   bean7171))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.ShutdownGatewayRequest}
shutdown-gateway-request
  [m7175]
  (clojure.core/let
   [bean7174
    (new
     com.amazonaws.services.storagegateway.model.ShutdownGatewayRequest)]
   (clojure.core/let
    [v7176
     (:gateway-arn m7175 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7176 :com.palletops.awaze.client-builder/undef)
     (. bean7174 setGatewayARN (clojure.core/str v7176))))
   bean7174))
 (clojure.core/defmulti
  storagegateway
  (clojure.core/fn
   storagegateway
   [m__1874__auto__]
   (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   storagegateway
   :update-chap-credentials
   [m7185]
   (clojure.core/let
    [credentials7186 (:credentials m7185) args7187 (:args m7185)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7188
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7186)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7188
       updateChapCredentials
       (storagegateway/update-chap-credentials-request
        (clojure.core/nth args7187 0)))))))
  (clojure.core/defn
   update-chap-credentials-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         secret-to-authenticate-target
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         initiator-name
                         clone-source
                         clone-root
                         target-arn
                         secret-to-authenticate-initiator]}]]),
    :doc "Generate map for updateChapCredentials"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-chap-credentials,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   update-chap-credentials
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         secret-to-authenticate-target
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         initiator-name
                         clone-source
                         clone-root
                         target-arn
                         secret-to-authenticate-initiator]}]]),
    :doc "Call updateChapCredentials"}
   [credentials7190 & args7191]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7192
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7190)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7192
      updateChapCredentials
      (storagegateway/update-chap-credentials-request
       (clojure.core/nth args7191 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :add-working-storage
   [m7193]
   (clojure.core/let
    [credentials7194 (:credentials m7193) args7195 (:args m7193)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7196
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7194)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7196
       addWorkingStorage
       (storagegateway/add-working-storage-request
        (clojure.core/nth args7195 0)))))))
  (clojure.core/defn
   add-working-storage-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         disk-ids
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for addWorkingStorage"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :add-working-storage,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   add-working-storage
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         disk-ids
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call addWorkingStorage"}
   [credentials7198 & args7199]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7200
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7198)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7200
      addWorkingStorage
      (storagegateway/add-working-storage-request
       (clojure.core/nth args7199 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-gateway-information
   [m7201]
   (clojure.core/let
    [credentials7202 (:credentials m7201) args7203 (:args m7201)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7204
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7202)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7204
       describeGatewayInformation
       (storagegateway/describe-gateway-information-request
        (clojure.core/nth args7203 0)))))))
  (clojure.core/defn
   describe-gateway-information-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for describeGatewayInformation"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-gateway-information,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   describe-gateway-information
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call describeGatewayInformation"}
   [credentials7206 & args7207]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7208
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7206)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7208
      describeGatewayInformation
      (storagegateway/describe-gateway-information-request
       (clojure.core/nth args7207 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :delete-tape
   [m7209]
   (clojure.core/let
    [credentials7210 (:credentials m7209) args7211 (:args m7209)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7212
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7210)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7212
       deleteTape
       (storagegateway/delete-tape-request
        (clojure.core/nth args7211 0)))))))
  (clojure.core/defn
   delete-tape-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         tape-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for deleteTape"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-tape,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   delete-tape
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         tape-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call deleteTape"}
   [credentials7214 & args7215]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7216
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7214)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7216
      deleteTape
      (storagegateway/delete-tape-request
       (clojure.core/nth args7215 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-snapshot-schedule
   [m7217]
   (clojure.core/let
    [credentials7218 (:credentials m7217) args7219 (:args m7217)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7220
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7218)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7220
       describeSnapshotSchedule
       (storagegateway/describe-snapshot-schedule-request
        (clojure.core/nth args7219 0)))))))
  (clojure.core/defn
   describe-snapshot-schedule-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         volume-arn
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeSnapshotSchedule"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-snapshot-schedule,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   describe-snapshot-schedule
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         volume-arn
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeSnapshotSchedule"}
   [credentials7222 & args7223]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7224
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7222)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7224
      describeSnapshotSchedule
      (storagegateway/describe-snapshot-schedule-request
       (clojure.core/nth args7223 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :create-tapes
   [m7225]
   (clojure.core/let
    [credentials7226 (:credentials m7225) args7227 (:args m7225)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7228
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7226)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7228
       createTapes
       (storagegateway/create-tapes-request
        (clojure.core/nth args7227 0)))))))
  (clojure.core/defn
   create-tapes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         num-tapes-to-create
                         tape-barcode-prefix
                         general-progress-listener
                         clone-source
                         tape-size-in-bytes
                         gateway-arn
                         client-token
                         clone-root]}]]),
    :doc "Generate map for createTapes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-tapes,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   create-tapes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         num-tapes-to-create
                         tape-barcode-prefix
                         general-progress-listener
                         clone-source
                         tape-size-in-bytes
                         gateway-arn
                         client-token
                         clone-root]}]]),
    :doc "Call createTapes"}
   [credentials7230 & args7231]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7232
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7230)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7232
      createTapes
      (storagegateway/create-tapes-request
       (clojure.core/nth args7231 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :delete-chap-credentials
   [m7235]
   (clojure.core/let
    [credentials7236 (:credentials m7235) args7237 (:args m7235)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7238
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7236)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7238
       deleteChapCredentials
       (storagegateway/delete-chap-credentials-request
        (clojure.core/nth args7237 0)))))))
  (clojure.core/defn
   delete-chap-credentials-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         initiator-name
                         clone-source
                         clone-root
                         target-arn]}]]),
    :doc "Generate map for deleteChapCredentials"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-chap-credentials,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   delete-chap-credentials
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         initiator-name
                         clone-source
                         clone-root
                         target-arn]}]]),
    :doc "Call deleteChapCredentials"}
   [credentials7240 & args7241]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7242
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7240)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7242
      deleteChapCredentials
      (storagegateway/delete-chap-credentials-request
       (clojure.core/nth args7241 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :cancel-archival
   [m7243]
   (clojure.core/let
    [credentials7244 (:credentials m7243) args7245 (:args m7243)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7246
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7244)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7246
       cancelArchival
       (storagegateway/cancel-archival-request
        (clojure.core/nth args7245 0)))))))
  (clojure.core/defn
   cancel-archival-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         tape-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for cancelArchival"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :cancel-archival,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   cancel-archival
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         tape-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call cancelArchival"}
   [credentials7248 & args7249]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7250
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7248)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7250
      cancelArchival
      (storagegateway/cancel-archival-request
       (clojure.core/nth args7249 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :cancel-retrieval
   [m7251]
   (clojure.core/let
    [credentials7252 (:credentials m7251) args7253 (:args m7251)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7254
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7252)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7254
       cancelRetrieval
       (storagegateway/cancel-retrieval-request
        (clojure.core/nth args7253 0)))))))
  (clojure.core/defn
   cancel-retrieval-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         tape-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for cancelRetrieval"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :cancel-retrieval,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   cancel-retrieval
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         tape-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call cancelRetrieval"}
   [credentials7256 & args7257]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7258
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7256)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7258
      cancelRetrieval
      (storagegateway/cancel-retrieval-request
       (clojure.core/nth args7257 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :delete-volume
   [m7259]
   (clojure.core/let
    [credentials7260 (:credentials m7259) args7261 (:args m7259)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7262
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7260)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7262
       deleteVolume
       (storagegateway/delete-volume-request
        (clojure.core/nth args7261 0)))))))
  (clojure.core/defn
   delete-volume-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         volume-arn
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteVolume"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-volume,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   delete-volume
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         volume-arn
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteVolume"}
   [credentials7264 & args7265]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7266
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7264)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7266
      deleteVolume
      (storagegateway/delete-volume-request
       (clojure.core/nth args7265 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-storedi-scsivolumes
   [m7267]
   (clojure.core/let
    [credentials7268 (:credentials m7267) args7269 (:args m7267)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7270
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7268)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7270
       describeStorediSCSIVolumes
       (storagegateway/describe-storedi-scsivolumes-request
        (clojure.core/nth args7269 0)))))))
  (clojure.core/defn
   describe-storedi-scsivolumes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-arns
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeStorediSCSIVolumes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-storedi-scsivolumes,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   describe-storedi-scsivolumes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-arns
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeStorediSCSIVolumes"}
   [credentials7272 & args7273]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7274
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7272)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7274
      describeStorediSCSIVolumes
      (storagegateway/describe-storedi-scsivolumes-request
       (clojure.core/nth args7273 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :add-tags-to-resource
   [m7275]
   (clojure.core/let
    [credentials7276 (:credentials m7275) args7277 (:args m7275)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7278
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7276)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7278
       addTagsToResource
       (storagegateway/add-tags-to-resource-request
        (clojure.core/nth args7277 0)))))))
  (clojure.core/defn
   add-tags-to-resource-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         resource-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for addTagsToResource"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :add-tags-to-resource,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   add-tags-to-resource
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         resource-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call addTagsToResource"}
   [credentials7280 & args7281]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7282
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7280)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7282
      addTagsToResource
      (storagegateway/add-tags-to-resource-request
       (clojure.core/nth args7281 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :create-cachedi-scsivolume
   [m7283]
   (clojure.core/let
    [credentials7284 (:credentials m7283) args7285 (:args m7283)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7286
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7284)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7286
       createCachediSCSIVolume
       (storagegateway/create-cachedi-scsivolume-request
        (clojure.core/nth args7285 0)))))))
  (clojure.core/defn
   create-cachedi-scsivolume-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         volume-size-in-bytes
                         clone-source
                         gateway-arn
                         client-token
                         clone-root
                         target-name]}]]),
    :doc "Generate map for createCachediSCSIVolume"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-cachedi-scsivolume,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   create-cachedi-scsivolume
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         volume-size-in-bytes
                         clone-source
                         gateway-arn
                         client-token
                         clone-root
                         target-name]}]]),
    :doc "Call createCachediSCSIVolume"}
   [credentials7288 & args7289]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7290
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7288)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7290
      createCachediSCSIVolume
      (storagegateway/create-cachedi-scsivolume-request
       (clojure.core/nth args7289 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :retrieve-tape-archive
   [m7291]
   (clojure.core/let
    [credentials7292 (:credentials m7291) args7293 (:args m7291)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7294
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7292)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7294
       retrieveTapeArchive
       (storagegateway/retrieve-tape-archive-request
        (clojure.core/nth args7293 0)))))))
  (clojure.core/defn
   retrieve-tape-archive-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         tape-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for retrieveTapeArchive"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :retrieve-tape-archive,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   retrieve-tape-archive
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         tape-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call retrieveTapeArchive"}
   [credentials7296 & args7297]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7298
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7296)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7298
      retrieveTapeArchive
      (storagegateway/retrieve-tape-archive-request
       (clojure.core/nth args7297 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :add-upload-buffer
   [m7299]
   (clojure.core/let
    [credentials7300 (:credentials m7299) args7301 (:args m7299)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7302
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7300)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7302
       addUploadBuffer
       (storagegateway/add-upload-buffer-request
        (clojure.core/nth args7301 0)))))))
  (clojure.core/defn
   add-upload-buffer-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         disk-ids
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for addUploadBuffer"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :add-upload-buffer,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   add-upload-buffer
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         disk-ids
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call addUploadBuffer"}
   [credentials7304 & args7305]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7306
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7304)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7306
      addUploadBuffer
      (storagegateway/add-upload-buffer-request
       (clojure.core/nth args7305 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :list-volumes
   [m7307]
   (clojure.core/let
    [credentials7308 (:credentials m7307) args7309 (:args m7307)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7310
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7308)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7310
       listVolumes
       (storagegateway/list-volumes-request
        (clojure.core/nth args7309 0)))))))
  (clojure.core/defn
   list-volumes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for listVolumes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-volumes,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   list-volumes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call listVolumes"}
   [credentials7312 & args7313]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7314
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7312)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7314
      listVolumes
      (storagegateway/list-volumes-request
       (clojure.core/nth args7313 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-tape-archives
   [m7315]
   (clojure.core/let
    [credentials7316 (:credentials m7315) args7317 (:args m7315)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7318
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7316)]
     (clojure.core/case
      (clojure.core/count args7317)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7318
        describeTapeArchives
        (storagegateway/describe-tape-archives-request
         (clojure.core/nth args7317 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7318
        describeTapeArchives))))))
  (clojure.core/defn
   describe-tape-archives-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         tape-arns
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeTapeArchives, describeTapeArchives"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-tape-archives,
     :credentials credentials__1842__auto__,
     :client :storagegateway})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-tape-archives,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   describe-tape-archives
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         tape-arns
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeTapeArchives, describeTapeArchives"}
   [credentials7320 & args7321]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7322
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7320)]
    (clojure.core/case
     (clojure.core/count args7321)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7322
       describeTapeArchives
       (storagegateway/describe-tape-archives-request
        (clojure.core/nth args7321 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7322
       describeTapeArchives))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-upload-buffer
   [m7323]
   (clojure.core/let
    [credentials7324 (:credentials m7323) args7325 (:args m7323)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7326
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7324)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7326
       describeUploadBuffer
       (storagegateway/describe-upload-buffer-request
        (clojure.core/nth args7325 0)))))))
  (clojure.core/defn
   describe-upload-buffer-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for describeUploadBuffer"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-upload-buffer,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   describe-upload-buffer
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call describeUploadBuffer"}
   [credentials7328 & args7329]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7330
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7328)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7330
      describeUploadBuffer
      (storagegateway/describe-upload-buffer-request
       (clojure.core/nth args7329 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :list-local-disks
   [m7331]
   (clojure.core/let
    [credentials7332 (:credentials m7331) args7333 (:args m7331)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7334
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7332)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7334
       listLocalDisks
       (storagegateway/list-local-disks-request
        (clojure.core/nth args7333 0)))))))
  (clojure.core/defn
   list-local-disks-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for listLocalDisks"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-local-disks,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   list-local-disks
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call listLocalDisks"}
   [credentials7336 & args7337]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7338
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7336)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7338
      listLocalDisks
      (storagegateway/list-local-disks-request
       (clojure.core/nth args7337 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :update-vtldevice-type
   [m7339]
   (clojure.core/let
    [credentials7340 (:credentials m7339) args7341 (:args m7339)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7342
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7340)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7342
       updateVTLDeviceType
       (storagegateway/update-vtldevice-type-request
        (clojure.core/nth args7341 0)))))))
  (clojure.core/defn
   update-vtldevice-type-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vtldevice-arn
                         custom-query-parameters
                         device-type
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateVTLDeviceType"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-vtldevice-type,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   update-vtldevice-type
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vtldevice-arn
                         custom-query-parameters
                         device-type
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateVTLDeviceType"}
   [credentials7344 & args7345]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7346
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7344)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7346
      updateVTLDeviceType
      (storagegateway/update-vtldevice-type-request
       (clojure.core/nth args7345 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-tape-recovery-points
   [m7347]
   (clojure.core/let
    [credentials7348 (:credentials m7347) args7349 (:args m7347)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7350
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7348)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7350
       describeTapeRecoveryPoints
       (storagegateway/describe-tape-recovery-points-request
        (clojure.core/nth args7349 0)))))))
  (clojure.core/defn
   describe-tape-recovery-points-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for describeTapeRecoveryPoints"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-tape-recovery-points,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   describe-tape-recovery-points
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call describeTapeRecoveryPoints"}
   [credentials7352 & args7353]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7354
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7352)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7354
      describeTapeRecoveryPoints
      (storagegateway/describe-tape-recovery-points-request
       (clojure.core/nth args7353 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :delete-tape-archive
   [m7355]
   (clojure.core/let
    [credentials7356 (:credentials m7355) args7357 (:args m7355)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7358
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7356)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7358
       deleteTapeArchive
       (storagegateway/delete-tape-archive-request
        (clojure.core/nth args7357 0)))))))
  (clojure.core/defn
   delete-tape-archive-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         tape-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteTapeArchive"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-tape-archive,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   delete-tape-archive
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         tape-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteTapeArchive"}
   [credentials7360 & args7361]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7362
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7360)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7362
      deleteTapeArchive
      (storagegateway/delete-tape-archive-request
       (clojure.core/nth args7361 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :delete-bandwidth-rate-limit
   [m7363]
   (clojure.core/let
    [credentials7364 (:credentials m7363) args7365 (:args m7363)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7366
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7364)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7366
       deleteBandwidthRateLimit
       (storagegateway/delete-bandwidth-rate-limit-request
        (clojure.core/nth args7365 0)))))))
  (clojure.core/defn
   delete-bandwidth-rate-limit-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         bandwidth-type
                         clone-root]}]]),
    :doc "Generate map for deleteBandwidthRateLimit"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-bandwidth-rate-limit,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   delete-bandwidth-rate-limit
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         bandwidth-type
                         clone-root]}]]),
    :doc "Call deleteBandwidthRateLimit"}
   [credentials7368 & args7369]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7370
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7368)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7370
      deleteBandwidthRateLimit
      (storagegateway/delete-bandwidth-rate-limit-request
       (clojure.core/nth args7369 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :disable-gateway
   [m7371]
   (clojure.core/let
    [credentials7372 (:credentials m7371) args7373 (:args m7371)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7374
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7372)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7374
       disableGateway
       (storagegateway/disable-gateway-request
        (clojure.core/nth args7373 0)))))))
  (clojure.core/defn
   disable-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for disableGateway"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :disable-gateway,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   disable-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call disableGateway"}
   [credentials7376 & args7377]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7378
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7376)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7378
      disableGateway
      (storagegateway/disable-gateway-request
       (clojure.core/nth args7377 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :delete-gateway
   [m7379]
   (clojure.core/let
    [credentials7380 (:credentials m7379) args7381 (:args m7379)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7382
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7380)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7382
       deleteGateway
       (storagegateway/delete-gateway-request
        (clojure.core/nth args7381 0)))))))
  (clojure.core/defn
   delete-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for deleteGateway"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-gateway,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   delete-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call deleteGateway"}
   [credentials7384 & args7385]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7386
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7384)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7386
      deleteGateway
      (storagegateway/delete-gateway-request
       (clojure.core/nth args7385 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :activate-gateway
   [m7387]
   (clojure.core/let
    [credentials7388 (:credentials m7387) args7389 (:args m7387)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7390
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7388)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7390
       activateGateway
       (storagegateway/activate-gateway-request
        (clojure.core/nth args7389 0)))))))
  (clojure.core/defn
   activate-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         tape-drive-type
                         gateway-name
                         sdk-request-timeout
                         gateway-type
                         custom-query-parameters
                         activation-key
                         medium-changer-type
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-region
                         gateway-timezone
                         clone-root]}]]),
    :doc "Generate map for activateGateway"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :activate-gateway,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   activate-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         tape-drive-type
                         gateway-name
                         sdk-request-timeout
                         gateway-type
                         custom-query-parameters
                         activation-key
                         medium-changer-type
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-region
                         gateway-timezone
                         clone-root]}]]),
    :doc "Call activateGateway"}
   [credentials7392 & args7393]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7394
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7392)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7394
      activateGateway
      (storagegateway/activate-gateway-request
       (clojure.core/nth args7393 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-maintenance-start-time
   [m7395]
   (clojure.core/let
    [credentials7396 (:credentials m7395) args7397 (:args m7395)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7398
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7396)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7398
       describeMaintenanceStartTime
       (storagegateway/describe-maintenance-start-time-request
        (clojure.core/nth args7397 0)))))))
  (clojure.core/defn
   describe-maintenance-start-time-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for describeMaintenanceStartTime"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-maintenance-start-time,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   describe-maintenance-start-time
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call describeMaintenanceStartTime"}
   [credentials7400 & args7401]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7402
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7400)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7402
      describeMaintenanceStartTime
      (storagegateway/describe-maintenance-start-time-request
       (clojure.core/nth args7401 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-bandwidth-rate-limit
   [m7403]
   (clojure.core/let
    [credentials7404 (:credentials m7403) args7405 (:args m7403)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7406
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7404)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7406
       describeBandwidthRateLimit
       (storagegateway/describe-bandwidth-rate-limit-request
        (clojure.core/nth args7405 0)))))))
  (clojure.core/defn
   describe-bandwidth-rate-limit-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for describeBandwidthRateLimit"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-bandwidth-rate-limit,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   describe-bandwidth-rate-limit
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call describeBandwidthRateLimit"}
   [credentials7408 & args7409]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7410
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7408)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7410
      describeBandwidthRateLimit
      (storagegateway/describe-bandwidth-rate-limit-request
       (clojure.core/nth args7409 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-tapes
   [m7411]
   (clojure.core/let
    [credentials7412 (:credentials m7411) args7413 (:args m7411)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7414
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7412)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7414
       describeTapes
       (storagegateway/describe-tapes-request
        (clojure.core/nth args7413 0)))))))
  (clojure.core/defn
   describe-tapes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         tape-arns
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for describeTapes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-tapes,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   describe-tapes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         tape-arns
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call describeTapes"}
   [credentials7416 & args7417]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7418
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7416)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7418
      describeTapes
      (storagegateway/describe-tapes-request
       (clojure.core/nth args7417 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :start-gateway
   [m7419]
   (clojure.core/let
    [credentials7420 (:credentials m7419) args7421 (:args m7419)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7422
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7420)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7422
       startGateway
       (storagegateway/start-gateway-request
        (clojure.core/nth args7421 0)))))))
  (clojure.core/defn
   start-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for startGateway"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :start-gateway,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   start-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call startGateway"}
   [credentials7424 & args7425]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7426
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7424)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7426
      startGateway
      (storagegateway/start-gateway-request
       (clojure.core/nth args7425 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :update-snapshot-schedule
   [m7427]
   (clojure.core/let
    [credentials7428 (:credentials m7427) args7429 (:args m7427)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7430
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7428)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7430
       updateSnapshotSchedule
       (storagegateway/update-snapshot-schedule-request
        (clojure.core/nth args7429 0)))))))
  (clojure.core/defn
   update-snapshot-schedule-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         start-at
                         volume-arn
                         custom-query-parameters
                         recurrence-in-hours
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateSnapshotSchedule"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-snapshot-schedule,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   update-snapshot-schedule
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         start-at
                         volume-arn
                         custom-query-parameters
                         recurrence-in-hours
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateSnapshotSchedule"}
   [credentials7432 & args7433]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7434
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7432)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7434
      updateSnapshotSchedule
      (storagegateway/update-snapshot-schedule-request
       (clojure.core/nth args7433 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :update-bandwidth-rate-limit
   [m7435]
   (clojure.core/let
    [credentials7436 (:credentials m7435) args7437 (:args m7435)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7438
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7436)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7438
       updateBandwidthRateLimit
       (storagegateway/update-bandwidth-rate-limit-request
        (clojure.core/nth args7437 0)))))))
  (clojure.core/defn
   update-bandwidth-rate-limit-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         average-download-rate-limit-in-bits-per-sec
                         sdk-request-timeout
                         custom-query-parameters
                         average-upload-rate-limit-in-bits-per-sec
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for updateBandwidthRateLimit"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-bandwidth-rate-limit,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   update-bandwidth-rate-limit
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         average-download-rate-limit-in-bits-per-sec
                         sdk-request-timeout
                         custom-query-parameters
                         average-upload-rate-limit-in-bits-per-sec
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call updateBandwidthRateLimit"}
   [credentials7440 & args7441]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7442
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7440)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7442
      updateBandwidthRateLimit
      (storagegateway/update-bandwidth-rate-limit-request
       (clojure.core/nth args7441 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :update-gateway-software-now
   [m7443]
   (clojure.core/let
    [credentials7444 (:credentials m7443) args7445 (:args m7443)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7446
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7444)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7446
       updateGatewaySoftwareNow
       (storagegateway/update-gateway-software-now-request
        (clojure.core/nth args7445 0)))))))
  (clojure.core/defn
   update-gateway-software-now-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for updateGatewaySoftwareNow"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-gateway-software-now,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   update-gateway-software-now
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call updateGatewaySoftwareNow"}
   [credentials7448 & args7449]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7450
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7448)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7450
      updateGatewaySoftwareNow
      (storagegateway/update-gateway-software-now-request
       (clojure.core/nth args7449 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :create-storedi-scsivolume
   [m7451]
   (clojure.core/let
    [credentials7452 (:credentials m7451) args7453 (:args m7451)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7454
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7452)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7454
       createStorediSCSIVolume
       (storagegateway/create-storedi-scsivolume-request
        (clojure.core/nth args7453 0)))))))
  (clojure.core/defn
   create-storedi-scsivolume-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         preserve-existing-data
                         general-progress-listener
                         disk-id
                         clone-source
                         gateway-arn
                         clone-root
                         target-name]}]]),
    :doc "Generate map for createStorediSCSIVolume"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-storedi-scsivolume,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   create-storedi-scsivolume
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         preserve-existing-data
                         general-progress-listener
                         disk-id
                         clone-source
                         gateway-arn
                         clone-root
                         target-name]}]]),
    :doc "Call createStorediSCSIVolume"}
   [credentials7456 & args7457]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7458
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7456)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7458
      createStorediSCSIVolume
      (storagegateway/create-storedi-scsivolume-request
       (clojure.core/nth args7457 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :update-gateway-information
   [m7459]
   (clojure.core/let
    [credentials7460 (:credentials m7459) args7461 (:args m7459)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7462
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7460)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7462
       updateGatewayInformation
       (storagegateway/update-gateway-information-request
        (clojure.core/nth args7461 0)))))))
  (clojure.core/defn
   update-gateway-information-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         gateway-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         gateway-timezone
                         clone-root]}]]),
    :doc "Generate map for updateGatewayInformation"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-gateway-information,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   update-gateway-information
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         gateway-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         gateway-timezone
                         clone-root]}]]),
    :doc "Call updateGatewayInformation"}
   [credentials7464 & args7465]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7466
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7464)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7466
      updateGatewayInformation
      (storagegateway/update-gateway-information-request
       (clojure.core/nth args7465 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :delete-snapshot-schedule
   [m7467]
   (clojure.core/let
    [credentials7468 (:credentials m7467) args7469 (:args m7467)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7470
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7468)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7470
       deleteSnapshotSchedule
       (storagegateway/delete-snapshot-schedule-request
        (clojure.core/nth args7469 0)))))))
  (clojure.core/defn
   delete-snapshot-schedule-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         volume-arn
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteSnapshotSchedule"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-snapshot-schedule,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   delete-snapshot-schedule
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         volume-arn
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteSnapshotSchedule"}
   [credentials7472 & args7473]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7474
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7472)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7474
      deleteSnapshotSchedule
      (storagegateway/delete-snapshot-schedule-request
       (clojure.core/nth args7473 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-cache
   [m7475]
   (clojure.core/let
    [credentials7476 (:credentials m7475) args7477 (:args m7475)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7478
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7476)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7478
       describeCache
       (storagegateway/describe-cache-request
        (clojure.core/nth args7477 0)))))))
  (clojure.core/defn
   describe-cache-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for describeCache"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-cache,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   describe-cache
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call describeCache"}
   [credentials7480 & args7481]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7482
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7480)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7482
      describeCache
      (storagegateway/describe-cache-request
       (clojure.core/nth args7481 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-chap-credentials
   [m7483]
   (clojure.core/let
    [credentials7484 (:credentials m7483) args7485 (:args m7483)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7486
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7484)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7486
       describeChapCredentials
       (storagegateway/describe-chap-credentials-request
        (clojure.core/nth args7485 0)))))))
  (clojure.core/defn
   describe-chap-credentials-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         target-arn]}]]),
    :doc "Generate map for describeChapCredentials"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-chap-credentials,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   describe-chap-credentials
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         target-arn]}]]),
    :doc "Call describeChapCredentials"}
   [credentials7488 & args7489]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7490
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7488)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7490
      describeChapCredentials
      (storagegateway/describe-chap-credentials-request
       (clojure.core/nth args7489 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :list-volume-recovery-points
   [m7491]
   (clojure.core/let
    [credentials7492 (:credentials m7491) args7493 (:args m7491)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7494
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7492)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7494
       listVolumeRecoveryPoints
       (storagegateway/list-volume-recovery-points-request
        (clojure.core/nth args7493 0)))))))
  (clojure.core/defn
   list-volume-recovery-points-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for listVolumeRecoveryPoints"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-volume-recovery-points,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   list-volume-recovery-points
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call listVolumeRecoveryPoints"}
   [credentials7496 & args7497]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7498
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7496)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7498
      listVolumeRecoveryPoints
      (storagegateway/list-volume-recovery-points-request
       (clojure.core/nth args7497 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :remove-tags-from-resource
   [m7499]
   (clojure.core/let
    [credentials7500 (:credentials m7499) args7501 (:args m7499)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7502
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7500)]
     (clojure.core/case
      (clojure.core/count args7501)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7502
        removeTagsFromResource
        (storagegateway/remove-tags-from-resource-request
         (clojure.core/nth args7501 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7502
        removeTagsFromResource))))))
  (clojure.core/defn
   remove-tags-from-resource-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         tag-keys
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         resource-arn
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for removeTagsFromResource, removeTagsFromResource"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :remove-tags-from-resource,
     :credentials credentials__1842__auto__,
     :client :storagegateway})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :remove-tags-from-resource,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   remove-tags-from-resource
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         tag-keys
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         resource-arn
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call removeTagsFromResource, removeTagsFromResource"}
   [credentials7504 & args7505]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7506
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7504)]
    (clojure.core/case
     (clojure.core/count args7505)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7506
       removeTagsFromResource
       (storagegateway/remove-tags-from-resource-request
        (clojure.core/nth args7505 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7506
       removeTagsFromResource))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :create-tape-with-barcode
   [m7507]
   (clojure.core/let
    [credentials7508 (:credentials m7507) args7509 (:args m7507)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7510
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7508)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7510
       createTapeWithBarcode
       (storagegateway/create-tape-with-barcode-request
        (clojure.core/nth args7509 0)))))))
  (clojure.core/defn
   create-tape-with-barcode-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         tape-barcode
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         tape-size-in-bytes
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for createTapeWithBarcode"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-tape-with-barcode,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   create-tape-with-barcode
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         tape-barcode
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         tape-size-in-bytes
                         gateway-arn
                         clone-root]}]]),
    :doc "Call createTapeWithBarcode"}
   [credentials7512 & args7513]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7514
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7512)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7514
      createTapeWithBarcode
      (storagegateway/create-tape-with-barcode-request
       (clojure.core/nth args7513 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :add-cache
   [m7515]
   (clojure.core/let
    [credentials7516 (:credentials m7515) args7517 (:args m7515)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7518
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7516)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7518
       addCache
       (storagegateway/add-cache-request
        (clojure.core/nth args7517 0)))))))
  (clojure.core/defn
   add-cache-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         disk-ids
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for addCache"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :add-cache,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   add-cache
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         disk-ids
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call addCache"}
   [credentials7520 & args7521]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7522
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7520)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7522
      addCache
      (storagegateway/add-cache-request (clojure.core/nth args7521 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :list-gateways
   [m7523]
   (clojure.core/let
    [credentials7524 (:credentials m7523) args7525 (:args m7523)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7526
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7524)]
     (clojure.core/case
      (clojure.core/count args7525)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7526
        listGateways))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7526
        listGateways
        (storagegateway/list-gateways-request
         (clojure.core/nth args7525 0))))))))
  (clojure.core/defn
   list-gateways-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listGateways, listGateways"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-gateways,
     :credentials credentials__1842__auto__,
     :client :storagegateway})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-gateways,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   list-gateways
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listGateways, listGateways"}
   [credentials7528 & args7529]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7530
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7528)]
    (clojure.core/case
     (clojure.core/count args7529)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7530
       listGateways))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7530
       listGateways
       (storagegateway/list-gateways-request
        (clojure.core/nth args7529 0))))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :list-tags-for-resource
   [m7531]
   (clojure.core/let
    [credentials7532 (:credentials m7531) args7533 (:args m7531)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7534
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7532)]
     (clojure.core/case
      (clojure.core/count args7533)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7534
        listTagsForResource
        (storagegateway/list-tags-for-resource-request
         (clojure.core/nth args7533 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7534
        listTagsForResource))))))
  (clojure.core/defn
   list-tags-for-resource-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         resource-arn
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listTagsForResource, listTagsForResource"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-tags-for-resource,
     :credentials credentials__1842__auto__,
     :client :storagegateway})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-tags-for-resource,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   list-tags-for-resource
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         resource-arn
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listTagsForResource, listTagsForResource"}
   [credentials7536 & args7537]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7538
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7536)]
    (clojure.core/case
     (clojure.core/count args7537)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7538
       listTagsForResource
       (storagegateway/list-tags-for-resource-request
        (clojure.core/nth args7537 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7538
       listTagsForResource))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :retrieve-tape-recovery-point
   [m7539]
   (clojure.core/let
    [credentials7540 (:credentials m7539) args7541 (:args m7539)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7542
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7540)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7542
       retrieveTapeRecoveryPoint
       (storagegateway/retrieve-tape-recovery-point-request
        (clojure.core/nth args7541 0)))))))
  (clojure.core/defn
   retrieve-tape-recovery-point-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         tape-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for retrieveTapeRecoveryPoint"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :retrieve-tape-recovery-point,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   retrieve-tape-recovery-point
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         tape-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call retrieveTapeRecoveryPoint"}
   [credentials7544 & args7545]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7546
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7544)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7546
      retrieveTapeRecoveryPoint
      (storagegateway/retrieve-tape-recovery-point-request
       (clojure.core/nth args7545 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :update-maintenance-start-time
   [m7547]
   (clojure.core/let
    [credentials7548 (:credentials m7547) args7549 (:args m7547)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7550
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7548)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7550
       updateMaintenanceStartTime
       (storagegateway/update-maintenance-start-time-request
        (clojure.core/nth args7549 0)))))))
  (clojure.core/defn
   update-maintenance-start-time-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         day-of-week
                         hour-of-day
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root
                         minute-of-hour]}]]),
    :doc "Generate map for updateMaintenanceStartTime"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-maintenance-start-time,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   update-maintenance-start-time
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         day-of-week
                         hour-of-day
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root
                         minute-of-hour]}]]),
    :doc "Call updateMaintenanceStartTime"}
   [credentials7552 & args7553]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7554
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7552)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7554
      updateMaintenanceStartTime
      (storagegateway/update-maintenance-start-time-request
       (clojure.core/nth args7553 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :reset-cache
   [m7555]
   (clojure.core/let
    [credentials7556 (:credentials m7555) args7557 (:args m7555)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7558
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7556)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7558
       resetCache
       (storagegateway/reset-cache-request
        (clojure.core/nth args7557 0)))))))
  (clojure.core/defn
   reset-cache-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for resetCache"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :reset-cache,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   reset-cache
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call resetCache"}
   [credentials7560 & args7561]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7562
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7560)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7562
      resetCache
      (storagegateway/reset-cache-request
       (clojure.core/nth args7561 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-vtldevices
   [m7563]
   (clojure.core/let
    [credentials7564 (:credentials m7563) args7565 (:args m7563)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7566
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7564)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7566
       describeVTLDevices
       (storagegateway/describe-vtldevices-request
        (clojure.core/nth args7565 0)))))))
  (clojure.core/defn
   describe-vtldevices-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         vtldevice-arns
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for describeVTLDevices"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-vtldevices,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   describe-vtldevices
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         vtldevice-arns
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call describeVTLDevices"}
   [credentials7568 & args7569]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7570
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7568)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7570
      describeVTLDevices
      (storagegateway/describe-vtldevices-request
       (clojure.core/nth args7569 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-cachedi-scsivolumes
   [m7571]
   (clojure.core/let
    [credentials7572 (:credentials m7571) args7573 (:args m7571)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7574
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7572)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7574
       describeCachediSCSIVolumes
       (storagegateway/describe-cachedi-scsivolumes-request
        (clojure.core/nth args7573 0)))))))
  (clojure.core/defn
   describe-cachedi-scsivolumes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-arns
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeCachediSCSIVolumes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-cachedi-scsivolumes,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   describe-cachedi-scsivolumes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-arns
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeCachediSCSIVolumes"}
   [credentials7576 & args7577]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7578
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7576)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7578
      describeCachediSCSIVolumes
      (storagegateway/describe-cachedi-scsivolumes-request
       (clojure.core/nth args7577 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :set-local-console-password
   [m7579]
   (clojure.core/let
    [credentials7580 (:credentials m7579) args7581 (:args m7579)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7582
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7580)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7582
       setLocalConsolePassword
       (storagegateway/set-local-console-password-request
        (clojure.core/nth args7581 0)))))))
  (clojure.core/defn
   set-local-console-password-map
   {:arglists (quote
               [[credentials
                 {:keys [local-console-password
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for setLocalConsolePassword"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-local-console-password,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   set-local-console-password
   {:arglists (quote
               [[credentials
                 {:keys [local-console-password
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call setLocalConsolePassword"}
   [credentials7584 & args7585]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7586
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7584)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7586
      setLocalConsolePassword
      (storagegateway/set-local-console-password-request
       (clojure.core/nth args7585 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :create-snapshot-from-volume-recovery-point
   [m7587]
   (clojure.core/let
    [credentials7588 (:credentials m7587) args7589 (:args m7587)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7590
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7588)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7590
       createSnapshotFromVolumeRecoveryPoint
       (storagegateway/create-snapshot-from-volume-recovery-point-request
        (clojure.core/nth args7589 0)))))))
  (clojure.core/defn
   create-snapshot-from-volume-recovery-point-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         snapshot-description
                         volume-arn
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createSnapshotFromVolumeRecoveryPoint"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-snapshot-from-volume-recovery-point,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   create-snapshot-from-volume-recovery-point
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         snapshot-description
                         volume-arn
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createSnapshotFromVolumeRecoveryPoint"}
   [credentials7592 & args7593]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7594
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7592)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7594
      createSnapshotFromVolumeRecoveryPoint
      (storagegateway/create-snapshot-from-volume-recovery-point-request
       (clojure.core/nth args7593 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :create-snapshot
   [m7595]
   (clojure.core/let
    [credentials7596 (:credentials m7595) args7597 (:args m7595)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7598
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7596)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7598
       createSnapshot
       (storagegateway/create-snapshot-request
        (clojure.core/nth args7597 0)))))))
  (clojure.core/defn
   create-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         snapshot-description
                         volume-arn
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createSnapshot"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-snapshot,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   create-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         snapshot-description
                         volume-arn
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createSnapshot"}
   [credentials7600 & args7601]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7602
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7600)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7602
      createSnapshot
      (storagegateway/create-snapshot-request
       (clojure.core/nth args7601 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-working-storage
   [m7603]
   (clojure.core/let
    [credentials7604 (:credentials m7603) args7605 (:args m7603)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7606
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7604)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7606
       describeWorkingStorage
       (storagegateway/describe-working-storage-request
        (clojure.core/nth args7605 0)))))))
  (clojure.core/defn
   describe-working-storage-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for describeWorkingStorage"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-working-storage,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   describe-working-storage
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call describeWorkingStorage"}
   [credentials7608 & args7609]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7610
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7608)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7610
      describeWorkingStorage
      (storagegateway/describe-working-storage-request
       (clojure.core/nth args7609 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :list-volume-initiators
   [m7611]
   (clojure.core/let
    [credentials7612 (:credentials m7611) args7613 (:args m7611)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7614
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7612)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7614
       listVolumeInitiators
       (storagegateway/list-volume-initiators-request
        (clojure.core/nth args7613 0)))))))
  (clojure.core/defn
   list-volume-initiators-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         volume-arn
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listVolumeInitiators"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-volume-initiators,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   list-volume-initiators
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         volume-arn
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listVolumeInitiators"}
   [credentials7616 & args7617]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7618
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7616)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7618
      listVolumeInitiators
      (storagegateway/list-volume-initiators-request
       (clojure.core/nth args7617 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :shutdown-gateway
   [m7619]
   (clojure.core/let
    [credentials7620 (:credentials m7619) args7621 (:args m7619)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client7622
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials7620)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7622
       shutdownGateway
       (storagegateway/shutdown-gateway-request
        (clojure.core/nth args7621 0)))))))
  (clojure.core/defn
   shutdown-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Generate map for shutdownGateway"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :shutdown-gateway,
     :credentials credentials__1842__auto__,
     :client :storagegateway}))
  (clojure.core/defn
   shutdown-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-arn
                         clone-root]}]]),
    :doc "Call shutdownGateway"}
   [credentials7624 & args7625]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client7626
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials7624)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client7626
      shutdownGateway
      (storagegateway/shutdown-gateway-request
       (clojure.core/nth args7625 0))))))))
