(ns
 com.palletops.awaze.sqs
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.sqs :as sqs]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :sqs
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.sqs.AmazonSQSClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.MessageAttributeValue}
message-attribute-value
  [m8501]
  (clojure.core/let
   [bean8500
    (new com.amazonaws.services.sqs.model.MessageAttributeValue)]
   (clojure.core/let
    [v8502
     (:data-type m8501 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8502 :com.palletops.awaze.client-builder/undef)
     (. bean8500 setDataType (clojure.core/str v8502))))
   (clojure.core/let
    [v8502
     (:string-value m8501 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8502 :com.palletops.awaze.client-builder/undef)
     (. bean8500 setStringValue (clojure.core/str v8502))))
   (clojure.core/let
    [v8502
     (:binary-value m8501 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8502 :com.palletops.awaze.client-builder/undef)
     (. bean8500 setBinaryValue (clojure.core/identity v8502))))
   (clojure.core/let
    [v8502
     (:string-list-values
      m8501
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8502 :com.palletops.awaze.client-builder/undef)
     (.
      bean8500
      setStringListValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8563] (clojure.core/str arg8563))
 v8502))))
   (clojure.core/let
    [v8502
     (:binary-list-values
      m8501
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8502 :com.palletops.awaze.client-builder/undef)
     (.
      bean8500
      setBinaryListValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8564] (clojure.core/identity arg8564))
 v8502))))
   bean8500))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry}
change-message-visibility-batch-request-entry
  [m8504]
  (clojure.core/let
   [bean8503
    (new
     com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry)]
   (clojure.core/let
    [v8505 (:id m8504 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8505 :com.palletops.awaze.client-builder/undef)
     (. bean8503 setId (clojure.core/str v8505))))
   (clojure.core/let
    [v8505
     (:receipt-handle m8504 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8505 :com.palletops.awaze.client-builder/undef)
     (. bean8503 setReceiptHandle (clojure.core/str v8505))))
   (clojure.core/let
    [v8505
     (:visibility-timeout
      m8504
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8505 :com.palletops.awaze.client-builder/undef)
     (. bean8503 setVisibilityTimeout (clojure.core/int v8505))))
   bean8503))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.DeleteMessageBatchRequestEntry}
delete-message-batch-request-entry
  [m8507]
  (clojure.core/let
   [bean8506
    (new
     com.amazonaws.services.sqs.model.DeleteMessageBatchRequestEntry)]
   (clojure.core/let
    [v8508 (:id m8507 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8508 :com.palletops.awaze.client-builder/undef)
     (. bean8506 setId (clojure.core/str v8508))))
   (clojure.core/let
    [v8508
     (:receipt-handle m8507 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8508 :com.palletops.awaze.client-builder/undef)
     (. bean8506 setReceiptHandle (clojure.core/str v8508))))
   bean8506))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.SendMessageBatchRequestEntry}
send-message-batch-request-entry
  [m8510]
  (clojure.core/let
   [bean8509
    (new
     com.amazonaws.services.sqs.model.SendMessageBatchRequestEntry)]
   (clojure.core/let
    [v8511
     (:message-attributes
      m8510
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8511 :com.palletops.awaze.client-builder/undef)
     (.
      bean8509
      setMessageAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg8565] (clojure.core/str arg8565))
  (clojure.core/keys v8511))
 (clojure.core/map
  (clojure.core/fn [arg8565] (sqs/message-attribute-value arg8565))
  (clojure.core/vals v8511))))))
   (clojure.core/let
    [v8511 (:id m8510 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8511 :com.palletops.awaze.client-builder/undef)
     (. bean8509 setId (clojure.core/str v8511))))
   (clojure.core/let
    [v8511
     (:message-body m8510 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8511 :com.palletops.awaze.client-builder/undef)
     (. bean8509 setMessageBody (clojure.core/str v8511))))
   (clojure.core/let
    [v8511
     (:delay-seconds m8510 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8511 :com.palletops.awaze.client-builder/undef)
     (. bean8509 setDelaySeconds (clojure.core/int v8511))))
   bean8509))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.GetQueueUrlRequest}
get-queue-url-request
  [m8513]
  (clojure.core/let
   [bean8512
    (new com.amazonaws.services.sqs.model.GetQueueUrlRequest)]
   (clojure.core/let
    [v8514
     (:queue-name m8513 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8514 :com.palletops.awaze.client-builder/undef)
     (. bean8512 setQueueName (clojure.core/str v8514))))
   (clojure.core/let
    [v8514
     (:queue-owner-awsaccount-id
      m8513
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8514 :com.palletops.awaze.client-builder/undef)
     (. bean8512 setQueueOwnerAWSAccountId (clojure.core/str v8514))))
   bean8512))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.CreateQueueRequest}
create-queue-request
  [m8516]
  (clojure.core/let
   [bean8515
    (new com.amazonaws.services.sqs.model.CreateQueueRequest)]
   (clojure.core/let
    [v8517
     (:attributes m8516 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8517 :com.palletops.awaze.client-builder/undef)
     (.
      bean8515
      setAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg8566] (clojure.core/str arg8566))
  (clojure.core/keys v8517))
 (clojure.core/map
  (clojure.core/fn [arg8566] (clojure.core/str arg8566))
  (clojure.core/vals v8517))))))
   (clojure.core/let
    [v8517
     (:queue-name m8516 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8517 :com.palletops.awaze.client-builder/undef)
     (. bean8515 setQueueName (clojure.core/str v8517))))
   bean8515))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.ListDeadLetterSourceQueuesRequest}
list-dead-letter-source-queues-request
  [m8519]
  (clojure.core/let
   [bean8518
    (new
     com.amazonaws.services.sqs.model.ListDeadLetterSourceQueuesRequest)]
   (clojure.core/let
    [v8520
     (:queue-url m8519 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8520 :com.palletops.awaze.client-builder/undef)
     (. bean8518 setQueueUrl (clojure.core/str v8520))))
   bean8518))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.RemovePermissionRequest}
remove-permission-request
  [m8522]
  (clojure.core/let
   [bean8521
    (new com.amazonaws.services.sqs.model.RemovePermissionRequest)]
   (clojure.core/let
    [v8523 (:label m8522 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8523 :com.palletops.awaze.client-builder/undef)
     (. bean8521 setLabel (clojure.core/str v8523))))
   (clojure.core/let
    [v8523
     (:queue-url m8522 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8523 :com.palletops.awaze.client-builder/undef)
     (. bean8521 setQueueUrl (clojure.core/str v8523))))
   bean8521))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.SetQueueAttributesRequest}
set-queue-attributes-request
  [m8525]
  (clojure.core/let
   [bean8524
    (new com.amazonaws.services.sqs.model.SetQueueAttributesRequest)]
   (clojure.core/let
    [v8526
     (:attributes m8525 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8526 :com.palletops.awaze.client-builder/undef)
     (.
      bean8524
      setAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg8567] (clojure.core/str arg8567))
  (clojure.core/keys v8526))
 (clojure.core/map
  (clojure.core/fn [arg8567] (clojure.core/str arg8567))
  (clojure.core/vals v8526))))))
   (clojure.core/let
    [v8526
     (:queue-url m8525 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8526 :com.palletops.awaze.client-builder/undef)
     (. bean8524 setQueueUrl (clojure.core/str v8526))))
   bean8524))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.ReceiveMessageRequest}
receive-message-request
  [m8528]
  (clojure.core/let
   [bean8527
    (new com.amazonaws.services.sqs.model.ReceiveMessageRequest)]
   (clojure.core/let
    [v8529
     (:attribute-names
      m8528
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8529 :com.palletops.awaze.client-builder/undef)
     (.
      bean8527
      setAttributeNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8568] (clojure.core/str arg8568))
 v8529))))
   (clojure.core/let
    [v8529
     (:queue-url m8528 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8529 :com.palletops.awaze.client-builder/undef)
     (. bean8527 setQueueUrl (clojure.core/str v8529))))
   (clojure.core/let
    [v8529
     (:visibility-timeout
      m8528
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8529 :com.palletops.awaze.client-builder/undef)
     (. bean8527 setVisibilityTimeout (clojure.core/int v8529))))
   (clojure.core/let
    [v8529
     (:message-attribute-names
      m8528
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8529 :com.palletops.awaze.client-builder/undef)
     (.
      bean8527
      setMessageAttributeNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8569] (clojure.core/str arg8569))
 v8529))))
   (clojure.core/let
    [v8529
     (:max-number-of-messages
      m8528
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8529 :com.palletops.awaze.client-builder/undef)
     (. bean8527 setMaxNumberOfMessages (clojure.core/int v8529))))
   (clojure.core/let
    [v8529
     (:wait-time-seconds
      m8528
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8529 :com.palletops.awaze.client-builder/undef)
     (. bean8527 setWaitTimeSeconds (clojure.core/int v8529))))
   bean8527))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.DeleteMessageRequest}
delete-message-request
  [m8531]
  (clojure.core/let
   [bean8530
    (new com.amazonaws.services.sqs.model.DeleteMessageRequest)]
   (clojure.core/let
    [v8532
     (:queue-url m8531 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8532 :com.palletops.awaze.client-builder/undef)
     (. bean8530 setQueueUrl (clojure.core/str v8532))))
   (clojure.core/let
    [v8532
     (:receipt-handle m8531 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8532 :com.palletops.awaze.client-builder/undef)
     (. bean8530 setReceiptHandle (clojure.core/str v8532))))
   bean8530))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.SendMessageRequest}
send-message-request
  [m8534]
  (clojure.core/let
   [bean8533
    (new com.amazonaws.services.sqs.model.SendMessageRequest)]
   (clojure.core/let
    [v8535
     (:message-attributes
      m8534
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8535 :com.palletops.awaze.client-builder/undef)
     (.
      bean8533
      setMessageAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg8570] (clojure.core/str arg8570))
  (clojure.core/keys v8535))
 (clojure.core/map
  (clojure.core/fn [arg8570] (sqs/message-attribute-value arg8570))
  (clojure.core/vals v8535))))))
   (clojure.core/let
    [v8535
     (:queue-url m8534 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8535 :com.palletops.awaze.client-builder/undef)
     (. bean8533 setQueueUrl (clojure.core/str v8535))))
   (clojure.core/let
    [v8535
     (:message-body m8534 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8535 :com.palletops.awaze.client-builder/undef)
     (. bean8533 setMessageBody (clojure.core/str v8535))))
   (clojure.core/let
    [v8535
     (:delay-seconds m8534 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8535 :com.palletops.awaze.client-builder/undef)
     (. bean8533 setDelaySeconds (clojure.core/int v8535))))
   bean8533))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequest}
change-message-visibility-batch-request
  [m8537]
  (clojure.core/let
   [bean8536
    (new
     com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequest)]
   (clojure.core/let
    [v8538
     (:queue-url m8537 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8538 :com.palletops.awaze.client-builder/undef)
     (. bean8536 setQueueUrl (clojure.core/str v8538))))
   (clojure.core/let
    [v8538 (:entries m8537 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8538 :com.palletops.awaze.client-builder/undef)
     (.
      bean8536
      setEntries
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg8571]
  (sqs/change-message-visibility-batch-request-entry arg8571))
 v8538))))
   bean8536))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.ChangeMessageVisibilityRequest}
change-message-visibility-request
  [m8540]
  (clojure.core/let
   [bean8539
    (new
     com.amazonaws.services.sqs.model.ChangeMessageVisibilityRequest)]
   (clojure.core/let
    [v8541
     (:queue-url m8540 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8541 :com.palletops.awaze.client-builder/undef)
     (. bean8539 setQueueUrl (clojure.core/str v8541))))
   (clojure.core/let
    [v8541
     (:receipt-handle m8540 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8541 :com.palletops.awaze.client-builder/undef)
     (. bean8539 setReceiptHandle (clojure.core/str v8541))))
   (clojure.core/let
    [v8541
     (:visibility-timeout
      m8540
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8541 :com.palletops.awaze.client-builder/undef)
     (. bean8539 setVisibilityTimeout (clojure.core/int v8541))))
   bean8539))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.ListQueuesRequest}
list-queues-request
  [m8543]
  (clojure.core/let
   [bean8542 (new com.amazonaws.services.sqs.model.ListQueuesRequest)]
   (clojure.core/let
    [v8544
     (:queue-name-prefix
      m8543
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8544 :com.palletops.awaze.client-builder/undef)
     (. bean8542 setQueueNamePrefix (clojure.core/str v8544))))
   bean8542))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.DeleteMessageBatchRequest}
delete-message-batch-request
  [m8546]
  (clojure.core/let
   [bean8545
    (new com.amazonaws.services.sqs.model.DeleteMessageBatchRequest)]
   (clojure.core/let
    [v8547
     (:queue-url m8546 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8547 :com.palletops.awaze.client-builder/undef)
     (. bean8545 setQueueUrl (clojure.core/str v8547))))
   (clojure.core/let
    [v8547 (:entries m8546 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8547 :com.palletops.awaze.client-builder/undef)
     (.
      bean8545
      setEntries
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg8644]
  (sqs/delete-message-batch-request-entry arg8644))
 v8547))))
   bean8545))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.DeleteQueueRequest}
delete-queue-request
  [m8549]
  (clojure.core/let
   [bean8548
    (new com.amazonaws.services.sqs.model.DeleteQueueRequest)]
   (clojure.core/let
    [v8550
     (:queue-url m8549 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8550 :com.palletops.awaze.client-builder/undef)
     (. bean8548 setQueueUrl (clojure.core/str v8550))))
   bean8548))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.AddPermissionRequest}
add-permission-request
  [m8552]
  (clojure.core/let
   [bean8551
    (new com.amazonaws.services.sqs.model.AddPermissionRequest)]
   (clojure.core/let
    [v8553 (:actions m8552 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8553 :com.palletops.awaze.client-builder/undef)
     (.
      bean8551
      setActions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8645] (clojure.core/str arg8645))
 v8553))))
   (clojure.core/let
    [v8553 (:label m8552 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8553 :com.palletops.awaze.client-builder/undef)
     (. bean8551 setLabel (clojure.core/str v8553))))
   (clojure.core/let
    [v8553
     (:awsaccount-ids m8552 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8553 :com.palletops.awaze.client-builder/undef)
     (.
      bean8551
      setAWSAccountIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8646] (clojure.core/str arg8646))
 v8553))))
   (clojure.core/let
    [v8553
     (:queue-url m8552 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8553 :com.palletops.awaze.client-builder/undef)
     (. bean8551 setQueueUrl (clojure.core/str v8553))))
   bean8551))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.PurgeQueueRequest}
purge-queue-request
  [m8555]
  (clojure.core/let
   [bean8554 (new com.amazonaws.services.sqs.model.PurgeQueueRequest)]
   (clojure.core/let
    [v8556
     (:queue-url m8555 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8556 :com.palletops.awaze.client-builder/undef)
     (. bean8554 setQueueUrl (clojure.core/str v8556))))
   bean8554))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.GetQueueAttributesRequest}
get-queue-attributes-request
  [m8558]
  (clojure.core/let
   [bean8557
    (new com.amazonaws.services.sqs.model.GetQueueAttributesRequest)]
   (clojure.core/let
    [v8559
     (:attribute-names
      m8558
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8559 :com.palletops.awaze.client-builder/undef)
     (.
      bean8557
      setAttributeNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8647] (clojure.core/str arg8647))
 v8559))))
   (clojure.core/let
    [v8559
     (:queue-url m8558 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8559 :com.palletops.awaze.client-builder/undef)
     (. bean8557 setQueueUrl (clojure.core/str v8559))))
   bean8557))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.SendMessageBatchRequest}
send-message-batch-request
  [m8561]
  (clojure.core/let
   [bean8560
    (new com.amazonaws.services.sqs.model.SendMessageBatchRequest)]
   (clojure.core/let
    [v8562
     (:queue-url m8561 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8562 :com.palletops.awaze.client-builder/undef)
     (. bean8560 setQueueUrl (clojure.core/str v8562))))
   (clojure.core/let
    [v8562 (:entries m8561 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8562 :com.palletops.awaze.client-builder/undef)
     (.
      bean8560
      setEntries
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg8648]
  (sqs/send-message-batch-request-entry arg8648))
 v8562))))
   bean8560))
 (clojure.core/defmulti
  sqs
  (clojure.core/fn sqs [m__1874__auto__] (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   sqs
   :get-queue-url
   [m8572]
   (clojure.core/let
    [credentials8573 (:credentials m8572) args8574 (:args m8572)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8575
      (com.palletops.awaze.common/aws-client :sqs credentials8573)]
     (clojure.core/case
      (clojure.core/count args8574)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.sqs.model.GetQueueUrlRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.sqs.model.GetQueueUrlRequest
           (clojure.core/nth args8574 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8575
           getQueueUrl
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args8574 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8575
               getQueueUrl
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getQueueUrl")
                {:args args8574}))))))))))))))
  (clojure.core/defn
   get-queue-url-map
   {:arglists (quote
               [[credentials
                 {:keys [queue-owner-awsaccount-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         queue-name
                         clone-root]}]
                [credentials string-0]]),
    :doc "Generate map for getQueueUrl, getQueueUrl"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-queue-url,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   get-queue-url
   {:arglists (quote
               [[credentials
                 {:keys [queue-owner-awsaccount-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         queue-name
                         clone-root]}]
                [credentials string-0]]),
    :doc "Call getQueueUrl, getQueueUrl"}
   [credentials8577 & args8578]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8579
     (com.palletops.awaze.common/aws-client :sqs credentials8577)]
    (clojure.core/case
     (clojure.core/count args8578)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.sqs.model.GetQueueUrlRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.sqs.model.GetQueueUrlRequest
          (clojure.core/nth args8578 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8579
          getQueueUrl
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args8578 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8579
              getQueueUrl
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getQueueUrl")
               {:args args8578}))))))))))))))
 (do
  (clojure.core/defmethod
   sqs
   :create-queue
   [m8580]
   (clojure.core/let
    [credentials8581 (:credentials m8580) args8582 (:args m8580)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8583
      (com.palletops.awaze.common/aws-client :sqs credentials8581)]
     (clojure.core/case
      (clojure.core/count args8582)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.sqs.model.CreateQueueRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.sqs.model.CreateQueueRequest
           (clojure.core/nth args8582 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8583
           createQueue
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args8582 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8583
               createQueue
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "createQueue")
                {:args args8582}))))))))))))))
  (clojure.core/defn
   create-queue-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         queue-name
                         attributes
                         clone-root]}]
                [credentials string-0]]),
    :doc "Generate map for createQueue, createQueue"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-queue,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   create-queue
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         queue-name
                         attributes
                         clone-root]}]
                [credentials string-0]]),
    :doc "Call createQueue, createQueue"}
   [credentials8585 & args8586]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8587
     (com.palletops.awaze.common/aws-client :sqs credentials8585)]
    (clojure.core/case
     (clojure.core/count args8586)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.sqs.model.CreateQueueRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.sqs.model.CreateQueueRequest
          (clojure.core/nth args8586 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8587
          createQueue
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args8586 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8587
              createQueue
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "createQueue")
               {:args args8586}))))))))))))))
 (do
  (clojure.core/defmethod
   sqs
   :list-dead-letter-source-queues
   [m8588]
   (clojure.core/let
    [credentials8589 (:credentials m8588) args8590 (:args m8588)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8591
      (com.palletops.awaze.common/aws-client :sqs credentials8589)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8591
       listDeadLetterSourceQueues
       (sqs/list-dead-letter-source-queues-request
        (clojure.core/nth args8590 0)))))))
  (clojure.core/defn
   list-dead-letter-source-queues-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Generate map for listDeadLetterSourceQueues"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-dead-letter-source-queues,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   list-dead-letter-source-queues
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Call listDeadLetterSourceQueues"}
   [credentials8593 & args8594]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8595
     (com.palletops.awaze.common/aws-client :sqs credentials8593)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8595
      listDeadLetterSourceQueues
      (sqs/list-dead-letter-source-queues-request
       (clojure.core/nth args8594 0)))))))
 (do
  (clojure.core/defmethod
   sqs
   :remove-permission
   [m8596]
   (clojure.core/let
    [credentials8597 (:credentials m8596) args8598 (:args m8596)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8599
      (com.palletops.awaze.common/aws-client :sqs credentials8597)]
     (clojure.core/case
      (clojure.core/count args8598)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8599
        removePermission
        (sqs/remove-permission-request (clojure.core/nth args8598 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8599
        removePermission
        (clojure.core/str (clojure.core/nth args8598 0))
        (clojure.core/str (clojure.core/nth args8598 1))))))))
  (clojure.core/defn
   remove-permission-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         label
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]
                [credentials string-0 string-1]]),
    :doc "Generate map for removePermission, removePermission"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :remove-permission,
     :credentials credentials__1842__auto__,
     :client :sqs})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :remove-permission,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   remove-permission
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         label
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]
                [credentials string-0 string-1]]),
    :doc "Call removePermission, removePermission"}
   [credentials8601 & args8602]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8603
     (com.palletops.awaze.common/aws-client :sqs credentials8601)]
    (clojure.core/case
     (clojure.core/count args8602)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8603
       removePermission
       (sqs/remove-permission-request (clojure.core/nth args8602 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8603
       removePermission
       (clojure.core/str (clojure.core/nth args8602 0))
       (clojure.core/str (clojure.core/nth args8602 1))))))))
 (do
  (clojure.core/defmethod
   sqs
   :set-queue-attributes
   [m8604]
   (clojure.core/let
    [credentials8605 (:credentials m8604) args8606 (:args m8604)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8607
      (com.palletops.awaze.common/aws-client :sqs credentials8605)]
     (clojure.core/case
      (clojure.core/count args8606)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8607
        setQueueAttributes
        (clojure.core/str (clojure.core/nth args8606 0))
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg8649] (clojure.core/str arg8649))
  (clojure.core/keys (clojure.core/nth args8606 1)))
 (clojure.core/map
  (clojure.core/fn [arg8649] (clojure.core/str arg8649))
  (clojure.core/vals (clojure.core/nth args8606 1))))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8607
        setQueueAttributes
        (sqs/set-queue-attributes-request
         (clojure.core/nth args8606 0))))))))
  (clojure.core/defn
   set-queue-attributes-map
   {:arglists (quote
               [[credentials string-0 map-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         attributes
                         clone-root
                         queue-url]}]]),
    :doc "Generate map for setQueueAttributes, setQueueAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-queue-attributes,
     :credentials credentials__1842__auto__,
     :client :sqs})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :set-queue-attributes,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   set-queue-attributes
   {:arglists (quote
               [[credentials string-0 map-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         attributes
                         clone-root
                         queue-url]}]]),
    :doc "Call setQueueAttributes, setQueueAttributes"}
   [credentials8609 & args8610]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8611
     (com.palletops.awaze.common/aws-client :sqs credentials8609)]
    (clojure.core/case
     (clojure.core/count args8610)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8611
       setQueueAttributes
       (clojure.core/str (clojure.core/nth args8610 0))
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg8650] (clojure.core/str arg8650))
  (clojure.core/keys (clojure.core/nth args8610 1)))
 (clojure.core/map
  (clojure.core/fn [arg8650] (clojure.core/str arg8650))
  (clojure.core/vals (clojure.core/nth args8610 1))))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8611
       setQueueAttributes
       (sqs/set-queue-attributes-request
        (clojure.core/nth args8610 0))))))))
 (do
  (clojure.core/defmethod
   sqs
   :receive-message
   [m8612]
   (clojure.core/let
    [credentials8613 (:credentials m8612) args8614 (:args m8612)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8615
      (com.palletops.awaze.common/aws-client :sqs credentials8613)]
     (clojure.core/case
      (clojure.core/count args8614)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args8614 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8615
           receiveMessage
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.sqs.model.ReceiveMessageRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.sqs.model.ReceiveMessageRequest
               (clojure.core/nth args8614 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8615
               receiveMessage
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "receiveMessage")
                {:args args8614}))))))))))))))
  (clojure.core/defn
   receive-message-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         attribute-names
                         sdk-client-execution-timeout
                         max-number-of-messages
                         sdk-request-timeout
                         message-attribute-names
                         wait-time-seconds
                         custom-query-parameters
                         visibility-timeout
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Generate map for receiveMessage, receiveMessage"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :receive-message,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   receive-message
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         attribute-names
                         sdk-client-execution-timeout
                         max-number-of-messages
                         sdk-request-timeout
                         message-attribute-names
                         wait-time-seconds
                         custom-query-parameters
                         visibility-timeout
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Call receiveMessage, receiveMessage"}
   [credentials8617 & args8618]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8619
     (com.palletops.awaze.common/aws-client :sqs credentials8617)]
    (clojure.core/case
     (clojure.core/count args8618)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args8618 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8619
          receiveMessage
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.sqs.model.ReceiveMessageRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.sqs.model.ReceiveMessageRequest
              (clojure.core/nth args8618 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8619
              receiveMessage
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "receiveMessage")
               {:args args8618}))))))))))))))
 (do
  (clojure.core/defmethod
   sqs
   :delete-message
   [m8620]
   (clojure.core/let
    [credentials8621 (:credentials m8620) args8622 (:args m8620)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8623
      (com.palletops.awaze.common/aws-client :sqs credentials8621)]
     (clojure.core/case
      (clojure.core/count args8622)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8623
        deleteMessage
        (clojure.core/str (clojure.core/nth args8622 0))
        (clojure.core/str (clojure.core/nth args8622 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8623
        deleteMessage
        (sqs/delete-message-request (clojure.core/nth args8622 0))))))))
  (clojure.core/defn
   delete-message-map
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         receipt-handle
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Generate map for deleteMessage, deleteMessage"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-message,
     :credentials credentials__1842__auto__,
     :client :sqs})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :delete-message,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   delete-message
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         receipt-handle
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Call deleteMessage, deleteMessage"}
   [credentials8625 & args8626]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8627
     (com.palletops.awaze.common/aws-client :sqs credentials8625)]
    (clojure.core/case
     (clojure.core/count args8626)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8627
       deleteMessage
       (clojure.core/str (clojure.core/nth args8626 0))
       (clojure.core/str (clojure.core/nth args8626 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8627
       deleteMessage
       (sqs/delete-message-request (clojure.core/nth args8626 0))))))))
 (do
  (clojure.core/defmethod
   sqs
   :send-message
   [m8628]
   (clojure.core/let
    [credentials8629 (:credentials m8628) args8630 (:args m8628)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8631
      (com.palletops.awaze.common/aws-client :sqs credentials8629)]
     (clojure.core/case
      (clojure.core/count args8630)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8631
        sendMessage
        (clojure.core/str (clojure.core/nth args8630 0))
        (clojure.core/str (clojure.core/nth args8630 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8631
        sendMessage
        (sqs/send-message-request (clojure.core/nth args8630 0))))))))
  (clojure.core/defn
   send-message-map
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         delay-seconds
                         sdk-request-timeout
                         message-attributes
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         message-body
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Generate map for sendMessage, sendMessage"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :send-message,
     :credentials credentials__1842__auto__,
     :client :sqs})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :send-message,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   send-message
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         delay-seconds
                         sdk-request-timeout
                         message-attributes
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         message-body
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Call sendMessage, sendMessage"}
   [credentials8633 & args8634]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8635
     (com.palletops.awaze.common/aws-client :sqs credentials8633)]
    (clojure.core/case
     (clojure.core/count args8634)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8635
       sendMessage
       (clojure.core/str (clojure.core/nth args8634 0))
       (clojure.core/str (clojure.core/nth args8634 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8635
       sendMessage
       (sqs/send-message-request (clojure.core/nth args8634 0))))))))
 (do
  (clojure.core/defmethod
   sqs
   :change-message-visibility-batch
   [m8636]
   (clojure.core/let
    [credentials8637 (:credentials m8636) args8638 (:args m8636)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8639
      (com.palletops.awaze.common/aws-client :sqs credentials8637)]
     (clojure.core/case
      (clojure.core/count args8638)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8639
        changeMessageVisibilityBatch
        (clojure.core/str (clojure.core/nth args8638 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg8715]
  (sqs/change-message-visibility-batch-request-entry arg8715))
 (clojure.core/nth args8638 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8639
        changeMessageVisibilityBatch
        (sqs/change-message-visibility-batch-request
         (clojure.core/nth args8638 0))))))))
  (clojure.core/defn
   change-message-visibility-batch-map
   {:arglists (quote
               [[credentials string-0 list-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         entries
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Generate map for changeMessageVisibilityBatch, changeMessageVisibilityBatch"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :change-message-visibility-batch,
     :credentials credentials__1842__auto__,
     :client :sqs})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :change-message-visibility-batch,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   change-message-visibility-batch
   {:arglists (quote
               [[credentials string-0 list-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         entries
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Call changeMessageVisibilityBatch, changeMessageVisibilityBatch"}
   [credentials8641 & args8642]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8643
     (com.palletops.awaze.common/aws-client :sqs credentials8641)]
    (clojure.core/case
     (clojure.core/count args8642)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8643
       changeMessageVisibilityBatch
       (clojure.core/str (clojure.core/nth args8642 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg8716]
  (sqs/change-message-visibility-batch-request-entry arg8716))
 (clojure.core/nth args8642 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8643
       changeMessageVisibilityBatch
       (sqs/change-message-visibility-batch-request
        (clojure.core/nth args8642 0))))))))
 (do
  (clojure.core/defmethod
   sqs
   :change-message-visibility
   [m8651]
   (clojure.core/let
    [credentials8652 (:credentials m8651) args8653 (:args m8651)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8654
      (com.palletops.awaze.common/aws-client :sqs credentials8652)]
     (clojure.core/case
      (clojure.core/count args8653)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8654
        changeMessageVisibility
        (sqs/change-message-visibility-request
         (clojure.core/nth args8653 0))))
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8654
        changeMessageVisibility
        (clojure.core/str (clojure.core/nth args8653 0))
        (clojure.core/str (clojure.core/nth args8653 1))
        (clojure.core/int (clojure.core/nth args8653 2))))))))
  (clojure.core/defn
   change-message-visibility-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         receipt-handle
                         sdk-request-timeout
                         custom-query-parameters
                         visibility-timeout
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]
                [credentials string-0 string-1 integer-2]]),
    :doc "Generate map for changeMessageVisibility, changeMessageVisibility"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :change-message-visibility,
     :credentials credentials__1842__auto__,
     :client :sqs})
   ([credentials__1842__auto__ a b c]
    {:args [a b c],
     :fn :change-message-visibility,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   change-message-visibility
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         receipt-handle
                         sdk-request-timeout
                         custom-query-parameters
                         visibility-timeout
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]
                [credentials string-0 string-1 integer-2]]),
    :doc "Call changeMessageVisibility, changeMessageVisibility"}
   [credentials8656 & args8657]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8658
     (com.palletops.awaze.common/aws-client :sqs credentials8656)]
    (clojure.core/case
     (clojure.core/count args8657)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8658
       changeMessageVisibility
       (sqs/change-message-visibility-request
        (clojure.core/nth args8657 0))))
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8658
       changeMessageVisibility
       (clojure.core/str (clojure.core/nth args8657 0))
       (clojure.core/str (clojure.core/nth args8657 1))
       (clojure.core/int (clojure.core/nth args8657 2))))))))
 (do
  (clojure.core/defmethod
   sqs
   :list-queues
   [m8659]
   (clojure.core/let
    [credentials8660 (:credentials m8659) args8661 (:args m8659)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8662
      (com.palletops.awaze.common/aws-client :sqs credentials8660)]
     (clojure.core/case
      (clojure.core/count args8661)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.sqs.model.ListQueuesRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.sqs.model.ListQueuesRequest
           (clojure.core/nth args8661 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8662
           listQueues
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args8661 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8662
               listQueues
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "listQueues")
                {:args args8661}))))))))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8662
        listQueues))))))
  (clojure.core/defn
   list-queues-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         queue-name-prefix
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials string-0]
                [credentials]]),
    :doc "Generate map for listQueues, listQueues, listQueues"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-queues,
     :credentials credentials__1842__auto__,
     :client :sqs})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-queues,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   list-queues
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         queue-name-prefix
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials string-0]
                [credentials]]),
    :doc "Call listQueues, listQueues, listQueues"}
   [credentials8664 & args8665]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8666
     (com.palletops.awaze.common/aws-client :sqs credentials8664)]
    (clojure.core/case
     (clojure.core/count args8665)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.sqs.model.ListQueuesRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.sqs.model.ListQueuesRequest
          (clojure.core/nth args8665 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8666
          listQueues
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args8665 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8666
              listQueues
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "listQueues")
               {:args args8665}))))))))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8666
       listQueues))))))
 (do
  (clojure.core/defmethod
   sqs
   :delete-message-batch
   [m8667]
   (clojure.core/let
    [credentials8668 (:credentials m8667) args8669 (:args m8667)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8670
      (com.palletops.awaze.common/aws-client :sqs credentials8668)]
     (clojure.core/case
      (clojure.core/count args8669)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8670
        deleteMessageBatch
        (clojure.core/str (clojure.core/nth args8669 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg8717]
  (sqs/delete-message-batch-request-entry arg8717))
 (clojure.core/nth args8669 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8670
        deleteMessageBatch
        (sqs/delete-message-batch-request
         (clojure.core/nth args8669 0))))))))
  (clojure.core/defn
   delete-message-batch-map
   {:arglists (quote
               [[credentials string-0 list-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         entries
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Generate map for deleteMessageBatch, deleteMessageBatch"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-message-batch,
     :credentials credentials__1842__auto__,
     :client :sqs})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :delete-message-batch,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   delete-message-batch
   {:arglists (quote
               [[credentials string-0 list-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         entries
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Call deleteMessageBatch, deleteMessageBatch"}
   [credentials8672 & args8673]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8674
     (com.palletops.awaze.common/aws-client :sqs credentials8672)]
    (clojure.core/case
     (clojure.core/count args8673)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8674
       deleteMessageBatch
       (clojure.core/str (clojure.core/nth args8673 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg8718]
  (sqs/delete-message-batch-request-entry arg8718))
 (clojure.core/nth args8673 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8674
       deleteMessageBatch
       (sqs/delete-message-batch-request
        (clojure.core/nth args8673 0))))))))
 (do
  (clojure.core/defmethod
   sqs
   :delete-queue
   [m8675]
   (clojure.core/let
    [credentials8676 (:credentials m8675) args8677 (:args m8675)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8678
      (com.palletops.awaze.common/aws-client :sqs credentials8676)]
     (clojure.core/case
      (clojure.core/count args8677)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.sqs.model.DeleteQueueRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.sqs.model.DeleteQueueRequest
           (clojure.core/nth args8677 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8678
           deleteQueue
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args8677 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8678
               deleteQueue
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteQueue")
                {:args args8677}))))))))))))))
  (clojure.core/defn
   delete-queue-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]
                [credentials string-0]]),
    :doc "Generate map for deleteQueue, deleteQueue"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-queue,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   delete-queue
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]
                [credentials string-0]]),
    :doc "Call deleteQueue, deleteQueue"}
   [credentials8680 & args8681]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8682
     (com.palletops.awaze.common/aws-client :sqs credentials8680)]
    (clojure.core/case
     (clojure.core/count args8681)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.sqs.model.DeleteQueueRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.sqs.model.DeleteQueueRequest
          (clojure.core/nth args8681 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8682
          deleteQueue
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args8681 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8682
              deleteQueue
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteQueue")
               {:args args8681}))))))))))))))
 (do
  (clojure.core/defmethod
   sqs
   :add-permission
   [m8683]
   (clojure.core/let
    [credentials8684 (:credentials m8683) args8685 (:args m8683)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8686
      (com.palletops.awaze.common/aws-client :sqs credentials8684)]
     (clojure.core/case
      (clojure.core/count args8685)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8686
        addPermission
        (sqs/add-permission-request (clojure.core/nth args8685 0))))
      4
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8686
        addPermission
        (clojure.core/str (clojure.core/nth args8685 0))
        (clojure.core/str (clojure.core/nth args8685 1))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg8719] (clojure.core/str arg8719))
 (clojure.core/nth args8685 2))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg8720] (clojure.core/str arg8720))
 (clojure.core/nth args8685 3))))))))
  (clojure.core/defn
   add-permission-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         awsaccount-ids
                         sdk-request-timeout
                         custom-query-parameters
                         actions
                         read-limit
                         label
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]
                [credentials string-0 string-1 list-2 list-3]]),
    :doc "Generate map for addPermission, addPermission"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :add-permission,
     :credentials credentials__1842__auto__,
     :client :sqs})
   ([credentials__1842__auto__ a b c d]
    {:args [a b c d],
     :fn :add-permission,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   add-permission
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         awsaccount-ids
                         sdk-request-timeout
                         custom-query-parameters
                         actions
                         read-limit
                         label
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]
                [credentials string-0 string-1 list-2 list-3]]),
    :doc "Call addPermission, addPermission"}
   [credentials8688 & args8689]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8690
     (com.palletops.awaze.common/aws-client :sqs credentials8688)]
    (clojure.core/case
     (clojure.core/count args8689)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8690
       addPermission
       (sqs/add-permission-request (clojure.core/nth args8689 0))))
     4
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8690
       addPermission
       (clojure.core/str (clojure.core/nth args8689 0))
       (clojure.core/str (clojure.core/nth args8689 1))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg8721] (clojure.core/str arg8721))
 (clojure.core/nth args8689 2))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg8722] (clojure.core/str arg8722))
 (clojure.core/nth args8689 3))))))))
 (do
  (clojure.core/defmethod
   sqs
   :purge-queue
   [m8691]
   (clojure.core/let
    [credentials8692 (:credentials m8691) args8693 (:args m8691)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8694
      (com.palletops.awaze.common/aws-client :sqs credentials8692)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8694
       purgeQueue
       (sqs/purge-queue-request (clojure.core/nth args8693 0)))))))
  (clojure.core/defn
   purge-queue-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Generate map for purgeQueue"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :purge-queue,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   purge-queue
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Call purgeQueue"}
   [credentials8696 & args8697]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8698
     (com.palletops.awaze.common/aws-client :sqs credentials8696)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8698
      purgeQueue
      (sqs/purge-queue-request (clojure.core/nth args8697 0)))))))
 (do
  (clojure.core/defmethod
   sqs
   :get-queue-attributes
   [m8699]
   (clojure.core/let
    [credentials8700 (:credentials m8699) args8701 (:args m8699)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8702
      (com.palletops.awaze.common/aws-client :sqs credentials8700)]
     (clojure.core/case
      (clojure.core/count args8701)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8702
        getQueueAttributes
        (sqs/get-queue-attributes-request
         (clojure.core/nth args8701 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8702
        getQueueAttributes
        (clojure.core/str (clojure.core/nth args8701 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg8723] (clojure.core/str arg8723))
 (clojure.core/nth args8701 1))))))))
  (clojure.core/defn
   get-queue-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         attribute-names
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]
                [credentials string-0 list-1]]),
    :doc "Generate map for getQueueAttributes, getQueueAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-queue-attributes,
     :credentials credentials__1842__auto__,
     :client :sqs})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :get-queue-attributes,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   get-queue-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         attribute-names
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]
                [credentials string-0 list-1]]),
    :doc "Call getQueueAttributes, getQueueAttributes"}
   [credentials8704 & args8705]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8706
     (com.palletops.awaze.common/aws-client :sqs credentials8704)]
    (clojure.core/case
     (clojure.core/count args8705)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8706
       getQueueAttributes
       (sqs/get-queue-attributes-request
        (clojure.core/nth args8705 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8706
       getQueueAttributes
       (clojure.core/str (clojure.core/nth args8705 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg8724] (clojure.core/str arg8724))
 (clojure.core/nth args8705 1))))))))
 (do
  (clojure.core/defmethod
   sqs
   :send-message-batch
   [m8707]
   (clojure.core/let
    [credentials8708 (:credentials m8707) args8709 (:args m8707)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8710
      (com.palletops.awaze.common/aws-client :sqs credentials8708)]
     (clojure.core/case
      (clojure.core/count args8709)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8710
        sendMessageBatch
        (sqs/send-message-batch-request (clojure.core/nth args8709 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8710
        sendMessageBatch
        (clojure.core/str (clojure.core/nth args8709 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg8725]
  (sqs/send-message-batch-request-entry arg8725))
 (clojure.core/nth args8709 1))))))))
  (clojure.core/defn
   send-message-batch-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         entries
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]
                [credentials string-0 list-1]]),
    :doc "Generate map for sendMessageBatch, sendMessageBatch"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :send-message-batch,
     :credentials credentials__1842__auto__,
     :client :sqs})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :send-message-batch,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   send-message-batch
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         entries
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]
                [credentials string-0 list-1]]),
    :doc "Call sendMessageBatch, sendMessageBatch"}
   [credentials8712 & args8713]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8714
     (com.palletops.awaze.common/aws-client :sqs credentials8712)]
    (clojure.core/case
     (clojure.core/count args8713)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8714
       sendMessageBatch
       (sqs/send-message-batch-request (clojure.core/nth args8713 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8714
       sendMessageBatch
       (clojure.core/str (clojure.core/nth args8713 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg8726]
  (sqs/send-message-batch-request-entry arg8726))
 (clojure.core/nth args8713 1)))))))))
