(ns
 com.palletops.awaze.simpledb
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.simpledb :as simpledb]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :simpledb
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.simpledb.AmazonSimpleDBClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.ReplaceableAttribute}
replaceable-attribute
  [m8728]
  (clojure.core/let
   [bean8727
    (new com.amazonaws.services.simpledb.model.ReplaceableAttribute)]
   (clojure.core/let
    [v8729 (:replace m8728 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8729 :com.palletops.awaze.client-builder/undef)
     (. bean8727 setReplace (clojure.core/boolean v8729))))
   (clojure.core/let
    [v8729 (:name m8728 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8729 :com.palletops.awaze.client-builder/undef)
     (. bean8727 setName (clojure.core/str v8729))))
   (clojure.core/let
    [v8729 (:value m8728 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8729 :com.palletops.awaze.client-builder/undef)
     (. bean8727 setValue (clojure.core/str v8729))))
   bean8727))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.Attribute}
attribute
  [m8731]
  (clojure.core/let
   [bean8730 (new com.amazonaws.services.simpledb.model.Attribute)]
   (clojure.core/let
    [v8732
     (:alternate-name-encoding
      m8731
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8732 :com.palletops.awaze.client-builder/undef)
     (. bean8730 setAlternateNameEncoding (clojure.core/str v8732))))
   (clojure.core/let
    [v8732
     (:alternate-value-encoding
      m8731
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8732 :com.palletops.awaze.client-builder/undef)
     (. bean8730 setAlternateValueEncoding (clojure.core/str v8732))))
   (clojure.core/let
    [v8732 (:name m8731 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8732 :com.palletops.awaze.client-builder/undef)
     (. bean8730 setName (clojure.core/str v8732))))
   (clojure.core/let
    [v8732 (:value m8731 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8732 :com.palletops.awaze.client-builder/undef)
     (. bean8730 setValue (clojure.core/str v8732))))
   bean8730))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.ReplaceableItem}
replaceable-item
  [m8734]
  (clojure.core/let
   [bean8733
    (new com.amazonaws.services.simpledb.model.ReplaceableItem)]
   (clojure.core/let
    [v8735
     (:attributes m8734 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8735 :com.palletops.awaze.client-builder/undef)
     (.
      bean8733
      setAttributes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8772] (simpledb/replaceable-attribute arg8772))
 v8735))))
   (clojure.core/let
    [v8735 (:name m8734 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8735 :com.palletops.awaze.client-builder/undef)
     (. bean8733 setName (clojure.core/str v8735))))
   bean8733))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.DeletableItem}
deletable-item
  [m8737]
  (clojure.core/let
   [bean8736
    (new com.amazonaws.services.simpledb.model.DeletableItem)]
   (clojure.core/let
    [v8738
     (:attributes m8737 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8738 :com.palletops.awaze.client-builder/undef)
     (.
      bean8736
      setAttributes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8773] (simpledb/attribute arg8773))
 v8738))))
   (clojure.core/let
    [v8738 (:name m8737 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8738 :com.palletops.awaze.client-builder/undef)
     (. bean8736 setName (clojure.core/str v8738))))
   bean8736))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.UpdateCondition}
update-condition
  [m8740]
  (clojure.core/let
   [bean8739
    (new com.amazonaws.services.simpledb.model.UpdateCondition)]
   (clojure.core/let
    [v8741 (:exists m8740 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8741 :com.palletops.awaze.client-builder/undef)
     (. bean8739 setExists (clojure.core/boolean v8741))))
   (clojure.core/let
    [v8741 (:name m8740 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8741 :com.palletops.awaze.client-builder/undef)
     (. bean8739 setName (clojure.core/str v8741))))
   (clojure.core/let
    [v8741 (:value m8740 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8741 :com.palletops.awaze.client-builder/undef)
     (. bean8739 setValue (clojure.core/str v8741))))
   bean8739))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.ListDomainsRequest}
list-domains-request
  [m8743]
  (clojure.core/let
   [bean8742
    (new com.amazonaws.services.simpledb.model.ListDomainsRequest)]
   (clojure.core/let
    [v8744
     (:max-number-of-domains
      m8743
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8744 :com.palletops.awaze.client-builder/undef)
     (. bean8742 setMaxNumberOfDomains (clojure.core/int v8744))))
   (clojure.core/let
    [v8744
     (:next-token m8743 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8744 :com.palletops.awaze.client-builder/undef)
     (. bean8742 setNextToken (clojure.core/str v8744))))
   bean8742))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.DeleteDomainRequest}
delete-domain-request
  [m8746]
  (clojure.core/let
   [bean8745
    (new com.amazonaws.services.simpledb.model.DeleteDomainRequest)]
   (clojure.core/let
    [v8747
     (:domain-name m8746 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8747 :com.palletops.awaze.client-builder/undef)
     (. bean8745 setDomainName (clojure.core/str v8747))))
   bean8745))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.DomainMetadataRequest}
domain-metadata-request
  [m8749]
  (clojure.core/let
   [bean8748
    (new com.amazonaws.services.simpledb.model.DomainMetadataRequest)]
   (clojure.core/let
    [v8750
     (:domain-name m8749 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8750 :com.palletops.awaze.client-builder/undef)
     (. bean8748 setDomainName (clojure.core/str v8750))))
   bean8748))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.BatchPutAttributesRequest}
batch-put-attributes-request
  [m8752]
  (clojure.core/let
   [bean8751
    (new
     com.amazonaws.services.simpledb.model.BatchPutAttributesRequest)]
   (clojure.core/let
    [v8753 (:items m8752 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8753 :com.palletops.awaze.client-builder/undef)
     (.
      bean8751
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8774] (simpledb/replaceable-item arg8774))
 v8753))))
   (clojure.core/let
    [v8753
     (:domain-name m8752 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8753 :com.palletops.awaze.client-builder/undef)
     (. bean8751 setDomainName (clojure.core/str v8753))))
   bean8751))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.BatchDeleteAttributesRequest}
batch-delete-attributes-request
  [m8755]
  (clojure.core/let
   [bean8754
    (new
     com.amazonaws.services.simpledb.model.BatchDeleteAttributesRequest)]
   (clojure.core/let
    [v8756 (:items m8755 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8756 :com.palletops.awaze.client-builder/undef)
     (.
      bean8754
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8775] (simpledb/deletable-item arg8775))
 v8756))))
   (clojure.core/let
    [v8756
     (:domain-name m8755 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8756 :com.palletops.awaze.client-builder/undef)
     (. bean8754 setDomainName (clojure.core/str v8756))))
   bean8754))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.GetAttributesRequest}
get-attributes-request
  [m8758]
  (clojure.core/let
   [bean8757
    (new com.amazonaws.services.simpledb.model.GetAttributesRequest)]
   (clojure.core/let
    [v8759
     (:item-name m8758 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8759 :com.palletops.awaze.client-builder/undef)
     (. bean8757 setItemName (clojure.core/str v8759))))
   (clojure.core/let
    [v8759
     (:consistent-read
      m8758
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8759 :com.palletops.awaze.client-builder/undef)
     (. bean8757 setConsistentRead (clojure.core/boolean v8759))))
   (clojure.core/let
    [v8759
     (:attribute-names
      m8758
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8759 :com.palletops.awaze.client-builder/undef)
     (.
      bean8757
      setAttributeNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8776] (clojure.core/str arg8776))
 v8759))))
   (clojure.core/let
    [v8759
     (:domain-name m8758 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8759 :com.palletops.awaze.client-builder/undef)
     (. bean8757 setDomainName (clojure.core/str v8759))))
   bean8757))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.PutAttributesRequest}
put-attributes-request
  [m8761]
  (clojure.core/let
   [bean8760
    (new com.amazonaws.services.simpledb.model.PutAttributesRequest)]
   (clojure.core/let
    [v8762
     (:attributes m8761 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8762 :com.palletops.awaze.client-builder/undef)
     (.
      bean8760
      setAttributes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8777] (simpledb/replaceable-attribute arg8777))
 v8762))))
   (clojure.core/let
    [v8762
     (:item-name m8761 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8762 :com.palletops.awaze.client-builder/undef)
     (. bean8760 setItemName (clojure.core/str v8762))))
   (clojure.core/let
    [v8762
     (:expected m8761 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8762 :com.palletops.awaze.client-builder/undef)
     (. bean8760 setExpected (simpledb/update-condition v8762))))
   (clojure.core/let
    [v8762
     (:domain-name m8761 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8762 :com.palletops.awaze.client-builder/undef)
     (. bean8760 setDomainName (clojure.core/str v8762))))
   bean8760))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.DeleteAttributesRequest}
delete-attributes-request
  [m8764]
  (clojure.core/let
   [bean8763
    (new
     com.amazonaws.services.simpledb.model.DeleteAttributesRequest)]
   (clojure.core/let
    [v8765
     (:attributes m8764 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8765 :com.palletops.awaze.client-builder/undef)
     (.
      bean8763
      setAttributes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8778] (simpledb/attribute arg8778))
 v8765))))
   (clojure.core/let
    [v8765
     (:item-name m8764 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8765 :com.palletops.awaze.client-builder/undef)
     (. bean8763 setItemName (clojure.core/str v8765))))
   (clojure.core/let
    [v8765
     (:expected m8764 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8765 :com.palletops.awaze.client-builder/undef)
     (. bean8763 setExpected (simpledb/update-condition v8765))))
   (clojure.core/let
    [v8765
     (:domain-name m8764 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8765 :com.palletops.awaze.client-builder/undef)
     (. bean8763 setDomainName (clojure.core/str v8765))))
   bean8763))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.CreateDomainRequest}
create-domain-request
  [m8767]
  (clojure.core/let
   [bean8766
    (new com.amazonaws.services.simpledb.model.CreateDomainRequest)]
   (clojure.core/let
    [v8768
     (:domain-name m8767 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8768 :com.palletops.awaze.client-builder/undef)
     (. bean8766 setDomainName (clojure.core/str v8768))))
   bean8766))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.SelectRequest}
select-request
  [m8770]
  (clojure.core/let
   [bean8769
    (new com.amazonaws.services.simpledb.model.SelectRequest)]
   (clojure.core/let
    [v8771
     (:select-expression
      m8770
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8771 :com.palletops.awaze.client-builder/undef)
     (. bean8769 setSelectExpression (clojure.core/str v8771))))
   (clojure.core/let
    [v8771
     (:consistent-read
      m8770
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8771 :com.palletops.awaze.client-builder/undef)
     (. bean8769 setConsistentRead (clojure.core/boolean v8771))))
   (clojure.core/let
    [v8771
     (:next-token m8770 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8771 :com.palletops.awaze.client-builder/undef)
     (. bean8769 setNextToken (clojure.core/str v8771))))
   bean8769))
 (clojure.core/defmulti
  simpledb
  (clojure.core/fn simpledb [m__1874__auto__] (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   simpledb
   :list-domains
   [m8779]
   (clojure.core/let
    [credentials8780 (:credentials m8779) args8781 (:args m8779)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client8782
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials8780)]
     (clojure.core/case
      (clojure.core/count args8781)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8782
        listDomains
        (simpledb/list-domains-request (clojure.core/nth args8781 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8782
        listDomains))))))
  (clojure.core/defn
   list-domains-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-number-of-domains
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for listDomains, listDomains"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-domains,
     :credentials credentials__1842__auto__,
     :client :simpledb})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-domains,
     :credentials credentials__1842__auto__,
     :client :simpledb}))
  (clojure.core/defn
   list-domains
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-number-of-domains
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call listDomains, listDomains"}
   [credentials8784 & args8785]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client8786
     (com.palletops.awaze.common/aws-client :simpledb credentials8784)]
    (clojure.core/case
     (clojure.core/count args8785)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8786
       listDomains
       (simpledb/list-domains-request (clojure.core/nth args8785 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8786
       listDomains))))))
 (do
  (clojure.core/defmethod
   simpledb
   :delete-domain
   [m8787]
   (clojure.core/let
    [credentials8788 (:credentials m8787) args8789 (:args m8787)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client8790
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials8788)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8790
       deleteDomain
       (simpledb/delete-domain-request (clojure.core/nth args8789 0)))))))
  (clojure.core/defn
   delete-domain-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteDomain"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-domain,
     :credentials credentials__1842__auto__,
     :client :simpledb}))
  (clojure.core/defn
   delete-domain
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteDomain"}
   [credentials8792 & args8793]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client8794
     (com.palletops.awaze.common/aws-client :simpledb credentials8792)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8794
      deleteDomain
      (simpledb/delete-domain-request (clojure.core/nth args8793 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :domain-metadata
   [m8795]
   (clojure.core/let
    [credentials8796 (:credentials m8795) args8797 (:args m8795)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client8798
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials8796)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8798
       domainMetadata
       (simpledb/domain-metadata-request
        (clojure.core/nth args8797 0)))))))
  (clojure.core/defn
   domain-metadata-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for domainMetadata"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :domain-metadata,
     :credentials credentials__1842__auto__,
     :client :simpledb}))
  (clojure.core/defn
   domain-metadata
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call domainMetadata"}
   [credentials8800 & args8801]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client8802
     (com.palletops.awaze.common/aws-client :simpledb credentials8800)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8802
      domainMetadata
      (simpledb/domain-metadata-request (clojure.core/nth args8801 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :batch-put-attributes
   [m8803]
   (clojure.core/let
    [credentials8804 (:credentials m8803) args8805 (:args m8803)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client8806
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials8804)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8806
       batchPutAttributes
       (simpledb/batch-put-attributes-request
        (clojure.core/nth args8805 0)))))))
  (clojure.core/defn
   batch-put-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         items
                         clone-root]}]]),
    :doc "Generate map for batchPutAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :batch-put-attributes,
     :credentials credentials__1842__auto__,
     :client :simpledb}))
  (clojure.core/defn
   batch-put-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         items
                         clone-root]}]]),
    :doc "Call batchPutAttributes"}
   [credentials8808 & args8809]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client8810
     (com.palletops.awaze.common/aws-client :simpledb credentials8808)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8810
      batchPutAttributes
      (simpledb/batch-put-attributes-request
       (clojure.core/nth args8809 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :batch-delete-attributes
   [m8811]
   (clojure.core/let
    [credentials8812 (:credentials m8811) args8813 (:args m8811)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client8814
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials8812)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8814
       batchDeleteAttributes
       (simpledb/batch-delete-attributes-request
        (clojure.core/nth args8813 0)))))))
  (clojure.core/defn
   batch-delete-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         items
                         clone-root]}]]),
    :doc "Generate map for batchDeleteAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :batch-delete-attributes,
     :credentials credentials__1842__auto__,
     :client :simpledb}))
  (clojure.core/defn
   batch-delete-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         items
                         clone-root]}]]),
    :doc "Call batchDeleteAttributes"}
   [credentials8816 & args8817]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client8818
     (com.palletops.awaze.common/aws-client :simpledb credentials8816)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8818
      batchDeleteAttributes
      (simpledb/batch-delete-attributes-request
       (clojure.core/nth args8817 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :get-attributes
   [m8819]
   (clojure.core/let
    [credentials8820 (:credentials m8819) args8821 (:args m8819)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client8822
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials8820)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8822
       getAttributes
       (simpledb/get-attributes-request (clojure.core/nth args8821 0)))))))
  (clojure.core/defn
   get-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         attribute-names
                         sdk-client-execution-timeout
                         item-name
                         consistent-read
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-attributes,
     :credentials credentials__1842__auto__,
     :client :simpledb}))
  (clojure.core/defn
   get-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         attribute-names
                         sdk-client-execution-timeout
                         item-name
                         consistent-read
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getAttributes"}
   [credentials8824 & args8825]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client8826
     (com.palletops.awaze.common/aws-client :simpledb credentials8824)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8826
      getAttributes
      (simpledb/get-attributes-request (clojure.core/nth args8825 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :put-attributes
   [m8827]
   (clojure.core/let
    [credentials8828 (:credentials m8827) args8829 (:args m8827)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client8830
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials8828)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8830
       putAttributes
       (simpledb/put-attributes-request (clojure.core/nth args8829 0)))))))
  (clojure.core/defn
   put-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         item-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         expected
                         general-progress-listener
                         clone-source
                         attributes
                         clone-root]}]]),
    :doc "Generate map for putAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :put-attributes,
     :credentials credentials__1842__auto__,
     :client :simpledb}))
  (clojure.core/defn
   put-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         item-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         expected
                         general-progress-listener
                         clone-source
                         attributes
                         clone-root]}]]),
    :doc "Call putAttributes"}
   [credentials8832 & args8833]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client8834
     (com.palletops.awaze.common/aws-client :simpledb credentials8832)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8834
      putAttributes
      (simpledb/put-attributes-request (clojure.core/nth args8833 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :delete-attributes
   [m8835]
   (clojure.core/let
    [credentials8836 (:credentials m8835) args8837 (:args m8835)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client8838
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials8836)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8838
       deleteAttributes
       (simpledb/delete-attributes-request
        (clojure.core/nth args8837 0)))))))
  (clojure.core/defn
   delete-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         item-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         expected
                         general-progress-listener
                         clone-source
                         attributes
                         clone-root]}]]),
    :doc "Generate map for deleteAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-attributes,
     :credentials credentials__1842__auto__,
     :client :simpledb}))
  (clojure.core/defn
   delete-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         item-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         expected
                         general-progress-listener
                         clone-source
                         attributes
                         clone-root]}]]),
    :doc "Call deleteAttributes"}
   [credentials8840 & args8841]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client8842
     (com.palletops.awaze.common/aws-client :simpledb credentials8840)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8842
      deleteAttributes
      (simpledb/delete-attributes-request
       (clojure.core/nth args8841 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :create-domain
   [m8843]
   (clojure.core/let
    [credentials8844 (:credentials m8843) args8845 (:args m8843)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client8846
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials8844)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8846
       createDomain
       (simpledb/create-domain-request (clojure.core/nth args8845 0)))))))
  (clojure.core/defn
   create-domain-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createDomain"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-domain,
     :credentials credentials__1842__auto__,
     :client :simpledb}))
  (clojure.core/defn
   create-domain
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createDomain"}
   [credentials8848 & args8849]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client8850
     (com.palletops.awaze.common/aws-client :simpledb credentials8848)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8850
      createDomain
      (simpledb/create-domain-request (clojure.core/nth args8849 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :select
   [m8851]
   (clojure.core/let
    [credentials8852 (:credentials m8851) args8853 (:args m8851)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client8854
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials8852)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8854
       select
       (simpledb/select-request (clojure.core/nth args8853 0)))))))
  (clojure.core/defn
   select-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         consistent-read
                         sdk-request-timeout
                         select-expression
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for select"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :select,
     :credentials credentials__1842__auto__,
     :client :simpledb}))
  (clojure.core/defn
   select
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         consistent-read
                         sdk-request-timeout
                         select-expression
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call select"}
   [credentials8856 & args8857]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client8858
     (com.palletops.awaze.common/aws-client :simpledb credentials8856)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8858
      select
      (simpledb/select-request (clojure.core/nth args8857 0))))))))
