(ns
 com.palletops.awaze.securitytoken
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.securitytoken :as securitytoken]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :securitytoken
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.securitytoken.model.AssumeRoleRequest}
assume-role-request
  [m8435]
  (clojure.core/let
   [bean8434
    (new com.amazonaws.services.securitytoken.model.AssumeRoleRequest)]
   (clojure.core/let
    [v8436 (:policy m8435 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8436 :com.palletops.awaze.client-builder/undef)
     (. bean8434 setPolicy (clojure.core/str v8436))))
   (clojure.core/let
    [v8436
     (:role-arn m8435 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8436 :com.palletops.awaze.client-builder/undef)
     (. bean8434 setRoleArn (clojure.core/str v8436))))
   (clojure.core/let
    [v8436
     (:role-session-name
      m8435
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8436 :com.palletops.awaze.client-builder/undef)
     (. bean8434 setRoleSessionName (clojure.core/str v8436))))
   (clojure.core/let
    [v8436
     (:duration-seconds
      m8435
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8436 :com.palletops.awaze.client-builder/undef)
     (. bean8434 setDurationSeconds (clojure.core/int v8436))))
   (clojure.core/let
    [v8436
     (:external-id m8435 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8436 :com.palletops.awaze.client-builder/undef)
     (. bean8434 setExternalId (clojure.core/str v8436))))
   (clojure.core/let
    [v8436
     (:serial-number m8435 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8436 :com.palletops.awaze.client-builder/undef)
     (. bean8434 setSerialNumber (clojure.core/str v8436))))
   (clojure.core/let
    [v8436
     (:token-code m8435 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8436 :com.palletops.awaze.client-builder/undef)
     (. bean8434 setTokenCode (clojure.core/str v8436))))
   bean8434))
 (clojure.core/defn
^{:tag com.amazonaws.services.securitytoken.model.AssumeRoleWithSAMLRequest}
assume-role-with-samlrequest
  [m8438]
  (clojure.core/let
   [bean8437
    (new
     com.amazonaws.services.securitytoken.model.AssumeRoleWithSAMLRequest)]
   (clojure.core/let
    [v8439 (:policy m8438 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8439 :com.palletops.awaze.client-builder/undef)
     (. bean8437 setPolicy (clojure.core/str v8439))))
   (clojure.core/let
    [v8439
     (:principal-arn m8438 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8439 :com.palletops.awaze.client-builder/undef)
     (. bean8437 setPrincipalArn (clojure.core/str v8439))))
   (clojure.core/let
    [v8439
     (:samlassertion m8438 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8439 :com.palletops.awaze.client-builder/undef)
     (. bean8437 setSAMLAssertion (clojure.core/str v8439))))
   (clojure.core/let
    [v8439
     (:role-arn m8438 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8439 :com.palletops.awaze.client-builder/undef)
     (. bean8437 setRoleArn (clojure.core/str v8439))))
   (clojure.core/let
    [v8439
     (:duration-seconds
      m8438
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8439 :com.palletops.awaze.client-builder/undef)
     (. bean8437 setDurationSeconds (clojure.core/int v8439))))
   bean8437))
 (clojure.core/defn
^{:tag com.amazonaws.services.securitytoken.model.AssumeRoleWithWebIdentityRequest}
assume-role-with-web-identity-request
  [m8441]
  (clojure.core/let
   [bean8440
    (new
     com.amazonaws.services.securitytoken.model.AssumeRoleWithWebIdentityRequest)]
   (clojure.core/let
    [v8442 (:policy m8441 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8442 :com.palletops.awaze.client-builder/undef)
     (. bean8440 setPolicy (clojure.core/str v8442))))
   (clojure.core/let
    [v8442
     (:web-identity-token
      m8441
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8442 :com.palletops.awaze.client-builder/undef)
     (. bean8440 setWebIdentityToken (clojure.core/str v8442))))
   (clojure.core/let
    [v8442
     (:role-arn m8441 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8442 :com.palletops.awaze.client-builder/undef)
     (. bean8440 setRoleArn (clojure.core/str v8442))))
   (clojure.core/let
    [v8442
     (:role-session-name
      m8441
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8442 :com.palletops.awaze.client-builder/undef)
     (. bean8440 setRoleSessionName (clojure.core/str v8442))))
   (clojure.core/let
    [v8442
     (:duration-seconds
      m8441
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8442 :com.palletops.awaze.client-builder/undef)
     (. bean8440 setDurationSeconds (clojure.core/int v8442))))
   (clojure.core/let
    [v8442
     (:provider-id m8441 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8442 :com.palletops.awaze.client-builder/undef)
     (. bean8440 setProviderId (clojure.core/str v8442))))
   bean8440))
 (clojure.core/defn
^{:tag com.amazonaws.services.securitytoken.model.DecodeAuthorizationMessageRequest}
decode-authorization-message-request
  [m8444]
  (clojure.core/let
   [bean8443
    (new
     com.amazonaws.services.securitytoken.model.DecodeAuthorizationMessageRequest)]
   (clojure.core/let
    [v8445
     (:encoded-message
      m8444
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8445 :com.palletops.awaze.client-builder/undef)
     (. bean8443 setEncodedMessage (clojure.core/str v8445))))
   bean8443))
 (clojure.core/defn
^{:tag com.amazonaws.services.securitytoken.model.GetFederationTokenRequest}
get-federation-token-request
  [m8447]
  (clojure.core/let
   [bean8446
    (new
     com.amazonaws.services.securitytoken.model.GetFederationTokenRequest)]
   (clojure.core/let
    [v8448 (:policy m8447 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8448 :com.palletops.awaze.client-builder/undef)
     (. bean8446 setPolicy (clojure.core/str v8448))))
   (clojure.core/let
    [v8448
     (:duration-seconds
      m8447
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8448 :com.palletops.awaze.client-builder/undef)
     (. bean8446 setDurationSeconds (clojure.core/int v8448))))
   (clojure.core/let
    [v8448 (:name m8447 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8448 :com.palletops.awaze.client-builder/undef)
     (. bean8446 setName (clojure.core/str v8448))))
   bean8446))
 (clojure.core/defn
^{:tag com.amazonaws.services.securitytoken.model.GetSessionTokenRequest}
get-session-token-request
  [m8450]
  (clojure.core/let
   [bean8449
    (new
     com.amazonaws.services.securitytoken.model.GetSessionTokenRequest)]
   (clojure.core/let
    [v8451
     (:duration-seconds
      m8450
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8451 :com.palletops.awaze.client-builder/undef)
     (. bean8449 setDurationSeconds (clojure.core/int v8451))))
   (clojure.core/let
    [v8451
     (:serial-number m8450 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8451 :com.palletops.awaze.client-builder/undef)
     (. bean8449 setSerialNumber (clojure.core/str v8451))))
   (clojure.core/let
    [v8451
     (:token-code m8450 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8451 :com.palletops.awaze.client-builder/undef)
     (. bean8449 setTokenCode (clojure.core/str v8451))))
   bean8449))
 (clojure.core/defmulti
  securitytoken
  (clojure.core/fn
   securitytoken
   [m__1874__auto__]
   (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   securitytoken
   :assume-role
   [m8452]
   (clojure.core/let
    [credentials8453 (:credentials m8452) args8454 (:args m8452)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client8455
      (com.palletops.awaze.common/aws-client
       :securitytoken
       credentials8453)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8455
       assumeRole
       (securitytoken/assume-role-request
        (clojure.core/nth args8454 0)))))))
  (clojure.core/defn
   assume-role-map
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         serial-number
                         custom-request-headers
                         sdk-client-execution-timeout
                         token-code
                         sdk-request-timeout
                         custom-query-parameters
                         policy
                         role-arn
                         external-id
                         read-limit
                         general-progress-listener
                         clone-source
                         role-session-name
                         clone-root]}]]),
    :doc "Generate map for assumeRole"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :assume-role,
     :credentials credentials__1842__auto__,
     :client :securitytoken}))
  (clojure.core/defn
   assume-role
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         serial-number
                         custom-request-headers
                         sdk-client-execution-timeout
                         token-code
                         sdk-request-timeout
                         custom-query-parameters
                         policy
                         role-arn
                         external-id
                         read-limit
                         general-progress-listener
                         clone-source
                         role-session-name
                         clone-root]}]]),
    :doc "Call assumeRole"}
   [credentials8457 & args8458]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client8459
     (com.palletops.awaze.common/aws-client
      :securitytoken
      credentials8457)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8459
      assumeRole
      (securitytoken/assume-role-request
       (clojure.core/nth args8458 0)))))))
 (do
  (clojure.core/defmethod
   securitytoken
   :assume-role-with-saml
   [m8460]
   (clojure.core/let
    [credentials8461 (:credentials m8460) args8462 (:args m8460)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client8463
      (com.palletops.awaze.common/aws-client
       :securitytoken
       credentials8461)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8463
       assumeRoleWithSAML
       (securitytoken/assume-role-with-samlrequest
        (clojure.core/nth args8462 0)))))))
  (clojure.core/defn
   assume-role-with-saml-map
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         custom-request-headers
                         sdk-client-execution-timeout
                         principal-arn
                         sdk-request-timeout
                         custom-query-parameters
                         samlassertion
                         policy
                         role-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for assumeRoleWithSAML"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :assume-role-with-saml,
     :credentials credentials__1842__auto__,
     :client :securitytoken}))
  (clojure.core/defn
   assume-role-with-saml
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         custom-request-headers
                         sdk-client-execution-timeout
                         principal-arn
                         sdk-request-timeout
                         custom-query-parameters
                         samlassertion
                         policy
                         role-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call assumeRoleWithSAML"}
   [credentials8465 & args8466]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client8467
     (com.palletops.awaze.common/aws-client
      :securitytoken
      credentials8465)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8467
      assumeRoleWithSAML
      (securitytoken/assume-role-with-samlrequest
       (clojure.core/nth args8466 0)))))))
 (do
  (clojure.core/defmethod
   securitytoken
   :assume-role-with-web-identity
   [m8468]
   (clojure.core/let
    [credentials8469 (:credentials m8468) args8470 (:args m8468)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client8471
      (com.palletops.awaze.common/aws-client
       :securitytoken
       credentials8469)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8471
       assumeRoleWithWebIdentity
       (securitytoken/assume-role-with-web-identity-request
        (clojure.core/nth args8470 0)))))))
  (clojure.core/defn
   assume-role-with-web-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         custom-request-headers
                         sdk-client-execution-timeout
                         provider-id
                         sdk-request-timeout
                         custom-query-parameters
                         policy
                         role-arn
                         read-limit
                         general-progress-listener
                         web-identity-token
                         clone-source
                         role-session-name
                         clone-root]}]]),
    :doc "Generate map for assumeRoleWithWebIdentity"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :assume-role-with-web-identity,
     :credentials credentials__1842__auto__,
     :client :securitytoken}))
  (clojure.core/defn
   assume-role-with-web-identity
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         custom-request-headers
                         sdk-client-execution-timeout
                         provider-id
                         sdk-request-timeout
                         custom-query-parameters
                         policy
                         role-arn
                         read-limit
                         general-progress-listener
                         web-identity-token
                         clone-source
                         role-session-name
                         clone-root]}]]),
    :doc "Call assumeRoleWithWebIdentity"}
   [credentials8473 & args8474]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client8475
     (com.palletops.awaze.common/aws-client
      :securitytoken
      credentials8473)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8475
      assumeRoleWithWebIdentity
      (securitytoken/assume-role-with-web-identity-request
       (clojure.core/nth args8474 0)))))))
 (do
  (clojure.core/defmethod
   securitytoken
   :decode-authorization-message
   [m8476]
   (clojure.core/let
    [credentials8477 (:credentials m8476) args8478 (:args m8476)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client8479
      (com.palletops.awaze.common/aws-client
       :securitytoken
       credentials8477)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8479
       decodeAuthorizationMessage
       (securitytoken/decode-authorization-message-request
        (clojure.core/nth args8478 0)))))))
  (clojure.core/defn
   decode-authorization-message-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         encoded-message
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for decodeAuthorizationMessage"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :decode-authorization-message,
     :credentials credentials__1842__auto__,
     :client :securitytoken}))
  (clojure.core/defn
   decode-authorization-message
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         encoded-message
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call decodeAuthorizationMessage"}
   [credentials8481 & args8482]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client8483
     (com.palletops.awaze.common/aws-client
      :securitytoken
      credentials8481)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8483
      decodeAuthorizationMessage
      (securitytoken/decode-authorization-message-request
       (clojure.core/nth args8482 0)))))))
 (do
  (clojure.core/defmethod
   securitytoken
   :get-federation-token
   [m8484]
   (clojure.core/let
    [credentials8485 (:credentials m8484) args8486 (:args m8484)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client8487
      (com.palletops.awaze.common/aws-client
       :securitytoken
       credentials8485)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8487
       getFederationToken
       (securitytoken/get-federation-token-request
        (clojure.core/nth args8486 0)))))))
  (clojure.core/defn
   get-federation-token-map
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         policy
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getFederationToken"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-federation-token,
     :credentials credentials__1842__auto__,
     :client :securitytoken}))
  (clojure.core/defn
   get-federation-token
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         policy
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getFederationToken"}
   [credentials8489 & args8490]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client8491
     (com.palletops.awaze.common/aws-client
      :securitytoken
      credentials8489)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8491
      getFederationToken
      (securitytoken/get-federation-token-request
       (clojure.core/nth args8490 0)))))))
 (do
  (clojure.core/defmethod
   securitytoken
   :get-session-token
   [m8492]
   (clojure.core/let
    [credentials8493 (:credentials m8492) args8494 (:args m8492)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client8495
      (com.palletops.awaze.common/aws-client
       :securitytoken
       credentials8493)]
     (clojure.core/case
      (clojure.core/count args8494)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8495
        getSessionToken
        (securitytoken/get-session-token-request
         (clojure.core/nth args8494 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8495
        getSessionToken))))))
  (clojure.core/defn
   get-session-token-map
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         serial-number
                         custom-request-headers
                         sdk-client-execution-timeout
                         token-code
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for getSessionToken, getSessionToken"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-session-token,
     :credentials credentials__1842__auto__,
     :client :securitytoken})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-session-token,
     :credentials credentials__1842__auto__,
     :client :securitytoken}))
  (clojure.core/defn
   get-session-token
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         serial-number
                         custom-request-headers
                         sdk-client-execution-timeout
                         token-code
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call getSessionToken, getSessionToken"}
   [credentials8497 & args8498]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client8499
     (com.palletops.awaze.common/aws-client
      :securitytoken
      credentials8497)]
    (clojure.core/case
     (clojure.core/count args8498)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8499
       getSessionToken
       (securitytoken/get-session-token-request
        (clojure.core/nth args8498 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8499
       getSessionToken)))))))
