(ns
 com.palletops.awaze.s3
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.s3 :as s3]
  [com.palletops.awaze.beans.root :as root]
  [com.palletops.awaze.beans.metrics :as metrics]
  [com.palletops.awaze.beans.regions :as regions]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :s3
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.s3.AmazonS3Client
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.StorageClass}
storage-class
  [m13233]
  (.
   com.amazonaws.services.s3.model.StorageClass
   fromValue
   (clojure.core/name m13233)))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.CORSRule$AllowedMethods}
corsrule-allowed-methods
  [m13236]
  (.
   com.amazonaws.services.s3.model.CORSRule$AllowedMethods
   fromValue
   (clojure.core/name m13236)))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketLifecycleConfiguration$NoncurrentVersionTransition}
bucket-lifecycle-configuration-noncurrent-version-transition
  [m13239]
  (clojure.core/let
   [bean13238
    (new
     com.amazonaws.services.s3.model.BucketLifecycleConfiguration$NoncurrentVersionTransition)]
   (clojure.core/let
    [v13240
     (:storage-class m13239 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13240 :com.palletops.awaze.client-builder/undef)
     (. bean13238 setStorageClass (s3/storage-class v13240))))
   (clojure.core/let
    [v13240 (:days m13239 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13240 :com.palletops.awaze.client-builder/undef)
     (. bean13238 setDays (clojure.core/int v13240))))
   bean13238))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketLifecycleConfiguration$Transition}
bucket-lifecycle-configuration-transition
  [m13242]
  (clojure.core/let
   [bean13241
    (new
     com.amazonaws.services.s3.model.BucketLifecycleConfiguration$Transition)]
   (clojure.core/let
    [v13243 (:date m13242 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13243 :com.palletops.awaze.client-builder/undef)
     (. bean13241 setDate (com.palletops.awaze.common/to-date v13243))))
   (clojure.core/let
    [v13243
     (:storage-class m13242 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13243 :com.palletops.awaze.client-builder/undef)
     (. bean13241 setStorageClass (s3/storage-class v13243))))
   (clojure.core/let
    [v13243 (:days m13242 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13243 :com.palletops.awaze.client-builder/undef)
     (. bean13241 setDays (clojure.core/int v13243))))
   bean13241))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.AbortIncompleteMultipartUpload}
abort-incomplete-multipart-upload
  [m13245]
  (clojure.core/let
   [bean13244
    (new
     com.amazonaws.services.s3.model.AbortIncompleteMultipartUpload)]
   (clojure.core/let
    [v13246
     (:days-after-initiation
      m13245
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13246 :com.palletops.awaze.client-builder/undef)
     (. bean13244 setDaysAfterInitiation (clojure.core/int v13246))))
   bean13244))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.Owner}
owner
  [m13248]
  (clojure.core/let
   [bean13247 (new com.amazonaws.services.s3.model.Owner)]
   (clojure.core/let
    [v13249
     (:display-name m13248 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13249 :com.palletops.awaze.client-builder/undef)
     (. bean13247 setDisplayName (clojure.core/str v13249))))
   (clojure.core/let
    [v13249 (:id m13248 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13249 :com.palletops.awaze.client-builder/undef)
     (. bean13247 setId (clojure.core/str v13249))))
   bean13247))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ReplicationDestinationConfig}
replication-destination-config
  [m13251]
  (clojure.core/let
   [bean13250
    (new com.amazonaws.services.s3.model.ReplicationDestinationConfig)]
   (clojure.core/let
    [v13252
     (:storage-class m13251 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13252 :com.palletops.awaze.client-builder/undef)
     (. bean13250 setStorageClass (clojure.core/str v13252))))
   (clojure.core/let
    [v13252
     (:bucket-arn m13251 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13252 :com.palletops.awaze.client-builder/undef)
     (. bean13250 setBucketARN (clojure.core/str v13252))))
   bean13250))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.RedirectRule}
redirect-rule
  [m13254]
  (clojure.core/let
   [bean13253 (new com.amazonaws.services.s3.model.RedirectRule)]
   (clojure.core/let
    [v13255
     (:host-name m13254 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13255 :com.palletops.awaze.client-builder/undef)
     (. bean13253 setHostName (clojure.core/str v13255))))
   (clojure.core/let
    [v13255
     (:replace-key-prefix-with
      m13254
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13255 :com.palletops.awaze.client-builder/undef)
     (. bean13253 setReplaceKeyPrefixWith (clojure.core/str v13255))))
   (clojure.core/let
    [v13255
     (:replace-key-with
      m13254
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13255 :com.palletops.awaze.client-builder/undef)
     (. bean13253 setReplaceKeyWith (clojure.core/str v13255))))
   (clojure.core/let
    [v13255
     (:http-redirect-code
      m13254
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13255 :com.palletops.awaze.client-builder/undef)
     (. bean13253 setHttpRedirectCode (clojure.core/str v13255))))
   (clojure.core/let
    [v13255
     (:protocol m13254 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13255 :com.palletops.awaze.client-builder/undef)
     (. bean13253 setProtocol (clojure.core/str v13255))))
   bean13253))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.RoutingRuleCondition}
routing-rule-condition
  [m13257]
  (clojure.core/let
   [bean13256
    (new com.amazonaws.services.s3.model.RoutingRuleCondition)]
   (clojure.core/let
    [v13258
     (:key-prefix-equals
      m13257
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13258 :com.palletops.awaze.client-builder/undef)
     (. bean13256 setKeyPrefixEquals (clojure.core/str v13258))))
   (clojure.core/let
    [v13258
     (:http-error-code-returned-equals
      m13257
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13258 :com.palletops.awaze.client-builder/undef)
     (.
      bean13256
      setHttpErrorCodeReturnedEquals
      (clojure.core/str v13258))))
   bean13256))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.CORSRule}
corsrule
  [m13260]
  (clojure.core/let
   [bean13259 (new com.amazonaws.services.s3.model.CORSRule)]
   (clojure.core/let
    [v13261
     (:allowed-methods
      m13260
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13261 :com.palletops.awaze.client-builder/undef)
     (.
      bean13259
      setAllowedMethods
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13596] (s3/corsrule-allowed-methods arg13596))
 v13261))))
   (clojure.core/let
    [v13261
     (:allowed-origins
      m13260
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13261 :com.palletops.awaze.client-builder/undef)
     (.
      bean13259
      setAllowedOrigins
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13597] (clojure.core/str arg13597))
 v13261))))
   (clojure.core/let
    [v13261
     (:max-age-seconds
      m13260
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13261 :com.palletops.awaze.client-builder/undef)
     (. bean13259 setMaxAgeSeconds (clojure.core/int v13261))))
   (clojure.core/let
    [v13261
     (:exposed-headers
      m13260
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13261 :com.palletops.awaze.client-builder/undef)
     (.
      bean13259
      setExposedHeaders
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13598] (clojure.core/str arg13598))
 v13261))))
   (clojure.core/let
    [v13261
     (:allowed-headers
      m13260
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13261 :com.palletops.awaze.client-builder/undef)
     (.
      bean13259
      setAllowedHeaders
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13599] (clojure.core/str arg13599))
 v13261))))
   (clojure.core/let
    [v13261 (:id m13260 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13261 :com.palletops.awaze.client-builder/undef)
     (. bean13259 setId (clojure.core/str v13261))))
   bean13259))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketLifecycleConfiguration$Rule}
bucket-lifecycle-configuration-rule
  [m13263]
  (clojure.core/let
   [bean13262
    (new
     com.amazonaws.services.s3.model.BucketLifecycleConfiguration$Rule)]
   (clojure.core/let
    [v13264
     (:prefix m13263 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13264 :com.palletops.awaze.client-builder/undef)
     (. bean13262 setPrefix (clojure.core/str v13264))))
   (clojure.core/let
    [v13264
     (:noncurrent-version-transition
      m13263
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13264 :com.palletops.awaze.client-builder/undef)
     (.
      bean13262
      setNoncurrentVersionTransition
      (s3/bucket-lifecycle-configuration-noncurrent-version-transition
       v13264))))
   (clojure.core/let
    [v13264
     (:transitions m13263 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13264 :com.palletops.awaze.client-builder/undef)
     (.
      bean13262
      setTransitions
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg13600]
  (s3/bucket-lifecycle-configuration-transition arg13600))
 v13264))))
   (clojure.core/let
    [v13264
     (:abort-incomplete-multipart-upload
      m13263
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13264 :com.palletops.awaze.client-builder/undef)
     (.
      bean13262
      setAbortIncompleteMultipartUpload
      (s3/abort-incomplete-multipart-upload v13264))))
   (clojure.core/let
    [v13264 (:id m13263 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13264 :com.palletops.awaze.client-builder/undef)
     (. bean13262 setId (clojure.core/str v13264))))
   (clojure.core/let
    [v13264
     (:noncurrent-version-expiration-in-days
      m13263
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13264 :com.palletops.awaze.client-builder/undef)
     (.
      bean13262
      setNoncurrentVersionExpirationInDays
      (clojure.core/int v13264))))
   (clojure.core/let
    [v13264
     (:expiration-in-days
      m13263
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13264 :com.palletops.awaze.client-builder/undef)
     (. bean13262 setExpirationInDays (clojure.core/int v13264))))
   (clojure.core/let
    [v13264
     (:noncurrent-version-transitions
      m13263
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13264 :com.palletops.awaze.client-builder/undef)
     (.
      bean13262
      setNoncurrentVersionTransitions
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg13601]
  (s3/bucket-lifecycle-configuration-noncurrent-version-transition
   arg13601))
 v13264))))
   (clojure.core/let
    [v13264
     (:expiration-date
      m13263
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13264 :com.palletops.awaze.client-builder/undef)
     (.
      bean13262
      setExpirationDate
      (com.palletops.awaze.common/to-date v13264))))
   (clojure.core/let
    [v13264
     (:expired-object-delete-marker
      m13263
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13264 :com.palletops.awaze.client-builder/undef)
     (.
      bean13262
      setExpiredObjectDeleteMarker
      (clojure.core/boolean v13264))))
   (clojure.core/let
    [v13264
     (:transition m13263 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13264 :com.palletops.awaze.client-builder/undef)
     (.
      bean13262
      setTransition
      (s3/bucket-lifecycle-configuration-transition v13264))))
   (clojure.core/let
    [v13264
     (:status m13263 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13264 :com.palletops.awaze.client-builder/undef)
     (. bean13262 setStatus (clojure.core/str v13264))))
   bean13262))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketNotificationConfiguration$TopicConfiguration}
bucket-notification-configuration-topic-configuration
  [m13266]
  (clojure.core/let
   [arg13268
    nil
    arg13269
    nil
    bean13265
    (new
     com.amazonaws.services.s3.model.BucketNotificationConfiguration$TopicConfiguration
     arg13268
     arg13269)]
   bean13265))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.S3VersionSummary}
s3version-summary
  [m13271]
  (clojure.core/let
   [bean13270 (new com.amazonaws.services.s3.model.S3VersionSummary)]
   (clojure.core/let
    [v13272
     (:bucket-name m13271 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13272 :com.palletops.awaze.client-builder/undef)
     (. bean13270 setBucketName (clojure.core/str v13272))))
   (clojure.core/let
    [v13272 (:owner m13271 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13272 :com.palletops.awaze.client-builder/undef)
     (. bean13270 setOwner (s3/owner v13272))))
   (clojure.core/let
    [v13272
     (:storage-class m13271 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13272 :com.palletops.awaze.client-builder/undef)
     (. bean13270 setStorageClass (clojure.core/str v13272))))
   (clojure.core/let
    [v13272
     (:is-latest m13271 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13272 :com.palletops.awaze.client-builder/undef)
     (. bean13270 setIsLatest (clojure.core/boolean v13272))))
   (clojure.core/let
    [v13272
     (:last-modified m13271 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13272 :com.palletops.awaze.client-builder/undef)
     (.
      bean13270
      setLastModified
      (com.palletops.awaze.common/to-date v13272))))
   (clojure.core/let
    [v13272 (:key m13271 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13272 :com.palletops.awaze.client-builder/undef)
     (. bean13270 setKey (clojure.core/str v13272))))
   (clojure.core/let
    [v13272 (:etag m13271 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13272 :com.palletops.awaze.client-builder/undef)
     (. bean13270 setETag (clojure.core/str v13272))))
   (clojure.core/let
    [v13272 (:size m13271 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13272 :com.palletops.awaze.client-builder/undef)
     (. bean13270 setSize (clojure.core/long v13272))))
   (clojure.core/let
    [v13272
     (:version-id m13271 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13272 :com.palletops.awaze.client-builder/undef)
     (. bean13270 setVersionId (clojure.core/str v13272))))
   (clojure.core/let
    [v13272
     (:is-delete-marker
      m13271
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13272 :com.palletops.awaze.client-builder/undef)
     (. bean13270 setIsDeleteMarker (clojure.core/boolean v13272))))
   bean13270))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ReplicationRule}
replication-rule
  [m13274]
  (clojure.core/let
   [bean13273 (new com.amazonaws.services.s3.model.ReplicationRule)]
   (clojure.core/let
    [v13275
     (:destination-config
      m13274
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13275 :com.palletops.awaze.client-builder/undef)
     (.
      bean13273
      setDestinationConfig
      (s3/replication-destination-config v13275))))
   (clojure.core/let
    [v13275
     (:status m13274 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13275 :com.palletops.awaze.client-builder/undef)
     (. bean13273 setStatus (clojure.core/str v13275))))
   (clojure.core/let
    [v13275
     (:prefix m13274 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13275 :com.palletops.awaze.client-builder/undef)
     (. bean13273 setPrefix (clojure.core/str v13275))))
   bean13273))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.TagSet}
tag-set
  [m13277]
  (clojure.core/let
   [bean13276 (new com.amazonaws.services.s3.model.TagSet)]
   bean13276))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.RoutingRule}
routing-rule
  [m13280]
  (clojure.core/let
   [bean13279 (new com.amazonaws.services.s3.model.RoutingRule)]
   (clojure.core/let
    [v13281
     (:redirect m13280 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13281 :com.palletops.awaze.client-builder/undef)
     (. bean13279 setRedirect (s3/redirect-rule v13281))))
   (clojure.core/let
    [v13281
     (:condition m13280 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13281 :com.palletops.awaze.client-builder/undef)
     (. bean13279 setCondition (s3/routing-rule-condition v13281))))
   bean13279))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SSECustomerKey}
ssecustomer-key
  [m13283]
  (clojure.core/let
   [^{:tag java.lang.String}
    arg13285
    nil
    bean13282
    (new
     com.amazonaws.services.s3.model.SSECustomerKey
^{:tag java.lang.String}
arg13285)]
   (clojure.core/let
    [v13284 (:md5 m13283 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13284 :com.palletops.awaze.client-builder/undef)
     (. bean13282 setMd5 (clojure.core/str v13284))))
   (clojure.core/let
    [v13284
     (:algorithm m13283 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13284 :com.palletops.awaze.client-builder/undef)
     (. bean13282 setAlgorithm (clojure.core/str v13284))))
   bean13282))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketCrossOriginConfiguration}
bucket-cross-origin-configuration
  [m13287]
  (clojure.core/let
   [bean13286
    (new
     com.amazonaws.services.s3.model.BucketCrossOriginConfiguration)]
   (clojure.core/let
    [v13288 (:rules m13287 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13288 :com.palletops.awaze.client-builder/undef)
     (.
      bean13286
      setRules
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13602] (s3/corsrule arg13602))
 v13288))))
   bean13286))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketLifecycleConfiguration}
bucket-lifecycle-configuration
  [m13290]
  (clojure.core/let
   [bean13289
    (new com.amazonaws.services.s3.model.BucketLifecycleConfiguration)]
   (clojure.core/let
    [v13291 (:rules m13290 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13291 :com.palletops.awaze.client-builder/undef)
     (.
      bean13289
      setRules
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg13603]
  (s3/bucket-lifecycle-configuration-rule arg13603))
 v13291))))
   bean13289))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketNotificationConfiguration}
bucket-notification-configuration
  [m13293]
  (clojure.core/let
   [bean13292
    (new
     com.amazonaws.services.s3.model.BucketNotificationConfiguration)]
   (clojure.core/let
    [v13294
     (:topic-configurations
      m13293
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13294 :com.palletops.awaze.client-builder/undef)
     (.
      bean13292
      setTopicConfigurations
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg13604]
  (s3/bucket-notification-configuration-topic-configuration arg13604))
 v13294))))
   (clojure.core/let
    [v13294
     (:configurations
      m13293
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13294 :com.palletops.awaze.client-builder/undef)
     (.
      bean13292
      setConfigurations
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg13605] (clojure.core/str arg13605))
  (clojure.core/keys v13294))
 (clojure.core/map
  (clojure.core/fn [arg13605] arg13605)
  (clojure.core/vals v13294))))))
   bean13292))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.VersionListing}
version-listing
  [m13296]
  (clojure.core/let
   [bean13295 (new com.amazonaws.services.s3.model.VersionListing)]
   (clojure.core/let
    [v13297
     (:prefix m13296 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13297 :com.palletops.awaze.client-builder/undef)
     (. bean13295 setPrefix (clojure.core/str v13297))))
   (clojure.core/let
    [v13297
     (:next-version-id-marker
      m13296
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13297 :com.palletops.awaze.client-builder/undef)
     (. bean13295 setNextVersionIdMarker (clojure.core/str v13297))))
   (clojure.core/let
    [v13297
     (:version-summaries
      m13296
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13297 :com.palletops.awaze.client-builder/undef)
     (.
      bean13295
      setVersionSummaries
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13606] (s3/s3version-summary arg13606))
 v13297))))
   (clojure.core/let
    [v13297
     (:bucket-name m13296 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13297 :com.palletops.awaze.client-builder/undef)
     (. bean13295 setBucketName (clojure.core/str v13297))))
   (clojure.core/let
    [v13297
     (:encoding-type m13296 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13297 :com.palletops.awaze.client-builder/undef)
     (. bean13295 setEncodingType (clojure.core/str v13297))))
   (clojure.core/let
    [v13297
     (:next-key-marker
      m13296
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13297 :com.palletops.awaze.client-builder/undef)
     (. bean13295 setNextKeyMarker (clojure.core/str v13297))))
   (clojure.core/let
    [v13297
     (:max-keys m13296 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13297 :com.palletops.awaze.client-builder/undef)
     (. bean13295 setMaxKeys (clojure.core/int v13297))))
   (clojure.core/let
    [v13297
     (:truncated m13296 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13297 :com.palletops.awaze.client-builder/undef)
     (. bean13295 setTruncated (clojure.core/boolean v13297))))
   (clojure.core/let
    [v13297
     (:version-id-marker
      m13296
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13297 :com.palletops.awaze.client-builder/undef)
     (. bean13295 setVersionIdMarker (clojure.core/str v13297))))
   (clojure.core/let
    [v13297
     (:common-prefixes
      m13296
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13297 :com.palletops.awaze.client-builder/undef)
     (.
      bean13295
      setCommonPrefixes
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13607] (clojure.core/str arg13607))
 v13297))))
   (clojure.core/let
    [v13297
     (:key-marker m13296 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13297 :com.palletops.awaze.client-builder/undef)
     (. bean13295 setKeyMarker (clojure.core/str v13297))))
   (clojure.core/let
    [v13297
     (:delimiter m13296 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13297 :com.palletops.awaze.client-builder/undef)
     (. bean13295 setDelimiter (clojure.core/str v13297))))
   bean13295))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SSEAlgorithm}
ssealgorithm
  [m13299]
  (java.lang.Enum/valueOf
   com.amazonaws.services.s3.model.SSEAlgorithm
   (clojure.core/name m13299)))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ResponseHeaderOverrides}
response-header-overrides
  [m13302]
  (clojure.core/let
   [bean13301
    (new com.amazonaws.services.s3.model.ResponseHeaderOverrides)]
   (clojure.core/let
    [v13303
     (:content-type m13302 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13303 :com.palletops.awaze.client-builder/undef)
     (. bean13301 setContentType (clojure.core/str v13303))))
   (clojure.core/let
    [v13303
     (:content-encoding
      m13302
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13303 :com.palletops.awaze.client-builder/undef)
     (. bean13301 setContentEncoding (clojure.core/str v13303))))
   (clojure.core/let
    [v13303
     (:cache-control m13302 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13303 :com.palletops.awaze.client-builder/undef)
     (. bean13301 setCacheControl (clojure.core/str v13303))))
   (clojure.core/let
    [v13303
     (:content-disposition
      m13302
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13303 :com.palletops.awaze.client-builder/undef)
     (. bean13301 setContentDisposition (clojure.core/str v13303))))
   (clojure.core/let
    [v13303
     (:content-language
      m13302
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13303 :com.palletops.awaze.client-builder/undef)
     (. bean13301 setContentLanguage (clojure.core/str v13303))))
   (clojure.core/let
    [v13303
     (:expires m13302 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13303 :com.palletops.awaze.client-builder/undef)
     (. bean13301 setExpires (clojure.core/str v13303))))
   bean13301))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
canned-access-control-list
  [m13305]
  (java.lang.Enum/valueOf
   com.amazonaws.services.s3.model.CannedAccessControlList
   (clojure.core/name m13305)))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.AccessControlList}
access-control-list
  [m13308]
  (clojure.core/let
   [bean13307 (new com.amazonaws.services.s3.model.AccessControlList)]
   (clojure.core/let
    [v13309 (:owner m13308 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13309 :com.palletops.awaze.client-builder/undef)
     (. bean13307 setOwner (s3/owner v13309))))
   (clojure.core/let
    [v13309
     (:requester-charged
      m13308
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13309 :com.palletops.awaze.client-builder/undef)
     (. bean13307 setRequesterCharged (clojure.core/boolean v13309))))
   bean13307))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SSEAwsKeyManagementParams}
sseaws-key-management-params
  [m13311]
  (clojure.core/let
   [bean13310
    (new com.amazonaws.services.s3.model.SSEAwsKeyManagementParams)]
   bean13310))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ObjectMetadata}
object-metadata
  [m13314]
  (clojure.core/let
   [bean13313 (new com.amazonaws.services.s3.model.ObjectMetadata)]
   (clojure.core/let
    [v13315
     (:content-encoding
      m13314
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13315 :com.palletops.awaze.client-builder/undef)
     (. bean13313 setContentEncoding (clojure.core/str v13315))))
   (clojure.core/let
    [v13315
     (:expiration-time-rule-id
      m13314
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13315 :com.palletops.awaze.client-builder/undef)
     (. bean13313 setExpirationTimeRuleId (clojure.core/str v13315))))
   (clojure.core/let
    [v13315
     (:cache-control m13314 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13315 :com.palletops.awaze.client-builder/undef)
     (. bean13313 setCacheControl (clojure.core/str v13315))))
   (clojure.core/let
    [v13315
     (:requester-charged
      m13314
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13315 :com.palletops.awaze.client-builder/undef)
     (. bean13313 setRequesterCharged (clojure.core/boolean v13315))))
   (clojure.core/let
    [v13315
     (:restore-expiration-time
      m13314
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13315 :com.palletops.awaze.client-builder/undef)
     (.
      bean13313
      setRestoreExpirationTime
      (com.palletops.awaze.common/to-date v13315))))
   (clojure.core/let
    [v13315
     (:content-type m13314 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13315 :com.palletops.awaze.client-builder/undef)
     (. bean13313 setContentType (clojure.core/str v13315))))
   (clojure.core/let
    [v13315
     (:content-length
      m13314
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13315 :com.palletops.awaze.client-builder/undef)
     (. bean13313 setContentLength (clojure.core/long v13315))))
   (clojure.core/let
    [v13315
     (:ssecustomer-key-md5
      m13314
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13315 :com.palletops.awaze.client-builder/undef)
     (. bean13313 setSSECustomerKeyMd5 (clojure.core/str v13315))))
   (clojure.core/let
    [v13315
     (:ongoing-restore
      m13314
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13315 :com.palletops.awaze.client-builder/undef)
     (. bean13313 setOngoingRestore (clojure.core/boolean v13315))))
   (clojure.core/let
    [v13315
     (:expiration-time
      m13314
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13315 :com.palletops.awaze.client-builder/undef)
     (.
      bean13313
      setExpirationTime
      (com.palletops.awaze.common/to-date v13315))))
   (clojure.core/let
    [v13315
     (:user-metadata m13314 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13315 :com.palletops.awaze.client-builder/undef)
     (.
      bean13313
      setUserMetadata
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg13608] (clojure.core/str arg13608))
  (clojure.core/keys v13315))
 (clojure.core/map
  (clojure.core/fn [arg13608] (clojure.core/str arg13608))
  (clojure.core/vals v13315))))))
   (clojure.core/let
    [v13315
     (:last-modified m13314 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13315 :com.palletops.awaze.client-builder/undef)
     (.
      bean13313
      setLastModified
      (com.palletops.awaze.common/to-date v13315))))
   (clojure.core/let
    [v13315
     (:content-md5 m13314 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13315 :com.palletops.awaze.client-builder/undef)
     (. bean13313 setContentMD5 (clojure.core/str v13315))))
   (clojure.core/let
    [v13315
     (:content-disposition
      m13314
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13315 :com.palletops.awaze.client-builder/undef)
     (. bean13313 setContentDisposition (clojure.core/str v13315))))
   (clojure.core/let
    [v13315
     (:server-side-encryption
      m13314
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13315 :com.palletops.awaze.client-builder/undef)
     (. bean13313 setServerSideEncryption (clojure.core/str v13315))))
   (clojure.core/let
    [v13315
     (:ssealgorithm m13314 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13315 :com.palletops.awaze.client-builder/undef)
     (. bean13313 setSSEAlgorithm (clojure.core/str v13315))))
   (clojure.core/let
    [v13315
     (:ssecustomer-algorithm
      m13314
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13315 :com.palletops.awaze.client-builder/undef)
     (. bean13313 setSSECustomerAlgorithm (clojure.core/str v13315))))
   (clojure.core/let
    [v13315
     (:http-expires-date
      m13314
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13315 :com.palletops.awaze.client-builder/undef)
     (.
      bean13313
      setHttpExpiresDate
      (com.palletops.awaze.common/to-date v13315))))
   bean13313))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.MultiFactorAuthentication}
multi-factor-authentication
  [m13317]
  (clojure.core/let
   [arg13319
    nil
    arg13320
    nil
    bean13316
    (new
     com.amazonaws.services.s3.model.MultiFactorAuthentication
     arg13319
     arg13320)]
   (clojure.core/let
    [v13318
     (:device-serial-number
      m13317
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13318 :com.palletops.awaze.client-builder/undef)
     (. bean13316 setDeviceSerialNumber (clojure.core/str v13318))))
   (clojure.core/let
    [v13318 (:token m13317 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13318 :com.palletops.awaze.client-builder/undef)
     (. bean13316 setToken (clojure.core/str v13318))))
   bean13316))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteObjectsRequest$KeyVersion}
delete-objects-request-key-version
  [m13322]
  (clojure.core/let
   [arg13324
    nil
    bean13321
    (new
     com.amazonaws.services.s3.model.DeleteObjectsRequest$KeyVersion
     arg13324)]
   bean13321))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketVersioningConfiguration}
bucket-versioning-configuration
  [m13326]
  (clojure.core/let
   [bean13325
    (new
     com.amazonaws.services.s3.model.BucketVersioningConfiguration)]
   (clojure.core/let
    [v13327
     (:mfa-delete-enabled
      m13326
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13327 :com.palletops.awaze.client-builder/undef)
     (. bean13325 setMfaDeleteEnabled (clojure.core/boolean v13327))))
   (clojure.core/let
    [v13327
     (:status m13326 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13327 :com.palletops.awaze.client-builder/undef)
     (. bean13325 setStatus (clojure.core/str v13327))))
   bean13325))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketLoggingConfiguration}
bucket-logging-configuration
  [m13329]
  (clojure.core/let
   [bean13328
    (new com.amazonaws.services.s3.model.BucketLoggingConfiguration)]
   (clojure.core/let
    [v13330
     (:destination-bucket-name
      m13329
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13330 :com.palletops.awaze.client-builder/undef)
     (. bean13328 setDestinationBucketName (clojure.core/str v13330))))
   (clojure.core/let
    [v13330
     (:log-file-prefix
      m13329
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13330 :com.palletops.awaze.client-builder/undef)
     (. bean13328 setLogFilePrefix (clojure.core/str v13330))))
   bean13328))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.S3ObjectId}
s3object-id
  [m13332]
  (clojure.core/let
   [arg13334
    nil
    arg13335
    nil
    bean13331
    (new com.amazonaws.services.s3.model.S3ObjectId arg13334 arg13335)]
   bean13331))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.PartETag}
part-etag
  [m13337]
  (clojure.core/let
   [arg13339
    0
    arg13340
    nil
    bean13336
    (new com.amazonaws.services.s3.model.PartETag arg13339 arg13340)]
   (clojure.core/let
    [v13338 (:etag m13337 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13338 :com.palletops.awaze.client-builder/undef)
     (. bean13336 setETag (clojure.core/str v13338))))
   (clojure.core/let
    [v13338
     (:part-number m13337 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13338 :com.palletops.awaze.client-builder/undef)
     (. bean13336 setPartNumber (clojure.core/int v13338))))
   bean13336))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketReplicationConfiguration}
bucket-replication-configuration
  [m13342]
  (clojure.core/let
   [bean13341
    (new
     com.amazonaws.services.s3.model.BucketReplicationConfiguration)]
   (clojure.core/let
    [v13343 (:rules m13342 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13343 :com.palletops.awaze.client-builder/undef)
     (.
      bean13341
      setRules
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg13609] (clojure.core/str arg13609))
  (clojure.core/keys v13343))
 (clojure.core/map
  (clojure.core/fn [arg13609] (s3/replication-rule arg13609))
  (clojure.core/vals v13343))))))
   (clojure.core/let
    [v13343
     (:role-arn m13342 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13343 :com.palletops.awaze.client-builder/undef)
     (. bean13341 setRoleARN (clojure.core/str v13343))))
   bean13341))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketTaggingConfiguration}
bucket-tagging-configuration
  [m13345]
  (clojure.core/let
   [bean13344
    (new com.amazonaws.services.s3.model.BucketTaggingConfiguration)]
   (clojure.core/let
    [v13346
     (:tag-sets m13345 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13346 :com.palletops.awaze.client-builder/undef)
     (.
      bean13344
      setTagSets
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg13610] (s3/tag-set arg13610))
 v13346))))
   bean13344))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ObjectListing}
object-listing
  [m13348]
  (clojure.core/let
   [bean13347 (new com.amazonaws.services.s3.model.ObjectListing)]
   (clojure.core/let
    [v13349
     (:prefix m13348 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13349 :com.palletops.awaze.client-builder/undef)
     (. bean13347 setPrefix (clojure.core/str v13349))))
   (clojure.core/let
    [v13349
     (:bucket-name m13348 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13349 :com.palletops.awaze.client-builder/undef)
     (. bean13347 setBucketName (clojure.core/str v13349))))
   (clojure.core/let
    [v13349
     (:encoding-type m13348 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13349 :com.palletops.awaze.client-builder/undef)
     (. bean13347 setEncodingType (clojure.core/str v13349))))
   (clojure.core/let
    [v13349
     (:max-keys m13348 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13349 :com.palletops.awaze.client-builder/undef)
     (. bean13347 setMaxKeys (clojure.core/int v13349))))
   (clojure.core/let
    [v13349
     (:marker m13348 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13349 :com.palletops.awaze.client-builder/undef)
     (. bean13347 setMarker (clojure.core/str v13349))))
   (clojure.core/let
    [v13349
     (:next-marker m13348 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13349 :com.palletops.awaze.client-builder/undef)
     (. bean13347 setNextMarker (clojure.core/str v13349))))
   (clojure.core/let
    [v13349
     (:truncated m13348 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13349 :com.palletops.awaze.client-builder/undef)
     (. bean13347 setTruncated (clojure.core/boolean v13349))))
   (clojure.core/let
    [v13349
     (:common-prefixes
      m13348
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13349 :com.palletops.awaze.client-builder/undef)
     (.
      bean13347
      setCommonPrefixes
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13611] (clojure.core/str arg13611))
 v13349))))
   (clojure.core/let
    [v13349
     (:delimiter m13348 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13349 :com.palletops.awaze.client-builder/undef)
     (. bean13347 setDelimiter (clojure.core/str v13349))))
   bean13347))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketWebsiteConfiguration}
bucket-website-configuration
  [m13351]
  (clojure.core/let
   [bean13350
    (new com.amazonaws.services.s3.model.BucketWebsiteConfiguration)]
   (clojure.core/let
    [v13352
     (:error-document
      m13351
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13352 :com.palletops.awaze.client-builder/undef)
     (. bean13350 setErrorDocument (clojure.core/str v13352))))
   (clojure.core/let
    [v13352
     (:redirect-all-requests-to
      m13351
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13352 :com.palletops.awaze.client-builder/undef)
     (. bean13350 setRedirectAllRequestsTo (s3/redirect-rule v13352))))
   (clojure.core/let
    [v13352
     (:routing-rules m13351 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13352 :com.palletops.awaze.client-builder/undef)
     (.
      bean13350
      setRoutingRules
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13612] (s3/routing-rule arg13612))
 v13352))))
   (clojure.core/let
    [v13352
     (:index-document-suffix
      m13351
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13352 :com.palletops.awaze.client-builder/undef)
     (. bean13350 setIndexDocumentSuffix (clojure.core/str v13352))))
   bean13350))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteBucketWebsiteConfigurationRequest}
delete-bucket-website-configuration-request
  [m13354]
  (clojure.core/let
   [arg13356
    nil
    bean13353
    (new
     com.amazonaws.services.s3.model.DeleteBucketWebsiteConfigurationRequest
     arg13356)]
   bean13353))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetObjectAclRequest}
set-object-acl-request
  [m13358]
  (clojure.core/let
   [^{:tag java.lang.String}
    arg13360
    nil
^{:tag java.lang.String}
arg13361
    nil
^{:tag com.amazonaws.services.s3.model.AccessControlList}
arg13362
    (access-control-list {})
    bean13357
    (new
     com.amazonaws.services.s3.model.SetObjectAclRequest
^{:tag java.lang.String}
arg13360
^{:tag java.lang.String}
arg13361
^{:tag com.amazonaws.services.s3.model.AccessControlList}
arg13362)]
   (clojure.core/let
    [v13359
     (:requester-pays
      m13358
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13359 :com.palletops.awaze.client-builder/undef)
     (. bean13357 setRequesterPays (clojure.core/boolean v13359))))
   bean13357))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetBucketLifecycleConfigurationRequest}
get-bucket-lifecycle-configuration-request
  [m13364]
  (clojure.core/let
   [arg13366
    nil
    bean13363
    (new
     com.amazonaws.services.s3.model.GetBucketLifecycleConfigurationRequest
     arg13366)]
   bean13363))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ListMultipartUploadsRequest}
list-multipart-uploads-request
  [m13368]
  (clojure.core/let
   [arg13370
    nil
    bean13367
    (new
     com.amazonaws.services.s3.model.ListMultipartUploadsRequest
     arg13370)]
   (clojure.core/let
    [v13369
     (:max-uploads m13368 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13369 :com.palletops.awaze.client-builder/undef)
     (. bean13367 setMaxUploads (clojure.core/int v13369))))
   (clojure.core/let
    [v13369
     (:delimiter m13368 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13369 :com.palletops.awaze.client-builder/undef)
     (. bean13367 setDelimiter (clojure.core/str v13369))))
   (clojure.core/let
    [v13369
     (:key-marker m13368 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13369 :com.palletops.awaze.client-builder/undef)
     (. bean13367 setKeyMarker (clojure.core/str v13369))))
   (clojure.core/let
    [v13369
     (:encoding-type m13368 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13369 :com.palletops.awaze.client-builder/undef)
     (. bean13367 setEncodingType (clojure.core/str v13369))))
   (clojure.core/let
    [v13369
     (:prefix m13368 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13369 :com.palletops.awaze.client-builder/undef)
     (. bean13367 setPrefix (clojure.core/str v13369))))
   (clojure.core/let
    [v13369
     (:bucket-name m13368 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13369 :com.palletops.awaze.client-builder/undef)
     (. bean13367 setBucketName (clojure.core/str v13369))))
   (clojure.core/let
    [v13369
     (:upload-id-marker
      m13368
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13369 :com.palletops.awaze.client-builder/undef)
     (. bean13367 setUploadIdMarker (clojure.core/str v13369))))
   bean13367))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetObjectMetadataRequest}
get-object-metadata-request
  [m13372]
  (clojure.core/let
   [arg13374
    nil
    arg13375
    nil
    bean13371
    (new
     com.amazonaws.services.s3.model.GetObjectMetadataRequest
     arg13374
     arg13375)]
   (clojure.core/let
    [v13373 (:key m13372 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13373 :com.palletops.awaze.client-builder/undef)
     (. bean13371 setKey (clojure.core/str v13373))))
   (clojure.core/let
    [v13373
     (:version-id m13372 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13373 :com.palletops.awaze.client-builder/undef)
     (. bean13371 setVersionId (clojure.core/str v13373))))
   (clojure.core/let
    [v13373
     (:ssecustomer-key
      m13372
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13373 :com.palletops.awaze.client-builder/undef)
     (. bean13371 setSSECustomerKey (s3/ssecustomer-key v13373))))
   (clojure.core/let
    [v13373
     (:requester-pays
      m13372
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13373 :com.palletops.awaze.client-builder/undef)
     (. bean13371 setRequesterPays (clojure.core/boolean v13373))))
   (clojure.core/let
    [v13373
     (:bucket-name m13372 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13373 :com.palletops.awaze.client-builder/undef)
     (. bean13371 setBucketName (clojure.core/str v13373))))
   bean13371))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketCrossOriginConfigurationRequest}
set-bucket-cross-origin-configuration-request
  [m13377]
  (clojure.core/let
   [arg13379
    nil
    arg13380
    (bucket-cross-origin-configuration {})
    bean13376
    (new
     com.amazonaws.services.s3.model.SetBucketCrossOriginConfigurationRequest
     arg13379
     arg13380)]
   (clojure.core/let
    [v13378
     (:cross-origin-configuration
      m13377
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13378 :com.palletops.awaze.client-builder/undef)
     (.
      bean13376
      setCrossOriginConfiguration
      (s3/bucket-cross-origin-configuration v13378))))
   (clojure.core/let
    [v13378
     (:bucket-name m13377 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13378 :com.palletops.awaze.client-builder/undef)
     (. bean13376 setBucketName (clojure.core/str v13378))))
   bean13376))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteBucketReplicationConfigurationRequest}
delete-bucket-replication-configuration-request
  [m13382]
  (clojure.core/let
   [arg13384
    nil
    bean13381
    (new
     com.amazonaws.services.s3.model.DeleteBucketReplicationConfigurationRequest
     arg13384)]
   bean13381))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketLifecycleConfigurationRequest}
set-bucket-lifecycle-configuration-request
  [m13386]
  (clojure.core/let
   [arg13388
    nil
    arg13389
    (bucket-lifecycle-configuration {})
    bean13385
    (new
     com.amazonaws.services.s3.model.SetBucketLifecycleConfigurationRequest
     arg13388
     arg13389)]
   (clojure.core/let
    [v13387
     (:lifecycle-configuration
      m13386
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13387 :com.palletops.awaze.client-builder/undef)
     (.
      bean13385
      setLifecycleConfiguration
      (s3/bucket-lifecycle-configuration v13387))))
   (clojure.core/let
    [v13387
     (:bucket-name m13386 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13387 :com.palletops.awaze.client-builder/undef)
     (. bean13385 setBucketName (clojure.core/str v13387))))
   bean13385))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketNotificationConfigurationRequest}
set-bucket-notification-configuration-request
  [m13391]
  (clojure.core/let
   [^{:tag java.lang.String}
    arg13393
    nil
^{:tag com.amazonaws.services.s3.model.BucketNotificationConfiguration}
arg13394
    (bucket-notification-configuration {})
    bean13390
    (new
     com.amazonaws.services.s3.model.SetBucketNotificationConfigurationRequest
^{:tag java.lang.String}
arg13393
^{:tag com.amazonaws.services.s3.model.BucketNotificationConfiguration}
arg13394)]
   (clojure.core/let
    [v13392
     (:notification-configuration
      m13391
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13392 :com.palletops.awaze.client-builder/undef)
     (.
      bean13390
      setNotificationConfiguration
      (s3/bucket-notification-configuration v13392))))
   (clojure.core/let
    [v13392
     (:bucket-notification-configuration
      m13391
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13392 :com.palletops.awaze.client-builder/undef)
     (.
      bean13390
      setBucketNotificationConfiguration
      (s3/bucket-notification-configuration v13392))))
   (clojure.core/let
    [v13392
     (:bucket m13391 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13392 :com.palletops.awaze.client-builder/undef)
     (. bean13390 setBucket (clojure.core/str v13392))))
   (clojure.core/let
    [v13392
     (:bucket-name m13391 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13392 :com.palletops.awaze.client-builder/undef)
     (. bean13390 setBucketName (clojure.core/str v13392))))
   bean13390))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteBucketPolicyRequest}
delete-bucket-policy-request
  [m13396]
  (clojure.core/let
   [arg13398
    nil
    bean13395
    (new
     com.amazonaws.services.s3.model.DeleteBucketPolicyRequest
     arg13398)]
   (clojure.core/let
    [v13397
     (:bucket-name m13396 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13397 :com.palletops.awaze.client-builder/undef)
     (. bean13395 setBucketName (clojure.core/str v13397))))
   bean13395))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.HeadBucketRequest}
head-bucket-request
  [m13400]
  (clojure.core/let
   [arg13402
    nil
    bean13399
    (new com.amazonaws.services.s3.model.HeadBucketRequest arg13402)]
   (clojure.core/let
    [v13401
     (:bucket-name m13400 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13401 :com.palletops.awaze.client-builder/undef)
     (. bean13399 setBucketName (clojure.core/str v13401))))
   bean13399))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.S3ClientOptions}
s3client-options
  [m13404]
  (clojure.core/let
   [bean13403 (new com.amazonaws.services.s3.S3ClientOptions)]
   (clojure.core/let
    [v13405
     (:path-style-access
      m13404
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13405 :com.palletops.awaze.client-builder/undef)
     (. bean13403 setPathStyleAccess (clojure.core/boolean v13405))))
   (clojure.core/let
    [v13405
     (:chunked-encoding-disabled
      m13404
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13405 :com.palletops.awaze.client-builder/undef)
     (.
      bean13403
      setChunkedEncodingDisabled
      (clojure.core/boolean v13405))))
   bean13403))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetBucketNotificationConfigurationRequest}
get-bucket-notification-configuration-request
  [m13407]
  (clojure.core/let
   [arg13409
    nil
    bean13406
    (new
     com.amazonaws.services.s3.model.GetBucketNotificationConfigurationRequest
     arg13409)]
   bean13406))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteBucketLifecycleConfigurationRequest}
delete-bucket-lifecycle-configuration-request
  [m13411]
  (clojure.core/let
   [arg13413
    nil
    bean13410
    (new
     com.amazonaws.services.s3.model.DeleteBucketLifecycleConfigurationRequest
     arg13413)]
   bean13410))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ListObjectsRequest}
list-objects-request
  [m13415]
  (clojure.core/let
   [bean13414
    (new com.amazonaws.services.s3.model.ListObjectsRequest)]
   (clojure.core/let
    [v13416
     (:delimiter m13415 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13416 :com.palletops.awaze.client-builder/undef)
     (. bean13414 setDelimiter (clojure.core/str v13416))))
   (clojure.core/let
    [v13416
     (:max-keys m13415 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13416 :com.palletops.awaze.client-builder/undef)
     (. bean13414 setMaxKeys (clojure.core/int v13416))))
   (clojure.core/let
    [v13416
     (:encoding-type m13415 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13416 :com.palletops.awaze.client-builder/undef)
     (. bean13414 setEncodingType (clojure.core/str v13416))))
   (clojure.core/let
    [v13416
     (:prefix m13415 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13416 :com.palletops.awaze.client-builder/undef)
     (. bean13414 setPrefix (clojure.core/str v13416))))
   (clojure.core/let
    [v13416
     (:marker m13415 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13416 :com.palletops.awaze.client-builder/undef)
     (. bean13414 setMarker (clojure.core/str v13416))))
   (clojure.core/let
    [v13416
     (:bucket-name m13415 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13416 :com.palletops.awaze.client-builder/undef)
     (. bean13414 setBucketName (clojure.core/str v13416))))
   bean13414))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.AbortMultipartUploadRequest}
abort-multipart-upload-request
  [m13418]
  (clojure.core/let
   [arg13420
    nil
    arg13421
    nil
    arg13422
    nil
    bean13417
    (new
     com.amazonaws.services.s3.model.AbortMultipartUploadRequest
     arg13420
     arg13421
     arg13422)]
   (clojure.core/let
    [v13419 (:key m13418 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13419 :com.palletops.awaze.client-builder/undef)
     (. bean13417 setKey (clojure.core/str v13419))))
   (clojure.core/let
    [v13419
     (:requester-pays
      m13418
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13419 :com.palletops.awaze.client-builder/undef)
     (. bean13417 setRequesterPays (clojure.core/boolean v13419))))
   (clojure.core/let
    [v13419
     (:upload-id m13418 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13419 :com.palletops.awaze.client-builder/undef)
     (. bean13417 setUploadId (clojure.core/str v13419))))
   (clojure.core/let
    [v13419
     (:bucket-name m13418 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13419 :com.palletops.awaze.client-builder/undef)
     (. bean13417 setBucketName (clojure.core/str v13419))))
   bean13417))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetS3AccountOwnerRequest}
get-s3account-owner-request
  [m13424]
  (clojure.core/let
   [bean13423
    (new com.amazonaws.services.s3.model.GetS3AccountOwnerRequest)]
   bean13423))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ListBucketsRequest}
list-buckets-request
  [m13427]
  (clojure.core/let
   [bean13426
    (new com.amazonaws.services.s3.model.ListBucketsRequest)]
   bean13426))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetBucketWebsiteConfigurationRequest}
get-bucket-website-configuration-request
  [m13430]
  (clojure.core/let
   [arg13432
    nil
    bean13429
    (new
     com.amazonaws.services.s3.model.GetBucketWebsiteConfigurationRequest
     arg13432)]
   (clojure.core/let
    [v13431
     (:bucket-name m13430 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13431 :com.palletops.awaze.client-builder/undef)
     (. bean13429 setBucketName (clojure.core/str v13431))))
   bean13429))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ListPartsRequest}
list-parts-request
  [m13434]
  (clojure.core/let
   [arg13436
    nil
    arg13437
    nil
    arg13438
    nil
    bean13433
    (new
     com.amazonaws.services.s3.model.ListPartsRequest
     arg13436
     arg13437
     arg13438)]
   (clojure.core/let
    [v13435 (:key m13434 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13435 :com.palletops.awaze.client-builder/undef)
     (. bean13433 setKey (clojure.core/str v13435))))
   (clojure.core/let
    [v13435
     (:requester-pays
      m13434
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13435 :com.palletops.awaze.client-builder/undef)
     (. bean13433 setRequesterPays (clojure.core/boolean v13435))))
   (clojure.core/let
    [v13435
     (:max-parts m13434 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13435 :com.palletops.awaze.client-builder/undef)
     (. bean13433 setMaxParts (clojure.core/int v13435))))
   (clojure.core/let
    [v13435
     (:part-number-marker
      m13434
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13435 :com.palletops.awaze.client-builder/undef)
     (. bean13433 setPartNumberMarker (clojure.core/int v13435))))
   (clojure.core/let
    [v13435
     (:encoding-type m13434 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13435 :com.palletops.awaze.client-builder/undef)
     (. bean13433 setEncodingType (clojure.core/str v13435))))
   (clojure.core/let
    [v13435
     (:upload-id m13434 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13435 :com.palletops.awaze.client-builder/undef)
     (. bean13433 setUploadId (clojure.core/str v13435))))
   (clojure.core/let
    [v13435
     (:bucket-name m13434 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13435 :com.palletops.awaze.client-builder/undef)
     (. bean13433 setBucketName (clojure.core/str v13435))))
   bean13433))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketAclRequest}
set-bucket-acl-request
  [m13440]
  (clojure.core/let
   [^{:tag java.lang.String}
    arg13442
    nil
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
arg13443
    (canned-access-control-list {})
    bean13439
    (new
     com.amazonaws.services.s3.model.SetBucketAclRequest
^{:tag java.lang.String}
arg13442
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
arg13443)]
   bean13439))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.CopyPartRequest}
copy-part-request
  [m13445]
  (clojure.core/let
   [bean13444 (new com.amazonaws.services.s3.model.CopyPartRequest)]
   (clojure.core/let
    [v13446
     (:first-byte m13445 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13446 :com.palletops.awaze.client-builder/undef)
     (. bean13444 setFirstByte (clojure.core/long v13446))))
   (clojure.core/let
    [v13446
     (:source-version-id
      m13445
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13446 :com.palletops.awaze.client-builder/undef)
     (. bean13444 setSourceVersionId (clojure.core/str v13446))))
   (clojure.core/let
    [v13446
     (:source-bucket-name
      m13445
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13446 :com.palletops.awaze.client-builder/undef)
     (. bean13444 setSourceBucketName (clojure.core/str v13446))))
   (clojure.core/let
    [v13446
     (:last-byte m13445 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13446 :com.palletops.awaze.client-builder/undef)
     (. bean13444 setLastByte (clojure.core/long v13446))))
   (clojure.core/let
    [v13446
     (:unmodified-since-constraint
      m13445
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13446 :com.palletops.awaze.client-builder/undef)
     (.
      bean13444
      setUnmodifiedSinceConstraint
      (com.palletops.awaze.common/to-date v13446))))
   (clojure.core/let
    [v13446
     (:modified-since-constraint
      m13445
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13446 :com.palletops.awaze.client-builder/undef)
     (.
      bean13444
      setModifiedSinceConstraint
      (com.palletops.awaze.common/to-date v13446))))
   (clojure.core/let
    [v13446
     (:destination-ssecustomer-key
      m13445
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13446 :com.palletops.awaze.client-builder/undef)
     (.
      bean13444
      setDestinationSSECustomerKey
      (s3/ssecustomer-key v13446))))
   (clojure.core/let
    [v13446
     (:destination-bucket-name
      m13445
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13446 :com.palletops.awaze.client-builder/undef)
     (. bean13444 setDestinationBucketName (clojure.core/str v13446))))
   (clojure.core/let
    [v13446
     (:part-number m13445 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13446 :com.palletops.awaze.client-builder/undef)
     (. bean13444 setPartNumber (clojure.core/int v13446))))
   (clojure.core/let
    [v13446
     (:destination-key
      m13445
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13446 :com.palletops.awaze.client-builder/undef)
     (. bean13444 setDestinationKey (clojure.core/str v13446))))
   (clojure.core/let
    [v13446
     (:matching-etag-constraints
      m13445
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13446 :com.palletops.awaze.client-builder/undef)
     (.
      bean13444
      setMatchingETagConstraints
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13613] (clojure.core/str arg13613))
 v13446))))
   (clojure.core/let
    [v13446
     (:source-key m13445 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13446 :com.palletops.awaze.client-builder/undef)
     (. bean13444 setSourceKey (clojure.core/str v13446))))
   (clojure.core/let
    [v13446
     (:source-ssecustomer-key
      m13445
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13446 :com.palletops.awaze.client-builder/undef)
     (. bean13444 setSourceSSECustomerKey (s3/ssecustomer-key v13446))))
   (clojure.core/let
    [v13446
     (:nonmatching-etag-constraints
      m13445
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13446 :com.palletops.awaze.client-builder/undef)
     (.
      bean13444
      setNonmatchingETagConstraints
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13614] (clojure.core/str arg13614))
 v13446))))
   (clojure.core/let
    [v13446
     (:upload-id m13445 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13446 :com.palletops.awaze.client-builder/undef)
     (. bean13444 setUploadId (clojure.core/str v13446))))
   bean13444))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetBucketReplicationConfigurationRequest}
get-bucket-replication-configuration-request
  [m13448]
  (clojure.core/let
   [arg13450
    nil
    bean13447
    (new
     com.amazonaws.services.s3.model.GetBucketReplicationConfigurationRequest
     arg13450)]
   bean13447))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetBucketVersioningConfigurationRequest}
get-bucket-versioning-configuration-request
  [m13452]
  (clojure.core/let
   [arg13454
    nil
    bean13451
    (new
     com.amazonaws.services.s3.model.GetBucketVersioningConfigurationRequest
     arg13454)]
   bean13451))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ListNextBatchOfVersionsRequest}
list-next-batch-of-versions-request
  [m13456]
  (clojure.core/let
   [arg13458
    (version-listing {})
    bean13455
    (new
     com.amazonaws.services.s3.model.ListNextBatchOfVersionsRequest
     arg13458)]
   (clojure.core/let
    [v13457
     (:previous-version-listing
      m13456
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13457 :com.palletops.awaze.client-builder/undef)
     (.
      bean13455
      setPreviousVersionListing
      (s3/version-listing v13457))))
   bean13455))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetBucketAclRequest}
get-bucket-acl-request
  [m13460]
  (clojure.core/let
   [arg13462
    nil
    bean13459
    (new com.amazonaws.services.s3.model.GetBucketAclRequest arg13462)]
   bean13459))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteObjectRequest}
delete-object-request
  [m13464]
  (clojure.core/let
   [arg13466
    nil
    arg13467
    nil
    bean13463
    (new
     com.amazonaws.services.s3.model.DeleteObjectRequest
     arg13466
     arg13467)]
   (clojure.core/let
    [v13465 (:key m13464 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13465 :com.palletops.awaze.client-builder/undef)
     (. bean13463 setKey (clojure.core/str v13465))))
   (clojure.core/let
    [v13465
     (:requester-pays
      m13464
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13465 :com.palletops.awaze.client-builder/undef)
     (. bean13463 setRequesterPays (clojure.core/boolean v13465))))
   (clojure.core/let
    [v13465
     (:bucket-name m13464 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13465 :com.palletops.awaze.client-builder/undef)
     (. bean13463 setBucketName (clojure.core/str v13465))))
   bean13463))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteBucketTaggingConfigurationRequest}
delete-bucket-tagging-configuration-request
  [m13469]
  (clojure.core/let
   [arg13471
    nil
    bean13468
    (new
     com.amazonaws.services.s3.model.DeleteBucketTaggingConfigurationRequest
     arg13471)]
   bean13468))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetBucketLoggingConfigurationRequest}
get-bucket-logging-configuration-request
  [m13473]
  (clojure.core/let
   [arg13475
    nil
    bean13472
    (new
     com.amazonaws.services.s3.model.GetBucketLoggingConfigurationRequest
     arg13475)]
   bean13472))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GeneratePresignedUrlRequest}
generate-presigned-url-request
  [m13477]
  (clojure.core/let
   [arg13479
    nil
    arg13480
    nil
    bean13476
    (new
     com.amazonaws.services.s3.model.GeneratePresignedUrlRequest
     arg13479
     arg13480)]
   (clojure.core/let
    [v13478
     (:expiration m13477 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13478 :com.palletops.awaze.client-builder/undef)
     (.
      bean13476
      setExpiration
      (com.palletops.awaze.common/to-date v13478))))
   (clojure.core/let
    [v13478
     (:kms-cmk-id m13477 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13478 :com.palletops.awaze.client-builder/undef)
     (. bean13476 setKmsCmkId (clojure.core/str v13478))))
   (clojure.core/let
    [v13478
     (:content-type m13477 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13478 :com.palletops.awaze.client-builder/undef)
     (. bean13476 setContentType (clojure.core/str v13478))))
   (clojure.core/let
    [v13478
     (:bucket-name m13477 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13478 :com.palletops.awaze.client-builder/undef)
     (. bean13476 setBucketName (clojure.core/str v13478))))
   (clojure.core/let
    [v13478
     (:ssecustomer-key
      m13477
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13478 :com.palletops.awaze.client-builder/undef)
     (. bean13476 setSSECustomerKey (s3/ssecustomer-key v13478))))
   (clojure.core/let
    [v13478
     (:method m13477 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13478 :com.palletops.awaze.client-builder/undef)
     (. bean13476 setMethod (root/http-method v13478))))
   (clojure.core/let
    [v13478
     (:ssecustomer-key-algorithm
      m13477
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13478 :com.palletops.awaze.client-builder/undef)
     (. bean13476 setSSECustomerKeyAlgorithm (s3/ssealgorithm v13478))))
   (clojure.core/let
    [v13478
     (:response-headers
      m13477
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13478 :com.palletops.awaze.client-builder/undef)
     (.
      bean13476
      setResponseHeaders
      (s3/response-header-overrides v13478))))
   (clojure.core/let
    [v13478
     (:zero-byte-content
      m13477
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13478 :com.palletops.awaze.client-builder/undef)
     (. bean13476 setZeroByteContent (clojure.core/boolean v13478))))
   (clojure.core/let
    [v13478 (:key m13477 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13478 :com.palletops.awaze.client-builder/undef)
     (. bean13476 setKey (clojure.core/str v13478))))
   (clojure.core/let
    [v13478
     (:ssealgorithm m13477 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13478 :com.palletops.awaze.client-builder/undef)
     (. bean13476 setSSEAlgorithm (s3/ssealgorithm v13478))))
   (clojure.core/let
    [v13478
     (:content-md5 m13477 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13478 :com.palletops.awaze.client-builder/undef)
     (. bean13476 setContentMd5 (clojure.core/str v13478))))
   bean13476))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.CopyObjectRequest}
copy-object-request
  [m13482]
  (clojure.core/let
   [arg13484
    nil
    arg13485
    nil
    arg13486
    nil
    arg13487
    nil
    bean13481
    (new
     com.amazonaws.services.s3.model.CopyObjectRequest
     arg13484
     arg13485
     arg13486
     arg13487)]
   (clojure.core/let
    [v13483
     (:canned-access-control-list
      m13482
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13483 :com.palletops.awaze.client-builder/undef)
     (.
      bean13481
      setCannedAccessControlList
      (s3/canned-access-control-list v13483))))
   (clojure.core/let
    [v13483
     (:source-version-id
      m13482
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13483 :com.palletops.awaze.client-builder/undef)
     (. bean13481 setSourceVersionId (clojure.core/str v13483))))
   (clojure.core/let
    [v13483
     (:source-bucket-name
      m13482
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13483 :com.palletops.awaze.client-builder/undef)
     (. bean13481 setSourceBucketName (clojure.core/str v13483))))
   (clojure.core/let
    [v13483
     (:unmodified-since-constraint
      m13482
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13483 :com.palletops.awaze.client-builder/undef)
     (.
      bean13481
      setUnmodifiedSinceConstraint
      (com.palletops.awaze.common/to-date v13483))))
   (clojure.core/let
    [v13483
     (:modified-since-constraint
      m13482
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13483 :com.palletops.awaze.client-builder/undef)
     (.
      bean13481
      setModifiedSinceConstraint
      (com.palletops.awaze.common/to-date v13483))))
   (clojure.core/let
    [v13483
     (:storage-class m13482 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13483 :com.palletops.awaze.client-builder/undef)
     (. bean13481 setStorageClass (s3/storage-class v13483))))
   (clojure.core/let
    [v13483
     (:destination-ssecustomer-key
      m13482
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13483 :com.palletops.awaze.client-builder/undef)
     (.
      bean13481
      setDestinationSSECustomerKey
      (s3/ssecustomer-key v13483))))
   (clojure.core/let
    [v13483
     (:destination-bucket-name
      m13482
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13483 :com.palletops.awaze.client-builder/undef)
     (. bean13481 setDestinationBucketName (clojure.core/str v13483))))
   (clojure.core/let
    [v13483
     (:redirect-location
      m13482
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13483 :com.palletops.awaze.client-builder/undef)
     (. bean13481 setRedirectLocation (clojure.core/str v13483))))
   (clojure.core/let
    [v13483
     (:requester-pays
      m13482
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13483 :com.palletops.awaze.client-builder/undef)
     (. bean13481 setRequesterPays (clojure.core/boolean v13483))))
   (clojure.core/let
    [v13483
     (:access-control-list
      m13482
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13483 :com.palletops.awaze.client-builder/undef)
     (.
      bean13481
      setAccessControlList
      (s3/access-control-list v13483))))
   (clojure.core/let
    [v13483
     (:sseaws-key-management-params
      m13482
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13483 :com.palletops.awaze.client-builder/undef)
     (.
      bean13481
      setSSEAwsKeyManagementParams
      (s3/sseaws-key-management-params v13483))))
   (clojure.core/let
    [v13483
     (:destination-key
      m13482
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13483 :com.palletops.awaze.client-builder/undef)
     (. bean13481 setDestinationKey (clojure.core/str v13483))))
   (clojure.core/let
    [v13483
     (:matching-etag-constraints
      m13482
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13483 :com.palletops.awaze.client-builder/undef)
     (.
      bean13481
      setMatchingETagConstraints
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13615] (clojure.core/str arg13615))
 v13483))))
   (clojure.core/let
    [v13483
     (:source-key m13482 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13483 :com.palletops.awaze.client-builder/undef)
     (. bean13481 setSourceKey (clojure.core/str v13483))))
   (clojure.core/let
    [v13483
     (:source-ssecustomer-key
      m13482
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13483 :com.palletops.awaze.client-builder/undef)
     (. bean13481 setSourceSSECustomerKey (s3/ssecustomer-key v13483))))
   (clojure.core/let
    [v13483
     (:new-object-metadata
      m13482
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13483 :com.palletops.awaze.client-builder/undef)
     (. bean13481 setNewObjectMetadata (s3/object-metadata v13483))))
   (clojure.core/let
    [v13483
     (:nonmatching-etag-constraints
      m13482
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13483 :com.palletops.awaze.client-builder/undef)
     (.
      bean13481
      setNonmatchingETagConstraints
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13616] (clojure.core/str arg13616))
 v13483))))
   bean13481))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteObjectsRequest}
delete-objects-request
  [m13489]
  (clojure.core/let
   [arg13491
    nil
    bean13488
    (new
     com.amazonaws.services.s3.model.DeleteObjectsRequest
     arg13491)]
   (clojure.core/let
    [v13490
     (:requester-pays
      m13489
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13490 :com.palletops.awaze.client-builder/undef)
     (. bean13488 setRequesterPays (clojure.core/boolean v13490))))
   (clojure.core/let
    [v13490 (:mfa m13489 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13490 :com.palletops.awaze.client-builder/undef)
     (. bean13488 setMfa (s3/multi-factor-authentication v13490))))
   (clojure.core/let
    [v13490 (:quiet m13489 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13490 :com.palletops.awaze.client-builder/undef)
     (. bean13488 setQuiet (clojure.core/boolean v13490))))
   (clojure.core/let
    [v13490 (:keys m13489 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13490 :com.palletops.awaze.client-builder/undef)
     (.
      bean13488
      setKeys
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg13617]
  (s3/delete-objects-request-key-version arg13617))
 v13490))))
   (clojure.core/let
    [v13490
     (:bucket-name m13489 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13490 :com.palletops.awaze.client-builder/undef)
     (. bean13488 setBucketName (clojure.core/str v13490))))
   bean13488))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketVersioningConfigurationRequest}
set-bucket-versioning-configuration-request
  [m13493]
  (clojure.core/let
   [arg13495
    nil
    arg13496
    (bucket-versioning-configuration {})
    bean13492
    (new
     com.amazonaws.services.s3.model.SetBucketVersioningConfigurationRequest
     arg13495
     arg13496)]
   (clojure.core/let
    [v13494 (:mfa m13493 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13494 :com.palletops.awaze.client-builder/undef)
     (. bean13492 setMfa (s3/multi-factor-authentication v13494))))
   (clojure.core/let
    [v13494
     (:versioning-configuration
      m13493
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13494 :com.palletops.awaze.client-builder/undef)
     (.
      bean13492
      setVersioningConfiguration
      (s3/bucket-versioning-configuration v13494))))
   (clojure.core/let
    [v13494
     (:bucket-name m13493 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13494 :com.palletops.awaze.client-builder/undef)
     (. bean13492 setBucketName (clojure.core/str v13494))))
   bean13492))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketLoggingConfigurationRequest}
set-bucket-logging-configuration-request
  [m13498]
  (clojure.core/let
   [arg13500
    nil
    arg13501
    (bucket-logging-configuration {})
    bean13497
    (new
     com.amazonaws.services.s3.model.SetBucketLoggingConfigurationRequest
     arg13500
     arg13501)]
   (clojure.core/let
    [v13499
     (:logging-configuration
      m13498
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13499 :com.palletops.awaze.client-builder/undef)
     (.
      bean13497
      setLoggingConfiguration
      (s3/bucket-logging-configuration v13499))))
   (clojure.core/let
    [v13499
     (:bucket-name m13498 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13499 :com.palletops.awaze.client-builder/undef)
     (. bean13497 setBucketName (clojure.core/str v13499))))
   bean13497))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetObjectRequest}
get-object-request
  [m13503]
  (clojure.core/let
   [arg13505
    nil
    arg13506
    nil
    bean13502
    (new
     com.amazonaws.services.s3.model.GetObjectRequest
     arg13505
     arg13506)]
   (clojure.core/let
    [v13504
     (:progress-listener
      m13503
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13504 :com.palletops.awaze.client-builder/undef)
     (. bean13502 setProgressListener v13504)))
   (clojure.core/let
    [v13504
     (:bucket-name m13503 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13504 :com.palletops.awaze.client-builder/undef)
     (. bean13502 setBucketName (clojure.core/str v13504))))
   (clojure.core/let
    [v13504
     (:ssecustomer-key
      m13503
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13504 :com.palletops.awaze.client-builder/undef)
     (. bean13502 setSSECustomerKey (s3/ssecustomer-key v13504))))
   (clojure.core/let
    [v13504
     (:unmodified-since-constraint
      m13503
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13504 :com.palletops.awaze.client-builder/undef)
     (.
      bean13502
      setUnmodifiedSinceConstraint
      (com.palletops.awaze.common/to-date v13504))))
   (clojure.core/let
    [v13504
     (:modified-since-constraint
      m13503
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13504 :com.palletops.awaze.client-builder/undef)
     (.
      bean13502
      setModifiedSinceConstraint
      (com.palletops.awaze.common/to-date v13504))))
   (clojure.core/let
    [v13504 (:range m13503 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13504 :com.palletops.awaze.client-builder/undef)
     (. bean13502 setRange (clojure.core/long v13504))))
   (clojure.core/let
    [v13504
     (:s3object-id m13503 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13504 :com.palletops.awaze.client-builder/undef)
     (. bean13502 setS3ObjectId (s3/s3object-id v13504))))
   (clojure.core/let
    [v13504
     (:response-headers
      m13503
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13504 :com.palletops.awaze.client-builder/undef)
     (.
      bean13502
      setResponseHeaders
      (s3/response-header-overrides v13504))))
   (clojure.core/let
    [v13504
     (:requester-pays
      m13503
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13504 :com.palletops.awaze.client-builder/undef)
     (. bean13502 setRequesterPays (clojure.core/boolean v13504))))
   (clojure.core/let
    [v13504 (:key m13503 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13504 :com.palletops.awaze.client-builder/undef)
     (. bean13502 setKey (clojure.core/str v13504))))
   (clojure.core/let
    [v13504
     (:matching-etag-constraints
      m13503
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13504 :com.palletops.awaze.client-builder/undef)
     (.
      bean13502
      setMatchingETagConstraints
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13618] (clojure.core/str arg13618))
 v13504))))
   (clojure.core/let
    [v13504
     (:version-id m13503 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13504 :com.palletops.awaze.client-builder/undef)
     (. bean13502 setVersionId (clojure.core/str v13504))))
   (clojure.core/let
    [v13504
     (:nonmatching-etag-constraints
      m13503
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13504 :com.palletops.awaze.client-builder/undef)
     (.
      bean13502
      setNonmatchingETagConstraints
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13619] (clojure.core/str arg13619))
 v13504))))
   bean13502))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteBucketCrossOriginConfigurationRequest}
delete-bucket-cross-origin-configuration-request
  [m13508]
  (clojure.core/let
   [arg13510
    nil
    bean13507
    (new
     com.amazonaws.services.s3.model.DeleteBucketCrossOriginConfigurationRequest
     arg13510)]
   bean13507))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.CompleteMultipartUploadRequest}
complete-multipart-upload-request
  [m13512]
  (clojure.core/let
   [bean13511
    (new
     com.amazonaws.services.s3.model.CompleteMultipartUploadRequest)]
   (clojure.core/let
    [v13513 (:key m13512 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13513 :com.palletops.awaze.client-builder/undef)
     (. bean13511 setKey (clojure.core/str v13513))))
   (clojure.core/let
    [v13513
     (:part-etags m13512 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13513 :com.palletops.awaze.client-builder/undef)
     (.
      bean13511
      setPartETags
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13620] (s3/part-etag arg13620))
 v13513))))
   (clojure.core/let
    [v13513
     (:requester-pays
      m13512
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13513 :com.palletops.awaze.client-builder/undef)
     (. bean13511 setRequesterPays (clojure.core/boolean v13513))))
   (clojure.core/let
    [v13513
     (:upload-id m13512 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13513 :com.palletops.awaze.client-builder/undef)
     (. bean13511 setUploadId (clojure.core/str v13513))))
   (clojure.core/let
    [v13513
     (:bucket-name m13512 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13513 :com.palletops.awaze.client-builder/undef)
     (. bean13511 setBucketName (clojure.core/str v13513))))
   bean13511))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.RestoreObjectRequest}
restore-object-request
  [m13515]
  (clojure.core/let
   [arg13517
    nil
    arg13518
    nil
    bean13514
    (new
     com.amazonaws.services.s3.model.RestoreObjectRequest
     arg13517
     arg13518)]
   (clojure.core/let
    [v13516 (:key m13515 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13516 :com.palletops.awaze.client-builder/undef)
     (. bean13514 setKey (clojure.core/str v13516))))
   (clojure.core/let
    [v13516
     (:version-id m13515 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13516 :com.palletops.awaze.client-builder/undef)
     (. bean13514 setVersionId (clojure.core/str v13516))))
   (clojure.core/let
    [v13516
     (:requester-pays
      m13515
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13516 :com.palletops.awaze.client-builder/undef)
     (. bean13514 setRequesterPays (clojure.core/boolean v13516))))
   (clojure.core/let
    [v13516
     (:expiration-in-days
      m13515
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13516 :com.palletops.awaze.client-builder/undef)
     (. bean13514 setExpirationInDays (clojure.core/int v13516))))
   (clojure.core/let
    [v13516
     (:bucket-name m13515 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13516 :com.palletops.awaze.client-builder/undef)
     (. bean13514 setBucketName (clojure.core/str v13516))))
   bean13514))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetBucketPolicyRequest}
get-bucket-policy-request
  [m13520]
  (clojure.core/let
   [arg13522
    nil
    bean13519
    (new
     com.amazonaws.services.s3.model.GetBucketPolicyRequest
     arg13522)]
   (clojure.core/let
    [v13521
     (:bucket-name m13520 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13521 :com.palletops.awaze.client-builder/undef)
     (. bean13519 setBucketName (clojure.core/str v13521))))
   bean13519))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketReplicationConfigurationRequest}
set-bucket-replication-configuration-request
  [m13524]
  (clojure.core/let
   [bean13523
    (new
     com.amazonaws.services.s3.model.SetBucketReplicationConfigurationRequest)]
   (clojure.core/let
    [v13525
     (:replication-configuration
      m13524
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13525 :com.palletops.awaze.client-builder/undef)
     (.
      bean13523
      setReplicationConfiguration
      (s3/bucket-replication-configuration v13525))))
   (clojure.core/let
    [v13525
     (:bucket-name m13524 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13525 :com.palletops.awaze.client-builder/undef)
     (. bean13523 setBucketName (clojure.core/str v13525))))
   bean13523))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.CreateBucketRequest}
create-bucket-request
  [m13527]
  (clojure.core/let
   [arg13529
    nil
    bean13526
    (new com.amazonaws.services.s3.model.CreateBucketRequest arg13529)]
   (clojure.core/let
    [v13528
     (:canned-acl m13527 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13528 :com.palletops.awaze.client-builder/undef)
     (. bean13526 setCannedAcl (s3/canned-access-control-list v13528))))
   (clojure.core/let
    [v13528
     (:access-control-list
      m13527
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13528 :com.palletops.awaze.client-builder/undef)
     (.
      bean13526
      setAccessControlList
      (s3/access-control-list v13528))))
   (clojure.core/let
    [v13528
     (:region m13527 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13528 :com.palletops.awaze.client-builder/undef)
     (. bean13526 setRegion (clojure.core/str v13528))))
   (clojure.core/let
    [v13528
     (:bucket-name m13527 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13528 :com.palletops.awaze.client-builder/undef)
     (. bean13526 setBucketName (clojure.core/str v13528))))
   bean13526))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.Region}
region
  [m13531]
  (.
   com.amazonaws.services.s3.model.Region
   fromValue
   (clojure.core/name m13531)))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteVersionRequest}
delete-version-request
  [m13534]
  (clojure.core/let
   [arg13536
    nil
    arg13537
    nil
    arg13538
    nil
    bean13533
    (new
     com.amazonaws.services.s3.model.DeleteVersionRequest
     arg13536
     arg13537
     arg13538)]
   (clojure.core/let
    [v13535 (:key m13534 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13535 :com.palletops.awaze.client-builder/undef)
     (. bean13533 setKey (clojure.core/str v13535))))
   (clojure.core/let
    [v13535
     (:version-id m13534 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13535 :com.palletops.awaze.client-builder/undef)
     (. bean13533 setVersionId (clojure.core/str v13535))))
   (clojure.core/let
    [v13535 (:mfa m13534 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13535 :com.palletops.awaze.client-builder/undef)
     (. bean13533 setMfa (s3/multi-factor-authentication v13535))))
   (clojure.core/let
    [v13535
     (:bucket-name m13534 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13535 :com.palletops.awaze.client-builder/undef)
     (. bean13533 setBucketName (clojure.core/str v13535))))
   bean13533))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.PutObjectRequest}
put-object-request
  [m13540]
  (clojure.core/let
   [^{:tag java.lang.String}
    arg13542
    nil
^{:tag java.lang.String}
arg13543
    nil
^{:tag java.lang.String}
arg13544
    nil
    bean13539
    (new
     com.amazonaws.services.s3.model.PutObjectRequest
^{:tag java.lang.String}
arg13542
^{:tag java.lang.String}
arg13543
^{:tag java.lang.String}
arg13544)]
   (clojure.core/let
    [v13541
     (:requester-pays
      m13540
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13541 :com.palletops.awaze.client-builder/undef)
     (. bean13539 setRequesterPays (clojure.core/boolean v13541))))
   bean13539))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ListVersionsRequest}
list-versions-request
  [m13546]
  (clojure.core/let
   [bean13545
    (new com.amazonaws.services.s3.model.ListVersionsRequest)]
   (clojure.core/let
    [v13547
     (:delimiter m13546 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13547 :com.palletops.awaze.client-builder/undef)
     (. bean13545 setDelimiter (clojure.core/str v13547))))
   (clojure.core/let
    [v13547
     (:key-marker m13546 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13547 :com.palletops.awaze.client-builder/undef)
     (. bean13545 setKeyMarker (clojure.core/str v13547))))
   (clojure.core/let
    [v13547
     (:version-id-marker
      m13546
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13547 :com.palletops.awaze.client-builder/undef)
     (. bean13545 setVersionIdMarker (clojure.core/str v13547))))
   (clojure.core/let
    [v13547
     (:encoding-type m13546 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13547 :com.palletops.awaze.client-builder/undef)
     (. bean13545 setEncodingType (clojure.core/str v13547))))
   (clojure.core/let
    [v13547
     (:prefix m13546 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13547 :com.palletops.awaze.client-builder/undef)
     (. bean13545 setPrefix (clojure.core/str v13547))))
   (clojure.core/let
    [v13547
     (:max-results m13546 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13547 :com.palletops.awaze.client-builder/undef)
     (. bean13545 setMaxResults (clojure.core/int v13547))))
   (clojure.core/let
    [v13547
     (:bucket-name m13546 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13547 :com.palletops.awaze.client-builder/undef)
     (. bean13545 setBucketName (clojure.core/str v13547))))
   bean13545))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketTaggingConfigurationRequest}
set-bucket-tagging-configuration-request
  [m13549]
  (clojure.core/let
   [arg13551
    nil
    arg13552
    (bucket-tagging-configuration {})
    bean13548
    (new
     com.amazonaws.services.s3.model.SetBucketTaggingConfigurationRequest
     arg13551
     arg13552)]
   (clojure.core/let
    [v13550
     (:tagging-configuration
      m13549
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13550 :com.palletops.awaze.client-builder/undef)
     (.
      bean13548
      setTaggingConfiguration
      (s3/bucket-tagging-configuration v13550))))
   (clojure.core/let
    [v13550
     (:bucket-name m13549 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13550 :com.palletops.awaze.client-builder/undef)
     (. bean13548 setBucketName (clojure.core/str v13550))))
   bean13548))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetBucketCrossOriginConfigurationRequest}
get-bucket-cross-origin-configuration-request
  [m13554]
  (clojure.core/let
   [arg13556
    nil
    bean13553
    (new
     com.amazonaws.services.s3.model.GetBucketCrossOriginConfigurationRequest
     arg13556)]
   bean13553))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketPolicyRequest}
set-bucket-policy-request
  [m13558]
  (clojure.core/let
   [arg13560
    nil
    arg13561
    nil
    bean13557
    (new
     com.amazonaws.services.s3.model.SetBucketPolicyRequest
     arg13560
     arg13561)]
   (clojure.core/let
    [v13559
     (:policy-text m13558 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13559 :com.palletops.awaze.client-builder/undef)
     (. bean13557 setPolicyText (clojure.core/str v13559))))
   (clojure.core/let
    [v13559
     (:bucket-name m13558 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13559 :com.palletops.awaze.client-builder/undef)
     (. bean13557 setBucketName (clojure.core/str v13559))))
   bean13557))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ListNextBatchOfObjectsRequest}
list-next-batch-of-objects-request
  [m13563]
  (clojure.core/let
   [arg13565
    (object-listing {})
    bean13562
    (new
     com.amazonaws.services.s3.model.ListNextBatchOfObjectsRequest
     arg13565)]
   (clojure.core/let
    [v13564
     (:previous-object-listing
      m13563
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13564 :com.palletops.awaze.client-builder/undef)
     (. bean13562 setPreviousObjectListing (s3/object-listing v13564))))
   bean13562))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.InitiateMultipartUploadRequest}
initiate-multipart-upload-request
  [m13567]
  (clojure.core/let
   [arg13569
    nil
    arg13570
    nil
    bean13566
    (new
     com.amazonaws.services.s3.model.InitiateMultipartUploadRequest
     arg13569
     arg13570)]
   (clojure.core/let
    [v13568
     (:bucket-name m13567 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13568 :com.palletops.awaze.client-builder/undef)
     (. bean13566 setBucketName (clojure.core/str v13568))))
   (clojure.core/let
    [v13568
     (:ssecustomer-key
      m13567
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13568 :com.palletops.awaze.client-builder/undef)
     (. bean13566 setSSECustomerKey (s3/ssecustomer-key v13568))))
   (clojure.core/let
    [v13568
     (:canned-acl m13567 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13568 :com.palletops.awaze.client-builder/undef)
     (. bean13566 setCannedACL (s3/canned-access-control-list v13568))))
   (clojure.core/let
    [v13568
     (:storage-class m13567 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13568 :com.palletops.awaze.client-builder/undef)
     (. bean13566 setStorageClass (s3/storage-class v13568))))
   (clojure.core/let
    [v13568
     (:redirect-location
      m13567
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13568 :com.palletops.awaze.client-builder/undef)
     (. bean13566 setRedirectLocation (clojure.core/str v13568))))
   (clojure.core/let
    [v13568
     (:requester-pays
      m13567
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13568 :com.palletops.awaze.client-builder/undef)
     (. bean13566 setRequesterPays (clojure.core/boolean v13568))))
   (clojure.core/let
    [v13568
     (:object-metadata
      m13567
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13568 :com.palletops.awaze.client-builder/undef)
     (. bean13566 setObjectMetadata (s3/object-metadata v13568))))
   (clojure.core/let
    [v13568
     (:access-control-list
      m13567
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13568 :com.palletops.awaze.client-builder/undef)
     (.
      bean13566
      setAccessControlList
      (s3/access-control-list v13568))))
   (clojure.core/let
    [v13568 (:key m13567 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13568 :com.palletops.awaze.client-builder/undef)
     (. bean13566 setKey (clojure.core/str v13568))))
   (clojure.core/let
    [v13568
     (:sseaws-key-management-params
      m13567
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13568 :com.palletops.awaze.client-builder/undef)
     (.
      bean13566
      setSSEAwsKeyManagementParams
      (s3/sseaws-key-management-params v13568))))
   bean13566))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteBucketRequest}
delete-bucket-request
  [m13572]
  (clojure.core/let
   [arg13574
    nil
    bean13571
    (new com.amazonaws.services.s3.model.DeleteBucketRequest arg13574)]
   (clojure.core/let
    [v13573
     (:bucket-name m13572 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13573 :com.palletops.awaze.client-builder/undef)
     (. bean13571 setBucketName (clojure.core/str v13573))))
   bean13571))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetBucketTaggingConfigurationRequest}
get-bucket-tagging-configuration-request
  [m13576]
  (clojure.core/let
   [arg13578
    nil
    bean13575
    (new
     com.amazonaws.services.s3.model.GetBucketTaggingConfigurationRequest
     arg13578)]
   bean13575))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetBucketLocationRequest}
get-bucket-location-request
  [m13580]
  (clojure.core/let
   [arg13582
    nil
    bean13579
    (new
     com.amazonaws.services.s3.model.GetBucketLocationRequest
     arg13582)]
   (clojure.core/let
    [v13581
     (:bucket-name m13580 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13581 :com.palletops.awaze.client-builder/undef)
     (. bean13579 setBucketName (clojure.core/str v13581))))
   bean13579))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetObjectAclRequest}
get-object-acl-request
  [m13584]
  (clojure.core/let
   [arg13586
    nil
    arg13587
    nil
    bean13583
    (new
     com.amazonaws.services.s3.model.GetObjectAclRequest
     arg13586
     arg13587)]
   (clojure.core/let
    [v13585 (:key m13584 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13585 :com.palletops.awaze.client-builder/undef)
     (. bean13583 setKey (clojure.core/str v13585))))
   (clojure.core/let
    [v13585
     (:version-id m13584 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13585 :com.palletops.awaze.client-builder/undef)
     (. bean13583 setVersionId (clojure.core/str v13585))))
   (clojure.core/let
    [v13585
     (:requester-pays
      m13584
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13585 :com.palletops.awaze.client-builder/undef)
     (. bean13583 setRequesterPays (clojure.core/boolean v13585))))
   (clojure.core/let
    [v13585
     (:bucket-name m13584 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13585 :com.palletops.awaze.client-builder/undef)
     (. bean13583 setBucketName (clojure.core/str v13585))))
   bean13583))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.UploadPartRequest}
upload-part-request
  [m13589]
  (clojure.core/let
   [bean13588 (new com.amazonaws.services.s3.model.UploadPartRequest)]
   (clojure.core/let
    [v13590
     (:file-offset m13589 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13590 :com.palletops.awaze.client-builder/undef)
     (. bean13588 setFileOffset (clojure.core/long v13590))))
   (clojure.core/let
    [v13590
     (:progress-listener
      m13589
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13590 :com.palletops.awaze.client-builder/undef)
     (. bean13588 setProgressListener v13590)))
   (clojure.core/let
    [v13590
     (:bucket-name m13589 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13590 :com.palletops.awaze.client-builder/undef)
     (. bean13588 setBucketName (clojure.core/str v13590))))
   (clojure.core/let
    [v13590
     (:ssecustomer-key
      m13589
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13590 :com.palletops.awaze.client-builder/undef)
     (. bean13588 setSSECustomerKey (s3/ssecustomer-key v13590))))
   (clojure.core/let
    [v13590
     (:input-stream m13589 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13590 :com.palletops.awaze.client-builder/undef)
     (.
      bean13588
      setInputStream
      (clojure.java.io/input-stream v13590))))
   (clojure.core/let
    [v13590
     (:md5digest m13589 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13590 :com.palletops.awaze.client-builder/undef)
     (. bean13588 setMd5Digest (clojure.core/str v13590))))
   (clojure.core/let
    [v13590
     (:part-size m13589 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13590 :com.palletops.awaze.client-builder/undef)
     (. bean13588 setPartSize (clojure.core/long v13590))))
   (clojure.core/let
    [v13590
     (:requester-pays
      m13589
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13590 :com.palletops.awaze.client-builder/undef)
     (. bean13588 setRequesterPays (clojure.core/boolean v13590))))
   (clojure.core/let
    [v13590
     (:object-metadata
      m13589
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13590 :com.palletops.awaze.client-builder/undef)
     (. bean13588 setObjectMetadata (s3/object-metadata v13590))))
   (clojure.core/let
    [v13590 (:key m13589 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13590 :com.palletops.awaze.client-builder/undef)
     (. bean13588 setKey (clojure.core/str v13590))))
   (clojure.core/let
    [v13590
     (:part-number m13589 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13590 :com.palletops.awaze.client-builder/undef)
     (. bean13588 setPartNumber (clojure.core/int v13590))))
   (clojure.core/let
    [v13590 (:file m13589 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13590 :com.palletops.awaze.client-builder/undef)
     (. bean13588 setFile (clojure.java.io/file v13590))))
   (clojure.core/let
    [v13590
     (:last-part m13589 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13590 :com.palletops.awaze.client-builder/undef)
     (. bean13588 setLastPart (clojure.core/boolean v13590))))
   (clojure.core/let
    [v13590
     (:upload-id m13589 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13590 :com.palletops.awaze.client-builder/undef)
     (. bean13588 setUploadId (clojure.core/str v13590))))
   bean13588))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketWebsiteConfigurationRequest}
set-bucket-website-configuration-request
  [m13592]
  (clojure.core/let
   [arg13594
    nil
    arg13595
    (bucket-website-configuration {})
    bean13591
    (new
     com.amazonaws.services.s3.model.SetBucketWebsiteConfigurationRequest
     arg13594
     arg13595)]
   (clojure.core/let
    [v13593
     (:configuration m13592 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13593 :com.palletops.awaze.client-builder/undef)
     (.
      bean13591
      setConfiguration
      (s3/bucket-website-configuration v13593))))
   (clojure.core/let
    [v13593
     (:bucket-name m13592 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13593 :com.palletops.awaze.client-builder/undef)
     (. bean13591 setBucketName (clojure.core/str v13593))))
   bean13591))
 (clojure.core/defmulti
  s3
  (clojure.core/fn s3 [m__1874__auto__] (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   s3
   :delete-bucket-website-configuration
   [m13621]
   (clojure.core/let
    [credentials13622 (:credentials m13621) args13623 (:args m13621)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13624
      (com.palletops.awaze.common/aws-client :s3 credentials13622)]
     (clojure.core/case
      (clojure.core/count args13623)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13623 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13624
           deleteBucketWebsiteConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.DeleteBucketWebsiteConfigurationRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.DeleteBucketWebsiteConfigurationRequest
               (clojure.core/nth args13623 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13624
               deleteBucketWebsiteConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteBucketWebsiteConfiguration")
                {:args args13623}))))))))))))))
  (clojure.core/defn
   delete-bucket-website-configuration-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Generate map for deleteBucketWebsiteConfiguration, deleteBucketWebsiteConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-bucket-website-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   delete-bucket-website-configuration
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Call deleteBucketWebsiteConfiguration, deleteBucketWebsiteConfiguration"}
   [credentials13627 & args13628]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13630
     (com.palletops.awaze.common/aws-client :s3 credentials13627)]
    (clojure.core/case
     (clojure.core/count args13628)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13628 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13630
          deleteBucketWebsiteConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.DeleteBucketWebsiteConfigurationRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.DeleteBucketWebsiteConfigurationRequest
              (clojure.core/nth args13628 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13630
              deleteBucketWebsiteConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteBucketWebsiteConfiguration")
               {:args args13628}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :set-object-acl
   [m13631]
   (clojure.core/let
    [credentials13632 (:credentials m13631) args13633 (:args m13631)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13634
      (com.palletops.awaze.common/aws-client :s3 credentials13632)]
     (clojure.core/case
      (clojure.core/count args13633)
      3
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13633 0))
^{:tag java.lang.String}
b
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13633 1))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
c
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.CannedAccessControlList
           (clojure.core/nth args13633 2))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13634
           setObjectAcl
           a
           b
           c)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13633 0))
^{:tag java.lang.String}
b
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13633 1))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
c
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.AccessControlList
               (clojure.core/nth args13633 2))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13634
               setObjectAcl
               a
               b
               c)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "setObjectAcl")
                {:args args13633}))))))))))
      5
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13633 0))
^{:tag java.lang.String}
b
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13633 1))
^{:tag java.lang.String}
c
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13633 2))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
d
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.AccessControlList
           (clojure.core/nth args13633 3))
^{:tag com.amazonaws.metrics.RequestMetricCollector}
e
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.metrics.RequestMetricCollector
           (clojure.core/nth args13633 4))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13634
           setObjectAcl
           a
           b
           c
           d
           e)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13633 0))
^{:tag java.lang.String}
b
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13633 1))
^{:tag java.lang.String}
c
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13633 2))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
d
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.CannedAccessControlList
               (clojure.core/nth args13633 3))
^{:tag com.amazonaws.metrics.RequestMetricCollector}
e
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.metrics.RequestMetricCollector
               (clojure.core/nth args13633 4))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13634
               setObjectAcl
               a
               b
               c
               d
               e)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "setObjectAcl")
                {:args args13633}))))))))))
      4
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13633 0))
^{:tag java.lang.String}
b
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13633 1))
^{:tag java.lang.String}
c
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13633 2))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
d
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.CannedAccessControlList
           (clojure.core/nth args13633 3))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13634
           setObjectAcl
           a
           b
           c
           d)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13633 0))
^{:tag java.lang.String}
b
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13633 1))
^{:tag java.lang.String}
c
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13633 2))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
d
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.AccessControlList
               (clojure.core/nth args13633 3))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13634
               setObjectAcl
               a
               b
               c
               d)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "setObjectAcl")
                {:args args13633}))))))))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13634
        setObjectAcl
        (s3/set-object-acl-request (clojure.core/nth args13633 0))))))))
  (clojure.core/defn
   set-object-acl-map
   {:arglists (quote
               [[credentials
                 string-0
                 string-1
                 canned-access-control-list-2]
                [credentials
                 string-0
                 string-1
                 string-2
                 {:keys [grants
                         grants-as-list
                         owner
                         requester-charged]}
                 request-metric-collector-4]
                [credentials
                 string-0
                 string-1
                 string-2
                 canned-access-control-list-3]
                [credentials
                 string-0
                 string-1
                 string-2
                 canned-access-control-list-3
                 request-metric-collector-4]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         acl
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays
                         canned-acl]}]
                [credentials
                 string-0
                 string-1
                 string-2
                 {:keys [grants
                         grants-as-list
                         owner
                         requester-charged]}]
                [credentials
                 string-0
                 string-1
                 {:keys [grants
                         grants-as-list
                         owner
                         requester-charged]}]]),
    :doc "Generate map for setObjectAcl, setObjectAcl, setObjectAcl, setObjectAcl, setObjectAcl, setObjectAcl, setObjectAcl"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-object-acl,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b c]
    {:args [a b c],
     :fn :set-object-acl,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b c d]
    {:args [a b c d],
     :fn :set-object-acl,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b c d e]
    {:args [a b c d e],
     :fn :set-object-acl,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   set-object-acl
   {:arglists (quote
               [[credentials
                 string-0
                 string-1
                 canned-access-control-list-2]
                [credentials
                 string-0
                 string-1
                 string-2
                 {:keys [grants
                         grants-as-list
                         owner
                         requester-charged]}
                 request-metric-collector-4]
                [credentials
                 string-0
                 string-1
                 string-2
                 canned-access-control-list-3]
                [credentials
                 string-0
                 string-1
                 string-2
                 canned-access-control-list-3
                 request-metric-collector-4]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         acl
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays
                         canned-acl]}]
                [credentials
                 string-0
                 string-1
                 string-2
                 {:keys [grants
                         grants-as-list
                         owner
                         requester-charged]}]
                [credentials
                 string-0
                 string-1
                 {:keys [grants
                         grants-as-list
                         owner
                         requester-charged]}]]),
    :doc "Call setObjectAcl, setObjectAcl, setObjectAcl, setObjectAcl, setObjectAcl, setObjectAcl, setObjectAcl"}
   [credentials13642 & args13643]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13650
     (com.palletops.awaze.common/aws-client :s3 credentials13642)]
    (clojure.core/case
     (clojure.core/count args13643)
     3
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13643 0))
^{:tag java.lang.String}
b
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13643 1))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
c
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.CannedAccessControlList
          (clojure.core/nth args13643 2))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13650
          setObjectAcl
          a
          b
          c)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13643 0))
^{:tag java.lang.String}
b
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13643 1))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
c
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.AccessControlList
              (clojure.core/nth args13643 2))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13650
              setObjectAcl
              a
              b
              c)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "setObjectAcl")
               {:args args13643}))))))))))
     5
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13643 0))
^{:tag java.lang.String}
b
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13643 1))
^{:tag java.lang.String}
c
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13643 2))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
d
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.AccessControlList
          (clojure.core/nth args13643 3))
^{:tag com.amazonaws.metrics.RequestMetricCollector}
e
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.metrics.RequestMetricCollector
          (clojure.core/nth args13643 4))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13650
          setObjectAcl
          a
          b
          c
          d
          e)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13643 0))
^{:tag java.lang.String}
b
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13643 1))
^{:tag java.lang.String}
c
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13643 2))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
d
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.CannedAccessControlList
              (clojure.core/nth args13643 3))
^{:tag com.amazonaws.metrics.RequestMetricCollector}
e
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.metrics.RequestMetricCollector
              (clojure.core/nth args13643 4))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13650
              setObjectAcl
              a
              b
              c
              d
              e)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "setObjectAcl")
               {:args args13643}))))))))))
     4
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13643 0))
^{:tag java.lang.String}
b
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13643 1))
^{:tag java.lang.String}
c
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13643 2))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
d
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.CannedAccessControlList
          (clojure.core/nth args13643 3))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13650
          setObjectAcl
          a
          b
          c
          d)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13643 0))
^{:tag java.lang.String}
b
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13643 1))
^{:tag java.lang.String}
c
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13643 2))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
d
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.AccessControlList
              (clojure.core/nth args13643 3))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13650
              setObjectAcl
              a
              b
              c
              d)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "setObjectAcl")
               {:args args13643}))))))))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13650
       setObjectAcl
       (s3/set-object-acl-request (clojure.core/nth args13643 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-lifecycle-configuration
   [m13651]
   (clojure.core/let
    [credentials13652 (:credentials m13651) args13653 (:args m13651)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13654
      (com.palletops.awaze.common/aws-client :s3 credentials13652)]
     (clojure.core/case
      (clojure.core/count args13653)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13653 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13654
           getBucketLifecycleConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.GetBucketLifecycleConfigurationRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.GetBucketLifecycleConfigurationRequest
               (clojure.core/nth args13653 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13654
               getBucketLifecycleConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketLifecycleConfiguration")
                {:args args13653}))))))))))))))
  (clojure.core/defn
   get-bucket-lifecycle-configuration-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Generate map for getBucketLifecycleConfiguration, getBucketLifecycleConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-bucket-lifecycle-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-bucket-lifecycle-configuration
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Call getBucketLifecycleConfiguration, getBucketLifecycleConfiguration"}
   [credentials13657 & args13658]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13660
     (com.palletops.awaze.common/aws-client :s3 credentials13657)]
    (clojure.core/case
     (clojure.core/count args13658)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13658 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13660
          getBucketLifecycleConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.GetBucketLifecycleConfigurationRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.GetBucketLifecycleConfigurationRequest
              (clojure.core/nth args13658 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13660
              getBucketLifecycleConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketLifecycleConfiguration")
               {:args args13658}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :list-multipart-uploads
   [m13661]
   (clojure.core/let
    [credentials13662 (:credentials m13661) args13663 (:args m13661)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13664
      (com.palletops.awaze.common/aws-client :s3 credentials13662)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13664
       listMultipartUploads
       (s3/list-multipart-uploads-request
        (clojure.core/nth args13663 0)))))))
  (clojure.core/defn
   list-multipart-uploads-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         encoding-type
                         upload-id-marker
                         sdk-request-timeout
                         custom-query-parameters
                         max-uploads
                         prefix
                         delimiter
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         key-marker]}]]),
    :doc "Generate map for listMultipartUploads"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-multipart-uploads,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   list-multipart-uploads
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         encoding-type
                         upload-id-marker
                         sdk-request-timeout
                         custom-query-parameters
                         max-uploads
                         prefix
                         delimiter
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         key-marker]}]]),
    :doc "Call listMultipartUploads"}
   [credentials13667 & args13668]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13670
     (com.palletops.awaze.common/aws-client :s3 credentials13667)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13670
      listMultipartUploads
      (s3/list-multipart-uploads-request
       (clojure.core/nth args13668 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-object-metadata
   [m13671]
   (clojure.core/let
    [credentials13672 (:credentials m13671) args13673 (:args m13671)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13674
      (com.palletops.awaze.common/aws-client :s3 credentials13672)]
     (clojure.core/case
      (clojure.core/count args13673)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13674
        getObjectMetadata
        (s3/get-object-metadata-request
         (clojure.core/nth args13673 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13674
        getObjectMetadata
        (clojure.core/str (clojure.core/nth args13673 0))
        (clojure.core/str (clojure.core/nth args13673 1))))))))
  (clojure.core/defn
   get-object-metadata-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         ssecustomer-key
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays]}]
                [credentials string-0 string-1]]),
    :doc "Generate map for getObjectMetadata, getObjectMetadata"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-object-metadata,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :get-object-metadata,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-object-metadata
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         ssecustomer-key
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays]}]
                [credentials string-0 string-1]]),
    :doc "Call getObjectMetadata, getObjectMetadata"}
   [credentials13678 & args13679]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13682
     (com.palletops.awaze.common/aws-client :s3 credentials13678)]
    (clojure.core/case
     (clojure.core/count args13679)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13682
       getObjectMetadata
       (s3/get-object-metadata-request (clojure.core/nth args13679 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13682
       getObjectMetadata
       (clojure.core/str (clojure.core/nth args13679 0))
       (clojure.core/str (clojure.core/nth args13679 1))))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-cross-origin-configuration
   [m13683]
   (clojure.core/let
    [credentials13684 (:credentials m13683) args13685 (:args m13683)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13686
      (com.palletops.awaze.common/aws-client :s3 credentials13684)]
     (clojure.core/case
      (clojure.core/count args13685)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13686
        setBucketCrossOriginConfiguration
        (clojure.core/str (clojure.core/nth args13685 0))
        (s3/bucket-cross-origin-configuration
         (clojure.core/nth args13685 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13686
        setBucketCrossOriginConfiguration
        (s3/set-bucket-cross-origin-configuration-request
         (clojure.core/nth args13685 0))))))))
  (clojure.core/defn
   set-bucket-cross-origin-configuration-map
   {:arglists (quote
               [[credentials string-0 {:keys [rules]}]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         cross-origin-configuration
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setBucketCrossOriginConfiguration, setBucketCrossOriginConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-bucket-cross-origin-configuration,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :set-bucket-cross-origin-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   set-bucket-cross-origin-configuration
   {:arglists (quote
               [[credentials string-0 {:keys [rules]}]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         cross-origin-configuration
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Call setBucketCrossOriginConfiguration, setBucketCrossOriginConfiguration"}
   [credentials13690 & args13691]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13694
     (com.palletops.awaze.common/aws-client :s3 credentials13690)]
    (clojure.core/case
     (clojure.core/count args13691)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13694
       setBucketCrossOriginConfiguration
       (clojure.core/str (clojure.core/nth args13691 0))
       (s3/bucket-cross-origin-configuration
        (clojure.core/nth args13691 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13694
       setBucketCrossOriginConfiguration
       (s3/set-bucket-cross-origin-configuration-request
        (clojure.core/nth args13691 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-bucket-replication-configuration
   [m13695]
   (clojure.core/let
    [credentials13696 (:credentials m13695) args13697 (:args m13695)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13698
      (com.palletops.awaze.common/aws-client :s3 credentials13696)]
     (clojure.core/case
      (clojure.core/count args13697)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13697 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13698
           deleteBucketReplicationConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.DeleteBucketReplicationConfigurationRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.DeleteBucketReplicationConfigurationRequest
               (clojure.core/nth args13697 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13698
               deleteBucketReplicationConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteBucketReplicationConfiguration")
                {:args args13697}))))))))))))))
  (clojure.core/defn
   delete-bucket-replication-configuration-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Generate map for deleteBucketReplicationConfiguration, deleteBucketReplicationConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-bucket-replication-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   delete-bucket-replication-configuration
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Call deleteBucketReplicationConfiguration, deleteBucketReplicationConfiguration"}
   [credentials13701 & args13702]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13704
     (com.palletops.awaze.common/aws-client :s3 credentials13701)]
    (clojure.core/case
     (clojure.core/count args13702)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13702 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13704
          deleteBucketReplicationConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.DeleteBucketReplicationConfigurationRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.DeleteBucketReplicationConfigurationRequest
              (clojure.core/nth args13702 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13704
              deleteBucketReplicationConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteBucketReplicationConfiguration")
               {:args args13702}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-lifecycle-configuration
   [m13705]
   (clojure.core/let
    [credentials13706 (:credentials m13705) args13707 (:args m13705)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13708
      (com.palletops.awaze.common/aws-client :s3 credentials13706)]
     (clojure.core/case
      (clojure.core/count args13707)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13708
        setBucketLifecycleConfiguration
        (s3/set-bucket-lifecycle-configuration-request
         (clojure.core/nth args13707 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13708
        setBucketLifecycleConfiguration
        (clojure.core/str (clojure.core/nth args13707 0))
        (s3/bucket-lifecycle-configuration
         (clojure.core/nth args13707 1))))))))
  (clojure.core/defn
   set-bucket-lifecycle-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         lifecycle-configuration
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]
                [credentials string-0 {:keys [rules]}]]),
    :doc "Generate map for setBucketLifecycleConfiguration, setBucketLifecycleConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-bucket-lifecycle-configuration,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :set-bucket-lifecycle-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   set-bucket-lifecycle-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         lifecycle-configuration
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]
                [credentials string-0 {:keys [rules]}]]),
    :doc "Call setBucketLifecycleConfiguration, setBucketLifecycleConfiguration"}
   [credentials13712 & args13713]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13716
     (com.palletops.awaze.common/aws-client :s3 credentials13712)]
    (clojure.core/case
     (clojure.core/count args13713)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13716
       setBucketLifecycleConfiguration
       (s3/set-bucket-lifecycle-configuration-request
        (clojure.core/nth args13713 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13716
       setBucketLifecycleConfiguration
       (clojure.core/str (clojure.core/nth args13713 0))
       (s3/bucket-lifecycle-configuration
        (clojure.core/nth args13713 1))))))))
 (do
  (clojure.core/defmethod
   s3
   :does-object-exist
   [m13717]
   (clojure.core/let
    [credentials13718 (:credentials m13717) args13719 (:args m13717)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13720
      (com.palletops.awaze.common/aws-client :s3 credentials13718)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13720
       doesObjectExist
       (clojure.core/str (clojure.core/nth args13719 0))
       (clojure.core/str (clojure.core/nth args13719 1)))))))
  (clojure.core/defn
   does-object-exist-map
   {:arglists (quote [[credentials string-0 string-1]]),
    :doc "Generate map for doesObjectExist"}
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :does-object-exist,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   does-object-exist
   {:arglists (quote [[credentials string-0 string-1]]),
    :doc "Call doesObjectExist"}
   [credentials13722 & args13723]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13724
     (com.palletops.awaze.common/aws-client :s3 credentials13722)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13724
      doesObjectExist
      (clojure.core/str (clojure.core/nth args13723 0))
      (clojure.core/str (clojure.core/nth args13723 1)))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-notification-configuration
   [m13725]
   (clojure.core/let
    [credentials13726 (:credentials m13725) args13727 (:args m13725)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13728
      (com.palletops.awaze.common/aws-client :s3 credentials13726)]
     (clojure.core/case
      (clojure.core/count args13727)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13728
        setBucketNotificationConfiguration
        (s3/set-bucket-notification-configuration-request
         (clojure.core/nth args13727 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13728
        setBucketNotificationConfiguration
        (clojure.core/str (clojure.core/nth args13727 0))
        (s3/bucket-notification-configuration
         (clojure.core/nth args13727 1))))))))
  (clojure.core/defn
   set-bucket-notification-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         notification-configuration
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         bucket-notification-configuration
                         clone-root
                         bucket]}]
                [credentials
                 string-0
                 {:keys [configurations topic-configurations]}]]),
    :doc "Generate map for setBucketNotificationConfiguration, setBucketNotificationConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-bucket-notification-configuration,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :set-bucket-notification-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   set-bucket-notification-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         notification-configuration
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         bucket-notification-configuration
                         clone-root
                         bucket]}]
                [credentials
                 string-0
                 {:keys [configurations topic-configurations]}]]),
    :doc "Call setBucketNotificationConfiguration, setBucketNotificationConfiguration"}
   [credentials13734 & args13735]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13740
     (com.palletops.awaze.common/aws-client :s3 credentials13734)]
    (clojure.core/case
     (clojure.core/count args13735)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13740
       setBucketNotificationConfiguration
       (s3/set-bucket-notification-configuration-request
        (clojure.core/nth args13735 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13740
       setBucketNotificationConfiguration
       (clojure.core/str (clojure.core/nth args13735 0))
       (s3/bucket-notification-configuration
        (clojure.core/nth args13735 1))))))))
 (do
  (clojure.core/defmethod
   s3
   :set-object-redirect-location
   [m13741]
   (clojure.core/let
    [credentials13742 (:credentials m13741) args13743 (:args m13741)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13744
      (com.palletops.awaze.common/aws-client :s3 credentials13742)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13744
       setObjectRedirectLocation
       (clojure.core/str (clojure.core/nth args13743 0))
       (clojure.core/str (clojure.core/nth args13743 1))
       (clojure.core/str (clojure.core/nth args13743 2)))))))
  (clojure.core/defn
   set-object-redirect-location-map
   {:arglists (quote [[credentials string-0 string-1 string-2]]),
    :doc "Generate map for setObjectRedirectLocation"}
   ([credentials__1842__auto__ a b c]
    {:args [a b c],
     :fn :set-object-redirect-location,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   set-object-redirect-location
   {:arglists (quote [[credentials string-0 string-1 string-2]]),
    :doc "Call setObjectRedirectLocation"}
   [credentials13746 & args13747]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13748
     (com.palletops.awaze.common/aws-client :s3 credentials13746)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13748
      setObjectRedirectLocation
      (clojure.core/str (clojure.core/nth args13747 0))
      (clojure.core/str (clojure.core/nth args13747 1))
      (clojure.core/str (clojure.core/nth args13747 2)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-url
   [m13749]
   (clojure.core/let
    [credentials13750 (:credentials m13749) args13751 (:args m13749)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13752
      (com.palletops.awaze.common/aws-client :s3 credentials13750)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13752
       getUrl
       (clojure.core/str (clojure.core/nth args13751 0))
       (clojure.core/str (clojure.core/nth args13751 1)))))))
  (clojure.core/defn
   get-url-map
   {:arglists (quote [[credentials string-0 string-1]]),
    :doc "Generate map for getUrl"}
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :get-url,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-url
   {:arglists (quote [[credentials string-0 string-1]]),
    :doc "Call getUrl"}
   [credentials13754 & args13755]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13756
     (com.palletops.awaze.common/aws-client :s3 credentials13754)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13756
      getUrl
      (clojure.core/str (clojure.core/nth args13755 0))
      (clojure.core/str (clojure.core/nth args13755 1)))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-bucket-policy
   [m13757]
   (clojure.core/let
    [credentials13758 (:credentials m13757) args13759 (:args m13757)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13760
      (com.palletops.awaze.common/aws-client :s3 credentials13758)]
     (clojure.core/case
      (clojure.core/count args13759)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.DeleteBucketPolicyRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.DeleteBucketPolicyRequest
           (clojure.core/nth args13759 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13760
           deleteBucketPolicy
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13759 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13760
               deleteBucketPolicy
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteBucketPolicy")
                {:args args13759}))))))))))))))
  (clojure.core/defn
   delete-bucket-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]
                [credentials string-0]]),
    :doc "Generate map for deleteBucketPolicy, deleteBucketPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-bucket-policy,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   delete-bucket-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]
                [credentials string-0]]),
    :doc "Call deleteBucketPolicy, deleteBucketPolicy"}
   [credentials13763 & args13764]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13766
     (com.palletops.awaze.common/aws-client :s3 credentials13763)]
    (clojure.core/case
     (clojure.core/count args13764)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.DeleteBucketPolicyRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.DeleteBucketPolicyRequest
          (clojure.core/nth args13764 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13766
          deleteBucketPolicy
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13764 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13766
              deleteBucketPolicy
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteBucketPolicy")
               {:args args13764}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :disable-requester-pays
   [m13767]
   (clojure.core/let
    [credentials13768 (:credentials m13767) args13769 (:args m13767)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13770
      (com.palletops.awaze.common/aws-client :s3 credentials13768)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13770
       disableRequesterPays
       (clojure.core/str (clojure.core/nth args13769 0)))))))
  (clojure.core/defn
   disable-requester-pays-map
   {:arglists (quote [[credentials string-0]]),
    :doc "Generate map for disableRequesterPays"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :disable-requester-pays,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   disable-requester-pays
   {:arglists (quote [[credentials string-0]]),
    :doc "Call disableRequesterPays"}
   [credentials13772 & args13773]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13774
     (com.palletops.awaze.common/aws-client :s3 credentials13772)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13774
      disableRequesterPays
      (clojure.core/str (clojure.core/nth args13773 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :head-bucket
   [m13775]
   (clojure.core/let
    [credentials13776 (:credentials m13775) args13777 (:args m13775)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13778
      (com.palletops.awaze.common/aws-client :s3 credentials13776)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13778
       headBucket
       (s3/head-bucket-request (clojure.core/nth args13777 0)))))))
  (clojure.core/defn
   head-bucket-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for headBucket"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :head-bucket,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   head-bucket
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Call headBucket"}
   [credentials13781 & args13782]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13784
     (com.palletops.awaze.common/aws-client :s3 credentials13781)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13784
      headBucket
      (s3/head-bucket-request (clojure.core/nth args13782 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :set-s3client-options
   [m13785]
   (clojure.core/let
    [credentials13786 (:credentials m13785) args13787 (:args m13785)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13788
      (com.palletops.awaze.common/aws-client :s3 credentials13786)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13788
       setS3ClientOptions
       (s3/s3client-options (clojure.core/nth args13787 0)))))))
  (clojure.core/defn
   set-s3client-options-map
   {:arglists (quote
               [[credentials
                 {:keys [chunked-encoding-disabled path-style-access]}]]),
    :doc "Generate map for setS3ClientOptions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-s3client-options,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   set-s3client-options
   {:arglists (quote
               [[credentials
                 {:keys [chunked-encoding-disabled path-style-access]}]]),
    :doc "Call setS3ClientOptions"}
   [credentials13790 & args13791]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13792
     (com.palletops.awaze.common/aws-client :s3 credentials13790)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13792
      setS3ClientOptions
      (s3/s3client-options (clojure.core/nth args13791 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-notification-configuration
   [m13793]
   (clojure.core/let
    [credentials13794 (:credentials m13793) args13795 (:args m13793)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13796
      (com.palletops.awaze.common/aws-client :s3 credentials13794)]
     (clojure.core/case
      (clojure.core/count args13795)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.GetBucketNotificationConfigurationRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.GetBucketNotificationConfigurationRequest
           (clojure.core/nth args13795 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13796
           getBucketNotificationConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13795 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13796
               getBucketNotificationConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketNotificationConfiguration")
                {:args args13795}))))))))))))))
  (clojure.core/defn
   get-bucket-notification-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]
                [credentials string-0]]),
    :doc "Generate map for getBucketNotificationConfiguration, getBucketNotificationConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-bucket-notification-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-bucket-notification-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]
                [credentials string-0]]),
    :doc "Call getBucketNotificationConfiguration, getBucketNotificationConfiguration"}
   [credentials13799 & args13800]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13802
     (com.palletops.awaze.common/aws-client :s3 credentials13799)]
    (clojure.core/case
     (clojure.core/count args13800)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.GetBucketNotificationConfigurationRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.GetBucketNotificationConfigurationRequest
          (clojure.core/nth args13800 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13802
          getBucketNotificationConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13800 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13802
              getBucketNotificationConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketNotificationConfiguration")
               {:args args13800}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-bucket-lifecycle-configuration
   [m13803]
   (clojure.core/let
    [credentials13804 (:credentials m13803) args13805 (:args m13803)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13806
      (com.palletops.awaze.common/aws-client :s3 credentials13804)]
     (clojure.core/case
      (clojure.core/count args13805)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13805 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13806
           deleteBucketLifecycleConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.DeleteBucketLifecycleConfigurationRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.DeleteBucketLifecycleConfigurationRequest
               (clojure.core/nth args13805 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13806
               deleteBucketLifecycleConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteBucketLifecycleConfiguration")
                {:args args13805}))))))))))))))
  (clojure.core/defn
   delete-bucket-lifecycle-configuration-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Generate map for deleteBucketLifecycleConfiguration, deleteBucketLifecycleConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-bucket-lifecycle-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   delete-bucket-lifecycle-configuration
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Call deleteBucketLifecycleConfiguration, deleteBucketLifecycleConfiguration"}
   [credentials13809 & args13810]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13812
     (com.palletops.awaze.common/aws-client :s3 credentials13809)]
    (clojure.core/case
     (clojure.core/count args13810)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13810 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13812
          deleteBucketLifecycleConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.DeleteBucketLifecycleConfigurationRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.DeleteBucketLifecycleConfigurationRequest
              (clojure.core/nth args13810 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13812
              deleteBucketLifecycleConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteBucketLifecycleConfiguration")
               {:args args13810}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :list-objects
   [m13813]
   (clojure.core/let
    [credentials13814 (:credentials m13813) args13815 (:args m13813)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13816
      (com.palletops.awaze.common/aws-client :s3 credentials13814)]
     (clojure.core/case
      (clojure.core/count args13815)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13816
        listObjects
        (clojure.core/str (clojure.core/nth args13815 0))
        (clojure.core/str (clojure.core/nth args13815 1))))
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13815 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13816
           listObjects
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.ListObjectsRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.ListObjectsRequest
               (clojure.core/nth args13815 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13816
               listObjects
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "listObjects")
                {:args args13815}))))))))))))))
  (clojure.core/defn
   list-objects-map
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         encoding-type
                         sdk-request-timeout
                         marker
                         max-keys
                         custom-query-parameters
                         prefix
                         delimiter
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listObjects, listObjects, listObjects"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-objects,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :list-objects,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   list-objects
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         encoding-type
                         sdk-request-timeout
                         marker
                         max-keys
                         custom-query-parameters
                         prefix
                         delimiter
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Call listObjects, listObjects, listObjects"}
   [credentials13818 & args13819]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13820
     (com.palletops.awaze.common/aws-client :s3 credentials13818)]
    (clojure.core/case
     (clojure.core/count args13819)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13820
       listObjects
       (clojure.core/str (clojure.core/nth args13819 0))
       (clojure.core/str (clojure.core/nth args13819 1))))
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13819 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13820
          listObjects
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.ListObjectsRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.ListObjectsRequest
              (clojure.core/nth args13819 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13820
              listObjects
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "listObjects")
               {:args args13819}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-resource-url
   [m13821]
   (clojure.core/let
    [credentials13822 (:credentials m13821) args13823 (:args m13821)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13824
      (com.palletops.awaze.common/aws-client :s3 credentials13822)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13824
       getResourceUrl
       (clojure.core/str (clojure.core/nth args13823 0))
       (clojure.core/str (clojure.core/nth args13823 1)))))))
  (clojure.core/defn
   get-resource-url-map
   {:arglists (quote [[credentials string-0 string-1]]),
    :doc "Generate map for getResourceUrl"}
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :get-resource-url,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-resource-url
   {:arglists (quote [[credentials string-0 string-1]]),
    :doc "Call getResourceUrl"}
   [credentials13826 & args13827]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13828
     (com.palletops.awaze.common/aws-client :s3 credentials13826)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13828
      getResourceUrl
      (clojure.core/str (clojure.core/nth args13827 0))
      (clojure.core/str (clojure.core/nth args13827 1)))))))
 (do
  (clojure.core/defmethod
   s3
   :enable-requester-pays
   [m13829]
   (clojure.core/let
    [credentials13830 (:credentials m13829) args13831 (:args m13829)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13832
      (com.palletops.awaze.common/aws-client :s3 credentials13830)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13832
       enableRequesterPays
       (clojure.core/str (clojure.core/nth args13831 0)))))))
  (clojure.core/defn
   enable-requester-pays-map
   {:arglists (quote [[credentials string-0]]),
    :doc "Generate map for enableRequesterPays"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :enable-requester-pays,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   enable-requester-pays
   {:arglists (quote [[credentials string-0]]),
    :doc "Call enableRequesterPays"}
   [credentials13834 & args13835]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13836
     (com.palletops.awaze.common/aws-client :s3 credentials13834)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13836
      enableRequesterPays
      (clojure.core/str (clojure.core/nth args13835 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :abort-multipart-upload
   [m13837]
   (clojure.core/let
    [credentials13838 (:credentials m13837) args13839 (:args m13837)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13840
      (com.palletops.awaze.common/aws-client :s3 credentials13838)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13840
       abortMultipartUpload
       (s3/abort-multipart-upload-request
        (clojure.core/nth args13839 0)))))))
  (clojure.core/defn
   abort-multipart-upload-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         upload-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays]}]]),
    :doc "Generate map for abortMultipartUpload"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :abort-multipart-upload,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   abort-multipart-upload
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         upload-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays]}]]),
    :doc "Call abortMultipartUpload"}
   [credentials13845 & args13846]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13850
     (com.palletops.awaze.common/aws-client :s3 credentials13845)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13850
      abortMultipartUpload
      (s3/abort-multipart-upload-request
       (clojure.core/nth args13846 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-s3account-owner
   [m13851]
   (clojure.core/let
    [credentials13852 (:credentials m13851) args13853 (:args m13851)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13854
      (com.palletops.awaze.common/aws-client :s3 credentials13852)]
     (clojure.core/case
      (clojure.core/count args13853)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13854
        getS3AccountOwner
        (s3/get-s3account-owner-request
         (clojure.core/nth args13853 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13854
        getS3AccountOwner))))))
  (clojure.core/defn
   get-s3account-owner-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for getS3AccountOwner, getS3AccountOwner"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-s3account-owner,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-s3account-owner,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-s3account-owner
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call getS3AccountOwner, getS3AccountOwner"}
   [credentials13856 & args13857]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13858
     (com.palletops.awaze.common/aws-client :s3 credentials13856)]
    (clojure.core/case
     (clojure.core/count args13857)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13858
       getS3AccountOwner
       (s3/get-s3account-owner-request (clojure.core/nth args13857 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13858
       getS3AccountOwner))))))
 (do
  (clojure.core/defmethod
   s3
   :list-buckets
   [m13859]
   (clojure.core/let
    [credentials13860 (:credentials m13859) args13861 (:args m13859)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13862
      (com.palletops.awaze.common/aws-client :s3 credentials13860)]
     (clojure.core/case
      (clojure.core/count args13861)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13862
        listBuckets
        (s3/list-buckets-request (clojure.core/nth args13861 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13862
        listBuckets))))))
  (clojure.core/defn
   list-buckets-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listBuckets, listBuckets"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-buckets,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-buckets,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   list-buckets
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listBuckets, listBuckets"}
   [credentials13864 & args13865]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13866
     (com.palletops.awaze.common/aws-client :s3 credentials13864)]
    (clojure.core/case
     (clojure.core/count args13865)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13866
       listBuckets
       (s3/list-buckets-request (clojure.core/nth args13865 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13866
       listBuckets))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-website-configuration
   [m13867]
   (clojure.core/let
    [credentials13868 (:credentials m13867) args13869 (:args m13867)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13870
      (com.palletops.awaze.common/aws-client :s3 credentials13868)]
     (clojure.core/case
      (clojure.core/count args13869)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.GetBucketWebsiteConfigurationRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.GetBucketWebsiteConfigurationRequest
           (clojure.core/nth args13869 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13870
           getBucketWebsiteConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13869 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13870
               getBucketWebsiteConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketWebsiteConfiguration")
                {:args args13869}))))))))))))))
  (clojure.core/defn
   get-bucket-website-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]
                [credentials string-0]]),
    :doc "Generate map for getBucketWebsiteConfiguration, getBucketWebsiteConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-bucket-website-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-bucket-website-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]
                [credentials string-0]]),
    :doc "Call getBucketWebsiteConfiguration, getBucketWebsiteConfiguration"}
   [credentials13873 & args13874]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13876
     (com.palletops.awaze.common/aws-client :s3 credentials13873)]
    (clojure.core/case
     (clojure.core/count args13874)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.GetBucketWebsiteConfigurationRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.GetBucketWebsiteConfigurationRequest
          (clojure.core/nth args13874 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13876
          getBucketWebsiteConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13874 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13876
              getBucketWebsiteConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketWebsiteConfiguration")
               {:args args13874}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :list-parts
   [m13877]
   (clojure.core/let
    [credentials13878 (:credentials m13877) args13879 (:args m13877)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13880
      (com.palletops.awaze.common/aws-client :s3 credentials13878)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13880
       listParts
       (s3/list-parts-request (clojure.core/nth args13879 0)))))))
  (clojure.core/defn
   list-parts-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         encoding-type
                         key
                         sdk-request-timeout
                         upload-id
                         custom-query-parameters
                         part-number-marker
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         max-parts
                         clone-root
                         requester-pays]}]]),
    :doc "Generate map for listParts"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-parts,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   list-parts
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         encoding-type
                         key
                         sdk-request-timeout
                         upload-id
                         custom-query-parameters
                         part-number-marker
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         max-parts
                         clone-root
                         requester-pays]}]]),
    :doc "Call listParts"}
   [credentials13885 & args13886]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13890
     (com.palletops.awaze.common/aws-client :s3 credentials13885)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13890
      listParts
      (s3/list-parts-request (clojure.core/nth args13886 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-acl
   [m13891]
   (clojure.core/let
    [credentials13892 (:credentials m13891) args13893 (:args m13891)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13894
      (com.palletops.awaze.common/aws-client :s3 credentials13892)]
     (clojure.core/case
      (clojure.core/count args13893)
      3
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13893 0))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
b
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.AccessControlList
           (clojure.core/nth args13893 1))
^{:tag com.amazonaws.metrics.RequestMetricCollector}
c
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.metrics.RequestMetricCollector
           (clojure.core/nth args13893 2))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13894
           setBucketAcl
           a
           b
           c)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13893 0))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
b
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.CannedAccessControlList
               (clojure.core/nth args13893 1))
^{:tag com.amazonaws.metrics.RequestMetricCollector}
c
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.metrics.RequestMetricCollector
               (clojure.core/nth args13893 2))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13894
               setBucketAcl
               a
               b
               c)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "setBucketAcl")
                {:args args13893}))))))))))
      2
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13893 0))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
b
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.CannedAccessControlList
           (clojure.core/nth args13893 1))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13894
           setBucketAcl
           a
           b)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13893 0))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
b
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.AccessControlList
               (clojure.core/nth args13893 1))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13894
               setBucketAcl
               a
               b)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "setBucketAcl")
                {:args args13893}))))))))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13894
        setBucketAcl
        (s3/set-bucket-acl-request (clojure.core/nth args13893 0))))))))
  (clojure.core/defn
   set-bucket-acl-map
   {:arglists (quote
               [[credentials
                 string-0
                 {:keys [grants
                         grants-as-list
                         owner
                         requester-charged]}
                 request-metric-collector-2]
                [credentials string-0 canned-access-control-list-1]
                [credentials
                 string-0
                 canned-access-control-list-1
                 request-metric-collector-2]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         acl
                         bucket-name
                         clone-source
                         clone-root
                         canned-acl]}]
                [credentials
                 string-0
                 {:keys [grants
                         grants-as-list
                         owner
                         requester-charged]}]]),
    :doc "Generate map for setBucketAcl, setBucketAcl, setBucketAcl, setBucketAcl, setBucketAcl"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-bucket-acl,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :set-bucket-acl,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b c]
    {:args [a b c],
     :fn :set-bucket-acl,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   set-bucket-acl
   {:arglists (quote
               [[credentials
                 string-0
                 {:keys [grants
                         grants-as-list
                         owner
                         requester-charged]}
                 request-metric-collector-2]
                [credentials string-0 canned-access-control-list-1]
                [credentials
                 string-0
                 canned-access-control-list-1
                 request-metric-collector-2]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         acl
                         bucket-name
                         clone-source
                         clone-root
                         canned-acl]}]
                [credentials
                 string-0
                 {:keys [grants
                         grants-as-list
                         owner
                         requester-charged]}]]),
    :doc "Call setBucketAcl, setBucketAcl, setBucketAcl, setBucketAcl, setBucketAcl"}
   [credentials13900 & args13901]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13906
     (com.palletops.awaze.common/aws-client :s3 credentials13900)]
    (clojure.core/case
     (clojure.core/count args13901)
     3
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13901 0))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
b
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.AccessControlList
          (clojure.core/nth args13901 1))
^{:tag com.amazonaws.metrics.RequestMetricCollector}
c
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.metrics.RequestMetricCollector
          (clojure.core/nth args13901 2))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13906
          setBucketAcl
          a
          b
          c)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13901 0))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
b
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.CannedAccessControlList
              (clojure.core/nth args13901 1))
^{:tag com.amazonaws.metrics.RequestMetricCollector}
c
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.metrics.RequestMetricCollector
              (clojure.core/nth args13901 2))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13906
              setBucketAcl
              a
              b
              c)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "setBucketAcl")
               {:args args13901}))))))))))
     2
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13901 0))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
b
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.CannedAccessControlList
          (clojure.core/nth args13901 1))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13906
          setBucketAcl
          a
          b)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13901 0))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
b
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.AccessControlList
              (clojure.core/nth args13901 1))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13906
              setBucketAcl
              a
              b)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "setBucketAcl")
               {:args args13901}))))))))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13906
       setBucketAcl
       (s3/set-bucket-acl-request (clojure.core/nth args13901 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :copy-part
   [m13907]
   (clojure.core/let
    [credentials13908 (:credentials m13907) args13909 (:args m13907)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13910
      (com.palletops.awaze.common/aws-client :s3 credentials13908)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13910
       copyPart
       (s3/copy-part-request (clojure.core/nth args13909 0)))))))
  (clojure.core/defn
   copy-part-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         unmodified-since-constraint
                         sdk-request-timeout
                         nonmatching-etag-constraints
                         upload-id
                         source-key
                         modified-since-constraint
                         first-byte
                         custom-query-parameters
                         destination-ssecustomer-key
                         read-limit
                         last-byte
                         destination-bucket-name
                         general-progress-listener
                         source-version-id
                         part-number
                         clone-source
                         matching-etag-constraints
                         source-bucket-name
                         clone-root
                         source-ssecustomer-key
                         destination-key]}]]),
    :doc "Generate map for copyPart"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :copy-part,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   copy-part
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         unmodified-since-constraint
                         sdk-request-timeout
                         nonmatching-etag-constraints
                         upload-id
                         source-key
                         modified-since-constraint
                         first-byte
                         custom-query-parameters
                         destination-ssecustomer-key
                         read-limit
                         last-byte
                         destination-bucket-name
                         general-progress-listener
                         source-version-id
                         part-number
                         clone-source
                         matching-etag-constraints
                         source-bucket-name
                         clone-root
                         source-ssecustomer-key
                         destination-key]}]]),
    :doc "Call copyPart"}
   [credentials13912 & args13913]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13914
     (com.palletops.awaze.common/aws-client :s3 credentials13912)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13914
      copyPart
      (s3/copy-part-request (clojure.core/nth args13913 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-replication-configuration
   [m13915]
   (clojure.core/let
    [credentials13916 (:credentials m13915) args13917 (:args m13915)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13918
      (com.palletops.awaze.common/aws-client :s3 credentials13916)]
     (clojure.core/case
      (clojure.core/count args13917)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13917 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13918
           getBucketReplicationConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.GetBucketReplicationConfigurationRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.GetBucketReplicationConfigurationRequest
               (clojure.core/nth args13917 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13918
               getBucketReplicationConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketReplicationConfiguration")
                {:args args13917}))))))))))))))
  (clojure.core/defn
   get-bucket-replication-configuration-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Generate map for getBucketReplicationConfiguration, getBucketReplicationConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-bucket-replication-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-bucket-replication-configuration
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Call getBucketReplicationConfiguration, getBucketReplicationConfiguration"}
   [credentials13921 & args13922]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13924
     (com.palletops.awaze.common/aws-client :s3 credentials13921)]
    (clojure.core/case
     (clojure.core/count args13922)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13922 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13924
          getBucketReplicationConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.GetBucketReplicationConfigurationRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.GetBucketReplicationConfigurationRequest
              (clojure.core/nth args13922 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13924
              getBucketReplicationConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketReplicationConfiguration")
               {:args args13922}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-versioning-configuration
   [m13925]
   (clojure.core/let
    [credentials13926 (:credentials m13925) args13927 (:args m13925)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13928
      (com.palletops.awaze.common/aws-client :s3 credentials13926)]
     (clojure.core/case
      (clojure.core/count args13927)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13927 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13928
           getBucketVersioningConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.GetBucketVersioningConfigurationRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.GetBucketVersioningConfigurationRequest
               (clojure.core/nth args13927 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13928
               getBucketVersioningConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketVersioningConfiguration")
                {:args args13927}))))))))))))))
  (clojure.core/defn
   get-bucket-versioning-configuration-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Generate map for getBucketVersioningConfiguration, getBucketVersioningConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-bucket-versioning-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-bucket-versioning-configuration
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Call getBucketVersioningConfiguration, getBucketVersioningConfiguration"}
   [credentials13931 & args13932]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13934
     (com.palletops.awaze.common/aws-client :s3 credentials13931)]
    (clojure.core/case
     (clojure.core/count args13932)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13932 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13934
          getBucketVersioningConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.GetBucketVersioningConfigurationRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.GetBucketVersioningConfigurationRequest
              (clojure.core/nth args13932 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13934
              getBucketVersioningConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketVersioningConfiguration")
               {:args args13932}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :list-next-batch-of-versions
   [m13935]
   (clojure.core/let
    [credentials13936 (:credentials m13935) args13937 (:args m13935)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13938
      (com.palletops.awaze.common/aws-client :s3 credentials13936)]
     (clojure.core/case
      (clojure.core/count args13937)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.VersionListing}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.VersionListing
           (clojure.core/nth args13937 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13938
           listNextBatchOfVersions
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.ListNextBatchOfVersionsRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.ListNextBatchOfVersionsRequest
               (clojure.core/nth args13937 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13938
               listNextBatchOfVersions
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "listNextBatchOfVersions")
                {:args args13937}))))))))))))))
  (clojure.core/defn
   list-next-batch-of-versions-map
   {:arglists (quote
               [[credentials
                 {:keys [encoding-type
                         common-prefixes
                         max-keys
                         next-key-marker
                         version-id-marker
                         prefix
                         delimiter
                         version-summaries
                         truncated
                         bucket-name
                         next-version-id-marker
                         key-marker]}]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         previous-version-listing
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listNextBatchOfVersions, listNextBatchOfVersions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-next-batch-of-versions,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   list-next-batch-of-versions
   {:arglists (quote
               [[credentials
                 {:keys [encoding-type
                         common-prefixes
                         max-keys
                         next-key-marker
                         version-id-marker
                         prefix
                         delimiter
                         version-summaries
                         truncated
                         bucket-name
                         next-version-id-marker
                         key-marker]}]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         previous-version-listing
                         clone-source
                         clone-root]}]]),
    :doc "Call listNextBatchOfVersions, listNextBatchOfVersions"}
   [credentials13941 & args13942]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13944
     (com.palletops.awaze.common/aws-client :s3 credentials13941)]
    (clojure.core/case
     (clojure.core/count args13942)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.VersionListing}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.VersionListing
          (clojure.core/nth args13942 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13944
          listNextBatchOfVersions
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.ListNextBatchOfVersionsRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.ListNextBatchOfVersionsRequest
              (clojure.core/nth args13942 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13944
              listNextBatchOfVersions
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "listNextBatchOfVersions")
               {:args args13942}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-acl
   [m13945]
   (clojure.core/let
    [credentials13946 (:credentials m13945) args13947 (:args m13945)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13948
      (com.palletops.awaze.common/aws-client :s3 credentials13946)]
     (clojure.core/case
      (clojure.core/count args13947)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.GetBucketAclRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.GetBucketAclRequest
           (clojure.core/nth args13947 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13948
           getBucketAcl
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13947 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13948
               getBucketAcl
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketAcl")
                {:args args13947}))))))))))))))
  (clojure.core/defn
   get-bucket-acl-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]
                [credentials string-0]]),
    :doc "Generate map for getBucketAcl, getBucketAcl"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-bucket-acl,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-bucket-acl
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]
                [credentials string-0]]),
    :doc "Call getBucketAcl, getBucketAcl"}
   [credentials13951 & args13952]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13954
     (com.palletops.awaze.common/aws-client :s3 credentials13951)]
    (clojure.core/case
     (clojure.core/count args13952)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.GetBucketAclRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.GetBucketAclRequest
          (clojure.core/nth args13952 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13954
          getBucketAcl
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13952 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13954
              getBucketAcl
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketAcl")
               {:args args13952}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-object
   [m13955]
   (clojure.core/let
    [credentials13956 (:credentials m13955) args13957 (:args m13955)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13958
      (com.palletops.awaze.common/aws-client :s3 credentials13956)]
     (clojure.core/case
      (clojure.core/count args13957)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13958
        deleteObject
        (s3/delete-object-request (clojure.core/nth args13957 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13958
        deleteObject
        (clojure.core/str (clojure.core/nth args13957 0))
        (clojure.core/str (clojure.core/nth args13957 1))))))))
  (clojure.core/defn
   delete-object-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays]}]
                [credentials string-0 string-1]]),
    :doc "Generate map for deleteObject, deleteObject"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-object,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :delete-object,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   delete-object
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays]}]
                [credentials string-0 string-1]]),
    :doc "Call deleteObject, deleteObject"}
   [credentials13962 & args13963]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13966
     (com.palletops.awaze.common/aws-client :s3 credentials13962)]
    (clojure.core/case
     (clojure.core/count args13963)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13966
       deleteObject
       (s3/delete-object-request (clojure.core/nth args13963 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13966
       deleteObject
       (clojure.core/str (clojure.core/nth args13963 0))
       (clojure.core/str (clojure.core/nth args13963 1))))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-bucket-tagging-configuration
   [m13967]
   (clojure.core/let
    [credentials13968 (:credentials m13967) args13969 (:args m13967)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13970
      (com.palletops.awaze.common/aws-client :s3 credentials13968)]
     (clojure.core/case
      (clojure.core/count args13969)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.DeleteBucketTaggingConfigurationRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.DeleteBucketTaggingConfigurationRequest
           (clojure.core/nth args13969 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13970
           deleteBucketTaggingConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13969 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13970
               deleteBucketTaggingConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteBucketTaggingConfiguration")
                {:args args13969}))))))))))))))
  (clojure.core/defn
   delete-bucket-tagging-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]
                [credentials string-0]]),
    :doc "Generate map for deleteBucketTaggingConfiguration, deleteBucketTaggingConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-bucket-tagging-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   delete-bucket-tagging-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]
                [credentials string-0]]),
    :doc "Call deleteBucketTaggingConfiguration, deleteBucketTaggingConfiguration"}
   [credentials13973 & args13974]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13976
     (com.palletops.awaze.common/aws-client :s3 credentials13973)]
    (clojure.core/case
     (clojure.core/count args13974)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.DeleteBucketTaggingConfigurationRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.DeleteBucketTaggingConfigurationRequest
          (clojure.core/nth args13974 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13976
          deleteBucketTaggingConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13974 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13976
              deleteBucketTaggingConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteBucketTaggingConfiguration")
               {:args args13974}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-logging-configuration
   [m13977]
   (clojure.core/let
    [credentials13978 (:credentials m13977) args13979 (:args m13977)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13980
      (com.palletops.awaze.common/aws-client :s3 credentials13978)]
     (clojure.core/case
      (clojure.core/count args13979)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13979 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13980
           getBucketLoggingConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.GetBucketLoggingConfigurationRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.GetBucketLoggingConfigurationRequest
               (clojure.core/nth args13979 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13980
               getBucketLoggingConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketLoggingConfiguration")
                {:args args13979}))))))))))))))
  (clojure.core/defn
   get-bucket-logging-configuration-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Generate map for getBucketLoggingConfiguration, getBucketLoggingConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-bucket-logging-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-bucket-logging-configuration
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Call getBucketLoggingConfiguration, getBucketLoggingConfiguration"}
   [credentials13983 & args13984]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13986
     (com.palletops.awaze.common/aws-client :s3 credentials13983)]
    (clojure.core/case
     (clojure.core/count args13984)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13984 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13986
          getBucketLoggingConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.GetBucketLoggingConfigurationRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.GetBucketLoggingConfigurationRequest
              (clojure.core/nth args13984 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13986
              getBucketLoggingConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketLoggingConfiguration")
               {:args args13984}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :generate-presigned-url
   [m13987]
   (clojure.core/let
    [credentials13988 (:credentials m13987) args13989 (:args m13987)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13990
      (com.palletops.awaze.common/aws-client :s3 credentials13988)]
     (clojure.core/case
      (clojure.core/count args13989)
      4
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13990
        generatePresignedUrl
        (clojure.core/str (clojure.core/nth args13989 0))
        (clojure.core/str (clojure.core/nth args13989 1))
        (com.palletops.awaze.common/to-date
         (clojure.core/nth args13989 2))
        (root/http-method (clojure.core/nth args13989 3))))
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13990
        generatePresignedUrl
        (clojure.core/str (clojure.core/nth args13989 0))
        (clojure.core/str (clojure.core/nth args13989 1))
        (com.palletops.awaze.common/to-date
         (clojure.core/nth args13989 2))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13990
        generatePresignedUrl
        (s3/generate-presigned-url-request
         (clojure.core/nth args13989 0))))))))
  (clojure.core/defn
   generate-presigned-url-map
   {:arglists (quote
               [[credentials string-0 string-1 date-2 http-method-3]
                [credentials string-0 string-1 date-2]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         kms-cmk-id
                         key
                         method
                         sdk-request-timeout
                         expiration
                         custom-query-parameters
                         ssealgorithm
                         read-limit
                         ssecustomer-key
                         general-progress-listener
                         content-type
                         bucket-name
                         content-md5
                         clone-source
                         clone-root
                         request-parameters
                         response-headers
                         zero-byte-content]}]]),
    :doc "Generate map for generatePresignedUrl, generatePresignedUrl, generatePresignedUrl"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :generate-presigned-url,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b c]
    {:args [a b c],
     :fn :generate-presigned-url,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b c d]
    {:args [a b c d],
     :fn :generate-presigned-url,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   generate-presigned-url
   {:arglists (quote
               [[credentials string-0 string-1 date-2 http-method-3]
                [credentials string-0 string-1 date-2]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         kms-cmk-id
                         key
                         method
                         sdk-request-timeout
                         expiration
                         custom-query-parameters
                         ssealgorithm
                         read-limit
                         ssecustomer-key
                         general-progress-listener
                         content-type
                         bucket-name
                         content-md5
                         clone-source
                         clone-root
                         request-parameters
                         response-headers
                         zero-byte-content]}]]),
    :doc "Call generatePresignedUrl, generatePresignedUrl, generatePresignedUrl"}
   [credentials13994 & args13995]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13998
     (com.palletops.awaze.common/aws-client :s3 credentials13994)]
    (clojure.core/case
     (clojure.core/count args13995)
     4
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13998
       generatePresignedUrl
       (clojure.core/str (clojure.core/nth args13995 0))
       (clojure.core/str (clojure.core/nth args13995 1))
       (com.palletops.awaze.common/to-date
        (clojure.core/nth args13995 2))
       (root/http-method (clojure.core/nth args13995 3))))
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13998
       generatePresignedUrl
       (clojure.core/str (clojure.core/nth args13995 0))
       (clojure.core/str (clojure.core/nth args13995 1))
       (com.palletops.awaze.common/to-date
        (clojure.core/nth args13995 2))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13998
       generatePresignedUrl
       (s3/generate-presigned-url-request
        (clojure.core/nth args13995 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :is-requester-pays-enabled
   [m13999]
   (clojure.core/let
    [credentials14000 (:credentials m13999) args14001 (:args m13999)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14002
      (com.palletops.awaze.common/aws-client :s3 credentials14000)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14002
       isRequesterPaysEnabled
       (clojure.core/str (clojure.core/nth args14001 0)))))))
  (clojure.core/defn
   is-requester-pays-enabled-map
   {:arglists (quote [[credentials string-0]]),
    :doc "Generate map for isRequesterPaysEnabled"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :is-requester-pays-enabled,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   is-requester-pays-enabled
   {:arglists (quote [[credentials string-0]]),
    :doc "Call isRequesterPaysEnabled"}
   [credentials14004 & args14005]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14006
     (com.palletops.awaze.common/aws-client :s3 credentials14004)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14006
      isRequesterPaysEnabled
      (clojure.core/str (clojure.core/nth args14005 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :copy-object
   [m14007]
   (clojure.core/let
    [credentials14008 (:credentials m14007) args14009 (:args m14007)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14010
      (com.palletops.awaze.common/aws-client :s3 credentials14008)]
     (clojure.core/case
      (clojure.core/count args14009)
      4
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14010
        copyObject
        (clojure.core/str (clojure.core/nth args14009 0))
        (clojure.core/str (clojure.core/nth args14009 1))
        (clojure.core/str (clojure.core/nth args14009 2))
        (clojure.core/str (clojure.core/nth args14009 3))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14010
        copyObject
        (s3/copy-object-request (clojure.core/nth args14009 0))))))))
  (clojure.core/defn
   copy-object-map
   {:arglists (quote
               [[credentials string-0 string-1 string-2 string-3]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         storage-class
                         unmodified-since-constraint
                         sdk-request-timeout
                         sseaws-key-management-params
                         nonmatching-etag-constraints
                         access-control-list
                         source-key
                         modified-since-constraint
                         custom-query-parameters
                         destination-ssecustomer-key
                         redirect-location
                         read-limit
                         destination-bucket-name
                         general-progress-listener
                         source-version-id
                         clone-source
                         matching-etag-constraints
                         source-bucket-name
                         clone-root
                         canned-access-control-list
                         new-object-metadata
                         source-ssecustomer-key
                         destination-key
                         requester-pays]}]]),
    :doc "Generate map for copyObject, copyObject"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :copy-object,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b c d]
    {:args [a b c d],
     :fn :copy-object,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   copy-object
   {:arglists (quote
               [[credentials string-0 string-1 string-2 string-3]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         storage-class
                         unmodified-since-constraint
                         sdk-request-timeout
                         sseaws-key-management-params
                         nonmatching-etag-constraints
                         access-control-list
                         source-key
                         modified-since-constraint
                         custom-query-parameters
                         destination-ssecustomer-key
                         redirect-location
                         read-limit
                         destination-bucket-name
                         general-progress-listener
                         source-version-id
                         clone-source
                         matching-etag-constraints
                         source-bucket-name
                         clone-root
                         canned-access-control-list
                         new-object-metadata
                         source-ssecustomer-key
                         destination-key
                         requester-pays]}]]),
    :doc "Call copyObject, copyObject"}
   [credentials14016 & args14017]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14022
     (com.palletops.awaze.common/aws-client :s3 credentials14016)]
    (clojure.core/case
     (clojure.core/count args14017)
     4
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14022
       copyObject
       (clojure.core/str (clojure.core/nth args14017 0))
       (clojure.core/str (clojure.core/nth args14017 1))
       (clojure.core/str (clojure.core/nth args14017 2))
       (clojure.core/str (clojure.core/nth args14017 3))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14022
       copyObject
       (s3/copy-object-request (clojure.core/nth args14017 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-objects
   [m14023]
   (clojure.core/let
    [credentials14024 (:credentials m14023) args14025 (:args m14023)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14026
      (com.palletops.awaze.common/aws-client :s3 credentials14024)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14026
       deleteObjects
       (s3/delete-objects-request (clojure.core/nth args14025 0)))))))
  (clojure.core/defn
   delete-objects-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         mfa
                         quiet
                         sdk-request-timeout
                         custom-query-parameters
                         keys
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays]}]]),
    :doc "Generate map for deleteObjects"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-objects,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   delete-objects
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         mfa
                         quiet
                         sdk-request-timeout
                         custom-query-parameters
                         keys
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays]}]]),
    :doc "Call deleteObjects"}
   [credentials14029 & args14030]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14032
     (com.palletops.awaze.common/aws-client :s3 credentials14029)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14032
      deleteObjects
      (s3/delete-objects-request (clojure.core/nth args14030 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-versioning-configuration
   [m14033]
   (clojure.core/let
    [credentials14034 (:credentials m14033) args14035 (:args m14033)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14036
      (com.palletops.awaze.common/aws-client :s3 credentials14034)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14036
       setBucketVersioningConfiguration
       (s3/set-bucket-versioning-configuration-request
        (clojure.core/nth args14035 0)))))))
  (clojure.core/defn
   set-bucket-versioning-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         mfa
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         versioning-configuration
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setBucketVersioningConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-bucket-versioning-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   set-bucket-versioning-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         mfa
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         versioning-configuration
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Call setBucketVersioningConfiguration"}
   [credentials14040 & args14041]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14044
     (com.palletops.awaze.common/aws-client :s3 credentials14040)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14044
      setBucketVersioningConfiguration
      (s3/set-bucket-versioning-configuration-request
       (clojure.core/nth args14041 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-logging-configuration
   [m14045]
   (clojure.core/let
    [credentials14046 (:credentials m14045) args14047 (:args m14045)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14048
      (com.palletops.awaze.common/aws-client :s3 credentials14046)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14048
       setBucketLoggingConfiguration
       (s3/set-bucket-logging-configuration-request
        (clojure.core/nth args14047 0)))))))
  (clojure.core/defn
   set-bucket-logging-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         logging-configuration
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setBucketLoggingConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-bucket-logging-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   set-bucket-logging-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         logging-configuration
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Call setBucketLoggingConfiguration"}
   [credentials14052 & args14053]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14056
     (com.palletops.awaze.common/aws-client :s3 credentials14052)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14056
      setBucketLoggingConfiguration
      (s3/set-bucket-logging-configuration-request
       (clojure.core/nth args14053 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-object
   [m14057]
   (clojure.core/let
    [credentials14058 (:credentials m14057) args14059 (:args m14057)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14060
      (com.palletops.awaze.common/aws-client :s3 credentials14058)]
     (clojure.core/case
      (clojure.core/count args14059)
      2
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.GetObjectRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.GetObjectRequest
           (clojure.core/nth args14059 0))
^{:tag java.io.File}
b
          (com.palletops.awaze.common/coerce-value-form
           java.io.File
           (clojure.core/nth args14059 1))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14060
           getObject
           a
           b)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args14059 0))
^{:tag java.lang.String}
b
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args14059 1))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14060
               getObject
               a
               b)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getObject")
                {:args args14059}))))))))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14060
        getObject
        (s3/get-object-request (clojure.core/nth args14059 0))))))))
  (clojure.core/defn
   get-object-map
   {:arglists (quote
               [[credentials {:keys []} file-1]
                [credentials string-0 string-1]
                [credentials {:keys []}]]),
    :doc "Generate map for getObject, getObject, getObject"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-object,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :get-object,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-object
   {:arglists (quote
               [[credentials {:keys []} file-1]
                [credentials string-0 string-1]
                [credentials {:keys []}]]),
    :doc "Call getObject, getObject, getObject"}
   [credentials14066 & args14067]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14072
     (com.palletops.awaze.common/aws-client :s3 credentials14066)]
    (clojure.core/case
     (clojure.core/count args14067)
     2
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.GetObjectRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.GetObjectRequest
          (clojure.core/nth args14067 0))
^{:tag java.io.File}
b
         (com.palletops.awaze.common/coerce-value-form
          java.io.File
          (clojure.core/nth args14067 1))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14072
          getObject
          a
          b)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args14067 0))
^{:tag java.lang.String}
b
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args14067 1))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14072
              getObject
              a
              b)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getObject")
               {:args args14067}))))))))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14072
       getObject
       (s3/get-object-request (clojure.core/nth args14067 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-bucket-cross-origin-configuration
   [m14073]
   (clojure.core/let
    [credentials14074 (:credentials m14073) args14075 (:args m14073)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14076
      (com.palletops.awaze.common/aws-client :s3 credentials14074)]
     (clojure.core/case
      (clojure.core/count args14075)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args14075 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14076
           deleteBucketCrossOriginConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.DeleteBucketCrossOriginConfigurationRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.DeleteBucketCrossOriginConfigurationRequest
               (clojure.core/nth args14075 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14076
               deleteBucketCrossOriginConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteBucketCrossOriginConfiguration")
                {:args args14075}))))))))))))))
  (clojure.core/defn
   delete-bucket-cross-origin-configuration-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Generate map for deleteBucketCrossOriginConfiguration, deleteBucketCrossOriginConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-bucket-cross-origin-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   delete-bucket-cross-origin-configuration
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Call deleteBucketCrossOriginConfiguration, deleteBucketCrossOriginConfiguration"}
   [credentials14079 & args14080]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14082
     (com.palletops.awaze.common/aws-client :s3 credentials14079)]
    (clojure.core/case
     (clojure.core/count args14080)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args14080 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14082
          deleteBucketCrossOriginConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.DeleteBucketCrossOriginConfigurationRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.DeleteBucketCrossOriginConfigurationRequest
              (clojure.core/nth args14080 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14082
              deleteBucketCrossOriginConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteBucketCrossOriginConfiguration")
               {:args args14080}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :complete-multipart-upload
   [m14083]
   (clojure.core/let
    [credentials14084 (:credentials m14083) args14085 (:args m14083)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14086
      (com.palletops.awaze.common/aws-client :s3 credentials14084)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14086
       completeMultipartUpload
       (s3/complete-multipart-upload-request
        (clojure.core/nth args14085 0)))))))
  (clojure.core/defn
   complete-multipart-upload-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         upload-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         part-etags
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays]}]]),
    :doc "Generate map for completeMultipartUpload"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :complete-multipart-upload,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   complete-multipart-upload
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         upload-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         part-etags
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays]}]]),
    :doc "Call completeMultipartUpload"}
   [credentials14088 & args14089]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14090
     (com.palletops.awaze.common/aws-client :s3 credentials14088)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14090
      completeMultipartUpload
      (s3/complete-multipart-upload-request
       (clojure.core/nth args14089 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :restore-object
   [m14091]
   (clojure.core/let
    [credentials14092 (:credentials m14091) args14093 (:args m14091)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14094
      (com.palletops.awaze.common/aws-client :s3 credentials14092)]
     (clojure.core/case
      (clojure.core/count args14093)
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14094
        restoreObject
        (clojure.core/str (clojure.core/nth args14093 0))
        (clojure.core/str (clojure.core/nth args14093 1))
        (clojure.core/int (clojure.core/nth args14093 2))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14094
        restoreObject
        (s3/restore-object-request (clojure.core/nth args14093 0))))))))
  (clojure.core/defn
   restore-object-map
   {:arglists (quote
               [[credentials string-0 string-1 int-2]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         expiration-in-days
                         clone-source
                         clone-root
                         requester-pays]}]]),
    :doc "Generate map for restoreObject, restoreObject"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :restore-object,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b c]
    {:args [a b c],
     :fn :restore-object,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   restore-object
   {:arglists (quote
               [[credentials string-0 string-1 int-2]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         expiration-in-days
                         clone-source
                         clone-root
                         requester-pays]}]]),
    :doc "Call restoreObject, restoreObject"}
   [credentials14098 & args14099]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14102
     (com.palletops.awaze.common/aws-client :s3 credentials14098)]
    (clojure.core/case
     (clojure.core/count args14099)
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14102
       restoreObject
       (clojure.core/str (clojure.core/nth args14099 0))
       (clojure.core/str (clojure.core/nth args14099 1))
       (clojure.core/int (clojure.core/nth args14099 2))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14102
       restoreObject
       (s3/restore-object-request (clojure.core/nth args14099 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-policy
   [m14103]
   (clojure.core/let
    [credentials14104 (:credentials m14103) args14105 (:args m14103)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14106
      (com.palletops.awaze.common/aws-client :s3 credentials14104)]
     (clojure.core/case
      (clojure.core/count args14105)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.GetBucketPolicyRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.GetBucketPolicyRequest
           (clojure.core/nth args14105 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14106
           getBucketPolicy
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args14105 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14106
               getBucketPolicy
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketPolicy")
                {:args args14105}))))))))))))))
  (clojure.core/defn
   get-bucket-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]
                [credentials string-0]]),
    :doc "Generate map for getBucketPolicy, getBucketPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-bucket-policy,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-bucket-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]
                [credentials string-0]]),
    :doc "Call getBucketPolicy, getBucketPolicy"}
   [credentials14109 & args14110]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14112
     (com.palletops.awaze.common/aws-client :s3 credentials14109)]
    (clojure.core/case
     (clojure.core/count args14110)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.GetBucketPolicyRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.GetBucketPolicyRequest
          (clojure.core/nth args14110 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14112
          getBucketPolicy
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args14110 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14112
              getBucketPolicy
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketPolicy")
               {:args args14110}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-replication-configuration
   [m14113]
   (clojure.core/let
    [credentials14114 (:credentials m14113) args14115 (:args m14113)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14116
      (com.palletops.awaze.common/aws-client :s3 credentials14114)]
     (clojure.core/case
      (clojure.core/count args14115)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14116
        setBucketReplicationConfiguration
        (clojure.core/str (clojure.core/nth args14115 0))
        (s3/bucket-replication-configuration
         (clojure.core/nth args14115 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14116
        setBucketReplicationConfiguration
        (s3/set-bucket-replication-configuration-request
         (clojure.core/nth args14115 0))))))))
  (clojure.core/defn
   set-bucket-replication-configuration-map
   {:arglists (quote
               [[credentials string-0 {:keys [role-arn rules]}]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         replication-configuration
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setBucketReplicationConfiguration, setBucketReplicationConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-bucket-replication-configuration,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :set-bucket-replication-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   set-bucket-replication-configuration
   {:arglists (quote
               [[credentials string-0 {:keys [role-arn rules]}]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         replication-configuration
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Call setBucketReplicationConfiguration, setBucketReplicationConfiguration"}
   [credentials14118 & args14119]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14120
     (com.palletops.awaze.common/aws-client :s3 credentials14118)]
    (clojure.core/case
     (clojure.core/count args14119)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14120
       setBucketReplicationConfiguration
       (clojure.core/str (clojure.core/nth args14119 0))
       (s3/bucket-replication-configuration
        (clojure.core/nth args14119 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14120
       setBucketReplicationConfiguration
       (s3/set-bucket-replication-configuration-request
        (clojure.core/nth args14119 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :create-bucket
   [m14121]
   (clojure.core/let
    [credentials14122 (:credentials m14121) args14123 (:args m14121)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14124
      (com.palletops.awaze.common/aws-client :s3 credentials14122)]
     (clojure.core/case
      (clojure.core/count args14123)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.CreateBucketRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.CreateBucketRequest
           (clojure.core/nth args14123 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14124
           createBucket
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args14123 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14124
               createBucket
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "createBucket")
                {:args args14123}))))))))))
      2
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args14123 0))
^{:tag com.amazonaws.services.s3.model.Region}
b
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.Region
           (clojure.core/nth args14123 1))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14124
           createBucket
           a
           b)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args14123 0))
^{:tag java.lang.String}
b
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args14123 1))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14124
               createBucket
               a
               b)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "createBucket")
                {:args args14123}))))))))))))))
  (clojure.core/defn
   create-bucket-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         access-control-list
                         custom-query-parameters
                         region
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         canned-acl]}]
                [credentials string-0 region-1]
                [credentials string-0 string-1]
                [credentials string-0]]),
    :doc "Generate map for createBucket, createBucket, createBucket, createBucket"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-bucket,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :create-bucket,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   create-bucket
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         access-control-list
                         custom-query-parameters
                         region
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         canned-acl]}]
                [credentials string-0 region-1]
                [credentials string-0 string-1]
                [credentials string-0]]),
    :doc "Call createBucket, createBucket, createBucket, createBucket"}
   [credentials14127 & args14128]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14130
     (com.palletops.awaze.common/aws-client :s3 credentials14127)]
    (clojure.core/case
     (clojure.core/count args14128)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.CreateBucketRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.CreateBucketRequest
          (clojure.core/nth args14128 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14130
          createBucket
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args14128 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14130
              createBucket
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "createBucket")
               {:args args14128}))))))))))
     2
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args14128 0))
^{:tag com.amazonaws.services.s3.model.Region}
b
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.Region
          (clojure.core/nth args14128 1))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14130
          createBucket
          a
          b)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args14128 0))
^{:tag java.lang.String}
b
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args14128 1))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14130
              createBucket
              a
              b)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "createBucket")
               {:args args14128}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-version
   [m14131]
   (clojure.core/let
    [credentials14132 (:credentials m14131) args14133 (:args m14131)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14134
      (com.palletops.awaze.common/aws-client :s3 credentials14132)]
     (clojure.core/case
      (clojure.core/count args14133)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14134
        deleteVersion
        (s3/delete-version-request (clojure.core/nth args14133 0))))
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14134
        deleteVersion
        (clojure.core/str (clojure.core/nth args14133 0))
        (clojure.core/str (clojure.core/nth args14133 1))
        (clojure.core/str (clojure.core/nth args14133 2))))))))
  (clojure.core/defn
   delete-version-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         mfa
                         key
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]
                [credentials string-0 string-1 string-2]]),
    :doc "Generate map for deleteVersion, deleteVersion"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-version,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b c]
    {:args [a b c],
     :fn :delete-version,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   delete-version
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         mfa
                         key
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]
                [credentials string-0 string-1 string-2]]),
    :doc "Call deleteVersion, deleteVersion"}
   [credentials14139 & args14140]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14144
     (com.palletops.awaze.common/aws-client :s3 credentials14139)]
    (clojure.core/case
     (clojure.core/count args14140)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14144
       deleteVersion
       (s3/delete-version-request (clojure.core/nth args14140 0))))
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14144
       deleteVersion
       (clojure.core/str (clojure.core/nth args14140 0))
       (clojure.core/str (clojure.core/nth args14140 1))
       (clojure.core/str (clojure.core/nth args14140 2))))))))
 (do
  (clojure.core/defmethod
   s3
   :put-object
   [m14145]
   (clojure.core/let
    [credentials14146 (:credentials m14145) args14147 (:args m14145)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14148
      (com.palletops.awaze.common/aws-client :s3 credentials14146)]
     (clojure.core/case
      (clojure.core/count args14147)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14148
        putObject
        (s3/put-object-request (clojure.core/nth args14147 0))))
      4
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14148
        putObject
        (clojure.core/str (clojure.core/nth args14147 0))
        (clojure.core/str (clojure.core/nth args14147 1))
        (clojure.java.io/input-stream (clojure.core/nth args14147 2))
        (s3/object-metadata (clojure.core/nth args14147 3))))
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14148
        putObject
        (clojure.core/str (clojure.core/nth args14147 0))
        (clojure.core/str (clojure.core/nth args14147 1))
        (clojure.java.io/file (clojure.core/nth args14147 2))))))))
  (clojure.core/defn
   put-object-map
   {:arglists (quote
               [[credentials
                 {:keys [input-stream
                         custom-request-headers
                         sdk-client-execution-timeout
                         key
                         progress-listener
                         storage-class
                         sdk-request-timeout
                         sseaws-key-management-params
                         access-control-list
                         file
                         custom-query-parameters
                         redirect-location
                         read-limit
                         ssecustomer-key
                         general-progress-listener
                         bucket-name
                         clone-source
                         metadata
                         clone-root
                         requester-pays
                         canned-acl]}]
                [credentials
                 string-0
                 string-1
                 input-stream-2
                 {:keys [raw-metadata
                         sseaws-kms-key-id
                         content-disposition
                         expiration-time-rule-id
                         user-metadata
                         storage-class
                         instance-length
                         ssecustomer-key-md5
                         ssecustomer-algorithm
                         version-id
                         server-side-encryption
                         requester-charged
                         etag
                         last-modified
                         ssealgorithm
                         cache-control
                         http-expires-date
                         content-length
                         content-type
                         restore-expiration-time
                         content-encoding
                         expiration-time
                         content-md5
                         ongoing-restore]}]
                [credentials string-0 string-1 file-2]]),
    :doc "Generate map for putObject, putObject, putObject"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :put-object,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b c]
    {:args [a b c],
     :fn :put-object,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b c d]
    {:args [a b c d],
     :fn :put-object,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   put-object
   {:arglists (quote
               [[credentials
                 {:keys [input-stream
                         custom-request-headers
                         sdk-client-execution-timeout
                         key
                         progress-listener
                         storage-class
                         sdk-request-timeout
                         sseaws-key-management-params
                         access-control-list
                         file
                         custom-query-parameters
                         redirect-location
                         read-limit
                         ssecustomer-key
                         general-progress-listener
                         bucket-name
                         clone-source
                         metadata
                         clone-root
                         requester-pays
                         canned-acl]}]
                [credentials
                 string-0
                 string-1
                 input-stream-2
                 {:keys [raw-metadata
                         sseaws-kms-key-id
                         content-disposition
                         expiration-time-rule-id
                         user-metadata
                         storage-class
                         instance-length
                         ssecustomer-key-md5
                         ssecustomer-algorithm
                         version-id
                         server-side-encryption
                         requester-charged
                         etag
                         last-modified
                         ssealgorithm
                         cache-control
                         http-expires-date
                         content-length
                         content-type
                         restore-expiration-time
                         content-encoding
                         expiration-time
                         content-md5
                         ongoing-restore]}]
                [credentials string-0 string-1 file-2]]),
    :doc "Call putObject, putObject, putObject"}
   [credentials14156 & args14157]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14164
     (com.palletops.awaze.common/aws-client :s3 credentials14156)]
    (clojure.core/case
     (clojure.core/count args14157)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14164
       putObject
       (s3/put-object-request (clojure.core/nth args14157 0))))
     4
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14164
       putObject
       (clojure.core/str (clojure.core/nth args14157 0))
       (clojure.core/str (clojure.core/nth args14157 1))
       (clojure.java.io/input-stream (clojure.core/nth args14157 2))
       (s3/object-metadata (clojure.core/nth args14157 3))))
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14164
       putObject
       (clojure.core/str (clojure.core/nth args14157 0))
       (clojure.core/str (clojure.core/nth args14157 1))
       (clojure.java.io/file (clojure.core/nth args14157 2))))))))
 (do
  (clojure.core/defmethod
   s3
   :list-versions
   [m14165]
   (clojure.core/let
    [credentials14166 (:credentials m14165) args14167 (:args m14165)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14168
      (com.palletops.awaze.common/aws-client :s3 credentials14166)]
     (clojure.core/case
      (clojure.core/count args14167)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14168
        listVersions
        (s3/list-versions-request (clojure.core/nth args14167 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14168
        listVersions
        (clojure.core/str (clojure.core/nth args14167 0))
        (clojure.core/str (clojure.core/nth args14167 1))))
      6
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14168
        listVersions
        (clojure.core/str (clojure.core/nth args14167 0))
        (clojure.core/str (clojure.core/nth args14167 1))
        (clojure.core/str (clojure.core/nth args14167 2))
        (clojure.core/str (clojure.core/nth args14167 3))
        (clojure.core/str (clojure.core/nth args14167 4))
        (clojure.core/int (clojure.core/nth args14167 5))))))))
  (clojure.core/defn
   list-versions-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         encoding-type
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         version-id-marker
                         prefix
                         delimiter
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         key-marker]}]
                [credentials string-0 string-1]
                [credentials
                 string-0
                 string-1
                 string-2
                 string-3
                 string-4
                 integer-5]]),
    :doc "Generate map for listVersions, listVersions, listVersions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-versions,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :list-versions,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b c d e f]
    {:args [a b c d e f],
     :fn :list-versions,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   list-versions
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         encoding-type
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         version-id-marker
                         prefix
                         delimiter
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         key-marker]}]
                [credentials string-0 string-1]
                [credentials
                 string-0
                 string-1
                 string-2
                 string-3
                 string-4
                 integer-5]]),
    :doc "Call listVersions, listVersions, listVersions"}
   [credentials14170 & args14171]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14172
     (com.palletops.awaze.common/aws-client :s3 credentials14170)]
    (clojure.core/case
     (clojure.core/count args14171)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14172
       listVersions
       (s3/list-versions-request (clojure.core/nth args14171 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14172
       listVersions
       (clojure.core/str (clojure.core/nth args14171 0))
       (clojure.core/str (clojure.core/nth args14171 1))))
     6
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14172
       listVersions
       (clojure.core/str (clojure.core/nth args14171 0))
       (clojure.core/str (clojure.core/nth args14171 1))
       (clojure.core/str (clojure.core/nth args14171 2))
       (clojure.core/str (clojure.core/nth args14171 3))
       (clojure.core/str (clojure.core/nth args14171 4))
       (clojure.core/int (clojure.core/nth args14171 5))))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-tagging-configuration
   [m14173]
   (clojure.core/let
    [credentials14174 (:credentials m14173) args14175 (:args m14173)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14176
      (com.palletops.awaze.common/aws-client :s3 credentials14174)]
     (clojure.core/case
      (clojure.core/count args14175)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14176
        setBucketTaggingConfiguration
        (clojure.core/str (clojure.core/nth args14175 0))
        (s3/bucket-tagging-configuration
         (clojure.core/nth args14175 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14176
        setBucketTaggingConfiguration
        (s3/set-bucket-tagging-configuration-request
         (clojure.core/nth args14175 0))))))))
  (clojure.core/defn
   set-bucket-tagging-configuration-map
   {:arglists (quote
               [[credentials string-0 {:keys []}]
                [credentials {:keys []}]]),
    :doc "Generate map for setBucketTaggingConfiguration, setBucketTaggingConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-bucket-tagging-configuration,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :set-bucket-tagging-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   set-bucket-tagging-configuration
   {:arglists (quote
               [[credentials string-0 {:keys []}]
                [credentials {:keys []}]]),
    :doc "Call setBucketTaggingConfiguration, setBucketTaggingConfiguration"}
   [credentials14180 & args14181]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14184
     (com.palletops.awaze.common/aws-client :s3 credentials14180)]
    (clojure.core/case
     (clojure.core/count args14181)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14184
       setBucketTaggingConfiguration
       (clojure.core/str (clojure.core/nth args14181 0))
       (s3/bucket-tagging-configuration
        (clojure.core/nth args14181 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14184
       setBucketTaggingConfiguration
       (s3/set-bucket-tagging-configuration-request
        (clojure.core/nth args14181 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-cross-origin-configuration
   [m14185]
   (clojure.core/let
    [credentials14186 (:credentials m14185) args14187 (:args m14185)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14188
      (com.palletops.awaze.common/aws-client :s3 credentials14186)]
     (clojure.core/case
      (clojure.core/count args14187)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args14187 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14188
           getBucketCrossOriginConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.GetBucketCrossOriginConfigurationRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.GetBucketCrossOriginConfigurationRequest
               (clojure.core/nth args14187 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14188
               getBucketCrossOriginConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketCrossOriginConfiguration")
                {:args args14187}))))))))))))))
  (clojure.core/defn
   get-bucket-cross-origin-configuration-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Generate map for getBucketCrossOriginConfiguration, getBucketCrossOriginConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-bucket-cross-origin-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-bucket-cross-origin-configuration
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Call getBucketCrossOriginConfiguration, getBucketCrossOriginConfiguration"}
   [credentials14191 & args14192]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14194
     (com.palletops.awaze.common/aws-client :s3 credentials14191)]
    (clojure.core/case
     (clojure.core/count args14192)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args14192 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14194
          getBucketCrossOriginConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.GetBucketCrossOriginConfigurationRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.GetBucketCrossOriginConfigurationRequest
              (clojure.core/nth args14192 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14194
              getBucketCrossOriginConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketCrossOriginConfiguration")
               {:args args14192}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-policy
   [m14195]
   (clojure.core/let
    [credentials14196 (:credentials m14195) args14197 (:args m14195)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14198
      (com.palletops.awaze.common/aws-client :s3 credentials14196)]
     (clojure.core/case
      (clojure.core/count args14197)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14198
        setBucketPolicy
        (s3/set-bucket-policy-request (clojure.core/nth args14197 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14198
        setBucketPolicy
        (clojure.core/str (clojure.core/nth args14197 0))
        (clojure.core/str (clojure.core/nth args14197 1))))))))
  (clojure.core/defn
   set-bucket-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-text
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]
                [credentials string-0 string-1]]),
    :doc "Generate map for setBucketPolicy, setBucketPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-bucket-policy,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :set-bucket-policy,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   set-bucket-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-text
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]
                [credentials string-0 string-1]]),
    :doc "Call setBucketPolicy, setBucketPolicy"}
   [credentials14202 & args14203]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14206
     (com.palletops.awaze.common/aws-client :s3 credentials14202)]
    (clojure.core/case
     (clojure.core/count args14203)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14206
       setBucketPolicy
       (s3/set-bucket-policy-request (clojure.core/nth args14203 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14206
       setBucketPolicy
       (clojure.core/str (clojure.core/nth args14203 0))
       (clojure.core/str (clojure.core/nth args14203 1))))))))
 (do
  (clojure.core/defmethod
   s3
   :list-next-batch-of-objects
   [m14207]
   (clojure.core/let
    [credentials14208 (:credentials m14207) args14209 (:args m14207)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14210
      (com.palletops.awaze.common/aws-client :s3 credentials14208)]
     (clojure.core/case
      (clojure.core/count args14209)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.ObjectListing}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.ObjectListing
           (clojure.core/nth args14209 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14210
           listNextBatchOfObjects
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.ListNextBatchOfObjectsRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.ListNextBatchOfObjectsRequest
               (clojure.core/nth args14209 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14210
               listNextBatchOfObjects
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "listNextBatchOfObjects")
                {:args args14209}))))))))))))))
  (clojure.core/defn
   list-next-batch-of-objects-map
   {:arglists (quote
               [[credentials
                 {:keys [encoding-type
                         common-prefixes
                         marker
                         max-keys
                         object-summaries
                         prefix
                         delimiter
                         next-marker
                         truncated
                         bucket-name]}]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         previous-object-listing
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listNextBatchOfObjects, listNextBatchOfObjects"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-next-batch-of-objects,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   list-next-batch-of-objects
   {:arglists (quote
               [[credentials
                 {:keys [encoding-type
                         common-prefixes
                         marker
                         max-keys
                         object-summaries
                         prefix
                         delimiter
                         next-marker
                         truncated
                         bucket-name]}]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         previous-object-listing
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listNextBatchOfObjects, listNextBatchOfObjects"}
   [credentials14213 & args14214]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14216
     (com.palletops.awaze.common/aws-client :s3 credentials14213)]
    (clojure.core/case
     (clojure.core/count args14214)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.ObjectListing}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.ObjectListing
          (clojure.core/nth args14214 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14216
          listNextBatchOfObjects
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.ListNextBatchOfObjectsRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.ListNextBatchOfObjectsRequest
              (clojure.core/nth args14214 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14216
              listNextBatchOfObjects
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "listNextBatchOfObjects")
               {:args args14214}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :change-object-storage-class
   [m14217]
   (clojure.core/let
    [credentials14218 (:credentials m14217) args14219 (:args m14217)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14220
      (com.palletops.awaze.common/aws-client :s3 credentials14218)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14220
       changeObjectStorageClass
       (clojure.core/str (clojure.core/nth args14219 0))
       (clojure.core/str (clojure.core/nth args14219 1))
       (s3/storage-class (clojure.core/nth args14219 2)))))))
  (clojure.core/defn
   change-object-storage-class-map
   {:arglists (quote
               [[credentials string-0 string-1 storage-class-2]]),
    :doc "Generate map for changeObjectStorageClass"}
   ([credentials__1842__auto__ a b c]
    {:args [a b c],
     :fn :change-object-storage-class,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   change-object-storage-class
   {:arglists (quote
               [[credentials string-0 string-1 storage-class-2]]),
    :doc "Call changeObjectStorageClass"}
   [credentials14222 & args14223]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14224
     (com.palletops.awaze.common/aws-client :s3 credentials14222)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14224
      changeObjectStorageClass
      (clojure.core/str (clojure.core/nth args14223 0))
      (clojure.core/str (clojure.core/nth args14223 1))
      (s3/storage-class (clojure.core/nth args14223 2)))))))
 (do
  (clojure.core/defmethod
   s3
   :initiate-multipart-upload
   [m14225]
   (clojure.core/let
    [credentials14226 (:credentials m14225) args14227 (:args m14225)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14228
      (com.palletops.awaze.common/aws-client :s3 credentials14226)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14228
       initiateMultipartUpload
       (s3/initiate-multipart-upload-request
        (clojure.core/nth args14227 0)))))))
  (clojure.core/defn
   initiate-multipart-upload-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         storage-class
                         sdk-request-timeout
                         sseaws-key-management-params
                         access-control-list
                         object-metadata
                         custom-query-parameters
                         redirect-location
                         read-limit
                         ssecustomer-key
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays
                         canned-acl]}]]),
    :doc "Generate map for initiateMultipartUpload"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :initiate-multipart-upload,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   initiate-multipart-upload
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         storage-class
                         sdk-request-timeout
                         sseaws-key-management-params
                         access-control-list
                         object-metadata
                         custom-query-parameters
                         redirect-location
                         read-limit
                         ssecustomer-key
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays
                         canned-acl]}]]),
    :doc "Call initiateMultipartUpload"}
   [credentials14232 & args14233]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14236
     (com.palletops.awaze.common/aws-client :s3 credentials14232)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14236
      initiateMultipartUpload
      (s3/initiate-multipart-upload-request
       (clojure.core/nth args14233 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :set-region
   [m14237]
   (clojure.core/let
    [credentials14238 (:credentials m14237) args14239 (:args m14237)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14240
      (com.palletops.awaze.common/aws-client :s3 credentials14238)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14240
       setRegion
       (regions/region (clojure.core/nth args14239 0)))))))
  (clojure.core/defn
   set-region-map
   {:arglists (quote [[credentials region-0]]),
    :doc "Generate map for setRegion"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-region,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   set-region
   {:arglists (quote [[credentials region-0]]), :doc "Call setRegion"}
   [credentials14242 & args14243]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14244
     (com.palletops.awaze.common/aws-client :s3 credentials14242)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14244
      setRegion
      (regions/region (clojure.core/nth args14243 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-bucket
   [m14245]
   (clojure.core/let
    [credentials14246 (:credentials m14245) args14247 (:args m14245)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14248
      (com.palletops.awaze.common/aws-client :s3 credentials14246)]
     (clojure.core/case
      (clojure.core/count args14247)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.DeleteBucketRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.DeleteBucketRequest
           (clojure.core/nth args14247 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14248
           deleteBucket
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args14247 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14248
               deleteBucket
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteBucket")
                {:args args14247}))))))))))))))
  (clojure.core/defn
   delete-bucket-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]
                [credentials string-0]]),
    :doc "Generate map for deleteBucket, deleteBucket"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-bucket,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   delete-bucket
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]
                [credentials string-0]]),
    :doc "Call deleteBucket, deleteBucket"}
   [credentials14251 & args14252]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14254
     (com.palletops.awaze.common/aws-client :s3 credentials14251)]
    (clojure.core/case
     (clojure.core/count args14252)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.DeleteBucketRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.DeleteBucketRequest
          (clojure.core/nth args14252 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14254
          deleteBucket
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args14252 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14254
              deleteBucket
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteBucket")
               {:args args14252}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-tagging-configuration
   [m14255]
   (clojure.core/let
    [credentials14256 (:credentials m14255) args14257 (:args m14255)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14258
      (com.palletops.awaze.common/aws-client :s3 credentials14256)]
     (clojure.core/case
      (clojure.core/count args14257)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args14257 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14258
           getBucketTaggingConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.GetBucketTaggingConfigurationRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.GetBucketTaggingConfigurationRequest
               (clojure.core/nth args14257 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14258
               getBucketTaggingConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketTaggingConfiguration")
                {:args args14257}))))))))))))))
  (clojure.core/defn
   get-bucket-tagging-configuration-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Generate map for getBucketTaggingConfiguration, getBucketTaggingConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-bucket-tagging-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-bucket-tagging-configuration
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Call getBucketTaggingConfiguration, getBucketTaggingConfiguration"}
   [credentials14261 & args14262]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14264
     (com.palletops.awaze.common/aws-client :s3 credentials14261)]
    (clojure.core/case
     (clojure.core/count args14262)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args14262 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14264
          getBucketTaggingConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.GetBucketTaggingConfigurationRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.GetBucketTaggingConfigurationRequest
              (clojure.core/nth args14262 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14264
              getBucketTaggingConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketTaggingConfiguration")
               {:args args14262}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-location
   [m14265]
   (clojure.core/let
    [credentials14266 (:credentials m14265) args14267 (:args m14265)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14268
      (com.palletops.awaze.common/aws-client :s3 credentials14266)]
     (clojure.core/case
      (clojure.core/count args14267)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.GetBucketLocationRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.GetBucketLocationRequest
           (clojure.core/nth args14267 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14268
           getBucketLocation
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args14267 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14268
               getBucketLocation
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketLocation")
                {:args args14267}))))))))))))))
  (clojure.core/defn
   get-bucket-location-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]
                [credentials string-0]]),
    :doc "Generate map for getBucketLocation, getBucketLocation"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-bucket-location,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-bucket-location
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]
                [credentials string-0]]),
    :doc "Call getBucketLocation, getBucketLocation"}
   [credentials14271 & args14272]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14274
     (com.palletops.awaze.common/aws-client :s3 credentials14271)]
    (clojure.core/case
     (clojure.core/count args14272)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.GetBucketLocationRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.GetBucketLocationRequest
          (clojure.core/nth args14272 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14274
          getBucketLocation
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args14272 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14274
              getBucketLocation
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketLocation")
               {:args args14272}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :does-bucket-exist
   [m14275]
   (clojure.core/let
    [credentials14276 (:credentials m14275) args14277 (:args m14275)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14278
      (com.palletops.awaze.common/aws-client :s3 credentials14276)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14278
       doesBucketExist
       (clojure.core/str (clojure.core/nth args14277 0)))))))
  (clojure.core/defn
   does-bucket-exist-map
   {:arglists (quote [[credentials string-0]]),
    :doc "Generate map for doesBucketExist"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :does-bucket-exist,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   does-bucket-exist
   {:arglists (quote [[credentials string-0]]),
    :doc "Call doesBucketExist"}
   [credentials14280 & args14281]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14282
     (com.palletops.awaze.common/aws-client :s3 credentials14280)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14282
      doesBucketExist
      (clojure.core/str (clojure.core/nth args14281 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-object-acl
   [m14283]
   (clojure.core/let
    [credentials14284 (:credentials m14283) args14285 (:args m14283)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14286
      (com.palletops.awaze.common/aws-client :s3 credentials14284)]
     (clojure.core/case
      (clojure.core/count args14285)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14286
        getObjectAcl
        (clojure.core/str (clojure.core/nth args14285 0))
        (clojure.core/str (clojure.core/nth args14285 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14286
        getObjectAcl
        (s3/get-object-acl-request (clojure.core/nth args14285 0))))
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14286
        getObjectAcl
        (clojure.core/str (clojure.core/nth args14285 0))
        (clojure.core/str (clojure.core/nth args14285 1))
        (clojure.core/str (clojure.core/nth args14285 2))))))))
  (clojure.core/defn
   get-object-acl-map
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays]}]
                [credentials string-0 string-1 string-2]]),
    :doc "Generate map for getObjectAcl, getObjectAcl, getObjectAcl"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-object-acl,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :get-object-acl,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b c]
    {:args [a b c],
     :fn :get-object-acl,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-object-acl
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays]}]
                [credentials string-0 string-1 string-2]]),
    :doc "Call getObjectAcl, getObjectAcl, getObjectAcl"}
   [credentials14290 & args14291]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14294
     (com.palletops.awaze.common/aws-client :s3 credentials14290)]
    (clojure.core/case
     (clojure.core/count args14291)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14294
       getObjectAcl
       (clojure.core/str (clojure.core/nth args14291 0))
       (clojure.core/str (clojure.core/nth args14291 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14294
       getObjectAcl
       (s3/get-object-acl-request (clojure.core/nth args14291 0))))
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14294
       getObjectAcl
       (clojure.core/str (clojure.core/nth args14291 0))
       (clojure.core/str (clojure.core/nth args14291 1))
       (clojure.core/str (clojure.core/nth args14291 2))))))))
 (do
  (clojure.core/defmethod
   s3
   :upload-part
   [m14295]
   (clojure.core/let
    [credentials14296 (:credentials m14295) args14297 (:args m14295)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14298
      (com.palletops.awaze.common/aws-client :s3 credentials14296)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14298
       uploadPart
       (s3/upload-part-request (clojure.core/nth args14297 0)))))))
  (clojure.core/defn
   upload-part-map
   {:arglists (quote
               [[credentials
                 {:keys [input-stream
                         custom-request-headers
                         sdk-client-execution-timeout
                         key
                         progress-listener
                         last-part
                         sdk-request-timeout
                         upload-id
                         file
                         object-metadata
                         custom-query-parameters
                         md5digest
                         read-limit
                         ssecustomer-key
                         general-progress-listener
                         file-offset
                         part-number
                         bucket-name
                         clone-source
                         part-size
                         clone-root
                         requester-pays]}]]),
    :doc "Generate map for uploadPart"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :upload-part,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   upload-part
   {:arglists (quote
               [[credentials
                 {:keys [input-stream
                         custom-request-headers
                         sdk-client-execution-timeout
                         key
                         progress-listener
                         last-part
                         sdk-request-timeout
                         upload-id
                         file
                         object-metadata
                         custom-query-parameters
                         md5digest
                         read-limit
                         ssecustomer-key
                         general-progress-listener
                         file-offset
                         part-number
                         bucket-name
                         clone-source
                         part-size
                         clone-root
                         requester-pays]}]]),
    :doc "Call uploadPart"}
   [credentials14300 & args14301]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14302
     (com.palletops.awaze.common/aws-client :s3 credentials14300)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14302
      uploadPart
      (s3/upload-part-request (clojure.core/nth args14301 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-website-configuration
   [m14303]
   (clojure.core/let
    [credentials14304 (:credentials m14303) args14305 (:args m14303)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14306
      (com.palletops.awaze.common/aws-client :s3 credentials14304)]
     (clojure.core/case
      (clojure.core/count args14305)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14306
        setBucketWebsiteConfiguration
        (s3/set-bucket-website-configuration-request
         (clojure.core/nth args14305 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14306
        setBucketWebsiteConfiguration
        (clojure.core/str (clojure.core/nth args14305 0))
        (s3/bucket-website-configuration
         (clojure.core/nth args14305 1))))))))
  (clojure.core/defn
   set-bucket-website-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         configuration
                         bucket-name
                         clone-source
                         clone-root]}]
                [credentials
                 string-0
                 {:keys [error-document
                         index-document-suffix
                         redirect-all-requests-to
                         routing-rules]}]]),
    :doc "Generate map for setBucketWebsiteConfiguration, setBucketWebsiteConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-bucket-website-configuration,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :set-bucket-website-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   set-bucket-website-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         configuration
                         bucket-name
                         clone-source
                         clone-root]}]
                [credentials
                 string-0
                 {:keys [error-document
                         index-document-suffix
                         redirect-all-requests-to
                         routing-rules]}]]),
    :doc "Call setBucketWebsiteConfiguration, setBucketWebsiteConfiguration"}
   [credentials14310 & args14311]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14314
     (com.palletops.awaze.common/aws-client :s3 credentials14310)]
    (clojure.core/case
     (clojure.core/count args14311)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14314
       setBucketWebsiteConfiguration
       (s3/set-bucket-website-configuration-request
        (clojure.core/nth args14311 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14314
       setBucketWebsiteConfiguration
       (clojure.core/str (clojure.core/nth args14311 0))
       (s3/bucket-website-configuration
        (clojure.core/nth args14311 1))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-region
   [m14315]
   (clojure.core/let
    [credentials14316 (:credentials m14315) args14317 (:args m14315)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14318
      (com.palletops.awaze.common/aws-client :s3 credentials14316)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14318
       getRegion)))))
  (clojure.core/defn
   get-region-map
   {:arglists (quote [[credentials]]),
    :doc "Generate map for getRegion"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-region,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-region
   {:arglists (quote [[credentials]]), :doc "Call getRegion"}
   [credentials14320 & args14321]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14322
     (com.palletops.awaze.common/aws-client :s3 credentials14320)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14322
      getRegion))))))
