(ns
 com.palletops.awaze.route53
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.route53 :as route53]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :route53
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.route53.AmazonRoute53Client
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.AliasTarget}
alias-target
  [m11163]
  (clojure.core/let
   [bean11162 (new com.amazonaws.services.route53.model.AliasTarget)]
   (clojure.core/let
    [v11164
     (:evaluate-target-health
      m11163
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11164 :com.palletops.awaze.client-builder/undef)
     (.
      bean11162
      setEvaluateTargetHealth
      (clojure.core/boolean v11164))))
   (clojure.core/let
    [v11164
     (:hosted-zone-id
      m11163
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11164 :com.palletops.awaze.client-builder/undef)
     (. bean11162 setHostedZoneId (clojure.core/str v11164))))
   (clojure.core/let
    [v11164
     (:dnsname m11163 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11164 :com.palletops.awaze.client-builder/undef)
     (. bean11162 setDNSName (clojure.core/str v11164))))
   bean11162))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ResourceRecordSetRegion}
resource-record-set-region
  [m11166]
  (.
   com.amazonaws.services.route53.model.ResourceRecordSetRegion
   fromValue
   (clojure.core/name m11166)))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ResourceRecordSetFailover}
resource-record-set-failover
  [m11169]
  (.
   com.amazonaws.services.route53.model.ResourceRecordSetFailover
   fromValue
   (clojure.core/name m11169)))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.RRType}
rrtype
  [m11172]
  (.
   com.amazonaws.services.route53.model.RRType
   fromValue
   (clojure.core/name m11172)))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ResourceRecord}
resource-record
  [m11175]
  (clojure.core/let
   [bean11174
    (new com.amazonaws.services.route53.model.ResourceRecord)]
   (clojure.core/let
    [v11176 (:value m11175 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11176 :com.palletops.awaze.client-builder/undef)
     (. bean11174 setValue (clojure.core/str v11176))))
   bean11174))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GeoLocation}
geo-location
  [m11178]
  (clojure.core/let
   [bean11177 (new com.amazonaws.services.route53.model.GeoLocation)]
   (clojure.core/let
    [v11179
     (:country-code m11178 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11179 :com.palletops.awaze.client-builder/undef)
     (. bean11177 setCountryCode (clojure.core/str v11179))))
   (clojure.core/let
    [v11179
     (:continent-code
      m11178
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11179 :com.palletops.awaze.client-builder/undef)
     (. bean11177 setContinentCode (clojure.core/str v11179))))
   (clojure.core/let
    [v11179
     (:subdivision-code
      m11178
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11179 :com.palletops.awaze.client-builder/undef)
     (. bean11177 setSubdivisionCode (clojure.core/str v11179))))
   bean11177))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ResourceRecordSet}
resource-record-set
  [m11181]
  (clojure.core/let
   [bean11180
    (new com.amazonaws.services.route53.model.ResourceRecordSet)]
   (clojure.core/let
    [v11182
     (:alias-target m11181 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11182 :com.palletops.awaze.client-builder/undef)
     (. bean11180 setAliasTarget (route53/alias-target v11182))))
   (clojure.core/let
    [v11182
     (:region m11181 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11182 :com.palletops.awaze.client-builder/undef)
     (.
      bean11180
      setRegion
      (route53/resource-record-set-region v11182))))
   (clojure.core/let
    [v11182
     (:failover m11181 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11182 :com.palletops.awaze.client-builder/undef)
     (.
      bean11180
      setFailover
      (route53/resource-record-set-failover v11182))))
   (clojure.core/let
    [v11182
     (:set-identifier
      m11181
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11182 :com.palletops.awaze.client-builder/undef)
     (. bean11180 setSetIdentifier (clojure.core/str v11182))))
   (clojure.core/let
    [v11182
     (:traffic-policy-instance-id
      m11181
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11182 :com.palletops.awaze.client-builder/undef)
     (.
      bean11180
      setTrafficPolicyInstanceId
      (clojure.core/str v11182))))
   (clojure.core/let
    [v11182 (:type m11181 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11182 :com.palletops.awaze.client-builder/undef)
     (. bean11180 setType (route53/rrtype v11182))))
   (clojure.core/let
    [v11182 (:name m11181 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11182 :com.palletops.awaze.client-builder/undef)
     (. bean11180 setName (clojure.core/str v11182))))
   (clojure.core/let
    [v11182
     (:weight m11181 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11182 :com.palletops.awaze.client-builder/undef)
     (. bean11180 setWeight (clojure.core/long v11182))))
   (clojure.core/let
    [v11182 (:ttl m11181 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11182 :com.palletops.awaze.client-builder/undef)
     (. bean11180 setTTL (clojure.core/long v11182))))
   (clojure.core/let
    [v11182
     (:health-check-id
      m11181
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11182 :com.palletops.awaze.client-builder/undef)
     (. bean11180 setHealthCheckId (clojure.core/str v11182))))
   (clojure.core/let
    [v11182
     (:resource-records
      m11181
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11182 :com.palletops.awaze.client-builder/undef)
     (.
      bean11180
      setResourceRecords
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11354] (route53/resource-record arg11354))
 v11182))))
   (clojure.core/let
    [v11182
     (:geo-location m11181 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11182 :com.palletops.awaze.client-builder/undef)
     (. bean11180 setGeoLocation (route53/geo-location v11182))))
   bean11180))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.Change}
change
  [m11184]
  (clojure.core/let
   [bean11183 (new com.amazonaws.services.route53.model.Change)]
   (clojure.core/let
    [v11185
     (:resource-record-set
      m11184
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11185 :com.palletops.awaze.client-builder/undef)
     (.
      bean11183
      setResourceRecordSet
      (route53/resource-record-set v11185))))
   (clojure.core/let
    [v11185
     (:action m11184 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11185 :com.palletops.awaze.client-builder/undef)
     (. bean11183 setAction (clojure.core/str v11185))))
   bean11183))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.VPCRegion}
vpcregion
  [m11187]
  (.
   com.amazonaws.services.route53.model.VPCRegion
   fromValue
   (clojure.core/name m11187)))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.HealthCheckType}
health-check-type
  [m11190]
  (.
   com.amazonaws.services.route53.model.HealthCheckType
   fromValue
   (clojure.core/name m11190)))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ChangeBatch}
change-batch
  [m11193]
  (clojure.core/let
   [bean11192 (new com.amazonaws.services.route53.model.ChangeBatch)]
   (clojure.core/let
    [v11194
     (:comment m11193 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11194 :com.palletops.awaze.client-builder/undef)
     (. bean11192 setComment (clojure.core/str v11194))))
   (clojure.core/let
    [v11194
     (:changes m11193 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11194 :com.palletops.awaze.client-builder/undef)
     (.
      bean11192
      setChanges
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11355] (route53/change arg11355))
 v11194))))
   bean11192))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.VPC}
vpc
  [m11196]
  (clojure.core/let
   [bean11195 (new com.amazonaws.services.route53.model.VPC)]
   (clojure.core/let
    [v11197
     (:vpcregion m11196 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11197 :com.palletops.awaze.client-builder/undef)
     (. bean11195 setVPCRegion (route53/vpcregion v11197))))
   (clojure.core/let
    [v11197 (:vpcid m11196 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11197 :com.palletops.awaze.client-builder/undef)
     (. bean11195 setVPCId (clojure.core/str v11197))))
   bean11195))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.TagResourceType}
tag-resource-type
  [m11199]
  (.
   com.amazonaws.services.route53.model.TagResourceType
   fromValue
   (clojure.core/name m11199)))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.HostedZoneConfig}
hosted-zone-config
  [m11202]
  (clojure.core/let
   [bean11201
    (new com.amazonaws.services.route53.model.HostedZoneConfig)]
   (clojure.core/let
    [v11203
     (:comment m11202 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11203 :com.palletops.awaze.client-builder/undef)
     (. bean11201 setComment (clojure.core/str v11203))))
   (clojure.core/let
    [v11203
     (:private-zone m11202 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11203 :com.palletops.awaze.client-builder/undef)
     (. bean11201 setPrivateZone (clojure.core/boolean v11203))))
   bean11201))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.HealthCheckConfig}
health-check-config
  [m11205]
  (clojure.core/let
   [bean11204
    (new com.amazonaws.services.route53.model.HealthCheckConfig)]
   (clojure.core/let
    [v11206
     (:inverted m11205 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11206 :com.palletops.awaze.client-builder/undef)
     (. bean11204 setInverted (clojure.core/boolean v11206))))
   (clojure.core/let
    [v11206 (:type m11205 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11206 :com.palletops.awaze.client-builder/undef)
     (. bean11204 setType (route53/health-check-type v11206))))
   (clojure.core/let
    [v11206
     (:resource-path m11205 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11206 :com.palletops.awaze.client-builder/undef)
     (. bean11204 setResourcePath (clojure.core/str v11206))))
   (clojure.core/let
    [v11206
     (:search-string m11205 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11206 :com.palletops.awaze.client-builder/undef)
     (. bean11204 setSearchString (clojure.core/str v11206))))
   (clojure.core/let
    [v11206
     (:child-health-checks
      m11205
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11206 :com.palletops.awaze.client-builder/undef)
     (.
      bean11204
      setChildHealthChecks
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11356] (clojure.core/str arg11356))
 v11206))))
   (clojure.core/let
    [v11206 (:port m11205 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11206 :com.palletops.awaze.client-builder/undef)
     (. bean11204 setPort (clojure.core/int v11206))))
   (clojure.core/let
    [v11206
     (:health-threshold
      m11205
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11206 :com.palletops.awaze.client-builder/undef)
     (. bean11204 setHealthThreshold (clojure.core/int v11206))))
   (clojure.core/let
    [v11206
     (:request-interval
      m11205
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11206 :com.palletops.awaze.client-builder/undef)
     (. bean11204 setRequestInterval (clojure.core/int v11206))))
   (clojure.core/let
    [v11206
     (:ipaddress m11205 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11206 :com.palletops.awaze.client-builder/undef)
     (. bean11204 setIPAddress (clojure.core/str v11206))))
   (clojure.core/let
    [v11206
     (:fully-qualified-domain-name
      m11205
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11206 :com.palletops.awaze.client-builder/undef)
     (.
      bean11204
      setFullyQualifiedDomainName
      (clojure.core/str v11206))))
   (clojure.core/let
    [v11206
     (:enable-sni m11205 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11206 :com.palletops.awaze.client-builder/undef)
     (. bean11204 setEnableSNI (clojure.core/boolean v11206))))
   (clojure.core/let
    [v11206
     (:measure-latency
      m11205
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11206 :com.palletops.awaze.client-builder/undef)
     (. bean11204 setMeasureLatency (clojure.core/boolean v11206))))
   (clojure.core/let
    [v11206
     (:failure-threshold
      m11205
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11206 :com.palletops.awaze.client-builder/undef)
     (. bean11204 setFailureThreshold (clojure.core/int v11206))))
   bean11204))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.Tag}
tag
  [m11208]
  (clojure.core/let
   [bean11207 (new com.amazonaws.services.route53.model.Tag)]
   (clojure.core/let
    [v11209 (:key m11208 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11209 :com.palletops.awaze.client-builder/undef)
     (. bean11207 setKey (clojure.core/str v11209))))
   (clojure.core/let
    [v11209 (:value m11208 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11209 :com.palletops.awaze.client-builder/undef)
     (. bean11207 setValue (clojure.core/str v11209))))
   bean11207))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.CreateTrafficPolicyVersionRequest}
create-traffic-policy-version-request
  [m11211]
  (clojure.core/let
   [bean11210
    (new
     com.amazonaws.services.route53.model.CreateTrafficPolicyVersionRequest)]
   (clojure.core/let
    [v11212
     (:comment m11211 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11212 :com.palletops.awaze.client-builder/undef)
     (. bean11210 setComment (clojure.core/str v11212))))
   (clojure.core/let
    [v11212
     (:document m11211 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11212 :com.palletops.awaze.client-builder/undef)
     (. bean11210 setDocument (clojure.core/str v11212))))
   (clojure.core/let
    [v11212 (:id m11211 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11212 :com.palletops.awaze.client-builder/undef)
     (. bean11210 setId (clojure.core/str v11212))))
   bean11210))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.DeleteTrafficPolicyRequest}
delete-traffic-policy-request
  [m11214]
  (clojure.core/let
   [bean11213
    (new
     com.amazonaws.services.route53.model.DeleteTrafficPolicyRequest)]
   (clojure.core/let
    [v11215
     (:version m11214 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11215 :com.palletops.awaze.client-builder/undef)
     (. bean11213 setVersion (clojure.core/int v11215))))
   (clojure.core/let
    [v11215 (:id m11214 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11215 :com.palletops.awaze.client-builder/undef)
     (. bean11213 setId (clojure.core/str v11215))))
   bean11213))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ChangeResourceRecordSetsRequest}
change-resource-record-sets-request
  [m11217]
  (clojure.core/let
   [bean11216
    (new
     com.amazonaws.services.route53.model.ChangeResourceRecordSetsRequest)]
   (clojure.core/let
    [v11218
     (:change-batch m11217 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11218 :com.palletops.awaze.client-builder/undef)
     (. bean11216 setChangeBatch (route53/change-batch v11218))))
   (clojure.core/let
    [v11218
     (:hosted-zone-id
      m11217
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11218 :com.palletops.awaze.client-builder/undef)
     (. bean11216 setHostedZoneId (clojure.core/str v11218))))
   bean11216))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListTrafficPoliciesRequest}
list-traffic-policies-request
  [m11220]
  (clojure.core/let
   [bean11219
    (new
     com.amazonaws.services.route53.model.ListTrafficPoliciesRequest)]
   (clojure.core/let
    [v11221
     (:traffic-policy-id-marker
      m11220
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11221 :com.palletops.awaze.client-builder/undef)
     (. bean11219 setTrafficPolicyIdMarker (clojure.core/str v11221))))
   (clojure.core/let
    [v11221
     (:max-items m11220 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11221 :com.palletops.awaze.client-builder/undef)
     (. bean11219 setMaxItems (clojure.core/str v11221))))
   bean11219))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListTrafficPolicyInstancesByPolicyRequest}
list-traffic-policy-instances-by-policy-request
  [m11223]
  (clojure.core/let
   [bean11222
    (new
     com.amazonaws.services.route53.model.ListTrafficPolicyInstancesByPolicyRequest)]
   (clojure.core/let
    [v11224
     (:traffic-policy-id
      m11223
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11224 :com.palletops.awaze.client-builder/undef)
     (. bean11222 setTrafficPolicyId (clojure.core/str v11224))))
   (clojure.core/let
    [v11224
     (:traffic-policy-version
      m11223
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11224 :com.palletops.awaze.client-builder/undef)
     (. bean11222 setTrafficPolicyVersion (clojure.core/int v11224))))
   (clojure.core/let
    [v11224
     (:traffic-policy-instance-type-marker
      m11223
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11224 :com.palletops.awaze.client-builder/undef)
     (.
      bean11222
      setTrafficPolicyInstanceTypeMarker
      (route53/rrtype v11224))))
   (clojure.core/let
    [v11224
     (:hosted-zone-id-marker
      m11223
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11224 :com.palletops.awaze.client-builder/undef)
     (. bean11222 setHostedZoneIdMarker (clojure.core/str v11224))))
   (clojure.core/let
    [v11224
     (:traffic-policy-instance-name-marker
      m11223
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11224 :com.palletops.awaze.client-builder/undef)
     (.
      bean11222
      setTrafficPolicyInstanceNameMarker
      (clojure.core/str v11224))))
   (clojure.core/let
    [v11224
     (:max-items m11223 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11224 :com.palletops.awaze.client-builder/undef)
     (. bean11222 setMaxItems (clojure.core/str v11224))))
   bean11222))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListTrafficPolicyVersionsRequest}
list-traffic-policy-versions-request
  [m11226]
  (clojure.core/let
   [bean11225
    (new
     com.amazonaws.services.route53.model.ListTrafficPolicyVersionsRequest)]
   (clojure.core/let
    [v11227
     (:traffic-policy-version-marker
      m11226
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11227 :com.palletops.awaze.client-builder/undef)
     (.
      bean11225
      setTrafficPolicyVersionMarker
      (clojure.core/str v11227))))
   (clojure.core/let
    [v11227 (:id m11226 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11227 :com.palletops.awaze.client-builder/undef)
     (. bean11225 setId (clojure.core/str v11227))))
   (clojure.core/let
    [v11227
     (:max-items m11226 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11227 :com.palletops.awaze.client-builder/undef)
     (. bean11225 setMaxItems (clojure.core/str v11227))))
   bean11225))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListTrafficPolicyInstancesByHostedZoneRequest}
list-traffic-policy-instances-by-hosted-zone-request
  [m11229]
  (clojure.core/let
   [bean11228
    (new
     com.amazonaws.services.route53.model.ListTrafficPolicyInstancesByHostedZoneRequest)]
   (clojure.core/let
    [v11230
     (:traffic-policy-instance-type-marker
      m11229
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11230 :com.palletops.awaze.client-builder/undef)
     (.
      bean11228
      setTrafficPolicyInstanceTypeMarker
      (clojure.core/str v11230))))
   (clojure.core/let
    [v11230
     (:traffic-policy-instance-name-marker
      m11229
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11230 :com.palletops.awaze.client-builder/undef)
     (.
      bean11228
      setTrafficPolicyInstanceNameMarker
      (clojure.core/str v11230))))
   (clojure.core/let
    [v11230
     (:hosted-zone-id
      m11229
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11230 :com.palletops.awaze.client-builder/undef)
     (. bean11228 setHostedZoneId (clojure.core/str v11230))))
   (clojure.core/let
    [v11230
     (:max-items m11229 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11230 :com.palletops.awaze.client-builder/undef)
     (. bean11228 setMaxItems (clojure.core/str v11230))))
   bean11228))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.DeleteReusableDelegationSetRequest}
delete-reusable-delegation-set-request
  [m11232]
  (clojure.core/let
   [bean11231
    (new
     com.amazonaws.services.route53.model.DeleteReusableDelegationSetRequest)]
   (clojure.core/let
    [v11233 (:id m11232 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11233 :com.palletops.awaze.client-builder/undef)
     (. bean11231 setId (clojure.core/str v11233))))
   bean11231))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetReusableDelegationSetRequest}
get-reusable-delegation-set-request
  [m11235]
  (clojure.core/let
   [bean11234
    (new
     com.amazonaws.services.route53.model.GetReusableDelegationSetRequest)]
   (clojure.core/let
    [v11236 (:id m11235 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11236 :com.palletops.awaze.client-builder/undef)
     (. bean11234 setId (clojure.core/str v11236))))
   bean11234))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.DeleteHostedZoneRequest}
delete-hosted-zone-request
  [m11238]
  (clojure.core/let
   [bean11237
    (new com.amazonaws.services.route53.model.DeleteHostedZoneRequest)]
   (clojure.core/let
    [v11239 (:id m11238 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11239 :com.palletops.awaze.client-builder/undef)
     (. bean11237 setId (clojure.core/str v11239))))
   bean11237))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.AssociateVPCWithHostedZoneRequest}
associate-vpcwith-hosted-zone-request
  [m11241]
  (clojure.core/let
   [bean11240
    (new
     com.amazonaws.services.route53.model.AssociateVPCWithHostedZoneRequest)]
   (clojure.core/let
    [v11242
     (:comment m11241 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11242 :com.palletops.awaze.client-builder/undef)
     (. bean11240 setComment (clojure.core/str v11242))))
   (clojure.core/let
    [v11242 (:vpc m11241 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11242 :com.palletops.awaze.client-builder/undef)
     (. bean11240 setVPC (route53/vpc v11242))))
   (clojure.core/let
    [v11242
     (:hosted-zone-id
      m11241
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11242 :com.palletops.awaze.client-builder/undef)
     (. bean11240 setHostedZoneId (clojure.core/str v11242))))
   bean11240))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListHostedZonesRequest}
list-hosted-zones-request
  [m11244]
  (clojure.core/let
   [bean11243
    (new com.amazonaws.services.route53.model.ListHostedZonesRequest)]
   (clojure.core/let
    [v11245
     (:delegation-set-id
      m11244
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11245 :com.palletops.awaze.client-builder/undef)
     (. bean11243 setDelegationSetId (clojure.core/str v11245))))
   (clojure.core/let
    [v11245
     (:marker m11244 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11245 :com.palletops.awaze.client-builder/undef)
     (. bean11243 setMarker (clojure.core/str v11245))))
   (clojure.core/let
    [v11245
     (:max-items m11244 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11245 :com.palletops.awaze.client-builder/undef)
     (. bean11243 setMaxItems (clojure.core/str v11245))))
   bean11243))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListReusableDelegationSetsRequest}
list-reusable-delegation-sets-request
  [m11247]
  (clojure.core/let
   [bean11246
    (new
     com.amazonaws.services.route53.model.ListReusableDelegationSetsRequest)]
   (clojure.core/let
    [v11248
     (:marker m11247 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11248 :com.palletops.awaze.client-builder/undef)
     (. bean11246 setMarker (clojure.core/str v11248))))
   (clojure.core/let
    [v11248
     (:max-items m11247 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11248 :com.palletops.awaze.client-builder/undef)
     (. bean11246 setMaxItems (clojure.core/str v11248))))
   bean11246))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.DeleteTrafficPolicyInstanceRequest}
delete-traffic-policy-instance-request
  [m11250]
  (clojure.core/let
   [bean11249
    (new
     com.amazonaws.services.route53.model.DeleteTrafficPolicyInstanceRequest)]
   (clojure.core/let
    [v11251 (:id m11250 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11251 :com.palletops.awaze.client-builder/undef)
     (. bean11249 setId (clojure.core/str v11251))))
   bean11249))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetHealthCheckRequest}
get-health-check-request
  [m11253]
  (clojure.core/let
   [bean11252
    (new com.amazonaws.services.route53.model.GetHealthCheckRequest)]
   (clojure.core/let
    [v11254
     (:health-check-id
      m11253
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11254 :com.palletops.awaze.client-builder/undef)
     (. bean11252 setHealthCheckId (clojure.core/str v11254))))
   bean11252))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListTagsForResourcesRequest}
list-tags-for-resources-request
  [m11256]
  (clojure.core/let
   [bean11255
    (new
     com.amazonaws.services.route53.model.ListTagsForResourcesRequest)]
   (clojure.core/let
    [v11257
     (:resource-ids m11256 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11257 :com.palletops.awaze.client-builder/undef)
     (.
      bean11255
      setResourceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11357] (clojure.core/str arg11357))
 v11257))))
   (clojure.core/let
    [v11257
     (:resource-type m11256 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11257 :com.palletops.awaze.client-builder/undef)
     (. bean11255 setResourceType (route53/tag-resource-type v11257))))
   bean11255))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetCheckerIpRangesRequest}
get-checker-ip-ranges-request
  [m11259]
  (clojure.core/let
   [bean11258
    (new
     com.amazonaws.services.route53.model.GetCheckerIpRangesRequest)]
   bean11258))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.CreateHostedZoneRequest}
create-hosted-zone-request
  [m11262]
  (clojure.core/let
   [bean11261
    (new com.amazonaws.services.route53.model.CreateHostedZoneRequest)]
   (clojure.core/let
    [v11263 (:vpc m11262 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11263 :com.palletops.awaze.client-builder/undef)
     (. bean11261 setVPC (route53/vpc v11263))))
   (clojure.core/let
    [v11263
     (:caller-reference
      m11262
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11263 :com.palletops.awaze.client-builder/undef)
     (. bean11261 setCallerReference (clojure.core/str v11263))))
   (clojure.core/let
    [v11263
     (:hosted-zone-config
      m11262
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11263 :com.palletops.awaze.client-builder/undef)
     (.
      bean11261
      setHostedZoneConfig
      (route53/hosted-zone-config v11263))))
   (clojure.core/let
    [v11263
     (:delegation-set-id
      m11262
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11263 :com.palletops.awaze.client-builder/undef)
     (. bean11261 setDelegationSetId (clojure.core/str v11263))))
   (clojure.core/let
    [v11263 (:name m11262 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11263 :com.palletops.awaze.client-builder/undef)
     (. bean11261 setName (clojure.core/str v11263))))
   bean11261))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListChangeBatchesByHostedZoneRequest}
list-change-batches-by-hosted-zone-request
  [m11265]
  (clojure.core/let
   [bean11264
    (new
     com.amazonaws.services.route53.model.ListChangeBatchesByHostedZoneRequest)]
   (clojure.core/let
    [v11266
     (:marker m11265 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11266 :com.palletops.awaze.client-builder/undef)
     (. bean11264 setMarker (clojure.core/str v11266))))
   (clojure.core/let
    [v11266
     (:hosted-zone-id
      m11265
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11266 :com.palletops.awaze.client-builder/undef)
     (. bean11264 setHostedZoneId (clojure.core/str v11266))))
   (clojure.core/let
    [v11266
     (:start-date m11265 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11266 :com.palletops.awaze.client-builder/undef)
     (. bean11264 setStartDate (clojure.core/str v11266))))
   (clojure.core/let
    [v11266
     (:end-date m11265 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11266 :com.palletops.awaze.client-builder/undef)
     (. bean11264 setEndDate (clojure.core/str v11266))))
   (clojure.core/let
    [v11266
     (:max-items m11265 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11266 :com.palletops.awaze.client-builder/undef)
     (. bean11264 setMaxItems (clojure.core/str v11266))))
   bean11264))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.UpdateHealthCheckRequest}
update-health-check-request
  [m11268]
  (clojure.core/let
   [bean11267
    (new
     com.amazonaws.services.route53.model.UpdateHealthCheckRequest)]
   (clojure.core/let
    [v11269
     (:inverted m11268 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11269 :com.palletops.awaze.client-builder/undef)
     (. bean11267 setInverted (clojure.core/boolean v11269))))
   (clojure.core/let
    [v11269
     (:resource-path m11268 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11269 :com.palletops.awaze.client-builder/undef)
     (. bean11267 setResourcePath (clojure.core/str v11269))))
   (clojure.core/let
    [v11269
     (:search-string m11268 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11269 :com.palletops.awaze.client-builder/undef)
     (. bean11267 setSearchString (clojure.core/str v11269))))
   (clojure.core/let
    [v11269
     (:health-check-id
      m11268
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11269 :com.palletops.awaze.client-builder/undef)
     (. bean11267 setHealthCheckId (clojure.core/str v11269))))
   (clojure.core/let
    [v11269
     (:child-health-checks
      m11268
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11269 :com.palletops.awaze.client-builder/undef)
     (.
      bean11267
      setChildHealthChecks
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11358] (clojure.core/str arg11358))
 v11269))))
   (clojure.core/let
    [v11269 (:port m11268 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11269 :com.palletops.awaze.client-builder/undef)
     (. bean11267 setPort (clojure.core/int v11269))))
   (clojure.core/let
    [v11269
     (:health-check-version
      m11268
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11269 :com.palletops.awaze.client-builder/undef)
     (. bean11267 setHealthCheckVersion (clojure.core/long v11269))))
   (clojure.core/let
    [v11269
     (:health-threshold
      m11268
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11269 :com.palletops.awaze.client-builder/undef)
     (. bean11267 setHealthThreshold (clojure.core/int v11269))))
   (clojure.core/let
    [v11269
     (:ipaddress m11268 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11269 :com.palletops.awaze.client-builder/undef)
     (. bean11267 setIPAddress (clojure.core/str v11269))))
   (clojure.core/let
    [v11269
     (:fully-qualified-domain-name
      m11268
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11269 :com.palletops.awaze.client-builder/undef)
     (.
      bean11267
      setFullyQualifiedDomainName
      (clojure.core/str v11269))))
   (clojure.core/let
    [v11269
     (:enable-sni m11268 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11269 :com.palletops.awaze.client-builder/undef)
     (. bean11267 setEnableSNI (clojure.core/boolean v11269))))
   (clojure.core/let
    [v11269
     (:failure-threshold
      m11268
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11269 :com.palletops.awaze.client-builder/undef)
     (. bean11267 setFailureThreshold (clojure.core/int v11269))))
   bean11267))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetHealthCheckLastFailureReasonRequest}
get-health-check-last-failure-reason-request
  [m11271]
  (clojure.core/let
   [bean11270
    (new
     com.amazonaws.services.route53.model.GetHealthCheckLastFailureReasonRequest)]
   (clojure.core/let
    [v11272
     (:health-check-id
      m11271
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11272 :com.palletops.awaze.client-builder/undef)
     (. bean11270 setHealthCheckId (clojure.core/str v11272))))
   bean11270))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.CreateHealthCheckRequest}
create-health-check-request
  [m11274]
  (clojure.core/let
   [bean11273
    (new
     com.amazonaws.services.route53.model.CreateHealthCheckRequest)]
   (clojure.core/let
    [v11275
     (:health-check-config
      m11274
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11275 :com.palletops.awaze.client-builder/undef)
     (.
      bean11273
      setHealthCheckConfig
      (route53/health-check-config v11275))))
   (clojure.core/let
    [v11275
     (:caller-reference
      m11274
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11275 :com.palletops.awaze.client-builder/undef)
     (. bean11273 setCallerReference (clojure.core/str v11275))))
   bean11273))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.CreateTrafficPolicyInstanceRequest}
create-traffic-policy-instance-request
  [m11277]
  (clojure.core/let
   [bean11276
    (new
     com.amazonaws.services.route53.model.CreateTrafficPolicyInstanceRequest)]
   (clojure.core/let
    [v11278 (:ttl m11277 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11278 :com.palletops.awaze.client-builder/undef)
     (. bean11276 setTTL (clojure.core/long v11278))))
   (clojure.core/let
    [v11278
     (:traffic-policy-id
      m11277
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11278 :com.palletops.awaze.client-builder/undef)
     (. bean11276 setTrafficPolicyId (clojure.core/str v11278))))
   (clojure.core/let
    [v11278
     (:traffic-policy-version
      m11277
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11278 :com.palletops.awaze.client-builder/undef)
     (. bean11276 setTrafficPolicyVersion (clojure.core/int v11278))))
   (clojure.core/let
    [v11278
     (:hosted-zone-id
      m11277
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11278 :com.palletops.awaze.client-builder/undef)
     (. bean11276 setHostedZoneId (clojure.core/str v11278))))
   (clojure.core/let
    [v11278 (:name m11277 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11278 :com.palletops.awaze.client-builder/undef)
     (. bean11276 setName (clojure.core/str v11278))))
   bean11276))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetChangeDetailsRequest}
get-change-details-request
  [m11280]
  (clojure.core/let
   [bean11279
    (new com.amazonaws.services.route53.model.GetChangeDetailsRequest)]
   (clojure.core/let
    [v11281 (:id m11280 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11281 :com.palletops.awaze.client-builder/undef)
     (. bean11279 setId (clojure.core/str v11281))))
   bean11279))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.CreateTrafficPolicyRequest}
create-traffic-policy-request
  [m11283]
  (clojure.core/let
   [bean11282
    (new
     com.amazonaws.services.route53.model.CreateTrafficPolicyRequest)]
   (clojure.core/let
    [v11284
     (:comment m11283 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11284 :com.palletops.awaze.client-builder/undef)
     (. bean11282 setComment (clojure.core/str v11284))))
   (clojure.core/let
    [v11284
     (:document m11283 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11284 :com.palletops.awaze.client-builder/undef)
     (. bean11282 setDocument (clojure.core/str v11284))))
   (clojure.core/let
    [v11284 (:name m11283 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11284 :com.palletops.awaze.client-builder/undef)
     (. bean11282 setName (clojure.core/str v11284))))
   bean11282))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ChangeTagsForResourceRequest}
change-tags-for-resource-request
  [m11286]
  (clojure.core/let
   [bean11285
    (new
     com.amazonaws.services.route53.model.ChangeTagsForResourceRequest)]
   (clojure.core/let
    [v11287
     (:add-tags m11286 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11287 :com.palletops.awaze.client-builder/undef)
     (.
      bean11285
      setAddTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11359] (route53/tag arg11359))
 v11287))))
   (clojure.core/let
    [v11287
     (:remove-tag-keys
      m11286
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11287 :com.palletops.awaze.client-builder/undef)
     (.
      bean11285
      setRemoveTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11360] (clojure.core/str arg11360))
 v11287))))
   (clojure.core/let
    [v11287
     (:resource-type m11286 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11287 :com.palletops.awaze.client-builder/undef)
     (. bean11285 setResourceType (route53/tag-resource-type v11287))))
   (clojure.core/let
    [v11287
     (:resource-id m11286 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11287 :com.palletops.awaze.client-builder/undef)
     (. bean11285 setResourceId (clojure.core/str v11287))))
   bean11285))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetTrafficPolicyInstanceCountRequest}
get-traffic-policy-instance-count-request
  [m11289]
  (clojure.core/let
   [bean11288
    (new
     com.amazonaws.services.route53.model.GetTrafficPolicyInstanceCountRequest)]
   bean11288))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetHealthCheckStatusRequest}
get-health-check-status-request
  [m11292]
  (clojure.core/let
   [bean11291
    (new
     com.amazonaws.services.route53.model.GetHealthCheckStatusRequest)]
   (clojure.core/let
    [v11293
     (:health-check-id
      m11292
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11293 :com.palletops.awaze.client-builder/undef)
     (. bean11291 setHealthCheckId (clojure.core/str v11293))))
   bean11291))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetChangeRequest}
get-change-request
  [m11295]
  (clojure.core/let
   [bean11294
    (new com.amazonaws.services.route53.model.GetChangeRequest)]
   (clojure.core/let
    [v11296 (:id m11295 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11296 :com.palletops.awaze.client-builder/undef)
     (. bean11294 setId (clojure.core/str v11296))))
   bean11294))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListGeoLocationsRequest}
list-geo-locations-request
  [m11298]
  (clojure.core/let
   [bean11297
    (new com.amazonaws.services.route53.model.ListGeoLocationsRequest)]
   (clojure.core/let
    [v11299
     (:start-continent-code
      m11298
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11299 :com.palletops.awaze.client-builder/undef)
     (. bean11297 setStartContinentCode (clojure.core/str v11299))))
   (clojure.core/let
    [v11299
     (:start-country-code
      m11298
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11299 :com.palletops.awaze.client-builder/undef)
     (. bean11297 setStartCountryCode (clojure.core/str v11299))))
   (clojure.core/let
    [v11299
     (:start-subdivision-code
      m11298
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11299 :com.palletops.awaze.client-builder/undef)
     (. bean11297 setStartSubdivisionCode (clojure.core/str v11299))))
   (clojure.core/let
    [v11299
     (:max-items m11298 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11299 :com.palletops.awaze.client-builder/undef)
     (. bean11297 setMaxItems (clojure.core/str v11299))))
   bean11297))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetHostedZoneCountRequest}
get-hosted-zone-count-request
  [m11301]
  (clojure.core/let
   [bean11300
    (new
     com.amazonaws.services.route53.model.GetHostedZoneCountRequest)]
   bean11300))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.UpdateHostedZoneCommentRequest}
update-hosted-zone-comment-request
  [m11304]
  (clojure.core/let
   [bean11303
    (new
     com.amazonaws.services.route53.model.UpdateHostedZoneCommentRequest)]
   (clojure.core/let
    [v11305
     (:comment m11304 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11305 :com.palletops.awaze.client-builder/undef)
     (. bean11303 setComment (clojure.core/str v11305))))
   (clojure.core/let
    [v11305 (:id m11304 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11305 :com.palletops.awaze.client-builder/undef)
     (. bean11303 setId (clojure.core/str v11305))))
   bean11303))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetHealthCheckCountRequest}
get-health-check-count-request
  [m11307]
  (clojure.core/let
   [bean11306
    (new
     com.amazonaws.services.route53.model.GetHealthCheckCountRequest)]
   bean11306))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetHostedZoneRequest}
get-hosted-zone-request
  [m11310]
  (clojure.core/let
   [bean11309
    (new com.amazonaws.services.route53.model.GetHostedZoneRequest)]
   (clojure.core/let
    [v11311 (:id m11310 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11311 :com.palletops.awaze.client-builder/undef)
     (. bean11309 setId (clojure.core/str v11311))))
   bean11309))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.UpdateTrafficPolicyCommentRequest}
update-traffic-policy-comment-request
  [m11313]
  (clojure.core/let
   [bean11312
    (new
     com.amazonaws.services.route53.model.UpdateTrafficPolicyCommentRequest)]
   (clojure.core/let
    [v11314
     (:version m11313 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11314 :com.palletops.awaze.client-builder/undef)
     (. bean11312 setVersion (clojure.core/int v11314))))
   (clojure.core/let
    [v11314
     (:comment m11313 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11314 :com.palletops.awaze.client-builder/undef)
     (. bean11312 setComment (clojure.core/str v11314))))
   (clojure.core/let
    [v11314 (:id m11313 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11314 :com.palletops.awaze.client-builder/undef)
     (. bean11312 setId (clojure.core/str v11314))))
   bean11312))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetTrafficPolicyInstanceRequest}
get-traffic-policy-instance-request
  [m11316]
  (clojure.core/let
   [bean11315
    (new
     com.amazonaws.services.route53.model.GetTrafficPolicyInstanceRequest)]
   (clojure.core/let
    [v11317 (:id m11316 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11317 :com.palletops.awaze.client-builder/undef)
     (. bean11315 setId (clojure.core/str v11317))))
   bean11315))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListHostedZonesByNameRequest}
list-hosted-zones-by-name-request
  [m11319]
  (clojure.core/let
   [bean11318
    (new
     com.amazonaws.services.route53.model.ListHostedZonesByNameRequest)]
   (clojure.core/let
    [v11320
     (:hosted-zone-id
      m11319
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11320 :com.palletops.awaze.client-builder/undef)
     (. bean11318 setHostedZoneId (clojure.core/str v11320))))
   (clojure.core/let
    [v11320
     (:dnsname m11319 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11320 :com.palletops.awaze.client-builder/undef)
     (. bean11318 setDNSName (clojure.core/str v11320))))
   (clojure.core/let
    [v11320
     (:max-items m11319 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11320 :com.palletops.awaze.client-builder/undef)
     (. bean11318 setMaxItems (clojure.core/str v11320))))
   bean11318))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetGeoLocationRequest}
get-geo-location-request
  [m11322]
  (clojure.core/let
   [bean11321
    (new com.amazonaws.services.route53.model.GetGeoLocationRequest)]
   (clojure.core/let
    [v11323
     (:country-code m11322 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11323 :com.palletops.awaze.client-builder/undef)
     (. bean11321 setCountryCode (clojure.core/str v11323))))
   (clojure.core/let
    [v11323
     (:continent-code
      m11322
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11323 :com.palletops.awaze.client-builder/undef)
     (. bean11321 setContinentCode (clojure.core/str v11323))))
   (clojure.core/let
    [v11323
     (:subdivision-code
      m11322
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11323 :com.palletops.awaze.client-builder/undef)
     (. bean11321 setSubdivisionCode (clojure.core/str v11323))))
   bean11321))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListTagsForResourceRequest}
list-tags-for-resource-request
  [m11325]
  (clojure.core/let
   [bean11324
    (new
     com.amazonaws.services.route53.model.ListTagsForResourceRequest)]
   (clojure.core/let
    [v11326
     (:resource-type m11325 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11326 :com.palletops.awaze.client-builder/undef)
     (. bean11324 setResourceType (route53/tag-resource-type v11326))))
   (clojure.core/let
    [v11326
     (:resource-id m11325 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11326 :com.palletops.awaze.client-builder/undef)
     (. bean11324 setResourceId (clojure.core/str v11326))))
   bean11324))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.CreateReusableDelegationSetRequest}
create-reusable-delegation-set-request
  [m11328]
  (clojure.core/let
   [bean11327
    (new
     com.amazonaws.services.route53.model.CreateReusableDelegationSetRequest)]
   (clojure.core/let
    [v11329
     (:caller-reference
      m11328
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11329 :com.palletops.awaze.client-builder/undef)
     (. bean11327 setCallerReference (clojure.core/str v11329))))
   (clojure.core/let
    [v11329
     (:hosted-zone-id
      m11328
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11329 :com.palletops.awaze.client-builder/undef)
     (. bean11327 setHostedZoneId (clojure.core/str v11329))))
   bean11327))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListHealthChecksRequest}
list-health-checks-request
  [m11331]
  (clojure.core/let
   [bean11330
    (new com.amazonaws.services.route53.model.ListHealthChecksRequest)]
   (clojure.core/let
    [v11332
     (:marker m11331 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11332 :com.palletops.awaze.client-builder/undef)
     (. bean11330 setMarker (clojure.core/str v11332))))
   (clojure.core/let
    [v11332
     (:max-items m11331 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11332 :com.palletops.awaze.client-builder/undef)
     (. bean11330 setMaxItems (clojure.core/str v11332))))
   bean11330))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.UpdateTrafficPolicyInstanceRequest}
update-traffic-policy-instance-request
  [m11334]
  (clojure.core/let
   [bean11333
    (new
     com.amazonaws.services.route53.model.UpdateTrafficPolicyInstanceRequest)]
   (clojure.core/let
    [v11335 (:ttl m11334 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11335 :com.palletops.awaze.client-builder/undef)
     (. bean11333 setTTL (clojure.core/long v11335))))
   (clojure.core/let
    [v11335
     (:traffic-policy-id
      m11334
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11335 :com.palletops.awaze.client-builder/undef)
     (. bean11333 setTrafficPolicyId (clojure.core/str v11335))))
   (clojure.core/let
    [v11335
     (:traffic-policy-version
      m11334
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11335 :com.palletops.awaze.client-builder/undef)
     (. bean11333 setTrafficPolicyVersion (clojure.core/int v11335))))
   (clojure.core/let
    [v11335 (:id m11334 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11335 :com.palletops.awaze.client-builder/undef)
     (. bean11333 setId (clojure.core/str v11335))))
   bean11333))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.DeleteHealthCheckRequest}
delete-health-check-request
  [m11337]
  (clojure.core/let
   [bean11336
    (new
     com.amazonaws.services.route53.model.DeleteHealthCheckRequest)]
   (clojure.core/let
    [v11338
     (:health-check-id
      m11337
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11338 :com.palletops.awaze.client-builder/undef)
     (. bean11336 setHealthCheckId (clojure.core/str v11338))))
   bean11336))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetTrafficPolicyRequest}
get-traffic-policy-request
  [m11340]
  (clojure.core/let
   [bean11339
    (new com.amazonaws.services.route53.model.GetTrafficPolicyRequest)]
   (clojure.core/let
    [v11341
     (:version m11340 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11341 :com.palletops.awaze.client-builder/undef)
     (. bean11339 setVersion (clojure.core/int v11341))))
   (clojure.core/let
    [v11341 (:id m11340 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11341 :com.palletops.awaze.client-builder/undef)
     (. bean11339 setId (clojure.core/str v11341))))
   bean11339))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListChangeBatchesByRRSetRequest}
list-change-batches-by-rrset-request
  [m11343]
  (clojure.core/let
   [bean11342
    (new
     com.amazonaws.services.route53.model.ListChangeBatchesByRRSetRequest)]
   (clojure.core/let
    [v11344
     (:set-identifier
      m11343
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11344 :com.palletops.awaze.client-builder/undef)
     (. bean11342 setSetIdentifier (clojure.core/str v11344))))
   (clojure.core/let
    [v11344 (:type m11343 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11344 :com.palletops.awaze.client-builder/undef)
     (. bean11342 setType (route53/rrtype v11344))))
   (clojure.core/let
    [v11344
     (:marker m11343 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11344 :com.palletops.awaze.client-builder/undef)
     (. bean11342 setMarker (clojure.core/str v11344))))
   (clojure.core/let
    [v11344
     (:hosted-zone-id
      m11343
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11344 :com.palletops.awaze.client-builder/undef)
     (. bean11342 setHostedZoneId (clojure.core/str v11344))))
   (clojure.core/let
    [v11344
     (:start-date m11343 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11344 :com.palletops.awaze.client-builder/undef)
     (. bean11342 setStartDate (clojure.core/str v11344))))
   (clojure.core/let
    [v11344
     (:end-date m11343 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11344 :com.palletops.awaze.client-builder/undef)
     (. bean11342 setEndDate (clojure.core/str v11344))))
   (clojure.core/let
    [v11344
     (:max-items m11343 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11344 :com.palletops.awaze.client-builder/undef)
     (. bean11342 setMaxItems (clojure.core/str v11344))))
   (clojure.core/let
    [v11344 (:name m11343 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11344 :com.palletops.awaze.client-builder/undef)
     (. bean11342 setName (clojure.core/str v11344))))
   bean11342))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListResourceRecordSetsRequest}
list-resource-record-sets-request
  [m11346]
  (clojure.core/let
   [bean11345
    (new
     com.amazonaws.services.route53.model.ListResourceRecordSetsRequest)]
   (clojure.core/let
    [v11347
     (:start-record-name
      m11346
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11347 :com.palletops.awaze.client-builder/undef)
     (. bean11345 setStartRecordName (clojure.core/str v11347))))
   (clojure.core/let
    [v11347
     (:start-record-type
      m11346
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11347 :com.palletops.awaze.client-builder/undef)
     (. bean11345 setStartRecordType (clojure.core/str v11347))))
   (clojure.core/let
    [v11347
     (:start-record-identifier
      m11346
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11347 :com.palletops.awaze.client-builder/undef)
     (. bean11345 setStartRecordIdentifier (clojure.core/str v11347))))
   (clojure.core/let
    [v11347
     (:hosted-zone-id
      m11346
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11347 :com.palletops.awaze.client-builder/undef)
     (. bean11345 setHostedZoneId (clojure.core/str v11347))))
   (clojure.core/let
    [v11347
     (:max-items m11346 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11347 :com.palletops.awaze.client-builder/undef)
     (. bean11345 setMaxItems (clojure.core/str v11347))))
   bean11345))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.DisassociateVPCFromHostedZoneRequest}
disassociate-vpcfrom-hosted-zone-request
  [m11349]
  (clojure.core/let
   [bean11348
    (new
     com.amazonaws.services.route53.model.DisassociateVPCFromHostedZoneRequest)]
   (clojure.core/let
    [v11350
     (:comment m11349 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11350 :com.palletops.awaze.client-builder/undef)
     (. bean11348 setComment (clojure.core/str v11350))))
   (clojure.core/let
    [v11350 (:vpc m11349 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11350 :com.palletops.awaze.client-builder/undef)
     (. bean11348 setVPC (route53/vpc v11350))))
   (clojure.core/let
    [v11350
     (:hosted-zone-id
      m11349
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11350 :com.palletops.awaze.client-builder/undef)
     (. bean11348 setHostedZoneId (clojure.core/str v11350))))
   bean11348))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListTrafficPolicyInstancesRequest}
list-traffic-policy-instances-request
  [m11352]
  (clojure.core/let
   [bean11351
    (new
     com.amazonaws.services.route53.model.ListTrafficPolicyInstancesRequest)]
   (clojure.core/let
    [v11353
     (:traffic-policy-instance-type-marker
      m11352
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11353 :com.palletops.awaze.client-builder/undef)
     (.
      bean11351
      setTrafficPolicyInstanceTypeMarker
      (clojure.core/str v11353))))
   (clojure.core/let
    [v11353
     (:hosted-zone-id-marker
      m11352
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11353 :com.palletops.awaze.client-builder/undef)
     (. bean11351 setHostedZoneIdMarker (clojure.core/str v11353))))
   (clojure.core/let
    [v11353
     (:traffic-policy-instance-name-marker
      m11352
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11353 :com.palletops.awaze.client-builder/undef)
     (.
      bean11351
      setTrafficPolicyInstanceNameMarker
      (clojure.core/str v11353))))
   (clojure.core/let
    [v11353
     (:max-items m11352 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11353 :com.palletops.awaze.client-builder/undef)
     (. bean11351 setMaxItems (clojure.core/str v11353))))
   bean11351))
 (clojure.core/defmulti
  route53
  (clojure.core/fn route53 [m__1874__auto__] (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   route53
   :create-traffic-policy-version
   [m11361]
   (clojure.core/let
    [credentials11362 (:credentials m11361) args11363 (:args m11361)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11364
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11362)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11364
       createTrafficPolicyVersion
       (route53/create-traffic-policy-version-request
        (clojure.core/nth args11363 0)))))))
  (clojure.core/defn
   create-traffic-policy-version-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         document
                         read-limit
                         id
                         comment
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createTrafficPolicyVersion"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-traffic-policy-version,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   create-traffic-policy-version
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         document
                         read-limit
                         id
                         comment
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createTrafficPolicyVersion"}
   [credentials11366 & args11367]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11368
     (com.palletops.awaze.common/aws-client :route53 credentials11366)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11368
      createTrafficPolicyVersion
      (route53/create-traffic-policy-version-request
       (clojure.core/nth args11367 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :delete-traffic-policy
   [m11369]
   (clojure.core/let
    [credentials11370 (:credentials m11369) args11371 (:args m11369)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11372
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11370)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11372
       deleteTrafficPolicy
       (route53/delete-traffic-policy-request
        (clojure.core/nth args11371 0)))))))
  (clojure.core/defn
   delete-traffic-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         version
                         clone-root]}]]),
    :doc "Generate map for deleteTrafficPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-traffic-policy,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   delete-traffic-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         version
                         clone-root]}]]),
    :doc "Call deleteTrafficPolicy"}
   [credentials11374 & args11375]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11376
     (com.palletops.awaze.common/aws-client :route53 credentials11374)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11376
      deleteTrafficPolicy
      (route53/delete-traffic-policy-request
       (clojure.core/nth args11375 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :change-resource-record-sets
   [m11377]
   (clojure.core/let
    [credentials11378 (:credentials m11377) args11379 (:args m11377)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11380
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11378)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11380
       changeResourceRecordSets
       (route53/change-resource-record-sets-request
        (clojure.core/nth args11379 0)))))))
  (clojure.core/defn
   change-resource-record-sets-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         change-batch
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Generate map for changeResourceRecordSets"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :change-resource-record-sets,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   change-resource-record-sets
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         change-batch
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Call changeResourceRecordSets"}
   [credentials11382 & args11383]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11384
     (com.palletops.awaze.common/aws-client :route53 credentials11382)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11384
      changeResourceRecordSets
      (route53/change-resource-record-sets-request
       (clojure.core/nth args11383 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-traffic-policies
   [m11385]
   (clojure.core/let
    [credentials11386 (:credentials m11385) args11387 (:args m11385)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11388
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11386)]
     (clojure.core/case
      (clojure.core/count args11387)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11388
        listTrafficPolicies
        (route53/list-traffic-policies-request
         (clojure.core/nth args11387 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11388
        listTrafficPolicies))))))
  (clojure.core/defn
   list-traffic-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         max-items
                         traffic-policy-id-marker
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listTrafficPolicies, listTrafficPolicies"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-traffic-policies,
     :credentials credentials__1842__auto__,
     :client :route53})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-traffic-policies,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   list-traffic-policies
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         max-items
                         traffic-policy-id-marker
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listTrafficPolicies, listTrafficPolicies"}
   [credentials11390 & args11391]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11392
     (com.palletops.awaze.common/aws-client :route53 credentials11390)]
    (clojure.core/case
     (clojure.core/count args11391)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11392
       listTrafficPolicies
       (route53/list-traffic-policies-request
        (clojure.core/nth args11391 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11392
       listTrafficPolicies))))))
 (do
  (clojure.core/defmethod
   route53
   :list-traffic-policy-instances-by-policy
   [m11393]
   (clojure.core/let
    [credentials11394 (:credentials m11393) args11395 (:args m11393)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11396
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11394)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11396
       listTrafficPolicyInstancesByPolicy
       (route53/list-traffic-policy-instances-by-policy-request
        (clojure.core/nth args11395 0)))))))
  (clojure.core/defn
   list-traffic-policy-instances-by-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         traffic-policy-instance-type-marker
                         hosted-zone-id-marker
                         traffic-policy-version
                         traffic-policy-id
                         traffic-policy-instance-name-marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listTrafficPolicyInstancesByPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-traffic-policy-instances-by-policy,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   list-traffic-policy-instances-by-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         traffic-policy-instance-type-marker
                         hosted-zone-id-marker
                         traffic-policy-version
                         traffic-policy-id
                         traffic-policy-instance-name-marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listTrafficPolicyInstancesByPolicy"}
   [credentials11398 & args11399]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11400
     (com.palletops.awaze.common/aws-client :route53 credentials11398)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11400
      listTrafficPolicyInstancesByPolicy
      (route53/list-traffic-policy-instances-by-policy-request
       (clojure.core/nth args11399 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-traffic-policy-versions
   [m11401]
   (clojure.core/let
    [credentials11402 (:credentials m11401) args11403 (:args m11401)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11404
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11402)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11404
       listTrafficPolicyVersions
       (route53/list-traffic-policy-versions-request
        (clojure.core/nth args11403 0)))))))
  (clojure.core/defn
   list-traffic-policy-versions-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         traffic-policy-version-marker
                         custom-query-parameters
                         max-items
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listTrafficPolicyVersions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-traffic-policy-versions,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   list-traffic-policy-versions
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         traffic-policy-version-marker
                         custom-query-parameters
                         max-items
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listTrafficPolicyVersions"}
   [credentials11406 & args11407]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11408
     (com.palletops.awaze.common/aws-client :route53 credentials11406)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11408
      listTrafficPolicyVersions
      (route53/list-traffic-policy-versions-request
       (clojure.core/nth args11407 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-traffic-policy-instances-by-hosted-zone
   [m11409]
   (clojure.core/let
    [credentials11410 (:credentials m11409) args11411 (:args m11409)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11412
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11410)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11412
       listTrafficPolicyInstancesByHostedZone
       (route53/list-traffic-policy-instances-by-hosted-zone-request
        (clojure.core/nth args11411 0)))))))
  (clojure.core/defn
   list-traffic-policy-instances-by-hosted-zone-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         traffic-policy-instance-type-marker
                         traffic-policy-instance-name-marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Generate map for listTrafficPolicyInstancesByHostedZone"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-traffic-policy-instances-by-hosted-zone,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   list-traffic-policy-instances-by-hosted-zone
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         traffic-policy-instance-type-marker
                         traffic-policy-instance-name-marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Call listTrafficPolicyInstancesByHostedZone"}
   [credentials11414 & args11415]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11416
     (com.palletops.awaze.common/aws-client :route53 credentials11414)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11416
      listTrafficPolicyInstancesByHostedZone
      (route53/list-traffic-policy-instances-by-hosted-zone-request
       (clojure.core/nth args11415 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :delete-reusable-delegation-set
   [m11417]
   (clojure.core/let
    [credentials11418 (:credentials m11417) args11419 (:args m11417)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11420
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11418)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11420
       deleteReusableDelegationSet
       (route53/delete-reusable-delegation-set-request
        (clojure.core/nth args11419 0)))))))
  (clojure.core/defn
   delete-reusable-delegation-set-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteReusableDelegationSet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-reusable-delegation-set,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   delete-reusable-delegation-set
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteReusableDelegationSet"}
   [credentials11422 & args11423]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11424
     (com.palletops.awaze.common/aws-client :route53 credentials11422)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11424
      deleteReusableDelegationSet
      (route53/delete-reusable-delegation-set-request
       (clojure.core/nth args11423 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :get-reusable-delegation-set
   [m11425]
   (clojure.core/let
    [credentials11426 (:credentials m11425) args11427 (:args m11425)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11428
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11426)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11428
       getReusableDelegationSet
       (route53/get-reusable-delegation-set-request
        (clojure.core/nth args11427 0)))))))
  (clojure.core/defn
   get-reusable-delegation-set-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getReusableDelegationSet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-reusable-delegation-set,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   get-reusable-delegation-set
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getReusableDelegationSet"}
   [credentials11430 & args11431]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11432
     (com.palletops.awaze.common/aws-client :route53 credentials11430)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11432
      getReusableDelegationSet
      (route53/get-reusable-delegation-set-request
       (clojure.core/nth args11431 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :delete-hosted-zone
   [m11433]
   (clojure.core/let
    [credentials11434 (:credentials m11433) args11435 (:args m11433)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11436
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11434)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11436
       deleteHostedZone
       (route53/delete-hosted-zone-request
        (clojure.core/nth args11435 0)))))))
  (clojure.core/defn
   delete-hosted-zone-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteHostedZone"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-hosted-zone,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   delete-hosted-zone
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteHostedZone"}
   [credentials11438 & args11439]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11440
     (com.palletops.awaze.common/aws-client :route53 credentials11438)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11440
      deleteHostedZone
      (route53/delete-hosted-zone-request
       (clojure.core/nth args11439 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :associate-vpcwith-hosted-zone
   [m11441]
   (clojure.core/let
    [credentials11442 (:credentials m11441) args11443 (:args m11441)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11444
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11442)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11444
       associateVPCWithHostedZone
       (route53/associate-vpcwith-hosted-zone-request
        (clojure.core/nth args11443 0)))))))
  (clojure.core/defn
   associate-vpcwith-hosted-zone-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         vpc
                         comment
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Generate map for associateVPCWithHostedZone"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :associate-vpcwith-hosted-zone,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   associate-vpcwith-hosted-zone
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         vpc
                         comment
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Call associateVPCWithHostedZone"}
   [credentials11446 & args11447]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11448
     (com.palletops.awaze.common/aws-client :route53 credentials11446)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11448
      associateVPCWithHostedZone
      (route53/associate-vpcwith-hosted-zone-request
       (clojure.core/nth args11447 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-hosted-zones
   [m11449]
   (clojure.core/let
    [credentials11450 (:credentials m11449) args11451 (:args m11449)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11452
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11450)]
     (clojure.core/case
      (clojure.core/count args11451)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11452
        listHostedZones
        (route53/list-hosted-zones-request
         (clojure.core/nth args11451 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11452
        listHostedZones))))))
  (clojure.core/defn
   list-hosted-zones-map
   {:arglists (quote
               [[credentials
                 {:keys [delegation-set-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listHostedZones, listHostedZones"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-hosted-zones,
     :credentials credentials__1842__auto__,
     :client :route53})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-hosted-zones,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   list-hosted-zones
   {:arglists (quote
               [[credentials
                 {:keys [delegation-set-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listHostedZones, listHostedZones"}
   [credentials11454 & args11455]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11456
     (com.palletops.awaze.common/aws-client :route53 credentials11454)]
    (clojure.core/case
     (clojure.core/count args11455)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11456
       listHostedZones
       (route53/list-hosted-zones-request
        (clojure.core/nth args11455 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11456
       listHostedZones))))))
 (do
  (clojure.core/defmethod
   route53
   :list-reusable-delegation-sets
   [m11457]
   (clojure.core/let
    [credentials11458 (:credentials m11457) args11459 (:args m11457)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11460
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11458)]
     (clojure.core/case
      (clojure.core/count args11459)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11460
        listReusableDelegationSets
        (route53/list-reusable-delegation-sets-request
         (clojure.core/nth args11459 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11460
        listReusableDelegationSets))))))
  (clojure.core/defn
   list-reusable-delegation-sets-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listReusableDelegationSets, listReusableDelegationSets"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-reusable-delegation-sets,
     :credentials credentials__1842__auto__,
     :client :route53})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-reusable-delegation-sets,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   list-reusable-delegation-sets
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listReusableDelegationSets, listReusableDelegationSets"}
   [credentials11462 & args11463]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11464
     (com.palletops.awaze.common/aws-client :route53 credentials11462)]
    (clojure.core/case
     (clojure.core/count args11463)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11464
       listReusableDelegationSets
       (route53/list-reusable-delegation-sets-request
        (clojure.core/nth args11463 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11464
       listReusableDelegationSets))))))
 (do
  (clojure.core/defmethod
   route53
   :delete-traffic-policy-instance
   [m11465]
   (clojure.core/let
    [credentials11466 (:credentials m11465) args11467 (:args m11465)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11468
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11466)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11468
       deleteTrafficPolicyInstance
       (route53/delete-traffic-policy-instance-request
        (clojure.core/nth args11467 0)))))))
  (clojure.core/defn
   delete-traffic-policy-instance-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteTrafficPolicyInstance"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-traffic-policy-instance,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   delete-traffic-policy-instance
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteTrafficPolicyInstance"}
   [credentials11470 & args11471]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11472
     (com.palletops.awaze.common/aws-client :route53 credentials11470)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11472
      deleteTrafficPolicyInstance
      (route53/delete-traffic-policy-instance-request
       (clojure.core/nth args11471 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :get-health-check
   [m11473]
   (clojure.core/let
    [credentials11474 (:credentials m11473) args11475 (:args m11473)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11476
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11474)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11476
       getHealthCheck
       (route53/get-health-check-request
        (clojure.core/nth args11475 0)))))))
  (clojure.core/defn
   get-health-check-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         health-check-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getHealthCheck"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-health-check,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   get-health-check
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         health-check-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getHealthCheck"}
   [credentials11478 & args11479]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11480
     (com.palletops.awaze.common/aws-client :route53 credentials11478)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11480
      getHealthCheck
      (route53/get-health-check-request
       (clojure.core/nth args11479 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-tags-for-resources
   [m11481]
   (clojure.core/let
    [credentials11482 (:credentials m11481) args11483 (:args m11481)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11484
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11482)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11484
       listTagsForResources
       (route53/list-tags-for-resources-request
        (clojure.core/nth args11483 0)))))))
  (clojure.core/defn
   list-tags-for-resources-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         resource-ids
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         resource-type
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listTagsForResources"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-tags-for-resources,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   list-tags-for-resources
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         resource-ids
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         resource-type
                         clone-source
                         clone-root]}]]),
    :doc "Call listTagsForResources"}
   [credentials11486 & args11487]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11488
     (com.palletops.awaze.common/aws-client :route53 credentials11486)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11488
      listTagsForResources
      (route53/list-tags-for-resources-request
       (clojure.core/nth args11487 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :get-checker-ip-ranges
   [m11489]
   (clojure.core/let
    [credentials11490 (:credentials m11489) args11491 (:args m11489)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11492
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11490)]
     (clojure.core/case
      (clojure.core/count args11491)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11492
        getCheckerIpRanges))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11492
        getCheckerIpRanges
        (route53/get-checker-ip-ranges-request
         (clojure.core/nth args11491 0))))))))
  (clojure.core/defn
   get-checker-ip-ranges-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getCheckerIpRanges, getCheckerIpRanges"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-checker-ip-ranges,
     :credentials credentials__1842__auto__,
     :client :route53})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-checker-ip-ranges,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   get-checker-ip-ranges
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getCheckerIpRanges, getCheckerIpRanges"}
   [credentials11494 & args11495]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11496
     (com.palletops.awaze.common/aws-client :route53 credentials11494)]
    (clojure.core/case
     (clojure.core/count args11495)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11496
       getCheckerIpRanges))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11496
       getCheckerIpRanges
       (route53/get-checker-ip-ranges-request
        (clojure.core/nth args11495 0))))))))
 (do
  (clojure.core/defmethod
   route53
   :create-hosted-zone
   [m11497]
   (clojure.core/let
    [credentials11498 (:credentials m11497) args11499 (:args m11497)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11500
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11498)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11500
       createHostedZone
       (route53/create-hosted-zone-request
        (clojure.core/nth args11499 0)))))))
  (clojure.core/defn
   create-hosted-zone-map
   {:arglists (quote
               [[credentials
                 {:keys [caller-reference
                         delegation-set-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         hosted-zone-config
                         custom-query-parameters
                         read-limit
                         vpc
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createHostedZone"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-hosted-zone,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   create-hosted-zone
   {:arglists (quote
               [[credentials
                 {:keys [caller-reference
                         delegation-set-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         hosted-zone-config
                         custom-query-parameters
                         read-limit
                         vpc
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createHostedZone"}
   [credentials11502 & args11503]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11504
     (com.palletops.awaze.common/aws-client :route53 credentials11502)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11504
      createHostedZone
      (route53/create-hosted-zone-request
       (clojure.core/nth args11503 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-change-batches-by-hosted-zone
   [m11505]
   (clojure.core/let
    [credentials11506 (:credentials m11505) args11507 (:args m11505)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11508
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11506)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11508
       listChangeBatchesByHostedZone
       (route53/list-change-batches-by-hosted-zone-request
        (clojure.core/nth args11507 0)))))))
  (clojure.core/defn
   list-change-batches-by-hosted-zone-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         end-date
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         start-date
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Generate map for listChangeBatchesByHostedZone"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-change-batches-by-hosted-zone,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   list-change-batches-by-hosted-zone
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         end-date
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         start-date
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Call listChangeBatchesByHostedZone"}
   [credentials11510 & args11511]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11512
     (com.palletops.awaze.common/aws-client :route53 credentials11510)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11512
      listChangeBatchesByHostedZone
      (route53/list-change-batches-by-hosted-zone-request
       (clojure.core/nth args11511 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :update-health-check
   [m11513]
   (clojure.core/let
    [credentials11514 (:credentials m11513) args11515 (:args m11513)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11516
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11514)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11516
       updateHealthCheck
       (route53/update-health-check-request
        (clojure.core/nth args11515 0)))))))
  (clojure.core/defn
   update-health-check-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         fully-qualified-domain-name
                         resource-path
                         sdk-request-timeout
                         custom-query-parameters
                         port
                         health-threshold
                         health-check-id
                         failure-threshold
                         enable-sni
                         read-limit
                         health-check-version
                         ipaddress
                         child-health-checks
                         general-progress-listener
                         clone-source
                         search-string
                         clone-root
                         inverted]}]]),
    :doc "Generate map for updateHealthCheck"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-health-check,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   update-health-check
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         fully-qualified-domain-name
                         resource-path
                         sdk-request-timeout
                         custom-query-parameters
                         port
                         health-threshold
                         health-check-id
                         failure-threshold
                         enable-sni
                         read-limit
                         health-check-version
                         ipaddress
                         child-health-checks
                         general-progress-listener
                         clone-source
                         search-string
                         clone-root
                         inverted]}]]),
    :doc "Call updateHealthCheck"}
   [credentials11518 & args11519]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11520
     (com.palletops.awaze.common/aws-client :route53 credentials11518)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11520
      updateHealthCheck
      (route53/update-health-check-request
       (clojure.core/nth args11519 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :get-health-check-last-failure-reason
   [m11521]
   (clojure.core/let
    [credentials11522 (:credentials m11521) args11523 (:args m11521)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11524
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11522)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11524
       getHealthCheckLastFailureReason
       (route53/get-health-check-last-failure-reason-request
        (clojure.core/nth args11523 0)))))))
  (clojure.core/defn
   get-health-check-last-failure-reason-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         health-check-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getHealthCheckLastFailureReason"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-health-check-last-failure-reason,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   get-health-check-last-failure-reason
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         health-check-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getHealthCheckLastFailureReason"}
   [credentials11526 & args11527]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11528
     (com.palletops.awaze.common/aws-client :route53 credentials11526)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11528
      getHealthCheckLastFailureReason
      (route53/get-health-check-last-failure-reason-request
       (clojure.core/nth args11527 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :create-health-check
   [m11529]
   (clojure.core/let
    [credentials11530 (:credentials m11529) args11531 (:args m11529)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11532
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11530)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11532
       createHealthCheck
       (route53/create-health-check-request
        (clojure.core/nth args11531 0)))))))
  (clojure.core/defn
   create-health-check-map
   {:arglists (quote
               [[credentials
                 {:keys [caller-reference
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         health-check-config
                         clone-root]}]]),
    :doc "Generate map for createHealthCheck"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-health-check,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   create-health-check
   {:arglists (quote
               [[credentials
                 {:keys [caller-reference
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         health-check-config
                         clone-root]}]]),
    :doc "Call createHealthCheck"}
   [credentials11534 & args11535]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11536
     (com.palletops.awaze.common/aws-client :route53 credentials11534)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11536
      createHealthCheck
      (route53/create-health-check-request
       (clojure.core/nth args11535 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :create-traffic-policy-instance
   [m11537]
   (clojure.core/let
    [credentials11538 (:credentials m11537) args11539 (:args m11537)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11540
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11538)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11540
       createTrafficPolicyInstance
       (route53/create-traffic-policy-instance-request
        (clojure.core/nth args11539 0)))))))
  (clojure.core/defn
   create-traffic-policy-instance-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         traffic-policy-version
                         traffic-policy-id
                         custom-query-parameters
                         ttl
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Generate map for createTrafficPolicyInstance"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-traffic-policy-instance,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   create-traffic-policy-instance
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         traffic-policy-version
                         traffic-policy-id
                         custom-query-parameters
                         ttl
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Call createTrafficPolicyInstance"}
   [credentials11542 & args11543]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11544
     (com.palletops.awaze.common/aws-client :route53 credentials11542)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11544
      createTrafficPolicyInstance
      (route53/create-traffic-policy-instance-request
       (clojure.core/nth args11543 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :get-change-details
   [m11545]
   (clojure.core/let
    [credentials11546 (:credentials m11545) args11547 (:args m11545)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11548
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11546)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11548
       getChangeDetails
       (route53/get-change-details-request
        (clojure.core/nth args11547 0)))))))
  (clojure.core/defn
   get-change-details-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getChangeDetails"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-change-details,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   get-change-details
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getChangeDetails"}
   [credentials11550 & args11551]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11552
     (com.palletops.awaze.common/aws-client :route53 credentials11550)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11552
      getChangeDetails
      (route53/get-change-details-request
       (clojure.core/nth args11551 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :create-traffic-policy
   [m11553]
   (clojure.core/let
    [credentials11554 (:credentials m11553) args11555 (:args m11553)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11556
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11554)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11556
       createTrafficPolicy
       (route53/create-traffic-policy-request
        (clojure.core/nth args11555 0)))))))
  (clojure.core/defn
   create-traffic-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         document
                         read-limit
                         comment
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createTrafficPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-traffic-policy,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   create-traffic-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         document
                         read-limit
                         comment
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createTrafficPolicy"}
   [credentials11558 & args11559]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11560
     (com.palletops.awaze.common/aws-client :route53 credentials11558)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11560
      createTrafficPolicy
      (route53/create-traffic-policy-request
       (clojure.core/nth args11559 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :change-tags-for-resource
   [m11561]
   (clojure.core/let
    [credentials11562 (:credentials m11561) args11563 (:args m11561)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11564
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11562)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11564
       changeTagsForResource
       (route53/change-tags-for-resource-request
        (clojure.core/nth args11563 0)))))))
  (clojure.core/defn
   change-tags-for-resource-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         remove-tag-keys
                         resource-id
                         custom-query-parameters
                         add-tags
                         read-limit
                         general-progress-listener
                         resource-type
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for changeTagsForResource"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :change-tags-for-resource,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   change-tags-for-resource
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         remove-tag-keys
                         resource-id
                         custom-query-parameters
                         add-tags
                         read-limit
                         general-progress-listener
                         resource-type
                         clone-source
                         clone-root]}]]),
    :doc "Call changeTagsForResource"}
   [credentials11566 & args11567]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11568
     (com.palletops.awaze.common/aws-client :route53 credentials11566)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11568
      changeTagsForResource
      (route53/change-tags-for-resource-request
       (clojure.core/nth args11567 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :get-traffic-policy-instance-count
   [m11569]
   (clojure.core/let
    [credentials11570 (:credentials m11569) args11571 (:args m11569)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11572
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11570)]
     (clojure.core/case
      (clojure.core/count args11571)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11572
        getTrafficPolicyInstanceCount))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11572
        getTrafficPolicyInstanceCount
        (route53/get-traffic-policy-instance-count-request
         (clojure.core/nth args11571 0))))))))
  (clojure.core/defn
   get-traffic-policy-instance-count-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getTrafficPolicyInstanceCount, getTrafficPolicyInstanceCount"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-traffic-policy-instance-count,
     :credentials credentials__1842__auto__,
     :client :route53})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-traffic-policy-instance-count,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   get-traffic-policy-instance-count
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getTrafficPolicyInstanceCount, getTrafficPolicyInstanceCount"}
   [credentials11574 & args11575]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11576
     (com.palletops.awaze.common/aws-client :route53 credentials11574)]
    (clojure.core/case
     (clojure.core/count args11575)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11576
       getTrafficPolicyInstanceCount))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11576
       getTrafficPolicyInstanceCount
       (route53/get-traffic-policy-instance-count-request
        (clojure.core/nth args11575 0))))))))
 (do
  (clojure.core/defmethod
   route53
   :get-health-check-status
   [m11577]
   (clojure.core/let
    [credentials11578 (:credentials m11577) args11579 (:args m11577)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11580
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11578)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11580
       getHealthCheckStatus
       (route53/get-health-check-status-request
        (clojure.core/nth args11579 0)))))))
  (clojure.core/defn
   get-health-check-status-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         health-check-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getHealthCheckStatus"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-health-check-status,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   get-health-check-status
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         health-check-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getHealthCheckStatus"}
   [credentials11582 & args11583]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11584
     (com.palletops.awaze.common/aws-client :route53 credentials11582)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11584
      getHealthCheckStatus
      (route53/get-health-check-status-request
       (clojure.core/nth args11583 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :get-change
   [m11585]
   (clojure.core/let
    [credentials11586 (:credentials m11585) args11587 (:args m11585)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11588
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11586)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11588
       getChange
       (route53/get-change-request (clojure.core/nth args11587 0)))))))
  (clojure.core/defn
   get-change-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getChange"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-change,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   get-change
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getChange"}
   [credentials11590 & args11591]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11592
     (com.palletops.awaze.common/aws-client :route53 credentials11590)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11592
      getChange
      (route53/get-change-request (clojure.core/nth args11591 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-geo-locations
   [m11593]
   (clojure.core/let
    [credentials11594 (:credentials m11593) args11595 (:args m11593)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11596
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11594)]
     (clojure.core/case
      (clojure.core/count args11595)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11596
        listGeoLocations
        (route53/list-geo-locations-request
         (clojure.core/nth args11595 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11596
        listGeoLocations))))))
  (clojure.core/defn
   list-geo-locations-map
   {:arglists (quote
               [[credentials
                 {:keys [start-continent-code
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         start-country-code
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         start-subdivision-code
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listGeoLocations, listGeoLocations"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-geo-locations,
     :credentials credentials__1842__auto__,
     :client :route53})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-geo-locations,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   list-geo-locations
   {:arglists (quote
               [[credentials
                 {:keys [start-continent-code
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         start-country-code
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         start-subdivision-code
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listGeoLocations, listGeoLocations"}
   [credentials11598 & args11599]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11600
     (com.palletops.awaze.common/aws-client :route53 credentials11598)]
    (clojure.core/case
     (clojure.core/count args11599)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11600
       listGeoLocations
       (route53/list-geo-locations-request
        (clojure.core/nth args11599 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11600
       listGeoLocations))))))
 (do
  (clojure.core/defmethod
   route53
   :get-hosted-zone-count
   [m11601]
   (clojure.core/let
    [credentials11602 (:credentials m11601) args11603 (:args m11601)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11604
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11602)]
     (clojure.core/case
      (clojure.core/count args11603)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11604
        getHostedZoneCount))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11604
        getHostedZoneCount
        (route53/get-hosted-zone-count-request
         (clojure.core/nth args11603 0))))))))
  (clojure.core/defn
   get-hosted-zone-count-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getHostedZoneCount, getHostedZoneCount"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-hosted-zone-count,
     :credentials credentials__1842__auto__,
     :client :route53})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-hosted-zone-count,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   get-hosted-zone-count
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getHostedZoneCount, getHostedZoneCount"}
   [credentials11606 & args11607]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11608
     (com.palletops.awaze.common/aws-client :route53 credentials11606)]
    (clojure.core/case
     (clojure.core/count args11607)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11608
       getHostedZoneCount))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11608
       getHostedZoneCount
       (route53/get-hosted-zone-count-request
        (clojure.core/nth args11607 0))))))))
 (do
  (clojure.core/defmethod
   route53
   :update-hosted-zone-comment
   [m11609]
   (clojure.core/let
    [credentials11610 (:credentials m11609) args11611 (:args m11609)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11612
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11610)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11612
       updateHostedZoneComment
       (route53/update-hosted-zone-comment-request
        (clojure.core/nth args11611 0)))))))
  (clojure.core/defn
   update-hosted-zone-comment-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         comment
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateHostedZoneComment"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-hosted-zone-comment,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   update-hosted-zone-comment
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         comment
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateHostedZoneComment"}
   [credentials11614 & args11615]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11616
     (com.palletops.awaze.common/aws-client :route53 credentials11614)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11616
      updateHostedZoneComment
      (route53/update-hosted-zone-comment-request
       (clojure.core/nth args11615 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :get-health-check-count
   [m11617]
   (clojure.core/let
    [credentials11618 (:credentials m11617) args11619 (:args m11617)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11620
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11618)]
     (clojure.core/case
      (clojure.core/count args11619)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11620
        getHealthCheckCount))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11620
        getHealthCheckCount
        (route53/get-health-check-count-request
         (clojure.core/nth args11619 0))))))))
  (clojure.core/defn
   get-health-check-count-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getHealthCheckCount, getHealthCheckCount"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-health-check-count,
     :credentials credentials__1842__auto__,
     :client :route53})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-health-check-count,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   get-health-check-count
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getHealthCheckCount, getHealthCheckCount"}
   [credentials11622 & args11623]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11624
     (com.palletops.awaze.common/aws-client :route53 credentials11622)]
    (clojure.core/case
     (clojure.core/count args11623)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11624
       getHealthCheckCount))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11624
       getHealthCheckCount
       (route53/get-health-check-count-request
        (clojure.core/nth args11623 0))))))))
 (do
  (clojure.core/defmethod
   route53
   :get-hosted-zone
   [m11625]
   (clojure.core/let
    [credentials11626 (:credentials m11625) args11627 (:args m11625)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11628
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11626)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11628
       getHostedZone
       (route53/get-hosted-zone-request
        (clojure.core/nth args11627 0)))))))
  (clojure.core/defn
   get-hosted-zone-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getHostedZone"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-hosted-zone,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   get-hosted-zone
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getHostedZone"}
   [credentials11630 & args11631]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11632
     (com.palletops.awaze.common/aws-client :route53 credentials11630)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11632
      getHostedZone
      (route53/get-hosted-zone-request (clojure.core/nth args11631 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :update-traffic-policy-comment
   [m11633]
   (clojure.core/let
    [credentials11634 (:credentials m11633) args11635 (:args m11633)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11636
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11634)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11636
       updateTrafficPolicyComment
       (route53/update-traffic-policy-comment-request
        (clojure.core/nth args11635 0)))))))
  (clojure.core/defn
   update-traffic-policy-comment-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         comment
                         general-progress-listener
                         clone-source
                         version
                         clone-root]}]]),
    :doc "Generate map for updateTrafficPolicyComment"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-traffic-policy-comment,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   update-traffic-policy-comment
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         comment
                         general-progress-listener
                         clone-source
                         version
                         clone-root]}]]),
    :doc "Call updateTrafficPolicyComment"}
   [credentials11638 & args11639]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11640
     (com.palletops.awaze.common/aws-client :route53 credentials11638)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11640
      updateTrafficPolicyComment
      (route53/update-traffic-policy-comment-request
       (clojure.core/nth args11639 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :get-traffic-policy-instance
   [m11641]
   (clojure.core/let
    [credentials11642 (:credentials m11641) args11643 (:args m11641)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11644
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11642)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11644
       getTrafficPolicyInstance
       (route53/get-traffic-policy-instance-request
        (clojure.core/nth args11643 0)))))))
  (clojure.core/defn
   get-traffic-policy-instance-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getTrafficPolicyInstance"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-traffic-policy-instance,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   get-traffic-policy-instance
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getTrafficPolicyInstance"}
   [credentials11646 & args11647]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11648
     (com.palletops.awaze.common/aws-client :route53 credentials11646)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11648
      getTrafficPolicyInstance
      (route53/get-traffic-policy-instance-request
       (clojure.core/nth args11647 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-hosted-zones-by-name
   [m11649]
   (clojure.core/let
    [credentials11650 (:credentials m11649) args11651 (:args m11649)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11652
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11650)]
     (clojure.core/case
      (clojure.core/count args11651)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11652
        listHostedZonesByName))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11652
        listHostedZonesByName
        (route53/list-hosted-zones-by-name-request
         (clojure.core/nth args11651 0))))))))
  (clojure.core/defn
   list-hosted-zones-by-name-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         dnsname
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Generate map for listHostedZonesByName, listHostedZonesByName"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-hosted-zones-by-name,
     :credentials credentials__1842__auto__,
     :client :route53})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-hosted-zones-by-name,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   list-hosted-zones-by-name
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         dnsname
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Call listHostedZonesByName, listHostedZonesByName"}
   [credentials11654 & args11655]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11656
     (com.palletops.awaze.common/aws-client :route53 credentials11654)]
    (clojure.core/case
     (clojure.core/count args11655)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11656
       listHostedZonesByName))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11656
       listHostedZonesByName
       (route53/list-hosted-zones-by-name-request
        (clojure.core/nth args11655 0))))))))
 (do
  (clojure.core/defmethod
   route53
   :get-geo-location
   [m11657]
   (clojure.core/let
    [credentials11658 (:credentials m11657) args11659 (:args m11657)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11660
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11658)]
     (clojure.core/case
      (clojure.core/count args11659)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11660
        getGeoLocation
        (route53/get-geo-location-request
         (clojure.core/nth args11659 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11660
        getGeoLocation))))))
  (clojure.core/defn
   get-geo-location-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         country-code
                         custom-query-parameters
                         read-limit
                         subdivision-code
                         general-progress-listener
                         clone-source
                         continent-code
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for getGeoLocation, getGeoLocation"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-geo-location,
     :credentials credentials__1842__auto__,
     :client :route53})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-geo-location,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   get-geo-location
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         country-code
                         custom-query-parameters
                         read-limit
                         subdivision-code
                         general-progress-listener
                         clone-source
                         continent-code
                         clone-root]}]
                [credentials]]),
    :doc "Call getGeoLocation, getGeoLocation"}
   [credentials11662 & args11663]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11664
     (com.palletops.awaze.common/aws-client :route53 credentials11662)]
    (clojure.core/case
     (clojure.core/count args11663)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11664
       getGeoLocation
       (route53/get-geo-location-request
        (clojure.core/nth args11663 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11664
       getGeoLocation))))))
 (do
  (clojure.core/defmethod
   route53
   :list-tags-for-resource
   [m11665]
   (clojure.core/let
    [credentials11666 (:credentials m11665) args11667 (:args m11665)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11668
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11666)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11668
       listTagsForResource
       (route53/list-tags-for-resource-request
        (clojure.core/nth args11667 0)))))))
  (clojure.core/defn
   list-tags-for-resource-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         resource-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         resource-type
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listTagsForResource"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-tags-for-resource,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   list-tags-for-resource
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         resource-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         resource-type
                         clone-source
                         clone-root]}]]),
    :doc "Call listTagsForResource"}
   [credentials11670 & args11671]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11672
     (com.palletops.awaze.common/aws-client :route53 credentials11670)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11672
      listTagsForResource
      (route53/list-tags-for-resource-request
       (clojure.core/nth args11671 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :create-reusable-delegation-set
   [m11673]
   (clojure.core/let
    [credentials11674 (:credentials m11673) args11675 (:args m11673)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11676
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11674)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11676
       createReusableDelegationSet
       (route53/create-reusable-delegation-set-request
        (clojure.core/nth args11675 0)))))))
  (clojure.core/defn
   create-reusable-delegation-set-map
   {:arglists (quote
               [[credentials
                 {:keys [caller-reference
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Generate map for createReusableDelegationSet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-reusable-delegation-set,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   create-reusable-delegation-set
   {:arglists (quote
               [[credentials
                 {:keys [caller-reference
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Call createReusableDelegationSet"}
   [credentials11678 & args11679]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11680
     (com.palletops.awaze.common/aws-client :route53 credentials11678)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11680
      createReusableDelegationSet
      (route53/create-reusable-delegation-set-request
       (clojure.core/nth args11679 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-health-checks
   [m11681]
   (clojure.core/let
    [credentials11682 (:credentials m11681) args11683 (:args m11681)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11684
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11682)]
     (clojure.core/case
      (clojure.core/count args11683)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11684
        listHealthChecks
        (route53/list-health-checks-request
         (clojure.core/nth args11683 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11684
        listHealthChecks))))))
  (clojure.core/defn
   list-health-checks-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listHealthChecks, listHealthChecks"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-health-checks,
     :credentials credentials__1842__auto__,
     :client :route53})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-health-checks,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   list-health-checks
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listHealthChecks, listHealthChecks"}
   [credentials11686 & args11687]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11688
     (com.palletops.awaze.common/aws-client :route53 credentials11686)]
    (clojure.core/case
     (clojure.core/count args11687)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11688
       listHealthChecks
       (route53/list-health-checks-request
        (clojure.core/nth args11687 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11688
       listHealthChecks))))))
 (do
  (clojure.core/defmethod
   route53
   :update-traffic-policy-instance
   [m11689]
   (clojure.core/let
    [credentials11690 (:credentials m11689) args11691 (:args m11689)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11692
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11690)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11692
       updateTrafficPolicyInstance
       (route53/update-traffic-policy-instance-request
        (clojure.core/nth args11691 0)))))))
  (clojure.core/defn
   update-traffic-policy-instance-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         traffic-policy-version
                         traffic-policy-id
                         custom-query-parameters
                         ttl
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateTrafficPolicyInstance"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-traffic-policy-instance,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   update-traffic-policy-instance
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         traffic-policy-version
                         traffic-policy-id
                         custom-query-parameters
                         ttl
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateTrafficPolicyInstance"}
   [credentials11694 & args11695]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11696
     (com.palletops.awaze.common/aws-client :route53 credentials11694)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11696
      updateTrafficPolicyInstance
      (route53/update-traffic-policy-instance-request
       (clojure.core/nth args11695 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :delete-health-check
   [m11697]
   (clojure.core/let
    [credentials11698 (:credentials m11697) args11699 (:args m11697)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11700
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11698)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11700
       deleteHealthCheck
       (route53/delete-health-check-request
        (clojure.core/nth args11699 0)))))))
  (clojure.core/defn
   delete-health-check-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         health-check-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteHealthCheck"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-health-check,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   delete-health-check
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         health-check-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteHealthCheck"}
   [credentials11702 & args11703]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11704
     (com.palletops.awaze.common/aws-client :route53 credentials11702)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11704
      deleteHealthCheck
      (route53/delete-health-check-request
       (clojure.core/nth args11703 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :get-traffic-policy
   [m11705]
   (clojure.core/let
    [credentials11706 (:credentials m11705) args11707 (:args m11705)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11708
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11706)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11708
       getTrafficPolicy
       (route53/get-traffic-policy-request
        (clojure.core/nth args11707 0)))))))
  (clojure.core/defn
   get-traffic-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         version
                         clone-root]}]]),
    :doc "Generate map for getTrafficPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-traffic-policy,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   get-traffic-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         version
                         clone-root]}]]),
    :doc "Call getTrafficPolicy"}
   [credentials11710 & args11711]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11712
     (com.palletops.awaze.common/aws-client :route53 credentials11710)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11712
      getTrafficPolicy
      (route53/get-traffic-policy-request
       (clojure.core/nth args11711 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-change-batches-by-rrset
   [m11713]
   (clojure.core/let
    [credentials11714 (:credentials m11713) args11715 (:args m11713)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11716
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11714)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11716
       listChangeBatchesByRRSet
       (route53/list-change-batches-by-rrset-request
        (clojure.core/nth args11715 0)))))))
  (clojure.core/defn
   list-change-batches-by-rrset-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         end-date
                         sdk-request-timeout
                         name
                         marker
                         set-identifier
                         type
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         start-date
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Generate map for listChangeBatchesByRRSet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-change-batches-by-rrset,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   list-change-batches-by-rrset
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         end-date
                         sdk-request-timeout
                         name
                         marker
                         set-identifier
                         type
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         start-date
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Call listChangeBatchesByRRSet"}
   [credentials11718 & args11719]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11720
     (com.palletops.awaze.common/aws-client :route53 credentials11718)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11720
      listChangeBatchesByRRSet
      (route53/list-change-batches-by-rrset-request
       (clojure.core/nth args11719 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-resource-record-sets
   [m11721]
   (clojure.core/let
    [credentials11722 (:credentials m11721) args11723 (:args m11721)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11724
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11722)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11724
       listResourceRecordSets
       (route53/list-resource-record-sets-request
        (clojure.core/nth args11723 0)))))))
  (clojure.core/defn
   list-resource-record-sets-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         max-items
                         start-record-name
                         read-limit
                         general-progress-listener
                         clone-source
                         start-record-identifier
                         clone-root
                         start-record-type
                         hosted-zone-id]}]]),
    :doc "Generate map for listResourceRecordSets"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-resource-record-sets,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   list-resource-record-sets
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         max-items
                         start-record-name
                         read-limit
                         general-progress-listener
                         clone-source
                         start-record-identifier
                         clone-root
                         start-record-type
                         hosted-zone-id]}]]),
    :doc "Call listResourceRecordSets"}
   [credentials11726 & args11727]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11728
     (com.palletops.awaze.common/aws-client :route53 credentials11726)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11728
      listResourceRecordSets
      (route53/list-resource-record-sets-request
       (clojure.core/nth args11727 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :disassociate-vpcfrom-hosted-zone
   [m11729]
   (clojure.core/let
    [credentials11730 (:credentials m11729) args11731 (:args m11729)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11732
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11730)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11732
       disassociateVPCFromHostedZone
       (route53/disassociate-vpcfrom-hosted-zone-request
        (clojure.core/nth args11731 0)))))))
  (clojure.core/defn
   disassociate-vpcfrom-hosted-zone-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         vpc
                         comment
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Generate map for disassociateVPCFromHostedZone"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :disassociate-vpcfrom-hosted-zone,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   disassociate-vpcfrom-hosted-zone
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         vpc
                         comment
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Call disassociateVPCFromHostedZone"}
   [credentials11734 & args11735]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11736
     (com.palletops.awaze.common/aws-client :route53 credentials11734)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11736
      disassociateVPCFromHostedZone
      (route53/disassociate-vpcfrom-hosted-zone-request
       (clojure.core/nth args11735 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-traffic-policy-instances
   [m11737]
   (clojure.core/let
    [credentials11738 (:credentials m11737) args11739 (:args m11737)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11740
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11738)]
     (clojure.core/case
      (clojure.core/count args11739)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11740
        listTrafficPolicyInstances))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11740
        listTrafficPolicyInstances
        (route53/list-traffic-policy-instances-request
         (clojure.core/nth args11739 0))))))))
  (clojure.core/defn
   list-traffic-policy-instances-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         traffic-policy-instance-type-marker
                         hosted-zone-id-marker
                         traffic-policy-instance-name-marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listTrafficPolicyInstances, listTrafficPolicyInstances"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-traffic-policy-instances,
     :credentials credentials__1842__auto__,
     :client :route53})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-traffic-policy-instances,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   list-traffic-policy-instances
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         traffic-policy-instance-type-marker
                         hosted-zone-id-marker
                         traffic-policy-instance-name-marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listTrafficPolicyInstances, listTrafficPolicyInstances"}
   [credentials11742 & args11743]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11744
     (com.palletops.awaze.common/aws-client :route53 credentials11742)]
    (clojure.core/case
     (clojure.core/count args11743)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11744
       listTrafficPolicyInstances))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11744
       listTrafficPolicyInstances
       (route53/list-traffic-policy-instances-request
        (clojure.core/nth args11743 0)))))))))
