(ns
 com.palletops.awaze.redshift
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.redshift :as redshift]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :redshift
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.redshift.AmazonRedshiftClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.ParameterApplyType}
parameter-apply-type
  [m8860]
  (.
   com.amazonaws.services.redshift.model.ParameterApplyType
   fromValue
   (clojure.core/name m8860)))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.Tag}
tag
  [m8863]
  (clojure.core/let
   [bean8862 (new com.amazonaws.services.redshift.model.Tag)]
   (clojure.core/let
    [v8864 (:key m8863 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8864 :com.palletops.awaze.client-builder/undef)
     (. bean8862 setKey (clojure.core/str v8864))))
   (clojure.core/let
    [v8864 (:value m8863 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8864 :com.palletops.awaze.client-builder/undef)
     (. bean8862 setValue (clojure.core/str v8864))))
   bean8862))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.SourceType}
source-type
  [m8866]
  (.
   com.amazonaws.services.redshift.model.SourceType
   fromValue
   (clojure.core/name m8866)))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.Parameter}
parameter
  [m8869]
  (clojure.core/let
   [bean8868 (new com.amazonaws.services.redshift.model.Parameter)]
   (clojure.core/let
    [v8870
     (:description m8869 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8870 :com.palletops.awaze.client-builder/undef)
     (. bean8868 setDescription (clojure.core/str v8870))))
   (clojure.core/let
    [v8870
     (:data-type m8869 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8870 :com.palletops.awaze.client-builder/undef)
     (. bean8868 setDataType (clojure.core/str v8870))))
   (clojure.core/let
    [v8870
     (:parameter-value
      m8869
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8870 :com.palletops.awaze.client-builder/undef)
     (. bean8868 setParameterValue (clojure.core/str v8870))))
   (clojure.core/let
    [v8870
     (:parameter-name m8869 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8870 :com.palletops.awaze.client-builder/undef)
     (. bean8868 setParameterName (clojure.core/str v8870))))
   (clojure.core/let
    [v8870
     (:is-modifiable m8869 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8870 :com.palletops.awaze.client-builder/undef)
     (. bean8868 setIsModifiable (clojure.core/boolean v8870))))
   (clojure.core/let
    [v8870
     (:minimum-engine-version
      m8869
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8870 :com.palletops.awaze.client-builder/undef)
     (. bean8868 setMinimumEngineVersion (clojure.core/str v8870))))
   (clojure.core/let
    [v8870
     (:apply-type m8869 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8870 :com.palletops.awaze.client-builder/undef)
     (. bean8868 setApplyType (redshift/parameter-apply-type v8870))))
   (clojure.core/let
    [v8870
     (:allowed-values m8869 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8870 :com.palletops.awaze.client-builder/undef)
     (. bean8868 setAllowedValues (clojure.core/str v8870))))
   (clojure.core/let
    [v8870 (:source m8869 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8870 :com.palletops.awaze.client-builder/undef)
     (. bean8868 setSource (clojure.core/str v8870))))
   bean8868))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeResizeRequest}
describe-resize-request
  [m8872]
  (clojure.core/let
   [bean8871
    (new com.amazonaws.services.redshift.model.DescribeResizeRequest)]
   (clojure.core/let
    [v8873
     (:cluster-identifier
      m8872
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8873 :com.palletops.awaze.client-builder/undef)
     (. bean8871 setClusterIdentifier (clojure.core/str v8873))))
   bean8871))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeClusterSnapshotsRequest}
describe-cluster-snapshots-request
  [m8875]
  (clojure.core/let
   [bean8874
    (new
     com.amazonaws.services.redshift.model.DescribeClusterSnapshotsRequest)]
   (clojure.core/let
    [v8876
     (:cluster-identifier
      m8875
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8876 :com.palletops.awaze.client-builder/undef)
     (. bean8874 setClusterIdentifier (clojure.core/str v8876))))
   (clojure.core/let
    [v8876
     (:snapshot-type m8875 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8876 :com.palletops.awaze.client-builder/undef)
     (. bean8874 setSnapshotType (clojure.core/str v8876))))
   (clojure.core/let
    [v8876 (:marker m8875 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8876 :com.palletops.awaze.client-builder/undef)
     (. bean8874 setMarker (clojure.core/str v8876))))
   (clojure.core/let
    [v8876
     (:tag-values m8875 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8876 :com.palletops.awaze.client-builder/undef)
     (.
      bean8874
      setTagValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9057] (clojure.core/str arg9057))
 v8876))))
   (clojure.core/let
    [v8876
     (:start-time m8875 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8876 :com.palletops.awaze.client-builder/undef)
     (.
      bean8874
      setStartTime
      (com.palletops.awaze.common/to-date v8876))))
   (clojure.core/let
    [v8876
     (:max-records m8875 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8876 :com.palletops.awaze.client-builder/undef)
     (. bean8874 setMaxRecords (clojure.core/int v8876))))
   (clojure.core/let
    [v8876
     (:end-time m8875 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8876 :com.palletops.awaze.client-builder/undef)
     (.
      bean8874
      setEndTime
      (com.palletops.awaze.common/to-date v8876))))
   (clojure.core/let
    [v8876
     (:snapshot-identifier
      m8875
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8876 :com.palletops.awaze.client-builder/undef)
     (. bean8874 setSnapshotIdentifier (clojure.core/str v8876))))
   (clojure.core/let
    [v8876
     (:owner-account m8875 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8876 :com.palletops.awaze.client-builder/undef)
     (. bean8874 setOwnerAccount (clojure.core/str v8876))))
   (clojure.core/let
    [v8876
     (:tag-keys m8875 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8876 :com.palletops.awaze.client-builder/undef)
     (.
      bean8874
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9058] (clojure.core/str arg9058))
 v8876))))
   bean8874))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeDefaultClusterParametersRequest}
describe-default-cluster-parameters-request
  [m8878]
  (clojure.core/let
   [bean8877
    (new
     com.amazonaws.services.redshift.model.DescribeDefaultClusterParametersRequest)]
   (clojure.core/let
    [v8879
     (:parameter-group-family
      m8878
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8879 :com.palletops.awaze.client-builder/undef)
     (. bean8877 setParameterGroupFamily (clojure.core/str v8879))))
   (clojure.core/let
    [v8879 (:marker m8878 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8879 :com.palletops.awaze.client-builder/undef)
     (. bean8877 setMarker (clojure.core/str v8879))))
   (clojure.core/let
    [v8879
     (:max-records m8878 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8879 :com.palletops.awaze.client-builder/undef)
     (. bean8877 setMaxRecords (clojure.core/int v8879))))
   bean8877))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateHsmClientCertificateRequest}
create-hsm-client-certificate-request
  [m8881]
  (clojure.core/let
   [bean8880
    (new
     com.amazonaws.services.redshift.model.CreateHsmClientCertificateRequest)]
   (clojure.core/let
    [v8882
     (:hsm-client-certificate-identifier
      m8881
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8882 :com.palletops.awaze.client-builder/undef)
     (.
      bean8880
      setHsmClientCertificateIdentifier
      (clojure.core/str v8882))))
   (clojure.core/let
    [v8882 (:tags m8881 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8882 :com.palletops.awaze.client-builder/undef)
     (.
      bean8880
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9059] (redshift/tag arg9059))
 v8882))))
   bean8880))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeClusterVersionsRequest}
describe-cluster-versions-request
  [m8884]
  (clojure.core/let
   [bean8883
    (new
     com.amazonaws.services.redshift.model.DescribeClusterVersionsRequest)]
   (clojure.core/let
    [v8885
     (:cluster-version
      m8884
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8885 :com.palletops.awaze.client-builder/undef)
     (. bean8883 setClusterVersion (clojure.core/str v8885))))
   (clojure.core/let
    [v8885
     (:cluster-parameter-group-family
      m8884
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8885 :com.palletops.awaze.client-builder/undef)
     (.
      bean8883
      setClusterParameterGroupFamily
      (clojure.core/str v8885))))
   (clojure.core/let
    [v8885 (:marker m8884 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8885 :com.palletops.awaze.client-builder/undef)
     (. bean8883 setMarker (clojure.core/str v8885))))
   (clojure.core/let
    [v8885
     (:max-records m8884 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8885 :com.palletops.awaze.client-builder/undef)
     (. bean8883 setMaxRecords (clojure.core/int v8885))))
   bean8883))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.EnableSnapshotCopyRequest}
enable-snapshot-copy-request
  [m8887]
  (clojure.core/let
   [bean8886
    (new
     com.amazonaws.services.redshift.model.EnableSnapshotCopyRequest)]
   (clojure.core/let
    [v8888
     (:cluster-identifier
      m8887
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8888 :com.palletops.awaze.client-builder/undef)
     (. bean8886 setClusterIdentifier (clojure.core/str v8888))))
   (clojure.core/let
    [v8888
     (:snapshot-copy-grant-name
      m8887
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8888 :com.palletops.awaze.client-builder/undef)
     (. bean8886 setSnapshotCopyGrantName (clojure.core/str v8888))))
   (clojure.core/let
    [v8888
     (:retention-period
      m8887
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8888 :com.palletops.awaze.client-builder/undef)
     (. bean8886 setRetentionPeriod (clojure.core/int v8888))))
   (clojure.core/let
    [v8888
     (:destination-region
      m8887
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8888 :com.palletops.awaze.client-builder/undef)
     (. bean8886 setDestinationRegion (clojure.core/str v8888))))
   bean8886))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateSnapshotCopyGrantRequest}
create-snapshot-copy-grant-request
  [m8890]
  (clojure.core/let
   [bean8889
    (new
     com.amazonaws.services.redshift.model.CreateSnapshotCopyGrantRequest)]
   (clojure.core/let
    [v8891
     (:snapshot-copy-grant-name
      m8890
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8891 :com.palletops.awaze.client-builder/undef)
     (. bean8889 setSnapshotCopyGrantName (clojure.core/str v8891))))
   (clojure.core/let
    [v8891
     (:kms-key-id m8890 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8891 :com.palletops.awaze.client-builder/undef)
     (. bean8889 setKmsKeyId (clojure.core/str v8891))))
   (clojure.core/let
    [v8891 (:tags m8890 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8891 :com.palletops.awaze.client-builder/undef)
     (.
      bean8889
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9060] (redshift/tag arg9060))
 v8891))))
   bean8889))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeClusterParameterGroupsRequest}
describe-cluster-parameter-groups-request
  [m8893]
  (clojure.core/let
   [bean8892
    (new
     com.amazonaws.services.redshift.model.DescribeClusterParameterGroupsRequest)]
   (clojure.core/let
    [v8894
     (:parameter-group-name
      m8893
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8894 :com.palletops.awaze.client-builder/undef)
     (. bean8892 setParameterGroupName (clojure.core/str v8894))))
   (clojure.core/let
    [v8894
     (:tag-values m8893 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8894 :com.palletops.awaze.client-builder/undef)
     (.
      bean8892
      setTagValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9061] (clojure.core/str arg9061))
 v8894))))
   (clojure.core/let
    [v8894 (:marker m8893 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8894 :com.palletops.awaze.client-builder/undef)
     (. bean8892 setMarker (clojure.core/str v8894))))
   (clojure.core/let
    [v8894
     (:max-records m8893 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8894 :com.palletops.awaze.client-builder/undef)
     (. bean8892 setMaxRecords (clojure.core/int v8894))))
   (clojure.core/let
    [v8894
     (:tag-keys m8893 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8894 :com.palletops.awaze.client-builder/undef)
     (.
      bean8892
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9062] (clojure.core/str arg9062))
 v8894))))
   bean8892))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteClusterParameterGroupRequest}
delete-cluster-parameter-group-request
  [m8896]
  (clojure.core/let
   [bean8895
    (new
     com.amazonaws.services.redshift.model.DeleteClusterParameterGroupRequest)]
   (clojure.core/let
    [v8897
     (:parameter-group-name
      m8896
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8897 :com.palletops.awaze.client-builder/undef)
     (. bean8895 setParameterGroupName (clojure.core/str v8897))))
   bean8895))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeEventsRequest}
describe-events-request
  [m8899]
  (clojure.core/let
   [bean8898
    (new com.amazonaws.services.redshift.model.DescribeEventsRequest)]
   (clojure.core/let
    [v8900
     (:source-identifier
      m8899
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8900 :com.palletops.awaze.client-builder/undef)
     (. bean8898 setSourceIdentifier (clojure.core/str v8900))))
   (clojure.core/let
    [v8900
     (:source-type m8899 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8900 :com.palletops.awaze.client-builder/undef)
     (. bean8898 setSourceType (redshift/source-type v8900))))
   (clojure.core/let
    [v8900
     (:duration m8899 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8900 :com.palletops.awaze.client-builder/undef)
     (. bean8898 setDuration (clojure.core/int v8900))))
   (clojure.core/let
    [v8900
     (:start-time m8899 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8900 :com.palletops.awaze.client-builder/undef)
     (.
      bean8898
      setStartTime
      (com.palletops.awaze.common/to-date v8900))))
   (clojure.core/let
    [v8900
     (:end-time m8899 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8900 :com.palletops.awaze.client-builder/undef)
     (.
      bean8898
      setEndTime
      (com.palletops.awaze.common/to-date v8900))))
   (clojure.core/let
    [v8900 (:marker m8899 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8900 :com.palletops.awaze.client-builder/undef)
     (. bean8898 setMarker (clojure.core/str v8900))))
   (clojure.core/let
    [v8900
     (:max-records m8899 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8900 :com.palletops.awaze.client-builder/undef)
     (. bean8898 setMaxRecords (clojure.core/int v8900))))
   bean8898))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeReservedNodesRequest}
describe-reserved-nodes-request
  [m8902]
  (clojure.core/let
   [bean8901
    (new
     com.amazonaws.services.redshift.model.DescribeReservedNodesRequest)]
   (clojure.core/let
    [v8903
     (:reserved-node-id
      m8902
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8903 :com.palletops.awaze.client-builder/undef)
     (. bean8901 setReservedNodeId (clojure.core/str v8903))))
   (clojure.core/let
    [v8903 (:marker m8902 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8903 :com.palletops.awaze.client-builder/undef)
     (. bean8901 setMarker (clojure.core/str v8903))))
   (clojure.core/let
    [v8903
     (:max-records m8902 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8903 :com.palletops.awaze.client-builder/undef)
     (. bean8901 setMaxRecords (clojure.core/int v8903))))
   bean8901))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.ModifyClusterIamRolesRequest}
modify-cluster-iam-roles-request
  [m8905]
  (clojure.core/let
   [bean8904
    (new
     com.amazonaws.services.redshift.model.ModifyClusterIamRolesRequest)]
   (clojure.core/let
    [v8906
     (:cluster-identifier
      m8905
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8906 :com.palletops.awaze.client-builder/undef)
     (. bean8904 setClusterIdentifier (clojure.core/str v8906))))
   (clojure.core/let
    [v8906
     (:add-iam-roles m8905 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8906 :com.palletops.awaze.client-builder/undef)
     (.
      bean8904
      setAddIamRoles
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9063] (clojure.core/str arg9063))
 v8906))))
   (clojure.core/let
    [v8906
     (:remove-iam-roles
      m8905
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8906 :com.palletops.awaze.client-builder/undef)
     (.
      bean8904
      setRemoveIamRoles
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9064] (clojure.core/str arg9064))
 v8906))))
   bean8904))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteEventSubscriptionRequest}
delete-event-subscription-request
  [m8908]
  (clojure.core/let
   [bean8907
    (new
     com.amazonaws.services.redshift.model.DeleteEventSubscriptionRequest)]
   (clojure.core/let
    [v8909
     (:subscription-name
      m8908
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8909 :com.palletops.awaze.client-builder/undef)
     (. bean8907 setSubscriptionName (clojure.core/str v8909))))
   bean8907))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.RebootClusterRequest}
reboot-cluster-request
  [m8911]
  (clojure.core/let
   [bean8910
    (new com.amazonaws.services.redshift.model.RebootClusterRequest)]
   (clojure.core/let
    [v8912
     (:cluster-identifier
      m8911
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8912 :com.palletops.awaze.client-builder/undef)
     (. bean8910 setClusterIdentifier (clojure.core/str v8912))))
   bean8910))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateClusterSecurityGroupRequest}
create-cluster-security-group-request
  [m8914]
  (clojure.core/let
   [bean8913
    (new
     com.amazonaws.services.redshift.model.CreateClusterSecurityGroupRequest)]
   (clojure.core/let
    [v8915
     (:cluster-security-group-name
      m8914
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8915 :com.palletops.awaze.client-builder/undef)
     (. bean8913 setClusterSecurityGroupName (clojure.core/str v8915))))
   (clojure.core/let
    [v8915
     (:description m8914 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8915 :com.palletops.awaze.client-builder/undef)
     (. bean8913 setDescription (clojure.core/str v8915))))
   (clojure.core/let
    [v8915 (:tags m8914 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8915 :com.palletops.awaze.client-builder/undef)
     (.
      bean8913
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9065] (redshift/tag arg9065))
 v8915))))
   bean8913))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.ModifyClusterParameterGroupRequest}
modify-cluster-parameter-group-request
  [m8917]
  (clojure.core/let
   [bean8916
    (new
     com.amazonaws.services.redshift.model.ModifyClusterParameterGroupRequest)]
   (clojure.core/let
    [v8918
     (:parameter-group-name
      m8917
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8918 :com.palletops.awaze.client-builder/undef)
     (. bean8916 setParameterGroupName (clojure.core/str v8918))))
   (clojure.core/let
    [v8918
     (:parameters m8917 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8918 :com.palletops.awaze.client-builder/undef)
     (.
      bean8916
      setParameters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9066] (redshift/parameter arg9066))
 v8918))))
   bean8916))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.ModifySnapshotCopyRetentionPeriodRequest}
modify-snapshot-copy-retention-period-request
  [m8920]
  (clojure.core/let
   [bean8919
    (new
     com.amazonaws.services.redshift.model.ModifySnapshotCopyRetentionPeriodRequest)]
   (clojure.core/let
    [v8921
     (:cluster-identifier
      m8920
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8921 :com.palletops.awaze.client-builder/undef)
     (. bean8919 setClusterIdentifier (clojure.core/str v8921))))
   (clojure.core/let
    [v8921
     (:retention-period
      m8920
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8921 :com.palletops.awaze.client-builder/undef)
     (. bean8919 setRetentionPeriod (clojure.core/int v8921))))
   bean8919))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteSnapshotCopyGrantRequest}
delete-snapshot-copy-grant-request
  [m8923]
  (clojure.core/let
   [bean8922
    (new
     com.amazonaws.services.redshift.model.DeleteSnapshotCopyGrantRequest)]
   (clojure.core/let
    [v8924
     (:snapshot-copy-grant-name
      m8923
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8924 :com.palletops.awaze.client-builder/undef)
     (. bean8922 setSnapshotCopyGrantName (clojure.core/str v8924))))
   bean8922))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.AuthorizeSnapshotAccessRequest}
authorize-snapshot-access-request
  [m8926]
  (clojure.core/let
   [bean8925
    (new
     com.amazonaws.services.redshift.model.AuthorizeSnapshotAccessRequest)]
   (clojure.core/let
    [v8927
     (:snapshot-identifier
      m8926
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8927 :com.palletops.awaze.client-builder/undef)
     (. bean8925 setSnapshotIdentifier (clojure.core/str v8927))))
   (clojure.core/let
    [v8927
     (:snapshot-cluster-identifier
      m8926
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8927 :com.palletops.awaze.client-builder/undef)
     (.
      bean8925
      setSnapshotClusterIdentifier
      (clojure.core/str v8927))))
   (clojure.core/let
    [v8927
     (:account-with-restore-access
      m8926
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8927 :com.palletops.awaze.client-builder/undef)
     (. bean8925 setAccountWithRestoreAccess (clojure.core/str v8927))))
   bean8925))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DisableLoggingRequest}
disable-logging-request
  [m8929]
  (clojure.core/let
   [bean8928
    (new com.amazonaws.services.redshift.model.DisableLoggingRequest)]
   (clojure.core/let
    [v8930
     (:cluster-identifier
      m8929
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8930 :com.palletops.awaze.client-builder/undef)
     (. bean8928 setClusterIdentifier (clojure.core/str v8930))))
   bean8928))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.ModifyClusterSubnetGroupRequest}
modify-cluster-subnet-group-request
  [m8932]
  (clojure.core/let
   [bean8931
    (new
     com.amazonaws.services.redshift.model.ModifyClusterSubnetGroupRequest)]
   (clojure.core/let
    [v8933
     (:cluster-subnet-group-name
      m8932
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8933 :com.palletops.awaze.client-builder/undef)
     (. bean8931 setClusterSubnetGroupName (clojure.core/str v8933))))
   (clojure.core/let
    [v8933
     (:description m8932 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8933 :com.palletops.awaze.client-builder/undef)
     (. bean8931 setDescription (clojure.core/str v8933))))
   (clojure.core/let
    [v8933
     (:subnet-ids m8932 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8933 :com.palletops.awaze.client-builder/undef)
     (.
      bean8931
      setSubnetIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9067] (clojure.core/str arg9067))
 v8933))))
   bean8931))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.ModifyClusterRequest}
modify-cluster-request
  [m8935]
  (clojure.core/let
   [bean8934
    (new com.amazonaws.services.redshift.model.ModifyClusterRequest)]
   (clojure.core/let
    [v8936
     (:cluster-version
      m8935
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8936 :com.palletops.awaze.client-builder/undef)
     (. bean8934 setClusterVersion (clojure.core/str v8936))))
   (clojure.core/let
    [v8936
     (:cluster-type m8935 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8936 :com.palletops.awaze.client-builder/undef)
     (. bean8934 setClusterType (clojure.core/str v8936))))
   (clojure.core/let
    [v8936
     (:cluster-identifier
      m8935
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8936 :com.palletops.awaze.client-builder/undef)
     (. bean8934 setClusterIdentifier (clojure.core/str v8936))))
   (clojure.core/let
    [v8936
     (:elastic-ip m8935 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8936 :com.palletops.awaze.client-builder/undef)
     (. bean8934 setElasticIp (clojure.core/str v8936))))
   (clojure.core/let
    [v8936
     (:allow-version-upgrade
      m8935
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8936 :com.palletops.awaze.client-builder/undef)
     (. bean8934 setAllowVersionUpgrade (clojure.core/boolean v8936))))
   (clojure.core/let
    [v8936
     (:hsm-client-certificate-identifier
      m8935
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8936 :com.palletops.awaze.client-builder/undef)
     (.
      bean8934
      setHsmClientCertificateIdentifier
      (clojure.core/str v8936))))
   (clojure.core/let
    [v8936
     (:new-cluster-identifier
      m8935
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8936 :com.palletops.awaze.client-builder/undef)
     (. bean8934 setNewClusterIdentifier (clojure.core/str v8936))))
   (clojure.core/let
    [v8936
     (:automated-snapshot-retention-period
      m8935
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8936 :com.palletops.awaze.client-builder/undef)
     (.
      bean8934
      setAutomatedSnapshotRetentionPeriod
      (clojure.core/int v8936))))
   (clojure.core/let
    [v8936
     (:master-user-password
      m8935
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8936 :com.palletops.awaze.client-builder/undef)
     (. bean8934 setMasterUserPassword (clojure.core/str v8936))))
   (clojure.core/let
    [v8936
     (:publicly-accessible
      m8935
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8936 :com.palletops.awaze.client-builder/undef)
     (. bean8934 setPubliclyAccessible (clojure.core/boolean v8936))))
   (clojure.core/let
    [v8936
     (:preferred-maintenance-window
      m8935
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8936 :com.palletops.awaze.client-builder/undef)
     (.
      bean8934
      setPreferredMaintenanceWindow
      (clojure.core/str v8936))))
   (clojure.core/let
    [v8936
     (:node-type m8935 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8936 :com.palletops.awaze.client-builder/undef)
     (. bean8934 setNodeType (clojure.core/str v8936))))
   (clojure.core/let
    [v8936
     (:hsm-configuration-identifier
      m8935
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8936 :com.palletops.awaze.client-builder/undef)
     (.
      bean8934
      setHsmConfigurationIdentifier
      (clojure.core/str v8936))))
   (clojure.core/let
    [v8936
     (:cluster-security-groups
      m8935
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8936 :com.palletops.awaze.client-builder/undef)
     (.
      bean8934
      setClusterSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9068] (clojure.core/str arg9068))
 v8936))))
   (clojure.core/let
    [v8936
     (:vpc-security-group-ids
      m8935
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8936 :com.palletops.awaze.client-builder/undef)
     (.
      bean8934
      setVpcSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9069] (clojure.core/str arg9069))
 v8936))))
   (clojure.core/let
    [v8936
     (:cluster-parameter-group-name
      m8935
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8936 :com.palletops.awaze.client-builder/undef)
     (.
      bean8934
      setClusterParameterGroupName
      (clojure.core/str v8936))))
   (clojure.core/let
    [v8936
     (:number-of-nodes
      m8935
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8936 :com.palletops.awaze.client-builder/undef)
     (. bean8934 setNumberOfNodes (clojure.core/int v8936))))
   bean8934))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.RestoreFromClusterSnapshotRequest}
restore-from-cluster-snapshot-request
  [m8938]
  (clojure.core/let
   [bean8937
    (new
     com.amazonaws.services.redshift.model.RestoreFromClusterSnapshotRequest)]
   (clojure.core/let
    [v8939
     (:cluster-subnet-group-name
      m8938
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8939 :com.palletops.awaze.client-builder/undef)
     (. bean8937 setClusterSubnetGroupName (clojure.core/str v8939))))
   (clojure.core/let
    [v8939
     (:cluster-identifier
      m8938
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8939 :com.palletops.awaze.client-builder/undef)
     (. bean8937 setClusterIdentifier (clojure.core/str v8939))))
   (clojure.core/let
    [v8939
     (:elastic-ip m8938 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8939 :com.palletops.awaze.client-builder/undef)
     (. bean8937 setElasticIp (clojure.core/str v8939))))
   (clojure.core/let
    [v8939
     (:allow-version-upgrade
      m8938
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8939 :com.palletops.awaze.client-builder/undef)
     (. bean8937 setAllowVersionUpgrade (clojure.core/boolean v8939))))
   (clojure.core/let
    [v8939
     (:additional-info
      m8938
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8939 :com.palletops.awaze.client-builder/undef)
     (. bean8937 setAdditionalInfo (clojure.core/str v8939))))
   (clojure.core/let
    [v8939
     (:hsm-client-certificate-identifier
      m8938
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8939 :com.palletops.awaze.client-builder/undef)
     (.
      bean8937
      setHsmClientCertificateIdentifier
      (clojure.core/str v8939))))
   (clojure.core/let
    [v8939
     (:availability-zone
      m8938
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8939 :com.palletops.awaze.client-builder/undef)
     (. bean8937 setAvailabilityZone (clojure.core/str v8939))))
   (clojure.core/let
    [v8939
     (:automated-snapshot-retention-period
      m8938
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8939 :com.palletops.awaze.client-builder/undef)
     (.
      bean8937
      setAutomatedSnapshotRetentionPeriod
      (clojure.core/int v8939))))
   (clojure.core/let
    [v8939
     (:publicly-accessible
      m8938
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8939 :com.palletops.awaze.client-builder/undef)
     (. bean8937 setPubliclyAccessible (clojure.core/boolean v8939))))
   (clojure.core/let
    [v8939
     (:preferred-maintenance-window
      m8938
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8939 :com.palletops.awaze.client-builder/undef)
     (.
      bean8937
      setPreferredMaintenanceWindow
      (clojure.core/str v8939))))
   (clojure.core/let
    [v8939
     (:snapshot-cluster-identifier
      m8938
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8939 :com.palletops.awaze.client-builder/undef)
     (.
      bean8937
      setSnapshotClusterIdentifier
      (clojure.core/str v8939))))
   (clojure.core/let
    [v8939
     (:iam-roles m8938 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8939 :com.palletops.awaze.client-builder/undef)
     (.
      bean8937
      setIamRoles
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9070] (clojure.core/str arg9070))
 v8939))))
   (clojure.core/let
    [v8939 (:port m8938 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8939 :com.palletops.awaze.client-builder/undef)
     (. bean8937 setPort (clojure.core/int v8939))))
   (clojure.core/let
    [v8939
     (:node-type m8938 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8939 :com.palletops.awaze.client-builder/undef)
     (. bean8937 setNodeType (clojure.core/str v8939))))
   (clojure.core/let
    [v8939
     (:hsm-configuration-identifier
      m8938
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8939 :com.palletops.awaze.client-builder/undef)
     (.
      bean8937
      setHsmConfigurationIdentifier
      (clojure.core/str v8939))))
   (clojure.core/let
    [v8939
     (:cluster-security-groups
      m8938
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8939 :com.palletops.awaze.client-builder/undef)
     (.
      bean8937
      setClusterSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9071] (clojure.core/str arg9071))
 v8939))))
   (clojure.core/let
    [v8939
     (:snapshot-identifier
      m8938
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8939 :com.palletops.awaze.client-builder/undef)
     (. bean8937 setSnapshotIdentifier (clojure.core/str v8939))))
   (clojure.core/let
    [v8939
     (:owner-account m8938 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8939 :com.palletops.awaze.client-builder/undef)
     (. bean8937 setOwnerAccount (clojure.core/str v8939))))
   (clojure.core/let
    [v8939
     (:vpc-security-group-ids
      m8938
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8939 :com.palletops.awaze.client-builder/undef)
     (.
      bean8937
      setVpcSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9072] (clojure.core/str arg9072))
 v8939))))
   (clojure.core/let
    [v8939
     (:cluster-parameter-group-name
      m8938
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8939 :com.palletops.awaze.client-builder/undef)
     (.
      bean8937
      setClusterParameterGroupName
      (clojure.core/str v8939))))
   (clojure.core/let
    [v8939
     (:kms-key-id m8938 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8939 :com.palletops.awaze.client-builder/undef)
     (. bean8937 setKmsKeyId (clojure.core/str v8939))))
   bean8937))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteHsmClientCertificateRequest}
delete-hsm-client-certificate-request
  [m8941]
  (clojure.core/let
   [bean8940
    (new
     com.amazonaws.services.redshift.model.DeleteHsmClientCertificateRequest)]
   (clojure.core/let
    [v8942
     (:hsm-client-certificate-identifier
      m8941
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8942 :com.palletops.awaze.client-builder/undef)
     (.
      bean8940
      setHsmClientCertificateIdentifier
      (clojure.core/str v8942))))
   bean8940))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateClusterRequest}
create-cluster-request
  [m8944]
  (clojure.core/let
   [bean8943
    (new com.amazonaws.services.redshift.model.CreateClusterRequest)]
   (clojure.core/let
    [v8945
     (:cluster-version
      m8944
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8945 :com.palletops.awaze.client-builder/undef)
     (. bean8943 setClusterVersion (clojure.core/str v8945))))
   (clojure.core/let
    [v8945
     (:cluster-type m8944 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8945 :com.palletops.awaze.client-builder/undef)
     (. bean8943 setClusterType (clojure.core/str v8945))))
   (clojure.core/let
    [v8945
     (:cluster-subnet-group-name
      m8944
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8945 :com.palletops.awaze.client-builder/undef)
     (. bean8943 setClusterSubnetGroupName (clojure.core/str v8945))))
   (clojure.core/let
    [v8945
     (:cluster-identifier
      m8944
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8945 :com.palletops.awaze.client-builder/undef)
     (. bean8943 setClusterIdentifier (clojure.core/str v8945))))
   (clojure.core/let
    [v8945
     (:elastic-ip m8944 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8945 :com.palletops.awaze.client-builder/undef)
     (. bean8943 setElasticIp (clojure.core/str v8945))))
   (clojure.core/let
    [v8945
     (:allow-version-upgrade
      m8944
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8945 :com.palletops.awaze.client-builder/undef)
     (. bean8943 setAllowVersionUpgrade (clojure.core/boolean v8945))))
   (clojure.core/let
    [v8945
     (:additional-info
      m8944
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8945 :com.palletops.awaze.client-builder/undef)
     (. bean8943 setAdditionalInfo (clojure.core/str v8945))))
   (clojure.core/let
    [v8945
     (:hsm-client-certificate-identifier
      m8944
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8945 :com.palletops.awaze.client-builder/undef)
     (.
      bean8943
      setHsmClientCertificateIdentifier
      (clojure.core/str v8945))))
   (clojure.core/let
    [v8945
     (:availability-zone
      m8944
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8945 :com.palletops.awaze.client-builder/undef)
     (. bean8943 setAvailabilityZone (clojure.core/str v8945))))
   (clojure.core/let
    [v8945
     (:automated-snapshot-retention-period
      m8944
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8945 :com.palletops.awaze.client-builder/undef)
     (.
      bean8943
      setAutomatedSnapshotRetentionPeriod
      (clojure.core/int v8945))))
   (clojure.core/let
    [v8945
     (:master-user-password
      m8944
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8945 :com.palletops.awaze.client-builder/undef)
     (. bean8943 setMasterUserPassword (clojure.core/str v8945))))
   (clojure.core/let
    [v8945
     (:publicly-accessible
      m8944
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8945 :com.palletops.awaze.client-builder/undef)
     (. bean8943 setPubliclyAccessible (clojure.core/boolean v8945))))
   (clojure.core/let
    [v8945
     (:preferred-maintenance-window
      m8944
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8945 :com.palletops.awaze.client-builder/undef)
     (.
      bean8943
      setPreferredMaintenanceWindow
      (clojure.core/str v8945))))
   (clojure.core/let
    [v8945
     (:iam-roles m8944 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8945 :com.palletops.awaze.client-builder/undef)
     (.
      bean8943
      setIamRoles
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9073] (clojure.core/str arg9073))
 v8945))))
   (clojure.core/let
    [v8945 (:port m8944 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8945 :com.palletops.awaze.client-builder/undef)
     (. bean8943 setPort (clojure.core/int v8945))))
   (clojure.core/let
    [v8945 (:tags m8944 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8945 :com.palletops.awaze.client-builder/undef)
     (.
      bean8943
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9074] (redshift/tag arg9074))
 v8945))))
   (clojure.core/let
    [v8945
     (:node-type m8944 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8945 :com.palletops.awaze.client-builder/undef)
     (. bean8943 setNodeType (clojure.core/str v8945))))
   (clojure.core/let
    [v8945
     (:hsm-configuration-identifier
      m8944
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8945 :com.palletops.awaze.client-builder/undef)
     (.
      bean8943
      setHsmConfigurationIdentifier
      (clojure.core/str v8945))))
   (clojure.core/let
    [v8945
     (:cluster-security-groups
      m8944
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8945 :com.palletops.awaze.client-builder/undef)
     (.
      bean8943
      setClusterSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9075] (clojure.core/str arg9075))
 v8945))))
   (clojure.core/let
    [v8945
     (:vpc-security-group-ids
      m8944
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8945 :com.palletops.awaze.client-builder/undef)
     (.
      bean8943
      setVpcSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9076] (clojure.core/str arg9076))
 v8945))))
   (clojure.core/let
    [v8945
     (:cluster-parameter-group-name
      m8944
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8945 :com.palletops.awaze.client-builder/undef)
     (.
      bean8943
      setClusterParameterGroupName
      (clojure.core/str v8945))))
   (clojure.core/let
    [v8945
     (:master-username
      m8944
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8945 :com.palletops.awaze.client-builder/undef)
     (. bean8943 setMasterUsername (clojure.core/str v8945))))
   (clojure.core/let
    [v8945 (:dbname m8944 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8945 :com.palletops.awaze.client-builder/undef)
     (. bean8943 setDBName (clojure.core/str v8945))))
   (clojure.core/let
    [v8945
     (:kms-key-id m8944 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8945 :com.palletops.awaze.client-builder/undef)
     (. bean8943 setKmsKeyId (clojure.core/str v8945))))
   (clojure.core/let
    [v8945
     (:encrypted m8944 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8945 :com.palletops.awaze.client-builder/undef)
     (. bean8943 setEncrypted (clojure.core/boolean v8945))))
   (clojure.core/let
    [v8945
     (:number-of-nodes
      m8944
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8945 :com.palletops.awaze.client-builder/undef)
     (. bean8943 setNumberOfNodes (clojure.core/int v8945))))
   bean8943))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeLoggingStatusRequest}
describe-logging-status-request
  [m8947]
  (clojure.core/let
   [bean8946
    (new
     com.amazonaws.services.redshift.model.DescribeLoggingStatusRequest)]
   (clojure.core/let
    [v8948
     (:cluster-identifier
      m8947
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8948 :com.palletops.awaze.client-builder/undef)
     (. bean8946 setClusterIdentifier (clojure.core/str v8948))))
   bean8946))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeTableRestoreStatusRequest}
describe-table-restore-status-request
  [m8950]
  (clojure.core/let
   [bean8949
    (new
     com.amazonaws.services.redshift.model.DescribeTableRestoreStatusRequest)]
   (clojure.core/let
    [v8951
     (:cluster-identifier
      m8950
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8951 :com.palletops.awaze.client-builder/undef)
     (. bean8949 setClusterIdentifier (clojure.core/str v8951))))
   (clojure.core/let
    [v8951
     (:table-restore-request-id
      m8950
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8951 :com.palletops.awaze.client-builder/undef)
     (. bean8949 setTableRestoreRequestId (clojure.core/str v8951))))
   (clojure.core/let
    [v8951 (:marker m8950 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8951 :com.palletops.awaze.client-builder/undef)
     (. bean8949 setMarker (clojure.core/str v8951))))
   (clojure.core/let
    [v8951
     (:max-records m8950 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8951 :com.palletops.awaze.client-builder/undef)
     (. bean8949 setMaxRecords (clojure.core/int v8951))))
   bean8949))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeEventCategoriesRequest}
describe-event-categories-request
  [m8953]
  (clojure.core/let
   [bean8952
    (new
     com.amazonaws.services.redshift.model.DescribeEventCategoriesRequest)]
   (clojure.core/let
    [v8954
     (:source-type m8953 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8954 :com.palletops.awaze.client-builder/undef)
     (. bean8952 setSourceType (clojure.core/str v8954))))
   bean8952))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeClusterParametersRequest}
describe-cluster-parameters-request
  [m8956]
  (clojure.core/let
   [bean8955
    (new
     com.amazonaws.services.redshift.model.DescribeClusterParametersRequest)]
   (clojure.core/let
    [v8957 (:source m8956 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8957 :com.palletops.awaze.client-builder/undef)
     (. bean8955 setSource (clojure.core/str v8957))))
   (clojure.core/let
    [v8957
     (:parameter-group-name
      m8956
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8957 :com.palletops.awaze.client-builder/undef)
     (. bean8955 setParameterGroupName (clojure.core/str v8957))))
   (clojure.core/let
    [v8957 (:marker m8956 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8957 :com.palletops.awaze.client-builder/undef)
     (. bean8955 setMarker (clojure.core/str v8957))))
   (clojure.core/let
    [v8957
     (:max-records m8956 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8957 :com.palletops.awaze.client-builder/undef)
     (. bean8955 setMaxRecords (clojure.core/int v8957))))
   bean8955))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.AuthorizeClusterSecurityGroupIngressRequest}
authorize-cluster-security-group-ingress-request
  [m8959]
  (clojure.core/let
   [bean8958
    (new
     com.amazonaws.services.redshift.model.AuthorizeClusterSecurityGroupIngressRequest)]
   (clojure.core/let
    [v8960
     (:cluster-security-group-name
      m8959
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8960 :com.palletops.awaze.client-builder/undef)
     (. bean8958 setClusterSecurityGroupName (clojure.core/str v8960))))
   (clojure.core/let
    [v8960 (:cidrip m8959 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8960 :com.palletops.awaze.client-builder/undef)
     (. bean8958 setCIDRIP (clojure.core/str v8960))))
   (clojure.core/let
    [v8960
     (:ec2security-group-name
      m8959
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8960 :com.palletops.awaze.client-builder/undef)
     (. bean8958 setEC2SecurityGroupName (clojure.core/str v8960))))
   (clojure.core/let
    [v8960
     (:ec2security-group-owner-id
      m8959
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8960 :com.palletops.awaze.client-builder/undef)
     (. bean8958 setEC2SecurityGroupOwnerId (clojure.core/str v8960))))
   bean8958))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeClustersRequest}
describe-clusters-request
  [m8962]
  (clojure.core/let
   [bean8961
    (new
     com.amazonaws.services.redshift.model.DescribeClustersRequest)]
   (clojure.core/let
    [v8963
     (:cluster-identifier
      m8962
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8963 :com.palletops.awaze.client-builder/undef)
     (. bean8961 setClusterIdentifier (clojure.core/str v8963))))
   (clojure.core/let
    [v8963
     (:tag-values m8962 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8963 :com.palletops.awaze.client-builder/undef)
     (.
      bean8961
      setTagValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9077] (clojure.core/str arg9077))
 v8963))))
   (clojure.core/let
    [v8963 (:marker m8962 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8963 :com.palletops.awaze.client-builder/undef)
     (. bean8961 setMarker (clojure.core/str v8963))))
   (clojure.core/let
    [v8963
     (:max-records m8962 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8963 :com.palletops.awaze.client-builder/undef)
     (. bean8961 setMaxRecords (clojure.core/int v8963))))
   (clojure.core/let
    [v8963
     (:tag-keys m8962 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8963 :com.palletops.awaze.client-builder/undef)
     (.
      bean8961
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9078] (clojure.core/str arg9078))
 v8963))))
   bean8961))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteClusterSubnetGroupRequest}
delete-cluster-subnet-group-request
  [m8965]
  (clojure.core/let
   [bean8964
    (new
     com.amazonaws.services.redshift.model.DeleteClusterSubnetGroupRequest)]
   (clojure.core/let
    [v8966
     (:cluster-subnet-group-name
      m8965
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8966 :com.palletops.awaze.client-builder/undef)
     (. bean8964 setClusterSubnetGroupName (clojure.core/str v8966))))
   bean8964))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeClusterSecurityGroupsRequest}
describe-cluster-security-groups-request
  [m8968]
  (clojure.core/let
   [bean8967
    (new
     com.amazonaws.services.redshift.model.DescribeClusterSecurityGroupsRequest)]
   (clojure.core/let
    [v8969
     (:cluster-security-group-name
      m8968
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8969 :com.palletops.awaze.client-builder/undef)
     (. bean8967 setClusterSecurityGroupName (clojure.core/str v8969))))
   (clojure.core/let
    [v8969
     (:tag-values m8968 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8969 :com.palletops.awaze.client-builder/undef)
     (.
      bean8967
      setTagValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9079] (clojure.core/str arg9079))
 v8969))))
   (clojure.core/let
    [v8969 (:marker m8968 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8969 :com.palletops.awaze.client-builder/undef)
     (. bean8967 setMarker (clojure.core/str v8969))))
   (clojure.core/let
    [v8969
     (:max-records m8968 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8969 :com.palletops.awaze.client-builder/undef)
     (. bean8967 setMaxRecords (clojure.core/int v8969))))
   (clojure.core/let
    [v8969
     (:tag-keys m8968 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8969 :com.palletops.awaze.client-builder/undef)
     (.
      bean8967
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9080] (clojure.core/str arg9080))
 v8969))))
   bean8967))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeTagsRequest}
describe-tags-request
  [m8971]
  (clojure.core/let
   [bean8970
    (new com.amazonaws.services.redshift.model.DescribeTagsRequest)]
   (clojure.core/let
    [v8972
     (:tag-values m8971 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8972 :com.palletops.awaze.client-builder/undef)
     (.
      bean8970
      setTagValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9081] (clojure.core/str arg9081))
 v8972))))
   (clojure.core/let
    [v8972
     (:resource-name m8971 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8972 :com.palletops.awaze.client-builder/undef)
     (. bean8970 setResourceName (clojure.core/str v8972))))
   (clojure.core/let
    [v8972
     (:resource-type m8971 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8972 :com.palletops.awaze.client-builder/undef)
     (. bean8970 setResourceType (clojure.core/str v8972))))
   (clojure.core/let
    [v8972 (:marker m8971 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8972 :com.palletops.awaze.client-builder/undef)
     (. bean8970 setMarker (clojure.core/str v8972))))
   (clojure.core/let
    [v8972
     (:max-records m8971 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8972 :com.palletops.awaze.client-builder/undef)
     (. bean8970 setMaxRecords (clojure.core/int v8972))))
   (clojure.core/let
    [v8972
     (:tag-keys m8971 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8972 :com.palletops.awaze.client-builder/undef)
     (.
      bean8970
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9082] (clojure.core/str arg9082))
 v8972))))
   bean8970))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DisableSnapshotCopyRequest}
disable-snapshot-copy-request
  [m8974]
  (clojure.core/let
   [bean8973
    (new
     com.amazonaws.services.redshift.model.DisableSnapshotCopyRequest)]
   (clojure.core/let
    [v8975
     (:cluster-identifier
      m8974
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8975 :com.palletops.awaze.client-builder/undef)
     (. bean8973 setClusterIdentifier (clojure.core/str v8975))))
   bean8973))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteTagsRequest}
delete-tags-request
  [m8977]
  (clojure.core/let
   [bean8976
    (new com.amazonaws.services.redshift.model.DeleteTagsRequest)]
   (clojure.core/let
    [v8978
     (:resource-name m8977 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8978 :com.palletops.awaze.client-builder/undef)
     (. bean8976 setResourceName (clojure.core/str v8978))))
   (clojure.core/let
    [v8978
     (:tag-keys m8977 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8978 :com.palletops.awaze.client-builder/undef)
     (.
      bean8976
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9083] (clojure.core/str arg9083))
 v8978))))
   bean8976))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.PurchaseReservedNodeOfferingRequest}
purchase-reserved-node-offering-request
  [m8980]
  (clojure.core/let
   [bean8979
    (new
     com.amazonaws.services.redshift.model.PurchaseReservedNodeOfferingRequest)]
   (clojure.core/let
    [v8981
     (:reserved-node-offering-id
      m8980
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8981 :com.palletops.awaze.client-builder/undef)
     (. bean8979 setReservedNodeOfferingId (clojure.core/str v8981))))
   (clojure.core/let
    [v8981
     (:node-count m8980 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8981 :com.palletops.awaze.client-builder/undef)
     (. bean8979 setNodeCount (clojure.core/int v8981))))
   bean8979))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteClusterSnapshotRequest}
delete-cluster-snapshot-request
  [m8983]
  (clojure.core/let
   [bean8982
    (new
     com.amazonaws.services.redshift.model.DeleteClusterSnapshotRequest)]
   (clojure.core/let
    [v8984
     (:snapshot-identifier
      m8983
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8984 :com.palletops.awaze.client-builder/undef)
     (. bean8982 setSnapshotIdentifier (clojure.core/str v8984))))
   (clojure.core/let
    [v8984
     (:snapshot-cluster-identifier
      m8983
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8984 :com.palletops.awaze.client-builder/undef)
     (.
      bean8982
      setSnapshotClusterIdentifier
      (clojure.core/str v8984))))
   bean8982))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateClusterParameterGroupRequest}
create-cluster-parameter-group-request
  [m8986]
  (clojure.core/let
   [bean8985
    (new
     com.amazonaws.services.redshift.model.CreateClusterParameterGroupRequest)]
   (clojure.core/let
    [v8987
     (:parameter-group-family
      m8986
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8987 :com.palletops.awaze.client-builder/undef)
     (. bean8985 setParameterGroupFamily (clojure.core/str v8987))))
   (clojure.core/let
    [v8987
     (:parameter-group-name
      m8986
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8987 :com.palletops.awaze.client-builder/undef)
     (. bean8985 setParameterGroupName (clojure.core/str v8987))))
   (clojure.core/let
    [v8987
     (:description m8986 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8987 :com.palletops.awaze.client-builder/undef)
     (. bean8985 setDescription (clojure.core/str v8987))))
   (clojure.core/let
    [v8987 (:tags m8986 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8987 :com.palletops.awaze.client-builder/undef)
     (.
      bean8985
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9084] (redshift/tag arg9084))
 v8987))))
   bean8985))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.RotateEncryptionKeyRequest}
rotate-encryption-key-request
  [m8989]
  (clojure.core/let
   [bean8988
    (new
     com.amazonaws.services.redshift.model.RotateEncryptionKeyRequest)]
   (clojure.core/let
    [v8990
     (:cluster-identifier
      m8989
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8990 :com.palletops.awaze.client-builder/undef)
     (. bean8988 setClusterIdentifier (clojure.core/str v8990))))
   bean8988))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeHsmClientCertificatesRequest}
describe-hsm-client-certificates-request
  [m8992]
  (clojure.core/let
   [bean8991
    (new
     com.amazonaws.services.redshift.model.DescribeHsmClientCertificatesRequest)]
   (clojure.core/let
    [v8993
     (:hsm-client-certificate-identifier
      m8992
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8993 :com.palletops.awaze.client-builder/undef)
     (.
      bean8991
      setHsmClientCertificateIdentifier
      (clojure.core/str v8993))))
   (clojure.core/let
    [v8993
     (:tag-values m8992 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8993 :com.palletops.awaze.client-builder/undef)
     (.
      bean8991
      setTagValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9085] (clojure.core/str arg9085))
 v8993))))
   (clojure.core/let
    [v8993 (:marker m8992 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8993 :com.palletops.awaze.client-builder/undef)
     (. bean8991 setMarker (clojure.core/str v8993))))
   (clojure.core/let
    [v8993
     (:max-records m8992 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8993 :com.palletops.awaze.client-builder/undef)
     (. bean8991 setMaxRecords (clojure.core/int v8993))))
   (clojure.core/let
    [v8993
     (:tag-keys m8992 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8993 :com.palletops.awaze.client-builder/undef)
     (.
      bean8991
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9086] (clojure.core/str arg9086))
 v8993))))
   bean8991))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeSnapshotCopyGrantsRequest}
describe-snapshot-copy-grants-request
  [m8995]
  (clojure.core/let
   [bean8994
    (new
     com.amazonaws.services.redshift.model.DescribeSnapshotCopyGrantsRequest)]
   (clojure.core/let
    [v8996
     (:tag-values m8995 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8996 :com.palletops.awaze.client-builder/undef)
     (.
      bean8994
      setTagValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9087] (clojure.core/str arg9087))
 v8996))))
   (clojure.core/let
    [v8996
     (:snapshot-copy-grant-name
      m8995
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8996 :com.palletops.awaze.client-builder/undef)
     (. bean8994 setSnapshotCopyGrantName (clojure.core/str v8996))))
   (clojure.core/let
    [v8996 (:marker m8995 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8996 :com.palletops.awaze.client-builder/undef)
     (. bean8994 setMarker (clojure.core/str v8996))))
   (clojure.core/let
    [v8996
     (:max-records m8995 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8996 :com.palletops.awaze.client-builder/undef)
     (. bean8994 setMaxRecords (clojure.core/int v8996))))
   (clojure.core/let
    [v8996
     (:tag-keys m8995 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8996 :com.palletops.awaze.client-builder/undef)
     (.
      bean8994
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9088] (clojure.core/str arg9088))
 v8996))))
   bean8994))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.ResetClusterParameterGroupRequest}
reset-cluster-parameter-group-request
  [m8998]
  (clojure.core/let
   [bean8997
    (new
     com.amazonaws.services.redshift.model.ResetClusterParameterGroupRequest)]
   (clojure.core/let
    [v8999
     (:parameter-group-name
      m8998
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8999 :com.palletops.awaze.client-builder/undef)
     (. bean8997 setParameterGroupName (clojure.core/str v8999))))
   (clojure.core/let
    [v8999
     (:reset-all-parameters
      m8998
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8999 :com.palletops.awaze.client-builder/undef)
     (. bean8997 setResetAllParameters (clojure.core/boolean v8999))))
   (clojure.core/let
    [v8999
     (:parameters m8998 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8999 :com.palletops.awaze.client-builder/undef)
     (.
      bean8997
      setParameters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9089] (redshift/parameter arg9089))
 v8999))))
   bean8997))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteClusterSecurityGroupRequest}
delete-cluster-security-group-request
  [m9001]
  (clojure.core/let
   [bean9000
    (new
     com.amazonaws.services.redshift.model.DeleteClusterSecurityGroupRequest)]
   (clojure.core/let
    [v9002
     (:cluster-security-group-name
      m9001
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9002 :com.palletops.awaze.client-builder/undef)
     (. bean9000 setClusterSecurityGroupName (clojure.core/str v9002))))
   bean9000))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CopyClusterSnapshotRequest}
copy-cluster-snapshot-request
  [m9004]
  (clojure.core/let
   [bean9003
    (new
     com.amazonaws.services.redshift.model.CopyClusterSnapshotRequest)]
   (clojure.core/let
    [v9005
     (:source-snapshot-identifier
      m9004
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9005 :com.palletops.awaze.client-builder/undef)
     (. bean9003 setSourceSnapshotIdentifier (clojure.core/str v9005))))
   (clojure.core/let
    [v9005
     (:source-snapshot-cluster-identifier
      m9004
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9005 :com.palletops.awaze.client-builder/undef)
     (.
      bean9003
      setSourceSnapshotClusterIdentifier
      (clojure.core/str v9005))))
   (clojure.core/let
    [v9005
     (:target-snapshot-identifier
      m9004
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9005 :com.palletops.awaze.client-builder/undef)
     (. bean9003 setTargetSnapshotIdentifier (clojure.core/str v9005))))
   bean9003))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.RestoreTableFromClusterSnapshotRequest}
restore-table-from-cluster-snapshot-request
  [m9007]
  (clojure.core/let
   [bean9006
    (new
     com.amazonaws.services.redshift.model.RestoreTableFromClusterSnapshotRequest)]
   (clojure.core/let
    [v9008
     (:snapshot-identifier
      m9007
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9008 :com.palletops.awaze.client-builder/undef)
     (. bean9006 setSnapshotIdentifier (clojure.core/str v9008))))
   (clojure.core/let
    [v9008
     (:cluster-identifier
      m9007
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9008 :com.palletops.awaze.client-builder/undef)
     (. bean9006 setClusterIdentifier (clojure.core/str v9008))))
   (clojure.core/let
    [v9008
     (:source-database-name
      m9007
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9008 :com.palletops.awaze.client-builder/undef)
     (. bean9006 setSourceDatabaseName (clojure.core/str v9008))))
   (clojure.core/let
    [v9008
     (:source-schema-name
      m9007
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9008 :com.palletops.awaze.client-builder/undef)
     (. bean9006 setSourceSchemaName (clojure.core/str v9008))))
   (clojure.core/let
    [v9008
     (:source-table-name
      m9007
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9008 :com.palletops.awaze.client-builder/undef)
     (. bean9006 setSourceTableName (clojure.core/str v9008))))
   (clojure.core/let
    [v9008
     (:target-database-name
      m9007
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9008 :com.palletops.awaze.client-builder/undef)
     (. bean9006 setTargetDatabaseName (clojure.core/str v9008))))
   (clojure.core/let
    [v9008
     (:target-schema-name
      m9007
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9008 :com.palletops.awaze.client-builder/undef)
     (. bean9006 setTargetSchemaName (clojure.core/str v9008))))
   (clojure.core/let
    [v9008
     (:new-table-name m9007 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9008 :com.palletops.awaze.client-builder/undef)
     (. bean9006 setNewTableName (clojure.core/str v9008))))
   bean9006))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.ModifyEventSubscriptionRequest}
modify-event-subscription-request
  [m9010]
  (clojure.core/let
   [bean9009
    (new
     com.amazonaws.services.redshift.model.ModifyEventSubscriptionRequest)]
   (clojure.core/let
    [v9011 (:enabled m9010 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9011 :com.palletops.awaze.client-builder/undef)
     (. bean9009 setEnabled (clojure.core/boolean v9011))))
   (clojure.core/let
    [v9011
     (:source-type m9010 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9011 :com.palletops.awaze.client-builder/undef)
     (. bean9009 setSourceType (clojure.core/str v9011))))
   (clojure.core/let
    [v9011
     (:source-ids m9010 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9011 :com.palletops.awaze.client-builder/undef)
     (.
      bean9009
      setSourceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9090] (clojure.core/str arg9090))
 v9011))))
   (clojure.core/let
    [v9011
     (:event-categories
      m9010
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9011 :com.palletops.awaze.client-builder/undef)
     (.
      bean9009
      setEventCategories
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9091] (clojure.core/str arg9091))
 v9011))))
   (clojure.core/let
    [v9011
     (:severity m9010 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9011 :com.palletops.awaze.client-builder/undef)
     (. bean9009 setSeverity (clojure.core/str v9011))))
   (clojure.core/let
    [v9011
     (:subscription-name
      m9010
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9011 :com.palletops.awaze.client-builder/undef)
     (. bean9009 setSubscriptionName (clojure.core/str v9011))))
   (clojure.core/let
    [v9011
     (:sns-topic-arn m9010 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9011 :com.palletops.awaze.client-builder/undef)
     (. bean9009 setSnsTopicArn (clojure.core/str v9011))))
   bean9009))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateHsmConfigurationRequest}
create-hsm-configuration-request
  [m9013]
  (clojure.core/let
   [bean9012
    (new
     com.amazonaws.services.redshift.model.CreateHsmConfigurationRequest)]
   (clojure.core/let
    [v9014
     (:hsm-configuration-identifier
      m9013
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9014 :com.palletops.awaze.client-builder/undef)
     (.
      bean9012
      setHsmConfigurationIdentifier
      (clojure.core/str v9014))))
   (clojure.core/let
    [v9014
     (:hsm-ip-address m9013 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9014 :com.palletops.awaze.client-builder/undef)
     (. bean9012 setHsmIpAddress (clojure.core/str v9014))))
   (clojure.core/let
    [v9014
     (:hsm-partition-name
      m9013
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9014 :com.palletops.awaze.client-builder/undef)
     (. bean9012 setHsmPartitionName (clojure.core/str v9014))))
   (clojure.core/let
    [v9014
     (:hsm-partition-password
      m9013
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9014 :com.palletops.awaze.client-builder/undef)
     (. bean9012 setHsmPartitionPassword (clojure.core/str v9014))))
   (clojure.core/let
    [v9014
     (:hsm-server-public-certificate
      m9013
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9014 :com.palletops.awaze.client-builder/undef)
     (.
      bean9012
      setHsmServerPublicCertificate
      (clojure.core/str v9014))))
   (clojure.core/let
    [v9014
     (:description m9013 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9014 :com.palletops.awaze.client-builder/undef)
     (. bean9012 setDescription (clojure.core/str v9014))))
   (clojure.core/let
    [v9014 (:tags m9013 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9014 :com.palletops.awaze.client-builder/undef)
     (.
      bean9012
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9092] (redshift/tag arg9092))
 v9014))))
   bean9012))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeHsmConfigurationsRequest}
describe-hsm-configurations-request
  [m9016]
  (clojure.core/let
   [bean9015
    (new
     com.amazonaws.services.redshift.model.DescribeHsmConfigurationsRequest)]
   (clojure.core/let
    [v9017
     (:hsm-configuration-identifier
      m9016
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9017 :com.palletops.awaze.client-builder/undef)
     (.
      bean9015
      setHsmConfigurationIdentifier
      (clojure.core/str v9017))))
   (clojure.core/let
    [v9017
     (:tag-values m9016 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9017 :com.palletops.awaze.client-builder/undef)
     (.
      bean9015
      setTagValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9093] (clojure.core/str arg9093))
 v9017))))
   (clojure.core/let
    [v9017 (:marker m9016 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9017 :com.palletops.awaze.client-builder/undef)
     (. bean9015 setMarker (clojure.core/str v9017))))
   (clojure.core/let
    [v9017
     (:max-records m9016 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9017 :com.palletops.awaze.client-builder/undef)
     (. bean9015 setMaxRecords (clojure.core/int v9017))))
   (clojure.core/let
    [v9017
     (:tag-keys m9016 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9017 :com.palletops.awaze.client-builder/undef)
     (.
      bean9015
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9094] (clojure.core/str arg9094))
 v9017))))
   bean9015))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeClusterSubnetGroupsRequest}
describe-cluster-subnet-groups-request
  [m9019]
  (clojure.core/let
   [bean9018
    (new
     com.amazonaws.services.redshift.model.DescribeClusterSubnetGroupsRequest)]
   (clojure.core/let
    [v9020
     (:cluster-subnet-group-name
      m9019
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9020 :com.palletops.awaze.client-builder/undef)
     (. bean9018 setClusterSubnetGroupName (clojure.core/str v9020))))
   (clojure.core/let
    [v9020
     (:tag-values m9019 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9020 :com.palletops.awaze.client-builder/undef)
     (.
      bean9018
      setTagValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9095] (clojure.core/str arg9095))
 v9020))))
   (clojure.core/let
    [v9020 (:marker m9019 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9020 :com.palletops.awaze.client-builder/undef)
     (. bean9018 setMarker (clojure.core/str v9020))))
   (clojure.core/let
    [v9020
     (:max-records m9019 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9020 :com.palletops.awaze.client-builder/undef)
     (. bean9018 setMaxRecords (clojure.core/int v9020))))
   (clojure.core/let
    [v9020
     (:tag-keys m9019 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9020 :com.palletops.awaze.client-builder/undef)
     (.
      bean9018
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9096] (clojure.core/str arg9096))
 v9020))))
   bean9018))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteClusterRequest}
delete-cluster-request
  [m9022]
  (clojure.core/let
   [bean9021
    (new com.amazonaws.services.redshift.model.DeleteClusterRequest)]
   (clojure.core/let
    [v9023
     (:cluster-identifier
      m9022
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9023 :com.palletops.awaze.client-builder/undef)
     (. bean9021 setClusterIdentifier (clojure.core/str v9023))))
   (clojure.core/let
    [v9023
     (:skip-final-cluster-snapshot
      m9022
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9023 :com.palletops.awaze.client-builder/undef)
     (.
      bean9021
      setSkipFinalClusterSnapshot
      (clojure.core/boolean v9023))))
   (clojure.core/let
    [v9023
     (:final-cluster-snapshot-identifier
      m9022
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9023 :com.palletops.awaze.client-builder/undef)
     (.
      bean9021
      setFinalClusterSnapshotIdentifier
      (clojure.core/str v9023))))
   bean9021))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.RevokeClusterSecurityGroupIngressRequest}
revoke-cluster-security-group-ingress-request
  [m9025]
  (clojure.core/let
   [bean9024
    (new
     com.amazonaws.services.redshift.model.RevokeClusterSecurityGroupIngressRequest)]
   (clojure.core/let
    [v9026
     (:cluster-security-group-name
      m9025
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9026 :com.palletops.awaze.client-builder/undef)
     (. bean9024 setClusterSecurityGroupName (clojure.core/str v9026))))
   (clojure.core/let
    [v9026 (:cidrip m9025 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9026 :com.palletops.awaze.client-builder/undef)
     (. bean9024 setCIDRIP (clojure.core/str v9026))))
   (clojure.core/let
    [v9026
     (:ec2security-group-name
      m9025
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9026 :com.palletops.awaze.client-builder/undef)
     (. bean9024 setEC2SecurityGroupName (clojure.core/str v9026))))
   (clojure.core/let
    [v9026
     (:ec2security-group-owner-id
      m9025
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9026 :com.palletops.awaze.client-builder/undef)
     (. bean9024 setEC2SecurityGroupOwnerId (clojure.core/str v9026))))
   bean9024))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateClusterSubnetGroupRequest}
create-cluster-subnet-group-request
  [m9028]
  (clojure.core/let
   [bean9027
    (new
     com.amazonaws.services.redshift.model.CreateClusterSubnetGroupRequest)]
   (clojure.core/let
    [v9029
     (:cluster-subnet-group-name
      m9028
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9029 :com.palletops.awaze.client-builder/undef)
     (. bean9027 setClusterSubnetGroupName (clojure.core/str v9029))))
   (clojure.core/let
    [v9029
     (:description m9028 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9029 :com.palletops.awaze.client-builder/undef)
     (. bean9027 setDescription (clojure.core/str v9029))))
   (clojure.core/let
    [v9029 (:tags m9028 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9029 :com.palletops.awaze.client-builder/undef)
     (.
      bean9027
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9097] (redshift/tag arg9097))
 v9029))))
   (clojure.core/let
    [v9029
     (:subnet-ids m9028 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9029 :com.palletops.awaze.client-builder/undef)
     (.
      bean9027
      setSubnetIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9098] (clojure.core/str arg9098))
 v9029))))
   bean9027))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateClusterSnapshotRequest}
create-cluster-snapshot-request
  [m9031]
  (clojure.core/let
   [bean9030
    (new
     com.amazonaws.services.redshift.model.CreateClusterSnapshotRequest)]
   (clojure.core/let
    [v9032
     (:snapshot-identifier
      m9031
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9032 :com.palletops.awaze.client-builder/undef)
     (. bean9030 setSnapshotIdentifier (clojure.core/str v9032))))
   (clojure.core/let
    [v9032
     (:cluster-identifier
      m9031
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9032 :com.palletops.awaze.client-builder/undef)
     (. bean9030 setClusterIdentifier (clojure.core/str v9032))))
   (clojure.core/let
    [v9032 (:tags m9031 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9032 :com.palletops.awaze.client-builder/undef)
     (.
      bean9030
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9099] (redshift/tag arg9099))
 v9032))))
   bean9030))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateTagsRequest}
create-tags-request
  [m9034]
  (clojure.core/let
   [bean9033
    (new com.amazonaws.services.redshift.model.CreateTagsRequest)]
   (clojure.core/let
    [v9035
     (:resource-name m9034 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9035 :com.palletops.awaze.client-builder/undef)
     (. bean9033 setResourceName (clojure.core/str v9035))))
   (clojure.core/let
    [v9035 (:tags m9034 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9035 :com.palletops.awaze.client-builder/undef)
     (.
      bean9033
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9100] (redshift/tag arg9100))
 v9035))))
   bean9033))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeOrderableClusterOptionsRequest}
describe-orderable-cluster-options-request
  [m9037]
  (clojure.core/let
   [bean9036
    (new
     com.amazonaws.services.redshift.model.DescribeOrderableClusterOptionsRequest)]
   (clojure.core/let
    [v9038
     (:node-type m9037 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9038 :com.palletops.awaze.client-builder/undef)
     (. bean9036 setNodeType (clojure.core/str v9038))))
   (clojure.core/let
    [v9038
     (:cluster-version
      m9037
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9038 :com.palletops.awaze.client-builder/undef)
     (. bean9036 setClusterVersion (clojure.core/str v9038))))
   (clojure.core/let
    [v9038 (:marker m9037 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9038 :com.palletops.awaze.client-builder/undef)
     (. bean9036 setMarker (clojure.core/str v9038))))
   (clojure.core/let
    [v9038
     (:max-records m9037 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9038 :com.palletops.awaze.client-builder/undef)
     (. bean9036 setMaxRecords (clojure.core/int v9038))))
   bean9036))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.EnableLoggingRequest}
enable-logging-request
  [m9040]
  (clojure.core/let
   [bean9039
    (new com.amazonaws.services.redshift.model.EnableLoggingRequest)]
   (clojure.core/let
    [v9041
     (:cluster-identifier
      m9040
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9041 :com.palletops.awaze.client-builder/undef)
     (. bean9039 setClusterIdentifier (clojure.core/str v9041))))
   (clojure.core/let
    [v9041
     (:s3key-prefix m9040 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9041 :com.palletops.awaze.client-builder/undef)
     (. bean9039 setS3KeyPrefix (clojure.core/str v9041))))
   (clojure.core/let
    [v9041
     (:bucket-name m9040 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9041 :com.palletops.awaze.client-builder/undef)
     (. bean9039 setBucketName (clojure.core/str v9041))))
   bean9039))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.RevokeSnapshotAccessRequest}
revoke-snapshot-access-request
  [m9043]
  (clojure.core/let
   [bean9042
    (new
     com.amazonaws.services.redshift.model.RevokeSnapshotAccessRequest)]
   (clojure.core/let
    [v9044
     (:snapshot-identifier
      m9043
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9044 :com.palletops.awaze.client-builder/undef)
     (. bean9042 setSnapshotIdentifier (clojure.core/str v9044))))
   (clojure.core/let
    [v9044
     (:snapshot-cluster-identifier
      m9043
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9044 :com.palletops.awaze.client-builder/undef)
     (.
      bean9042
      setSnapshotClusterIdentifier
      (clojure.core/str v9044))))
   (clojure.core/let
    [v9044
     (:account-with-restore-access
      m9043
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9044 :com.palletops.awaze.client-builder/undef)
     (. bean9042 setAccountWithRestoreAccess (clojure.core/str v9044))))
   bean9042))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeEventSubscriptionsRequest}
describe-event-subscriptions-request
  [m9046]
  (clojure.core/let
   [bean9045
    (new
     com.amazonaws.services.redshift.model.DescribeEventSubscriptionsRequest)]
   (clojure.core/let
    [v9047
     (:subscription-name
      m9046
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9047 :com.palletops.awaze.client-builder/undef)
     (. bean9045 setSubscriptionName (clojure.core/str v9047))))
   (clojure.core/let
    [v9047 (:marker m9046 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9047 :com.palletops.awaze.client-builder/undef)
     (. bean9045 setMarker (clojure.core/str v9047))))
   (clojure.core/let
    [v9047
     (:max-records m9046 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9047 :com.palletops.awaze.client-builder/undef)
     (. bean9045 setMaxRecords (clojure.core/int v9047))))
   bean9045))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeReservedNodeOfferingsRequest}
describe-reserved-node-offerings-request
  [m9049]
  (clojure.core/let
   [bean9048
    (new
     com.amazonaws.services.redshift.model.DescribeReservedNodeOfferingsRequest)]
   (clojure.core/let
    [v9050
     (:reserved-node-offering-id
      m9049
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9050 :com.palletops.awaze.client-builder/undef)
     (. bean9048 setReservedNodeOfferingId (clojure.core/str v9050))))
   (clojure.core/let
    [v9050 (:marker m9049 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9050 :com.palletops.awaze.client-builder/undef)
     (. bean9048 setMarker (clojure.core/str v9050))))
   (clojure.core/let
    [v9050
     (:max-records m9049 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9050 :com.palletops.awaze.client-builder/undef)
     (. bean9048 setMaxRecords (clojure.core/int v9050))))
   bean9048))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteHsmConfigurationRequest}
delete-hsm-configuration-request
  [m9052]
  (clojure.core/let
   [bean9051
    (new
     com.amazonaws.services.redshift.model.DeleteHsmConfigurationRequest)]
   (clojure.core/let
    [v9053
     (:hsm-configuration-identifier
      m9052
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9053 :com.palletops.awaze.client-builder/undef)
     (.
      bean9051
      setHsmConfigurationIdentifier
      (clojure.core/str v9053))))
   bean9051))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateEventSubscriptionRequest}
create-event-subscription-request
  [m9055]
  (clojure.core/let
   [bean9054
    (new
     com.amazonaws.services.redshift.model.CreateEventSubscriptionRequest)]
   (clojure.core/let
    [v9056 (:enabled m9055 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9056 :com.palletops.awaze.client-builder/undef)
     (. bean9054 setEnabled (clojure.core/boolean v9056))))
   (clojure.core/let
    [v9056
     (:source-type m9055 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9056 :com.palletops.awaze.client-builder/undef)
     (. bean9054 setSourceType (clojure.core/str v9056))))
   (clojure.core/let
    [v9056
     (:source-ids m9055 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9056 :com.palletops.awaze.client-builder/undef)
     (.
      bean9054
      setSourceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9197] (clojure.core/str arg9197))
 v9056))))
   (clojure.core/let
    [v9056
     (:event-categories
      m9055
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9056 :com.palletops.awaze.client-builder/undef)
     (.
      bean9054
      setEventCategories
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9198] (clojure.core/str arg9198))
 v9056))))
   (clojure.core/let
    [v9056
     (:severity m9055 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9056 :com.palletops.awaze.client-builder/undef)
     (. bean9054 setSeverity (clojure.core/str v9056))))
   (clojure.core/let
    [v9056
     (:subscription-name
      m9055
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9056 :com.palletops.awaze.client-builder/undef)
     (. bean9054 setSubscriptionName (clojure.core/str v9056))))
   (clojure.core/let
    [v9056
     (:sns-topic-arn m9055 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9056 :com.palletops.awaze.client-builder/undef)
     (. bean9054 setSnsTopicArn (clojure.core/str v9056))))
   (clojure.core/let
    [v9056 (:tags m9055 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9056 :com.palletops.awaze.client-builder/undef)
     (.
      bean9054
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9199] (redshift/tag arg9199))
 v9056))))
   bean9054))
 (clojure.core/defmulti
  redshift
  (clojure.core/fn redshift [m__1874__auto__] (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   redshift
   :describe-resize
   [m9101]
   (clojure.core/let
    [credentials9102 (:credentials m9101) args9103 (:args m9101)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9104
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9102)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9104
       describeResize
       (redshift/describe-resize-request
        (clojure.core/nth args9103 0)))))))
  (clojure.core/defn
   describe-resize-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeResize"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-resize,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-resize
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeResize"}
   [credentials9106 & args9107]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9108
     (com.palletops.awaze.common/aws-client :redshift credentials9106)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9108
      describeResize
      (redshift/describe-resize-request (clojure.core/nth args9107 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-cluster-snapshots
   [m9109]
   (clojure.core/let
    [credentials9110 (:credentials m9109) args9111 (:args m9109)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9112
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9110)]
     (clojure.core/case
      (clojure.core/count args9111)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9112
        describeClusterSnapshots))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9112
        describeClusterSnapshots
        (redshift/describe-cluster-snapshots-request
         (clojure.core/nth args9111 0))))))))
  (clojure.core/defn
   describe-cluster-snapshots-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         marker
                         start-time
                         tag-keys
                         custom-query-parameters
                         end-time
                         snapshot-identifier
                         read-limit
                         tag-values
                         general-progress-listener
                         owner-account
                         max-records
                         clone-source
                         snapshot-type
                         clone-root]}]]),
    :doc "Generate map for describeClusterSnapshots, describeClusterSnapshots"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-cluster-snapshots,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-cluster-snapshots,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-cluster-snapshots
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         marker
                         start-time
                         tag-keys
                         custom-query-parameters
                         end-time
                         snapshot-identifier
                         read-limit
                         tag-values
                         general-progress-listener
                         owner-account
                         max-records
                         clone-source
                         snapshot-type
                         clone-root]}]]),
    :doc "Call describeClusterSnapshots, describeClusterSnapshots"}
   [credentials9114 & args9115]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9116
     (com.palletops.awaze.common/aws-client :redshift credentials9114)]
    (clojure.core/case
     (clojure.core/count args9115)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9116
       describeClusterSnapshots))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9116
       describeClusterSnapshots
       (redshift/describe-cluster-snapshots-request
        (clojure.core/nth args9115 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-default-cluster-parameters
   [m9117]
   (clojure.core/let
    [credentials9118 (:credentials m9117) args9119 (:args m9117)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9120
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9118)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9120
       describeDefaultClusterParameters
       (redshift/describe-default-cluster-parameters-request
        (clojure.core/nth args9119 0)))))))
  (clojure.core/defn
   describe-default-cluster-parameters-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         parameter-group-family
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeDefaultClusterParameters"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-default-cluster-parameters,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-default-cluster-parameters
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         parameter-group-family
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeDefaultClusterParameters"}
   [credentials9122 & args9123]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9124
     (com.palletops.awaze.common/aws-client :redshift credentials9122)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9124
      describeDefaultClusterParameters
      (redshift/describe-default-cluster-parameters-request
       (clojure.core/nth args9123 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-hsm-client-certificate
   [m9125]
   (clojure.core/let
    [credentials9126 (:credentials m9125) args9127 (:args m9125)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9128
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9126)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9128
       createHsmClientCertificate
       (redshift/create-hsm-client-certificate-request
        (clojure.core/nth args9127 0)))))))
  (clojure.core/defn
   create-hsm-client-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         hsm-client-certificate-identifier
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createHsmClientCertificate"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-hsm-client-certificate,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   create-hsm-client-certificate
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         hsm-client-certificate-identifier
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createHsmClientCertificate"}
   [credentials9130 & args9131]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9132
     (com.palletops.awaze.common/aws-client :redshift credentials9130)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9132
      createHsmClientCertificate
      (redshift/create-hsm-client-certificate-request
       (clojure.core/nth args9131 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-cluster-versions
   [m9133]
   (clojure.core/let
    [credentials9134 (:credentials m9133) args9135 (:args m9133)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9136
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9134)]
     (clojure.core/case
      (clojure.core/count args9135)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9136
        describeClusterVersions))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9136
        describeClusterVersions
        (redshift/describe-cluster-versions-request
         (clojure.core/nth args9135 0))))))))
  (clojure.core/defn
   describe-cluster-versions-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         cluster-version
                         custom-query-parameters
                         cluster-parameter-group-family
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeClusterVersions, describeClusterVersions"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-cluster-versions,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-cluster-versions,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-cluster-versions
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         cluster-version
                         custom-query-parameters
                         cluster-parameter-group-family
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeClusterVersions, describeClusterVersions"}
   [credentials9138 & args9139]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9140
     (com.palletops.awaze.common/aws-client :redshift credentials9138)]
    (clojure.core/case
     (clojure.core/count args9139)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9140
       describeClusterVersions))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9140
       describeClusterVersions
       (redshift/describe-cluster-versions-request
        (clojure.core/nth args9139 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :enable-snapshot-copy
   [m9141]
   (clojure.core/let
    [credentials9142 (:credentials m9141) args9143 (:args m9141)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9144
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9142)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9144
       enableSnapshotCopy
       (redshift/enable-snapshot-copy-request
        (clojure.core/nth args9143 0)))))))
  (clojure.core/defn
   enable-snapshot-copy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         destination-region
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         retention-period
                         read-limit
                         general-progress-listener
                         clone-source
                         snapshot-copy-grant-name
                         clone-root]}]]),
    :doc "Generate map for enableSnapshotCopy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :enable-snapshot-copy,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   enable-snapshot-copy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         destination-region
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         retention-period
                         read-limit
                         general-progress-listener
                         clone-source
                         snapshot-copy-grant-name
                         clone-root]}]]),
    :doc "Call enableSnapshotCopy"}
   [credentials9146 & args9147]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9148
     (com.palletops.awaze.common/aws-client :redshift credentials9146)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9148
      enableSnapshotCopy
      (redshift/enable-snapshot-copy-request
       (clojure.core/nth args9147 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-snapshot-copy-grant
   [m9149]
   (clojure.core/let
    [credentials9150 (:credentials m9149) args9151 (:args m9149)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9152
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9150)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9152
       createSnapshotCopyGrant
       (redshift/create-snapshot-copy-grant-request
        (clojure.core/nth args9151 0)))))))
  (clojure.core/defn
   create-snapshot-copy-grant-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         kms-key-id
                         clone-source
                         snapshot-copy-grant-name
                         clone-root]}]]),
    :doc "Generate map for createSnapshotCopyGrant"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-snapshot-copy-grant,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   create-snapshot-copy-grant
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         kms-key-id
                         clone-source
                         snapshot-copy-grant-name
                         clone-root]}]]),
    :doc "Call createSnapshotCopyGrant"}
   [credentials9154 & args9155]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9156
     (com.palletops.awaze.common/aws-client :redshift credentials9154)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9156
      createSnapshotCopyGrant
      (redshift/create-snapshot-copy-grant-request
       (clojure.core/nth args9155 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-cluster-parameter-groups
   [m9157]
   (clojure.core/let
    [credentials9158 (:credentials m9157) args9159 (:args m9157)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9160
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9158)]
     (clojure.core/case
      (clojure.core/count args9159)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9160
        describeClusterParameterGroups
        (redshift/describe-cluster-parameter-groups-request
         (clojure.core/nth args9159 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9160
        describeClusterParameterGroups))))))
  (clojure.core/defn
   describe-cluster-parameter-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         parameter-group-name
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeClusterParameterGroups, describeClusterParameterGroups"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-cluster-parameter-groups,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-cluster-parameter-groups,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-cluster-parameter-groups
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         parameter-group-name
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeClusterParameterGroups, describeClusterParameterGroups"}
   [credentials9162 & args9163]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9164
     (com.palletops.awaze.common/aws-client :redshift credentials9162)]
    (clojure.core/case
     (clojure.core/count args9163)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9164
       describeClusterParameterGroups
       (redshift/describe-cluster-parameter-groups-request
        (clojure.core/nth args9163 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9164
       describeClusterParameterGroups))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-cluster-parameter-group
   [m9165]
   (clojure.core/let
    [credentials9166 (:credentials m9165) args9167 (:args m9165)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9168
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9166)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9168
       deleteClusterParameterGroup
       (redshift/delete-cluster-parameter-group-request
        (clojure.core/nth args9167 0)))))))
  (clojure.core/defn
   delete-cluster-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         parameter-group-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteClusterParameterGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-cluster-parameter-group,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   delete-cluster-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         parameter-group-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteClusterParameterGroup"}
   [credentials9170 & args9171]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9172
     (com.palletops.awaze.common/aws-client :redshift credentials9170)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9172
      deleteClusterParameterGroup
      (redshift/delete-cluster-parameter-group-request
       (clojure.core/nth args9171 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-events
   [m9173]
   (clojure.core/let
    [credentials9174 (:credentials m9173) args9175 (:args m9173)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9176
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9174)]
     (clojure.core/case
      (clojure.core/count args9175)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9176
        describeEvents
        (redshift/describe-events-request
         (clojure.core/nth args9175 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9176
        describeEvents))))))
  (clojure.core/defn
   describe-events-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         source-type
                         start-time
                         custom-query-parameters
                         end-time
                         duration
                         read-limit
                         source-identifier
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeEvents, describeEvents"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-events,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-events,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-events
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         source-type
                         start-time
                         custom-query-parameters
                         end-time
                         duration
                         read-limit
                         source-identifier
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeEvents, describeEvents"}
   [credentials9178 & args9179]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9180
     (com.palletops.awaze.common/aws-client :redshift credentials9178)]
    (clojure.core/case
     (clojure.core/count args9179)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9180
       describeEvents
       (redshift/describe-events-request
        (clojure.core/nth args9179 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9180
       describeEvents))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-reserved-nodes
   [m9181]
   (clojure.core/let
    [credentials9182 (:credentials m9181) args9183 (:args m9181)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9184
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9182)]
     (clojure.core/case
      (clojure.core/count args9183)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9184
        describeReservedNodes))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9184
        describeReservedNodes
        (redshift/describe-reserved-nodes-request
         (clojure.core/nth args9183 0))))))))
  (clojure.core/defn
   describe-reserved-nodes-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         reserved-node-id
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeReservedNodes, describeReservedNodes"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-reserved-nodes,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-reserved-nodes,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-reserved-nodes
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         reserved-node-id
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeReservedNodes, describeReservedNodes"}
   [credentials9186 & args9187]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9188
     (com.palletops.awaze.common/aws-client :redshift credentials9186)]
    (clojure.core/case
     (clojure.core/count args9187)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9188
       describeReservedNodes))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9188
       describeReservedNodes
       (redshift/describe-reserved-nodes-request
        (clojure.core/nth args9187 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :modify-cluster-iam-roles
   [m9189]
   (clojure.core/let
    [credentials9190 (:credentials m9189) args9191 (:args m9189)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9192
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9190)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9192
       modifyClusterIamRoles
       (redshift/modify-cluster-iam-roles-request
        (clojure.core/nth args9191 0)))))))
  (clojure.core/defn
   modify-cluster-iam-roles-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         remove-iam-roles
                         read-limit
                         add-iam-roles
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for modifyClusterIamRoles"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-cluster-iam-roles,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   modify-cluster-iam-roles
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         remove-iam-roles
                         read-limit
                         add-iam-roles
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call modifyClusterIamRoles"}
   [credentials9194 & args9195]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9196
     (com.palletops.awaze.common/aws-client :redshift credentials9194)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9196
      modifyClusterIamRoles
      (redshift/modify-cluster-iam-roles-request
       (clojure.core/nth args9195 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-event-subscription
   [m9200]
   (clojure.core/let
    [credentials9201 (:credentials m9200) args9202 (:args m9200)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9203
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9201)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9203
       deleteEventSubscription
       (redshift/delete-event-subscription-request
        (clojure.core/nth args9202 0)))))))
  (clojure.core/defn
   delete-event-subscription-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subscription-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteEventSubscription"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-event-subscription,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   delete-event-subscription
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subscription-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteEventSubscription"}
   [credentials9205 & args9206]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9207
     (com.palletops.awaze.common/aws-client :redshift credentials9205)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9207
      deleteEventSubscription
      (redshift/delete-event-subscription-request
       (clojure.core/nth args9206 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :reboot-cluster
   [m9208]
   (clojure.core/let
    [credentials9209 (:credentials m9208) args9210 (:args m9208)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9211
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9209)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9211
       rebootCluster
       (redshift/reboot-cluster-request (clojure.core/nth args9210 0)))))))
  (clojure.core/defn
   reboot-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for rebootCluster"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :reboot-cluster,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   reboot-cluster
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call rebootCluster"}
   [credentials9213 & args9214]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9215
     (com.palletops.awaze.common/aws-client :redshift credentials9213)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9215
      rebootCluster
      (redshift/reboot-cluster-request (clojure.core/nth args9214 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-cluster-security-group
   [m9216]
   (clojure.core/let
    [credentials9217 (:credentials m9216) args9218 (:args m9216)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9219
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9217)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9219
       createClusterSecurityGroup
       (redshift/create-cluster-security-group-request
        (clojure.core/nth args9218 0)))))))
  (clojure.core/defn
   create-cluster-security-group-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         cluster-security-group-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createClusterSecurityGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-cluster-security-group,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   create-cluster-security-group
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         cluster-security-group-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createClusterSecurityGroup"}
   [credentials9221 & args9222]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9223
     (com.palletops.awaze.common/aws-client :redshift credentials9221)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9223
      createClusterSecurityGroup
      (redshift/create-cluster-security-group-request
       (clojure.core/nth args9222 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :modify-cluster-parameter-group
   [m9224]
   (clojure.core/let
    [credentials9225 (:credentials m9224) args9226 (:args m9224)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9227
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9225)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9227
       modifyClusterParameterGroup
       (redshift/modify-cluster-parameter-group-request
        (clojure.core/nth args9226 0)))))))
  (clojure.core/defn
   modify-cluster-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         parameter-group-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         parameters
                         clone-root]}]]),
    :doc "Generate map for modifyClusterParameterGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-cluster-parameter-group,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   modify-cluster-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         parameter-group-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         parameters
                         clone-root]}]]),
    :doc "Call modifyClusterParameterGroup"}
   [credentials9229 & args9230]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9231
     (com.palletops.awaze.common/aws-client :redshift credentials9229)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9231
      modifyClusterParameterGroup
      (redshift/modify-cluster-parameter-group-request
       (clojure.core/nth args9230 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :modify-snapshot-copy-retention-period
   [m9232]
   (clojure.core/let
    [credentials9233 (:credentials m9232) args9234 (:args m9232)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9235
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9233)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9235
       modifySnapshotCopyRetentionPeriod
       (redshift/modify-snapshot-copy-retention-period-request
        (clojure.core/nth args9234 0)))))))
  (clojure.core/defn
   modify-snapshot-copy-retention-period-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         retention-period
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for modifySnapshotCopyRetentionPeriod"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-snapshot-copy-retention-period,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   modify-snapshot-copy-retention-period
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         retention-period
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call modifySnapshotCopyRetentionPeriod"}
   [credentials9237 & args9238]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9239
     (com.palletops.awaze.common/aws-client :redshift credentials9237)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9239
      modifySnapshotCopyRetentionPeriod
      (redshift/modify-snapshot-copy-retention-period-request
       (clojure.core/nth args9238 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-snapshot-copy-grant
   [m9240]
   (clojure.core/let
    [credentials9241 (:credentials m9240) args9242 (:args m9240)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9243
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9241)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9243
       deleteSnapshotCopyGrant
       (redshift/delete-snapshot-copy-grant-request
        (clojure.core/nth args9242 0)))))))
  (clojure.core/defn
   delete-snapshot-copy-grant-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         snapshot-copy-grant-name
                         clone-root]}]]),
    :doc "Generate map for deleteSnapshotCopyGrant"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-snapshot-copy-grant,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   delete-snapshot-copy-grant
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         snapshot-copy-grant-name
                         clone-root]}]]),
    :doc "Call deleteSnapshotCopyGrant"}
   [credentials9245 & args9246]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9247
     (com.palletops.awaze.common/aws-client :redshift credentials9245)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9247
      deleteSnapshotCopyGrant
      (redshift/delete-snapshot-copy-grant-request
       (clojure.core/nth args9246 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :authorize-snapshot-access
   [m9248]
   (clojure.core/let
    [credentials9249 (:credentials m9248) args9250 (:args m9248)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9251
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9249)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9251
       authorizeSnapshotAccess
       (redshift/authorize-snapshot-access-request
        (clojure.core/nth args9250 0)))))))
  (clojure.core/defn
   authorize-snapshot-access-map
   {:arglists (quote
               [[credentials
                 {:keys [account-with-restore-access
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         snapshot-identifier
                         read-limit
                         general-progress-listener
                         snapshot-cluster-identifier
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for authorizeSnapshotAccess"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :authorize-snapshot-access,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   authorize-snapshot-access
   {:arglists (quote
               [[credentials
                 {:keys [account-with-restore-access
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         snapshot-identifier
                         read-limit
                         general-progress-listener
                         snapshot-cluster-identifier
                         clone-source
                         clone-root]}]]),
    :doc "Call authorizeSnapshotAccess"}
   [credentials9253 & args9254]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9255
     (com.palletops.awaze.common/aws-client :redshift credentials9253)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9255
      authorizeSnapshotAccess
      (redshift/authorize-snapshot-access-request
       (clojure.core/nth args9254 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :disable-logging
   [m9256]
   (clojure.core/let
    [credentials9257 (:credentials m9256) args9258 (:args m9256)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9259
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9257)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9259
       disableLogging
       (redshift/disable-logging-request
        (clojure.core/nth args9258 0)))))))
  (clojure.core/defn
   disable-logging-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for disableLogging"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :disable-logging,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   disable-logging
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call disableLogging"}
   [credentials9261 & args9262]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9263
     (com.palletops.awaze.common/aws-client :redshift credentials9261)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9263
      disableLogging
      (redshift/disable-logging-request (clojure.core/nth args9262 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :modify-cluster-subnet-group
   [m9264]
   (clojure.core/let
    [credentials9265 (:credentials m9264) args9266 (:args m9264)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9267
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9265)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9267
       modifyClusterSubnetGroup
       (redshift/modify-cluster-subnet-group-request
        (clojure.core/nth args9266 0)))))))
  (clojure.core/defn
   modify-cluster-subnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         subnet-ids
                         general-progress-listener
                         clone-source
                         cluster-subnet-group-name
                         clone-root]}]]),
    :doc "Generate map for modifyClusterSubnetGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-cluster-subnet-group,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   modify-cluster-subnet-group
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         subnet-ids
                         general-progress-listener
                         clone-source
                         cluster-subnet-group-name
                         clone-root]}]]),
    :doc "Call modifyClusterSubnetGroup"}
   [credentials9269 & args9270]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9271
     (com.palletops.awaze.common/aws-client :redshift credentials9269)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9271
      modifyClusterSubnetGroup
      (redshift/modify-cluster-subnet-group-request
       (clojure.core/nth args9270 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :modify-cluster
   [m9272]
   (clojure.core/let
    [credentials9273 (:credentials m9272) args9274 (:args m9272)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9275
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9273)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9275
       modifyCluster
       (redshift/modify-cluster-request (clojure.core/nth args9274 0)))))))
  (clojure.core/defn
   modify-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-security-group-ids
                         hsm-configuration-identifier
                         new-cluster-identifier
                         automated-snapshot-retention-period
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         cluster-parameter-group-name
                         elastic-ip
                         allow-version-upgrade
                         cluster-identifier
                         sdk-request-timeout
                         hsm-client-certificate-identifier
                         cluster-security-groups
                         cluster-version
                         custom-query-parameters
                         node-type
                         publicly-accessible
                         number-of-nodes
                         read-limit
                         general-progress-listener
                         master-user-password
                         clone-source
                         clone-root
                         cluster-type]}]]),
    :doc "Generate map for modifyCluster"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-cluster,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   modify-cluster
   {:arglists (quote
               [[credentials
                 {:keys [vpc-security-group-ids
                         hsm-configuration-identifier
                         new-cluster-identifier
                         automated-snapshot-retention-period
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         cluster-parameter-group-name
                         elastic-ip
                         allow-version-upgrade
                         cluster-identifier
                         sdk-request-timeout
                         hsm-client-certificate-identifier
                         cluster-security-groups
                         cluster-version
                         custom-query-parameters
                         node-type
                         publicly-accessible
                         number-of-nodes
                         read-limit
                         general-progress-listener
                         master-user-password
                         clone-source
                         clone-root
                         cluster-type]}]]),
    :doc "Call modifyCluster"}
   [credentials9277 & args9278]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9279
     (com.palletops.awaze.common/aws-client :redshift credentials9277)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9279
      modifyCluster
      (redshift/modify-cluster-request (clojure.core/nth args9278 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :restore-from-cluster-snapshot
   [m9280]
   (clojure.core/let
    [credentials9281 (:credentials m9280) args9282 (:args m9280)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9283
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9281)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9283
       restoreFromClusterSnapshot
       (redshift/restore-from-cluster-snapshot-request
        (clojure.core/nth args9282 0)))))))
  (clojure.core/defn
   restore-from-cluster-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-security-group-ids
                         hsm-configuration-identifier
                         automated-snapshot-retention-period
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         cluster-parameter-group-name
                         elastic-ip
                         allow-version-upgrade
                         cluster-identifier
                         sdk-request-timeout
                         hsm-client-certificate-identifier
                         cluster-security-groups
                         custom-query-parameters
                         availability-zone
                         port
                         node-type
                         publicly-accessible
                         additional-info
                         snapshot-identifier
                         read-limit
                         general-progress-listener
                         owner-account
                         kms-key-id
                         iam-roles
                         snapshot-cluster-identifier
                         clone-source
                         cluster-subnet-group-name
                         clone-root]}]]),
    :doc "Generate map for restoreFromClusterSnapshot"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :restore-from-cluster-snapshot,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   restore-from-cluster-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [vpc-security-group-ids
                         hsm-configuration-identifier
                         automated-snapshot-retention-period
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         cluster-parameter-group-name
                         elastic-ip
                         allow-version-upgrade
                         cluster-identifier
                         sdk-request-timeout
                         hsm-client-certificate-identifier
                         cluster-security-groups
                         custom-query-parameters
                         availability-zone
                         port
                         node-type
                         publicly-accessible
                         additional-info
                         snapshot-identifier
                         read-limit
                         general-progress-listener
                         owner-account
                         kms-key-id
                         iam-roles
                         snapshot-cluster-identifier
                         clone-source
                         cluster-subnet-group-name
                         clone-root]}]]),
    :doc "Call restoreFromClusterSnapshot"}
   [credentials9285 & args9286]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9287
     (com.palletops.awaze.common/aws-client :redshift credentials9285)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9287
      restoreFromClusterSnapshot
      (redshift/restore-from-cluster-snapshot-request
       (clojure.core/nth args9286 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-hsm-client-certificate
   [m9288]
   (clojure.core/let
    [credentials9289 (:credentials m9288) args9290 (:args m9288)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9291
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9289)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9291
       deleteHsmClientCertificate
       (redshift/delete-hsm-client-certificate-request
        (clojure.core/nth args9290 0)))))))
  (clojure.core/defn
   delete-hsm-client-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         hsm-client-certificate-identifier
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteHsmClientCertificate"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-hsm-client-certificate,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   delete-hsm-client-certificate
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         hsm-client-certificate-identifier
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteHsmClientCertificate"}
   [credentials9293 & args9294]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9295
     (com.palletops.awaze.common/aws-client :redshift credentials9293)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9295
      deleteHsmClientCertificate
      (redshift/delete-hsm-client-certificate-request
       (clojure.core/nth args9294 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-cluster
   [m9296]
   (clojure.core/let
    [credentials9297 (:credentials m9296) args9298 (:args m9296)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9299
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9297)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9299
       createCluster
       (redshift/create-cluster-request (clojure.core/nth args9298 0)))))))
  (clojure.core/defn
   create-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-security-group-ids
                         tags
                         hsm-configuration-identifier
                         automated-snapshot-retention-period
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         cluster-parameter-group-name
                         master-username
                         elastic-ip
                         allow-version-upgrade
                         cluster-identifier
                         sdk-request-timeout
                         hsm-client-certificate-identifier
                         cluster-security-groups
                         cluster-version
                         custom-query-parameters
                         availability-zone
                         port
                         node-type
                         publicly-accessible
                         dbname
                         number-of-nodes
                         additional-info
                         read-limit
                         general-progress-listener
                         kms-key-id
                         iam-roles
                         master-user-password
                         clone-source
                         cluster-subnet-group-name
                         encrypted
                         clone-root
                         cluster-type]}]]),
    :doc "Generate map for createCluster"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-cluster,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   create-cluster
   {:arglists (quote
               [[credentials
                 {:keys [vpc-security-group-ids
                         tags
                         hsm-configuration-identifier
                         automated-snapshot-retention-period
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         cluster-parameter-group-name
                         master-username
                         elastic-ip
                         allow-version-upgrade
                         cluster-identifier
                         sdk-request-timeout
                         hsm-client-certificate-identifier
                         cluster-security-groups
                         cluster-version
                         custom-query-parameters
                         availability-zone
                         port
                         node-type
                         publicly-accessible
                         dbname
                         number-of-nodes
                         additional-info
                         read-limit
                         general-progress-listener
                         kms-key-id
                         iam-roles
                         master-user-password
                         clone-source
                         cluster-subnet-group-name
                         encrypted
                         clone-root
                         cluster-type]}]]),
    :doc "Call createCluster"}
   [credentials9301 & args9302]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9303
     (com.palletops.awaze.common/aws-client :redshift credentials9301)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9303
      createCluster
      (redshift/create-cluster-request (clojure.core/nth args9302 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-logging-status
   [m9304]
   (clojure.core/let
    [credentials9305 (:credentials m9304) args9306 (:args m9304)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9307
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9305)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9307
       describeLoggingStatus
       (redshift/describe-logging-status-request
        (clojure.core/nth args9306 0)))))))
  (clojure.core/defn
   describe-logging-status-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeLoggingStatus"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-logging-status,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-logging-status
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeLoggingStatus"}
   [credentials9309 & args9310]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9311
     (com.palletops.awaze.common/aws-client :redshift credentials9309)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9311
      describeLoggingStatus
      (redshift/describe-logging-status-request
       (clojure.core/nth args9310 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-table-restore-status
   [m9312]
   (clojure.core/let
    [credentials9313 (:credentials m9312) args9314 (:args m9312)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9315
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9313)]
     (clojure.core/case
      (clojure.core/count args9314)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9315
        describeTableRestoreStatus
        (redshift/describe-table-restore-status-request
         (clojure.core/nth args9314 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9315
        describeTableRestoreStatus))))))
  (clojure.core/defn
   describe-table-restore-status-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         table-restore-request-id]}]
                [credentials]]),
    :doc "Generate map for describeTableRestoreStatus, describeTableRestoreStatus"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-table-restore-status,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-table-restore-status,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-table-restore-status
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         table-restore-request-id]}]
                [credentials]]),
    :doc "Call describeTableRestoreStatus, describeTableRestoreStatus"}
   [credentials9317 & args9318]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9319
     (com.palletops.awaze.common/aws-client :redshift credentials9317)]
    (clojure.core/case
     (clojure.core/count args9318)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9319
       describeTableRestoreStatus
       (redshift/describe-table-restore-status-request
        (clojure.core/nth args9318 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9319
       describeTableRestoreStatus))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-event-categories
   [m9320]
   (clojure.core/let
    [credentials9321 (:credentials m9320) args9322 (:args m9320)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9323
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9321)]
     (clojure.core/case
      (clojure.core/count args9322)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9323
        describeEventCategories
        (redshift/describe-event-categories-request
         (clojure.core/nth args9322 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9323
        describeEventCategories))))))
  (clojure.core/defn
   describe-event-categories-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         source-type
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeEventCategories, describeEventCategories"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-event-categories,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-event-categories,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-event-categories
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         source-type
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeEventCategories, describeEventCategories"}
   [credentials9325 & args9326]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9327
     (com.palletops.awaze.common/aws-client :redshift credentials9325)]
    (clojure.core/case
     (clojure.core/count args9326)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9327
       describeEventCategories
       (redshift/describe-event-categories-request
        (clojure.core/nth args9326 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9327
       describeEventCategories))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-cluster-parameters
   [m9328]
   (clojure.core/let
    [credentials9329 (:credentials m9328) args9330 (:args m9328)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9331
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9329)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9331
       describeClusterParameters
       (redshift/describe-cluster-parameters-request
        (clojure.core/nth args9330 0)))))))
  (clojure.core/defn
   describe-cluster-parameters-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         parameter-group-name
                         custom-query-parameters
                         source
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeClusterParameters"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-cluster-parameters,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-cluster-parameters
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         parameter-group-name
                         custom-query-parameters
                         source
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeClusterParameters"}
   [credentials9333 & args9334]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9335
     (com.palletops.awaze.common/aws-client :redshift credentials9333)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9335
      describeClusterParameters
      (redshift/describe-cluster-parameters-request
       (clojure.core/nth args9334 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :authorize-cluster-security-group-ingress
   [m9336]
   (clojure.core/let
    [credentials9337 (:credentials m9336) args9338 (:args m9336)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9339
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9337)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9339
       authorizeClusterSecurityGroupIngress
       (redshift/authorize-cluster-security-group-ingress-request
        (clojure.core/nth args9338 0)))))))
  (clojure.core/defn
   authorize-cluster-security-group-ingress-map
   {:arglists (quote
               [[credentials
                 {:keys [cluster-security-group-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         cidrip
                         read-limit
                         general-progress-listener
                         ec2security-group-owner-id
                         clone-source
                         clone-root
                         ec2security-group-name]}]]),
    :doc "Generate map for authorizeClusterSecurityGroupIngress"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :authorize-cluster-security-group-ingress,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   authorize-cluster-security-group-ingress
   {:arglists (quote
               [[credentials
                 {:keys [cluster-security-group-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         cidrip
                         read-limit
                         general-progress-listener
                         ec2security-group-owner-id
                         clone-source
                         clone-root
                         ec2security-group-name]}]]),
    :doc "Call authorizeClusterSecurityGroupIngress"}
   [credentials9341 & args9342]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9343
     (com.palletops.awaze.common/aws-client :redshift credentials9341)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9343
      authorizeClusterSecurityGroupIngress
      (redshift/authorize-cluster-security-group-ingress-request
       (clojure.core/nth args9342 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-clusters
   [m9344]
   (clojure.core/let
    [credentials9345 (:credentials m9344) args9346 (:args m9344)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9347
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9345)]
     (clojure.core/case
      (clojure.core/count args9346)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9347
        describeClusters))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9347
        describeClusters
        (redshift/describe-clusters-request
         (clojure.core/nth args9346 0))))))))
  (clojure.core/defn
   describe-clusters-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         marker
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeClusters, describeClusters"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-clusters,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-clusters,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-clusters
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         marker
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeClusters, describeClusters"}
   [credentials9349 & args9350]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9351
     (com.palletops.awaze.common/aws-client :redshift credentials9349)]
    (clojure.core/case
     (clojure.core/count args9350)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9351
       describeClusters))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9351
       describeClusters
       (redshift/describe-clusters-request
        (clojure.core/nth args9350 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-cluster-subnet-group
   [m9352]
   (clojure.core/let
    [credentials9353 (:credentials m9352) args9354 (:args m9352)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9355
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9353)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9355
       deleteClusterSubnetGroup
       (redshift/delete-cluster-subnet-group-request
        (clojure.core/nth args9354 0)))))))
  (clojure.core/defn
   delete-cluster-subnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         cluster-subnet-group-name
                         clone-root]}]]),
    :doc "Generate map for deleteClusterSubnetGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-cluster-subnet-group,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   delete-cluster-subnet-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         cluster-subnet-group-name
                         clone-root]}]]),
    :doc "Call deleteClusterSubnetGroup"}
   [credentials9357 & args9358]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9359
     (com.palletops.awaze.common/aws-client :redshift credentials9357)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9359
      deleteClusterSubnetGroup
      (redshift/delete-cluster-subnet-group-request
       (clojure.core/nth args9358 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-cluster-security-groups
   [m9360]
   (clojure.core/let
    [credentials9361 (:credentials m9360) args9362 (:args m9360)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9363
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9361)]
     (clojure.core/case
      (clojure.core/count args9362)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9363
        describeClusterSecurityGroups
        (redshift/describe-cluster-security-groups-request
         (clojure.core/nth args9362 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9363
        describeClusterSecurityGroups))))))
  (clojure.core/defn
   describe-cluster-security-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [cluster-security-group-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeClusterSecurityGroups, describeClusterSecurityGroups"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-cluster-security-groups,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-cluster-security-groups,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-cluster-security-groups
   {:arglists (quote
               [[credentials
                 {:keys [cluster-security-group-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeClusterSecurityGroups, describeClusterSecurityGroups"}
   [credentials9365 & args9366]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9367
     (com.palletops.awaze.common/aws-client :redshift credentials9365)]
    (clojure.core/case
     (clojure.core/count args9366)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9367
       describeClusterSecurityGroups
       (redshift/describe-cluster-security-groups-request
        (clojure.core/nth args9366 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9367
       describeClusterSecurityGroups))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-tags
   [m9368]
   (clojure.core/let
    [credentials9369 (:credentials m9368) args9370 (:args m9368)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9371
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9369)]
     (clojure.core/case
      (clojure.core/count args9370)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9371
        describeTags
        (redshift/describe-tags-request (clojure.core/nth args9370 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9371
        describeTags))))))
  (clojure.core/defn
   describe-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         tag-keys
                         resource-name
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         resource-type
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeTags, describeTags"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-tags,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-tags,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-tags
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         tag-keys
                         resource-name
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         resource-type
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeTags, describeTags"}
   [credentials9373 & args9374]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9375
     (com.palletops.awaze.common/aws-client :redshift credentials9373)]
    (clojure.core/case
     (clojure.core/count args9374)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9375
       describeTags
       (redshift/describe-tags-request (clojure.core/nth args9374 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9375
       describeTags))))))
 (do
  (clojure.core/defmethod
   redshift
   :disable-snapshot-copy
   [m9376]
   (clojure.core/let
    [credentials9377 (:credentials m9376) args9378 (:args m9376)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9379
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9377)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9379
       disableSnapshotCopy
       (redshift/disable-snapshot-copy-request
        (clojure.core/nth args9378 0)))))))
  (clojure.core/defn
   disable-snapshot-copy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for disableSnapshotCopy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :disable-snapshot-copy,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   disable-snapshot-copy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call disableSnapshotCopy"}
   [credentials9381 & args9382]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9383
     (com.palletops.awaze.common/aws-client :redshift credentials9381)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9383
      disableSnapshotCopy
      (redshift/disable-snapshot-copy-request
       (clojure.core/nth args9382 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-tags
   [m9384]
   (clojure.core/let
    [credentials9385 (:credentials m9384) args9386 (:args m9384)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9387
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9385)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9387
       deleteTags
       (redshift/delete-tags-request (clojure.core/nth args9386 0)))))))
  (clojure.core/defn
   delete-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         tag-keys
                         resource-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteTags"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-tags,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   delete-tags
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         tag-keys
                         resource-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteTags"}
   [credentials9389 & args9390]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9391
     (com.palletops.awaze.common/aws-client :redshift credentials9389)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9391
      deleteTags
      (redshift/delete-tags-request (clojure.core/nth args9390 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :purchase-reserved-node-offering
   [m9392]
   (clojure.core/let
    [credentials9393 (:credentials m9392) args9394 (:args m9392)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9395
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9393)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9395
       purchaseReservedNodeOffering
       (redshift/purchase-reserved-node-offering-request
        (clojure.core/nth args9394 0)))))))
  (clojure.core/defn
   purchase-reserved-node-offering-map
   {:arglists (quote
               [[credentials
                 {:keys [node-count
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         reserved-node-offering-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for purchaseReservedNodeOffering"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :purchase-reserved-node-offering,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   purchase-reserved-node-offering
   {:arglists (quote
               [[credentials
                 {:keys [node-count
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         reserved-node-offering-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call purchaseReservedNodeOffering"}
   [credentials9397 & args9398]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9399
     (com.palletops.awaze.common/aws-client :redshift credentials9397)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9399
      purchaseReservedNodeOffering
      (redshift/purchase-reserved-node-offering-request
       (clojure.core/nth args9398 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-cluster-snapshot
   [m9400]
   (clojure.core/let
    [credentials9401 (:credentials m9400) args9402 (:args m9400)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9403
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9401)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9403
       deleteClusterSnapshot
       (redshift/delete-cluster-snapshot-request
        (clojure.core/nth args9402 0)))))))
  (clojure.core/defn
   delete-cluster-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         snapshot-identifier
                         read-limit
                         general-progress-listener
                         snapshot-cluster-identifier
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteClusterSnapshot"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-cluster-snapshot,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   delete-cluster-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         snapshot-identifier
                         read-limit
                         general-progress-listener
                         snapshot-cluster-identifier
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteClusterSnapshot"}
   [credentials9405 & args9406]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9407
     (com.palletops.awaze.common/aws-client :redshift credentials9405)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9407
      deleteClusterSnapshot
      (redshift/delete-cluster-snapshot-request
       (clojure.core/nth args9406 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-cluster-parameter-group
   [m9408]
   (clojure.core/let
    [credentials9409 (:credentials m9408) args9410 (:args m9408)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9411
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9409)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9411
       createClusterParameterGroup
       (redshift/create-cluster-parameter-group-request
        (clojure.core/nth args9410 0)))))))
  (clojure.core/defn
   create-cluster-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         parameter-group-name
                         custom-query-parameters
                         parameter-group-family
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createClusterParameterGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-cluster-parameter-group,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   create-cluster-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         parameter-group-name
                         custom-query-parameters
                         parameter-group-family
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createClusterParameterGroup"}
   [credentials9413 & args9414]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9415
     (com.palletops.awaze.common/aws-client :redshift credentials9413)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9415
      createClusterParameterGroup
      (redshift/create-cluster-parameter-group-request
       (clojure.core/nth args9414 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :rotate-encryption-key
   [m9416]
   (clojure.core/let
    [credentials9417 (:credentials m9416) args9418 (:args m9416)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9419
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9417)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9419
       rotateEncryptionKey
       (redshift/rotate-encryption-key-request
        (clojure.core/nth args9418 0)))))))
  (clojure.core/defn
   rotate-encryption-key-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for rotateEncryptionKey"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :rotate-encryption-key,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   rotate-encryption-key
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call rotateEncryptionKey"}
   [credentials9421 & args9422]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9423
     (com.palletops.awaze.common/aws-client :redshift credentials9421)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9423
      rotateEncryptionKey
      (redshift/rotate-encryption-key-request
       (clojure.core/nth args9422 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-hsm-client-certificates
   [m9424]
   (clojure.core/let
    [credentials9425 (:credentials m9424) args9426 (:args m9424)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9427
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9425)]
     (clojure.core/case
      (clojure.core/count args9426)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9427
        describeHsmClientCertificates))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9427
        describeHsmClientCertificates
        (redshift/describe-hsm-client-certificates-request
         (clojure.core/nth args9426 0))))))))
  (clojure.core/defn
   describe-hsm-client-certificates-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         hsm-client-certificate-identifier
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeHsmClientCertificates, describeHsmClientCertificates"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-hsm-client-certificates,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-hsm-client-certificates,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-hsm-client-certificates
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         hsm-client-certificate-identifier
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeHsmClientCertificates, describeHsmClientCertificates"}
   [credentials9429 & args9430]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9431
     (com.palletops.awaze.common/aws-client :redshift credentials9429)]
    (clojure.core/case
     (clojure.core/count args9430)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9431
       describeHsmClientCertificates))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9431
       describeHsmClientCertificates
       (redshift/describe-hsm-client-certificates-request
        (clojure.core/nth args9430 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-snapshot-copy-grants
   [m9432]
   (clojure.core/let
    [credentials9433 (:credentials m9432) args9434 (:args m9432)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9435
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9433)]
     (clojure.core/case
      (clojure.core/count args9434)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9435
        describeSnapshotCopyGrants))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9435
        describeSnapshotCopyGrants
        (redshift/describe-snapshot-copy-grants-request
         (clojure.core/nth args9434 0))))))))
  (clojure.core/defn
   describe-snapshot-copy-grants-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         snapshot-copy-grant-name
                         clone-root]}]]),
    :doc "Generate map for describeSnapshotCopyGrants, describeSnapshotCopyGrants"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-snapshot-copy-grants,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-snapshot-copy-grants,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-snapshot-copy-grants
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         snapshot-copy-grant-name
                         clone-root]}]]),
    :doc "Call describeSnapshotCopyGrants, describeSnapshotCopyGrants"}
   [credentials9437 & args9438]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9439
     (com.palletops.awaze.common/aws-client :redshift credentials9437)]
    (clojure.core/case
     (clojure.core/count args9438)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9439
       describeSnapshotCopyGrants))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9439
       describeSnapshotCopyGrants
       (redshift/describe-snapshot-copy-grants-request
        (clojure.core/nth args9438 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :reset-cluster-parameter-group
   [m9440]
   (clojure.core/let
    [credentials9441 (:credentials m9440) args9442 (:args m9440)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9443
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9441)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9443
       resetClusterParameterGroup
       (redshift/reset-cluster-parameter-group-request
        (clojure.core/nth args9442 0)))))))
  (clojure.core/defn
   reset-cluster-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         parameter-group-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         reset-all-parameters
                         parameters
                         clone-root]}]]),
    :doc "Generate map for resetClusterParameterGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :reset-cluster-parameter-group,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   reset-cluster-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         parameter-group-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         reset-all-parameters
                         parameters
                         clone-root]}]]),
    :doc "Call resetClusterParameterGroup"}
   [credentials9445 & args9446]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9447
     (com.palletops.awaze.common/aws-client :redshift credentials9445)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9447
      resetClusterParameterGroup
      (redshift/reset-cluster-parameter-group-request
       (clojure.core/nth args9446 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-cluster-security-group
   [m9448]
   (clojure.core/let
    [credentials9449 (:credentials m9448) args9450 (:args m9448)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9451
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9449)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9451
       deleteClusterSecurityGroup
       (redshift/delete-cluster-security-group-request
        (clojure.core/nth args9450 0)))))))
  (clojure.core/defn
   delete-cluster-security-group-map
   {:arglists (quote
               [[credentials
                 {:keys [cluster-security-group-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteClusterSecurityGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-cluster-security-group,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   delete-cluster-security-group
   {:arglists (quote
               [[credentials
                 {:keys [cluster-security-group-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteClusterSecurityGroup"}
   [credentials9453 & args9454]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9455
     (com.palletops.awaze.common/aws-client :redshift credentials9453)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9455
      deleteClusterSecurityGroup
      (redshift/delete-cluster-security-group-request
       (clojure.core/nth args9454 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :copy-cluster-snapshot
   [m9456]
   (clojure.core/let
    [credentials9457 (:credentials m9456) args9458 (:args m9456)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9459
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9457)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9459
       copyClusterSnapshot
       (redshift/copy-cluster-snapshot-request
        (clojure.core/nth args9458 0)))))))
  (clojure.core/defn
   copy-cluster-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         source-snapshot-identifier
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         source-snapshot-cluster-identifier
                         clone-source
                         target-snapshot-identifier
                         clone-root]}]]),
    :doc "Generate map for copyClusterSnapshot"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :copy-cluster-snapshot,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   copy-cluster-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         source-snapshot-identifier
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         source-snapshot-cluster-identifier
                         clone-source
                         target-snapshot-identifier
                         clone-root]}]]),
    :doc "Call copyClusterSnapshot"}
   [credentials9461 & args9462]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9463
     (com.palletops.awaze.common/aws-client :redshift credentials9461)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9463
      copyClusterSnapshot
      (redshift/copy-cluster-snapshot-request
       (clojure.core/nth args9462 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :restore-table-from-cluster-snapshot
   [m9464]
   (clojure.core/let
    [credentials9465 (:credentials m9464) args9466 (:args m9464)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9467
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9465)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9467
       restoreTableFromClusterSnapshot
       (redshift/restore-table-from-cluster-snapshot-request
        (clojure.core/nth args9466 0)))))))
  (clojure.core/defn
   restore-table-from-cluster-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         target-schema-name
                         cluster-identifier
                         source-schema-name
                         sdk-request-timeout
                         source-database-name
                         source-table-name
                         custom-query-parameters
                         new-table-name
                         snapshot-identifier
                         read-limit
                         general-progress-listener
                         clone-source
                         target-database-name
                         clone-root]}]]),
    :doc "Generate map for restoreTableFromClusterSnapshot"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :restore-table-from-cluster-snapshot,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   restore-table-from-cluster-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         target-schema-name
                         cluster-identifier
                         source-schema-name
                         sdk-request-timeout
                         source-database-name
                         source-table-name
                         custom-query-parameters
                         new-table-name
                         snapshot-identifier
                         read-limit
                         general-progress-listener
                         clone-source
                         target-database-name
                         clone-root]}]]),
    :doc "Call restoreTableFromClusterSnapshot"}
   [credentials9469 & args9470]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9471
     (com.palletops.awaze.common/aws-client :redshift credentials9469)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9471
      restoreTableFromClusterSnapshot
      (redshift/restore-table-from-cluster-snapshot-request
       (clojure.core/nth args9470 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :modify-event-subscription
   [m9472]
   (clojure.core/let
    [credentials9473 (:credentials m9472) args9474 (:args m9472)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9475
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9473)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9475
       modifyEventSubscription
       (redshift/modify-event-subscription-request
        (clojure.core/nth args9474 0)))))))
  (clojure.core/defn
   modify-event-subscription-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subscription-name
                         sdk-request-timeout
                         source-type
                         custom-query-parameters
                         source-ids
                         read-limit
                         general-progress-listener
                         severity
                         event-categories
                         clone-source
                         sns-topic-arn
                         enabled
                         clone-root]}]]),
    :doc "Generate map for modifyEventSubscription"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-event-subscription,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   modify-event-subscription
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subscription-name
                         sdk-request-timeout
                         source-type
                         custom-query-parameters
                         source-ids
                         read-limit
                         general-progress-listener
                         severity
                         event-categories
                         clone-source
                         sns-topic-arn
                         enabled
                         clone-root]}]]),
    :doc "Call modifyEventSubscription"}
   [credentials9477 & args9478]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9479
     (com.palletops.awaze.common/aws-client :redshift credentials9477)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9479
      modifyEventSubscription
      (redshift/modify-event-subscription-request
       (clojure.core/nth args9478 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-hsm-configuration
   [m9480]
   (clojure.core/let
    [credentials9481 (:credentials m9480) args9482 (:args m9480)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9483
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9481)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9483
       createHsmConfiguration
       (redshift/create-hsm-configuration-request
        (clojure.core/nth args9482 0)))))))
  (clojure.core/defn
   create-hsm-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         hsm-configuration-identifier
                         custom-request-headers
                         sdk-client-execution-timeout
                         hsm-partition-password
                         sdk-request-timeout
                         hsm-ip-address
                         custom-query-parameters
                         hsm-partition-name
                         read-limit
                         hsm-server-public-certificate
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createHsmConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-hsm-configuration,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   create-hsm-configuration
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         hsm-configuration-identifier
                         custom-request-headers
                         sdk-client-execution-timeout
                         hsm-partition-password
                         sdk-request-timeout
                         hsm-ip-address
                         custom-query-parameters
                         hsm-partition-name
                         read-limit
                         hsm-server-public-certificate
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createHsmConfiguration"}
   [credentials9485 & args9486]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9487
     (com.palletops.awaze.common/aws-client :redshift credentials9485)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9487
      createHsmConfiguration
      (redshift/create-hsm-configuration-request
       (clojure.core/nth args9486 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-hsm-configurations
   [m9488]
   (clojure.core/let
    [credentials9489 (:credentials m9488) args9490 (:args m9488)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9491
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9489)]
     (clojure.core/case
      (clojure.core/count args9490)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9491
        describeHsmConfigurations
        (redshift/describe-hsm-configurations-request
         (clojure.core/nth args9490 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9491
        describeHsmConfigurations))))))
  (clojure.core/defn
   describe-hsm-configurations-map
   {:arglists (quote
               [[credentials
                 {:keys [hsm-configuration-identifier
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeHsmConfigurations, describeHsmConfigurations"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-hsm-configurations,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-hsm-configurations,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-hsm-configurations
   {:arglists (quote
               [[credentials
                 {:keys [hsm-configuration-identifier
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeHsmConfigurations, describeHsmConfigurations"}
   [credentials9493 & args9494]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9495
     (com.palletops.awaze.common/aws-client :redshift credentials9493)]
    (clojure.core/case
     (clojure.core/count args9494)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9495
       describeHsmConfigurations
       (redshift/describe-hsm-configurations-request
        (clojure.core/nth args9494 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9495
       describeHsmConfigurations))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-cluster-subnet-groups
   [m9496]
   (clojure.core/let
    [credentials9497 (:credentials m9496) args9498 (:args m9496)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9499
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9497)]
     (clojure.core/case
      (clojure.core/count args9498)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9499
        describeClusterSubnetGroups
        (redshift/describe-cluster-subnet-groups-request
         (clojure.core/nth args9498 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9499
        describeClusterSubnetGroups))))))
  (clojure.core/defn
   describe-cluster-subnet-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         cluster-subnet-group-name
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeClusterSubnetGroups, describeClusterSubnetGroups"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-cluster-subnet-groups,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-cluster-subnet-groups,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-cluster-subnet-groups
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         cluster-subnet-group-name
                         clone-root]}]
                [credentials]]),
    :doc "Call describeClusterSubnetGroups, describeClusterSubnetGroups"}
   [credentials9501 & args9502]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9503
     (com.palletops.awaze.common/aws-client :redshift credentials9501)]
    (clojure.core/case
     (clojure.core/count args9502)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9503
       describeClusterSubnetGroups
       (redshift/describe-cluster-subnet-groups-request
        (clojure.core/nth args9502 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9503
       describeClusterSubnetGroups))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-cluster
   [m9504]
   (clojure.core/let
    [credentials9505 (:credentials m9504) args9506 (:args m9504)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9507
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9505)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9507
       deleteCluster
       (redshift/delete-cluster-request (clojure.core/nth args9506 0)))))))
  (clojure.core/defn
   delete-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         final-cluster-snapshot-identifier
                         read-limit
                         skip-final-cluster-snapshot
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteCluster"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-cluster,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   delete-cluster
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         final-cluster-snapshot-identifier
                         read-limit
                         skip-final-cluster-snapshot
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteCluster"}
   [credentials9509 & args9510]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9511
     (com.palletops.awaze.common/aws-client :redshift credentials9509)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9511
      deleteCluster
      (redshift/delete-cluster-request (clojure.core/nth args9510 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :revoke-cluster-security-group-ingress
   [m9512]
   (clojure.core/let
    [credentials9513 (:credentials m9512) args9514 (:args m9512)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9515
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9513)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9515
       revokeClusterSecurityGroupIngress
       (redshift/revoke-cluster-security-group-ingress-request
        (clojure.core/nth args9514 0)))))))
  (clojure.core/defn
   revoke-cluster-security-group-ingress-map
   {:arglists (quote
               [[credentials
                 {:keys [cluster-security-group-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         cidrip
                         read-limit
                         general-progress-listener
                         ec2security-group-owner-id
                         clone-source
                         clone-root
                         ec2security-group-name]}]]),
    :doc "Generate map for revokeClusterSecurityGroupIngress"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :revoke-cluster-security-group-ingress,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   revoke-cluster-security-group-ingress
   {:arglists (quote
               [[credentials
                 {:keys [cluster-security-group-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         cidrip
                         read-limit
                         general-progress-listener
                         ec2security-group-owner-id
                         clone-source
                         clone-root
                         ec2security-group-name]}]]),
    :doc "Call revokeClusterSecurityGroupIngress"}
   [credentials9517 & args9518]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9519
     (com.palletops.awaze.common/aws-client :redshift credentials9517)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9519
      revokeClusterSecurityGroupIngress
      (redshift/revoke-cluster-security-group-ingress-request
       (clojure.core/nth args9518 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-cluster-subnet-group
   [m9520]
   (clojure.core/let
    [credentials9521 (:credentials m9520) args9522 (:args m9520)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9523
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9521)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9523
       createClusterSubnetGroup
       (redshift/create-cluster-subnet-group-request
        (clojure.core/nth args9522 0)))))))
  (clojure.core/defn
   create-cluster-subnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         subnet-ids
                         general-progress-listener
                         clone-source
                         cluster-subnet-group-name
                         clone-root]}]]),
    :doc "Generate map for createClusterSubnetGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-cluster-subnet-group,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   create-cluster-subnet-group
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         subnet-ids
                         general-progress-listener
                         clone-source
                         cluster-subnet-group-name
                         clone-root]}]]),
    :doc "Call createClusterSubnetGroup"}
   [credentials9525 & args9526]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9527
     (com.palletops.awaze.common/aws-client :redshift credentials9525)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9527
      createClusterSubnetGroup
      (redshift/create-cluster-subnet-group-request
       (clojure.core/nth args9526 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-cluster-snapshot
   [m9528]
   (clojure.core/let
    [credentials9529 (:credentials m9528) args9530 (:args m9528)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9531
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9529)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9531
       createClusterSnapshot
       (redshift/create-cluster-snapshot-request
        (clojure.core/nth args9530 0)))))))
  (clojure.core/defn
   create-cluster-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         snapshot-identifier
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createClusterSnapshot"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-cluster-snapshot,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   create-cluster-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         snapshot-identifier
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createClusterSnapshot"}
   [credentials9533 & args9534]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9535
     (com.palletops.awaze.common/aws-client :redshift credentials9533)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9535
      createClusterSnapshot
      (redshift/create-cluster-snapshot-request
       (clojure.core/nth args9534 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-tags
   [m9536]
   (clojure.core/let
    [credentials9537 (:credentials m9536) args9538 (:args m9536)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9539
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9537)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9539
       createTags
       (redshift/create-tags-request (clojure.core/nth args9538 0)))))))
  (clojure.core/defn
   create-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         resource-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createTags"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-tags,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   create-tags
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         resource-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createTags"}
   [credentials9541 & args9542]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9543
     (com.palletops.awaze.common/aws-client :redshift credentials9541)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9543
      createTags
      (redshift/create-tags-request (clojure.core/nth args9542 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-orderable-cluster-options
   [m9544]
   (clojure.core/let
    [credentials9545 (:credentials m9544) args9546 (:args m9544)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9547
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9545)]
     (clojure.core/case
      (clojure.core/count args9546)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9547
        describeOrderableClusterOptions))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9547
        describeOrderableClusterOptions
        (redshift/describe-orderable-cluster-options-request
         (clojure.core/nth args9546 0))))))))
  (clojure.core/defn
   describe-orderable-cluster-options-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         cluster-version
                         custom-query-parameters
                         node-type
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeOrderableClusterOptions, describeOrderableClusterOptions"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-orderable-cluster-options,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-orderable-cluster-options,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-orderable-cluster-options
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         cluster-version
                         custom-query-parameters
                         node-type
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeOrderableClusterOptions, describeOrderableClusterOptions"}
   [credentials9549 & args9550]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9551
     (com.palletops.awaze.common/aws-client :redshift credentials9549)]
    (clojure.core/case
     (clojure.core/count args9550)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9551
       describeOrderableClusterOptions))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9551
       describeOrderableClusterOptions
       (redshift/describe-orderable-cluster-options-request
        (clojure.core/nth args9550 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :enable-logging
   [m9552]
   (clojure.core/let
    [credentials9553 (:credentials m9552) args9554 (:args m9552)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9555
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9553)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9555
       enableLogging
       (redshift/enable-logging-request (clojure.core/nth args9554 0)))))))
  (clojure.core/defn
   enable-logging-map
   {:arglists (quote
               [[credentials
                 {:keys [s3key-prefix
                         custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for enableLogging"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :enable-logging,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   enable-logging
   {:arglists (quote
               [[credentials
                 {:keys [s3key-prefix
                         custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Call enableLogging"}
   [credentials9557 & args9558]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9559
     (com.palletops.awaze.common/aws-client :redshift credentials9557)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9559
      enableLogging
      (redshift/enable-logging-request (clojure.core/nth args9558 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :revoke-snapshot-access
   [m9560]
   (clojure.core/let
    [credentials9561 (:credentials m9560) args9562 (:args m9560)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9563
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9561)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9563
       revokeSnapshotAccess
       (redshift/revoke-snapshot-access-request
        (clojure.core/nth args9562 0)))))))
  (clojure.core/defn
   revoke-snapshot-access-map
   {:arglists (quote
               [[credentials
                 {:keys [account-with-restore-access
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         snapshot-identifier
                         read-limit
                         general-progress-listener
                         snapshot-cluster-identifier
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for revokeSnapshotAccess"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :revoke-snapshot-access,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   revoke-snapshot-access
   {:arglists (quote
               [[credentials
                 {:keys [account-with-restore-access
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         snapshot-identifier
                         read-limit
                         general-progress-listener
                         snapshot-cluster-identifier
                         clone-source
                         clone-root]}]]),
    :doc "Call revokeSnapshotAccess"}
   [credentials9565 & args9566]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9567
     (com.palletops.awaze.common/aws-client :redshift credentials9565)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9567
      revokeSnapshotAccess
      (redshift/revoke-snapshot-access-request
       (clojure.core/nth args9566 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-event-subscriptions
   [m9568]
   (clojure.core/let
    [credentials9569 (:credentials m9568) args9570 (:args m9568)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9571
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9569)]
     (clojure.core/case
      (clojure.core/count args9570)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9571
        describeEventSubscriptions))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9571
        describeEventSubscriptions
        (redshift/describe-event-subscriptions-request
         (clojure.core/nth args9570 0))))))))
  (clojure.core/defn
   describe-event-subscriptions-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subscription-name
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeEventSubscriptions, describeEventSubscriptions"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-event-subscriptions,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-event-subscriptions,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-event-subscriptions
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subscription-name
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeEventSubscriptions, describeEventSubscriptions"}
   [credentials9573 & args9574]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9575
     (com.palletops.awaze.common/aws-client :redshift credentials9573)]
    (clojure.core/case
     (clojure.core/count args9574)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9575
       describeEventSubscriptions))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9575
       describeEventSubscriptions
       (redshift/describe-event-subscriptions-request
        (clojure.core/nth args9574 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-reserved-node-offerings
   [m9576]
   (clojure.core/let
    [credentials9577 (:credentials m9576) args9578 (:args m9576)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9579
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9577)]
     (clojure.core/case
      (clojure.core/count args9578)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9579
        describeReservedNodeOfferings))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9579
        describeReservedNodeOfferings
        (redshift/describe-reserved-node-offerings-request
         (clojure.core/nth args9578 0))))))))
  (clojure.core/defn
   describe-reserved-node-offerings-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         reserved-node-offering-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeReservedNodeOfferings, describeReservedNodeOfferings"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-reserved-node-offerings,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-reserved-node-offerings,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-reserved-node-offerings
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         reserved-node-offering-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeReservedNodeOfferings, describeReservedNodeOfferings"}
   [credentials9581 & args9582]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9583
     (com.palletops.awaze.common/aws-client :redshift credentials9581)]
    (clojure.core/case
     (clojure.core/count args9582)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9583
       describeReservedNodeOfferings))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9583
       describeReservedNodeOfferings
       (redshift/describe-reserved-node-offerings-request
        (clojure.core/nth args9582 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-hsm-configuration
   [m9584]
   (clojure.core/let
    [credentials9585 (:credentials m9584) args9586 (:args m9584)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9587
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9585)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9587
       deleteHsmConfiguration
       (redshift/delete-hsm-configuration-request
        (clojure.core/nth args9586 0)))))))
  (clojure.core/defn
   delete-hsm-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [hsm-configuration-identifier
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteHsmConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-hsm-configuration,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   delete-hsm-configuration
   {:arglists (quote
               [[credentials
                 {:keys [hsm-configuration-identifier
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteHsmConfiguration"}
   [credentials9589 & args9590]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9591
     (com.palletops.awaze.common/aws-client :redshift credentials9589)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9591
      deleteHsmConfiguration
      (redshift/delete-hsm-configuration-request
       (clojure.core/nth args9590 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-event-subscription
   [m9592]
   (clojure.core/let
    [credentials9593 (:credentials m9592) args9594 (:args m9592)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9595
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9593)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9595
       createEventSubscription
       (redshift/create-event-subscription-request
        (clojure.core/nth args9594 0)))))))
  (clojure.core/defn
   create-event-subscription-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         subscription-name
                         sdk-request-timeout
                         source-type
                         custom-query-parameters
                         source-ids
                         read-limit
                         general-progress-listener
                         severity
                         event-categories
                         clone-source
                         sns-topic-arn
                         enabled
                         clone-root]}]]),
    :doc "Generate map for createEventSubscription"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-event-subscription,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   create-event-subscription
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         subscription-name
                         sdk-request-timeout
                         source-type
                         custom-query-parameters
                         source-ids
                         read-limit
                         general-progress-listener
                         severity
                         event-categories
                         clone-source
                         sns-topic-arn
                         enabled
                         clone-root]}]]),
    :doc "Call createEventSubscription"}
   [credentials9597 & args9598]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9599
     (com.palletops.awaze.common/aws-client :redshift credentials9597)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9599
      createEventSubscription
      (redshift/create-event-subscription-request
       (clojure.core/nth args9598 0))))))))
