(ns
 com.palletops.awaze.iam
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.iam :as iam]
  [com.palletops.awaze.beans.identitymanagement
   :as
   identitymanagement]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :iam
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient
   credentials__1792__auto__))
 (clojure.core/defmulti
  iam
  (clojure.core/fn iam [m__1874__auto__] (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   iam
   :list-groups-for-user
   [m12328]
   (clojure.core/let
    [credentials12329 (:credentials m12328) args12330 (:args m12328)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12331
      (com.palletops.awaze.common/aws-client :iam credentials12329)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12331
       listGroupsForUser
       (identitymanagement/list-groups-for-user-request
        (clojure.core/nth args12330 0)))))))
  (clojure.core/defn
   list-groups-for-user-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listGroupsForUser"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-groups-for-user,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-groups-for-user
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listGroupsForUser"}
   [credentials12333 & args12334]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12335
     (com.palletops.awaze.common/aws-client :iam credentials12333)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12335
      listGroupsForUser
      (identitymanagement/list-groups-for-user-request
       (clojure.core/nth args12334 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-user
   [m12336]
   (clojure.core/let
    [credentials12337 (:credentials m12336) args12338 (:args m12336)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12339
      (com.palletops.awaze.common/aws-client :iam credentials12337)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12339
       createUser
       (identitymanagement/create-user-request
        (clojure.core/nth args12338 0)))))))
  (clojure.core/defn
   create-user-map
   {:arglists (quote
               [[credentials
                 {:keys [path
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createUser"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-user,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   create-user
   {:arglists (quote
               [[credentials
                 {:keys [path
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createUser"}
   [credentials12341 & args12342]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12343
     (com.palletops.awaze.common/aws-client :iam credentials12341)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12343
      createUser
      (identitymanagement/create-user-request
       (clojure.core/nth args12342 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-credential-report
   [m12344]
   (clojure.core/let
    [credentials12345 (:credentials m12344) args12346 (:args m12344)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12347
      (com.palletops.awaze.common/aws-client :iam credentials12345)]
     (clojure.core/case
      (clojure.core/count args12346)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12347
        getCredentialReport
        (identitymanagement/get-credential-report-request
         (clojure.core/nth args12346 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12347
        getCredentialReport))))))
  (clojure.core/defn
   get-credential-report-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for getCredentialReport, getCredentialReport"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-credential-report,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-credential-report,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-credential-report
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call getCredentialReport, getCredentialReport"}
   [credentials12349 & args12350]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12351
     (com.palletops.awaze.common/aws-client :iam credentials12349)]
    (clojure.core/case
     (clojure.core/count args12350)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12351
       getCredentialReport
       (identitymanagement/get-credential-report-request
        (clojure.core/nth args12350 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12351
       getCredentialReport))))))
 (do
  (clojure.core/defmethod
   iam
   :get-open-idconnect-provider
   [m12352]
   (clojure.core/let
    [credentials12353 (:credentials m12352) args12354 (:args m12352)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12355
      (com.palletops.awaze.common/aws-client :iam credentials12353)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12355
       getOpenIDConnectProvider
       (identitymanagement/get-open-idconnect-provider-request
        (clojure.core/nth args12354 0)))))))
  (clojure.core/defn
   get-open-idconnect-provider-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         open-idconnect-provider-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getOpenIDConnectProvider"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-open-idconnect-provider,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-open-idconnect-provider
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         open-idconnect-provider-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getOpenIDConnectProvider"}
   [credentials12357 & args12358]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12359
     (com.palletops.awaze.common/aws-client :iam credentials12357)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12359
      getOpenIDConnectProvider
      (identitymanagement/get-open-idconnect-provider-request
       (clojure.core/nth args12358 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-signing-certificate
   [m12360]
   (clojure.core/let
    [credentials12361 (:credentials m12360) args12362 (:args m12360)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12363
      (com.palletops.awaze.common/aws-client :iam credentials12361)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12363
       deleteSigningCertificate
       (identitymanagement/delete-signing-certificate-request
        (clojure.core/nth args12362 0)))))))
  (clojure.core/defn
   delete-signing-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         certificate-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteSigningCertificate"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-signing-certificate,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-signing-certificate
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         certificate-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteSigningCertificate"}
   [credentials12365 & args12366]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12367
     (com.palletops.awaze.common/aws-client :iam credentials12365)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12367
      deleteSigningCertificate
      (identitymanagement/delete-signing-certificate-request
       (clojure.core/nth args12366 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :change-password
   [m12368]
   (clojure.core/let
    [credentials12369 (:credentials m12368) args12370 (:args m12368)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12371
      (com.palletops.awaze.common/aws-client :iam credentials12369)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12371
       changePassword
       (identitymanagement/change-password-request
        (clojure.core/nth args12370 0)))))))
  (clojure.core/defn
   change-password-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         old-password
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         new-password]}]]),
    :doc "Generate map for changePassword"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :change-password,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   change-password
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         old-password
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         new-password]}]]),
    :doc "Call changePassword"}
   [credentials12373 & args12374]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12375
     (com.palletops.awaze.common/aws-client :iam credentials12373)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12375
      changePassword
      (identitymanagement/change-password-request
       (clojure.core/nth args12374 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-instance-profiles-for-role
   [m12376]
   (clojure.core/let
    [credentials12377 (:credentials m12376) args12378 (:args m12376)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12379
      (com.palletops.awaze.common/aws-client :iam credentials12377)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12379
       listInstanceProfilesForRole
       (identitymanagement/list-instance-profiles-for-role-request
        (clojure.core/nth args12378 0)))))))
  (clojure.core/defn
   list-instance-profiles-for-role-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listInstanceProfilesForRole"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-instance-profiles-for-role,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-instance-profiles-for-role
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listInstanceProfilesForRole"}
   [credentials12381 & args12382]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12383
     (com.palletops.awaze.common/aws-client :iam credentials12381)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12383
      listInstanceProfilesForRole
      (identitymanagement/list-instance-profiles-for-role-request
       (clojure.core/nth args12382 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-instance-profiles
   [m12384]
   (clojure.core/let
    [credentials12385 (:credentials m12384) args12386 (:args m12384)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12387
      (com.palletops.awaze.common/aws-client :iam credentials12385)]
     (clojure.core/case
      (clojure.core/count args12386)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12387
        listInstanceProfiles))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12387
        listInstanceProfiles
        (identitymanagement/list-instance-profiles-request
         (clojure.core/nth args12386 0))))))))
  (clojure.core/defn
   list-instance-profiles-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listInstanceProfiles, listInstanceProfiles"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-instance-profiles,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-instance-profiles,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-instance-profiles
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listInstanceProfiles, listInstanceProfiles"}
   [credentials12389 & args12390]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12391
     (com.palletops.awaze.common/aws-client :iam credentials12389)]
    (clojure.core/case
     (clojure.core/count args12390)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12391
       listInstanceProfiles))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12391
       listInstanceProfiles
       (identitymanagement/list-instance-profiles-request
        (clojure.core/nth args12390 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :set-default-policy-version
   [m12392]
   (clojure.core/let
    [credentials12393 (:credentials m12392) args12394 (:args m12392)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12395
      (com.palletops.awaze.common/aws-client :iam credentials12393)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12395
       setDefaultPolicyVersion
       (identitymanagement/set-default-policy-version-request
        (clojure.core/nth args12394 0)))))))
  (clojure.core/defn
   set-default-policy-version-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setDefaultPolicyVersion"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-default-policy-version,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   set-default-policy-version
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call setDefaultPolicyVersion"}
   [credentials12397 & args12398]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12399
     (com.palletops.awaze.common/aws-client :iam credentials12397)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12399
      setDefaultPolicyVersion
      (identitymanagement/set-default-policy-version-request
       (clojure.core/nth args12398 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-user-policy
   [m12400]
   (clojure.core/let
    [credentials12401 (:credentials m12400) args12402 (:args m12400)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12403
      (com.palletops.awaze.common/aws-client :iam credentials12401)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12403
       deleteUserPolicy
       (identitymanagement/delete-user-policy-request
        (clojure.core/nth args12402 0)))))))
  (clojure.core/defn
   delete-user-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteUserPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-user-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-user-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteUserPolicy"}
   [credentials12405 & args12406]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12407
     (com.palletops.awaze.common/aws-client :iam credentials12405)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12407
      deleteUserPolicy
      (identitymanagement/delete-user-policy-request
       (clojure.core/nth args12406 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-access-key-last-used
   [m12408]
   (clojure.core/let
    [credentials12409 (:credentials m12408) args12410 (:args m12408)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12411
      (com.palletops.awaze.common/aws-client :iam credentials12409)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12411
       getAccessKeyLastUsed
       (identitymanagement/get-access-key-last-used-request
        (clojure.core/nth args12410 0)))))))
  (clojure.core/defn
   get-access-key-last-used-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         access-key-id
                         clone-root]}]]),
    :doc "Generate map for getAccessKeyLastUsed"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-access-key-last-used,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-access-key-last-used
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         access-key-id
                         clone-root]}]]),
    :doc "Call getAccessKeyLastUsed"}
   [credentials12413 & args12414]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12415
     (com.palletops.awaze.common/aws-client :iam credentials12413)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12415
      getAccessKeyLastUsed
      (identitymanagement/get-access-key-last-used-request
       (clojure.core/nth args12414 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :attach-group-policy
   [m12416]
   (clojure.core/let
    [credentials12417 (:credentials m12416) args12418 (:args m12416)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12419
      (com.palletops.awaze.common/aws-client :iam credentials12417)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12419
       attachGroupPolicy
       (identitymanagement/attach-group-policy-request
        (clojure.core/nth args12418 0)))))))
  (clojure.core/defn
   attach-group-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for attachGroupPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :attach-group-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   attach-group-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call attachGroupPolicy"}
   [credentials12421 & args12422]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12423
     (com.palletops.awaze.common/aws-client :iam credentials12421)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12423
      attachGroupPolicy
      (identitymanagement/attach-group-policy-request
       (clojure.core/nth args12422 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-user
   [m12424]
   (clojure.core/let
    [credentials12425 (:credentials m12424) args12426 (:args m12424)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12427
      (com.palletops.awaze.common/aws-client :iam credentials12425)]
     (clojure.core/case
      (clojure.core/count args12426)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12427
        getUser
        (identitymanagement/get-user-request
         (clojure.core/nth args12426 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12427
        getUser))))))
  (clojure.core/defn
   get-user-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for getUser, getUser"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-user,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-user,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-user
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call getUser, getUser"}
   [credentials12429 & args12430]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12431
     (com.palletops.awaze.common/aws-client :iam credentials12429)]
    (clojure.core/case
     (clojure.core/count args12430)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12431
       getUser
       (identitymanagement/get-user-request
        (clojure.core/nth args12430 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12431
       getUser))))))
 (do
  (clojure.core/defmethod
   iam
   :generate-credential-report
   [m12432]
   (clojure.core/let
    [credentials12433 (:credentials m12432) args12434 (:args m12432)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12435
      (com.palletops.awaze.common/aws-client :iam credentials12433)]
     (clojure.core/case
      (clojure.core/count args12434)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12435
        generateCredentialReport
        (identitymanagement/generate-credential-report-request
         (clojure.core/nth args12434 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12435
        generateCredentialReport))))))
  (clojure.core/defn
   generate-credential-report-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for generateCredentialReport, generateCredentialReport"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :generate-credential-report,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :generate-credential-report,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   generate-credential-report
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call generateCredentialReport, generateCredentialReport"}
   [credentials12437 & args12438]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12439
     (com.palletops.awaze.common/aws-client :iam credentials12437)]
    (clojure.core/case
     (clojure.core/count args12438)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12439
       generateCredentialReport
       (identitymanagement/generate-credential-report-request
        (clojure.core/nth args12438 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12439
       generateCredentialReport))))))
 (do
  (clojure.core/defmethod
   iam
   :get-sshpublic-key
   [m12440]
   (clojure.core/let
    [credentials12441 (:credentials m12440) args12442 (:args m12440)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12443
      (com.palletops.awaze.common/aws-client :iam credentials12441)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12443
       getSSHPublicKey
       (identitymanagement/get-sshpublic-key-request
        (clojure.core/nth args12442 0)))))))
  (clojure.core/defn
   get-sshpublic-key-map
   {:arglists (quote
               [[credentials
                 {:keys [encoding
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         sshpublic-key-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getSSHPublicKey"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-sshpublic-key,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-sshpublic-key
   {:arglists (quote
               [[credentials
                 {:keys [encoding
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         sshpublic-key-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getSSHPublicKey"}
   [credentials12445 & args12446]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12447
     (com.palletops.awaze.common/aws-client :iam credentials12445)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12447
      getSSHPublicKey
      (identitymanagement/get-sshpublic-key-request
       (clojure.core/nth args12446 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-account-alias
   [m12448]
   (clojure.core/let
    [credentials12449 (:credentials m12448) args12450 (:args m12448)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12451
      (com.palletops.awaze.common/aws-client :iam credentials12449)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12451
       createAccountAlias
       (identitymanagement/create-account-alias-request
        (clojure.core/nth args12450 0)))))))
  (clojure.core/defn
   create-account-alias-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         account-alias
                         clone-root]}]]),
    :doc "Generate map for createAccountAlias"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-account-alias,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   create-account-alias
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         account-alias
                         clone-root]}]]),
    :doc "Call createAccountAlias"}
   [credentials12453 & args12454]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12455
     (com.palletops.awaze.common/aws-client :iam credentials12453)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12455
      createAccountAlias
      (identitymanagement/create-account-alias-request
       (clojure.core/nth args12454 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-samlprovider
   [m12456]
   (clojure.core/let
    [credentials12457 (:credentials m12456) args12458 (:args m12456)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12459
      (com.palletops.awaze.common/aws-client :iam credentials12457)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12459
       getSAMLProvider
       (identitymanagement/get-samlprovider-request
        (clojure.core/nth args12458 0)))))))
  (clojure.core/defn
   get-samlprovider-map
   {:arglists (quote
               [[credentials
                 {:keys [samlprovider-arn
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getSAMLProvider"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-samlprovider,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-samlprovider
   {:arglists (quote
               [[credentials
                 {:keys [samlprovider-arn
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getSAMLProvider"}
   [credentials12461 & args12462]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12463
     (com.palletops.awaze.common/aws-client :iam credentials12461)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12463
      getSAMLProvider
      (identitymanagement/get-samlprovider-request
       (clojure.core/nth args12462 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-policy-version
   [m12464]
   (clojure.core/let
    [credentials12465 (:credentials m12464) args12466 (:args m12464)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12467
      (com.palletops.awaze.common/aws-client :iam credentials12465)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12467
       getPolicyVersion
       (identitymanagement/get-policy-version-request
        (clojure.core/nth args12466 0)))))))
  (clojure.core/defn
   get-policy-version-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getPolicyVersion"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-policy-version,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-policy-version
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call getPolicyVersion"}
   [credentials12469 & args12470]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12471
     (com.palletops.awaze.common/aws-client :iam credentials12469)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12471
      getPolicyVersion
      (identitymanagement/get-policy-version-request
       (clojure.core/nth args12470 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-mfadevices
   [m12472]
   (clojure.core/let
    [credentials12473 (:credentials m12472) args12474 (:args m12472)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12475
      (com.palletops.awaze.common/aws-client :iam credentials12473)]
     (clojure.core/case
      (clojure.core/count args12474)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12475
        listMFADevices
        (identitymanagement/list-mfadevices-request
         (clojure.core/nth args12474 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12475
        listMFADevices))))))
  (clojure.core/defn
   list-mfadevices-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listMFADevices, listMFADevices"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-mfadevices,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-mfadevices,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-mfadevices
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listMFADevices, listMFADevices"}
   [credentials12477 & args12478]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12479
     (com.palletops.awaze.common/aws-client :iam credentials12477)]
    (clojure.core/case
     (clojure.core/count args12478)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12479
       listMFADevices
       (identitymanagement/list-mfadevices-request
        (clojure.core/nth args12478 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12479
       listMFADevices))))))
 (do
  (clojure.core/defmethod
   iam
   :list-server-certificates
   [m12480]
   (clojure.core/let
    [credentials12481 (:credentials m12480) args12482 (:args m12480)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12483
      (com.palletops.awaze.common/aws-client :iam credentials12481)]
     (clojure.core/case
      (clojure.core/count args12482)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12483
        listServerCertificates))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12483
        listServerCertificates
        (identitymanagement/list-server-certificates-request
         (clojure.core/nth args12482 0))))))))
  (clojure.core/defn
   list-server-certificates-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listServerCertificates, listServerCertificates"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-server-certificates,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-server-certificates,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-server-certificates
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listServerCertificates, listServerCertificates"}
   [credentials12485 & args12486]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12487
     (com.palletops.awaze.common/aws-client :iam credentials12485)]
    (clojure.core/case
     (clojure.core/count args12486)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12487
       listServerCertificates))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12487
       listServerCertificates
       (identitymanagement/list-server-certificates-request
        (clojure.core/nth args12486 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :put-group-policy
   [m12488]
   (clojure.core/let
    [credentials12489 (:credentials m12488) args12490 (:args m12488)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12491
      (com.palletops.awaze.common/aws-client :iam credentials12489)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12491
       putGroupPolicy
       (identitymanagement/put-group-policy-request
        (clojure.core/nth args12490 0)))))))
  (clojure.core/defn
   put-group-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for putGroupPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :put-group-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   put-group-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call putGroupPolicy"}
   [credentials12493 & args12494]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12495
     (com.palletops.awaze.common/aws-client :iam credentials12493)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12495
      putGroupPolicy
      (identitymanagement/put-group-policy-request
       (clojure.core/nth args12494 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-account-authorization-details
   [m12496]
   (clojure.core/let
    [credentials12497 (:credentials m12496) args12498 (:args m12496)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12499
      (com.palletops.awaze.common/aws-client :iam credentials12497)]
     (clojure.core/case
      (clojure.core/count args12498)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12499
        getAccountAuthorizationDetails))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12499
        getAccountAuthorizationDetails
        (identitymanagement/get-account-authorization-details-request
         (clojure.core/nth args12498 0))))))))
  (clojure.core/defn
   get-account-authorization-details-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         filter
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getAccountAuthorizationDetails, getAccountAuthorizationDetails"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-account-authorization-details,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-account-authorization-details,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-account-authorization-details
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         filter
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getAccountAuthorizationDetails, getAccountAuthorizationDetails"}
   [credentials12501 & args12502]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12503
     (com.palletops.awaze.common/aws-client :iam credentials12501)]
    (clojure.core/case
     (clojure.core/count args12502)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12503
       getAccountAuthorizationDetails))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12503
       getAccountAuthorizationDetails
       (identitymanagement/get-account-authorization-details-request
        (clojure.core/nth args12502 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-group-policy
   [m12504]
   (clojure.core/let
    [credentials12505 (:credentials m12504) args12506 (:args m12504)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12507
      (com.palletops.awaze.common/aws-client :iam credentials12505)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12507
       deleteGroupPolicy
       (identitymanagement/delete-group-policy-request
        (clojure.core/nth args12506 0)))))))
  (clojure.core/defn
   delete-group-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteGroupPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-group-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-group-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteGroupPolicy"}
   [credentials12509 & args12510]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12511
     (com.palletops.awaze.common/aws-client :iam credentials12509)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12511
      deleteGroupPolicy
      (identitymanagement/delete-group-policy-request
       (clojure.core/nth args12510 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-open-idconnect-providers
   [m12512]
   (clojure.core/let
    [credentials12513 (:credentials m12512) args12514 (:args m12512)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12515
      (com.palletops.awaze.common/aws-client :iam credentials12513)]
     (clojure.core/case
      (clojure.core/count args12514)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12515
        listOpenIDConnectProviders
        (identitymanagement/list-open-idconnect-providers-request
         (clojure.core/nth args12514 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12515
        listOpenIDConnectProviders))))))
  (clojure.core/defn
   list-open-idconnect-providers-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listOpenIDConnectProviders, listOpenIDConnectProviders"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-open-idconnect-providers,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-open-idconnect-providers,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-open-idconnect-providers
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listOpenIDConnectProviders, listOpenIDConnectProviders"}
   [credentials12517 & args12518]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12519
     (com.palletops.awaze.common/aws-client :iam credentials12517)]
    (clojure.core/case
     (clojure.core/count args12518)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12519
       listOpenIDConnectProviders
       (identitymanagement/list-open-idconnect-providers-request
        (clojure.core/nth args12518 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12519
       listOpenIDConnectProviders))))))
 (do
  (clojure.core/defmethod
   iam
   :list-role-policies
   [m12520]
   (clojure.core/let
    [credentials12521 (:credentials m12520) args12522 (:args m12520)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12523
      (com.palletops.awaze.common/aws-client :iam credentials12521)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12523
       listRolePolicies
       (identitymanagement/list-role-policies-request
        (clojure.core/nth args12522 0)))))))
  (clojure.core/defn
   list-role-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listRolePolicies"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-role-policies,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-role-policies
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listRolePolicies"}
   [credentials12525 & args12526]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12527
     (com.palletops.awaze.common/aws-client :iam credentials12525)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12527
      listRolePolicies
      (identitymanagement/list-role-policies-request
       (clojure.core/nth args12526 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-account-password-policy
   [m12528]
   (clojure.core/let
    [credentials12529 (:credentials m12528) args12530 (:args m12528)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12531
      (com.palletops.awaze.common/aws-client :iam credentials12529)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12531
       updateAccountPasswordPolicy
       (identitymanagement/update-account-password-policy-request
        (clojure.core/nth args12530 0)))))))
  (clojure.core/defn
   update-account-password-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         require-lowercase-characters
                         require-symbols
                         sdk-request-timeout
                         require-numbers
                         custom-query-parameters
                         require-uppercase-characters
                         read-limit
                         allow-users-to-change-password
                         general-progress-listener
                         max-password-age
                         clone-source
                         hard-expiry
                         clone-root
                         minimum-password-length
                         password-reuse-prevention]}]]),
    :doc "Generate map for updateAccountPasswordPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-account-password-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   update-account-password-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         require-lowercase-characters
                         require-symbols
                         sdk-request-timeout
                         require-numbers
                         custom-query-parameters
                         require-uppercase-characters
                         read-limit
                         allow-users-to-change-password
                         general-progress-listener
                         max-password-age
                         clone-source
                         hard-expiry
                         clone-root
                         minimum-password-length
                         password-reuse-prevention]}]]),
    :doc "Call updateAccountPasswordPolicy"}
   [credentials12533 & args12534]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12535
     (com.palletops.awaze.common/aws-client :iam credentials12533)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12535
      updateAccountPasswordPolicy
      (identitymanagement/update-account-password-policy-request
       (clojure.core/nth args12534 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :put-user-policy
   [m12536]
   (clojure.core/let
    [credentials12537 (:credentials m12536) args12538 (:args m12536)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12539
      (com.palletops.awaze.common/aws-client :iam credentials12537)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12539
       putUserPolicy
       (identitymanagement/put-user-policy-request
        (clojure.core/nth args12538 0)))))))
  (clojure.core/defn
   put-user-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for putUserPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :put-user-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   put-user-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call putUserPolicy"}
   [credentials12541 & args12542]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12543
     (com.palletops.awaze.common/aws-client :iam credentials12541)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12543
      putUserPolicy
      (identitymanagement/put-user-policy-request
       (clojure.core/nth args12542 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-assume-role-policy
   [m12544]
   (clojure.core/let
    [credentials12545 (:credentials m12544) args12546 (:args m12544)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12547
      (com.palletops.awaze.common/aws-client :iam credentials12545)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12547
       updateAssumeRolePolicy
       (identitymanagement/update-assume-role-policy-request
        (clojure.core/nth args12546 0)))))))
  (clojure.core/defn
   update-assume-role-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateAssumeRolePolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-assume-role-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   update-assume-role-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateAssumeRolePolicy"}
   [credentials12549 & args12550]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12551
     (com.palletops.awaze.common/aws-client :iam credentials12549)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12551
      updateAssumeRolePolicy
      (identitymanagement/update-assume-role-policy-request
       (clojure.core/nth args12550 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-policy
   [m12552]
   (clojure.core/let
    [credentials12553 (:credentials m12552) args12554 (:args m12552)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12555
      (com.palletops.awaze.common/aws-client :iam credentials12553)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12555
       getPolicy
       (identitymanagement/get-policy-request
        (clojure.core/nth args12554 0)))))))
  (clojure.core/defn
   get-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call getPolicy"}
   [credentials12557 & args12558]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12559
     (com.palletops.awaze.common/aws-client :iam credentials12557)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12559
      getPolicy
      (identitymanagement/get-policy-request
       (clojure.core/nth args12558 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-user
   [m12560]
   (clojure.core/let
    [credentials12561 (:credentials m12560) args12562 (:args m12560)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12563
      (com.palletops.awaze.common/aws-client :iam credentials12561)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12563
       updateUser
       (identitymanagement/update-user-request
        (clojure.core/nth args12562 0)))))))
  (clojure.core/defn
   update-user-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         new-path
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         new-user-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateUser"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-user,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   update-user
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         new-path
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         new-user-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateUser"}
   [credentials12565 & args12566]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12567
     (com.palletops.awaze.common/aws-client :iam credentials12565)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12567
      updateUser
      (identitymanagement/update-user-request
       (clojure.core/nth args12566 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-role-policy
   [m12568]
   (clojure.core/let
    [credentials12569 (:credentials m12568) args12570 (:args m12568)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12571
      (com.palletops.awaze.common/aws-client :iam credentials12569)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12571
       getRolePolicy
       (identitymanagement/get-role-policy-request
        (clojure.core/nth args12570 0)))))))
  (clojure.core/defn
   get-role-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-name
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getRolePolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-role-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-role-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-name
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getRolePolicy"}
   [credentials12573 & args12574]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12575
     (com.palletops.awaze.common/aws-client :iam credentials12573)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12575
      getRolePolicy
      (identitymanagement/get-role-policy-request
       (clojure.core/nth args12574 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-group
   [m12576]
   (clojure.core/let
    [credentials12577 (:credentials m12576) args12578 (:args m12576)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12579
      (com.palletops.awaze.common/aws-client :iam credentials12577)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12579
       deleteGroup
       (identitymanagement/delete-group-request
        (clojure.core/nth args12578 0)))))))
  (clojure.core/defn
   delete-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-group,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteGroup"}
   [credentials12581 & args12582]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12583
     (com.palletops.awaze.common/aws-client :iam credentials12581)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12583
      deleteGroup
      (identitymanagement/delete-group-request
       (clojure.core/nth args12582 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-login-profile
   [m12584]
   (clojure.core/let
    [credentials12585 (:credentials m12584) args12586 (:args m12584)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12587
      (com.palletops.awaze.common/aws-client :iam credentials12585)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12587
       getLoginProfile
       (identitymanagement/get-login-profile-request
        (clojure.core/nth args12586 0)))))))
  (clojure.core/defn
   get-login-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getLoginProfile"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-login-profile,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-login-profile
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getLoginProfile"}
   [credentials12589 & args12590]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12591
     (com.palletops.awaze.common/aws-client :iam credentials12589)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12591
      getLoginProfile
      (identitymanagement/get-login-profile-request
       (clojure.core/nth args12590 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-samlproviders
   [m12592]
   (clojure.core/let
    [credentials12593 (:credentials m12592) args12594 (:args m12592)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12595
      (com.palletops.awaze.common/aws-client :iam credentials12593)]
     (clojure.core/case
      (clojure.core/count args12594)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12595
        listSAMLProviders
        (identitymanagement/list-samlproviders-request
         (clojure.core/nth args12594 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12595
        listSAMLProviders))))))
  (clojure.core/defn
   list-samlproviders-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listSAMLProviders, listSAMLProviders"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-samlproviders,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-samlproviders,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-samlproviders
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listSAMLProviders, listSAMLProviders"}
   [credentials12597 & args12598]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12599
     (com.palletops.awaze.common/aws-client :iam credentials12597)]
    (clojure.core/case
     (clojure.core/count args12598)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12599
       listSAMLProviders
       (identitymanagement/list-samlproviders-request
        (clojure.core/nth args12598 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12599
       listSAMLProviders))))))
 (do
  (clojure.core/defmethod
   iam
   :create-role
   [m12600]
   (clojure.core/let
    [credentials12601 (:credentials m12600) args12602 (:args m12600)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12603
      (com.palletops.awaze.common/aws-client :iam credentials12601)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12603
       createRole
       (identitymanagement/create-role-request
        (clojure.core/nth args12602 0)))))))
  (clojure.core/defn
   create-role-map
   {:arglists (quote
               [[credentials
                 {:keys [path
                         custom-request-headers
                         sdk-client-execution-timeout
                         assume-role-policy-document
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createRole"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-role,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   create-role
   {:arglists (quote
               [[credentials
                 {:keys [path
                         custom-request-headers
                         sdk-client-execution-timeout
                         assume-role-policy-document
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createRole"}
   [credentials12605 & args12606]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12607
     (com.palletops.awaze.common/aws-client :iam credentials12605)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12607
      createRole
      (identitymanagement/create-role-request
       (clojure.core/nth args12606 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-attached-group-policies
   [m12608]
   (clojure.core/let
    [credentials12609 (:credentials m12608) args12610 (:args m12608)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12611
      (com.palletops.awaze.common/aws-client :iam credentials12609)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12611
       listAttachedGroupPolicies
       (identitymanagement/list-attached-group-policies-request
        (clojure.core/nth args12610 0)))))))
  (clojure.core/defn
   list-attached-group-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listAttachedGroupPolicies"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-attached-group-policies,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-attached-group-policies
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listAttachedGroupPolicies"}
   [credentials12613 & args12614]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12615
     (com.palletops.awaze.common/aws-client :iam credentials12613)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12615
      listAttachedGroupPolicies
      (identitymanagement/list-attached-group-policies-request
       (clojure.core/nth args12614 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-access-key
   [m12616]
   (clojure.core/let
    [credentials12617 (:credentials m12616) args12618 (:args m12616)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12619
      (com.palletops.awaze.common/aws-client :iam credentials12617)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12619
       deleteAccessKey
       (identitymanagement/delete-access-key-request
        (clojure.core/nth args12618 0)))))))
  (clojure.core/defn
   delete-access-key-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         access-key-id
                         clone-root]}]]),
    :doc "Generate map for deleteAccessKey"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-access-key,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-access-key
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         access-key-id
                         clone-root]}]]),
    :doc "Call deleteAccessKey"}
   [credentials12621 & args12622]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12623
     (com.palletops.awaze.common/aws-client :iam credentials12621)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12623
      deleteAccessKey
      (identitymanagement/delete-access-key-request
       (clojure.core/nth args12622 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-group
   [m12624]
   (clojure.core/let
    [credentials12625 (:credentials m12624) args12626 (:args m12624)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12627
      (com.palletops.awaze.common/aws-client :iam credentials12625)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12627
       getGroup
       (identitymanagement/get-group-request
        (clojure.core/nth args12626 0)))))))
  (clojure.core/defn
   get-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-group,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getGroup"}
   [credentials12629 & args12630]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12631
     (com.palletops.awaze.common/aws-client :iam credentials12629)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12631
      getGroup
      (identitymanagement/get-group-request
       (clojure.core/nth args12630 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-account-password-policy
   [m12632]
   (clojure.core/let
    [credentials12633 (:credentials m12632) args12634 (:args m12632)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12635
      (com.palletops.awaze.common/aws-client :iam credentials12633)]
     (clojure.core/case
      (clojure.core/count args12634)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12635
        deleteAccountPasswordPolicy))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12635
        deleteAccountPasswordPolicy
        (identitymanagement/delete-account-password-policy-request
         (clojure.core/nth args12634 0))))))))
  (clojure.core/defn
   delete-account-password-policy-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteAccountPasswordPolicy, deleteAccountPasswordPolicy"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :delete-account-password-policy,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-account-password-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-account-password-policy
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteAccountPasswordPolicy, deleteAccountPasswordPolicy"}
   [credentials12637 & args12638]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12639
     (com.palletops.awaze.common/aws-client :iam credentials12637)]
    (clojure.core/case
     (clojure.core/count args12638)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12639
       deleteAccountPasswordPolicy))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12639
       deleteAccountPasswordPolicy
       (identitymanagement/delete-account-password-policy-request
        (clojure.core/nth args12638 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :get-account-summary
   [m12640]
   (clojure.core/let
    [credentials12641 (:credentials m12640) args12642 (:args m12640)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12643
      (com.palletops.awaze.common/aws-client :iam credentials12641)]
     (clojure.core/case
      (clojure.core/count args12642)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12643
        getAccountSummary))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12643
        getAccountSummary
        (identitymanagement/get-account-summary-request
         (clojure.core/nth args12642 0))))))))
  (clojure.core/defn
   get-account-summary-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getAccountSummary, getAccountSummary"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-account-summary,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-account-summary,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-account-summary
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getAccountSummary, getAccountSummary"}
   [credentials12645 & args12646]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12647
     (com.palletops.awaze.common/aws-client :iam credentials12645)]
    (clojure.core/case
     (clojure.core/count args12646)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12647
       getAccountSummary))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12647
       getAccountSummary
       (identitymanagement/get-account-summary-request
        (clojure.core/nth args12646 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-policy
   [m12648]
   (clojure.core/let
    [credentials12649 (:credentials m12648) args12650 (:args m12648)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12651
      (com.palletops.awaze.common/aws-client :iam credentials12649)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12651
       deletePolicy
       (identitymanagement/delete-policy-request
        (clojure.core/nth args12650 0)))))))
  (clojure.core/defn
   delete-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deletePolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call deletePolicy"}
   [credentials12653 & args12654]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12655
     (com.palletops.awaze.common/aws-client :iam credentials12653)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12655
      deletePolicy
      (identitymanagement/delete-policy-request
       (clojure.core/nth args12654 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-group
   [m12656]
   (clojure.core/let
    [credentials12657 (:credentials m12656) args12658 (:args m12656)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12659
      (com.palletops.awaze.common/aws-client :iam credentials12657)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12659
       createGroup
       (identitymanagement/create-group-request
        (clojure.core/nth args12658 0)))))))
  (clojure.core/defn
   create-group-map
   {:arglists (quote
               [[credentials
                 {:keys [path
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-group,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   create-group
   {:arglists (quote
               [[credentials
                 {:keys [path
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createGroup"}
   [credentials12661 & args12662]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12663
     (com.palletops.awaze.common/aws-client :iam credentials12661)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12663
      createGroup
      (identitymanagement/create-group-request
       (clojure.core/nth args12662 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-role
   [m12664]
   (clojure.core/let
    [credentials12665 (:credentials m12664) args12666 (:args m12664)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12667
      (com.palletops.awaze.common/aws-client :iam credentials12665)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12667
       getRole
       (identitymanagement/get-role-request
        (clojure.core/nth args12666 0)))))))
  (clojure.core/defn
   get-role-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getRole"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-role,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-role
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getRole"}
   [credentials12669 & args12670]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12671
     (com.palletops.awaze.common/aws-client :iam credentials12669)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12671
      getRole
      (identitymanagement/get-role-request
       (clojure.core/nth args12670 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-policy-versions
   [m12672]
   (clojure.core/let
    [credentials12673 (:credentials m12672) args12674 (:args m12672)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12675
      (com.palletops.awaze.common/aws-client :iam credentials12673)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12675
       listPolicyVersions
       (identitymanagement/list-policy-versions-request
        (clojure.core/nth args12674 0)))))))
  (clojure.core/defn
   list-policy-versions-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listPolicyVersions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-policy-versions,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-policy-versions
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call listPolicyVersions"}
   [credentials12677 & args12678]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12679
     (com.palletops.awaze.common/aws-client :iam credentials12677)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12679
      listPolicyVersions
      (identitymanagement/list-policy-versions-request
       (clojure.core/nth args12678 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-group-policies
   [m12680]
   (clojure.core/let
    [credentials12681 (:credentials m12680) args12682 (:args m12680)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12683
      (com.palletops.awaze.common/aws-client :iam credentials12681)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12683
       listGroupPolicies
       (identitymanagement/list-group-policies-request
        (clojure.core/nth args12682 0)))))))
  (clojure.core/defn
   list-group-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listGroupPolicies"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-group-policies,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-group-policies
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listGroupPolicies"}
   [credentials12685 & args12686]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12687
     (com.palletops.awaze.common/aws-client :iam credentials12685)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12687
      listGroupPolicies
      (identitymanagement/list-group-policies-request
       (clojure.core/nth args12686 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-samlprovider
   [m12688]
   (clojure.core/let
    [credentials12689 (:credentials m12688) args12690 (:args m12688)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12691
      (com.palletops.awaze.common/aws-client :iam credentials12689)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12691
       deleteSAMLProvider
       (identitymanagement/delete-samlprovider-request
        (clojure.core/nth args12690 0)))))))
  (clojure.core/defn
   delete-samlprovider-map
   {:arglists (quote
               [[credentials
                 {:keys [samlprovider-arn
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteSAMLProvider"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-samlprovider,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-samlprovider
   {:arglists (quote
               [[credentials
                 {:keys [samlprovider-arn
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteSAMLProvider"}
   [credentials12693 & args12694]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12695
     (com.palletops.awaze.common/aws-client :iam credentials12693)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12695
      deleteSAMLProvider
      (identitymanagement/delete-samlprovider-request
       (clojure.core/nth args12694 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :detach-role-policy
   [m12696]
   (clojure.core/let
    [credentials12697 (:credentials m12696) args12698 (:args m12696)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12699
      (com.palletops.awaze.common/aws-client :iam credentials12697)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12699
       detachRolePolicy
       (identitymanagement/detach-role-policy-request
        (clojure.core/nth args12698 0)))))))
  (clojure.core/defn
   detach-role-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for detachRolePolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :detach-role-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   detach-role-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call detachRolePolicy"}
   [credentials12701 & args12702]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12703
     (com.palletops.awaze.common/aws-client :iam credentials12701)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12703
      detachRolePolicy
      (identitymanagement/detach-role-policy-request
       (clojure.core/nth args12702 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-login-profile
   [m12704]
   (clojure.core/let
    [credentials12705 (:credentials m12704) args12706 (:args m12704)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12707
      (com.palletops.awaze.common/aws-client :iam credentials12705)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12707
       updateLoginProfile
       (identitymanagement/update-login-profile-request
        (clojure.core/nth args12706 0)))))))
  (clojure.core/defn
   update-login-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         password
                         sdk-request-timeout
                         password-reset-required
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateLoginProfile"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-login-profile,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   update-login-profile
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         password
                         sdk-request-timeout
                         password-reset-required
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateLoginProfile"}
   [credentials12709 & args12710]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12711
     (com.palletops.awaze.common/aws-client :iam credentials12709)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12711
      updateLoginProfile
      (identitymanagement/update-login-profile-request
       (clojure.core/nth args12710 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-open-idconnect-provider-thumbprint
   [m12712]
   (clojure.core/let
    [credentials12713 (:credentials m12712) args12714 (:args m12712)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12715
      (com.palletops.awaze.common/aws-client :iam credentials12713)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12715
       updateOpenIDConnectProviderThumbprint
       (identitymanagement/update-open-idconnect-provider-thumbprint-request
        (clojure.core/nth args12714 0)))))))
  (clojure.core/defn
   update-open-idconnect-provider-thumbprint-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         open-idconnect-provider-arn
                         sdk-request-timeout
                         custom-query-parameters
                         thumbprint-list
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateOpenIDConnectProviderThumbprint"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-open-idconnect-provider-thumbprint,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   update-open-idconnect-provider-thumbprint
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         open-idconnect-provider-arn
                         sdk-request-timeout
                         custom-query-parameters
                         thumbprint-list
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateOpenIDConnectProviderThumbprint"}
   [credentials12717 & args12718]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12719
     (com.palletops.awaze.common/aws-client :iam credentials12717)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12719
      updateOpenIDConnectProviderThumbprint
      (identitymanagement/update-open-idconnect-provider-thumbprint-request
       (clojure.core/nth args12718 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-sshpublic-key
   [m12720]
   (clojure.core/let
    [credentials12721 (:credentials m12720) args12722 (:args m12720)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12723
      (com.palletops.awaze.common/aws-client :iam credentials12721)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12723
       updateSSHPublicKey
       (identitymanagement/update-sshpublic-key-request
        (clojure.core/nth args12722 0)))))))
  (clojure.core/defn
   update-sshpublic-key-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         sshpublic-key-id
                         read-limit
                         status
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateSSHPublicKey"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-sshpublic-key,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   update-sshpublic-key
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         sshpublic-key-id
                         read-limit
                         status
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateSSHPublicKey"}
   [credentials12725 & args12726]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12727
     (com.palletops.awaze.common/aws-client :iam credentials12725)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12727
      updateSSHPublicKey
      (identitymanagement/update-sshpublic-key-request
       (clojure.core/nth args12726 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-server-certificate
   [m12728]
   (clojure.core/let
    [credentials12729 (:credentials m12728) args12730 (:args m12728)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12731
      (com.palletops.awaze.common/aws-client :iam credentials12729)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12731
       deleteServerCertificate
       (identitymanagement/delete-server-certificate-request
        (clojure.core/nth args12730 0)))))))
  (clojure.core/defn
   delete-server-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [server-certificate-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteServerCertificate"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-server-certificate,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-server-certificate
   {:arglists (quote
               [[credentials
                 {:keys [server-certificate-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteServerCertificate"}
   [credentials12733 & args12734]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12735
     (com.palletops.awaze.common/aws-client :iam credentials12733)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12735
      deleteServerCertificate
      (identitymanagement/delete-server-certificate-request
       (clojure.core/nth args12734 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-virtual-mfadevices
   [m12736]
   (clojure.core/let
    [credentials12737 (:credentials m12736) args12738 (:args m12736)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12739
      (com.palletops.awaze.common/aws-client :iam credentials12737)]
     (clojure.core/case
      (clojure.core/count args12738)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12739
        listVirtualMFADevices))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12739
        listVirtualMFADevices
        (identitymanagement/list-virtual-mfadevices-request
         (clojure.core/nth args12738 0))))))))
  (clojure.core/defn
   list-virtual-mfadevices-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         assignment-status
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listVirtualMFADevices, listVirtualMFADevices"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-virtual-mfadevices,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-virtual-mfadevices,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-virtual-mfadevices
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         assignment-status
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listVirtualMFADevices, listVirtualMFADevices"}
   [credentials12741 & args12742]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12743
     (com.palletops.awaze.common/aws-client :iam credentials12741)]
    (clojure.core/case
     (clojure.core/count args12742)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12743
       listVirtualMFADevices))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12743
       listVirtualMFADevices
       (identitymanagement/list-virtual-mfadevices-request
        (clojure.core/nth args12742 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :get-server-certificate
   [m12744]
   (clojure.core/let
    [credentials12745 (:credentials m12744) args12746 (:args m12744)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12747
      (com.palletops.awaze.common/aws-client :iam credentials12745)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12747
       getServerCertificate
       (identitymanagement/get-server-certificate-request
        (clojure.core/nth args12746 0)))))))
  (clojure.core/defn
   get-server-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [server-certificate-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getServerCertificate"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-server-certificate,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-server-certificate
   {:arglists (quote
               [[credentials
                 {:keys [server-certificate-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getServerCertificate"}
   [credentials12749 & args12750]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12751
     (com.palletops.awaze.common/aws-client :iam credentials12749)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12751
      getServerCertificate
      (identitymanagement/get-server-certificate-request
       (clojure.core/nth args12750 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-role-policy
   [m12752]
   (clojure.core/let
    [credentials12753 (:credentials m12752) args12754 (:args m12752)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12755
      (com.palletops.awaze.common/aws-client :iam credentials12753)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12755
       deleteRolePolicy
       (identitymanagement/delete-role-policy-request
        (clojure.core/nth args12754 0)))))))
  (clojure.core/defn
   delete-role-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-name
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteRolePolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-role-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-role-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-name
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteRolePolicy"}
   [credentials12757 & args12758]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12759
     (com.palletops.awaze.common/aws-client :iam credentials12757)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12759
      deleteRolePolicy
      (identitymanagement/delete-role-policy-request
       (clojure.core/nth args12758 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-instance-profile
   [m12760]
   (clojure.core/let
    [credentials12761 (:credentials m12760) args12762 (:args m12760)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12763
      (com.palletops.awaze.common/aws-client :iam credentials12761)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12763
       deleteInstanceProfile
       (identitymanagement/delete-instance-profile-request
        (clojure.core/nth args12762 0)))))))
  (clojure.core/defn
   delete-instance-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         instance-profile-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteInstanceProfile"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-instance-profile,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-instance-profile
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         instance-profile-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteInstanceProfile"}
   [credentials12765 & args12766]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12767
     (com.palletops.awaze.common/aws-client :iam credentials12765)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12767
      deleteInstanceProfile
      (identitymanagement/delete-instance-profile-request
       (clojure.core/nth args12766 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-account-aliases
   [m12768]
   (clojure.core/let
    [credentials12769 (:credentials m12768) args12770 (:args m12768)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12771
      (com.palletops.awaze.common/aws-client :iam credentials12769)]
     (clojure.core/case
      (clojure.core/count args12770)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12771
        listAccountAliases
        (identitymanagement/list-account-aliases-request
         (clojure.core/nth args12770 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12771
        listAccountAliases))))))
  (clojure.core/defn
   list-account-aliases-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listAccountAliases, listAccountAliases"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-account-aliases,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-account-aliases,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-account-aliases
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listAccountAliases, listAccountAliases"}
   [credentials12773 & args12774]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12775
     (com.palletops.awaze.common/aws-client :iam credentials12773)]
    (clojure.core/case
     (clojure.core/count args12774)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12775
       listAccountAliases
       (identitymanagement/list-account-aliases-request
        (clojure.core/nth args12774 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12775
       listAccountAliases))))))
 (do
  (clojure.core/defmethod
   iam
   :add-user-to-group
   [m12776]
   (clojure.core/let
    [credentials12777 (:credentials m12776) args12778 (:args m12776)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12779
      (com.palletops.awaze.common/aws-client :iam credentials12777)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12779
       addUserToGroup
       (identitymanagement/add-user-to-group-request
        (clojure.core/nth args12778 0)))))))
  (clojure.core/defn
   add-user-to-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for addUserToGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :add-user-to-group,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   add-user-to-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call addUserToGroup"}
   [credentials12781 & args12782]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12783
     (com.palletops.awaze.common/aws-client :iam credentials12781)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12783
      addUserToGroup
      (identitymanagement/add-user-to-group-request
       (clojure.core/nth args12782 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-open-idconnect-provider
   [m12784]
   (clojure.core/let
    [credentials12785 (:credentials m12784) args12786 (:args m12784)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12787
      (com.palletops.awaze.common/aws-client :iam credentials12785)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12787
       deleteOpenIDConnectProvider
       (identitymanagement/delete-open-idconnect-provider-request
        (clojure.core/nth args12786 0)))))))
  (clojure.core/defn
   delete-open-idconnect-provider-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         open-idconnect-provider-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteOpenIDConnectProvider"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-open-idconnect-provider,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-open-idconnect-provider
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         open-idconnect-provider-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteOpenIDConnectProvider"}
   [credentials12789 & args12790]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12791
     (com.palletops.awaze.common/aws-client :iam credentials12789)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12791
      deleteOpenIDConnectProvider
      (identitymanagement/delete-open-idconnect-provider-request
       (clojure.core/nth args12790 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-users
   [m12792]
   (clojure.core/let
    [credentials12793 (:credentials m12792) args12794 (:args m12792)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12795
      (com.palletops.awaze.common/aws-client :iam credentials12793)]
     (clojure.core/case
      (clojure.core/count args12794)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12795
        listUsers))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12795
        listUsers
        (identitymanagement/list-users-request
         (clojure.core/nth args12794 0))))))))
  (clojure.core/defn
   list-users-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listUsers, listUsers"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-users,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-users,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-users
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listUsers, listUsers"}
   [credentials12797 & args12798]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12799
     (com.palletops.awaze.common/aws-client :iam credentials12797)]
    (clojure.core/case
     (clojure.core/count args12798)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12799
       listUsers))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12799
       listUsers
       (identitymanagement/list-users-request
        (clojure.core/nth args12798 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :create-instance-profile
   [m12800]
   (clojure.core/let
    [credentials12801 (:credentials m12800) args12802 (:args m12800)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12803
      (com.palletops.awaze.common/aws-client :iam credentials12801)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12803
       createInstanceProfile
       (identitymanagement/create-instance-profile-request
        (clojure.core/nth args12802 0)))))))
  (clojure.core/defn
   create-instance-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [path
                         custom-request-headers
                         sdk-client-execution-timeout
                         instance-profile-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createInstanceProfile"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-instance-profile,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   create-instance-profile
   {:arglists (quote
               [[credentials
                 {:keys [path
                         custom-request-headers
                         sdk-client-execution-timeout
                         instance-profile-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createInstanceProfile"}
   [credentials12805 & args12806]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12807
     (com.palletops.awaze.common/aws-client :iam credentials12805)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12807
      createInstanceProfile
      (identitymanagement/create-instance-profile-request
       (clojure.core/nth args12806 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-user-policy
   [m12808]
   (clojure.core/let
    [credentials12809 (:credentials m12808) args12810 (:args m12808)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12811
      (com.palletops.awaze.common/aws-client :iam credentials12809)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12811
       getUserPolicy
       (identitymanagement/get-user-policy-request
        (clojure.core/nth args12810 0)))))))
  (clojure.core/defn
   get-user-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getUserPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-user-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-user-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getUserPolicy"}
   [credentials12813 & args12814]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12815
     (com.palletops.awaze.common/aws-client :iam credentials12813)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12815
      getUserPolicy
      (identitymanagement/get-user-policy-request
       (clojure.core/nth args12814 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-login-profile
   [m12816]
   (clojure.core/let
    [credentials12817 (:credentials m12816) args12818 (:args m12816)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12819
      (com.palletops.awaze.common/aws-client :iam credentials12817)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12819
       deleteLoginProfile
       (identitymanagement/delete-login-profile-request
        (clojure.core/nth args12818 0)))))))
  (clojure.core/defn
   delete-login-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteLoginProfile"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-login-profile,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-login-profile
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteLoginProfile"}
   [credentials12821 & args12822]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12823
     (com.palletops.awaze.common/aws-client :iam credentials12821)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12823
      deleteLoginProfile
      (identitymanagement/delete-login-profile-request
       (clojure.core/nth args12822 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :attach-user-policy
   [m12824]
   (clojure.core/let
    [credentials12825 (:credentials m12824) args12826 (:args m12824)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12827
      (com.palletops.awaze.common/aws-client :iam credentials12825)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12827
       attachUserPolicy
       (identitymanagement/attach-user-policy-request
        (clojure.core/nth args12826 0)))))))
  (clojure.core/defn
   attach-user-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for attachUserPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :attach-user-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   attach-user-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call attachUserPolicy"}
   [credentials12829 & args12830]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12831
     (com.palletops.awaze.common/aws-client :iam credentials12829)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12831
      attachUserPolicy
      (identitymanagement/attach-user-policy-request
       (clojure.core/nth args12830 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :put-role-policy
   [m12832]
   (clojure.core/let
    [credentials12833 (:credentials m12832) args12834 (:args m12832)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12835
      (com.palletops.awaze.common/aws-client :iam credentials12833)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12835
       putRolePolicy
       (identitymanagement/put-role-policy-request
        (clojure.core/nth args12834 0)))))))
  (clojure.core/defn
   put-role-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-name
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for putRolePolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :put-role-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   put-role-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-name
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call putRolePolicy"}
   [credentials12837 & args12838]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12839
     (com.palletops.awaze.common/aws-client :iam credentials12837)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12839
      putRolePolicy
      (identitymanagement/put-role-policy-request
       (clojure.core/nth args12838 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-access-keys
   [m12840]
   (clojure.core/let
    [credentials12841 (:credentials m12840) args12842 (:args m12840)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12843
      (com.palletops.awaze.common/aws-client :iam credentials12841)]
     (clojure.core/case
      (clojure.core/count args12842)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12843
        listAccessKeys
        (identitymanagement/list-access-keys-request
         (clojure.core/nth args12842 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12843
        listAccessKeys))))))
  (clojure.core/defn
   list-access-keys-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listAccessKeys, listAccessKeys"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-access-keys,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-access-keys,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-access-keys
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listAccessKeys, listAccessKeys"}
   [credentials12845 & args12846]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12847
     (com.palletops.awaze.common/aws-client :iam credentials12845)]
    (clojure.core/case
     (clojure.core/count args12846)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12847
       listAccessKeys
       (identitymanagement/list-access-keys-request
        (clojure.core/nth args12846 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12847
       listAccessKeys))))))
 (do
  (clojure.core/defmethod
   iam
   :list-signing-certificates
   [m12848]
   (clojure.core/let
    [credentials12849 (:credentials m12848) args12850 (:args m12848)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12851
      (com.palletops.awaze.common/aws-client :iam credentials12849)]
     (clojure.core/case
      (clojure.core/count args12850)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12851
        listSigningCertificates))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12851
        listSigningCertificates
        (identitymanagement/list-signing-certificates-request
         (clojure.core/nth args12850 0))))))))
  (clojure.core/defn
   list-signing-certificates-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listSigningCertificates, listSigningCertificates"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-signing-certificates,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-signing-certificates,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-signing-certificates
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listSigningCertificates, listSigningCertificates"}
   [credentials12853 & args12854]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12855
     (com.palletops.awaze.common/aws-client :iam credentials12853)]
    (clojure.core/case
     (clojure.core/count args12854)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12855
       listSigningCertificates))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12855
       listSigningCertificates
       (identitymanagement/list-signing-certificates-request
        (clojure.core/nth args12854 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :detach-group-policy
   [m12856]
   (clojure.core/let
    [credentials12857 (:credentials m12856) args12858 (:args m12856)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12859
      (com.palletops.awaze.common/aws-client :iam credentials12857)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12859
       detachGroupPolicy
       (identitymanagement/detach-group-policy-request
        (clojure.core/nth args12858 0)))))))
  (clojure.core/defn
   detach-group-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for detachGroupPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :detach-group-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   detach-group-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call detachGroupPolicy"}
   [credentials12861 & args12862]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12863
     (com.palletops.awaze.common/aws-client :iam credentials12861)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12863
      detachGroupPolicy
      (identitymanagement/detach-group-policy-request
       (clojure.core/nth args12862 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-access-key
   [m12864]
   (clojure.core/let
    [credentials12865 (:credentials m12864) args12866 (:args m12864)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12867
      (com.palletops.awaze.common/aws-client :iam credentials12865)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12867
       updateAccessKey
       (identitymanagement/update-access-key-request
        (clojure.core/nth args12866 0)))))))
  (clojure.core/defn
   update-access-key-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         status
                         general-progress-listener
                         clone-source
                         access-key-id
                         clone-root]}]]),
    :doc "Generate map for updateAccessKey"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-access-key,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   update-access-key
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         status
                         general-progress-listener
                         clone-source
                         access-key-id
                         clone-root]}]]),
    :doc "Call updateAccessKey"}
   [credentials12869 & args12870]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12871
     (com.palletops.awaze.common/aws-client :iam credentials12869)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12871
      updateAccessKey
      (identitymanagement/update-access-key-request
       (clojure.core/nth args12870 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :upload-sshpublic-key
   [m12872]
   (clojure.core/let
    [credentials12873 (:credentials m12872) args12874 (:args m12872)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12875
      (com.palletops.awaze.common/aws-client :iam credentials12873)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12875
       uploadSSHPublicKey
       (identitymanagement/upload-sshpublic-key-request
        (clojure.core/nth args12874 0)))))))
  (clojure.core/defn
   upload-sshpublic-key-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sshpublic-key-body
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for uploadSSHPublicKey"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :upload-sshpublic-key,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   upload-sshpublic-key
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sshpublic-key-body
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call uploadSSHPublicKey"}
   [credentials12877 & args12878]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12879
     (com.palletops.awaze.common/aws-client :iam credentials12877)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12879
      uploadSSHPublicKey
      (identitymanagement/upload-sshpublic-key-request
       (clojure.core/nth args12878 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :upload-server-certificate
   [m12880]
   (clojure.core/let
    [credentials12881 (:credentials m12880) args12882 (:args m12880)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12883
      (com.palletops.awaze.common/aws-client :iam credentials12881)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12883
       uploadServerCertificate
       (identitymanagement/upload-server-certificate-request
        (clojure.core/nth args12882 0)))))))
  (clojure.core/defn
   upload-server-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [path
                         certificate-body
                         server-certificate-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         certificate-chain
                         read-limit
                         general-progress-listener
                         clone-source
                         private-key
                         clone-root]}]]),
    :doc "Generate map for uploadServerCertificate"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :upload-server-certificate,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   upload-server-certificate
   {:arglists (quote
               [[credentials
                 {:keys [path
                         certificate-body
                         server-certificate-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         certificate-chain
                         read-limit
                         general-progress-listener
                         clone-source
                         private-key
                         clone-root]}]]),
    :doc "Call uploadServerCertificate"}
   [credentials12885 & args12886]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12887
     (com.palletops.awaze.common/aws-client :iam credentials12885)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12887
      uploadServerCertificate
      (identitymanagement/upload-server-certificate-request
       (clojure.core/nth args12886 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-account-password-policy
   [m12888]
   (clojure.core/let
    [credentials12889 (:credentials m12888) args12890 (:args m12888)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12891
      (com.palletops.awaze.common/aws-client :iam credentials12889)]
     (clojure.core/case
      (clojure.core/count args12890)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12891
        getAccountPasswordPolicy))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12891
        getAccountPasswordPolicy
        (identitymanagement/get-account-password-policy-request
         (clojure.core/nth args12890 0))))))))
  (clojure.core/defn
   get-account-password-policy-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getAccountPasswordPolicy, getAccountPasswordPolicy"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-account-password-policy,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-account-password-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-account-password-policy
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getAccountPasswordPolicy, getAccountPasswordPolicy"}
   [credentials12893 & args12894]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12895
     (com.palletops.awaze.common/aws-client :iam credentials12893)]
    (clojure.core/case
     (clojure.core/count args12894)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12895
       getAccountPasswordPolicy))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12895
       getAccountPasswordPolicy
       (identitymanagement/get-account-password-policy-request
        (clojure.core/nth args12894 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-role
   [m12896]
   (clojure.core/let
    [credentials12897 (:credentials m12896) args12898 (:args m12896)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12899
      (com.palletops.awaze.common/aws-client :iam credentials12897)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12899
       deleteRole
       (identitymanagement/delete-role-request
        (clojure.core/nth args12898 0)))))))
  (clojure.core/defn
   delete-role-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteRole"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-role,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-role
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteRole"}
   [credentials12901 & args12902]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12903
     (com.palletops.awaze.common/aws-client :iam credentials12901)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12903
      deleteRole
      (identitymanagement/delete-role-request
       (clojure.core/nth args12902 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :remove-client-idfrom-open-idconnect-provider
   [m12904]
   (clojure.core/let
    [credentials12905 (:credentials m12904) args12906 (:args m12904)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12907
      (com.palletops.awaze.common/aws-client :iam credentials12905)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12907
       removeClientIDFromOpenIDConnectProvider
       (identitymanagement/remove-client-idfrom-open-idconnect-provider-request
        (clojure.core/nth args12906 0)))))))
  (clojure.core/defn
   remove-client-idfrom-open-idconnect-provider-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         client-id
                         open-idconnect-provider-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for removeClientIDFromOpenIDConnectProvider"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :remove-client-idfrom-open-idconnect-provider,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   remove-client-idfrom-open-idconnect-provider
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         client-id
                         open-idconnect-provider-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call removeClientIDFromOpenIDConnectProvider"}
   [credentials12909 & args12910]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12911
     (com.palletops.awaze.common/aws-client :iam credentials12909)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12911
      removeClientIDFromOpenIDConnectProvider
      (identitymanagement/remove-client-idfrom-open-idconnect-provider-request
       (clojure.core/nth args12910 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :remove-user-from-group
   [m12912]
   (clojure.core/let
    [credentials12913 (:credentials m12912) args12914 (:args m12912)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12915
      (com.palletops.awaze.common/aws-client :iam credentials12913)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12915
       removeUserFromGroup
       (identitymanagement/remove-user-from-group-request
        (clojure.core/nth args12914 0)))))))
  (clojure.core/defn
   remove-user-from-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for removeUserFromGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :remove-user-from-group,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   remove-user-from-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call removeUserFromGroup"}
   [credentials12917 & args12918]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12919
     (com.palletops.awaze.common/aws-client :iam credentials12917)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12919
      removeUserFromGroup
      (identitymanagement/remove-user-from-group-request
       (clojure.core/nth args12918 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-roles
   [m12920]
   (clojure.core/let
    [credentials12921 (:credentials m12920) args12922 (:args m12920)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12923
      (com.palletops.awaze.common/aws-client :iam credentials12921)]
     (clojure.core/case
      (clojure.core/count args12922)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12923
        listRoles))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12923
        listRoles
        (identitymanagement/list-roles-request
         (clojure.core/nth args12922 0))))))))
  (clojure.core/defn
   list-roles-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listRoles, listRoles"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-roles,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-roles,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-roles
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listRoles, listRoles"}
   [credentials12925 & args12926]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12927
     (com.palletops.awaze.common/aws-client :iam credentials12925)]
    (clojure.core/case
     (clojure.core/count args12926)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12927
       listRoles))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12927
       listRoles
       (identitymanagement/list-roles-request
        (clojure.core/nth args12926 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :list-attached-role-policies
   [m12928]
   (clojure.core/let
    [credentials12929 (:credentials m12928) args12930 (:args m12928)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12931
      (com.palletops.awaze.common/aws-client :iam credentials12929)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12931
       listAttachedRolePolicies
       (identitymanagement/list-attached-role-policies-request
        (clojure.core/nth args12930 0)))))))
  (clojure.core/defn
   list-attached-role-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listAttachedRolePolicies"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-attached-role-policies,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-attached-role-policies
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listAttachedRolePolicies"}
   [credentials12933 & args12934]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12935
     (com.palletops.awaze.common/aws-client :iam credentials12933)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12935
      listAttachedRolePolicies
      (identitymanagement/list-attached-role-policies-request
       (clojure.core/nth args12934 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :remove-role-from-instance-profile
   [m12936]
   (clojure.core/let
    [credentials12937 (:credentials m12936) args12938 (:args m12936)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12939
      (com.palletops.awaze.common/aws-client :iam credentials12937)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12939
       removeRoleFromInstanceProfile
       (identitymanagement/remove-role-from-instance-profile-request
        (clojure.core/nth args12938 0)))))))
  (clojure.core/defn
   remove-role-from-instance-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         instance-profile-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for removeRoleFromInstanceProfile"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :remove-role-from-instance-profile,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   remove-role-from-instance-profile
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         instance-profile-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call removeRoleFromInstanceProfile"}
   [credentials12941 & args12942]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12943
     (com.palletops.awaze.common/aws-client :iam credentials12941)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12943
      removeRoleFromInstanceProfile
      (identitymanagement/remove-role-from-instance-profile-request
       (clojure.core/nth args12942 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-policy
   [m12944]
   (clojure.core/let
    [credentials12945 (:credentials m12944) args12946 (:args m12944)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12947
      (com.palletops.awaze.common/aws-client :iam credentials12945)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12947
       createPolicy
       (identitymanagement/create-policy-request
        (clojure.core/nth args12946 0)))))))
  (clojure.core/defn
   create-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         path
                         custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   create-policy
   {:arglists (quote
               [[credentials
                 {:keys [description
                         path
                         custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createPolicy"}
   [credentials12949 & args12950]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12951
     (com.palletops.awaze.common/aws-client :iam credentials12949)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12951
      createPolicy
      (identitymanagement/create-policy-request
       (clojure.core/nth args12950 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :add-client-idto-open-idconnect-provider
   [m12952]
   (clojure.core/let
    [credentials12953 (:credentials m12952) args12954 (:args m12952)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12955
      (com.palletops.awaze.common/aws-client :iam credentials12953)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12955
       addClientIDToOpenIDConnectProvider
       (identitymanagement/add-client-idto-open-idconnect-provider-request
        (clojure.core/nth args12954 0)))))))
  (clojure.core/defn
   add-client-idto-open-idconnect-provider-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         client-id
                         open-idconnect-provider-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for addClientIDToOpenIDConnectProvider"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :add-client-idto-open-idconnect-provider,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   add-client-idto-open-idconnect-provider
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         client-id
                         open-idconnect-provider-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call addClientIDToOpenIDConnectProvider"}
   [credentials12957 & args12958]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12959
     (com.palletops.awaze.common/aws-client :iam credentials12957)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12959
      addClientIDToOpenIDConnectProvider
      (identitymanagement/add-client-idto-open-idconnect-provider-request
       (clojure.core/nth args12958 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-virtual-mfadevice
   [m12960]
   (clojure.core/let
    [credentials12961 (:credentials m12960) args12962 (:args m12960)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12963
      (com.palletops.awaze.common/aws-client :iam credentials12961)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12963
       createVirtualMFADevice
       (identitymanagement/create-virtual-mfadevice-request
        (clojure.core/nth args12962 0)))))))
  (clojure.core/defn
   create-virtual-mfadevice-map
   {:arglists (quote
               [[credentials
                 {:keys [path
                         custom-request-headers
                         sdk-client-execution-timeout
                         virtual-mfadevice-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createVirtualMFADevice"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-virtual-mfadevice,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   create-virtual-mfadevice
   {:arglists (quote
               [[credentials
                 {:keys [path
                         custom-request-headers
                         sdk-client-execution-timeout
                         virtual-mfadevice-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createVirtualMFADevice"}
   [credentials12965 & args12966]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12967
     (com.palletops.awaze.common/aws-client :iam credentials12965)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12967
      createVirtualMFADevice
      (identitymanagement/create-virtual-mfadevice-request
       (clojure.core/nth args12966 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-account-alias
   [m12968]
   (clojure.core/let
    [credentials12969 (:credentials m12968) args12970 (:args m12968)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12971
      (com.palletops.awaze.common/aws-client :iam credentials12969)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12971
       deleteAccountAlias
       (identitymanagement/delete-account-alias-request
        (clojure.core/nth args12970 0)))))))
  (clojure.core/defn
   delete-account-alias-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         account-alias
                         clone-root]}]]),
    :doc "Generate map for deleteAccountAlias"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-account-alias,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-account-alias
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         account-alias
                         clone-root]}]]),
    :doc "Call deleteAccountAlias"}
   [credentials12973 & args12974]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12975
     (com.palletops.awaze.common/aws-client :iam credentials12973)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12975
      deleteAccountAlias
      (identitymanagement/delete-account-alias-request
       (clojure.core/nth args12974 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :upload-signing-certificate
   [m12976]
   (clojure.core/let
    [credentials12977 (:credentials m12976) args12978 (:args m12976)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12979
      (com.palletops.awaze.common/aws-client :iam credentials12977)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12979
       uploadSigningCertificate
       (identitymanagement/upload-signing-certificate-request
        (clojure.core/nth args12978 0)))))))
  (clojure.core/defn
   upload-signing-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [certificate-body
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for uploadSigningCertificate"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :upload-signing-certificate,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   upload-signing-certificate
   {:arglists (quote
               [[credentials
                 {:keys [certificate-body
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call uploadSigningCertificate"}
   [credentials12981 & args12982]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12983
     (com.palletops.awaze.common/aws-client :iam credentials12981)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12983
      uploadSigningCertificate
      (identitymanagement/upload-signing-certificate-request
       (clojure.core/nth args12982 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :deactivate-mfadevice
   [m12984]
   (clojure.core/let
    [credentials12985 (:credentials m12984) args12986 (:args m12984)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12987
      (com.palletops.awaze.common/aws-client :iam credentials12985)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12987
       deactivateMFADevice
       (identitymanagement/deactivate-mfadevice-request
        (clojure.core/nth args12986 0)))))))
  (clojure.core/defn
   deactivate-mfadevice-map
   {:arglists (quote
               [[credentials
                 {:keys [serial-number
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deactivateMFADevice"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :deactivate-mfadevice,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   deactivate-mfadevice
   {:arglists (quote
               [[credentials
                 {:keys [serial-number
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deactivateMFADevice"}
   [credentials12989 & args12990]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12991
     (com.palletops.awaze.common/aws-client :iam credentials12989)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12991
      deactivateMFADevice
      (identitymanagement/deactivate-mfadevice-request
       (clojure.core/nth args12990 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :resync-mfadevice
   [m12992]
   (clojure.core/let
    [credentials12993 (:credentials m12992) args12994 (:args m12992)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client12995
      (com.palletops.awaze.common/aws-client :iam credentials12993)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12995
       resyncMFADevice
       (identitymanagement/resync-mfadevice-request
        (clojure.core/nth args12994 0)))))))
  (clojure.core/defn
   resync-mfadevice-map
   {:arglists (quote
               [[credentials
                 {:keys [serial-number
                         authentication-code2
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         authentication-code1
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for resyncMFADevice"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :resync-mfadevice,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   resync-mfadevice
   {:arglists (quote
               [[credentials
                 {:keys [serial-number
                         authentication-code2
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         authentication-code1
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call resyncMFADevice"}
   [credentials12997 & args12998]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client12999
     (com.palletops.awaze.common/aws-client :iam credentials12997)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client12999
      resyncMFADevice
      (identitymanagement/resync-mfadevice-request
       (clojure.core/nth args12998 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-sshpublic-keys
   [m13000]
   (clojure.core/let
    [credentials13001 (:credentials m13000) args13002 (:args m13000)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13003
      (com.palletops.awaze.common/aws-client :iam credentials13001)]
     (clojure.core/case
      (clojure.core/count args13002)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13003
        listSSHPublicKeys))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13003
        listSSHPublicKeys
        (identitymanagement/list-sshpublic-keys-request
         (clojure.core/nth args13002 0))))))))
  (clojure.core/defn
   list-sshpublic-keys-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listSSHPublicKeys, listSSHPublicKeys"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-sshpublic-keys,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-sshpublic-keys,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-sshpublic-keys
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listSSHPublicKeys, listSSHPublicKeys"}
   [credentials13005 & args13006]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13007
     (com.palletops.awaze.common/aws-client :iam credentials13005)]
    (clojure.core/case
     (clojure.core/count args13006)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13007
       listSSHPublicKeys))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13007
       listSSHPublicKeys
       (identitymanagement/list-sshpublic-keys-request
        (clojure.core/nth args13006 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :add-role-to-instance-profile
   [m13008]
   (clojure.core/let
    [credentials13009 (:credentials m13008) args13010 (:args m13008)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13011
      (com.palletops.awaze.common/aws-client :iam credentials13009)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13011
       addRoleToInstanceProfile
       (identitymanagement/add-role-to-instance-profile-request
        (clojure.core/nth args13010 0)))))))
  (clojure.core/defn
   add-role-to-instance-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         instance-profile-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for addRoleToInstanceProfile"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :add-role-to-instance-profile,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   add-role-to-instance-profile
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         instance-profile-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call addRoleToInstanceProfile"}
   [credentials13013 & args13014]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13015
     (com.palletops.awaze.common/aws-client :iam credentials13013)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13015
      addRoleToInstanceProfile
      (identitymanagement/add-role-to-instance-profile-request
       (clojure.core/nth args13014 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :enable-mfadevice
   [m13016]
   (clojure.core/let
    [credentials13017 (:credentials m13016) args13018 (:args m13016)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13019
      (com.palletops.awaze.common/aws-client :iam credentials13017)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13019
       enableMFADevice
       (identitymanagement/enable-mfadevice-request
        (clojure.core/nth args13018 0)))))))
  (clojure.core/defn
   enable-mfadevice-map
   {:arglists (quote
               [[credentials
                 {:keys [serial-number
                         authentication-code2
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         authentication-code1
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for enableMFADevice"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :enable-mfadevice,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   enable-mfadevice
   {:arglists (quote
               [[credentials
                 {:keys [serial-number
                         authentication-code2
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         authentication-code1
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call enableMFADevice"}
   [credentials13021 & args13022]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13023
     (com.palletops.awaze.common/aws-client :iam credentials13021)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13023
      enableMFADevice
      (identitymanagement/enable-mfadevice-request
       (clojure.core/nth args13022 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-groups
   [m13024]
   (clojure.core/let
    [credentials13025 (:credentials m13024) args13026 (:args m13024)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13027
      (com.palletops.awaze.common/aws-client :iam credentials13025)]
     (clojure.core/case
      (clojure.core/count args13026)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13027
        listGroups
        (identitymanagement/list-groups-request
         (clojure.core/nth args13026 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13027
        listGroups))))))
  (clojure.core/defn
   list-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listGroups, listGroups"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-groups,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-groups,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-groups
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listGroups, listGroups"}
   [credentials13029 & args13030]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13031
     (com.palletops.awaze.common/aws-client :iam credentials13029)]
    (clojure.core/case
     (clojure.core/count args13030)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13031
       listGroups
       (identitymanagement/list-groups-request
        (clojure.core/nth args13030 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13031
       listGroups))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-policy-version
   [m13032]
   (clojure.core/let
    [credentials13033 (:credentials m13032) args13034 (:args m13032)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13035
      (com.palletops.awaze.common/aws-client :iam credentials13033)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13035
       deletePolicyVersion
       (identitymanagement/delete-policy-version-request
        (clojure.core/nth args13034 0)))))))
  (clojure.core/defn
   delete-policy-version-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deletePolicyVersion"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-policy-version,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-policy-version
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call deletePolicyVersion"}
   [credentials13037 & args13038]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13039
     (com.palletops.awaze.common/aws-client :iam credentials13037)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13039
      deletePolicyVersion
      (identitymanagement/delete-policy-version-request
       (clojure.core/nth args13038 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-access-key
   [m13040]
   (clojure.core/let
    [credentials13041 (:credentials m13040) args13042 (:args m13040)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13043
      (com.palletops.awaze.common/aws-client :iam credentials13041)]
     (clojure.core/case
      (clojure.core/count args13042)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13043
        createAccessKey
        (identitymanagement/create-access-key-request
         (clojure.core/nth args13042 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13043
        createAccessKey))))))
  (clojure.core/defn
   create-access-key-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for createAccessKey, createAccessKey"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :create-access-key,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-access-key,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   create-access-key
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call createAccessKey, createAccessKey"}
   [credentials13045 & args13046]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13047
     (com.palletops.awaze.common/aws-client :iam credentials13045)]
    (clojure.core/case
     (clojure.core/count args13046)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13047
       createAccessKey
       (identitymanagement/create-access-key-request
        (clojure.core/nth args13046 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13047
       createAccessKey))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-virtual-mfadevice
   [m13048]
   (clojure.core/let
    [credentials13049 (:credentials m13048) args13050 (:args m13048)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13051
      (com.palletops.awaze.common/aws-client :iam credentials13049)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13051
       deleteVirtualMFADevice
       (identitymanagement/delete-virtual-mfadevice-request
        (clojure.core/nth args13050 0)))))))
  (clojure.core/defn
   delete-virtual-mfadevice-map
   {:arglists (quote
               [[credentials
                 {:keys [serial-number
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteVirtualMFADevice"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-virtual-mfadevice,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-virtual-mfadevice
   {:arglists (quote
               [[credentials
                 {:keys [serial-number
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteVirtualMFADevice"}
   [credentials13053 & args13054]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13055
     (com.palletops.awaze.common/aws-client :iam credentials13053)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13055
      deleteVirtualMFADevice
      (identitymanagement/delete-virtual-mfadevice-request
       (clojure.core/nth args13054 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-instance-profile
   [m13056]
   (clojure.core/let
    [credentials13057 (:credentials m13056) args13058 (:args m13056)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13059
      (com.palletops.awaze.common/aws-client :iam credentials13057)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13059
       getInstanceProfile
       (identitymanagement/get-instance-profile-request
        (clojure.core/nth args13058 0)))))))
  (clojure.core/defn
   get-instance-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         instance-profile-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getInstanceProfile"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-instance-profile,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-instance-profile
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         instance-profile-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getInstanceProfile"}
   [credentials13061 & args13062]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13063
     (com.palletops.awaze.common/aws-client :iam credentials13061)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13063
      getInstanceProfile
      (identitymanagement/get-instance-profile-request
       (clojure.core/nth args13062 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-samlprovider
   [m13064]
   (clojure.core/let
    [credentials13065 (:credentials m13064) args13066 (:args m13064)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13067
      (com.palletops.awaze.common/aws-client :iam credentials13065)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13067
       createSAMLProvider
       (identitymanagement/create-samlprovider-request
        (clojure.core/nth args13066 0)))))))
  (clojure.core/defn
   create-samlprovider-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         samlmetadata-document
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createSAMLProvider"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-samlprovider,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   create-samlprovider
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         samlmetadata-document
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createSAMLProvider"}
   [credentials13069 & args13070]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13071
     (com.palletops.awaze.common/aws-client :iam credentials13069)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13071
      createSAMLProvider
      (identitymanagement/create-samlprovider-request
       (clojure.core/nth args13070 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-samlprovider
   [m13072]
   (clojure.core/let
    [credentials13073 (:credentials m13072) args13074 (:args m13072)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13075
      (com.palletops.awaze.common/aws-client :iam credentials13073)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13075
       updateSAMLProvider
       (identitymanagement/update-samlprovider-request
        (clojure.core/nth args13074 0)))))))
  (clojure.core/defn
   update-samlprovider-map
   {:arglists (quote
               [[credentials
                 {:keys [samlprovider-arn
                         custom-request-headers
                         sdk-client-execution-timeout
                         samlmetadata-document
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateSAMLProvider"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-samlprovider,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   update-samlprovider
   {:arglists (quote
               [[credentials
                 {:keys [samlprovider-arn
                         custom-request-headers
                         sdk-client-execution-timeout
                         samlmetadata-document
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateSAMLProvider"}
   [credentials13077 & args13078]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13079
     (com.palletops.awaze.common/aws-client :iam credentials13077)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13079
      updateSAMLProvider
      (identitymanagement/update-samlprovider-request
       (clojure.core/nth args13078 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-sshpublic-key
   [m13080]
   (clojure.core/let
    [credentials13081 (:credentials m13080) args13082 (:args m13080)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13083
      (com.palletops.awaze.common/aws-client :iam credentials13081)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13083
       deleteSSHPublicKey
       (identitymanagement/delete-sshpublic-key-request
        (clojure.core/nth args13082 0)))))))
  (clojure.core/defn
   delete-sshpublic-key-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         sshpublic-key-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteSSHPublicKey"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-sshpublic-key,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-sshpublic-key
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         sshpublic-key-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteSSHPublicKey"}
   [credentials13085 & args13086]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13087
     (com.palletops.awaze.common/aws-client :iam credentials13085)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13087
      deleteSSHPublicKey
      (identitymanagement/delete-sshpublic-key-request
       (clojure.core/nth args13086 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :simulate-custom-policy
   [m13088]
   (clojure.core/let
    [credentials13089 (:credentials m13088) args13090 (:args m13088)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13091
      (com.palletops.awaze.common/aws-client :iam credentials13089)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13091
       simulateCustomPolicy
       (identitymanagement/simulate-custom-policy-request
        (clojure.core/nth args13090 0)))))))
  (clojure.core/defn
   simulate-custom-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-input-list
                         custom-request-headers
                         sdk-client-execution-timeout
                         resource-arns
                         sdk-request-timeout
                         marker
                         resource-handling-option
                         custom-query-parameters
                         max-items
                         context-entries
                         resource-owner
                         action-names
                         read-limit
                         caller-arn
                         general-progress-listener
                         clone-source
                         clone-root
                         resource-policy]}]]),
    :doc "Generate map for simulateCustomPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :simulate-custom-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   simulate-custom-policy
   {:arglists (quote
               [[credentials
                 {:keys [policy-input-list
                         custom-request-headers
                         sdk-client-execution-timeout
                         resource-arns
                         sdk-request-timeout
                         marker
                         resource-handling-option
                         custom-query-parameters
                         max-items
                         context-entries
                         resource-owner
                         action-names
                         read-limit
                         caller-arn
                         general-progress-listener
                         clone-source
                         clone-root
                         resource-policy]}]]),
    :doc "Call simulateCustomPolicy"}
   [credentials13093 & args13094]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13095
     (com.palletops.awaze.common/aws-client :iam credentials13093)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13095
      simulateCustomPolicy
      (identitymanagement/simulate-custom-policy-request
       (clojure.core/nth args13094 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-context-keys-for-custom-policy
   [m13096]
   (clojure.core/let
    [credentials13097 (:credentials m13096) args13098 (:args m13096)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13099
      (com.palletops.awaze.common/aws-client :iam credentials13097)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13099
       getContextKeysForCustomPolicy
       (identitymanagement/get-context-keys-for-custom-policy-request
        (clojure.core/nth args13098 0)))))))
  (clojure.core/defn
   get-context-keys-for-custom-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-input-list
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getContextKeysForCustomPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-context-keys-for-custom-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-context-keys-for-custom-policy
   {:arglists (quote
               [[credentials
                 {:keys [policy-input-list
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getContextKeysForCustomPolicy"}
   [credentials13101 & args13102]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13103
     (com.palletops.awaze.common/aws-client :iam credentials13101)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13103
      getContextKeysForCustomPolicy
      (identitymanagement/get-context-keys-for-custom-policy-request
       (clojure.core/nth args13102 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-user-policies
   [m13104]
   (clojure.core/let
    [credentials13105 (:credentials m13104) args13106 (:args m13104)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13107
      (com.palletops.awaze.common/aws-client :iam credentials13105)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13107
       listUserPolicies
       (identitymanagement/list-user-policies-request
        (clojure.core/nth args13106 0)))))))
  (clojure.core/defn
   list-user-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listUserPolicies"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-user-policies,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-user-policies
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listUserPolicies"}
   [credentials13109 & args13110]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13111
     (com.palletops.awaze.common/aws-client :iam credentials13109)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13111
      listUserPolicies
      (identitymanagement/list-user-policies-request
       (clojure.core/nth args13110 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-group
   [m13112]
   (clojure.core/let
    [credentials13113 (:credentials m13112) args13114 (:args m13112)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13115
      (com.palletops.awaze.common/aws-client :iam credentials13113)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13115
       updateGroup
       (identitymanagement/update-group-request
        (clojure.core/nth args13114 0)))))))
  (clojure.core/defn
   update-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         new-path
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         new-group-name
                         clone-root]}]]),
    :doc "Generate map for updateGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-group,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   update-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         new-path
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         new-group-name
                         clone-root]}]]),
    :doc "Call updateGroup"}
   [credentials13117 & args13118]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13119
     (com.palletops.awaze.common/aws-client :iam credentials13117)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13119
      updateGroup
      (identitymanagement/update-group-request
       (clojure.core/nth args13118 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-entities-for-policy
   [m13120]
   (clojure.core/let
    [credentials13121 (:credentials m13120) args13122 (:args m13120)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13123
      (com.palletops.awaze.common/aws-client :iam credentials13121)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13123
       listEntitiesForPolicy
       (identitymanagement/list-entities-for-policy-request
        (clojure.core/nth args13122 0)))))))
  (clojure.core/defn
   list-entities-for-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         entity-filter
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listEntitiesForPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-entities-for-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-entities-for-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         entity-filter
                         marker
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call listEntitiesForPolicy"}
   [credentials13125 & args13126]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13127
     (com.palletops.awaze.common/aws-client :iam credentials13125)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13127
      listEntitiesForPolicy
      (identitymanagement/list-entities-for-policy-request
       (clojure.core/nth args13126 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-policies
   [m13128]
   (clojure.core/let
    [credentials13129 (:credentials m13128) args13130 (:args m13128)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13131
      (com.palletops.awaze.common/aws-client :iam credentials13129)]
     (clojure.core/case
      (clojure.core/count args13130)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13131
        listPolicies))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13131
        listPolicies
        (identitymanagement/list-policies-request
         (clojure.core/nth args13130 0))))))))
  (clojure.core/defn
   list-policies-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         only-attached
                         custom-query-parameters
                         max-items
                         scope
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listPolicies, listPolicies"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-policies,
     :credentials credentials__1842__auto__,
     :client :iam})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-policies,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-policies
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         path-prefix
                         only-attached
                         custom-query-parameters
                         max-items
                         scope
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listPolicies, listPolicies"}
   [credentials13133 & args13134]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13135
     (com.palletops.awaze.common/aws-client :iam credentials13133)]
    (clojure.core/case
     (clojure.core/count args13134)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13135
       listPolicies))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13135
       listPolicies
       (identitymanagement/list-policies-request
        (clojure.core/nth args13134 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-user
   [m13136]
   (clojure.core/let
    [credentials13137 (:credentials m13136) args13138 (:args m13136)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13139
      (com.palletops.awaze.common/aws-client :iam credentials13137)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13139
       deleteUser
       (identitymanagement/delete-user-request
        (clojure.core/nth args13138 0)))))))
  (clojure.core/defn
   delete-user-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteUser"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-user,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   delete-user
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteUser"}
   [credentials13141 & args13142]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13143
     (com.palletops.awaze.common/aws-client :iam credentials13141)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13143
      deleteUser
      (identitymanagement/delete-user-request
       (clojure.core/nth args13142 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-signing-certificate
   [m13144]
   (clojure.core/let
    [credentials13145 (:credentials m13144) args13146 (:args m13144)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13147
      (com.palletops.awaze.common/aws-client :iam credentials13145)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13147
       updateSigningCertificate
       (identitymanagement/update-signing-certificate-request
        (clojure.core/nth args13146 0)))))))
  (clojure.core/defn
   update-signing-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         status
                         certificate-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateSigningCertificate"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-signing-certificate,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   update-signing-certificate
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         status
                         certificate-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateSigningCertificate"}
   [credentials13149 & args13150]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13151
     (com.palletops.awaze.common/aws-client :iam credentials13149)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13151
      updateSigningCertificate
      (identitymanagement/update-signing-certificate-request
       (clojure.core/nth args13150 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-context-keys-for-principal-policy
   [m13152]
   (clojure.core/let
    [credentials13153 (:credentials m13152) args13154 (:args m13152)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13155
      (com.palletops.awaze.common/aws-client :iam credentials13153)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13155
       getContextKeysForPrincipalPolicy
       (identitymanagement/get-context-keys-for-principal-policy-request
        (clojure.core/nth args13154 0)))))))
  (clojure.core/defn
   get-context-keys-for-principal-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-input-list
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-source-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getContextKeysForPrincipalPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-context-keys-for-principal-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-context-keys-for-principal-policy
   {:arglists (quote
               [[credentials
                 {:keys [policy-input-list
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-source-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call getContextKeysForPrincipalPolicy"}
   [credentials13157 & args13158]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13159
     (com.palletops.awaze.common/aws-client :iam credentials13157)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13159
      getContextKeysForPrincipalPolicy
      (identitymanagement/get-context-keys-for-principal-policy-request
       (clojure.core/nth args13158 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-server-certificate
   [m13160]
   (clojure.core/let
    [credentials13161 (:credentials m13160) args13162 (:args m13160)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13163
      (com.palletops.awaze.common/aws-client :iam credentials13161)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13163
       updateServerCertificate
       (identitymanagement/update-server-certificate-request
        (clojure.core/nth args13162 0)))))))
  (clojure.core/defn
   update-server-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [server-certificate-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         new-path
                         sdk-request-timeout
                         custom-query-parameters
                         new-server-certificate-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateServerCertificate"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-server-certificate,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   update-server-certificate
   {:arglists (quote
               [[credentials
                 {:keys [server-certificate-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         new-path
                         sdk-request-timeout
                         custom-query-parameters
                         new-server-certificate-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateServerCertificate"}
   [credentials13165 & args13166]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13167
     (com.palletops.awaze.common/aws-client :iam credentials13165)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13167
      updateServerCertificate
      (identitymanagement/update-server-certificate-request
       (clojure.core/nth args13166 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-attached-user-policies
   [m13168]
   (clojure.core/let
    [credentials13169 (:credentials m13168) args13170 (:args m13168)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13171
      (com.palletops.awaze.common/aws-client :iam credentials13169)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13171
       listAttachedUserPolicies
       (identitymanagement/list-attached-user-policies-request
        (clojure.core/nth args13170 0)))))))
  (clojure.core/defn
   list-attached-user-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listAttachedUserPolicies"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-attached-user-policies,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   list-attached-user-policies
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         user-name
                         path-prefix
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listAttachedUserPolicies"}
   [credentials13173 & args13174]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13175
     (com.palletops.awaze.common/aws-client :iam credentials13173)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13175
      listAttachedUserPolicies
      (identitymanagement/list-attached-user-policies-request
       (clojure.core/nth args13174 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-policy-version
   [m13176]
   (clojure.core/let
    [credentials13177 (:credentials m13176) args13178 (:args m13176)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13179
      (com.palletops.awaze.common/aws-client :iam credentials13177)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13179
       createPolicyVersion
       (identitymanagement/create-policy-version-request
        (clojure.core/nth args13178 0)))))))
  (clojure.core/defn
   create-policy-version-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root
                         set-as-default]}]]),
    :doc "Generate map for createPolicyVersion"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-policy-version,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   create-policy-version
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root
                         set-as-default]}]]),
    :doc "Call createPolicyVersion"}
   [credentials13181 & args13182]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13183
     (com.palletops.awaze.common/aws-client :iam credentials13181)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13183
      createPolicyVersion
      (identitymanagement/create-policy-version-request
       (clojure.core/nth args13182 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-login-profile
   [m13184]
   (clojure.core/let
    [credentials13185 (:credentials m13184) args13186 (:args m13184)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13187
      (com.palletops.awaze.common/aws-client :iam credentials13185)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13187
       createLoginProfile
       (identitymanagement/create-login-profile-request
        (clojure.core/nth args13186 0)))))))
  (clojure.core/defn
   create-login-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         password
                         sdk-request-timeout
                         password-reset-required
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createLoginProfile"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-login-profile,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   create-login-profile
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         password
                         sdk-request-timeout
                         password-reset-required
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createLoginProfile"}
   [credentials13189 & args13190]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13191
     (com.palletops.awaze.common/aws-client :iam credentials13189)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13191
      createLoginProfile
      (identitymanagement/create-login-profile-request
       (clojure.core/nth args13190 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :simulate-principal-policy
   [m13192]
   (clojure.core/let
    [credentials13193 (:credentials m13192) args13194 (:args m13192)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13195
      (com.palletops.awaze.common/aws-client :iam credentials13193)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13195
       simulatePrincipalPolicy
       (identitymanagement/simulate-principal-policy-request
        (clojure.core/nth args13194 0)))))))
  (clojure.core/defn
   simulate-principal-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-input-list
                         custom-request-headers
                         sdk-client-execution-timeout
                         resource-arns
                         sdk-request-timeout
                         marker
                         resource-handling-option
                         custom-query-parameters
                         max-items
                         context-entries
                         resource-owner
                         action-names
                         read-limit
                         caller-arn
                         general-progress-listener
                         policy-source-arn
                         clone-source
                         clone-root
                         resource-policy]}]]),
    :doc "Generate map for simulatePrincipalPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :simulate-principal-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   simulate-principal-policy
   {:arglists (quote
               [[credentials
                 {:keys [policy-input-list
                         custom-request-headers
                         sdk-client-execution-timeout
                         resource-arns
                         sdk-request-timeout
                         marker
                         resource-handling-option
                         custom-query-parameters
                         max-items
                         context-entries
                         resource-owner
                         action-names
                         read-limit
                         caller-arn
                         general-progress-listener
                         policy-source-arn
                         clone-source
                         clone-root
                         resource-policy]}]]),
    :doc "Call simulatePrincipalPolicy"}
   [credentials13197 & args13198]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13199
     (com.palletops.awaze.common/aws-client :iam credentials13197)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13199
      simulatePrincipalPolicy
      (identitymanagement/simulate-principal-policy-request
       (clojure.core/nth args13198 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-open-idconnect-provider
   [m13200]
   (clojure.core/let
    [credentials13201 (:credentials m13200) args13202 (:args m13200)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13203
      (com.palletops.awaze.common/aws-client :iam credentials13201)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13203
       createOpenIDConnectProvider
       (identitymanagement/create-open-idconnect-provider-request
        (clojure.core/nth args13202 0)))))))
  (clojure.core/defn
   create-open-idconnect-provider-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         client-idlist
                         sdk-request-timeout
                         custom-query-parameters
                         thumbprint-list
                         read-limit
                         general-progress-listener
                         url
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createOpenIDConnectProvider"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-open-idconnect-provider,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   create-open-idconnect-provider
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         client-idlist
                         sdk-request-timeout
                         custom-query-parameters
                         thumbprint-list
                         read-limit
                         general-progress-listener
                         url
                         clone-source
                         clone-root]}]]),
    :doc "Call createOpenIDConnectProvider"}
   [credentials13205 & args13206]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13207
     (com.palletops.awaze.common/aws-client :iam credentials13205)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13207
      createOpenIDConnectProvider
      (identitymanagement/create-open-idconnect-provider-request
       (clojure.core/nth args13206 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :attach-role-policy
   [m13208]
   (clojure.core/let
    [credentials13209 (:credentials m13208) args13210 (:args m13208)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13211
      (com.palletops.awaze.common/aws-client :iam credentials13209)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13211
       attachRolePolicy
       (identitymanagement/attach-role-policy-request
        (clojure.core/nth args13210 0)))))))
  (clojure.core/defn
   attach-role-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for attachRolePolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :attach-role-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   attach-role-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call attachRolePolicy"}
   [credentials13213 & args13214]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13215
     (com.palletops.awaze.common/aws-client :iam credentials13213)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13215
      attachRolePolicy
      (identitymanagement/attach-role-policy-request
       (clojure.core/nth args13214 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-group-policy
   [m13216]
   (clojure.core/let
    [credentials13217 (:credentials m13216) args13218 (:args m13216)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13219
      (com.palletops.awaze.common/aws-client :iam credentials13217)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13219
       getGroupPolicy
       (identitymanagement/get-group-policy-request
        (clojure.core/nth args13218 0)))))))
  (clojure.core/defn
   get-group-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getGroupPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-group-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   get-group-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getGroupPolicy"}
   [credentials13221 & args13222]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13223
     (com.palletops.awaze.common/aws-client :iam credentials13221)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13223
      getGroupPolicy
      (identitymanagement/get-group-policy-request
       (clojure.core/nth args13222 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :detach-user-policy
   [m13224]
   (clojure.core/let
    [credentials13225 (:credentials m13224) args13226 (:args m13224)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client13227
      (com.palletops.awaze.common/aws-client :iam credentials13225)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13227
       detachUserPolicy
       (identitymanagement/detach-user-policy-request
        (clojure.core/nth args13226 0)))))))
  (clojure.core/defn
   detach-user-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for detachUserPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :detach-user-policy,
     :credentials credentials__1842__auto__,
     :client :iam}))
  (clojure.core/defn
   detach-user-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         user-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         policy-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call detachUserPolicy"}
   [credentials13229 & args13230]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client13231
     (com.palletops.awaze.common/aws-client :iam credentials13229)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client13231
      detachUserPolicy
      (identitymanagement/detach-user-policy-request
       (clojure.core/nth args13230 0))))))))
