(ns
 com.palletops.awaze.elasticmapreduce
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.elasticmapreduce :as elasticmapreduce]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :elasticmapreduce
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.Configuration}
configuration
  [m8159]
  (clojure.core/let
   [bean8158
    (new com.amazonaws.services.elasticmapreduce.model.Configuration)]
   (clojure.core/let
    [v8160
     (:configurations m8159 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8160 :com.palletops.awaze.client-builder/undef)
     (.
      bean8158
      setConfigurations
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8263] (elasticmapreduce/configuration arg8263))
 v8160))))
   (clojure.core/let
    [v8160
     (:classification m8159 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8160 :com.palletops.awaze.client-builder/undef)
     (. bean8158 setClassification (clojure.core/str v8160))))
   (clojure.core/let
    [v8160
     (:properties m8159 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8160 :com.palletops.awaze.client-builder/undef)
     (.
      bean8158
      setProperties
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg8264] (clojure.core/str arg8264))
  (clojure.core/keys v8160))
 (clojure.core/map
  (clojure.core/fn [arg8264] (clojure.core/str arg8264))
  (clojure.core/vals v8160))))))
   bean8158))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.VolumeSpecification}
volume-specification
  [m8162]
  (clojure.core/let
   [bean8161
    (new
     com.amazonaws.services.elasticmapreduce.model.VolumeSpecification)]
   (clojure.core/let
    [v8163
     (:volume-type m8162 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8163 :com.palletops.awaze.client-builder/undef)
     (. bean8161 setVolumeType (clojure.core/str v8163))))
   (clojure.core/let
    [v8163 (:iops m8162 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8163 :com.palletops.awaze.client-builder/undef)
     (. bean8161 setIops (clojure.core/int v8163))))
   (clojure.core/let
    [v8163
     (:size-in-gb m8162 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8163 :com.palletops.awaze.client-builder/undef)
     (. bean8161 setSizeInGB (clojure.core/int v8163))))
   bean8161))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.EbsBlockDeviceConfig}
ebs-block-device-config
  [m8165]
  (clojure.core/let
   [bean8164
    (new
     com.amazonaws.services.elasticmapreduce.model.EbsBlockDeviceConfig)]
   (clojure.core/let
    [v8166
     (:volume-specification
      m8165
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8166 :com.palletops.awaze.client-builder/undef)
     (.
      bean8164
      setVolumeSpecification
      (elasticmapreduce/volume-specification v8166))))
   (clojure.core/let
    [v8166
     (:volumes-per-instance
      m8165
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8166 :com.palletops.awaze.client-builder/undef)
     (. bean8164 setVolumesPerInstance (clojure.core/int v8166))))
   bean8164))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.MarketType}
market-type
  [m8168]
  (.
   com.amazonaws.services.elasticmapreduce.model.MarketType
   fromValue
   (clojure.core/name m8168)))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.EbsConfiguration}
ebs-configuration
  [m8171]
  (clojure.core/let
   [bean8170
    (new
     com.amazonaws.services.elasticmapreduce.model.EbsConfiguration)]
   (clojure.core/let
    [v8172
     (:ebs-optimized m8171 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8172 :com.palletops.awaze.client-builder/undef)
     (. bean8170 setEbsOptimized (clojure.core/boolean v8172))))
   (clojure.core/let
    [v8172
     (:ebs-block-device-configs
      m8171
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8172 :com.palletops.awaze.client-builder/undef)
     (.
      bean8170
      setEbsBlockDeviceConfigs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg8265]
  (elasticmapreduce/ebs-block-device-config arg8265))
 v8172))))
   bean8170))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.KeyValue}
key-value
  [m8174]
  (clojure.core/let
   [bean8173
    (new com.amazonaws.services.elasticmapreduce.model.KeyValue)]
   (clojure.core/let
    [v8175 (:key m8174 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8175 :com.palletops.awaze.client-builder/undef)
     (. bean8173 setKey (clojure.core/str v8175))))
   (clojure.core/let
    [v8175 (:value m8174 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8175 :com.palletops.awaze.client-builder/undef)
     (. bean8173 setValue (clojure.core/str v8175))))
   bean8173))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.PlacementType}
placement-type
  [m8177]
  (clojure.core/let
   [bean8176
    (new com.amazonaws.services.elasticmapreduce.model.PlacementType)]
   (clojure.core/let
    [v8178
     (:availability-zone
      m8177
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8178 :com.palletops.awaze.client-builder/undef)
     (. bean8176 setAvailabilityZone (clojure.core/str v8178))))
   bean8176))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.InstanceGroupConfig}
instance-group-config
  [m8180]
  (clojure.core/let
   [bean8179
    (new
     com.amazonaws.services.elasticmapreduce.model.InstanceGroupConfig)]
   (clojure.core/let
    [v8181
     (:configurations m8180 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8181 :com.palletops.awaze.client-builder/undef)
     (.
      bean8179
      setConfigurations
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8266] (elasticmapreduce/configuration arg8266))
 v8181))))
   (clojure.core/let
    [v8181
     (:instance-type m8180 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8181 :com.palletops.awaze.client-builder/undef)
     (. bean8179 setInstanceType (clojure.core/str v8181))))
   (clojure.core/let
    [v8181
     (:instance-count m8180 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8181 :com.palletops.awaze.client-builder/undef)
     (. bean8179 setInstanceCount (clojure.core/int v8181))))
   (clojure.core/let
    [v8181 (:market m8180 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8181 :com.palletops.awaze.client-builder/undef)
     (. bean8179 setMarket (elasticmapreduce/market-type v8181))))
   (clojure.core/let
    [v8181
     (:instance-role m8180 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8181 :com.palletops.awaze.client-builder/undef)
     (. bean8179 setInstanceRole (clojure.core/str v8181))))
   (clojure.core/let
    [v8181
     (:bid-price m8180 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8181 :com.palletops.awaze.client-builder/undef)
     (. bean8179 setBidPrice (clojure.core/str v8181))))
   (clojure.core/let
    [v8181
     (:ebs-configuration
      m8180
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8181 :com.palletops.awaze.client-builder/undef)
     (.
      bean8179
      setEbsConfiguration
      (elasticmapreduce/ebs-configuration v8181))))
   (clojure.core/let
    [v8181 (:name m8180 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8181 :com.palletops.awaze.client-builder/undef)
     (. bean8179 setName (clojure.core/str v8181))))
   bean8179))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.HadoopJarStepConfig}
hadoop-jar-step-config
  [m8183]
  (clojure.core/let
   [bean8182
    (new
     com.amazonaws.services.elasticmapreduce.model.HadoopJarStepConfig)]
   (clojure.core/let
    [v8184 (:args m8183 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8184 :com.palletops.awaze.client-builder/undef)
     (.
      bean8182
      setArgs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8267] (clojure.core/str arg8267))
 v8184))))
   (clojure.core/let
    [v8184 (:jar m8183 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8184 :com.palletops.awaze.client-builder/undef)
     (. bean8182 setJar (clojure.core/str v8184))))
   (clojure.core/let
    [v8184
     (:main-class m8183 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8184 :com.palletops.awaze.client-builder/undef)
     (. bean8182 setMainClass (clojure.core/str v8184))))
   (clojure.core/let
    [v8184
     (:properties m8183 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8184 :com.palletops.awaze.client-builder/undef)
     (.
      bean8182
      setProperties
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8268] (elasticmapreduce/key-value arg8268))
 v8184))))
   bean8182))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.ActionOnFailure}
action-on-failure
  [m8186]
  (.
   com.amazonaws.services.elasticmapreduce.model.ActionOnFailure
   fromValue
   (clojure.core/name m8186)))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.ScriptBootstrapActionConfig}
script-bootstrap-action-config
  [m8189]
  (clojure.core/let
   [bean8188
    (new
     com.amazonaws.services.elasticmapreduce.model.ScriptBootstrapActionConfig)]
   (clojure.core/let
    [v8190 (:args m8189 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8190 :com.palletops.awaze.client-builder/undef)
     (.
      bean8188
      setArgs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8269] (clojure.core/str arg8269))
 v8190))))
   (clojure.core/let
    [v8190 (:path m8189 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8190 :com.palletops.awaze.client-builder/undef)
     (. bean8188 setPath (clojure.core/str v8190))))
   bean8188))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.InstanceGroupModifyConfig}
instance-group-modify-config
  [m8192]
  (clojure.core/let
   [bean8191
    (new
     com.amazonaws.services.elasticmapreduce.model.InstanceGroupModifyConfig)]
   (clojure.core/let
    [v8193
     (:instance-group-id
      m8192
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8193 :com.palletops.awaze.client-builder/undef)
     (. bean8191 setInstanceGroupId (clojure.core/str v8193))))
   (clojure.core/let
    [v8193
     (:instance-count m8192 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8193 :com.palletops.awaze.client-builder/undef)
     (. bean8191 setInstanceCount (clojure.core/int v8193))))
   (clojure.core/let
    [v8193
     (:ec2instance-ids-to-terminate
      m8192
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8193 :com.palletops.awaze.client-builder/undef)
     (.
      bean8191
      setEC2InstanceIdsToTerminate
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8270] (clojure.core/str arg8270))
 v8193))))
   bean8191))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.Tag}
tag
  [m8195]
  (clojure.core/let
   [bean8194 (new com.amazonaws.services.elasticmapreduce.model.Tag)]
   (clojure.core/let
    [v8196 (:key m8195 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8196 :com.palletops.awaze.client-builder/undef)
     (. bean8194 setKey (clojure.core/str v8196))))
   (clojure.core/let
    [v8196 (:value m8195 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8196 :com.palletops.awaze.client-builder/undef)
     (. bean8194 setValue (clojure.core/str v8196))))
   bean8194))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.JobFlowInstancesConfig}
job-flow-instances-config
  [m8198]
  (clojure.core/let
   [bean8197
    (new
     com.amazonaws.services.elasticmapreduce.model.JobFlowInstancesConfig)]
   (clojure.core/let
    [v8199
     (:additional-master-security-groups
      m8198
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8199 :com.palletops.awaze.client-builder/undef)
     (.
      bean8197
      setAdditionalMasterSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8271] (clojure.core/str arg8271))
 v8199))))
   (clojure.core/let
    [v8199
     (:keep-job-flow-alive-when-no-steps
      m8198
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8199 :com.palletops.awaze.client-builder/undef)
     (.
      bean8197
      setKeepJobFlowAliveWhenNoSteps
      (clojure.core/boolean v8199))))
   (clojure.core/let
    [v8199
     (:placement m8198 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8199 :com.palletops.awaze.client-builder/undef)
     (. bean8197 setPlacement (elasticmapreduce/placement-type v8199))))
   (clojure.core/let
    [v8199
     (:hadoop-version m8198 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8199 :com.palletops.awaze.client-builder/undef)
     (. bean8197 setHadoopVersion (clojure.core/str v8199))))
   (clojure.core/let
    [v8199
     (:ec2subnet-id m8198 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8199 :com.palletops.awaze.client-builder/undef)
     (. bean8197 setEc2SubnetId (clojure.core/str v8199))))
   (clojure.core/let
    [v8199
     (:master-instance-type
      m8198
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8199 :com.palletops.awaze.client-builder/undef)
     (. bean8197 setMasterInstanceType (clojure.core/str v8199))))
   (clojure.core/let
    [v8199
     (:slave-instance-type
      m8198
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8199 :com.palletops.awaze.client-builder/undef)
     (. bean8197 setSlaveInstanceType (clojure.core/str v8199))))
   (clojure.core/let
    [v8199
     (:termination-protected
      m8198
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8199 :com.palletops.awaze.client-builder/undef)
     (. bean8197 setTerminationProtected (clojure.core/boolean v8199))))
   (clojure.core/let
    [v8199
     (:emr-managed-master-security-group
      m8198
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8199 :com.palletops.awaze.client-builder/undef)
     (.
      bean8197
      setEmrManagedMasterSecurityGroup
      (clojure.core/str v8199))))
   (clojure.core/let
    [v8199
     (:additional-slave-security-groups
      m8198
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8199 :com.palletops.awaze.client-builder/undef)
     (.
      bean8197
      setAdditionalSlaveSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8272] (clojure.core/str arg8272))
 v8199))))
   (clojure.core/let
    [v8199
     (:ec2key-name m8198 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8199 :com.palletops.awaze.client-builder/undef)
     (. bean8197 setEc2KeyName (clojure.core/str v8199))))
   (clojure.core/let
    [v8199
     (:instance-count m8198 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8199 :com.palletops.awaze.client-builder/undef)
     (. bean8197 setInstanceCount (clojure.core/int v8199))))
   (clojure.core/let
    [v8199
     (:instance-groups
      m8198
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8199 :com.palletops.awaze.client-builder/undef)
     (.
      bean8197
      setInstanceGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg8273]
  (elasticmapreduce/instance-group-config arg8273))
 v8199))))
   (clojure.core/let
    [v8199
     (:service-access-security-group
      m8198
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8199 :com.palletops.awaze.client-builder/undef)
     (.
      bean8197
      setServiceAccessSecurityGroup
      (clojure.core/str v8199))))
   (clojure.core/let
    [v8199
     (:emr-managed-slave-security-group
      m8198
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8199 :com.palletops.awaze.client-builder/undef)
     (.
      bean8197
      setEmrManagedSlaveSecurityGroup
      (clojure.core/str v8199))))
   bean8197))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.Application}
application
  [m8201]
  (clojure.core/let
   [bean8200
    (new com.amazonaws.services.elasticmapreduce.model.Application)]
   (clojure.core/let
    [v8202 (:version m8201 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8202 :com.palletops.awaze.client-builder/undef)
     (. bean8200 setVersion (clojure.core/str v8202))))
   (clojure.core/let
    [v8202
     (:additional-info
      m8201
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8202 :com.palletops.awaze.client-builder/undef)
     (.
      bean8200
      setAdditionalInfo
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg8274] (clojure.core/str arg8274))
  (clojure.core/keys v8202))
 (clojure.core/map
  (clojure.core/fn [arg8274] (clojure.core/str arg8274))
  (clojure.core/vals v8202))))))
   (clojure.core/let
    [v8202 (:args m8201 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8202 :com.palletops.awaze.client-builder/undef)
     (.
      bean8200
      setArgs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8275] (clojure.core/str arg8275))
 v8202))))
   (clojure.core/let
    [v8202 (:name m8201 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8202 :com.palletops.awaze.client-builder/undef)
     (. bean8200 setName (clojure.core/str v8202))))
   bean8200))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.StepConfig}
step-config
  [m8204]
  (clojure.core/let
   [bean8203
    (new com.amazonaws.services.elasticmapreduce.model.StepConfig)]
   (clojure.core/let
    [v8205
     (:hadoop-jar-step
      m8204
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8205 :com.palletops.awaze.client-builder/undef)
     (.
      bean8203
      setHadoopJarStep
      (elasticmapreduce/hadoop-jar-step-config v8205))))
   (clojure.core/let
    [v8205
     (:action-on-failure
      m8204
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8205 :com.palletops.awaze.client-builder/undef)
     (.
      bean8203
      setActionOnFailure
      (elasticmapreduce/action-on-failure v8205))))
   (clojure.core/let
    [v8205 (:name m8204 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8205 :com.palletops.awaze.client-builder/undef)
     (. bean8203 setName (clojure.core/str v8205))))
   bean8203))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.SupportedProductConfig}
supported-product-config
  [m8207]
  (clojure.core/let
   [bean8206
    (new
     com.amazonaws.services.elasticmapreduce.model.SupportedProductConfig)]
   (clojure.core/let
    [v8208 (:args m8207 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8208 :com.palletops.awaze.client-builder/undef)
     (.
      bean8206
      setArgs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8276] (clojure.core/str arg8276))
 v8208))))
   (clojure.core/let
    [v8208 (:name m8207 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8208 :com.palletops.awaze.client-builder/undef)
     (. bean8206 setName (clojure.core/str v8208))))
   bean8206))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.BootstrapActionConfig}
bootstrap-action-config
  [m8210]
  (clojure.core/let
   [bean8209
    (new
     com.amazonaws.services.elasticmapreduce.model.BootstrapActionConfig)]
   (clojure.core/let
    [v8211
     (:script-bootstrap-action
      m8210
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8211 :com.palletops.awaze.client-builder/undef)
     (.
      bean8209
      setScriptBootstrapAction
      (elasticmapreduce/script-bootstrap-action-config v8211))))
   (clojure.core/let
    [v8211 (:name m8210 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8211 :com.palletops.awaze.client-builder/undef)
     (. bean8209 setName (clojure.core/str v8211))))
   bean8209))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.ModifyInstanceGroupsRequest}
modify-instance-groups-request
  [m8213]
  (clojure.core/let
   [bean8212
    (new
     com.amazonaws.services.elasticmapreduce.model.ModifyInstanceGroupsRequest)]
   (clojure.core/let
    [v8214
     (:instance-groups
      m8213
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8214 :com.palletops.awaze.client-builder/undef)
     (.
      bean8212
      setInstanceGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg8277]
  (elasticmapreduce/instance-group-modify-config arg8277))
 v8214))))
   bean8212))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.ListInstanceGroupsRequest}
list-instance-groups-request
  [m8216]
  (clojure.core/let
   [bean8215
    (new
     com.amazonaws.services.elasticmapreduce.model.ListInstanceGroupsRequest)]
   (clojure.core/let
    [v8217
     (:cluster-id m8216 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8217 :com.palletops.awaze.client-builder/undef)
     (. bean8215 setClusterId (clojure.core/str v8217))))
   (clojure.core/let
    [v8217 (:marker m8216 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8217 :com.palletops.awaze.client-builder/undef)
     (. bean8215 setMarker (clojure.core/str v8217))))
   bean8215))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.ListClustersRequest}
list-clusters-request
  [m8219]
  (clojure.core/let
   [bean8218
    (new
     com.amazonaws.services.elasticmapreduce.model.ListClustersRequest)]
   (clojure.core/let
    [v8220
     (:created-after m8219 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8220 :com.palletops.awaze.client-builder/undef)
     (.
      bean8218
      setCreatedAfter
      (com.palletops.awaze.common/to-date v8220))))
   (clojure.core/let
    [v8220
     (:created-before m8219 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8220 :com.palletops.awaze.client-builder/undef)
     (.
      bean8218
      setCreatedBefore
      (com.palletops.awaze.common/to-date v8220))))
   (clojure.core/let
    [v8220
     (:cluster-states m8219 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8220 :com.palletops.awaze.client-builder/undef)
     (.
      bean8218
      setClusterStates
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8278] (clojure.core/str arg8278))
 v8220))))
   (clojure.core/let
    [v8220 (:marker m8219 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8220 :com.palletops.awaze.client-builder/undef)
     (. bean8218 setMarker (clojure.core/str v8220))))
   bean8218))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.RemoveTagsRequest}
remove-tags-request
  [m8222]
  (clojure.core/let
   [bean8221
    (new
     com.amazonaws.services.elasticmapreduce.model.RemoveTagsRequest)]
   (clojure.core/let
    [v8223
     (:resource-id m8222 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8223 :com.palletops.awaze.client-builder/undef)
     (. bean8221 setResourceId (clojure.core/str v8223))))
   (clojure.core/let
    [v8223
     (:tag-keys m8222 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8223 :com.palletops.awaze.client-builder/undef)
     (.
      bean8221
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8279] (clojure.core/str arg8279))
 v8223))))
   bean8221))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.AddTagsRequest}
add-tags-request
  [m8225]
  (clojure.core/let
   [bean8224
    (new com.amazonaws.services.elasticmapreduce.model.AddTagsRequest)]
   (clojure.core/let
    [v8226 (:tags m8225 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8226 :com.palletops.awaze.client-builder/undef)
     (.
      bean8224
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8280] (elasticmapreduce/tag arg8280))
 v8226))))
   (clojure.core/let
    [v8226
     (:resource-id m8225 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8226 :com.palletops.awaze.client-builder/undef)
     (. bean8224 setResourceId (clojure.core/str v8226))))
   bean8224))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.SetVisibleToAllUsersRequest}
set-visible-to-all-users-request
  [m8228]
  (clojure.core/let
   [bean8227
    (new
     com.amazonaws.services.elasticmapreduce.model.SetVisibleToAllUsersRequest)]
   (clojure.core/let
    [v8229
     (:job-flow-ids m8228 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8229 :com.palletops.awaze.client-builder/undef)
     (.
      bean8227
      setJobFlowIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8281] (clojure.core/str arg8281))
 v8229))))
   (clojure.core/let
    [v8229
     (:visible-to-all-users
      m8228
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8229 :com.palletops.awaze.client-builder/undef)
     (. bean8227 setVisibleToAllUsers (clojure.core/boolean v8229))))
   bean8227))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.ListInstancesRequest}
list-instances-request
  [m8231]
  (clojure.core/let
   [bean8230
    (new
     com.amazonaws.services.elasticmapreduce.model.ListInstancesRequest)]
   (clojure.core/let
    [v8232
     (:cluster-id m8231 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8232 :com.palletops.awaze.client-builder/undef)
     (. bean8230 setClusterId (clojure.core/str v8232))))
   (clojure.core/let
    [v8232
     (:instance-group-id
      m8231
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8232 :com.palletops.awaze.client-builder/undef)
     (. bean8230 setInstanceGroupId (clojure.core/str v8232))))
   (clojure.core/let
    [v8232
     (:instance-group-types
      m8231
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8232 :com.palletops.awaze.client-builder/undef)
     (.
      bean8230
      setInstanceGroupTypes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8282] (clojure.core/str arg8282))
 v8232))))
   (clojure.core/let
    [v8232 (:marker m8231 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8232 :com.palletops.awaze.client-builder/undef)
     (. bean8230 setMarker (clojure.core/str v8232))))
   bean8230))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.DescribeClusterRequest}
describe-cluster-request
  [m8234]
  (clojure.core/let
   [bean8233
    (new
     com.amazonaws.services.elasticmapreduce.model.DescribeClusterRequest)]
   (clojure.core/let
    [v8235
     (:cluster-id m8234 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8235 :com.palletops.awaze.client-builder/undef)
     (. bean8233 setClusterId (clojure.core/str v8235))))
   bean8233))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.ListBootstrapActionsRequest}
list-bootstrap-actions-request
  [m8237]
  (clojure.core/let
   [bean8236
    (new
     com.amazonaws.services.elasticmapreduce.model.ListBootstrapActionsRequest)]
   (clojure.core/let
    [v8238
     (:cluster-id m8237 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8238 :com.palletops.awaze.client-builder/undef)
     (. bean8236 setClusterId (clojure.core/str v8238))))
   (clojure.core/let
    [v8238 (:marker m8237 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8238 :com.palletops.awaze.client-builder/undef)
     (. bean8236 setMarker (clojure.core/str v8238))))
   bean8236))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.TerminateJobFlowsRequest}
terminate-job-flows-request
  [m8240]
  (clojure.core/let
   [bean8239
    (new
     com.amazonaws.services.elasticmapreduce.model.TerminateJobFlowsRequest)]
   (clojure.core/let
    [v8241
     (:job-flow-ids m8240 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8241 :com.palletops.awaze.client-builder/undef)
     (.
      bean8239
      setJobFlowIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8283] (clojure.core/str arg8283))
 v8241))))
   bean8239))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.DescribeJobFlowsRequest}
describe-job-flows-request
  [m8243]
  (clojure.core/let
   [bean8242
    (new
     com.amazonaws.services.elasticmapreduce.model.DescribeJobFlowsRequest)]
   (clojure.core/let
    [v8244
     (:created-after m8243 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8244 :com.palletops.awaze.client-builder/undef)
     (.
      bean8242
      setCreatedAfter
      (com.palletops.awaze.common/to-date v8244))))
   (clojure.core/let
    [v8244
     (:created-before m8243 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8244 :com.palletops.awaze.client-builder/undef)
     (.
      bean8242
      setCreatedBefore
      (com.palletops.awaze.common/to-date v8244))))
   (clojure.core/let
    [v8244
     (:job-flow-ids m8243 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8244 :com.palletops.awaze.client-builder/undef)
     (.
      bean8242
      setJobFlowIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8284] (clojure.core/str arg8284))
 v8244))))
   (clojure.core/let
    [v8244
     (:job-flow-states
      m8243
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8244 :com.palletops.awaze.client-builder/undef)
     (.
      bean8242
      setJobFlowStates
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8285] (clojure.core/str arg8285))
 v8244))))
   bean8242))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.RunJobFlowRequest}
run-job-flow-request
  [m8246]
  (clojure.core/let
   [bean8245
    (new
     com.amazonaws.services.elasticmapreduce.model.RunJobFlowRequest)]
   (clojure.core/let
    [v8247
     (:job-flow-role m8246 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8247 :com.palletops.awaze.client-builder/undef)
     (. bean8245 setJobFlowRole (clojure.core/str v8247))))
   (clojure.core/let
    [v8247
     (:instances m8246 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8247 :com.palletops.awaze.client-builder/undef)
     (.
      bean8245
      setInstances
      (elasticmapreduce/job-flow-instances-config v8247))))
   (clojure.core/let
    [v8247
     (:additional-info
      m8246
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8247 :com.palletops.awaze.client-builder/undef)
     (. bean8245 setAdditionalInfo (clojure.core/str v8247))))
   (clojure.core/let
    [v8247
     (:visible-to-all-users
      m8246
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8247 :com.palletops.awaze.client-builder/undef)
     (. bean8245 setVisibleToAllUsers (clojure.core/boolean v8247))))
   (clojure.core/let
    [v8247 (:name m8246 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8247 :com.palletops.awaze.client-builder/undef)
     (. bean8245 setName (clojure.core/str v8247))))
   (clojure.core/let
    [v8247
     (:applications m8246 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8247 :com.palletops.awaze.client-builder/undef)
     (.
      bean8245
      setApplications
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8286] (elasticmapreduce/application arg8286))
 v8247))))
   (clojure.core/let
    [v8247
     (:service-role m8246 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8247 :com.palletops.awaze.client-builder/undef)
     (. bean8245 setServiceRole (clojure.core/str v8247))))
   (clojure.core/let
    [v8247 (:steps m8246 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8247 :com.palletops.awaze.client-builder/undef)
     (.
      bean8245
      setSteps
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8287] (elasticmapreduce/step-config arg8287))
 v8247))))
   (clojure.core/let
    [v8247
     (:supported-products
      m8246
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8247 :com.palletops.awaze.client-builder/undef)
     (.
      bean8245
      setSupportedProducts
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8288] (clojure.core/str arg8288))
 v8247))))
   (clojure.core/let
    [v8247
     (:ami-version m8246 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8247 :com.palletops.awaze.client-builder/undef)
     (. bean8245 setAmiVersion (clojure.core/str v8247))))
   (clojure.core/let
    [v8247 (:tags m8246 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8247 :com.palletops.awaze.client-builder/undef)
     (.
      bean8245
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8289] (elasticmapreduce/tag arg8289))
 v8247))))
   (clojure.core/let
    [v8247 (:log-uri m8246 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8247 :com.palletops.awaze.client-builder/undef)
     (. bean8245 setLogUri (clojure.core/str v8247))))
   (clojure.core/let
    [v8247
     (:configurations m8246 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8247 :com.palletops.awaze.client-builder/undef)
     (.
      bean8245
      setConfigurations
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8290] (elasticmapreduce/configuration arg8290))
 v8247))))
   (clojure.core/let
    [v8247
     (:release-label m8246 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8247 :com.palletops.awaze.client-builder/undef)
     (. bean8245 setReleaseLabel (clojure.core/str v8247))))
   (clojure.core/let
    [v8247
     (:new-supported-products
      m8246
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8247 :com.palletops.awaze.client-builder/undef)
     (.
      bean8245
      setNewSupportedProducts
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg8291]
  (elasticmapreduce/supported-product-config arg8291))
 v8247))))
   (clojure.core/let
    [v8247
     (:bootstrap-actions
      m8246
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8247 :com.palletops.awaze.client-builder/undef)
     (.
      bean8245
      setBootstrapActions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg8292]
  (elasticmapreduce/bootstrap-action-config arg8292))
 v8247))))
   bean8245))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.AddInstanceGroupsRequest}
add-instance-groups-request
  [m8249]
  (clojure.core/let
   [bean8248
    (new
     com.amazonaws.services.elasticmapreduce.model.AddInstanceGroupsRequest)]
   (clojure.core/let
    [v8250
     (:instance-groups
      m8249
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8250 :com.palletops.awaze.client-builder/undef)
     (.
      bean8248
      setInstanceGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg8381]
  (elasticmapreduce/instance-group-config arg8381))
 v8250))))
   (clojure.core/let
    [v8250
     (:job-flow-id m8249 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8250 :com.palletops.awaze.client-builder/undef)
     (. bean8248 setJobFlowId (clojure.core/str v8250))))
   bean8248))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.ListStepsRequest}
list-steps-request
  [m8252]
  (clojure.core/let
   [bean8251
    (new
     com.amazonaws.services.elasticmapreduce.model.ListStepsRequest)]
   (clojure.core/let
    [v8253
     (:cluster-id m8252 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8253 :com.palletops.awaze.client-builder/undef)
     (. bean8251 setClusterId (clojure.core/str v8253))))
   (clojure.core/let
    [v8253
     (:step-ids m8252 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8253 :com.palletops.awaze.client-builder/undef)
     (.
      bean8251
      setStepIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8382] (clojure.core/str arg8382))
 v8253))))
   (clojure.core/let
    [v8253 (:marker m8252 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8253 :com.palletops.awaze.client-builder/undef)
     (. bean8251 setMarker (clojure.core/str v8253))))
   (clojure.core/let
    [v8253
     (:step-states m8252 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8253 :com.palletops.awaze.client-builder/undef)
     (.
      bean8251
      setStepStates
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8383] (clojure.core/str arg8383))
 v8253))))
   bean8251))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.AddJobFlowStepsRequest}
add-job-flow-steps-request
  [m8255]
  (clojure.core/let
   [bean8254
    (new
     com.amazonaws.services.elasticmapreduce.model.AddJobFlowStepsRequest)]
   (clojure.core/let
    [v8256 (:steps m8255 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8256 :com.palletops.awaze.client-builder/undef)
     (.
      bean8254
      setSteps
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8384] (elasticmapreduce/step-config arg8384))
 v8256))))
   (clojure.core/let
    [v8256
     (:job-flow-id m8255 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8256 :com.palletops.awaze.client-builder/undef)
     (. bean8254 setJobFlowId (clojure.core/str v8256))))
   bean8254))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.SetTerminationProtectionRequest}
set-termination-protection-request
  [m8258]
  (clojure.core/let
   [bean8257
    (new
     com.amazonaws.services.elasticmapreduce.model.SetTerminationProtectionRequest)]
   (clojure.core/let
    [v8259
     (:job-flow-ids m8258 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8259 :com.palletops.awaze.client-builder/undef)
     (.
      bean8257
      setJobFlowIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8385] (clojure.core/str arg8385))
 v8259))))
   (clojure.core/let
    [v8259
     (:termination-protected
      m8258
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8259 :com.palletops.awaze.client-builder/undef)
     (. bean8257 setTerminationProtected (clojure.core/boolean v8259))))
   bean8257))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.DescribeStepRequest}
describe-step-request
  [m8261]
  (clojure.core/let
   [bean8260
    (new
     com.amazonaws.services.elasticmapreduce.model.DescribeStepRequest)]
   (clojure.core/let
    [v8262
     (:cluster-id m8261 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8262 :com.palletops.awaze.client-builder/undef)
     (. bean8260 setClusterId (clojure.core/str v8262))))
   (clojure.core/let
    [v8262 (:step-id m8261 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8262 :com.palletops.awaze.client-builder/undef)
     (. bean8260 setStepId (clojure.core/str v8262))))
   bean8260))
 (clojure.core/defmulti
  elasticmapreduce
  (clojure.core/fn
   elasticmapreduce
   [m__1874__auto__]
   (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :modify-instance-groups
   [m8293]
   (clojure.core/let
    [credentials8294 (:credentials m8293) args8295 (:args m8293)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8296
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8294)]
     (clojure.core/case
      (clojure.core/count args8295)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8296
        modifyInstanceGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8296
        modifyInstanceGroups
        (elasticmapreduce/modify-instance-groups-request
         (clojure.core/nth args8295 0))))))))
  (clojure.core/defn
   modify-instance-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         instance-groups
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for modifyInstanceGroups, modifyInstanceGroups"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :modify-instance-groups,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-instance-groups,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   modify-instance-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         instance-groups
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call modifyInstanceGroups, modifyInstanceGroups"}
   [credentials8298 & args8299]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8300
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8298)]
    (clojure.core/case
     (clojure.core/count args8299)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8300
       modifyInstanceGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8300
       modifyInstanceGroups
       (elasticmapreduce/modify-instance-groups-request
        (clojure.core/nth args8299 0))))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :list-instance-groups
   [m8301]
   (clojure.core/let
    [credentials8302 (:credentials m8301) args8303 (:args m8301)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8304
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8302)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8304
       listInstanceGroups
       (elasticmapreduce/list-instance-groups-request
        (clojure.core/nth args8303 0)))))))
  (clojure.core/defn
   list-instance-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [cluster-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listInstanceGroups"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-instance-groups,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   list-instance-groups
   {:arglists (quote
               [[credentials
                 {:keys [cluster-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listInstanceGroups"}
   [credentials8306 & args8307]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8308
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8306)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8308
      listInstanceGroups
      (elasticmapreduce/list-instance-groups-request
       (clojure.core/nth args8307 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :list-clusters
   [m8309]
   (clojure.core/let
    [credentials8310 (:credentials m8309) args8311 (:args m8309)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8312
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8310)]
     (clojure.core/case
      (clojure.core/count args8311)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8312
        listClusters))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8312
        listClusters
        (elasticmapreduce/list-clusters-request
         (clojure.core/nth args8311 0))))))))
  (clojure.core/defn
   list-clusters-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [created-after
                         custom-request-headers
                         sdk-client-execution-timeout
                         cluster-states
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         created-before
                         clone-root]}]]),
    :doc "Generate map for listClusters, listClusters"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-clusters,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-clusters,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   list-clusters
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [created-after
                         custom-request-headers
                         sdk-client-execution-timeout
                         cluster-states
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         created-before
                         clone-root]}]]),
    :doc "Call listClusters, listClusters"}
   [credentials8314 & args8315]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8316
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8314)]
    (clojure.core/case
     (clojure.core/count args8315)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8316
       listClusters))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8316
       listClusters
       (elasticmapreduce/list-clusters-request
        (clojure.core/nth args8315 0))))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :remove-tags
   [m8317]
   (clojure.core/let
    [credentials8318 (:credentials m8317) args8319 (:args m8317)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8320
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8318)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8320
       removeTags
       (elasticmapreduce/remove-tags-request
        (clojure.core/nth args8319 0)))))))
  (clojure.core/defn
   remove-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         resource-id
                         tag-keys
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for removeTags"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :remove-tags,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   remove-tags
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         resource-id
                         tag-keys
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call removeTags"}
   [credentials8322 & args8323]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8324
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8322)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8324
      removeTags
      (elasticmapreduce/remove-tags-request
       (clojure.core/nth args8323 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :add-tags
   [m8325]
   (clojure.core/let
    [credentials8326 (:credentials m8325) args8327 (:args m8325)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8328
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8326)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8328
       addTags
       (elasticmapreduce/add-tags-request
        (clojure.core/nth args8327 0)))))))
  (clojure.core/defn
   add-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         resource-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for addTags"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :add-tags,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   add-tags
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         resource-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call addTags"}
   [credentials8330 & args8331]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8332
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8330)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8332
      addTags
      (elasticmapreduce/add-tags-request
       (clojure.core/nth args8331 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :set-visible-to-all-users
   [m8333]
   (clojure.core/let
    [credentials8334 (:credentials m8333) args8335 (:args m8333)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8336
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8334)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8336
       setVisibleToAllUsers
       (elasticmapreduce/set-visible-to-all-users-request
        (clojure.core/nth args8335 0)))))))
  (clojure.core/defn
   set-visible-to-all-users-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         visible-to-all-users
                         job-flow-ids
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setVisibleToAllUsers"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-visible-to-all-users,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   set-visible-to-all-users
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         visible-to-all-users
                         job-flow-ids
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call setVisibleToAllUsers"}
   [credentials8338 & args8339]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8340
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8338)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8340
      setVisibleToAllUsers
      (elasticmapreduce/set-visible-to-all-users-request
       (clojure.core/nth args8339 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :list-instances
   [m8341]
   (clojure.core/let
    [credentials8342 (:credentials m8341) args8343 (:args m8341)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8344
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8342)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8344
       listInstances
       (elasticmapreduce/list-instances-request
        (clojure.core/nth args8343 0)))))))
  (clojure.core/defn
   list-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-group-types
                         cluster-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         instance-group-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listInstances"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-instances,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   list-instances
   {:arglists (quote
               [[credentials
                 {:keys [instance-group-types
                         cluster-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         instance-group-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listInstances"}
   [credentials8346 & args8347]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8348
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8346)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8348
      listInstances
      (elasticmapreduce/list-instances-request
       (clojure.core/nth args8347 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :describe-cluster
   [m8349]
   (clojure.core/let
    [credentials8350 (:credentials m8349) args8351 (:args m8349)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8352
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8350)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8352
       describeCluster
       (elasticmapreduce/describe-cluster-request
        (clojure.core/nth args8351 0)))))))
  (clojure.core/defn
   describe-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [cluster-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeCluster"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-cluster,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   describe-cluster
   {:arglists (quote
               [[credentials
                 {:keys [cluster-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeCluster"}
   [credentials8354 & args8355]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8356
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8354)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8356
      describeCluster
      (elasticmapreduce/describe-cluster-request
       (clojure.core/nth args8355 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :list-bootstrap-actions
   [m8357]
   (clojure.core/let
    [credentials8358 (:credentials m8357) args8359 (:args m8357)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8360
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8358)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8360
       listBootstrapActions
       (elasticmapreduce/list-bootstrap-actions-request
        (clojure.core/nth args8359 0)))))))
  (clojure.core/defn
   list-bootstrap-actions-map
   {:arglists (quote
               [[credentials
                 {:keys [cluster-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listBootstrapActions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-bootstrap-actions,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   list-bootstrap-actions
   {:arglists (quote
               [[credentials
                 {:keys [cluster-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listBootstrapActions"}
   [credentials8362 & args8363]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8364
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8362)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8364
      listBootstrapActions
      (elasticmapreduce/list-bootstrap-actions-request
       (clojure.core/nth args8363 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :terminate-job-flows
   [m8365]
   (clojure.core/let
    [credentials8366 (:credentials m8365) args8367 (:args m8365)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8368
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8366)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8368
       terminateJobFlows
       (elasticmapreduce/terminate-job-flows-request
        (clojure.core/nth args8367 0)))))))
  (clojure.core/defn
   terminate-job-flows-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         job-flow-ids
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for terminateJobFlows"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :terminate-job-flows,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   terminate-job-flows
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         job-flow-ids
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call terminateJobFlows"}
   [credentials8370 & args8371]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8372
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8370)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8372
      terminateJobFlows
      (elasticmapreduce/terminate-job-flows-request
       (clojure.core/nth args8371 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :describe-job-flows
   [m8373]
   (clojure.core/let
    [credentials8374 (:credentials m8373) args8375 (:args m8373)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8376
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8374)]
     (clojure.core/case
      (clojure.core/count args8375)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8376
        describeJobFlows
        (elasticmapreduce/describe-job-flows-request
         (clojure.core/nth args8375 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8376
        describeJobFlows))))))
  (clojure.core/defn
   describe-job-flows-map
   {:arglists (quote
               [[credentials
                 {:keys [created-after
                         custom-request-headers
                         sdk-client-execution-timeout
                         job-flow-ids
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         job-flow-states
                         general-progress-listener
                         clone-source
                         created-before
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeJobFlows, describeJobFlows"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-job-flows,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-job-flows,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   describe-job-flows
   {:arglists (quote
               [[credentials
                 {:keys [created-after
                         custom-request-headers
                         sdk-client-execution-timeout
                         job-flow-ids
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         job-flow-states
                         general-progress-listener
                         clone-source
                         created-before
                         clone-root]}]
                [credentials]]),
    :doc "Call describeJobFlows, describeJobFlows"}
   [credentials8378 & args8379]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8380
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8378)]
    (clojure.core/case
     (clojure.core/count args8379)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8380
       describeJobFlows
       (elasticmapreduce/describe-job-flows-request
        (clojure.core/nth args8379 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8380
       describeJobFlows))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :run-job-flow
   [m8386]
   (clojure.core/let
    [credentials8387 (:credentials m8386) args8388 (:args m8386)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8389
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8387)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8389
       runJobFlow
       (elasticmapreduce/run-job-flow-request
        (clojure.core/nth args8388 0)))))))
  (clojure.core/defn
   run-job-flow-map
   {:arglists (quote
               [[credentials
                 {:keys [ami-version
                         new-supported-products
                         tags
                         custom-request-headers
                         release-label
                         sdk-client-execution-timeout
                         visible-to-all-users
                         applications
                         sdk-request-timeout
                         service-role
                         name
                         configurations
                         steps
                         custom-query-parameters
                         bootstrap-actions
                         log-uri
                         supported-products
                         additional-info
                         read-limit
                         instances
                         general-progress-listener
                         clone-source
                         clone-root
                         job-flow-role]}]]),
    :doc "Generate map for runJobFlow"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :run-job-flow,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   run-job-flow
   {:arglists (quote
               [[credentials
                 {:keys [ami-version
                         new-supported-products
                         tags
                         custom-request-headers
                         release-label
                         sdk-client-execution-timeout
                         visible-to-all-users
                         applications
                         sdk-request-timeout
                         service-role
                         name
                         configurations
                         steps
                         custom-query-parameters
                         bootstrap-actions
                         log-uri
                         supported-products
                         additional-info
                         read-limit
                         instances
                         general-progress-listener
                         clone-source
                         clone-root
                         job-flow-role]}]]),
    :doc "Call runJobFlow"}
   [credentials8391 & args8392]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8393
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8391)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8393
      runJobFlow
      (elasticmapreduce/run-job-flow-request
       (clojure.core/nth args8392 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :add-instance-groups
   [m8394]
   (clojure.core/let
    [credentials8395 (:credentials m8394) args8396 (:args m8394)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8397
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8395)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8397
       addInstanceGroups
       (elasticmapreduce/add-instance-groups-request
        (clojure.core/nth args8396 0)))))))
  (clojure.core/defn
   add-instance-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         instance-groups
                         custom-query-parameters
                         job-flow-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for addInstanceGroups"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :add-instance-groups,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   add-instance-groups
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         instance-groups
                         custom-query-parameters
                         job-flow-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call addInstanceGroups"}
   [credentials8399 & args8400]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8401
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8399)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8401
      addInstanceGroups
      (elasticmapreduce/add-instance-groups-request
       (clojure.core/nth args8400 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :list-steps
   [m8402]
   (clojure.core/let
    [credentials8403 (:credentials m8402) args8404 (:args m8402)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8405
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8403)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8405
       listSteps
       (elasticmapreduce/list-steps-request
        (clojure.core/nth args8404 0)))))))
  (clojure.core/defn
   list-steps-map
   {:arglists (quote
               [[credentials
                 {:keys [cluster-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         step-ids
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         step-states
                         clone-root]}]]),
    :doc "Generate map for listSteps"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-steps,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   list-steps
   {:arglists (quote
               [[credentials
                 {:keys [cluster-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         step-ids
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         step-states
                         clone-root]}]]),
    :doc "Call listSteps"}
   [credentials8407 & args8408]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8409
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8407)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8409
      listSteps
      (elasticmapreduce/list-steps-request
       (clojure.core/nth args8408 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :add-job-flow-steps
   [m8410]
   (clojure.core/let
    [credentials8411 (:credentials m8410) args8412 (:args m8410)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8413
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8411)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8413
       addJobFlowSteps
       (elasticmapreduce/add-job-flow-steps-request
        (clojure.core/nth args8412 0)))))))
  (clojure.core/defn
   add-job-flow-steps-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         steps
                         custom-query-parameters
                         job-flow-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for addJobFlowSteps"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :add-job-flow-steps,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   add-job-flow-steps
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         steps
                         custom-query-parameters
                         job-flow-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call addJobFlowSteps"}
   [credentials8415 & args8416]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8417
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8415)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8417
      addJobFlowSteps
      (elasticmapreduce/add-job-flow-steps-request
       (clojure.core/nth args8416 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :set-termination-protection
   [m8418]
   (clojure.core/let
    [credentials8419 (:credentials m8418) args8420 (:args m8418)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8421
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8419)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8421
       setTerminationProtection
       (elasticmapreduce/set-termination-protection-request
        (clojure.core/nth args8420 0)))))))
  (clojure.core/defn
   set-termination-protection-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         job-flow-ids
                         termination-protected
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setTerminationProtection"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-termination-protection,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   set-termination-protection
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         job-flow-ids
                         termination-protected
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call setTerminationProtection"}
   [credentials8423 & args8424]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8425
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8423)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8425
      setTerminationProtection
      (elasticmapreduce/set-termination-protection-request
       (clojure.core/nth args8424 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :describe-step
   [m8426]
   (clojure.core/let
    [credentials8427 (:credentials m8426) args8428 (:args m8426)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8429
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8427)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8429
       describeStep
       (elasticmapreduce/describe-step-request
        (clojure.core/nth args8428 0)))))))
  (clojure.core/defn
   describe-step-map
   {:arglists (quote
               [[credentials
                 {:keys [cluster-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         step-id
                         clone-root]}]]),
    :doc "Generate map for describeStep"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-step,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   describe-step
   {:arglists (quote
               [[credentials
                 {:keys [cluster-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         step-id
                         clone-root]}]]),
    :doc "Call describeStep"}
   [credentials8431 & args8432]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8433
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8431)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8433
      describeStep
      (elasticmapreduce/describe-step-request
       (clojure.core/nth args8432 0))))))))
