(ns
 com.palletops.awaze.elasticloadbalancing
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.elasticloadbalancing :as elasticloadbalancing]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :elasticloadbalancing
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.CrossZoneLoadBalancing}
cross-zone-load-balancing
  [m4556]
  (clojure.core/let
   [bean4555
    (new
     com.amazonaws.services.elasticloadbalancing.model.CrossZoneLoadBalancing)]
   (clojure.core/let
    [v4557 (:enabled m4556 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4557 :com.palletops.awaze.client-builder/undef)
     (. bean4555 setEnabled (clojure.core/boolean v4557))))
   bean4555))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.AccessLog}
access-log
  [m4559]
  (clojure.core/let
   [bean4558
    (new com.amazonaws.services.elasticloadbalancing.model.AccessLog)]
   (clojure.core/let
    [v4560 (:enabled m4559 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4560 :com.palletops.awaze.client-builder/undef)
     (. bean4558 setEnabled (clojure.core/boolean v4560))))
   (clojure.core/let
    [v4560
     (:s3bucket-prefix
      m4559
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4560 :com.palletops.awaze.client-builder/undef)
     (. bean4558 setS3BucketPrefix (clojure.core/str v4560))))
   (clojure.core/let
    [v4560
     (:s3bucket-name m4559 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4560 :com.palletops.awaze.client-builder/undef)
     (. bean4558 setS3BucketName (clojure.core/str v4560))))
   (clojure.core/let
    [v4560
     (:emit-interval m4559 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4560 :com.palletops.awaze.client-builder/undef)
     (. bean4558 setEmitInterval (clojure.core/int v4560))))
   bean4558))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.ConnectionDraining}
connection-draining
  [m4562]
  (clojure.core/let
   [bean4561
    (new
     com.amazonaws.services.elasticloadbalancing.model.ConnectionDraining)]
   (clojure.core/let
    [v4563 (:enabled m4562 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4563 :com.palletops.awaze.client-builder/undef)
     (. bean4561 setEnabled (clojure.core/boolean v4563))))
   (clojure.core/let
    [v4563 (:timeout m4562 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4563 :com.palletops.awaze.client-builder/undef)
     (. bean4561 setTimeout (clojure.core/int v4563))))
   bean4561))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.ConnectionSettings}
connection-settings
  [m4565]
  (clojure.core/let
   [bean4564
    (new
     com.amazonaws.services.elasticloadbalancing.model.ConnectionSettings)]
   (clojure.core/let
    [v4566
     (:idle-timeout m4565 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4566 :com.palletops.awaze.client-builder/undef)
     (. bean4564 setIdleTimeout (clojure.core/int v4566))))
   bean4564))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.AdditionalAttribute}
additional-attribute
  [m4568]
  (clojure.core/let
   [bean4567
    (new
     com.amazonaws.services.elasticloadbalancing.model.AdditionalAttribute)]
   (clojure.core/let
    [v4569 (:key m4568 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4569 :com.palletops.awaze.client-builder/undef)
     (. bean4567 setKey (clojure.core/str v4569))))
   (clojure.core/let
    [v4569 (:value m4568 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4569 :com.palletops.awaze.client-builder/undef)
     (. bean4567 setValue (clojure.core/str v4569))))
   bean4567))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.Listener}
listener
  [m4571]
  (clojure.core/let
   [bean4570
    (new com.amazonaws.services.elasticloadbalancing.model.Listener)]
   (clojure.core/let
    [v4572
     (:instance-port m4571 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4572 :com.palletops.awaze.client-builder/undef)
     (. bean4570 setInstancePort (clojure.core/int v4572))))
   (clojure.core/let
    [v4572
     (:load-balancer-port
      m4571
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4572 :com.palletops.awaze.client-builder/undef)
     (. bean4570 setLoadBalancerPort (clojure.core/int v4572))))
   (clojure.core/let
    [v4572
     (:sslcertificate-id
      m4571
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4572 :com.palletops.awaze.client-builder/undef)
     (. bean4570 setSSLCertificateId (clojure.core/str v4572))))
   (clojure.core/let
    [v4572
     (:protocol m4571 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4572 :com.palletops.awaze.client-builder/undef)
     (. bean4570 setProtocol (clojure.core/str v4572))))
   (clojure.core/let
    [v4572
     (:instance-protocol
      m4571
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4572 :com.palletops.awaze.client-builder/undef)
     (. bean4570 setInstanceProtocol (clojure.core/str v4572))))
   bean4570))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.Tag}
tag
  [m4574]
  (clojure.core/let
   [bean4573
    (new com.amazonaws.services.elasticloadbalancing.model.Tag)]
   (clojure.core/let
    [v4575 (:key m4574 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4575 :com.palletops.awaze.client-builder/undef)
     (. bean4573 setKey (clojure.core/str v4575))))
   (clojure.core/let
    [v4575 (:value m4574 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4575 :com.palletops.awaze.client-builder/undef)
     (. bean4573 setValue (clojure.core/str v4575))))
   bean4573))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.TagKeyOnly}
tag-key-only
  [m4577]
  (clojure.core/let
   [bean4576
    (new com.amazonaws.services.elasticloadbalancing.model.TagKeyOnly)]
   (clojure.core/let
    [v4578 (:key m4577 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4578 :com.palletops.awaze.client-builder/undef)
     (. bean4576 setKey (clojure.core/str v4578))))
   bean4576))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.PolicyAttribute}
policy-attribute
  [m4580]
  (clojure.core/let
   [bean4579
    (new
     com.amazonaws.services.elasticloadbalancing.model.PolicyAttribute)]
   (clojure.core/let
    [v4581
     (:attribute-name m4580 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4581 :com.palletops.awaze.client-builder/undef)
     (. bean4579 setAttributeName (clojure.core/str v4581))))
   (clojure.core/let
    [v4581
     (:attribute-value
      m4580
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4581 :com.palletops.awaze.client-builder/undef)
     (. bean4579 setAttributeValue (clojure.core/str v4581))))
   bean4579))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.Instance}
instance
  [m4583]
  (clojure.core/let
   [bean4582
    (new com.amazonaws.services.elasticloadbalancing.model.Instance)]
   (clojure.core/let
    [v4584
     (:instance-id m4583 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4584 :com.palletops.awaze.client-builder/undef)
     (. bean4582 setInstanceId (clojure.core/str v4584))))
   bean4582))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.LoadBalancerAttributes}
load-balancer-attributes
  [m4586]
  (clojure.core/let
   [bean4585
    (new
     com.amazonaws.services.elasticloadbalancing.model.LoadBalancerAttributes)]
   (clojure.core/let
    [v4587
     (:cross-zone-load-balancing
      m4586
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4587 :com.palletops.awaze.client-builder/undef)
     (.
      bean4585
      setCrossZoneLoadBalancing
      (elasticloadbalancing/cross-zone-load-balancing v4587))))
   (clojure.core/let
    [v4587
     (:access-log m4586 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4587 :com.palletops.awaze.client-builder/undef)
     (. bean4585 setAccessLog (elasticloadbalancing/access-log v4587))))
   (clojure.core/let
    [v4587
     (:connection-draining
      m4586
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4587 :com.palletops.awaze.client-builder/undef)
     (.
      bean4585
      setConnectionDraining
      (elasticloadbalancing/connection-draining v4587))))
   (clojure.core/let
    [v4587
     (:connection-settings
      m4586
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4587 :com.palletops.awaze.client-builder/undef)
     (.
      bean4585
      setConnectionSettings
      (elasticloadbalancing/connection-settings v4587))))
   (clojure.core/let
    [v4587
     (:additional-attributes
      m4586
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4587 :com.palletops.awaze.client-builder/undef)
     (.
      bean4585
      setAdditionalAttributes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg4675]
  (elasticloadbalancing/additional-attribute arg4675))
 v4587))))
   bean4585))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.HealthCheck}
health-check
  [m4589]
  (clojure.core/let
   [bean4588
    (new
     com.amazonaws.services.elasticloadbalancing.model.HealthCheck)]
   (clojure.core/let
    [v4590
     (:interval m4589 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4590 :com.palletops.awaze.client-builder/undef)
     (. bean4588 setInterval (clojure.core/int v4590))))
   (clojure.core/let
    [v4590 (:timeout m4589 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4590 :com.palletops.awaze.client-builder/undef)
     (. bean4588 setTimeout (clojure.core/int v4590))))
   (clojure.core/let
    [v4590
     (:unhealthy-threshold
      m4589
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4590 :com.palletops.awaze.client-builder/undef)
     (. bean4588 setUnhealthyThreshold (clojure.core/int v4590))))
   (clojure.core/let
    [v4590
     (:healthy-threshold
      m4589
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4590 :com.palletops.awaze.client-builder/undef)
     (. bean4588 setHealthyThreshold (clojure.core/int v4590))))
   (clojure.core/let
    [v4590 (:target m4589 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4590 :com.palletops.awaze.client-builder/undef)
     (. bean4588 setTarget (clojure.core/str v4590))))
   bean4588))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerRequest}
create-load-balancer-request
  [m4592]
  (clojure.core/let
   [bean4591
    (new
     com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerRequest)]
   (clojure.core/let
    [v4593
     (:load-balancer-name
      m4592
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4593 :com.palletops.awaze.client-builder/undef)
     (. bean4591 setLoadBalancerName (clojure.core/str v4593))))
   (clojure.core/let
    [v4593
     (:listeners m4592 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4593 :com.palletops.awaze.client-builder/undef)
     (.
      bean4591
      setListeners
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4676] (elasticloadbalancing/listener arg4676))
 v4593))))
   (clojure.core/let
    [v4593 (:subnets m4592 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4593 :com.palletops.awaze.client-builder/undef)
     (.
      bean4591
      setSubnets
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4677] (clojure.core/str arg4677))
 v4593))))
   (clojure.core/let
    [v4593
     (:security-groups
      m4592
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4593 :com.palletops.awaze.client-builder/undef)
     (.
      bean4591
      setSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4678] (clojure.core/str arg4678))
 v4593))))
   (clojure.core/let
    [v4593 (:tags m4592 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4593 :com.palletops.awaze.client-builder/undef)
     (.
      bean4591
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4679] (elasticloadbalancing/tag arg4679))
 v4593))))
   (clojure.core/let
    [v4593 (:scheme m4592 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4593 :com.palletops.awaze.client-builder/undef)
     (. bean4591 setScheme (clojure.core/str v4593))))
   (clojure.core/let
    [v4593
     (:availability-zones
      m4592
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4593 :com.palletops.awaze.client-builder/undef)
     (.
      bean4591
      setAvailabilityZones
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4680] (clojure.core/str arg4680))
 v4593))))
   bean4591))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerListenersRequest}
delete-load-balancer-listeners-request
  [m4595]
  (clojure.core/let
   [bean4594
    (new
     com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerListenersRequest)]
   (clojure.core/let
    [v4596
     (:load-balancer-name
      m4595
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4596 :com.palletops.awaze.client-builder/undef)
     (. bean4594 setLoadBalancerName (clojure.core/str v4596))))
   (clojure.core/let
    [v4596
     (:load-balancer-ports
      m4595
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4596 :com.palletops.awaze.client-builder/undef)
     (.
      bean4594
      setLoadBalancerPorts
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4681] (clojure.core/int arg4681))
 v4596))))
   bean4594))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerRequest}
enable-availability-zones-for-load-balancer-request
  [m4598]
  (clojure.core/let
   [bean4597
    (new
     com.amazonaws.services.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerRequest)]
   (clojure.core/let
    [v4599
     (:load-balancer-name
      m4598
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4599 :com.palletops.awaze.client-builder/undef)
     (. bean4597 setLoadBalancerName (clojure.core/str v4599))))
   (clojure.core/let
    [v4599
     (:availability-zones
      m4598
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4599 :com.palletops.awaze.client-builder/undef)
     (.
      bean4597
      setAvailabilityZones
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4682] (clojure.core/str arg4682))
 v4599))))
   bean4597))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancersRequest}
describe-load-balancers-request
  [m4601]
  (clojure.core/let
   [bean4600
    (new
     com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancersRequest)]
   (clojure.core/let
    [v4602
     (:load-balancer-names
      m4601
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4602 :com.palletops.awaze.client-builder/undef)
     (.
      bean4600
      setLoadBalancerNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4683] (clojure.core/str arg4683))
 v4602))))
   (clojure.core/let
    [v4602
     (:page-size m4601 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4602 :com.palletops.awaze.client-builder/undef)
     (. bean4600 setPageSize (clojure.core/int v4602))))
   (clojure.core/let
    [v4602 (:marker m4601 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4602 :com.palletops.awaze.client-builder/undef)
     (. bean4600 setMarker (clojure.core/str v4602))))
   bean4600))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerPolicyRequest}
delete-load-balancer-policy-request
  [m4604]
  (clojure.core/let
   [bean4603
    (new
     com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerPolicyRequest)]
   (clojure.core/let
    [v4605
     (:load-balancer-name
      m4604
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4605 :com.palletops.awaze.client-builder/undef)
     (. bean4603 setLoadBalancerName (clojure.core/str v4605))))
   (clojure.core/let
    [v4605
     (:policy-name m4604 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4605 :com.palletops.awaze.client-builder/undef)
     (. bean4603 setPolicyName (clojure.core/str v4605))))
   bean4603))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerPoliciesRequest}
describe-load-balancer-policies-request
  [m4607]
  (clojure.core/let
   [bean4606
    (new
     com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerPoliciesRequest)]
   (clojure.core/let
    [v4608
     (:load-balancer-name
      m4607
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4608 :com.palletops.awaze.client-builder/undef)
     (. bean4606 setLoadBalancerName (clojure.core/str v4608))))
   (clojure.core/let
    [v4608
     (:policy-names m4607 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4608 :com.palletops.awaze.client-builder/undef)
     (.
      bean4606
      setPolicyNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4684] (clojure.core/str arg4684))
 v4608))))
   bean4606))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.RemoveTagsRequest}
remove-tags-request
  [m4610]
  (clojure.core/let
   [bean4609
    (new
     com.amazonaws.services.elasticloadbalancing.model.RemoveTagsRequest)]
   (clojure.core/let
    [v4611
     (:load-balancer-names
      m4610
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4611 :com.palletops.awaze.client-builder/undef)
     (.
      bean4609
      setLoadBalancerNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4685] (clojure.core/str arg4685))
 v4611))))
   (clojure.core/let
    [v4611 (:tags m4610 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4611 :com.palletops.awaze.client-builder/undef)
     (.
      bean4609
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg4686]
  (elasticloadbalancing/tag-key-only arg4686))
 v4611))))
   bean4609))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerPolicyRequest}
create-load-balancer-policy-request
  [m4613]
  (clojure.core/let
   [bean4612
    (new
     com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerPolicyRequest)]
   (clojure.core/let
    [v4614
     (:load-balancer-name
      m4613
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4614 :com.palletops.awaze.client-builder/undef)
     (. bean4612 setLoadBalancerName (clojure.core/str v4614))))
   (clojure.core/let
    [v4614
     (:policy-name m4613 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4614 :com.palletops.awaze.client-builder/undef)
     (. bean4612 setPolicyName (clojure.core/str v4614))))
   (clojure.core/let
    [v4614
     (:policy-type-name
      m4613
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4614 :com.palletops.awaze.client-builder/undef)
     (. bean4612 setPolicyTypeName (clojure.core/str v4614))))
   (clojure.core/let
    [v4614
     (:policy-attributes
      m4613
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4614 :com.palletops.awaze.client-builder/undef)
     (.
      bean4612
      setPolicyAttributes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg4687]
  (elasticloadbalancing/policy-attribute arg4687))
 v4614))))
   bean4612))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerListenersRequest}
create-load-balancer-listeners-request
  [m4616]
  (clojure.core/let
   [bean4615
    (new
     com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerListenersRequest)]
   (clojure.core/let
    [v4617
     (:load-balancer-name
      m4616
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4617 :com.palletops.awaze.client-builder/undef)
     (. bean4615 setLoadBalancerName (clojure.core/str v4617))))
   (clojure.core/let
    [v4617
     (:listeners m4616 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4617 :com.palletops.awaze.client-builder/undef)
     (.
      bean4615
      setListeners
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4688] (elasticloadbalancing/listener arg4688))
 v4617))))
   bean4615))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerPoliciesForBackendServerRequest}
set-load-balancer-policies-for-backend-server-request
  [m4619]
  (clojure.core/let
   [bean4618
    (new
     com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerPoliciesForBackendServerRequest)]
   (clojure.core/let
    [v4620
     (:load-balancer-name
      m4619
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4620 :com.palletops.awaze.client-builder/undef)
     (. bean4618 setLoadBalancerName (clojure.core/str v4620))))
   (clojure.core/let
    [v4620
     (:policy-names m4619 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4620 :com.palletops.awaze.client-builder/undef)
     (.
      bean4618
      setPolicyNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4689] (clojure.core/str arg4689))
 v4620))))
   (clojure.core/let
    [v4620
     (:instance-port m4619 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4620 :com.palletops.awaze.client-builder/undef)
     (. bean4618 setInstancePort (clojure.core/int v4620))))
   bean4618))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DescribeInstanceHealthRequest}
describe-instance-health-request
  [m4622]
  (clojure.core/let
   [bean4621
    (new
     com.amazonaws.services.elasticloadbalancing.model.DescribeInstanceHealthRequest)]
   (clojure.core/let
    [v4623
     (:load-balancer-name
      m4622
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4623 :com.palletops.awaze.client-builder/undef)
     (. bean4621 setLoadBalancerName (clojure.core/str v4623))))
   (clojure.core/let
    [v4623
     (:instances m4622 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4623 :com.palletops.awaze.client-builder/undef)
     (.
      bean4621
      setInstances
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4690] (elasticloadbalancing/instance arg4690))
 v4623))))
   bean4621))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerRequest}
delete-load-balancer-request
  [m4625]
  (clojure.core/let
   [bean4624
    (new
     com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerRequest)]
   (clojure.core/let
    [v4626
     (:load-balancer-name
      m4625
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4626 :com.palletops.awaze.client-builder/undef)
     (. bean4624 setLoadBalancerName (clojure.core/str v4626))))
   bean4624))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DetachLoadBalancerFromSubnetsRequest}
detach-load-balancer-from-subnets-request
  [m4628]
  (clojure.core/let
   [bean4627
    (new
     com.amazonaws.services.elasticloadbalancing.model.DetachLoadBalancerFromSubnetsRequest)]
   (clojure.core/let
    [v4629
     (:load-balancer-name
      m4628
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4629 :com.palletops.awaze.client-builder/undef)
     (. bean4627 setLoadBalancerName (clojure.core/str v4629))))
   (clojure.core/let
    [v4629 (:subnets m4628 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4629 :com.palletops.awaze.client-builder/undef)
     (.
      bean4627
      setSubnets
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4691] (clojure.core/str arg4691))
 v4629))))
   bean4627))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerRequest}
disable-availability-zones-for-load-balancer-request
  [m4631]
  (clojure.core/let
   [bean4630
    (new
     com.amazonaws.services.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerRequest)]
   (clojure.core/let
    [v4632
     (:load-balancer-name
      m4631
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4632 :com.palletops.awaze.client-builder/undef)
     (. bean4630 setLoadBalancerName (clojure.core/str v4632))))
   (clojure.core/let
    [v4632
     (:availability-zones
      m4631
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4632 :com.palletops.awaze.client-builder/undef)
     (.
      bean4630
      setAvailabilityZones
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4692] (clojure.core/str arg4692))
 v4632))))
   bean4630))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerPoliciesOfListenerRequest}
set-load-balancer-policies-of-listener-request
  [m4634]
  (clojure.core/let
   [bean4633
    (new
     com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerPoliciesOfListenerRequest)]
   (clojure.core/let
    [v4635
     (:load-balancer-name
      m4634
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4635 :com.palletops.awaze.client-builder/undef)
     (. bean4633 setLoadBalancerName (clojure.core/str v4635))))
   (clojure.core/let
    [v4635
     (:policy-names m4634 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4635 :com.palletops.awaze.client-builder/undef)
     (.
      bean4633
      setPolicyNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4693] (clojure.core/str arg4693))
 v4635))))
   (clojure.core/let
    [v4635
     (:load-balancer-port
      m4634
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4635 :com.palletops.awaze.client-builder/undef)
     (. bean4633 setLoadBalancerPort (clojure.core/int v4635))))
   bean4633))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.AddTagsRequest}
add-tags-request
  [m4637]
  (clojure.core/let
   [bean4636
    (new
     com.amazonaws.services.elasticloadbalancing.model.AddTagsRequest)]
   (clojure.core/let
    [v4638
     (:load-balancer-names
      m4637
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4638 :com.palletops.awaze.client-builder/undef)
     (.
      bean4636
      setLoadBalancerNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4694] (clojure.core/str arg4694))
 v4638))))
   (clojure.core/let
    [v4638 (:tags m4637 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4638 :com.palletops.awaze.client-builder/undef)
     (.
      bean4636
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4695] (elasticloadbalancing/tag arg4695))
 v4638))))
   bean4636))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerRequest}
register-instances-with-load-balancer-request
  [m4640]
  (clojure.core/let
   [bean4639
    (new
     com.amazonaws.services.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerRequest)]
   (clojure.core/let
    [v4641
     (:load-balancer-name
      m4640
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4641 :com.palletops.awaze.client-builder/undef)
     (. bean4639 setLoadBalancerName (clojure.core/str v4641))))
   (clojure.core/let
    [v4641
     (:instances m4640 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4641 :com.palletops.awaze.client-builder/undef)
     (.
      bean4639
      setInstances
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4696] (elasticloadbalancing/instance arg4696))
 v4641))))
   bean4639))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DescribeTagsRequest}
describe-tags-request
  [m4643]
  (clojure.core/let
   [bean4642
    (new
     com.amazonaws.services.elasticloadbalancing.model.DescribeTagsRequest)]
   (clojure.core/let
    [v4644
     (:load-balancer-names
      m4643
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4644 :com.palletops.awaze.client-builder/undef)
     (.
      bean4642
      setLoadBalancerNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4697] (clojure.core/str arg4697))
 v4644))))
   bean4642))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.CreateAppCookieStickinessPolicyRequest}
create-app-cookie-stickiness-policy-request
  [m4646]
  (clojure.core/let
   [bean4645
    (new
     com.amazonaws.services.elasticloadbalancing.model.CreateAppCookieStickinessPolicyRequest)]
   (clojure.core/let
    [v4647
     (:load-balancer-name
      m4646
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4647 :com.palletops.awaze.client-builder/undef)
     (. bean4645 setLoadBalancerName (clojure.core/str v4647))))
   (clojure.core/let
    [v4647
     (:policy-name m4646 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4647 :com.palletops.awaze.client-builder/undef)
     (. bean4645 setPolicyName (clojure.core/str v4647))))
   (clojure.core/let
    [v4647
     (:cookie-name m4646 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4647 :com.palletops.awaze.client-builder/undef)
     (. bean4645 setCookieName (clojure.core/str v4647))))
   bean4645))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.ModifyLoadBalancerAttributesRequest}
modify-load-balancer-attributes-request
  [m4649]
  (clojure.core/let
   [bean4648
    (new
     com.amazonaws.services.elasticloadbalancing.model.ModifyLoadBalancerAttributesRequest)]
   (clojure.core/let
    [v4650
     (:load-balancer-name
      m4649
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4650 :com.palletops.awaze.client-builder/undef)
     (. bean4648 setLoadBalancerName (clojure.core/str v4650))))
   (clojure.core/let
    [v4650
     (:load-balancer-attributes
      m4649
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4650 :com.palletops.awaze.client-builder/undef)
     (.
      bean4648
      setLoadBalancerAttributes
      (elasticloadbalancing/load-balancer-attributes v4650))))
   bean4648))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerListenerSSLCertificateRequest}
set-load-balancer-listener-sslcertificate-request
  [m4652]
  (clojure.core/let
   [bean4651
    (new
     com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerListenerSSLCertificateRequest)]
   (clojure.core/let
    [v4653
     (:load-balancer-name
      m4652
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4653 :com.palletops.awaze.client-builder/undef)
     (. bean4651 setLoadBalancerName (clojure.core/str v4653))))
   (clojure.core/let
    [v4653
     (:load-balancer-port
      m4652
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4653 :com.palletops.awaze.client-builder/undef)
     (. bean4651 setLoadBalancerPort (clojure.core/int v4653))))
   (clojure.core/let
    [v4653
     (:sslcertificate-id
      m4652
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4653 :com.palletops.awaze.client-builder/undef)
     (. bean4651 setSSLCertificateId (clojure.core/str v4653))))
   bean4651))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerAttributesRequest}
describe-load-balancer-attributes-request
  [m4655]
  (clojure.core/let
   [bean4654
    (new
     com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerAttributesRequest)]
   (clojure.core/let
    [v4656
     (:load-balancer-name
      m4655
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4656 :com.palletops.awaze.client-builder/undef)
     (. bean4654 setLoadBalancerName (clojure.core/str v4656))))
   bean4654))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.ConfigureHealthCheckRequest}
configure-health-check-request
  [m4658]
  (clojure.core/let
   [bean4657
    (new
     com.amazonaws.services.elasticloadbalancing.model.ConfigureHealthCheckRequest)]
   (clojure.core/let
    [v4659
     (:load-balancer-name
      m4658
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4659 :com.palletops.awaze.client-builder/undef)
     (. bean4657 setLoadBalancerName (clojure.core/str v4659))))
   (clojure.core/let
    [v4659
     (:health-check m4658 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4659 :com.palletops.awaze.client-builder/undef)
     (.
      bean4657
      setHealthCheck
      (elasticloadbalancing/health-check v4659))))
   bean4657))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.AttachLoadBalancerToSubnetsRequest}
attach-load-balancer-to-subnets-request
  [m4661]
  (clojure.core/let
   [bean4660
    (new
     com.amazonaws.services.elasticloadbalancing.model.AttachLoadBalancerToSubnetsRequest)]
   (clojure.core/let
    [v4662
     (:load-balancer-name
      m4661
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4662 :com.palletops.awaze.client-builder/undef)
     (. bean4660 setLoadBalancerName (clojure.core/str v4662))))
   (clojure.core/let
    [v4662 (:subnets m4661 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4662 :com.palletops.awaze.client-builder/undef)
     (.
      bean4660
      setSubnets
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4746] (clojure.core/str arg4746))
 v4662))))
   bean4660))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesRequest}
describe-load-balancer-policy-types-request
  [m4664]
  (clojure.core/let
   [bean4663
    (new
     com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesRequest)]
   (clojure.core/let
    [v4665
     (:policy-type-names
      m4664
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4665 :com.palletops.awaze.client-builder/undef)
     (.
      bean4663
      setPolicyTypeNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4747] (clojure.core/str arg4747))
 v4665))))
   bean4663))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerRequest}
deregister-instances-from-load-balancer-request
  [m4667]
  (clojure.core/let
   [bean4666
    (new
     com.amazonaws.services.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerRequest)]
   (clojure.core/let
    [v4668
     (:load-balancer-name
      m4667
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4668 :com.palletops.awaze.client-builder/undef)
     (. bean4666 setLoadBalancerName (clojure.core/str v4668))))
   (clojure.core/let
    [v4668
     (:instances m4667 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4668 :com.palletops.awaze.client-builder/undef)
     (.
      bean4666
      setInstances
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4748] (elasticloadbalancing/instance arg4748))
 v4668))))
   bean4666))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerRequest}
apply-security-groups-to-load-balancer-request
  [m4670]
  (clojure.core/let
   [bean4669
    (new
     com.amazonaws.services.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerRequest)]
   (clojure.core/let
    [v4671
     (:load-balancer-name
      m4670
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4671 :com.palletops.awaze.client-builder/undef)
     (. bean4669 setLoadBalancerName (clojure.core/str v4671))))
   (clojure.core/let
    [v4671
     (:security-groups
      m4670
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4671 :com.palletops.awaze.client-builder/undef)
     (.
      bean4669
      setSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4749] (clojure.core/str arg4749))
 v4671))))
   bean4669))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.CreateLBCookieStickinessPolicyRequest}
create-lbcookie-stickiness-policy-request
  [m4673]
  (clojure.core/let
   [bean4672
    (new
     com.amazonaws.services.elasticloadbalancing.model.CreateLBCookieStickinessPolicyRequest)]
   (clojure.core/let
    [v4674
     (:load-balancer-name
      m4673
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4674 :com.palletops.awaze.client-builder/undef)
     (. bean4672 setLoadBalancerName (clojure.core/str v4674))))
   (clojure.core/let
    [v4674
     (:policy-name m4673 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4674 :com.palletops.awaze.client-builder/undef)
     (. bean4672 setPolicyName (clojure.core/str v4674))))
   (clojure.core/let
    [v4674
     (:cookie-expiration-period
      m4673
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4674 :com.palletops.awaze.client-builder/undef)
     (. bean4672 setCookieExpirationPeriod (clojure.core/long v4674))))
   bean4672))
 (clojure.core/defmulti
  elasticloadbalancing
  (clojure.core/fn
   elasticloadbalancing
   [m__1874__auto__]
   (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :create-load-balancer
   [m4698]
   (clojure.core/let
    [credentials4699 (:credentials m4698) args4700 (:args m4698)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4701
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4699)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4701
       createLoadBalancer
       (elasticloadbalancing/create-load-balancer-request
        (clojure.core/nth args4700 0)))))))
  (clojure.core/defn
   create-load-balancer-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         security-groups
                         sdk-request-timeout
                         availability-zones
                         load-balancer-name
                         custom-query-parameters
                         subnets
                         read-limit
                         general-progress-listener
                         clone-source
                         listeners
                         clone-root
                         scheme]}]]),
    :doc "Generate map for createLoadBalancer"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-load-balancer,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   create-load-balancer
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         security-groups
                         sdk-request-timeout
                         availability-zones
                         load-balancer-name
                         custom-query-parameters
                         subnets
                         read-limit
                         general-progress-listener
                         clone-source
                         listeners
                         clone-root
                         scheme]}]]),
    :doc "Call createLoadBalancer"}
   [credentials4703 & args4704]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4705
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4703)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4705
      createLoadBalancer
      (elasticloadbalancing/create-load-balancer-request
       (clojure.core/nth args4704 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :delete-load-balancer-listeners
   [m4706]
   (clojure.core/let
    [credentials4707 (:credentials m4706) args4708 (:args m4706)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4709
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4707)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4709
       deleteLoadBalancerListeners
       (elasticloadbalancing/delete-load-balancer-listeners-request
        (clojure.core/nth args4708 0)))))))
  (clojure.core/defn
   delete-load-balancer-listeners-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         load-balancer-ports
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteLoadBalancerListeners"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-load-balancer-listeners,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   delete-load-balancer-listeners
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         load-balancer-ports
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteLoadBalancerListeners"}
   [credentials4711 & args4712]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4713
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4711)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4713
      deleteLoadBalancerListeners
      (elasticloadbalancing/delete-load-balancer-listeners-request
       (clojure.core/nth args4712 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :enable-availability-zones-for-load-balancer
   [m4714]
   (clojure.core/let
    [credentials4715 (:credentials m4714) args4716 (:args m4714)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4717
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4715)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4717
       enableAvailabilityZonesForLoadBalancer
       (elasticloadbalancing/enable-availability-zones-for-load-balancer-request
        (clojure.core/nth args4716 0)))))))
  (clojure.core/defn
   enable-availability-zones-for-load-balancer-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         availability-zones
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for enableAvailabilityZonesForLoadBalancer"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :enable-availability-zones-for-load-balancer,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   enable-availability-zones-for-load-balancer
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         availability-zones
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call enableAvailabilityZonesForLoadBalancer"}
   [credentials4719 & args4720]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4721
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4719)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4721
      enableAvailabilityZonesForLoadBalancer
      (elasticloadbalancing/enable-availability-zones-for-load-balancer-request
       (clojure.core/nth args4720 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :describe-load-balancers
   [m4722]
   (clojure.core/let
    [credentials4723 (:credentials m4722) args4724 (:args m4722)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4725
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4723)]
     (clojure.core/case
      (clojure.core/count args4724)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4725
        describeLoadBalancers))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4725
        describeLoadBalancers
        (elasticloadbalancing/describe-load-balancers-request
         (clojure.core/nth args4724 0))))))))
  (clojure.core/defn
   describe-load-balancers-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         page-size
                         custom-query-parameters
                         read-limit
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeLoadBalancers, describeLoadBalancers"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-load-balancers,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-load-balancers,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   describe-load-balancers
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         page-size
                         custom-query-parameters
                         read-limit
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeLoadBalancers, describeLoadBalancers"}
   [credentials4727 & args4728]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4729
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4727)]
    (clojure.core/case
     (clojure.core/count args4728)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4729
       describeLoadBalancers))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4729
       describeLoadBalancers
       (elasticloadbalancing/describe-load-balancers-request
        (clojure.core/nth args4728 0))))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :delete-load-balancer-policy
   [m4730]
   (clojure.core/let
    [credentials4731 (:credentials m4730) args4732 (:args m4730)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4733
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4731)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4733
       deleteLoadBalancerPolicy
       (elasticloadbalancing/delete-load-balancer-policy-request
        (clojure.core/nth args4732 0)))))))
  (clojure.core/defn
   delete-load-balancer-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteLoadBalancerPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-load-balancer-policy,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   delete-load-balancer-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteLoadBalancerPolicy"}
   [credentials4735 & args4736]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4737
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4735)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4737
      deleteLoadBalancerPolicy
      (elasticloadbalancing/delete-load-balancer-policy-request
       (clojure.core/nth args4736 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :describe-load-balancer-policies
   [m4738]
   (clojure.core/let
    [credentials4739 (:credentials m4738) args4740 (:args m4738)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4741
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4739)]
     (clojure.core/case
      (clojure.core/count args4740)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4741
        describeLoadBalancerPolicies
        (elasticloadbalancing/describe-load-balancer-policies-request
         (clojure.core/nth args4740 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4741
        describeLoadBalancerPolicies))))))
  (clojure.core/defn
   describe-load-balancer-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeLoadBalancerPolicies, describeLoadBalancerPolicies"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-load-balancer-policies,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-load-balancer-policies,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   describe-load-balancer-policies
   {:arglists (quote
               [[credentials
                 {:keys [policy-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeLoadBalancerPolicies, describeLoadBalancerPolicies"}
   [credentials4743 & args4744]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4745
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4743)]
    (clojure.core/case
     (clojure.core/count args4744)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4745
       describeLoadBalancerPolicies
       (elasticloadbalancing/describe-load-balancer-policies-request
        (clojure.core/nth args4744 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4745
       describeLoadBalancerPolicies))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :remove-tags
   [m4750]
   (clojure.core/let
    [credentials4751 (:credentials m4750) args4752 (:args m4750)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4753
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4751)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4753
       removeTags
       (elasticloadbalancing/remove-tags-request
        (clojure.core/nth args4752 0)))))))
  (clojure.core/defn
   remove-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for removeTags"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :remove-tags,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   remove-tags
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call removeTags"}
   [credentials4755 & args4756]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4757
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4755)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4757
      removeTags
      (elasticloadbalancing/remove-tags-request
       (clojure.core/nth args4756 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :create-load-balancer-policy
   [m4758]
   (clojure.core/let
    [credentials4759 (:credentials m4758) args4760 (:args m4758)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4761
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4759)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4761
       createLoadBalancerPolicy
       (elasticloadbalancing/create-load-balancer-policy-request
        (clojure.core/nth args4760 0)))))))
  (clojure.core/defn
   create-load-balancer-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-type-name
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         policy-attributes
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createLoadBalancerPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-load-balancer-policy,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   create-load-balancer-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-type-name
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         policy-attributes
                         clone-source
                         clone-root]}]]),
    :doc "Call createLoadBalancerPolicy"}
   [credentials4763 & args4764]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4765
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4763)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4765
      createLoadBalancerPolicy
      (elasticloadbalancing/create-load-balancer-policy-request
       (clojure.core/nth args4764 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :create-load-balancer-listeners
   [m4766]
   (clojure.core/let
    [credentials4767 (:credentials m4766) args4768 (:args m4766)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4769
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4767)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4769
       createLoadBalancerListeners
       (elasticloadbalancing/create-load-balancer-listeners-request
        (clojure.core/nth args4768 0)))))))
  (clojure.core/defn
   create-load-balancer-listeners-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         listeners
                         clone-root]}]]),
    :doc "Generate map for createLoadBalancerListeners"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-load-balancer-listeners,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   create-load-balancer-listeners
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         listeners
                         clone-root]}]]),
    :doc "Call createLoadBalancerListeners"}
   [credentials4771 & args4772]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4773
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4771)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4773
      createLoadBalancerListeners
      (elasticloadbalancing/create-load-balancer-listeners-request
       (clojure.core/nth args4772 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :set-load-balancer-policies-for-backend-server
   [m4774]
   (clojure.core/let
    [credentials4775 (:credentials m4774) args4776 (:args m4774)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4777
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4775)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4777
       setLoadBalancerPoliciesForBackendServer
       (elasticloadbalancing/set-load-balancer-policies-for-backend-server-request
        (clojure.core/nth args4776 0)))))))
  (clojure.core/defn
   set-load-balancer-policies-for-backend-server-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         instance-port
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setLoadBalancerPoliciesForBackendServer"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-load-balancer-policies-for-backend-server,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   set-load-balancer-policies-for-backend-server
   {:arglists (quote
               [[credentials
                 {:keys [policy-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         instance-port
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call setLoadBalancerPoliciesForBackendServer"}
   [credentials4779 & args4780]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4781
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4779)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4781
      setLoadBalancerPoliciesForBackendServer
      (elasticloadbalancing/set-load-balancer-policies-for-backend-server-request
       (clojure.core/nth args4780 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :describe-instance-health
   [m4782]
   (clojure.core/let
    [credentials4783 (:credentials m4782) args4784 (:args m4782)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4785
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4783)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4785
       describeInstanceHealth
       (elasticloadbalancing/describe-instance-health-request
        (clojure.core/nth args4784 0)))))))
  (clojure.core/defn
   describe-instance-health-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         instances
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeInstanceHealth"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-instance-health,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   describe-instance-health
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         instances
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeInstanceHealth"}
   [credentials4787 & args4788]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4789
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4787)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4789
      describeInstanceHealth
      (elasticloadbalancing/describe-instance-health-request
       (clojure.core/nth args4788 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :delete-load-balancer
   [m4790]
   (clojure.core/let
    [credentials4791 (:credentials m4790) args4792 (:args m4790)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4793
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4791)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4793
       deleteLoadBalancer
       (elasticloadbalancing/delete-load-balancer-request
        (clojure.core/nth args4792 0)))))))
  (clojure.core/defn
   delete-load-balancer-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteLoadBalancer"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-load-balancer,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   delete-load-balancer
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteLoadBalancer"}
   [credentials4795 & args4796]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4797
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4795)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4797
      deleteLoadBalancer
      (elasticloadbalancing/delete-load-balancer-request
       (clojure.core/nth args4796 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :detach-load-balancer-from-subnets
   [m4798]
   (clojure.core/let
    [credentials4799 (:credentials m4798) args4800 (:args m4798)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4801
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4799)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4801
       detachLoadBalancerFromSubnets
       (elasticloadbalancing/detach-load-balancer-from-subnets-request
        (clojure.core/nth args4800 0)))))))
  (clojure.core/defn
   detach-load-balancer-from-subnets-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         subnets
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for detachLoadBalancerFromSubnets"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :detach-load-balancer-from-subnets,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   detach-load-balancer-from-subnets
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         subnets
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call detachLoadBalancerFromSubnets"}
   [credentials4803 & args4804]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4805
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4803)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4805
      detachLoadBalancerFromSubnets
      (elasticloadbalancing/detach-load-balancer-from-subnets-request
       (clojure.core/nth args4804 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :disable-availability-zones-for-load-balancer
   [m4806]
   (clojure.core/let
    [credentials4807 (:credentials m4806) args4808 (:args m4806)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4809
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4807)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4809
       disableAvailabilityZonesForLoadBalancer
       (elasticloadbalancing/disable-availability-zones-for-load-balancer-request
        (clojure.core/nth args4808 0)))))))
  (clojure.core/defn
   disable-availability-zones-for-load-balancer-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         availability-zones
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for disableAvailabilityZonesForLoadBalancer"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :disable-availability-zones-for-load-balancer,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   disable-availability-zones-for-load-balancer
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         availability-zones
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call disableAvailabilityZonesForLoadBalancer"}
   [credentials4811 & args4812]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4813
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4811)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4813
      disableAvailabilityZonesForLoadBalancer
      (elasticloadbalancing/disable-availability-zones-for-load-balancer-request
       (clojure.core/nth args4812 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :set-load-balancer-policies-of-listener
   [m4814]
   (clojure.core/let
    [credentials4815 (:credentials m4814) args4816 (:args m4814)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4817
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4815)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4817
       setLoadBalancerPoliciesOfListener
       (elasticloadbalancing/set-load-balancer-policies-of-listener-request
        (clojure.core/nth args4816 0)))))))
  (clojure.core/defn
   set-load-balancer-policies-of-listener-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         load-balancer-port]}]]),
    :doc "Generate map for setLoadBalancerPoliciesOfListener"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-load-balancer-policies-of-listener,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   set-load-balancer-policies-of-listener
   {:arglists (quote
               [[credentials
                 {:keys [policy-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         load-balancer-port]}]]),
    :doc "Call setLoadBalancerPoliciesOfListener"}
   [credentials4819 & args4820]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4821
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4819)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4821
      setLoadBalancerPoliciesOfListener
      (elasticloadbalancing/set-load-balancer-policies-of-listener-request
       (clojure.core/nth args4820 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :add-tags
   [m4822]
   (clojure.core/let
    [credentials4823 (:credentials m4822) args4824 (:args m4822)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4825
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4823)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4825
       addTags
       (elasticloadbalancing/add-tags-request
        (clojure.core/nth args4824 0)))))))
  (clojure.core/defn
   add-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for addTags"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :add-tags,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   add-tags
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call addTags"}
   [credentials4827 & args4828]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4829
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4827)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4829
      addTags
      (elasticloadbalancing/add-tags-request
       (clojure.core/nth args4828 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :register-instances-with-load-balancer
   [m4830]
   (clojure.core/let
    [credentials4831 (:credentials m4830) args4832 (:args m4830)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4833
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4831)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4833
       registerInstancesWithLoadBalancer
       (elasticloadbalancing/register-instances-with-load-balancer-request
        (clojure.core/nth args4832 0)))))))
  (clojure.core/defn
   register-instances-with-load-balancer-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         instances
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for registerInstancesWithLoadBalancer"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :register-instances-with-load-balancer,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   register-instances-with-load-balancer
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         instances
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call registerInstancesWithLoadBalancer"}
   [credentials4835 & args4836]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4837
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4835)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4837
      registerInstancesWithLoadBalancer
      (elasticloadbalancing/register-instances-with-load-balancer-request
       (clojure.core/nth args4836 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :describe-tags
   [m4838]
   (clojure.core/let
    [credentials4839 (:credentials m4838) args4840 (:args m4838)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4841
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4839)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4841
       describeTags
       (elasticloadbalancing/describe-tags-request
        (clojure.core/nth args4840 0)))))))
  (clojure.core/defn
   describe-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeTags"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-tags,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   describe-tags
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeTags"}
   [credentials4843 & args4844]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4845
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4843)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4845
      describeTags
      (elasticloadbalancing/describe-tags-request
       (clojure.core/nth args4844 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :create-app-cookie-stickiness-policy
   [m4846]
   (clojure.core/let
    [credentials4847 (:credentials m4846) args4848 (:args m4846)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4849
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4847)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4849
       createAppCookieStickinessPolicy
       (elasticloadbalancing/create-app-cookie-stickiness-policy-request
        (clojure.core/nth args4848 0)))))))
  (clojure.core/defn
   create-app-cookie-stickiness-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cookie-name
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createAppCookieStickinessPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-app-cookie-stickiness-policy,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   create-app-cookie-stickiness-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cookie-name
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createAppCookieStickinessPolicy"}
   [credentials4851 & args4852]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4853
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4851)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4853
      createAppCookieStickinessPolicy
      (elasticloadbalancing/create-app-cookie-stickiness-policy-request
       (clojure.core/nth args4852 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :modify-load-balancer-attributes
   [m4854]
   (clojure.core/let
    [credentials4855 (:credentials m4854) args4856 (:args m4854)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4857
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4855)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4857
       modifyLoadBalancerAttributes
       (elasticloadbalancing/modify-load-balancer-attributes-request
        (clojure.core/nth args4856 0)))))))
  (clojure.core/defn
   modify-load-balancer-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         load-balancer-attributes
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for modifyLoadBalancerAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-load-balancer-attributes,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   modify-load-balancer-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         load-balancer-attributes
                         clone-source
                         clone-root]}]]),
    :doc "Call modifyLoadBalancerAttributes"}
   [credentials4859 & args4860]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4861
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4859)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4861
      modifyLoadBalancerAttributes
      (elasticloadbalancing/modify-load-balancer-attributes-request
       (clojure.core/nth args4860 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :set-load-balancer-listener-sslcertificate
   [m4862]
   (clojure.core/let
    [credentials4863 (:credentials m4862) args4864 (:args m4862)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4865
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4863)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4865
       setLoadBalancerListenerSSLCertificate
       (elasticloadbalancing/set-load-balancer-listener-sslcertificate-request
        (clojure.core/nth args4864 0)))))))
  (clojure.core/defn
   set-load-balancer-listener-sslcertificate-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sslcertificate-id
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         load-balancer-port]}]]),
    :doc "Generate map for setLoadBalancerListenerSSLCertificate"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-load-balancer-listener-sslcertificate,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   set-load-balancer-listener-sslcertificate
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sslcertificate-id
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         load-balancer-port]}]]),
    :doc "Call setLoadBalancerListenerSSLCertificate"}
   [credentials4867 & args4868]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4869
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4867)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4869
      setLoadBalancerListenerSSLCertificate
      (elasticloadbalancing/set-load-balancer-listener-sslcertificate-request
       (clojure.core/nth args4868 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :describe-load-balancer-attributes
   [m4870]
   (clojure.core/let
    [credentials4871 (:credentials m4870) args4872 (:args m4870)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4873
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4871)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4873
       describeLoadBalancerAttributes
       (elasticloadbalancing/describe-load-balancer-attributes-request
        (clojure.core/nth args4872 0)))))))
  (clojure.core/defn
   describe-load-balancer-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeLoadBalancerAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-load-balancer-attributes,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   describe-load-balancer-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeLoadBalancerAttributes"}
   [credentials4875 & args4876]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4877
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4875)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4877
      describeLoadBalancerAttributes
      (elasticloadbalancing/describe-load-balancer-attributes-request
       (clojure.core/nth args4876 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :configure-health-check
   [m4878]
   (clojure.core/let
    [credentials4879 (:credentials m4878) args4880 (:args m4878)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4881
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4879)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4881
       configureHealthCheck
       (elasticloadbalancing/configure-health-check-request
        (clojure.core/nth args4880 0)))))))
  (clojure.core/defn
   configure-health-check-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         health-check
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for configureHealthCheck"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :configure-health-check,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   configure-health-check
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         health-check
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call configureHealthCheck"}
   [credentials4883 & args4884]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4885
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4883)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4885
      configureHealthCheck
      (elasticloadbalancing/configure-health-check-request
       (clojure.core/nth args4884 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :attach-load-balancer-to-subnets
   [m4886]
   (clojure.core/let
    [credentials4887 (:credentials m4886) args4888 (:args m4886)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4889
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4887)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4889
       attachLoadBalancerToSubnets
       (elasticloadbalancing/attach-load-balancer-to-subnets-request
        (clojure.core/nth args4888 0)))))))
  (clojure.core/defn
   attach-load-balancer-to-subnets-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         subnets
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for attachLoadBalancerToSubnets"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :attach-load-balancer-to-subnets,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   attach-load-balancer-to-subnets
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         subnets
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call attachLoadBalancerToSubnets"}
   [credentials4891 & args4892]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4893
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4891)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4893
      attachLoadBalancerToSubnets
      (elasticloadbalancing/attach-load-balancer-to-subnets-request
       (clojure.core/nth args4892 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :describe-load-balancer-policy-types
   [m4894]
   (clojure.core/let
    [credentials4895 (:credentials m4894) args4896 (:args m4894)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4897
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4895)]
     (clojure.core/case
      (clojure.core/count args4896)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4897
        describeLoadBalancerPolicyTypes
        (elasticloadbalancing/describe-load-balancer-policy-types-request
         (clojure.core/nth args4896 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4897
        describeLoadBalancerPolicyTypes))))))
  (clojure.core/defn
   describe-load-balancer-policy-types-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-type-names
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeLoadBalancerPolicyTypes, describeLoadBalancerPolicyTypes"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-load-balancer-policy-types,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-load-balancer-policy-types,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   describe-load-balancer-policy-types
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-type-names
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeLoadBalancerPolicyTypes, describeLoadBalancerPolicyTypes"}
   [credentials4899 & args4900]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4901
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4899)]
    (clojure.core/case
     (clojure.core/count args4900)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4901
       describeLoadBalancerPolicyTypes
       (elasticloadbalancing/describe-load-balancer-policy-types-request
        (clojure.core/nth args4900 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4901
       describeLoadBalancerPolicyTypes))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :deregister-instances-from-load-balancer
   [m4902]
   (clojure.core/let
    [credentials4903 (:credentials m4902) args4904 (:args m4902)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4905
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4903)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4905
       deregisterInstancesFromLoadBalancer
       (elasticloadbalancing/deregister-instances-from-load-balancer-request
        (clojure.core/nth args4904 0)))))))
  (clojure.core/defn
   deregister-instances-from-load-balancer-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         instances
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deregisterInstancesFromLoadBalancer"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :deregister-instances-from-load-balancer,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   deregister-instances-from-load-balancer
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         instances
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deregisterInstancesFromLoadBalancer"}
   [credentials4907 & args4908]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4909
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4907)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4909
      deregisterInstancesFromLoadBalancer
      (elasticloadbalancing/deregister-instances-from-load-balancer-request
       (clojure.core/nth args4908 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :apply-security-groups-to-load-balancer
   [m4910]
   (clojure.core/let
    [credentials4911 (:credentials m4910) args4912 (:args m4910)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4913
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4911)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4913
       applySecurityGroupsToLoadBalancer
       (elasticloadbalancing/apply-security-groups-to-load-balancer-request
        (clojure.core/nth args4912 0)))))))
  (clojure.core/defn
   apply-security-groups-to-load-balancer-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         security-groups
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for applySecurityGroupsToLoadBalancer"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :apply-security-groups-to-load-balancer,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   apply-security-groups-to-load-balancer
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         security-groups
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call applySecurityGroupsToLoadBalancer"}
   [credentials4915 & args4916]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4917
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4915)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4917
      applySecurityGroupsToLoadBalancer
      (elasticloadbalancing/apply-security-groups-to-load-balancer-request
       (clojure.core/nth args4916 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :create-lbcookie-stickiness-policy
   [m4918]
   (clojure.core/let
    [credentials4919 (:credentials m4918) args4920 (:args m4918)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4921
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4919)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4921
       createLBCookieStickinessPolicy
       (elasticloadbalancing/create-lbcookie-stickiness-policy-request
        (clojure.core/nth args4920 0)))))))
  (clojure.core/defn
   create-lbcookie-stickiness-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [cookie-expiration-period
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createLBCookieStickinessPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-lbcookie-stickiness-policy,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   create-lbcookie-stickiness-policy
   {:arglists (quote
               [[credentials
                 {:keys [cookie-expiration-period
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createLBCookieStickinessPolicy"}
   [credentials4923 & args4924]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4925
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4923)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4925
      createLBCookieStickinessPolicy
      (elasticloadbalancing/create-lbcookie-stickiness-policy-request
       (clojure.core/nth args4924 0))))))))
