(ns
 com.palletops.awaze.elasticbeanstalk
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.elasticbeanstalk :as elasticbeanstalk]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :elasticbeanstalk
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.EventSeverity}
event-severity
  [m10711]
  (.
   com.amazonaws.services.elasticbeanstalk.model.EventSeverity
   fromValue
   (clojure.core/name m10711)))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.OptionSpecification}
option-specification
  [m10714]
  (clojure.core/let
   [bean10713
    (new
     com.amazonaws.services.elasticbeanstalk.model.OptionSpecification)]
   (clojure.core/let
    [v10715
     (:namespace m10714 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10715 :com.palletops.awaze.client-builder/undef)
     (. bean10713 setNamespace (clojure.core/str v10715))))
   (clojure.core/let
    [v10715
     (:resource-name m10714 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10715 :com.palletops.awaze.client-builder/undef)
     (. bean10713 setResourceName (clojure.core/str v10715))))
   (clojure.core/let
    [v10715
     (:option-name m10714 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10715 :com.palletops.awaze.client-builder/undef)
     (. bean10713 setOptionName (clojure.core/str v10715))))
   bean10713))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.ConfigurationOptionSetting}
configuration-option-setting
  [m10717]
  (clojure.core/let
   [bean10716
    (new
     com.amazonaws.services.elasticbeanstalk.model.ConfigurationOptionSetting)]
   (clojure.core/let
    [v10718
     (:namespace m10717 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10718 :com.palletops.awaze.client-builder/undef)
     (. bean10716 setNamespace (clojure.core/str v10718))))
   (clojure.core/let
    [v10718
     (:resource-name m10717 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10718 :com.palletops.awaze.client-builder/undef)
     (. bean10716 setResourceName (clojure.core/str v10718))))
   (clojure.core/let
    [v10718
     (:option-name m10717 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10718 :com.palletops.awaze.client-builder/undef)
     (. bean10716 setOptionName (clojure.core/str v10718))))
   (clojure.core/let
    [v10718 (:value m10717 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10718 :com.palletops.awaze.client-builder/undef)
     (. bean10716 setValue (clojure.core/str v10718))))
   bean10716))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.SourceConfiguration}
source-configuration
  [m10720]
  (clojure.core/let
   [bean10719
    (new
     com.amazonaws.services.elasticbeanstalk.model.SourceConfiguration)]
   (clojure.core/let
    [v10721
     (:template-name m10720 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10721 :com.palletops.awaze.client-builder/undef)
     (. bean10719 setTemplateName (clojure.core/str v10721))))
   (clojure.core/let
    [v10721
     (:application-name
      m10720
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10721 :com.palletops.awaze.client-builder/undef)
     (. bean10719 setApplicationName (clojure.core/str v10721))))
   bean10719))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.EnvironmentTier}
environment-tier
  [m10723]
  (clojure.core/let
   [bean10722
    (new
     com.amazonaws.services.elasticbeanstalk.model.EnvironmentTier)]
   (clojure.core/let
    [v10724
     (:version m10723 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10724 :com.palletops.awaze.client-builder/undef)
     (. bean10722 setVersion (clojure.core/str v10724))))
   (clojure.core/let
    [v10724 (:type m10723 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10724 :com.palletops.awaze.client-builder/undef)
     (. bean10722 setType (clojure.core/str v10724))))
   (clojure.core/let
    [v10724 (:name m10723 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10724 :com.palletops.awaze.client-builder/undef)
     (. bean10722 setName (clojure.core/str v10724))))
   bean10722))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.EnvironmentInfoType}
environment-info-type
  [m10726]
  (.
   com.amazonaws.services.elasticbeanstalk.model.EnvironmentInfoType
   fromValue
   (clojure.core/name m10726)))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.S3Location}
s3location
  [m10729]
  (clojure.core/let
   [bean10728
    (new com.amazonaws.services.elasticbeanstalk.model.S3Location)]
   (clojure.core/let
    [v10730
     (:s3bucket m10729 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10730 :com.palletops.awaze.client-builder/undef)
     (. bean10728 setS3Bucket (clojure.core/str v10730))))
   (clojure.core/let
    [v10730 (:s3key m10729 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10730 :com.palletops.awaze.client-builder/undef)
     (. bean10728 setS3Key (clojure.core/str v10730))))
   bean10728))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.Tag}
tag
  [m10732]
  (clojure.core/let
   [bean10731 (new com.amazonaws.services.elasticbeanstalk.model.Tag)]
   (clojure.core/let
    [v10733 (:key m10732 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10733 :com.palletops.awaze.client-builder/undef)
     (. bean10731 setKey (clojure.core/str v10733))))
   (clojure.core/let
    [v10733 (:value m10732 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10733 :com.palletops.awaze.client-builder/undef)
     (. bean10731 setValue (clojure.core/str v10733))))
   bean10731))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationVersionsRequest}
describe-application-versions-request
  [m10735]
  (clojure.core/let
   [bean10734
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationVersionsRequest)]
   (clojure.core/let
    [v10736
     (:version-labels
      m10735
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10736 :com.palletops.awaze.client-builder/undef)
     (.
      bean10734
      setVersionLabels
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10833] (clojure.core/str arg10833))
 v10736))))
   (clojure.core/let
    [v10736
     (:application-name
      m10735
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10736 :com.palletops.awaze.client-builder/undef)
     (. bean10734 setApplicationName (clojure.core/str v10736))))
   bean10734))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.ComposeEnvironmentsRequest}
compose-environments-request
  [m10738]
  (clojure.core/let
   [bean10737
    (new
     com.amazonaws.services.elasticbeanstalk.model.ComposeEnvironmentsRequest)]
   (clojure.core/let
    [v10739
     (:group-name m10738 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10739 :com.palletops.awaze.client-builder/undef)
     (. bean10737 setGroupName (clojure.core/str v10739))))
   (clojure.core/let
    [v10739
     (:version-labels
      m10738
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10739 :com.palletops.awaze.client-builder/undef)
     (.
      bean10737
      setVersionLabels
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10834] (clojure.core/str arg10834))
 v10739))))
   (clojure.core/let
    [v10739
     (:application-name
      m10738
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10739 :com.palletops.awaze.client-builder/undef)
     (. bean10737 setApplicationName (clojure.core/str v10739))))
   bean10737))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.RebuildEnvironmentRequest}
rebuild-environment-request
  [m10741]
  (clojure.core/let
   [bean10740
    (new
     com.amazonaws.services.elasticbeanstalk.model.RebuildEnvironmentRequest)]
   (clojure.core/let
    [v10742
     (:environment-id
      m10741
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10742 :com.palletops.awaze.client-builder/undef)
     (. bean10740 setEnvironmentId (clojure.core/str v10742))))
   (clojure.core/let
    [v10742
     (:environment-name
      m10741
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10742 :com.palletops.awaze.client-builder/undef)
     (. bean10740 setEnvironmentName (clojure.core/str v10742))))
   bean10740))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.UpdateApplicationVersionRequest}
update-application-version-request
  [m10744]
  (clojure.core/let
   [bean10743
    (new
     com.amazonaws.services.elasticbeanstalk.model.UpdateApplicationVersionRequest)]
   (clojure.core/let
    [v10745
     (:description m10744 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10745 :com.palletops.awaze.client-builder/undef)
     (. bean10743 setDescription (clojure.core/str v10745))))
   (clojure.core/let
    [v10745
     (:application-name
      m10744
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10745 :com.palletops.awaze.client-builder/undef)
     (. bean10743 setApplicationName (clojure.core/str v10745))))
   (clojure.core/let
    [v10745
     (:version-label m10744 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10745 :com.palletops.awaze.client-builder/undef)
     (. bean10743 setVersionLabel (clojure.core/str v10745))))
   bean10743))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DeleteEnvironmentConfigurationRequest}
delete-environment-configuration-request
  [m10747]
  (clojure.core/let
   [bean10746
    (new
     com.amazonaws.services.elasticbeanstalk.model.DeleteEnvironmentConfigurationRequest)]
   (clojure.core/let
    [v10748
     (:environment-name
      m10747
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10748 :com.palletops.awaze.client-builder/undef)
     (. bean10746 setEnvironmentName (clojure.core/str v10748))))
   (clojure.core/let
    [v10748
     (:application-name
      m10747
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10748 :com.palletops.awaze.client-builder/undef)
     (. bean10746 setApplicationName (clojure.core/str v10748))))
   bean10746))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DescribeEventsRequest}
describe-events-request
  [m10750]
  (clojure.core/let
   [bean10749
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeEventsRequest)]
   (clojure.core/let
    [v10751
     (:start-time m10750 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10751 :com.palletops.awaze.client-builder/undef)
     (.
      bean10749
      setStartTime
      (com.palletops.awaze.common/to-date v10751))))
   (clojure.core/let
    [v10751
     (:version-label m10750 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10751 :com.palletops.awaze.client-builder/undef)
     (. bean10749 setVersionLabel (clojure.core/str v10751))))
   (clojure.core/let
    [v10751
     (:template-name m10750 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10751 :com.palletops.awaze.client-builder/undef)
     (. bean10749 setTemplateName (clojure.core/str v10751))))
   (clojure.core/let
    [v10751
     (:environment-name
      m10750
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10751 :com.palletops.awaze.client-builder/undef)
     (. bean10749 setEnvironmentName (clojure.core/str v10751))))
   (clojure.core/let
    [v10751
     (:max-records m10750 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10751 :com.palletops.awaze.client-builder/undef)
     (. bean10749 setMaxRecords (clojure.core/int v10751))))
   (clojure.core/let
    [v10751
     (:severity m10750 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10751 :com.palletops.awaze.client-builder/undef)
     (.
      bean10749
      setSeverity
      (elasticbeanstalk/event-severity v10751))))
   (clojure.core/let
    [v10751
     (:end-time m10750 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10751 :com.palletops.awaze.client-builder/undef)
     (.
      bean10749
      setEndTime
      (com.palletops.awaze.common/to-date v10751))))
   (clojure.core/let
    [v10751
     (:request-id m10750 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10751 :com.palletops.awaze.client-builder/undef)
     (. bean10749 setRequestId (clojure.core/str v10751))))
   (clojure.core/let
    [v10751
     (:environment-id
      m10750
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10751 :com.palletops.awaze.client-builder/undef)
     (. bean10749 setEnvironmentId (clojure.core/str v10751))))
   (clojure.core/let
    [v10751
     (:next-token m10750 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10751 :com.palletops.awaze.client-builder/undef)
     (. bean10749 setNextToken (clojure.core/str v10751))))
   (clojure.core/let
    [v10751
     (:application-name
      m10750
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10751 :com.palletops.awaze.client-builder/undef)
     (. bean10749 setApplicationName (clojure.core/str v10751))))
   bean10749))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationSettingsRequest}
describe-configuration-settings-request
  [m10753]
  (clojure.core/let
   [bean10752
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationSettingsRequest)]
   (clojure.core/let
    [v10754
     (:template-name m10753 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10754 :com.palletops.awaze.client-builder/undef)
     (. bean10752 setTemplateName (clojure.core/str v10754))))
   (clojure.core/let
    [v10754
     (:environment-name
      m10753
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10754 :com.palletops.awaze.client-builder/undef)
     (. bean10752 setEnvironmentName (clojure.core/str v10754))))
   (clojure.core/let
    [v10754
     (:application-name
      m10753
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10754 :com.palletops.awaze.client-builder/undef)
     (. bean10752 setApplicationName (clojure.core/str v10754))))
   bean10752))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.TerminateEnvironmentRequest}
terminate-environment-request
  [m10756]
  (clojure.core/let
   [bean10755
    (new
     com.amazonaws.services.elasticbeanstalk.model.TerminateEnvironmentRequest)]
   (clojure.core/let
    [v10757
     (:terminate-resources
      m10756
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10757 :com.palletops.awaze.client-builder/undef)
     (. bean10755 setTerminateResources (clojure.core/boolean v10757))))
   (clojure.core/let
    [v10757
     (:environment-id
      m10756
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10757 :com.palletops.awaze.client-builder/undef)
     (. bean10755 setEnvironmentId (clojure.core/str v10757))))
   (clojure.core/let
    [v10757
     (:environment-name
      m10756
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10757 :com.palletops.awaze.client-builder/undef)
     (. bean10755 setEnvironmentName (clojure.core/str v10757))))
   (clojure.core/let
    [v10757
     (:force-terminate
      m10756
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10757 :com.palletops.awaze.client-builder/undef)
     (. bean10755 setForceTerminate (clojure.core/boolean v10757))))
   bean10755))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationOptionsRequest}
describe-configuration-options-request
  [m10759]
  (clojure.core/let
   [bean10758
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationOptionsRequest)]
   (clojure.core/let
    [v10760
     (:options m10759 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10760 :com.palletops.awaze.client-builder/undef)
     (.
      bean10758
      setOptions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg10835]
  (elasticbeanstalk/option-specification arg10835))
 v10760))))
   (clojure.core/let
    [v10760
     (:template-name m10759 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10760 :com.palletops.awaze.client-builder/undef)
     (. bean10758 setTemplateName (clojure.core/str v10760))))
   (clojure.core/let
    [v10760
     (:environment-name
      m10759
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10760 :com.palletops.awaze.client-builder/undef)
     (. bean10758 setEnvironmentName (clojure.core/str v10760))))
   (clojure.core/let
    [v10760
     (:solution-stack-name
      m10759
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10760 :com.palletops.awaze.client-builder/undef)
     (. bean10758 setSolutionStackName (clojure.core/str v10760))))
   (clojure.core/let
    [v10760
     (:application-name
      m10759
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10760 :com.palletops.awaze.client-builder/undef)
     (. bean10758 setApplicationName (clojure.core/str v10760))))
   bean10758))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.CreateConfigurationTemplateRequest}
create-configuration-template-request
  [m10762]
  (clojure.core/let
   [bean10761
    (new
     com.amazonaws.services.elasticbeanstalk.model.CreateConfigurationTemplateRequest)]
   (clojure.core/let
    [v10763
     (:description m10762 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10763 :com.palletops.awaze.client-builder/undef)
     (. bean10761 setDescription (clojure.core/str v10763))))
   (clojure.core/let
    [v10763
     (:option-settings
      m10762
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10763 :com.palletops.awaze.client-builder/undef)
     (.
      bean10761
      setOptionSettings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg10836]
  (elasticbeanstalk/configuration-option-setting arg10836))
 v10763))))
   (clojure.core/let
    [v10763
     (:template-name m10762 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10763 :com.palletops.awaze.client-builder/undef)
     (. bean10761 setTemplateName (clojure.core/str v10763))))
   (clojure.core/let
    [v10763
     (:environment-id
      m10762
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10763 :com.palletops.awaze.client-builder/undef)
     (. bean10761 setEnvironmentId (clojure.core/str v10763))))
   (clojure.core/let
    [v10763
     (:solution-stack-name
      m10762
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10763 :com.palletops.awaze.client-builder/undef)
     (. bean10761 setSolutionStackName (clojure.core/str v10763))))
   (clojure.core/let
    [v10763
     (:source-configuration
      m10762
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10763 :com.palletops.awaze.client-builder/undef)
     (.
      bean10761
      setSourceConfiguration
      (elasticbeanstalk/source-configuration v10763))))
   (clojure.core/let
    [v10763
     (:application-name
      m10762
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10763 :com.palletops.awaze.client-builder/undef)
     (. bean10761 setApplicationName (clojure.core/str v10763))))
   bean10761))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.UpdateEnvironmentRequest}
update-environment-request
  [m10765]
  (clojure.core/let
   [bean10764
    (new
     com.amazonaws.services.elasticbeanstalk.model.UpdateEnvironmentRequest)]
   (clojure.core/let
    [v10766
     (:option-settings
      m10765
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10766 :com.palletops.awaze.client-builder/undef)
     (.
      bean10764
      setOptionSettings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg10837]
  (elasticbeanstalk/configuration-option-setting arg10837))
 v10766))))
   (clojure.core/let
    [v10766
     (:description m10765 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10766 :com.palletops.awaze.client-builder/undef)
     (. bean10764 setDescription (clojure.core/str v10766))))
   (clojure.core/let
    [v10766
     (:solution-stack-name
      m10765
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10766 :com.palletops.awaze.client-builder/undef)
     (. bean10764 setSolutionStackName (clojure.core/str v10766))))
   (clojure.core/let
    [v10766 (:tier m10765 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10766 :com.palletops.awaze.client-builder/undef)
     (. bean10764 setTier (elasticbeanstalk/environment-tier v10766))))
   (clojure.core/let
    [v10766
     (:version-label m10765 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10766 :com.palletops.awaze.client-builder/undef)
     (. bean10764 setVersionLabel (clojure.core/str v10766))))
   (clojure.core/let
    [v10766
     (:template-name m10765 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10766 :com.palletops.awaze.client-builder/undef)
     (. bean10764 setTemplateName (clojure.core/str v10766))))
   (clojure.core/let
    [v10766
     (:environment-name
      m10765
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10766 :com.palletops.awaze.client-builder/undef)
     (. bean10764 setEnvironmentName (clojure.core/str v10766))))
   (clojure.core/let
    [v10766
     (:options-to-remove
      m10765
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10766 :com.palletops.awaze.client-builder/undef)
     (.
      bean10764
      setOptionsToRemove
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg10838]
  (elasticbeanstalk/option-specification arg10838))
 v10766))))
   (clojure.core/let
    [v10766
     (:group-name m10765 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10766 :com.palletops.awaze.client-builder/undef)
     (. bean10764 setGroupName (clojure.core/str v10766))))
   (clojure.core/let
    [v10766
     (:environment-id
      m10765
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10766 :com.palletops.awaze.client-builder/undef)
     (. bean10764 setEnvironmentId (clojure.core/str v10766))))
   (clojure.core/let
    [v10766
     (:application-name
      m10765
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10766 :com.palletops.awaze.client-builder/undef)
     (. bean10764 setApplicationName (clojure.core/str v10766))))
   bean10764))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationsRequest}
describe-applications-request
  [m10768]
  (clojure.core/let
   [bean10767
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationsRequest)]
   (clojure.core/let
    [v10769
     (:application-names
      m10768
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10769 :com.palletops.awaze.client-builder/undef)
     (.
      bean10767
      setApplicationNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10839] (clojure.core/str arg10839))
 v10769))))
   bean10767))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.CreateStorageLocationRequest}
create-storage-location-request
  [m10771]
  (clojure.core/let
   [bean10770
    (new
     com.amazonaws.services.elasticbeanstalk.model.CreateStorageLocationRequest)]
   bean10770))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.RestartAppServerRequest}
restart-app-server-request
  [m10774]
  (clojure.core/let
   [bean10773
    (new
     com.amazonaws.services.elasticbeanstalk.model.RestartAppServerRequest)]
   (clojure.core/let
    [v10775
     (:environment-id
      m10774
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10775 :com.palletops.awaze.client-builder/undef)
     (. bean10773 setEnvironmentId (clojure.core/str v10775))))
   (clojure.core/let
    [v10775
     (:environment-name
      m10774
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10775 :com.palletops.awaze.client-builder/undef)
     (. bean10773 setEnvironmentName (clojure.core/str v10775))))
   bean10773))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DeleteApplicationRequest}
delete-application-request
  [m10777]
  (clojure.core/let
   [bean10776
    (new
     com.amazonaws.services.elasticbeanstalk.model.DeleteApplicationRequest)]
   (clojure.core/let
    [v10778
     (:terminate-env-by-force
      m10777
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10778 :com.palletops.awaze.client-builder/undef)
     (.
      bean10776
      setTerminateEnvByForce
      (clojure.core/boolean v10778))))
   (clojure.core/let
    [v10778
     (:application-name
      m10777
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10778 :com.palletops.awaze.client-builder/undef)
     (. bean10776 setApplicationName (clojure.core/str v10778))))
   bean10776))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.CreateApplicationRequest}
create-application-request
  [m10780]
  (clojure.core/let
   [bean10779
    (new
     com.amazonaws.services.elasticbeanstalk.model.CreateApplicationRequest)]
   (clojure.core/let
    [v10781
     (:description m10780 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10781 :com.palletops.awaze.client-builder/undef)
     (. bean10779 setDescription (clojure.core/str v10781))))
   (clojure.core/let
    [v10781
     (:application-name
      m10780
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10781 :com.palletops.awaze.client-builder/undef)
     (. bean10779 setApplicationName (clojure.core/str v10781))))
   bean10779))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DeleteConfigurationTemplateRequest}
delete-configuration-template-request
  [m10783]
  (clojure.core/let
   [bean10782
    (new
     com.amazonaws.services.elasticbeanstalk.model.DeleteConfigurationTemplateRequest)]
   (clojure.core/let
    [v10784
     (:template-name m10783 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10784 :com.palletops.awaze.client-builder/undef)
     (. bean10782 setTemplateName (clojure.core/str v10784))))
   (clojure.core/let
    [v10784
     (:application-name
      m10783
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10784 :com.palletops.awaze.client-builder/undef)
     (. bean10782 setApplicationName (clojure.core/str v10784))))
   bean10782))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.SwapEnvironmentCNAMEsRequest}
swap-environment-cnames-request
  [m10786]
  (clojure.core/let
   [bean10785
    (new
     com.amazonaws.services.elasticbeanstalk.model.SwapEnvironmentCNAMEsRequest)]
   (clojure.core/let
    [v10787
     (:source-environment-id
      m10786
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10787 :com.palletops.awaze.client-builder/undef)
     (. bean10785 setSourceEnvironmentId (clojure.core/str v10787))))
   (clojure.core/let
    [v10787
     (:source-environment-name
      m10786
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10787 :com.palletops.awaze.client-builder/undef)
     (. bean10785 setSourceEnvironmentName (clojure.core/str v10787))))
   (clojure.core/let
    [v10787
     (:destination-environment-id
      m10786
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10787 :com.palletops.awaze.client-builder/undef)
     (.
      bean10785
      setDestinationEnvironmentId
      (clojure.core/str v10787))))
   (clojure.core/let
    [v10787
     (:destination-environment-name
      m10786
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10787 :com.palletops.awaze.client-builder/undef)
     (.
      bean10785
      setDestinationEnvironmentName
      (clojure.core/str v10787))))
   bean10785))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentHealthRequest}
describe-environment-health-request
  [m10789]
  (clojure.core/let
   [bean10788
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentHealthRequest)]
   (clojure.core/let
    [v10790
     (:attribute-names
      m10789
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10790 :com.palletops.awaze.client-builder/undef)
     (.
      bean10788
      setAttributeNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10840] (clojure.core/str arg10840))
 v10790))))
   (clojure.core/let
    [v10790
     (:environment-id
      m10789
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10790 :com.palletops.awaze.client-builder/undef)
     (. bean10788 setEnvironmentId (clojure.core/str v10790))))
   (clojure.core/let
    [v10790
     (:environment-name
      m10789
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10790 :com.palletops.awaze.client-builder/undef)
     (. bean10788 setEnvironmentName (clojure.core/str v10790))))
   bean10788))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.AbortEnvironmentUpdateRequest}
abort-environment-update-request
  [m10792]
  (clojure.core/let
   [bean10791
    (new
     com.amazonaws.services.elasticbeanstalk.model.AbortEnvironmentUpdateRequest)]
   (clojure.core/let
    [v10793
     (:environment-id
      m10792
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10793 :com.palletops.awaze.client-builder/undef)
     (. bean10791 setEnvironmentId (clojure.core/str v10793))))
   (clojure.core/let
    [v10793
     (:environment-name
      m10792
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10793 :com.palletops.awaze.client-builder/undef)
     (. bean10791 setEnvironmentName (clojure.core/str v10793))))
   bean10791))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.CheckDNSAvailabilityRequest}
check-dnsavailability-request
  [m10795]
  (clojure.core/let
   [bean10794
    (new
     com.amazonaws.services.elasticbeanstalk.model.CheckDNSAvailabilityRequest)]
   (clojure.core/let
    [v10796
     (:cnameprefix m10795 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10796 :com.palletops.awaze.client-builder/undef)
     (. bean10794 setCNAMEPrefix (clojure.core/str v10796))))
   bean10794))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.RetrieveEnvironmentInfoRequest}
retrieve-environment-info-request
  [m10798]
  (clojure.core/let
   [bean10797
    (new
     com.amazonaws.services.elasticbeanstalk.model.RetrieveEnvironmentInfoRequest)]
   (clojure.core/let
    [v10799
     (:info-type m10798 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10799 :com.palletops.awaze.client-builder/undef)
     (.
      bean10797
      setInfoType
      (elasticbeanstalk/environment-info-type v10799))))
   (clojure.core/let
    [v10799
     (:environment-id
      m10798
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10799 :com.palletops.awaze.client-builder/undef)
     (. bean10797 setEnvironmentId (clojure.core/str v10799))))
   (clojure.core/let
    [v10799
     (:environment-name
      m10798
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10799 :com.palletops.awaze.client-builder/undef)
     (. bean10797 setEnvironmentName (clojure.core/str v10799))))
   bean10797))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.CreateApplicationVersionRequest}
create-application-version-request
  [m10801]
  (clojure.core/let
   [bean10800
    (new
     com.amazonaws.services.elasticbeanstalk.model.CreateApplicationVersionRequest)]
   (clojure.core/let
    [v10802
     (:description m10801 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10802 :com.palletops.awaze.client-builder/undef)
     (. bean10800 setDescription (clojure.core/str v10802))))
   (clojure.core/let
    [v10802
     (:source-bundle m10801 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10802 :com.palletops.awaze.client-builder/undef)
     (.
      bean10800
      setSourceBundle
      (elasticbeanstalk/s3location v10802))))
   (clojure.core/let
    [v10802
     (:auto-create-application
      m10801
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10802 :com.palletops.awaze.client-builder/undef)
     (.
      bean10800
      setAutoCreateApplication
      (clojure.core/boolean v10802))))
   (clojure.core/let
    [v10802
     (:process m10801 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10802 :com.palletops.awaze.client-builder/undef)
     (. bean10800 setProcess (clojure.core/boolean v10802))))
   (clojure.core/let
    [v10802
     (:application-name
      m10801
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10802 :com.palletops.awaze.client-builder/undef)
     (. bean10800 setApplicationName (clojure.core/str v10802))))
   (clojure.core/let
    [v10802
     (:version-label m10801 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10802 :com.palletops.awaze.client-builder/undef)
     (. bean10800 setVersionLabel (clojure.core/str v10802))))
   bean10800))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsRequest}
describe-environments-request
  [m10804]
  (clojure.core/let
   [bean10803
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsRequest)]
   (clojure.core/let
    [v10805
     (:environment-ids
      m10804
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10805 :com.palletops.awaze.client-builder/undef)
     (.
      bean10803
      setEnvironmentIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10881] (clojure.core/str arg10881))
 v10805))))
   (clojure.core/let
    [v10805
     (:environment-names
      m10804
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10805 :com.palletops.awaze.client-builder/undef)
     (.
      bean10803
      setEnvironmentNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10882] (clojure.core/str arg10882))
 v10805))))
   (clojure.core/let
    [v10805
     (:include-deleted
      m10804
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10805 :com.palletops.awaze.client-builder/undef)
     (. bean10803 setIncludeDeleted (clojure.core/boolean v10805))))
   (clojure.core/let
    [v10805
     (:included-deleted-back-to
      m10804
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10805 :com.palletops.awaze.client-builder/undef)
     (.
      bean10803
      setIncludedDeletedBackTo
      (com.palletops.awaze.common/to-date v10805))))
   (clojure.core/let
    [v10805
     (:application-name
      m10804
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10805 :com.palletops.awaze.client-builder/undef)
     (. bean10803 setApplicationName (clojure.core/str v10805))))
   (clojure.core/let
    [v10805
     (:version-label m10804 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10805 :com.palletops.awaze.client-builder/undef)
     (. bean10803 setVersionLabel (clojure.core/str v10805))))
   bean10803))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.UpdateConfigurationTemplateRequest}
update-configuration-template-request
  [m10807]
  (clojure.core/let
   [bean10806
    (new
     com.amazonaws.services.elasticbeanstalk.model.UpdateConfigurationTemplateRequest)]
   (clojure.core/let
    [v10808
     (:options-to-remove
      m10807
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10808 :com.palletops.awaze.client-builder/undef)
     (.
      bean10806
      setOptionsToRemove
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg10883]
  (elasticbeanstalk/option-specification arg10883))
 v10808))))
   (clojure.core/let
    [v10808
     (:description m10807 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10808 :com.palletops.awaze.client-builder/undef)
     (. bean10806 setDescription (clojure.core/str v10808))))
   (clojure.core/let
    [v10808
     (:option-settings
      m10807
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10808 :com.palletops.awaze.client-builder/undef)
     (.
      bean10806
      setOptionSettings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg10884]
  (elasticbeanstalk/configuration-option-setting arg10884))
 v10808))))
   (clojure.core/let
    [v10808
     (:template-name m10807 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10808 :com.palletops.awaze.client-builder/undef)
     (. bean10806 setTemplateName (clojure.core/str v10808))))
   (clojure.core/let
    [v10808
     (:application-name
      m10807
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10808 :com.palletops.awaze.client-builder/undef)
     (. bean10806 setApplicationName (clojure.core/str v10808))))
   bean10806))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentResourcesRequest}
describe-environment-resources-request
  [m10810]
  (clojure.core/let
   [bean10809
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentResourcesRequest)]
   (clojure.core/let
    [v10811
     (:environment-id
      m10810
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10811 :com.palletops.awaze.client-builder/undef)
     (. bean10809 setEnvironmentId (clojure.core/str v10811))))
   (clojure.core/let
    [v10811
     (:environment-name
      m10810
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10811 :com.palletops.awaze.client-builder/undef)
     (. bean10809 setEnvironmentName (clojure.core/str v10811))))
   bean10809))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.ListAvailableSolutionStacksRequest}
list-available-solution-stacks-request
  [m10813]
  (clojure.core/let
   [bean10812
    (new
     com.amazonaws.services.elasticbeanstalk.model.ListAvailableSolutionStacksRequest)]
   bean10812))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.ValidateConfigurationSettingsRequest}
validate-configuration-settings-request
  [m10816]
  (clojure.core/let
   [bean10815
    (new
     com.amazonaws.services.elasticbeanstalk.model.ValidateConfigurationSettingsRequest)]
   (clojure.core/let
    [v10817
     (:option-settings
      m10816
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10817 :com.palletops.awaze.client-builder/undef)
     (.
      bean10815
      setOptionSettings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg10885]
  (elasticbeanstalk/configuration-option-setting arg10885))
 v10817))))
   (clojure.core/let
    [v10817
     (:template-name m10816 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10817 :com.palletops.awaze.client-builder/undef)
     (. bean10815 setTemplateName (clojure.core/str v10817))))
   (clojure.core/let
    [v10817
     (:environment-name
      m10816
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10817 :com.palletops.awaze.client-builder/undef)
     (. bean10815 setEnvironmentName (clojure.core/str v10817))))
   (clojure.core/let
    [v10817
     (:application-name
      m10816
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10817 :com.palletops.awaze.client-builder/undef)
     (. bean10815 setApplicationName (clojure.core/str v10817))))
   bean10815))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DescribeInstancesHealthRequest}
describe-instances-health-request
  [m10819]
  (clojure.core/let
   [bean10818
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeInstancesHealthRequest)]
   (clojure.core/let
    [v10820
     (:attribute-names
      m10819
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10820 :com.palletops.awaze.client-builder/undef)
     (.
      bean10818
      setAttributeNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10886] (clojure.core/str arg10886))
 v10820))))
   (clojure.core/let
    [v10820
     (:next-token m10819 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10820 :com.palletops.awaze.client-builder/undef)
     (. bean10818 setNextToken (clojure.core/str v10820))))
   (clojure.core/let
    [v10820
     (:environment-id
      m10819
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10820 :com.palletops.awaze.client-builder/undef)
     (. bean10818 setEnvironmentId (clojure.core/str v10820))))
   (clojure.core/let
    [v10820
     (:environment-name
      m10819
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10820 :com.palletops.awaze.client-builder/undef)
     (. bean10818 setEnvironmentName (clojure.core/str v10820))))
   bean10818))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.UpdateApplicationRequest}
update-application-request
  [m10822]
  (clojure.core/let
   [bean10821
    (new
     com.amazonaws.services.elasticbeanstalk.model.UpdateApplicationRequest)]
   (clojure.core/let
    [v10823
     (:description m10822 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10823 :com.palletops.awaze.client-builder/undef)
     (. bean10821 setDescription (clojure.core/str v10823))))
   (clojure.core/let
    [v10823
     (:application-name
      m10822
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10823 :com.palletops.awaze.client-builder/undef)
     (. bean10821 setApplicationName (clojure.core/str v10823))))
   bean10821))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.RequestEnvironmentInfoRequest}
request-environment-info-request
  [m10825]
  (clojure.core/let
   [bean10824
    (new
     com.amazonaws.services.elasticbeanstalk.model.RequestEnvironmentInfoRequest)]
   (clojure.core/let
    [v10826
     (:info-type m10825 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10826 :com.palletops.awaze.client-builder/undef)
     (.
      bean10824
      setInfoType
      (elasticbeanstalk/environment-info-type v10826))))
   (clojure.core/let
    [v10826
     (:environment-id
      m10825
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10826 :com.palletops.awaze.client-builder/undef)
     (. bean10824 setEnvironmentId (clojure.core/str v10826))))
   (clojure.core/let
    [v10826
     (:environment-name
      m10825
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10826 :com.palletops.awaze.client-builder/undef)
     (. bean10824 setEnvironmentName (clojure.core/str v10826))))
   bean10824))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.CreateEnvironmentRequest}
create-environment-request
  [m10828]
  (clojure.core/let
   [bean10827
    (new
     com.amazonaws.services.elasticbeanstalk.model.CreateEnvironmentRequest)]
   (clojure.core/let
    [v10829
     (:option-settings
      m10828
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10829 :com.palletops.awaze.client-builder/undef)
     (.
      bean10827
      setOptionSettings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg10887]
  (elasticbeanstalk/configuration-option-setting arg10887))
 v10829))))
   (clojure.core/let
    [v10829
     (:description m10828 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10829 :com.palletops.awaze.client-builder/undef)
     (. bean10827 setDescription (clojure.core/str v10829))))
   (clojure.core/let
    [v10829
     (:cnameprefix m10828 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10829 :com.palletops.awaze.client-builder/undef)
     (. bean10827 setCNAMEPrefix (clojure.core/str v10829))))
   (clojure.core/let
    [v10829
     (:solution-stack-name
      m10828
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10829 :com.palletops.awaze.client-builder/undef)
     (. bean10827 setSolutionStackName (clojure.core/str v10829))))
   (clojure.core/let
    [v10829 (:tier m10828 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10829 :com.palletops.awaze.client-builder/undef)
     (. bean10827 setTier (elasticbeanstalk/environment-tier v10829))))
   (clojure.core/let
    [v10829
     (:version-label m10828 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10829 :com.palletops.awaze.client-builder/undef)
     (. bean10827 setVersionLabel (clojure.core/str v10829))))
   (clojure.core/let
    [v10829
     (:template-name m10828 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10829 :com.palletops.awaze.client-builder/undef)
     (. bean10827 setTemplateName (clojure.core/str v10829))))
   (clojure.core/let
    [v10829
     (:environment-name
      m10828
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10829 :com.palletops.awaze.client-builder/undef)
     (. bean10827 setEnvironmentName (clojure.core/str v10829))))
   (clojure.core/let
    [v10829 (:tags m10828 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10829 :com.palletops.awaze.client-builder/undef)
     (.
      bean10827
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10888] (elasticbeanstalk/tag arg10888))
 v10829))))
   (clojure.core/let
    [v10829
     (:options-to-remove
      m10828
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10829 :com.palletops.awaze.client-builder/undef)
     (.
      bean10827
      setOptionsToRemove
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg10889]
  (elasticbeanstalk/option-specification arg10889))
 v10829))))
   (clojure.core/let
    [v10829
     (:group-name m10828 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10829 :com.palletops.awaze.client-builder/undef)
     (. bean10827 setGroupName (clojure.core/str v10829))))
   (clojure.core/let
    [v10829
     (:application-name
      m10828
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10829 :com.palletops.awaze.client-builder/undef)
     (. bean10827 setApplicationName (clojure.core/str v10829))))
   bean10827))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DeleteApplicationVersionRequest}
delete-application-version-request
  [m10831]
  (clojure.core/let
   [bean10830
    (new
     com.amazonaws.services.elasticbeanstalk.model.DeleteApplicationVersionRequest)]
   (clojure.core/let
    [v10832
     (:delete-source-bundle
      m10831
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10832 :com.palletops.awaze.client-builder/undef)
     (. bean10830 setDeleteSourceBundle (clojure.core/boolean v10832))))
   (clojure.core/let
    [v10832
     (:application-name
      m10831
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10832 :com.palletops.awaze.client-builder/undef)
     (. bean10830 setApplicationName (clojure.core/str v10832))))
   (clojure.core/let
    [v10832
     (:version-label m10831 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10832 :com.palletops.awaze.client-builder/undef)
     (. bean10830 setVersionLabel (clojure.core/str v10832))))
   bean10830))
 (clojure.core/defmulti
  elasticbeanstalk
  (clojure.core/fn
   elasticbeanstalk
   [m__1874__auto__]
   (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-application-versions
   [m10841]
   (clojure.core/let
    [credentials10842 (:credentials m10841) args10843 (:args m10841)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10844
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10842)]
     (clojure.core/case
      (clojure.core/count args10843)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10844
        describeApplicationVersions))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10844
        describeApplicationVersions
        (elasticbeanstalk/describe-application-versions-request
         (clojure.core/nth args10843 0))))))))
  (clojure.core/defn
   describe-application-versions-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         version-labels
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeApplicationVersions, describeApplicationVersions"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-application-versions,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-application-versions,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   describe-application-versions
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         version-labels
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeApplicationVersions, describeApplicationVersions"}
   [credentials10846 & args10847]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10848
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10846)]
    (clojure.core/case
     (clojure.core/count args10847)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10848
       describeApplicationVersions))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10848
       describeApplicationVersions
       (elasticbeanstalk/describe-application-versions-request
        (clojure.core/nth args10847 0))))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :compose-environments
   [m10849]
   (clojure.core/let
    [credentials10850 (:credentials m10849) args10851 (:args m10849)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10852
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10850)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10852
       composeEnvironments
       (elasticbeanstalk/compose-environments-request
        (clojure.core/nth args10851 0)))))))
  (clojure.core/defn
   compose-environments-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         version-labels
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for composeEnvironments"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :compose-environments,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   compose-environments
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         version-labels
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call composeEnvironments"}
   [credentials10854 & args10855]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10856
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10854)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10856
      composeEnvironments
      (elasticbeanstalk/compose-environments-request
       (clojure.core/nth args10855 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :rebuild-environment
   [m10857]
   (clojure.core/let
    [credentials10858 (:credentials m10857) args10859 (:args m10857)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10860
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10858)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10860
       rebuildEnvironment
       (elasticbeanstalk/rebuild-environment-request
        (clojure.core/nth args10859 0)))))))
  (clojure.core/defn
   rebuild-environment-map
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for rebuildEnvironment"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :rebuild-environment,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   rebuild-environment
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call rebuildEnvironment"}
   [credentials10862 & args10863]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10864
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10862)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10864
      rebuildEnvironment
      (elasticbeanstalk/rebuild-environment-request
       (clojure.core/nth args10863 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :update-application-version
   [m10865]
   (clojure.core/let
    [credentials10866 (:credentials m10865) args10867 (:args m10865)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10868
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10866)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10868
       updateApplicationVersion
       (elasticbeanstalk/update-application-version-request
        (clojure.core/nth args10867 0)))))))
  (clojure.core/defn
   update-application-version-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         version-label
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateApplicationVersion"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-application-version,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   update-application-version
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         version-label
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateApplicationVersion"}
   [credentials10870 & args10871]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10872
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10870)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10872
      updateApplicationVersion
      (elasticbeanstalk/update-application-version-request
       (clojure.core/nth args10871 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :delete-environment-configuration
   [m10873]
   (clojure.core/let
    [credentials10874 (:credentials m10873) args10875 (:args m10873)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10876
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10874)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10876
       deleteEnvironmentConfiguration
       (elasticbeanstalk/delete-environment-configuration-request
        (clojure.core/nth args10875 0)))))))
  (clojure.core/defn
   delete-environment-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for deleteEnvironmentConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-environment-configuration,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   delete-environment-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call deleteEnvironmentConfiguration"}
   [credentials10878 & args10879]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10880
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10878)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10880
      deleteEnvironmentConfiguration
      (elasticbeanstalk/delete-environment-configuration-request
       (clojure.core/nth args10879 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-events
   [m10890]
   (clojure.core/let
    [credentials10891 (:credentials m10890) args10892 (:args m10890)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10893
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10891)]
     (clojure.core/case
      (clojure.core/count args10892)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10893
        describeEvents))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10893
        describeEvents
        (elasticbeanstalk/describe-events-request
         (clojure.core/nth args10892 0))))))))
  (clojure.core/defn
   describe-events-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [template-name
                         environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         request-id
                         application-name
                         sdk-request-timeout
                         start-time
                         custom-query-parameters
                         end-time
                         version-label
                         read-limit
                         general-progress-listener
                         severity
                         max-records
                         clone-source
                         environment-name
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeEvents, describeEvents"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-events,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-events,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   describe-events
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [template-name
                         environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         request-id
                         application-name
                         sdk-request-timeout
                         start-time
                         custom-query-parameters
                         end-time
                         version-label
                         read-limit
                         general-progress-listener
                         severity
                         max-records
                         clone-source
                         environment-name
                         clone-root
                         next-token]}]]),
    :doc "Call describeEvents, describeEvents"}
   [credentials10895 & args10896]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10897
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10895)]
    (clojure.core/case
     (clojure.core/count args10896)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10897
       describeEvents))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10897
       describeEvents
       (elasticbeanstalk/describe-events-request
        (clojure.core/nth args10896 0))))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-configuration-settings
   [m10898]
   (clojure.core/let
    [credentials10899 (:credentials m10898) args10900 (:args m10898)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10901
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10899)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10901
       describeConfigurationSettings
       (elasticbeanstalk/describe-configuration-settings-request
        (clojure.core/nth args10900 0)))))))
  (clojure.core/defn
   describe-configuration-settings-map
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for describeConfigurationSettings"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-configuration-settings,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   describe-configuration-settings
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call describeConfigurationSettings"}
   [credentials10903 & args10904]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10905
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10903)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10905
      describeConfigurationSettings
      (elasticbeanstalk/describe-configuration-settings-request
       (clojure.core/nth args10904 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :terminate-environment
   [m10906]
   (clojure.core/let
    [credentials10907 (:credentials m10906) args10908 (:args m10906)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10909
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10907)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10909
       terminateEnvironment
       (elasticbeanstalk/terminate-environment-request
        (clojure.core/nth args10908 0)))))))
  (clojure.core/defn
   terminate-environment-map
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         terminate-resources
                         custom-query-parameters
                         force-terminate
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for terminateEnvironment"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :terminate-environment,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   terminate-environment
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         terminate-resources
                         custom-query-parameters
                         force-terminate
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call terminateEnvironment"}
   [credentials10911 & args10912]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10913
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10911)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10913
      terminateEnvironment
      (elasticbeanstalk/terminate-environment-request
       (clojure.core/nth args10912 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-configuration-options
   [m10914]
   (clojure.core/let
    [credentials10915 (:credentials m10914) args10916 (:args m10914)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10917
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10915)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10917
       describeConfigurationOptions
       (elasticbeanstalk/describe-configuration-options-request
        (clojure.core/nth args10916 0)))))))
  (clojure.core/defn
   describe-configuration-options-map
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         solution-stack-name
                         general-progress-listener
                         options
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for describeConfigurationOptions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-configuration-options,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   describe-configuration-options
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         solution-stack-name
                         general-progress-listener
                         options
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call describeConfigurationOptions"}
   [credentials10919 & args10920]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10921
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10919)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10921
      describeConfigurationOptions
      (elasticbeanstalk/describe-configuration-options-request
       (clojure.core/nth args10920 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :create-configuration-template
   [m10922]
   (clojure.core/let
    [credentials10923 (:credentials m10922) args10924 (:args m10922)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10925
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10923)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10925
       createConfigurationTemplate
       (elasticbeanstalk/create-configuration-template-request
        (clojure.core/nth args10924 0)))))))
  (clojure.core/defn
   create-configuration-template-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         template-name
                         environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         source-configuration
                         solution-stack-name
                         general-progress-listener
                         option-settings
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createConfigurationTemplate"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-configuration-template,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   create-configuration-template
   {:arglists (quote
               [[credentials
                 {:keys [description
                         template-name
                         environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         source-configuration
                         solution-stack-name
                         general-progress-listener
                         option-settings
                         clone-source
                         clone-root]}]]),
    :doc "Call createConfigurationTemplate"}
   [credentials10927 & args10928]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10929
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10927)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10929
      createConfigurationTemplate
      (elasticbeanstalk/create-configuration-template-request
       (clojure.core/nth args10928 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :update-environment
   [m10930]
   (clojure.core/let
    [credentials10931 (:credentials m10930) args10932 (:args m10930)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10933
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10931)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10933
       updateEnvironment
       (elasticbeanstalk/update-environment-request
        (clojure.core/nth args10932 0)))))))
  (clojure.core/defn
   update-environment-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         template-name
                         tier
                         environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         options-to-remove
                         custom-query-parameters
                         version-label
                         group-name
                         read-limit
                         solution-stack-name
                         general-progress-listener
                         option-settings
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for updateEnvironment"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-environment,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   update-environment
   {:arglists (quote
               [[credentials
                 {:keys [description
                         template-name
                         tier
                         environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         options-to-remove
                         custom-query-parameters
                         version-label
                         group-name
                         read-limit
                         solution-stack-name
                         general-progress-listener
                         option-settings
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call updateEnvironment"}
   [credentials10935 & args10936]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10937
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10935)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10937
      updateEnvironment
      (elasticbeanstalk/update-environment-request
       (clojure.core/nth args10936 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-applications
   [m10938]
   (clojure.core/let
    [credentials10939 (:credentials m10938) args10940 (:args m10938)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10941
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10939)]
     (clojure.core/case
      (clojure.core/count args10940)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10941
        describeApplications))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10941
        describeApplications
        (elasticbeanstalk/describe-applications-request
         (clojure.core/nth args10940 0))))))))
  (clojure.core/defn
   describe-applications-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         application-names]}]]),
    :doc "Generate map for describeApplications, describeApplications"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-applications,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-applications,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   describe-applications
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         application-names]}]]),
    :doc "Call describeApplications, describeApplications"}
   [credentials10943 & args10944]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10945
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10943)]
    (clojure.core/case
     (clojure.core/count args10944)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10945
       describeApplications))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10945
       describeApplications
       (elasticbeanstalk/describe-applications-request
        (clojure.core/nth args10944 0))))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :create-storage-location
   [m10946]
   (clojure.core/let
    [credentials10947 (:credentials m10946) args10948 (:args m10946)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10949
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10947)]
     (clojure.core/case
      (clojure.core/count args10948)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10949
        createStorageLocation
        (elasticbeanstalk/create-storage-location-request
         (clojure.core/nth args10948 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10949
        createStorageLocation))))))
  (clojure.core/defn
   create-storage-location-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for createStorageLocation, createStorageLocation"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :create-storage-location,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-storage-location,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   create-storage-location
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call createStorageLocation, createStorageLocation"}
   [credentials10951 & args10952]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10953
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10951)]
    (clojure.core/case
     (clojure.core/count args10952)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10953
       createStorageLocation
       (elasticbeanstalk/create-storage-location-request
        (clojure.core/nth args10952 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10953
       createStorageLocation))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :restart-app-server
   [m10954]
   (clojure.core/let
    [credentials10955 (:credentials m10954) args10956 (:args m10954)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10957
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10955)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10957
       restartAppServer
       (elasticbeanstalk/restart-app-server-request
        (clojure.core/nth args10956 0)))))))
  (clojure.core/defn
   restart-app-server-map
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for restartAppServer"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :restart-app-server,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   restart-app-server
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call restartAppServer"}
   [credentials10959 & args10960]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10961
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10959)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10961
      restartAppServer
      (elasticbeanstalk/restart-app-server-request
       (clojure.core/nth args10960 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :delete-application
   [m10962]
   (clojure.core/let
    [credentials10963 (:credentials m10962) args10964 (:args m10962)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10965
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10963)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10965
       deleteApplication
       (elasticbeanstalk/delete-application-request
        (clojure.core/nth args10964 0)))))))
  (clojure.core/defn
   delete-application-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         terminate-env-by-force
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteApplication"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-application,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   delete-application
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         terminate-env-by-force
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteApplication"}
   [credentials10967 & args10968]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10969
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10967)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10969
      deleteApplication
      (elasticbeanstalk/delete-application-request
       (clojure.core/nth args10968 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :create-application
   [m10970]
   (clojure.core/let
    [credentials10971 (:credentials m10970) args10972 (:args m10970)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10973
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10971)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10973
       createApplication
       (elasticbeanstalk/create-application-request
        (clojure.core/nth args10972 0)))))))
  (clojure.core/defn
   create-application-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createApplication"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-application,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   create-application
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createApplication"}
   [credentials10975 & args10976]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10977
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10975)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10977
      createApplication
      (elasticbeanstalk/create-application-request
       (clojure.core/nth args10976 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :delete-configuration-template
   [m10978]
   (clojure.core/let
    [credentials10979 (:credentials m10978) args10980 (:args m10978)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10981
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10979)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10981
       deleteConfigurationTemplate
       (elasticbeanstalk/delete-configuration-template-request
        (clojure.core/nth args10980 0)))))))
  (clojure.core/defn
   delete-configuration-template-map
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteConfigurationTemplate"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-configuration-template,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   delete-configuration-template
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteConfigurationTemplate"}
   [credentials10983 & args10984]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10985
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10983)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10985
      deleteConfigurationTemplate
      (elasticbeanstalk/delete-configuration-template-request
       (clojure.core/nth args10984 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :swap-environment-cnames
   [m10986]
   (clojure.core/let
    [credentials10987 (:credentials m10986) args10988 (:args m10986)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10989
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10987)]
     (clojure.core/case
      (clojure.core/count args10988)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10989
        swapEnvironmentCNAMEs))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10989
        swapEnvironmentCNAMEs
        (elasticbeanstalk/swap-environment-cnames-request
         (clojure.core/nth args10988 0))))))))
  (clojure.core/defn
   swap-environment-cnames-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [source-environment-id
                         source-environment-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         destination-environment-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         destination-environment-id]}]]),
    :doc "Generate map for swapEnvironmentCNAMEs, swapEnvironmentCNAMEs"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :swap-environment-cnames,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :swap-environment-cnames,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   swap-environment-cnames
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [source-environment-id
                         source-environment-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         destination-environment-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         destination-environment-id]}]]),
    :doc "Call swapEnvironmentCNAMEs, swapEnvironmentCNAMEs"}
   [credentials10991 & args10992]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10993
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10991)]
    (clojure.core/case
     (clojure.core/count args10992)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10993
       swapEnvironmentCNAMEs))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10993
       swapEnvironmentCNAMEs
       (elasticbeanstalk/swap-environment-cnames-request
        (clojure.core/nth args10992 0))))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-environment-health
   [m10994]
   (clojure.core/let
    [credentials10995 (:credentials m10994) args10996 (:args m10994)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10997
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10995)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10997
       describeEnvironmentHealth
       (elasticbeanstalk/describe-environment-health-request
        (clojure.core/nth args10996 0)))))))
  (clojure.core/defn
   describe-environment-health-map
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         attribute-names
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for describeEnvironmentHealth"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-environment-health,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   describe-environment-health
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         attribute-names
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call describeEnvironmentHealth"}
   [credentials10999 & args11000]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client11001
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10999)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11001
      describeEnvironmentHealth
      (elasticbeanstalk/describe-environment-health-request
       (clojure.core/nth args11000 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :abort-environment-update
   [m11002]
   (clojure.core/let
    [credentials11003 (:credentials m11002) args11004 (:args m11002)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client11005
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials11003)]
     (clojure.core/case
      (clojure.core/count args11004)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11005
        abortEnvironmentUpdate))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11005
        abortEnvironmentUpdate
        (elasticbeanstalk/abort-environment-update-request
         (clojure.core/nth args11004 0))))))))
  (clojure.core/defn
   abort-environment-update-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for abortEnvironmentUpdate, abortEnvironmentUpdate"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :abort-environment-update,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :abort-environment-update,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   abort-environment-update
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call abortEnvironmentUpdate, abortEnvironmentUpdate"}
   [credentials11007 & args11008]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client11009
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials11007)]
    (clojure.core/case
     (clojure.core/count args11008)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11009
       abortEnvironmentUpdate))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11009
       abortEnvironmentUpdate
       (elasticbeanstalk/abort-environment-update-request
        (clojure.core/nth args11008 0))))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :check-dnsavailability
   [m11010]
   (clojure.core/let
    [credentials11011 (:credentials m11010) args11012 (:args m11010)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client11013
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials11011)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11013
       checkDNSAvailability
       (elasticbeanstalk/check-dnsavailability-request
        (clojure.core/nth args11012 0)))))))
  (clojure.core/defn
   check-dnsavailability-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cnameprefix
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for checkDNSAvailability"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :check-dnsavailability,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   check-dnsavailability
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cnameprefix
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call checkDNSAvailability"}
   [credentials11015 & args11016]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client11017
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials11015)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11017
      checkDNSAvailability
      (elasticbeanstalk/check-dnsavailability-request
       (clojure.core/nth args11016 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :retrieve-environment-info
   [m11018]
   (clojure.core/let
    [credentials11019 (:credentials m11018) args11020 (:args m11018)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client11021
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials11019)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11021
       retrieveEnvironmentInfo
       (elasticbeanstalk/retrieve-environment-info-request
        (clojure.core/nth args11020 0)))))))
  (clojure.core/defn
   retrieve-environment-info-map
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         info-type
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for retrieveEnvironmentInfo"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :retrieve-environment-info,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   retrieve-environment-info
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         info-type
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call retrieveEnvironmentInfo"}
   [credentials11023 & args11024]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client11025
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials11023)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11025
      retrieveEnvironmentInfo
      (elasticbeanstalk/retrieve-environment-info-request
       (clojure.core/nth args11024 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :create-application-version
   [m11026]
   (clojure.core/let
    [credentials11027 (:credentials m11026) args11028 (:args m11026)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client11029
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials11027)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11029
       createApplicationVersion
       (elasticbeanstalk/create-application-version-request
        (clojure.core/nth args11028 0)))))))
  (clojure.core/defn
   create-application-version-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         process
                         custom-query-parameters
                         source-bundle
                         version-label
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-create-application]}]]),
    :doc "Generate map for createApplicationVersion"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-application-version,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   create-application-version
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         process
                         custom-query-parameters
                         source-bundle
                         version-label
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-create-application]}]]),
    :doc "Call createApplicationVersion"}
   [credentials11031 & args11032]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client11033
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials11031)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11033
      createApplicationVersion
      (elasticbeanstalk/create-application-version-request
       (clojure.core/nth args11032 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-environments
   [m11034]
   (clojure.core/let
    [credentials11035 (:credentials m11034) args11036 (:args m11034)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client11037
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials11035)]
     (clojure.core/case
      (clojure.core/count args11036)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11037
        describeEnvironments))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11037
        describeEnvironments
        (elasticbeanstalk/describe-environments-request
         (clojure.core/nth args11036 0))))))))
  (clojure.core/defn
   describe-environments-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         include-deleted
                         application-name
                         environment-ids
                         sdk-request-timeout
                         included-deleted-back-to
                         custom-query-parameters
                         version-label
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         environment-names]}]]),
    :doc "Generate map for describeEnvironments, describeEnvironments"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-environments,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-environments,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   describe-environments
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         include-deleted
                         application-name
                         environment-ids
                         sdk-request-timeout
                         included-deleted-back-to
                         custom-query-parameters
                         version-label
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         environment-names]}]]),
    :doc "Call describeEnvironments, describeEnvironments"}
   [credentials11039 & args11040]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client11041
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials11039)]
    (clojure.core/case
     (clojure.core/count args11040)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11041
       describeEnvironments))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11041
       describeEnvironments
       (elasticbeanstalk/describe-environments-request
        (clojure.core/nth args11040 0))))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :update-configuration-template
   [m11042]
   (clojure.core/let
    [credentials11043 (:credentials m11042) args11044 (:args m11042)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client11045
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials11043)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11045
       updateConfigurationTemplate
       (elasticbeanstalk/update-configuration-template-request
        (clojure.core/nth args11044 0)))))))
  (clojure.core/defn
   update-configuration-template-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         template-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         options-to-remove
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         option-settings
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateConfigurationTemplate"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-configuration-template,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   update-configuration-template
   {:arglists (quote
               [[credentials
                 {:keys [description
                         template-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         options-to-remove
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         option-settings
                         clone-source
                         clone-root]}]]),
    :doc "Call updateConfigurationTemplate"}
   [credentials11047 & args11048]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client11049
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials11047)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11049
      updateConfigurationTemplate
      (elasticbeanstalk/update-configuration-template-request
       (clojure.core/nth args11048 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-environment-resources
   [m11050]
   (clojure.core/let
    [credentials11051 (:credentials m11050) args11052 (:args m11050)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client11053
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials11051)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11053
       describeEnvironmentResources
       (elasticbeanstalk/describe-environment-resources-request
        (clojure.core/nth args11052 0)))))))
  (clojure.core/defn
   describe-environment-resources-map
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for describeEnvironmentResources"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-environment-resources,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   describe-environment-resources
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call describeEnvironmentResources"}
   [credentials11055 & args11056]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client11057
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials11055)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11057
      describeEnvironmentResources
      (elasticbeanstalk/describe-environment-resources-request
       (clojure.core/nth args11056 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :list-available-solution-stacks
   [m11058]
   (clojure.core/let
    [credentials11059 (:credentials m11058) args11060 (:args m11058)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client11061
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials11059)]
     (clojure.core/case
      (clojure.core/count args11060)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11061
        listAvailableSolutionStacks))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11061
        listAvailableSolutionStacks
        (elasticbeanstalk/list-available-solution-stacks-request
         (clojure.core/nth args11060 0))))))))
  (clojure.core/defn
   list-available-solution-stacks-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listAvailableSolutionStacks, listAvailableSolutionStacks"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-available-solution-stacks,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-available-solution-stacks,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   list-available-solution-stacks
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listAvailableSolutionStacks, listAvailableSolutionStacks"}
   [credentials11063 & args11064]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client11065
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials11063)]
    (clojure.core/case
     (clojure.core/count args11064)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11065
       listAvailableSolutionStacks))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11065
       listAvailableSolutionStacks
       (elasticbeanstalk/list-available-solution-stacks-request
        (clojure.core/nth args11064 0))))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :validate-configuration-settings
   [m11066]
   (clojure.core/let
    [credentials11067 (:credentials m11066) args11068 (:args m11066)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client11069
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials11067)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11069
       validateConfigurationSettings
       (elasticbeanstalk/validate-configuration-settings-request
        (clojure.core/nth args11068 0)))))))
  (clojure.core/defn
   validate-configuration-settings-map
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         option-settings
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for validateConfigurationSettings"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :validate-configuration-settings,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   validate-configuration-settings
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         option-settings
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call validateConfigurationSettings"}
   [credentials11071 & args11072]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client11073
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials11071)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11073
      validateConfigurationSettings
      (elasticbeanstalk/validate-configuration-settings-request
       (clojure.core/nth args11072 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-instances-health
   [m11074]
   (clojure.core/let
    [credentials11075 (:credentials m11074) args11076 (:args m11074)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client11077
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials11075)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11077
       describeInstancesHealth
       (elasticbeanstalk/describe-instances-health-request
        (clojure.core/nth args11076 0)))))))
  (clojure.core/defn
   describe-instances-health-map
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         attribute-names
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeInstancesHealth"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-instances-health,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   describe-instances-health
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         attribute-names
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root
                         next-token]}]]),
    :doc "Call describeInstancesHealth"}
   [credentials11079 & args11080]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client11081
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials11079)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11081
      describeInstancesHealth
      (elasticbeanstalk/describe-instances-health-request
       (clojure.core/nth args11080 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :update-application
   [m11082]
   (clojure.core/let
    [credentials11083 (:credentials m11082) args11084 (:args m11082)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client11085
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials11083)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11085
       updateApplication
       (elasticbeanstalk/update-application-request
        (clojure.core/nth args11084 0)))))))
  (clojure.core/defn
   update-application-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateApplication"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-application,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   update-application
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateApplication"}
   [credentials11087 & args11088]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client11089
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials11087)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11089
      updateApplication
      (elasticbeanstalk/update-application-request
       (clojure.core/nth args11088 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :request-environment-info
   [m11090]
   (clojure.core/let
    [credentials11091 (:credentials m11090) args11092 (:args m11090)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client11093
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials11091)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11093
       requestEnvironmentInfo
       (elasticbeanstalk/request-environment-info-request
        (clojure.core/nth args11092 0)))))))
  (clojure.core/defn
   request-environment-info-map
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         info-type
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for requestEnvironmentInfo"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :request-environment-info,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   request-environment-info
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         info-type
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call requestEnvironmentInfo"}
   [credentials11095 & args11096]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client11097
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials11095)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11097
      requestEnvironmentInfo
      (elasticbeanstalk/request-environment-info-request
       (clojure.core/nth args11096 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :create-environment
   [m11098]
   (clojure.core/let
    [credentials11099 (:credentials m11098) args11100 (:args m11098)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client11101
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials11099)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11101
       createEnvironment
       (elasticbeanstalk/create-environment-request
        (clojure.core/nth args11100 0)))))))
  (clojure.core/defn
   create-environment-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         template-name
                         tier
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         options-to-remove
                         cnameprefix
                         custom-query-parameters
                         version-label
                         group-name
                         read-limit
                         solution-stack-name
                         general-progress-listener
                         option-settings
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for createEnvironment"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-environment,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   create-environment
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         template-name
                         tier
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         options-to-remove
                         cnameprefix
                         custom-query-parameters
                         version-label
                         group-name
                         read-limit
                         solution-stack-name
                         general-progress-listener
                         option-settings
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call createEnvironment"}
   [credentials11103 & args11104]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client11105
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials11103)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11105
      createEnvironment
      (elasticbeanstalk/create-environment-request
       (clojure.core/nth args11104 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :delete-application-version
   [m11106]
   (clojure.core/let
    [credentials11107 (:credentials m11106) args11108 (:args m11106)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client11109
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials11107)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11109
       deleteApplicationVersion
       (elasticbeanstalk/delete-application-version-request
        (clojure.core/nth args11108 0)))))))
  (clojure.core/defn
   delete-application-version-map
   {:arglists (quote
               [[credentials
                 {:keys [delete-source-bundle
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         version-label
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteApplicationVersion"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-application-version,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   delete-application-version
   {:arglists (quote
               [[credentials
                 {:keys [delete-source-bundle
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         version-label
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteApplicationVersion"}
   [credentials11111 & args11112]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client11113
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials11111)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11113
      deleteApplicationVersion
      (elasticbeanstalk/delete-application-version-request
       (clojure.core/nth args11112 0))))))))
