(ns
 com.palletops.awaze.elasticache
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.elasticache :as elasticache]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :elasticache
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.elasticache.AmazonElastiCacheClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.ParameterNameValue}
parameter-name-value
  [m14324]
  (clojure.core/let
   [bean14323
    (new com.amazonaws.services.elasticache.model.ParameterNameValue)]
   (clojure.core/let
    [v14325
     (:parameter-name
      m14324
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14325 :com.palletops.awaze.client-builder/undef)
     (. bean14323 setParameterName (clojure.core/str v14325))))
   (clojure.core/let
    [v14325
     (:parameter-value
      m14324
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14325 :com.palletops.awaze.client-builder/undef)
     (. bean14323 setParameterValue (clojure.core/str v14325))))
   bean14323))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.AZMode}
azmode
  [m14327]
  (.
   com.amazonaws.services.elasticache.model.AZMode
   fromValue
   (clojure.core/name m14327)))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.Tag}
tag
  [m14330]
  (clojure.core/let
   [bean14329 (new com.amazonaws.services.elasticache.model.Tag)]
   (clojure.core/let
    [v14331 (:key m14330 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14331 :com.palletops.awaze.client-builder/undef)
     (. bean14329 setKey (clojure.core/str v14331))))
   (clojure.core/let
    [v14331 (:value m14330 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14331 :com.palletops.awaze.client-builder/undef)
     (. bean14329 setValue (clojure.core/str v14331))))
   bean14329))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.SourceType}
source-type
  [m14333]
  (.
   com.amazonaws.services.elasticache.model.SourceType
   fromValue
   (clojure.core/name m14333)))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.ModifyCacheParameterGroupRequest}
modify-cache-parameter-group-request
  [m14336]
  (clojure.core/let
   [bean14335
    (new
     com.amazonaws.services.elasticache.model.ModifyCacheParameterGroupRequest)]
   (clojure.core/let
    [v14337
     (:cache-parameter-group-name
      m14336
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14337 :com.palletops.awaze.client-builder/undef)
     (.
      bean14335
      setCacheParameterGroupName
      (clojure.core/str v14337))))
   (clojure.core/let
    [v14337
     (:parameter-name-values
      m14336
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14337 :com.palletops.awaze.client-builder/undef)
     (.
      bean14335
      setParameterNameValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg14449]
  (elasticache/parameter-name-value arg14449))
 v14337))))
   bean14335))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeReplicationGroupsRequest}
describe-replication-groups-request
  [m14339]
  (clojure.core/let
   [bean14338
    (new
     com.amazonaws.services.elasticache.model.DescribeReplicationGroupsRequest)]
   (clojure.core/let
    [v14340
     (:replication-group-id
      m14339
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14340 :com.palletops.awaze.client-builder/undef)
     (. bean14338 setReplicationGroupId (clojure.core/str v14340))))
   (clojure.core/let
    [v14340
     (:marker m14339 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14340 :com.palletops.awaze.client-builder/undef)
     (. bean14338 setMarker (clojure.core/str v14340))))
   (clojure.core/let
    [v14340
     (:max-records m14339 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14340 :com.palletops.awaze.client-builder/undef)
     (. bean14338 setMaxRecords (clojure.core/int v14340))))
   bean14338))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.CreateCacheClusterRequest}
create-cache-cluster-request
  [m14342]
  (clojure.core/let
   [bean14341
    (new
     com.amazonaws.services.elasticache.model.CreateCacheClusterRequest)]
   (clojure.core/let
    [v14343
     (:engine m14342 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14343 :com.palletops.awaze.client-builder/undef)
     (. bean14341 setEngine (clojure.core/str v14343))))
   (clojure.core/let
    [v14343
     (:preferred-availability-zones
      m14342
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14343 :com.palletops.awaze.client-builder/undef)
     (.
      bean14341
      setPreferredAvailabilityZones
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14450] (clojure.core/str arg14450))
 v14343))))
   (clojure.core/let
    [v14343
     (:cache-subnet-group-name
      m14342
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14343 :com.palletops.awaze.client-builder/undef)
     (. bean14341 setCacheSubnetGroupName (clojure.core/str v14343))))
   (clojure.core/let
    [v14343
     (:replication-group-id
      m14342
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14343 :com.palletops.awaze.client-builder/undef)
     (. bean14341 setReplicationGroupId (clojure.core/str v14343))))
   (clojure.core/let
    [v14343
     (:security-group-ids
      m14342
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14343 :com.palletops.awaze.client-builder/undef)
     (.
      bean14341
      setSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14451] (clojure.core/str arg14451))
 v14343))))
   (clojure.core/let
    [v14343
     (:snapshot-retention-limit
      m14342
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14343 :com.palletops.awaze.client-builder/undef)
     (. bean14341 setSnapshotRetentionLimit (clojure.core/int v14343))))
   (clojure.core/let
    [v14343
     (:preferred-maintenance-window
      m14342
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14343 :com.palletops.awaze.client-builder/undef)
     (.
      bean14341
      setPreferredMaintenanceWindow
      (clojure.core/str v14343))))
   (clojure.core/let
    [v14343
     (:azmode m14342 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14343 :com.palletops.awaze.client-builder/undef)
     (. bean14341 setAZMode (elasticache/azmode v14343))))
   (clojure.core/let
    [v14343
     (:notification-topic-arn
      m14342
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14343 :com.palletops.awaze.client-builder/undef)
     (. bean14341 setNotificationTopicArn (clojure.core/str v14343))))
   (clojure.core/let
    [v14343
     (:cache-security-group-names
      m14342
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14343 :com.palletops.awaze.client-builder/undef)
     (.
      bean14341
      setCacheSecurityGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14452] (clojure.core/str arg14452))
 v14343))))
   (clojure.core/let
    [v14343
     (:snapshot-name m14342 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14343 :com.palletops.awaze.client-builder/undef)
     (. bean14341 setSnapshotName (clojure.core/str v14343))))
   (clojure.core/let
    [v14343
     (:preferred-availability-zone
      m14342
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14343 :com.palletops.awaze.client-builder/undef)
     (.
      bean14341
      setPreferredAvailabilityZone
      (clojure.core/str v14343))))
   (clojure.core/let
    [v14343
     (:snapshot-arns m14342 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14343 :com.palletops.awaze.client-builder/undef)
     (.
      bean14341
      setSnapshotArns
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14453] (clojure.core/str arg14453))
 v14343))))
   (clojure.core/let
    [v14343 (:port m14342 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14343 :com.palletops.awaze.client-builder/undef)
     (. bean14341 setPort (clojure.core/int v14343))))
   (clojure.core/let
    [v14343 (:tags m14342 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14343 :com.palletops.awaze.client-builder/undef)
     (.
      bean14341
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14454] (elasticache/tag arg14454))
 v14343))))
   (clojure.core/let
    [v14343
     (:cache-parameter-group-name
      m14342
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14343 :com.palletops.awaze.client-builder/undef)
     (.
      bean14341
      setCacheParameterGroupName
      (clojure.core/str v14343))))
   (clojure.core/let
    [v14343
     (:cache-cluster-id
      m14342
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14343 :com.palletops.awaze.client-builder/undef)
     (. bean14341 setCacheClusterId (clojure.core/str v14343))))
   (clojure.core/let
    [v14343
     (:num-cache-nodes
      m14342
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14343 :com.palletops.awaze.client-builder/undef)
     (. bean14341 setNumCacheNodes (clojure.core/int v14343))))
   (clojure.core/let
    [v14343
     (:auto-minor-version-upgrade
      m14342
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14343 :com.palletops.awaze.client-builder/undef)
     (.
      bean14341
      setAutoMinorVersionUpgrade
      (clojure.core/boolean v14343))))
   (clojure.core/let
    [v14343
     (:snapshot-window
      m14342
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14343 :com.palletops.awaze.client-builder/undef)
     (. bean14341 setSnapshotWindow (clojure.core/str v14343))))
   (clojure.core/let
    [v14343
     (:engine-version
      m14342
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14343 :com.palletops.awaze.client-builder/undef)
     (. bean14341 setEngineVersion (clojure.core/str v14343))))
   (clojure.core/let
    [v14343
     (:cache-node-type
      m14342
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14343 :com.palletops.awaze.client-builder/undef)
     (. bean14341 setCacheNodeType (clojure.core/str v14343))))
   bean14341))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeCacheParameterGroupsRequest}
describe-cache-parameter-groups-request
  [m14345]
  (clojure.core/let
   [bean14344
    (new
     com.amazonaws.services.elasticache.model.DescribeCacheParameterGroupsRequest)]
   (clojure.core/let
    [v14346
     (:cache-parameter-group-name
      m14345
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14346 :com.palletops.awaze.client-builder/undef)
     (.
      bean14344
      setCacheParameterGroupName
      (clojure.core/str v14346))))
   (clojure.core/let
    [v14346
     (:marker m14345 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14346 :com.palletops.awaze.client-builder/undef)
     (. bean14344 setMarker (clojure.core/str v14346))))
   (clojure.core/let
    [v14346
     (:max-records m14345 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14346 :com.palletops.awaze.client-builder/undef)
     (. bean14344 setMaxRecords (clojure.core/int v14346))))
   bean14344))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DeleteCacheParameterGroupRequest}
delete-cache-parameter-group-request
  [m14348]
  (clojure.core/let
   [bean14347
    (new
     com.amazonaws.services.elasticache.model.DeleteCacheParameterGroupRequest)]
   (clojure.core/let
    [v14349
     (:cache-parameter-group-name
      m14348
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14349 :com.palletops.awaze.client-builder/undef)
     (.
      bean14347
      setCacheParameterGroupName
      (clojure.core/str v14349))))
   bean14347))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.CreateCacheSecurityGroupRequest}
create-cache-security-group-request
  [m14351]
  (clojure.core/let
   [bean14350
    (new
     com.amazonaws.services.elasticache.model.CreateCacheSecurityGroupRequest)]
   (clojure.core/let
    [v14352
     (:cache-security-group-name
      m14351
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14352 :com.palletops.awaze.client-builder/undef)
     (. bean14350 setCacheSecurityGroupName (clojure.core/str v14352))))
   (clojure.core/let
    [v14352
     (:description m14351 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14352 :com.palletops.awaze.client-builder/undef)
     (. bean14350 setDescription (clojure.core/str v14352))))
   bean14350))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.AddTagsToResourceRequest}
add-tags-to-resource-request
  [m14354]
  (clojure.core/let
   [bean14353
    (new
     com.amazonaws.services.elasticache.model.AddTagsToResourceRequest)]
   (clojure.core/let
    [v14355
     (:resource-name m14354 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14355 :com.palletops.awaze.client-builder/undef)
     (. bean14353 setResourceName (clojure.core/str v14355))))
   (clojure.core/let
    [v14355 (:tags m14354 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14355 :com.palletops.awaze.client-builder/undef)
     (.
      bean14353
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14455] (elasticache/tag arg14455))
 v14355))))
   bean14353))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeEventsRequest}
describe-events-request
  [m14357]
  (clojure.core/let
   [bean14356
    (new
     com.amazonaws.services.elasticache.model.DescribeEventsRequest)]
   (clojure.core/let
    [v14358
     (:source-identifier
      m14357
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14358 :com.palletops.awaze.client-builder/undef)
     (. bean14356 setSourceIdentifier (clojure.core/str v14358))))
   (clojure.core/let
    [v14358
     (:source-type m14357 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14358 :com.palletops.awaze.client-builder/undef)
     (. bean14356 setSourceType (elasticache/source-type v14358))))
   (clojure.core/let
    [v14358
     (:duration m14357 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14358 :com.palletops.awaze.client-builder/undef)
     (. bean14356 setDuration (clojure.core/int v14358))))
   (clojure.core/let
    [v14358
     (:start-time m14357 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14358 :com.palletops.awaze.client-builder/undef)
     (.
      bean14356
      setStartTime
      (com.palletops.awaze.common/to-date v14358))))
   (clojure.core/let
    [v14358
     (:end-time m14357 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14358 :com.palletops.awaze.client-builder/undef)
     (.
      bean14356
      setEndTime
      (com.palletops.awaze.common/to-date v14358))))
   (clojure.core/let
    [v14358
     (:marker m14357 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14358 :com.palletops.awaze.client-builder/undef)
     (. bean14356 setMarker (clojure.core/str v14358))))
   (clojure.core/let
    [v14358
     (:max-records m14357 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14358 :com.palletops.awaze.client-builder/undef)
     (. bean14356 setMaxRecords (clojure.core/int v14358))))
   bean14356))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.ModifyCacheSubnetGroupRequest}
modify-cache-subnet-group-request
  [m14360]
  (clojure.core/let
   [bean14359
    (new
     com.amazonaws.services.elasticache.model.ModifyCacheSubnetGroupRequest)]
   (clojure.core/let
    [v14361
     (:cache-subnet-group-name
      m14360
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14361 :com.palletops.awaze.client-builder/undef)
     (. bean14359 setCacheSubnetGroupName (clojure.core/str v14361))))
   (clojure.core/let
    [v14361
     (:cache-subnet-group-description
      m14360
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14361 :com.palletops.awaze.client-builder/undef)
     (.
      bean14359
      setCacheSubnetGroupDescription
      (clojure.core/str v14361))))
   (clojure.core/let
    [v14361
     (:subnet-ids m14360 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14361 :com.palletops.awaze.client-builder/undef)
     (.
      bean14359
      setSubnetIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14456] (clojure.core/str arg14456))
 v14361))))
   bean14359))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.RevokeCacheSecurityGroupIngressRequest}
revoke-cache-security-group-ingress-request
  [m14363]
  (clojure.core/let
   [bean14362
    (new
     com.amazonaws.services.elasticache.model.RevokeCacheSecurityGroupIngressRequest)]
   (clojure.core/let
    [v14364
     (:cache-security-group-name
      m14363
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14364 :com.palletops.awaze.client-builder/undef)
     (. bean14362 setCacheSecurityGroupName (clojure.core/str v14364))))
   (clojure.core/let
    [v14364
     (:ec2security-group-name
      m14363
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14364 :com.palletops.awaze.client-builder/undef)
     (. bean14362 setEC2SecurityGroupName (clojure.core/str v14364))))
   (clojure.core/let
    [v14364
     (:ec2security-group-owner-id
      m14363
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14364 :com.palletops.awaze.client-builder/undef)
     (.
      bean14362
      setEC2SecurityGroupOwnerId
      (clojure.core/str v14364))))
   bean14362))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeReservedCacheNodesRequest}
describe-reserved-cache-nodes-request
  [m14366]
  (clojure.core/let
   [bean14365
    (new
     com.amazonaws.services.elasticache.model.DescribeReservedCacheNodesRequest)]
   (clojure.core/let
    [v14367
     (:reserved-cache-node-id
      m14366
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14367 :com.palletops.awaze.client-builder/undef)
     (. bean14365 setReservedCacheNodeId (clojure.core/str v14367))))
   (clojure.core/let
    [v14367
     (:reserved-cache-nodes-offering-id
      m14366
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14367 :com.palletops.awaze.client-builder/undef)
     (.
      bean14365
      setReservedCacheNodesOfferingId
      (clojure.core/str v14367))))
   (clojure.core/let
    [v14367
     (:cache-node-type
      m14366
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14367 :com.palletops.awaze.client-builder/undef)
     (. bean14365 setCacheNodeType (clojure.core/str v14367))))
   (clojure.core/let
    [v14367
     (:duration m14366 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14367 :com.palletops.awaze.client-builder/undef)
     (. bean14365 setDuration (clojure.core/str v14367))))
   (clojure.core/let
    [v14367
     (:marker m14366 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14367 :com.palletops.awaze.client-builder/undef)
     (. bean14365 setMarker (clojure.core/str v14367))))
   (clojure.core/let
    [v14367
     (:max-records m14366 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14367 :com.palletops.awaze.client-builder/undef)
     (. bean14365 setMaxRecords (clojure.core/int v14367))))
   (clojure.core/let
    [v14367
     (:product-description
      m14366
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14367 :com.palletops.awaze.client-builder/undef)
     (. bean14365 setProductDescription (clojure.core/str v14367))))
   (clojure.core/let
    [v14367
     (:offering-type m14366 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14367 :com.palletops.awaze.client-builder/undef)
     (. bean14365 setOfferingType (clojure.core/str v14367))))
   bean14365))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.RebootCacheClusterRequest}
reboot-cache-cluster-request
  [m14369]
  (clojure.core/let
   [bean14368
    (new
     com.amazonaws.services.elasticache.model.RebootCacheClusterRequest)]
   (clojure.core/let
    [v14370
     (:cache-node-ids-to-reboot
      m14369
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14370 :com.palletops.awaze.client-builder/undef)
     (.
      bean14368
      setCacheNodeIdsToReboot
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14457] (clojure.core/str arg14457))
 v14370))))
   (clojure.core/let
    [v14370
     (:cache-cluster-id
      m14369
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14370 :com.palletops.awaze.client-builder/undef)
     (. bean14368 setCacheClusterId (clojure.core/str v14370))))
   bean14368))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeCacheClustersRequest}
describe-cache-clusters-request
  [m14372]
  (clojure.core/let
   [bean14371
    (new
     com.amazonaws.services.elasticache.model.DescribeCacheClustersRequest)]
   (clojure.core/let
    [v14373
     (:cache-cluster-id
      m14372
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14373 :com.palletops.awaze.client-builder/undef)
     (. bean14371 setCacheClusterId (clojure.core/str v14373))))
   (clojure.core/let
    [v14373
     (:show-cache-node-info
      m14372
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14373 :com.palletops.awaze.client-builder/undef)
     (. bean14371 setShowCacheNodeInfo (clojure.core/boolean v14373))))
   (clojure.core/let
    [v14373
     (:marker m14372 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14373 :com.palletops.awaze.client-builder/undef)
     (. bean14371 setMarker (clojure.core/str v14373))))
   (clojure.core/let
    [v14373
     (:max-records m14372 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14373 :com.palletops.awaze.client-builder/undef)
     (. bean14371 setMaxRecords (clojure.core/int v14373))))
   bean14371))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.CopySnapshotRequest}
copy-snapshot-request
  [m14375]
  (clojure.core/let
   [bean14374
    (new com.amazonaws.services.elasticache.model.CopySnapshotRequest)]
   (clojure.core/let
    [v14376
     (:source-snapshot-name
      m14375
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14376 :com.palletops.awaze.client-builder/undef)
     (. bean14374 setSourceSnapshotName (clojure.core/str v14376))))
   (clojure.core/let
    [v14376
     (:target-snapshot-name
      m14375
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14376 :com.palletops.awaze.client-builder/undef)
     (. bean14374 setTargetSnapshotName (clojure.core/str v14376))))
   bean14374))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DeleteSnapshotRequest}
delete-snapshot-request
  [m14378]
  (clojure.core/let
   [bean14377
    (new
     com.amazonaws.services.elasticache.model.DeleteSnapshotRequest)]
   (clojure.core/let
    [v14379
     (:snapshot-name m14378 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14379 :com.palletops.awaze.client-builder/undef)
     (. bean14377 setSnapshotName (clojure.core/str v14379))))
   bean14377))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeCacheEngineVersionsRequest}
describe-cache-engine-versions-request
  [m14381]
  (clojure.core/let
   [bean14380
    (new
     com.amazonaws.services.elasticache.model.DescribeCacheEngineVersionsRequest)]
   (clojure.core/let
    [v14382
     (:cache-parameter-group-family
      m14381
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14382 :com.palletops.awaze.client-builder/undef)
     (.
      bean14380
      setCacheParameterGroupFamily
      (clojure.core/str v14382))))
   (clojure.core/let
    [v14382
     (:engine m14381 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14382 :com.palletops.awaze.client-builder/undef)
     (. bean14380 setEngine (clojure.core/str v14382))))
   (clojure.core/let
    [v14382
     (:engine-version
      m14381
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14382 :com.palletops.awaze.client-builder/undef)
     (. bean14380 setEngineVersion (clojure.core/str v14382))))
   (clojure.core/let
    [v14382
     (:default-only m14381 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14382 :com.palletops.awaze.client-builder/undef)
     (. bean14380 setDefaultOnly (clojure.core/boolean v14382))))
   (clojure.core/let
    [v14382
     (:marker m14381 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14382 :com.palletops.awaze.client-builder/undef)
     (. bean14380 setMarker (clojure.core/str v14382))))
   (clojure.core/let
    [v14382
     (:max-records m14381 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14382 :com.palletops.awaze.client-builder/undef)
     (. bean14380 setMaxRecords (clojure.core/int v14382))))
   bean14380))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeEngineDefaultParametersRequest}
describe-engine-default-parameters-request
  [m14384]
  (clojure.core/let
   [bean14383
    (new
     com.amazonaws.services.elasticache.model.DescribeEngineDefaultParametersRequest)]
   (clojure.core/let
    [v14385
     (:cache-parameter-group-family
      m14384
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14385 :com.palletops.awaze.client-builder/undef)
     (.
      bean14383
      setCacheParameterGroupFamily
      (clojure.core/str v14385))))
   (clojure.core/let
    [v14385
     (:marker m14384 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14385 :com.palletops.awaze.client-builder/undef)
     (. bean14383 setMarker (clojure.core/str v14385))))
   (clojure.core/let
    [v14385
     (:max-records m14384 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14385 :com.palletops.awaze.client-builder/undef)
     (. bean14383 setMaxRecords (clojure.core/int v14385))))
   bean14383))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DeleteReplicationGroupRequest}
delete-replication-group-request
  [m14387]
  (clojure.core/let
   [bean14386
    (new
     com.amazonaws.services.elasticache.model.DeleteReplicationGroupRequest)]
   (clojure.core/let
    [v14388
     (:replication-group-id
      m14387
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14388 :com.palletops.awaze.client-builder/undef)
     (. bean14386 setReplicationGroupId (clojure.core/str v14388))))
   (clojure.core/let
    [v14388
     (:retain-primary-cluster
      m14387
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14388 :com.palletops.awaze.client-builder/undef)
     (.
      bean14386
      setRetainPrimaryCluster
      (clojure.core/boolean v14388))))
   (clojure.core/let
    [v14388
     (:final-snapshot-identifier
      m14387
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14388 :com.palletops.awaze.client-builder/undef)
     (.
      bean14386
      setFinalSnapshotIdentifier
      (clojure.core/str v14388))))
   bean14386))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.CreateCacheSubnetGroupRequest}
create-cache-subnet-group-request
  [m14390]
  (clojure.core/let
   [bean14389
    (new
     com.amazonaws.services.elasticache.model.CreateCacheSubnetGroupRequest)]
   (clojure.core/let
    [v14391
     (:cache-subnet-group-name
      m14390
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14391 :com.palletops.awaze.client-builder/undef)
     (. bean14389 setCacheSubnetGroupName (clojure.core/str v14391))))
   (clojure.core/let
    [v14391
     (:cache-subnet-group-description
      m14390
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14391 :com.palletops.awaze.client-builder/undef)
     (.
      bean14389
      setCacheSubnetGroupDescription
      (clojure.core/str v14391))))
   (clojure.core/let
    [v14391
     (:subnet-ids m14390 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14391 :com.palletops.awaze.client-builder/undef)
     (.
      bean14389
      setSubnetIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14458] (clojure.core/str arg14458))
 v14391))))
   bean14389))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.ModifyCacheClusterRequest}
modify-cache-cluster-request
  [m14393]
  (clojure.core/let
   [bean14392
    (new
     com.amazonaws.services.elasticache.model.ModifyCacheClusterRequest)]
   (clojure.core/let
    [v14394
     (:new-availability-zones
      m14393
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14394 :com.palletops.awaze.client-builder/undef)
     (.
      bean14392
      setNewAvailabilityZones
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14459] (clojure.core/str arg14459))
 v14394))))
   (clojure.core/let
    [v14394
     (:security-group-ids
      m14393
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14394 :com.palletops.awaze.client-builder/undef)
     (.
      bean14392
      setSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14460] (clojure.core/str arg14460))
 v14394))))
   (clojure.core/let
    [v14394
     (:snapshot-retention-limit
      m14393
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14394 :com.palletops.awaze.client-builder/undef)
     (. bean14392 setSnapshotRetentionLimit (clojure.core/int v14394))))
   (clojure.core/let
    [v14394
     (:apply-immediately
      m14393
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14394 :com.palletops.awaze.client-builder/undef)
     (. bean14392 setApplyImmediately (clojure.core/boolean v14394))))
   (clojure.core/let
    [v14394
     (:preferred-maintenance-window
      m14393
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14394 :com.palletops.awaze.client-builder/undef)
     (.
      bean14392
      setPreferredMaintenanceWindow
      (clojure.core/str v14394))))
   (clojure.core/let
    [v14394
     (:azmode m14393 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14394 :com.palletops.awaze.client-builder/undef)
     (. bean14392 setAZMode (elasticache/azmode v14394))))
   (clojure.core/let
    [v14394
     (:notification-topic-arn
      m14393
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14394 :com.palletops.awaze.client-builder/undef)
     (. bean14392 setNotificationTopicArn (clojure.core/str v14394))))
   (clojure.core/let
    [v14394
     (:cache-security-group-names
      m14393
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14394 :com.palletops.awaze.client-builder/undef)
     (.
      bean14392
      setCacheSecurityGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14461] (clojure.core/str arg14461))
 v14394))))
   (clojure.core/let
    [v14394
     (:cache-parameter-group-name
      m14393
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14394 :com.palletops.awaze.client-builder/undef)
     (.
      bean14392
      setCacheParameterGroupName
      (clojure.core/str v14394))))
   (clojure.core/let
    [v14394
     (:cache-cluster-id
      m14393
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14394 :com.palletops.awaze.client-builder/undef)
     (. bean14392 setCacheClusterId (clojure.core/str v14394))))
   (clojure.core/let
    [v14394
     (:notification-topic-status
      m14393
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14394 :com.palletops.awaze.client-builder/undef)
     (.
      bean14392
      setNotificationTopicStatus
      (clojure.core/str v14394))))
   (clojure.core/let
    [v14394
     (:num-cache-nodes
      m14393
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14394 :com.palletops.awaze.client-builder/undef)
     (. bean14392 setNumCacheNodes (clojure.core/int v14394))))
   (clojure.core/let
    [v14394
     (:cache-node-ids-to-remove
      m14393
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14394 :com.palletops.awaze.client-builder/undef)
     (.
      bean14392
      setCacheNodeIdsToRemove
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14462] (clojure.core/str arg14462))
 v14394))))
   (clojure.core/let
    [v14394
     (:auto-minor-version-upgrade
      m14393
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14394 :com.palletops.awaze.client-builder/undef)
     (.
      bean14392
      setAutoMinorVersionUpgrade
      (clojure.core/boolean v14394))))
   (clojure.core/let
    [v14394
     (:snapshot-window
      m14393
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14394 :com.palletops.awaze.client-builder/undef)
     (. bean14392 setSnapshotWindow (clojure.core/str v14394))))
   (clojure.core/let
    [v14394
     (:engine-version
      m14393
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14394 :com.palletops.awaze.client-builder/undef)
     (. bean14392 setEngineVersion (clojure.core/str v14394))))
   (clojure.core/let
    [v14394
     (:cache-node-type
      m14393
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14394 :com.palletops.awaze.client-builder/undef)
     (. bean14392 setCacheNodeType (clojure.core/str v14394))))
   bean14392))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.AuthorizeCacheSecurityGroupIngressRequest}
authorize-cache-security-group-ingress-request
  [m14396]
  (clojure.core/let
   [bean14395
    (new
     com.amazonaws.services.elasticache.model.AuthorizeCacheSecurityGroupIngressRequest)]
   (clojure.core/let
    [v14397
     (:cache-security-group-name
      m14396
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14397 :com.palletops.awaze.client-builder/undef)
     (. bean14395 setCacheSecurityGroupName (clojure.core/str v14397))))
   (clojure.core/let
    [v14397
     (:ec2security-group-name
      m14396
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14397 :com.palletops.awaze.client-builder/undef)
     (. bean14395 setEC2SecurityGroupName (clojure.core/str v14397))))
   (clojure.core/let
    [v14397
     (:ec2security-group-owner-id
      m14396
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14397 :com.palletops.awaze.client-builder/undef)
     (.
      bean14395
      setEC2SecurityGroupOwnerId
      (clojure.core/str v14397))))
   bean14395))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeCacheParametersRequest}
describe-cache-parameters-request
  [m14399]
  (clojure.core/let
   [bean14398
    (new
     com.amazonaws.services.elasticache.model.DescribeCacheParametersRequest)]
   (clojure.core/let
    [v14400
     (:source m14399 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14400 :com.palletops.awaze.client-builder/undef)
     (. bean14398 setSource (clojure.core/str v14400))))
   (clojure.core/let
    [v14400
     (:cache-parameter-group-name
      m14399
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14400 :com.palletops.awaze.client-builder/undef)
     (.
      bean14398
      setCacheParameterGroupName
      (clojure.core/str v14400))))
   (clojure.core/let
    [v14400
     (:marker m14399 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14400 :com.palletops.awaze.client-builder/undef)
     (. bean14398 setMarker (clojure.core/str v14400))))
   (clojure.core/let
    [v14400
     (:max-records m14399 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14400 :com.palletops.awaze.client-builder/undef)
     (. bean14398 setMaxRecords (clojure.core/int v14400))))
   bean14398))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DeleteCacheClusterRequest}
delete-cache-cluster-request
  [m14402]
  (clojure.core/let
   [bean14401
    (new
     com.amazonaws.services.elasticache.model.DeleteCacheClusterRequest)]
   (clojure.core/let
    [v14403
     (:cache-cluster-id
      m14402
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14403 :com.palletops.awaze.client-builder/undef)
     (. bean14401 setCacheClusterId (clojure.core/str v14403))))
   (clojure.core/let
    [v14403
     (:final-snapshot-identifier
      m14402
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14403 :com.palletops.awaze.client-builder/undef)
     (.
      bean14401
      setFinalSnapshotIdentifier
      (clojure.core/str v14403))))
   bean14401))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.ListAllowedNodeTypeModificationsRequest}
list-allowed-node-type-modifications-request
  [m14405]
  (clojure.core/let
   [bean14404
    (new
     com.amazonaws.services.elasticache.model.ListAllowedNodeTypeModificationsRequest)]
   (clojure.core/let
    [v14406
     (:replication-group-id
      m14405
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14406 :com.palletops.awaze.client-builder/undef)
     (. bean14404 setReplicationGroupId (clojure.core/str v14406))))
   (clojure.core/let
    [v14406
     (:cache-cluster-id
      m14405
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14406 :com.palletops.awaze.client-builder/undef)
     (. bean14404 setCacheClusterId (clojure.core/str v14406))))
   bean14404))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.CreateCacheParameterGroupRequest}
create-cache-parameter-group-request
  [m14408]
  (clojure.core/let
   [bean14407
    (new
     com.amazonaws.services.elasticache.model.CreateCacheParameterGroupRequest)]
   (clojure.core/let
    [v14409
     (:cache-parameter-group-family
      m14408
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14409 :com.palletops.awaze.client-builder/undef)
     (.
      bean14407
      setCacheParameterGroupFamily
      (clojure.core/str v14409))))
   (clojure.core/let
    [v14409
     (:cache-parameter-group-name
      m14408
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14409 :com.palletops.awaze.client-builder/undef)
     (.
      bean14407
      setCacheParameterGroupName
      (clojure.core/str v14409))))
   (clojure.core/let
    [v14409
     (:description m14408 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14409 :com.palletops.awaze.client-builder/undef)
     (. bean14407 setDescription (clojure.core/str v14409))))
   bean14407))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.ModifyReplicationGroupRequest}
modify-replication-group-request
  [m14411]
  (clojure.core/let
   [bean14410
    (new
     com.amazonaws.services.elasticache.model.ModifyReplicationGroupRequest)]
   (clojure.core/let
    [v14412
     (:snapshotting-cluster-id
      m14411
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14412 :com.palletops.awaze.client-builder/undef)
     (. bean14410 setSnapshottingClusterId (clojure.core/str v14412))))
   (clojure.core/let
    [v14412
     (:replication-group-description
      m14411
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14412 :com.palletops.awaze.client-builder/undef)
     (.
      bean14410
      setReplicationGroupDescription
      (clojure.core/str v14412))))
   (clojure.core/let
    [v14412
     (:replication-group-id
      m14411
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14412 :com.palletops.awaze.client-builder/undef)
     (. bean14410 setReplicationGroupId (clojure.core/str v14412))))
   (clojure.core/let
    [v14412
     (:security-group-ids
      m14411
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14412 :com.palletops.awaze.client-builder/undef)
     (.
      bean14410
      setSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14463] (clojure.core/str arg14463))
 v14412))))
   (clojure.core/let
    [v14412
     (:snapshot-retention-limit
      m14411
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14412 :com.palletops.awaze.client-builder/undef)
     (. bean14410 setSnapshotRetentionLimit (clojure.core/int v14412))))
   (clojure.core/let
    [v14412
     (:apply-immediately
      m14411
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14412 :com.palletops.awaze.client-builder/undef)
     (. bean14410 setApplyImmediately (clojure.core/boolean v14412))))
   (clojure.core/let
    [v14412
     (:primary-cluster-id
      m14411
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14412 :com.palletops.awaze.client-builder/undef)
     (. bean14410 setPrimaryClusterId (clojure.core/str v14412))))
   (clojure.core/let
    [v14412
     (:preferred-maintenance-window
      m14411
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14412 :com.palletops.awaze.client-builder/undef)
     (.
      bean14410
      setPreferredMaintenanceWindow
      (clojure.core/str v14412))))
   (clojure.core/let
    [v14412
     (:notification-topic-arn
      m14411
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14412 :com.palletops.awaze.client-builder/undef)
     (. bean14410 setNotificationTopicArn (clojure.core/str v14412))))
   (clojure.core/let
    [v14412
     (:cache-security-group-names
      m14411
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14412 :com.palletops.awaze.client-builder/undef)
     (.
      bean14410
      setCacheSecurityGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14464] (clojure.core/str arg14464))
 v14412))))
   (clojure.core/let
    [v14412
     (:cache-parameter-group-name
      m14411
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14412 :com.palletops.awaze.client-builder/undef)
     (.
      bean14410
      setCacheParameterGroupName
      (clojure.core/str v14412))))
   (clojure.core/let
    [v14412
     (:notification-topic-status
      m14411
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14412 :com.palletops.awaze.client-builder/undef)
     (.
      bean14410
      setNotificationTopicStatus
      (clojure.core/str v14412))))
   (clojure.core/let
    [v14412
     (:auto-minor-version-upgrade
      m14411
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14412 :com.palletops.awaze.client-builder/undef)
     (.
      bean14410
      setAutoMinorVersionUpgrade
      (clojure.core/boolean v14412))))
   (clojure.core/let
    [v14412
     (:automatic-failover-enabled
      m14411
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14412 :com.palletops.awaze.client-builder/undef)
     (.
      bean14410
      setAutomaticFailoverEnabled
      (clojure.core/boolean v14412))))
   (clojure.core/let
    [v14412
     (:snapshot-window
      m14411
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14412 :com.palletops.awaze.client-builder/undef)
     (. bean14410 setSnapshotWindow (clojure.core/str v14412))))
   (clojure.core/let
    [v14412
     (:engine-version
      m14411
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14412 :com.palletops.awaze.client-builder/undef)
     (. bean14410 setEngineVersion (clojure.core/str v14412))))
   (clojure.core/let
    [v14412
     (:cache-node-type
      m14411
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14412 :com.palletops.awaze.client-builder/undef)
     (. bean14410 setCacheNodeType (clojure.core/str v14412))))
   bean14410))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.RemoveTagsFromResourceRequest}
remove-tags-from-resource-request
  [m14414]
  (clojure.core/let
   [bean14413
    (new
     com.amazonaws.services.elasticache.model.RemoveTagsFromResourceRequest)]
   (clojure.core/let
    [v14415
     (:resource-name m14414 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14415 :com.palletops.awaze.client-builder/undef)
     (. bean14413 setResourceName (clojure.core/str v14415))))
   (clojure.core/let
    [v14415
     (:tag-keys m14414 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14415 :com.palletops.awaze.client-builder/undef)
     (.
      bean14413
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14497] (clojure.core/str arg14497))
 v14415))))
   bean14413))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeReservedCacheNodesOfferingsRequest}
describe-reserved-cache-nodes-offerings-request
  [m14417]
  (clojure.core/let
   [bean14416
    (new
     com.amazonaws.services.elasticache.model.DescribeReservedCacheNodesOfferingsRequest)]
   (clojure.core/let
    [v14418
     (:reserved-cache-nodes-offering-id
      m14417
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14418 :com.palletops.awaze.client-builder/undef)
     (.
      bean14416
      setReservedCacheNodesOfferingId
      (clojure.core/str v14418))))
   (clojure.core/let
    [v14418
     (:cache-node-type
      m14417
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14418 :com.palletops.awaze.client-builder/undef)
     (. bean14416 setCacheNodeType (clojure.core/str v14418))))
   (clojure.core/let
    [v14418
     (:duration m14417 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14418 :com.palletops.awaze.client-builder/undef)
     (. bean14416 setDuration (clojure.core/str v14418))))
   (clojure.core/let
    [v14418
     (:marker m14417 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14418 :com.palletops.awaze.client-builder/undef)
     (. bean14416 setMarker (clojure.core/str v14418))))
   (clojure.core/let
    [v14418
     (:max-records m14417 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14418 :com.palletops.awaze.client-builder/undef)
     (. bean14416 setMaxRecords (clojure.core/int v14418))))
   (clojure.core/let
    [v14418
     (:product-description
      m14417
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14418 :com.palletops.awaze.client-builder/undef)
     (. bean14416 setProductDescription (clojure.core/str v14418))))
   (clojure.core/let
    [v14418
     (:offering-type m14417 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14418 :com.palletops.awaze.client-builder/undef)
     (. bean14416 setOfferingType (clojure.core/str v14418))))
   bean14416))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeCacheSecurityGroupsRequest}
describe-cache-security-groups-request
  [m14420]
  (clojure.core/let
   [bean14419
    (new
     com.amazonaws.services.elasticache.model.DescribeCacheSecurityGroupsRequest)]
   (clojure.core/let
    [v14421
     (:cache-security-group-name
      m14420
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14421 :com.palletops.awaze.client-builder/undef)
     (. bean14419 setCacheSecurityGroupName (clojure.core/str v14421))))
   (clojure.core/let
    [v14421
     (:marker m14420 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14421 :com.palletops.awaze.client-builder/undef)
     (. bean14419 setMarker (clojure.core/str v14421))))
   (clojure.core/let
    [v14421
     (:max-records m14420 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14421 :com.palletops.awaze.client-builder/undef)
     (. bean14419 setMaxRecords (clojure.core/int v14421))))
   bean14419))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.CreateReplicationGroupRequest}
create-replication-group-request
  [m14423]
  (clojure.core/let
   [bean14422
    (new
     com.amazonaws.services.elasticache.model.CreateReplicationGroupRequest)]
   (clojure.core/let
    [v14424
     (:preferred-cache-cluster-azs
      m14423
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14424 :com.palletops.awaze.client-builder/undef)
     (.
      bean14422
      setPreferredCacheClusterAZs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14498] (clojure.core/str arg14498))
 v14424))))
   (clojure.core/let
    [v14424
     (:engine m14423 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14424 :com.palletops.awaze.client-builder/undef)
     (. bean14422 setEngine (clojure.core/str v14424))))
   (clojure.core/let
    [v14424
     (:replication-group-description
      m14423
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14424 :com.palletops.awaze.client-builder/undef)
     (.
      bean14422
      setReplicationGroupDescription
      (clojure.core/str v14424))))
   (clojure.core/let
    [v14424
     (:cache-subnet-group-name
      m14423
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14424 :com.palletops.awaze.client-builder/undef)
     (. bean14422 setCacheSubnetGroupName (clojure.core/str v14424))))
   (clojure.core/let
    [v14424
     (:replication-group-id
      m14423
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14424 :com.palletops.awaze.client-builder/undef)
     (. bean14422 setReplicationGroupId (clojure.core/str v14424))))
   (clojure.core/let
    [v14424
     (:security-group-ids
      m14423
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14424 :com.palletops.awaze.client-builder/undef)
     (.
      bean14422
      setSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14499] (clojure.core/str arg14499))
 v14424))))
   (clojure.core/let
    [v14424
     (:snapshot-retention-limit
      m14423
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14424 :com.palletops.awaze.client-builder/undef)
     (. bean14422 setSnapshotRetentionLimit (clojure.core/int v14424))))
   (clojure.core/let
    [v14424
     (:primary-cluster-id
      m14423
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14424 :com.palletops.awaze.client-builder/undef)
     (. bean14422 setPrimaryClusterId (clojure.core/str v14424))))
   (clojure.core/let
    [v14424
     (:preferred-maintenance-window
      m14423
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14424 :com.palletops.awaze.client-builder/undef)
     (.
      bean14422
      setPreferredMaintenanceWindow
      (clojure.core/str v14424))))
   (clojure.core/let
    [v14424
     (:notification-topic-arn
      m14423
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14424 :com.palletops.awaze.client-builder/undef)
     (. bean14422 setNotificationTopicArn (clojure.core/str v14424))))
   (clojure.core/let
    [v14424
     (:cache-security-group-names
      m14423
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14424 :com.palletops.awaze.client-builder/undef)
     (.
      bean14422
      setCacheSecurityGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14500] (clojure.core/str arg14500))
 v14424))))
   (clojure.core/let
    [v14424
     (:snapshot-name m14423 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14424 :com.palletops.awaze.client-builder/undef)
     (. bean14422 setSnapshotName (clojure.core/str v14424))))
   (clojure.core/let
    [v14424
     (:snapshot-arns m14423 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14424 :com.palletops.awaze.client-builder/undef)
     (.
      bean14422
      setSnapshotArns
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14501] (clojure.core/str arg14501))
 v14424))))
   (clojure.core/let
    [v14424 (:port m14423 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14424 :com.palletops.awaze.client-builder/undef)
     (. bean14422 setPort (clojure.core/int v14424))))
   (clojure.core/let
    [v14424 (:tags m14423 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14424 :com.palletops.awaze.client-builder/undef)
     (.
      bean14422
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14502] (elasticache/tag arg14502))
 v14424))))
   (clojure.core/let
    [v14424
     (:cache-parameter-group-name
      m14423
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14424 :com.palletops.awaze.client-builder/undef)
     (.
      bean14422
      setCacheParameterGroupName
      (clojure.core/str v14424))))
   (clojure.core/let
    [v14424
     (:auto-minor-version-upgrade
      m14423
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14424 :com.palletops.awaze.client-builder/undef)
     (.
      bean14422
      setAutoMinorVersionUpgrade
      (clojure.core/boolean v14424))))
   (clojure.core/let
    [v14424
     (:automatic-failover-enabled
      m14423
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14424 :com.palletops.awaze.client-builder/undef)
     (.
      bean14422
      setAutomaticFailoverEnabled
      (clojure.core/boolean v14424))))
   (clojure.core/let
    [v14424
     (:snapshot-window
      m14423
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14424 :com.palletops.awaze.client-builder/undef)
     (. bean14422 setSnapshotWindow (clojure.core/str v14424))))
   (clojure.core/let
    [v14424
     (:engine-version
      m14423
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14424 :com.palletops.awaze.client-builder/undef)
     (. bean14422 setEngineVersion (clojure.core/str v14424))))
   (clojure.core/let
    [v14424
     (:num-cache-clusters
      m14423
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14424 :com.palletops.awaze.client-builder/undef)
     (. bean14422 setNumCacheClusters (clojure.core/int v14424))))
   (clojure.core/let
    [v14424
     (:cache-node-type
      m14423
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14424 :com.palletops.awaze.client-builder/undef)
     (. bean14422 setCacheNodeType (clojure.core/str v14424))))
   bean14422))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.ListTagsForResourceRequest}
list-tags-for-resource-request
  [m14426]
  (clojure.core/let
   [bean14425
    (new
     com.amazonaws.services.elasticache.model.ListTagsForResourceRequest)]
   (clojure.core/let
    [v14427
     (:resource-name m14426 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14427 :com.palletops.awaze.client-builder/undef)
     (. bean14425 setResourceName (clojure.core/str v14427))))
   bean14425))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.ResetCacheParameterGroupRequest}
reset-cache-parameter-group-request
  [m14429]
  (clojure.core/let
   [bean14428
    (new
     com.amazonaws.services.elasticache.model.ResetCacheParameterGroupRequest)]
   (clojure.core/let
    [v14430
     (:cache-parameter-group-name
      m14429
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14430 :com.palletops.awaze.client-builder/undef)
     (.
      bean14428
      setCacheParameterGroupName
      (clojure.core/str v14430))))
   (clojure.core/let
    [v14430
     (:parameter-name-values
      m14429
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14430 :com.palletops.awaze.client-builder/undef)
     (.
      bean14428
      setParameterNameValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg14503]
  (elasticache/parameter-name-value arg14503))
 v14430))))
   (clojure.core/let
    [v14430
     (:reset-all-parameters
      m14429
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14430 :com.palletops.awaze.client-builder/undef)
     (. bean14428 setResetAllParameters (clojure.core/boolean v14430))))
   bean14428))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeSnapshotsRequest}
describe-snapshots-request
  [m14432]
  (clojure.core/let
   [bean14431
    (new
     com.amazonaws.services.elasticache.model.DescribeSnapshotsRequest)]
   (clojure.core/let
    [v14433
     (:snapshot-name m14432 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14433 :com.palletops.awaze.client-builder/undef)
     (. bean14431 setSnapshotName (clojure.core/str v14433))))
   (clojure.core/let
    [v14433
     (:snapshot-source
      m14432
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14433 :com.palletops.awaze.client-builder/undef)
     (. bean14431 setSnapshotSource (clojure.core/str v14433))))
   (clojure.core/let
    [v14433
     (:cache-cluster-id
      m14432
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14433 :com.palletops.awaze.client-builder/undef)
     (. bean14431 setCacheClusterId (clojure.core/str v14433))))
   (clojure.core/let
    [v14433
     (:marker m14432 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14433 :com.palletops.awaze.client-builder/undef)
     (. bean14431 setMarker (clojure.core/str v14433))))
   (clojure.core/let
    [v14433
     (:max-records m14432 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14433 :com.palletops.awaze.client-builder/undef)
     (. bean14431 setMaxRecords (clojure.core/int v14433))))
   bean14431))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DeleteCacheSubnetGroupRequest}
delete-cache-subnet-group-request
  [m14435]
  (clojure.core/let
   [bean14434
    (new
     com.amazonaws.services.elasticache.model.DeleteCacheSubnetGroupRequest)]
   (clojure.core/let
    [v14436
     (:cache-subnet-group-name
      m14435
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14436 :com.palletops.awaze.client-builder/undef)
     (. bean14434 setCacheSubnetGroupName (clojure.core/str v14436))))
   bean14434))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.CreateSnapshotRequest}
create-snapshot-request
  [m14438]
  (clojure.core/let
   [bean14437
    (new
     com.amazonaws.services.elasticache.model.CreateSnapshotRequest)]
   (clojure.core/let
    [v14439
     (:snapshot-name m14438 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14439 :com.palletops.awaze.client-builder/undef)
     (. bean14437 setSnapshotName (clojure.core/str v14439))))
   (clojure.core/let
    [v14439
     (:cache-cluster-id
      m14438
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14439 :com.palletops.awaze.client-builder/undef)
     (. bean14437 setCacheClusterId (clojure.core/str v14439))))
   bean14437))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.PurchaseReservedCacheNodesOfferingRequest}
purchase-reserved-cache-nodes-offering-request
  [m14441]
  (clojure.core/let
   [bean14440
    (new
     com.amazonaws.services.elasticache.model.PurchaseReservedCacheNodesOfferingRequest)]
   (clojure.core/let
    [v14442
     (:reserved-cache-node-id
      m14441
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14442 :com.palletops.awaze.client-builder/undef)
     (. bean14440 setReservedCacheNodeId (clojure.core/str v14442))))
   (clojure.core/let
    [v14442
     (:reserved-cache-nodes-offering-id
      m14441
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14442 :com.palletops.awaze.client-builder/undef)
     (.
      bean14440
      setReservedCacheNodesOfferingId
      (clojure.core/str v14442))))
   (clojure.core/let
    [v14442
     (:cache-node-count
      m14441
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14442 :com.palletops.awaze.client-builder/undef)
     (. bean14440 setCacheNodeCount (clojure.core/int v14442))))
   bean14440))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DeleteCacheSecurityGroupRequest}
delete-cache-security-group-request
  [m14444]
  (clojure.core/let
   [bean14443
    (new
     com.amazonaws.services.elasticache.model.DeleteCacheSecurityGroupRequest)]
   (clojure.core/let
    [v14445
     (:cache-security-group-name
      m14444
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14445 :com.palletops.awaze.client-builder/undef)
     (. bean14443 setCacheSecurityGroupName (clojure.core/str v14445))))
   bean14443))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeCacheSubnetGroupsRequest}
describe-cache-subnet-groups-request
  [m14447]
  (clojure.core/let
   [bean14446
    (new
     com.amazonaws.services.elasticache.model.DescribeCacheSubnetGroupsRequest)]
   (clojure.core/let
    [v14448
     (:cache-subnet-group-name
      m14447
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14448 :com.palletops.awaze.client-builder/undef)
     (. bean14446 setCacheSubnetGroupName (clojure.core/str v14448))))
   (clojure.core/let
    [v14448
     (:marker m14447 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14448 :com.palletops.awaze.client-builder/undef)
     (. bean14446 setMarker (clojure.core/str v14448))))
   (clojure.core/let
    [v14448
     (:max-records m14447 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14448 :com.palletops.awaze.client-builder/undef)
     (. bean14446 setMaxRecords (clojure.core/int v14448))))
   bean14446))
 (clojure.core/defmulti
  elasticache
  (clojure.core/fn
   elasticache
   [m__1874__auto__]
   (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   elasticache
   :modify-cache-parameter-group
   [m14465]
   (clojure.core/let
    [credentials14466 (:credentials m14465) args14467 (:args m14465)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14468
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14466)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14468
       modifyCacheParameterGroup
       (elasticache/modify-cache-parameter-group-request
        (clojure.core/nth args14467 0)))))))
  (clojure.core/defn
   modify-cache-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         parameter-name-values
                         clone-source
                         cache-parameter-group-name
                         clone-root]}]]),
    :doc "Generate map for modifyCacheParameterGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-cache-parameter-group,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   modify-cache-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         parameter-name-values
                         clone-source
                         cache-parameter-group-name
                         clone-root]}]]),
    :doc "Call modifyCacheParameterGroup"}
   [credentials14470 & args14471]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14472
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14470)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14472
      modifyCacheParameterGroup
      (elasticache/modify-cache-parameter-group-request
       (clojure.core/nth args14471 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-replication-groups
   [m14473]
   (clojure.core/let
    [credentials14474 (:credentials m14473) args14475 (:args m14473)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14476
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14474)]
     (clojure.core/case
      (clojure.core/count args14475)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14476
        describeReplicationGroups
        (elasticache/describe-replication-groups-request
         (clojure.core/nth args14475 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14476
        describeReplicationGroups))))))
  (clojure.core/defn
   describe-replication-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         replication-group-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeReplicationGroups, describeReplicationGroups"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-replication-groups,
     :credentials credentials__1842__auto__,
     :client :elasticache})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-replication-groups,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   describe-replication-groups
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         replication-group-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeReplicationGroups, describeReplicationGroups"}
   [credentials14478 & args14479]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14480
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14478)]
    (clojure.core/case
     (clojure.core/count args14479)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14480
       describeReplicationGroups
       (elasticache/describe-replication-groups-request
        (clojure.core/nth args14479 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14480
       describeReplicationGroups))))))
 (do
  (clojure.core/defmethod
   elasticache
   :create-cache-cluster
   [m14481]
   (clojure.core/let
    [credentials14482 (:credentials m14481) args14483 (:args m14481)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14484
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14482)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14484
       createCacheCluster
       (elasticache/create-cache-cluster-request
        (clojure.core/nth args14483 0)))))))
  (clojure.core/defn
   create-cache-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [preferred-availability-zone
                         security-group-ids
                         tags
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         azmode
                         num-cache-nodes
                         sdk-request-timeout
                         notification-topic-arn
                         replication-group-id
                         cache-security-group-names
                         cache-subnet-group-name
                         custom-query-parameters
                         preferred-availability-zones
                         port
                         cache-cluster-id
                         read-limit
                         snapshot-name
                         general-progress-listener
                         snapshot-window
                         cache-node-type
                         engine
                         snapshot-retention-limit
                         clone-source
                         cache-parameter-group-name
                         auto-minor-version-upgrade
                         clone-root
                         snapshot-arns
                         engine-version]}]]),
    :doc "Generate map for createCacheCluster"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-cache-cluster,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   create-cache-cluster
   {:arglists (quote
               [[credentials
                 {:keys [preferred-availability-zone
                         security-group-ids
                         tags
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         azmode
                         num-cache-nodes
                         sdk-request-timeout
                         notification-topic-arn
                         replication-group-id
                         cache-security-group-names
                         cache-subnet-group-name
                         custom-query-parameters
                         preferred-availability-zones
                         port
                         cache-cluster-id
                         read-limit
                         snapshot-name
                         general-progress-listener
                         snapshot-window
                         cache-node-type
                         engine
                         snapshot-retention-limit
                         clone-source
                         cache-parameter-group-name
                         auto-minor-version-upgrade
                         clone-root
                         snapshot-arns
                         engine-version]}]]),
    :doc "Call createCacheCluster"}
   [credentials14486 & args14487]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14488
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14486)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14488
      createCacheCluster
      (elasticache/create-cache-cluster-request
       (clojure.core/nth args14487 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-cache-parameter-groups
   [m14489]
   (clojure.core/let
    [credentials14490 (:credentials m14489) args14491 (:args m14489)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14492
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14490)]
     (clojure.core/case
      (clojure.core/count args14491)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14492
        describeCacheParameterGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14492
        describeCacheParameterGroups
        (elasticache/describe-cache-parameter-groups-request
         (clojure.core/nth args14491 0))))))))
  (clojure.core/defn
   describe-cache-parameter-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         cache-parameter-group-name
                         clone-root]}]]),
    :doc "Generate map for describeCacheParameterGroups, describeCacheParameterGroups"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-cache-parameter-groups,
     :credentials credentials__1842__auto__,
     :client :elasticache})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-cache-parameter-groups,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   describe-cache-parameter-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         cache-parameter-group-name
                         clone-root]}]]),
    :doc "Call describeCacheParameterGroups, describeCacheParameterGroups"}
   [credentials14494 & args14495]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14496
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14494)]
    (clojure.core/case
     (clojure.core/count args14495)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14496
       describeCacheParameterGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14496
       describeCacheParameterGroups
       (elasticache/describe-cache-parameter-groups-request
        (clojure.core/nth args14495 0))))))))
 (do
  (clojure.core/defmethod
   elasticache
   :delete-cache-parameter-group
   [m14504]
   (clojure.core/let
    [credentials14505 (:credentials m14504) args14506 (:args m14504)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14507
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14505)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14507
       deleteCacheParameterGroup
       (elasticache/delete-cache-parameter-group-request
        (clojure.core/nth args14506 0)))))))
  (clojure.core/defn
   delete-cache-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         cache-parameter-group-name
                         clone-root]}]]),
    :doc "Generate map for deleteCacheParameterGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-cache-parameter-group,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   delete-cache-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         cache-parameter-group-name
                         clone-root]}]]),
    :doc "Call deleteCacheParameterGroup"}
   [credentials14509 & args14510]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14511
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14509)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14511
      deleteCacheParameterGroup
      (elasticache/delete-cache-parameter-group-request
       (clojure.core/nth args14510 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :create-cache-security-group
   [m14512]
   (clojure.core/let
    [credentials14513 (:credentials m14512) args14514 (:args m14512)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14515
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14513)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14515
       createCacheSecurityGroup
       (elasticache/create-cache-security-group-request
        (clojure.core/nth args14514 0)))))))
  (clojure.core/defn
   create-cache-security-group-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         cache-security-group-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createCacheSecurityGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-cache-security-group,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   create-cache-security-group
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         cache-security-group-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createCacheSecurityGroup"}
   [credentials14517 & args14518]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14519
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14517)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14519
      createCacheSecurityGroup
      (elasticache/create-cache-security-group-request
       (clojure.core/nth args14518 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :add-tags-to-resource
   [m14520]
   (clojure.core/let
    [credentials14521 (:credentials m14520) args14522 (:args m14520)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14523
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14521)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14523
       addTagsToResource
       (elasticache/add-tags-to-resource-request
        (clojure.core/nth args14522 0)))))))
  (clojure.core/defn
   add-tags-to-resource-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         resource-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for addTagsToResource"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :add-tags-to-resource,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   add-tags-to-resource
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         resource-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call addTagsToResource"}
   [credentials14525 & args14526]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14527
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14525)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14527
      addTagsToResource
      (elasticache/add-tags-to-resource-request
       (clojure.core/nth args14526 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-events
   [m14528]
   (clojure.core/let
    [credentials14529 (:credentials m14528) args14530 (:args m14528)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14531
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14529)]
     (clojure.core/case
      (clojure.core/count args14530)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14531
        describeEvents))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14531
        describeEvents
        (elasticache/describe-events-request
         (clojure.core/nth args14530 0))))))))
  (clojure.core/defn
   describe-events-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         source-type
                         start-time
                         custom-query-parameters
                         end-time
                         duration
                         read-limit
                         source-identifier
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeEvents, describeEvents"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-events,
     :credentials credentials__1842__auto__,
     :client :elasticache})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-events,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   describe-events
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         source-type
                         start-time
                         custom-query-parameters
                         end-time
                         duration
                         read-limit
                         source-identifier
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeEvents, describeEvents"}
   [credentials14533 & args14534]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14535
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14533)]
    (clojure.core/case
     (clojure.core/count args14534)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14535
       describeEvents))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14535
       describeEvents
       (elasticache/describe-events-request
        (clojure.core/nth args14534 0))))))))
 (do
  (clojure.core/defmethod
   elasticache
   :modify-cache-subnet-group
   [m14536]
   (clojure.core/let
    [credentials14537 (:credentials m14536) args14538 (:args m14536)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14539
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14537)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14539
       modifyCacheSubnetGroup
       (elasticache/modify-cache-subnet-group-request
        (clojure.core/nth args14538 0)))))))
  (clojure.core/defn
   modify-cache-subnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cache-subnet-group-name
                         custom-query-parameters
                         read-limit
                         subnet-ids
                         general-progress-listener
                         cache-subnet-group-description
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for modifyCacheSubnetGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-cache-subnet-group,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   modify-cache-subnet-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cache-subnet-group-name
                         custom-query-parameters
                         read-limit
                         subnet-ids
                         general-progress-listener
                         cache-subnet-group-description
                         clone-source
                         clone-root]}]]),
    :doc "Call modifyCacheSubnetGroup"}
   [credentials14541 & args14542]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14543
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14541)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14543
      modifyCacheSubnetGroup
      (elasticache/modify-cache-subnet-group-request
       (clojure.core/nth args14542 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :revoke-cache-security-group-ingress
   [m14544]
   (clojure.core/let
    [credentials14545 (:credentials m14544) args14546 (:args m14544)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14547
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14545)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14547
       revokeCacheSecurityGroupIngress
       (elasticache/revoke-cache-security-group-ingress-request
        (clojure.core/nth args14546 0)))))))
  (clojure.core/defn
   revoke-cache-security-group-ingress-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cache-security-group-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         ec2security-group-owner-id
                         clone-source
                         clone-root
                         ec2security-group-name]}]]),
    :doc "Generate map for revokeCacheSecurityGroupIngress"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :revoke-cache-security-group-ingress,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   revoke-cache-security-group-ingress
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cache-security-group-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         ec2security-group-owner-id
                         clone-source
                         clone-root
                         ec2security-group-name]}]]),
    :doc "Call revokeCacheSecurityGroupIngress"}
   [credentials14549 & args14550]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14551
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14549)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14551
      revokeCacheSecurityGroupIngress
      (elasticache/revoke-cache-security-group-ingress-request
       (clojure.core/nth args14550 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-reserved-cache-nodes
   [m14552]
   (clojure.core/let
    [credentials14553 (:credentials m14552) args14554 (:args m14552)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14555
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14553)]
     (clojure.core/case
      (clojure.core/count args14554)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14555
        describeReservedCacheNodes))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14555
        describeReservedCacheNodes
        (elasticache/describe-reserved-cache-nodes-request
         (clojure.core/nth args14554 0))))))))
  (clojure.core/defn
   describe-reserved-cache-nodes-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         reserved-cache-node-id
                         offering-type
                         sdk-request-timeout
                         marker
                         reserved-cache-nodes-offering-id
                         custom-query-parameters
                         duration
                         read-limit
                         product-description
                         general-progress-listener
                         cache-node-type
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeReservedCacheNodes, describeReservedCacheNodes"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-reserved-cache-nodes,
     :credentials credentials__1842__auto__,
     :client :elasticache})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-reserved-cache-nodes,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   describe-reserved-cache-nodes
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         reserved-cache-node-id
                         offering-type
                         sdk-request-timeout
                         marker
                         reserved-cache-nodes-offering-id
                         custom-query-parameters
                         duration
                         read-limit
                         product-description
                         general-progress-listener
                         cache-node-type
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeReservedCacheNodes, describeReservedCacheNodes"}
   [credentials14557 & args14558]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14559
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14557)]
    (clojure.core/case
     (clojure.core/count args14558)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14559
       describeReservedCacheNodes))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14559
       describeReservedCacheNodes
       (elasticache/describe-reserved-cache-nodes-request
        (clojure.core/nth args14558 0))))))))
 (do
  (clojure.core/defmethod
   elasticache
   :reboot-cache-cluster
   [m14560]
   (clojure.core/let
    [credentials14561 (:credentials m14560) args14562 (:args m14560)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14563
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14561)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14563
       rebootCacheCluster
       (elasticache/reboot-cache-cluster-request
        (clojure.core/nth args14562 0)))))))
  (clojure.core/defn
   reboot-cache-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cache-node-ids-to-reboot
                         custom-query-parameters
                         cache-cluster-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for rebootCacheCluster"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :reboot-cache-cluster,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   reboot-cache-cluster
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cache-node-ids-to-reboot
                         custom-query-parameters
                         cache-cluster-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call rebootCacheCluster"}
   [credentials14565 & args14566]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14567
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14565)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14567
      rebootCacheCluster
      (elasticache/reboot-cache-cluster-request
       (clojure.core/nth args14566 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-cache-clusters
   [m14568]
   (clojure.core/let
    [credentials14569 (:credentials m14568) args14570 (:args m14568)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14571
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14569)]
     (clojure.core/case
      (clojure.core/count args14570)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14571
        describeCacheClusters))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14571
        describeCacheClusters
        (elasticache/describe-cache-clusters-request
         (clojure.core/nth args14570 0))))))))
  (clojure.core/defn
   describe-cache-clusters-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         show-cache-node-info
                         custom-query-parameters
                         cache-cluster-id
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeCacheClusters, describeCacheClusters"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-cache-clusters,
     :credentials credentials__1842__auto__,
     :client :elasticache})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-cache-clusters,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   describe-cache-clusters
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         show-cache-node-info
                         custom-query-parameters
                         cache-cluster-id
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeCacheClusters, describeCacheClusters"}
   [credentials14573 & args14574]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14575
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14573)]
    (clojure.core/case
     (clojure.core/count args14574)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14575
       describeCacheClusters))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14575
       describeCacheClusters
       (elasticache/describe-cache-clusters-request
        (clojure.core/nth args14574 0))))))))
 (do
  (clojure.core/defmethod
   elasticache
   :copy-snapshot
   [m14576]
   (clojure.core/let
    [credentials14577 (:credentials m14576) args14578 (:args m14576)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14579
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14577)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14579
       copySnapshot
       (elasticache/copy-snapshot-request
        (clojure.core/nth args14578 0)))))))
  (clojure.core/defn
   copy-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         source-snapshot-name
                         read-limit
                         general-progress-listener
                         clone-source
                         target-snapshot-name
                         clone-root]}]]),
    :doc "Generate map for copySnapshot"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :copy-snapshot,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   copy-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         source-snapshot-name
                         read-limit
                         general-progress-listener
                         clone-source
                         target-snapshot-name
                         clone-root]}]]),
    :doc "Call copySnapshot"}
   [credentials14581 & args14582]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14583
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14581)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14583
      copySnapshot
      (elasticache/copy-snapshot-request
       (clojure.core/nth args14582 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :delete-snapshot
   [m14584]
   (clojure.core/let
    [credentials14585 (:credentials m14584) args14586 (:args m14584)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14587
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14585)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14587
       deleteSnapshot
       (elasticache/delete-snapshot-request
        (clojure.core/nth args14586 0)))))))
  (clojure.core/defn
   delete-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         snapshot-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteSnapshot"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-snapshot,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   delete-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         snapshot-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteSnapshot"}
   [credentials14589 & args14590]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14591
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14589)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14591
      deleteSnapshot
      (elasticache/delete-snapshot-request
       (clojure.core/nth args14590 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-cache-engine-versions
   [m14592]
   (clojure.core/let
    [credentials14593 (:credentials m14592) args14594 (:args m14592)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14595
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14593)]
     (clojure.core/case
      (clojure.core/count args14594)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14595
        describeCacheEngineVersions))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14595
        describeCacheEngineVersions
        (elasticache/describe-cache-engine-versions-request
         (clojure.core/nth args14594 0))))))))
  (clojure.core/defn
   describe-cache-engine-versions-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         default-only
                         sdk-request-timeout
                         marker
                         cache-parameter-group-family
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         engine
                         clone-source
                         clone-root
                         engine-version]}]]),
    :doc "Generate map for describeCacheEngineVersions, describeCacheEngineVersions"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-cache-engine-versions,
     :credentials credentials__1842__auto__,
     :client :elasticache})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-cache-engine-versions,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   describe-cache-engine-versions
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         default-only
                         sdk-request-timeout
                         marker
                         cache-parameter-group-family
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         engine
                         clone-source
                         clone-root
                         engine-version]}]]),
    :doc "Call describeCacheEngineVersions, describeCacheEngineVersions"}
   [credentials14597 & args14598]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14599
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14597)]
    (clojure.core/case
     (clojure.core/count args14598)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14599
       describeCacheEngineVersions))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14599
       describeCacheEngineVersions
       (elasticache/describe-cache-engine-versions-request
        (clojure.core/nth args14598 0))))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-engine-default-parameters
   [m14600]
   (clojure.core/let
    [credentials14601 (:credentials m14600) args14602 (:args m14600)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14603
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14601)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14603
       describeEngineDefaultParameters
       (elasticache/describe-engine-default-parameters-request
        (clojure.core/nth args14602 0)))))))
  (clojure.core/defn
   describe-engine-default-parameters-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         cache-parameter-group-family
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeEngineDefaultParameters"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-engine-default-parameters,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   describe-engine-default-parameters
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         cache-parameter-group-family
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeEngineDefaultParameters"}
   [credentials14605 & args14606]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14607
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14605)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14607
      describeEngineDefaultParameters
      (elasticache/describe-engine-default-parameters-request
       (clojure.core/nth args14606 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :delete-replication-group
   [m14608]
   (clojure.core/let
    [credentials14609 (:credentials m14608) args14610 (:args m14608)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14611
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14609)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14611
       deleteReplicationGroup
       (elasticache/delete-replication-group-request
        (clojure.core/nth args14610 0)))))))
  (clojure.core/defn
   delete-replication-group-map
   {:arglists (quote
               [[credentials
                 {:keys [retain-primary-cluster
                         custom-request-headers
                         sdk-client-execution-timeout
                         final-snapshot-identifier
                         sdk-request-timeout
                         replication-group-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteReplicationGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-replication-group,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   delete-replication-group
   {:arglists (quote
               [[credentials
                 {:keys [retain-primary-cluster
                         custom-request-headers
                         sdk-client-execution-timeout
                         final-snapshot-identifier
                         sdk-request-timeout
                         replication-group-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteReplicationGroup"}
   [credentials14613 & args14614]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14615
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14613)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14615
      deleteReplicationGroup
      (elasticache/delete-replication-group-request
       (clojure.core/nth args14614 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :create-cache-subnet-group
   [m14616]
   (clojure.core/let
    [credentials14617 (:credentials m14616) args14618 (:args m14616)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14619
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14617)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14619
       createCacheSubnetGroup
       (elasticache/create-cache-subnet-group-request
        (clojure.core/nth args14618 0)))))))
  (clojure.core/defn
   create-cache-subnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cache-subnet-group-name
                         custom-query-parameters
                         read-limit
                         subnet-ids
                         general-progress-listener
                         cache-subnet-group-description
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createCacheSubnetGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-cache-subnet-group,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   create-cache-subnet-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cache-subnet-group-name
                         custom-query-parameters
                         read-limit
                         subnet-ids
                         general-progress-listener
                         cache-subnet-group-description
                         clone-source
                         clone-root]}]]),
    :doc "Call createCacheSubnetGroup"}
   [credentials14621 & args14622]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14623
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14621)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14623
      createCacheSubnetGroup
      (elasticache/create-cache-subnet-group-request
       (clojure.core/nth args14622 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :modify-cache-cluster
   [m14624]
   (clojure.core/let
    [credentials14625 (:credentials m14624) args14626 (:args m14624)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14627
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14625)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14627
       modifyCacheCluster
       (elasticache/modify-cache-cluster-request
        (clojure.core/nth args14626 0)))))))
  (clojure.core/defn
   modify-cache-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [security-group-ids
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         azmode
                         num-cache-nodes
                         sdk-request-timeout
                         notification-topic-arn
                         cache-security-group-names
                         custom-query-parameters
                         notification-topic-status
                         cache-cluster-id
                         read-limit
                         cache-node-ids-to-remove
                         apply-immediately
                         general-progress-listener
                         snapshot-window
                         cache-node-type
                         snapshot-retention-limit
                         clone-source
                         cache-parameter-group-name
                         new-availability-zones
                         auto-minor-version-upgrade
                         clone-root
                         engine-version]}]]),
    :doc "Generate map for modifyCacheCluster"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-cache-cluster,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   modify-cache-cluster
   {:arglists (quote
               [[credentials
                 {:keys [security-group-ids
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         azmode
                         num-cache-nodes
                         sdk-request-timeout
                         notification-topic-arn
                         cache-security-group-names
                         custom-query-parameters
                         notification-topic-status
                         cache-cluster-id
                         read-limit
                         cache-node-ids-to-remove
                         apply-immediately
                         general-progress-listener
                         snapshot-window
                         cache-node-type
                         snapshot-retention-limit
                         clone-source
                         cache-parameter-group-name
                         new-availability-zones
                         auto-minor-version-upgrade
                         clone-root
                         engine-version]}]]),
    :doc "Call modifyCacheCluster"}
   [credentials14629 & args14630]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14631
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14629)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14631
      modifyCacheCluster
      (elasticache/modify-cache-cluster-request
       (clojure.core/nth args14630 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :authorize-cache-security-group-ingress
   [m14632]
   (clojure.core/let
    [credentials14633 (:credentials m14632) args14634 (:args m14632)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14635
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14633)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14635
       authorizeCacheSecurityGroupIngress
       (elasticache/authorize-cache-security-group-ingress-request
        (clojure.core/nth args14634 0)))))))
  (clojure.core/defn
   authorize-cache-security-group-ingress-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cache-security-group-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         ec2security-group-owner-id
                         clone-source
                         clone-root
                         ec2security-group-name]}]]),
    :doc "Generate map for authorizeCacheSecurityGroupIngress"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :authorize-cache-security-group-ingress,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   authorize-cache-security-group-ingress
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cache-security-group-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         ec2security-group-owner-id
                         clone-source
                         clone-root
                         ec2security-group-name]}]]),
    :doc "Call authorizeCacheSecurityGroupIngress"}
   [credentials14637 & args14638]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14639
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14637)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14639
      authorizeCacheSecurityGroupIngress
      (elasticache/authorize-cache-security-group-ingress-request
       (clojure.core/nth args14638 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-cache-parameters
   [m14640]
   (clojure.core/let
    [credentials14641 (:credentials m14640) args14642 (:args m14640)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14643
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14641)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14643
       describeCacheParameters
       (elasticache/describe-cache-parameters-request
        (clojure.core/nth args14642 0)))))))
  (clojure.core/defn
   describe-cache-parameters-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         source
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         cache-parameter-group-name
                         clone-root]}]]),
    :doc "Generate map for describeCacheParameters"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-cache-parameters,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   describe-cache-parameters
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         source
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         cache-parameter-group-name
                         clone-root]}]]),
    :doc "Call describeCacheParameters"}
   [credentials14645 & args14646]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14647
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14645)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14647
      describeCacheParameters
      (elasticache/describe-cache-parameters-request
       (clojure.core/nth args14646 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :delete-cache-cluster
   [m14648]
   (clojure.core/let
    [credentials14649 (:credentials m14648) args14650 (:args m14648)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14651
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14649)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14651
       deleteCacheCluster
       (elasticache/delete-cache-cluster-request
        (clojure.core/nth args14650 0)))))))
  (clojure.core/defn
   delete-cache-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         final-snapshot-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         cache-cluster-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteCacheCluster"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-cache-cluster,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   delete-cache-cluster
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         final-snapshot-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         cache-cluster-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteCacheCluster"}
   [credentials14653 & args14654]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14655
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14653)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14655
      deleteCacheCluster
      (elasticache/delete-cache-cluster-request
       (clojure.core/nth args14654 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :list-allowed-node-type-modifications
   [m14656]
   (clojure.core/let
    [credentials14657 (:credentials m14656) args14658 (:args m14656)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14659
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14657)]
     (clojure.core/case
      (clojure.core/count args14658)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14659
        listAllowedNodeTypeModifications))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14659
        listAllowedNodeTypeModifications
        (elasticache/list-allowed-node-type-modifications-request
         (clojure.core/nth args14658 0))))))))
  (clojure.core/defn
   list-allowed-node-type-modifications-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         replication-group-id
                         custom-query-parameters
                         cache-cluster-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listAllowedNodeTypeModifications, listAllowedNodeTypeModifications"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-allowed-node-type-modifications,
     :credentials credentials__1842__auto__,
     :client :elasticache})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-allowed-node-type-modifications,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   list-allowed-node-type-modifications
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         replication-group-id
                         custom-query-parameters
                         cache-cluster-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listAllowedNodeTypeModifications, listAllowedNodeTypeModifications"}
   [credentials14661 & args14662]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14663
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14661)]
    (clojure.core/case
     (clojure.core/count args14662)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14663
       listAllowedNodeTypeModifications))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14663
       listAllowedNodeTypeModifications
       (elasticache/list-allowed-node-type-modifications-request
        (clojure.core/nth args14662 0))))))))
 (do
  (clojure.core/defmethod
   elasticache
   :create-cache-parameter-group
   [m14664]
   (clojure.core/let
    [credentials14665 (:credentials m14664) args14666 (:args m14664)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14667
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14665)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14667
       createCacheParameterGroup
       (elasticache/create-cache-parameter-group-request
        (clojure.core/nth args14666 0)))))))
  (clojure.core/defn
   create-cache-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cache-parameter-group-family
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         cache-parameter-group-name
                         clone-root]}]]),
    :doc "Generate map for createCacheParameterGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-cache-parameter-group,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   create-cache-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cache-parameter-group-family
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         cache-parameter-group-name
                         clone-root]}]]),
    :doc "Call createCacheParameterGroup"}
   [credentials14669 & args14670]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14671
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14669)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14671
      createCacheParameterGroup
      (elasticache/create-cache-parameter-group-request
       (clojure.core/nth args14670 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :modify-replication-group
   [m14672]
   (clojure.core/let
    [credentials14673 (:credentials m14672) args14674 (:args m14672)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14675
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14673)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14675
       modifyReplicationGroup
       (elasticache/modify-replication-group-request
        (clojure.core/nth args14674 0)))))))
  (clojure.core/defn
   modify-replication-group-map
   {:arglists (quote
               [[credentials
                 {:keys [automatic-failover-enabled
                         security-group-ids
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         notification-topic-arn
                         replication-group-id
                         cache-security-group-names
                         custom-query-parameters
                         notification-topic-status
                         snapshotting-cluster-id
                         read-limit
                         apply-immediately
                         general-progress-listener
                         primary-cluster-id
                         snapshot-window
                         replication-group-description
                         cache-node-type
                         snapshot-retention-limit
                         clone-source
                         cache-parameter-group-name
                         auto-minor-version-upgrade
                         clone-root
                         engine-version]}]]),
    :doc "Generate map for modifyReplicationGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-replication-group,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   modify-replication-group
   {:arglists (quote
               [[credentials
                 {:keys [automatic-failover-enabled
                         security-group-ids
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         notification-topic-arn
                         replication-group-id
                         cache-security-group-names
                         custom-query-parameters
                         notification-topic-status
                         snapshotting-cluster-id
                         read-limit
                         apply-immediately
                         general-progress-listener
                         primary-cluster-id
                         snapshot-window
                         replication-group-description
                         cache-node-type
                         snapshot-retention-limit
                         clone-source
                         cache-parameter-group-name
                         auto-minor-version-upgrade
                         clone-root
                         engine-version]}]]),
    :doc "Call modifyReplicationGroup"}
   [credentials14677 & args14678]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14679
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14677)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14679
      modifyReplicationGroup
      (elasticache/modify-replication-group-request
       (clojure.core/nth args14678 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :remove-tags-from-resource
   [m14680]
   (clojure.core/let
    [credentials14681 (:credentials m14680) args14682 (:args m14680)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14683
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14681)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14683
       removeTagsFromResource
       (elasticache/remove-tags-from-resource-request
        (clojure.core/nth args14682 0)))))))
  (clojure.core/defn
   remove-tags-from-resource-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         tag-keys
                         resource-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for removeTagsFromResource"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :remove-tags-from-resource,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   remove-tags-from-resource
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         tag-keys
                         resource-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call removeTagsFromResource"}
   [credentials14685 & args14686]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14687
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14685)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14687
      removeTagsFromResource
      (elasticache/remove-tags-from-resource-request
       (clojure.core/nth args14686 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-reserved-cache-nodes-offerings
   [m14688]
   (clojure.core/let
    [credentials14689 (:credentials m14688) args14690 (:args m14688)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14691
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14689)]
     (clojure.core/case
      (clojure.core/count args14690)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14691
        describeReservedCacheNodesOfferings
        (elasticache/describe-reserved-cache-nodes-offerings-request
         (clojure.core/nth args14690 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14691
        describeReservedCacheNodesOfferings))))))
  (clojure.core/defn
   describe-reserved-cache-nodes-offerings-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         offering-type
                         sdk-request-timeout
                         marker
                         reserved-cache-nodes-offering-id
                         custom-query-parameters
                         duration
                         read-limit
                         product-description
                         general-progress-listener
                         cache-node-type
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeReservedCacheNodesOfferings, describeReservedCacheNodesOfferings"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-reserved-cache-nodes-offerings,
     :credentials credentials__1842__auto__,
     :client :elasticache})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-reserved-cache-nodes-offerings,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   describe-reserved-cache-nodes-offerings
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         offering-type
                         sdk-request-timeout
                         marker
                         reserved-cache-nodes-offering-id
                         custom-query-parameters
                         duration
                         read-limit
                         product-description
                         general-progress-listener
                         cache-node-type
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeReservedCacheNodesOfferings, describeReservedCacheNodesOfferings"}
   [credentials14693 & args14694]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14695
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14693)]
    (clojure.core/case
     (clojure.core/count args14694)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14695
       describeReservedCacheNodesOfferings
       (elasticache/describe-reserved-cache-nodes-offerings-request
        (clojure.core/nth args14694 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14695
       describeReservedCacheNodesOfferings))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-cache-security-groups
   [m14696]
   (clojure.core/let
    [credentials14697 (:credentials m14696) args14698 (:args m14696)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14699
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14697)]
     (clojure.core/case
      (clojure.core/count args14698)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14699
        describeCacheSecurityGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14699
        describeCacheSecurityGroups
        (elasticache/describe-cache-security-groups-request
         (clojure.core/nth args14698 0))))))))
  (clojure.core/defn
   describe-cache-security-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cache-security-group-name
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeCacheSecurityGroups, describeCacheSecurityGroups"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-cache-security-groups,
     :credentials credentials__1842__auto__,
     :client :elasticache})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-cache-security-groups,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   describe-cache-security-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cache-security-group-name
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeCacheSecurityGroups, describeCacheSecurityGroups"}
   [credentials14701 & args14702]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14703
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14701)]
    (clojure.core/case
     (clojure.core/count args14702)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14703
       describeCacheSecurityGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14703
       describeCacheSecurityGroups
       (elasticache/describe-cache-security-groups-request
        (clojure.core/nth args14702 0))))))))
 (do
  (clojure.core/defmethod
   elasticache
   :create-replication-group
   [m14704]
   (clojure.core/let
    [credentials14705 (:credentials m14704) args14706 (:args m14704)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14707
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14705)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14707
       createReplicationGroup
       (elasticache/create-replication-group-request
        (clojure.core/nth args14706 0)))))))
  (clojure.core/defn
   create-replication-group-map
   {:arglists (quote
               [[credentials
                 {:keys [automatic-failover-enabled
                         security-group-ids
                         tags
                         preferred-cache-cluster-azs
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         notification-topic-arn
                         replication-group-id
                         cache-security-group-names
                         cache-subnet-group-name
                         custom-query-parameters
                         port
                         read-limit
                         snapshot-name
                         general-progress-listener
                         primary-cluster-id
                         snapshot-window
                         num-cache-clusters
                         replication-group-description
                         cache-node-type
                         engine
                         snapshot-retention-limit
                         clone-source
                         cache-parameter-group-name
                         auto-minor-version-upgrade
                         clone-root
                         snapshot-arns
                         engine-version]}]]),
    :doc "Generate map for createReplicationGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-replication-group,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   create-replication-group
   {:arglists (quote
               [[credentials
                 {:keys [automatic-failover-enabled
                         security-group-ids
                         tags
                         preferred-cache-cluster-azs
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         notification-topic-arn
                         replication-group-id
                         cache-security-group-names
                         cache-subnet-group-name
                         custom-query-parameters
                         port
                         read-limit
                         snapshot-name
                         general-progress-listener
                         primary-cluster-id
                         snapshot-window
                         num-cache-clusters
                         replication-group-description
                         cache-node-type
                         engine
                         snapshot-retention-limit
                         clone-source
                         cache-parameter-group-name
                         auto-minor-version-upgrade
                         clone-root
                         snapshot-arns
                         engine-version]}]]),
    :doc "Call createReplicationGroup"}
   [credentials14709 & args14710]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14711
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14709)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14711
      createReplicationGroup
      (elasticache/create-replication-group-request
       (clojure.core/nth args14710 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :list-tags-for-resource
   [m14712]
   (clojure.core/let
    [credentials14713 (:credentials m14712) args14714 (:args m14712)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14715
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14713)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14715
       listTagsForResource
       (elasticache/list-tags-for-resource-request
        (clojure.core/nth args14714 0)))))))
  (clojure.core/defn
   list-tags-for-resource-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         resource-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listTagsForResource"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-tags-for-resource,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   list-tags-for-resource
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         resource-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listTagsForResource"}
   [credentials14717 & args14718]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14719
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14717)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14719
      listTagsForResource
      (elasticache/list-tags-for-resource-request
       (clojure.core/nth args14718 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :reset-cache-parameter-group
   [m14720]
   (clojure.core/let
    [credentials14721 (:credentials m14720) args14722 (:args m14720)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14723
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14721)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14723
       resetCacheParameterGroup
       (elasticache/reset-cache-parameter-group-request
        (clojure.core/nth args14722 0)))))))
  (clojure.core/defn
   reset-cache-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         parameter-name-values
                         clone-source
                         reset-all-parameters
                         cache-parameter-group-name
                         clone-root]}]]),
    :doc "Generate map for resetCacheParameterGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :reset-cache-parameter-group,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   reset-cache-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         parameter-name-values
                         clone-source
                         reset-all-parameters
                         cache-parameter-group-name
                         clone-root]}]]),
    :doc "Call resetCacheParameterGroup"}
   [credentials14725 & args14726]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14727
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14725)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14727
      resetCacheParameterGroup
      (elasticache/reset-cache-parameter-group-request
       (clojure.core/nth args14726 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-snapshots
   [m14728]
   (clojure.core/let
    [credentials14729 (:credentials m14728) args14730 (:args m14728)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14731
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14729)]
     (clojure.core/case
      (clojure.core/count args14730)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14731
        describeSnapshots))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14731
        describeSnapshots
        (elasticache/describe-snapshots-request
         (clojure.core/nth args14730 0))))))))
  (clojure.core/defn
   describe-snapshots-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         cache-cluster-id
                         read-limit
                         snapshot-name
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         snapshot-source]}]]),
    :doc "Generate map for describeSnapshots, describeSnapshots"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-snapshots,
     :credentials credentials__1842__auto__,
     :client :elasticache})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-snapshots,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   describe-snapshots
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         cache-cluster-id
                         read-limit
                         snapshot-name
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         snapshot-source]}]]),
    :doc "Call describeSnapshots, describeSnapshots"}
   [credentials14733 & args14734]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14735
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14733)]
    (clojure.core/case
     (clojure.core/count args14734)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14735
       describeSnapshots))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14735
       describeSnapshots
       (elasticache/describe-snapshots-request
        (clojure.core/nth args14734 0))))))))
 (do
  (clojure.core/defmethod
   elasticache
   :delete-cache-subnet-group
   [m14736]
   (clojure.core/let
    [credentials14737 (:credentials m14736) args14738 (:args m14736)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14739
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14737)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14739
       deleteCacheSubnetGroup
       (elasticache/delete-cache-subnet-group-request
        (clojure.core/nth args14738 0)))))))
  (clojure.core/defn
   delete-cache-subnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cache-subnet-group-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteCacheSubnetGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-cache-subnet-group,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   delete-cache-subnet-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cache-subnet-group-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteCacheSubnetGroup"}
   [credentials14741 & args14742]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14743
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14741)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14743
      deleteCacheSubnetGroup
      (elasticache/delete-cache-subnet-group-request
       (clojure.core/nth args14742 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :create-snapshot
   [m14744]
   (clojure.core/let
    [credentials14745 (:credentials m14744) args14746 (:args m14744)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14747
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14745)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14747
       createSnapshot
       (elasticache/create-snapshot-request
        (clojure.core/nth args14746 0)))))))
  (clojure.core/defn
   create-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         cache-cluster-id
                         read-limit
                         snapshot-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createSnapshot"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-snapshot,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   create-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         cache-cluster-id
                         read-limit
                         snapshot-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createSnapshot"}
   [credentials14749 & args14750]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14751
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14749)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14751
      createSnapshot
      (elasticache/create-snapshot-request
       (clojure.core/nth args14750 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :purchase-reserved-cache-nodes-offering
   [m14752]
   (clojure.core/let
    [credentials14753 (:credentials m14752) args14754 (:args m14752)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14755
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14753)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14755
       purchaseReservedCacheNodesOffering
       (elasticache/purchase-reserved-cache-nodes-offering-request
        (clojure.core/nth args14754 0)))))))
  (clojure.core/defn
   purchase-reserved-cache-nodes-offering-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         reserved-cache-node-id
                         cache-node-count
                         sdk-request-timeout
                         reserved-cache-nodes-offering-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for purchaseReservedCacheNodesOffering"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :purchase-reserved-cache-nodes-offering,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   purchase-reserved-cache-nodes-offering
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         reserved-cache-node-id
                         cache-node-count
                         sdk-request-timeout
                         reserved-cache-nodes-offering-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call purchaseReservedCacheNodesOffering"}
   [credentials14757 & args14758]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14759
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14757)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14759
      purchaseReservedCacheNodesOffering
      (elasticache/purchase-reserved-cache-nodes-offering-request
       (clojure.core/nth args14758 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :delete-cache-security-group
   [m14760]
   (clojure.core/let
    [credentials14761 (:credentials m14760) args14762 (:args m14760)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14763
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14761)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14763
       deleteCacheSecurityGroup
       (elasticache/delete-cache-security-group-request
        (clojure.core/nth args14762 0)))))))
  (clojure.core/defn
   delete-cache-security-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cache-security-group-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteCacheSecurityGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-cache-security-group,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   delete-cache-security-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cache-security-group-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteCacheSecurityGroup"}
   [credentials14765 & args14766]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14767
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14765)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14767
      deleteCacheSecurityGroup
      (elasticache/delete-cache-security-group-request
       (clojure.core/nth args14766 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-cache-subnet-groups
   [m14768]
   (clojure.core/let
    [credentials14769 (:credentials m14768) args14770 (:args m14768)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14771
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14769)]
     (clojure.core/case
      (clojure.core/count args14770)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14771
        describeCacheSubnetGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14771
        describeCacheSubnetGroups
        (elasticache/describe-cache-subnet-groups-request
         (clojure.core/nth args14770 0))))))))
  (clojure.core/defn
   describe-cache-subnet-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         cache-subnet-group-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeCacheSubnetGroups, describeCacheSubnetGroups"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-cache-subnet-groups,
     :credentials credentials__1842__auto__,
     :client :elasticache})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-cache-subnet-groups,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   describe-cache-subnet-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         cache-subnet-group-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeCacheSubnetGroups, describeCacheSubnetGroups"}
   [credentials14773 & args14774]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14775
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14773)]
    (clojure.core/case
     (clojure.core/count args14774)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14775
       describeCacheSubnetGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14775
       describeCacheSubnetGroups
       (elasticache/describe-cache-subnet-groups-request
        (clojure.core/nth args14774 0)))))))))
