(ns
 com.palletops.awaze.ec2
 (:refer-clojure :exclude [filter])
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.ec2 :as ec2]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :ec2
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.ec2.AmazonEC2Client
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.VolumeType}
volume-type
  [m1947]
  (.
   com.amazonaws.services.ec2.model.VolumeType
   fromValue
   (clojure.core/name m1947)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.EbsBlockDevice}
ebs-block-device
  [m1950]
  (clojure.core/let
   [bean1949 (new com.amazonaws.services.ec2.model.EbsBlockDevice)]
   (clojure.core/let
    [v1951
     (:delete-on-termination
      m1950
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1951 :com.palletops.awaze.client-builder/undef)
     (. bean1949 setDeleteOnTermination (clojure.core/boolean v1951))))
   (clojure.core/let
    [v1951
     (:volume-size m1950 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1951 :com.palletops.awaze.client-builder/undef)
     (. bean1949 setVolumeSize (clojure.core/int v1951))))
   (clojure.core/let
    [v1951
     (:encrypted m1950 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1951 :com.palletops.awaze.client-builder/undef)
     (. bean1949 setEncrypted (clojure.core/boolean v1951))))
   (clojure.core/let
    [v1951
     (:snapshot-id m1950 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1951 :com.palletops.awaze.client-builder/undef)
     (. bean1949 setSnapshotId (clojure.core/str v1951))))
   (clojure.core/let
    [v1951
     (:volume-type m1950 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1951 :com.palletops.awaze.client-builder/undef)
     (. bean1949 setVolumeType (ec2/volume-type v1951))))
   (clojure.core/let
    [v1951 (:iops m1950 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1951 :com.palletops.awaze.client-builder/undef)
     (. bean1949 setIops (clojure.core/int v1951))))
   bean1949))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.PrivateIpAddressSpecification}
private-ip-address-specification
  [m1953]
  (clojure.core/let
   [bean1952
    (new
     com.amazonaws.services.ec2.model.PrivateIpAddressSpecification)]
   (clojure.core/let
    [v1954 (:primary m1953 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1954 :com.palletops.awaze.client-builder/undef)
     (. bean1952 setPrimary (clojure.core/boolean v1954))))
   (clojure.core/let
    [v1954
     (:private-ip-address
      m1953
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1954 :com.palletops.awaze.client-builder/undef)
     (. bean1952 setPrivateIpAddress (clojure.core/str v1954))))
   bean1952))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DiskImageFormat}
disk-image-format
  [m1956]
  (.
   com.amazonaws.services.ec2.model.DiskImageFormat
   fromValue
   (clojure.core/name m1956)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.IamInstanceProfileSpecification}
iam-instance-profile-specification
  [m1959]
  (clojure.core/let
   [bean1958
    (new
     com.amazonaws.services.ec2.model.IamInstanceProfileSpecification)]
   (clojure.core/let
    [v1960 (:arn m1959 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1960 :com.palletops.awaze.client-builder/undef)
     (. bean1958 setArn (clojure.core/str v1960))))
   (clojure.core/let
    [v1960 (:name m1959 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1960 :com.palletops.awaze.client-builder/undef)
     (. bean1958 setName (clojure.core/str v1960))))
   bean1958))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.SpotPlacement}
spot-placement
  [m1962]
  (clojure.core/let
   [bean1961 (new com.amazonaws.services.ec2.model.SpotPlacement)]
   (clojure.core/let
    [v1963
     (:availability-zone
      m1962
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1963 :com.palletops.awaze.client-builder/undef)
     (. bean1961 setAvailabilityZone (clojure.core/str v1963))))
   (clojure.core/let
    [v1963
     (:group-name m1962 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1963 :com.palletops.awaze.client-builder/undef)
     (. bean1961 setGroupName (clojure.core/str v1963))))
   bean1961))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.SpotFleetMonitoring}
spot-fleet-monitoring
  [m1965]
  (clojure.core/let
   [bean1964
    (new com.amazonaws.services.ec2.model.SpotFleetMonitoring)]
   (clojure.core/let
    [v1966 (:enabled m1965 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1966 :com.palletops.awaze.client-builder/undef)
     (. bean1964 setEnabled (clojure.core/boolean v1966))))
   bean1964))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.GroupIdentifier}
group-identifier
  [m1968]
  (clojure.core/let
   [bean1967 (new com.amazonaws.services.ec2.model.GroupIdentifier)]
   (clojure.core/let
    [v1969
     (:group-id m1968 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1969 :com.palletops.awaze.client-builder/undef)
     (. bean1967 setGroupId (clojure.core/str v1969))))
   (clojure.core/let
    [v1969
     (:group-name m1968 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1969 :com.palletops.awaze.client-builder/undef)
     (. bean1967 setGroupName (clojure.core/str v1969))))
   bean1967))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.BlockDeviceMapping}
block-device-mapping
  [m1971]
  (clojure.core/let
   [bean1970
    (new com.amazonaws.services.ec2.model.BlockDeviceMapping)]
   (clojure.core/let
    [v1972
     (:device-name m1971 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1972 :com.palletops.awaze.client-builder/undef)
     (. bean1970 setDeviceName (clojure.core/str v1972))))
   (clojure.core/let
    [v1972 (:ebs m1971 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1972 :com.palletops.awaze.client-builder/undef)
     (. bean1970 setEbs (ec2/ebs-block-device v1972))))
   (clojure.core/let
    [v1972
     (:virtual-name m1971 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1972 :com.palletops.awaze.client-builder/undef)
     (. bean1970 setVirtualName (clojure.core/str v1972))))
   (clojure.core/let
    [v1972
     (:no-device m1971 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1972 :com.palletops.awaze.client-builder/undef)
     (. bean1970 setNoDevice (clojure.core/str v1972))))
   bean1970))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.InstanceNetworkInterfaceSpecification}
instance-network-interface-specification
  [m1974]
  (clojure.core/let
   [bean1973
    (new
     com.amazonaws.services.ec2.model.InstanceNetworkInterfaceSpecification)]
   (clojure.core/let
    [v1975
     (:description m1974 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1975 :com.palletops.awaze.client-builder/undef)
     (. bean1973 setDescription (clojure.core/str v1975))))
   (clojure.core/let
    [v1975
     (:subnet-id m1974 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1975 :com.palletops.awaze.client-builder/undef)
     (. bean1973 setSubnetId (clojure.core/str v1975))))
   (clojure.core/let
    [v1975
     (:secondary-private-ip-address-count
      m1974
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1975 :com.palletops.awaze.client-builder/undef)
     (.
      bean1973
      setSecondaryPrivateIpAddressCount
      (clojure.core/int v1975))))
   (clojure.core/let
    [v1975
     (:device-index m1974 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1975 :com.palletops.awaze.client-builder/undef)
     (. bean1973 setDeviceIndex (clojure.core/int v1975))))
   (clojure.core/let
    [v1975
     (:private-ip-address
      m1974
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1975 :com.palletops.awaze.client-builder/undef)
     (. bean1973 setPrivateIpAddress (clojure.core/str v1975))))
   (clojure.core/let
    [v1975 (:groups m1974 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1975 :com.palletops.awaze.client-builder/undef)
     (.
      bean1973
      setGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2780] (clojure.core/str arg2780))
 v1975))))
   (clojure.core/let
    [v1975
     (:network-interface-id
      m1974
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1975 :com.palletops.awaze.client-builder/undef)
     (. bean1973 setNetworkInterfaceId (clojure.core/str v1975))))
   (clojure.core/let
    [v1975
     (:associate-public-ip-address
      m1974
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1975 :com.palletops.awaze.client-builder/undef)
     (.
      bean1973
      setAssociatePublicIpAddress
      (clojure.core/boolean v1975))))
   (clojure.core/let
    [v1975
     (:private-ip-addresses
      m1974
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1975 :com.palletops.awaze.client-builder/undef)
     (.
      bean1973
      setPrivateIpAddresses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg2781]
  (ec2/private-ip-address-specification arg2781))
 v1975))))
   (clojure.core/let
    [v1975
     (:delete-on-termination
      m1974
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1975 :com.palletops.awaze.client-builder/undef)
     (. bean1973 setDeleteOnTermination (clojure.core/boolean v1975))))
   bean1973))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ScheduledInstancesEbs}
scheduled-instances-ebs
  [m1977]
  (clojure.core/let
   [bean1976
    (new com.amazonaws.services.ec2.model.ScheduledInstancesEbs)]
   (clojure.core/let
    [v1978
     (:delete-on-termination
      m1977
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1978 :com.palletops.awaze.client-builder/undef)
     (. bean1976 setDeleteOnTermination (clojure.core/boolean v1978))))
   (clojure.core/let
    [v1978
     (:volume-size m1977 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1978 :com.palletops.awaze.client-builder/undef)
     (. bean1976 setVolumeSize (clojure.core/int v1978))))
   (clojure.core/let
    [v1978
     (:encrypted m1977 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1978 :com.palletops.awaze.client-builder/undef)
     (. bean1976 setEncrypted (clojure.core/boolean v1978))))
   (clojure.core/let
    [v1978
     (:snapshot-id m1977 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1978 :com.palletops.awaze.client-builder/undef)
     (. bean1976 setSnapshotId (clojure.core/str v1978))))
   (clojure.core/let
    [v1978
     (:volume-type m1977 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1978 :com.palletops.awaze.client-builder/undef)
     (. bean1976 setVolumeType (clojure.core/str v1978))))
   (clojure.core/let
    [v1978 (:iops m1977 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1978 :com.palletops.awaze.client-builder/undef)
     (. bean1976 setIops (clojure.core/int v1978))))
   bean1976))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ScheduledInstancesPrivateIpAddressConfig}
scheduled-instances-private-ip-address-config
  [m1980]
  (clojure.core/let
   [bean1979
    (new
     com.amazonaws.services.ec2.model.ScheduledInstancesPrivateIpAddressConfig)]
   (clojure.core/let
    [v1981 (:primary m1980 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1981 :com.palletops.awaze.client-builder/undef)
     (. bean1979 setPrimary (clojure.core/boolean v1981))))
   (clojure.core/let
    [v1981
     (:private-ip-address
      m1980
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1981 :com.palletops.awaze.client-builder/undef)
     (. bean1979 setPrivateIpAddress (clojure.core/str v1981))))
   bean1979))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CurrencyCodeValues}
currency-code-values
  [m1983]
  (.
   com.amazonaws.services.ec2.model.CurrencyCodeValues
   fromValue
   (clojure.core/name m1983)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.UserIdGroupPair}
user-id-group-pair
  [m1986]
  (clojure.core/let
   [bean1985 (new com.amazonaws.services.ec2.model.UserIdGroupPair)]
   (clojure.core/let
    [v1987 (:user-id m1986 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1987 :com.palletops.awaze.client-builder/undef)
     (. bean1985 setUserId (clojure.core/str v1987))))
   (clojure.core/let
    [v1987
     (:peering-status m1986 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1987 :com.palletops.awaze.client-builder/undef)
     (. bean1985 setPeeringStatus (clojure.core/str v1987))))
   (clojure.core/let
    [v1987 (:vpc-id m1986 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1987 :com.palletops.awaze.client-builder/undef)
     (. bean1985 setVpcId (clojure.core/str v1987))))
   (clojure.core/let
    [v1987
     (:group-id m1986 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1987 :com.palletops.awaze.client-builder/undef)
     (. bean1985 setGroupId (clojure.core/str v1987))))
   (clojure.core/let
    [v1987
     (:group-name m1986 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1987 :com.palletops.awaze.client-builder/undef)
     (. bean1985 setGroupName (clojure.core/str v1987))))
   (clojure.core/let
    [v1987
     (:vpc-peering-connection-id
      m1986
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1987 :com.palletops.awaze.client-builder/undef)
     (. bean1985 setVpcPeeringConnectionId (clojure.core/str v1987))))
   bean1985))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.PrefixListId}
prefix-list-id
  [m1989]
  (clojure.core/let
   [bean1988 (new com.amazonaws.services.ec2.model.PrefixListId)]
   (clojure.core/let
    [v1990
     (:prefix-list-id m1989 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1990 :com.palletops.awaze.client-builder/undef)
     (. bean1988 setPrefixListId (clojure.core/str v1990))))
   bean1988))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.EbsInstanceBlockDeviceSpecification}
ebs-instance-block-device-specification
  [m1992]
  (clojure.core/let
   [bean1991
    (new
     com.amazonaws.services.ec2.model.EbsInstanceBlockDeviceSpecification)]
   (clojure.core/let
    [v1993
     (:delete-on-termination
      m1992
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1993 :com.palletops.awaze.client-builder/undef)
     (. bean1991 setDeleteOnTermination (clojure.core/boolean v1993))))
   (clojure.core/let
    [v1993
     (:volume-id m1992 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1993 :com.palletops.awaze.client-builder/undef)
     (. bean1991 setVolumeId (clojure.core/str v1993))))
   bean1991))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.Placement}
placement
  [m1995]
  (clojure.core/let
   [bean1994 (new com.amazonaws.services.ec2.model.Placement)]
   (clojure.core/let
    [v1996
     (:availability-zone
      m1995
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1996 :com.palletops.awaze.client-builder/undef)
     (. bean1994 setAvailabilityZone (clojure.core/str v1996))))
   (clojure.core/let
    [v1996
     (:group-name m1995 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1996 :com.palletops.awaze.client-builder/undef)
     (. bean1994 setGroupName (clojure.core/str v1996))))
   (clojure.core/let
    [v1996 (:tenancy m1995 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1996 :com.palletops.awaze.client-builder/undef)
     (. bean1994 setTenancy (clojure.core/str v1996))))
   (clojure.core/let
    [v1996
     (:affinity m1995 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1996 :com.palletops.awaze.client-builder/undef)
     (. bean1994 setAffinity (clojure.core/str v1996))))
   (clojure.core/let
    [v1996 (:host-id m1995 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1996 :com.palletops.awaze.client-builder/undef)
     (. bean1994 setHostId (clojure.core/str v1996))))
   bean1994))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ShutdownBehavior}
shutdown-behavior
  [m1998]
  (.
   com.amazonaws.services.ec2.model.ShutdownBehavior
   fromValue
   (clojure.core/name m1998)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.UserData}
user-data
  [m2001]
  (clojure.core/let
   [bean2000 (new com.amazonaws.services.ec2.model.UserData)]
   (clojure.core/let
    [v2002 (:data m2001 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2002 :com.palletops.awaze.client-builder/undef)
     (. bean2000 setData (clojure.core/str v2002))))
   bean2000))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DiskImageDetail}
disk-image-detail
  [m2004]
  (clojure.core/let
   [bean2003 (new com.amazonaws.services.ec2.model.DiskImageDetail)]
   (clojure.core/let
    [v2005 (:format m2004 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2005 :com.palletops.awaze.client-builder/undef)
     (. bean2003 setFormat (ec2/disk-image-format v2005))))
   (clojure.core/let
    [v2005 (:bytes m2004 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2005 :com.palletops.awaze.client-builder/undef)
     (. bean2003 setBytes (clojure.core/long v2005))))
   (clojure.core/let
    [v2005
     (:import-manifest-url
      m2004
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2005 :com.palletops.awaze.client-builder/undef)
     (. bean2003 setImportManifestUrl (clojure.core/str v2005))))
   bean2003))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.VolumeDetail}
volume-detail
  [m2007]
  (clojure.core/let
   [bean2006 (new com.amazonaws.services.ec2.model.VolumeDetail)]
   (clojure.core/let
    [v2008 (:size m2007 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2008 :com.palletops.awaze.client-builder/undef)
     (. bean2006 setSize (clojure.core/long v2008))))
   bean2006))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVolumePermission}
create-volume-permission
  [m2010]
  (clojure.core/let
   [bean2009
    (new com.amazonaws.services.ec2.model.CreateVolumePermission)]
   (clojure.core/let
    [v2011 (:group m2010 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2011 :com.palletops.awaze.client-builder/undef)
     (. bean2009 setGroup (clojure.core/str v2011))))
   (clojure.core/let
    [v2011 (:user-id m2010 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2011 :com.palletops.awaze.client-builder/undef)
     (. bean2009 setUserId (clojure.core/str v2011))))
   bean2009))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.SpotFleetLaunchSpecification}
spot-fleet-launch-specification
  [m2013]
  (clojure.core/let
   [bean2012
    (new
     com.amazonaws.services.ec2.model.SpotFleetLaunchSpecification)]
   (clojure.core/let
    [v2014
     (:spot-price m2013 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2014 :com.palletops.awaze.client-builder/undef)
     (. bean2012 setSpotPrice (clojure.core/str v2014))))
   (clojure.core/let
    [v2014
     (:iam-instance-profile
      m2013
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2014 :com.palletops.awaze.client-builder/undef)
     (.
      bean2012
      setIamInstanceProfile
      (ec2/iam-instance-profile-specification v2014))))
   (clojure.core/let
    [v2014
     (:subnet-id m2013 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2014 :com.palletops.awaze.client-builder/undef)
     (. bean2012 setSubnetId (clojure.core/str v2014))))
   (clojure.core/let
    [v2014
     (:placement m2013 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2014 :com.palletops.awaze.client-builder/undef)
     (. bean2012 setPlacement (ec2/spot-placement v2014))))
   (clojure.core/let
    [v2014
     (:addressing-type
      m2013
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2014 :com.palletops.awaze.client-builder/undef)
     (. bean2012 setAddressingType (clojure.core/str v2014))))
   (clojure.core/let
    [v2014
     (:instance-type m2013 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2014 :com.palletops.awaze.client-builder/undef)
     (. bean2012 setInstanceType (clojure.core/str v2014))))
   (clojure.core/let
    [v2014
     (:ebs-optimized m2013 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2014 :com.palletops.awaze.client-builder/undef)
     (. bean2012 setEbsOptimized (clojure.core/boolean v2014))))
   (clojure.core/let
    [v2014
     (:ramdisk-id m2013 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2014 :com.palletops.awaze.client-builder/undef)
     (. bean2012 setRamdiskId (clojure.core/str v2014))))
   (clojure.core/let
    [v2014
     (:weighted-capacity
      m2013
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2014 :com.palletops.awaze.client-builder/undef)
     (. bean2012 setWeightedCapacity (clojure.core/double v2014))))
   (clojure.core/let
    [v2014
     (:image-id m2013 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2014 :com.palletops.awaze.client-builder/undef)
     (. bean2012 setImageId (clojure.core/str v2014))))
   (clojure.core/let
    [v2014
     (:key-name m2013 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2014 :com.palletops.awaze.client-builder/undef)
     (. bean2012 setKeyName (clojure.core/str v2014))))
   (clojure.core/let
    [v2014
     (:kernel-id m2013 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2014 :com.palletops.awaze.client-builder/undef)
     (. bean2012 setKernelId (clojure.core/str v2014))))
   (clojure.core/let
    [v2014
     (:monitoring m2013 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2014 :com.palletops.awaze.client-builder/undef)
     (. bean2012 setMonitoring (ec2/spot-fleet-monitoring v2014))))
   (clojure.core/let
    [v2014
     (:security-groups
      m2013
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2014 :com.palletops.awaze.client-builder/undef)
     (.
      bean2012
      setSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2782] (ec2/group-identifier arg2782))
 v2014))))
   (clojure.core/let
    [v2014
     (:block-device-mappings
      m2013
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2014 :com.palletops.awaze.client-builder/undef)
     (.
      bean2012
      setBlockDeviceMappings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2783] (ec2/block-device-mapping arg2783))
 v2014))))
   (clojure.core/let
    [v2014
     (:user-data m2013 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2014 :com.palletops.awaze.client-builder/undef)
     (. bean2012 setUserData (clojure.core/str v2014))))
   (clojure.core/let
    [v2014
     (:network-interfaces
      m2013
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2014 :com.palletops.awaze.client-builder/undef)
     (.
      bean2012
      setNetworkInterfaces
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg2784]
  (ec2/instance-network-interface-specification arg2784))
 v2014))))
   bean2012))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AllocationStrategy}
allocation-strategy
  [m2016]
  (.
   com.amazonaws.services.ec2.model.AllocationStrategy
   fromValue
   (clojure.core/name m2016)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ExcessCapacityTerminationPolicy}
excess-capacity-termination-policy
  [m2019]
  (.
   com.amazonaws.services.ec2.model.ExcessCapacityTerminationPolicy
   fromValue
   (clojure.core/name m2019)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.UserBucket}
user-bucket
  [m2022]
  (clojure.core/let
   [bean2021 (new com.amazonaws.services.ec2.model.UserBucket)]
   (clojure.core/let
    [v2023
     (:s3bucket m2022 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2023 :com.palletops.awaze.client-builder/undef)
     (. bean2021 setS3Bucket (clojure.core/str v2023))))
   (clojure.core/let
    [v2023 (:s3key m2022 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2023 :com.palletops.awaze.client-builder/undef)
     (. bean2021 setS3Key (clojure.core/str v2023))))
   bean2021))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.S3Storage}
s3storage
  [m2025]
  (clojure.core/let
   [bean2024 (new com.amazonaws.services.ec2.model.S3Storage)]
   (clojure.core/let
    [v2026
     (:awsaccess-key-id
      m2025
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2026 :com.palletops.awaze.client-builder/undef)
     (. bean2024 setAWSAccessKeyId (clojure.core/str v2026))))
   (clojure.core/let
    [v2026
     (:upload-policy m2025 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2026 :com.palletops.awaze.client-builder/undef)
     (. bean2024 setUploadPolicy (clojure.core/str v2026))))
   (clojure.core/let
    [v2026
     (:upload-policy-signature
      m2025
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2026 :com.palletops.awaze.client-builder/undef)
     (. bean2024 setUploadPolicySignature (clojure.core/str v2026))))
   (clojure.core/let
    [v2026 (:bucket m2025 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2026 :com.palletops.awaze.client-builder/undef)
     (. bean2024 setBucket (clojure.core/str v2026))))
   (clojure.core/let
    [v2026 (:prefix m2025 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2026 :com.palletops.awaze.client-builder/undef)
     (. bean2024 setPrefix (clojure.core/str v2026))))
   bean2024))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.LaunchPermission}
launch-permission
  [m2028]
  (clojure.core/let
   [bean2027 (new com.amazonaws.services.ec2.model.LaunchPermission)]
   (clojure.core/let
    [v2029 (:group m2028 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2029 :com.palletops.awaze.client-builder/undef)
     (. bean2027 setGroup (clojure.core/str v2029))))
   (clojure.core/let
    [v2029 (:user-id m2028 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2029 :com.palletops.awaze.client-builder/undef)
     (. bean2027 setUserId (clojure.core/str v2029))))
   bean2027))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ScheduledInstancesIamInstanceProfile}
scheduled-instances-iam-instance-profile
  [m2031]
  (clojure.core/let
   [bean2030
    (new
     com.amazonaws.services.ec2.model.ScheduledInstancesIamInstanceProfile)]
   (clojure.core/let
    [v2032 (:arn m2031 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2032 :com.palletops.awaze.client-builder/undef)
     (. bean2030 setArn (clojure.core/str v2032))))
   (clojure.core/let
    [v2032 (:name m2031 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2032 :com.palletops.awaze.client-builder/undef)
     (. bean2030 setName (clojure.core/str v2032))))
   bean2030))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ScheduledInstancesPlacement}
scheduled-instances-placement
  [m2034]
  (clojure.core/let
   [bean2033
    (new com.amazonaws.services.ec2.model.ScheduledInstancesPlacement)]
   (clojure.core/let
    [v2035
     (:availability-zone
      m2034
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2035 :com.palletops.awaze.client-builder/undef)
     (. bean2033 setAvailabilityZone (clojure.core/str v2035))))
   (clojure.core/let
    [v2035
     (:group-name m2034 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2035 :com.palletops.awaze.client-builder/undef)
     (. bean2033 setGroupName (clojure.core/str v2035))))
   bean2033))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ScheduledInstancesMonitoring}
scheduled-instances-monitoring
  [m2037]
  (clojure.core/let
   [bean2036
    (new
     com.amazonaws.services.ec2.model.ScheduledInstancesMonitoring)]
   (clojure.core/let
    [v2038 (:enabled m2037 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2038 :com.palletops.awaze.client-builder/undef)
     (. bean2036 setEnabled (clojure.core/boolean v2038))))
   bean2036))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ScheduledInstancesBlockDeviceMapping}
scheduled-instances-block-device-mapping
  [m2040]
  (clojure.core/let
   [bean2039
    (new
     com.amazonaws.services.ec2.model.ScheduledInstancesBlockDeviceMapping)]
   (clojure.core/let
    [v2041
     (:device-name m2040 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2041 :com.palletops.awaze.client-builder/undef)
     (. bean2039 setDeviceName (clojure.core/str v2041))))
   (clojure.core/let
    [v2041 (:ebs m2040 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2041 :com.palletops.awaze.client-builder/undef)
     (. bean2039 setEbs (ec2/scheduled-instances-ebs v2041))))
   (clojure.core/let
    [v2041
     (:virtual-name m2040 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2041 :com.palletops.awaze.client-builder/undef)
     (. bean2039 setVirtualName (clojure.core/str v2041))))
   (clojure.core/let
    [v2041
     (:no-device m2040 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2041 :com.palletops.awaze.client-builder/undef)
     (. bean2039 setNoDevice (clojure.core/str v2041))))
   bean2039))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ScheduledInstancesNetworkInterface}
scheduled-instances-network-interface
  [m2043]
  (clojure.core/let
   [bean2042
    (new
     com.amazonaws.services.ec2.model.ScheduledInstancesNetworkInterface)]
   (clojure.core/let
    [v2044
     (:description m2043 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2044 :com.palletops.awaze.client-builder/undef)
     (. bean2042 setDescription (clojure.core/str v2044))))
   (clojure.core/let
    [v2044
     (:subnet-id m2043 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2044 :com.palletops.awaze.client-builder/undef)
     (. bean2042 setSubnetId (clojure.core/str v2044))))
   (clojure.core/let
    [v2044
     (:secondary-private-ip-address-count
      m2043
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2044 :com.palletops.awaze.client-builder/undef)
     (.
      bean2042
      setSecondaryPrivateIpAddressCount
      (clojure.core/int v2044))))
   (clojure.core/let
    [v2044
     (:device-index m2043 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2044 :com.palletops.awaze.client-builder/undef)
     (. bean2042 setDeviceIndex (clojure.core/int v2044))))
   (clojure.core/let
    [v2044
     (:private-ip-address
      m2043
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2044 :com.palletops.awaze.client-builder/undef)
     (. bean2042 setPrivateIpAddress (clojure.core/str v2044))))
   (clojure.core/let
    [v2044
     (:private-ip-address-configs
      m2043
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2044 :com.palletops.awaze.client-builder/undef)
     (.
      bean2042
      setPrivateIpAddressConfigs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg2785]
  (ec2/scheduled-instances-private-ip-address-config arg2785))
 v2044))))
   (clojure.core/let
    [v2044 (:groups m2043 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2044 :com.palletops.awaze.client-builder/undef)
     (.
      bean2042
      setGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2786] (clojure.core/str arg2786))
 v2044))))
   (clojure.core/let
    [v2044
     (:network-interface-id
      m2043
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2044 :com.palletops.awaze.client-builder/undef)
     (. bean2042 setNetworkInterfaceId (clojure.core/str v2044))))
   (clojure.core/let
    [v2044
     (:associate-public-ip-address
      m2043
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2044 :com.palletops.awaze.client-builder/undef)
     (.
      bean2042
      setAssociatePublicIpAddress
      (clojure.core/boolean v2044))))
   (clojure.core/let
    [v2044
     (:delete-on-termination
      m2043
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2044 :com.palletops.awaze.client-builder/undef)
     (. bean2042 setDeleteOnTermination (clojure.core/boolean v2044))))
   bean2042))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.InstanceType}
instance-type
  [m2046]
  (.
   com.amazonaws.services.ec2.model.InstanceType
   fromValue
   (clojure.core/name m2046)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.PriceScheduleSpecification}
price-schedule-specification
  [m2049]
  (clojure.core/let
   [bean2048
    (new com.amazonaws.services.ec2.model.PriceScheduleSpecification)]
   (clojure.core/let
    [v2050 (:price m2049 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2050 :com.palletops.awaze.client-builder/undef)
     (. bean2048 setPrice (clojure.core/double v2050))))
   (clojure.core/let
    [v2050 (:term m2049 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2050 :com.palletops.awaze.client-builder/undef)
     (. bean2048 setTerm (clojure.core/long v2050))))
   (clojure.core/let
    [v2050
     (:currency-code m2049 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2050 :com.palletops.awaze.client-builder/undef)
     (. bean2048 setCurrencyCode (ec2/currency-code-values v2050))))
   bean2048))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.IpPermission}
ip-permission
  [m2052]
  (clojure.core/let
   [bean2051 (new com.amazonaws.services.ec2.model.IpPermission)]
   (clojure.core/let
    [v2053
     (:user-id-group-pairs
      m2052
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2053 :com.palletops.awaze.client-builder/undef)
     (.
      bean2051
      setUserIdGroupPairs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2787] (ec2/user-id-group-pair arg2787))
 v2053))))
   (clojure.core/let
    [v2053
     (:ip-ranges m2052 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2053 :com.palletops.awaze.client-builder/undef)
     (.
      bean2051
      setIpRanges
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2788] (clojure.core/str arg2788))
 v2053))))
   (clojure.core/let
    [v2053
     (:ip-protocol m2052 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2053 :com.palletops.awaze.client-builder/undef)
     (. bean2051 setIpProtocol (clojure.core/str v2053))))
   (clojure.core/let
    [v2053
     (:from-port m2052 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2053 :com.palletops.awaze.client-builder/undef)
     (. bean2051 setFromPort (clojure.core/int v2053))))
   (clojure.core/let
    [v2053 (:to-port m2052 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2053 :com.palletops.awaze.client-builder/undef)
     (. bean2051 setToPort (clojure.core/int v2053))))
   (clojure.core/let
    [v2053
     (:prefix-list-ids
      m2052
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2053 :com.palletops.awaze.client-builder/undef)
     (.
      bean2051
      setPrefixListIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2789] (ec2/prefix-list-id arg2789))
 v2053))))
   bean2051))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.InstanceBlockDeviceMappingSpecification}
instance-block-device-mapping-specification
  [m2055]
  (clojure.core/let
   [bean2054
    (new
     com.amazonaws.services.ec2.model.InstanceBlockDeviceMappingSpecification)]
   (clojure.core/let
    [v2056
     (:device-name m2055 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2056 :com.palletops.awaze.client-builder/undef)
     (. bean2054 setDeviceName (clojure.core/str v2056))))
   (clojure.core/let
    [v2056 (:ebs m2055 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2056 :com.palletops.awaze.client-builder/undef)
     (.
      bean2054
      setEbs
      (ec2/ebs-instance-block-device-specification v2056))))
   (clojure.core/let
    [v2056
     (:virtual-name m2055 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2056 :com.palletops.awaze.client-builder/undef)
     (. bean2054 setVirtualName (clojure.core/str v2056))))
   (clojure.core/let
    [v2056
     (:no-device m2055 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2056 :com.palletops.awaze.client-builder/undef)
     (. bean2054 setNoDevice (clojure.core/str v2056))))
   bean2054))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.Filter}
filter
  [m2058]
  (clojure.core/let
   [bean2057 (new com.amazonaws.services.ec2.model.Filter)]
   (clojure.core/let
    [v2059 (:values m2058 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2059 :com.palletops.awaze.client-builder/undef)
     (.
      bean2057
      setValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2790] (clojure.core/str arg2790))
 v2059))))
   (clojure.core/let
    [v2059 (:name m2058 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2059 :com.palletops.awaze.client-builder/undef)
     (. bean2057 setName (clojure.core/str v2059))))
   bean2057))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReportStatusType}
report-status-type
  [m2061]
  (.
   com.amazonaws.services.ec2.model.ReportStatusType
   fromValue
   (clojure.core/name m2061)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ArchitectureValues}
architecture-values
  [m2064]
  (.
   com.amazonaws.services.ec2.model.ArchitectureValues
   fromValue
   (clojure.core/name m2064)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.SlotStartTimeRangeRequest}
slot-start-time-range-request
  [m2067]
  (clojure.core/let
   [bean2066
    (new com.amazonaws.services.ec2.model.SlotStartTimeRangeRequest)]
   (clojure.core/let
    [v2068
     (:earliest-time m2067 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2068 :com.palletops.awaze.client-builder/undef)
     (.
      bean2066
      setEarliestTime
      (com.palletops.awaze.common/to-date v2068))))
   (clojure.core/let
    [v2068
     (:latest-time m2067 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2068 :com.palletops.awaze.client-builder/undef)
     (.
      bean2066
      setLatestTime
      (com.palletops.awaze.common/to-date v2068))))
   bean2066))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.IcmpTypeCode}
icmp-type-code
  [m2070]
  (clojure.core/let
   [bean2069 (new com.amazonaws.services.ec2.model.IcmpTypeCode)]
   (clojure.core/let
    [v2071 (:code m2070 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2071 :com.palletops.awaze.client-builder/undef)
     (. bean2069 setCode (clojure.core/int v2071))))
   (clojure.core/let
    [v2071 (:type m2070 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2071 :com.palletops.awaze.client-builder/undef)
     (. bean2069 setType (clojure.core/int v2071))))
   bean2069))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.PortRange}
port-range
  [m2073]
  (clojure.core/let
   [bean2072 (new com.amazonaws.services.ec2.model.PortRange)]
   (clojure.core/let
    [v2074 (:from m2073 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2074 :com.palletops.awaze.client-builder/undef)
     (. bean2072 setFrom (clojure.core/int v2074))))
   (clojure.core/let
    [v2074 (:to m2073 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2074 :com.palletops.awaze.client-builder/undef)
     (. bean2072 setTo (clojure.core/int v2074))))
   bean2072))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ImportInstanceLaunchSpecification}
import-instance-launch-specification
  [m2076]
  (clojure.core/let
   [bean2075
    (new
     com.amazonaws.services.ec2.model.ImportInstanceLaunchSpecification)]
   (clojure.core/let
    [v2077
     (:group-ids m2076 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2077 :com.palletops.awaze.client-builder/undef)
     (.
      bean2075
      setGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2791] (clojure.core/str arg2791))
 v2077))))
   (clojure.core/let
    [v2077
     (:subnet-id m2076 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2077 :com.palletops.awaze.client-builder/undef)
     (. bean2075 setSubnetId (clojure.core/str v2077))))
   (clojure.core/let
    [v2077
     (:additional-info
      m2076
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2077 :com.palletops.awaze.client-builder/undef)
     (. bean2075 setAdditionalInfo (clojure.core/str v2077))))
   (clojure.core/let
    [v2077
     (:placement m2076 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2077 :com.palletops.awaze.client-builder/undef)
     (. bean2075 setPlacement (ec2/placement v2077))))
   (clojure.core/let
    [v2077
     (:group-names m2076 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2077 :com.palletops.awaze.client-builder/undef)
     (.
      bean2075
      setGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2792] (clojure.core/str arg2792))
 v2077))))
   (clojure.core/let
    [v2077
     (:private-ip-address
      m2076
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2077 :com.palletops.awaze.client-builder/undef)
     (. bean2075 setPrivateIpAddress (clojure.core/str v2077))))
   (clojure.core/let
    [v2077
     (:instance-type m2076 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2077 :com.palletops.awaze.client-builder/undef)
     (. bean2075 setInstanceType (clojure.core/str v2077))))
   (clojure.core/let
    [v2077
     (:instance-initiated-shutdown-behavior
      m2076
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2077 :com.palletops.awaze.client-builder/undef)
     (.
      bean2075
      setInstanceInitiatedShutdownBehavior
      (ec2/shutdown-behavior v2077))))
   (clojure.core/let
    [v2077
     (:monitoring m2076 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2077 :com.palletops.awaze.client-builder/undef)
     (. bean2075 setMonitoring (clojure.core/boolean v2077))))
   (clojure.core/let
    [v2077
     (:architecture m2076 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2077 :com.palletops.awaze.client-builder/undef)
     (. bean2075 setArchitecture (clojure.core/str v2077))))
   (clojure.core/let
    [v2077
     (:user-data m2076 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2077 :com.palletops.awaze.client-builder/undef)
     (. bean2075 setUserData (ec2/user-data v2077))))
   bean2075))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DiskImage}
disk-image
  [m2079]
  (clojure.core/let
   [bean2078 (new com.amazonaws.services.ec2.model.DiskImage)]
   (clojure.core/let
    [v2080
     (:description m2079 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2080 :com.palletops.awaze.client-builder/undef)
     (. bean2078 setDescription (clojure.core/str v2080))))
   (clojure.core/let
    [v2080 (:image m2079 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2080 :com.palletops.awaze.client-builder/undef)
     (. bean2078 setImage (ec2/disk-image-detail v2080))))
   (clojure.core/let
    [v2080 (:volume m2079 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2080 :com.palletops.awaze.client-builder/undef)
     (. bean2078 setVolume (ec2/volume-detail v2080))))
   bean2078))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.PlatformValues}
platform-values
  [m2082]
  (.
   com.amazonaws.services.ec2.model.PlatformValues
   fromValue
   (clojure.core/name m2082)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.SnapshotAttributeName}
snapshot-attribute-name
  [m2085]
  (.
   com.amazonaws.services.ec2.model.SnapshotAttributeName
   fromValue
   (clojure.core/name m2085)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVolumePermissionModifications}
create-volume-permission-modifications
  [m2088]
  (clojure.core/let
   [bean2087
    (new
     com.amazonaws.services.ec2.model.CreateVolumePermissionModifications)]
   (clojure.core/let
    [v2089 (:add m2088 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2089 :com.palletops.awaze.client-builder/undef)
     (.
      bean2087
      setAdd
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2793] (ec2/create-volume-permission arg2793))
 v2089))))
   (clojure.core/let
    [v2089 (:remove m2088 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2089 :com.palletops.awaze.client-builder/undef)
     (.
      bean2087
      setRemove
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2794] (ec2/create-volume-permission arg2794))
 v2089))))
   bean2087))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.SpotFleetRequestConfigData}
spot-fleet-request-config-data
  [m2091]
  (clojure.core/let
   [bean2090
    (new com.amazonaws.services.ec2.model.SpotFleetRequestConfigData)]
   (clojure.core/let
    [v2092
     (:iam-fleet-role m2091 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2092 :com.palletops.awaze.client-builder/undef)
     (. bean2090 setIamFleetRole (clojure.core/str v2092))))
   (clojure.core/let
    [v2092
     (:spot-price m2091 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2092 :com.palletops.awaze.client-builder/undef)
     (. bean2090 setSpotPrice (clojure.core/str v2092))))
   (clojure.core/let
    [v2092
     (:launch-specifications
      m2091
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2092 :com.palletops.awaze.client-builder/undef)
     (.
      bean2090
      setLaunchSpecifications
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg2795]
  (ec2/spot-fleet-launch-specification arg2795))
 v2092))))
   (clojure.core/let
    [v2092
     (:valid-from m2091 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2092 :com.palletops.awaze.client-builder/undef)
     (.
      bean2090
      setValidFrom
      (com.palletops.awaze.common/to-date v2092))))
   (clojure.core/let
    [v2092
     (:client-token m2091 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2092 :com.palletops.awaze.client-builder/undef)
     (. bean2090 setClientToken (clojure.core/str v2092))))
   (clojure.core/let
    [v2092
     (:allocation-strategy
      m2091
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2092 :com.palletops.awaze.client-builder/undef)
     (.
      bean2090
      setAllocationStrategy
      (ec2/allocation-strategy v2092))))
   (clojure.core/let
    [v2092
     (:terminate-instances-with-expiration
      m2091
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2092 :com.palletops.awaze.client-builder/undef)
     (.
      bean2090
      setTerminateInstancesWithExpiration
      (clojure.core/boolean v2092))))
   (clojure.core/let
    [v2092
     (:target-capacity
      m2091
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2092 :com.palletops.awaze.client-builder/undef)
     (. bean2090 setTargetCapacity (clojure.core/int v2092))))
   (clojure.core/let
    [v2092
     (:valid-until m2091 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2092 :com.palletops.awaze.client-builder/undef)
     (.
      bean2090
      setValidUntil
      (com.palletops.awaze.common/to-date v2092))))
   (clojure.core/let
    [v2092
     (:excess-capacity-termination-policy
      m2091
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2092 :com.palletops.awaze.client-builder/undef)
     (.
      bean2090
      setExcessCapacityTerminationPolicy
      (ec2/excess-capacity-termination-policy v2092))))
   bean2090))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ExportEnvironment}
export-environment
  [m2094]
  (.
   com.amazonaws.services.ec2.model.ExportEnvironment
   fromValue
   (clojure.core/name m2094)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ExportToS3TaskSpecification}
export-to-s3task-specification
  [m2097]
  (clojure.core/let
   [bean2096
    (new com.amazonaws.services.ec2.model.ExportToS3TaskSpecification)]
   (clojure.core/let
    [v2098
     (:disk-image-format
      m2097
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2098 :com.palletops.awaze.client-builder/undef)
     (. bean2096 setDiskImageFormat (ec2/disk-image-format v2098))))
   (clojure.core/let
    [v2098
     (:container-format
      m2097
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2098 :com.palletops.awaze.client-builder/undef)
     (. bean2096 setContainerFormat (clojure.core/str v2098))))
   (clojure.core/let
    [v2098
     (:s3bucket m2097 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2098 :com.palletops.awaze.client-builder/undef)
     (. bean2096 setS3Bucket (clojure.core/str v2098))))
   (clojure.core/let
    [v2098
     (:s3prefix m2097 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2098 :com.palletops.awaze.client-builder/undef)
     (. bean2096 setS3Prefix (clojure.core/str v2098))))
   bean2096))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.PurchaseRequest}
purchase-request
  [m2100]
  (clojure.core/let
   [bean2099 (new com.amazonaws.services.ec2.model.PurchaseRequest)]
   (clojure.core/let
    [v2101
     (:purchase-token m2100 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2101 :com.palletops.awaze.client-builder/undef)
     (. bean2099 setPurchaseToken (clojure.core/str v2101))))
   (clojure.core/let
    [v2101
     (:instance-count m2100 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2101 :com.palletops.awaze.client-builder/undef)
     (. bean2099 setInstanceCount (clojure.core/int v2101))))
   bean2099))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReservedInstanceLimitPrice}
reserved-instance-limit-price
  [m2103]
  (clojure.core/let
   [bean2102
    (new com.amazonaws.services.ec2.model.ReservedInstanceLimitPrice)]
   (clojure.core/let
    [v2104 (:amount m2103 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2104 :com.palletops.awaze.client-builder/undef)
     (. bean2102 setAmount (clojure.core/double v2104))))
   (clojure.core/let
    [v2104
     (:currency-code m2103 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2104 :com.palletops.awaze.client-builder/undef)
     (. bean2102 setCurrencyCode (clojure.core/str v2104))))
   bean2102))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DhcpConfiguration}
dhcp-configuration
  [m2106]
  (clojure.core/let
   [bean2105 (new com.amazonaws.services.ec2.model.DhcpConfiguration)]
   (clojure.core/let
    [v2107 (:values m2106 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2107 :com.palletops.awaze.client-builder/undef)
     (.
      bean2105
      setValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2796] (clojure.core/str arg2796))
 v2107))))
   (clojure.core/let
    [v2107 (:key m2106 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2107 :com.palletops.awaze.client-builder/undef)
     (. bean2105 setKey (clojure.core/str v2107))))
   bean2105))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.SpotInstanceType}
spot-instance-type
  [m2109]
  (.
   com.amazonaws.services.ec2.model.SpotInstanceType
   fromValue
   (clojure.core/name m2109)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.LaunchSpecification}
launch-specification
  [m2112]
  (clojure.core/let
   [bean2111
    (new com.amazonaws.services.ec2.model.LaunchSpecification)]
   (clojure.core/let
    [v2113
     (:iam-instance-profile
      m2112
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2113 :com.palletops.awaze.client-builder/undef)
     (.
      bean2111
      setIamInstanceProfile
      (ec2/iam-instance-profile-specification v2113))))
   (clojure.core/let
    [v2113
     (:subnet-id m2112 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2113 :com.palletops.awaze.client-builder/undef)
     (. bean2111 setSubnetId (clojure.core/str v2113))))
   (clojure.core/let
    [v2113
     (:placement m2112 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2113 :com.palletops.awaze.client-builder/undef)
     (. bean2111 setPlacement (ec2/spot-placement v2113))))
   (clojure.core/let
    [v2113
     (:addressing-type
      m2112
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2113 :com.palletops.awaze.client-builder/undef)
     (. bean2111 setAddressingType (clojure.core/str v2113))))
   (clojure.core/let
    [v2113
     (:instance-type m2112 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2113 :com.palletops.awaze.client-builder/undef)
     (. bean2111 setInstanceType (clojure.core/str v2113))))
   (clojure.core/let
    [v2113
     (:ebs-optimized m2112 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2113 :com.palletops.awaze.client-builder/undef)
     (. bean2111 setEbsOptimized (clojure.core/boolean v2113))))
   (clojure.core/let
    [v2113
     (:ramdisk-id m2112 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2113 :com.palletops.awaze.client-builder/undef)
     (. bean2111 setRamdiskId (clojure.core/str v2113))))
   (clojure.core/let
    [v2113
     (:all-security-groups
      m2112
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2113 :com.palletops.awaze.client-builder/undef)
     (.
      bean2111
      setAllSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2797] (ec2/group-identifier arg2797))
 v2113))))
   (clojure.core/let
    [v2113
     (:image-id m2112 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2113 :com.palletops.awaze.client-builder/undef)
     (. bean2111 setImageId (clojure.core/str v2113))))
   (clojure.core/let
    [v2113
     (:key-name m2112 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2113 :com.palletops.awaze.client-builder/undef)
     (. bean2111 setKeyName (clojure.core/str v2113))))
   (clojure.core/let
    [v2113
     (:monitoring-enabled
      m2112
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2113 :com.palletops.awaze.client-builder/undef)
     (. bean2111 setMonitoringEnabled (clojure.core/boolean v2113))))
   (clojure.core/let
    [v2113
     (:kernel-id m2112 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2113 :com.palletops.awaze.client-builder/undef)
     (. bean2111 setKernelId (clojure.core/str v2113))))
   (clojure.core/let
    [v2113
     (:security-groups
      m2112
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2113 :com.palletops.awaze.client-builder/undef)
     (.
      bean2111
      setSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2798] (clojure.core/str arg2798))
 v2113))))
   (clojure.core/let
    [v2113
     (:block-device-mappings
      m2112
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2113 :com.palletops.awaze.client-builder/undef)
     (.
      bean2111
      setBlockDeviceMappings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2799] (ec2/block-device-mapping arg2799))
 v2113))))
   (clojure.core/let
    [v2113
     (:user-data m2112 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2113 :com.palletops.awaze.client-builder/undef)
     (. bean2111 setUserData (clojure.core/str v2113))))
   (clojure.core/let
    [v2113
     (:network-interfaces
      m2112
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2113 :com.palletops.awaze.client-builder/undef)
     (.
      bean2111
      setNetworkInterfaces
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg2800]
  (ec2/instance-network-interface-specification arg2800))
 v2113))))
   bean2111))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.SnapshotDiskContainer}
snapshot-disk-container
  [m2115]
  (clojure.core/let
   [bean2114
    (new com.amazonaws.services.ec2.model.SnapshotDiskContainer)]
   (clojure.core/let
    [v2116 (:format m2115 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2116 :com.palletops.awaze.client-builder/undef)
     (. bean2114 setFormat (clojure.core/str v2116))))
   (clojure.core/let
    [v2116 (:url m2115 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2116 :com.palletops.awaze.client-builder/undef)
     (. bean2114 setUrl (clojure.core/str v2116))))
   (clojure.core/let
    [v2116
     (:user-bucket m2115 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2116 :com.palletops.awaze.client-builder/undef)
     (. bean2114 setUserBucket (ec2/user-bucket v2116))))
   (clojure.core/let
    [v2116
     (:description m2115 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2116 :com.palletops.awaze.client-builder/undef)
     (. bean2114 setDescription (clojure.core/str v2116))))
   bean2114))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ClientData}
client-data
  [m2118]
  (clojure.core/let
   [bean2117 (new com.amazonaws.services.ec2.model.ClientData)]
   (clojure.core/let
    [v2119 (:comment m2118 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2119 :com.palletops.awaze.client-builder/undef)
     (. bean2117 setComment (clojure.core/str v2119))))
   (clojure.core/let
    [v2119
     (:upload-start m2118 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2119 :com.palletops.awaze.client-builder/undef)
     (.
      bean2117
      setUploadStart
      (com.palletops.awaze.common/to-date v2119))))
   (clojure.core/let
    [v2119
     (:upload-end m2118 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2119 :com.palletops.awaze.client-builder/undef)
     (.
      bean2117
      setUploadEnd
      (com.palletops.awaze.common/to-date v2119))))
   (clojure.core/let
    [v2119
     (:upload-size m2118 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2119 :com.palletops.awaze.client-builder/undef)
     (. bean2117 setUploadSize (clojure.core/double v2119))))
   bean2117))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.Tag}
tag
  [m2121]
  (clojure.core/let
   [bean2120 (new com.amazonaws.services.ec2.model.Tag)]
   (clojure.core/let
    [v2122 (:key m2121 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2122 :com.palletops.awaze.client-builder/undef)
     (. bean2120 setKey (clojure.core/str v2122))))
   (clojure.core/let
    [v2122 (:value m2121 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2122 :com.palletops.awaze.client-builder/undef)
     (. bean2120 setValue (clojure.core/str v2122))))
   bean2120))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.OfferingTypeValues}
offering-type-values
  [m2124]
  (.
   com.amazonaws.services.ec2.model.OfferingTypeValues
   fromValue
   (clojure.core/name m2124)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.Tenancy}
tenancy
  [m2127]
  (.
   com.amazonaws.services.ec2.model.Tenancy
   fromValue
   (clojure.core/name m2127)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.TrafficType}
traffic-type
  [m2130]
  (.
   com.amazonaws.services.ec2.model.TrafficType
   fromValue
   (clojure.core/name m2130)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.Storage}
storage
  [m2133]
  (clojure.core/let
   [bean2132 (new com.amazonaws.services.ec2.model.Storage)]
   (clojure.core/let
    [v2134 (:s3 m2133 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2134 :com.palletops.awaze.client-builder/undef)
     (. bean2132 setS3 (ec2/s3storage v2134))))
   bean2132))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.EventType}
event-type
  [m2136]
  (.
   com.amazonaws.services.ec2.model.EventType
   fromValue
   (clojure.core/name m2136)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.NetworkInterfaceAttribute}
network-interface-attribute
  [m2139]
  (.
   com.amazonaws.services.ec2.model.NetworkInterfaceAttribute
   fromValue
   (clojure.core/name m2139)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.HostTenancy}
host-tenancy
  [m2142]
  (.
   com.amazonaws.services.ec2.model.HostTenancy
   fromValue
   (clojure.core/name m2142)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.OperationType}
operation-type
  [m2145]
  (.
   com.amazonaws.services.ec2.model.OperationType
   fromValue
   (clojure.core/name m2145)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.LaunchPermissionModifications}
launch-permission-modifications
  [m2148]
  (clojure.core/let
   [bean2147
    (new
     com.amazonaws.services.ec2.model.LaunchPermissionModifications)]
   (clojure.core/let
    [v2149 (:add m2148 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2149 :com.palletops.awaze.client-builder/undef)
     (.
      bean2147
      setAdd
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2801] (ec2/launch-permission arg2801))
 v2149))))
   (clojure.core/let
    [v2149 (:remove m2148 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2149 :com.palletops.awaze.client-builder/undef)
     (.
      bean2147
      setRemove
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2802] (ec2/launch-permission arg2802))
 v2149))))
   bean2147))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AutoPlacement}
auto-placement
  [m2151]
  (.
   com.amazonaws.services.ec2.model.AutoPlacement
   fromValue
   (clojure.core/name m2151)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.VpnConnectionOptionsSpecification}
vpn-connection-options-specification
  [m2154]
  (clojure.core/let
   [bean2153
    (new
     com.amazonaws.services.ec2.model.VpnConnectionOptionsSpecification)]
   (clojure.core/let
    [v2155
     (:static-routes-only
      m2154
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2155 :com.palletops.awaze.client-builder/undef)
     (. bean2153 setStaticRoutesOnly (clojure.core/boolean v2155))))
   bean2153))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ScheduledInstanceRecurrenceRequest}
scheduled-instance-recurrence-request
  [m2157]
  (clojure.core/let
   [bean2156
    (new
     com.amazonaws.services.ec2.model.ScheduledInstanceRecurrenceRequest)]
   (clojure.core/let
    [v2158
     (:frequency m2157 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2158 :com.palletops.awaze.client-builder/undef)
     (. bean2156 setFrequency (clojure.core/str v2158))))
   (clojure.core/let
    [v2158
     (:interval m2157 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2158 :com.palletops.awaze.client-builder/undef)
     (. bean2156 setInterval (clojure.core/int v2158))))
   (clojure.core/let
    [v2158
     (:occurrence-days
      m2157
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2158 :com.palletops.awaze.client-builder/undef)
     (.
      bean2156
      setOccurrenceDays
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2803] (clojure.core/int arg2803))
 v2158))))
   (clojure.core/let
    [v2158
     (:occurrence-relative-to-end
      m2157
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2158 :com.palletops.awaze.client-builder/undef)
     (.
      bean2156
      setOccurrenceRelativeToEnd
      (clojure.core/boolean v2158))))
   (clojure.core/let
    [v2158
     (:occurrence-unit
      m2157
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2158 :com.palletops.awaze.client-builder/undef)
     (. bean2156 setOccurrenceUnit (clojure.core/str v2158))))
   bean2156))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.SlotDateTimeRangeRequest}
slot-date-time-range-request
  [m2160]
  (clojure.core/let
   [bean2159
    (new com.amazonaws.services.ec2.model.SlotDateTimeRangeRequest)]
   (clojure.core/let
    [v2161
     (:earliest-time m2160 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2161 :com.palletops.awaze.client-builder/undef)
     (.
      bean2159
      setEarliestTime
      (com.palletops.awaze.common/to-date v2161))))
   (clojure.core/let
    [v2161
     (:latest-time m2160 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2161 :com.palletops.awaze.client-builder/undef)
     (.
      bean2159
      setLatestTime
      (com.palletops.awaze.common/to-date v2161))))
   bean2159))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.VpcAttributeName}
vpc-attribute-name
  [m2163]
  (.
   com.amazonaws.services.ec2.model.VpcAttributeName
   fromValue
   (clojure.core/name m2163)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ImageDiskContainer}
image-disk-container
  [m2166]
  (clojure.core/let
   [bean2165
    (new com.amazonaws.services.ec2.model.ImageDiskContainer)]
   (clojure.core/let
    [v2167 (:format m2166 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2167 :com.palletops.awaze.client-builder/undef)
     (. bean2165 setFormat (clojure.core/str v2167))))
   (clojure.core/let
    [v2167
     (:device-name m2166 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2167 :com.palletops.awaze.client-builder/undef)
     (. bean2165 setDeviceName (clojure.core/str v2167))))
   (clojure.core/let
    [v2167 (:url m2166 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2167 :com.palletops.awaze.client-builder/undef)
     (. bean2165 setUrl (clojure.core/str v2167))))
   (clojure.core/let
    [v2167
     (:user-bucket m2166 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2167 :com.palletops.awaze.client-builder/undef)
     (. bean2165 setUserBucket (ec2/user-bucket v2167))))
   (clojure.core/let
    [v2167
     (:description m2166 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2167 :com.palletops.awaze.client-builder/undef)
     (. bean2165 setDescription (clojure.core/str v2167))))
   (clojure.core/let
    [v2167
     (:snapshot-id m2166 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2167 :com.palletops.awaze.client-builder/undef)
     (. bean2165 setSnapshotId (clojure.core/str v2167))))
   bean2165))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.VolumeAttributeName}
volume-attribute-name
  [m2169]
  (.
   com.amazonaws.services.ec2.model.VolumeAttributeName
   fromValue
   (clojure.core/name m2169)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ScheduledInstancesLaunchSpecification}
scheduled-instances-launch-specification
  [m2172]
  (clojure.core/let
   [bean2171
    (new
     com.amazonaws.services.ec2.model.ScheduledInstancesLaunchSpecification)]
   (clojure.core/let
    [v2173
     (:iam-instance-profile
      m2172
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2173 :com.palletops.awaze.client-builder/undef)
     (.
      bean2171
      setIamInstanceProfile
      (ec2/scheduled-instances-iam-instance-profile v2173))))
   (clojure.core/let
    [v2173
     (:subnet-id m2172 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2173 :com.palletops.awaze.client-builder/undef)
     (. bean2171 setSubnetId (clojure.core/str v2173))))
   (clojure.core/let
    [v2173
     (:security-group-ids
      m2172
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2173 :com.palletops.awaze.client-builder/undef)
     (.
      bean2171
      setSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2804] (clojure.core/str arg2804))
 v2173))))
   (clojure.core/let
    [v2173
     (:placement m2172 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2173 :com.palletops.awaze.client-builder/undef)
     (.
      bean2171
      setPlacement
      (ec2/scheduled-instances-placement v2173))))
   (clojure.core/let
    [v2173
     (:instance-type m2172 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2173 :com.palletops.awaze.client-builder/undef)
     (. bean2171 setInstanceType (clojure.core/str v2173))))
   (clojure.core/let
    [v2173
     (:ebs-optimized m2172 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2173 :com.palletops.awaze.client-builder/undef)
     (. bean2171 setEbsOptimized (clojure.core/boolean v2173))))
   (clojure.core/let
    [v2173
     (:ramdisk-id m2172 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2173 :com.palletops.awaze.client-builder/undef)
     (. bean2171 setRamdiskId (clojure.core/str v2173))))
   (clojure.core/let
    [v2173
     (:image-id m2172 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2173 :com.palletops.awaze.client-builder/undef)
     (. bean2171 setImageId (clojure.core/str v2173))))
   (clojure.core/let
    [v2173
     (:key-name m2172 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2173 :com.palletops.awaze.client-builder/undef)
     (. bean2171 setKeyName (clojure.core/str v2173))))
   (clojure.core/let
    [v2173
     (:kernel-id m2172 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2173 :com.palletops.awaze.client-builder/undef)
     (. bean2171 setKernelId (clojure.core/str v2173))))
   (clojure.core/let
    [v2173
     (:monitoring m2172 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2173 :com.palletops.awaze.client-builder/undef)
     (.
      bean2171
      setMonitoring
      (ec2/scheduled-instances-monitoring v2173))))
   (clojure.core/let
    [v2173
     (:block-device-mappings
      m2172
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2173 :com.palletops.awaze.client-builder/undef)
     (.
      bean2171
      setBlockDeviceMappings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg2805]
  (ec2/scheduled-instances-block-device-mapping arg2805))
 v2173))))
   (clojure.core/let
    [v2173
     (:user-data m2172 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2173 :com.palletops.awaze.client-builder/undef)
     (. bean2171 setUserData (clojure.core/str v2173))))
   (clojure.core/let
    [v2173
     (:network-interfaces
      m2172
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2173 :com.palletops.awaze.client-builder/undef)
     (.
      bean2171
      setNetworkInterfaces
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg2806]
  (ec2/scheduled-instances-network-interface arg2806))
 v2173))))
   bean2171))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReservedInstancesConfiguration}
reserved-instances-configuration
  [m2175]
  (clojure.core/let
   [bean2174
    (new
     com.amazonaws.services.ec2.model.ReservedInstancesConfiguration)]
   (clojure.core/let
    [v2176
     (:instance-type m2175 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2176 :com.palletops.awaze.client-builder/undef)
     (. bean2174 setInstanceType (ec2/instance-type v2176))))
   (clojure.core/let
    [v2176
     (:availability-zone
      m2175
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2176 :com.palletops.awaze.client-builder/undef)
     (. bean2174 setAvailabilityZone (clojure.core/str v2176))))
   (clojure.core/let
    [v2176
     (:instance-count m2175 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2176 :com.palletops.awaze.client-builder/undef)
     (. bean2174 setInstanceCount (clojure.core/int v2176))))
   (clojure.core/let
    [v2176
     (:platform m2175 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2176 :com.palletops.awaze.client-builder/undef)
     (. bean2174 setPlatform (clojure.core/str v2176))))
   bean2174))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.NetworkInterfaceAttachmentChanges}
network-interface-attachment-changes
  [m2178]
  (clojure.core/let
   [bean2177
    (new
     com.amazonaws.services.ec2.model.NetworkInterfaceAttachmentChanges)]
   (clojure.core/let
    [v2179
     (:delete-on-termination
      m2178
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2179 :com.palletops.awaze.client-builder/undef)
     (. bean2177 setDeleteOnTermination (clojure.core/boolean v2179))))
   (clojure.core/let
    [v2179
     (:attachment-id m2178 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2179 :com.palletops.awaze.client-builder/undef)
     (. bean2177 setAttachmentId (clojure.core/str v2179))))
   bean2177))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteVpcEndpointsRequest}
delete-vpc-endpoints-request
  [m2181]
  (clojure.core/let
   [bean2180
    (new com.amazonaws.services.ec2.model.DeleteVpcEndpointsRequest)]
   (clojure.core/let
    [v2182
     (:vpc-endpoint-ids
      m2181
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2182 :com.palletops.awaze.client-builder/undef)
     (.
      bean2180
      setVpcEndpointIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2807] (clojure.core/str arg2807))
 v2182))))
   bean2180))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateNatGatewayRequest}
create-nat-gateway-request
  [m2184]
  (clojure.core/let
   [bean2183
    (new com.amazonaws.services.ec2.model.CreateNatGatewayRequest)]
   (clojure.core/let
    [v2185
     (:client-token m2184 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2185 :com.palletops.awaze.client-builder/undef)
     (. bean2183 setClientToken (clojure.core/str v2185))))
   (clojure.core/let
    [v2185
     (:subnet-id m2184 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2185 :com.palletops.awaze.client-builder/undef)
     (. bean2183 setSubnetId (clojure.core/str v2185))))
   (clojure.core/let
    [v2185
     (:allocation-id m2184 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2185 :com.palletops.awaze.client-builder/undef)
     (. bean2183 setAllocationId (clojure.core/str v2185))))
   bean2183))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.StopInstancesRequest}
stop-instances-request
  [m2187]
  (clojure.core/let
   [bean2186
    (new com.amazonaws.services.ec2.model.StopInstancesRequest)]
   (clojure.core/let
    [v2188
     (:instance-ids m2187 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2188 :com.palletops.awaze.client-builder/undef)
     (.
      bean2186
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2808] (clojure.core/str arg2808))
 v2188))))
   (clojure.core/let
    [v2188 (:force m2187 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2188 :com.palletops.awaze.client-builder/undef)
     (. bean2186 setForce (clojure.core/boolean v2188))))
   bean2186))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreatePlacementGroupRequest}
create-placement-group-request
  [m2190]
  (clojure.core/let
   [bean2189
    (new com.amazonaws.services.ec2.model.CreatePlacementGroupRequest)]
   (clojure.core/let
    [v2191
     (:group-name m2190 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2191 :com.palletops.awaze.client-builder/undef)
     (. bean2189 setGroupName (clojure.core/str v2191))))
   (clojure.core/let
    [v2191
     (:strategy m2190 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2191 :com.palletops.awaze.client-builder/undef)
     (. bean2189 setStrategy (clojure.core/str v2191))))
   bean2189))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateReservedInstancesListingRequest}
create-reserved-instances-listing-request
  [m2193]
  (clojure.core/let
   [bean2192
    (new
     com.amazonaws.services.ec2.model.CreateReservedInstancesListingRequest)]
   (clojure.core/let
    [v2194
     (:client-token m2193 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2194 :com.palletops.awaze.client-builder/undef)
     (. bean2192 setClientToken (clojure.core/str v2194))))
   (clojure.core/let
    [v2194
     (:instance-count m2193 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2194 :com.palletops.awaze.client-builder/undef)
     (. bean2192 setInstanceCount (clojure.core/int v2194))))
   (clojure.core/let
    [v2194
     (:reserved-instances-id
      m2193
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2194 :com.palletops.awaze.client-builder/undef)
     (. bean2192 setReservedInstancesId (clojure.core/str v2194))))
   (clojure.core/let
    [v2194
     (:price-schedules
      m2193
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2194 :com.palletops.awaze.client-builder/undef)
     (.
      bean2192
      setPriceSchedules
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg2809]
  (ec2/price-schedule-specification arg2809))
 v2194))))
   bean2192))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReleaseHostsRequest}
release-hosts-request
  [m2196]
  (clojure.core/let
   [bean2195
    (new com.amazonaws.services.ec2.model.ReleaseHostsRequest)]
   (clojure.core/let
    [v2197
     (:host-ids m2196 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2197 :com.palletops.awaze.client-builder/undef)
     (.
      bean2195
      setHostIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2810] (clojure.core/str arg2810))
 v2197))))
   bean2195))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RevokeSecurityGroupIngressRequest}
revoke-security-group-ingress-request
  [m2199]
  (clojure.core/let
   [bean2198
    (new
     com.amazonaws.services.ec2.model.RevokeSecurityGroupIngressRequest)]
   (clojure.core/let
    [v2200 (:cidr-ip m2199 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2200 :com.palletops.awaze.client-builder/undef)
     (. bean2198 setCidrIp (clojure.core/str v2200))))
   (clojure.core/let
    [v2200
     (:group-id m2199 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2200 :com.palletops.awaze.client-builder/undef)
     (. bean2198 setGroupId (clojure.core/str v2200))))
   (clojure.core/let
    [v2200 (:to-port m2199 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2200 :com.palletops.awaze.client-builder/undef)
     (. bean2198 setToPort (clojure.core/int v2200))))
   (clojure.core/let
    [v2200
     (:source-security-group-owner-id
      m2199
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2200 :com.palletops.awaze.client-builder/undef)
     (.
      bean2198
      setSourceSecurityGroupOwnerId
      (clojure.core/str v2200))))
   (clojure.core/let
    [v2200
     (:ip-permissions m2199 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2200 :com.palletops.awaze.client-builder/undef)
     (.
      bean2198
      setIpPermissions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2811] (ec2/ip-permission arg2811))
 v2200))))
   (clojure.core/let
    [v2200
     (:source-security-group-name
      m2199
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2200 :com.palletops.awaze.client-builder/undef)
     (. bean2198 setSourceSecurityGroupName (clojure.core/str v2200))))
   (clojure.core/let
    [v2200
     (:group-name m2199 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2200 :com.palletops.awaze.client-builder/undef)
     (. bean2198 setGroupName (clojure.core/str v2200))))
   (clojure.core/let
    [v2200
     (:ip-protocol m2199 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2200 :com.palletops.awaze.client-builder/undef)
     (. bean2198 setIpProtocol (clojure.core/str v2200))))
   (clojure.core/let
    [v2200
     (:from-port m2199 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2200 :com.palletops.awaze.client-builder/undef)
     (. bean2198 setFromPort (clojure.core/int v2200))))
   bean2198))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AttachClassicLinkVpcRequest}
attach-classic-link-vpc-request
  [m2202]
  (clojure.core/let
   [bean2201
    (new com.amazonaws.services.ec2.model.AttachClassicLinkVpcRequest)]
   (clojure.core/let
    [v2203
     (:instance-id m2202 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2203 :com.palletops.awaze.client-builder/undef)
     (. bean2201 setInstanceId (clojure.core/str v2203))))
   (clojure.core/let
    [v2203 (:vpc-id m2202 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2203 :com.palletops.awaze.client-builder/undef)
     (. bean2201 setVpcId (clojure.core/str v2203))))
   (clojure.core/let
    [v2203 (:groups m2202 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2203 :com.palletops.awaze.client-builder/undef)
     (.
      bean2201
      setGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2812] (clojure.core/str arg2812))
 v2203))))
   bean2201))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReplaceNetworkAclAssociationRequest}
replace-network-acl-association-request
  [m2205]
  (clojure.core/let
   [bean2204
    (new
     com.amazonaws.services.ec2.model.ReplaceNetworkAclAssociationRequest)]
   (clojure.core/let
    [v2206
     (:network-acl-id m2205 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2206 :com.palletops.awaze.client-builder/undef)
     (. bean2204 setNetworkAclId (clojure.core/str v2206))))
   (clojure.core/let
    [v2206
     (:association-id m2205 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2206 :com.palletops.awaze.client-builder/undef)
     (. bean2204 setAssociationId (clojure.core/str v2206))))
   bean2204))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteNatGatewayRequest}
delete-nat-gateway-request
  [m2208]
  (clojure.core/let
   [bean2207
    (new com.amazonaws.services.ec2.model.DeleteNatGatewayRequest)]
   (clojure.core/let
    [v2209
     (:nat-gateway-id m2208 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2209 :com.palletops.awaze.client-builder/undef)
     (. bean2207 setNatGatewayId (clojure.core/str v2209))))
   bean2207))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyInstanceAttributeRequest}
modify-instance-attribute-request
  [m2211]
  (clojure.core/let
   [bean2210
    (new
     com.amazonaws.services.ec2.model.ModifyInstanceAttributeRequest)]
   (clojure.core/let
    [v2212 (:kernel m2211 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2212 :com.palletops.awaze.client-builder/undef)
     (. bean2210 setKernel (clojure.core/str v2212))))
   (clojure.core/let
    [v2212
     (:instance-type m2211 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2212 :com.palletops.awaze.client-builder/undef)
     (. bean2210 setInstanceType (clojure.core/str v2212))))
   (clojure.core/let
    [v2212
     (:ebs-optimized m2211 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2212 :com.palletops.awaze.client-builder/undef)
     (. bean2210 setEbsOptimized (clojure.core/boolean v2212))))
   (clojure.core/let
    [v2212
     (:source-dest-check
      m2211
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2212 :com.palletops.awaze.client-builder/undef)
     (. bean2210 setSourceDestCheck (clojure.core/boolean v2212))))
   (clojure.core/let
    [v2212
     (:instance-id m2211 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2212 :com.palletops.awaze.client-builder/undef)
     (. bean2210 setInstanceId (clojure.core/str v2212))))
   (clojure.core/let
    [v2212
     (:instance-initiated-shutdown-behavior
      m2211
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2212 :com.palletops.awaze.client-builder/undef)
     (.
      bean2210
      setInstanceInitiatedShutdownBehavior
      (clojure.core/str v2212))))
   (clojure.core/let
    [v2212 (:groups m2211 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2212 :com.palletops.awaze.client-builder/undef)
     (.
      bean2210
      setGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2813] (clojure.core/str arg2813))
 v2212))))
   (clojure.core/let
    [v2212
     (:disable-api-termination
      m2211
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2212 :com.palletops.awaze.client-builder/undef)
     (.
      bean2210
      setDisableApiTermination
      (clojure.core/boolean v2212))))
   (clojure.core/let
    [v2212
     (:attribute m2211 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2212 :com.palletops.awaze.client-builder/undef)
     (. bean2210 setAttribute (clojure.core/str v2212))))
   (clojure.core/let
    [v2212
     (:sriov-net-support
      m2211
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2212 :com.palletops.awaze.client-builder/undef)
     (. bean2210 setSriovNetSupport (clojure.core/str v2212))))
   (clojure.core/let
    [v2212 (:value m2211 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2212 :com.palletops.awaze.client-builder/undef)
     (. bean2210 setValue (clojure.core/str v2212))))
   (clojure.core/let
    [v2212
     (:block-device-mappings
      m2211
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2212 :com.palletops.awaze.client-builder/undef)
     (.
      bean2210
      setBlockDeviceMappings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg2814]
  (ec2/instance-block-device-mapping-specification arg2814))
 v2212))))
   (clojure.core/let
    [v2212 (:ramdisk m2211 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2212 :com.palletops.awaze.client-builder/undef)
     (. bean2210 setRamdisk (clojure.core/str v2212))))
   (clojure.core/let
    [v2212
     (:user-data m2211 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2212 :com.palletops.awaze.client-builder/undef)
     (. bean2210 setUserData (clojure.core/str v2212))))
   bean2210))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeNetworkAclsRequest}
describe-network-acls-request
  [m2214]
  (clojure.core/let
   [bean2213
    (new com.amazonaws.services.ec2.model.DescribeNetworkAclsRequest)]
   (clojure.core/let
    [v2215 (:filters m2214 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2215 :com.palletops.awaze.client-builder/undef)
     (.
      bean2213
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2815] (ec2/filter arg2815))
 v2215))))
   (clojure.core/let
    [v2215
     (:network-acl-ids
      m2214
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2215 :com.palletops.awaze.client-builder/undef)
     (.
      bean2213
      setNetworkAclIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2816] (clojure.core/str arg2816))
 v2215))))
   bean2213))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReportInstanceStatusRequest}
report-instance-status-request
  [m2217]
  (clojure.core/let
   [bean2216
    (new com.amazonaws.services.ec2.model.ReportInstanceStatusRequest)]
   (clojure.core/let
    [v2218
     (:description m2217 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2218 :com.palletops.awaze.client-builder/undef)
     (. bean2216 setDescription (clojure.core/str v2218))))
   (clojure.core/let
    [v2218
     (:instances m2217 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2218 :com.palletops.awaze.client-builder/undef)
     (.
      bean2216
      setInstances
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2817] (clojure.core/str arg2817))
 v2218))))
   (clojure.core/let
    [v2218 (:status m2217 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2218 :com.palletops.awaze.client-builder/undef)
     (. bean2216 setStatus (ec2/report-status-type v2218))))
   (clojure.core/let
    [v2218
     (:start-time m2217 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2218 :com.palletops.awaze.client-builder/undef)
     (.
      bean2216
      setStartTime
      (com.palletops.awaze.common/to-date v2218))))
   (clojure.core/let
    [v2218
     (:end-time m2217 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2218 :com.palletops.awaze.client-builder/undef)
     (.
      bean2216
      setEndTime
      (com.palletops.awaze.common/to-date v2218))))
   (clojure.core/let
    [v2218
     (:reason-codes m2217 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2218 :com.palletops.awaze.client-builder/undef)
     (.
      bean2216
      setReasonCodes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2818] (clojure.core/str arg2818))
 v2218))))
   bean2216))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeImagesRequest}
describe-images-request
  [m2220]
  (clojure.core/let
   [bean2219
    (new com.amazonaws.services.ec2.model.DescribeImagesRequest)]
   (clojure.core/let
    [v2221 (:filters m2220 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2221 :com.palletops.awaze.client-builder/undef)
     (.
      bean2219
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2819] (ec2/filter arg2819))
 v2221))))
   (clojure.core/let
    [v2221
     (:image-ids m2220 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2221 :com.palletops.awaze.client-builder/undef)
     (.
      bean2219
      setImageIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2820] (clojure.core/str arg2820))
 v2221))))
   (clojure.core/let
    [v2221 (:owners m2220 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2221 :com.palletops.awaze.client-builder/undef)
     (.
      bean2219
      setOwners
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2821] (clojure.core/str arg2821))
 v2221))))
   (clojure.core/let
    [v2221
     (:executable-users
      m2220
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2221 :com.palletops.awaze.client-builder/undef)
     (.
      bean2219
      setExecutableUsers
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2822] (clojure.core/str arg2822))
 v2221))))
   bean2219))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeImportImageTasksRequest}
describe-import-image-tasks-request
  [m2223]
  (clojure.core/let
   [bean2222
    (new
     com.amazonaws.services.ec2.model.DescribeImportImageTasksRequest)]
   (clojure.core/let
    [v2224 (:filters m2223 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2224 :com.palletops.awaze.client-builder/undef)
     (.
      bean2222
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2823] (ec2/filter arg2823))
 v2224))))
   (clojure.core/let
    [v2224
     (:next-token m2223 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2224 :com.palletops.awaze.client-builder/undef)
     (. bean2222 setNextToken (clojure.core/str v2224))))
   (clojure.core/let
    [v2224
     (:max-results m2223 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2224 :com.palletops.awaze.client-builder/undef)
     (. bean2222 setMaxResults (clojure.core/int v2224))))
   (clojure.core/let
    [v2224
     (:import-task-ids
      m2223
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2224 :com.palletops.awaze.client-builder/undef)
     (.
      bean2222
      setImportTaskIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2824] (clojure.core/str arg2824))
 v2224))))
   bean2222))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyHostsRequest}
modify-hosts-request
  [m2226]
  (clojure.core/let
   [bean2225
    (new com.amazonaws.services.ec2.model.ModifyHostsRequest)]
   (clojure.core/let
    [v2227
     (:auto-placement m2226 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2227 :com.palletops.awaze.client-builder/undef)
     (. bean2225 setAutoPlacement (clojure.core/str v2227))))
   (clojure.core/let
    [v2227
     (:host-ids m2226 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2227 :com.palletops.awaze.client-builder/undef)
     (.
      bean2225
      setHostIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2825] (clojure.core/str arg2825))
 v2227))))
   bean2225))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RegisterImageRequest}
register-image-request
  [m2229]
  (clojure.core/let
   [bean2228
    (new com.amazonaws.services.ec2.model.RegisterImageRequest)]
   (clojure.core/let
    [v2230
     (:description m2229 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2230 :com.palletops.awaze.client-builder/undef)
     (. bean2228 setDescription (clojure.core/str v2230))))
   (clojure.core/let
    [v2230 (:name m2229 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2230 :com.palletops.awaze.client-builder/undef)
     (. bean2228 setName (clojure.core/str v2230))))
   (clojure.core/let
    [v2230
     (:root-device-name
      m2229
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2230 :com.palletops.awaze.client-builder/undef)
     (. bean2228 setRootDeviceName (clojure.core/str v2230))))
   (clojure.core/let
    [v2230
     (:ramdisk-id m2229 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2230 :com.palletops.awaze.client-builder/undef)
     (. bean2228 setRamdiskId (clojure.core/str v2230))))
   (clojure.core/let
    [v2230
     (:virtualization-type
      m2229
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2230 :com.palletops.awaze.client-builder/undef)
     (. bean2228 setVirtualizationType (clojure.core/str v2230))))
   (clojure.core/let
    [v2230
     (:sriov-net-support
      m2229
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2230 :com.palletops.awaze.client-builder/undef)
     (. bean2228 setSriovNetSupport (clojure.core/str v2230))))
   (clojure.core/let
    [v2230
     (:kernel-id m2229 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2230 :com.palletops.awaze.client-builder/undef)
     (. bean2228 setKernelId (clojure.core/str v2230))))
   (clojure.core/let
    [v2230
     (:image-location m2229 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2230 :com.palletops.awaze.client-builder/undef)
     (. bean2228 setImageLocation (clojure.core/str v2230))))
   (clojure.core/let
    [v2230
     (:architecture m2229 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2230 :com.palletops.awaze.client-builder/undef)
     (. bean2228 setArchitecture (ec2/architecture-values v2230))))
   (clojure.core/let
    [v2230
     (:block-device-mappings
      m2229
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2230 :com.palletops.awaze.client-builder/undef)
     (.
      bean2228
      setBlockDeviceMappings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2826] (ec2/block-device-mapping arg2826))
 v2230))))
   bean2228))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DetachVpnGatewayRequest}
detach-vpn-gateway-request
  [m2232]
  (clojure.core/let
   [bean2231
    (new com.amazonaws.services.ec2.model.DetachVpnGatewayRequest)]
   (clojure.core/let
    [v2233 (:vpc-id m2232 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2233 :com.palletops.awaze.client-builder/undef)
     (. bean2231 setVpcId (clojure.core/str v2233))))
   (clojure.core/let
    [v2233
     (:vpn-gateway-id m2232 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2233 :com.palletops.awaze.client-builder/undef)
     (. bean2231 setVpnGatewayId (clojure.core/str v2233))))
   bean2231))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteVolumeRequest}
delete-volume-request
  [m2235]
  (clojure.core/let
   [bean2234
    (new com.amazonaws.services.ec2.model.DeleteVolumeRequest)]
   (clojure.core/let
    [v2236
     (:volume-id m2235 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2236 :com.palletops.awaze.client-builder/undef)
     (. bean2234 setVolumeId (clojure.core/str v2236))))
   bean2234))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteInternetGatewayRequest}
delete-internet-gateway-request
  [m2238]
  (clojure.core/let
   [bean2237
    (new
     com.amazonaws.services.ec2.model.DeleteInternetGatewayRequest)]
   (clojure.core/let
    [v2239
     (:internet-gateway-id
      m2238
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2239 :com.palletops.awaze.client-builder/undef)
     (. bean2237 setInternetGatewayId (clojure.core/str v2239))))
   bean2237))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteSubnetRequest}
delete-subnet-request
  [m2241]
  (clojure.core/let
   [bean2240
    (new com.amazonaws.services.ec2.model.DeleteSubnetRequest)]
   (clojure.core/let
    [v2242
     (:subnet-id m2241 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2242 :com.palletops.awaze.client-builder/undef)
     (. bean2240 setSubnetId (clojure.core/str v2242))))
   bean2240))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ResetInstanceAttributeRequest}
reset-instance-attribute-request
  [m2244]
  (clojure.core/let
   [bean2243
    (new
     com.amazonaws.services.ec2.model.ResetInstanceAttributeRequest)]
   (clojure.core/let
    [v2245
     (:attribute m2244 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2245 :com.palletops.awaze.client-builder/undef)
     (. bean2243 setAttribute (clojure.core/str v2245))))
   (clojure.core/let
    [v2245
     (:instance-id m2244 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2245 :com.palletops.awaze.client-builder/undef)
     (. bean2243 setInstanceId (clojure.core/str v2245))))
   bean2243))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DetachVolumeRequest}
detach-volume-request
  [m2247]
  (clojure.core/let
   [bean2246
    (new com.amazonaws.services.ec2.model.DetachVolumeRequest)]
   (clojure.core/let
    [v2248
     (:instance-id m2247 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2248 :com.palletops.awaze.client-builder/undef)
     (. bean2246 setInstanceId (clojure.core/str v2248))))
   (clojure.core/let
    [v2248 (:device m2247 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2248 :com.palletops.awaze.client-builder/undef)
     (. bean2246 setDevice (clojure.core/str v2248))))
   (clojure.core/let
    [v2248
     (:volume-id m2247 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2248 :com.palletops.awaze.client-builder/undef)
     (. bean2246 setVolumeId (clojure.core/str v2248))))
   (clojure.core/let
    [v2248 (:force m2247 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2248 :com.palletops.awaze.client-builder/undef)
     (. bean2246 setForce (clojure.core/boolean v2248))))
   bean2246))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeExportTasksRequest}
describe-export-tasks-request
  [m2250]
  (clojure.core/let
   [bean2249
    (new com.amazonaws.services.ec2.model.DescribeExportTasksRequest)]
   (clojure.core/let
    [v2251
     (:export-task-ids
      m2250
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2251 :com.palletops.awaze.client-builder/undef)
     (.
      bean2249
      setExportTaskIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2827] (clojure.core/str arg2827))
 v2251))))
   bean2249))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeScheduledInstancesRequest}
describe-scheduled-instances-request
  [m2253]
  (clojure.core/let
   [bean2252
    (new
     com.amazonaws.services.ec2.model.DescribeScheduledInstancesRequest)]
   (clojure.core/let
    [v2254 (:filters m2253 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2254 :com.palletops.awaze.client-builder/undef)
     (.
      bean2252
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2828] (ec2/filter arg2828))
 v2254))))
   (clojure.core/let
    [v2254
     (:next-token m2253 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2254 :com.palletops.awaze.client-builder/undef)
     (. bean2252 setNextToken (clojure.core/str v2254))))
   (clojure.core/let
    [v2254
     (:max-results m2253 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2254 :com.palletops.awaze.client-builder/undef)
     (. bean2252 setMaxResults (clojure.core/int v2254))))
   (clojure.core/let
    [v2254
     (:scheduled-instance-ids
      m2253
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2254 :com.palletops.awaze.client-builder/undef)
     (.
      bean2252
      setScheduledInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2829] (clojure.core/str arg2829))
 v2254))))
   (clojure.core/let
    [v2254
     (:slot-start-time-range
      m2253
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2254 :com.palletops.awaze.client-builder/undef)
     (.
      bean2252
      setSlotStartTimeRange
      (ec2/slot-start-time-range-request v2254))))
   bean2252))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteFlowLogsRequest}
delete-flow-logs-request
  [m2256]
  (clojure.core/let
   [bean2255
    (new com.amazonaws.services.ec2.model.DeleteFlowLogsRequest)]
   (clojure.core/let
    [v2257
     (:flow-log-ids m2256 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2257 :com.palletops.awaze.client-builder/undef)
     (.
      bean2255
      setFlowLogIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2830] (clojure.core/str arg2830))
 v2257))))
   bean2255))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVpcRequest}
create-vpc-request
  [m2259]
  (clojure.core/let
   [bean2258 (new com.amazonaws.services.ec2.model.CreateVpcRequest)]
   (clojure.core/let
    [v2260
     (:cidr-block m2259 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2260 :com.palletops.awaze.client-builder/undef)
     (. bean2258 setCidrBlock (clojure.core/str v2260))))
   (clojure.core/let
    [v2260
     (:instance-tenancy
      m2259
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2260 :com.palletops.awaze.client-builder/undef)
     (. bean2258 setInstanceTenancy (clojure.core/str v2260))))
   bean2258))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateSpotDatafeedSubscriptionRequest}
create-spot-datafeed-subscription-request
  [m2262]
  (clojure.core/let
   [bean2261
    (new
     com.amazonaws.services.ec2.model.CreateSpotDatafeedSubscriptionRequest)]
   (clojure.core/let
    [v2263 (:bucket m2262 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2263 :com.palletops.awaze.client-builder/undef)
     (. bean2261 setBucket (clojure.core/str v2263))))
   (clojure.core/let
    [v2263 (:prefix m2262 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2263 :com.palletops.awaze.client-builder/undef)
     (. bean2261 setPrefix (clojure.core/str v2263))))
   bean2261))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVpcClassicLinkRequest}
describe-vpc-classic-link-request
  [m2265]
  (clojure.core/let
   [bean2264
    (new
     com.amazonaws.services.ec2.model.DescribeVpcClassicLinkRequest)]
   (clojure.core/let
    [v2266 (:filters m2265 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2266 :com.palletops.awaze.client-builder/undef)
     (.
      bean2264
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2831] (ec2/filter arg2831))
 v2266))))
   (clojure.core/let
    [v2266 (:vpc-ids m2265 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2266 :com.palletops.awaze.client-builder/undef)
     (.
      bean2264
      setVpcIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2832] (clojure.core/str arg2832))
 v2266))))
   bean2264))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteRouteRequest}
delete-route-request
  [m2268]
  (clojure.core/let
   [bean2267
    (new com.amazonaws.services.ec2.model.DeleteRouteRequest)]
   (clojure.core/let
    [v2269
     (:route-table-id m2268 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2269 :com.palletops.awaze.client-builder/undef)
     (. bean2267 setRouteTableId (clojure.core/str v2269))))
   (clojure.core/let
    [v2269
     (:destination-cidr-block
      m2268
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2269 :com.palletops.awaze.client-builder/undef)
     (. bean2267 setDestinationCidrBlock (clojure.core/str v2269))))
   bean2267))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeIdFormatRequest}
describe-id-format-request
  [m2271]
  (clojure.core/let
   [bean2270
    (new com.amazonaws.services.ec2.model.DescribeIdFormatRequest)]
   (clojure.core/let
    [v2272
     (:resource m2271 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2272 :com.palletops.awaze.client-builder/undef)
     (. bean2270 setResource (clojure.core/str v2272))))
   bean2270))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AttachVolumeRequest}
attach-volume-request
  [m2274]
  (clojure.core/let
   [bean2273
    (new com.amazonaws.services.ec2.model.AttachVolumeRequest)]
   (clojure.core/let
    [v2275
     (:instance-id m2274 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2275 :com.palletops.awaze.client-builder/undef)
     (. bean2273 setInstanceId (clojure.core/str v2275))))
   (clojure.core/let
    [v2275 (:device m2274 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2275 :com.palletops.awaze.client-builder/undef)
     (. bean2273 setDevice (clojure.core/str v2275))))
   (clojure.core/let
    [v2275
     (:volume-id m2274 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2275 :com.palletops.awaze.client-builder/undef)
     (. bean2273 setVolumeId (clojure.core/str v2275))))
   bean2273))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.EnableVolumeIORequest}
enable-volume-iorequest
  [m2277]
  (clojure.core/let
   [bean2276
    (new com.amazonaws.services.ec2.model.EnableVolumeIORequest)]
   (clojure.core/let
    [v2278
     (:volume-id m2277 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2278 :com.palletops.awaze.client-builder/undef)
     (. bean2276 setVolumeId (clojure.core/str v2278))))
   bean2276))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AttachVpnGatewayRequest}
attach-vpn-gateway-request
  [m2280]
  (clojure.core/let
   [bean2279
    (new com.amazonaws.services.ec2.model.AttachVpnGatewayRequest)]
   (clojure.core/let
    [v2281 (:vpc-id m2280 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2281 :com.palletops.awaze.client-builder/undef)
     (. bean2279 setVpcId (clojure.core/str v2281))))
   (clojure.core/let
    [v2281
     (:vpn-gateway-id m2280 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2281 :com.palletops.awaze.client-builder/undef)
     (. bean2279 setVpnGatewayId (clojure.core/str v2281))))
   bean2279))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReplaceNetworkAclEntryRequest}
replace-network-acl-entry-request
  [m2283]
  (clojure.core/let
   [bean2282
    (new
     com.amazonaws.services.ec2.model.ReplaceNetworkAclEntryRequest)]
   (clojure.core/let
    [v2284
     (:protocol m2283 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2284 :com.palletops.awaze.client-builder/undef)
     (. bean2282 setProtocol (clojure.core/str v2284))))
   (clojure.core/let
    [v2284
     (:network-acl-id m2283 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2284 :com.palletops.awaze.client-builder/undef)
     (. bean2282 setNetworkAclId (clojure.core/str v2284))))
   (clojure.core/let
    [v2284
     (:rule-number m2283 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2284 :com.palletops.awaze.client-builder/undef)
     (. bean2282 setRuleNumber (clojure.core/int v2284))))
   (clojure.core/let
    [v2284
     (:rule-action m2283 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2284 :com.palletops.awaze.client-builder/undef)
     (. bean2282 setRuleAction (clojure.core/str v2284))))
   (clojure.core/let
    [v2284 (:egress m2283 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2284 :com.palletops.awaze.client-builder/undef)
     (. bean2282 setEgress (clojure.core/boolean v2284))))
   (clojure.core/let
    [v2284
     (:cidr-block m2283 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2284 :com.palletops.awaze.client-builder/undef)
     (. bean2282 setCidrBlock (clojure.core/str v2284))))
   (clojure.core/let
    [v2284
     (:icmp-type-code m2283 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2284 :com.palletops.awaze.client-builder/undef)
     (. bean2282 setIcmpTypeCode (ec2/icmp-type-code v2284))))
   (clojure.core/let
    [v2284
     (:port-range m2283 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2284 :com.palletops.awaze.client-builder/undef)
     (. bean2282 setPortRange (ec2/port-range v2284))))
   bean2282))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSnapshotAttributeRequest}
describe-snapshot-attribute-request
  [m2286]
  (clojure.core/let
   [bean2285
    (new
     com.amazonaws.services.ec2.model.DescribeSnapshotAttributeRequest)]
   (clojure.core/let
    [v2287
     (:attribute m2286 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2287 :com.palletops.awaze.client-builder/undef)
     (. bean2285 setAttribute (clojure.core/str v2287))))
   (clojure.core/let
    [v2287
     (:snapshot-id m2286 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2287 :com.palletops.awaze.client-builder/undef)
     (. bean2285 setSnapshotId (clojure.core/str v2287))))
   bean2285))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RebootInstancesRequest}
reboot-instances-request
  [m2289]
  (clojure.core/let
   [bean2288
    (new com.amazonaws.services.ec2.model.RebootInstancesRequest)]
   (clojure.core/let
    [v2290
     (:instance-ids m2289 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2290 :com.palletops.awaze.client-builder/undef)
     (.
      bean2288
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2833] (clojure.core/str arg2833))
 v2290))))
   bean2288))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RejectVpcPeeringConnectionRequest}
reject-vpc-peering-connection-request
  [m2292]
  (clojure.core/let
   [bean2291
    (new
     com.amazonaws.services.ec2.model.RejectVpcPeeringConnectionRequest)]
   (clojure.core/let
    [v2293
     (:vpc-peering-connection-id
      m2292
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2293 :com.palletops.awaze.client-builder/undef)
     (. bean2291 setVpcPeeringConnectionId (clojure.core/str v2293))))
   bean2291))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateSecurityGroupRequest}
create-security-group-request
  [m2295]
  (clojure.core/let
   [bean2294
    (new com.amazonaws.services.ec2.model.CreateSecurityGroupRequest)]
   (clojure.core/let
    [v2296 (:vpc-id m2295 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2296 :com.palletops.awaze.client-builder/undef)
     (. bean2294 setVpcId (clojure.core/str v2296))))
   (clojure.core/let
    [v2296
     (:group-name m2295 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2296 :com.palletops.awaze.client-builder/undef)
     (. bean2294 setGroupName (clojure.core/str v2296))))
   (clojure.core/let
    [v2296
     (:description m2295 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2296 :com.palletops.awaze.client-builder/undef)
     (. bean2294 setDescription (clojure.core/str v2296))))
   bean2294))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSpotInstanceRequestsRequest}
describe-spot-instance-requests-request
  [m2298]
  (clojure.core/let
   [bean2297
    (new
     com.amazonaws.services.ec2.model.DescribeSpotInstanceRequestsRequest)]
   (clojure.core/let
    [v2299
     (:spot-instance-request-ids
      m2298
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2299 :com.palletops.awaze.client-builder/undef)
     (.
      bean2297
      setSpotInstanceRequestIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2834] (clojure.core/str arg2834))
 v2299))))
   (clojure.core/let
    [v2299 (:filters m2298 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2299 :com.palletops.awaze.client-builder/undef)
     (.
      bean2297
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2835] (ec2/filter arg2835))
 v2299))))
   bean2297))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSpotDatafeedSubscriptionRequest}
describe-spot-datafeed-subscription-request
  [m2301]
  (clojure.core/let
   [bean2300
    (new
     com.amazonaws.services.ec2.model.DescribeSpotDatafeedSubscriptionRequest)]
   bean2300))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.MoveAddressToVpcRequest}
move-address-to-vpc-request
  [m2304]
  (clojure.core/let
   [bean2303
    (new com.amazonaws.services.ec2.model.MoveAddressToVpcRequest)]
   (clojure.core/let
    [v2305
     (:public-ip m2304 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2305 :com.palletops.awaze.client-builder/undef)
     (. bean2303 setPublicIp (clojure.core/str v2305))))
   bean2303))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyVpcEndpointRequest}
modify-vpc-endpoint-request
  [m2307]
  (clojure.core/let
   [bean2306
    (new com.amazonaws.services.ec2.model.ModifyVpcEndpointRequest)]
   (clojure.core/let
    [v2308
     (:vpc-endpoint-id
      m2307
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2308 :com.palletops.awaze.client-builder/undef)
     (. bean2306 setVpcEndpointId (clojure.core/str v2308))))
   (clojure.core/let
    [v2308
     (:reset-policy m2307 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2308 :com.palletops.awaze.client-builder/undef)
     (. bean2306 setResetPolicy (clojure.core/boolean v2308))))
   (clojure.core/let
    [v2308
     (:policy-document
      m2307
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2308 :com.palletops.awaze.client-builder/undef)
     (. bean2306 setPolicyDocument (clojure.core/str v2308))))
   (clojure.core/let
    [v2308
     (:add-route-table-ids
      m2307
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2308 :com.palletops.awaze.client-builder/undef)
     (.
      bean2306
      setAddRouteTableIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2836] (clojure.core/str arg2836))
 v2308))))
   (clojure.core/let
    [v2308
     (:remove-route-table-ids
      m2307
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2308 :com.palletops.awaze.client-builder/undef)
     (.
      bean2306
      setRemoveRouteTableIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2837] (clojure.core/str arg2837))
 v2308))))
   bean2306))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AttachNetworkInterfaceRequest}
attach-network-interface-request
  [m2310]
  (clojure.core/let
   [bean2309
    (new
     com.amazonaws.services.ec2.model.AttachNetworkInterfaceRequest)]
   (clojure.core/let
    [v2311
     (:network-interface-id
      m2310
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2311 :com.palletops.awaze.client-builder/undef)
     (. bean2309 setNetworkInterfaceId (clojure.core/str v2311))))
   (clojure.core/let
    [v2311
     (:instance-id m2310 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2311 :com.palletops.awaze.client-builder/undef)
     (. bean2309 setInstanceId (clojure.core/str v2311))))
   (clojure.core/let
    [v2311
     (:device-index m2310 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2311 :com.palletops.awaze.client-builder/undef)
     (. bean2309 setDeviceIndex (clojure.core/int v2311))))
   bean2309))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DetachNetworkInterfaceRequest}
detach-network-interface-request
  [m2313]
  (clojure.core/let
   [bean2312
    (new
     com.amazonaws.services.ec2.model.DetachNetworkInterfaceRequest)]
   (clojure.core/let
    [v2314 (:force m2313 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2314 :com.palletops.awaze.client-builder/undef)
     (. bean2312 setForce (clojure.core/boolean v2314))))
   (clojure.core/let
    [v2314
     (:attachment-id m2313 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2314 :com.palletops.awaze.client-builder/undef)
     (. bean2312 setAttachmentId (clojure.core/str v2314))))
   bean2312))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteDhcpOptionsRequest}
delete-dhcp-options-request
  [m2316]
  (clojure.core/let
   [bean2315
    (new com.amazonaws.services.ec2.model.DeleteDhcpOptionsRequest)]
   (clojure.core/let
    [v2317
     (:dhcp-options-id
      m2316
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2317 :com.palletops.awaze.client-builder/undef)
     (. bean2315 setDhcpOptionsId (clojure.core/str v2317))))
   bean2315))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVpcEndpointsRequest}
describe-vpc-endpoints-request
  [m2319]
  (clojure.core/let
   [bean2318
    (new com.amazonaws.services.ec2.model.DescribeVpcEndpointsRequest)]
   (clojure.core/let
    [v2320
     (:vpc-endpoint-ids
      m2319
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2320 :com.palletops.awaze.client-builder/undef)
     (.
      bean2318
      setVpcEndpointIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2838] (clojure.core/str arg2838))
 v2320))))
   (clojure.core/let
    [v2320 (:filters m2319 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2320 :com.palletops.awaze.client-builder/undef)
     (.
      bean2318
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2839] (ec2/filter arg2839))
 v2320))))
   (clojure.core/let
    [v2320
     (:next-token m2319 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2320 :com.palletops.awaze.client-builder/undef)
     (. bean2318 setNextToken (clojure.core/str v2320))))
   (clojure.core/let
    [v2320
     (:max-results m2319 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2320 :com.palletops.awaze.client-builder/undef)
     (. bean2318 setMaxResults (clojure.core/int v2320))))
   bean2318))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ConfirmProductInstanceRequest}
confirm-product-instance-request
  [m2322]
  (clojure.core/let
   [bean2321
    (new
     com.amazonaws.services.ec2.model.ConfirmProductInstanceRequest)]
   (clojure.core/let
    [v2323
     (:instance-id m2322 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2323 :com.palletops.awaze.client-builder/undef)
     (. bean2321 setInstanceId (clojure.core/str v2323))))
   (clojure.core/let
    [v2323
     (:product-code m2322 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2323 :com.palletops.awaze.client-builder/undef)
     (. bean2321 setProductCode (clojure.core/str v2323))))
   bean2321))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AllocateAddressRequest}
allocate-address-request
  [m2325]
  (clojure.core/let
   [bean2324
    (new com.amazonaws.services.ec2.model.AllocateAddressRequest)]
   (clojure.core/let
    [v2326 (:domain m2325 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2326 :com.palletops.awaze.client-builder/undef)
     (. bean2324 setDomain (clojure.core/str v2326))))
   bean2324))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVpcEndpointRequest}
create-vpc-endpoint-request
  [m2328]
  (clojure.core/let
   [bean2327
    (new com.amazonaws.services.ec2.model.CreateVpcEndpointRequest)]
   (clojure.core/let
    [v2329
     (:client-token m2328 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2329 :com.palletops.awaze.client-builder/undef)
     (. bean2327 setClientToken (clojure.core/str v2329))))
   (clojure.core/let
    [v2329 (:vpc-id m2328 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2329 :com.palletops.awaze.client-builder/undef)
     (. bean2327 setVpcId (clojure.core/str v2329))))
   (clojure.core/let
    [v2329
     (:policy-document
      m2328
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2329 :com.palletops.awaze.client-builder/undef)
     (. bean2327 setPolicyDocument (clojure.core/str v2329))))
   (clojure.core/let
    [v2329
     (:service-name m2328 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2329 :com.palletops.awaze.client-builder/undef)
     (. bean2327 setServiceName (clojure.core/str v2329))))
   (clojure.core/let
    [v2329
     (:route-table-ids
      m2328
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2329 :com.palletops.awaze.client-builder/undef)
     (.
      bean2327
      setRouteTableIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2840] (clojure.core/str arg2840))
 v2329))))
   bean2327))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ImportKeyPairRequest}
import-key-pair-request
  [m2331]
  (clojure.core/let
   [bean2330
    (new com.amazonaws.services.ec2.model.ImportKeyPairRequest)]
   (clojure.core/let
    [v2332
     (:key-name m2331 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2332 :com.palletops.awaze.client-builder/undef)
     (. bean2330 setKeyName (clojure.core/str v2332))))
   (clojure.core/let
    [v2332
     (:public-key-material
      m2331
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2332 :com.palletops.awaze.client-builder/undef)
     (. bean2330 setPublicKeyMaterial (clojure.core/str v2332))))
   bean2330))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CopySnapshotRequest}
copy-snapshot-request
  [m2334]
  (clojure.core/let
   [bean2333
    (new com.amazonaws.services.ec2.model.CopySnapshotRequest)]
   (clojure.core/let
    [v2335
     (:source-region m2334 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2335 :com.palletops.awaze.client-builder/undef)
     (. bean2333 setSourceRegion (clojure.core/str v2335))))
   (clojure.core/let
    [v2335
     (:description m2334 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2335 :com.palletops.awaze.client-builder/undef)
     (. bean2333 setDescription (clojure.core/str v2335))))
   (clojure.core/let
    [v2335
     (:encrypted m2334 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2335 :com.palletops.awaze.client-builder/undef)
     (. bean2333 setEncrypted (clojure.core/boolean v2335))))
   (clojure.core/let
    [v2335
     (:kms-key-id m2334 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2335 :com.palletops.awaze.client-builder/undef)
     (. bean2333 setKmsKeyId (clojure.core/str v2335))))
   (clojure.core/let
    [v2335
     (:source-snapshot-id
      m2334
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2335 :com.palletops.awaze.client-builder/undef)
     (. bean2333 setSourceSnapshotId (clojure.core/str v2335))))
   (clojure.core/let
    [v2335
     (:destination-region
      m2334
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2335 :com.palletops.awaze.client-builder/undef)
     (. bean2333 setDestinationRegion (clojure.core/str v2335))))
   (clojure.core/let
    [v2335
     (:presigned-url m2334 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2335 :com.palletops.awaze.client-builder/undef)
     (. bean2333 setPresignedUrl (clojure.core/str v2335))))
   bean2333))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteSnapshotRequest}
delete-snapshot-request
  [m2337]
  (clojure.core/let
   [bean2336
    (new com.amazonaws.services.ec2.model.DeleteSnapshotRequest)]
   (clojure.core/let
    [v2338
     (:snapshot-id m2337 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2338 :com.palletops.awaze.client-builder/undef)
     (. bean2336 setSnapshotId (clojure.core/str v2338))))
   bean2336))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ResetImageAttributeRequest}
reset-image-attribute-request
  [m2340]
  (clojure.core/let
   [bean2339
    (new com.amazonaws.services.ec2.model.ResetImageAttributeRequest)]
   (clojure.core/let
    [v2341
     (:attribute m2340 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2341 :com.palletops.awaze.client-builder/undef)
     (. bean2339 setAttribute (clojure.core/str v2341))))
   (clojure.core/let
    [v2341
     (:image-id m2340 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2341 :com.palletops.awaze.client-builder/undef)
     (. bean2339 setImageId (clojure.core/str v2341))))
   bean2339))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateInternetGatewayRequest}
create-internet-gateway-request
  [m2343]
  (clojure.core/let
   [bean2342
    (new
     com.amazonaws.services.ec2.model.CreateInternetGatewayRequest)]
   bean2342))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.MonitorInstancesRequest}
monitor-instances-request
  [m2346]
  (clojure.core/let
   [bean2345
    (new com.amazonaws.services.ec2.model.MonitorInstancesRequest)]
   (clojure.core/let
    [v2347
     (:instance-ids m2346 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2347 :com.palletops.awaze.client-builder/undef)
     (.
      bean2345
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2841] (clojure.core/str arg2841))
 v2347))))
   bean2345))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RevokeSecurityGroupEgressRequest}
revoke-security-group-egress-request
  [m2349]
  (clojure.core/let
   [bean2348
    (new
     com.amazonaws.services.ec2.model.RevokeSecurityGroupEgressRequest)]
   (clojure.core/let
    [v2350
     (:source-security-group-name
      m2349
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2350 :com.palletops.awaze.client-builder/undef)
     (. bean2348 setSourceSecurityGroupName (clojure.core/str v2350))))
   (clojure.core/let
    [v2350
     (:group-id m2349 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2350 :com.palletops.awaze.client-builder/undef)
     (. bean2348 setGroupId (clojure.core/str v2350))))
   (clojure.core/let
    [v2350
     (:source-security-group-owner-id
      m2349
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2350 :com.palletops.awaze.client-builder/undef)
     (.
      bean2348
      setSourceSecurityGroupOwnerId
      (clojure.core/str v2350))))
   (clojure.core/let
    [v2350
     (:ip-protocol m2349 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2350 :com.palletops.awaze.client-builder/undef)
     (. bean2348 setIpProtocol (clojure.core/str v2350))))
   (clojure.core/let
    [v2350
     (:from-port m2349 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2350 :com.palletops.awaze.client-builder/undef)
     (. bean2348 setFromPort (clojure.core/int v2350))))
   (clojure.core/let
    [v2350 (:to-port m2349 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2350 :com.palletops.awaze.client-builder/undef)
     (. bean2348 setToPort (clojure.core/int v2350))))
   (clojure.core/let
    [v2350 (:cidr-ip m2349 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2350 :com.palletops.awaze.client-builder/undef)
     (. bean2348 setCidrIp (clojure.core/str v2350))))
   (clojure.core/let
    [v2350
     (:ip-permissions m2349 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2350 :com.palletops.awaze.client-builder/undef)
     (.
      bean2348
      setIpPermissions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2842] (ec2/ip-permission arg2842))
 v2350))))
   bean2348))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVpcsRequest}
describe-vpcs-request
  [m2352]
  (clojure.core/let
   [bean2351
    (new com.amazonaws.services.ec2.model.DescribeVpcsRequest)]
   (clojure.core/let
    [v2353 (:filters m2352 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2353 :com.palletops.awaze.client-builder/undef)
     (.
      bean2351
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2843] (ec2/filter arg2843))
 v2353))))
   (clojure.core/let
    [v2353 (:vpc-ids m2352 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2353 :com.palletops.awaze.client-builder/undef)
     (.
      bean2351
      setVpcIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2844] (clojure.core/str arg2844))
 v2353))))
   bean2351))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ImportInstanceRequest}
import-instance-request
  [m2355]
  (clojure.core/let
   [bean2354
    (new com.amazonaws.services.ec2.model.ImportInstanceRequest)]
   (clojure.core/let
    [v2356
     (:description m2355 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2356 :com.palletops.awaze.client-builder/undef)
     (. bean2354 setDescription (clojure.core/str v2356))))
   (clojure.core/let
    [v2356
     (:launch-specification
      m2355
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2356 :com.palletops.awaze.client-builder/undef)
     (.
      bean2354
      setLaunchSpecification
      (ec2/import-instance-launch-specification v2356))))
   (clojure.core/let
    [v2356
     (:disk-images m2355 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2356 :com.palletops.awaze.client-builder/undef)
     (.
      bean2354
      setDiskImages
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2845] (ec2/disk-image arg2845))
 v2356))))
   (clojure.core/let
    [v2356
     (:platform m2355 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2356 :com.palletops.awaze.client-builder/undef)
     (. bean2354 setPlatform (ec2/platform-values v2356))))
   bean2354))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CopyImageRequest}
copy-image-request
  [m2358]
  (clojure.core/let
   [bean2357 (new com.amazonaws.services.ec2.model.CopyImageRequest)]
   (clojure.core/let
    [v2359
     (:client-token m2358 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2359 :com.palletops.awaze.client-builder/undef)
     (. bean2357 setClientToken (clojure.core/str v2359))))
   (clojure.core/let
    [v2359
     (:source-region m2358 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2359 :com.palletops.awaze.client-builder/undef)
     (. bean2357 setSourceRegion (clojure.core/str v2359))))
   (clojure.core/let
    [v2359
     (:source-image-id
      m2358
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2359 :com.palletops.awaze.client-builder/undef)
     (. bean2357 setSourceImageId (clojure.core/str v2359))))
   (clojure.core/let
    [v2359
     (:description m2358 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2359 :com.palletops.awaze.client-builder/undef)
     (. bean2357 setDescription (clojure.core/str v2359))))
   (clojure.core/let
    [v2359
     (:encrypted m2358 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2359 :com.palletops.awaze.client-builder/undef)
     (. bean2357 setEncrypted (clojure.core/boolean v2359))))
   (clojure.core/let
    [v2359
     (:kms-key-id m2358 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2359 :com.palletops.awaze.client-builder/undef)
     (. bean2357 setKmsKeyId (clojure.core/str v2359))))
   (clojure.core/let
    [v2359 (:name m2358 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2359 :com.palletops.awaze.client-builder/undef)
     (. bean2357 setName (clojure.core/str v2359))))
   bean2357))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.GetConsoleOutputRequest}
get-console-output-request
  [m2361]
  (clojure.core/let
   [bean2360
    (new com.amazonaws.services.ec2.model.GetConsoleOutputRequest)]
   (clojure.core/let
    [v2362
     (:instance-id m2361 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2362 :com.palletops.awaze.client-builder/undef)
     (. bean2360 setInstanceId (clojure.core/str v2362))))
   bean2360))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifySnapshotAttributeRequest}
modify-snapshot-attribute-request
  [m2364]
  (clojure.core/let
   [bean2363
    (new
     com.amazonaws.services.ec2.model.ModifySnapshotAttributeRequest)]
   (clojure.core/let
    [v2365
     (:attribute m2364 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2365 :com.palletops.awaze.client-builder/undef)
     (. bean2363 setAttribute (ec2/snapshot-attribute-name v2365))))
   (clojure.core/let
    [v2365
     (:operation-type m2364 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2365 :com.palletops.awaze.client-builder/undef)
     (. bean2363 setOperationType (clojure.core/str v2365))))
   (clojure.core/let
    [v2365
     (:user-ids m2364 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2365 :com.palletops.awaze.client-builder/undef)
     (.
      bean2363
      setUserIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2846] (clojure.core/str arg2846))
 v2365))))
   (clojure.core/let
    [v2365
     (:snapshot-id m2364 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2365 :com.palletops.awaze.client-builder/undef)
     (. bean2363 setSnapshotId (clojure.core/str v2365))))
   (clojure.core/let
    [v2365
     (:group-names m2364 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2365 :com.palletops.awaze.client-builder/undef)
     (.
      bean2363
      setGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2847] (clojure.core/str arg2847))
 v2365))))
   (clojure.core/let
    [v2365
     (:create-volume-permission
      m2364
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2365 :com.palletops.awaze.client-builder/undef)
     (.
      bean2363
      setCreateVolumePermission
      (ec2/create-volume-permission-modifications v2365))))
   bean2363))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RequestSpotFleetRequest}
request-spot-fleet-request
  [m2367]
  (clojure.core/let
   [bean2366
    (new com.amazonaws.services.ec2.model.RequestSpotFleetRequest)]
   (clojure.core/let
    [v2368
     (:spot-fleet-request-config
      m2367
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2368 :com.palletops.awaze.client-builder/undef)
     (.
      bean2366
      setSpotFleetRequestConfig
      (ec2/spot-fleet-request-config-data v2368))))
   bean2366))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RestoreAddressToClassicRequest}
restore-address-to-classic-request
  [m2370]
  (clojure.core/let
   [bean2369
    (new
     com.amazonaws.services.ec2.model.RestoreAddressToClassicRequest)]
   (clojure.core/let
    [v2371
     (:public-ip m2370 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2371 :com.palletops.awaze.client-builder/undef)
     (. bean2369 setPublicIp (clojure.core/str v2371))))
   bean2369))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifySubnetAttributeRequest}
modify-subnet-attribute-request
  [m2373]
  (clojure.core/let
   [bean2372
    (new
     com.amazonaws.services.ec2.model.ModifySubnetAttributeRequest)]
   (clojure.core/let
    [v2374
     (:subnet-id m2373 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2374 :com.palletops.awaze.client-builder/undef)
     (. bean2372 setSubnetId (clojure.core/str v2374))))
   (clojure.core/let
    [v2374
     (:map-public-ip-on-launch
      m2373
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2374 :com.palletops.awaze.client-builder/undef)
     (. bean2372 setMapPublicIpOnLaunch (clojure.core/boolean v2374))))
   bean2372))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeConversionTasksRequest}
describe-conversion-tasks-request
  [m2376]
  (clojure.core/let
   [bean2375
    (new
     com.amazonaws.services.ec2.model.DescribeConversionTasksRequest)]
   (clojure.core/let
    [v2377 (:filters m2376 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2377 :com.palletops.awaze.client-builder/undef)
     (.
      bean2375
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2848] (ec2/filter arg2848))
 v2377))))
   (clojure.core/let
    [v2377
     (:conversion-task-ids
      m2376
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2377 :com.palletops.awaze.client-builder/undef)
     (.
      bean2375
      setConversionTaskIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2849] (clojure.core/str arg2849))
 v2377))))
   bean2375))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AuthorizeSecurityGroupEgressRequest}
authorize-security-group-egress-request
  [m2379]
  (clojure.core/let
   [bean2378
    (new
     com.amazonaws.services.ec2.model.AuthorizeSecurityGroupEgressRequest)]
   (clojure.core/let
    [v2380
     (:source-security-group-name
      m2379
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2380 :com.palletops.awaze.client-builder/undef)
     (. bean2378 setSourceSecurityGroupName (clojure.core/str v2380))))
   (clojure.core/let
    [v2380
     (:group-id m2379 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2380 :com.palletops.awaze.client-builder/undef)
     (. bean2378 setGroupId (clojure.core/str v2380))))
   (clojure.core/let
    [v2380
     (:source-security-group-owner-id
      m2379
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2380 :com.palletops.awaze.client-builder/undef)
     (.
      bean2378
      setSourceSecurityGroupOwnerId
      (clojure.core/str v2380))))
   (clojure.core/let
    [v2380
     (:ip-protocol m2379 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2380 :com.palletops.awaze.client-builder/undef)
     (. bean2378 setIpProtocol (clojure.core/str v2380))))
   (clojure.core/let
    [v2380
     (:from-port m2379 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2380 :com.palletops.awaze.client-builder/undef)
     (. bean2378 setFromPort (clojure.core/int v2380))))
   (clojure.core/let
    [v2380 (:to-port m2379 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2380 :com.palletops.awaze.client-builder/undef)
     (. bean2378 setToPort (clojure.core/int v2380))))
   (clojure.core/let
    [v2380 (:cidr-ip m2379 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2380 :com.palletops.awaze.client-builder/undef)
     (. bean2378 setCidrIp (clojure.core/str v2380))))
   (clojure.core/let
    [v2380
     (:ip-permissions m2379 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2380 :com.palletops.awaze.client-builder/undef)
     (.
      bean2378
      setIpPermissions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2850] (ec2/ip-permission arg2850))
 v2380))))
   bean2378))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AuthorizeSecurityGroupIngressRequest}
authorize-security-group-ingress-request
  [m2382]
  (clojure.core/let
   [bean2381
    (new
     com.amazonaws.services.ec2.model.AuthorizeSecurityGroupIngressRequest)]
   (clojure.core/let
    [v2383 (:cidr-ip m2382 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2383 :com.palletops.awaze.client-builder/undef)
     (. bean2381 setCidrIp (clojure.core/str v2383))))
   (clojure.core/let
    [v2383
     (:group-id m2382 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2383 :com.palletops.awaze.client-builder/undef)
     (. bean2381 setGroupId (clojure.core/str v2383))))
   (clojure.core/let
    [v2383 (:to-port m2382 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2383 :com.palletops.awaze.client-builder/undef)
     (. bean2381 setToPort (clojure.core/int v2383))))
   (clojure.core/let
    [v2383
     (:source-security-group-owner-id
      m2382
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2383 :com.palletops.awaze.client-builder/undef)
     (.
      bean2381
      setSourceSecurityGroupOwnerId
      (clojure.core/str v2383))))
   (clojure.core/let
    [v2383
     (:ip-permissions m2382 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2383 :com.palletops.awaze.client-builder/undef)
     (.
      bean2381
      setIpPermissions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2851] (ec2/ip-permission arg2851))
 v2383))))
   (clojure.core/let
    [v2383
     (:source-security-group-name
      m2382
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2383 :com.palletops.awaze.client-builder/undef)
     (. bean2381 setSourceSecurityGroupName (clojure.core/str v2383))))
   (clojure.core/let
    [v2383
     (:group-name m2382 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2383 :com.palletops.awaze.client-builder/undef)
     (. bean2381 setGroupName (clojure.core/str v2383))))
   (clojure.core/let
    [v2383
     (:ip-protocol m2382 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2383 :com.palletops.awaze.client-builder/undef)
     (. bean2381 setIpProtocol (clojure.core/str v2383))))
   (clojure.core/let
    [v2383
     (:from-port m2382 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2383 :com.palletops.awaze.client-builder/undef)
     (. bean2381 setFromPort (clojure.core/int v2383))))
   bean2381))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeAddressesRequest}
describe-addresses-request
  [m2385]
  (clojure.core/let
   [bean2384
    (new com.amazonaws.services.ec2.model.DescribeAddressesRequest)]
   (clojure.core/let
    [v2386
     (:public-ips m2385 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2386 :com.palletops.awaze.client-builder/undef)
     (.
      bean2384
      setPublicIps
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2852] (clojure.core/str arg2852))
 v2386))))
   (clojure.core/let
    [v2386 (:filters m2385 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2386 :com.palletops.awaze.client-builder/undef)
     (.
      bean2384
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2853] (ec2/filter arg2853))
 v2386))))
   (clojure.core/let
    [v2386
     (:allocation-ids m2385 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2386 :com.palletops.awaze.client-builder/undef)
     (.
      bean2384
      setAllocationIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2854] (clojure.core/str arg2854))
 v2386))))
   bean2384))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVpnConnectionRouteRequest}
create-vpn-connection-route-request
  [m2388]
  (clojure.core/let
   [bean2387
    (new
     com.amazonaws.services.ec2.model.CreateVpnConnectionRouteRequest)]
   (clojure.core/let
    [v2389
     (:destination-cidr-block
      m2388
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2389 :com.palletops.awaze.client-builder/undef)
     (. bean2387 setDestinationCidrBlock (clojure.core/str v2389))))
   (clojure.core/let
    [v2389
     (:vpn-connection-id
      m2388
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2389 :com.palletops.awaze.client-builder/undef)
     (. bean2387 setVpnConnectionId (clojure.core/str v2389))))
   bean2387))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AssociateAddressRequest}
associate-address-request
  [m2391]
  (clojure.core/let
   [bean2390
    (new com.amazonaws.services.ec2.model.AssociateAddressRequest)]
   (clojure.core/let
    [v2392
     (:network-interface-id
      m2391
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2392 :com.palletops.awaze.client-builder/undef)
     (. bean2390 setNetworkInterfaceId (clojure.core/str v2392))))
   (clojure.core/let
    [v2392
     (:instance-id m2391 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2392 :com.palletops.awaze.client-builder/undef)
     (. bean2390 setInstanceId (clojure.core/str v2392))))
   (clojure.core/let
    [v2392
     (:public-ip m2391 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2392 :com.palletops.awaze.client-builder/undef)
     (. bean2390 setPublicIp (clojure.core/str v2392))))
   (clojure.core/let
    [v2392
     (:allocation-id m2391 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2392 :com.palletops.awaze.client-builder/undef)
     (. bean2390 setAllocationId (clojure.core/str v2392))))
   (clojure.core/let
    [v2392
     (:private-ip-address
      m2391
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2392 :com.palletops.awaze.client-builder/undef)
     (. bean2390 setPrivateIpAddress (clojure.core/str v2392))))
   (clojure.core/let
    [v2392
     (:allow-reassociation
      m2391
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2392 :com.palletops.awaze.client-builder/undef)
     (. bean2390 setAllowReassociation (clojure.core/boolean v2392))))
   bean2390))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateInstanceExportTaskRequest}
create-instance-export-task-request
  [m2394]
  (clojure.core/let
   [bean2393
    (new
     com.amazonaws.services.ec2.model.CreateInstanceExportTaskRequest)]
   (clojure.core/let
    [v2395
     (:instance-id m2394 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2395 :com.palletops.awaze.client-builder/undef)
     (. bean2393 setInstanceId (clojure.core/str v2395))))
   (clojure.core/let
    [v2395
     (:description m2394 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2395 :com.palletops.awaze.client-builder/undef)
     (. bean2393 setDescription (clojure.core/str v2395))))
   (clojure.core/let
    [v2395
     (:target-environment
      m2394
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2395 :com.palletops.awaze.client-builder/undef)
     (. bean2393 setTargetEnvironment (ec2/export-environment v2395))))
   (clojure.core/let
    [v2395
     (:export-to-s3task
      m2394
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2395 :com.palletops.awaze.client-builder/undef)
     (.
      bean2393
      setExportToS3Task
      (ec2/export-to-s3task-specification v2395))))
   bean2393))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeKeyPairsRequest}
describe-key-pairs-request
  [m2397]
  (clojure.core/let
   [bean2396
    (new com.amazonaws.services.ec2.model.DescribeKeyPairsRequest)]
   (clojure.core/let
    [v2398 (:filters m2397 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2398 :com.palletops.awaze.client-builder/undef)
     (.
      bean2396
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2855] (ec2/filter arg2855))
 v2398))))
   (clojure.core/let
    [v2398
     (:key-names m2397 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2398 :com.palletops.awaze.client-builder/undef)
     (.
      bean2396
      setKeyNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2856] (clojure.core/str arg2856))
 v2398))))
   bean2396))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSpotFleetRequestsRequest}
describe-spot-fleet-requests-request
  [m2400]
  (clojure.core/let
   [bean2399
    (new
     com.amazonaws.services.ec2.model.DescribeSpotFleetRequestsRequest)]
   (clojure.core/let
    [v2401
     (:spot-fleet-request-ids
      m2400
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2401 :com.palletops.awaze.client-builder/undef)
     (.
      bean2399
      setSpotFleetRequestIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2857] (clojure.core/str arg2857))
 v2401))))
   (clojure.core/let
    [v2401
     (:next-token m2400 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2401 :com.palletops.awaze.client-builder/undef)
     (. bean2399 setNextToken (clojure.core/str v2401))))
   (clojure.core/let
    [v2401
     (:max-results m2400 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2401 :com.palletops.awaze.client-builder/undef)
     (. bean2399 setMaxResults (clojure.core/int v2401))))
   bean2399))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeImageAttributeRequest}
describe-image-attribute-request
  [m2403]
  (clojure.core/let
   [bean2402
    (new
     com.amazonaws.services.ec2.model.DescribeImageAttributeRequest)]
   (clojure.core/let
    [v2404
     (:attribute m2403 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2404 :com.palletops.awaze.client-builder/undef)
     (. bean2402 setAttribute (clojure.core/str v2404))))
   (clojure.core/let
    [v2404
     (:image-id m2403 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2404 :com.palletops.awaze.client-builder/undef)
     (. bean2402 setImageId (clojure.core/str v2404))))
   bean2402))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeMovingAddressesRequest}
describe-moving-addresses-request
  [m2406]
  (clojure.core/let
   [bean2405
    (new
     com.amazonaws.services.ec2.model.DescribeMovingAddressesRequest)]
   (clojure.core/let
    [v2407
     (:public-ips m2406 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2407 :com.palletops.awaze.client-builder/undef)
     (.
      bean2405
      setPublicIps
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2858] (clojure.core/str arg2858))
 v2407))))
   (clojure.core/let
    [v2407 (:filters m2406 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2407 :com.palletops.awaze.client-builder/undef)
     (.
      bean2405
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2859] (ec2/filter arg2859))
 v2407))))
   (clojure.core/let
    [v2407
     (:next-token m2406 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2407 :com.palletops.awaze.client-builder/undef)
     (. bean2405 setNextToken (clojure.core/str v2407))))
   (clojure.core/let
    [v2407
     (:max-results m2406 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2407 :com.palletops.awaze.client-builder/undef)
     (. bean2405 setMaxResults (clojure.core/int v2407))))
   bean2405))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteNetworkAclRequest}
delete-network-acl-request
  [m2409]
  (clojure.core/let
   [bean2408
    (new com.amazonaws.services.ec2.model.DeleteNetworkAclRequest)]
   (clojure.core/let
    [v2410
     (:network-acl-id m2409 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2410 :com.palletops.awaze.client-builder/undef)
     (. bean2408 setNetworkAclId (clojure.core/str v2410))))
   bean2408))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteNetworkInterfaceRequest}
delete-network-interface-request
  [m2412]
  (clojure.core/let
   [bean2411
    (new
     com.amazonaws.services.ec2.model.DeleteNetworkInterfaceRequest)]
   (clojure.core/let
    [v2413
     (:network-interface-id
      m2412
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2413 :com.palletops.awaze.client-builder/undef)
     (. bean2411 setNetworkInterfaceId (clojure.core/str v2413))))
   bean2411))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteVpnConnectionRequest}
delete-vpn-connection-request
  [m2415]
  (clojure.core/let
   [bean2414
    (new com.amazonaws.services.ec2.model.DeleteVpnConnectionRequest)]
   (clojure.core/let
    [v2416
     (:vpn-connection-id
      m2415
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2416 :com.palletops.awaze.client-builder/undef)
     (. bean2414 setVpnConnectionId (clojure.core/str v2416))))
   bean2414))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.PurchaseScheduledInstancesRequest}
purchase-scheduled-instances-request
  [m2418]
  (clojure.core/let
   [bean2417
    (new
     com.amazonaws.services.ec2.model.PurchaseScheduledInstancesRequest)]
   (clojure.core/let
    [v2419
     (:client-token m2418 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2419 :com.palletops.awaze.client-builder/undef)
     (. bean2417 setClientToken (clojure.core/str v2419))))
   (clojure.core/let
    [v2419
     (:purchase-requests
      m2418
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2419 :com.palletops.awaze.client-builder/undef)
     (.
      bean2417
      setPurchaseRequests
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2860] (ec2/purchase-request arg2860))
 v2419))))
   bean2417))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeReservedInstancesModificationsRequest}
describe-reserved-instances-modifications-request
  [m2421]
  (clojure.core/let
   [bean2420
    (new
     com.amazonaws.services.ec2.model.DescribeReservedInstancesModificationsRequest)]
   (clojure.core/let
    [v2422 (:filters m2421 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2422 :com.palletops.awaze.client-builder/undef)
     (.
      bean2420
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2861] (ec2/filter arg2861))
 v2422))))
   (clojure.core/let
    [v2422
     (:next-token m2421 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2422 :com.palletops.awaze.client-builder/undef)
     (. bean2420 setNextToken (clojure.core/str v2422))))
   (clojure.core/let
    [v2422
     (:reserved-instances-modification-ids
      m2421
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2422 :com.palletops.awaze.client-builder/undef)
     (.
      bean2420
      setReservedInstancesModificationIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2862] (clojure.core/str arg2862))
 v2422))))
   bean2420))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeClassicLinkInstancesRequest}
describe-classic-link-instances-request
  [m2424]
  (clojure.core/let
   [bean2423
    (new
     com.amazonaws.services.ec2.model.DescribeClassicLinkInstancesRequest)]
   (clojure.core/let
    [v2425
     (:instance-ids m2424 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2425 :com.palletops.awaze.client-builder/undef)
     (.
      bean2423
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2863] (clojure.core/str arg2863))
 v2425))))
   (clojure.core/let
    [v2425 (:filters m2424 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2425 :com.palletops.awaze.client-builder/undef)
     (.
      bean2423
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2864] (ec2/filter arg2864))
 v2425))))
   (clojure.core/let
    [v2425
     (:next-token m2424 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2425 :com.palletops.awaze.client-builder/undef)
     (. bean2423 setNextToken (clojure.core/str v2425))))
   (clojure.core/let
    [v2425
     (:max-results m2424 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2425 :com.palletops.awaze.client-builder/undef)
     (. bean2423 setMaxResults (clojure.core/int v2425))))
   bean2423))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.PurchaseReservedInstancesOfferingRequest}
purchase-reserved-instances-offering-request
  [m2427]
  (clojure.core/let
   [bean2426
    (new
     com.amazonaws.services.ec2.model.PurchaseReservedInstancesOfferingRequest)]
   (clojure.core/let
    [v2428
     (:reserved-instances-offering-id
      m2427
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2428 :com.palletops.awaze.client-builder/undef)
     (.
      bean2426
      setReservedInstancesOfferingId
      (clojure.core/str v2428))))
   (clojure.core/let
    [v2428
     (:instance-count m2427 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2428 :com.palletops.awaze.client-builder/undef)
     (. bean2426 setInstanceCount (clojure.core/int v2428))))
   (clojure.core/let
    [v2428
     (:limit-price m2427 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2428 :com.palletops.awaze.client-builder/undef)
     (.
      bean2426
      setLimitPrice
      (ec2/reserved-instance-limit-price v2428))))
   bean2426))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.StartInstancesRequest}
start-instances-request
  [m2430]
  (clojure.core/let
   [bean2429
    (new com.amazonaws.services.ec2.model.StartInstancesRequest)]
   (clojure.core/let
    [v2431
     (:instance-ids m2430 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2431 :com.palletops.awaze.client-builder/undef)
     (.
      bean2429
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2865] (clojure.core/str arg2865))
 v2431))))
   (clojure.core/let
    [v2431
     (:additional-info
      m2430
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2431 :com.palletops.awaze.client-builder/undef)
     (. bean2429 setAdditionalInfo (clojure.core/str v2431))))
   bean2429))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeInstanceAttributeRequest}
describe-instance-attribute-request
  [m2433]
  (clojure.core/let
   [bean2432
    (new
     com.amazonaws.services.ec2.model.DescribeInstanceAttributeRequest)]
   (clojure.core/let
    [v2434
     (:attribute m2433 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2434 :com.palletops.awaze.client-builder/undef)
     (. bean2432 setAttribute (clojure.core/str v2434))))
   (clojure.core/let
    [v2434
     (:instance-id m2433 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2434 :com.palletops.awaze.client-builder/undef)
     (. bean2432 setInstanceId (clojure.core/str v2434))))
   bean2432))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CancelSpotFleetRequestsRequest}
cancel-spot-fleet-requests-request
  [m2436]
  (clojure.core/let
   [bean2435
    (new
     com.amazonaws.services.ec2.model.CancelSpotFleetRequestsRequest)]
   (clojure.core/let
    [v2437
     (:spot-fleet-request-ids
      m2436
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2437 :com.palletops.awaze.client-builder/undef)
     (.
      bean2435
      setSpotFleetRequestIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2866] (clojure.core/str arg2866))
 v2437))))
   (clojure.core/let
    [v2437
     (:terminate-instances
      m2436
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2437 :com.palletops.awaze.client-builder/undef)
     (. bean2435 setTerminateInstances (clojure.core/boolean v2437))))
   bean2435))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSubnetsRequest}
describe-subnets-request
  [m2439]
  (clojure.core/let
   [bean2438
    (new com.amazonaws.services.ec2.model.DescribeSubnetsRequest)]
   (clojure.core/let
    [v2440 (:filters m2439 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2440 :com.palletops.awaze.client-builder/undef)
     (.
      bean2438
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2867] (ec2/filter arg2867))
 v2440))))
   (clojure.core/let
    [v2440
     (:subnet-ids m2439 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2440 :com.palletops.awaze.client-builder/undef)
     (.
      bean2438
      setSubnetIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2868] (clojure.core/str arg2868))
 v2440))))
   bean2438))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVolumeRequest}
create-volume-request
  [m2442]
  (clojure.core/let
   [bean2441
    (new com.amazonaws.services.ec2.model.CreateVolumeRequest)]
   (clojure.core/let
    [v2443
     (:availability-zone
      m2442
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2443 :com.palletops.awaze.client-builder/undef)
     (. bean2441 setAvailabilityZone (clojure.core/str v2443))))
   (clojure.core/let
    [v2443
     (:encrypted m2442 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2443 :com.palletops.awaze.client-builder/undef)
     (. bean2441 setEncrypted (clojure.core/boolean v2443))))
   (clojure.core/let
    [v2443
     (:kms-key-id m2442 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2443 :com.palletops.awaze.client-builder/undef)
     (. bean2441 setKmsKeyId (clojure.core/str v2443))))
   (clojure.core/let
    [v2443
     (:snapshot-id m2442 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2443 :com.palletops.awaze.client-builder/undef)
     (. bean2441 setSnapshotId (clojure.core/str v2443))))
   (clojure.core/let
    [v2443
     (:volume-type m2442 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2443 :com.palletops.awaze.client-builder/undef)
     (. bean2441 setVolumeType (clojure.core/str v2443))))
   (clojure.core/let
    [v2443 (:iops m2442 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2443 :com.palletops.awaze.client-builder/undef)
     (. bean2441 setIops (clojure.core/int v2443))))
   (clojure.core/let
    [v2443 (:size m2442 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2443 :com.palletops.awaze.client-builder/undef)
     (. bean2441 setSize (clojure.core/int v2443))))
   bean2441))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeReservedInstancesListingsRequest}
describe-reserved-instances-listings-request
  [m2445]
  (clojure.core/let
   [bean2444
    (new
     com.amazonaws.services.ec2.model.DescribeReservedInstancesListingsRequest)]
   (clojure.core/let
    [v2446
     (:reserved-instances-listing-id
      m2445
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2446 :com.palletops.awaze.client-builder/undef)
     (.
      bean2444
      setReservedInstancesListingId
      (clojure.core/str v2446))))
   (clojure.core/let
    [v2446
     (:reserved-instances-id
      m2445
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2446 :com.palletops.awaze.client-builder/undef)
     (. bean2444 setReservedInstancesId (clojure.core/str v2446))))
   (clojure.core/let
    [v2446 (:filters m2445 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2446 :com.palletops.awaze.client-builder/undef)
     (.
      bean2444
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2869] (ec2/filter arg2869))
 v2446))))
   bean2444))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateDhcpOptionsRequest}
create-dhcp-options-request
  [m2448]
  (clojure.core/let
   [bean2447
    (new com.amazonaws.services.ec2.model.CreateDhcpOptionsRequest)]
   (clojure.core/let
    [v2449
     (:dhcp-configurations
      m2448
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2449 :com.palletops.awaze.client-builder/undef)
     (.
      bean2447
      setDhcpConfigurations
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2870] (ec2/dhcp-configuration arg2870))
 v2449))))
   bean2447))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DetachInternetGatewayRequest}
detach-internet-gateway-request
  [m2451]
  (clojure.core/let
   [bean2450
    (new
     com.amazonaws.services.ec2.model.DetachInternetGatewayRequest)]
   (clojure.core/let
    [v2452 (:vpc-id m2451 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2452 :com.palletops.awaze.client-builder/undef)
     (. bean2450 setVpcId (clojure.core/str v2452))))
   (clojure.core/let
    [v2452
     (:internet-gateway-id
      m2451
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2452 :com.palletops.awaze.client-builder/undef)
     (. bean2450 setInternetGatewayId (clojure.core/str v2452))))
   bean2450))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteVpnGatewayRequest}
delete-vpn-gateway-request
  [m2454]
  (clojure.core/let
   [bean2453
    (new com.amazonaws.services.ec2.model.DeleteVpnGatewayRequest)]
   (clojure.core/let
    [v2455
     (:vpn-gateway-id m2454 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2455 :com.palletops.awaze.client-builder/undef)
     (. bean2453 setVpnGatewayId (clojure.core/str v2455))))
   bean2453))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RequestSpotInstancesRequest}
request-spot-instances-request
  [m2457]
  (clojure.core/let
   [bean2456
    (new com.amazonaws.services.ec2.model.RequestSpotInstancesRequest)]
   (clojure.core/let
    [v2458
     (:spot-price m2457 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2458 :com.palletops.awaze.client-builder/undef)
     (. bean2456 setSpotPrice (clojure.core/str v2458))))
   (clojure.core/let
    [v2458
     (:valid-from m2457 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2458 :com.palletops.awaze.client-builder/undef)
     (.
      bean2456
      setValidFrom
      (com.palletops.awaze.common/to-date v2458))))
   (clojure.core/let
    [v2458
     (:block-duration-minutes
      m2457
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2458 :com.palletops.awaze.client-builder/undef)
     (. bean2456 setBlockDurationMinutes (clojure.core/int v2458))))
   (clojure.core/let
    [v2458 (:type m2457 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2458 :com.palletops.awaze.client-builder/undef)
     (. bean2456 setType (ec2/spot-instance-type v2458))))
   (clojure.core/let
    [v2458
     (:client-token m2457 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2458 :com.palletops.awaze.client-builder/undef)
     (. bean2456 setClientToken (clojure.core/str v2458))))
   (clojure.core/let
    [v2458
     (:launch-group m2457 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2458 :com.palletops.awaze.client-builder/undef)
     (. bean2456 setLaunchGroup (clojure.core/str v2458))))
   (clojure.core/let
    [v2458
     (:instance-count m2457 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2458 :com.palletops.awaze.client-builder/undef)
     (. bean2456 setInstanceCount (clojure.core/int v2458))))
   (clojure.core/let
    [v2458
     (:launch-specification
      m2457
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2458 :com.palletops.awaze.client-builder/undef)
     (.
      bean2456
      setLaunchSpecification
      (ec2/launch-specification v2458))))
   (clojure.core/let
    [v2458
     (:valid-until m2457 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2458 :com.palletops.awaze.client-builder/undef)
     (.
      bean2456
      setValidUntil
      (com.palletops.awaze.common/to-date v2458))))
   (clojure.core/let
    [v2458
     (:availability-zone-group
      m2457
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2458 :com.palletops.awaze.client-builder/undef)
     (. bean2456 setAvailabilityZoneGroup (clojure.core/str v2458))))
   bean2456))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ImportVolumeRequest}
import-volume-request
  [m2460]
  (clojure.core/let
   [bean2459
    (new com.amazonaws.services.ec2.model.ImportVolumeRequest)]
   (clojure.core/let
    [v2461
     (:availability-zone
      m2460
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2461 :com.palletops.awaze.client-builder/undef)
     (. bean2459 setAvailabilityZone (clojure.core/str v2461))))
   (clojure.core/let
    [v2461
     (:description m2460 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2461 :com.palletops.awaze.client-builder/undef)
     (. bean2459 setDescription (clojure.core/str v2461))))
   (clojure.core/let
    [v2461 (:image m2460 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2461 :com.palletops.awaze.client-builder/undef)
     (. bean2459 setImage (ec2/disk-image-detail v2461))))
   (clojure.core/let
    [v2461 (:volume m2460 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2461 :com.palletops.awaze.client-builder/undef)
     (. bean2459 setVolume (ec2/volume-detail v2461))))
   bean2459))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ImportSnapshotRequest}
import-snapshot-request
  [m2463]
  (clojure.core/let
   [bean2462
    (new com.amazonaws.services.ec2.model.ImportSnapshotRequest)]
   (clojure.core/let
    [v2464
     (:client-token m2463 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2464 :com.palletops.awaze.client-builder/undef)
     (. bean2462 setClientToken (clojure.core/str v2464))))
   (clojure.core/let
    [v2464
     (:description m2463 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2464 :com.palletops.awaze.client-builder/undef)
     (. bean2462 setDescription (clojure.core/str v2464))))
   (clojure.core/let
    [v2464
     (:disk-container m2463 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2464 :com.palletops.awaze.client-builder/undef)
     (. bean2462 setDiskContainer (ec2/snapshot-disk-container v2464))))
   (clojure.core/let
    [v2464
     (:client-data m2463 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2464 :com.palletops.awaze.client-builder/undef)
     (. bean2462 setClientData (ec2/client-data v2464))))
   (clojure.core/let
    [v2464
     (:role-name m2463 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2464 :com.palletops.awaze.client-builder/undef)
     (. bean2462 setRoleName (clojure.core/str v2464))))
   bean2462))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeTagsRequest}
describe-tags-request
  [m2466]
  (clojure.core/let
   [bean2465
    (new com.amazonaws.services.ec2.model.DescribeTagsRequest)]
   (clojure.core/let
    [v2467 (:filters m2466 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2467 :com.palletops.awaze.client-builder/undef)
     (.
      bean2465
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2871] (ec2/filter arg2871))
 v2467))))
   (clojure.core/let
    [v2467
     (:next-token m2466 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2467 :com.palletops.awaze.client-builder/undef)
     (. bean2465 setNextToken (clojure.core/str v2467))))
   (clojure.core/let
    [v2467
     (:max-results m2466 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2467 :com.palletops.awaze.client-builder/undef)
     (. bean2465 setMaxResults (clojure.core/int v2467))))
   bean2465))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteTagsRequest}
delete-tags-request
  [m2469]
  (clojure.core/let
   [bean2468 (new com.amazonaws.services.ec2.model.DeleteTagsRequest)]
   (clojure.core/let
    [v2470
     (:resources m2469 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2470 :com.palletops.awaze.client-builder/undef)
     (.
      bean2468
      setResources
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2872] (clojure.core/str arg2872))
 v2470))))
   (clojure.core/let
    [v2470 (:tags m2469 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2470 :com.palletops.awaze.client-builder/undef)
     (.
      bean2468
      setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg2873] (ec2/tag arg2873)) v2470))))
   bean2468))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.EnableVpcClassicLinkRequest}
enable-vpc-classic-link-request
  [m2472]
  (clojure.core/let
   [bean2471
    (new com.amazonaws.services.ec2.model.EnableVpcClassicLinkRequest)]
   (clojure.core/let
    [v2473 (:vpc-id m2472 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2473 :com.palletops.awaze.client-builder/undef)
     (. bean2471 setVpcId (clojure.core/str v2473))))
   bean2471))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeReservedInstancesOfferingsRequest}
describe-reserved-instances-offerings-request
  [m2475]
  (clojure.core/let
   [bean2474
    (new
     com.amazonaws.services.ec2.model.DescribeReservedInstancesOfferingsRequest)]
   (clojure.core/let
    [v2476
     (:include-marketplace
      m2475
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2476 :com.palletops.awaze.client-builder/undef)
     (. bean2474 setIncludeMarketplace (clojure.core/boolean v2476))))
   (clojure.core/let
    [v2476
     (:reserved-instances-offering-ids
      m2475
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2476 :com.palletops.awaze.client-builder/undef)
     (.
      bean2474
      setReservedInstancesOfferingIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2874] (clojure.core/str arg2874))
 v2476))))
   (clojure.core/let
    [v2476
     (:product-description
      m2475
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2476 :com.palletops.awaze.client-builder/undef)
     (. bean2474 setProductDescription (clojure.core/str v2476))))
   (clojure.core/let
    [v2476
     (:availability-zone
      m2475
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2476 :com.palletops.awaze.client-builder/undef)
     (. bean2474 setAvailabilityZone (clojure.core/str v2476))))
   (clojure.core/let
    [v2476
     (:min-duration m2475 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2476 :com.palletops.awaze.client-builder/undef)
     (. bean2474 setMinDuration (clojure.core/long v2476))))
   (clojure.core/let
    [v2476
     (:instance-type m2475 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2476 :com.palletops.awaze.client-builder/undef)
     (. bean2474 setInstanceType (ec2/instance-type v2476))))
   (clojure.core/let
    [v2476 (:filters m2475 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2476 :com.palletops.awaze.client-builder/undef)
     (.
      bean2474
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2875] (ec2/filter arg2875))
 v2476))))
   (clojure.core/let
    [v2476
     (:offering-type m2475 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2476 :com.palletops.awaze.client-builder/undef)
     (. bean2474 setOfferingType (ec2/offering-type-values v2476))))
   (clojure.core/let
    [v2476
     (:instance-tenancy
      m2475
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2476 :com.palletops.awaze.client-builder/undef)
     (. bean2474 setInstanceTenancy (ec2/tenancy v2476))))
   (clojure.core/let
    [v2476
     (:max-duration m2475 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2476 :com.palletops.awaze.client-builder/undef)
     (. bean2474 setMaxDuration (clojure.core/long v2476))))
   (clojure.core/let
    [v2476
     (:next-token m2475 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2476 :com.palletops.awaze.client-builder/undef)
     (. bean2474 setNextToken (clojure.core/str v2476))))
   (clojure.core/let
    [v2476
     (:max-results m2475 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2476 :com.palletops.awaze.client-builder/undef)
     (. bean2474 setMaxResults (clojure.core/int v2476))))
   (clojure.core/let
    [v2476
     (:max-instance-count
      m2475
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2476 :com.palletops.awaze.client-builder/undef)
     (. bean2474 setMaxInstanceCount (clojure.core/int v2476))))
   bean2474))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVpnGatewayRequest}
create-vpn-gateway-request
  [m2478]
  (clojure.core/let
   [bean2477
    (new com.amazonaws.services.ec2.model.CreateVpnGatewayRequest)]
   (clojure.core/let
    [v2479
     (:availability-zone
      m2478
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2479 :com.palletops.awaze.client-builder/undef)
     (. bean2477 setAvailabilityZone (clojure.core/str v2479))))
   (clojure.core/let
    [v2479 (:type m2478 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2479 :com.palletops.awaze.client-builder/undef)
     (. bean2477 setType (clojure.core/str v2479))))
   bean2477))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeRouteTablesRequest}
describe-route-tables-request
  [m2481]
  (clojure.core/let
   [bean2480
    (new com.amazonaws.services.ec2.model.DescribeRouteTablesRequest)]
   (clojure.core/let
    [v2482
     (:route-table-ids
      m2481
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2482 :com.palletops.awaze.client-builder/undef)
     (.
      bean2480
      setRouteTableIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2876] (clojure.core/str arg2876))
 v2482))))
   (clojure.core/let
    [v2482 (:filters m2481 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2482 :com.palletops.awaze.client-builder/undef)
     (.
      bean2480
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2877] (ec2/filter arg2877))
 v2482))))
   bean2480))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CancelSpotInstanceRequestsRequest}
cancel-spot-instance-requests-request
  [m2484]
  (clojure.core/let
   [bean2483
    (new
     com.amazonaws.services.ec2.model.CancelSpotInstanceRequestsRequest)]
   (clojure.core/let
    [v2485
     (:spot-instance-request-ids
      m2484
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2485 :com.palletops.awaze.client-builder/undef)
     (.
      bean2483
      setSpotInstanceRequestIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2878] (clojure.core/str arg2878))
 v2485))))
   bean2483))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AssignPrivateIpAddressesRequest}
assign-private-ip-addresses-request
  [m2487]
  (clojure.core/let
   [bean2486
    (new
     com.amazonaws.services.ec2.model.AssignPrivateIpAddressesRequest)]
   (clojure.core/let
    [v2488
     (:network-interface-id
      m2487
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2488 :com.palletops.awaze.client-builder/undef)
     (. bean2486 setNetworkInterfaceId (clojure.core/str v2488))))
   (clojure.core/let
    [v2488
     (:private-ip-addresses
      m2487
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2488 :com.palletops.awaze.client-builder/undef)
     (.
      bean2486
      setPrivateIpAddresses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2879] (clojure.core/str arg2879))
 v2488))))
   (clojure.core/let
    [v2488
     (:secondary-private-ip-address-count
      m2487
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2488 :com.palletops.awaze.client-builder/undef)
     (.
      bean2486
      setSecondaryPrivateIpAddressCount
      (clojure.core/int v2488))))
   (clojure.core/let
    [v2488
     (:allow-reassignment
      m2487
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2488 :com.palletops.awaze.client-builder/undef)
     (. bean2486 setAllowReassignment (clojure.core/boolean v2488))))
   bean2486))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DisableVpcClassicLinkDnsSupportRequest}
disable-vpc-classic-link-dns-support-request
  [m2490]
  (clojure.core/let
   [bean2489
    (new
     com.amazonaws.services.ec2.model.DisableVpcClassicLinkDnsSupportRequest)]
   (clojure.core/let
    [v2491 (:vpc-id m2490 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2491 :com.palletops.awaze.client-builder/undef)
     (. bean2489 setVpcId (clojure.core/str v2491))))
   bean2489))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeletePlacementGroupRequest}
delete-placement-group-request
  [m2493]
  (clojure.core/let
   [bean2492
    (new com.amazonaws.services.ec2.model.DeletePlacementGroupRequest)]
   (clojure.core/let
    [v2494
     (:group-name m2493 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2494 :com.palletops.awaze.client-builder/undef)
     (. bean2492 setGroupName (clojure.core/str v2494))))
   bean2492))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeInstancesRequest}
describe-instances-request
  [m2496]
  (clojure.core/let
   [bean2495
    (new com.amazonaws.services.ec2.model.DescribeInstancesRequest)]
   (clojure.core/let
    [v2497
     (:instance-ids m2496 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2497 :com.palletops.awaze.client-builder/undef)
     (.
      bean2495
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2880] (clojure.core/str arg2880))
 v2497))))
   (clojure.core/let
    [v2497 (:filters m2496 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2497 :com.palletops.awaze.client-builder/undef)
     (.
      bean2495
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2881] (ec2/filter arg2881))
 v2497))))
   (clojure.core/let
    [v2497
     (:next-token m2496 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2497 :com.palletops.awaze.client-builder/undef)
     (. bean2495 setNextToken (clojure.core/str v2497))))
   (clojure.core/let
    [v2497
     (:max-results m2496 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2497 :com.palletops.awaze.client-builder/undef)
     (. bean2495 setMaxResults (clojure.core/int v2497))))
   bean2495))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVolumesRequest}
describe-volumes-request
  [m2499]
  (clojure.core/let
   [bean2498
    (new com.amazonaws.services.ec2.model.DescribeVolumesRequest)]
   (clojure.core/let
    [v2500 (:filters m2499 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2500 :com.palletops.awaze.client-builder/undef)
     (.
      bean2498
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2882] (ec2/filter arg2882))
 v2500))))
   (clojure.core/let
    [v2500
     (:next-token m2499 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2500 :com.palletops.awaze.client-builder/undef)
     (. bean2498 setNextToken (clojure.core/str v2500))))
   (clojure.core/let
    [v2500
     (:max-results m2499 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2500 :com.palletops.awaze.client-builder/undef)
     (. bean2498 setMaxResults (clojure.core/int v2500))))
   (clojure.core/let
    [v2500
     (:volume-ids m2499 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2500 :com.palletops.awaze.client-builder/undef)
     (.
      bean2498
      setVolumeIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2883] (clojure.core/str arg2883))
 v2500))))
   bean2498))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeBundleTasksRequest}
describe-bundle-tasks-request
  [m2502]
  (clojure.core/let
   [bean2501
    (new com.amazonaws.services.ec2.model.DescribeBundleTasksRequest)]
   (clojure.core/let
    [v2503 (:filters m2502 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2503 :com.palletops.awaze.client-builder/undef)
     (.
      bean2501
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2884] (ec2/filter arg2884))
 v2503))))
   (clojure.core/let
    [v2503
     (:bundle-ids m2502 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2503 :com.palletops.awaze.client-builder/undef)
     (.
      bean2501
      setBundleIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2885] (clojure.core/str arg2885))
 v2503))))
   bean2501))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AssociateDhcpOptionsRequest}
associate-dhcp-options-request
  [m2505]
  (clojure.core/let
   [bean2504
    (new com.amazonaws.services.ec2.model.AssociateDhcpOptionsRequest)]
   (clojure.core/let
    [v2506
     (:dhcp-options-id
      m2505
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2506 :com.palletops.awaze.client-builder/undef)
     (. bean2504 setDhcpOptionsId (clojure.core/str v2506))))
   (clojure.core/let
    [v2506 (:vpc-id m2505 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2506 :com.palletops.awaze.client-builder/undef)
     (. bean2504 setVpcId (clojure.core/str v2506))))
   bean2504))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyVpcAttributeRequest}
modify-vpc-attribute-request
  [m2508]
  (clojure.core/let
   [bean2507
    (new com.amazonaws.services.ec2.model.ModifyVpcAttributeRequest)]
   (clojure.core/let
    [v2509 (:vpc-id m2508 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2509 :com.palletops.awaze.client-builder/undef)
     (. bean2507 setVpcId (clojure.core/str v2509))))
   (clojure.core/let
    [v2509
     (:enable-dns-support
      m2508
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2509 :com.palletops.awaze.client-builder/undef)
     (. bean2507 setEnableDnsSupport (clojure.core/boolean v2509))))
   (clojure.core/let
    [v2509
     (:enable-dns-hostnames
      m2508
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2509 :com.palletops.awaze.client-builder/undef)
     (. bean2507 setEnableDnsHostnames (clojure.core/boolean v2509))))
   bean2507))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateFlowLogsRequest}
create-flow-logs-request
  [m2511]
  (clojure.core/let
   [bean2510
    (new com.amazonaws.services.ec2.model.CreateFlowLogsRequest)]
   (clojure.core/let
    [v2512
     (:client-token m2511 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2512 :com.palletops.awaze.client-builder/undef)
     (. bean2510 setClientToken (clojure.core/str v2512))))
   (clojure.core/let
    [v2512
     (:resource-ids m2511 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2512 :com.palletops.awaze.client-builder/undef)
     (.
      bean2510
      setResourceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2886] (clojure.core/str arg2886))
 v2512))))
   (clojure.core/let
    [v2512
     (:resource-type m2511 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2512 :com.palletops.awaze.client-builder/undef)
     (. bean2510 setResourceType (clojure.core/str v2512))))
   (clojure.core/let
    [v2512
     (:traffic-type m2511 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2512 :com.palletops.awaze.client-builder/undef)
     (. bean2510 setTrafficType (ec2/traffic-type v2512))))
   (clojure.core/let
    [v2512
     (:log-group-name m2511 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2512 :com.palletops.awaze.client-builder/undef)
     (. bean2510 setLogGroupName (clojure.core/str v2512))))
   (clojure.core/let
    [v2512
     (:deliver-logs-permission-arn
      m2511
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2512 :com.palletops.awaze.client-builder/undef)
     (. bean2510 setDeliverLogsPermissionArn (clojure.core/str v2512))))
   bean2510))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DisassociateAddressRequest}
disassociate-address-request
  [m2514]
  (clojure.core/let
   [bean2513
    (new com.amazonaws.services.ec2.model.DisassociateAddressRequest)]
   (clojure.core/let
    [v2515
     (:public-ip m2514 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2515 :com.palletops.awaze.client-builder/undef)
     (. bean2513 setPublicIp (clojure.core/str v2515))))
   (clojure.core/let
    [v2515
     (:association-id m2514 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2515 :com.palletops.awaze.client-builder/undef)
     (. bean2513 setAssociationId (clojure.core/str v2515))))
   bean2513))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ResetNetworkInterfaceAttributeRequest}
reset-network-interface-attribute-request
  [m2517]
  (clojure.core/let
   [bean2516
    (new
     com.amazonaws.services.ec2.model.ResetNetworkInterfaceAttributeRequest)]
   (clojure.core/let
    [v2518
     (:network-interface-id
      m2517
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2518 :com.palletops.awaze.client-builder/undef)
     (. bean2516 setNetworkInterfaceId (clojure.core/str v2518))))
   (clojure.core/let
    [v2518
     (:source-dest-check
      m2517
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2518 :com.palletops.awaze.client-builder/undef)
     (. bean2516 setSourceDestCheck (clojure.core/str v2518))))
   bean2516))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribePlacementGroupsRequest}
describe-placement-groups-request
  [m2520]
  (clojure.core/let
   [bean2519
    (new
     com.amazonaws.services.ec2.model.DescribePlacementGroupsRequest)]
   (clojure.core/let
    [v2521
     (:group-names m2520 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2521 :com.palletops.awaze.client-builder/undef)
     (.
      bean2519
      setGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2887] (clojure.core/str arg2887))
 v2521))))
   (clojure.core/let
    [v2521 (:filters m2520 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2521 :com.palletops.awaze.client-builder/undef)
     (.
      bean2519
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2888] (ec2/filter arg2888))
 v2521))))
   bean2519))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ResetSnapshotAttributeRequest}
reset-snapshot-attribute-request
  [m2523]
  (clojure.core/let
   [bean2522
    (new
     com.amazonaws.services.ec2.model.ResetSnapshotAttributeRequest)]
   (clojure.core/let
    [v2524
     (:attribute m2523 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2524 :com.palletops.awaze.client-builder/undef)
     (. bean2522 setAttribute (clojure.core/str v2524))))
   (clojure.core/let
    [v2524
     (:snapshot-id m2523 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2524 :com.palletops.awaze.client-builder/undef)
     (. bean2522 setSnapshotId (clojure.core/str v2524))))
   bean2522))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReleaseAddressRequest}
release-address-request
  [m2526]
  (clojure.core/let
   [bean2525
    (new com.amazonaws.services.ec2.model.ReleaseAddressRequest)]
   (clojure.core/let
    [v2527
     (:public-ip m2526 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2527 :com.palletops.awaze.client-builder/undef)
     (. bean2525 setPublicIp (clojure.core/str v2527))))
   (clojure.core/let
    [v2527
     (:allocation-id m2526 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2527 :com.palletops.awaze.client-builder/undef)
     (. bean2525 setAllocationId (clojure.core/str v2527))))
   bean2525))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVolumeStatusRequest}
describe-volume-status-request
  [m2529]
  (clojure.core/let
   [bean2528
    (new com.amazonaws.services.ec2.model.DescribeVolumeStatusRequest)]
   (clojure.core/let
    [v2530 (:filters m2529 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2530 :com.palletops.awaze.client-builder/undef)
     (.
      bean2528
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2889] (ec2/filter arg2889))
 v2530))))
   (clojure.core/let
    [v2530
     (:next-token m2529 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2530 :com.palletops.awaze.client-builder/undef)
     (. bean2528 setNextToken (clojure.core/str v2530))))
   (clojure.core/let
    [v2530
     (:max-results m2529 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2530 :com.palletops.awaze.client-builder/undef)
     (. bean2528 setMaxResults (clojure.core/int v2530))))
   (clojure.core/let
    [v2530
     (:volume-ids m2529 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2530 :com.palletops.awaze.client-builder/undef)
     (.
      bean2528
      setVolumeIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2890] (clojure.core/str arg2890))
 v2530))))
   bean2528))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.BundleInstanceRequest}
bundle-instance-request
  [m2532]
  (clojure.core/let
   [bean2531
    (new com.amazonaws.services.ec2.model.BundleInstanceRequest)]
   (clojure.core/let
    [v2533
     (:instance-id m2532 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2533 :com.palletops.awaze.client-builder/undef)
     (. bean2531 setInstanceId (clojure.core/str v2533))))
   (clojure.core/let
    [v2533 (:storage m2532 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2533 :com.palletops.awaze.client-builder/undef)
     (. bean2531 setStorage (ec2/storage v2533))))
   bean2531))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVpnConnectionsRequest}
describe-vpn-connections-request
  [m2535]
  (clojure.core/let
   [bean2534
    (new
     com.amazonaws.services.ec2.model.DescribeVpnConnectionsRequest)]
   (clojure.core/let
    [v2536 (:filters m2535 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2536 :com.palletops.awaze.client-builder/undef)
     (.
      bean2534
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2891] (ec2/filter arg2891))
 v2536))))
   (clojure.core/let
    [v2536
     (:vpn-connection-ids
      m2535
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2536 :com.palletops.awaze.client-builder/undef)
     (.
      bean2534
      setVpnConnectionIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2892] (clojure.core/str arg2892))
 v2536))))
   bean2534))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateRouteRequest}
create-route-request
  [m2538]
  (clojure.core/let
   [bean2537
    (new com.amazonaws.services.ec2.model.CreateRouteRequest)]
   (clojure.core/let
    [v2539
     (:network-interface-id
      m2538
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2539 :com.palletops.awaze.client-builder/undef)
     (. bean2537 setNetworkInterfaceId (clojure.core/str v2539))))
   (clojure.core/let
    [v2539
     (:instance-id m2538 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2539 :com.palletops.awaze.client-builder/undef)
     (. bean2537 setInstanceId (clojure.core/str v2539))))
   (clojure.core/let
    [v2539
     (:route-table-id m2538 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2539 :com.palletops.awaze.client-builder/undef)
     (. bean2537 setRouteTableId (clojure.core/str v2539))))
   (clojure.core/let
    [v2539
     (:vpc-peering-connection-id
      m2538
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2539 :com.palletops.awaze.client-builder/undef)
     (. bean2537 setVpcPeeringConnectionId (clojure.core/str v2539))))
   (clojure.core/let
    [v2539
     (:destination-cidr-block
      m2538
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2539 :com.palletops.awaze.client-builder/undef)
     (. bean2537 setDestinationCidrBlock (clojure.core/str v2539))))
   (clojure.core/let
    [v2539
     (:gateway-id m2538 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2539 :com.palletops.awaze.client-builder/undef)
     (. bean2537 setGatewayId (clojure.core/str v2539))))
   (clojure.core/let
    [v2539
     (:nat-gateway-id m2538 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2539 :com.palletops.awaze.client-builder/undef)
     (. bean2537 setNatGatewayId (clojure.core/str v2539))))
   bean2537))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSpotPriceHistoryRequest}
describe-spot-price-history-request
  [m2541]
  (clojure.core/let
   [bean2540
    (new
     com.amazonaws.services.ec2.model.DescribeSpotPriceHistoryRequest)]
   (clojure.core/let
    [v2542
     (:availability-zone
      m2541
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2542 :com.palletops.awaze.client-builder/undef)
     (. bean2540 setAvailabilityZone (clojure.core/str v2542))))
   (clojure.core/let
    [v2542
     (:start-time m2541 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2542 :com.palletops.awaze.client-builder/undef)
     (.
      bean2540
      setStartTime
      (com.palletops.awaze.common/to-date v2542))))
   (clojure.core/let
    [v2542
     (:end-time m2541 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2542 :com.palletops.awaze.client-builder/undef)
     (.
      bean2540
      setEndTime
      (com.palletops.awaze.common/to-date v2542))))
   (clojure.core/let
    [v2542 (:filters m2541 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2542 :com.palletops.awaze.client-builder/undef)
     (.
      bean2540
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2893] (ec2/filter arg2893))
 v2542))))
   (clojure.core/let
    [v2542
     (:next-token m2541 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2542 :com.palletops.awaze.client-builder/undef)
     (. bean2540 setNextToken (clojure.core/str v2542))))
   (clojure.core/let
    [v2542
     (:max-results m2541 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2542 :com.palletops.awaze.client-builder/undef)
     (. bean2540 setMaxResults (clojure.core/int v2542))))
   (clojure.core/let
    [v2542
     (:instance-types m2541 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2542 :com.palletops.awaze.client-builder/undef)
     (.
      bean2540
      setInstanceTypes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2894] (clojure.core/str arg2894))
 v2542))))
   (clojure.core/let
    [v2542
     (:product-descriptions
      m2541
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2542 :com.palletops.awaze.client-builder/undef)
     (.
      bean2540
      setProductDescriptions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2895] (clojure.core/str arg2895))
 v2542))))
   bean2540))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeAvailabilityZonesRequest}
describe-availability-zones-request
  [m2544]
  (clojure.core/let
   [bean2543
    (new
     com.amazonaws.services.ec2.model.DescribeAvailabilityZonesRequest)]
   (clojure.core/let
    [v2545
     (:zone-names m2544 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2545 :com.palletops.awaze.client-builder/undef)
     (.
      bean2543
      setZoneNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2896] (clojure.core/str arg2896))
 v2545))))
   (clojure.core/let
    [v2545 (:filters m2544 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2545 :com.palletops.awaze.client-builder/undef)
     (.
      bean2543
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2897] (ec2/filter arg2897))
 v2545))))
   bean2543))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVpcPeeringConnectionRequest}
create-vpc-peering-connection-request
  [m2547]
  (clojure.core/let
   [bean2546
    (new
     com.amazonaws.services.ec2.model.CreateVpcPeeringConnectionRequest)]
   (clojure.core/let
    [v2548 (:vpc-id m2547 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2548 :com.palletops.awaze.client-builder/undef)
     (. bean2546 setVpcId (clojure.core/str v2548))))
   (clojure.core/let
    [v2548
     (:peer-vpc-id m2547 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2548 :com.palletops.awaze.client-builder/undef)
     (. bean2546 setPeerVpcId (clojure.core/str v2548))))
   (clojure.core/let
    [v2548
     (:peer-owner-id m2547 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2548 :com.palletops.awaze.client-builder/undef)
     (. bean2546 setPeerOwnerId (clojure.core/str v2548))))
   bean2546))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeInternetGatewaysRequest}
describe-internet-gateways-request
  [m2550]
  (clojure.core/let
   [bean2549
    (new
     com.amazonaws.services.ec2.model.DescribeInternetGatewaysRequest)]
   (clojure.core/let
    [v2551 (:filters m2550 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2551 :com.palletops.awaze.client-builder/undef)
     (.
      bean2549
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2898] (ec2/filter arg2898))
 v2551))))
   (clojure.core/let
    [v2551
     (:internet-gateway-ids
      m2550
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2551 :com.palletops.awaze.client-builder/undef)
     (.
      bean2549
      setInternetGatewayIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2899] (clojure.core/str arg2899))
 v2551))))
   bean2549))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DisassociateRouteTableRequest}
disassociate-route-table-request
  [m2553]
  (clojure.core/let
   [bean2552
    (new
     com.amazonaws.services.ec2.model.DisassociateRouteTableRequest)]
   (clojure.core/let
    [v2554
     (:association-id m2553 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2554 :com.palletops.awaze.client-builder/undef)
     (. bean2552 setAssociationId (clojure.core/str v2554))))
   bean2552))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeRegionsRequest}
describe-regions-request
  [m2556]
  (clojure.core/let
   [bean2555
    (new com.amazonaws.services.ec2.model.DescribeRegionsRequest)]
   (clojure.core/let
    [v2557 (:filters m2556 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2557 :com.palletops.awaze.client-builder/undef)
     (.
      bean2555
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2900] (ec2/filter arg2900))
 v2557))))
   (clojure.core/let
    [v2557
     (:region-names m2556 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2557 :com.palletops.awaze.client-builder/undef)
     (.
      bean2555
      setRegionNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2901] (clojure.core/str arg2901))
 v2557))))
   bean2555))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.EnableVpcClassicLinkDnsSupportRequest}
enable-vpc-classic-link-dns-support-request
  [m2559]
  (clojure.core/let
   [bean2558
    (new
     com.amazonaws.services.ec2.model.EnableVpcClassicLinkDnsSupportRequest)]
   (clojure.core/let
    [v2560 (:vpc-id m2559 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2560 :com.palletops.awaze.client-builder/undef)
     (. bean2558 setVpcId (clojure.core/str v2560))))
   bean2558))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeregisterImageRequest}
deregister-image-request
  [m2562]
  (clojure.core/let
   [bean2561
    (new com.amazonaws.services.ec2.model.DeregisterImageRequest)]
   (clojure.core/let
    [v2563
     (:image-id m2562 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2563 :com.palletops.awaze.client-builder/undef)
     (. bean2561 setImageId (clojure.core/str v2563))))
   bean2561))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteSpotDatafeedSubscriptionRequest}
delete-spot-datafeed-subscription-request
  [m2565]
  (clojure.core/let
   [bean2564
    (new
     com.amazonaws.services.ec2.model.DeleteSpotDatafeedSubscriptionRequest)]
   bean2564))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeCustomerGatewaysRequest}
describe-customer-gateways-request
  [m2568]
  (clojure.core/let
   [bean2567
    (new
     com.amazonaws.services.ec2.model.DescribeCustomerGatewaysRequest)]
   (clojure.core/let
    [v2569 (:filters m2568 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2569 :com.palletops.awaze.client-builder/undef)
     (.
      bean2567
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2902] (ec2/filter arg2902))
 v2569))))
   (clojure.core/let
    [v2569
     (:customer-gateway-ids
      m2568
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2569 :com.palletops.awaze.client-builder/undef)
     (.
      bean2567
      setCustomerGatewayIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2903] (clojure.core/str arg2903))
 v2569))))
   bean2567))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSpotFleetRequestHistoryRequest}
describe-spot-fleet-request-history-request
  [m2571]
  (clojure.core/let
   [bean2570
    (new
     com.amazonaws.services.ec2.model.DescribeSpotFleetRequestHistoryRequest)]
   (clojure.core/let
    [v2572
     (:spot-fleet-request-id
      m2571
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2572 :com.palletops.awaze.client-builder/undef)
     (. bean2570 setSpotFleetRequestId (clojure.core/str v2572))))
   (clojure.core/let
    [v2572
     (:start-time m2571 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2572 :com.palletops.awaze.client-builder/undef)
     (.
      bean2570
      setStartTime
      (com.palletops.awaze.common/to-date v2572))))
   (clojure.core/let
    [v2572
     (:next-token m2571 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2572 :com.palletops.awaze.client-builder/undef)
     (. bean2570 setNextToken (clojure.core/str v2572))))
   (clojure.core/let
    [v2572
     (:max-results m2571 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2572 :com.palletops.awaze.client-builder/undef)
     (. bean2570 setMaxResults (clojure.core/int v2572))))
   (clojure.core/let
    [v2572
     (:event-type m2571 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2572 :com.palletops.awaze.client-builder/undef)
     (. bean2570 setEventType (ec2/event-type v2572))))
   bean2570))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateSubnetRequest}
create-subnet-request
  [m2574]
  (clojure.core/let
   [bean2573
    (new com.amazonaws.services.ec2.model.CreateSubnetRequest)]
   (clojure.core/let
    [v2575
     (:availability-zone
      m2574
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2575 :com.palletops.awaze.client-builder/undef)
     (. bean2573 setAvailabilityZone (clojure.core/str v2575))))
   (clojure.core/let
    [v2575 (:vpc-id m2574 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2575 :com.palletops.awaze.client-builder/undef)
     (. bean2573 setVpcId (clojure.core/str v2575))))
   (clojure.core/let
    [v2575
     (:cidr-block m2574 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2575 :com.palletops.awaze.client-builder/undef)
     (. bean2573 setCidrBlock (clojure.core/str v2575))))
   bean2573))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeNetworkInterfaceAttributeRequest}
describe-network-interface-attribute-request
  [m2577]
  (clojure.core/let
   [bean2576
    (new
     com.amazonaws.services.ec2.model.DescribeNetworkInterfaceAttributeRequest)]
   (clojure.core/let
    [v2578
     (:attribute m2577 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2578 :com.palletops.awaze.client-builder/undef)
     (. bean2576 setAttribute (ec2/network-interface-attribute v2578))))
   (clojure.core/let
    [v2578
     (:network-interface-id
      m2577
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2578 :com.palletops.awaze.client-builder/undef)
     (. bean2576 setNetworkInterfaceId (clojure.core/str v2578))))
   bean2576))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyInstancePlacementRequest}
modify-instance-placement-request
  [m2580]
  (clojure.core/let
   [bean2579
    (new
     com.amazonaws.services.ec2.model.ModifyInstancePlacementRequest)]
   (clojure.core/let
    [v2581
     (:instance-id m2580 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2581 :com.palletops.awaze.client-builder/undef)
     (. bean2579 setInstanceId (clojure.core/str v2581))))
   (clojure.core/let
    [v2581 (:tenancy m2580 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2581 :com.palletops.awaze.client-builder/undef)
     (. bean2579 setTenancy (ec2/host-tenancy v2581))))
   (clojure.core/let
    [v2581
     (:affinity m2580 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2581 :com.palletops.awaze.client-builder/undef)
     (. bean2579 setAffinity (clojure.core/str v2581))))
   (clojure.core/let
    [v2581 (:host-id m2580 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2581 :com.palletops.awaze.client-builder/undef)
     (. bean2579 setHostId (clojure.core/str v2581))))
   bean2579))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DetachClassicLinkVpcRequest}
detach-classic-link-vpc-request
  [m2583]
  (clojure.core/let
   [bean2582
    (new com.amazonaws.services.ec2.model.DetachClassicLinkVpcRequest)]
   (clojure.core/let
    [v2584
     (:instance-id m2583 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2584 :com.palletops.awaze.client-builder/undef)
     (. bean2582 setInstanceId (clojure.core/str v2584))))
   (clojure.core/let
    [v2584 (:vpc-id m2583 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2584 :com.palletops.awaze.client-builder/undef)
     (. bean2582 setVpcId (clojure.core/str v2584))))
   bean2582))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CancelConversionTaskRequest}
cancel-conversion-task-request
  [m2586]
  (clojure.core/let
   [bean2585
    (new com.amazonaws.services.ec2.model.CancelConversionTaskRequest)]
   (clojure.core/let
    [v2587
     (:conversion-task-id
      m2586
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2587 :com.palletops.awaze.client-builder/undef)
     (. bean2585 setConversionTaskId (clojure.core/str v2587))))
   (clojure.core/let
    [v2587
     (:reason-message m2586 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2587 :com.palletops.awaze.client-builder/undef)
     (. bean2585 setReasonMessage (clojure.core/str v2587))))
   bean2585))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateNetworkInterfaceRequest}
create-network-interface-request
  [m2589]
  (clojure.core/let
   [bean2588
    (new
     com.amazonaws.services.ec2.model.CreateNetworkInterfaceRequest)]
   (clojure.core/let
    [v2590
     (:subnet-id m2589 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2590 :com.palletops.awaze.client-builder/undef)
     (. bean2588 setSubnetId (clojure.core/str v2590))))
   (clojure.core/let
    [v2590
     (:private-ip-addresses
      m2589
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2590 :com.palletops.awaze.client-builder/undef)
     (.
      bean2588
      setPrivateIpAddresses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg2904]
  (ec2/private-ip-address-specification arg2904))
 v2590))))
   (clojure.core/let
    [v2590
     (:secondary-private-ip-address-count
      m2589
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2590 :com.palletops.awaze.client-builder/undef)
     (.
      bean2588
      setSecondaryPrivateIpAddressCount
      (clojure.core/int v2590))))
   (clojure.core/let
    [v2590
     (:private-ip-address
      m2589
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2590 :com.palletops.awaze.client-builder/undef)
     (. bean2588 setPrivateIpAddress (clojure.core/str v2590))))
   (clojure.core/let
    [v2590 (:groups m2589 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2590 :com.palletops.awaze.client-builder/undef)
     (.
      bean2588
      setGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2905] (clojure.core/str arg2905))
 v2590))))
   (clojure.core/let
    [v2590
     (:description m2589 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2590 :com.palletops.awaze.client-builder/undef)
     (. bean2588 setDescription (clojure.core/str v2590))))
   bean2588))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyImageAttributeRequest}
modify-image-attribute-request
  [m2592]
  (clojure.core/let
   [bean2591
    (new com.amazonaws.services.ec2.model.ModifyImageAttributeRequest)]
   (clojure.core/let
    [v2593
     (:description m2592 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2593 :com.palletops.awaze.client-builder/undef)
     (. bean2591 setDescription (clojure.core/str v2593))))
   (clojure.core/let
    [v2593
     (:operation-type m2592 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2593 :com.palletops.awaze.client-builder/undef)
     (. bean2591 setOperationType (ec2/operation-type v2593))))
   (clojure.core/let
    [v2593
     (:product-codes m2592 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2593 :com.palletops.awaze.client-builder/undef)
     (.
      bean2591
      setProductCodes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2906] (clojure.core/str arg2906))
 v2593))))
   (clojure.core/let
    [v2593
     (:user-ids m2592 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2593 :com.palletops.awaze.client-builder/undef)
     (.
      bean2591
      setUserIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2907] (clojure.core/str arg2907))
 v2593))))
   (clojure.core/let
    [v2593
     (:attribute m2592 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2593 :com.palletops.awaze.client-builder/undef)
     (. bean2591 setAttribute (clojure.core/str v2593))))
   (clojure.core/let
    [v2593
     (:image-id m2592 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2593 :com.palletops.awaze.client-builder/undef)
     (. bean2591 setImageId (clojure.core/str v2593))))
   (clojure.core/let
    [v2593
     (:launch-permission
      m2592
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2593 :com.palletops.awaze.client-builder/undef)
     (.
      bean2591
      setLaunchPermission
      (ec2/launch-permission-modifications v2593))))
   (clojure.core/let
    [v2593 (:value m2592 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2593 :com.palletops.awaze.client-builder/undef)
     (. bean2591 setValue (clojure.core/str v2593))))
   (clojure.core/let
    [v2593
     (:user-groups m2592 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2593 :com.palletops.awaze.client-builder/undef)
     (.
      bean2591
      setUserGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2908] (clojure.core/str arg2908))
 v2593))))
   bean2591))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteRouteTableRequest}
delete-route-table-request
  [m2595]
  (clojure.core/let
   [bean2594
    (new com.amazonaws.services.ec2.model.DeleteRouteTableRequest)]
   (clojure.core/let
    [v2596
     (:route-table-id m2595 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2596 :com.palletops.awaze.client-builder/undef)
     (. bean2594 setRouteTableId (clojure.core/str v2596))))
   bean2594))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AssociateRouteTableRequest}
associate-route-table-request
  [m2598]
  (clojure.core/let
   [bean2597
    (new com.amazonaws.services.ec2.model.AssociateRouteTableRequest)]
   (clojure.core/let
    [v2599
     (:subnet-id m2598 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2599 :com.palletops.awaze.client-builder/undef)
     (. bean2597 setSubnetId (clojure.core/str v2599))))
   (clojure.core/let
    [v2599
     (:route-table-id m2598 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2599 :com.palletops.awaze.client-builder/undef)
     (. bean2597 setRouteTableId (clojure.core/str v2599))))
   bean2597))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteCustomerGatewayRequest}
delete-customer-gateway-request
  [m2601]
  (clojure.core/let
   [bean2600
    (new
     com.amazonaws.services.ec2.model.DeleteCustomerGatewayRequest)]
   (clojure.core/let
    [v2602
     (:customer-gateway-id
      m2601
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2602 :com.palletops.awaze.client-builder/undef)
     (. bean2600 setCustomerGatewayId (clojure.core/str v2602))))
   bean2600))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReplaceRouteTableAssociationRequest}
replace-route-table-association-request
  [m2604]
  (clojure.core/let
   [bean2603
    (new
     com.amazonaws.services.ec2.model.ReplaceRouteTableAssociationRequest)]
   (clojure.core/let
    [v2605
     (:route-table-id m2604 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2605 :com.palletops.awaze.client-builder/undef)
     (. bean2603 setRouteTableId (clojure.core/str v2605))))
   (clojure.core/let
    [v2605
     (:association-id m2604 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2605 :com.palletops.awaze.client-builder/undef)
     (. bean2603 setAssociationId (clojure.core/str v2605))))
   bean2603))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteVpcRequest}
delete-vpc-request
  [m2607]
  (clojure.core/let
   [bean2606 (new com.amazonaws.services.ec2.model.DeleteVpcRequest)]
   (clojure.core/let
    [v2608 (:vpc-id m2607 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2608 :com.palletops.awaze.client-builder/undef)
     (. bean2606 setVpcId (clojure.core/str v2608))))
   bean2606))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateKeyPairRequest}
create-key-pair-request
  [m2610]
  (clojure.core/let
   [bean2609
    (new com.amazonaws.services.ec2.model.CreateKeyPairRequest)]
   (clojure.core/let
    [v2611
     (:key-name m2610 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2611 :com.palletops.awaze.client-builder/undef)
     (. bean2609 setKeyName (clojure.core/str v2611))))
   bean2609))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AllocateHostsRequest}
allocate-hosts-request
  [m2613]
  (clojure.core/let
   [bean2612
    (new com.amazonaws.services.ec2.model.AllocateHostsRequest)]
   (clojure.core/let
    [v2614
     (:quantity m2613 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2614 :com.palletops.awaze.client-builder/undef)
     (. bean2612 setQuantity (clojure.core/int v2614))))
   (clojure.core/let
    [v2614
     (:auto-placement m2613 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2614 :com.palletops.awaze.client-builder/undef)
     (. bean2612 setAutoPlacement (ec2/auto-placement v2614))))
   (clojure.core/let
    [v2614
     (:client-token m2613 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2614 :com.palletops.awaze.client-builder/undef)
     (. bean2612 setClientToken (clojure.core/str v2614))))
   (clojure.core/let
    [v2614
     (:instance-type m2613 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2614 :com.palletops.awaze.client-builder/undef)
     (. bean2612 setInstanceType (clojure.core/str v2614))))
   (clojure.core/let
    [v2614
     (:availability-zone
      m2613
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2614 :com.palletops.awaze.client-builder/undef)
     (. bean2612 setAvailabilityZone (clojure.core/str v2614))))
   bean2612))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReplaceRouteRequest}
replace-route-request
  [m2616]
  (clojure.core/let
   [bean2615
    (new com.amazonaws.services.ec2.model.ReplaceRouteRequest)]
   (clojure.core/let
    [v2617
     (:network-interface-id
      m2616
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2617 :com.palletops.awaze.client-builder/undef)
     (. bean2615 setNetworkInterfaceId (clojure.core/str v2617))))
   (clojure.core/let
    [v2617
     (:instance-id m2616 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2617 :com.palletops.awaze.client-builder/undef)
     (. bean2615 setInstanceId (clojure.core/str v2617))))
   (clojure.core/let
    [v2617
     (:route-table-id m2616 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2617 :com.palletops.awaze.client-builder/undef)
     (. bean2615 setRouteTableId (clojure.core/str v2617))))
   (clojure.core/let
    [v2617
     (:vpc-peering-connection-id
      m2616
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2617 :com.palletops.awaze.client-builder/undef)
     (. bean2615 setVpcPeeringConnectionId (clojure.core/str v2617))))
   (clojure.core/let
    [v2617
     (:destination-cidr-block
      m2616
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2617 :com.palletops.awaze.client-builder/undef)
     (. bean2615 setDestinationCidrBlock (clojure.core/str v2617))))
   (clojure.core/let
    [v2617
     (:gateway-id m2616 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2617 :com.palletops.awaze.client-builder/undef)
     (. bean2615 setGatewayId (clojure.core/str v2617))))
   (clojure.core/let
    [v2617
     (:nat-gateway-id m2616 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2617 :com.palletops.awaze.client-builder/undef)
     (. bean2615 setNatGatewayId (clojure.core/str v2617))))
   bean2615))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.TerminateInstancesRequest}
terminate-instances-request
  [m2619]
  (clojure.core/let
   [bean2618
    (new com.amazonaws.services.ec2.model.TerminateInstancesRequest)]
   (clojure.core/let
    [v2620
     (:instance-ids m2619 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2620 :com.palletops.awaze.client-builder/undef)
     (.
      bean2618
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2909] (clojure.core/str arg2909))
 v2620))))
   bean2618))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSnapshotsRequest}
describe-snapshots-request
  [m2622]
  (clojure.core/let
   [bean2621
    (new com.amazonaws.services.ec2.model.DescribeSnapshotsRequest)]
   (clojure.core/let
    [v2623 (:filters m2622 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2623 :com.palletops.awaze.client-builder/undef)
     (.
      bean2621
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2910] (ec2/filter arg2910))
 v2623))))
   (clojure.core/let
    [v2623
     (:next-token m2622 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2623 :com.palletops.awaze.client-builder/undef)
     (. bean2621 setNextToken (clojure.core/str v2623))))
   (clojure.core/let
    [v2623
     (:max-results m2622 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2623 :com.palletops.awaze.client-builder/undef)
     (. bean2621 setMaxResults (clojure.core/int v2623))))
   (clojure.core/let
    [v2623
     (:snapshot-ids m2622 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2623 :com.palletops.awaze.client-builder/undef)
     (.
      bean2621
      setSnapshotIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2911] (clojure.core/str arg2911))
 v2623))))
   (clojure.core/let
    [v2623
     (:owner-ids m2622 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2623 :com.palletops.awaze.client-builder/undef)
     (.
      bean2621
      setOwnerIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2912] (clojure.core/str arg2912))
 v2623))))
   (clojure.core/let
    [v2623
     (:restorable-by-user-ids
      m2622
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2623 :com.palletops.awaze.client-builder/undef)
     (.
      bean2621
      setRestorableByUserIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2913] (clojure.core/str arg2913))
 v2623))))
   bean2621))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVpnGatewaysRequest}
describe-vpn-gateways-request
  [m2625]
  (clojure.core/let
   [bean2624
    (new com.amazonaws.services.ec2.model.DescribeVpnGatewaysRequest)]
   (clojure.core/let
    [v2626 (:filters m2625 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2626 :com.palletops.awaze.client-builder/undef)
     (.
      bean2624
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2914] (ec2/filter arg2914))
 v2626))))
   (clojure.core/let
    [v2626
     (:vpn-gateway-ids
      m2625
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2626 :com.palletops.awaze.client-builder/undef)
     (.
      bean2624
      setVpnGatewayIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2915] (clojure.core/str arg2915))
 v2626))))
   bean2624))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.GetPasswordDataRequest}
get-password-data-request
  [m2628]
  (clojure.core/let
   [bean2627
    (new com.amazonaws.services.ec2.model.GetPasswordDataRequest)]
   (clojure.core/let
    [v2629
     (:instance-id m2628 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2629 :com.palletops.awaze.client-builder/undef)
     (. bean2627 setInstanceId (clojure.core/str v2629))))
   bean2627))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyVolumeAttributeRequest}
modify-volume-attribute-request
  [m2631]
  (clojure.core/let
   [bean2630
    (new
     com.amazonaws.services.ec2.model.ModifyVolumeAttributeRequest)]
   (clojure.core/let
    [v2632
     (:volume-id m2631 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2632 :com.palletops.awaze.client-builder/undef)
     (. bean2630 setVolumeId (clojure.core/str v2632))))
   (clojure.core/let
    [v2632
     (:auto-enable-io m2631 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2632 :com.palletops.awaze.client-builder/undef)
     (. bean2630 setAutoEnableIO (clojure.core/boolean v2632))))
   bean2630))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DisableVgwRoutePropagationRequest}
disable-vgw-route-propagation-request
  [m2634]
  (clojure.core/let
   [bean2633
    (new
     com.amazonaws.services.ec2.model.DisableVgwRoutePropagationRequest)]
   (clojure.core/let
    [v2635
     (:route-table-id m2634 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2635 :com.palletops.awaze.client-builder/undef)
     (. bean2633 setRouteTableId (clojure.core/str v2635))))
   (clojure.core/let
    [v2635
     (:gateway-id m2634 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2635 :com.palletops.awaze.client-builder/undef)
     (. bean2633 setGatewayId (clojure.core/str v2635))))
   bean2633))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSpotFleetInstancesRequest}
describe-spot-fleet-instances-request
  [m2637]
  (clojure.core/let
   [bean2636
    (new
     com.amazonaws.services.ec2.model.DescribeSpotFleetInstancesRequest)]
   (clojure.core/let
    [v2638
     (:spot-fleet-request-id
      m2637
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2638 :com.palletops.awaze.client-builder/undef)
     (. bean2636 setSpotFleetRequestId (clojure.core/str v2638))))
   (clojure.core/let
    [v2638
     (:next-token m2637 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2638 :com.palletops.awaze.client-builder/undef)
     (. bean2636 setNextToken (clojure.core/str v2638))))
   (clojure.core/let
    [v2638
     (:max-results m2637 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2638 :com.palletops.awaze.client-builder/undef)
     (. bean2636 setMaxResults (clojure.core/int v2638))))
   bean2636))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribePrefixListsRequest}
describe-prefix-lists-request
  [m2640]
  (clojure.core/let
   [bean2639
    (new com.amazonaws.services.ec2.model.DescribePrefixListsRequest)]
   (clojure.core/let
    [v2641 (:filters m2640 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2641 :com.palletops.awaze.client-builder/undef)
     (.
      bean2639
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2916] (ec2/filter arg2916))
 v2641))))
   (clojure.core/let
    [v2641
     (:next-token m2640 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2641 :com.palletops.awaze.client-builder/undef)
     (. bean2639 setNextToken (clojure.core/str v2641))))
   (clojure.core/let
    [v2641
     (:max-results m2640 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2641 :com.palletops.awaze.client-builder/undef)
     (. bean2639 setMaxResults (clojure.core/int v2641))))
   (clojure.core/let
    [v2641
     (:prefix-list-ids
      m2640
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2641 :com.palletops.awaze.client-builder/undef)
     (.
      bean2639
      setPrefixListIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2917] (clojure.core/str arg2917))
 v2641))))
   bean2639))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeAccountAttributesRequest}
describe-account-attributes-request
  [m2643]
  (clojure.core/let
   [bean2642
    (new
     com.amazonaws.services.ec2.model.DescribeAccountAttributesRequest)]
   (clojure.core/let
    [v2644
     (:attribute-names
      m2643
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2644 :com.palletops.awaze.client-builder/undef)
     (.
      bean2642
      setAttributeNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2918] (clojure.core/str arg2918))
 v2644))))
   bean2642))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVpnConnectionRequest}
create-vpn-connection-request
  [m2646]
  (clojure.core/let
   [bean2645
    (new com.amazonaws.services.ec2.model.CreateVpnConnectionRequest)]
   (clojure.core/let
    [v2647
     (:vpn-gateway-id m2646 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2647 :com.palletops.awaze.client-builder/undef)
     (. bean2645 setVpnGatewayId (clojure.core/str v2647))))
   (clojure.core/let
    [v2647 (:type m2646 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2647 :com.palletops.awaze.client-builder/undef)
     (. bean2645 setType (clojure.core/str v2647))))
   (clojure.core/let
    [v2647
     (:customer-gateway-id
      m2646
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2647 :com.palletops.awaze.client-builder/undef)
     (. bean2645 setCustomerGatewayId (clojure.core/str v2647))))
   (clojure.core/let
    [v2647 (:options m2646 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2647 :com.palletops.awaze.client-builder/undef)
     (.
      bean2645
      setOptions
      (ec2/vpn-connection-options-specification v2647))))
   bean2645))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVpcPeeringConnectionsRequest}
describe-vpc-peering-connections-request
  [m2649]
  (clojure.core/let
   [bean2648
    (new
     com.amazonaws.services.ec2.model.DescribeVpcPeeringConnectionsRequest)]
   (clojure.core/let
    [v2650 (:filters m2649 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2650 :com.palletops.awaze.client-builder/undef)
     (.
      bean2648
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2919] (ec2/filter arg2919))
 v2650))))
   (clojure.core/let
    [v2650
     (:vpc-peering-connection-ids
      m2649
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2650 :com.palletops.awaze.client-builder/undef)
     (.
      bean2648
      setVpcPeeringConnectionIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2920] (clojure.core/str arg2920))
 v2650))))
   bean2648))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeScheduledInstanceAvailabilityRequest}
describe-scheduled-instance-availability-request
  [m2652]
  (clojure.core/let
   [bean2651
    (new
     com.amazonaws.services.ec2.model.DescribeScheduledInstanceAvailabilityRequest)]
   (clojure.core/let
    [v2653 (:filters m2652 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2653 :com.palletops.awaze.client-builder/undef)
     (.
      bean2651
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2921] (ec2/filter arg2921))
 v2653))))
   (clojure.core/let
    [v2653
     (:next-token m2652 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2653 :com.palletops.awaze.client-builder/undef)
     (. bean2651 setNextToken (clojure.core/str v2653))))
   (clojure.core/let
    [v2653
     (:max-results m2652 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2653 :com.palletops.awaze.client-builder/undef)
     (. bean2651 setMaxResults (clojure.core/int v2653))))
   (clojure.core/let
    [v2653
     (:recurrence m2652 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2653 :com.palletops.awaze.client-builder/undef)
     (.
      bean2651
      setRecurrence
      (ec2/scheduled-instance-recurrence-request v2653))))
   (clojure.core/let
    [v2653
     (:first-slot-start-time-range
      m2652
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2653 :com.palletops.awaze.client-builder/undef)
     (.
      bean2651
      setFirstSlotStartTimeRange
      (ec2/slot-date-time-range-request v2653))))
   (clojure.core/let
    [v2653
     (:min-slot-duration-in-hours
      m2652
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2653 :com.palletops.awaze.client-builder/undef)
     (. bean2651 setMinSlotDurationInHours (clojure.core/int v2653))))
   (clojure.core/let
    [v2653
     (:max-slot-duration-in-hours
      m2652
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2653 :com.palletops.awaze.client-builder/undef)
     (. bean2651 setMaxSlotDurationInHours (clojure.core/int v2653))))
   bean2651))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeFlowLogsRequest}
describe-flow-logs-request
  [m2655]
  (clojure.core/let
   [bean2654
    (new com.amazonaws.services.ec2.model.DescribeFlowLogsRequest)]
   (clojure.core/let
    [v2656
     (:flow-log-ids m2655 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2656 :com.palletops.awaze.client-builder/undef)
     (.
      bean2654
      setFlowLogIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2922] (clojure.core/str arg2922))
 v2656))))
   (clojure.core/let
    [v2656
     (:next-token m2655 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2656 :com.palletops.awaze.client-builder/undef)
     (. bean2654 setNextToken (clojure.core/str v2656))))
   (clojure.core/let
    [v2656
     (:max-results m2655 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2656 :com.palletops.awaze.client-builder/undef)
     (. bean2654 setMaxResults (clojure.core/int v2656))))
   (clojure.core/let
    [v2656 (:filter m2655 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2656 :com.palletops.awaze.client-builder/undef)
     (.
      bean2654
      setFilter
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2923] (ec2/filter arg2923))
 v2656))))
   bean2654))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CancelBundleTaskRequest}
cancel-bundle-task-request
  [m2658]
  (clojure.core/let
   [bean2657
    (new com.amazonaws.services.ec2.model.CancelBundleTaskRequest)]
   (clojure.core/let
    [v2659
     (:bundle-id m2658 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2659 :com.palletops.awaze.client-builder/undef)
     (. bean2657 setBundleId (clojure.core/str v2659))))
   bean2657))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeReservedInstancesRequest}
describe-reserved-instances-request
  [m2661]
  (clojure.core/let
   [bean2660
    (new
     com.amazonaws.services.ec2.model.DescribeReservedInstancesRequest)]
   (clojure.core/let
    [v2662
     (:reserved-instances-ids
      m2661
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2662 :com.palletops.awaze.client-builder/undef)
     (.
      bean2660
      setReservedInstancesIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2924] (clojure.core/str arg2924))
 v2662))))
   (clojure.core/let
    [v2662 (:filters m2661 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2662 :com.palletops.awaze.client-builder/undef)
     (.
      bean2660
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2925] (ec2/filter arg2925))
 v2662))))
   (clojure.core/let
    [v2662
     (:offering-type m2661 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2662 :com.palletops.awaze.client-builder/undef)
     (. bean2660 setOfferingType (ec2/offering-type-values v2662))))
   bean2660))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.UnmonitorInstancesRequest}
unmonitor-instances-request
  [m2664]
  (clojure.core/let
   [bean2663
    (new com.amazonaws.services.ec2.model.UnmonitorInstancesRequest)]
   (clojure.core/let
    [v2665
     (:instance-ids m2664 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2665 :com.palletops.awaze.client-builder/undef)
     (.
      bean2663
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2926] (clojure.core/str arg2926))
 v2665))))
   bean2663))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteSecurityGroupRequest}
delete-security-group-request
  [m2667]
  (clojure.core/let
   [bean2666
    (new com.amazonaws.services.ec2.model.DeleteSecurityGroupRequest)]
   (clojure.core/let
    [v2668
     (:group-id m2667 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2668 :com.palletops.awaze.client-builder/undef)
     (. bean2666 setGroupId (clojure.core/str v2668))))
   (clojure.core/let
    [v2668
     (:group-name m2667 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2668 :com.palletops.awaze.client-builder/undef)
     (. bean2666 setGroupName (clojure.core/str v2668))))
   bean2666))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVpcAttributeRequest}
describe-vpc-attribute-request
  [m2670]
  (clojure.core/let
   [bean2669
    (new com.amazonaws.services.ec2.model.DescribeVpcAttributeRequest)]
   (clojure.core/let
    [v2671
     (:attribute m2670 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2671 :com.palletops.awaze.client-builder/undef)
     (. bean2669 setAttribute (ec2/vpc-attribute-name v2671))))
   (clojure.core/let
    [v2671 (:vpc-id m2670 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2671 :com.palletops.awaze.client-builder/undef)
     (. bean2669 setVpcId (clojure.core/str v2671))))
   bean2669))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateNetworkAclRequest}
create-network-acl-request
  [m2673]
  (clojure.core/let
   [bean2672
    (new com.amazonaws.services.ec2.model.CreateNetworkAclRequest)]
   (clojure.core/let
    [v2674 (:vpc-id m2673 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2674 :com.palletops.awaze.client-builder/undef)
     (. bean2672 setVpcId (clojure.core/str v2674))))
   bean2672))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CancelImportTaskRequest}
cancel-import-task-request
  [m2676]
  (clojure.core/let
   [bean2675
    (new com.amazonaws.services.ec2.model.CancelImportTaskRequest)]
   (clojure.core/let
    [v2677
     (:import-task-id m2676 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2677 :com.palletops.awaze.client-builder/undef)
     (. bean2675 setImportTaskId (clojure.core/str v2677))))
   (clojure.core/let
    [v2677
     (:cancel-reason m2676 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2677 :com.palletops.awaze.client-builder/undef)
     (. bean2675 setCancelReason (clojure.core/str v2677))))
   bean2675))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AcceptVpcPeeringConnectionRequest}
accept-vpc-peering-connection-request
  [m2679]
  (clojure.core/let
   [bean2678
    (new
     com.amazonaws.services.ec2.model.AcceptVpcPeeringConnectionRequest)]
   (clojure.core/let
    [v2680
     (:vpc-peering-connection-id
      m2679
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2680 :com.palletops.awaze.client-builder/undef)
     (. bean2678 setVpcPeeringConnectionId (clojure.core/str v2680))))
   bean2678))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVpcEndpointServicesRequest}
describe-vpc-endpoint-services-request
  [m2682]
  (clojure.core/let
   [bean2681
    (new
     com.amazonaws.services.ec2.model.DescribeVpcEndpointServicesRequest)]
   (clojure.core/let
    [v2683
     (:next-token m2682 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2683 :com.palletops.awaze.client-builder/undef)
     (. bean2681 setNextToken (clojure.core/str v2683))))
   (clojure.core/let
    [v2683
     (:max-results m2682 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2683 :com.palletops.awaze.client-builder/undef)
     (. bean2681 setMaxResults (clojure.core/int v2683))))
   bean2681))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteVpcPeeringConnectionRequest}
delete-vpc-peering-connection-request
  [m2685]
  (clojure.core/let
   [bean2684
    (new
     com.amazonaws.services.ec2.model.DeleteVpcPeeringConnectionRequest)]
   (clojure.core/let
    [v2686
     (:vpc-peering-connection-id
      m2685
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2686 :com.palletops.awaze.client-builder/undef)
     (. bean2684 setVpcPeeringConnectionId (clojure.core/str v2686))))
   bean2684))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RunInstancesRequest}
run-instances-request
  [m2688]
  (clojure.core/let
   [bean2687
    (new com.amazonaws.services.ec2.model.RunInstancesRequest)]
   (clojure.core/let
    [v2689
     (:iam-instance-profile
      m2688
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2689 :com.palletops.awaze.client-builder/undef)
     (.
      bean2687
      setIamInstanceProfile
      (ec2/iam-instance-profile-specification v2689))))
   (clojure.core/let
    [v2689
     (:max-count m2688 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2689 :com.palletops.awaze.client-builder/undef)
     (. bean2687 setMaxCount (clojure.core/int v2689))))
   (clojure.core/let
    [v2689
     (:subnet-id m2688 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2689 :com.palletops.awaze.client-builder/undef)
     (. bean2687 setSubnetId (clojure.core/str v2689))))
   (clojure.core/let
    [v2689
     (:additional-info
      m2688
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2689 :com.palletops.awaze.client-builder/undef)
     (. bean2687 setAdditionalInfo (clojure.core/str v2689))))
   (clojure.core/let
    [v2689
     (:security-group-ids
      m2688
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2689 :com.palletops.awaze.client-builder/undef)
     (.
      bean2687
      setSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2927] (clojure.core/str arg2927))
 v2689))))
   (clojure.core/let
    [v2689
     (:placement m2688 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2689 :com.palletops.awaze.client-builder/undef)
     (. bean2687 setPlacement (ec2/placement v2689))))
   (clojure.core/let
    [v2689
     (:private-ip-address
      m2688
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2689 :com.palletops.awaze.client-builder/undef)
     (. bean2687 setPrivateIpAddress (clojure.core/str v2689))))
   (clojure.core/let
    [v2689
     (:client-token m2688 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2689 :com.palletops.awaze.client-builder/undef)
     (. bean2687 setClientToken (clojure.core/str v2689))))
   (clojure.core/let
    [v2689
     (:instance-type m2688 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2689 :com.palletops.awaze.client-builder/undef)
     (. bean2687 setInstanceType (clojure.core/str v2689))))
   (clojure.core/let
    [v2689
     (:ebs-optimized m2688 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2689 :com.palletops.awaze.client-builder/undef)
     (. bean2687 setEbsOptimized (clojure.core/boolean v2689))))
   (clojure.core/let
    [v2689
     (:ramdisk-id m2688 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2689 :com.palletops.awaze.client-builder/undef)
     (. bean2687 setRamdiskId (clojure.core/str v2689))))
   (clojure.core/let
    [v2689
     (:instance-initiated-shutdown-behavior
      m2688
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2689 :com.palletops.awaze.client-builder/undef)
     (.
      bean2687
      setInstanceInitiatedShutdownBehavior
      (ec2/shutdown-behavior v2689))))
   (clojure.core/let
    [v2689
     (:disable-api-termination
      m2688
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2689 :com.palletops.awaze.client-builder/undef)
     (.
      bean2687
      setDisableApiTermination
      (clojure.core/boolean v2689))))
   (clojure.core/let
    [v2689
     (:image-id m2688 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2689 :com.palletops.awaze.client-builder/undef)
     (. bean2687 setImageId (clojure.core/str v2689))))
   (clojure.core/let
    [v2689
     (:key-name m2688 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2689 :com.palletops.awaze.client-builder/undef)
     (. bean2687 setKeyName (clojure.core/str v2689))))
   (clojure.core/let
    [v2689
     (:min-count m2688 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2689 :com.palletops.awaze.client-builder/undef)
     (. bean2687 setMinCount (clojure.core/int v2689))))
   (clojure.core/let
    [v2689
     (:kernel-id m2688 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2689 :com.palletops.awaze.client-builder/undef)
     (. bean2687 setKernelId (clojure.core/str v2689))))
   (clojure.core/let
    [v2689
     (:monitoring m2688 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2689 :com.palletops.awaze.client-builder/undef)
     (. bean2687 setMonitoring (clojure.core/boolean v2689))))
   (clojure.core/let
    [v2689
     (:security-groups
      m2688
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2689 :com.palletops.awaze.client-builder/undef)
     (.
      bean2687
      setSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2928] (clojure.core/str arg2928))
 v2689))))
   (clojure.core/let
    [v2689
     (:block-device-mappings
      m2688
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2689 :com.palletops.awaze.client-builder/undef)
     (.
      bean2687
      setBlockDeviceMappings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2929] (ec2/block-device-mapping arg2929))
 v2689))))
   (clojure.core/let
    [v2689
     (:user-data m2688 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2689 :com.palletops.awaze.client-builder/undef)
     (. bean2687 setUserData (clojure.core/str v2689))))
   (clojure.core/let
    [v2689
     (:network-interfaces
      m2688
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2689 :com.palletops.awaze.client-builder/undef)
     (.
      bean2687
      setNetworkInterfaces
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg2930]
  (ec2/instance-network-interface-specification arg2930))
 v2689))))
   bean2687))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeInstanceStatusRequest}
describe-instance-status-request
  [m2691]
  (clojure.core/let
   [bean2690
    (new
     com.amazonaws.services.ec2.model.DescribeInstanceStatusRequest)]
   (clojure.core/let
    [v2692
     (:instance-ids m2691 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2692 :com.palletops.awaze.client-builder/undef)
     (.
      bean2690
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2931] (clojure.core/str arg2931))
 v2692))))
   (clojure.core/let
    [v2692 (:filters m2691 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2692 :com.palletops.awaze.client-builder/undef)
     (.
      bean2690
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2932] (ec2/filter arg2932))
 v2692))))
   (clojure.core/let
    [v2692
     (:next-token m2691 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2692 :com.palletops.awaze.client-builder/undef)
     (. bean2690 setNextToken (clojure.core/str v2692))))
   (clojure.core/let
    [v2692
     (:max-results m2691 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2692 :com.palletops.awaze.client-builder/undef)
     (. bean2690 setMaxResults (clojure.core/int v2692))))
   (clojure.core/let
    [v2692
     (:include-all-instances
      m2691
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2692 :com.palletops.awaze.client-builder/undef)
     (. bean2690 setIncludeAllInstances (clojure.core/boolean v2692))))
   bean2690))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVpcClassicLinkDnsSupportRequest}
describe-vpc-classic-link-dns-support-request
  [m2694]
  (clojure.core/let
   [bean2693
    (new
     com.amazonaws.services.ec2.model.DescribeVpcClassicLinkDnsSupportRequest)]
   (clojure.core/let
    [v2695
     (:next-token m2694 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2695 :com.palletops.awaze.client-builder/undef)
     (. bean2693 setNextToken (clojure.core/str v2695))))
   (clojure.core/let
    [v2695
     (:max-results m2694 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2695 :com.palletops.awaze.client-builder/undef)
     (. bean2693 setMaxResults (clojure.core/int v2695))))
   (clojure.core/let
    [v2695 (:vpc-ids m2694 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2695 :com.palletops.awaze.client-builder/undef)
     (.
      bean2693
      setVpcIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2933] (clojure.core/str arg2933))
 v2695))))
   bean2693))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.UnassignPrivateIpAddressesRequest}
unassign-private-ip-addresses-request
  [m2697]
  (clojure.core/let
   [bean2696
    (new
     com.amazonaws.services.ec2.model.UnassignPrivateIpAddressesRequest)]
   (clojure.core/let
    [v2698
     (:network-interface-id
      m2697
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2698 :com.palletops.awaze.client-builder/undef)
     (. bean2696 setNetworkInterfaceId (clojure.core/str v2698))))
   (clojure.core/let
    [v2698
     (:private-ip-addresses
      m2697
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2698 :com.palletops.awaze.client-builder/undef)
     (.
      bean2696
      setPrivateIpAddresses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2934] (clojure.core/str arg2934))
 v2698))))
   bean2696))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSecurityGroupsRequest}
describe-security-groups-request
  [m2700]
  (clojure.core/let
   [bean2699
    (new
     com.amazonaws.services.ec2.model.DescribeSecurityGroupsRequest)]
   (clojure.core/let
    [v2701
     (:group-names m2700 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2701 :com.palletops.awaze.client-builder/undef)
     (.
      bean2699
      setGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2935] (clojure.core/str arg2935))
 v2701))))
   (clojure.core/let
    [v2701 (:filters m2700 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2701 :com.palletops.awaze.client-builder/undef)
     (.
      bean2699
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2936] (ec2/filter arg2936))
 v2701))))
   (clojure.core/let
    [v2701
     (:group-ids m2700 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2701 :com.palletops.awaze.client-builder/undef)
     (.
      bean2699
      setGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2937] (clojure.core/str arg2937))
 v2701))))
   bean2699))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeNetworkInterfacesRequest}
describe-network-interfaces-request
  [m2703]
  (clojure.core/let
   [bean2702
    (new
     com.amazonaws.services.ec2.model.DescribeNetworkInterfacesRequest)]
   (clojure.core/let
    [v2704 (:filters m2703 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2704 :com.palletops.awaze.client-builder/undef)
     (.
      bean2702
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2938] (ec2/filter arg2938))
 v2704))))
   (clojure.core/let
    [v2704
     (:network-interface-ids
      m2703
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2704 :com.palletops.awaze.client-builder/undef)
     (.
      bean2702
      setNetworkInterfaceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2939] (clojure.core/str arg2939))
 v2704))))
   bean2702))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateCustomerGatewayRequest}
create-customer-gateway-request
  [m2706]
  (clojure.core/let
   [bean2705
    (new
     com.amazonaws.services.ec2.model.CreateCustomerGatewayRequest)]
   (clojure.core/let
    [v2707
     (:public-ip m2706 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2707 :com.palletops.awaze.client-builder/undef)
     (. bean2705 setPublicIp (clojure.core/str v2707))))
   (clojure.core/let
    [v2707 (:type m2706 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2707 :com.palletops.awaze.client-builder/undef)
     (. bean2705 setType (clojure.core/str v2707))))
   (clojure.core/let
    [v2707 (:bgp-asn m2706 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2707 :com.palletops.awaze.client-builder/undef)
     (. bean2705 setBgpAsn (clojure.core/int v2707))))
   bean2705))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeDhcpOptionsRequest}
describe-dhcp-options-request
  [m2709]
  (clojure.core/let
   [bean2708
    (new com.amazonaws.services.ec2.model.DescribeDhcpOptionsRequest)]
   (clojure.core/let
    [v2710 (:filters m2709 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2710 :com.palletops.awaze.client-builder/undef)
     (.
      bean2708
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2940] (ec2/filter arg2940))
 v2710))))
   (clojure.core/let
    [v2710
     (:dhcp-options-ids
      m2709
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2710 :com.palletops.awaze.client-builder/undef)
     (.
      bean2708
      setDhcpOptionsIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2941] (clojure.core/str arg2941))
 v2710))))
   bean2708))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateTagsRequest}
create-tags-request
  [m2712]
  (clojure.core/let
   [bean2711 (new com.amazonaws.services.ec2.model.CreateTagsRequest)]
   (clojure.core/let
    [v2713
     (:resources m2712 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2713 :com.palletops.awaze.client-builder/undef)
     (.
      bean2711
      setResources
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2942] (clojure.core/str arg2942))
 v2713))))
   (clojure.core/let
    [v2713 (:tags m2712 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2713 :com.palletops.awaze.client-builder/undef)
     (.
      bean2711
      setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg2943] (ec2/tag arg2943)) v2713))))
   bean2711))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateSnapshotRequest}
create-snapshot-request
  [m2715]
  (clojure.core/let
   [bean2714
    (new com.amazonaws.services.ec2.model.CreateSnapshotRequest)]
   (clojure.core/let
    [v2716
     (:volume-id m2715 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2716 :com.palletops.awaze.client-builder/undef)
     (. bean2714 setVolumeId (clojure.core/str v2716))))
   (clojure.core/let
    [v2716
     (:description m2715 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2716 :com.palletops.awaze.client-builder/undef)
     (. bean2714 setDescription (clojure.core/str v2716))))
   bean2714))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ImportImageRequest}
import-image-request
  [m2718]
  (clojure.core/let
   [bean2717
    (new com.amazonaws.services.ec2.model.ImportImageRequest)]
   (clojure.core/let
    [v2719
     (:description m2718 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2719 :com.palletops.awaze.client-builder/undef)
     (. bean2717 setDescription (clojure.core/str v2719))))
   (clojure.core/let
    [v2719
     (:disk-containers
      m2718
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2719 :com.palletops.awaze.client-builder/undef)
     (.
      bean2717
      setDiskContainers
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2944] (ec2/image-disk-container arg2944))
 v2719))))
   (clojure.core/let
    [v2719
     (:client-data m2718 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2719 :com.palletops.awaze.client-builder/undef)
     (. bean2717 setClientData (ec2/client-data v2719))))
   (clojure.core/let
    [v2719
     (:client-token m2718 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2719 :com.palletops.awaze.client-builder/undef)
     (. bean2717 setClientToken (clojure.core/str v2719))))
   (clojure.core/let
    [v2719
     (:role-name m2718 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2719 :com.palletops.awaze.client-builder/undef)
     (. bean2717 setRoleName (clojure.core/str v2719))))
   (clojure.core/let
    [v2719
     (:hypervisor m2718 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2719 :com.palletops.awaze.client-builder/undef)
     (. bean2717 setHypervisor (clojure.core/str v2719))))
   (clojure.core/let
    [v2719
     (:platform m2718 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2719 :com.palletops.awaze.client-builder/undef)
     (. bean2717 setPlatform (clojure.core/str v2719))))
   (clojure.core/let
    [v2719
     (:license-type m2718 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2719 :com.palletops.awaze.client-builder/undef)
     (. bean2717 setLicenseType (clojure.core/str v2719))))
   (clojure.core/let
    [v2719
     (:architecture m2718 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2719 :com.palletops.awaze.client-builder/undef)
     (. bean2717 setArchitecture (clojure.core/str v2719))))
   bean2717))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateRouteTableRequest}
create-route-table-request
  [m2721]
  (clojure.core/let
   [bean2720
    (new com.amazonaws.services.ec2.model.CreateRouteTableRequest)]
   (clojure.core/let
    [v2722 (:vpc-id m2721 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2722 :com.palletops.awaze.client-builder/undef)
     (. bean2720 setVpcId (clojure.core/str v2722))))
   bean2720))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeHostsRequest}
describe-hosts-request
  [m2724]
  (clojure.core/let
   [bean2723
    (new com.amazonaws.services.ec2.model.DescribeHostsRequest)]
   (clojure.core/let
    [v2725
     (:host-ids m2724 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2725 :com.palletops.awaze.client-builder/undef)
     (.
      bean2723
      setHostIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2945] (clojure.core/str arg2945))
 v2725))))
   (clojure.core/let
    [v2725
     (:next-token m2724 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2725 :com.palletops.awaze.client-builder/undef)
     (. bean2723 setNextToken (clojure.core/str v2725))))
   (clojure.core/let
    [v2725
     (:max-results m2724 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2725 :com.palletops.awaze.client-builder/undef)
     (. bean2723 setMaxResults (clojure.core/int v2725))))
   (clojure.core/let
    [v2725 (:filter m2724 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2725 :com.palletops.awaze.client-builder/undef)
     (.
      bean2723
      setFilter
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2946] (ec2/filter arg2946))
 v2725))))
   bean2723))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVolumeAttributeRequest}
describe-volume-attribute-request
  [m2727]
  (clojure.core/let
   [bean2726
    (new
     com.amazonaws.services.ec2.model.DescribeVolumeAttributeRequest)]
   (clojure.core/let
    [v2728
     (:attribute m2727 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2728 :com.palletops.awaze.client-builder/undef)
     (. bean2726 setAttribute (ec2/volume-attribute-name v2728))))
   (clojure.core/let
    [v2728
     (:volume-id m2727 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2728 :com.palletops.awaze.client-builder/undef)
     (. bean2726 setVolumeId (clojure.core/str v2728))))
   bean2726))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyIdFormatRequest}
modify-id-format-request
  [m2730]
  (clojure.core/let
   [bean2729
    (new com.amazonaws.services.ec2.model.ModifyIdFormatRequest)]
   (clojure.core/let
    [v2731
     (:resource m2730 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2731 :com.palletops.awaze.client-builder/undef)
     (. bean2729 setResource (clojure.core/str v2731))))
   (clojure.core/let
    [v2731
     (:use-long-ids m2730 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2731 :com.palletops.awaze.client-builder/undef)
     (. bean2729 setUseLongIds (clojure.core/boolean v2731))))
   bean2729))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateNetworkAclEntryRequest}
create-network-acl-entry-request
  [m2733]
  (clojure.core/let
   [bean2732
    (new
     com.amazonaws.services.ec2.model.CreateNetworkAclEntryRequest)]
   (clojure.core/let
    [v2734
     (:protocol m2733 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2734 :com.palletops.awaze.client-builder/undef)
     (. bean2732 setProtocol (clojure.core/str v2734))))
   (clojure.core/let
    [v2734
     (:network-acl-id m2733 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2734 :com.palletops.awaze.client-builder/undef)
     (. bean2732 setNetworkAclId (clojure.core/str v2734))))
   (clojure.core/let
    [v2734
     (:rule-number m2733 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2734 :com.palletops.awaze.client-builder/undef)
     (. bean2732 setRuleNumber (clojure.core/int v2734))))
   (clojure.core/let
    [v2734
     (:rule-action m2733 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2734 :com.palletops.awaze.client-builder/undef)
     (. bean2732 setRuleAction (clojure.core/str v2734))))
   (clojure.core/let
    [v2734 (:egress m2733 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2734 :com.palletops.awaze.client-builder/undef)
     (. bean2732 setEgress (clojure.core/boolean v2734))))
   (clojure.core/let
    [v2734
     (:cidr-block m2733 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2734 :com.palletops.awaze.client-builder/undef)
     (. bean2732 setCidrBlock (clojure.core/str v2734))))
   (clojure.core/let
    [v2734
     (:icmp-type-code m2733 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2734 :com.palletops.awaze.client-builder/undef)
     (. bean2732 setIcmpTypeCode (ec2/icmp-type-code v2734))))
   (clojure.core/let
    [v2734
     (:port-range m2733 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2734 :com.palletops.awaze.client-builder/undef)
     (. bean2732 setPortRange (ec2/port-range v2734))))
   bean2732))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeNatGatewaysRequest}
describe-nat-gateways-request
  [m2736]
  (clojure.core/let
   [bean2735
    (new com.amazonaws.services.ec2.model.DescribeNatGatewaysRequest)]
   (clojure.core/let
    [v2737
     (:next-token m2736 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2737 :com.palletops.awaze.client-builder/undef)
     (. bean2735 setNextToken (clojure.core/str v2737))))
   (clojure.core/let
    [v2737
     (:max-results m2736 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2737 :com.palletops.awaze.client-builder/undef)
     (. bean2735 setMaxResults (clojure.core/int v2737))))
   (clojure.core/let
    [v2737 (:filter m2736 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2737 :com.palletops.awaze.client-builder/undef)
     (.
      bean2735
      setFilter
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2947] (ec2/filter arg2947))
 v2737))))
   (clojure.core/let
    [v2737
     (:nat-gateway-ids
      m2736
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2737 :com.palletops.awaze.client-builder/undef)
     (.
      bean2735
      setNatGatewayIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2948] (clojure.core/str arg2948))
 v2737))))
   bean2735))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CancelReservedInstancesListingRequest}
cancel-reserved-instances-listing-request
  [m2739]
  (clojure.core/let
   [bean2738
    (new
     com.amazonaws.services.ec2.model.CancelReservedInstancesListingRequest)]
   (clojure.core/let
    [v2740
     (:reserved-instances-listing-id
      m2739
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2740 :com.palletops.awaze.client-builder/undef)
     (.
      bean2738
      setReservedInstancesListingId
      (clojure.core/str v2740))))
   bean2738))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DisableVpcClassicLinkRequest}
disable-vpc-classic-link-request
  [m2742]
  (clojure.core/let
   [bean2741
    (new
     com.amazonaws.services.ec2.model.DisableVpcClassicLinkRequest)]
   (clojure.core/let
    [v2743 (:vpc-id m2742 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2743 :com.palletops.awaze.client-builder/undef)
     (. bean2741 setVpcId (clojure.core/str v2743))))
   bean2741))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RunScheduledInstancesRequest}
run-scheduled-instances-request
  [m2745]
  (clojure.core/let
   [bean2744
    (new
     com.amazonaws.services.ec2.model.RunScheduledInstancesRequest)]
   (clojure.core/let
    [v2746
     (:client-token m2745 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2746 :com.palletops.awaze.client-builder/undef)
     (. bean2744 setClientToken (clojure.core/str v2746))))
   (clojure.core/let
    [v2746
     (:instance-count m2745 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2746 :com.palletops.awaze.client-builder/undef)
     (. bean2744 setInstanceCount (clojure.core/int v2746))))
   (clojure.core/let
    [v2746
     (:launch-specification
      m2745
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2746 :com.palletops.awaze.client-builder/undef)
     (.
      bean2744
      setLaunchSpecification
      (ec2/scheduled-instances-launch-specification v2746))))
   (clojure.core/let
    [v2746
     (:scheduled-instance-id
      m2745
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2746 :com.palletops.awaze.client-builder/undef)
     (. bean2744 setScheduledInstanceId (clojure.core/str v2746))))
   bean2744))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteKeyPairRequest}
delete-key-pair-request
  [m2748]
  (clojure.core/let
   [bean2747
    (new com.amazonaws.services.ec2.model.DeleteKeyPairRequest)]
   (clojure.core/let
    [v2749
     (:key-name m2748 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2749 :com.palletops.awaze.client-builder/undef)
     (. bean2747 setKeyName (clojure.core/str v2749))))
   bean2747))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyReservedInstancesRequest}
modify-reserved-instances-request
  [m2751]
  (clojure.core/let
   [bean2750
    (new
     com.amazonaws.services.ec2.model.ModifyReservedInstancesRequest)]
   (clojure.core/let
    [v2752
     (:client-token m2751 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2752 :com.palletops.awaze.client-builder/undef)
     (. bean2750 setClientToken (clojure.core/str v2752))))
   (clojure.core/let
    [v2752
     (:reserved-instances-ids
      m2751
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2752 :com.palletops.awaze.client-builder/undef)
     (.
      bean2750
      setReservedInstancesIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2949] (clojure.core/str arg2949))
 v2752))))
   (clojure.core/let
    [v2752
     (:target-configurations
      m2751
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2752 :com.palletops.awaze.client-builder/undef)
     (.
      bean2750
      setTargetConfigurations
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg2950]
  (ec2/reserved-instances-configuration arg2950))
 v2752))))
   bean2750))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteVpnConnectionRouteRequest}
delete-vpn-connection-route-request
  [m2754]
  (clojure.core/let
   [bean2753
    (new
     com.amazonaws.services.ec2.model.DeleteVpnConnectionRouteRequest)]
   (clojure.core/let
    [v2755
     (:destination-cidr-block
      m2754
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2755 :com.palletops.awaze.client-builder/undef)
     (. bean2753 setDestinationCidrBlock (clojure.core/str v2755))))
   (clojure.core/let
    [v2755
     (:vpn-connection-id
      m2754
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2755 :com.palletops.awaze.client-builder/undef)
     (. bean2753 setVpnConnectionId (clojure.core/str v2755))))
   bean2753))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AttachInternetGatewayRequest}
attach-internet-gateway-request
  [m2757]
  (clojure.core/let
   [bean2756
    (new
     com.amazonaws.services.ec2.model.AttachInternetGatewayRequest)]
   (clojure.core/let
    [v2758 (:vpc-id m2757 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2758 :com.palletops.awaze.client-builder/undef)
     (. bean2756 setVpcId (clojure.core/str v2758))))
   (clojure.core/let
    [v2758
     (:internet-gateway-id
      m2757
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2758 :com.palletops.awaze.client-builder/undef)
     (. bean2756 setInternetGatewayId (clojure.core/str v2758))))
   bean2756))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyNetworkInterfaceAttributeRequest}
modify-network-interface-attribute-request
  [m2760]
  (clojure.core/let
   [bean2759
    (new
     com.amazonaws.services.ec2.model.ModifyNetworkInterfaceAttributeRequest)]
   (clojure.core/let
    [v2761
     (:network-interface-id
      m2760
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2761 :com.palletops.awaze.client-builder/undef)
     (. bean2759 setNetworkInterfaceId (clojure.core/str v2761))))
   (clojure.core/let
    [v2761 (:groups m2760 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2761 :com.palletops.awaze.client-builder/undef)
     (.
      bean2759
      setGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3015] (clojure.core/str arg3015))
 v2761))))
   (clojure.core/let
    [v2761
     (:description m2760 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2761 :com.palletops.awaze.client-builder/undef)
     (. bean2759 setDescription (clojure.core/str v2761))))
   (clojure.core/let
    [v2761
     (:source-dest-check
      m2760
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2761 :com.palletops.awaze.client-builder/undef)
     (. bean2759 setSourceDestCheck (clojure.core/boolean v2761))))
   (clojure.core/let
    [v2761
     (:attachment m2760 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2761 :com.palletops.awaze.client-builder/undef)
     (.
      bean2759
      setAttachment
      (ec2/network-interface-attachment-changes v2761))))
   bean2759))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.EnableVgwRoutePropagationRequest}
enable-vgw-route-propagation-request
  [m2763]
  (clojure.core/let
   [bean2762
    (new
     com.amazonaws.services.ec2.model.EnableVgwRoutePropagationRequest)]
   (clojure.core/let
    [v2764
     (:route-table-id m2763 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2764 :com.palletops.awaze.client-builder/undef)
     (. bean2762 setRouteTableId (clojure.core/str v2764))))
   (clojure.core/let
    [v2764
     (:gateway-id m2763 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2764 :com.palletops.awaze.client-builder/undef)
     (. bean2762 setGatewayId (clojure.core/str v2764))))
   bean2762))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteNetworkAclEntryRequest}
delete-network-acl-entry-request
  [m2766]
  (clojure.core/let
   [bean2765
    (new
     com.amazonaws.services.ec2.model.DeleteNetworkAclEntryRequest)]
   (clojure.core/let
    [v2767
     (:network-acl-id m2766 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2767 :com.palletops.awaze.client-builder/undef)
     (. bean2765 setNetworkAclId (clojure.core/str v2767))))
   (clojure.core/let
    [v2767
     (:rule-number m2766 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2767 :com.palletops.awaze.client-builder/undef)
     (. bean2765 setRuleNumber (clojure.core/int v2767))))
   (clojure.core/let
    [v2767 (:egress m2766 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2767 :com.palletops.awaze.client-builder/undef)
     (. bean2765 setEgress (clojure.core/boolean v2767))))
   bean2765))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CancelExportTaskRequest}
cancel-export-task-request
  [m2769]
  (clojure.core/let
   [bean2768
    (new com.amazonaws.services.ec2.model.CancelExportTaskRequest)]
   (clojure.core/let
    [v2770
     (:export-task-id m2769 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2770 :com.palletops.awaze.client-builder/undef)
     (. bean2768 setExportTaskId (clojure.core/str v2770))))
   bean2768))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateImageRequest}
create-image-request
  [m2772]
  (clojure.core/let
   [bean2771
    (new com.amazonaws.services.ec2.model.CreateImageRequest)]
   (clojure.core/let
    [v2773
     (:instance-id m2772 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2773 :com.palletops.awaze.client-builder/undef)
     (. bean2771 setInstanceId (clojure.core/str v2773))))
   (clojure.core/let
    [v2773
     (:description m2772 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2773 :com.palletops.awaze.client-builder/undef)
     (. bean2771 setDescription (clojure.core/str v2773))))
   (clojure.core/let
    [v2773
     (:no-reboot m2772 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2773 :com.palletops.awaze.client-builder/undef)
     (. bean2771 setNoReboot (clojure.core/boolean v2773))))
   (clojure.core/let
    [v2773
     (:block-device-mappings
      m2772
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2773 :com.palletops.awaze.client-builder/undef)
     (.
      bean2771
      setBlockDeviceMappings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3016] (ec2/block-device-mapping arg3016))
 v2773))))
   (clojure.core/let
    [v2773 (:name m2772 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2773 :com.palletops.awaze.client-builder/undef)
     (. bean2771 setName (clojure.core/str v2773))))
   bean2771))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifySpotFleetRequestRequest}
modify-spot-fleet-request-request
  [m2775]
  (clojure.core/let
   [bean2774
    (new
     com.amazonaws.services.ec2.model.ModifySpotFleetRequestRequest)]
   (clojure.core/let
    [v2776
     (:spot-fleet-request-id
      m2775
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2776 :com.palletops.awaze.client-builder/undef)
     (. bean2774 setSpotFleetRequestId (clojure.core/str v2776))))
   (clojure.core/let
    [v2776
     (:target-capacity
      m2775
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2776 :com.palletops.awaze.client-builder/undef)
     (. bean2774 setTargetCapacity (clojure.core/int v2776))))
   (clojure.core/let
    [v2776
     (:excess-capacity-termination-policy
      m2775
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2776 :com.palletops.awaze.client-builder/undef)
     (.
      bean2774
      setExcessCapacityTerminationPolicy
      (ec2/excess-capacity-termination-policy v2776))))
   bean2774))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeImportSnapshotTasksRequest}
describe-import-snapshot-tasks-request
  [m2778]
  (clojure.core/let
   [bean2777
    (new
     com.amazonaws.services.ec2.model.DescribeImportSnapshotTasksRequest)]
   (clojure.core/let
    [v2779 (:filters m2778 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2779 :com.palletops.awaze.client-builder/undef)
     (.
      bean2777
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3017] (ec2/filter arg3017))
 v2779))))
   (clojure.core/let
    [v2779
     (:next-token m2778 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2779 :com.palletops.awaze.client-builder/undef)
     (. bean2777 setNextToken (clojure.core/str v2779))))
   (clojure.core/let
    [v2779
     (:max-results m2778 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2779 :com.palletops.awaze.client-builder/undef)
     (. bean2777 setMaxResults (clojure.core/int v2779))))
   (clojure.core/let
    [v2779
     (:import-task-ids
      m2778
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2779 :com.palletops.awaze.client-builder/undef)
     (.
      bean2777
      setImportTaskIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3018] (clojure.core/str arg3018))
 v2779))))
   bean2777))
 (clojure.core/defmulti
  ec2
  (clojure.core/fn ec2 [m__1874__auto__] (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   ec2
   :delete-vpc-endpoints
   [m2951]
   (clojure.core/let
    [credentials2952 (:credentials m2951) args2953 (:args m2951)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client2954
      (com.palletops.awaze.common/aws-client :ec2 credentials2952)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2954
       deleteVpcEndpoints
       (ec2/delete-vpc-endpoints-request
        (clojure.core/nth args2953 0)))))))
  (clojure.core/defn
   delete-vpc-endpoints-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         vpc-endpoint-ids
                         clone-root]}]]),
    :doc "Generate map for deleteVpcEndpoints"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-vpc-endpoints,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-vpc-endpoints
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         vpc-endpoint-ids
                         clone-root]}]]),
    :doc "Call deleteVpcEndpoints"}
   [credentials2956 & args2957]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client2958
     (com.palletops.awaze.common/aws-client :ec2 credentials2956)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2958
      deleteVpcEndpoints
      (ec2/delete-vpc-endpoints-request (clojure.core/nth args2957 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-nat-gateway
   [m2959]
   (clojure.core/let
    [credentials2960 (:credentials m2959) args2961 (:args m2959)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client2962
      (com.palletops.awaze.common/aws-client :ec2 credentials2960)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2962
       createNatGateway
       (ec2/create-nat-gateway-request (clojure.core/nth args2961 0)))))))
  (clojure.core/defn
   create-nat-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subnet-id
                         allocation-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         client-token
                         clone-root]}]]),
    :doc "Generate map for createNatGateway"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-nat-gateway,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-nat-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subnet-id
                         allocation-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         client-token
                         clone-root]}]]),
    :doc "Call createNatGateway"}
   [credentials2964 & args2965]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client2966
     (com.palletops.awaze.common/aws-client :ec2 credentials2964)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2966
      createNatGateway
      (ec2/create-nat-gateway-request (clojure.core/nth args2965 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :stop-instances
   [m2967]
   (clojure.core/let
    [credentials2968 (:credentials m2967) args2969 (:args m2967)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client2970
      (com.palletops.awaze.common/aws-client :ec2 credentials2968)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2970
       stopInstances
       (ec2/stop-instances-request (clojure.core/nth args2969 0)))))))
  (clojure.core/defn
   stop-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         force
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for stopInstances"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :stop-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   stop-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         force
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call stopInstances"}
   [credentials2972 & args2973]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client2974
     (com.palletops.awaze.common/aws-client :ec2 credentials2972)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2974
      stopInstances
      (ec2/stop-instances-request (clojure.core/nth args2973 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-placement-group
   [m2975]
   (clojure.core/let
    [credentials2976 (:credentials m2975) args2977 (:args m2975)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client2978
      (com.palletops.awaze.common/aws-client :ec2 credentials2976)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2978
       createPlacementGroup
       (ec2/create-placement-group-request
        (clojure.core/nth args2977 0)))))))
  (clojure.core/defn
   create-placement-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         strategy
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createPlacementGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-placement-group,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-placement-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         strategy
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createPlacementGroup"}
   [credentials2980 & args2981]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client2982
     (com.palletops.awaze.common/aws-client :ec2 credentials2980)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2982
      createPlacementGroup
      (ec2/create-placement-group-request
       (clojure.core/nth args2981 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-reserved-instances-listing
   [m2983]
   (clojure.core/let
    [credentials2984 (:credentials m2983) args2985 (:args m2983)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client2986
      (com.palletops.awaze.common/aws-client :ec2 credentials2984)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2986
       createReservedInstancesListing
       (ec2/create-reserved-instances-listing-request
        (clojure.core/nth args2985 0)))))))
  (clojure.core/defn
   create-reserved-instances-listing-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         reserved-instances-id
                         sdk-request-timeout
                         custom-query-parameters
                         price-schedules
                         instance-count
                         read-limit
                         general-progress-listener
                         clone-source
                         client-token
                         clone-root]}]]),
    :doc "Generate map for createReservedInstancesListing"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-reserved-instances-listing,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-reserved-instances-listing
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         reserved-instances-id
                         sdk-request-timeout
                         custom-query-parameters
                         price-schedules
                         instance-count
                         read-limit
                         general-progress-listener
                         clone-source
                         client-token
                         clone-root]}]]),
    :doc "Call createReservedInstancesListing"}
   [credentials2988 & args2989]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client2990
     (com.palletops.awaze.common/aws-client :ec2 credentials2988)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2990
      createReservedInstancesListing
      (ec2/create-reserved-instances-listing-request
       (clojure.core/nth args2989 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :release-hosts
   [m2991]
   (clojure.core/let
    [credentials2992 (:credentials m2991) args2993 (:args m2991)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client2994
      (com.palletops.awaze.common/aws-client :ec2 credentials2992)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2994
       releaseHosts
       (ec2/release-hosts-request (clojure.core/nth args2993 0)))))))
  (clojure.core/defn
   release-hosts-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         host-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for releaseHosts"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :release-hosts,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   release-hosts
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         host-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call releaseHosts"}
   [credentials2996 & args2997]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client2998
     (com.palletops.awaze.common/aws-client :ec2 credentials2996)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client2998
      releaseHosts
      (ec2/release-hosts-request (clojure.core/nth args2997 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :revoke-security-group-ingress
   [m2999]
   (clojure.core/let
    [credentials3000 (:credentials m2999) args3001 (:args m2999)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3002
      (com.palletops.awaze.common/aws-client :ec2 credentials3000)]
     (clojure.core/case
      (clojure.core/count args3001)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3002
        revokeSecurityGroupIngress
        (ec2/revoke-security-group-ingress-request
         (clojure.core/nth args3001 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3002
        revokeSecurityGroupIngress))))))
  (clojure.core/defn
   revoke-security-group-ingress-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         ip-permissions
                         group-id
                         sdk-request-timeout
                         custom-query-parameters
                         to-port
                         source-security-group-name
                         cidr-ip
                         ip-protocol
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         from-port
                         source-security-group-owner-id
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for revokeSecurityGroupIngress, revokeSecurityGroupIngress"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :revoke-security-group-ingress,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :revoke-security-group-ingress,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   revoke-security-group-ingress
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         ip-permissions
                         group-id
                         sdk-request-timeout
                         custom-query-parameters
                         to-port
                         source-security-group-name
                         cidr-ip
                         ip-protocol
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         from-port
                         source-security-group-owner-id
                         clone-root]}]
                [credentials]]),
    :doc "Call revokeSecurityGroupIngress, revokeSecurityGroupIngress"}
   [credentials3004 & args3005]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3006
     (com.palletops.awaze.common/aws-client :ec2 credentials3004)]
    (clojure.core/case
     (clojure.core/count args3005)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3006
       revokeSecurityGroupIngress
       (ec2/revoke-security-group-ingress-request
        (clojure.core/nth args3005 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3006
       revokeSecurityGroupIngress))))))
 (do
  (clojure.core/defmethod
   ec2
   :attach-classic-link-vpc
   [m3007]
   (clojure.core/let
    [credentials3008 (:credentials m3007) args3009 (:args m3007)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3010
      (com.palletops.awaze.common/aws-client :ec2 credentials3008)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3010
       attachClassicLinkVpc
       (ec2/attach-classic-link-vpc-request
        (clojure.core/nth args3009 0)))))))
  (clojure.core/defn
   attach-classic-link-vpc-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         groups
                         clone-root]}]]),
    :doc "Generate map for attachClassicLinkVpc"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :attach-classic-link-vpc,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   attach-classic-link-vpc
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         groups
                         clone-root]}]]),
    :doc "Call attachClassicLinkVpc"}
   [credentials3012 & args3013]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3014
     (com.palletops.awaze.common/aws-client :ec2 credentials3012)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3014
      attachClassicLinkVpc
      (ec2/attach-classic-link-vpc-request
       (clojure.core/nth args3013 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :replace-network-acl-association
   [m3019]
   (clojure.core/let
    [credentials3020 (:credentials m3019) args3021 (:args m3019)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3022
      (com.palletops.awaze.common/aws-client :ec2 credentials3020)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3022
       replaceNetworkAclAssociation
       (ec2/replace-network-acl-association-request
        (clojure.core/nth args3021 0)))))))
  (clojure.core/defn
   replace-network-acl-association-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         association-id
                         sdk-request-timeout
                         network-acl-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for replaceNetworkAclAssociation"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :replace-network-acl-association,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   replace-network-acl-association
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         association-id
                         sdk-request-timeout
                         network-acl-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call replaceNetworkAclAssociation"}
   [credentials3024 & args3025]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3026
     (com.palletops.awaze.common/aws-client :ec2 credentials3024)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3026
      replaceNetworkAclAssociation
      (ec2/replace-network-acl-association-request
       (clojure.core/nth args3025 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-nat-gateway
   [m3027]
   (clojure.core/let
    [credentials3028 (:credentials m3027) args3029 (:args m3027)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3030
      (com.palletops.awaze.common/aws-client :ec2 credentials3028)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3030
       deleteNatGateway
       (ec2/delete-nat-gateway-request (clojure.core/nth args3029 0)))))))
  (clojure.core/defn
   delete-nat-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         nat-gateway-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteNatGateway"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-nat-gateway,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-nat-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         nat-gateway-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteNatGateway"}
   [credentials3032 & args3033]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3034
     (com.palletops.awaze.common/aws-client :ec2 credentials3032)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3034
      deleteNatGateway
      (ec2/delete-nat-gateway-request (clojure.core/nth args3033 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-instance-attribute
   [m3035]
   (clojure.core/let
    [credentials3036 (:credentials m3035) args3037 (:args m3035)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3038
      (com.palletops.awaze.common/aws-client :ec2 credentials3036)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3038
       modifyInstanceAttribute
       (ec2/modify-instance-attribute-request
        (clojure.core/nth args3037 0)))))))
  (clojure.core/defn
   modify-instance-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-initiated-shutdown-behavior
                         attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         source-dest-check
                         sdk-request-timeout
                         disable-api-termination
                         ramdisk
                         value
                         instance-type
                         custom-query-parameters
                         ebs-optimized
                         instance-id
                         user-data
                         read-limit
                         sriov-net-support
                         general-progress-listener
                         kernel
                         clone-source
                         groups
                         block-device-mappings
                         clone-root]}]]),
    :doc "Generate map for modifyInstanceAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-instance-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-instance-attribute
   {:arglists (quote
               [[credentials
                 {:keys [instance-initiated-shutdown-behavior
                         attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         source-dest-check
                         sdk-request-timeout
                         disable-api-termination
                         ramdisk
                         value
                         instance-type
                         custom-query-parameters
                         ebs-optimized
                         instance-id
                         user-data
                         read-limit
                         sriov-net-support
                         general-progress-listener
                         kernel
                         clone-source
                         groups
                         block-device-mappings
                         clone-root]}]]),
    :doc "Call modifyInstanceAttribute"}
   [credentials3040 & args3041]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3042
     (com.palletops.awaze.common/aws-client :ec2 credentials3040)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3042
      modifyInstanceAttribute
      (ec2/modify-instance-attribute-request
       (clojure.core/nth args3041 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-network-acls
   [m3043]
   (clojure.core/let
    [credentials3044 (:credentials m3043) args3045 (:args m3043)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3046
      (com.palletops.awaze.common/aws-client :ec2 credentials3044)]
     (clojure.core/case
      (clojure.core/count args3045)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3046
        describeNetworkAcls))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3046
        describeNetworkAcls
        (ec2/describe-network-acls-request
         (clojure.core/nth args3045 0))))))))
  (clojure.core/defn
   describe-network-acls-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         network-acl-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeNetworkAcls, describeNetworkAcls"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-network-acls,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-network-acls,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-network-acls
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         network-acl-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeNetworkAcls, describeNetworkAcls"}
   [credentials3048 & args3049]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3050
     (com.palletops.awaze.common/aws-client :ec2 credentials3048)]
    (clojure.core/case
     (clojure.core/count args3049)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3050
       describeNetworkAcls))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3050
       describeNetworkAcls
       (ec2/describe-network-acls-request
        (clojure.core/nth args3049 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :report-instance-status
   [m3051]
   (clojure.core/let
    [credentials3052 (:credentials m3051) args3053 (:args m3051)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3054
      (com.palletops.awaze.common/aws-client :ec2 credentials3052)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3054
       reportInstanceStatus
       (ec2/report-instance-status-request
        (clojure.core/nth args3053 0)))))))
  (clojure.core/defn
   report-instance-status-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         reason-codes
                         start-time
                         custom-query-parameters
                         end-time
                         read-limit
                         instances
                         status
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for reportInstanceStatus"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :report-instance-status,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   report-instance-status
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         reason-codes
                         start-time
                         custom-query-parameters
                         end-time
                         read-limit
                         instances
                         status
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call reportInstanceStatus"}
   [credentials3056 & args3057]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3058
     (com.palletops.awaze.common/aws-client :ec2 credentials3056)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3058
      reportInstanceStatus
      (ec2/report-instance-status-request
       (clojure.core/nth args3057 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-images
   [m3059]
   (clojure.core/let
    [credentials3060 (:credentials m3059) args3061 (:args m3059)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3062
      (com.palletops.awaze.common/aws-client :ec2 credentials3060)]
     (clojure.core/case
      (clojure.core/count args3061)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3062
        describeImages))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3062
        describeImages
        (ec2/describe-images-request (clojure.core/nth args3061 0))))))))
  (clojure.core/defn
   describe-images-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         executable-users
                         owners
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         image-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeImages, describeImages"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-images,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-images,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-images
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         executable-users
                         owners
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         image-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeImages, describeImages"}
   [credentials3064 & args3065]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3066
     (com.palletops.awaze.common/aws-client :ec2 credentials3064)]
    (clojure.core/case
     (clojure.core/count args3065)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3066
       describeImages))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3066
       describeImages
       (ec2/describe-images-request (clojure.core/nth args3065 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-import-image-tasks
   [m3067]
   (clojure.core/let
    [credentials3068 (:credentials m3067) args3069 (:args m3067)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3070
      (com.palletops.awaze.common/aws-client :ec2 credentials3068)]
     (clojure.core/case
      (clojure.core/count args3069)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3070
        describeImportImageTasks
        (ec2/describe-import-image-tasks-request
         (clojure.core/nth args3069 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3070
        describeImportImageTasks))))))
  (clojure.core/defn
   describe-import-image-tasks-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         import-task-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeImportImageTasks, describeImportImageTasks"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-import-image-tasks,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-import-image-tasks,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-import-image-tasks
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         import-task-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call describeImportImageTasks, describeImportImageTasks"}
   [credentials3072 & args3073]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3074
     (com.palletops.awaze.common/aws-client :ec2 credentials3072)]
    (clojure.core/case
     (clojure.core/count args3073)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3074
       describeImportImageTasks
       (ec2/describe-import-image-tasks-request
        (clojure.core/nth args3073 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3074
       describeImportImageTasks))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-hosts
   [m3075]
   (clojure.core/let
    [credentials3076 (:credentials m3075) args3077 (:args m3075)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3078
      (com.palletops.awaze.common/aws-client :ec2 credentials3076)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3078
       modifyHosts
       (ec2/modify-hosts-request (clojure.core/nth args3077 0)))))))
  (clojure.core/defn
   modify-hosts-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         auto-placement
                         read-limit
                         host-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for modifyHosts"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-hosts,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-hosts
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         auto-placement
                         read-limit
                         host-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call modifyHosts"}
   [credentials3080 & args3081]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3082
     (com.palletops.awaze.common/aws-client :ec2 credentials3080)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3082
      modifyHosts
      (ec2/modify-hosts-request (clojure.core/nth args3081 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :register-image
   [m3083]
   (clojure.core/let
    [credentials3084 (:credentials m3083) args3085 (:args m3083)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3086
      (com.palletops.awaze.common/aws-client :ec2 credentials3084)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3086
       registerImage
       (ec2/register-image-request (clojure.core/nth args3085 0)))))))
  (clojure.core/defn
   register-image-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         ramdisk-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         architecture
                         sdk-request-timeout
                         root-device-name
                         name
                         virtualization-type
                         custom-query-parameters
                         read-limit
                         sriov-net-support
                         kernel-id
                         general-progress-listener
                         clone-source
                         image-location
                         block-device-mappings
                         clone-root]}]]),
    :doc "Generate map for registerImage"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :register-image,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   register-image
   {:arglists (quote
               [[credentials
                 {:keys [description
                         ramdisk-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         architecture
                         sdk-request-timeout
                         root-device-name
                         name
                         virtualization-type
                         custom-query-parameters
                         read-limit
                         sriov-net-support
                         kernel-id
                         general-progress-listener
                         clone-source
                         image-location
                         block-device-mappings
                         clone-root]}]]),
    :doc "Call registerImage"}
   [credentials3088 & args3089]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3090
     (com.palletops.awaze.common/aws-client :ec2 credentials3088)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3090
      registerImage
      (ec2/register-image-request (clojure.core/nth args3089 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :detach-vpn-gateway
   [m3091]
   (clojure.core/let
    [credentials3092 (:credentials m3091) args3093 (:args m3091)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3094
      (com.palletops.awaze.common/aws-client :ec2 credentials3092)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3094
       detachVpnGateway
       (ec2/detach-vpn-gateway-request (clojure.core/nth args3093 0)))))))
  (clojure.core/defn
   detach-vpn-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         vpn-gateway-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for detachVpnGateway"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :detach-vpn-gateway,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   detach-vpn-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         vpn-gateway-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call detachVpnGateway"}
   [credentials3096 & args3097]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3098
     (com.palletops.awaze.common/aws-client :ec2 credentials3096)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3098
      detachVpnGateway
      (ec2/detach-vpn-gateway-request (clojure.core/nth args3097 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-volume
   [m3099]
   (clojure.core/let
    [credentials3100 (:credentials m3099) args3101 (:args m3099)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3102
      (com.palletops.awaze.common/aws-client :ec2 credentials3100)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3102
       deleteVolume
       (ec2/delete-volume-request (clojure.core/nth args3101 0)))))))
  (clojure.core/defn
   delete-volume-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteVolume"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-volume,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-volume
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteVolume"}
   [credentials3104 & args3105]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3106
     (com.palletops.awaze.common/aws-client :ec2 credentials3104)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3106
      deleteVolume
      (ec2/delete-volume-request (clojure.core/nth args3105 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-internet-gateway
   [m3107]
   (clojure.core/let
    [credentials3108 (:credentials m3107) args3109 (:args m3107)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3110
      (com.palletops.awaze.common/aws-client :ec2 credentials3108)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3110
       deleteInternetGateway
       (ec2/delete-internet-gateway-request
        (clojure.core/nth args3109 0)))))))
  (clojure.core/defn
   delete-internet-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         internet-gateway-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteInternetGateway"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-internet-gateway,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-internet-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         internet-gateway-id
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteInternetGateway"}
   [credentials3112 & args3113]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3114
     (com.palletops.awaze.common/aws-client :ec2 credentials3112)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3114
      deleteInternetGateway
      (ec2/delete-internet-gateway-request
       (clojure.core/nth args3113 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-subnet
   [m3115]
   (clojure.core/let
    [credentials3116 (:credentials m3115) args3117 (:args m3115)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3118
      (com.palletops.awaze.common/aws-client :ec2 credentials3116)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3118
       deleteSubnet
       (ec2/delete-subnet-request (clojure.core/nth args3117 0)))))))
  (clojure.core/defn
   delete-subnet-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subnet-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteSubnet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-subnet,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-subnet
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subnet-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteSubnet"}
   [credentials3120 & args3121]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3122
     (com.palletops.awaze.common/aws-client :ec2 credentials3120)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3122
      deleteSubnet
      (ec2/delete-subnet-request (clojure.core/nth args3121 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :reset-instance-attribute
   [m3123]
   (clojure.core/let
    [credentials3124 (:credentials m3123) args3125 (:args m3123)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3126
      (com.palletops.awaze.common/aws-client :ec2 credentials3124)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3126
       resetInstanceAttribute
       (ec2/reset-instance-attribute-request
        (clojure.core/nth args3125 0)))))))
  (clojure.core/defn
   reset-instance-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for resetInstanceAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :reset-instance-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   reset-instance-attribute
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call resetInstanceAttribute"}
   [credentials3128 & args3129]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3130
     (com.palletops.awaze.common/aws-client :ec2 credentials3128)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3130
      resetInstanceAttribute
      (ec2/reset-instance-attribute-request
       (clojure.core/nth args3129 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :detach-volume
   [m3131]
   (clojure.core/let
    [credentials3132 (:credentials m3131) args3133 (:args m3131)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3134
      (com.palletops.awaze.common/aws-client :ec2 credentials3132)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3134
       detachVolume
       (ec2/detach-volume-request (clojure.core/nth args3133 0)))))))
  (clojure.core/defn
   detach-volume-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         force
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         volume-id
                         read-limit
                         general-progress-listener
                         device
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for detachVolume"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :detach-volume,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   detach-volume
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         force
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         volume-id
                         read-limit
                         general-progress-listener
                         device
                         clone-source
                         clone-root]}]]),
    :doc "Call detachVolume"}
   [credentials3136 & args3137]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3138
     (com.palletops.awaze.common/aws-client :ec2 credentials3136)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3138
      detachVolume
      (ec2/detach-volume-request (clojure.core/nth args3137 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-export-tasks
   [m3139]
   (clojure.core/let
    [credentials3140 (:credentials m3139) args3141 (:args m3139)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3142
      (com.palletops.awaze.common/aws-client :ec2 credentials3140)]
     (clojure.core/case
      (clojure.core/count args3141)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3142
        describeExportTasks))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3142
        describeExportTasks
        (ec2/describe-export-tasks-request
         (clojure.core/nth args3141 0))))))))
  (clojure.core/defn
   describe-export-tasks-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         export-task-ids
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeExportTasks, describeExportTasks"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-export-tasks,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-export-tasks,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-export-tasks
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         export-task-ids
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeExportTasks, describeExportTasks"}
   [credentials3144 & args3145]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3146
     (com.palletops.awaze.common/aws-client :ec2 credentials3144)]
    (clojure.core/case
     (clojure.core/count args3145)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3146
       describeExportTasks))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3146
       describeExportTasks
       (ec2/describe-export-tasks-request
        (clojure.core/nth args3145 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-scheduled-instances
   [m3147]
   (clojure.core/let
    [credentials3148 (:credentials m3147) args3149 (:args m3147)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3150
      (com.palletops.awaze.common/aws-client :ec2 credentials3148)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3150
       describeScheduledInstances
       (ec2/describe-scheduled-instances-request
        (clojure.core/nth args3149 0)))))))
  (clojure.core/defn
   describe-scheduled-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         scheduled-instance-ids
                         clone-source
                         slot-start-time-range
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeScheduledInstances"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-scheduled-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-scheduled-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         scheduled-instance-ids
                         clone-source
                         slot-start-time-range
                         clone-root
                         next-token]}]]),
    :doc "Call describeScheduledInstances"}
   [credentials3152 & args3153]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3154
     (com.palletops.awaze.common/aws-client :ec2 credentials3152)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3154
      describeScheduledInstances
      (ec2/describe-scheduled-instances-request
       (clojure.core/nth args3153 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-flow-logs
   [m3155]
   (clojure.core/let
    [credentials3156 (:credentials m3155) args3157 (:args m3155)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3158
      (com.palletops.awaze.common/aws-client :ec2 credentials3156)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3158
       deleteFlowLogs
       (ec2/delete-flow-logs-request (clojure.core/nth args3157 0)))))))
  (clojure.core/defn
   delete-flow-logs-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         flow-log-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteFlowLogs"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-flow-logs,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-flow-logs
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         flow-log-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteFlowLogs"}
   [credentials3160 & args3161]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3162
     (com.palletops.awaze.common/aws-client :ec2 credentials3160)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3162
      deleteFlowLogs
      (ec2/delete-flow-logs-request (clojure.core/nth args3161 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-vpc
   [m3163]
   (clojure.core/let
    [credentials3164 (:credentials m3163) args3165 (:args m3163)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3166
      (com.palletops.awaze.common/aws-client :ec2 credentials3164)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3166
       createVpc
       (ec2/create-vpc-request (clojure.core/nth args3165 0)))))))
  (clojure.core/defn
   create-vpc-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         cidr-block
                         clone-root
                         instance-tenancy]}]]),
    :doc "Generate map for createVpc"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-vpc,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-vpc
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         cidr-block
                         clone-root
                         instance-tenancy]}]]),
    :doc "Call createVpc"}
   [credentials3168 & args3169]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3170
     (com.palletops.awaze.common/aws-client :ec2 credentials3168)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3170
      createVpc
      (ec2/create-vpc-request (clojure.core/nth args3169 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-spot-datafeed-subscription
   [m3171]
   (clojure.core/let
    [credentials3172 (:credentials m3171) args3173 (:args m3171)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3174
      (com.palletops.awaze.common/aws-client :ec2 credentials3172)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3174
       createSpotDatafeedSubscription
       (ec2/create-spot-datafeed-subscription-request
        (clojure.core/nth args3173 0)))))))
  (clojure.core/defn
   create-spot-datafeed-subscription-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         prefix
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Generate map for createSpotDatafeedSubscription"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-spot-datafeed-subscription,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-spot-datafeed-subscription
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         prefix
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Call createSpotDatafeedSubscription"}
   [credentials3176 & args3177]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3178
     (com.palletops.awaze.common/aws-client :ec2 credentials3176)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3178
      createSpotDatafeedSubscription
      (ec2/create-spot-datafeed-subscription-request
       (clojure.core/nth args3177 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpc-classic-link
   [m3179]
   (clojure.core/let
    [credentials3180 (:credentials m3179) args3181 (:args m3179)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3182
      (com.palletops.awaze.common/aws-client :ec2 credentials3180)]
     (clojure.core/case
      (clojure.core/count args3181)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3182
        describeVpcClassicLink))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3182
        describeVpcClassicLink
        (ec2/describe-vpc-classic-link-request
         (clojure.core/nth args3181 0))))))))
  (clojure.core/defn
   describe-vpc-classic-link-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-ids
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeVpcClassicLink, describeVpcClassicLink"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-vpc-classic-link,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-vpc-classic-link,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-vpc-classic-link
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-ids
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeVpcClassicLink, describeVpcClassicLink"}
   [credentials3184 & args3185]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3186
     (com.palletops.awaze.common/aws-client :ec2 credentials3184)]
    (clojure.core/case
     (clojure.core/count args3185)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3186
       describeVpcClassicLink))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3186
       describeVpcClassicLink
       (ec2/describe-vpc-classic-link-request
        (clojure.core/nth args3185 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-route
   [m3187]
   (clojure.core/let
    [credentials3188 (:credentials m3187) args3189 (:args m3187)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3190
      (com.palletops.awaze.common/aws-client :ec2 credentials3188)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3190
       deleteRoute
       (ec2/delete-route-request (clojure.core/nth args3189 0)))))))
  (clojure.core/defn
   delete-route-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         destination-cidr-block
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         route-table-id
                         clone-root]}]]),
    :doc "Generate map for deleteRoute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-route,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-route
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         destination-cidr-block
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         route-table-id
                         clone-root]}]]),
    :doc "Call deleteRoute"}
   [credentials3192 & args3193]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3194
     (com.palletops.awaze.common/aws-client :ec2 credentials3192)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3194
      deleteRoute
      (ec2/delete-route-request (clojure.core/nth args3193 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-id-format
   [m3195]
   (clojure.core/let
    [credentials3196 (:credentials m3195) args3197 (:args m3195)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3198
      (com.palletops.awaze.common/aws-client :ec2 credentials3196)]
     (clojure.core/case
      (clojure.core/count args3197)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3198
        describeIdFormat
        (ec2/describe-id-format-request (clojure.core/nth args3197 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3198
        describeIdFormat))))))
  (clojure.core/defn
   describe-id-format-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         resource
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeIdFormat, describeIdFormat"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-id-format,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-id-format,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-id-format
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         resource
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeIdFormat, describeIdFormat"}
   [credentials3200 & args3201]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3202
     (com.palletops.awaze.common/aws-client :ec2 credentials3200)]
    (clojure.core/case
     (clojure.core/count args3201)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3202
       describeIdFormat
       (ec2/describe-id-format-request (clojure.core/nth args3201 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3202
       describeIdFormat))))))
 (do
  (clojure.core/defmethod
   ec2
   :attach-volume
   [m3203]
   (clojure.core/let
    [credentials3204 (:credentials m3203) args3205 (:args m3203)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3206
      (com.palletops.awaze.common/aws-client :ec2 credentials3204)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3206
       attachVolume
       (ec2/attach-volume-request (clojure.core/nth args3205 0)))))))
  (clojure.core/defn
   attach-volume-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         volume-id
                         read-limit
                         general-progress-listener
                         device
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for attachVolume"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :attach-volume,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   attach-volume
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         volume-id
                         read-limit
                         general-progress-listener
                         device
                         clone-source
                         clone-root]}]]),
    :doc "Call attachVolume"}
   [credentials3208 & args3209]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3210
     (com.palletops.awaze.common/aws-client :ec2 credentials3208)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3210
      attachVolume
      (ec2/attach-volume-request (clojure.core/nth args3209 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :enable-volume-io
   [m3211]
   (clojure.core/let
    [credentials3212 (:credentials m3211) args3213 (:args m3211)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3214
      (com.palletops.awaze.common/aws-client :ec2 credentials3212)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3214
       enableVolumeIO
       (ec2/enable-volume-iorequest (clojure.core/nth args3213 0)))))))
  (clojure.core/defn
   enable-volume-io-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for enableVolumeIO"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :enable-volume-io,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   enable-volume-io
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call enableVolumeIO"}
   [credentials3216 & args3217]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3218
     (com.palletops.awaze.common/aws-client :ec2 credentials3216)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3218
      enableVolumeIO
      (ec2/enable-volume-iorequest (clojure.core/nth args3217 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :attach-vpn-gateway
   [m3219]
   (clojure.core/let
    [credentials3220 (:credentials m3219) args3221 (:args m3219)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3222
      (com.palletops.awaze.common/aws-client :ec2 credentials3220)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3222
       attachVpnGateway
       (ec2/attach-vpn-gateway-request (clojure.core/nth args3221 0)))))))
  (clojure.core/defn
   attach-vpn-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         vpn-gateway-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for attachVpnGateway"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :attach-vpn-gateway,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   attach-vpn-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         vpn-gateway-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call attachVpnGateway"}
   [credentials3224 & args3225]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3226
     (com.palletops.awaze.common/aws-client :ec2 credentials3224)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3226
      attachVpnGateway
      (ec2/attach-vpn-gateway-request (clojure.core/nth args3225 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :replace-network-acl-entry
   [m3227]
   (clojure.core/let
    [credentials3228 (:credentials m3227) args3229 (:args m3227)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3230
      (com.palletops.awaze.common/aws-client :ec2 credentials3228)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3230
       replaceNetworkAclEntry
       (ec2/replace-network-acl-entry-request
        (clojure.core/nth args3229 0)))))))
  (clojure.core/defn
   replace-network-acl-entry-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         protocol
                         sdk-request-timeout
                         network-acl-id
                         custom-query-parameters
                         rule-action
                         rule-number
                         read-limit
                         general-progress-listener
                         egress
                         icmp-type-code
                         port-range
                         clone-source
                         cidr-block
                         clone-root]}]]),
    :doc "Generate map for replaceNetworkAclEntry"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :replace-network-acl-entry,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   replace-network-acl-entry
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         protocol
                         sdk-request-timeout
                         network-acl-id
                         custom-query-parameters
                         rule-action
                         rule-number
                         read-limit
                         general-progress-listener
                         egress
                         icmp-type-code
                         port-range
                         clone-source
                         cidr-block
                         clone-root]}]]),
    :doc "Call replaceNetworkAclEntry"}
   [credentials3232 & args3233]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3234
     (com.palletops.awaze.common/aws-client :ec2 credentials3232)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3234
      replaceNetworkAclEntry
      (ec2/replace-network-acl-entry-request
       (clojure.core/nth args3233 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-snapshot-attribute
   [m3235]
   (clojure.core/let
    [credentials3236 (:credentials m3235) args3237 (:args m3235)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3238
      (com.palletops.awaze.common/aws-client :ec2 credentials3236)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3238
       describeSnapshotAttribute
       (ec2/describe-snapshot-attribute-request
        (clojure.core/nth args3237 0)))))))
  (clojure.core/defn
   describe-snapshot-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeSnapshotAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-snapshot-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-snapshot-attribute
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeSnapshotAttribute"}
   [credentials3240 & args3241]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3242
     (com.palletops.awaze.common/aws-client :ec2 credentials3240)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3242
      describeSnapshotAttribute
      (ec2/describe-snapshot-attribute-request
       (clojure.core/nth args3241 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :reboot-instances
   [m3243]
   (clojure.core/let
    [credentials3244 (:credentials m3243) args3245 (:args m3243)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3246
      (com.palletops.awaze.common/aws-client :ec2 credentials3244)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3246
       rebootInstances
       (ec2/reboot-instances-request (clojure.core/nth args3245 0)))))))
  (clojure.core/defn
   reboot-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for rebootInstances"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :reboot-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   reboot-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call rebootInstances"}
   [credentials3248 & args3249]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3250
     (com.palletops.awaze.common/aws-client :ec2 credentials3248)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3250
      rebootInstances
      (ec2/reboot-instances-request (clojure.core/nth args3249 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :reject-vpc-peering-connection
   [m3251]
   (clojure.core/let
    [credentials3252 (:credentials m3251) args3253 (:args m3251)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3254
      (com.palletops.awaze.common/aws-client :ec2 credentials3252)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3254
       rejectVpcPeeringConnection
       (ec2/reject-vpc-peering-connection-request
        (clojure.core/nth args3253 0)))))))
  (clojure.core/defn
   reject-vpc-peering-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-peering-connection-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for rejectVpcPeeringConnection"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :reject-vpc-peering-connection,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   reject-vpc-peering-connection
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-peering-connection-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call rejectVpcPeeringConnection"}
   [credentials3256 & args3257]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3258
     (com.palletops.awaze.common/aws-client :ec2 credentials3256)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3258
      rejectVpcPeeringConnection
      (ec2/reject-vpc-peering-connection-request
       (clojure.core/nth args3257 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-security-group
   [m3259]
   (clojure.core/let
    [credentials3260 (:credentials m3259) args3261 (:args m3259)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3262
      (com.palletops.awaze.common/aws-client :ec2 credentials3260)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3262
       createSecurityGroup
       (ec2/create-security-group-request
        (clojure.core/nth args3261 0)))))))
  (clojure.core/defn
   create-security-group-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createSecurityGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-security-group,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-security-group
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createSecurityGroup"}
   [credentials3264 & args3265]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3266
     (com.palletops.awaze.common/aws-client :ec2 credentials3264)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3266
      createSecurityGroup
      (ec2/create-security-group-request
       (clojure.core/nth args3265 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-spot-instance-requests
   [m3267]
   (clojure.core/let
    [credentials3268 (:credentials m3267) args3269 (:args m3267)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3270
      (com.palletops.awaze.common/aws-client :ec2 credentials3268)]
     (clojure.core/case
      (clojure.core/count args3269)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3270
        describeSpotInstanceRequests))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3270
        describeSpotInstanceRequests
        (ec2/describe-spot-instance-requests-request
         (clojure.core/nth args3269 0))))))))
  (clojure.core/defn
   describe-spot-instance-requests-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         spot-instance-request-ids
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeSpotInstanceRequests, describeSpotInstanceRequests"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-spot-instance-requests,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-spot-instance-requests,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-spot-instance-requests
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         spot-instance-request-ids
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeSpotInstanceRequests, describeSpotInstanceRequests"}
   [credentials3272 & args3273]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3274
     (com.palletops.awaze.common/aws-client :ec2 credentials3272)]
    (clojure.core/case
     (clojure.core/count args3273)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3274
       describeSpotInstanceRequests))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3274
       describeSpotInstanceRequests
       (ec2/describe-spot-instance-requests-request
        (clojure.core/nth args3273 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-spot-datafeed-subscription
   [m3275]
   (clojure.core/let
    [credentials3276 (:credentials m3275) args3277 (:args m3275)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3278
      (com.palletops.awaze.common/aws-client :ec2 credentials3276)]
     (clojure.core/case
      (clojure.core/count args3277)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3278
        describeSpotDatafeedSubscription))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3278
        describeSpotDatafeedSubscription
        (ec2/describe-spot-datafeed-subscription-request
         (clojure.core/nth args3277 0))))))))
  (clojure.core/defn
   describe-spot-datafeed-subscription-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeSpotDatafeedSubscription, describeSpotDatafeedSubscription"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-spot-datafeed-subscription,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-spot-datafeed-subscription,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-spot-datafeed-subscription
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeSpotDatafeedSubscription, describeSpotDatafeedSubscription"}
   [credentials3280 & args3281]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3282
     (com.palletops.awaze.common/aws-client :ec2 credentials3280)]
    (clojure.core/case
     (clojure.core/count args3281)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3282
       describeSpotDatafeedSubscription))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3282
       describeSpotDatafeedSubscription
       (ec2/describe-spot-datafeed-subscription-request
        (clojure.core/nth args3281 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :move-address-to-vpc
   [m3283]
   (clojure.core/let
    [credentials3284 (:credentials m3283) args3285 (:args m3283)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3286
      (com.palletops.awaze.common/aws-client :ec2 credentials3284)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3286
       moveAddressToVpc
       (ec2/move-address-to-vpc-request (clojure.core/nth args3285 0)))))))
  (clojure.core/defn
   move-address-to-vpc-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         public-ip]}]]),
    :doc "Generate map for moveAddressToVpc"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :move-address-to-vpc,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   move-address-to-vpc
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         public-ip]}]]),
    :doc "Call moveAddressToVpc"}
   [credentials3288 & args3289]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3290
     (com.palletops.awaze.common/aws-client :ec2 credentials3288)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3290
      moveAddressToVpc
      (ec2/move-address-to-vpc-request (clojure.core/nth args3289 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-vpc-endpoint
   [m3291]
   (clojure.core/let
    [credentials3292 (:credentials m3291) args3293 (:args m3291)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3294
      (com.palletops.awaze.common/aws-client :ec2 credentials3292)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3294
       modifyVpcEndpoint
       (ec2/modify-vpc-endpoint-request (clojure.core/nth args3293 0)))))))
  (clojure.core/defn
   modify-vpc-endpoint-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         add-route-table-ids
                         sdk-request-timeout
                         remove-route-table-ids
                         custom-query-parameters
                         reset-policy
                         read-limit
                         general-progress-listener
                         clone-source
                         vpc-endpoint-id
                         clone-root]}]]),
    :doc "Generate map for modifyVpcEndpoint"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-vpc-endpoint,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-vpc-endpoint
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         add-route-table-ids
                         sdk-request-timeout
                         remove-route-table-ids
                         custom-query-parameters
                         reset-policy
                         read-limit
                         general-progress-listener
                         clone-source
                         vpc-endpoint-id
                         clone-root]}]]),
    :doc "Call modifyVpcEndpoint"}
   [credentials3296 & args3297]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3298
     (com.palletops.awaze.common/aws-client :ec2 credentials3296)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3298
      modifyVpcEndpoint
      (ec2/modify-vpc-endpoint-request (clojure.core/nth args3297 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :attach-network-interface
   [m3299]
   (clojure.core/let
    [credentials3300 (:credentials m3299) args3301 (:args m3299)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3302
      (com.palletops.awaze.common/aws-client :ec2 credentials3300)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3302
       attachNetworkInterface
       (ec2/attach-network-interface-request
        (clojure.core/nth args3301 0)))))))
  (clojure.core/defn
   attach-network-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         device-index
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for attachNetworkInterface"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :attach-network-interface,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   attach-network-interface
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         device-index
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call attachNetworkInterface"}
   [credentials3304 & args3305]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3306
     (com.palletops.awaze.common/aws-client :ec2 credentials3304)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3306
      attachNetworkInterface
      (ec2/attach-network-interface-request
       (clojure.core/nth args3305 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :detach-network-interface
   [m3307]
   (clojure.core/let
    [credentials3308 (:credentials m3307) args3309 (:args m3307)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3310
      (com.palletops.awaze.common/aws-client :ec2 credentials3308)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3310
       detachNetworkInterface
       (ec2/detach-network-interface-request
        (clojure.core/nth args3309 0)))))))
  (clojure.core/defn
   detach-network-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         force
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         attachment-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for detachNetworkInterface"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :detach-network-interface,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   detach-network-interface
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         force
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         attachment-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call detachNetworkInterface"}
   [credentials3312 & args3313]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3314
     (com.palletops.awaze.common/aws-client :ec2 credentials3312)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3314
      detachNetworkInterface
      (ec2/detach-network-interface-request
       (clojure.core/nth args3313 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-dhcp-options
   [m3315]
   (clojure.core/let
    [credentials3316 (:credentials m3315) args3317 (:args m3315)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3318
      (com.palletops.awaze.common/aws-client :ec2 credentials3316)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3318
       deleteDhcpOptions
       (ec2/delete-dhcp-options-request (clojure.core/nth args3317 0)))))))
  (clojure.core/defn
   delete-dhcp-options-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         dhcp-options-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteDhcpOptions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-dhcp-options,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-dhcp-options
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         dhcp-options-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteDhcpOptions"}
   [credentials3320 & args3321]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3322
     (com.palletops.awaze.common/aws-client :ec2 credentials3320)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3322
      deleteDhcpOptions
      (ec2/delete-dhcp-options-request (clojure.core/nth args3321 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpc-endpoints
   [m3323]
   (clojure.core/let
    [credentials3324 (:credentials m3323) args3325 (:args m3323)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3326
      (com.palletops.awaze.common/aws-client :ec2 credentials3324)]
     (clojure.core/case
      (clojure.core/count args3325)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3326
        describeVpcEndpoints))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3326
        describeVpcEndpoints
        (ec2/describe-vpc-endpoints-request
         (clojure.core/nth args3325 0))))))))
  (clojure.core/defn
   describe-vpc-endpoints-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         vpc-endpoint-ids
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeVpcEndpoints, describeVpcEndpoints"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-vpc-endpoints,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-vpc-endpoints,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-vpc-endpoints
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         vpc-endpoint-ids
                         clone-root
                         next-token]}]]),
    :doc "Call describeVpcEndpoints, describeVpcEndpoints"}
   [credentials3328 & args3329]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3330
     (com.palletops.awaze.common/aws-client :ec2 credentials3328)]
    (clojure.core/case
     (clojure.core/count args3329)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3330
       describeVpcEndpoints))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3330
       describeVpcEndpoints
       (ec2/describe-vpc-endpoints-request
        (clojure.core/nth args3329 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :confirm-product-instance
   [m3331]
   (clojure.core/let
    [credentials3332 (:credentials m3331) args3333 (:args m3331)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3334
      (com.palletops.awaze.common/aws-client :ec2 credentials3332)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3334
       confirmProductInstance
       (ec2/confirm-product-instance-request
        (clojure.core/nth args3333 0)))))))
  (clojure.core/defn
   confirm-product-instance-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         product-code
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for confirmProductInstance"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :confirm-product-instance,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   confirm-product-instance
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         product-code
                         clone-source
                         clone-root]}]]),
    :doc "Call confirmProductInstance"}
   [credentials3336 & args3337]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3338
     (com.palletops.awaze.common/aws-client :ec2 credentials3336)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3338
      confirmProductInstance
      (ec2/confirm-product-instance-request
       (clojure.core/nth args3337 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :allocate-address
   [m3339]
   (clojure.core/let
    [credentials3340 (:credentials m3339) args3341 (:args m3339)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3342
      (com.palletops.awaze.common/aws-client :ec2 credentials3340)]
     (clojure.core/case
      (clojure.core/count args3341)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3342
        allocateAddress))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3342
        allocateAddress
        (ec2/allocate-address-request (clojure.core/nth args3341 0))))))))
  (clojure.core/defn
   allocate-address-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         domain
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for allocateAddress, allocateAddress"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :allocate-address,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :allocate-address,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   allocate-address
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         domain
                         clone-source
                         clone-root]}]]),
    :doc "Call allocateAddress, allocateAddress"}
   [credentials3344 & args3345]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3346
     (com.palletops.awaze.common/aws-client :ec2 credentials3344)]
    (clojure.core/case
     (clojure.core/count args3345)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3346
       allocateAddress))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3346
       allocateAddress
       (ec2/allocate-address-request (clojure.core/nth args3345 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-vpc-endpoint
   [m3347]
   (clojure.core/let
    [credentials3348 (:credentials m3347) args3349 (:args m3347)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3350
      (com.palletops.awaze.common/aws-client :ec2 credentials3348)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3350
       createVpcEndpoint
       (ec2/create-vpc-endpoint-request (clojure.core/nth args3349 0)))))))
  (clojure.core/defn
   create-vpc-endpoint-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         service-name
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         route-table-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         client-token
                         clone-root]}]]),
    :doc "Generate map for createVpcEndpoint"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-vpc-endpoint,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-vpc-endpoint
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-document
                         service-name
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         route-table-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         client-token
                         clone-root]}]]),
    :doc "Call createVpcEndpoint"}
   [credentials3352 & args3353]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3354
     (com.palletops.awaze.common/aws-client :ec2 credentials3352)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3354
      createVpcEndpoint
      (ec2/create-vpc-endpoint-request (clojure.core/nth args3353 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :import-key-pair
   [m3355]
   (clojure.core/let
    [credentials3356 (:credentials m3355) args3357 (:args m3355)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3358
      (com.palletops.awaze.common/aws-client :ec2 credentials3356)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3358
       importKeyPair
       (ec2/import-key-pair-request (clojure.core/nth args3357 0)))))))
  (clojure.core/defn
   import-key-pair-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key-name
                         public-key-material
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for importKeyPair"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :import-key-pair,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   import-key-pair
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key-name
                         public-key-material
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call importKeyPair"}
   [credentials3360 & args3361]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3362
     (com.palletops.awaze.common/aws-client :ec2 credentials3360)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3362
      importKeyPair
      (ec2/import-key-pair-request (clojure.core/nth args3361 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :copy-snapshot
   [m3363]
   (clojure.core/let
    [credentials3364 (:credentials m3363) args3365 (:args m3363)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3366
      (com.palletops.awaze.common/aws-client :ec2 credentials3364)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3366
       copySnapshot
       (ec2/copy-snapshot-request (clojure.core/nth args3365 0)))))))
  (clojure.core/defn
   copy-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         presigned-url
                         custom-request-headers
                         sdk-client-execution-timeout
                         destination-region
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         kms-key-id
                         clone-source
                         encrypted
                         source-snapshot-id
                         clone-root
                         source-region]}]]),
    :doc "Generate map for copySnapshot"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :copy-snapshot,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   copy-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [description
                         presigned-url
                         custom-request-headers
                         sdk-client-execution-timeout
                         destination-region
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         kms-key-id
                         clone-source
                         encrypted
                         source-snapshot-id
                         clone-root
                         source-region]}]]),
    :doc "Call copySnapshot"}
   [credentials3368 & args3369]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3370
     (com.palletops.awaze.common/aws-client :ec2 credentials3368)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3370
      copySnapshot
      (ec2/copy-snapshot-request (clojure.core/nth args3369 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-snapshot
   [m3371]
   (clojure.core/let
    [credentials3372 (:credentials m3371) args3373 (:args m3371)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3374
      (com.palletops.awaze.common/aws-client :ec2 credentials3372)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3374
       deleteSnapshot
       (ec2/delete-snapshot-request (clojure.core/nth args3373 0)))))))
  (clojure.core/defn
   delete-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteSnapshot"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-snapshot,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteSnapshot"}
   [credentials3376 & args3377]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3378
     (com.palletops.awaze.common/aws-client :ec2 credentials3376)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3378
      deleteSnapshot
      (ec2/delete-snapshot-request (clojure.core/nth args3377 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :reset-image-attribute
   [m3379]
   (clojure.core/let
    [credentials3380 (:credentials m3379) args3381 (:args m3379)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3382
      (com.palletops.awaze.common/aws-client :ec2 credentials3380)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3382
       resetImageAttribute
       (ec2/reset-image-attribute-request
        (clojure.core/nth args3381 0)))))))
  (clojure.core/defn
   reset-image-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         image-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for resetImageAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :reset-image-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   reset-image-attribute
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         image-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call resetImageAttribute"}
   [credentials3384 & args3385]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3386
     (com.palletops.awaze.common/aws-client :ec2 credentials3384)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3386
      resetImageAttribute
      (ec2/reset-image-attribute-request
       (clojure.core/nth args3385 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-internet-gateway
   [m3387]
   (clojure.core/let
    [credentials3388 (:credentials m3387) args3389 (:args m3387)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3390
      (com.palletops.awaze.common/aws-client :ec2 credentials3388)]
     (clojure.core/case
      (clojure.core/count args3389)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3390
        createInternetGateway
        (ec2/create-internet-gateway-request
         (clojure.core/nth args3389 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3390
        createInternetGateway))))))
  (clojure.core/defn
   create-internet-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for createInternetGateway, createInternetGateway"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :create-internet-gateway,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-internet-gateway,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-internet-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call createInternetGateway, createInternetGateway"}
   [credentials3392 & args3393]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3394
     (com.palletops.awaze.common/aws-client :ec2 credentials3392)]
    (clojure.core/case
     (clojure.core/count args3393)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3394
       createInternetGateway
       (ec2/create-internet-gateway-request
        (clojure.core/nth args3393 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3394
       createInternetGateway))))))
 (do
  (clojure.core/defmethod
   ec2
   :monitor-instances
   [m3395]
   (clojure.core/let
    [credentials3396 (:credentials m3395) args3397 (:args m3395)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3398
      (com.palletops.awaze.common/aws-client :ec2 credentials3396)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3398
       monitorInstances
       (ec2/monitor-instances-request (clojure.core/nth args3397 0)))))))
  (clojure.core/defn
   monitor-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for monitorInstances"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :monitor-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   monitor-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call monitorInstances"}
   [credentials3400 & args3401]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3402
     (com.palletops.awaze.common/aws-client :ec2 credentials3400)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3402
      monitorInstances
      (ec2/monitor-instances-request (clojure.core/nth args3401 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :revoke-security-group-egress
   [m3403]
   (clojure.core/let
    [credentials3404 (:credentials m3403) args3405 (:args m3403)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3406
      (com.palletops.awaze.common/aws-client :ec2 credentials3404)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3406
       revokeSecurityGroupEgress
       (ec2/revoke-security-group-egress-request
        (clojure.core/nth args3405 0)))))))
  (clojure.core/defn
   revoke-security-group-egress-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         ip-permissions
                         group-id
                         sdk-request-timeout
                         custom-query-parameters
                         to-port
                         source-security-group-name
                         cidr-ip
                         ip-protocol
                         read-limit
                         general-progress-listener
                         clone-source
                         from-port
                         source-security-group-owner-id
                         clone-root]}]]),
    :doc "Generate map for revokeSecurityGroupEgress"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :revoke-security-group-egress,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   revoke-security-group-egress
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         ip-permissions
                         group-id
                         sdk-request-timeout
                         custom-query-parameters
                         to-port
                         source-security-group-name
                         cidr-ip
                         ip-protocol
                         read-limit
                         general-progress-listener
                         clone-source
                         from-port
                         source-security-group-owner-id
                         clone-root]}]]),
    :doc "Call revokeSecurityGroupEgress"}
   [credentials3408 & args3409]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3410
     (com.palletops.awaze.common/aws-client :ec2 credentials3408)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3410
      revokeSecurityGroupEgress
      (ec2/revoke-security-group-egress-request
       (clojure.core/nth args3409 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpcs
   [m3411]
   (clojure.core/let
    [credentials3412 (:credentials m3411) args3413 (:args m3411)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3414
      (com.palletops.awaze.common/aws-client :ec2 credentials3412)]
     (clojure.core/case
      (clojure.core/count args3413)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3414
        describeVpcs
        (ec2/describe-vpcs-request (clojure.core/nth args3413 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3414
        describeVpcs))))))
  (clojure.core/defn
   describe-vpcs-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-ids
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeVpcs, describeVpcs"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-vpcs,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-vpcs,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-vpcs
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-ids
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeVpcs, describeVpcs"}
   [credentials3416 & args3417]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3418
     (com.palletops.awaze.common/aws-client :ec2 credentials3416)]
    (clojure.core/case
     (clojure.core/count args3417)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3418
       describeVpcs
       (ec2/describe-vpcs-request (clojure.core/nth args3417 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3418
       describeVpcs))))))
 (do
  (clojure.core/defmethod
   ec2
   :import-instance
   [m3419]
   (clojure.core/let
    [credentials3420 (:credentials m3419) args3421 (:args m3419)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3422
      (com.palletops.awaze.common/aws-client :ec2 credentials3420)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3422
       importInstance
       (ec2/import-instance-request (clojure.core/nth args3421 0)))))))
  (clojure.core/defn
   import-instance-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         launch-specification
                         disk-images
                         clone-root
                         platform]}]]),
    :doc "Generate map for importInstance"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :import-instance,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   import-instance
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         launch-specification
                         disk-images
                         clone-root
                         platform]}]]),
    :doc "Call importInstance"}
   [credentials3424 & args3425]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3426
     (com.palletops.awaze.common/aws-client :ec2 credentials3424)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3426
      importInstance
      (ec2/import-instance-request (clojure.core/nth args3425 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :copy-image
   [m3427]
   (clojure.core/let
    [credentials3428 (:credentials m3427) args3429 (:args m3427)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3430
      (com.palletops.awaze.common/aws-client :ec2 credentials3428)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3430
       copyImage
       (ec2/copy-image-request (clojure.core/nth args3429 0)))))))
  (clojure.core/defn
   copy-image-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         source-image-id
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         kms-key-id
                         clone-source
                         encrypted
                         client-token
                         clone-root
                         source-region]}]]),
    :doc "Generate map for copyImage"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :copy-image,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   copy-image
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         source-image-id
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         kms-key-id
                         clone-source
                         encrypted
                         client-token
                         clone-root
                         source-region]}]]),
    :doc "Call copyImage"}
   [credentials3432 & args3433]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3434
     (com.palletops.awaze.common/aws-client :ec2 credentials3432)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3434
      copyImage
      (ec2/copy-image-request (clojure.core/nth args3433 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :get-console-output
   [m3435]
   (clojure.core/let
    [credentials3436 (:credentials m3435) args3437 (:args m3435)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3438
      (com.palletops.awaze.common/aws-client :ec2 credentials3436)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3438
       getConsoleOutput
       (ec2/get-console-output-request (clojure.core/nth args3437 0)))))))
  (clojure.core/defn
   get-console-output-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getConsoleOutput"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-console-output,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   get-console-output
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getConsoleOutput"}
   [credentials3440 & args3441]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3442
     (com.palletops.awaze.common/aws-client :ec2 credentials3440)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3442
      getConsoleOutput
      (ec2/get-console-output-request (clojure.core/nth args3441 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-snapshot-attribute
   [m3443]
   (clojure.core/let
    [credentials3444 (:credentials m3443) args3445 (:args m3443)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3446
      (com.palletops.awaze.common/aws-client :ec2 credentials3444)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3446
       modifySnapshotAttribute
       (ec2/modify-snapshot-attribute-request
        (clojure.core/nth args3445 0)))))))
  (clojure.core/defn
   modify-snapshot-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         user-ids
                         sdk-request-timeout
                         custom-query-parameters
                         create-volume-permission
                         group-names
                         read-limit
                         general-progress-listener
                         clone-source
                         operation-type
                         clone-root]}]]),
    :doc "Generate map for modifySnapshotAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-snapshot-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-snapshot-attribute
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         user-ids
                         sdk-request-timeout
                         custom-query-parameters
                         create-volume-permission
                         group-names
                         read-limit
                         general-progress-listener
                         clone-source
                         operation-type
                         clone-root]}]]),
    :doc "Call modifySnapshotAttribute"}
   [credentials3448 & args3449]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3450
     (com.palletops.awaze.common/aws-client :ec2 credentials3448)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3450
      modifySnapshotAttribute
      (ec2/modify-snapshot-attribute-request
       (clojure.core/nth args3449 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :request-spot-fleet
   [m3451]
   (clojure.core/let
    [credentials3452 (:credentials m3451) args3453 (:args m3451)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3454
      (com.palletops.awaze.common/aws-client :ec2 credentials3452)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3454
       requestSpotFleet
       (ec2/request-spot-fleet-request (clojure.core/nth args3453 0)))))))
  (clojure.core/defn
   request-spot-fleet-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         spot-fleet-request-config
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for requestSpotFleet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :request-spot-fleet,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   request-spot-fleet
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         spot-fleet-request-config
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call requestSpotFleet"}
   [credentials3456 & args3457]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3458
     (com.palletops.awaze.common/aws-client :ec2 credentials3456)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3458
      requestSpotFleet
      (ec2/request-spot-fleet-request (clojure.core/nth args3457 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :restore-address-to-classic
   [m3459]
   (clojure.core/let
    [credentials3460 (:credentials m3459) args3461 (:args m3459)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3462
      (com.palletops.awaze.common/aws-client :ec2 credentials3460)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3462
       restoreAddressToClassic
       (ec2/restore-address-to-classic-request
        (clojure.core/nth args3461 0)))))))
  (clojure.core/defn
   restore-address-to-classic-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         public-ip]}]]),
    :doc "Generate map for restoreAddressToClassic"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :restore-address-to-classic,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   restore-address-to-classic
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         public-ip]}]]),
    :doc "Call restoreAddressToClassic"}
   [credentials3464 & args3465]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3466
     (com.palletops.awaze.common/aws-client :ec2 credentials3464)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3466
      restoreAddressToClassic
      (ec2/restore-address-to-classic-request
       (clojure.core/nth args3465 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-subnet-attribute
   [m3467]
   (clojure.core/let
    [credentials3468 (:credentials m3467) args3469 (:args m3467)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3470
      (com.palletops.awaze.common/aws-client :ec2 credentials3468)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3470
       modifySubnetAttribute
       (ec2/modify-subnet-attribute-request
        (clojure.core/nth args3469 0)))))))
  (clojure.core/defn
   modify-subnet-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subnet-id
                         sdk-request-timeout
                         custom-query-parameters
                         map-public-ip-on-launch
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for modifySubnetAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-subnet-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-subnet-attribute
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subnet-id
                         sdk-request-timeout
                         custom-query-parameters
                         map-public-ip-on-launch
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call modifySubnetAttribute"}
   [credentials3472 & args3473]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3474
     (com.palletops.awaze.common/aws-client :ec2 credentials3472)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3474
      modifySubnetAttribute
      (ec2/modify-subnet-attribute-request
       (clojure.core/nth args3473 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-conversion-tasks
   [m3475]
   (clojure.core/let
    [credentials3476 (:credentials m3475) args3477 (:args m3475)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3478
      (com.palletops.awaze.common/aws-client :ec2 credentials3476)]
     (clojure.core/case
      (clojure.core/count args3477)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3478
        describeConversionTasks
        (ec2/describe-conversion-tasks-request
         (clojure.core/nth args3477 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3478
        describeConversionTasks))))))
  (clojure.core/defn
   describe-conversion-tasks-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         conversion-task-ids
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeConversionTasks, describeConversionTasks"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-conversion-tasks,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-conversion-tasks,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-conversion-tasks
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         conversion-task-ids
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeConversionTasks, describeConversionTasks"}
   [credentials3480 & args3481]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3482
     (com.palletops.awaze.common/aws-client :ec2 credentials3480)]
    (clojure.core/case
     (clojure.core/count args3481)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3482
       describeConversionTasks
       (ec2/describe-conversion-tasks-request
        (clojure.core/nth args3481 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3482
       describeConversionTasks))))))
 (do
  (clojure.core/defmethod
   ec2
   :authorize-security-group-egress
   [m3483]
   (clojure.core/let
    [credentials3484 (:credentials m3483) args3485 (:args m3483)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3486
      (com.palletops.awaze.common/aws-client :ec2 credentials3484)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3486
       authorizeSecurityGroupEgress
       (ec2/authorize-security-group-egress-request
        (clojure.core/nth args3485 0)))))))
  (clojure.core/defn
   authorize-security-group-egress-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         ip-permissions
                         group-id
                         sdk-request-timeout
                         custom-query-parameters
                         to-port
                         source-security-group-name
                         cidr-ip
                         ip-protocol
                         read-limit
                         general-progress-listener
                         clone-source
                         from-port
                         source-security-group-owner-id
                         clone-root]}]]),
    :doc "Generate map for authorizeSecurityGroupEgress"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :authorize-security-group-egress,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   authorize-security-group-egress
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         ip-permissions
                         group-id
                         sdk-request-timeout
                         custom-query-parameters
                         to-port
                         source-security-group-name
                         cidr-ip
                         ip-protocol
                         read-limit
                         general-progress-listener
                         clone-source
                         from-port
                         source-security-group-owner-id
                         clone-root]}]]),
    :doc "Call authorizeSecurityGroupEgress"}
   [credentials3488 & args3489]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3490
     (com.palletops.awaze.common/aws-client :ec2 credentials3488)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3490
      authorizeSecurityGroupEgress
      (ec2/authorize-security-group-egress-request
       (clojure.core/nth args3489 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :authorize-security-group-ingress
   [m3491]
   (clojure.core/let
    [credentials3492 (:credentials m3491) args3493 (:args m3491)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3494
      (com.palletops.awaze.common/aws-client :ec2 credentials3492)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3494
       authorizeSecurityGroupIngress
       (ec2/authorize-security-group-ingress-request
        (clojure.core/nth args3493 0)))))))
  (clojure.core/defn
   authorize-security-group-ingress-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         ip-permissions
                         group-id
                         sdk-request-timeout
                         custom-query-parameters
                         to-port
                         source-security-group-name
                         cidr-ip
                         ip-protocol
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         from-port
                         source-security-group-owner-id
                         clone-root]}]]),
    :doc "Generate map for authorizeSecurityGroupIngress"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :authorize-security-group-ingress,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   authorize-security-group-ingress
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         ip-permissions
                         group-id
                         sdk-request-timeout
                         custom-query-parameters
                         to-port
                         source-security-group-name
                         cidr-ip
                         ip-protocol
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         from-port
                         source-security-group-owner-id
                         clone-root]}]]),
    :doc "Call authorizeSecurityGroupIngress"}
   [credentials3496 & args3497]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3498
     (com.palletops.awaze.common/aws-client :ec2 credentials3496)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3498
      authorizeSecurityGroupIngress
      (ec2/authorize-security-group-ingress-request
       (clojure.core/nth args3497 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-addresses
   [m3499]
   (clojure.core/let
    [credentials3500 (:credentials m3499) args3501 (:args m3499)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3502
      (com.palletops.awaze.common/aws-client :ec2 credentials3500)]
     (clojure.core/case
      (clojure.core/count args3501)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3502
        describeAddresses
        (ec2/describe-addresses-request (clojure.core/nth args3501 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3502
        describeAddresses))))))
  (clojure.core/defn
   describe-addresses-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         public-ips
                         general-progress-listener
                         allocation-ids
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeAddresses, describeAddresses"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-addresses,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-addresses,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-addresses
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         public-ips
                         general-progress-listener
                         allocation-ids
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeAddresses, describeAddresses"}
   [credentials3504 & args3505]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3506
     (com.palletops.awaze.common/aws-client :ec2 credentials3504)]
    (clojure.core/case
     (clojure.core/count args3505)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3506
       describeAddresses
       (ec2/describe-addresses-request (clojure.core/nth args3505 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3506
       describeAddresses))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-vpn-connection-route
   [m3507]
   (clojure.core/let
    [credentials3508 (:credentials m3507) args3509 (:args m3507)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3510
      (com.palletops.awaze.common/aws-client :ec2 credentials3508)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3510
       createVpnConnectionRoute
       (ec2/create-vpn-connection-route-request
        (clojure.core/nth args3509 0)))))))
  (clojure.core/defn
   create-vpn-connection-route-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         destination-cidr-block
                         sdk-request-timeout
                         vpn-connection-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createVpnConnectionRoute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-vpn-connection-route,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-vpn-connection-route
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         destination-cidr-block
                         sdk-request-timeout
                         vpn-connection-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createVpnConnectionRoute"}
   [credentials3512 & args3513]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3514
     (com.palletops.awaze.common/aws-client :ec2 credentials3512)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3514
      createVpnConnectionRoute
      (ec2/create-vpn-connection-route-request
       (clojure.core/nth args3513 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :associate-address
   [m3515]
   (clojure.core/let
    [credentials3516 (:credentials m3515) args3517 (:args m3515)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3518
      (com.palletops.awaze.common/aws-client :ec2 credentials3516)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3518
       associateAddress
       (ec2/associate-address-request (clojure.core/nth args3517 0)))))))
  (clojure.core/defn
   associate-address-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         allow-reassociation
                         allocation-id
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         instance-id
                         read-limit
                         general-progress-listener
                         private-ip-address
                         clone-source
                         clone-root
                         public-ip]}]]),
    :doc "Generate map for associateAddress"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :associate-address,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   associate-address
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         allow-reassociation
                         allocation-id
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         instance-id
                         read-limit
                         general-progress-listener
                         private-ip-address
                         clone-source
                         clone-root
                         public-ip]}]]),
    :doc "Call associateAddress"}
   [credentials3520 & args3521]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3522
     (com.palletops.awaze.common/aws-client :ec2 credentials3520)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3522
      associateAddress
      (ec2/associate-address-request (clojure.core/nth args3521 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-instance-export-task
   [m3523]
   (clojure.core/let
    [credentials3524 (:credentials m3523) args3525 (:args m3523)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3526
      (com.palletops.awaze.common/aws-client :ec2 credentials3524)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3526
       createInstanceExportTask
       (ec2/create-instance-export-task-request
        (clojure.core/nth args3525 0)))))))
  (clojure.core/defn
   create-instance-export-task-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         target-environment
                         instance-id
                         read-limit
                         general-progress-listener
                         export-to-s3task
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createInstanceExportTask"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-instance-export-task,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-instance-export-task
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         target-environment
                         instance-id
                         read-limit
                         general-progress-listener
                         export-to-s3task
                         clone-source
                         clone-root]}]]),
    :doc "Call createInstanceExportTask"}
   [credentials3528 & args3529]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3530
     (com.palletops.awaze.common/aws-client :ec2 credentials3528)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3530
      createInstanceExportTask
      (ec2/create-instance-export-task-request
       (clojure.core/nth args3529 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-key-pairs
   [m3531]
   (clojure.core/let
    [credentials3532 (:credentials m3531) args3533 (:args m3531)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3534
      (com.palletops.awaze.common/aws-client :ec2 credentials3532)]
     (clojure.core/case
      (clojure.core/count args3533)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3534
        describeKeyPairs
        (ec2/describe-key-pairs-request (clojure.core/nth args3533 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3534
        describeKeyPairs))))))
  (clojure.core/defn
   describe-key-pairs-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key-names
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeKeyPairs, describeKeyPairs"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-key-pairs,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-key-pairs,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-key-pairs
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key-names
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeKeyPairs, describeKeyPairs"}
   [credentials3536 & args3537]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3538
     (com.palletops.awaze.common/aws-client :ec2 credentials3536)]
    (clojure.core/case
     (clojure.core/count args3537)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3538
       describeKeyPairs
       (ec2/describe-key-pairs-request (clojure.core/nth args3537 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3538
       describeKeyPairs))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-spot-fleet-requests
   [m3539]
   (clojure.core/let
    [credentials3540 (:credentials m3539) args3541 (:args m3539)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3542
      (com.palletops.awaze.common/aws-client :ec2 credentials3540)]
     (clojure.core/case
      (clojure.core/count args3541)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3542
        describeSpotFleetRequests))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3542
        describeSpotFleetRequests
        (ec2/describe-spot-fleet-requests-request
         (clojure.core/nth args3541 0))))))))
  (clojure.core/defn
   describe-spot-fleet-requests-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         spot-fleet-request-ids
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeSpotFleetRequests, describeSpotFleetRequests"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-spot-fleet-requests,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-spot-fleet-requests,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-spot-fleet-requests
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         spot-fleet-request-ids
                         clone-root
                         next-token]}]]),
    :doc "Call describeSpotFleetRequests, describeSpotFleetRequests"}
   [credentials3544 & args3545]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3546
     (com.palletops.awaze.common/aws-client :ec2 credentials3544)]
    (clojure.core/case
     (clojure.core/count args3545)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3546
       describeSpotFleetRequests))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3546
       describeSpotFleetRequests
       (ec2/describe-spot-fleet-requests-request
        (clojure.core/nth args3545 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-image-attribute
   [m3547]
   (clojure.core/let
    [credentials3548 (:credentials m3547) args3549 (:args m3547)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3550
      (com.palletops.awaze.common/aws-client :ec2 credentials3548)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3550
       describeImageAttribute
       (ec2/describe-image-attribute-request
        (clojure.core/nth args3549 0)))))))
  (clojure.core/defn
   describe-image-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         image-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeImageAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-image-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-image-attribute
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         image-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeImageAttribute"}
   [credentials3552 & args3553]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3554
     (com.palletops.awaze.common/aws-client :ec2 credentials3552)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3554
      describeImageAttribute
      (ec2/describe-image-attribute-request
       (clojure.core/nth args3553 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-moving-addresses
   [m3555]
   (clojure.core/let
    [credentials3556 (:credentials m3555) args3557 (:args m3555)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3558
      (com.palletops.awaze.common/aws-client :ec2 credentials3556)]
     (clojure.core/case
      (clojure.core/count args3557)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3558
        describeMovingAddresses
        (ec2/describe-moving-addresses-request
         (clojure.core/nth args3557 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3558
        describeMovingAddresses))))))
  (clojure.core/defn
   describe-moving-addresses-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         public-ips
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeMovingAddresses, describeMovingAddresses"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-moving-addresses,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-moving-addresses,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-moving-addresses
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         public-ips
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call describeMovingAddresses, describeMovingAddresses"}
   [credentials3560 & args3561]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3562
     (com.palletops.awaze.common/aws-client :ec2 credentials3560)]
    (clojure.core/case
     (clojure.core/count args3561)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3562
       describeMovingAddresses
       (ec2/describe-moving-addresses-request
        (clojure.core/nth args3561 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3562
       describeMovingAddresses))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-network-acl
   [m3563]
   (clojure.core/let
    [credentials3564 (:credentials m3563) args3565 (:args m3563)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3566
      (com.palletops.awaze.common/aws-client :ec2 credentials3564)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3566
       deleteNetworkAcl
       (ec2/delete-network-acl-request (clojure.core/nth args3565 0)))))))
  (clojure.core/defn
   delete-network-acl-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         network-acl-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteNetworkAcl"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-network-acl,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-network-acl
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         network-acl-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteNetworkAcl"}
   [credentials3568 & args3569]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3570
     (com.palletops.awaze.common/aws-client :ec2 credentials3568)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3570
      deleteNetworkAcl
      (ec2/delete-network-acl-request (clojure.core/nth args3569 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-network-interface
   [m3571]
   (clojure.core/let
    [credentials3572 (:credentials m3571) args3573 (:args m3571)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3574
      (com.palletops.awaze.common/aws-client :ec2 credentials3572)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3574
       deleteNetworkInterface
       (ec2/delete-network-interface-request
        (clojure.core/nth args3573 0)))))))
  (clojure.core/defn
   delete-network-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteNetworkInterface"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-network-interface,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-network-interface
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteNetworkInterface"}
   [credentials3576 & args3577]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3578
     (com.palletops.awaze.common/aws-client :ec2 credentials3576)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3578
      deleteNetworkInterface
      (ec2/delete-network-interface-request
       (clojure.core/nth args3577 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-vpn-connection
   [m3579]
   (clojure.core/let
    [credentials3580 (:credentials m3579) args3581 (:args m3579)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3582
      (com.palletops.awaze.common/aws-client :ec2 credentials3580)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3582
       deleteVpnConnection
       (ec2/delete-vpn-connection-request
        (clojure.core/nth args3581 0)))))))
  (clojure.core/defn
   delete-vpn-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vpn-connection-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteVpnConnection"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-vpn-connection,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-vpn-connection
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vpn-connection-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteVpnConnection"}
   [credentials3584 & args3585]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3586
     (com.palletops.awaze.common/aws-client :ec2 credentials3584)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3586
      deleteVpnConnection
      (ec2/delete-vpn-connection-request
       (clojure.core/nth args3585 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :purchase-scheduled-instances
   [m3587]
   (clojure.core/let
    [credentials3588 (:credentials m3587) args3589 (:args m3587)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3590
      (com.palletops.awaze.common/aws-client :ec2 credentials3588)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3590
       purchaseScheduledInstances
       (ec2/purchase-scheduled-instances-request
        (clojure.core/nth args3589 0)))))))
  (clojure.core/defn
   purchase-scheduled-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         purchase-requests
                         read-limit
                         general-progress-listener
                         clone-source
                         client-token
                         clone-root]}]]),
    :doc "Generate map for purchaseScheduledInstances"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :purchase-scheduled-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   purchase-scheduled-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         purchase-requests
                         read-limit
                         general-progress-listener
                         clone-source
                         client-token
                         clone-root]}]]),
    :doc "Call purchaseScheduledInstances"}
   [credentials3592 & args3593]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3594
     (com.palletops.awaze.common/aws-client :ec2 credentials3592)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3594
      purchaseScheduledInstances
      (ec2/purchase-scheduled-instances-request
       (clojure.core/nth args3593 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-reserved-instances-modifications
   [m3595]
   (clojure.core/let
    [credentials3596 (:credentials m3595) args3597 (:args m3595)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3598
      (com.palletops.awaze.common/aws-client :ec2 credentials3596)]
     (clojure.core/case
      (clojure.core/count args3597)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3598
        describeReservedInstancesModifications))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3598
        describeReservedInstancesModifications
        (ec2/describe-reserved-instances-modifications-request
         (clojure.core/nth args3597 0))))))))
  (clojure.core/defn
   describe-reserved-instances-modifications-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         reserved-instances-modification-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeReservedInstancesModifications, describeReservedInstancesModifications"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-reserved-instances-modifications,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-reserved-instances-modifications,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-reserved-instances-modifications
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         reserved-instances-modification-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeReservedInstancesModifications, describeReservedInstancesModifications"}
   [credentials3600 & args3601]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3602
     (com.palletops.awaze.common/aws-client :ec2 credentials3600)]
    (clojure.core/case
     (clojure.core/count args3601)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3602
       describeReservedInstancesModifications))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3602
       describeReservedInstancesModifications
       (ec2/describe-reserved-instances-modifications-request
        (clojure.core/nth args3601 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-classic-link-instances
   [m3603]
   (clojure.core/let
    [credentials3604 (:credentials m3603) args3605 (:args m3603)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3606
      (com.palletops.awaze.common/aws-client :ec2 credentials3604)]
     (clojure.core/case
      (clojure.core/count args3605)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3606
        describeClassicLinkInstances))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3606
        describeClassicLinkInstances
        (ec2/describe-classic-link-instances-request
         (clojure.core/nth args3605 0))))))))
  (clojure.core/defn
   describe-classic-link-instances-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeClassicLinkInstances, describeClassicLinkInstances"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-classic-link-instances,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-classic-link-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-classic-link-instances
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeClassicLinkInstances, describeClassicLinkInstances"}
   [credentials3608 & args3609]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3610
     (com.palletops.awaze.common/aws-client :ec2 credentials3608)]
    (clojure.core/case
     (clojure.core/count args3609)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3610
       describeClassicLinkInstances))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3610
       describeClassicLinkInstances
       (ec2/describe-classic-link-instances-request
        (clojure.core/nth args3609 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :purchase-reserved-instances-offering
   [m3611]
   (clojure.core/let
    [credentials3612 (:credentials m3611) args3613 (:args m3611)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3614
      (com.palletops.awaze.common/aws-client :ec2 credentials3612)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3614
       purchaseReservedInstancesOffering
       (ec2/purchase-reserved-instances-offering-request
        (clojure.core/nth args3613 0)))))))
  (clojure.core/defn
   purchase-reserved-instances-offering-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         limit-price
                         custom-query-parameters
                         reserved-instances-offering-id
                         instance-count
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for purchaseReservedInstancesOffering"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :purchase-reserved-instances-offering,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   purchase-reserved-instances-offering
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         limit-price
                         custom-query-parameters
                         reserved-instances-offering-id
                         instance-count
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call purchaseReservedInstancesOffering"}
   [credentials3616 & args3617]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3618
     (com.palletops.awaze.common/aws-client :ec2 credentials3616)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3618
      purchaseReservedInstancesOffering
      (ec2/purchase-reserved-instances-offering-request
       (clojure.core/nth args3617 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :start-instances
   [m3619]
   (clojure.core/let
    [credentials3620 (:credentials m3619) args3621 (:args m3619)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3622
      (com.palletops.awaze.common/aws-client :ec2 credentials3620)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3622
       startInstances
       (ec2/start-instances-request (clojure.core/nth args3621 0)))))))
  (clojure.core/defn
   start-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         additional-info
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for startInstances"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :start-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   start-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         additional-info
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call startInstances"}
   [credentials3624 & args3625]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3626
     (com.palletops.awaze.common/aws-client :ec2 credentials3624)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3626
      startInstances
      (ec2/start-instances-request (clojure.core/nth args3625 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-instance-attribute
   [m3627]
   (clojure.core/let
    [credentials3628 (:credentials m3627) args3629 (:args m3627)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3630
      (com.palletops.awaze.common/aws-client :ec2 credentials3628)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3630
       describeInstanceAttribute
       (ec2/describe-instance-attribute-request
        (clojure.core/nth args3629 0)))))))
  (clojure.core/defn
   describe-instance-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeInstanceAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-instance-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-instance-attribute
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeInstanceAttribute"}
   [credentials3632 & args3633]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3634
     (com.palletops.awaze.common/aws-client :ec2 credentials3632)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3634
      describeInstanceAttribute
      (ec2/describe-instance-attribute-request
       (clojure.core/nth args3633 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :cancel-spot-fleet-requests
   [m3635]
   (clojure.core/let
    [credentials3636 (:credentials m3635) args3637 (:args m3635)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3638
      (com.palletops.awaze.common/aws-client :ec2 credentials3636)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3638
       cancelSpotFleetRequests
       (ec2/cancel-spot-fleet-requests-request
        (clojure.core/nth args3637 0)))))))
  (clojure.core/defn
   cancel-spot-fleet-requests-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         terminate-instances
                         clone-source
                         spot-fleet-request-ids
                         clone-root]}]]),
    :doc "Generate map for cancelSpotFleetRequests"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :cancel-spot-fleet-requests,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   cancel-spot-fleet-requests
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         terminate-instances
                         clone-source
                         spot-fleet-request-ids
                         clone-root]}]]),
    :doc "Call cancelSpotFleetRequests"}
   [credentials3640 & args3641]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3642
     (com.palletops.awaze.common/aws-client :ec2 credentials3640)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3642
      cancelSpotFleetRequests
      (ec2/cancel-spot-fleet-requests-request
       (clojure.core/nth args3641 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-subnets
   [m3643]
   (clojure.core/let
    [credentials3644 (:credentials m3643) args3645 (:args m3643)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3646
      (com.palletops.awaze.common/aws-client :ec2 credentials3644)]
     (clojure.core/case
      (clojure.core/count args3645)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3646
        describeSubnets
        (ec2/describe-subnets-request (clojure.core/nth args3645 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3646
        describeSubnets))))))
  (clojure.core/defn
   describe-subnets-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         subnet-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeSubnets, describeSubnets"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-subnets,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-subnets,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-subnets
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         subnet-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeSubnets, describeSubnets"}
   [credentials3648 & args3649]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3650
     (com.palletops.awaze.common/aws-client :ec2 credentials3648)]
    (clojure.core/case
     (clojure.core/count args3649)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3650
       describeSubnets
       (ec2/describe-subnets-request (clojure.core/nth args3649 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3650
       describeSubnets))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-volume
   [m3651]
   (clojure.core/let
    [credentials3652 (:credentials m3651) args3653 (:args m3651)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3654
      (com.palletops.awaze.common/aws-client :ec2 credentials3652)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3654
       createVolume
       (ec2/create-volume-request (clojure.core/nth args3653 0)))))))
  (clojure.core/defn
   create-volume-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         sdk-request-timeout
                         volume-type
                         custom-query-parameters
                         iops
                         availability-zone
                         size
                         read-limit
                         general-progress-listener
                         kms-key-id
                         clone-source
                         encrypted
                         clone-root]}]]),
    :doc "Generate map for createVolume"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-volume,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-volume
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         sdk-request-timeout
                         volume-type
                         custom-query-parameters
                         iops
                         availability-zone
                         size
                         read-limit
                         general-progress-listener
                         kms-key-id
                         clone-source
                         encrypted
                         clone-root]}]]),
    :doc "Call createVolume"}
   [credentials3656 & args3657]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3658
     (com.palletops.awaze.common/aws-client :ec2 credentials3656)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3658
      createVolume
      (ec2/create-volume-request (clojure.core/nth args3657 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-reserved-instances-listings
   [m3659]
   (clojure.core/let
    [credentials3660 (:credentials m3659) args3661 (:args m3659)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3662
      (com.palletops.awaze.common/aws-client :ec2 credentials3660)]
     (clojure.core/case
      (clojure.core/count args3661)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3662
        describeReservedInstancesListings))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3662
        describeReservedInstancesListings
        (ec2/describe-reserved-instances-listings-request
         (clojure.core/nth args3661 0))))))))
  (clojure.core/defn
   describe-reserved-instances-listings-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [reserved-instances-listing-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         reserved-instances-id
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeReservedInstancesListings, describeReservedInstancesListings"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-reserved-instances-listings,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-reserved-instances-listings,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-reserved-instances-listings
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [reserved-instances-listing-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         reserved-instances-id
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeReservedInstancesListings, describeReservedInstancesListings"}
   [credentials3664 & args3665]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3666
     (com.palletops.awaze.common/aws-client :ec2 credentials3664)]
    (clojure.core/case
     (clojure.core/count args3665)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3666
       describeReservedInstancesListings))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3666
       describeReservedInstancesListings
       (ec2/describe-reserved-instances-listings-request
        (clojure.core/nth args3665 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-dhcp-options
   [m3667]
   (clojure.core/let
    [credentials3668 (:credentials m3667) args3669 (:args m3667)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3670
      (com.palletops.awaze.common/aws-client :ec2 credentials3668)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3670
       createDhcpOptions
       (ec2/create-dhcp-options-request (clojure.core/nth args3669 0)))))))
  (clojure.core/defn
   create-dhcp-options-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         dhcp-configurations
                         clone-root]}]]),
    :doc "Generate map for createDhcpOptions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-dhcp-options,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-dhcp-options
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         dhcp-configurations
                         clone-root]}]]),
    :doc "Call createDhcpOptions"}
   [credentials3672 & args3673]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3674
     (com.palletops.awaze.common/aws-client :ec2 credentials3672)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3674
      createDhcpOptions
      (ec2/create-dhcp-options-request (clojure.core/nth args3673 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :detach-internet-gateway
   [m3675]
   (clojure.core/let
    [credentials3676 (:credentials m3675) args3677 (:args m3675)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3678
      (com.palletops.awaze.common/aws-client :ec2 credentials3676)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3678
       detachInternetGateway
       (ec2/detach-internet-gateway-request
        (clojure.core/nth args3677 0)))))))
  (clojure.core/defn
   detach-internet-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         internet-gateway-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for detachInternetGateway"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :detach-internet-gateway,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   detach-internet-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         internet-gateway-id
                         clone-source
                         clone-root]}]]),
    :doc "Call detachInternetGateway"}
   [credentials3680 & args3681]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3682
     (com.palletops.awaze.common/aws-client :ec2 credentials3680)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3682
      detachInternetGateway
      (ec2/detach-internet-gateway-request
       (clojure.core/nth args3681 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-vpn-gateway
   [m3683]
   (clojure.core/let
    [credentials3684 (:credentials m3683) args3685 (:args m3683)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3686
      (com.palletops.awaze.common/aws-client :ec2 credentials3684)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3686
       deleteVpnGateway
       (ec2/delete-vpn-gateway-request (clojure.core/nth args3685 0)))))))
  (clojure.core/defn
   delete-vpn-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         vpn-gateway-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteVpnGateway"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-vpn-gateway,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-vpn-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         vpn-gateway-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteVpnGateway"}
   [credentials3688 & args3689]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3690
     (com.palletops.awaze.common/aws-client :ec2 credentials3688)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3690
      deleteVpnGateway
      (ec2/delete-vpn-gateway-request (clojure.core/nth args3689 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :request-spot-instances
   [m3691]
   (clojure.core/let
    [credentials3692 (:credentials m3691) args3693 (:args m3691)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3694
      (com.palletops.awaze.common/aws-client :ec2 credentials3692)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3694
       requestSpotInstances
       (ec2/request-spot-instances-request
        (clojure.core/nth args3693 0)))))))
  (clojure.core/defn
   request-spot-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         valid-from
                         launch-group
                         spot-price
                         type
                         custom-query-parameters
                         availability-zone-group
                         instance-count
                         read-limit
                         block-duration-minutes
                         general-progress-listener
                         valid-until
                         clone-source
                         launch-specification
                         client-token
                         clone-root]}]]),
    :doc "Generate map for requestSpotInstances"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :request-spot-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   request-spot-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         valid-from
                         launch-group
                         spot-price
                         type
                         custom-query-parameters
                         availability-zone-group
                         instance-count
                         read-limit
                         block-duration-minutes
                         general-progress-listener
                         valid-until
                         clone-source
                         launch-specification
                         client-token
                         clone-root]}]]),
    :doc "Call requestSpotInstances"}
   [credentials3696 & args3697]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3698
     (com.palletops.awaze.common/aws-client :ec2 credentials3696)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3698
      requestSpotInstances
      (ec2/request-spot-instances-request
       (clojure.core/nth args3697 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :import-volume
   [m3699]
   (clojure.core/let
    [credentials3700 (:credentials m3699) args3701 (:args m3699)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3702
      (com.palletops.awaze.common/aws-client :ec2 credentials3700)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3702
       importVolume
       (ec2/import-volume-request (clojure.core/nth args3701 0)))))))
  (clojure.core/defn
   import-volume-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         availability-zone
                         volume
                         read-limit
                         general-progress-listener
                         image
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for importVolume"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :import-volume,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   import-volume
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         availability-zone
                         volume
                         read-limit
                         general-progress-listener
                         image
                         clone-source
                         clone-root]}]]),
    :doc "Call importVolume"}
   [credentials3704 & args3705]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3706
     (com.palletops.awaze.common/aws-client :ec2 credentials3704)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3706
      importVolume
      (ec2/import-volume-request (clojure.core/nth args3705 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :import-snapshot
   [m3707]
   (clojure.core/let
    [credentials3708 (:credentials m3707) args3709 (:args m3707)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3710
      (com.palletops.awaze.common/aws-client :ec2 credentials3708)]
     (clojure.core/case
      (clojure.core/count args3709)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3710
        importSnapshot))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3710
        importSnapshot
        (ec2/import-snapshot-request (clojure.core/nth args3709 0))))))))
  (clojure.core/defn
   import-snapshot-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         disk-container
                         client-token
                         clone-root
                         client-data]}]]),
    :doc "Generate map for importSnapshot, importSnapshot"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :import-snapshot,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :import-snapshot,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   import-snapshot
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         disk-container
                         client-token
                         clone-root
                         client-data]}]]),
    :doc "Call importSnapshot, importSnapshot"}
   [credentials3712 & args3713]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3714
     (com.palletops.awaze.common/aws-client :ec2 credentials3712)]
    (clojure.core/case
     (clojure.core/count args3713)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3714
       importSnapshot))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3714
       importSnapshot
       (ec2/import-snapshot-request (clojure.core/nth args3713 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-tags
   [m3715]
   (clojure.core/let
    [credentials3716 (:credentials m3715) args3717 (:args m3715)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3718
      (com.palletops.awaze.common/aws-client :ec2 credentials3716)]
     (clojure.core/case
      (clojure.core/count args3717)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3718
        describeTags
        (ec2/describe-tags-request (clojure.core/nth args3717 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3718
        describeTags))))))
  (clojure.core/defn
   describe-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeTags, describeTags"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-tags,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-tags,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-tags
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call describeTags, describeTags"}
   [credentials3720 & args3721]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3722
     (com.palletops.awaze.common/aws-client :ec2 credentials3720)]
    (clojure.core/case
     (clojure.core/count args3721)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3722
       describeTags
       (ec2/describe-tags-request (clojure.core/nth args3721 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3722
       describeTags))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-tags
   [m3723]
   (clojure.core/let
    [credentials3724 (:credentials m3723) args3725 (:args m3723)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3726
      (com.palletops.awaze.common/aws-client :ec2 credentials3724)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3726
       deleteTags
       (ec2/delete-tags-request (clojure.core/nth args3725 0)))))))
  (clojure.core/defn
   delete-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         resources
                         clone-root]}]]),
    :doc "Generate map for deleteTags"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-tags,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-tags
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         resources
                         clone-root]}]]),
    :doc "Call deleteTags"}
   [credentials3728 & args3729]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3730
     (com.palletops.awaze.common/aws-client :ec2 credentials3728)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3730
      deleteTags
      (ec2/delete-tags-request (clojure.core/nth args3729 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :enable-vpc-classic-link
   [m3731]
   (clojure.core/let
    [credentials3732 (:credentials m3731) args3733 (:args m3731)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3734
      (com.palletops.awaze.common/aws-client :ec2 credentials3732)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3734
       enableVpcClassicLink
       (ec2/enable-vpc-classic-link-request
        (clojure.core/nth args3733 0)))))))
  (clojure.core/defn
   enable-vpc-classic-link-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for enableVpcClassicLink"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :enable-vpc-classic-link,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   enable-vpc-classic-link
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call enableVpcClassicLink"}
   [credentials3736 & args3737]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3738
     (com.palletops.awaze.common/aws-client :ec2 credentials3736)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3738
      enableVpcClassicLink
      (ec2/enable-vpc-classic-link-request
       (clojure.core/nth args3737 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-reserved-instances-offerings
   [m3739]
   (clojure.core/let
    [credentials3740 (:credentials m3739) args3741 (:args m3739)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3742
      (com.palletops.awaze.common/aws-client :ec2 credentials3740)]
     (clojure.core/case
      (clojure.core/count args3741)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3742
        describeReservedInstancesOfferings))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3742
        describeReservedInstancesOfferings
        (ec2/describe-reserved-instances-offerings-request
         (clojure.core/nth args3741 0))))))))
  (clojure.core/defn
   describe-reserved-instances-offerings-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         offering-type
                         filters
                         sdk-request-timeout
                         include-marketplace
                         instance-type
                         max-results
                         custom-query-parameters
                         availability-zone
                         max-instance-count
                         max-duration
                         min-duration
                         read-limit
                         product-description
                         general-progress-listener
                         clone-source
                         reserved-instances-offering-ids
                         clone-root
                         instance-tenancy
                         next-token]}]]),
    :doc "Generate map for describeReservedInstancesOfferings, describeReservedInstancesOfferings"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-reserved-instances-offerings,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-reserved-instances-offerings,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-reserved-instances-offerings
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         offering-type
                         filters
                         sdk-request-timeout
                         include-marketplace
                         instance-type
                         max-results
                         custom-query-parameters
                         availability-zone
                         max-instance-count
                         max-duration
                         min-duration
                         read-limit
                         product-description
                         general-progress-listener
                         clone-source
                         reserved-instances-offering-ids
                         clone-root
                         instance-tenancy
                         next-token]}]]),
    :doc "Call describeReservedInstancesOfferings, describeReservedInstancesOfferings"}
   [credentials3744 & args3745]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3746
     (com.palletops.awaze.common/aws-client :ec2 credentials3744)]
    (clojure.core/case
     (clojure.core/count args3745)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3746
       describeReservedInstancesOfferings))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3746
       describeReservedInstancesOfferings
       (ec2/describe-reserved-instances-offerings-request
        (clojure.core/nth args3745 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-vpn-gateway
   [m3747]
   (clojure.core/let
    [credentials3748 (:credentials m3747) args3749 (:args m3747)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3750
      (com.palletops.awaze.common/aws-client :ec2 credentials3748)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3750
       createVpnGateway
       (ec2/create-vpn-gateway-request (clojure.core/nth args3749 0)))))))
  (clojure.core/defn
   create-vpn-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         type
                         custom-query-parameters
                         availability-zone
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createVpnGateway"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-vpn-gateway,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-vpn-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         type
                         custom-query-parameters
                         availability-zone
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createVpnGateway"}
   [credentials3752 & args3753]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3754
     (com.palletops.awaze.common/aws-client :ec2 credentials3752)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3754
      createVpnGateway
      (ec2/create-vpn-gateway-request (clojure.core/nth args3753 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-route-tables
   [m3755]
   (clojure.core/let
    [credentials3756 (:credentials m3755) args3757 (:args m3755)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3758
      (com.palletops.awaze.common/aws-client :ec2 credentials3756)]
     (clojure.core/case
      (clojure.core/count args3757)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3758
        describeRouteTables))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3758
        describeRouteTables
        (ec2/describe-route-tables-request
         (clojure.core/nth args3757 0))))))))
  (clojure.core/defn
   describe-route-tables-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         route-table-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeRouteTables, describeRouteTables"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-route-tables,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-route-tables,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-route-tables
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         route-table-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeRouteTables, describeRouteTables"}
   [credentials3760 & args3761]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3762
     (com.palletops.awaze.common/aws-client :ec2 credentials3760)]
    (clojure.core/case
     (clojure.core/count args3761)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3762
       describeRouteTables))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3762
       describeRouteTables
       (ec2/describe-route-tables-request
        (clojure.core/nth args3761 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :cancel-spot-instance-requests
   [m3763]
   (clojure.core/let
    [credentials3764 (:credentials m3763) args3765 (:args m3763)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3766
      (com.palletops.awaze.common/aws-client :ec2 credentials3764)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3766
       cancelSpotInstanceRequests
       (ec2/cancel-spot-instance-requests-request
        (clojure.core/nth args3765 0)))))))
  (clojure.core/defn
   cancel-spot-instance-requests-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         spot-instance-request-ids
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for cancelSpotInstanceRequests"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :cancel-spot-instance-requests,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   cancel-spot-instance-requests
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         spot-instance-request-ids
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call cancelSpotInstanceRequests"}
   [credentials3768 & args3769]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3770
     (com.palletops.awaze.common/aws-client :ec2 credentials3768)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3770
      cancelSpotInstanceRequests
      (ec2/cancel-spot-instance-requests-request
       (clojure.core/nth args3769 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :assign-private-ip-addresses
   [m3771]
   (clojure.core/let
    [credentials3772 (:credentials m3771) args3773 (:args m3771)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3774
      (com.palletops.awaze.common/aws-client :ec2 credentials3772)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3774
       assignPrivateIpAddresses
       (ec2/assign-private-ip-addresses-request
        (clojure.core/nth args3773 0)))))))
  (clojure.core/defn
   assign-private-ip-addresses-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         private-ip-addresses
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         allow-reassignment
                         secondary-private-ip-address-count]}]]),
    :doc "Generate map for assignPrivateIpAddresses"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :assign-private-ip-addresses,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   assign-private-ip-addresses
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         private-ip-addresses
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         allow-reassignment
                         secondary-private-ip-address-count]}]]),
    :doc "Call assignPrivateIpAddresses"}
   [credentials3776 & args3777]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3778
     (com.palletops.awaze.common/aws-client :ec2 credentials3776)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3778
      assignPrivateIpAddresses
      (ec2/assign-private-ip-addresses-request
       (clojure.core/nth args3777 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :disable-vpc-classic-link-dns-support
   [m3779]
   (clojure.core/let
    [credentials3780 (:credentials m3779) args3781 (:args m3779)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3782
      (com.palletops.awaze.common/aws-client :ec2 credentials3780)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3782
       disableVpcClassicLinkDnsSupport
       (ec2/disable-vpc-classic-link-dns-support-request
        (clojure.core/nth args3781 0)))))))
  (clojure.core/defn
   disable-vpc-classic-link-dns-support-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for disableVpcClassicLinkDnsSupport"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :disable-vpc-classic-link-dns-support,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   disable-vpc-classic-link-dns-support
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call disableVpcClassicLinkDnsSupport"}
   [credentials3784 & args3785]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3786
     (com.palletops.awaze.common/aws-client :ec2 credentials3784)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3786
      disableVpcClassicLinkDnsSupport
      (ec2/disable-vpc-classic-link-dns-support-request
       (clojure.core/nth args3785 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-placement-group
   [m3787]
   (clojure.core/let
    [credentials3788 (:credentials m3787) args3789 (:args m3787)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3790
      (com.palletops.awaze.common/aws-client :ec2 credentials3788)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3790
       deletePlacementGroup
       (ec2/delete-placement-group-request
        (clojure.core/nth args3789 0)))))))
  (clojure.core/defn
   delete-placement-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deletePlacementGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-placement-group,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-placement-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deletePlacementGroup"}
   [credentials3792 & args3793]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3794
     (com.palletops.awaze.common/aws-client :ec2 credentials3792)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3794
      deletePlacementGroup
      (ec2/delete-placement-group-request
       (clojure.core/nth args3793 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-instances
   [m3795]
   (clojure.core/let
    [credentials3796 (:credentials m3795) args3797 (:args m3795)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3798
      (com.palletops.awaze.common/aws-client :ec2 credentials3796)]
     (clojure.core/case
      (clojure.core/count args3797)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3798
        describeInstances
        (ec2/describe-instances-request (clojure.core/nth args3797 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3798
        describeInstances))))))
  (clojure.core/defn
   describe-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeInstances, describeInstances"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-instances,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call describeInstances, describeInstances"}
   [credentials3800 & args3801]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3802
     (com.palletops.awaze.common/aws-client :ec2 credentials3800)]
    (clojure.core/case
     (clojure.core/count args3801)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3802
       describeInstances
       (ec2/describe-instances-request (clojure.core/nth args3801 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3802
       describeInstances))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-volumes
   [m3803]
   (clojure.core/let
    [credentials3804 (:credentials m3803) args3805 (:args m3803)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3806
      (com.palletops.awaze.common/aws-client :ec2 credentials3804)]
     (clojure.core/case
      (clojure.core/count args3805)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3806
        describeVolumes))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3806
        describeVolumes
        (ec2/describe-volumes-request (clojure.core/nth args3805 0))))))))
  (clojure.core/defn
   describe-volumes-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         volume-ids
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeVolumes, describeVolumes"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-volumes,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-volumes,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-volumes
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         volume-ids
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeVolumes, describeVolumes"}
   [credentials3808 & args3809]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3810
     (com.palletops.awaze.common/aws-client :ec2 credentials3808)]
    (clojure.core/case
     (clojure.core/count args3809)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3810
       describeVolumes))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3810
       describeVolumes
       (ec2/describe-volumes-request (clojure.core/nth args3809 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-bundle-tasks
   [m3811]
   (clojure.core/let
    [credentials3812 (:credentials m3811) args3813 (:args m3811)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3814
      (com.palletops.awaze.common/aws-client :ec2 credentials3812)]
     (clojure.core/case
      (clojure.core/count args3813)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3814
        describeBundleTasks
        (ec2/describe-bundle-tasks-request
         (clojure.core/nth args3813 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3814
        describeBundleTasks))))))
  (clojure.core/defn
   describe-bundle-tasks-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         bundle-ids]}]
                [credentials]]),
    :doc "Generate map for describeBundleTasks, describeBundleTasks"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-bundle-tasks,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-bundle-tasks,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-bundle-tasks
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         bundle-ids]}]
                [credentials]]),
    :doc "Call describeBundleTasks, describeBundleTasks"}
   [credentials3816 & args3817]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3818
     (com.palletops.awaze.common/aws-client :ec2 credentials3816)]
    (clojure.core/case
     (clojure.core/count args3817)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3818
       describeBundleTasks
       (ec2/describe-bundle-tasks-request
        (clojure.core/nth args3817 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3818
       describeBundleTasks))))))
 (do
  (clojure.core/defmethod
   ec2
   :associate-dhcp-options
   [m3819]
   (clojure.core/let
    [credentials3820 (:credentials m3819) args3821 (:args m3819)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3822
      (com.palletops.awaze.common/aws-client :ec2 credentials3820)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3822
       associateDhcpOptions
       (ec2/associate-dhcp-options-request
        (clojure.core/nth args3821 0)))))))
  (clojure.core/defn
   associate-dhcp-options-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         dhcp-options-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for associateDhcpOptions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :associate-dhcp-options,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   associate-dhcp-options
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         dhcp-options-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call associateDhcpOptions"}
   [credentials3824 & args3825]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3826
     (com.palletops.awaze.common/aws-client :ec2 credentials3824)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3826
      associateDhcpOptions
      (ec2/associate-dhcp-options-request
       (clojure.core/nth args3825 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-vpc-attribute
   [m3827]
   (clojure.core/let
    [credentials3828 (:credentials m3827) args3829 (:args m3827)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3830
      (com.palletops.awaze.common/aws-client :ec2 credentials3828)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3830
       modifyVpcAttribute
       (ec2/modify-vpc-attribute-request
        (clojure.core/nth args3829 0)))))))
  (clojure.core/defn
   modify-vpc-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         enable-dns-support
                         custom-query-parameters
                         vpc-id
                         read-limit
                         enable-dns-hostnames
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for modifyVpcAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-vpc-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-vpc-attribute
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         enable-dns-support
                         custom-query-parameters
                         vpc-id
                         read-limit
                         enable-dns-hostnames
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call modifyVpcAttribute"}
   [credentials3832 & args3833]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3834
     (com.palletops.awaze.common/aws-client :ec2 credentials3832)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3834
      modifyVpcAttribute
      (ec2/modify-vpc-attribute-request (clojure.core/nth args3833 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-flow-logs
   [m3835]
   (clojure.core/let
    [credentials3836 (:credentials m3835) args3837 (:args m3835)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3838
      (com.palletops.awaze.common/aws-client :ec2 credentials3836)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3838
       createFlowLogs
       (ec2/create-flow-logs-request (clojure.core/nth args3837 0)))))))
  (clojure.core/defn
   create-flow-logs-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         resource-ids
                         traffic-type
                         sdk-request-timeout
                         custom-query-parameters
                         log-group-name
                         deliver-logs-permission-arn
                         read-limit
                         general-progress-listener
                         resource-type
                         clone-source
                         client-token
                         clone-root]}]]),
    :doc "Generate map for createFlowLogs"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-flow-logs,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-flow-logs
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         resource-ids
                         traffic-type
                         sdk-request-timeout
                         custom-query-parameters
                         log-group-name
                         deliver-logs-permission-arn
                         read-limit
                         general-progress-listener
                         resource-type
                         clone-source
                         client-token
                         clone-root]}]]),
    :doc "Call createFlowLogs"}
   [credentials3840 & args3841]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3842
     (com.palletops.awaze.common/aws-client :ec2 credentials3840)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3842
      createFlowLogs
      (ec2/create-flow-logs-request (clojure.core/nth args3841 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :disassociate-address
   [m3843]
   (clojure.core/let
    [credentials3844 (:credentials m3843) args3845 (:args m3843)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3846
      (com.palletops.awaze.common/aws-client :ec2 credentials3844)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3846
       disassociateAddress
       (ec2/disassociate-address-request
        (clojure.core/nth args3845 0)))))))
  (clojure.core/defn
   disassociate-address-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         association-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         public-ip]}]]),
    :doc "Generate map for disassociateAddress"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :disassociate-address,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   disassociate-address
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         association-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         public-ip]}]]),
    :doc "Call disassociateAddress"}
   [credentials3848 & args3849]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3850
     (com.palletops.awaze.common/aws-client :ec2 credentials3848)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3850
      disassociateAddress
      (ec2/disassociate-address-request (clojure.core/nth args3849 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :reset-network-interface-attribute
   [m3851]
   (clojure.core/let
    [credentials3852 (:credentials m3851) args3853 (:args m3851)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3854
      (com.palletops.awaze.common/aws-client :ec2 credentials3852)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3854
       resetNetworkInterfaceAttribute
       (ec2/reset-network-interface-attribute-request
        (clojure.core/nth args3853 0)))))))
  (clojure.core/defn
   reset-network-interface-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         source-dest-check
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for resetNetworkInterfaceAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :reset-network-interface-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   reset-network-interface-attribute
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         source-dest-check
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call resetNetworkInterfaceAttribute"}
   [credentials3856 & args3857]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3858
     (com.palletops.awaze.common/aws-client :ec2 credentials3856)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3858
      resetNetworkInterfaceAttribute
      (ec2/reset-network-interface-attribute-request
       (clojure.core/nth args3857 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-placement-groups
   [m3859]
   (clojure.core/let
    [credentials3860 (:credentials m3859) args3861 (:args m3859)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3862
      (com.palletops.awaze.common/aws-client :ec2 credentials3860)]
     (clojure.core/case
      (clojure.core/count args3861)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3862
        describePlacementGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3862
        describePlacementGroups
        (ec2/describe-placement-groups-request
         (clojure.core/nth args3861 0))))))))
  (clojure.core/defn
   describe-placement-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         group-names
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describePlacementGroups, describePlacementGroups"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-placement-groups,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-placement-groups,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-placement-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         group-names
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describePlacementGroups, describePlacementGroups"}
   [credentials3864 & args3865]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3866
     (com.palletops.awaze.common/aws-client :ec2 credentials3864)]
    (clojure.core/case
     (clojure.core/count args3865)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3866
       describePlacementGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3866
       describePlacementGroups
       (ec2/describe-placement-groups-request
        (clojure.core/nth args3865 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :reset-snapshot-attribute
   [m3867]
   (clojure.core/let
    [credentials3868 (:credentials m3867) args3869 (:args m3867)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3870
      (com.palletops.awaze.common/aws-client :ec2 credentials3868)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3870
       resetSnapshotAttribute
       (ec2/reset-snapshot-attribute-request
        (clojure.core/nth args3869 0)))))))
  (clojure.core/defn
   reset-snapshot-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for resetSnapshotAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :reset-snapshot-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   reset-snapshot-attribute
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         snapshot-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call resetSnapshotAttribute"}
   [credentials3872 & args3873]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3874
     (com.palletops.awaze.common/aws-client :ec2 credentials3872)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3874
      resetSnapshotAttribute
      (ec2/reset-snapshot-attribute-request
       (clojure.core/nth args3873 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :release-address
   [m3875]
   (clojure.core/let
    [credentials3876 (:credentials m3875) args3877 (:args m3875)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3878
      (com.palletops.awaze.common/aws-client :ec2 credentials3876)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3878
       releaseAddress
       (ec2/release-address-request (clojure.core/nth args3877 0)))))))
  (clojure.core/defn
   release-address-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         allocation-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         public-ip]}]]),
    :doc "Generate map for releaseAddress"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :release-address,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   release-address
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         allocation-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         public-ip]}]]),
    :doc "Call releaseAddress"}
   [credentials3880 & args3881]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3882
     (com.palletops.awaze.common/aws-client :ec2 credentials3880)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3882
      releaseAddress
      (ec2/release-address-request (clojure.core/nth args3881 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-volume-status
   [m3883]
   (clojure.core/let
    [credentials3884 (:credentials m3883) args3885 (:args m3883)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3886
      (com.palletops.awaze.common/aws-client :ec2 credentials3884)]
     (clojure.core/case
      (clojure.core/count args3885)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3886
        describeVolumeStatus))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3886
        describeVolumeStatus
        (ec2/describe-volume-status-request
         (clojure.core/nth args3885 0))))))))
  (clojure.core/defn
   describe-volume-status-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         volume-ids
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeVolumeStatus, describeVolumeStatus"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-volume-status,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-volume-status,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-volume-status
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         volume-ids
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeVolumeStatus, describeVolumeStatus"}
   [credentials3888 & args3889]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3890
     (com.palletops.awaze.common/aws-client :ec2 credentials3888)]
    (clojure.core/case
     (clojure.core/count args3889)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3890
       describeVolumeStatus))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3890
       describeVolumeStatus
       (ec2/describe-volume-status-request
        (clojure.core/nth args3889 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :bundle-instance
   [m3891]
   (clojure.core/let
    [credentials3892 (:credentials m3891) args3893 (:args m3891)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3894
      (com.palletops.awaze.common/aws-client :ec2 credentials3892)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3894
       bundleInstance
       (ec2/bundle-instance-request (clojure.core/nth args3893 0)))))))
  (clojure.core/defn
   bundle-instance-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         storage
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for bundleInstance"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :bundle-instance,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   bundle-instance
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         storage
                         clone-source
                         clone-root]}]]),
    :doc "Call bundleInstance"}
   [credentials3896 & args3897]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3898
     (com.palletops.awaze.common/aws-client :ec2 credentials3896)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3898
      bundleInstance
      (ec2/bundle-instance-request (clojure.core/nth args3897 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpn-connections
   [m3899]
   (clojure.core/let
    [credentials3900 (:credentials m3899) args3901 (:args m3899)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3902
      (com.palletops.awaze.common/aws-client :ec2 credentials3900)]
     (clojure.core/case
      (clojure.core/count args3901)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3902
        describeVpnConnections
        (ec2/describe-vpn-connections-request
         (clojure.core/nth args3901 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3902
        describeVpnConnections))))))
  (clojure.core/defn
   describe-vpn-connections-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpn-connection-ids
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeVpnConnections, describeVpnConnections"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-vpn-connections,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-vpn-connections,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-vpn-connections
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpn-connection-ids
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeVpnConnections, describeVpnConnections"}
   [credentials3904 & args3905]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3906
     (com.palletops.awaze.common/aws-client :ec2 credentials3904)]
    (clojure.core/case
     (clojure.core/count args3905)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3906
       describeVpnConnections
       (ec2/describe-vpn-connections-request
        (clojure.core/nth args3905 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3906
       describeVpnConnections))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-route
   [m3907]
   (clojure.core/let
    [credentials3908 (:credentials m3907) args3909 (:args m3907)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3910
      (com.palletops.awaze.common/aws-client :ec2 credentials3908)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3910
       createRoute
       (ec2/create-route-request (clojure.core/nth args3909 0)))))))
  (clojure.core/defn
   create-route-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-peering-connection-id
                         destination-cidr-block
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         instance-id
                         read-limit
                         nat-gateway-id
                         general-progress-listener
                         clone-source
                         gateway-id
                         route-table-id
                         clone-root]}]]),
    :doc "Generate map for createRoute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-route,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-route
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-peering-connection-id
                         destination-cidr-block
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         instance-id
                         read-limit
                         nat-gateway-id
                         general-progress-listener
                         clone-source
                         gateway-id
                         route-table-id
                         clone-root]}]]),
    :doc "Call createRoute"}
   [credentials3912 & args3913]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3914
     (com.palletops.awaze.common/aws-client :ec2 credentials3912)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3914
      createRoute
      (ec2/create-route-request (clojure.core/nth args3913 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-spot-price-history
   [m3915]
   (clojure.core/let
    [credentials3916 (:credentials m3915) args3917 (:args m3915)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3918
      (com.palletops.awaze.common/aws-client :ec2 credentials3916)]
     (clojure.core/case
      (clojure.core/count args3917)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3918
        describeSpotPriceHistory
        (ec2/describe-spot-price-history-request
         (clojure.core/nth args3917 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3918
        describeSpotPriceHistory))))))
  (clojure.core/defn
   describe-spot-price-history-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         start-time
                         max-results
                         custom-query-parameters
                         instance-types
                         end-time
                         availability-zone
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         product-descriptions
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeSpotPriceHistory, describeSpotPriceHistory"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-spot-price-history,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-spot-price-history,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-spot-price-history
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         start-time
                         max-results
                         custom-query-parameters
                         instance-types
                         end-time
                         availability-zone
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         product-descriptions
                         next-token]}]
                [credentials]]),
    :doc "Call describeSpotPriceHistory, describeSpotPriceHistory"}
   [credentials3920 & args3921]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3922
     (com.palletops.awaze.common/aws-client :ec2 credentials3920)]
    (clojure.core/case
     (clojure.core/count args3921)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3922
       describeSpotPriceHistory
       (ec2/describe-spot-price-history-request
        (clojure.core/nth args3921 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3922
       describeSpotPriceHistory))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-availability-zones
   [m3923]
   (clojure.core/let
    [credentials3924 (:credentials m3923) args3925 (:args m3923)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3926
      (com.palletops.awaze.common/aws-client :ec2 credentials3924)]
     (clojure.core/case
      (clojure.core/count args3925)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3926
        describeAvailabilityZones
        (ec2/describe-availability-zones-request
         (clojure.core/nth args3925 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3926
        describeAvailabilityZones))))))
  (clojure.core/defn
   describe-availability-zones-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         zone-names
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeAvailabilityZones, describeAvailabilityZones"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-availability-zones,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-availability-zones,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-availability-zones
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         zone-names
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeAvailabilityZones, describeAvailabilityZones"}
   [credentials3928 & args3929]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3930
     (com.palletops.awaze.common/aws-client :ec2 credentials3928)]
    (clojure.core/case
     (clojure.core/count args3929)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3930
       describeAvailabilityZones
       (ec2/describe-availability-zones-request
        (clojure.core/nth args3929 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3930
       describeAvailabilityZones))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-vpc-peering-connection
   [m3931]
   (clojure.core/let
    [credentials3932 (:credentials m3931) args3933 (:args m3931)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3934
      (com.palletops.awaze.common/aws-client :ec2 credentials3932)]
     (clojure.core/case
      (clojure.core/count args3933)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3934
        createVpcPeeringConnection
        (ec2/create-vpc-peering-connection-request
         (clojure.core/nth args3933 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3934
        createVpcPeeringConnection))))))
  (clojure.core/defn
   create-vpc-peering-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         peer-vpc-id
                         custom-query-parameters
                         peer-owner-id
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for createVpcPeeringConnection, createVpcPeeringConnection"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :create-vpc-peering-connection,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-vpc-peering-connection,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-vpc-peering-connection
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         peer-vpc-id
                         custom-query-parameters
                         peer-owner-id
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call createVpcPeeringConnection, createVpcPeeringConnection"}
   [credentials3936 & args3937]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3938
     (com.palletops.awaze.common/aws-client :ec2 credentials3936)]
    (clojure.core/case
     (clojure.core/count args3937)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3938
       createVpcPeeringConnection
       (ec2/create-vpc-peering-connection-request
        (clojure.core/nth args3937 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3938
       createVpcPeeringConnection))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-internet-gateways
   [m3939]
   (clojure.core/let
    [credentials3940 (:credentials m3939) args3941 (:args m3939)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3942
      (com.palletops.awaze.common/aws-client :ec2 credentials3940)]
     (clojure.core/case
      (clojure.core/count args3941)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3942
        describeInternetGateways
        (ec2/describe-internet-gateways-request
         (clojure.core/nth args3941 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3942
        describeInternetGateways))))))
  (clojure.core/defn
   describe-internet-gateways-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         internet-gateway-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeInternetGateways, describeInternetGateways"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-internet-gateways,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-internet-gateways,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-internet-gateways
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         internet-gateway-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeInternetGateways, describeInternetGateways"}
   [credentials3944 & args3945]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3946
     (com.palletops.awaze.common/aws-client :ec2 credentials3944)]
    (clojure.core/case
     (clojure.core/count args3945)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3946
       describeInternetGateways
       (ec2/describe-internet-gateways-request
        (clojure.core/nth args3945 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3946
       describeInternetGateways))))))
 (do
  (clojure.core/defmethod
   ec2
   :disassociate-route-table
   [m3947]
   (clojure.core/let
    [credentials3948 (:credentials m3947) args3949 (:args m3947)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3950
      (com.palletops.awaze.common/aws-client :ec2 credentials3948)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3950
       disassociateRouteTable
       (ec2/disassociate-route-table-request
        (clojure.core/nth args3949 0)))))))
  (clojure.core/defn
   disassociate-route-table-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         association-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for disassociateRouteTable"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :disassociate-route-table,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   disassociate-route-table
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         association-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call disassociateRouteTable"}
   [credentials3952 & args3953]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3954
     (com.palletops.awaze.common/aws-client :ec2 credentials3952)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3954
      disassociateRouteTable
      (ec2/disassociate-route-table-request
       (clojure.core/nth args3953 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-regions
   [m3955]
   (clojure.core/let
    [credentials3956 (:credentials m3955) args3957 (:args m3955)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3958
      (com.palletops.awaze.common/aws-client :ec2 credentials3956)]
     (clojure.core/case
      (clojure.core/count args3957)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3958
        describeRegions))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3958
        describeRegions
        (ec2/describe-regions-request (clojure.core/nth args3957 0))))))))
  (clojure.core/defn
   describe-regions-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [region-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeRegions, describeRegions"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-regions,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-regions,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-regions
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [region-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeRegions, describeRegions"}
   [credentials3960 & args3961]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3962
     (com.palletops.awaze.common/aws-client :ec2 credentials3960)]
    (clojure.core/case
     (clojure.core/count args3961)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3962
       describeRegions))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3962
       describeRegions
       (ec2/describe-regions-request (clojure.core/nth args3961 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :enable-vpc-classic-link-dns-support
   [m3963]
   (clojure.core/let
    [credentials3964 (:credentials m3963) args3965 (:args m3963)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3966
      (com.palletops.awaze.common/aws-client :ec2 credentials3964)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3966
       enableVpcClassicLinkDnsSupport
       (ec2/enable-vpc-classic-link-dns-support-request
        (clojure.core/nth args3965 0)))))))
  (clojure.core/defn
   enable-vpc-classic-link-dns-support-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for enableVpcClassicLinkDnsSupport"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :enable-vpc-classic-link-dns-support,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   enable-vpc-classic-link-dns-support
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call enableVpcClassicLinkDnsSupport"}
   [credentials3968 & args3969]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3970
     (com.palletops.awaze.common/aws-client :ec2 credentials3968)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3970
      enableVpcClassicLinkDnsSupport
      (ec2/enable-vpc-classic-link-dns-support-request
       (clojure.core/nth args3969 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :deregister-image
   [m3971]
   (clojure.core/let
    [credentials3972 (:credentials m3971) args3973 (:args m3971)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3974
      (com.palletops.awaze.common/aws-client :ec2 credentials3972)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3974
       deregisterImage
       (ec2/deregister-image-request (clojure.core/nth args3973 0)))))))
  (clojure.core/defn
   deregister-image-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         image-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deregisterImage"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :deregister-image,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   deregister-image
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         image-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deregisterImage"}
   [credentials3976 & args3977]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3978
     (com.palletops.awaze.common/aws-client :ec2 credentials3976)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3978
      deregisterImage
      (ec2/deregister-image-request (clojure.core/nth args3977 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-spot-datafeed-subscription
   [m3979]
   (clojure.core/let
    [credentials3980 (:credentials m3979) args3981 (:args m3979)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3982
      (com.palletops.awaze.common/aws-client :ec2 credentials3980)]
     (clojure.core/case
      (clojure.core/count args3981)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3982
        deleteSpotDatafeedSubscription
        (ec2/delete-spot-datafeed-subscription-request
         (clojure.core/nth args3981 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3982
        deleteSpotDatafeedSubscription))))))
  (clojure.core/defn
   delete-spot-datafeed-subscription-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for deleteSpotDatafeedSubscription, deleteSpotDatafeedSubscription"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :delete-spot-datafeed-subscription,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-spot-datafeed-subscription,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-spot-datafeed-subscription
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call deleteSpotDatafeedSubscription, deleteSpotDatafeedSubscription"}
   [credentials3984 & args3985]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3986
     (com.palletops.awaze.common/aws-client :ec2 credentials3984)]
    (clojure.core/case
     (clojure.core/count args3985)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3986
       deleteSpotDatafeedSubscription
       (ec2/delete-spot-datafeed-subscription-request
        (clojure.core/nth args3985 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3986
       deleteSpotDatafeedSubscription))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-customer-gateways
   [m3987]
   (clojure.core/let
    [credentials3988 (:credentials m3987) args3989 (:args m3987)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3990
      (com.palletops.awaze.common/aws-client :ec2 credentials3988)]
     (clojure.core/case
      (clojure.core/count args3989)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3990
        describeCustomerGateways
        (ec2/describe-customer-gateways-request
         (clojure.core/nth args3989 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3990
        describeCustomerGateways))))))
  (clojure.core/defn
   describe-customer-gateways-map
   {:arglists (quote
               [[credentials
                 {:keys [customer-gateway-ids
                         custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeCustomerGateways, describeCustomerGateways"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-customer-gateways,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-customer-gateways,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-customer-gateways
   {:arglists (quote
               [[credentials
                 {:keys [customer-gateway-ids
                         custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeCustomerGateways, describeCustomerGateways"}
   [credentials3992 & args3993]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client3994
     (com.palletops.awaze.common/aws-client :ec2 credentials3992)]
    (clojure.core/case
     (clojure.core/count args3993)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3994
       describeCustomerGateways
       (ec2/describe-customer-gateways-request
        (clojure.core/nth args3993 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3994
       describeCustomerGateways))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-spot-fleet-request-history
   [m3995]
   (clojure.core/let
    [credentials3996 (:credentials m3995) args3997 (:args m3995)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client3998
      (com.palletops.awaze.common/aws-client :ec2 credentials3996)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client3998
       describeSpotFleetRequestHistory
       (ec2/describe-spot-fleet-request-history-request
        (clojure.core/nth args3997 0)))))))
  (clojure.core/defn
   describe-spot-fleet-request-history-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         start-time
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         spot-fleet-request-id
                         clone-source
                         event-type
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeSpotFleetRequestHistory"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-spot-fleet-request-history,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-spot-fleet-request-history
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         start-time
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         spot-fleet-request-id
                         clone-source
                         event-type
                         clone-root
                         next-token]}]]),
    :doc "Call describeSpotFleetRequestHistory"}
   [credentials4000 & args4001]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4002
     (com.palletops.awaze.common/aws-client :ec2 credentials4000)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4002
      describeSpotFleetRequestHistory
      (ec2/describe-spot-fleet-request-history-request
       (clojure.core/nth args4001 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-subnet
   [m4003]
   (clojure.core/let
    [credentials4004 (:credentials m4003) args4005 (:args m4003)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4006
      (com.palletops.awaze.common/aws-client :ec2 credentials4004)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4006
       createSubnet
       (ec2/create-subnet-request (clojure.core/nth args4005 0)))))))
  (clojure.core/defn
   create-subnet-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         availability-zone
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         cidr-block
                         clone-root]}]]),
    :doc "Generate map for createSubnet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-subnet,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-subnet
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         availability-zone
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         cidr-block
                         clone-root]}]]),
    :doc "Call createSubnet"}
   [credentials4008 & args4009]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4010
     (com.palletops.awaze.common/aws-client :ec2 credentials4008)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4010
      createSubnet
      (ec2/create-subnet-request (clojure.core/nth args4009 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-network-interface-attribute
   [m4011]
   (clojure.core/let
    [credentials4012 (:credentials m4011) args4013 (:args m4011)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4014
      (com.palletops.awaze.common/aws-client :ec2 credentials4012)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4014
       describeNetworkInterfaceAttribute
       (ec2/describe-network-interface-attribute-request
        (clojure.core/nth args4013 0)))))))
  (clojure.core/defn
   describe-network-interface-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeNetworkInterfaceAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-network-interface-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-network-interface-attribute
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeNetworkInterfaceAttribute"}
   [credentials4016 & args4017]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4018
     (com.palletops.awaze.common/aws-client :ec2 credentials4016)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4018
      describeNetworkInterfaceAttribute
      (ec2/describe-network-interface-attribute-request
       (clojure.core/nth args4017 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-instance-placement
   [m4019]
   (clojure.core/let
    [credentials4020 (:credentials m4019) args4021 (:args m4019)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4022
      (com.palletops.awaze.common/aws-client :ec2 credentials4020)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4022
       modifyInstancePlacement
       (ec2/modify-instance-placement-request
        (clojure.core/nth args4021 0)))))))
  (clojure.core/defn
   modify-instance-placement-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         tenancy
                         sdk-request-timeout
                         affinity
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         host-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for modifyInstancePlacement"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-instance-placement,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-instance-placement
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         tenancy
                         sdk-request-timeout
                         affinity
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         host-id
                         clone-source
                         clone-root]}]]),
    :doc "Call modifyInstancePlacement"}
   [credentials4024 & args4025]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4026
     (com.palletops.awaze.common/aws-client :ec2 credentials4024)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4026
      modifyInstancePlacement
      (ec2/modify-instance-placement-request
       (clojure.core/nth args4025 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :detach-classic-link-vpc
   [m4027]
   (clojure.core/let
    [credentials4028 (:credentials m4027) args4029 (:args m4027)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4030
      (com.palletops.awaze.common/aws-client :ec2 credentials4028)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4030
       detachClassicLinkVpc
       (ec2/detach-classic-link-vpc-request
        (clojure.core/nth args4029 0)))))))
  (clojure.core/defn
   detach-classic-link-vpc-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for detachClassicLinkVpc"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :detach-classic-link-vpc,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   detach-classic-link-vpc
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call detachClassicLinkVpc"}
   [credentials4032 & args4033]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4034
     (com.palletops.awaze.common/aws-client :ec2 credentials4032)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4034
      detachClassicLinkVpc
      (ec2/detach-classic-link-vpc-request
       (clojure.core/nth args4033 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :cancel-conversion-task
   [m4035]
   (clojure.core/let
    [credentials4036 (:credentials m4035) args4037 (:args m4035)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4038
      (com.palletops.awaze.common/aws-client :ec2 credentials4036)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4038
       cancelConversionTask
       (ec2/cancel-conversion-task-request
        (clojure.core/nth args4037 0)))))))
  (clojure.core/defn
   cancel-conversion-task-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         conversion-task-id
                         custom-query-parameters
                         reason-message
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for cancelConversionTask"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :cancel-conversion-task,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   cancel-conversion-task
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         conversion-task-id
                         custom-query-parameters
                         reason-message
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call cancelConversionTask"}
   [credentials4040 & args4041]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4042
     (com.palletops.awaze.common/aws-client :ec2 credentials4040)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4042
      cancelConversionTask
      (ec2/cancel-conversion-task-request
       (clojure.core/nth args4041 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-network-interface
   [m4043]
   (clojure.core/let
    [credentials4044 (:credentials m4043) args4045 (:args m4043)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4046
      (com.palletops.awaze.common/aws-client :ec2 credentials4044)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4046
       createNetworkInterface
       (ec2/create-network-interface-request
        (clojure.core/nth args4045 0)))))))
  (clojure.core/defn
   create-network-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         subnet-id
                         sdk-request-timeout
                         private-ip-addresses
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         private-ip-address
                         clone-source
                         groups
                         clone-root
                         secondary-private-ip-address-count]}]]),
    :doc "Generate map for createNetworkInterface"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-network-interface,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-network-interface
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         subnet-id
                         sdk-request-timeout
                         private-ip-addresses
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         private-ip-address
                         clone-source
                         groups
                         clone-root
                         secondary-private-ip-address-count]}]]),
    :doc "Call createNetworkInterface"}
   [credentials4048 & args4049]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4050
     (com.palletops.awaze.common/aws-client :ec2 credentials4048)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4050
      createNetworkInterface
      (ec2/create-network-interface-request
       (clojure.core/nth args4049 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-image-attribute
   [m4051]
   (clojure.core/let
    [credentials4052 (:credentials m4051) args4053 (:args m4051)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4054
      (com.palletops.awaze.common/aws-client :ec2 credentials4052)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4054
       modifyImageAttribute
       (ec2/modify-image-attribute-request
        (clojure.core/nth args4053 0)))))))
  (clojure.core/defn
   modify-image-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         user-ids
                         sdk-request-timeout
                         product-codes
                         value
                         user-groups
                         image-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         operation-type
                         clone-root
                         launch-permission]}]]),
    :doc "Generate map for modifyImageAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-image-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-image-attribute
   {:arglists (quote
               [[credentials
                 {:keys [description
                         attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         user-ids
                         sdk-request-timeout
                         product-codes
                         value
                         user-groups
                         image-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         operation-type
                         clone-root
                         launch-permission]}]]),
    :doc "Call modifyImageAttribute"}
   [credentials4056 & args4057]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4058
     (com.palletops.awaze.common/aws-client :ec2 credentials4056)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4058
      modifyImageAttribute
      (ec2/modify-image-attribute-request
       (clojure.core/nth args4057 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-route-table
   [m4059]
   (clojure.core/let
    [credentials4060 (:credentials m4059) args4061 (:args m4059)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4062
      (com.palletops.awaze.common/aws-client :ec2 credentials4060)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4062
       deleteRouteTable
       (ec2/delete-route-table-request (clojure.core/nth args4061 0)))))))
  (clojure.core/defn
   delete-route-table-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         route-table-id
                         clone-root]}]]),
    :doc "Generate map for deleteRouteTable"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-route-table,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-route-table
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         route-table-id
                         clone-root]}]]),
    :doc "Call deleteRouteTable"}
   [credentials4064 & args4065]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4066
     (com.palletops.awaze.common/aws-client :ec2 credentials4064)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4066
      deleteRouteTable
      (ec2/delete-route-table-request (clojure.core/nth args4065 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :associate-route-table
   [m4067]
   (clojure.core/let
    [credentials4068 (:credentials m4067) args4069 (:args m4067)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4070
      (com.palletops.awaze.common/aws-client :ec2 credentials4068)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4070
       associateRouteTable
       (ec2/associate-route-table-request
        (clojure.core/nth args4069 0)))))))
  (clojure.core/defn
   associate-route-table-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subnet-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         route-table-id
                         clone-root]}]]),
    :doc "Generate map for associateRouteTable"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :associate-route-table,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   associate-route-table
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subnet-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         route-table-id
                         clone-root]}]]),
    :doc "Call associateRouteTable"}
   [credentials4072 & args4073]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4074
     (com.palletops.awaze.common/aws-client :ec2 credentials4072)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4074
      associateRouteTable
      (ec2/associate-route-table-request
       (clojure.core/nth args4073 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-customer-gateway
   [m4075]
   (clojure.core/let
    [credentials4076 (:credentials m4075) args4077 (:args m4075)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4078
      (com.palletops.awaze.common/aws-client :ec2 credentials4076)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4078
       deleteCustomerGateway
       (ec2/delete-customer-gateway-request
        (clojure.core/nth args4077 0)))))))
  (clojure.core/defn
   delete-customer-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         customer-gateway-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteCustomerGateway"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-customer-gateway,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-customer-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         customer-gateway-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteCustomerGateway"}
   [credentials4080 & args4081]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4082
     (com.palletops.awaze.common/aws-client :ec2 credentials4080)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4082
      deleteCustomerGateway
      (ec2/delete-customer-gateway-request
       (clojure.core/nth args4081 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :replace-route-table-association
   [m4083]
   (clojure.core/let
    [credentials4084 (:credentials m4083) args4085 (:args m4083)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4086
      (com.palletops.awaze.common/aws-client :ec2 credentials4084)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4086
       replaceRouteTableAssociation
       (ec2/replace-route-table-association-request
        (clojure.core/nth args4085 0)))))))
  (clojure.core/defn
   replace-route-table-association-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         association-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         route-table-id
                         clone-root]}]]),
    :doc "Generate map for replaceRouteTableAssociation"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :replace-route-table-association,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   replace-route-table-association
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         association-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         route-table-id
                         clone-root]}]]),
    :doc "Call replaceRouteTableAssociation"}
   [credentials4088 & args4089]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4090
     (com.palletops.awaze.common/aws-client :ec2 credentials4088)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4090
      replaceRouteTableAssociation
      (ec2/replace-route-table-association-request
       (clojure.core/nth args4089 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-vpc
   [m4091]
   (clojure.core/let
    [credentials4092 (:credentials m4091) args4093 (:args m4091)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4094
      (com.palletops.awaze.common/aws-client :ec2 credentials4092)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4094
       deleteVpc
       (ec2/delete-vpc-request (clojure.core/nth args4093 0)))))))
  (clojure.core/defn
   delete-vpc-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteVpc"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-vpc,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-vpc
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteVpc"}
   [credentials4096 & args4097]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4098
     (com.palletops.awaze.common/aws-client :ec2 credentials4096)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4098
      deleteVpc
      (ec2/delete-vpc-request (clojure.core/nth args4097 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-key-pair
   [m4099]
   (clojure.core/let
    [credentials4100 (:credentials m4099) args4101 (:args m4099)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4102
      (com.palletops.awaze.common/aws-client :ec2 credentials4100)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4102
       createKeyPair
       (ec2/create-key-pair-request (clojure.core/nth args4101 0)))))))
  (clojure.core/defn
   create-key-pair-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createKeyPair"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-key-pair,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-key-pair
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createKeyPair"}
   [credentials4104 & args4105]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4106
     (com.palletops.awaze.common/aws-client :ec2 credentials4104)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4106
      createKeyPair
      (ec2/create-key-pair-request (clojure.core/nth args4105 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :allocate-hosts
   [m4107]
   (clojure.core/let
    [credentials4108 (:credentials m4107) args4109 (:args m4107)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4110
      (com.palletops.awaze.common/aws-client :ec2 credentials4108)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4110
       allocateHosts
       (ec2/allocate-hosts-request (clojure.core/nth args4109 0)))))))
  (clojure.core/defn
   allocate-hosts-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         instance-type
                         custom-query-parameters
                         availability-zone
                         auto-placement
                         read-limit
                         general-progress-listener
                         clone-source
                         quantity
                         client-token
                         clone-root]}]]),
    :doc "Generate map for allocateHosts"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :allocate-hosts,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   allocate-hosts
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         instance-type
                         custom-query-parameters
                         availability-zone
                         auto-placement
                         read-limit
                         general-progress-listener
                         clone-source
                         quantity
                         client-token
                         clone-root]}]]),
    :doc "Call allocateHosts"}
   [credentials4112 & args4113]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4114
     (com.palletops.awaze.common/aws-client :ec2 credentials4112)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4114
      allocateHosts
      (ec2/allocate-hosts-request (clojure.core/nth args4113 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :replace-route
   [m4115]
   (clojure.core/let
    [credentials4116 (:credentials m4115) args4117 (:args m4115)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4118
      (com.palletops.awaze.common/aws-client :ec2 credentials4116)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4118
       replaceRoute
       (ec2/replace-route-request (clojure.core/nth args4117 0)))))))
  (clojure.core/defn
   replace-route-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-peering-connection-id
                         destination-cidr-block
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         instance-id
                         read-limit
                         nat-gateway-id
                         general-progress-listener
                         clone-source
                         gateway-id
                         route-table-id
                         clone-root]}]]),
    :doc "Generate map for replaceRoute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :replace-route,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   replace-route
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-peering-connection-id
                         destination-cidr-block
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         instance-id
                         read-limit
                         nat-gateway-id
                         general-progress-listener
                         clone-source
                         gateway-id
                         route-table-id
                         clone-root]}]]),
    :doc "Call replaceRoute"}
   [credentials4120 & args4121]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4122
     (com.palletops.awaze.common/aws-client :ec2 credentials4120)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4122
      replaceRoute
      (ec2/replace-route-request (clojure.core/nth args4121 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :terminate-instances
   [m4123]
   (clojure.core/let
    [credentials4124 (:credentials m4123) args4125 (:args m4123)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4126
      (com.palletops.awaze.common/aws-client :ec2 credentials4124)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4126
       terminateInstances
       (ec2/terminate-instances-request (clojure.core/nth args4125 0)))))))
  (clojure.core/defn
   terminate-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for terminateInstances"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :terminate-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   terminate-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call terminateInstances"}
   [credentials4128 & args4129]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4130
     (com.palletops.awaze.common/aws-client :ec2 credentials4128)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4130
      terminateInstances
      (ec2/terminate-instances-request (clojure.core/nth args4129 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-snapshots
   [m4131]
   (clojure.core/let
    [credentials4132 (:credentials m4131) args4133 (:args m4131)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4134
      (com.palletops.awaze.common/aws-client :ec2 credentials4132)]
     (clojure.core/case
      (clojure.core/count args4133)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4134
        describeSnapshots))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4134
        describeSnapshots
        (ec2/describe-snapshots-request (clojure.core/nth args4133 0))))))))
  (clojure.core/defn
   describe-snapshots-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         restorable-by-user-ids
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         snapshot-ids
                         owner-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeSnapshots, describeSnapshots"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-snapshots,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-snapshots,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-snapshots
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         restorable-by-user-ids
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         snapshot-ids
                         owner-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeSnapshots, describeSnapshots"}
   [credentials4136 & args4137]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4138
     (com.palletops.awaze.common/aws-client :ec2 credentials4136)]
    (clojure.core/case
     (clojure.core/count args4137)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4138
       describeSnapshots))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4138
       describeSnapshots
       (ec2/describe-snapshots-request (clojure.core/nth args4137 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpn-gateways
   [m4139]
   (clojure.core/let
    [credentials4140 (:credentials m4139) args4141 (:args m4139)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4142
      (com.palletops.awaze.common/aws-client :ec2 credentials4140)]
     (clojure.core/case
      (clojure.core/count args4141)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4142
        describeVpnGateways))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4142
        describeVpnGateways
        (ec2/describe-vpn-gateways-request
         (clojure.core/nth args4141 0))))))))
  (clojure.core/defn
   describe-vpn-gateways-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         vpn-gateway-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeVpnGateways, describeVpnGateways"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-vpn-gateways,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-vpn-gateways,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-vpn-gateways
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         vpn-gateway-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeVpnGateways, describeVpnGateways"}
   [credentials4144 & args4145]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4146
     (com.palletops.awaze.common/aws-client :ec2 credentials4144)]
    (clojure.core/case
     (clojure.core/count args4145)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4146
       describeVpnGateways))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4146
       describeVpnGateways
       (ec2/describe-vpn-gateways-request
        (clojure.core/nth args4145 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :get-password-data
   [m4147]
   (clojure.core/let
    [credentials4148 (:credentials m4147) args4149 (:args m4147)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4150
      (com.palletops.awaze.common/aws-client :ec2 credentials4148)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4150
       getPasswordData
       (ec2/get-password-data-request (clojure.core/nth args4149 0)))))))
  (clojure.core/defn
   get-password-data-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getPasswordData"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-password-data,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   get-password-data
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getPasswordData"}
   [credentials4152 & args4153]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4154
     (com.palletops.awaze.common/aws-client :ec2 credentials4152)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4154
      getPasswordData
      (ec2/get-password-data-request (clojure.core/nth args4153 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-volume-attribute
   [m4155]
   (clojure.core/let
    [credentials4156 (:credentials m4155) args4157 (:args m4155)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4158
      (com.palletops.awaze.common/aws-client :ec2 credentials4156)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4158
       modifyVolumeAttribute
       (ec2/modify-volume-attribute-request
        (clojure.core/nth args4157 0)))))))
  (clojure.core/defn
   modify-volume-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [auto-enable-io
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for modifyVolumeAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-volume-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-volume-attribute
   {:arglists (quote
               [[credentials
                 {:keys [auto-enable-io
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call modifyVolumeAttribute"}
   [credentials4160 & args4161]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4162
     (com.palletops.awaze.common/aws-client :ec2 credentials4160)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4162
      modifyVolumeAttribute
      (ec2/modify-volume-attribute-request
       (clojure.core/nth args4161 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :disable-vgw-route-propagation
   [m4163]
   (clojure.core/let
    [credentials4164 (:credentials m4163) args4165 (:args m4163)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4166
      (com.palletops.awaze.common/aws-client :ec2 credentials4164)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4166
       disableVgwRoutePropagation
       (ec2/disable-vgw-route-propagation-request
        (clojure.core/nth args4165 0)))))))
  (clojure.core/defn
   disable-vgw-route-propagation-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-id
                         route-table-id
                         clone-root]}]]),
    :doc "Generate map for disableVgwRoutePropagation"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :disable-vgw-route-propagation,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   disable-vgw-route-propagation
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-id
                         route-table-id
                         clone-root]}]]),
    :doc "Call disableVgwRoutePropagation"}
   [credentials4168 & args4169]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4170
     (com.palletops.awaze.common/aws-client :ec2 credentials4168)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4170
      disableVgwRoutePropagation
      (ec2/disable-vgw-route-propagation-request
       (clojure.core/nth args4169 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-spot-fleet-instances
   [m4171]
   (clojure.core/let
    [credentials4172 (:credentials m4171) args4173 (:args m4171)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4174
      (com.palletops.awaze.common/aws-client :ec2 credentials4172)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4174
       describeSpotFleetInstances
       (ec2/describe-spot-fleet-instances-request
        (clojure.core/nth args4173 0)))))))
  (clojure.core/defn
   describe-spot-fleet-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         spot-fleet-request-id
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeSpotFleetInstances"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-spot-fleet-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-spot-fleet-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         spot-fleet-request-id
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeSpotFleetInstances"}
   [credentials4176 & args4177]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4178
     (com.palletops.awaze.common/aws-client :ec2 credentials4176)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4178
      describeSpotFleetInstances
      (ec2/describe-spot-fleet-instances-request
       (clojure.core/nth args4177 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-prefix-lists
   [m4179]
   (clojure.core/let
    [credentials4180 (:credentials m4179) args4181 (:args m4179)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4182
      (com.palletops.awaze.common/aws-client :ec2 credentials4180)]
     (clojure.core/case
      (clojure.core/count args4181)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4182
        describePrefixLists))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4182
        describePrefixLists
        (ec2/describe-prefix-lists-request
         (clojure.core/nth args4181 0))))))))
  (clojure.core/defn
   describe-prefix-lists-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         prefix-list-ids
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describePrefixLists, describePrefixLists"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-prefix-lists,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-prefix-lists,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-prefix-lists
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         prefix-list-ids
                         clone-root
                         next-token]}]]),
    :doc "Call describePrefixLists, describePrefixLists"}
   [credentials4184 & args4185]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4186
     (com.palletops.awaze.common/aws-client :ec2 credentials4184)]
    (clojure.core/case
     (clojure.core/count args4185)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4186
       describePrefixLists))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4186
       describePrefixLists
       (ec2/describe-prefix-lists-request
        (clojure.core/nth args4185 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-account-attributes
   [m4187]
   (clojure.core/let
    [credentials4188 (:credentials m4187) args4189 (:args m4187)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4190
      (com.palletops.awaze.common/aws-client :ec2 credentials4188)]
     (clojure.core/case
      (clojure.core/count args4189)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4190
        describeAccountAttributes
        (ec2/describe-account-attributes-request
         (clojure.core/nth args4189 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4190
        describeAccountAttributes))))))
  (clojure.core/defn
   describe-account-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         attribute-names
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeAccountAttributes, describeAccountAttributes"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-account-attributes,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-account-attributes,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-account-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         attribute-names
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeAccountAttributes, describeAccountAttributes"}
   [credentials4192 & args4193]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4194
     (com.palletops.awaze.common/aws-client :ec2 credentials4192)]
    (clojure.core/case
     (clojure.core/count args4193)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4194
       describeAccountAttributes
       (ec2/describe-account-attributes-request
        (clojure.core/nth args4193 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4194
       describeAccountAttributes))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-vpn-connection
   [m4195]
   (clojure.core/let
    [credentials4196 (:credentials m4195) args4197 (:args m4195)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4198
      (com.palletops.awaze.common/aws-client :ec2 credentials4196)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4198
       createVpnConnection
       (ec2/create-vpn-connection-request
        (clojure.core/nth args4197 0)))))))
  (clojure.core/defn
   create-vpn-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         type
                         custom-query-parameters
                         customer-gateway-id
                         read-limit
                         vpn-gateway-id
                         general-progress-listener
                         options
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createVpnConnection"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-vpn-connection,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-vpn-connection
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         type
                         custom-query-parameters
                         customer-gateway-id
                         read-limit
                         vpn-gateway-id
                         general-progress-listener
                         options
                         clone-source
                         clone-root]}]]),
    :doc "Call createVpnConnection"}
   [credentials4200 & args4201]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4202
     (com.palletops.awaze.common/aws-client :ec2 credentials4200)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4202
      createVpnConnection
      (ec2/create-vpn-connection-request
       (clojure.core/nth args4201 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpc-peering-connections
   [m4203]
   (clojure.core/let
    [credentials4204 (:credentials m4203) args4205 (:args m4203)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4206
      (com.palletops.awaze.common/aws-client :ec2 credentials4204)]
     (clojure.core/case
      (clojure.core/count args4205)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4206
        describeVpcPeeringConnections))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4206
        describeVpcPeeringConnections
        (ec2/describe-vpc-peering-connections-request
         (clojure.core/nth args4205 0))))))))
  (clojure.core/defn
   describe-vpc-peering-connections-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-peering-connection-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeVpcPeeringConnections, describeVpcPeeringConnections"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-vpc-peering-connections,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-vpc-peering-connections,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-vpc-peering-connections
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-peering-connection-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeVpcPeeringConnections, describeVpcPeeringConnections"}
   [credentials4208 & args4209]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4210
     (com.palletops.awaze.common/aws-client :ec2 credentials4208)]
    (clojure.core/case
     (clojure.core/count args4209)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4210
       describeVpcPeeringConnections))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4210
       describeVpcPeeringConnections
       (ec2/describe-vpc-peering-connections-request
        (clojure.core/nth args4209 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-scheduled-instance-availability
   [m4211]
   (clojure.core/let
    [credentials4212 (:credentials m4211) args4213 (:args m4211)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4214
      (com.palletops.awaze.common/aws-client :ec2 credentials4212)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4214
       describeScheduledInstanceAvailability
       (ec2/describe-scheduled-instance-availability-request
        (clojure.core/nth args4213 0)))))))
  (clojure.core/defn
   describe-scheduled-instance-availability-map
   {:arglists (quote
               [[credentials
                 {:keys [max-slot-duration-in-hours
                         custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         recurrence
                         min-slot-duration-in-hours
                         clone-source
                         first-slot-start-time-range
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeScheduledInstanceAvailability"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-scheduled-instance-availability,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-scheduled-instance-availability
   {:arglists (quote
               [[credentials
                 {:keys [max-slot-duration-in-hours
                         custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         recurrence
                         min-slot-duration-in-hours
                         clone-source
                         first-slot-start-time-range
                         clone-root
                         next-token]}]]),
    :doc "Call describeScheduledInstanceAvailability"}
   [credentials4216 & args4217]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4218
     (com.palletops.awaze.common/aws-client :ec2 credentials4216)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4218
      describeScheduledInstanceAvailability
      (ec2/describe-scheduled-instance-availability-request
       (clojure.core/nth args4217 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-flow-logs
   [m4219]
   (clojure.core/let
    [credentials4220 (:credentials m4219) args4221 (:args m4219)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4222
      (com.palletops.awaze.common/aws-client :ec2 credentials4220)]
     (clojure.core/case
      (clojure.core/count args4221)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4222
        describeFlowLogs))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4222
        describeFlowLogs
        (ec2/describe-flow-logs-request (clojure.core/nth args4221 0))))))))
  (clojure.core/defn
   describe-flow-logs-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         flow-log-ids
                         filter
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeFlowLogs, describeFlowLogs"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-flow-logs,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-flow-logs,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-flow-logs
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         flow-log-ids
                         filter
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeFlowLogs, describeFlowLogs"}
   [credentials4224 & args4225]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4226
     (com.palletops.awaze.common/aws-client :ec2 credentials4224)]
    (clojure.core/case
     (clojure.core/count args4225)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4226
       describeFlowLogs))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4226
       describeFlowLogs
       (ec2/describe-flow-logs-request (clojure.core/nth args4225 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :cancel-bundle-task
   [m4227]
   (clojure.core/let
    [credentials4228 (:credentials m4227) args4229 (:args m4227)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4230
      (com.palletops.awaze.common/aws-client :ec2 credentials4228)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4230
       cancelBundleTask
       (ec2/cancel-bundle-task-request (clojure.core/nth args4229 0)))))))
  (clojure.core/defn
   cancel-bundle-task-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         bundle-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for cancelBundleTask"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :cancel-bundle-task,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   cancel-bundle-task
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         bundle-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call cancelBundleTask"}
   [credentials4232 & args4233]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4234
     (com.palletops.awaze.common/aws-client :ec2 credentials4232)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4234
      cancelBundleTask
      (ec2/cancel-bundle-task-request (clojure.core/nth args4233 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-reserved-instances
   [m4235]
   (clojure.core/let
    [credentials4236 (:credentials m4235) args4237 (:args m4235)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4238
      (com.palletops.awaze.common/aws-client :ec2 credentials4236)]
     (clojure.core/case
      (clojure.core/count args4237)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4238
        describeReservedInstances))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4238
        describeReservedInstances
        (ec2/describe-reserved-instances-request
         (clojure.core/nth args4237 0))))))))
  (clojure.core/defn
   describe-reserved-instances-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         offering-type
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         reserved-instances-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeReservedInstances, describeReservedInstances"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-reserved-instances,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-reserved-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-reserved-instances
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         offering-type
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         reserved-instances-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeReservedInstances, describeReservedInstances"}
   [credentials4240 & args4241]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4242
     (com.palletops.awaze.common/aws-client :ec2 credentials4240)]
    (clojure.core/case
     (clojure.core/count args4241)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4242
       describeReservedInstances))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4242
       describeReservedInstances
       (ec2/describe-reserved-instances-request
        (clojure.core/nth args4241 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :unmonitor-instances
   [m4243]
   (clojure.core/let
    [credentials4244 (:credentials m4243) args4245 (:args m4243)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4246
      (com.palletops.awaze.common/aws-client :ec2 credentials4244)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4246
       unmonitorInstances
       (ec2/unmonitor-instances-request (clojure.core/nth args4245 0)))))))
  (clojure.core/defn
   unmonitor-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for unmonitorInstances"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :unmonitor-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   unmonitor-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call unmonitorInstances"}
   [credentials4248 & args4249]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4250
     (com.palletops.awaze.common/aws-client :ec2 credentials4248)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4250
      unmonitorInstances
      (ec2/unmonitor-instances-request (clojure.core/nth args4249 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-security-group
   [m4251]
   (clojure.core/let
    [credentials4252 (:credentials m4251) args4253 (:args m4251)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4254
      (com.palletops.awaze.common/aws-client :ec2 credentials4252)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4254
       deleteSecurityGroup
       (ec2/delete-security-group-request
        (clojure.core/nth args4253 0)))))))
  (clojure.core/defn
   delete-security-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         group-id
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteSecurityGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-security-group,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-security-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         group-id
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteSecurityGroup"}
   [credentials4256 & args4257]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4258
     (com.palletops.awaze.common/aws-client :ec2 credentials4256)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4258
      deleteSecurityGroup
      (ec2/delete-security-group-request
       (clojure.core/nth args4257 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpc-attribute
   [m4259]
   (clojure.core/let
    [credentials4260 (:credentials m4259) args4261 (:args m4259)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4262
      (com.palletops.awaze.common/aws-client :ec2 credentials4260)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4262
       describeVpcAttribute
       (ec2/describe-vpc-attribute-request
        (clojure.core/nth args4261 0)))))))
  (clojure.core/defn
   describe-vpc-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeVpcAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-vpc-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-vpc-attribute
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeVpcAttribute"}
   [credentials4264 & args4265]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4266
     (com.palletops.awaze.common/aws-client :ec2 credentials4264)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4266
      describeVpcAttribute
      (ec2/describe-vpc-attribute-request
       (clojure.core/nth args4265 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-network-acl
   [m4267]
   (clojure.core/let
    [credentials4268 (:credentials m4267) args4269 (:args m4267)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4270
      (com.palletops.awaze.common/aws-client :ec2 credentials4268)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4270
       createNetworkAcl
       (ec2/create-network-acl-request (clojure.core/nth args4269 0)))))))
  (clojure.core/defn
   create-network-acl-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createNetworkAcl"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-network-acl,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-network-acl
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createNetworkAcl"}
   [credentials4272 & args4273]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4274
     (com.palletops.awaze.common/aws-client :ec2 credentials4272)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4274
      createNetworkAcl
      (ec2/create-network-acl-request (clojure.core/nth args4273 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :cancel-import-task
   [m4275]
   (clojure.core/let
    [credentials4276 (:credentials m4275) args4277 (:args m4275)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4278
      (com.palletops.awaze.common/aws-client :ec2 credentials4276)]
     (clojure.core/case
      (clojure.core/count args4277)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4278
        cancelImportTask))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4278
        cancelImportTask
        (ec2/cancel-import-task-request (clojure.core/nth args4277 0))))))))
  (clojure.core/defn
   cancel-import-task-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [import-task-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         cancel-reason
                         clone-root]}]]),
    :doc "Generate map for cancelImportTask, cancelImportTask"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :cancel-import-task,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :cancel-import-task,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   cancel-import-task
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [import-task-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         cancel-reason
                         clone-root]}]]),
    :doc "Call cancelImportTask, cancelImportTask"}
   [credentials4280 & args4281]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4282
     (com.palletops.awaze.common/aws-client :ec2 credentials4280)]
    (clojure.core/case
     (clojure.core/count args4281)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4282
       cancelImportTask))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4282
       cancelImportTask
       (ec2/cancel-import-task-request (clojure.core/nth args4281 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :accept-vpc-peering-connection
   [m4283]
   (clojure.core/let
    [credentials4284 (:credentials m4283) args4285 (:args m4283)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4286
      (com.palletops.awaze.common/aws-client :ec2 credentials4284)]
     (clojure.core/case
      (clojure.core/count args4285)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4286
        acceptVpcPeeringConnection
        (ec2/accept-vpc-peering-connection-request
         (clojure.core/nth args4285 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4286
        acceptVpcPeeringConnection))))))
  (clojure.core/defn
   accept-vpc-peering-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-peering-connection-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for acceptVpcPeeringConnection, acceptVpcPeeringConnection"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :accept-vpc-peering-connection,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :accept-vpc-peering-connection,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   accept-vpc-peering-connection
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-peering-connection-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call acceptVpcPeeringConnection, acceptVpcPeeringConnection"}
   [credentials4288 & args4289]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4290
     (com.palletops.awaze.common/aws-client :ec2 credentials4288)]
    (clojure.core/case
     (clojure.core/count args4289)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4290
       acceptVpcPeeringConnection
       (ec2/accept-vpc-peering-connection-request
        (clojure.core/nth args4289 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4290
       acceptVpcPeeringConnection))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpc-endpoint-services
   [m4291]
   (clojure.core/let
    [credentials4292 (:credentials m4291) args4293 (:args m4291)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4294
      (com.palletops.awaze.common/aws-client :ec2 credentials4292)]
     (clojure.core/case
      (clojure.core/count args4293)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4294
        describeVpcEndpointServices))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4294
        describeVpcEndpointServices
        (ec2/describe-vpc-endpoint-services-request
         (clojure.core/nth args4293 0))))))))
  (clojure.core/defn
   describe-vpc-endpoint-services-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeVpcEndpointServices, describeVpcEndpointServices"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-vpc-endpoint-services,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-vpc-endpoint-services,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-vpc-endpoint-services
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeVpcEndpointServices, describeVpcEndpointServices"}
   [credentials4296 & args4297]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4298
     (com.palletops.awaze.common/aws-client :ec2 credentials4296)]
    (clojure.core/case
     (clojure.core/count args4297)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4298
       describeVpcEndpointServices))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4298
       describeVpcEndpointServices
       (ec2/describe-vpc-endpoint-services-request
        (clojure.core/nth args4297 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-vpc-peering-connection
   [m4299]
   (clojure.core/let
    [credentials4300 (:credentials m4299) args4301 (:args m4299)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4302
      (com.palletops.awaze.common/aws-client :ec2 credentials4300)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4302
       deleteVpcPeeringConnection
       (ec2/delete-vpc-peering-connection-request
        (clojure.core/nth args4301 0)))))))
  (clojure.core/defn
   delete-vpc-peering-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-peering-connection-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteVpcPeeringConnection"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-vpc-peering-connection,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-vpc-peering-connection
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-peering-connection-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteVpcPeeringConnection"}
   [credentials4304 & args4305]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4306
     (com.palletops.awaze.common/aws-client :ec2 credentials4304)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4306
      deleteVpcPeeringConnection
      (ec2/delete-vpc-peering-connection-request
       (clojure.core/nth args4305 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :run-instances
   [m4307]
   (clojure.core/let
    [credentials4308 (:credentials m4307) args4309 (:args m4307)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4310
      (com.palletops.awaze.common/aws-client :ec2 credentials4308)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4310
       runInstances
       (ec2/run-instances-request (clojure.core/nth args4309 0)))))))
  (clojure.core/defn
   run-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-initiated-shutdown-behavior
                         monitoring
                         ramdisk-id
                         security-group-ids
                         custom-request-headers
                         sdk-client-execution-timeout
                         subnet-id
                         key-name
                         security-groups
                         sdk-request-timeout
                         disable-api-termination
                         instance-type
                         image-id
                         custom-query-parameters
                         network-interfaces
                         ebs-optimized
                         user-data
                         iam-instance-profile
                         additional-info
                         read-limit
                         min-count
                         kernel-id
                         general-progress-listener
                         private-ip-address
                         max-count
                         clone-source
                         placement
                         client-token
                         block-device-mappings
                         clone-root]}]]),
    :doc "Generate map for runInstances"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :run-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   run-instances
   {:arglists (quote
               [[credentials
                 {:keys [instance-initiated-shutdown-behavior
                         monitoring
                         ramdisk-id
                         security-group-ids
                         custom-request-headers
                         sdk-client-execution-timeout
                         subnet-id
                         key-name
                         security-groups
                         sdk-request-timeout
                         disable-api-termination
                         instance-type
                         image-id
                         custom-query-parameters
                         network-interfaces
                         ebs-optimized
                         user-data
                         iam-instance-profile
                         additional-info
                         read-limit
                         min-count
                         kernel-id
                         general-progress-listener
                         private-ip-address
                         max-count
                         clone-source
                         placement
                         client-token
                         block-device-mappings
                         clone-root]}]]),
    :doc "Call runInstances"}
   [credentials4312 & args4313]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4314
     (com.palletops.awaze.common/aws-client :ec2 credentials4312)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4314
      runInstances
      (ec2/run-instances-request (clojure.core/nth args4313 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-instance-status
   [m4315]
   (clojure.core/let
    [credentials4316 (:credentials m4315) args4317 (:args m4315)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4318
      (com.palletops.awaze.common/aws-client :ec2 credentials4316)]
     (clojure.core/case
      (clojure.core/count args4317)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4318
        describeInstanceStatus))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4318
        describeInstanceStatus
        (ec2/describe-instance-status-request
         (clojure.core/nth args4317 0))))))))
  (clojure.core/defn
   describe-instance-status-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         include-all-instances
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeInstanceStatus, describeInstanceStatus"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-instance-status,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-instance-status,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-instance-status
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         include-all-instances
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeInstanceStatus, describeInstanceStatus"}
   [credentials4320 & args4321]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4322
     (com.palletops.awaze.common/aws-client :ec2 credentials4320)]
    (clojure.core/case
     (clojure.core/count args4321)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4322
       describeInstanceStatus))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4322
       describeInstanceStatus
       (ec2/describe-instance-status-request
        (clojure.core/nth args4321 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpc-classic-link-dns-support
   [m4323]
   (clojure.core/let
    [credentials4324 (:credentials m4323) args4325 (:args m4323)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4326
      (com.palletops.awaze.common/aws-client :ec2 credentials4324)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4326
       describeVpcClassicLinkDnsSupport
       (ec2/describe-vpc-classic-link-dns-support-request
        (clojure.core/nth args4325 0)))))))
  (clojure.core/defn
   describe-vpc-classic-link-dns-support-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-ids
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeVpcClassicLinkDnsSupport"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-vpc-classic-link-dns-support,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-vpc-classic-link-dns-support
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vpc-ids
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeVpcClassicLinkDnsSupport"}
   [credentials4328 & args4329]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4330
     (com.palletops.awaze.common/aws-client :ec2 credentials4328)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4330
      describeVpcClassicLinkDnsSupport
      (ec2/describe-vpc-classic-link-dns-support-request
       (clojure.core/nth args4329 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :unassign-private-ip-addresses
   [m4331]
   (clojure.core/let
    [credentials4332 (:credentials m4331) args4333 (:args m4331)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4334
      (com.palletops.awaze.common/aws-client :ec2 credentials4332)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4334
       unassignPrivateIpAddresses
       (ec2/unassign-private-ip-addresses-request
        (clojure.core/nth args4333 0)))))))
  (clojure.core/defn
   unassign-private-ip-addresses-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         private-ip-addresses
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for unassignPrivateIpAddresses"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :unassign-private-ip-addresses,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   unassign-private-ip-addresses
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         private-ip-addresses
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call unassignPrivateIpAddresses"}
   [credentials4336 & args4337]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4338
     (com.palletops.awaze.common/aws-client :ec2 credentials4336)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4338
      unassignPrivateIpAddresses
      (ec2/unassign-private-ip-addresses-request
       (clojure.core/nth args4337 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-security-groups
   [m4339]
   (clojure.core/let
    [credentials4340 (:credentials m4339) args4341 (:args m4339)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4342
      (com.palletops.awaze.common/aws-client :ec2 credentials4340)]
     (clojure.core/case
      (clojure.core/count args4341)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4342
        describeSecurityGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4342
        describeSecurityGroups
        (ec2/describe-security-groups-request
         (clojure.core/nth args4341 0))))))))
  (clojure.core/defn
   describe-security-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         group-ids
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         group-names
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeSecurityGroups, describeSecurityGroups"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-security-groups,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-security-groups,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-security-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         group-ids
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         group-names
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeSecurityGroups, describeSecurityGroups"}
   [credentials4344 & args4345]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4346
     (com.palletops.awaze.common/aws-client :ec2 credentials4344)]
    (clojure.core/case
     (clojure.core/count args4345)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4346
       describeSecurityGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4346
       describeSecurityGroups
       (ec2/describe-security-groups-request
        (clojure.core/nth args4345 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-network-interfaces
   [m4347]
   (clojure.core/let
    [credentials4348 (:credentials m4347) args4349 (:args m4347)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4350
      (com.palletops.awaze.common/aws-client :ec2 credentials4348)]
     (clojure.core/case
      (clojure.core/count args4349)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4350
        describeNetworkInterfaces))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4350
        describeNetworkInterfaces
        (ec2/describe-network-interfaces-request
         (clojure.core/nth args4349 0))))))))
  (clojure.core/defn
   describe-network-interfaces-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         network-interface-ids]}]]),
    :doc "Generate map for describeNetworkInterfaces, describeNetworkInterfaces"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-network-interfaces,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-network-interfaces,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-network-interfaces
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         network-interface-ids]}]]),
    :doc "Call describeNetworkInterfaces, describeNetworkInterfaces"}
   [credentials4352 & args4353]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4354
     (com.palletops.awaze.common/aws-client :ec2 credentials4352)]
    (clojure.core/case
     (clojure.core/count args4353)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4354
       describeNetworkInterfaces))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4354
       describeNetworkInterfaces
       (ec2/describe-network-interfaces-request
        (clojure.core/nth args4353 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-customer-gateway
   [m4355]
   (clojure.core/let
    [credentials4356 (:credentials m4355) args4357 (:args m4355)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4358
      (com.palletops.awaze.common/aws-client :ec2 credentials4356)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4358
       createCustomerGateway
       (ec2/create-customer-gateway-request
        (clojure.core/nth args4357 0)))))))
  (clojure.core/defn
   create-customer-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         type
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bgp-asn
                         clone-source
                         clone-root
                         public-ip]}]]),
    :doc "Generate map for createCustomerGateway"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-customer-gateway,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-customer-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         type
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bgp-asn
                         clone-source
                         clone-root
                         public-ip]}]]),
    :doc "Call createCustomerGateway"}
   [credentials4360 & args4361]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4362
     (com.palletops.awaze.common/aws-client :ec2 credentials4360)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4362
      createCustomerGateway
      (ec2/create-customer-gateway-request
       (clojure.core/nth args4361 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-dhcp-options
   [m4363]
   (clojure.core/let
    [credentials4364 (:credentials m4363) args4365 (:args m4363)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4366
      (com.palletops.awaze.common/aws-client :ec2 credentials4364)]
     (clojure.core/case
      (clojure.core/count args4365)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4366
        describeDhcpOptions))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4366
        describeDhcpOptions
        (ec2/describe-dhcp-options-request
         (clojure.core/nth args4365 0))))))))
  (clojure.core/defn
   describe-dhcp-options-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         dhcp-options-ids
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeDhcpOptions, describeDhcpOptions"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-dhcp-options,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-dhcp-options,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-dhcp-options
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         dhcp-options-ids
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeDhcpOptions, describeDhcpOptions"}
   [credentials4368 & args4369]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4370
     (com.palletops.awaze.common/aws-client :ec2 credentials4368)]
    (clojure.core/case
     (clojure.core/count args4369)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4370
       describeDhcpOptions))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4370
       describeDhcpOptions
       (ec2/describe-dhcp-options-request
        (clojure.core/nth args4369 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-tags
   [m4371]
   (clojure.core/let
    [credentials4372 (:credentials m4371) args4373 (:args m4371)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4374
      (com.palletops.awaze.common/aws-client :ec2 credentials4372)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4374
       createTags
       (ec2/create-tags-request (clojure.core/nth args4373 0)))))))
  (clojure.core/defn
   create-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         resources
                         clone-root]}]]),
    :doc "Generate map for createTags"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-tags,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-tags
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         resources
                         clone-root]}]]),
    :doc "Call createTags"}
   [credentials4376 & args4377]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4378
     (com.palletops.awaze.common/aws-client :ec2 credentials4376)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4378
      createTags
      (ec2/create-tags-request (clojure.core/nth args4377 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-snapshot
   [m4379]
   (clojure.core/let
    [credentials4380 (:credentials m4379) args4381 (:args m4379)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4382
      (com.palletops.awaze.common/aws-client :ec2 credentials4380)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4382
       createSnapshot
       (ec2/create-snapshot-request (clojure.core/nth args4381 0)))))))
  (clojure.core/defn
   create-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createSnapshot"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-snapshot,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createSnapshot"}
   [credentials4384 & args4385]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4386
     (com.palletops.awaze.common/aws-client :ec2 credentials4384)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4386
      createSnapshot
      (ec2/create-snapshot-request (clojure.core/nth args4385 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :import-image
   [m4387]
   (clojure.core/let
    [credentials4388 (:credentials m4387) args4389 (:args m4387)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4390
      (com.palletops.awaze.common/aws-client :ec2 credentials4388)]
     (clojure.core/case
      (clojure.core/count args4389)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4390
        importImage
        (ec2/import-image-request (clojure.core/nth args4389 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4390
        importImage))))))
  (clojure.core/defn
   import-image-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         hypervisor
                         license-type
                         architecture
                         sdk-request-timeout
                         custom-query-parameters
                         disk-containers
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         client-token
                         clone-root
                         platform
                         client-data]}]
                [credentials]]),
    :doc "Generate map for importImage, importImage"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :import-image,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :import-image,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   import-image
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         hypervisor
                         license-type
                         architecture
                         sdk-request-timeout
                         custom-query-parameters
                         disk-containers
                         read-limit
                         role-name
                         general-progress-listener
                         clone-source
                         client-token
                         clone-root
                         platform
                         client-data]}]
                [credentials]]),
    :doc "Call importImage, importImage"}
   [credentials4392 & args4393]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4394
     (com.palletops.awaze.common/aws-client :ec2 credentials4392)]
    (clojure.core/case
     (clojure.core/count args4393)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4394
       importImage
       (ec2/import-image-request (clojure.core/nth args4393 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4394
       importImage))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-route-table
   [m4395]
   (clojure.core/let
    [credentials4396 (:credentials m4395) args4397 (:args m4395)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4398
      (com.palletops.awaze.common/aws-client :ec2 credentials4396)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4398
       createRouteTable
       (ec2/create-route-table-request (clojure.core/nth args4397 0)))))))
  (clojure.core/defn
   create-route-table-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createRouteTable"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-route-table,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-route-table
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createRouteTable"}
   [credentials4400 & args4401]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4402
     (com.palletops.awaze.common/aws-client :ec2 credentials4400)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4402
      createRouteTable
      (ec2/create-route-table-request (clojure.core/nth args4401 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-hosts
   [m4403]
   (clojure.core/let
    [credentials4404 (:credentials m4403) args4405 (:args m4403)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4406
      (com.palletops.awaze.common/aws-client :ec2 credentials4404)]
     (clojure.core/case
      (clojure.core/count args4405)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4406
        describeHosts))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4406
        describeHosts
        (ec2/describe-hosts-request (clojure.core/nth args4405 0))))))))
  (clojure.core/defn
   describe-hosts-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         filter
                         read-limit
                         host-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeHosts, describeHosts"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-hosts,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-hosts,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-hosts
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         filter
                         read-limit
                         host-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeHosts, describeHosts"}
   [credentials4408 & args4409]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4410
     (com.palletops.awaze.common/aws-client :ec2 credentials4408)]
    (clojure.core/case
     (clojure.core/count args4409)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4410
       describeHosts))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4410
       describeHosts
       (ec2/describe-hosts-request (clojure.core/nth args4409 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-volume-attribute
   [m4411]
   (clojure.core/let
    [credentials4412 (:credentials m4411) args4413 (:args m4411)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4414
      (com.palletops.awaze.common/aws-client :ec2 credentials4412)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4414
       describeVolumeAttribute
       (ec2/describe-volume-attribute-request
        (clojure.core/nth args4413 0)))))))
  (clojure.core/defn
   describe-volume-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeVolumeAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-volume-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-volume-attribute
   {:arglists (quote
               [[credentials
                 {:keys [attribute
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         volume-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeVolumeAttribute"}
   [credentials4416 & args4417]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4418
     (com.palletops.awaze.common/aws-client :ec2 credentials4416)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4418
      describeVolumeAttribute
      (ec2/describe-volume-attribute-request
       (clojure.core/nth args4417 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-id-format
   [m4419]
   (clojure.core/let
    [credentials4420 (:credentials m4419) args4421 (:args m4419)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4422
      (com.palletops.awaze.common/aws-client :ec2 credentials4420)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4422
       modifyIdFormat
       (ec2/modify-id-format-request (clojure.core/nth args4421 0)))))))
  (clojure.core/defn
   modify-id-format-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         resource
                         general-progress-listener
                         use-long-ids
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for modifyIdFormat"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-id-format,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-id-format
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         resource
                         general-progress-listener
                         use-long-ids
                         clone-source
                         clone-root]}]]),
    :doc "Call modifyIdFormat"}
   [credentials4424 & args4425]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4426
     (com.palletops.awaze.common/aws-client :ec2 credentials4424)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4426
      modifyIdFormat
      (ec2/modify-id-format-request (clojure.core/nth args4425 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-network-acl-entry
   [m4427]
   (clojure.core/let
    [credentials4428 (:credentials m4427) args4429 (:args m4427)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4430
      (com.palletops.awaze.common/aws-client :ec2 credentials4428)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4430
       createNetworkAclEntry
       (ec2/create-network-acl-entry-request
        (clojure.core/nth args4429 0)))))))
  (clojure.core/defn
   create-network-acl-entry-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         protocol
                         sdk-request-timeout
                         network-acl-id
                         custom-query-parameters
                         rule-action
                         rule-number
                         read-limit
                         general-progress-listener
                         egress
                         icmp-type-code
                         port-range
                         clone-source
                         cidr-block
                         clone-root]}]]),
    :doc "Generate map for createNetworkAclEntry"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-network-acl-entry,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-network-acl-entry
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         protocol
                         sdk-request-timeout
                         network-acl-id
                         custom-query-parameters
                         rule-action
                         rule-number
                         read-limit
                         general-progress-listener
                         egress
                         icmp-type-code
                         port-range
                         clone-source
                         cidr-block
                         clone-root]}]]),
    :doc "Call createNetworkAclEntry"}
   [credentials4432 & args4433]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4434
     (com.palletops.awaze.common/aws-client :ec2 credentials4432)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4434
      createNetworkAclEntry
      (ec2/create-network-acl-entry-request
       (clojure.core/nth args4433 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-nat-gateways
   [m4435]
   (clojure.core/let
    [credentials4436 (:credentials m4435) args4437 (:args m4435)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4438
      (com.palletops.awaze.common/aws-client :ec2 credentials4436)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4438
       describeNatGateways
       (ec2/describe-nat-gateways-request
        (clojure.core/nth args4437 0)))))))
  (clojure.core/defn
   describe-nat-gateways-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         filter
                         read-limit
                         general-progress-listener
                         clone-source
                         nat-gateway-ids
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeNatGateways"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-nat-gateways,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-nat-gateways
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         filter
                         read-limit
                         general-progress-listener
                         clone-source
                         nat-gateway-ids
                         clone-root
                         next-token]}]]),
    :doc "Call describeNatGateways"}
   [credentials4440 & args4441]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4442
     (com.palletops.awaze.common/aws-client :ec2 credentials4440)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4442
      describeNatGateways
      (ec2/describe-nat-gateways-request
       (clojure.core/nth args4441 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :cancel-reserved-instances-listing
   [m4443]
   (clojure.core/let
    [credentials4444 (:credentials m4443) args4445 (:args m4443)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4446
      (com.palletops.awaze.common/aws-client :ec2 credentials4444)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4446
       cancelReservedInstancesListing
       (ec2/cancel-reserved-instances-listing-request
        (clojure.core/nth args4445 0)))))))
  (clojure.core/defn
   cancel-reserved-instances-listing-map
   {:arglists (quote
               [[credentials
                 {:keys [reserved-instances-listing-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for cancelReservedInstancesListing"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :cancel-reserved-instances-listing,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   cancel-reserved-instances-listing
   {:arglists (quote
               [[credentials
                 {:keys [reserved-instances-listing-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call cancelReservedInstancesListing"}
   [credentials4448 & args4449]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4450
     (com.palletops.awaze.common/aws-client :ec2 credentials4448)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4450
      cancelReservedInstancesListing
      (ec2/cancel-reserved-instances-listing-request
       (clojure.core/nth args4449 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :disable-vpc-classic-link
   [m4451]
   (clojure.core/let
    [credentials4452 (:credentials m4451) args4453 (:args m4451)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4454
      (com.palletops.awaze.common/aws-client :ec2 credentials4452)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4454
       disableVpcClassicLink
       (ec2/disable-vpc-classic-link-request
        (clojure.core/nth args4453 0)))))))
  (clojure.core/defn
   disable-vpc-classic-link-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for disableVpcClassicLink"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :disable-vpc-classic-link,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   disable-vpc-classic-link
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call disableVpcClassicLink"}
   [credentials4456 & args4457]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4458
     (com.palletops.awaze.common/aws-client :ec2 credentials4456)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4458
      disableVpcClassicLink
      (ec2/disable-vpc-classic-link-request
       (clojure.core/nth args4457 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :run-scheduled-instances
   [m4459]
   (clojure.core/let
    [credentials4460 (:credentials m4459) args4461 (:args m4459)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4462
      (com.palletops.awaze.common/aws-client :ec2 credentials4460)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4462
       runScheduledInstances
       (ec2/run-scheduled-instances-request
        (clojure.core/nth args4461 0)))))))
  (clojure.core/defn
   run-scheduled-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-count
                         read-limit
                         general-progress-listener
                         scheduled-instance-id
                         clone-source
                         launch-specification
                         client-token
                         clone-root]}]]),
    :doc "Generate map for runScheduledInstances"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :run-scheduled-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   run-scheduled-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-count
                         read-limit
                         general-progress-listener
                         scheduled-instance-id
                         clone-source
                         launch-specification
                         client-token
                         clone-root]}]]),
    :doc "Call runScheduledInstances"}
   [credentials4464 & args4465]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4466
     (com.palletops.awaze.common/aws-client :ec2 credentials4464)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4466
      runScheduledInstances
      (ec2/run-scheduled-instances-request
       (clojure.core/nth args4465 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-key-pair
   [m4467]
   (clojure.core/let
    [credentials4468 (:credentials m4467) args4469 (:args m4467)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4470
      (com.palletops.awaze.common/aws-client :ec2 credentials4468)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4470
       deleteKeyPair
       (ec2/delete-key-pair-request (clojure.core/nth args4469 0)))))))
  (clojure.core/defn
   delete-key-pair-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteKeyPair"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-key-pair,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-key-pair
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteKeyPair"}
   [credentials4472 & args4473]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4474
     (com.palletops.awaze.common/aws-client :ec2 credentials4472)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4474
      deleteKeyPair
      (ec2/delete-key-pair-request (clojure.core/nth args4473 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-reserved-instances
   [m4475]
   (clojure.core/let
    [credentials4476 (:credentials m4475) args4477 (:args m4475)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4478
      (com.palletops.awaze.common/aws-client :ec2 credentials4476)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4478
       modifyReservedInstances
       (ec2/modify-reserved-instances-request
        (clojure.core/nth args4477 0)))))))
  (clojure.core/defn
   modify-reserved-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         target-configurations
                         custom-query-parameters
                         read-limit
                         reserved-instances-ids
                         general-progress-listener
                         clone-source
                         client-token
                         clone-root]}]]),
    :doc "Generate map for modifyReservedInstances"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-reserved-instances,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-reserved-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         target-configurations
                         custom-query-parameters
                         read-limit
                         reserved-instances-ids
                         general-progress-listener
                         clone-source
                         client-token
                         clone-root]}]]),
    :doc "Call modifyReservedInstances"}
   [credentials4480 & args4481]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4482
     (com.palletops.awaze.common/aws-client :ec2 credentials4480)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4482
      modifyReservedInstances
      (ec2/modify-reserved-instances-request
       (clojure.core/nth args4481 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-vpn-connection-route
   [m4483]
   (clojure.core/let
    [credentials4484 (:credentials m4483) args4485 (:args m4483)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4486
      (com.palletops.awaze.common/aws-client :ec2 credentials4484)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4486
       deleteVpnConnectionRoute
       (ec2/delete-vpn-connection-route-request
        (clojure.core/nth args4485 0)))))))
  (clojure.core/defn
   delete-vpn-connection-route-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         destination-cidr-block
                         sdk-request-timeout
                         vpn-connection-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteVpnConnectionRoute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-vpn-connection-route,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-vpn-connection-route
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         destination-cidr-block
                         sdk-request-timeout
                         vpn-connection-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteVpnConnectionRoute"}
   [credentials4488 & args4489]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4490
     (com.palletops.awaze.common/aws-client :ec2 credentials4488)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4490
      deleteVpnConnectionRoute
      (ec2/delete-vpn-connection-route-request
       (clojure.core/nth args4489 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :attach-internet-gateway
   [m4491]
   (clojure.core/let
    [credentials4492 (:credentials m4491) args4493 (:args m4491)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4494
      (com.palletops.awaze.common/aws-client :ec2 credentials4492)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4494
       attachInternetGateway
       (ec2/attach-internet-gateway-request
        (clojure.core/nth args4493 0)))))))
  (clojure.core/defn
   attach-internet-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         internet-gateway-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for attachInternetGateway"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :attach-internet-gateway,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   attach-internet-gateway
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         vpc-id
                         read-limit
                         general-progress-listener
                         internet-gateway-id
                         clone-source
                         clone-root]}]]),
    :doc "Call attachInternetGateway"}
   [credentials4496 & args4497]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4498
     (com.palletops.awaze.common/aws-client :ec2 credentials4496)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4498
      attachInternetGateway
      (ec2/attach-internet-gateway-request
       (clojure.core/nth args4497 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-network-interface-attribute
   [m4499]
   (clojure.core/let
    [credentials4500 (:credentials m4499) args4501 (:args m4499)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4502
      (com.palletops.awaze.common/aws-client :ec2 credentials4500)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4502
       modifyNetworkInterfaceAttribute
       (ec2/modify-network-interface-attribute-request
        (clojure.core/nth args4501 0)))))))
  (clojure.core/defn
   modify-network-interface-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         source-dest-check
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         clone-source
                         groups
                         clone-root
                         attachment]}]]),
    :doc "Generate map for modifyNetworkInterfaceAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-network-interface-attribute,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-network-interface-attribute
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         source-dest-check
                         sdk-request-timeout
                         custom-query-parameters
                         network-interface-id
                         read-limit
                         general-progress-listener
                         clone-source
                         groups
                         clone-root
                         attachment]}]]),
    :doc "Call modifyNetworkInterfaceAttribute"}
   [credentials4504 & args4505]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4506
     (com.palletops.awaze.common/aws-client :ec2 credentials4504)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4506
      modifyNetworkInterfaceAttribute
      (ec2/modify-network-interface-attribute-request
       (clojure.core/nth args4505 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :enable-vgw-route-propagation
   [m4507]
   (clojure.core/let
    [credentials4508 (:credentials m4507) args4509 (:args m4507)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4510
      (com.palletops.awaze.common/aws-client :ec2 credentials4508)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4510
       enableVgwRoutePropagation
       (ec2/enable-vgw-route-propagation-request
        (clojure.core/nth args4509 0)))))))
  (clojure.core/defn
   enable-vgw-route-propagation-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-id
                         route-table-id
                         clone-root]}]]),
    :doc "Generate map for enableVgwRoutePropagation"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :enable-vgw-route-propagation,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   enable-vgw-route-propagation
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         gateway-id
                         route-table-id
                         clone-root]}]]),
    :doc "Call enableVgwRoutePropagation"}
   [credentials4512 & args4513]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4514
     (com.palletops.awaze.common/aws-client :ec2 credentials4512)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4514
      enableVgwRoutePropagation
      (ec2/enable-vgw-route-propagation-request
       (clojure.core/nth args4513 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-network-acl-entry
   [m4515]
   (clojure.core/let
    [credentials4516 (:credentials m4515) args4517 (:args m4515)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4518
      (com.palletops.awaze.common/aws-client :ec2 credentials4516)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4518
       deleteNetworkAclEntry
       (ec2/delete-network-acl-entry-request
        (clojure.core/nth args4517 0)))))))
  (clojure.core/defn
   delete-network-acl-entry-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         network-acl-id
                         custom-query-parameters
                         rule-number
                         read-limit
                         general-progress-listener
                         egress
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteNetworkAclEntry"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-network-acl-entry,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   delete-network-acl-entry
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         network-acl-id
                         custom-query-parameters
                         rule-number
                         read-limit
                         general-progress-listener
                         egress
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteNetworkAclEntry"}
   [credentials4520 & args4521]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4522
     (com.palletops.awaze.common/aws-client :ec2 credentials4520)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4522
      deleteNetworkAclEntry
      (ec2/delete-network-acl-entry-request
       (clojure.core/nth args4521 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :cancel-export-task
   [m4523]
   (clojure.core/let
    [credentials4524 (:credentials m4523) args4525 (:args m4523)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4526
      (com.palletops.awaze.common/aws-client :ec2 credentials4524)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4526
       cancelExportTask
       (ec2/cancel-export-task-request (clojure.core/nth args4525 0)))))))
  (clojure.core/defn
   cancel-export-task-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         export-task-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for cancelExportTask"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :cancel-export-task,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   cancel-export-task
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         export-task-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call cancelExportTask"}
   [credentials4528 & args4529]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4530
     (com.palletops.awaze.common/aws-client :ec2 credentials4528)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4530
      cancelExportTask
      (ec2/cancel-export-task-request (clojure.core/nth args4529 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-image
   [m4531]
   (clojure.core/let
    [credentials4532 (:credentials m4531) args4533 (:args m4531)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4534
      (com.palletops.awaze.common/aws-client :ec2 credentials4532)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4534
       createImage
       (ec2/create-image-request (clojure.core/nth args4533 0)))))))
  (clojure.core/defn
   create-image-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         no-reboot
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         block-device-mappings
                         clone-root]}]]),
    :doc "Generate map for createImage"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-image,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   create-image
   {:arglists (quote
               [[credentials
                 {:keys [description
                         no-reboot
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         block-device-mappings
                         clone-root]}]]),
    :doc "Call createImage"}
   [credentials4536 & args4537]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4538
     (com.palletops.awaze.common/aws-client :ec2 credentials4536)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4538
      createImage
      (ec2/create-image-request (clojure.core/nth args4537 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-spot-fleet-request
   [m4539]
   (clojure.core/let
    [credentials4540 (:credentials m4539) args4541 (:args m4539)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4542
      (com.palletops.awaze.common/aws-client :ec2 credentials4540)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4542
       modifySpotFleetRequest
       (ec2/modify-spot-fleet-request-request
        (clojure.core/nth args4541 0)))))))
  (clojure.core/defn
   modify-spot-fleet-request-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         target-capacity
                         spot-fleet-request-id
                         clone-source
                         clone-root
                         excess-capacity-termination-policy]}]]),
    :doc "Generate map for modifySpotFleetRequest"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-spot-fleet-request,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   modify-spot-fleet-request
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         target-capacity
                         spot-fleet-request-id
                         clone-source
                         clone-root
                         excess-capacity-termination-policy]}]]),
    :doc "Call modifySpotFleetRequest"}
   [credentials4544 & args4545]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4546
     (com.palletops.awaze.common/aws-client :ec2 credentials4544)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4546
      modifySpotFleetRequest
      (ec2/modify-spot-fleet-request-request
       (clojure.core/nth args4545 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-import-snapshot-tasks
   [m4547]
   (clojure.core/let
    [credentials4548 (:credentials m4547) args4549 (:args m4547)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client4550
      (com.palletops.awaze.common/aws-client :ec2 credentials4548)]
     (clojure.core/case
      (clojure.core/count args4549)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4550
        describeImportSnapshotTasks
        (ec2/describe-import-snapshot-tasks-request
         (clojure.core/nth args4549 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4550
        describeImportSnapshotTasks))))))
  (clojure.core/defn
   describe-import-snapshot-tasks-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         import-task-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeImportSnapshotTasks, describeImportSnapshotTasks"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-import-snapshot-tasks,
     :credentials credentials__1842__auto__,
     :client :ec2})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-import-snapshot-tasks,
     :credentials credentials__1842__auto__,
     :client :ec2}))
  (clojure.core/defn
   describe-import-snapshot-tasks
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         import-task-ids
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call describeImportSnapshotTasks, describeImportSnapshotTasks"}
   [credentials4552 & args4553]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client4554
     (com.palletops.awaze.common/aws-client :ec2 credentials4552)]
    (clojure.core/case
     (clojure.core/count args4553)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4554
       describeImportSnapshotTasks
       (ec2/describe-import-snapshot-tasks-request
        (clojure.core/nth args4553 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client4554
       describeImportSnapshotTasks)))))))
