(ns
 com.palletops.awaze.directconnect
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.directconnect :as directconnect]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :directconnect
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.directconnect.AmazonDirectConnectClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.RouteFilterPrefix}
route-filter-prefix
  [m11746]
  (clojure.core/let
   [bean11745
    (new com.amazonaws.services.directconnect.model.RouteFilterPrefix)]
   (clojure.core/let
    [v11747 (:cidr m11746 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11747 :com.palletops.awaze.client-builder/undef)
     (. bean11745 setCidr (clojure.core/str v11747))))
   bean11745))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.NewPrivateVirtualInterfaceAllocation}
new-private-virtual-interface-allocation
  [m11749]
  (clojure.core/let
   [bean11748
    (new
     com.amazonaws.services.directconnect.model.NewPrivateVirtualInterfaceAllocation)]
   (clojure.core/let
    [v11750 (:vlan m11749 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11750 :com.palletops.awaze.client-builder/undef)
     (. bean11748 setVlan (clojure.core/int v11750))))
   (clojure.core/let
    [v11750
     (:virtual-interface-name
      m11749
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11750 :com.palletops.awaze.client-builder/undef)
     (. bean11748 setVirtualInterfaceName (clojure.core/str v11750))))
   (clojure.core/let
    [v11750 (:asn m11749 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11750 :com.palletops.awaze.client-builder/undef)
     (. bean11748 setAsn (clojure.core/int v11750))))
   (clojure.core/let
    [v11750
     (:auth-key m11749 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11750 :com.palletops.awaze.client-builder/undef)
     (. bean11748 setAuthKey (clojure.core/str v11750))))
   (clojure.core/let
    [v11750
     (:amazon-address
      m11749
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11750 :com.palletops.awaze.client-builder/undef)
     (. bean11748 setAmazonAddress (clojure.core/str v11750))))
   (clojure.core/let
    [v11750
     (:customer-address
      m11749
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11750 :com.palletops.awaze.client-builder/undef)
     (. bean11748 setCustomerAddress (clojure.core/str v11750))))
   bean11748))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.NewPublicVirtualInterfaceAllocation}
new-public-virtual-interface-allocation
  [m11752]
  (clojure.core/let
   [bean11751
    (new
     com.amazonaws.services.directconnect.model.NewPublicVirtualInterfaceAllocation)]
   (clojure.core/let
    [v11753 (:vlan m11752 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11753 :com.palletops.awaze.client-builder/undef)
     (. bean11751 setVlan (clojure.core/int v11753))))
   (clojure.core/let
    [v11753
     (:virtual-interface-name
      m11752
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11753 :com.palletops.awaze.client-builder/undef)
     (. bean11751 setVirtualInterfaceName (clojure.core/str v11753))))
   (clojure.core/let
    [v11753 (:asn m11752 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11753 :com.palletops.awaze.client-builder/undef)
     (. bean11751 setAsn (clojure.core/int v11753))))
   (clojure.core/let
    [v11753
     (:auth-key m11752 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11753 :com.palletops.awaze.client-builder/undef)
     (. bean11751 setAuthKey (clojure.core/str v11753))))
   (clojure.core/let
    [v11753
     (:amazon-address
      m11752
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11753 :com.palletops.awaze.client-builder/undef)
     (. bean11751 setAmazonAddress (clojure.core/str v11753))))
   (clojure.core/let
    [v11753
     (:customer-address
      m11752
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11753 :com.palletops.awaze.client-builder/undef)
     (. bean11751 setCustomerAddress (clojure.core/str v11753))))
   (clojure.core/let
    [v11753
     (:route-filter-prefixes
      m11752
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11753 :com.palletops.awaze.client-builder/undef)
     (.
      bean11751
      setRouteFilterPrefixes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg11817]
  (directconnect/route-filter-prefix arg11817))
 v11753))))
   bean11751))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.NewPrivateVirtualInterface}
new-private-virtual-interface
  [m11755]
  (clojure.core/let
   [bean11754
    (new
     com.amazonaws.services.directconnect.model.NewPrivateVirtualInterface)]
   (clojure.core/let
    [v11756 (:vlan m11755 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11756 :com.palletops.awaze.client-builder/undef)
     (. bean11754 setVlan (clojure.core/int v11756))))
   (clojure.core/let
    [v11756
     (:virtual-gateway-id
      m11755
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11756 :com.palletops.awaze.client-builder/undef)
     (. bean11754 setVirtualGatewayId (clojure.core/str v11756))))
   (clojure.core/let
    [v11756
     (:virtual-interface-name
      m11755
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11756 :com.palletops.awaze.client-builder/undef)
     (. bean11754 setVirtualInterfaceName (clojure.core/str v11756))))
   (clojure.core/let
    [v11756 (:asn m11755 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11756 :com.palletops.awaze.client-builder/undef)
     (. bean11754 setAsn (clojure.core/int v11756))))
   (clojure.core/let
    [v11756
     (:auth-key m11755 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11756 :com.palletops.awaze.client-builder/undef)
     (. bean11754 setAuthKey (clojure.core/str v11756))))
   (clojure.core/let
    [v11756
     (:amazon-address
      m11755
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11756 :com.palletops.awaze.client-builder/undef)
     (. bean11754 setAmazonAddress (clojure.core/str v11756))))
   (clojure.core/let
    [v11756
     (:customer-address
      m11755
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11756 :com.palletops.awaze.client-builder/undef)
     (. bean11754 setCustomerAddress (clojure.core/str v11756))))
   bean11754))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.NewPublicVirtualInterface}
new-public-virtual-interface
  [m11758]
  (clojure.core/let
   [bean11757
    (new
     com.amazonaws.services.directconnect.model.NewPublicVirtualInterface)]
   (clojure.core/let
    [v11759 (:vlan m11758 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11759 :com.palletops.awaze.client-builder/undef)
     (. bean11757 setVlan (clojure.core/int v11759))))
   (clojure.core/let
    [v11759
     (:virtual-interface-name
      m11758
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11759 :com.palletops.awaze.client-builder/undef)
     (. bean11757 setVirtualInterfaceName (clojure.core/str v11759))))
   (clojure.core/let
    [v11759 (:asn m11758 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11759 :com.palletops.awaze.client-builder/undef)
     (. bean11757 setAsn (clojure.core/int v11759))))
   (clojure.core/let
    [v11759
     (:auth-key m11758 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11759 :com.palletops.awaze.client-builder/undef)
     (. bean11757 setAuthKey (clojure.core/str v11759))))
   (clojure.core/let
    [v11759
     (:amazon-address
      m11758
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11759 :com.palletops.awaze.client-builder/undef)
     (. bean11757 setAmazonAddress (clojure.core/str v11759))))
   (clojure.core/let
    [v11759
     (:customer-address
      m11758
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11759 :com.palletops.awaze.client-builder/undef)
     (. bean11757 setCustomerAddress (clojure.core/str v11759))))
   (clojure.core/let
    [v11759
     (:route-filter-prefixes
      m11758
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11759 :com.palletops.awaze.client-builder/undef)
     (.
      bean11757
      setRouteFilterPrefixes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg11818]
  (directconnect/route-filter-prefix arg11818))
 v11759))))
   bean11757))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DescribeConnectionsOnInterconnectRequest}
describe-connections-on-interconnect-request
  [m11761]
  (clojure.core/let
   [bean11760
    (new
     com.amazonaws.services.directconnect.model.DescribeConnectionsOnInterconnectRequest)]
   (clojure.core/let
    [v11762
     (:interconnect-id
      m11761
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11762 :com.palletops.awaze.client-builder/undef)
     (. bean11760 setInterconnectId (clojure.core/str v11762))))
   bean11760))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.AllocatePrivateVirtualInterfaceRequest}
allocate-private-virtual-interface-request
  [m11764]
  (clojure.core/let
   [bean11763
    (new
     com.amazonaws.services.directconnect.model.AllocatePrivateVirtualInterfaceRequest)]
   (clojure.core/let
    [v11765
     (:connection-id m11764 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11765 :com.palletops.awaze.client-builder/undef)
     (. bean11763 setConnectionId (clojure.core/str v11765))))
   (clojure.core/let
    [v11765
     (:new-private-virtual-interface-allocation
      m11764
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11765 :com.palletops.awaze.client-builder/undef)
     (.
      bean11763
      setNewPrivateVirtualInterfaceAllocation
      (directconnect/new-private-virtual-interface-allocation v11765))))
   (clojure.core/let
    [v11765
     (:owner-account m11764 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11765 :com.palletops.awaze.client-builder/undef)
     (. bean11763 setOwnerAccount (clojure.core/str v11765))))
   bean11763))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DescribeVirtualInterfacesRequest}
describe-virtual-interfaces-request
  [m11767]
  (clojure.core/let
   [bean11766
    (new
     com.amazonaws.services.directconnect.model.DescribeVirtualInterfacesRequest)]
   (clojure.core/let
    [v11768
     (:connection-id m11767 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11768 :com.palletops.awaze.client-builder/undef)
     (. bean11766 setConnectionId (clojure.core/str v11768))))
   (clojure.core/let
    [v11768
     (:virtual-interface-id
      m11767
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11768 :com.palletops.awaze.client-builder/undef)
     (. bean11766 setVirtualInterfaceId (clojure.core/str v11768))))
   bean11766))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.AllocatePublicVirtualInterfaceRequest}
allocate-public-virtual-interface-request
  [m11770]
  (clojure.core/let
   [bean11769
    (new
     com.amazonaws.services.directconnect.model.AllocatePublicVirtualInterfaceRequest)]
   (clojure.core/let
    [v11771
     (:connection-id m11770 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11771 :com.palletops.awaze.client-builder/undef)
     (. bean11769 setConnectionId (clojure.core/str v11771))))
   (clojure.core/let
    [v11771
     (:new-public-virtual-interface-allocation
      m11770
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11771 :com.palletops.awaze.client-builder/undef)
     (.
      bean11769
      setNewPublicVirtualInterfaceAllocation
      (directconnect/new-public-virtual-interface-allocation v11771))))
   (clojure.core/let
    [v11771
     (:owner-account m11770 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11771 :com.palletops.awaze.client-builder/undef)
     (. bean11769 setOwnerAccount (clojure.core/str v11771))))
   bean11769))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DescribeInterconnectsRequest}
describe-interconnects-request
  [m11773]
  (clojure.core/let
   [bean11772
    (new
     com.amazonaws.services.directconnect.model.DescribeInterconnectsRequest)]
   (clojure.core/let
    [v11774
     (:interconnect-id
      m11773
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11774 :com.palletops.awaze.client-builder/undef)
     (. bean11772 setInterconnectId (clojure.core/str v11774))))
   bean11772))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DeleteVirtualInterfaceRequest}
delete-virtual-interface-request
  [m11776]
  (clojure.core/let
   [bean11775
    (new
     com.amazonaws.services.directconnect.model.DeleteVirtualInterfaceRequest)]
   (clojure.core/let
    [v11777
     (:virtual-interface-id
      m11776
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11777 :com.palletops.awaze.client-builder/undef)
     (. bean11775 setVirtualInterfaceId (clojure.core/str v11777))))
   bean11775))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DescribeLocationsRequest}
describe-locations-request
  [m11779]
  (clojure.core/let
   [bean11778
    (new
     com.amazonaws.services.directconnect.model.DescribeLocationsRequest)]
   bean11778))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.AllocateConnectionOnInterconnectRequest}
allocate-connection-on-interconnect-request
  [m11782]
  (clojure.core/let
   [bean11781
    (new
     com.amazonaws.services.directconnect.model.AllocateConnectionOnInterconnectRequest)]
   (clojure.core/let
    [v11783
     (:bandwidth m11782 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11783 :com.palletops.awaze.client-builder/undef)
     (. bean11781 setBandwidth (clojure.core/str v11783))))
   (clojure.core/let
    [v11783
     (:connection-name
      m11782
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11783 :com.palletops.awaze.client-builder/undef)
     (. bean11781 setConnectionName (clojure.core/str v11783))))
   (clojure.core/let
    [v11783
     (:interconnect-id
      m11782
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11783 :com.palletops.awaze.client-builder/undef)
     (. bean11781 setInterconnectId (clojure.core/str v11783))))
   (clojure.core/let
    [v11783 (:vlan m11782 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11783 :com.palletops.awaze.client-builder/undef)
     (. bean11781 setVlan (clojure.core/int v11783))))
   (clojure.core/let
    [v11783
     (:owner-account m11782 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11783 :com.palletops.awaze.client-builder/undef)
     (. bean11781 setOwnerAccount (clojure.core/str v11783))))
   bean11781))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.CreateInterconnectRequest}
create-interconnect-request
  [m11785]
  (clojure.core/let
   [bean11784
    (new
     com.amazonaws.services.directconnect.model.CreateInterconnectRequest)]
   (clojure.core/let
    [v11786
     (:bandwidth m11785 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11786 :com.palletops.awaze.client-builder/undef)
     (. bean11784 setBandwidth (clojure.core/str v11786))))
   (clojure.core/let
    [v11786
     (:interconnect-name
      m11785
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11786 :com.palletops.awaze.client-builder/undef)
     (. bean11784 setInterconnectName (clojure.core/str v11786))))
   (clojure.core/let
    [v11786
     (:location m11785 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11786 :com.palletops.awaze.client-builder/undef)
     (. bean11784 setLocation (clojure.core/str v11786))))
   bean11784))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DeleteConnectionRequest}
delete-connection-request
  [m11788]
  (clojure.core/let
   [bean11787
    (new
     com.amazonaws.services.directconnect.model.DeleteConnectionRequest)]
   (clojure.core/let
    [v11789
     (:connection-id m11788 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11789 :com.palletops.awaze.client-builder/undef)
     (. bean11787 setConnectionId (clojure.core/str v11789))))
   bean11787))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.CreatePrivateVirtualInterfaceRequest}
create-private-virtual-interface-request
  [m11791]
  (clojure.core/let
   [bean11790
    (new
     com.amazonaws.services.directconnect.model.CreatePrivateVirtualInterfaceRequest)]
   (clojure.core/let
    [v11792
     (:connection-id m11791 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11792 :com.palletops.awaze.client-builder/undef)
     (. bean11790 setConnectionId (clojure.core/str v11792))))
   (clojure.core/let
    [v11792
     (:new-private-virtual-interface
      m11791
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11792 :com.palletops.awaze.client-builder/undef)
     (.
      bean11790
      setNewPrivateVirtualInterface
      (directconnect/new-private-virtual-interface v11792))))
   bean11790))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DeleteInterconnectRequest}
delete-interconnect-request
  [m11794]
  (clojure.core/let
   [bean11793
    (new
     com.amazonaws.services.directconnect.model.DeleteInterconnectRequest)]
   (clojure.core/let
    [v11795
     (:interconnect-id
      m11794
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11795 :com.palletops.awaze.client-builder/undef)
     (. bean11793 setInterconnectId (clojure.core/str v11795))))
   bean11793))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.CreatePublicVirtualInterfaceRequest}
create-public-virtual-interface-request
  [m11797]
  (clojure.core/let
   [bean11796
    (new
     com.amazonaws.services.directconnect.model.CreatePublicVirtualInterfaceRequest)]
   (clojure.core/let
    [v11798
     (:connection-id m11797 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11798 :com.palletops.awaze.client-builder/undef)
     (. bean11796 setConnectionId (clojure.core/str v11798))))
   (clojure.core/let
    [v11798
     (:new-public-virtual-interface
      m11797
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11798 :com.palletops.awaze.client-builder/undef)
     (.
      bean11796
      setNewPublicVirtualInterface
      (directconnect/new-public-virtual-interface v11798))))
   bean11796))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.CreateConnectionRequest}
create-connection-request
  [m11800]
  (clojure.core/let
   [bean11799
    (new
     com.amazonaws.services.directconnect.model.CreateConnectionRequest)]
   (clojure.core/let
    [v11801
     (:bandwidth m11800 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11801 :com.palletops.awaze.client-builder/undef)
     (. bean11799 setBandwidth (clojure.core/str v11801))))
   (clojure.core/let
    [v11801
     (:connection-name
      m11800
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11801 :com.palletops.awaze.client-builder/undef)
     (. bean11799 setConnectionName (clojure.core/str v11801))))
   (clojure.core/let
    [v11801
     (:location m11800 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11801 :com.palletops.awaze.client-builder/undef)
     (. bean11799 setLocation (clojure.core/str v11801))))
   bean11799))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.ConfirmConnectionRequest}
confirm-connection-request
  [m11803]
  (clojure.core/let
   [bean11802
    (new
     com.amazonaws.services.directconnect.model.ConfirmConnectionRequest)]
   (clojure.core/let
    [v11804
     (:connection-id m11803 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11804 :com.palletops.awaze.client-builder/undef)
     (. bean11802 setConnectionId (clojure.core/str v11804))))
   bean11802))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DescribeVirtualGatewaysRequest}
describe-virtual-gateways-request
  [m11806]
  (clojure.core/let
   [bean11805
    (new
     com.amazonaws.services.directconnect.model.DescribeVirtualGatewaysRequest)]
   bean11805))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DescribeConnectionsRequest}
describe-connections-request
  [m11809]
  (clojure.core/let
   [bean11808
    (new
     com.amazonaws.services.directconnect.model.DescribeConnectionsRequest)]
   (clojure.core/let
    [v11810
     (:connection-id m11809 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11810 :com.palletops.awaze.client-builder/undef)
     (. bean11808 setConnectionId (clojure.core/str v11810))))
   bean11808))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.ConfirmPublicVirtualInterfaceRequest}
confirm-public-virtual-interface-request
  [m11812]
  (clojure.core/let
   [bean11811
    (new
     com.amazonaws.services.directconnect.model.ConfirmPublicVirtualInterfaceRequest)]
   (clojure.core/let
    [v11813
     (:virtual-interface-id
      m11812
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11813 :com.palletops.awaze.client-builder/undef)
     (. bean11811 setVirtualInterfaceId (clojure.core/str v11813))))
   bean11811))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.ConfirmPrivateVirtualInterfaceRequest}
confirm-private-virtual-interface-request
  [m11815]
  (clojure.core/let
   [bean11814
    (new
     com.amazonaws.services.directconnect.model.ConfirmPrivateVirtualInterfaceRequest)]
   (clojure.core/let
    [v11816
     (:virtual-interface-id
      m11815
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11816 :com.palletops.awaze.client-builder/undef)
     (. bean11814 setVirtualInterfaceId (clojure.core/str v11816))))
   (clojure.core/let
    [v11816
     (:virtual-gateway-id
      m11815
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11816 :com.palletops.awaze.client-builder/undef)
     (. bean11814 setVirtualGatewayId (clojure.core/str v11816))))
   bean11814))
 (clojure.core/defmulti
  directconnect
  (clojure.core/fn
   directconnect
   [m__1874__auto__]
   (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   directconnect
   :describe-connections-on-interconnect
   [m11819]
   (clojure.core/let
    [credentials11820 (:credentials m11819) args11821 (:args m11819)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11822
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11820)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11822
       describeConnectionsOnInterconnect
       (directconnect/describe-connections-on-interconnect-request
        (clojure.core/nth args11821 0)))))))
  (clojure.core/defn
   describe-connections-on-interconnect-map
   {:arglists (quote
               [[credentials
                 {:keys [interconnect-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeConnectionsOnInterconnect"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-connections-on-interconnect,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   describe-connections-on-interconnect
   {:arglists (quote
               [[credentials
                 {:keys [interconnect-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeConnectionsOnInterconnect"}
   [credentials11824 & args11825]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11826
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11824)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11826
      describeConnectionsOnInterconnect
      (directconnect/describe-connections-on-interconnect-request
       (clojure.core/nth args11825 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :allocate-private-virtual-interface
   [m11827]
   (clojure.core/let
    [credentials11828 (:credentials m11827) args11829 (:args m11827)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11830
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11828)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11830
       allocatePrivateVirtualInterface
       (directconnect/allocate-private-virtual-interface-request
        (clojure.core/nth args11829 0)))))))
  (clojure.core/defn
   allocate-private-virtual-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         owner-account
                         connection-id
                         clone-source
                         clone-root
                         new-private-virtual-interface-allocation]}]]),
    :doc "Generate map for allocatePrivateVirtualInterface"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :allocate-private-virtual-interface,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   allocate-private-virtual-interface
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         owner-account
                         connection-id
                         clone-source
                         clone-root
                         new-private-virtual-interface-allocation]}]]),
    :doc "Call allocatePrivateVirtualInterface"}
   [credentials11832 & args11833]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11834
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11832)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11834
      allocatePrivateVirtualInterface
      (directconnect/allocate-private-virtual-interface-request
       (clojure.core/nth args11833 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :describe-virtual-interfaces
   [m11835]
   (clojure.core/let
    [credentials11836 (:credentials m11835) args11837 (:args m11835)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11838
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11836)]
     (clojure.core/case
      (clojure.core/count args11837)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11838
        describeVirtualInterfaces
        (directconnect/describe-virtual-interfaces-request
         (clojure.core/nth args11837 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11838
        describeVirtualInterfaces))))))
  (clojure.core/defn
   describe-virtual-interfaces-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         connection-id
                         virtual-interface-id
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeVirtualInterfaces, describeVirtualInterfaces"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-virtual-interfaces,
     :credentials credentials__1842__auto__,
     :client :directconnect})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-virtual-interfaces,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   describe-virtual-interfaces
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         connection-id
                         virtual-interface-id
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeVirtualInterfaces, describeVirtualInterfaces"}
   [credentials11840 & args11841]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11842
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11840)]
    (clojure.core/case
     (clojure.core/count args11841)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11842
       describeVirtualInterfaces
       (directconnect/describe-virtual-interfaces-request
        (clojure.core/nth args11841 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11842
       describeVirtualInterfaces))))))
 (do
  (clojure.core/defmethod
   directconnect
   :allocate-public-virtual-interface
   [m11843]
   (clojure.core/let
    [credentials11844 (:credentials m11843) args11845 (:args m11843)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11846
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11844)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11846
       allocatePublicVirtualInterface
       (directconnect/allocate-public-virtual-interface-request
        (clojure.core/nth args11845 0)))))))
  (clojure.core/defn
   allocate-public-virtual-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         new-public-virtual-interface-allocation
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         owner-account
                         connection-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for allocatePublicVirtualInterface"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :allocate-public-virtual-interface,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   allocate-public-virtual-interface
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         new-public-virtual-interface-allocation
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         owner-account
                         connection-id
                         clone-source
                         clone-root]}]]),
    :doc "Call allocatePublicVirtualInterface"}
   [credentials11848 & args11849]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11850
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11848)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11850
      allocatePublicVirtualInterface
      (directconnect/allocate-public-virtual-interface-request
       (clojure.core/nth args11849 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :describe-interconnects
   [m11851]
   (clojure.core/let
    [credentials11852 (:credentials m11851) args11853 (:args m11851)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11854
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11852)]
     (clojure.core/case
      (clojure.core/count args11853)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11854
        describeInterconnects))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11854
        describeInterconnects
        (directconnect/describe-interconnects-request
         (clojure.core/nth args11853 0))))))))
  (clojure.core/defn
   describe-interconnects-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [interconnect-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeInterconnects, describeInterconnects"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-interconnects,
     :credentials credentials__1842__auto__,
     :client :directconnect})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-interconnects,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   describe-interconnects
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [interconnect-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeInterconnects, describeInterconnects"}
   [credentials11856 & args11857]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11858
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11856)]
    (clojure.core/case
     (clojure.core/count args11857)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11858
       describeInterconnects))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11858
       describeInterconnects
       (directconnect/describe-interconnects-request
        (clojure.core/nth args11857 0))))))))
 (do
  (clojure.core/defmethod
   directconnect
   :delete-virtual-interface
   [m11859]
   (clojure.core/let
    [credentials11860 (:credentials m11859) args11861 (:args m11859)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11862
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11860)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11862
       deleteVirtualInterface
       (directconnect/delete-virtual-interface-request
        (clojure.core/nth args11861 0)))))))
  (clojure.core/defn
   delete-virtual-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         virtual-interface-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteVirtualInterface"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-virtual-interface,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   delete-virtual-interface
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         virtual-interface-id
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteVirtualInterface"}
   [credentials11864 & args11865]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11866
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11864)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11866
      deleteVirtualInterface
      (directconnect/delete-virtual-interface-request
       (clojure.core/nth args11865 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :describe-locations
   [m11867]
   (clojure.core/let
    [credentials11868 (:credentials m11867) args11869 (:args m11867)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11870
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11868)]
     (clojure.core/case
      (clojure.core/count args11869)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11870
        describeLocations))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11870
        describeLocations
        (directconnect/describe-locations-request
         (clojure.core/nth args11869 0))))))))
  (clojure.core/defn
   describe-locations-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeLocations, describeLocations"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-locations,
     :credentials credentials__1842__auto__,
     :client :directconnect})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-locations,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   describe-locations
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeLocations, describeLocations"}
   [credentials11872 & args11873]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11874
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11872)]
    (clojure.core/case
     (clojure.core/count args11873)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11874
       describeLocations))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11874
       describeLocations
       (directconnect/describe-locations-request
        (clojure.core/nth args11873 0))))))))
 (do
  (clojure.core/defmethod
   directconnect
   :allocate-connection-on-interconnect
   [m11875]
   (clojure.core/let
    [credentials11876 (:credentials m11875) args11877 (:args m11875)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11878
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11876)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11878
       allocateConnectionOnInterconnect
       (directconnect/allocate-connection-on-interconnect-request
        (clojure.core/nth args11877 0)))))))
  (clojure.core/defn
   allocate-connection-on-interconnect-map
   {:arglists (quote
               [[credentials
                 {:keys [interconnect-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         bandwidth
                         read-limit
                         general-progress-listener
                         owner-account
                         vlan
                         clone-source
                         connection-name
                         clone-root]}]]),
    :doc "Generate map for allocateConnectionOnInterconnect"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :allocate-connection-on-interconnect,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   allocate-connection-on-interconnect
   {:arglists (quote
               [[credentials
                 {:keys [interconnect-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         bandwidth
                         read-limit
                         general-progress-listener
                         owner-account
                         vlan
                         clone-source
                         connection-name
                         clone-root]}]]),
    :doc "Call allocateConnectionOnInterconnect"}
   [credentials11880 & args11881]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11882
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11880)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11882
      allocateConnectionOnInterconnect
      (directconnect/allocate-connection-on-interconnect-request
       (clojure.core/nth args11881 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :create-interconnect
   [m11883]
   (clojure.core/let
    [credentials11884 (:credentials m11883) args11885 (:args m11883)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11886
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11884)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11886
       createInterconnect
       (directconnect/create-interconnect-request
        (clojure.core/nth args11885 0)))))))
  (clojure.core/defn
   create-interconnect-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         interconnect-name
                         bandwidth
                         read-limit
                         general-progress-listener
                         clone-source
                         location
                         clone-root]}]]),
    :doc "Generate map for createInterconnect"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-interconnect,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   create-interconnect
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         interconnect-name
                         bandwidth
                         read-limit
                         general-progress-listener
                         clone-source
                         location
                         clone-root]}]]),
    :doc "Call createInterconnect"}
   [credentials11888 & args11889]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11890
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11888)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11890
      createInterconnect
      (directconnect/create-interconnect-request
       (clojure.core/nth args11889 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :delete-connection
   [m11891]
   (clojure.core/let
    [credentials11892 (:credentials m11891) args11893 (:args m11891)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11894
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11892)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11894
       deleteConnection
       (directconnect/delete-connection-request
        (clojure.core/nth args11893 0)))))))
  (clojure.core/defn
   delete-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         connection-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteConnection"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-connection,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   delete-connection
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         connection-id
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteConnection"}
   [credentials11896 & args11897]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11898
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11896)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11898
      deleteConnection
      (directconnect/delete-connection-request
       (clojure.core/nth args11897 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :create-private-virtual-interface
   [m11899]
   (clojure.core/let
    [credentials11900 (:credentials m11899) args11901 (:args m11899)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11902
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11900)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11902
       createPrivateVirtualInterface
       (directconnect/create-private-virtual-interface-request
        (clojure.core/nth args11901 0)))))))
  (clojure.core/defn
   create-private-virtual-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         connection-id
                         clone-source
                         new-private-virtual-interface
                         clone-root]}]]),
    :doc "Generate map for createPrivateVirtualInterface"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-private-virtual-interface,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   create-private-virtual-interface
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         connection-id
                         clone-source
                         new-private-virtual-interface
                         clone-root]}]]),
    :doc "Call createPrivateVirtualInterface"}
   [credentials11904 & args11905]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11906
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11904)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11906
      createPrivateVirtualInterface
      (directconnect/create-private-virtual-interface-request
       (clojure.core/nth args11905 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :delete-interconnect
   [m11907]
   (clojure.core/let
    [credentials11908 (:credentials m11907) args11909 (:args m11907)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11910
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11908)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11910
       deleteInterconnect
       (directconnect/delete-interconnect-request
        (clojure.core/nth args11909 0)))))))
  (clojure.core/defn
   delete-interconnect-map
   {:arglists (quote
               [[credentials
                 {:keys [interconnect-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteInterconnect"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-interconnect,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   delete-interconnect
   {:arglists (quote
               [[credentials
                 {:keys [interconnect-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteInterconnect"}
   [credentials11912 & args11913]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11914
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11912)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11914
      deleteInterconnect
      (directconnect/delete-interconnect-request
       (clojure.core/nth args11913 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :create-public-virtual-interface
   [m11915]
   (clojure.core/let
    [credentials11916 (:credentials m11915) args11917 (:args m11915)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11918
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11916)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11918
       createPublicVirtualInterface
       (directconnect/create-public-virtual-interface-request
        (clojure.core/nth args11917 0)))))))
  (clojure.core/defn
   create-public-virtual-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         connection-id
                         clone-source
                         clone-root
                         new-public-virtual-interface]}]]),
    :doc "Generate map for createPublicVirtualInterface"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-public-virtual-interface,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   create-public-virtual-interface
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         connection-id
                         clone-source
                         clone-root
                         new-public-virtual-interface]}]]),
    :doc "Call createPublicVirtualInterface"}
   [credentials11920 & args11921]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11922
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11920)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11922
      createPublicVirtualInterface
      (directconnect/create-public-virtual-interface-request
       (clojure.core/nth args11921 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :create-connection
   [m11923]
   (clojure.core/let
    [credentials11924 (:credentials m11923) args11925 (:args m11923)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11926
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11924)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11926
       createConnection
       (directconnect/create-connection-request
        (clojure.core/nth args11925 0)))))))
  (clojure.core/defn
   create-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         bandwidth
                         read-limit
                         general-progress-listener
                         clone-source
                         connection-name
                         location
                         clone-root]}]]),
    :doc "Generate map for createConnection"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-connection,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   create-connection
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         bandwidth
                         read-limit
                         general-progress-listener
                         clone-source
                         connection-name
                         location
                         clone-root]}]]),
    :doc "Call createConnection"}
   [credentials11928 & args11929]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11930
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11928)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11930
      createConnection
      (directconnect/create-connection-request
       (clojure.core/nth args11929 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :confirm-connection
   [m11931]
   (clojure.core/let
    [credentials11932 (:credentials m11931) args11933 (:args m11931)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11934
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11932)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11934
       confirmConnection
       (directconnect/confirm-connection-request
        (clojure.core/nth args11933 0)))))))
  (clojure.core/defn
   confirm-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         connection-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for confirmConnection"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :confirm-connection,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   confirm-connection
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         connection-id
                         clone-source
                         clone-root]}]]),
    :doc "Call confirmConnection"}
   [credentials11936 & args11937]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11938
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11936)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11938
      confirmConnection
      (directconnect/confirm-connection-request
       (clojure.core/nth args11937 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :describe-virtual-gateways
   [m11939]
   (clojure.core/let
    [credentials11940 (:credentials m11939) args11941 (:args m11939)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11942
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11940)]
     (clojure.core/case
      (clojure.core/count args11941)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11942
        describeVirtualGateways))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11942
        describeVirtualGateways
        (directconnect/describe-virtual-gateways-request
         (clojure.core/nth args11941 0))))))))
  (clojure.core/defn
   describe-virtual-gateways-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeVirtualGateways, describeVirtualGateways"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-virtual-gateways,
     :credentials credentials__1842__auto__,
     :client :directconnect})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-virtual-gateways,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   describe-virtual-gateways
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeVirtualGateways, describeVirtualGateways"}
   [credentials11944 & args11945]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11946
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11944)]
    (clojure.core/case
     (clojure.core/count args11945)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11946
       describeVirtualGateways))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11946
       describeVirtualGateways
       (directconnect/describe-virtual-gateways-request
        (clojure.core/nth args11945 0))))))))
 (do
  (clojure.core/defmethod
   directconnect
   :describe-connections
   [m11947]
   (clojure.core/let
    [credentials11948 (:credentials m11947) args11949 (:args m11947)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11950
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11948)]
     (clojure.core/case
      (clojure.core/count args11949)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11950
        describeConnections
        (directconnect/describe-connections-request
         (clojure.core/nth args11949 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11950
        describeConnections))))))
  (clojure.core/defn
   describe-connections-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         connection-id
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeConnections, describeConnections"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-connections,
     :credentials credentials__1842__auto__,
     :client :directconnect})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-connections,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   describe-connections
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         connection-id
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeConnections, describeConnections"}
   [credentials11952 & args11953]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11954
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11952)]
    (clojure.core/case
     (clojure.core/count args11953)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11954
       describeConnections
       (directconnect/describe-connections-request
        (clojure.core/nth args11953 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11954
       describeConnections))))))
 (do
  (clojure.core/defmethod
   directconnect
   :confirm-public-virtual-interface
   [m11955]
   (clojure.core/let
    [credentials11956 (:credentials m11955) args11957 (:args m11955)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11958
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11956)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11958
       confirmPublicVirtualInterface
       (directconnect/confirm-public-virtual-interface-request
        (clojure.core/nth args11957 0)))))))
  (clojure.core/defn
   confirm-public-virtual-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         virtual-interface-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for confirmPublicVirtualInterface"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :confirm-public-virtual-interface,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   confirm-public-virtual-interface
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         virtual-interface-id
                         clone-source
                         clone-root]}]]),
    :doc "Call confirmPublicVirtualInterface"}
   [credentials11960 & args11961]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11962
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11960)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11962
      confirmPublicVirtualInterface
      (directconnect/confirm-public-virtual-interface-request
       (clojure.core/nth args11961 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :confirm-private-virtual-interface
   [m11963]
   (clojure.core/let
    [credentials11964 (:credentials m11963) args11965 (:args m11963)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11966
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11964)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11966
       confirmPrivateVirtualInterface
       (directconnect/confirm-private-virtual-interface-request
        (clojure.core/nth args11965 0)))))))
  (clojure.core/defn
   confirm-private-virtual-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         virtual-gateway-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         virtual-interface-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for confirmPrivateVirtualInterface"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :confirm-private-virtual-interface,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   confirm-private-virtual-interface
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         virtual-gateway-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         virtual-interface-id
                         clone-source
                         clone-root]}]]),
    :doc "Call confirmPrivateVirtualInterface"}
   [credentials11968 & args11969]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11970
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11968)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11970
      confirmPrivateVirtualInterface
      (directconnect/confirm-private-virtual-interface-request
       (clojure.core/nth args11969 0))))))))
