(ns
 com.palletops.awaze.datapipeline
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.datapipeline :as datapipeline]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :datapipeline
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.datapipeline.DataPipelineClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.Operator}
operator
  [m7628]
  (clojure.core/let
   [bean7627 (new com.amazonaws.services.datapipeline.model.Operator)]
   (clojure.core/let
    [v7629 (:values m7628 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7629 :com.palletops.awaze.client-builder/undef)
     (.
      bean7627
      setValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7714] (clojure.core/str arg7714))
 v7629))))
   (clojure.core/let
    [v7629 (:type m7628 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7629 :com.palletops.awaze.client-builder/undef)
     (. bean7627 setType (clojure.core/str v7629))))
   bean7627))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.Field}
field
  [m7631]
  (clojure.core/let
   [bean7630 (new com.amazonaws.services.datapipeline.model.Field)]
   (clojure.core/let
    [v7632 (:key m7631 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7632 :com.palletops.awaze.client-builder/undef)
     (. bean7630 setKey (clojure.core/str v7632))))
   (clojure.core/let
    [v7632
     (:ref-value m7631 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7632 :com.palletops.awaze.client-builder/undef)
     (. bean7630 setRefValue (clojure.core/str v7632))))
   (clojure.core/let
    [v7632
     (:string-value m7631 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7632 :com.palletops.awaze.client-builder/undef)
     (. bean7630 setStringValue (clojure.core/str v7632))))
   bean7630))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.ParameterAttribute}
parameter-attribute
  [m7634]
  (clojure.core/let
   [bean7633
    (new com.amazonaws.services.datapipeline.model.ParameterAttribute)]
   (clojure.core/let
    [v7635 (:key m7634 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7635 :com.palletops.awaze.client-builder/undef)
     (. bean7633 setKey (clojure.core/str v7635))))
   (clojure.core/let
    [v7635
     (:string-value m7634 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7635 :com.palletops.awaze.client-builder/undef)
     (. bean7633 setStringValue (clojure.core/str v7635))))
   bean7633))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.Selector}
selector
  [m7637]
  (clojure.core/let
   [bean7636 (new com.amazonaws.services.datapipeline.model.Selector)]
   (clojure.core/let
    [v7638
     (:operator m7637 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7638 :com.palletops.awaze.client-builder/undef)
     (. bean7636 setOperator (datapipeline/operator v7638))))
   (clojure.core/let
    [v7638
     (:field-name m7637 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7638 :com.palletops.awaze.client-builder/undef)
     (. bean7636 setFieldName (clojure.core/str v7638))))
   bean7636))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.ParameterValue}
parameter-value
  [m7640]
  (clojure.core/let
   [bean7639
    (new com.amazonaws.services.datapipeline.model.ParameterValue)]
   (clojure.core/let
    [v7641
     (:string-value m7640 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7641 :com.palletops.awaze.client-builder/undef)
     (. bean7639 setStringValue (clojure.core/str v7641))))
   (clojure.core/let
    [v7641 (:id m7640 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7641 :com.palletops.awaze.client-builder/undef)
     (. bean7639 setId (clojure.core/str v7641))))
   bean7639))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.PipelineObject}
pipeline-object
  [m7643]
  (clojure.core/let
   [bean7642
    (new com.amazonaws.services.datapipeline.model.PipelineObject)]
   (clojure.core/let
    [v7644 (:fields m7643 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7644 :com.palletops.awaze.client-builder/undef)
     (.
      bean7642
      setFields
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7715] (datapipeline/field arg7715))
 v7644))))
   (clojure.core/let
    [v7644 (:id m7643 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7644 :com.palletops.awaze.client-builder/undef)
     (. bean7642 setId (clojure.core/str v7644))))
   (clojure.core/let
    [v7644 (:name m7643 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7644 :com.palletops.awaze.client-builder/undef)
     (. bean7642 setName (clojure.core/str v7644))))
   bean7642))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.ParameterObject}
parameter-object
  [m7646]
  (clojure.core/let
   [bean7645
    (new com.amazonaws.services.datapipeline.model.ParameterObject)]
   (clojure.core/let
    [v7647
     (:attributes m7646 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7647 :com.palletops.awaze.client-builder/undef)
     (.
      bean7645
      setAttributes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg7716]
  (datapipeline/parameter-attribute arg7716))
 v7647))))
   (clojure.core/let
    [v7647 (:id m7646 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7647 :com.palletops.awaze.client-builder/undef)
     (. bean7645 setId (clojure.core/str v7647))))
   bean7645))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.InstanceIdentity}
instance-identity
  [m7649]
  (clojure.core/let
   [bean7648
    (new com.amazonaws.services.datapipeline.model.InstanceIdentity)]
   (clojure.core/let
    [v7650
     (:document m7649 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7650 :com.palletops.awaze.client-builder/undef)
     (. bean7648 setDocument (clojure.core/str v7650))))
   (clojure.core/let
    [v7650
     (:signature m7649 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7650 :com.palletops.awaze.client-builder/undef)
     (. bean7648 setSignature (clojure.core/str v7650))))
   bean7648))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.Tag}
tag
  [m7652]
  (clojure.core/let
   [bean7651 (new com.amazonaws.services.datapipeline.model.Tag)]
   (clojure.core/let
    [v7653 (:key m7652 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7653 :com.palletops.awaze.client-builder/undef)
     (. bean7651 setKey (clojure.core/str v7653))))
   (clojure.core/let
    [v7653 (:value m7652 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7653 :com.palletops.awaze.client-builder/undef)
     (. bean7651 setValue (clojure.core/str v7653))))
   bean7651))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.Query}
query
  [m7655]
  (clojure.core/let
   [bean7654 (new com.amazonaws.services.datapipeline.model.Query)]
   (clojure.core/let
    [v7656
     (:selectors m7655 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7656 :com.palletops.awaze.client-builder/undef)
     (.
      bean7654
      setSelectors
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7717] (datapipeline/selector arg7717))
 v7656))))
   bean7654))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.GetPipelineDefinitionRequest}
get-pipeline-definition-request
  [m7658]
  (clojure.core/let
   [bean7657
    (new
     com.amazonaws.services.datapipeline.model.GetPipelineDefinitionRequest)]
   (clojure.core/let
    [v7659 (:version m7658 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7659 :com.palletops.awaze.client-builder/undef)
     (. bean7657 setVersion (clojure.core/str v7659))))
   (clojure.core/let
    [v7659
     (:pipeline-id m7658 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7659 :com.palletops.awaze.client-builder/undef)
     (. bean7657 setPipelineId (clojure.core/str v7659))))
   bean7657))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.ValidatePipelineDefinitionRequest}
validate-pipeline-definition-request
  [m7661]
  (clojure.core/let
   [bean7660
    (new
     com.amazonaws.services.datapipeline.model.ValidatePipelineDefinitionRequest)]
   (clojure.core/let
    [v7662
     (:pipeline-id m7661 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7662 :com.palletops.awaze.client-builder/undef)
     (. bean7660 setPipelineId (clojure.core/str v7662))))
   (clojure.core/let
    [v7662
     (:parameter-values
      m7661
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7662 :com.palletops.awaze.client-builder/undef)
     (.
      bean7660
      setParameterValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7718] (datapipeline/parameter-value arg7718))
 v7662))))
   (clojure.core/let
    [v7662
     (:pipeline-objects
      m7661
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7662 :com.palletops.awaze.client-builder/undef)
     (.
      bean7660
      setPipelineObjects
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7719] (datapipeline/pipeline-object arg7719))
 v7662))))
   (clojure.core/let
    [v7662
     (:parameter-objects
      m7661
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7662 :com.palletops.awaze.client-builder/undef)
     (.
      bean7660
      setParameterObjects
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7720] (datapipeline/parameter-object arg7720))
 v7662))))
   bean7660))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.ReportTaskProgressRequest}
report-task-progress-request
  [m7664]
  (clojure.core/let
   [bean7663
    (new
     com.amazonaws.services.datapipeline.model.ReportTaskProgressRequest)]
   (clojure.core/let
    [v7665 (:task-id m7664 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7665 :com.palletops.awaze.client-builder/undef)
     (. bean7663 setTaskId (clojure.core/str v7665))))
   (clojure.core/let
    [v7665 (:fields m7664 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7665 :com.palletops.awaze.client-builder/undef)
     (.
      bean7663
      setFields
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7721] (datapipeline/field arg7721))
 v7665))))
   bean7663))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.RemoveTagsRequest}
remove-tags-request
  [m7667]
  (clojure.core/let
   [bean7666
    (new com.amazonaws.services.datapipeline.model.RemoveTagsRequest)]
   (clojure.core/let
    [v7668
     (:pipeline-id m7667 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7668 :com.palletops.awaze.client-builder/undef)
     (. bean7666 setPipelineId (clojure.core/str v7668))))
   (clojure.core/let
    [v7668
     (:tag-keys m7667 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7668 :com.palletops.awaze.client-builder/undef)
     (.
      bean7666
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7722] (clojure.core/str arg7722))
 v7668))))
   bean7666))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.DescribePipelinesRequest}
describe-pipelines-request
  [m7670]
  (clojure.core/let
   [bean7669
    (new
     com.amazonaws.services.datapipeline.model.DescribePipelinesRequest)]
   (clojure.core/let
    [v7671
     (:pipeline-ids m7670 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7671 :com.palletops.awaze.client-builder/undef)
     (.
      bean7669
      setPipelineIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7731] (clojure.core/str arg7731))
 v7671))))
   bean7669))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.PollForTaskRequest}
poll-for-task-request
  [m7673]
  (clojure.core/let
   [bean7672
    (new com.amazonaws.services.datapipeline.model.PollForTaskRequest)]
   (clojure.core/let
    [v7674
     (:instance-identity
      m7673
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7674 :com.palletops.awaze.client-builder/undef)
     (.
      bean7672
      setInstanceIdentity
      (datapipeline/instance-identity v7674))))
   (clojure.core/let
    [v7674
     (:worker-group m7673 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7674 :com.palletops.awaze.client-builder/undef)
     (. bean7672 setWorkerGroup (clojure.core/str v7674))))
   (clojure.core/let
    [v7674
     (:hostname m7673 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7674 :com.palletops.awaze.client-builder/undef)
     (. bean7672 setHostname (clojure.core/str v7674))))
   bean7672))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.AddTagsRequest}
add-tags-request
  [m7676]
  (clojure.core/let
   [bean7675
    (new com.amazonaws.services.datapipeline.model.AddTagsRequest)]
   (clojure.core/let
    [v7677
     (:pipeline-id m7676 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7677 :com.palletops.awaze.client-builder/undef)
     (. bean7675 setPipelineId (clojure.core/str v7677))))
   (clojure.core/let
    [v7677 (:tags m7676 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7677 :com.palletops.awaze.client-builder/undef)
     (.
      bean7675
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7732] (datapipeline/tag arg7732))
 v7677))))
   bean7675))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.QueryObjectsRequest}
query-objects-request
  [m7679]
  (clojure.core/let
   [bean7678
    (new
     com.amazonaws.services.datapipeline.model.QueryObjectsRequest)]
   (clojure.core/let
    [v7680 (:limit m7679 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7680 :com.palletops.awaze.client-builder/undef)
     (. bean7678 setLimit (clojure.core/int v7680))))
   (clojure.core/let
    [v7680
     (:pipeline-id m7679 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7680 :com.palletops.awaze.client-builder/undef)
     (. bean7678 setPipelineId (clojure.core/str v7680))))
   (clojure.core/let
    [v7680 (:query m7679 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7680 :com.palletops.awaze.client-builder/undef)
     (. bean7678 setQuery (datapipeline/query v7680))))
   (clojure.core/let
    [v7680 (:sphere m7679 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7680 :com.palletops.awaze.client-builder/undef)
     (. bean7678 setSphere (clojure.core/str v7680))))
   (clojure.core/let
    [v7680 (:marker m7679 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7680 :com.palletops.awaze.client-builder/undef)
     (. bean7678 setMarker (clojure.core/str v7680))))
   bean7678))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.ListPipelinesRequest}
list-pipelines-request
  [m7682]
  (clojure.core/let
   [bean7681
    (new
     com.amazonaws.services.datapipeline.model.ListPipelinesRequest)]
   (clojure.core/let
    [v7683 (:marker m7682 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7683 :com.palletops.awaze.client-builder/undef)
     (. bean7681 setMarker (clojure.core/str v7683))))
   bean7681))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.ReportTaskRunnerHeartbeatRequest}
report-task-runner-heartbeat-request
  [m7685]
  (clojure.core/let
   [bean7684
    (new
     com.amazonaws.services.datapipeline.model.ReportTaskRunnerHeartbeatRequest)]
   (clojure.core/let
    [v7686
     (:taskrunner-id m7685 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7686 :com.palletops.awaze.client-builder/undef)
     (. bean7684 setTaskrunnerId (clojure.core/str v7686))))
   (clojure.core/let
    [v7686
     (:worker-group m7685 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7686 :com.palletops.awaze.client-builder/undef)
     (. bean7684 setWorkerGroup (clojure.core/str v7686))))
   (clojure.core/let
    [v7686
     (:hostname m7685 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7686 :com.palletops.awaze.client-builder/undef)
     (. bean7684 setHostname (clojure.core/str v7686))))
   bean7684))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.SetTaskStatusRequest}
set-task-status-request
  [m7688]
  (clojure.core/let
   [bean7687
    (new
     com.amazonaws.services.datapipeline.model.SetTaskStatusRequest)]
   (clojure.core/let
    [v7689
     (:error-stack-trace
      m7688
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7689 :com.palletops.awaze.client-builder/undef)
     (. bean7687 setErrorStackTrace (clojure.core/str v7689))))
   (clojure.core/let
    [v7689
     (:error-id m7688 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7689 :com.palletops.awaze.client-builder/undef)
     (. bean7687 setErrorId (clojure.core/str v7689))))
   (clojure.core/let
    [v7689 (:task-id m7688 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7689 :com.palletops.awaze.client-builder/undef)
     (. bean7687 setTaskId (clojure.core/str v7689))))
   (clojure.core/let
    [v7689
     (:task-status m7688 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7689 :com.palletops.awaze.client-builder/undef)
     (. bean7687 setTaskStatus (clojure.core/str v7689))))
   (clojure.core/let
    [v7689
     (:error-message m7688 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7689 :com.palletops.awaze.client-builder/undef)
     (. bean7687 setErrorMessage (clojure.core/str v7689))))
   bean7687))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.CreatePipelineRequest}
create-pipeline-request
  [m7691]
  (clojure.core/let
   [bean7690
    (new
     com.amazonaws.services.datapipeline.model.CreatePipelineRequest)]
   (clojure.core/let
    [v7692
     (:unique-id m7691 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7692 :com.palletops.awaze.client-builder/undef)
     (. bean7690 setUniqueId (clojure.core/str v7692))))
   (clojure.core/let
    [v7692
     (:description m7691 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7692 :com.palletops.awaze.client-builder/undef)
     (. bean7690 setDescription (clojure.core/str v7692))))
   (clojure.core/let
    [v7692 (:tags m7691 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7692 :com.palletops.awaze.client-builder/undef)
     (.
      bean7690
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7733] (datapipeline/tag arg7733))
 v7692))))
   (clojure.core/let
    [v7692 (:name m7691 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7692 :com.palletops.awaze.client-builder/undef)
     (. bean7690 setName (clojure.core/str v7692))))
   bean7690))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.DeletePipelineRequest}
delete-pipeline-request
  [m7694]
  (clojure.core/let
   [bean7693
    (new
     com.amazonaws.services.datapipeline.model.DeletePipelineRequest)]
   (clojure.core/let
    [v7695
     (:pipeline-id m7694 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7695 :com.palletops.awaze.client-builder/undef)
     (. bean7693 setPipelineId (clojure.core/str v7695))))
   bean7693))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.PutPipelineDefinitionRequest}
put-pipeline-definition-request
  [m7697]
  (clojure.core/let
   [bean7696
    (new
     com.amazonaws.services.datapipeline.model.PutPipelineDefinitionRequest)]
   (clojure.core/let
    [v7698
     (:pipeline-id m7697 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7698 :com.palletops.awaze.client-builder/undef)
     (. bean7696 setPipelineId (clojure.core/str v7698))))
   (clojure.core/let
    [v7698
     (:parameter-values
      m7697
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7698 :com.palletops.awaze.client-builder/undef)
     (.
      bean7696
      setParameterValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7734] (datapipeline/parameter-value arg7734))
 v7698))))
   (clojure.core/let
    [v7698
     (:pipeline-objects
      m7697
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7698 :com.palletops.awaze.client-builder/undef)
     (.
      bean7696
      setPipelineObjects
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7735] (datapipeline/pipeline-object arg7735))
 v7698))))
   (clojure.core/let
    [v7698
     (:parameter-objects
      m7697
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7698 :com.palletops.awaze.client-builder/undef)
     (.
      bean7696
      setParameterObjects
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7736] (datapipeline/parameter-object arg7736))
 v7698))))
   bean7696))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.DeactivatePipelineRequest}
deactivate-pipeline-request
  [m7700]
  (clojure.core/let
   [bean7699
    (new
     com.amazonaws.services.datapipeline.model.DeactivatePipelineRequest)]
   (clojure.core/let
    [v7701
     (:pipeline-id m7700 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7701 :com.palletops.awaze.client-builder/undef)
     (. bean7699 setPipelineId (clojure.core/str v7701))))
   (clojure.core/let
    [v7701
     (:cancel-active m7700 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7701 :com.palletops.awaze.client-builder/undef)
     (. bean7699 setCancelActive (clojure.core/boolean v7701))))
   bean7699))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.SetStatusRequest}
set-status-request
  [m7703]
  (clojure.core/let
   [bean7702
    (new com.amazonaws.services.datapipeline.model.SetStatusRequest)]
   (clojure.core/let
    [v7704
     (:pipeline-id m7703 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7704 :com.palletops.awaze.client-builder/undef)
     (. bean7702 setPipelineId (clojure.core/str v7704))))
   (clojure.core/let
    [v7704
     (:object-ids m7703 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7704 :com.palletops.awaze.client-builder/undef)
     (.
      bean7702
      setObjectIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7737] (clojure.core/str arg7737))
 v7704))))
   (clojure.core/let
    [v7704 (:status m7703 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7704 :com.palletops.awaze.client-builder/undef)
     (. bean7702 setStatus (clojure.core/str v7704))))
   bean7702))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.EvaluateExpressionRequest}
evaluate-expression-request
  [m7706]
  (clojure.core/let
   [bean7705
    (new
     com.amazonaws.services.datapipeline.model.EvaluateExpressionRequest)]
   (clojure.core/let
    [v7707
     (:pipeline-id m7706 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7707 :com.palletops.awaze.client-builder/undef)
     (. bean7705 setPipelineId (clojure.core/str v7707))))
   (clojure.core/let
    [v7707
     (:object-id m7706 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7707 :com.palletops.awaze.client-builder/undef)
     (. bean7705 setObjectId (clojure.core/str v7707))))
   (clojure.core/let
    [v7707
     (:expression m7706 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7707 :com.palletops.awaze.client-builder/undef)
     (. bean7705 setExpression (clojure.core/str v7707))))
   bean7705))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.DescribeObjectsRequest}
describe-objects-request
  [m7709]
  (clojure.core/let
   [bean7708
    (new
     com.amazonaws.services.datapipeline.model.DescribeObjectsRequest)]
   (clojure.core/let
    [v7710
     (:pipeline-id m7709 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7710 :com.palletops.awaze.client-builder/undef)
     (. bean7708 setPipelineId (clojure.core/str v7710))))
   (clojure.core/let
    [v7710
     (:object-ids m7709 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7710 :com.palletops.awaze.client-builder/undef)
     (.
      bean7708
      setObjectIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7738] (clojure.core/str arg7738))
 v7710))))
   (clojure.core/let
    [v7710
     (:evaluate-expressions
      m7709
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7710 :com.palletops.awaze.client-builder/undef)
     (. bean7708 setEvaluateExpressions (clojure.core/boolean v7710))))
   (clojure.core/let
    [v7710 (:marker m7709 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7710 :com.palletops.awaze.client-builder/undef)
     (. bean7708 setMarker (clojure.core/str v7710))))
   bean7708))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.ActivatePipelineRequest}
activate-pipeline-request
  [m7712]
  (clojure.core/let
   [bean7711
    (new
     com.amazonaws.services.datapipeline.model.ActivatePipelineRequest)]
   (clojure.core/let
    [v7713
     (:pipeline-id m7712 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7713 :com.palletops.awaze.client-builder/undef)
     (. bean7711 setPipelineId (clojure.core/str v7713))))
   (clojure.core/let
    [v7713
     (:parameter-values
      m7712
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7713 :com.palletops.awaze.client-builder/undef)
     (.
      bean7711
      setParameterValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7739] (datapipeline/parameter-value arg7739))
 v7713))))
   (clojure.core/let
    [v7713
     (:start-timestamp
      m7712
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7713 :com.palletops.awaze.client-builder/undef)
     (.
      bean7711
      setStartTimestamp
      (com.palletops.awaze.common/to-date v7713))))
   bean7711))
 (clojure.core/defmulti
  datapipeline
  (clojure.core/fn
   datapipeline
   [m__1874__auto__]
   (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   datapipeline
   :get-pipeline-definition
   [m7723]
   (clojure.core/let
    [credentials7724 (:credentials m7723) args7725 (:args m7723)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7726
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7724)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7726
       getPipelineDefinition
       (datapipeline/get-pipeline-definition-request
        (clojure.core/nth args7725 0)))))))
  (clojure.core/defn
   get-pipeline-definition-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         version
                         pipeline-id
                         clone-root]}]]),
    :doc "Generate map for getPipelineDefinition"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-pipeline-definition,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   get-pipeline-definition
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         version
                         pipeline-id
                         clone-root]}]]),
    :doc "Call getPipelineDefinition"}
   [credentials7728 & args7729]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7730
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7728)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7730
      getPipelineDefinition
      (datapipeline/get-pipeline-definition-request
       (clojure.core/nth args7729 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :validate-pipeline-definition
   [m7740]
   (clojure.core/let
    [credentials7741 (:credentials m7740) args7742 (:args m7740)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7743
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7741)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7743
       validatePipelineDefinition
       (datapipeline/validate-pipeline-definition-request
        (clojure.core/nth args7742 0)))))))
  (clojure.core/defn
   validate-pipeline-definition-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         parameter-objects
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         pipeline-objects
                         general-progress-listener
                         clone-source
                         pipeline-id
                         parameter-values
                         clone-root]}]]),
    :doc "Generate map for validatePipelineDefinition"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :validate-pipeline-definition,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   validate-pipeline-definition
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         parameter-objects
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         pipeline-objects
                         general-progress-listener
                         clone-source
                         pipeline-id
                         parameter-values
                         clone-root]}]]),
    :doc "Call validatePipelineDefinition"}
   [credentials7745 & args7746]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7747
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7745)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7747
      validatePipelineDefinition
      (datapipeline/validate-pipeline-definition-request
       (clojure.core/nth args7746 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :report-task-progress
   [m7748]
   (clojure.core/let
    [credentials7749 (:credentials m7748) args7750 (:args m7748)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7751
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7749)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7751
       reportTaskProgress
       (datapipeline/report-task-progress-request
        (clojure.core/nth args7750 0)))))))
  (clojure.core/defn
   report-task-progress-map
   {:arglists (quote
               [[credentials
                 {:keys [task-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         fields
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for reportTaskProgress"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :report-task-progress,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   report-task-progress
   {:arglists (quote
               [[credentials
                 {:keys [task-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         fields
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call reportTaskProgress"}
   [credentials7753 & args7754]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7755
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7753)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7755
      reportTaskProgress
      (datapipeline/report-task-progress-request
       (clojure.core/nth args7754 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :remove-tags
   [m7756]
   (clojure.core/let
    [credentials7757 (:credentials m7756) args7758 (:args m7756)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7759
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7757)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7759
       removeTags
       (datapipeline/remove-tags-request
        (clojure.core/nth args7758 0)))))))
  (clojure.core/defn
   remove-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         tag-keys
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         pipeline-id
                         clone-root]}]]),
    :doc "Generate map for removeTags"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :remove-tags,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   remove-tags
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         tag-keys
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         pipeline-id
                         clone-root]}]]),
    :doc "Call removeTags"}
   [credentials7761 & args7762]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7763
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7761)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7763
      removeTags
      (datapipeline/remove-tags-request (clojure.core/nth args7762 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :describe-pipelines
   [m7764]
   (clojure.core/let
    [credentials7765 (:credentials m7764) args7766 (:args m7764)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7767
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7765)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7767
       describePipelines
       (datapipeline/describe-pipelines-request
        (clojure.core/nth args7766 0)))))))
  (clojure.core/defn
   describe-pipelines-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         pipeline-ids]}]]),
    :doc "Generate map for describePipelines"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-pipelines,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   describe-pipelines
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         pipeline-ids]}]]),
    :doc "Call describePipelines"}
   [credentials7769 & args7770]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7771
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7769)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7771
      describePipelines
      (datapipeline/describe-pipelines-request
       (clojure.core/nth args7770 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :poll-for-task
   [m7772]
   (clojure.core/let
    [credentials7773 (:credentials m7772) args7774 (:args m7772)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7775
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7773)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7775
       pollForTask
       (datapipeline/poll-for-task-request
        (clojure.core/nth args7774 0)))))))
  (clojure.core/defn
   poll-for-task-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         hostname
                         read-limit
                         general-progress-listener
                         worker-group
                         clone-source
                         clone-root
                         instance-identity]}]]),
    :doc "Generate map for pollForTask"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :poll-for-task,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   poll-for-task
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         hostname
                         read-limit
                         general-progress-listener
                         worker-group
                         clone-source
                         clone-root
                         instance-identity]}]]),
    :doc "Call pollForTask"}
   [credentials7777 & args7778]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7779
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7777)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7779
      pollForTask
      (datapipeline/poll-for-task-request
       (clojure.core/nth args7778 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :add-tags
   [m7780]
   (clojure.core/let
    [credentials7781 (:credentials m7780) args7782 (:args m7780)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7783
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7781)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7783
       addTags
       (datapipeline/add-tags-request (clojure.core/nth args7782 0)))))))
  (clojure.core/defn
   add-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         pipeline-id
                         clone-root]}]]),
    :doc "Generate map for addTags"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :add-tags,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   add-tags
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         pipeline-id
                         clone-root]}]]),
    :doc "Call addTags"}
   [credentials7785 & args7786]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7787
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7785)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7787
      addTags
      (datapipeline/add-tags-request (clojure.core/nth args7786 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :query-objects
   [m7788]
   (clojure.core/let
    [credentials7789 (:credentials m7788) args7790 (:args m7788)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7791
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7789)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7791
       queryObjects
       (datapipeline/query-objects-request
        (clojure.core/nth args7790 0)))))))
  (clojure.core/defn
   query-objects-map
   {:arglists (quote
               [[credentials
                 {:keys [sphere
                         custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         query
                         pipeline-id
                         clone-root]}]]),
    :doc "Generate map for queryObjects"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :query-objects,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   query-objects
   {:arglists (quote
               [[credentials
                 {:keys [sphere
                         custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         query
                         pipeline-id
                         clone-root]}]]),
    :doc "Call queryObjects"}
   [credentials7793 & args7794]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7795
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7793)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7795
      queryObjects
      (datapipeline/query-objects-request
       (clojure.core/nth args7794 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :list-pipelines
   [m7796]
   (clojure.core/let
    [credentials7797 (:credentials m7796) args7798 (:args m7796)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7799
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7797)]
     (clojure.core/case
      (clojure.core/count args7798)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7799
        listPipelines
        (datapipeline/list-pipelines-request
         (clojure.core/nth args7798 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7799
        listPipelines))))))
  (clojure.core/defn
   list-pipelines-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listPipelines, listPipelines"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-pipelines,
     :credentials credentials__1842__auto__,
     :client :datapipeline})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-pipelines,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   list-pipelines
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listPipelines, listPipelines"}
   [credentials7801 & args7802]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7803
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7801)]
    (clojure.core/case
     (clojure.core/count args7802)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7803
       listPipelines
       (datapipeline/list-pipelines-request
        (clojure.core/nth args7802 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7803
       listPipelines))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :report-task-runner-heartbeat
   [m7804]
   (clojure.core/let
    [credentials7805 (:credentials m7804) args7806 (:args m7804)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7807
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7805)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7807
       reportTaskRunnerHeartbeat
       (datapipeline/report-task-runner-heartbeat-request
        (clojure.core/nth args7806 0)))))))
  (clojure.core/defn
   report-task-runner-heartbeat-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         hostname
                         taskrunner-id
                         read-limit
                         general-progress-listener
                         worker-group
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for reportTaskRunnerHeartbeat"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :report-task-runner-heartbeat,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   report-task-runner-heartbeat
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         hostname
                         taskrunner-id
                         read-limit
                         general-progress-listener
                         worker-group
                         clone-source
                         clone-root]}]]),
    :doc "Call reportTaskRunnerHeartbeat"}
   [credentials7809 & args7810]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7811
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7809)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7811
      reportTaskRunnerHeartbeat
      (datapipeline/report-task-runner-heartbeat-request
       (clojure.core/nth args7810 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :set-task-status
   [m7812]
   (clojure.core/let
    [credentials7813 (:credentials m7812) args7814 (:args m7812)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7815
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7813)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7815
       setTaskStatus
       (datapipeline/set-task-status-request
        (clojure.core/nth args7814 0)))))))
  (clojure.core/defn
   set-task-status-map
   {:arglists (quote
               [[credentials
                 {:keys [task-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         error-stack-trace
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         task-status
                         error-id
                         error-message
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setTaskStatus"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-task-status,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   set-task-status
   {:arglists (quote
               [[credentials
                 {:keys [task-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         error-stack-trace
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         task-status
                         error-id
                         error-message
                         clone-source
                         clone-root]}]]),
    :doc "Call setTaskStatus"}
   [credentials7817 & args7818]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7819
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7817)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7819
      setTaskStatus
      (datapipeline/set-task-status-request
       (clojure.core/nth args7818 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :create-pipeline
   [m7820]
   (clojure.core/let
    [credentials7821 (:credentials m7820) args7822 (:args m7820)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7823
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7821)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7823
       createPipeline
       (datapipeline/create-pipeline-request
        (clojure.core/nth args7822 0)))))))
  (clojure.core/defn
   create-pipeline-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         unique-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createPipeline"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-pipeline,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   create-pipeline
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         unique-id
                         clone-source
                         clone-root]}]]),
    :doc "Call createPipeline"}
   [credentials7825 & args7826]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7827
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7825)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7827
      createPipeline
      (datapipeline/create-pipeline-request
       (clojure.core/nth args7826 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :delete-pipeline
   [m7828]
   (clojure.core/let
    [credentials7829 (:credentials m7828) args7830 (:args m7828)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7831
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7829)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7831
       deletePipeline
       (datapipeline/delete-pipeline-request
        (clojure.core/nth args7830 0)))))))
  (clojure.core/defn
   delete-pipeline-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         pipeline-id
                         clone-root]}]]),
    :doc "Generate map for deletePipeline"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-pipeline,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   delete-pipeline
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         pipeline-id
                         clone-root]}]]),
    :doc "Call deletePipeline"}
   [credentials7833 & args7834]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7835
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7833)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7835
      deletePipeline
      (datapipeline/delete-pipeline-request
       (clojure.core/nth args7834 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :put-pipeline-definition
   [m7836]
   (clojure.core/let
    [credentials7837 (:credentials m7836) args7838 (:args m7836)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7839
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7837)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7839
       putPipelineDefinition
       (datapipeline/put-pipeline-definition-request
        (clojure.core/nth args7838 0)))))))
  (clojure.core/defn
   put-pipeline-definition-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         parameter-objects
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         pipeline-objects
                         general-progress-listener
                         clone-source
                         pipeline-id
                         parameter-values
                         clone-root]}]]),
    :doc "Generate map for putPipelineDefinition"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :put-pipeline-definition,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   put-pipeline-definition
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         parameter-objects
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         pipeline-objects
                         general-progress-listener
                         clone-source
                         pipeline-id
                         parameter-values
                         clone-root]}]]),
    :doc "Call putPipelineDefinition"}
   [credentials7841 & args7842]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7843
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7841)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7843
      putPipelineDefinition
      (datapipeline/put-pipeline-definition-request
       (clojure.core/nth args7842 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :deactivate-pipeline
   [m7844]
   (clojure.core/let
    [credentials7845 (:credentials m7844) args7846 (:args m7844)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7847
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7845)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7847
       deactivatePipeline
       (datapipeline/deactivate-pipeline-request
        (clojure.core/nth args7846 0)))))))
  (clojure.core/defn
   deactivate-pipeline-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cancel-active
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         pipeline-id
                         clone-root]}]]),
    :doc "Generate map for deactivatePipeline"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :deactivate-pipeline,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   deactivate-pipeline
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cancel-active
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         pipeline-id
                         clone-root]}]]),
    :doc "Call deactivatePipeline"}
   [credentials7849 & args7850]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7851
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7849)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7851
      deactivatePipeline
      (datapipeline/deactivate-pipeline-request
       (clojure.core/nth args7850 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :set-status
   [m7852]
   (clojure.core/let
    [credentials7853 (:credentials m7852) args7854 (:args m7852)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7855
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7853)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7855
       setStatus
       (datapipeline/set-status-request (clojure.core/nth args7854 0)))))))
  (clojure.core/defn
   set-status-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         status
                         general-progress-listener
                         object-ids
                         clone-source
                         pipeline-id
                         clone-root]}]]),
    :doc "Generate map for setStatus"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-status,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   set-status
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         status
                         general-progress-listener
                         object-ids
                         clone-source
                         pipeline-id
                         clone-root]}]]),
    :doc "Call setStatus"}
   [credentials7857 & args7858]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7859
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7857)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7859
      setStatus
      (datapipeline/set-status-request (clojure.core/nth args7858 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :evaluate-expression
   [m7860]
   (clojure.core/let
    [credentials7861 (:credentials m7860) args7862 (:args m7860)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7863
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7861)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7863
       evaluateExpression
       (datapipeline/evaluate-expression-request
        (clojure.core/nth args7862 0)))))))
  (clojure.core/defn
   evaluate-expression-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         expression
                         object-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         pipeline-id
                         clone-root]}]]),
    :doc "Generate map for evaluateExpression"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :evaluate-expression,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   evaluate-expression
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         expression
                         object-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         pipeline-id
                         clone-root]}]]),
    :doc "Call evaluateExpression"}
   [credentials7865 & args7866]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7867
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7865)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7867
      evaluateExpression
      (datapipeline/evaluate-expression-request
       (clojure.core/nth args7866 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :describe-objects
   [m7868]
   (clojure.core/let
    [credentials7869 (:credentials m7868) args7870 (:args m7868)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7871
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7869)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7871
       describeObjects
       (datapipeline/describe-objects-request
        (clojure.core/nth args7870 0)))))))
  (clojure.core/defn
   describe-objects-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         object-ids
                         clone-source
                         evaluate-expressions
                         pipeline-id
                         clone-root]}]]),
    :doc "Generate map for describeObjects"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-objects,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   describe-objects
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         object-ids
                         clone-source
                         evaluate-expressions
                         pipeline-id
                         clone-root]}]]),
    :doc "Call describeObjects"}
   [credentials7873 & args7874]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7875
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7873)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7875
      describeObjects
      (datapipeline/describe-objects-request
       (clojure.core/nth args7874 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :activate-pipeline
   [m7876]
   (clojure.core/let
    [credentials7877 (:credentials m7876) args7878 (:args m7876)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7879
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7877)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7879
       activatePipeline
       (datapipeline/activate-pipeline-request
        (clojure.core/nth args7878 0)))))))
  (clojure.core/defn
   activate-pipeline-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         start-timestamp
                         clone-source
                         pipeline-id
                         parameter-values
                         clone-root]}]]),
    :doc "Generate map for activatePipeline"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :activate-pipeline,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   activate-pipeline
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         start-timestamp
                         clone-source
                         pipeline-id
                         parameter-values
                         clone-root]}]]),
    :doc "Call activatePipeline"}
   [credentials7881 & args7882]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7883
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7881)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7883
      activatePipeline
      (datapipeline/activate-pipeline-request
       (clojure.core/nth args7882 0))))))))
