(ns
 com.palletops.awaze.cloudwatch
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.cloudwatch :as cloudwatch]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :cloudwatch
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.cloudwatch.AmazonCloudWatchClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.Dimension}
dimension
  [m10552]
  (clojure.core/let
   [bean10551 (new com.amazonaws.services.cloudwatch.model.Dimension)]
   (clojure.core/let
    [v10553 (:name m10552 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10553 :com.palletops.awaze.client-builder/undef)
     (. bean10551 setName (clojure.core/str v10553))))
   (clojure.core/let
    [v10553 (:value m10552 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10553 :com.palletops.awaze.client-builder/undef)
     (. bean10551 setValue (clojure.core/str v10553))))
   bean10551))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.StatisticSet}
statistic-set
  [m10555]
  (clojure.core/let
   [bean10554
    (new com.amazonaws.services.cloudwatch.model.StatisticSet)]
   (clojure.core/let
    [v10556
     (:sample-count m10555 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10556 :com.palletops.awaze.client-builder/undef)
     (. bean10554 setSampleCount (clojure.core/double v10556))))
   (clojure.core/let
    [v10556 (:sum m10555 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10556 :com.palletops.awaze.client-builder/undef)
     (. bean10554 setSum (clojure.core/double v10556))))
   (clojure.core/let
    [v10556
     (:minimum m10555 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10556 :com.palletops.awaze.client-builder/undef)
     (. bean10554 setMinimum (clojure.core/double v10556))))
   (clojure.core/let
    [v10556
     (:maximum m10555 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10556 :com.palletops.awaze.client-builder/undef)
     (. bean10554 setMaximum (clojure.core/double v10556))))
   bean10554))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.Statistic}
statistic
  [m10558]
  (.
   com.amazonaws.services.cloudwatch.model.Statistic
   fromValue
   (clojure.core/name m10558)))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.StandardUnit}
standard-unit
  [m10561]
  (.
   com.amazonaws.services.cloudwatch.model.StandardUnit
   fromValue
   (clojure.core/name m10561)))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.MetricDatum}
metric-datum
  [m10564]
  (clojure.core/let
   [bean10563
    (new com.amazonaws.services.cloudwatch.model.MetricDatum)]
   (clojure.core/let
    [v10565
     (:metric-name m10564 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10565 :com.palletops.awaze.client-builder/undef)
     (. bean10563 setMetricName (clojure.core/str v10565))))
   (clojure.core/let
    [v10565
     (:dimensions m10564 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10565 :com.palletops.awaze.client-builder/undef)
     (.
      bean10563
      setDimensions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10608] (cloudwatch/dimension arg10608))
 v10565))))
   (clojure.core/let
    [v10565 (:unit m10564 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10565 :com.palletops.awaze.client-builder/undef)
     (. bean10563 setUnit (clojure.core/str v10565))))
   (clojure.core/let
    [v10565
     (:statistic-values
      m10564
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10565 :com.palletops.awaze.client-builder/undef)
     (.
      bean10563
      setStatisticValues
      (cloudwatch/statistic-set v10565))))
   (clojure.core/let
    [v10565 (:value m10564 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10565 :com.palletops.awaze.client-builder/undef)
     (. bean10563 setValue (clojure.core/double v10565))))
   (clojure.core/let
    [v10565
     (:timestamp m10564 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10565 :com.palletops.awaze.client-builder/undef)
     (.
      bean10563
      setTimestamp
      (com.palletops.awaze.common/to-date v10565))))
   bean10563))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.StateValue}
state-value
  [m10567]
  (.
   com.amazonaws.services.cloudwatch.model.StateValue
   fromValue
   (clojure.core/name m10567)))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.HistoryItemType}
history-item-type
  [m10570]
  (.
   com.amazonaws.services.cloudwatch.model.HistoryItemType
   fromValue
   (clojure.core/name m10570)))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.DimensionFilter}
dimension-filter
  [m10573]
  (clojure.core/let
   [bean10572
    (new com.amazonaws.services.cloudwatch.model.DimensionFilter)]
   (clojure.core/let
    [v10574 (:name m10573 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10574 :com.palletops.awaze.client-builder/undef)
     (. bean10572 setName (clojure.core/str v10574))))
   (clojure.core/let
    [v10574 (:value m10573 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10574 :com.palletops.awaze.client-builder/undef)
     (. bean10572 setValue (clojure.core/str v10574))))
   bean10572))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.DeleteAlarmsRequest}
delete-alarms-request
  [m10576]
  (clojure.core/let
   [bean10575
    (new com.amazonaws.services.cloudwatch.model.DeleteAlarmsRequest)]
   (clojure.core/let
    [v10577
     (:alarm-names m10576 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10577 :com.palletops.awaze.client-builder/undef)
     (.
      bean10575
      setAlarmNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10609] (clojure.core/str arg10609))
 v10577))))
   bean10575))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.EnableAlarmActionsRequest}
enable-alarm-actions-request
  [m10579]
  (clojure.core/let
   [bean10578
    (new
     com.amazonaws.services.cloudwatch.model.EnableAlarmActionsRequest)]
   (clojure.core/let
    [v10580
     (:alarm-names m10579 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10580 :com.palletops.awaze.client-builder/undef)
     (.
      bean10578
      setAlarmNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10610] (clojure.core/str arg10610))
 v10580))))
   bean10578))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.DisableAlarmActionsRequest}
disable-alarm-actions-request
  [m10582]
  (clojure.core/let
   [bean10581
    (new
     com.amazonaws.services.cloudwatch.model.DisableAlarmActionsRequest)]
   (clojure.core/let
    [v10583
     (:alarm-names m10582 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10583 :com.palletops.awaze.client-builder/undef)
     (.
      bean10581
      setAlarmNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10611] (clojure.core/str arg10611))
 v10583))))
   bean10581))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.SetAlarmStateRequest}
set-alarm-state-request
  [m10585]
  (clojure.core/let
   [bean10584
    (new com.amazonaws.services.cloudwatch.model.SetAlarmStateRequest)]
   (clojure.core/let
    [v10586
     (:state-reason m10585 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10586 :com.palletops.awaze.client-builder/undef)
     (. bean10584 setStateReason (clojure.core/str v10586))))
   (clojure.core/let
    [v10586
     (:state-reason-data
      m10585
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10586 :com.palletops.awaze.client-builder/undef)
     (. bean10584 setStateReasonData (clojure.core/str v10586))))
   (clojure.core/let
    [v10586
     (:alarm-name m10585 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10586 :com.palletops.awaze.client-builder/undef)
     (. bean10584 setAlarmName (clojure.core/str v10586))))
   (clojure.core/let
    [v10586
     (:state-value m10585 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10586 :com.palletops.awaze.client-builder/undef)
     (. bean10584 setStateValue (clojure.core/str v10586))))
   bean10584))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.DescribeAlarmsForMetricRequest}
describe-alarms-for-metric-request
  [m10588]
  (clojure.core/let
   [bean10587
    (new
     com.amazonaws.services.cloudwatch.model.DescribeAlarmsForMetricRequest)]
   (clojure.core/let
    [v10589
     (:namespace m10588 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10589 :com.palletops.awaze.client-builder/undef)
     (. bean10587 setNamespace (clojure.core/str v10589))))
   (clojure.core/let
    [v10589
     (:metric-name m10588 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10589 :com.palletops.awaze.client-builder/undef)
     (. bean10587 setMetricName (clojure.core/str v10589))))
   (clojure.core/let
    [v10589
     (:statistic m10588 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10589 :com.palletops.awaze.client-builder/undef)
     (. bean10587 setStatistic (cloudwatch/statistic v10589))))
   (clojure.core/let
    [v10589
     (:dimensions m10588 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10589 :com.palletops.awaze.client-builder/undef)
     (.
      bean10587
      setDimensions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10612] (cloudwatch/dimension arg10612))
 v10589))))
   (clojure.core/let
    [v10589
     (:period m10588 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10589 :com.palletops.awaze.client-builder/undef)
     (. bean10587 setPeriod (clojure.core/int v10589))))
   (clojure.core/let
    [v10589 (:unit m10588 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10589 :com.palletops.awaze.client-builder/undef)
     (. bean10587 setUnit (cloudwatch/standard-unit v10589))))
   bean10587))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.PutMetricDataRequest}
put-metric-data-request
  [m10591]
  (clojure.core/let
   [bean10590
    (new com.amazonaws.services.cloudwatch.model.PutMetricDataRequest)]
   (clojure.core/let
    [v10592
     (:namespace m10591 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10592 :com.palletops.awaze.client-builder/undef)
     (. bean10590 setNamespace (clojure.core/str v10592))))
   (clojure.core/let
    [v10592
     (:metric-data m10591 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10592 :com.palletops.awaze.client-builder/undef)
     (.
      bean10590
      setMetricData
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10613] (cloudwatch/metric-datum arg10613))
 v10592))))
   bean10590))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.DescribeAlarmsRequest}
describe-alarms-request
  [m10594]
  (clojure.core/let
   [bean10593
    (new
     com.amazonaws.services.cloudwatch.model.DescribeAlarmsRequest)]
   (clojure.core/let
    [v10595
     (:next-token m10594 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10595 :com.palletops.awaze.client-builder/undef)
     (. bean10593 setNextToken (clojure.core/str v10595))))
   (clojure.core/let
    [v10595
     (:max-records m10594 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10595 :com.palletops.awaze.client-builder/undef)
     (. bean10593 setMaxRecords (clojure.core/int v10595))))
   (clojure.core/let
    [v10595
     (:alarm-name-prefix
      m10594
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10595 :com.palletops.awaze.client-builder/undef)
     (. bean10593 setAlarmNamePrefix (clojure.core/str v10595))))
   (clojure.core/let
    [v10595
     (:action-prefix m10594 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10595 :com.palletops.awaze.client-builder/undef)
     (. bean10593 setActionPrefix (clojure.core/str v10595))))
   (clojure.core/let
    [v10595
     (:state-value m10594 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10595 :com.palletops.awaze.client-builder/undef)
     (. bean10593 setStateValue (cloudwatch/state-value v10595))))
   (clojure.core/let
    [v10595
     (:alarm-names m10594 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10595 :com.palletops.awaze.client-builder/undef)
     (.
      bean10593
      setAlarmNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10702] (clojure.core/str arg10702))
 v10595))))
   bean10593))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.DescribeAlarmHistoryRequest}
describe-alarm-history-request
  [m10597]
  (clojure.core/let
   [bean10596
    (new
     com.amazonaws.services.cloudwatch.model.DescribeAlarmHistoryRequest)]
   (clojure.core/let
    [v10598
     (:next-token m10597 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10598 :com.palletops.awaze.client-builder/undef)
     (. bean10596 setNextToken (clojure.core/str v10598))))
   (clojure.core/let
    [v10598
     (:max-records m10597 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10598 :com.palletops.awaze.client-builder/undef)
     (. bean10596 setMaxRecords (clojure.core/int v10598))))
   (clojure.core/let
    [v10598
     (:alarm-name m10597 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10598 :com.palletops.awaze.client-builder/undef)
     (. bean10596 setAlarmName (clojure.core/str v10598))))
   (clojure.core/let
    [v10598
     (:history-item-type
      m10597
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10598 :com.palletops.awaze.client-builder/undef)
     (.
      bean10596
      setHistoryItemType
      (cloudwatch/history-item-type v10598))))
   (clojure.core/let
    [v10598
     (:start-date m10597 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10598 :com.palletops.awaze.client-builder/undef)
     (.
      bean10596
      setStartDate
      (com.palletops.awaze.common/to-date v10598))))
   (clojure.core/let
    [v10598
     (:end-date m10597 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10598 :com.palletops.awaze.client-builder/undef)
     (.
      bean10596
      setEndDate
      (com.palletops.awaze.common/to-date v10598))))
   bean10596))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.PutMetricAlarmRequest}
put-metric-alarm-request
  [m10600]
  (clojure.core/let
   [bean10599
    (new
     com.amazonaws.services.cloudwatch.model.PutMetricAlarmRequest)]
   (clojure.core/let
    [v10601
     (:alarm-name m10600 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10601 :com.palletops.awaze.client-builder/undef)
     (. bean10599 setAlarmName (clojure.core/str v10601))))
   (clojure.core/let
    [v10601
     (:alarm-description
      m10600
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10601 :com.palletops.awaze.client-builder/undef)
     (. bean10599 setAlarmDescription (clojure.core/str v10601))))
   (clojure.core/let
    [v10601
     (:okactions m10600 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10601 :com.palletops.awaze.client-builder/undef)
     (.
      bean10599
      setOKActions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10703] (clojure.core/str arg10703))
 v10601))))
   (clojure.core/let
    [v10601 (:unit m10600 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10601 :com.palletops.awaze.client-builder/undef)
     (. bean10599 setUnit (clojure.core/str v10601))))
   (clojure.core/let
    [v10601
     (:metric-name m10600 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10601 :com.palletops.awaze.client-builder/undef)
     (. bean10599 setMetricName (clojure.core/str v10601))))
   (clojure.core/let
    [v10601
     (:dimensions m10600 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10601 :com.palletops.awaze.client-builder/undef)
     (.
      bean10599
      setDimensions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10704] (cloudwatch/dimension arg10704))
 v10601))))
   (clojure.core/let
    [v10601
     (:evaluation-periods
      m10600
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10601 :com.palletops.awaze.client-builder/undef)
     (. bean10599 setEvaluationPeriods (clojure.core/int v10601))))
   (clojure.core/let
    [v10601
     (:namespace m10600 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10601 :com.palletops.awaze.client-builder/undef)
     (. bean10599 setNamespace (clojure.core/str v10601))))
   (clojure.core/let
    [v10601
     (:period m10600 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10601 :com.palletops.awaze.client-builder/undef)
     (. bean10599 setPeriod (clojure.core/int v10601))))
   (clojure.core/let
    [v10601
     (:comparison-operator
      m10600
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10601 :com.palletops.awaze.client-builder/undef)
     (. bean10599 setComparisonOperator (clojure.core/str v10601))))
   (clojure.core/let
    [v10601
     (:actions-enabled
      m10600
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10601 :com.palletops.awaze.client-builder/undef)
     (. bean10599 setActionsEnabled (clojure.core/boolean v10601))))
   (clojure.core/let
    [v10601
     (:alarm-actions m10600 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10601 :com.palletops.awaze.client-builder/undef)
     (.
      bean10599
      setAlarmActions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10705] (clojure.core/str arg10705))
 v10601))))
   (clojure.core/let
    [v10601
     (:insufficient-data-actions
      m10600
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10601 :com.palletops.awaze.client-builder/undef)
     (.
      bean10599
      setInsufficientDataActions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10706] (clojure.core/str arg10706))
 v10601))))
   (clojure.core/let
    [v10601
     (:threshold m10600 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10601 :com.palletops.awaze.client-builder/undef)
     (. bean10599 setThreshold (clojure.core/double v10601))))
   (clojure.core/let
    [v10601
     (:statistic m10600 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10601 :com.palletops.awaze.client-builder/undef)
     (. bean10599 setStatistic (cloudwatch/statistic v10601))))
   bean10599))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.GetMetricStatisticsRequest}
get-metric-statistics-request
  [m10603]
  (clojure.core/let
   [bean10602
    (new
     com.amazonaws.services.cloudwatch.model.GetMetricStatisticsRequest)]
   (clojure.core/let
    [v10604
     (:namespace m10603 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10604 :com.palletops.awaze.client-builder/undef)
     (. bean10602 setNamespace (clojure.core/str v10604))))
   (clojure.core/let
    [v10604
     (:start-time m10603 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10604 :com.palletops.awaze.client-builder/undef)
     (.
      bean10602
      setStartTime
      (com.palletops.awaze.common/to-date v10604))))
   (clojure.core/let
    [v10604
     (:end-time m10603 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10604 :com.palletops.awaze.client-builder/undef)
     (.
      bean10602
      setEndTime
      (com.palletops.awaze.common/to-date v10604))))
   (clojure.core/let
    [v10604
     (:statistics m10603 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10604 :com.palletops.awaze.client-builder/undef)
     (.
      bean10602
      setStatistics
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10707] (clojure.core/str arg10707))
 v10604))))
   (clojure.core/let
    [v10604
     (:metric-name m10603 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10604 :com.palletops.awaze.client-builder/undef)
     (. bean10602 setMetricName (clojure.core/str v10604))))
   (clojure.core/let
    [v10604
     (:dimensions m10603 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10604 :com.palletops.awaze.client-builder/undef)
     (.
      bean10602
      setDimensions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10708] (cloudwatch/dimension arg10708))
 v10604))))
   (clojure.core/let
    [v10604
     (:period m10603 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10604 :com.palletops.awaze.client-builder/undef)
     (. bean10602 setPeriod (clojure.core/int v10604))))
   (clojure.core/let
    [v10604 (:unit m10603 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10604 :com.palletops.awaze.client-builder/undef)
     (. bean10602 setUnit (cloudwatch/standard-unit v10604))))
   bean10602))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.ListMetricsRequest}
list-metrics-request
  [m10606]
  (clojure.core/let
   [bean10605
    (new com.amazonaws.services.cloudwatch.model.ListMetricsRequest)]
   (clojure.core/let
    [v10607
     (:namespace m10606 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10607 :com.palletops.awaze.client-builder/undef)
     (. bean10605 setNamespace (clojure.core/str v10607))))
   (clojure.core/let
    [v10607
     (:next-token m10606 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10607 :com.palletops.awaze.client-builder/undef)
     (. bean10605 setNextToken (clojure.core/str v10607))))
   (clojure.core/let
    [v10607
     (:metric-name m10606 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10607 :com.palletops.awaze.client-builder/undef)
     (. bean10605 setMetricName (clojure.core/str v10607))))
   (clojure.core/let
    [v10607
     (:dimensions m10606 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10607 :com.palletops.awaze.client-builder/undef)
     (.
      bean10605
      setDimensions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10709] (cloudwatch/dimension-filter arg10709))
 v10607))))
   bean10605))
 (clojure.core/defmulti
  cloudwatch
  (clojure.core/fn cloudwatch [m__1874__auto__] (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   cloudwatch
   :delete-alarms
   [m10614]
   (clojure.core/let
    [credentials10615 (:credentials m10614) args10616 (:args m10614)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client10617
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials10615)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10617
       deleteAlarms
       (cloudwatch/delete-alarms-request
        (clojure.core/nth args10616 0)))))))
  (clojure.core/defn
   delete-alarms-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         alarm-names
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteAlarms"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-alarms,
     :credentials credentials__1842__auto__,
     :client :cloudwatch}))
  (clojure.core/defn
   delete-alarms
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         alarm-names
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteAlarms"}
   [credentials10619 & args10620]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client10621
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials10619)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10621
      deleteAlarms
      (cloudwatch/delete-alarms-request
       (clojure.core/nth args10620 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :enable-alarm-actions
   [m10622]
   (clojure.core/let
    [credentials10623 (:credentials m10622) args10624 (:args m10622)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client10625
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials10623)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10625
       enableAlarmActions
       (cloudwatch/enable-alarm-actions-request
        (clojure.core/nth args10624 0)))))))
  (clojure.core/defn
   enable-alarm-actions-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         alarm-names
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for enableAlarmActions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :enable-alarm-actions,
     :credentials credentials__1842__auto__,
     :client :cloudwatch}))
  (clojure.core/defn
   enable-alarm-actions
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         alarm-names
                         clone-source
                         clone-root]}]]),
    :doc "Call enableAlarmActions"}
   [credentials10627 & args10628]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client10629
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials10627)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10629
      enableAlarmActions
      (cloudwatch/enable-alarm-actions-request
       (clojure.core/nth args10628 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :disable-alarm-actions
   [m10630]
   (clojure.core/let
    [credentials10631 (:credentials m10630) args10632 (:args m10630)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client10633
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials10631)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10633
       disableAlarmActions
       (cloudwatch/disable-alarm-actions-request
        (clojure.core/nth args10632 0)))))))
  (clojure.core/defn
   disable-alarm-actions-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         alarm-names
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for disableAlarmActions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :disable-alarm-actions,
     :credentials credentials__1842__auto__,
     :client :cloudwatch}))
  (clojure.core/defn
   disable-alarm-actions
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         alarm-names
                         clone-source
                         clone-root]}]]),
    :doc "Call disableAlarmActions"}
   [credentials10635 & args10636]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client10637
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials10635)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10637
      disableAlarmActions
      (cloudwatch/disable-alarm-actions-request
       (clojure.core/nth args10636 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :set-alarm-state
   [m10638]
   (clojure.core/let
    [credentials10639 (:credentials m10638) args10640 (:args m10638)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client10641
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials10639)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10641
       setAlarmState
       (cloudwatch/set-alarm-state-request
        (clojure.core/nth args10640 0)))))))
  (clojure.core/defn
   set-alarm-state-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         alarm-name
                         sdk-request-timeout
                         state-value
                         custom-query-parameters
                         state-reason
                         read-limit
                         general-progress-listener
                         clone-source
                         state-reason-data
                         clone-root]}]]),
    :doc "Generate map for setAlarmState"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-alarm-state,
     :credentials credentials__1842__auto__,
     :client :cloudwatch}))
  (clojure.core/defn
   set-alarm-state
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         alarm-name
                         sdk-request-timeout
                         state-value
                         custom-query-parameters
                         state-reason
                         read-limit
                         general-progress-listener
                         clone-source
                         state-reason-data
                         clone-root]}]]),
    :doc "Call setAlarmState"}
   [credentials10643 & args10644]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client10645
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials10643)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10645
      setAlarmState
      (cloudwatch/set-alarm-state-request
       (clojure.core/nth args10644 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :describe-alarms-for-metric
   [m10646]
   (clojure.core/let
    [credentials10647 (:credentials m10646) args10648 (:args m10646)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client10649
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials10647)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10649
       describeAlarmsForMetric
       (cloudwatch/describe-alarms-for-metric-request
        (clojure.core/nth args10648 0)))))))
  (clojure.core/defn
   describe-alarms-for-metric-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         statistic
                         sdk-client-execution-timeout
                         unit
                         sdk-request-timeout
                         metric-name
                         custom-query-parameters
                         dimensions
                         read-limit
                         general-progress-listener
                         period
                         clone-source
                         namespace
                         clone-root]}]]),
    :doc "Generate map for describeAlarmsForMetric"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-alarms-for-metric,
     :credentials credentials__1842__auto__,
     :client :cloudwatch}))
  (clojure.core/defn
   describe-alarms-for-metric
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         statistic
                         sdk-client-execution-timeout
                         unit
                         sdk-request-timeout
                         metric-name
                         custom-query-parameters
                         dimensions
                         read-limit
                         general-progress-listener
                         period
                         clone-source
                         namespace
                         clone-root]}]]),
    :doc "Call describeAlarmsForMetric"}
   [credentials10651 & args10652]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client10653
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials10651)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10653
      describeAlarmsForMetric
      (cloudwatch/describe-alarms-for-metric-request
       (clojure.core/nth args10652 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :put-metric-data
   [m10654]
   (clojure.core/let
    [credentials10655 (:credentials m10654) args10656 (:args m10654)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client10657
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials10655)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10657
       putMetricData
       (cloudwatch/put-metric-data-request
        (clojure.core/nth args10656 0)))))))
  (clojure.core/defn
   put-metric-data-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         metric-data
                         general-progress-listener
                         clone-source
                         namespace
                         clone-root]}]]),
    :doc "Generate map for putMetricData"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :put-metric-data,
     :credentials credentials__1842__auto__,
     :client :cloudwatch}))
  (clojure.core/defn
   put-metric-data
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         metric-data
                         general-progress-listener
                         clone-source
                         namespace
                         clone-root]}]]),
    :doc "Call putMetricData"}
   [credentials10659 & args10660]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client10661
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials10659)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10661
      putMetricData
      (cloudwatch/put-metric-data-request
       (clojure.core/nth args10660 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :describe-alarms
   [m10662]
   (clojure.core/let
    [credentials10663 (:credentials m10662) args10664 (:args m10662)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client10665
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials10663)]
     (clojure.core/case
      (clojure.core/count args10664)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10665
        describeAlarms
        (cloudwatch/describe-alarms-request
         (clojure.core/nth args10664 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10665
        describeAlarms))))))
  (clojure.core/defn
   describe-alarms-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         alarm-name-prefix
                         state-value
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         action-prefix
                         max-records
                         alarm-names
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeAlarms, describeAlarms"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-alarms,
     :credentials credentials__1842__auto__,
     :client :cloudwatch})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-alarms,
     :credentials credentials__1842__auto__,
     :client :cloudwatch}))
  (clojure.core/defn
   describe-alarms
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         alarm-name-prefix
                         state-value
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         action-prefix
                         max-records
                         alarm-names
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call describeAlarms, describeAlarms"}
   [credentials10667 & args10668]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client10669
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials10667)]
    (clojure.core/case
     (clojure.core/count args10668)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10669
       describeAlarms
       (cloudwatch/describe-alarms-request
        (clojure.core/nth args10668 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10669
       describeAlarms))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :describe-alarm-history
   [m10670]
   (clojure.core/let
    [credentials10671 (:credentials m10670) args10672 (:args m10670)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client10673
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials10671)]
     (clojure.core/case
      (clojure.core/count args10672)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10673
        describeAlarmHistory
        (cloudwatch/describe-alarm-history-request
         (clojure.core/nth args10672 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10673
        describeAlarmHistory))))))
  (clojure.core/defn
   describe-alarm-history-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         alarm-name
                         end-date
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         history-item-type
                         max-records
                         clone-source
                         start-date
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeAlarmHistory, describeAlarmHistory"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-alarm-history,
     :credentials credentials__1842__auto__,
     :client :cloudwatch})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-alarm-history,
     :credentials credentials__1842__auto__,
     :client :cloudwatch}))
  (clojure.core/defn
   describe-alarm-history
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         alarm-name
                         end-date
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         history-item-type
                         max-records
                         clone-source
                         start-date
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call describeAlarmHistory, describeAlarmHistory"}
   [credentials10675 & args10676]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client10677
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials10675)]
    (clojure.core/case
     (clojure.core/count args10676)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10677
       describeAlarmHistory
       (cloudwatch/describe-alarm-history-request
        (clojure.core/nth args10676 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10677
       describeAlarmHistory))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :put-metric-alarm
   [m10678]
   (clojure.core/let
    [credentials10679 (:credentials m10678) args10680 (:args m10678)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client10681
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials10679)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10681
       putMetricAlarm
       (cloudwatch/put-metric-alarm-request
        (clojure.core/nth args10680 0)))))))
  (clojure.core/defn
   put-metric-alarm-map
   {:arglists (quote
               [[credentials
                 {:keys [evaluation-periods
                         custom-request-headers
                         statistic
                         sdk-client-execution-timeout
                         alarm-name
                         actions-enabled
                         unit
                         sdk-request-timeout
                         insufficient-data-actions
                         alarm-actions
                         metric-name
                         custom-query-parameters
                         comparison-operator
                         threshold
                         dimensions
                         alarm-description
                         read-limit
                         general-progress-listener
                         period
                         clone-source
                         okactions
                         namespace
                         clone-root]}]]),
    :doc "Generate map for putMetricAlarm"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :put-metric-alarm,
     :credentials credentials__1842__auto__,
     :client :cloudwatch}))
  (clojure.core/defn
   put-metric-alarm
   {:arglists (quote
               [[credentials
                 {:keys [evaluation-periods
                         custom-request-headers
                         statistic
                         sdk-client-execution-timeout
                         alarm-name
                         actions-enabled
                         unit
                         sdk-request-timeout
                         insufficient-data-actions
                         alarm-actions
                         metric-name
                         custom-query-parameters
                         comparison-operator
                         threshold
                         dimensions
                         alarm-description
                         read-limit
                         general-progress-listener
                         period
                         clone-source
                         okactions
                         namespace
                         clone-root]}]]),
    :doc "Call putMetricAlarm"}
   [credentials10683 & args10684]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client10685
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials10683)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10685
      putMetricAlarm
      (cloudwatch/put-metric-alarm-request
       (clojure.core/nth args10684 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :get-metric-statistics
   [m10686]
   (clojure.core/let
    [credentials10687 (:credentials m10686) args10688 (:args m10686)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client10689
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials10687)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10689
       getMetricStatistics
       (cloudwatch/get-metric-statistics-request
        (clojure.core/nth args10688 0)))))))
  (clojure.core/defn
   get-metric-statistics-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         unit
                         sdk-request-timeout
                         metric-name
                         start-time
                         custom-query-parameters
                         end-time
                         dimensions
                         statistics
                         read-limit
                         general-progress-listener
                         period
                         clone-source
                         namespace
                         clone-root]}]]),
    :doc "Generate map for getMetricStatistics"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-metric-statistics,
     :credentials credentials__1842__auto__,
     :client :cloudwatch}))
  (clojure.core/defn
   get-metric-statistics
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         unit
                         sdk-request-timeout
                         metric-name
                         start-time
                         custom-query-parameters
                         end-time
                         dimensions
                         statistics
                         read-limit
                         general-progress-listener
                         period
                         clone-source
                         namespace
                         clone-root]}]]),
    :doc "Call getMetricStatistics"}
   [credentials10691 & args10692]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client10693
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials10691)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10693
      getMetricStatistics
      (cloudwatch/get-metric-statistics-request
       (clojure.core/nth args10692 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :list-metrics
   [m10694]
   (clojure.core/let
    [credentials10695 (:credentials m10694) args10696 (:args m10694)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client10697
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials10695)]
     (clojure.core/case
      (clojure.core/count args10696)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10697
        listMetrics))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10697
        listMetrics
        (cloudwatch/list-metrics-request
         (clojure.core/nth args10696 0))))))))
  (clojure.core/defn
   list-metrics-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         metric-name
                         custom-query-parameters
                         dimensions
                         read-limit
                         general-progress-listener
                         clone-source
                         namespace
                         clone-root
                         next-token]}]]),
    :doc "Generate map for listMetrics, listMetrics"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-metrics,
     :credentials credentials__1842__auto__,
     :client :cloudwatch})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-metrics,
     :credentials credentials__1842__auto__,
     :client :cloudwatch}))
  (clojure.core/defn
   list-metrics
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         metric-name
                         custom-query-parameters
                         dimensions
                         read-limit
                         general-progress-listener
                         clone-source
                         namespace
                         clone-root
                         next-token]}]]),
    :doc "Call listMetrics, listMetrics"}
   [credentials10699 & args10700]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client10701
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials10699)]
    (clojure.core/case
     (clojure.core/count args10700)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10701
       listMetrics))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10701
       listMetrics
       (cloudwatch/list-metrics-request
        (clojure.core/nth args10700 0)))))))))
