(ns
 com.palletops.awaze.cloudsearch
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.cloudsearch :as cloudsearch]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :cloudsearch
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.cloudsearch.AmazonCloudSearchClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.SourceData}
source-data
  [m7885]
  (clojure.core/let
   [bean7884
    (new com.amazonaws.services.cloudsearch.model.SourceData)]
   (clojure.core/let
    [v7886
     (:default-value m7885 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7886 :com.palletops.awaze.client-builder/undef)
     (. bean7884 setDefaultValue (clojure.core/str v7886))))
   (clojure.core/let
    [v7886
     (:source-name m7885 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7886 :com.palletops.awaze.client-builder/undef)
     (. bean7884 setSourceName (clojure.core/str v7886))))
   bean7884))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.SourceDataTrimTitle}
source-data-trim-title
  [m7888]
  (clojure.core/let
   [bean7887
    (new com.amazonaws.services.cloudsearch.model.SourceDataTrimTitle)]
   (clojure.core/let
    [v7889
     (:language m7888 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7889 :com.palletops.awaze.client-builder/undef)
     (. bean7887 setLanguage (clojure.core/str v7889))))
   (clojure.core/let
    [v7889
     (:default-value m7888 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7889 :com.palletops.awaze.client-builder/undef)
     (. bean7887 setDefaultValue (clojure.core/str v7889))))
   (clojure.core/let
    [v7889
     (:source-name m7888 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7889 :com.palletops.awaze.client-builder/undef)
     (. bean7887 setSourceName (clojure.core/str v7889))))
   (clojure.core/let
    [v7889
     (:separator m7888 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7889 :com.palletops.awaze.client-builder/undef)
     (. bean7887 setSeparator (clojure.core/str v7889))))
   bean7887))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.SourceDataMap}
source-data-map
  [m7891]
  (clojure.core/let
   [bean7890
    (new com.amazonaws.services.cloudsearch.model.SourceDataMap)]
   (clojure.core/let
    [v7892
     (:default-value m7891 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7892 :com.palletops.awaze.client-builder/undef)
     (. bean7890 setDefaultValue (clojure.core/str v7892))))
   (clojure.core/let
    [v7892 (:cases m7891 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7892 :com.palletops.awaze.client-builder/undef)
     (.
      bean7890
      setCases
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg7977] (clojure.core/str arg7977))
  (clojure.core/keys v7892))
 (clojure.core/map
  (clojure.core/fn [arg7977] (clojure.core/str arg7977))
  (clojure.core/vals v7892))))))
   (clojure.core/let
    [v7892
     (:source-name m7891 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7892 :com.palletops.awaze.client-builder/undef)
     (. bean7890 setSourceName (clojure.core/str v7892))))
   bean7890))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.LiteralOptions}
literal-options
  [m7894]
  (clojure.core/let
   [bean7893
    (new com.amazonaws.services.cloudsearch.model.LiteralOptions)]
   (clojure.core/let
    [v7895
     (:result-enabled m7894 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7895 :com.palletops.awaze.client-builder/undef)
     (. bean7893 setResultEnabled (clojure.core/boolean v7895))))
   (clojure.core/let
    [v7895
     (:default-value m7894 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7895 :com.palletops.awaze.client-builder/undef)
     (. bean7893 setDefaultValue (clojure.core/str v7895))))
   (clojure.core/let
    [v7895
     (:facet-enabled m7894 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7895 :com.palletops.awaze.client-builder/undef)
     (. bean7893 setFacetEnabled (clojure.core/boolean v7895))))
   (clojure.core/let
    [v7895
     (:search-enabled m7894 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7895 :com.palletops.awaze.client-builder/undef)
     (. bean7893 setSearchEnabled (clojure.core/boolean v7895))))
   bean7893))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.TextOptions}
text-options
  [m7897]
  (clojure.core/let
   [bean7896
    (new com.amazonaws.services.cloudsearch.model.TextOptions)]
   (clojure.core/let
    [v7898
     (:result-enabled m7897 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7898 :com.palletops.awaze.client-builder/undef)
     (. bean7896 setResultEnabled (clojure.core/boolean v7898))))
   (clojure.core/let
    [v7898
     (:default-value m7897 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7898 :com.palletops.awaze.client-builder/undef)
     (. bean7896 setDefaultValue (clojure.core/str v7898))))
   (clojure.core/let
    [v7898
     (:facet-enabled m7897 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7898 :com.palletops.awaze.client-builder/undef)
     (. bean7896 setFacetEnabled (clojure.core/boolean v7898))))
   (clojure.core/let
    [v7898
     (:text-processor m7897 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7898 :com.palletops.awaze.client-builder/undef)
     (. bean7896 setTextProcessor (clojure.core/str v7898))))
   bean7896))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.SourceAttribute}
source-attribute
  [m7900]
  (clojure.core/let
   [bean7899
    (new com.amazonaws.services.cloudsearch.model.SourceAttribute)]
   (clojure.core/let
    [v7901
     (:source-data-function
      m7900
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7901 :com.palletops.awaze.client-builder/undef)
     (. bean7899 setSourceDataFunction (clojure.core/str v7901))))
   (clojure.core/let
    [v7901
     (:source-data-copy
      m7900
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7901 :com.palletops.awaze.client-builder/undef)
     (. bean7899 setSourceDataCopy (cloudsearch/source-data v7901))))
   (clojure.core/let
    [v7901
     (:source-data-trim-title
      m7900
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7901 :com.palletops.awaze.client-builder/undef)
     (.
      bean7899
      setSourceDataTrimTitle
      (cloudsearch/source-data-trim-title v7901))))
   (clojure.core/let
    [v7901
     (:source-data-map
      m7900
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7901 :com.palletops.awaze.client-builder/undef)
     (. bean7899 setSourceDataMap (cloudsearch/source-data-map v7901))))
   bean7899))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.UIntOptions}
uint-options
  [m7903]
  (clojure.core/let
   [bean7902
    (new com.amazonaws.services.cloudsearch.model.UIntOptions)]
   (clojure.core/let
    [v7904
     (:default-value m7903 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7904 :com.palletops.awaze.client-builder/undef)
     (. bean7902 setDefaultValue (clojure.core/int v7904))))
   bean7902))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.NamedRankExpression}
named-rank-expression
  [m7906]
  (clojure.core/let
   [bean7905
    (new com.amazonaws.services.cloudsearch.model.NamedRankExpression)]
   (clojure.core/let
    [v7907
     (:rank-expression
      m7906
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7907 :com.palletops.awaze.client-builder/undef)
     (. bean7905 setRankExpression (clojure.core/str v7907))))
   (clojure.core/let
    [v7907
     (:rank-name m7906 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7907 :com.palletops.awaze.client-builder/undef)
     (. bean7905 setRankName (clojure.core/str v7907))))
   bean7905))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.IndexField}
index-field
  [m7909]
  (clojure.core/let
   [bean7908
    (new com.amazonaws.services.cloudsearch.model.IndexField)]
   (clojure.core/let
    [v7910
     (:literal-options
      m7909
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7910 :com.palletops.awaze.client-builder/undef)
     (.
      bean7908
      setLiteralOptions
      (cloudsearch/literal-options v7910))))
   (clojure.core/let
    [v7910
     (:text-options m7909 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7910 :com.palletops.awaze.client-builder/undef)
     (. bean7908 setTextOptions (cloudsearch/text-options v7910))))
   (clojure.core/let
    [v7910
     (:source-attributes
      m7909
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7910 :com.palletops.awaze.client-builder/undef)
     (.
      bean7908
      setSourceAttributes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7978] (cloudsearch/source-attribute arg7978))
 v7910))))
   (clojure.core/let
    [v7910
     (:index-field-name
      m7909
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7910 :com.palletops.awaze.client-builder/undef)
     (. bean7908 setIndexFieldName (clojure.core/str v7910))))
   (clojure.core/let
    [v7910
     (:index-field-type
      m7909
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7910 :com.palletops.awaze.client-builder/undef)
     (. bean7908 setIndexFieldType (clojure.core/str v7910))))
   (clojure.core/let
    [v7910
     (:uint-options m7909 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7910 :com.palletops.awaze.client-builder/undef)
     (. bean7908 setUIntOptions (cloudsearch/uint-options v7910))))
   bean7908))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.UpdateStemmingOptionsRequest}
update-stemming-options-request
  [m7912]
  (clojure.core/let
   [bean7911
    (new
     com.amazonaws.services.cloudsearch.model.UpdateStemmingOptionsRequest)]
   (clojure.core/let
    [v7913
     (:domain-name m7912 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7913 :com.palletops.awaze.client-builder/undef)
     (. bean7911 setDomainName (clojure.core/str v7913))))
   (clojure.core/let
    [v7913 (:stems m7912 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7913 :com.palletops.awaze.client-builder/undef)
     (. bean7911 setStems (clojure.core/str v7913))))
   bean7911))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.UpdateSynonymOptionsRequest}
update-synonym-options-request
  [m7915]
  (clojure.core/let
   [bean7914
    (new
     com.amazonaws.services.cloudsearch.model.UpdateSynonymOptionsRequest)]
   (clojure.core/let
    [v7916
     (:domain-name m7915 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7916 :com.palletops.awaze.client-builder/undef)
     (. bean7914 setDomainName (clojure.core/str v7916))))
   (clojure.core/let
    [v7916
     (:synonyms m7915 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7916 :com.palletops.awaze.client-builder/undef)
     (. bean7914 setSynonyms (clojure.core/str v7916))))
   bean7914))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DeleteDomainRequest}
delete-domain-request
  [m7918]
  (clojure.core/let
   [bean7917
    (new com.amazonaws.services.cloudsearch.model.DeleteDomainRequest)]
   (clojure.core/let
    [v7919
     (:domain-name m7918 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7919 :com.palletops.awaze.client-builder/undef)
     (. bean7917 setDomainName (clojure.core/str v7919))))
   bean7917))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DefineRankExpressionRequest}
define-rank-expression-request
  [m7921]
  (clojure.core/let
   [bean7920
    (new
     com.amazonaws.services.cloudsearch.model.DefineRankExpressionRequest)]
   (clojure.core/let
    [v7922
     (:domain-name m7921 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7922 :com.palletops.awaze.client-builder/undef)
     (. bean7920 setDomainName (clojure.core/str v7922))))
   (clojure.core/let
    [v7922
     (:rank-expression
      m7921
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7922 :com.palletops.awaze.client-builder/undef)
     (.
      bean7920
      setRankExpression
      (cloudsearch/named-rank-expression v7922))))
   bean7920))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.UpdateStopwordOptionsRequest}
update-stopword-options-request
  [m7924]
  (clojure.core/let
   [bean7923
    (new
     com.amazonaws.services.cloudsearch.model.UpdateStopwordOptionsRequest)]
   (clojure.core/let
    [v7925
     (:domain-name m7924 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7925 :com.palletops.awaze.client-builder/undef)
     (. bean7923 setDomainName (clojure.core/str v7925))))
   (clojure.core/let
    [v7925
     (:stopwords m7924 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7925 :com.palletops.awaze.client-builder/undef)
     (. bean7923 setStopwords (clojure.core/str v7925))))
   bean7923))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DescribeDomainsRequest}
describe-domains-request
  [m7927]
  (clojure.core/let
   [bean7926
    (new
     com.amazonaws.services.cloudsearch.model.DescribeDomainsRequest)]
   (clojure.core/let
    [v7928
     (:domain-names m7927 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7928 :com.palletops.awaze.client-builder/undef)
     (.
      bean7926
      setDomainNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7979] (clojure.core/str arg7979))
 v7928))))
   bean7926))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DescribeRankExpressionsRequest}
describe-rank-expressions-request
  [m7930]
  (clojure.core/let
   [bean7929
    (new
     com.amazonaws.services.cloudsearch.model.DescribeRankExpressionsRequest)]
   (clojure.core/let
    [v7931
     (:domain-name m7930 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7931 :com.palletops.awaze.client-builder/undef)
     (. bean7929 setDomainName (clojure.core/str v7931))))
   (clojure.core/let
    [v7931
     (:rank-names m7930 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7931 :com.palletops.awaze.client-builder/undef)
     (.
      bean7929
      setRankNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7980] (clojure.core/str arg7980))
 v7931))))
   bean7929))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.IndexDocumentsRequest}
index-documents-request
  [m7933]
  (clojure.core/let
   [bean7932
    (new
     com.amazonaws.services.cloudsearch.model.IndexDocumentsRequest)]
   (clojure.core/let
    [v7934
     (:domain-name m7933 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7934 :com.palletops.awaze.client-builder/undef)
     (. bean7932 setDomainName (clojure.core/str v7934))))
   bean7932))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DescribeStemmingOptionsRequest}
describe-stemming-options-request
  [m7936]
  (clojure.core/let
   [bean7935
    (new
     com.amazonaws.services.cloudsearch.model.DescribeStemmingOptionsRequest)]
   (clojure.core/let
    [v7937
     (:domain-name m7936 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7937 :com.palletops.awaze.client-builder/undef)
     (. bean7935 setDomainName (clojure.core/str v7937))))
   bean7935))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DefineIndexFieldRequest}
define-index-field-request
  [m7939]
  (clojure.core/let
   [bean7938
    (new
     com.amazonaws.services.cloudsearch.model.DefineIndexFieldRequest)]
   (clojure.core/let
    [v7940
     (:domain-name m7939 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7940 :com.palletops.awaze.client-builder/undef)
     (. bean7938 setDomainName (clojure.core/str v7940))))
   (clojure.core/let
    [v7940
     (:index-field m7939 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7940 :com.palletops.awaze.client-builder/undef)
     (. bean7938 setIndexField (cloudsearch/index-field v7940))))
   bean7938))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DescribeDefaultSearchFieldRequest}
describe-default-search-field-request
  [m7942]
  (clojure.core/let
   [bean7941
    (new
     com.amazonaws.services.cloudsearch.model.DescribeDefaultSearchFieldRequest)]
   (clojure.core/let
    [v7943
     (:domain-name m7942 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7943 :com.palletops.awaze.client-builder/undef)
     (. bean7941 setDomainName (clojure.core/str v7943))))
   bean7941))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.UpdateDefaultSearchFieldRequest}
update-default-search-field-request
  [m7945]
  (clojure.core/let
   [bean7944
    (new
     com.amazonaws.services.cloudsearch.model.UpdateDefaultSearchFieldRequest)]
   (clojure.core/let
    [v7946
     (:domain-name m7945 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7946 :com.palletops.awaze.client-builder/undef)
     (. bean7944 setDomainName (clojure.core/str v7946))))
   (clojure.core/let
    [v7946
     (:default-search-field
      m7945
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7946 :com.palletops.awaze.client-builder/undef)
     (. bean7944 setDefaultSearchField (clojure.core/str v7946))))
   bean7944))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DescribeIndexFieldsRequest}
describe-index-fields-request
  [m7948]
  (clojure.core/let
   [bean7947
    (new
     com.amazonaws.services.cloudsearch.model.DescribeIndexFieldsRequest)]
   (clojure.core/let
    [v7949
     (:domain-name m7948 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7949 :com.palletops.awaze.client-builder/undef)
     (. bean7947 setDomainName (clojure.core/str v7949))))
   (clojure.core/let
    [v7949
     (:field-names m7948 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7949 :com.palletops.awaze.client-builder/undef)
     (.
      bean7947
      setFieldNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7981] (clojure.core/str arg7981))
 v7949))))
   bean7947))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.UpdateAvailabilityOptionsRequest}
update-availability-options-request
  [m7951]
  (clojure.core/let
   [bean7950
    (new
     com.amazonaws.services.cloudsearch.model.UpdateAvailabilityOptionsRequest)]
   (clojure.core/let
    [v7952
     (:multi-az m7951 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7952 :com.palletops.awaze.client-builder/undef)
     (. bean7950 setMultiAZ (clojure.core/boolean v7952))))
   (clojure.core/let
    [v7952
     (:domain-name m7951 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7952 :com.palletops.awaze.client-builder/undef)
     (. bean7950 setDomainName (clojure.core/str v7952))))
   bean7950))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.UpdateServiceAccessPoliciesRequest}
update-service-access-policies-request
  [m7954]
  (clojure.core/let
   [bean7953
    (new
     com.amazonaws.services.cloudsearch.model.UpdateServiceAccessPoliciesRequest)]
   (clojure.core/let
    [v7955
     (:access-policies
      m7954
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7955 :com.palletops.awaze.client-builder/undef)
     (. bean7953 setAccessPolicies (clojure.core/str v7955))))
   (clojure.core/let
    [v7955
     (:domain-name m7954 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7955 :com.palletops.awaze.client-builder/undef)
     (. bean7953 setDomainName (clojure.core/str v7955))))
   bean7953))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DescribeServiceAccessPoliciesRequest}
describe-service-access-policies-request
  [m7957]
  (clojure.core/let
   [bean7956
    (new
     com.amazonaws.services.cloudsearch.model.DescribeServiceAccessPoliciesRequest)]
   (clojure.core/let
    [v7958
     (:domain-name m7957 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7958 :com.palletops.awaze.client-builder/undef)
     (. bean7956 setDomainName (clojure.core/str v7958))))
   bean7956))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DescribeStopwordOptionsRequest}
describe-stopword-options-request
  [m7960]
  (clojure.core/let
   [bean7959
    (new
     com.amazonaws.services.cloudsearch.model.DescribeStopwordOptionsRequest)]
   (clojure.core/let
    [v7961
     (:domain-name m7960 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7961 :com.palletops.awaze.client-builder/undef)
     (. bean7959 setDomainName (clojure.core/str v7961))))
   bean7959))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DescribeSynonymOptionsRequest}
describe-synonym-options-request
  [m7963]
  (clojure.core/let
   [bean7962
    (new
     com.amazonaws.services.cloudsearch.model.DescribeSynonymOptionsRequest)]
   (clojure.core/let
    [v7964
     (:domain-name m7963 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7964 :com.palletops.awaze.client-builder/undef)
     (. bean7962 setDomainName (clojure.core/str v7964))))
   bean7962))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DeleteRankExpressionRequest}
delete-rank-expression-request
  [m7966]
  (clojure.core/let
   [bean7965
    (new
     com.amazonaws.services.cloudsearch.model.DeleteRankExpressionRequest)]
   (clojure.core/let
    [v7967
     (:domain-name m7966 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7967 :com.palletops.awaze.client-builder/undef)
     (. bean7965 setDomainName (clojure.core/str v7967))))
   (clojure.core/let
    [v7967
     (:rank-name m7966 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7967 :com.palletops.awaze.client-builder/undef)
     (. bean7965 setRankName (clojure.core/str v7967))))
   bean7965))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DeleteIndexFieldRequest}
delete-index-field-request
  [m7969]
  (clojure.core/let
   [bean7968
    (new
     com.amazonaws.services.cloudsearch.model.DeleteIndexFieldRequest)]
   (clojure.core/let
    [v7970
     (:domain-name m7969 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7970 :com.palletops.awaze.client-builder/undef)
     (. bean7968 setDomainName (clojure.core/str v7970))))
   (clojure.core/let
    [v7970
     (:index-field-name
      m7969
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7970 :com.palletops.awaze.client-builder/undef)
     (. bean7968 setIndexFieldName (clojure.core/str v7970))))
   bean7968))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DescribeAvailabilityOptionsRequest}
describe-availability-options-request
  [m7972]
  (clojure.core/let
   [bean7971
    (new
     com.amazonaws.services.cloudsearch.model.DescribeAvailabilityOptionsRequest)]
   (clojure.core/let
    [v7973
     (:domain-name m7972 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7973 :com.palletops.awaze.client-builder/undef)
     (. bean7971 setDomainName (clojure.core/str v7973))))
   bean7971))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.CreateDomainRequest}
create-domain-request
  [m7975]
  (clojure.core/let
   [bean7974
    (new com.amazonaws.services.cloudsearch.model.CreateDomainRequest)]
   (clojure.core/let
    [v7976
     (:domain-name m7975 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7976 :com.palletops.awaze.client-builder/undef)
     (. bean7974 setDomainName (clojure.core/str v7976))))
   bean7974))
 (clojure.core/defmulti
  cloudsearch
  (clojure.core/fn
   cloudsearch
   [m__1874__auto__]
   (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   cloudsearch
   :update-stemming-options
   [m7982]
   (clojure.core/let
    [credentials7983 (:credentials m7982) args7984 (:args m7982)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client7985
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials7983)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client7985
       updateStemmingOptions
       (cloudsearch/update-stemming-options-request
        (clojure.core/nth args7984 0)))))))
  (clojure.core/defn
   update-stemming-options-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         stems
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateStemmingOptions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-stemming-options,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   update-stemming-options
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         stems
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateStemmingOptions"}
   [credentials7987 & args7988]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client7989
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials7987)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client7989
      updateStemmingOptions
      (cloudsearch/update-stemming-options-request
       (clojure.core/nth args7988 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :update-synonym-options
   [m7990]
   (clojure.core/let
    [credentials7991 (:credentials m7990) args7992 (:args m7990)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client7993
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials7991)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client7993
       updateSynonymOptions
       (cloudsearch/update-synonym-options-request
        (clojure.core/nth args7992 0)))))))
  (clojure.core/defn
   update-synonym-options-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         synonyms
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateSynonymOptions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-synonym-options,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   update-synonym-options
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         synonyms
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateSynonymOptions"}
   [credentials7995 & args7996]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client7997
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials7995)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client7997
      updateSynonymOptions
      (cloudsearch/update-synonym-options-request
       (clojure.core/nth args7996 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :delete-domain
   [m7998]
   (clojure.core/let
    [credentials7999 (:credentials m7998) args8000 (:args m7998)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8001
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials7999)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8001
       deleteDomain
       (cloudsearch/delete-domain-request
        (clojure.core/nth args8000 0)))))))
  (clojure.core/defn
   delete-domain-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteDomain"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-domain,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   delete-domain
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteDomain"}
   [credentials8003 & args8004]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8005
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8003)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8005
      deleteDomain
      (cloudsearch/delete-domain-request
       (clojure.core/nth args8004 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :define-rank-expression
   [m8006]
   (clojure.core/let
    [credentials8007 (:credentials m8006) args8008 (:args m8006)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8009
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8007)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8009
       defineRankExpression
       (cloudsearch/define-rank-expression-request
        (clojure.core/nth args8008 0)))))))
  (clojure.core/defn
   define-rank-expression-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         rank-expression
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for defineRankExpression"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :define-rank-expression,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   define-rank-expression
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         rank-expression
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call defineRankExpression"}
   [credentials8011 & args8012]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8013
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8011)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8013
      defineRankExpression
      (cloudsearch/define-rank-expression-request
       (clojure.core/nth args8012 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :update-stopword-options
   [m8014]
   (clojure.core/let
    [credentials8015 (:credentials m8014) args8016 (:args m8014)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8017
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8015)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8017
       updateStopwordOptions
       (cloudsearch/update-stopword-options-request
        (clojure.core/nth args8016 0)))))))
  (clojure.core/defn
   update-stopword-options-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         stopwords
                         clone-root]}]]),
    :doc "Generate map for updateStopwordOptions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-stopword-options,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   update-stopword-options
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         stopwords
                         clone-root]}]]),
    :doc "Call updateStopwordOptions"}
   [credentials8019 & args8020]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8021
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8019)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8021
      updateStopwordOptions
      (cloudsearch/update-stopword-options-request
       (clojure.core/nth args8020 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-domains
   [m8022]
   (clojure.core/let
    [credentials8023 (:credentials m8022) args8024 (:args m8022)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8025
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8023)]
     (clojure.core/case
      (clojure.core/count args8024)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8025
        describeDomains
        (cloudsearch/describe-domains-request
         (clojure.core/nth args8024 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8025
        describeDomains))))))
  (clojure.core/defn
   describe-domains-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         domain-names
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeDomains, describeDomains"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-domains,
     :credentials credentials__1842__auto__,
     :client :cloudsearch})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-domains,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   describe-domains
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         domain-names
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeDomains, describeDomains"}
   [credentials8027 & args8028]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8029
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8027)]
    (clojure.core/case
     (clojure.core/count args8028)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8029
       describeDomains
       (cloudsearch/describe-domains-request
        (clojure.core/nth args8028 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8029
       describeDomains))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-rank-expressions
   [m8030]
   (clojure.core/let
    [credentials8031 (:credentials m8030) args8032 (:args m8030)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8033
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8031)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8033
       describeRankExpressions
       (cloudsearch/describe-rank-expressions-request
        (clojure.core/nth args8032 0)))))))
  (clojure.core/defn
   describe-rank-expressions-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         rank-names
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeRankExpressions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-rank-expressions,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   describe-rank-expressions
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         rank-names
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeRankExpressions"}
   [credentials8035 & args8036]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8037
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8035)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8037
      describeRankExpressions
      (cloudsearch/describe-rank-expressions-request
       (clojure.core/nth args8036 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :index-documents
   [m8038]
   (clojure.core/let
    [credentials8039 (:credentials m8038) args8040 (:args m8038)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8041
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8039)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8041
       indexDocuments
       (cloudsearch/index-documents-request
        (clojure.core/nth args8040 0)))))))
  (clojure.core/defn
   index-documents-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for indexDocuments"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :index-documents,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   index-documents
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call indexDocuments"}
   [credentials8043 & args8044]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8045
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8043)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8045
      indexDocuments
      (cloudsearch/index-documents-request
       (clojure.core/nth args8044 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-stemming-options
   [m8046]
   (clojure.core/let
    [credentials8047 (:credentials m8046) args8048 (:args m8046)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8049
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8047)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8049
       describeStemmingOptions
       (cloudsearch/describe-stemming-options-request
        (clojure.core/nth args8048 0)))))))
  (clojure.core/defn
   describe-stemming-options-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeStemmingOptions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-stemming-options,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   describe-stemming-options
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeStemmingOptions"}
   [credentials8051 & args8052]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8053
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8051)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8053
      describeStemmingOptions
      (cloudsearch/describe-stemming-options-request
       (clojure.core/nth args8052 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :define-index-field
   [m8054]
   (clojure.core/let
    [credentials8055 (:credentials m8054) args8056 (:args m8054)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8057
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8055)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8057
       defineIndexField
       (cloudsearch/define-index-field-request
        (clojure.core/nth args8056 0)))))))
  (clojure.core/defn
   define-index-field-map
   {:arglists (quote
               [[credentials
                 {:keys [index-field
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for defineIndexField"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :define-index-field,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   define-index-field
   {:arglists (quote
               [[credentials
                 {:keys [index-field
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call defineIndexField"}
   [credentials8059 & args8060]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8061
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8059)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8061
      defineIndexField
      (cloudsearch/define-index-field-request
       (clojure.core/nth args8060 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-default-search-field
   [m8062]
   (clojure.core/let
    [credentials8063 (:credentials m8062) args8064 (:args m8062)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8065
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8063)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8065
       describeDefaultSearchField
       (cloudsearch/describe-default-search-field-request
        (clojure.core/nth args8064 0)))))))
  (clojure.core/defn
   describe-default-search-field-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeDefaultSearchField"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-default-search-field,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   describe-default-search-field
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeDefaultSearchField"}
   [credentials8067 & args8068]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8069
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8067)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8069
      describeDefaultSearchField
      (cloudsearch/describe-default-search-field-request
       (clojure.core/nth args8068 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :update-default-search-field
   [m8070]
   (clojure.core/let
    [credentials8071 (:credentials m8070) args8072 (:args m8070)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8073
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8071)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8073
       updateDefaultSearchField
       (cloudsearch/update-default-search-field-request
        (clojure.core/nth args8072 0)))))))
  (clojure.core/defn
   update-default-search-field-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root
                         default-search-field]}]]),
    :doc "Generate map for updateDefaultSearchField"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-default-search-field,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   update-default-search-field
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root
                         default-search-field]}]]),
    :doc "Call updateDefaultSearchField"}
   [credentials8075 & args8076]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8077
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8075)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8077
      updateDefaultSearchField
      (cloudsearch/update-default-search-field-request
       (clojure.core/nth args8076 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-index-fields
   [m8078]
   (clojure.core/let
    [credentials8079 (:credentials m8078) args8080 (:args m8078)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8081
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8079)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8081
       describeIndexFields
       (cloudsearch/describe-index-fields-request
        (clojure.core/nth args8080 0)))))))
  (clojure.core/defn
   describe-index-fields-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         field-names
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeIndexFields"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-index-fields,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   describe-index-fields
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         field-names
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeIndexFields"}
   [credentials8083 & args8084]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8085
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8083)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8085
      describeIndexFields
      (cloudsearch/describe-index-fields-request
       (clojure.core/nth args8084 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :update-availability-options
   [m8086]
   (clojure.core/let
    [credentials8087 (:credentials m8086) args8088 (:args m8086)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8089
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8087)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8089
       updateAvailabilityOptions
       (cloudsearch/update-availability-options-request
        (clojure.core/nth args8088 0)))))))
  (clojure.core/defn
   update-availability-options-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         multi-az
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateAvailabilityOptions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-availability-options,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   update-availability-options
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         multi-az
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateAvailabilityOptions"}
   [credentials8091 & args8092]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8093
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8091)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8093
      updateAvailabilityOptions
      (cloudsearch/update-availability-options-request
       (clojure.core/nth args8092 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :update-service-access-policies
   [m8094]
   (clojure.core/let
    [credentials8095 (:credentials m8094) args8096 (:args m8094)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8097
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8095)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8097
       updateServiceAccessPolicies
       (cloudsearch/update-service-access-policies-request
        (clojure.core/nth args8096 0)))))))
  (clojure.core/defn
   update-service-access-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         access-policies
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateServiceAccessPolicies"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-service-access-policies,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   update-service-access-policies
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         access-policies
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateServiceAccessPolicies"}
   [credentials8099 & args8100]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8101
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8099)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8101
      updateServiceAccessPolicies
      (cloudsearch/update-service-access-policies-request
       (clojure.core/nth args8100 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-service-access-policies
   [m8102]
   (clojure.core/let
    [credentials8103 (:credentials m8102) args8104 (:args m8102)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8105
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8103)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8105
       describeServiceAccessPolicies
       (cloudsearch/describe-service-access-policies-request
        (clojure.core/nth args8104 0)))))))
  (clojure.core/defn
   describe-service-access-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeServiceAccessPolicies"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-service-access-policies,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   describe-service-access-policies
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeServiceAccessPolicies"}
   [credentials8107 & args8108]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8109
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8107)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8109
      describeServiceAccessPolicies
      (cloudsearch/describe-service-access-policies-request
       (clojure.core/nth args8108 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-stopword-options
   [m8110]
   (clojure.core/let
    [credentials8111 (:credentials m8110) args8112 (:args m8110)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8113
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8111)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8113
       describeStopwordOptions
       (cloudsearch/describe-stopword-options-request
        (clojure.core/nth args8112 0)))))))
  (clojure.core/defn
   describe-stopword-options-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeStopwordOptions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-stopword-options,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   describe-stopword-options
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeStopwordOptions"}
   [credentials8115 & args8116]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8117
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8115)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8117
      describeStopwordOptions
      (cloudsearch/describe-stopword-options-request
       (clojure.core/nth args8116 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-synonym-options
   [m8118]
   (clojure.core/let
    [credentials8119 (:credentials m8118) args8120 (:args m8118)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8121
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8119)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8121
       describeSynonymOptions
       (cloudsearch/describe-synonym-options-request
        (clojure.core/nth args8120 0)))))))
  (clojure.core/defn
   describe-synonym-options-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeSynonymOptions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-synonym-options,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   describe-synonym-options
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeSynonymOptions"}
   [credentials8123 & args8124]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8125
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8123)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8125
      describeSynonymOptions
      (cloudsearch/describe-synonym-options-request
       (clojure.core/nth args8124 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :delete-rank-expression
   [m8126]
   (clojure.core/let
    [credentials8127 (:credentials m8126) args8128 (:args m8126)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8129
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8127)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8129
       deleteRankExpression
       (cloudsearch/delete-rank-expression-request
        (clojure.core/nth args8128 0)))))))
  (clojure.core/defn
   delete-rank-expression-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         rank-name
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteRankExpression"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-rank-expression,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   delete-rank-expression
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         rank-name
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteRankExpression"}
   [credentials8131 & args8132]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8133
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8131)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8133
      deleteRankExpression
      (cloudsearch/delete-rank-expression-request
       (clojure.core/nth args8132 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :delete-index-field
   [m8134]
   (clojure.core/let
    [credentials8135 (:credentials m8134) args8136 (:args m8134)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8137
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8135)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8137
       deleteIndexField
       (cloudsearch/delete-index-field-request
        (clojure.core/nth args8136 0)))))))
  (clojure.core/defn
   delete-index-field-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         index-field-name
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteIndexField"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-index-field,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   delete-index-field
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         index-field-name
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteIndexField"}
   [credentials8139 & args8140]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8141
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8139)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8141
      deleteIndexField
      (cloudsearch/delete-index-field-request
       (clojure.core/nth args8140 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-availability-options
   [m8142]
   (clojure.core/let
    [credentials8143 (:credentials m8142) args8144 (:args m8142)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8145
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8143)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8145
       describeAvailabilityOptions
       (cloudsearch/describe-availability-options-request
        (clojure.core/nth args8144 0)))))))
  (clojure.core/defn
   describe-availability-options-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeAvailabilityOptions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-availability-options,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   describe-availability-options
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeAvailabilityOptions"}
   [credentials8147 & args8148]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8149
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8147)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8149
      describeAvailabilityOptions
      (cloudsearch/describe-availability-options-request
       (clojure.core/nth args8148 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :create-domain
   [m8150]
   (clojure.core/let
    [credentials8151 (:credentials m8150) args8152 (:args m8150)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8153
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8151)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8153
       createDomain
       (cloudsearch/create-domain-request
        (clojure.core/nth args8152 0)))))))
  (clojure.core/defn
   create-domain-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createDomain"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-domain,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   create-domain
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createDomain"}
   [credentials8155 & args8156]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8157
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8155)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8157
      createDomain
      (cloudsearch/create-domain-request
       (clojure.core/nth args8156 0))))))))
