(ns
 com.palletops.awaze.cloudfront
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.cloudfront :as cloudfront]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :cloudfront
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.cloudfront.AmazonCloudFrontClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.ItemSelection}
item-selection
  [m11972]
  (.
   com.amazonaws.services.cloudfront.model.ItemSelection
   fromValue
   (clojure.core/name m11972)))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CookieNames}
cookie-names
  [m11975]
  (clojure.core/let
   [bean11974
    (new com.amazonaws.services.cloudfront.model.CookieNames)]
   (clojure.core/let
    [v11976 (:items m11975 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11976 :com.palletops.awaze.client-builder/undef)
     (.
      bean11974
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg12139] (clojure.core/str arg12139))
 v11976))))
   (clojure.core/let
    [v11976
     (:quantity m11975 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11976 :com.palletops.awaze.client-builder/undef)
     (. bean11974 setQuantity (clojure.core/int v11976))))
   bean11974))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.Headers}
headers
  [m11978]
  (clojure.core/let
   [bean11977 (new com.amazonaws.services.cloudfront.model.Headers)]
   (clojure.core/let
    [v11979 (:items m11978 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11979 :com.palletops.awaze.client-builder/undef)
     (.
      bean11977
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg12140] (clojure.core/str arg12140))
 v11979))))
   (clojure.core/let
    [v11979
     (:quantity m11978 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11979 :com.palletops.awaze.client-builder/undef)
     (. bean11977 setQuantity (clojure.core/int v11979))))
   bean11977))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CookiePreference}
cookie-preference
  [m11981]
  (clojure.core/let
   [bean11980
    (new com.amazonaws.services.cloudfront.model.CookiePreference)]
   (clojure.core/let
    [v11982
     (:forward m11981 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11982 :com.palletops.awaze.client-builder/undef)
     (. bean11980 setForward (cloudfront/item-selection v11982))))
   (clojure.core/let
    [v11982
     (:whitelisted-names
      m11981
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11982 :com.palletops.awaze.client-builder/undef)
     (.
      bean11980
      setWhitelistedNames
      (cloudfront/cookie-names v11982))))
   bean11980))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CachedMethods}
cached-methods
  [m11984]
  (clojure.core/let
   [bean11983
    (new com.amazonaws.services.cloudfront.model.CachedMethods)]
   (clojure.core/let
    [v11985 (:items m11984 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11985 :com.palletops.awaze.client-builder/undef)
     (.
      bean11983
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg12141] (clojure.core/str arg12141))
 v11985))))
   (clojure.core/let
    [v11985
     (:quantity m11984 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11985 :com.palletops.awaze.client-builder/undef)
     (. bean11983 setQuantity (clojure.core/int v11985))))
   bean11983))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.OriginCustomHeader}
origin-custom-header
  [m11987]
  (clojure.core/let
   [bean11986
    (new com.amazonaws.services.cloudfront.model.OriginCustomHeader)]
   (clojure.core/let
    [v11988
     (:header-name m11987 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11988 :com.palletops.awaze.client-builder/undef)
     (. bean11986 setHeaderName (clojure.core/str v11988))))
   (clojure.core/let
    [v11988
     (:header-value m11987 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11988 :com.palletops.awaze.client-builder/undef)
     (. bean11986 setHeaderValue (clojure.core/str v11988))))
   bean11986))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.OriginSslProtocols}
origin-ssl-protocols
  [m11990]
  (clojure.core/let
   [bean11989
    (new com.amazonaws.services.cloudfront.model.OriginSslProtocols)]
   (clojure.core/let
    [v11991 (:items m11990 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11991 :com.palletops.awaze.client-builder/undef)
     (.
      bean11989
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg12142] (clojure.core/str arg12142))
 v11991))))
   (clojure.core/let
    [v11991
     (:quantity m11990 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11991 :com.palletops.awaze.client-builder/undef)
     (. bean11989 setQuantity (clojure.core/int v11991))))
   bean11989))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.ForwardedValues}
forwarded-values
  [m11993]
  (clojure.core/let
   [bean11992
    (new com.amazonaws.services.cloudfront.model.ForwardedValues)]
   (clojure.core/let
    [v11994
     (:headers m11993 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11994 :com.palletops.awaze.client-builder/undef)
     (. bean11992 setHeaders (cloudfront/headers v11994))))
   (clojure.core/let
    [v11994
     (:query-string m11993 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11994 :com.palletops.awaze.client-builder/undef)
     (. bean11992 setQueryString (clojure.core/boolean v11994))))
   (clojure.core/let
    [v11994
     (:cookies m11993 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11994 :com.palletops.awaze.client-builder/undef)
     (. bean11992 setCookies (cloudfront/cookie-preference v11994))))
   bean11992))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.TrustedSigners}
trusted-signers
  [m11996]
  (clojure.core/let
   [bean11995
    (new com.amazonaws.services.cloudfront.model.TrustedSigners)]
   (clojure.core/let
    [v11997
     (:enabled m11996 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11997 :com.palletops.awaze.client-builder/undef)
     (. bean11995 setEnabled (clojure.core/boolean v11997))))
   (clojure.core/let
    [v11997 (:items m11996 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11997 :com.palletops.awaze.client-builder/undef)
     (.
      bean11995
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg12143] (clojure.core/str arg12143))
 v11997))))
   (clojure.core/let
    [v11997
     (:quantity m11996 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11997 :com.palletops.awaze.client-builder/undef)
     (. bean11995 setQuantity (clojure.core/int v11997))))
   bean11995))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.ViewerProtocolPolicy}
viewer-protocol-policy
  [m11999]
  (.
   com.amazonaws.services.cloudfront.model.ViewerProtocolPolicy
   fromValue
   (clojure.core/name m11999)))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.AllowedMethods}
allowed-methods
  [m12002]
  (clojure.core/let
   [bean12001
    (new com.amazonaws.services.cloudfront.model.AllowedMethods)]
   (clojure.core/let
    [v12003
     (:cached-methods
      m12002
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12003 :com.palletops.awaze.client-builder/undef)
     (. bean12001 setCachedMethods (cloudfront/cached-methods v12003))))
   (clojure.core/let
    [v12003 (:items m12002 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12003 :com.palletops.awaze.client-builder/undef)
     (.
      bean12001
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg12144] (clojure.core/str arg12144))
 v12003))))
   (clojure.core/let
    [v12003
     (:quantity m12002 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12003 :com.palletops.awaze.client-builder/undef)
     (. bean12001 setQuantity (clojure.core/int v12003))))
   bean12001))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CustomHeaders}
custom-headers
  [m12005]
  (clojure.core/let
   [bean12004
    (new com.amazonaws.services.cloudfront.model.CustomHeaders)]
   (clojure.core/let
    [v12006 (:items m12005 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12006 :com.palletops.awaze.client-builder/undef)
     (.
      bean12004
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg12145]
  (cloudfront/origin-custom-header arg12145))
 v12006))))
   (clojure.core/let
    [v12006
     (:quantity m12005 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12006 :com.palletops.awaze.client-builder/undef)
     (. bean12004 setQuantity (clojure.core/int v12006))))
   bean12004))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.S3OriginConfig}
s3origin-config
  [m12008]
  (clojure.core/let
   [bean12007
    (new com.amazonaws.services.cloudfront.model.S3OriginConfig)]
   (clojure.core/let
    [v12009
     (:origin-access-identity
      m12008
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12009 :com.palletops.awaze.client-builder/undef)
     (. bean12007 setOriginAccessIdentity (clojure.core/str v12009))))
   bean12007))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CustomOriginConfig}
custom-origin-config
  [m12011]
  (clojure.core/let
   [bean12010
    (new com.amazonaws.services.cloudfront.model.CustomOriginConfig)]
   (clojure.core/let
    [v12012
     (:httpport m12011 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12012 :com.palletops.awaze.client-builder/undef)
     (. bean12010 setHTTPPort (clojure.core/int v12012))))
   (clojure.core/let
    [v12012
     (:httpsport m12011 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12012 :com.palletops.awaze.client-builder/undef)
     (. bean12010 setHTTPSPort (clojure.core/int v12012))))
   (clojure.core/let
    [v12012
     (:origin-protocol-policy
      m12011
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12012 :com.palletops.awaze.client-builder/undef)
     (. bean12010 setOriginProtocolPolicy (clojure.core/str v12012))))
   (clojure.core/let
    [v12012
     (:origin-ssl-protocols
      m12011
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12012 :com.palletops.awaze.client-builder/undef)
     (.
      bean12010
      setOriginSslProtocols
      (cloudfront/origin-ssl-protocols v12012))))
   bean12010))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.GeoRestriction}
geo-restriction
  [m12014]
  (clojure.core/let
   [bean12013
    (new com.amazonaws.services.cloudfront.model.GeoRestriction)]
   (clojure.core/let
    [v12015
     (:restriction-type
      m12014
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12015 :com.palletops.awaze.client-builder/undef)
     (. bean12013 setRestrictionType (clojure.core/str v12015))))
   (clojure.core/let
    [v12015 (:items m12014 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12015 :com.palletops.awaze.client-builder/undef)
     (.
      bean12013
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg12146] (clojure.core/str arg12146))
 v12015))))
   (clojure.core/let
    [v12015
     (:quantity m12014 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12015 :com.palletops.awaze.client-builder/undef)
     (. bean12013 setQuantity (clojure.core/int v12015))))
   bean12013))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CacheBehavior}
cache-behavior
  [m12017]
  (clojure.core/let
   [bean12016
    (new com.amazonaws.services.cloudfront.model.CacheBehavior)]
   (clojure.core/let
    [v12018
     (:smooth-streaming
      m12017
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12018 :com.palletops.awaze.client-builder/undef)
     (. bean12016 setSmoothStreaming (clojure.core/boolean v12018))))
   (clojure.core/let
    [v12018
     (:path-pattern m12017 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12018 :com.palletops.awaze.client-builder/undef)
     (. bean12016 setPathPattern (clojure.core/str v12018))))
   (clojure.core/let
    [v12018
     (:forwarded-values
      m12017
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12018 :com.palletops.awaze.client-builder/undef)
     (.
      bean12016
      setForwardedValues
      (cloudfront/forwarded-values v12018))))
   (clojure.core/let
    [v12018
     (:trusted-signers
      m12017
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12018 :com.palletops.awaze.client-builder/undef)
     (.
      bean12016
      setTrustedSigners
      (cloudfront/trusted-signers v12018))))
   (clojure.core/let
    [v12018
     (:max-ttl m12017 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12018 :com.palletops.awaze.client-builder/undef)
     (. bean12016 setMaxTTL (clojure.core/long v12018))))
   (clojure.core/let
    [v12018
     (:viewer-protocol-policy
      m12017
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12018 :com.palletops.awaze.client-builder/undef)
     (.
      bean12016
      setViewerProtocolPolicy
      (cloudfront/viewer-protocol-policy v12018))))
   (clojure.core/let
    [v12018
     (:target-origin-id
      m12017
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12018 :com.palletops.awaze.client-builder/undef)
     (. bean12016 setTargetOriginId (clojure.core/str v12018))))
   (clojure.core/let
    [v12018
     (:default-ttl m12017 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12018 :com.palletops.awaze.client-builder/undef)
     (. bean12016 setDefaultTTL (clojure.core/long v12018))))
   (clojure.core/let
    [v12018
     (:compress m12017 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12018 :com.palletops.awaze.client-builder/undef)
     (. bean12016 setCompress (clojure.core/boolean v12018))))
   (clojure.core/let
    [v12018
     (:allowed-methods
      m12017
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12018 :com.palletops.awaze.client-builder/undef)
     (.
      bean12016
      setAllowedMethods
      (cloudfront/allowed-methods v12018))))
   (clojure.core/let
    [v12018
     (:min-ttl m12017 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12018 :com.palletops.awaze.client-builder/undef)
     (. bean12016 setMinTTL (clojure.core/long v12018))))
   bean12016))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.MinimumProtocolVersion}
minimum-protocol-version
  [m12020]
  (.
   com.amazonaws.services.cloudfront.model.MinimumProtocolVersion
   fromValue
   (clojure.core/name m12020)))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.Origin}
origin
  [m12023]
  (clojure.core/let
   [bean12022 (new com.amazonaws.services.cloudfront.model.Origin)]
   (clojure.core/let
    [v12024
     (:origin-path m12023 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12024 :com.palletops.awaze.client-builder/undef)
     (. bean12022 setOriginPath (clojure.core/str v12024))))
   (clojure.core/let
    [v12024
     (:custom-headers
      m12023
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12024 :com.palletops.awaze.client-builder/undef)
     (. bean12022 setCustomHeaders (cloudfront/custom-headers v12024))))
   (clojure.core/let
    [v12024
     (:s3origin-config
      m12023
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12024 :com.palletops.awaze.client-builder/undef)
     (.
      bean12022
      setS3OriginConfig
      (cloudfront/s3origin-config v12024))))
   (clojure.core/let
    [v12024
     (:custom-origin-config
      m12023
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12024 :com.palletops.awaze.client-builder/undef)
     (.
      bean12022
      setCustomOriginConfig
      (cloudfront/custom-origin-config v12024))))
   (clojure.core/let
    [v12024
     (:domain-name m12023 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12024 :com.palletops.awaze.client-builder/undef)
     (. bean12022 setDomainName (clojure.core/str v12024))))
   (clojure.core/let
    [v12024 (:id m12023 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12024 :com.palletops.awaze.client-builder/undef)
     (. bean12022 setId (clojure.core/str v12024))))
   bean12022))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CustomErrorResponse}
custom-error-response
  [m12026]
  (clojure.core/let
   [bean12025
    (new com.amazonaws.services.cloudfront.model.CustomErrorResponse)]
   (clojure.core/let
    [v12027
     (:response-page-path
      m12026
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12027 :com.palletops.awaze.client-builder/undef)
     (. bean12025 setResponsePagePath (clojure.core/str v12027))))
   (clojure.core/let
    [v12027
     (:response-code m12026 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12027 :com.palletops.awaze.client-builder/undef)
     (. bean12025 setResponseCode (clojure.core/str v12027))))
   (clojure.core/let
    [v12027
     (:error-caching-min-ttl
      m12026
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12027 :com.palletops.awaze.client-builder/undef)
     (. bean12025 setErrorCachingMinTTL (clojure.core/long v12027))))
   (clojure.core/let
    [v12027
     (:error-code m12026 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12027 :com.palletops.awaze.client-builder/undef)
     (. bean12025 setErrorCode (clojure.core/int v12027))))
   bean12025))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.Paths}
paths
  [m12029]
  (clojure.core/let
   [bean12028 (new com.amazonaws.services.cloudfront.model.Paths)]
   (clojure.core/let
    [v12030 (:items m12029 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12030 :com.palletops.awaze.client-builder/undef)
     (.
      bean12028
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg12147] (clojure.core/str arg12147))
 v12030))))
   (clojure.core/let
    [v12030
     (:quantity m12029 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12030 :com.palletops.awaze.client-builder/undef)
     (. bean12028 setQuantity (clojure.core/int v12030))))
   bean12028))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.Restrictions}
restrictions
  [m12032]
  (clojure.core/let
   [bean12031
    (new com.amazonaws.services.cloudfront.model.Restrictions)]
   (clojure.core/let
    [v12033
     (:geo-restriction
      m12032
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12033 :com.palletops.awaze.client-builder/undef)
     (.
      bean12031
      setGeoRestriction
      (cloudfront/geo-restriction v12033))))
   bean12031))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.DefaultCacheBehavior}
default-cache-behavior
  [m12035]
  (clojure.core/let
   [bean12034
    (new com.amazonaws.services.cloudfront.model.DefaultCacheBehavior)]
   (clojure.core/let
    [v12036
     (:smooth-streaming
      m12035
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12036 :com.palletops.awaze.client-builder/undef)
     (. bean12034 setSmoothStreaming (clojure.core/boolean v12036))))
   (clojure.core/let
    [v12036
     (:forwarded-values
      m12035
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12036 :com.palletops.awaze.client-builder/undef)
     (.
      bean12034
      setForwardedValues
      (cloudfront/forwarded-values v12036))))
   (clojure.core/let
    [v12036
     (:trusted-signers
      m12035
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12036 :com.palletops.awaze.client-builder/undef)
     (.
      bean12034
      setTrustedSigners
      (cloudfront/trusted-signers v12036))))
   (clojure.core/let
    [v12036
     (:max-ttl m12035 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12036 :com.palletops.awaze.client-builder/undef)
     (. bean12034 setMaxTTL (clojure.core/long v12036))))
   (clojure.core/let
    [v12036
     (:viewer-protocol-policy
      m12035
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12036 :com.palletops.awaze.client-builder/undef)
     (.
      bean12034
      setViewerProtocolPolicy
      (cloudfront/viewer-protocol-policy v12036))))
   (clojure.core/let
    [v12036
     (:target-origin-id
      m12035
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12036 :com.palletops.awaze.client-builder/undef)
     (. bean12034 setTargetOriginId (clojure.core/str v12036))))
   (clojure.core/let
    [v12036
     (:default-ttl m12035 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12036 :com.palletops.awaze.client-builder/undef)
     (. bean12034 setDefaultTTL (clojure.core/long v12036))))
   (clojure.core/let
    [v12036
     (:compress m12035 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12036 :com.palletops.awaze.client-builder/undef)
     (. bean12034 setCompress (clojure.core/boolean v12036))))
   (clojure.core/let
    [v12036
     (:allowed-methods
      m12035
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12036 :com.palletops.awaze.client-builder/undef)
     (.
      bean12034
      setAllowedMethods
      (cloudfront/allowed-methods v12036))))
   (clojure.core/let
    [v12036
     (:min-ttl m12035 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12036 :com.palletops.awaze.client-builder/undef)
     (. bean12034 setMinTTL (clojure.core/long v12036))))
   bean12034))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CacheBehaviors}
cache-behaviors
  [m12038]
  (clojure.core/let
   [bean12037
    (new com.amazonaws.services.cloudfront.model.CacheBehaviors)]
   (clojure.core/let
    [v12039 (:items m12038 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12039 :com.palletops.awaze.client-builder/undef)
     (.
      bean12037
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg12148] (cloudfront/cache-behavior arg12148))
 v12039))))
   (clojure.core/let
    [v12039
     (:quantity m12038 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12039 :com.palletops.awaze.client-builder/undef)
     (. bean12037 setQuantity (clojure.core/int v12039))))
   bean12037))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.ViewerCertificate}
viewer-certificate
  [m12041]
  (clojure.core/let
   [bean12040
    (new com.amazonaws.services.cloudfront.model.ViewerCertificate)]
   (clojure.core/let
    [v12042
     (:sslsupport-method
      m12041
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12042 :com.palletops.awaze.client-builder/undef)
     (. bean12040 setSSLSupportMethod (clojure.core/str v12042))))
   (clojure.core/let
    [v12042
     (:minimum-protocol-version
      m12041
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12042 :com.palletops.awaze.client-builder/undef)
     (.
      bean12040
      setMinimumProtocolVersion
      (cloudfront/minimum-protocol-version v12042))))
   (clojure.core/let
    [v12042
     (:certificate m12041 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12042 :com.palletops.awaze.client-builder/undef)
     (. bean12040 setCertificate (clojure.core/str v12042))))
   (clojure.core/let
    [v12042
     (:certificate-source
      m12041
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12042 :com.palletops.awaze.client-builder/undef)
     (. bean12040 setCertificateSource (clojure.core/str v12042))))
   (clojure.core/let
    [v12042
     (:cloud-front-default-certificate
      m12041
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12042 :com.palletops.awaze.client-builder/undef)
     (.
      bean12040
      setCloudFrontDefaultCertificate
      (clojure.core/boolean v12042))))
   (clojure.core/let
    [v12042
     (:iamcertificate-id
      m12041
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12042 :com.palletops.awaze.client-builder/undef)
     (. bean12040 setIAMCertificateId (clojure.core/str v12042))))
   (clojure.core/let
    [v12042
     (:acmcertificate-arn
      m12041
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12042 :com.palletops.awaze.client-builder/undef)
     (. bean12040 setACMCertificateArn (clojure.core/str v12042))))
   bean12040))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.Aliases}
aliases
  [m12044]
  (clojure.core/let
   [bean12043 (new com.amazonaws.services.cloudfront.model.Aliases)]
   (clojure.core/let
    [v12045 (:items m12044 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12045 :com.palletops.awaze.client-builder/undef)
     (.
      bean12043
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg12149] (clojure.core/str arg12149))
 v12045))))
   (clojure.core/let
    [v12045
     (:quantity m12044 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12045 :com.palletops.awaze.client-builder/undef)
     (. bean12043 setQuantity (clojure.core/int v12045))))
   bean12043))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.Origins}
origins
  [m12047]
  (clojure.core/let
   [bean12046 (new com.amazonaws.services.cloudfront.model.Origins)]
   (clojure.core/let
    [v12048 (:items m12047 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12048 :com.palletops.awaze.client-builder/undef)
     (.
      bean12046
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg12150] (cloudfront/origin arg12150))
 v12048))))
   (clojure.core/let
    [v12048
     (:quantity m12047 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12048 :com.palletops.awaze.client-builder/undef)
     (. bean12046 setQuantity (clojure.core/int v12048))))
   bean12046))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.LoggingConfig}
logging-config
  [m12050]
  (clojure.core/let
   [bean12049
    (new com.amazonaws.services.cloudfront.model.LoggingConfig)]
   (clojure.core/let
    [v12051
     (:enabled m12050 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12051 :com.palletops.awaze.client-builder/undef)
     (. bean12049 setEnabled (clojure.core/boolean v12051))))
   (clojure.core/let
    [v12051
     (:include-cookies
      m12050
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12051 :com.palletops.awaze.client-builder/undef)
     (. bean12049 setIncludeCookies (clojure.core/boolean v12051))))
   (clojure.core/let
    [v12051
     (:bucket m12050 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12051 :com.palletops.awaze.client-builder/undef)
     (. bean12049 setBucket (clojure.core/str v12051))))
   (clojure.core/let
    [v12051
     (:prefix m12050 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12051 :com.palletops.awaze.client-builder/undef)
     (. bean12049 setPrefix (clojure.core/str v12051))))
   bean12049))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CustomErrorResponses}
custom-error-responses
  [m12053]
  (clojure.core/let
   [bean12052
    (new com.amazonaws.services.cloudfront.model.CustomErrorResponses)]
   (clojure.core/let
    [v12054 (:items m12053 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12054 :com.palletops.awaze.client-builder/undef)
     (.
      bean12052
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg12151]
  (cloudfront/custom-error-response arg12151))
 v12054))))
   (clojure.core/let
    [v12054
     (:quantity m12053 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12054 :com.palletops.awaze.client-builder/undef)
     (. bean12052 setQuantity (clojure.core/int v12054))))
   bean12052))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.StreamingLoggingConfig}
streaming-logging-config
  [m12056]
  (clojure.core/let
   [bean12055
    (new
     com.amazonaws.services.cloudfront.model.StreamingLoggingConfig)]
   (clojure.core/let
    [v12057
     (:enabled m12056 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12057 :com.palletops.awaze.client-builder/undef)
     (. bean12055 setEnabled (clojure.core/boolean v12057))))
   (clojure.core/let
    [v12057
     (:bucket m12056 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12057 :com.palletops.awaze.client-builder/undef)
     (. bean12055 setBucket (clojure.core/str v12057))))
   (clojure.core/let
    [v12057
     (:prefix m12056 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12057 :com.palletops.awaze.client-builder/undef)
     (. bean12055 setPrefix (clojure.core/str v12057))))
   bean12055))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.S3Origin}
s3origin
  [m12059]
  (clojure.core/let
   [bean12058 (new com.amazonaws.services.cloudfront.model.S3Origin)]
   (clojure.core/let
    [v12060
     (:origin-access-identity
      m12059
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12060 :com.palletops.awaze.client-builder/undef)
     (. bean12058 setOriginAccessIdentity (clojure.core/str v12060))))
   (clojure.core/let
    [v12060
     (:domain-name m12059 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12060 :com.palletops.awaze.client-builder/undef)
     (. bean12058 setDomainName (clojure.core/str v12060))))
   bean12058))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.InvalidationBatch}
invalidation-batch
  [m12062]
  (clojure.core/let
   [bean12061
    (new com.amazonaws.services.cloudfront.model.InvalidationBatch)]
   (clojure.core/let
    [v12063
     (:caller-reference
      m12062
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12063 :com.palletops.awaze.client-builder/undef)
     (. bean12061 setCallerReference (clojure.core/str v12063))))
   (clojure.core/let
    [v12063 (:paths m12062 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12063 :com.palletops.awaze.client-builder/undef)
     (. bean12061 setPaths (cloudfront/paths v12063))))
   bean12061))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.DistributionConfig}
distribution-config
  [m12065]
  (clojure.core/let
   [bean12064
    (new com.amazonaws.services.cloudfront.model.DistributionConfig)]
   (clojure.core/let
    [v12066
     (:restrictions m12065 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12066 :com.palletops.awaze.client-builder/undef)
     (. bean12064 setRestrictions (cloudfront/restrictions v12066))))
   (clojure.core/let
    [v12066
     (:default-root-object
      m12065
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12066 :com.palletops.awaze.client-builder/undef)
     (. bean12064 setDefaultRootObject (clojure.core/str v12066))))
   (clojure.core/let
    [v12066
     (:default-cache-behavior
      m12065
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12066 :com.palletops.awaze.client-builder/undef)
     (.
      bean12064
      setDefaultCacheBehavior
      (cloudfront/default-cache-behavior v12066))))
   (clojure.core/let
    [v12066
     (:comment m12065 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12066 :com.palletops.awaze.client-builder/undef)
     (. bean12064 setComment (clojure.core/str v12066))))
   (clojure.core/let
    [v12066
     (:cache-behaviors
      m12065
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12066 :com.palletops.awaze.client-builder/undef)
     (.
      bean12064
      setCacheBehaviors
      (cloudfront/cache-behaviors v12066))))
   (clojure.core/let
    [v12066
     (:viewer-certificate
      m12065
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12066 :com.palletops.awaze.client-builder/undef)
     (.
      bean12064
      setViewerCertificate
      (cloudfront/viewer-certificate v12066))))
   (clojure.core/let
    [v12066
     (:aliases m12065 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12066 :com.palletops.awaze.client-builder/undef)
     (. bean12064 setAliases (cloudfront/aliases v12066))))
   (clojure.core/let
    [v12066
     (:enabled m12065 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12066 :com.palletops.awaze.client-builder/undef)
     (. bean12064 setEnabled (clojure.core/boolean v12066))))
   (clojure.core/let
    [v12066
     (:price-class m12065 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12066 :com.palletops.awaze.client-builder/undef)
     (. bean12064 setPriceClass (clojure.core/str v12066))))
   (clojure.core/let
    [v12066
     (:origins m12065 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12066 :com.palletops.awaze.client-builder/undef)
     (. bean12064 setOrigins (cloudfront/origins v12066))))
   (clojure.core/let
    [v12066
     (:caller-reference
      m12065
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12066 :com.palletops.awaze.client-builder/undef)
     (. bean12064 setCallerReference (clojure.core/str v12066))))
   (clojure.core/let
    [v12066
     (:logging m12065 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12066 :com.palletops.awaze.client-builder/undef)
     (. bean12064 setLogging (cloudfront/logging-config v12066))))
   (clojure.core/let
    [v12066
     (:web-aclid m12065 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12066 :com.palletops.awaze.client-builder/undef)
     (. bean12064 setWebACLId (clojure.core/str v12066))))
   (clojure.core/let
    [v12066
     (:custom-error-responses
      m12065
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12066 :com.palletops.awaze.client-builder/undef)
     (.
      bean12064
      setCustomErrorResponses
      (cloudfront/custom-error-responses v12066))))
   bean12064))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CloudFrontOriginAccessIdentityConfig}
cloud-front-origin-access-identity-config
  [m12068]
  (clojure.core/let
   [bean12067
    (new
     com.amazonaws.services.cloudfront.model.CloudFrontOriginAccessIdentityConfig)]
   (clojure.core/let
    [v12069
     (:comment m12068 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12069 :com.palletops.awaze.client-builder/undef)
     (. bean12067 setComment (clojure.core/str v12069))))
   (clojure.core/let
    [v12069
     (:caller-reference
      m12068
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12069 :com.palletops.awaze.client-builder/undef)
     (. bean12067 setCallerReference (clojure.core/str v12069))))
   bean12067))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.StreamingDistributionConfig}
streaming-distribution-config
  [m12071]
  (clojure.core/let
   [bean12070
    (new
     com.amazonaws.services.cloudfront.model.StreamingDistributionConfig)]
   (clojure.core/let
    [v12072
     (:comment m12071 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12072 :com.palletops.awaze.client-builder/undef)
     (. bean12070 setComment (clojure.core/str v12072))))
   (clojure.core/let
    [v12072
     (:enabled m12071 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12072 :com.palletops.awaze.client-builder/undef)
     (. bean12070 setEnabled (clojure.core/boolean v12072))))
   (clojure.core/let
    [v12072
     (:caller-reference
      m12071
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12072 :com.palletops.awaze.client-builder/undef)
     (. bean12070 setCallerReference (clojure.core/str v12072))))
   (clojure.core/let
    [v12072
     (:aliases m12071 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12072 :com.palletops.awaze.client-builder/undef)
     (. bean12070 setAliases (cloudfront/aliases v12072))))
   (clojure.core/let
    [v12072
     (:logging m12071 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12072 :com.palletops.awaze.client-builder/undef)
     (.
      bean12070
      setLogging
      (cloudfront/streaming-logging-config v12072))))
   (clojure.core/let
    [v12072
     (:price-class m12071 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12072 :com.palletops.awaze.client-builder/undef)
     (. bean12070 setPriceClass (clojure.core/str v12072))))
   (clojure.core/let
    [v12072
     (:s3origin m12071 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12072 :com.palletops.awaze.client-builder/undef)
     (. bean12070 setS3Origin (cloudfront/s3origin v12072))))
   (clojure.core/let
    [v12072
     (:trusted-signers
      m12071
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12072 :com.palletops.awaze.client-builder/undef)
     (.
      bean12070
      setTrustedSigners
      (cloudfront/trusted-signers v12072))))
   bean12070))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.GetStreamingDistributionRequest}
get-streaming-distribution-request
  [m12074]
  (clojure.core/let
   [bean12073
    (new
     com.amazonaws.services.cloudfront.model.GetStreamingDistributionRequest)]
   (clojure.core/let
    [v12075 (:id m12074 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12075 :com.palletops.awaze.client-builder/undef)
     (. bean12073 setId (clojure.core/str v12075))))
   bean12073))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CreateInvalidationRequest}
create-invalidation-request
  [m12077]
  (clojure.core/let
   [bean12076
    (new
     com.amazonaws.services.cloudfront.model.CreateInvalidationRequest)]
   (clojure.core/let
    [v12078
     (:distribution-id
      m12077
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12078 :com.palletops.awaze.client-builder/undef)
     (. bean12076 setDistributionId (clojure.core/str v12078))))
   (clojure.core/let
    [v12078
     (:invalidation-batch
      m12077
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12078 :com.palletops.awaze.client-builder/undef)
     (.
      bean12076
      setInvalidationBatch
      (cloudfront/invalidation-batch v12078))))
   bean12076))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.DeleteDistributionRequest}
delete-distribution-request
  [m12080]
  (clojure.core/let
   [bean12079
    (new
     com.amazonaws.services.cloudfront.model.DeleteDistributionRequest)]
   (clojure.core/let
    [v12081
     (:if-match m12080 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12081 :com.palletops.awaze.client-builder/undef)
     (. bean12079 setIfMatch (clojure.core/str v12081))))
   (clojure.core/let
    [v12081 (:id m12080 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12081 :com.palletops.awaze.client-builder/undef)
     (. bean12079 setId (clojure.core/str v12081))))
   bean12079))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.DeleteCloudFrontOriginAccessIdentityRequest}
delete-cloud-front-origin-access-identity-request
  [m12083]
  (clojure.core/let
   [bean12082
    (new
     com.amazonaws.services.cloudfront.model.DeleteCloudFrontOriginAccessIdentityRequest)]
   (clojure.core/let
    [v12084
     (:if-match m12083 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12084 :com.palletops.awaze.client-builder/undef)
     (. bean12082 setIfMatch (clojure.core/str v12084))))
   (clojure.core/let
    [v12084 (:id m12083 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12084 :com.palletops.awaze.client-builder/undef)
     (. bean12082 setId (clojure.core/str v12084))))
   bean12082))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CreateDistributionRequest}
create-distribution-request
  [m12086]
  (clojure.core/let
   [bean12085
    (new
     com.amazonaws.services.cloudfront.model.CreateDistributionRequest)]
   (clojure.core/let
    [v12087
     (:distribution-config
      m12086
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12087 :com.palletops.awaze.client-builder/undef)
     (.
      bean12085
      setDistributionConfig
      (cloudfront/distribution-config v12087))))
   bean12085))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.ListInvalidationsRequest}
list-invalidations-request
  [m12089]
  (clojure.core/let
   [bean12088
    (new
     com.amazonaws.services.cloudfront.model.ListInvalidationsRequest)]
   (clojure.core/let
    [v12090
     (:distribution-id
      m12089
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12090 :com.palletops.awaze.client-builder/undef)
     (. bean12088 setDistributionId (clojure.core/str v12090))))
   (clojure.core/let
    [v12090
     (:marker m12089 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12090 :com.palletops.awaze.client-builder/undef)
     (. bean12088 setMarker (clojure.core/str v12090))))
   (clojure.core/let
    [v12090
     (:max-items m12089 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12090 :com.palletops.awaze.client-builder/undef)
     (. bean12088 setMaxItems (clojure.core/str v12090))))
   bean12088))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.ListStreamingDistributionsRequest}
list-streaming-distributions-request
  [m12092]
  (clojure.core/let
   [bean12091
    (new
     com.amazonaws.services.cloudfront.model.ListStreamingDistributionsRequest)]
   (clojure.core/let
    [v12093
     (:marker m12092 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12093 :com.palletops.awaze.client-builder/undef)
     (. bean12091 setMarker (clojure.core/str v12093))))
   (clojure.core/let
    [v12093
     (:max-items m12092 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12093 :com.palletops.awaze.client-builder/undef)
     (. bean12091 setMaxItems (clojure.core/str v12093))))
   bean12091))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigRequest}
get-cloud-front-origin-access-identity-config-request
  [m12095]
  (clojure.core/let
   [bean12094
    (new
     com.amazonaws.services.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigRequest)]
   (clojure.core/let
    [v12096 (:id m12095 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12096 :com.palletops.awaze.client-builder/undef)
     (. bean12094 setId (clojure.core/str v12096))))
   bean12094))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.ListDistributionsRequest}
list-distributions-request
  [m12098]
  (clojure.core/let
   [bean12097
    (new
     com.amazonaws.services.cloudfront.model.ListDistributionsRequest)]
   (clojure.core/let
    [v12099
     (:marker m12098 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12099 :com.palletops.awaze.client-builder/undef)
     (. bean12097 setMarker (clojure.core/str v12099))))
   (clojure.core/let
    [v12099
     (:max-items m12098 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12099 :com.palletops.awaze.client-builder/undef)
     (. bean12097 setMaxItems (clojure.core/str v12099))))
   bean12097))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityRequest}
create-cloud-front-origin-access-identity-request
  [m12101]
  (clojure.core/let
   [bean12100
    (new
     com.amazonaws.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityRequest)]
   (clojure.core/let
    [v12102
     (:cloud-front-origin-access-identity-config
      m12101
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12102 :com.palletops.awaze.client-builder/undef)
     (.
      bean12100
      setCloudFrontOriginAccessIdentityConfig
      (cloudfront/cloud-front-origin-access-identity-config v12102))))
   bean12100))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.UpdateStreamingDistributionRequest}
update-streaming-distribution-request
  [m12104]
  (clojure.core/let
   [bean12103
    (new
     com.amazonaws.services.cloudfront.model.UpdateStreamingDistributionRequest)]
   (clojure.core/let
    [v12105
     (:streaming-distribution-config
      m12104
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12105 :com.palletops.awaze.client-builder/undef)
     (.
      bean12103
      setStreamingDistributionConfig
      (cloudfront/streaming-distribution-config v12105))))
   (clojure.core/let
    [v12105
     (:if-match m12104 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12105 :com.palletops.awaze.client-builder/undef)
     (. bean12103 setIfMatch (clojure.core/str v12105))))
   (clojure.core/let
    [v12105 (:id m12104 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12105 :com.palletops.awaze.client-builder/undef)
     (. bean12103 setId (clojure.core/str v12105))))
   bean12103))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.ListDistributionsByWebACLIdRequest}
list-distributions-by-web-aclid-request
  [m12107]
  (clojure.core/let
   [bean12106
    (new
     com.amazonaws.services.cloudfront.model.ListDistributionsByWebACLIdRequest)]
   (clojure.core/let
    [v12108
     (:web-aclid m12107 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12108 :com.palletops.awaze.client-builder/undef)
     (. bean12106 setWebACLId (clojure.core/str v12108))))
   (clojure.core/let
    [v12108
     (:marker m12107 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12108 :com.palletops.awaze.client-builder/undef)
     (. bean12106 setMarker (clojure.core/str v12108))))
   (clojure.core/let
    [v12108
     (:max-items m12107 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12108 :com.palletops.awaze.client-builder/undef)
     (. bean12106 setMaxItems (clojure.core/str v12108))))
   bean12106))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesRequest}
list-cloud-front-origin-access-identities-request
  [m12110]
  (clojure.core/let
   [bean12109
    (new
     com.amazonaws.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesRequest)]
   (clojure.core/let
    [v12111
     (:marker m12110 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12111 :com.palletops.awaze.client-builder/undef)
     (. bean12109 setMarker (clojure.core/str v12111))))
   (clojure.core/let
    [v12111
     (:max-items m12110 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12111 :com.palletops.awaze.client-builder/undef)
     (. bean12109 setMaxItems (clojure.core/str v12111))))
   bean12109))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.GetDistributionRequest}
get-distribution-request
  [m12113]
  (clojure.core/let
   [bean12112
    (new
     com.amazonaws.services.cloudfront.model.GetDistributionRequest)]
   (clojure.core/let
    [v12114 (:id m12113 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12114 :com.palletops.awaze.client-builder/undef)
     (. bean12112 setId (clojure.core/str v12114))))
   bean12112))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.DeleteStreamingDistributionRequest}
delete-streaming-distribution-request
  [m12116]
  (clojure.core/let
   [bean12115
    (new
     com.amazonaws.services.cloudfront.model.DeleteStreamingDistributionRequest)]
   (clojure.core/let
    [v12117
     (:if-match m12116 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12117 :com.palletops.awaze.client-builder/undef)
     (. bean12115 setIfMatch (clojure.core/str v12117))))
   (clojure.core/let
    [v12117 (:id m12116 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12117 :com.palletops.awaze.client-builder/undef)
     (. bean12115 setId (clojure.core/str v12117))))
   bean12115))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.GetDistributionConfigRequest}
get-distribution-config-request
  [m12119]
  (clojure.core/let
   [bean12118
    (new
     com.amazonaws.services.cloudfront.model.GetDistributionConfigRequest)]
   (clojure.core/let
    [v12120 (:id m12119 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12120 :com.palletops.awaze.client-builder/undef)
     (. bean12118 setId (clojure.core/str v12120))))
   bean12118))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.UpdateDistributionRequest}
update-distribution-request
  [m12122]
  (clojure.core/let
   [bean12121
    (new
     com.amazonaws.services.cloudfront.model.UpdateDistributionRequest)]
   (clojure.core/let
    [v12123
     (:distribution-config
      m12122
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12123 :com.palletops.awaze.client-builder/undef)
     (.
      bean12121
      setDistributionConfig
      (cloudfront/distribution-config v12123))))
   (clojure.core/let
    [v12123
     (:if-match m12122 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12123 :com.palletops.awaze.client-builder/undef)
     (. bean12121 setIfMatch (clojure.core/str v12123))))
   (clojure.core/let
    [v12123 (:id m12122 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12123 :com.palletops.awaze.client-builder/undef)
     (. bean12121 setId (clojure.core/str v12123))))
   bean12121))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.GetCloudFrontOriginAccessIdentityRequest}
get-cloud-front-origin-access-identity-request
  [m12125]
  (clojure.core/let
   [bean12124
    (new
     com.amazonaws.services.cloudfront.model.GetCloudFrontOriginAccessIdentityRequest)]
   (clojure.core/let
    [v12126 (:id m12125 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12126 :com.palletops.awaze.client-builder/undef)
     (. bean12124 setId (clojure.core/str v12126))))
   bean12124))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.GetStreamingDistributionConfigRequest}
get-streaming-distribution-config-request
  [m12128]
  (clojure.core/let
   [bean12127
    (new
     com.amazonaws.services.cloudfront.model.GetStreamingDistributionConfigRequest)]
   (clojure.core/let
    [v12129 (:id m12128 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12129 :com.palletops.awaze.client-builder/undef)
     (. bean12127 setId (clojure.core/str v12129))))
   bean12127))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityRequest}
update-cloud-front-origin-access-identity-request
  [m12131]
  (clojure.core/let
   [bean12130
    (new
     com.amazonaws.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityRequest)]
   (clojure.core/let
    [v12132
     (:cloud-front-origin-access-identity-config
      m12131
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12132 :com.palletops.awaze.client-builder/undef)
     (.
      bean12130
      setCloudFrontOriginAccessIdentityConfig
      (cloudfront/cloud-front-origin-access-identity-config v12132))))
   (clojure.core/let
    [v12132
     (:if-match m12131 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12132 :com.palletops.awaze.client-builder/undef)
     (. bean12130 setIfMatch (clojure.core/str v12132))))
   (clojure.core/let
    [v12132 (:id m12131 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12132 :com.palletops.awaze.client-builder/undef)
     (. bean12130 setId (clojure.core/str v12132))))
   bean12130))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CreateStreamingDistributionRequest}
create-streaming-distribution-request
  [m12134]
  (clojure.core/let
   [bean12133
    (new
     com.amazonaws.services.cloudfront.model.CreateStreamingDistributionRequest)]
   (clojure.core/let
    [v12135
     (:streaming-distribution-config
      m12134
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12135 :com.palletops.awaze.client-builder/undef)
     (.
      bean12133
      setStreamingDistributionConfig
      (cloudfront/streaming-distribution-config v12135))))
   bean12133))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.GetInvalidationRequest}
get-invalidation-request
  [m12137]
  (clojure.core/let
   [bean12136
    (new
     com.amazonaws.services.cloudfront.model.GetInvalidationRequest)]
   (clojure.core/let
    [v12138
     (:distribution-id
      m12137
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12138 :com.palletops.awaze.client-builder/undef)
     (. bean12136 setDistributionId (clojure.core/str v12138))))
   (clojure.core/let
    [v12138 (:id m12137 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12138 :com.palletops.awaze.client-builder/undef)
     (. bean12136 setId (clojure.core/str v12138))))
   bean12136))
 (clojure.core/defmulti
  cloudfront
  (clojure.core/fn cloudfront [m__1874__auto__] (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   cloudfront
   :get-streaming-distribution
   [m12152]
   (clojure.core/let
    [credentials12153 (:credentials m12152) args12154 (:args m12152)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12155
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12153)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12155
       getStreamingDistribution
       (cloudfront/get-streaming-distribution-request
        (clojure.core/nth args12154 0)))))))
  (clojure.core/defn
   get-streaming-distribution-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getStreamingDistribution"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-streaming-distribution,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   get-streaming-distribution
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getStreamingDistribution"}
   [credentials12157 & args12158]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12159
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12157)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12159
      getStreamingDistribution
      (cloudfront/get-streaming-distribution-request
       (clojure.core/nth args12158 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :create-invalidation
   [m12160]
   (clojure.core/let
    [credentials12161 (:credentials m12160) args12162 (:args m12160)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12163
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12161)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12163
       createInvalidation
       (cloudfront/create-invalidation-request
        (clojure.core/nth args12162 0)))))))
  (clojure.core/defn
   create-invalidation-map
   {:arglists (quote
               [[credentials
                 {:keys [invalidation-batch
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         distribution-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createInvalidation"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-invalidation,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   create-invalidation
   {:arglists (quote
               [[credentials
                 {:keys [invalidation-batch
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         distribution-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createInvalidation"}
   [credentials12165 & args12166]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12167
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12165)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12167
      createInvalidation
      (cloudfront/create-invalidation-request
       (clojure.core/nth args12166 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :delete-distribution
   [m12168]
   (clojure.core/let
    [credentials12169 (:credentials m12168) args12170 (:args m12168)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12171
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12169)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12171
       deleteDistribution
       (cloudfront/delete-distribution-request
        (clojure.core/nth args12170 0)))))))
  (clojure.core/defn
   delete-distribution-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         if-match
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteDistribution"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-distribution,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   delete-distribution
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         if-match
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteDistribution"}
   [credentials12173 & args12174]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12175
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12173)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12175
      deleteDistribution
      (cloudfront/delete-distribution-request
       (clojure.core/nth args12174 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :delete-cloud-front-origin-access-identity
   [m12176]
   (clojure.core/let
    [credentials12177 (:credentials m12176) args12178 (:args m12176)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12179
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12177)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12179
       deleteCloudFrontOriginAccessIdentity
       (cloudfront/delete-cloud-front-origin-access-identity-request
        (clojure.core/nth args12178 0)))))))
  (clojure.core/defn
   delete-cloud-front-origin-access-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         if-match
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteCloudFrontOriginAccessIdentity"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-cloud-front-origin-access-identity,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   delete-cloud-front-origin-access-identity
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         if-match
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteCloudFrontOriginAccessIdentity"}
   [credentials12181 & args12182]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12183
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12181)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12183
      deleteCloudFrontOriginAccessIdentity
      (cloudfront/delete-cloud-front-origin-access-identity-request
       (clojure.core/nth args12182 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :create-distribution
   [m12184]
   (clojure.core/let
    [credentials12185 (:credentials m12184) args12186 (:args m12184)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12187
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12185)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12187
       createDistribution
       (cloudfront/create-distribution-request
        (clojure.core/nth args12186 0)))))))
  (clojure.core/defn
   create-distribution-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         distribution-config
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createDistribution"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-distribution,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   create-distribution
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         distribution-config
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createDistribution"}
   [credentials12189 & args12190]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12191
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12189)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12191
      createDistribution
      (cloudfront/create-distribution-request
       (clojure.core/nth args12190 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :list-invalidations
   [m12192]
   (clojure.core/let
    [credentials12193 (:credentials m12192) args12194 (:args m12192)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12195
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12193)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12195
       listInvalidations
       (cloudfront/list-invalidations-request
        (clojure.core/nth args12194 0)))))))
  (clojure.core/defn
   list-invalidations-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         distribution-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listInvalidations"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-invalidations,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   list-invalidations
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         distribution-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listInvalidations"}
   [credentials12197 & args12198]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12199
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12197)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12199
      listInvalidations
      (cloudfront/list-invalidations-request
       (clojure.core/nth args12198 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :list-streaming-distributions
   [m12200]
   (clojure.core/let
    [credentials12201 (:credentials m12200) args12202 (:args m12200)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12203
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12201)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12203
       listStreamingDistributions
       (cloudfront/list-streaming-distributions-request
        (clojure.core/nth args12202 0)))))))
  (clojure.core/defn
   list-streaming-distributions-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listStreamingDistributions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-streaming-distributions,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   list-streaming-distributions
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listStreamingDistributions"}
   [credentials12205 & args12206]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12207
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12205)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12207
      listStreamingDistributions
      (cloudfront/list-streaming-distributions-request
       (clojure.core/nth args12206 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :get-cloud-front-origin-access-identity-config
   [m12208]
   (clojure.core/let
    [credentials12209 (:credentials m12208) args12210 (:args m12208)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12211
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12209)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12211
       getCloudFrontOriginAccessIdentityConfig
       (cloudfront/get-cloud-front-origin-access-identity-config-request
        (clojure.core/nth args12210 0)))))))
  (clojure.core/defn
   get-cloud-front-origin-access-identity-config-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getCloudFrontOriginAccessIdentityConfig"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-cloud-front-origin-access-identity-config,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   get-cloud-front-origin-access-identity-config
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getCloudFrontOriginAccessIdentityConfig"}
   [credentials12213 & args12214]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12215
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12213)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12215
      getCloudFrontOriginAccessIdentityConfig
      (cloudfront/get-cloud-front-origin-access-identity-config-request
       (clojure.core/nth args12214 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :list-distributions
   [m12216]
   (clojure.core/let
    [credentials12217 (:credentials m12216) args12218 (:args m12216)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12219
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12217)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12219
       listDistributions
       (cloudfront/list-distributions-request
        (clojure.core/nth args12218 0)))))))
  (clojure.core/defn
   list-distributions-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listDistributions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-distributions,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   list-distributions
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listDistributions"}
   [credentials12221 & args12222]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12223
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12221)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12223
      listDistributions
      (cloudfront/list-distributions-request
       (clojure.core/nth args12222 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :create-cloud-front-origin-access-identity
   [m12224]
   (clojure.core/let
    [credentials12225 (:credentials m12224) args12226 (:args m12224)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12227
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12225)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12227
       createCloudFrontOriginAccessIdentity
       (cloudfront/create-cloud-front-origin-access-identity-request
        (clojure.core/nth args12226 0)))))))
  (clojure.core/defn
   create-cloud-front-origin-access-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cloud-front-origin-access-identity-config
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createCloudFrontOriginAccessIdentity"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-cloud-front-origin-access-identity,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   create-cloud-front-origin-access-identity
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cloud-front-origin-access-identity-config
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createCloudFrontOriginAccessIdentity"}
   [credentials12229 & args12230]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12231
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12229)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12231
      createCloudFrontOriginAccessIdentity
      (cloudfront/create-cloud-front-origin-access-identity-request
       (clojure.core/nth args12230 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :update-streaming-distribution
   [m12232]
   (clojure.core/let
    [credentials12233 (:credentials m12232) args12234 (:args m12232)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12235
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12233)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12235
       updateStreamingDistribution
       (cloudfront/update-streaming-distribution-request
        (clojure.core/nth args12234 0)))))))
  (clojure.core/defn
   update-streaming-distribution-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         if-match
                         custom-query-parameters
                         streaming-distribution-config
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateStreamingDistribution"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-streaming-distribution,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   update-streaming-distribution
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         if-match
                         custom-query-parameters
                         streaming-distribution-config
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateStreamingDistribution"}
   [credentials12237 & args12238]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12239
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12237)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12239
      updateStreamingDistribution
      (cloudfront/update-streaming-distribution-request
       (clojure.core/nth args12238 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :list-distributions-by-web-aclid
   [m12240]
   (clojure.core/let
    [credentials12241 (:credentials m12240) args12242 (:args m12240)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12243
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12241)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12243
       listDistributionsByWebACLId
       (cloudfront/list-distributions-by-web-aclid-request
        (clojure.core/nth args12242 0)))))))
  (clojure.core/defn
   list-distributions-by-web-aclid-map
   {:arglists (quote
               [[credentials
                 {:keys [web-aclid
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listDistributionsByWebACLId"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-distributions-by-web-aclid,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   list-distributions-by-web-aclid
   {:arglists (quote
               [[credentials
                 {:keys [web-aclid
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listDistributionsByWebACLId"}
   [credentials12245 & args12246]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12247
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12245)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12247
      listDistributionsByWebACLId
      (cloudfront/list-distributions-by-web-aclid-request
       (clojure.core/nth args12246 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :list-cloud-front-origin-access-identities
   [m12248]
   (clojure.core/let
    [credentials12249 (:credentials m12248) args12250 (:args m12248)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12251
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12249)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12251
       listCloudFrontOriginAccessIdentities
       (cloudfront/list-cloud-front-origin-access-identities-request
        (clojure.core/nth args12250 0)))))))
  (clojure.core/defn
   list-cloud-front-origin-access-identities-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listCloudFrontOriginAccessIdentities"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-cloud-front-origin-access-identities,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   list-cloud-front-origin-access-identities
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listCloudFrontOriginAccessIdentities"}
   [credentials12253 & args12254]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12255
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12253)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12255
      listCloudFrontOriginAccessIdentities
      (cloudfront/list-cloud-front-origin-access-identities-request
       (clojure.core/nth args12254 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :get-distribution
   [m12256]
   (clojure.core/let
    [credentials12257 (:credentials m12256) args12258 (:args m12256)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12259
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12257)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12259
       getDistribution
       (cloudfront/get-distribution-request
        (clojure.core/nth args12258 0)))))))
  (clojure.core/defn
   get-distribution-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getDistribution"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-distribution,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   get-distribution
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getDistribution"}
   [credentials12261 & args12262]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12263
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12261)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12263
      getDistribution
      (cloudfront/get-distribution-request
       (clojure.core/nth args12262 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :delete-streaming-distribution
   [m12264]
   (clojure.core/let
    [credentials12265 (:credentials m12264) args12266 (:args m12264)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12267
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12265)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12267
       deleteStreamingDistribution
       (cloudfront/delete-streaming-distribution-request
        (clojure.core/nth args12266 0)))))))
  (clojure.core/defn
   delete-streaming-distribution-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         if-match
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteStreamingDistribution"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-streaming-distribution,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   delete-streaming-distribution
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         if-match
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteStreamingDistribution"}
   [credentials12269 & args12270]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12271
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12269)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12271
      deleteStreamingDistribution
      (cloudfront/delete-streaming-distribution-request
       (clojure.core/nth args12270 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :get-distribution-config
   [m12272]
   (clojure.core/let
    [credentials12273 (:credentials m12272) args12274 (:args m12272)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12275
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12273)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12275
       getDistributionConfig
       (cloudfront/get-distribution-config-request
        (clojure.core/nth args12274 0)))))))
  (clojure.core/defn
   get-distribution-config-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getDistributionConfig"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-distribution-config,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   get-distribution-config
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getDistributionConfig"}
   [credentials12277 & args12278]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12279
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12277)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12279
      getDistributionConfig
      (cloudfront/get-distribution-config-request
       (clojure.core/nth args12278 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :update-distribution
   [m12280]
   (clojure.core/let
    [credentials12281 (:credentials m12280) args12282 (:args m12280)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12283
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12281)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12283
       updateDistribution
       (cloudfront/update-distribution-request
        (clojure.core/nth args12282 0)))))))
  (clojure.core/defn
   update-distribution-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         if-match
                         custom-query-parameters
                         distribution-config
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateDistribution"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-distribution,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   update-distribution
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         if-match
                         custom-query-parameters
                         distribution-config
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateDistribution"}
   [credentials12285 & args12286]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12287
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12285)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12287
      updateDistribution
      (cloudfront/update-distribution-request
       (clojure.core/nth args12286 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :get-cloud-front-origin-access-identity
   [m12288]
   (clojure.core/let
    [credentials12289 (:credentials m12288) args12290 (:args m12288)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12291
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12289)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12291
       getCloudFrontOriginAccessIdentity
       (cloudfront/get-cloud-front-origin-access-identity-request
        (clojure.core/nth args12290 0)))))))
  (clojure.core/defn
   get-cloud-front-origin-access-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getCloudFrontOriginAccessIdentity"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-cloud-front-origin-access-identity,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   get-cloud-front-origin-access-identity
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getCloudFrontOriginAccessIdentity"}
   [credentials12293 & args12294]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12295
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12293)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12295
      getCloudFrontOriginAccessIdentity
      (cloudfront/get-cloud-front-origin-access-identity-request
       (clojure.core/nth args12294 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :get-streaming-distribution-config
   [m12296]
   (clojure.core/let
    [credentials12297 (:credentials m12296) args12298 (:args m12296)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12299
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12297)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12299
       getStreamingDistributionConfig
       (cloudfront/get-streaming-distribution-config-request
        (clojure.core/nth args12298 0)))))))
  (clojure.core/defn
   get-streaming-distribution-config-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getStreamingDistributionConfig"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-streaming-distribution-config,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   get-streaming-distribution-config
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getStreamingDistributionConfig"}
   [credentials12301 & args12302]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12303
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12301)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12303
      getStreamingDistributionConfig
      (cloudfront/get-streaming-distribution-config-request
       (clojure.core/nth args12302 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :update-cloud-front-origin-access-identity
   [m12304]
   (clojure.core/let
    [credentials12305 (:credentials m12304) args12306 (:args m12304)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12307
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12305)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12307
       updateCloudFrontOriginAccessIdentity
       (cloudfront/update-cloud-front-origin-access-identity-request
        (clojure.core/nth args12306 0)))))))
  (clojure.core/defn
   update-cloud-front-origin-access-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         if-match
                         cloud-front-origin-access-identity-config
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateCloudFrontOriginAccessIdentity"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-cloud-front-origin-access-identity,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   update-cloud-front-origin-access-identity
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         if-match
                         cloud-front-origin-access-identity-config
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateCloudFrontOriginAccessIdentity"}
   [credentials12309 & args12310]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12311
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12309)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12311
      updateCloudFrontOriginAccessIdentity
      (cloudfront/update-cloud-front-origin-access-identity-request
       (clojure.core/nth args12310 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :create-streaming-distribution
   [m12312]
   (clojure.core/let
    [credentials12313 (:credentials m12312) args12314 (:args m12312)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12315
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12313)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12315
       createStreamingDistribution
       (cloudfront/create-streaming-distribution-request
        (clojure.core/nth args12314 0)))))))
  (clojure.core/defn
   create-streaming-distribution-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         streaming-distribution-config
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createStreamingDistribution"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-streaming-distribution,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   create-streaming-distribution
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         streaming-distribution-config
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createStreamingDistribution"}
   [credentials12317 & args12318]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12319
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12317)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12319
      createStreamingDistribution
      (cloudfront/create-streaming-distribution-request
       (clojure.core/nth args12318 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :get-invalidation
   [m12320]
   (clojure.core/let
    [credentials12321 (:credentials m12320) args12322 (:args m12320)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12323
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12321)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12323
       getInvalidation
       (cloudfront/get-invalidation-request
        (clojure.core/nth args12322 0)))))))
  (clojure.core/defn
   get-invalidation-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         distribution-id
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getInvalidation"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-invalidation,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   get-invalidation
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         distribution-id
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getInvalidation"}
   [credentials12325 & args12326]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12327
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12325)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12327
      getInvalidation
      (cloudfront/get-invalidation-request
       (clojure.core/nth args12326 0))))))))
