(ns
 com.palletops.awaze.cloudformation
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.cloudformation :as cloudformation]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :cloudformation
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.cloudformation.AmazonCloudFormationClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.Parameter}
parameter
  [m4927]
  (clojure.core/let
   [bean4926
    (new com.amazonaws.services.cloudformation.model.Parameter)]
   (clojure.core/let
    [v4928
     (:parameter-key m4927 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4928 :com.palletops.awaze.client-builder/undef)
     (. bean4926 setParameterKey (clojure.core/str v4928))))
   (clojure.core/let
    [v4928
     (:parameter-value
      m4927
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4928 :com.palletops.awaze.client-builder/undef)
     (. bean4926 setParameterValue (clojure.core/str v4928))))
   (clojure.core/let
    [v4928
     (:use-previous-value
      m4927
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4928 :com.palletops.awaze.client-builder/undef)
     (. bean4926 setUsePreviousValue (clojure.core/boolean v4928))))
   bean4926))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.Tag}
tag
  [m4930]
  (clojure.core/let
   [bean4929 (new com.amazonaws.services.cloudformation.model.Tag)]
   (clojure.core/let
    [v4931 (:key m4930 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4931 :com.palletops.awaze.client-builder/undef)
     (. bean4929 setKey (clojure.core/str v4931))))
   (clojure.core/let
    [v4931 (:value m4930 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4931 :com.palletops.awaze.client-builder/undef)
     (. bean4929 setValue (clojure.core/str v4931))))
   bean4929))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.ResourceSignalStatus}
resource-signal-status
  [m4933]
  (.
   com.amazonaws.services.cloudformation.model.ResourceSignalStatus
   fromValue
   (clojure.core/name m4933)))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.ContinueUpdateRollbackRequest}
continue-update-rollback-request
  [m4936]
  (clojure.core/let
   [bean4935
    (new
     com.amazonaws.services.cloudformation.model.ContinueUpdateRollbackRequest)]
   (clojure.core/let
    [v4937
     (:stack-name m4936 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4937 :com.palletops.awaze.client-builder/undef)
     (. bean4935 setStackName (clojure.core/str v4937))))
   bean4935))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.DescribeChangeSetRequest}
describe-change-set-request
  [m4939]
  (clojure.core/let
   [bean4938
    (new
     com.amazonaws.services.cloudformation.model.DescribeChangeSetRequest)]
   (clojure.core/let
    [v4940
     (:change-set-name
      m4939
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4940 :com.palletops.awaze.client-builder/undef)
     (. bean4938 setChangeSetName (clojure.core/str v4940))))
   (clojure.core/let
    [v4940
     (:stack-name m4939 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4940 :com.palletops.awaze.client-builder/undef)
     (. bean4938 setStackName (clojure.core/str v4940))))
   (clojure.core/let
    [v4940
     (:next-token m4939 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4940 :com.palletops.awaze.client-builder/undef)
     (. bean4938 setNextToken (clojure.core/str v4940))))
   bean4938))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.SetStackPolicyRequest}
set-stack-policy-request
  [m4942]
  (clojure.core/let
   [bean4941
    (new
     com.amazonaws.services.cloudformation.model.SetStackPolicyRequest)]
   (clojure.core/let
    [v4943
     (:stack-name m4942 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4943 :com.palletops.awaze.client-builder/undef)
     (. bean4941 setStackName (clojure.core/str v4943))))
   (clojure.core/let
    [v4943
     (:stack-policy-body
      m4942
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4943 :com.palletops.awaze.client-builder/undef)
     (. bean4941 setStackPolicyBody (clojure.core/str v4943))))
   (clojure.core/let
    [v4943
     (:stack-policy-url
      m4942
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4943 :com.palletops.awaze.client-builder/undef)
     (. bean4941 setStackPolicyURL (clojure.core/str v4943))))
   bean4941))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.DescribeStacksRequest}
describe-stacks-request
  [m4945]
  (clojure.core/let
   [bean4944
    (new
     com.amazonaws.services.cloudformation.model.DescribeStacksRequest)]
   (clojure.core/let
    [v4946
     (:stack-name m4945 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4946 :com.palletops.awaze.client-builder/undef)
     (. bean4944 setStackName (clojure.core/str v4946))))
   (clojure.core/let
    [v4946
     (:next-token m4945 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4946 :com.palletops.awaze.client-builder/undef)
     (. bean4944 setNextToken (clojure.core/str v4946))))
   bean4944))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.UpdateStackRequest}
update-stack-request
  [m4948]
  (clojure.core/let
   [bean4947
    (new
     com.amazonaws.services.cloudformation.model.UpdateStackRequest)]
   (clojure.core/let
    [v4949
     (:use-previous-template
      m4948
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4949 :com.palletops.awaze.client-builder/undef)
     (. bean4947 setUsePreviousTemplate (clojure.core/boolean v4949))))
   (clojure.core/let
    [v4949
     (:stack-name m4948 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4949 :com.palletops.awaze.client-builder/undef)
     (. bean4947 setStackName (clojure.core/str v4949))))
   (clojure.core/let
    [v4949
     (:notification-arns
      m4948
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4949 :com.palletops.awaze.client-builder/undef)
     (.
      bean4947
      setNotificationARNs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5007] (clojure.core/str arg5007))
 v4949))))
   (clojure.core/let
    [v4949
     (:parameters m4948 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4949 :com.palletops.awaze.client-builder/undef)
     (.
      bean4947
      setParameters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5008] (cloudformation/parameter arg5008))
 v4949))))
   (clojure.core/let
    [v4949
     (:stack-policy-during-update-body
      m4948
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4949 :com.palletops.awaze.client-builder/undef)
     (.
      bean4947
      setStackPolicyDuringUpdateBody
      (clojure.core/str v4949))))
   (clojure.core/let
    [v4949
     (:template-url m4948 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4949 :com.palletops.awaze.client-builder/undef)
     (. bean4947 setTemplateURL (clojure.core/str v4949))))
   (clojure.core/let
    [v4949
     (:stack-policy-url
      m4948
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4949 :com.palletops.awaze.client-builder/undef)
     (. bean4947 setStackPolicyURL (clojure.core/str v4949))))
   (clojure.core/let
    [v4949
     (:stack-policy-body
      m4948
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4949 :com.palletops.awaze.client-builder/undef)
     (. bean4947 setStackPolicyBody (clojure.core/str v4949))))
   (clojure.core/let
    [v4949 (:tags m4948 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4949 :com.palletops.awaze.client-builder/undef)
     (.
      bean4947
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5009] (cloudformation/tag arg5009))
 v4949))))
   (clojure.core/let
    [v4949
     (:stack-policy-during-update-url
      m4948
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4949 :com.palletops.awaze.client-builder/undef)
     (.
      bean4947
      setStackPolicyDuringUpdateURL
      (clojure.core/str v4949))))
   (clojure.core/let
    [v4949
     (:template-body m4948 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4949 :com.palletops.awaze.client-builder/undef)
     (. bean4947 setTemplateBody (clojure.core/str v4949))))
   (clojure.core/let
    [v4949
     (:resource-types m4948 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4949 :com.palletops.awaze.client-builder/undef)
     (.
      bean4947
      setResourceTypes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5010] (clojure.core/str arg5010))
 v4949))))
   (clojure.core/let
    [v4949
     (:capabilities m4948 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4949 :com.palletops.awaze.client-builder/undef)
     (.
      bean4947
      setCapabilities
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5011] (clojure.core/str arg5011))
 v4949))))
   bean4947))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.EstimateTemplateCostRequest}
estimate-template-cost-request
  [m4951]
  (clojure.core/let
   [bean4950
    (new
     com.amazonaws.services.cloudformation.model.EstimateTemplateCostRequest)]
   (clojure.core/let
    [v4952
     (:template-body m4951 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4952 :com.palletops.awaze.client-builder/undef)
     (. bean4950 setTemplateBody (clojure.core/str v4952))))
   (clojure.core/let
    [v4952
     (:template-url m4951 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4952 :com.palletops.awaze.client-builder/undef)
     (. bean4950 setTemplateURL (clojure.core/str v4952))))
   (clojure.core/let
    [v4952
     (:parameters m4951 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4952 :com.palletops.awaze.client-builder/undef)
     (.
      bean4950
      setParameters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5012] (cloudformation/parameter arg5012))
 v4952))))
   bean4950))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.ListStacksRequest}
list-stacks-request
  [m4954]
  (clojure.core/let
   [bean4953
    (new
     com.amazonaws.services.cloudformation.model.ListStacksRequest)]
   (clojure.core/let
    [v4955
     (:stack-status-filters
      m4954
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4955 :com.palletops.awaze.client-builder/undef)
     (.
      bean4953
      setStackStatusFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5013] (clojure.core/str arg5013))
 v4955))))
   (clojure.core/let
    [v4955
     (:next-token m4954 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4955 :com.palletops.awaze.client-builder/undef)
     (. bean4953 setNextToken (clojure.core/str v4955))))
   bean4953))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.DescribeStackEventsRequest}
describe-stack-events-request
  [m4957]
  (clojure.core/let
   [bean4956
    (new
     com.amazonaws.services.cloudformation.model.DescribeStackEventsRequest)]
   (clojure.core/let
    [v4958
     (:stack-name m4957 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4958 :com.palletops.awaze.client-builder/undef)
     (. bean4956 setStackName (clojure.core/str v4958))))
   (clojure.core/let
    [v4958
     (:next-token m4957 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4958 :com.palletops.awaze.client-builder/undef)
     (. bean4956 setNextToken (clojure.core/str v4958))))
   bean4956))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.DeleteStackRequest}
delete-stack-request
  [m4960]
  (clojure.core/let
   [bean4959
    (new
     com.amazonaws.services.cloudformation.model.DeleteStackRequest)]
   (clojure.core/let
    [v4961
     (:stack-name m4960 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4961 :com.palletops.awaze.client-builder/undef)
     (. bean4959 setStackName (clojure.core/str v4961))))
   (clojure.core/let
    [v4961
     (:retain-resources
      m4960
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4961 :com.palletops.awaze.client-builder/undef)
     (.
      bean4959
      setRetainResources
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5014] (clojure.core/str arg5014))
 v4961))))
   bean4959))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.ValidateTemplateRequest}
validate-template-request
  [m4963]
  (clojure.core/let
   [bean4962
    (new
     com.amazonaws.services.cloudformation.model.ValidateTemplateRequest)]
   (clojure.core/let
    [v4964
     (:template-body m4963 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4964 :com.palletops.awaze.client-builder/undef)
     (. bean4962 setTemplateBody (clojure.core/str v4964))))
   (clojure.core/let
    [v4964
     (:template-url m4963 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4964 :com.palletops.awaze.client-builder/undef)
     (. bean4962 setTemplateURL (clojure.core/str v4964))))
   bean4962))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.DescribeStackResourcesRequest}
describe-stack-resources-request
  [m4966]
  (clojure.core/let
   [bean4965
    (new
     com.amazonaws.services.cloudformation.model.DescribeStackResourcesRequest)]
   (clojure.core/let
    [v4967
     (:stack-name m4966 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4967 :com.palletops.awaze.client-builder/undef)
     (. bean4965 setStackName (clojure.core/str v4967))))
   (clojure.core/let
    [v4967
     (:logical-resource-id
      m4966
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4967 :com.palletops.awaze.client-builder/undef)
     (. bean4965 setLogicalResourceId (clojure.core/str v4967))))
   (clojure.core/let
    [v4967
     (:physical-resource-id
      m4966
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4967 :com.palletops.awaze.client-builder/undef)
     (. bean4965 setPhysicalResourceId (clojure.core/str v4967))))
   bean4965))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.DescribeAccountLimitsRequest}
describe-account-limits-request
  [m4969]
  (clojure.core/let
   [bean4968
    (new
     com.amazonaws.services.cloudformation.model.DescribeAccountLimitsRequest)]
   (clojure.core/let
    [v4970
     (:next-token m4969 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4970 :com.palletops.awaze.client-builder/undef)
     (. bean4968 setNextToken (clojure.core/str v4970))))
   bean4968))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.SignalResourceRequest}
signal-resource-request
  [m4972]
  (clojure.core/let
   [bean4971
    (new
     com.amazonaws.services.cloudformation.model.SignalResourceRequest)]
   (clojure.core/let
    [v4973
     (:stack-name m4972 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4973 :com.palletops.awaze.client-builder/undef)
     (. bean4971 setStackName (clojure.core/str v4973))))
   (clojure.core/let
    [v4973
     (:logical-resource-id
      m4972
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4973 :com.palletops.awaze.client-builder/undef)
     (. bean4971 setLogicalResourceId (clojure.core/str v4973))))
   (clojure.core/let
    [v4973
     (:unique-id m4972 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4973 :com.palletops.awaze.client-builder/undef)
     (. bean4971 setUniqueId (clojure.core/str v4973))))
   (clojure.core/let
    [v4973 (:status m4972 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4973 :com.palletops.awaze.client-builder/undef)
     (.
      bean4971
      setStatus
      (cloudformation/resource-signal-status v4973))))
   bean4971))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.GetTemplateRequest}
get-template-request
  [m4975]
  (clojure.core/let
   [bean4974
    (new
     com.amazonaws.services.cloudformation.model.GetTemplateRequest)]
   (clojure.core/let
    [v4976
     (:stack-name m4975 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4976 :com.palletops.awaze.client-builder/undef)
     (. bean4974 setStackName (clojure.core/str v4976))))
   bean4974))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.GetStackPolicyRequest}
get-stack-policy-request
  [m4978]
  (clojure.core/let
   [bean4977
    (new
     com.amazonaws.services.cloudformation.model.GetStackPolicyRequest)]
   (clojure.core/let
    [v4979
     (:stack-name m4978 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4979 :com.palletops.awaze.client-builder/undef)
     (. bean4977 setStackName (clojure.core/str v4979))))
   bean4977))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.CreateStackRequest}
create-stack-request
  [m4981]
  (clojure.core/let
   [bean4980
    (new
     com.amazonaws.services.cloudformation.model.CreateStackRequest)]
   (clojure.core/let
    [v4982
     (:stack-name m4981 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4982 :com.palletops.awaze.client-builder/undef)
     (. bean4980 setStackName (clojure.core/str v4982))))
   (clojure.core/let
    [v4982
     (:notification-arns
      m4981
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4982 :com.palletops.awaze.client-builder/undef)
     (.
      bean4980
      setNotificationARNs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5039] (clojure.core/str arg5039))
 v4982))))
   (clojure.core/let
    [v4982
     (:parameters m4981 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4982 :com.palletops.awaze.client-builder/undef)
     (.
      bean4980
      setParameters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5040] (cloudformation/parameter arg5040))
 v4982))))
   (clojure.core/let
    [v4982
     (:timeout-in-minutes
      m4981
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4982 :com.palletops.awaze.client-builder/undef)
     (. bean4980 setTimeoutInMinutes (clojure.core/int v4982))))
   (clojure.core/let
    [v4982
     (:disable-rollback
      m4981
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4982 :com.palletops.awaze.client-builder/undef)
     (. bean4980 setDisableRollback (clojure.core/boolean v4982))))
   (clojure.core/let
    [v4982
     (:template-url m4981 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4982 :com.palletops.awaze.client-builder/undef)
     (. bean4980 setTemplateURL (clojure.core/str v4982))))
   (clojure.core/let
    [v4982
     (:stack-policy-url
      m4981
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4982 :com.palletops.awaze.client-builder/undef)
     (. bean4980 setStackPolicyURL (clojure.core/str v4982))))
   (clojure.core/let
    [v4982
     (:stack-policy-body
      m4981
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4982 :com.palletops.awaze.client-builder/undef)
     (. bean4980 setStackPolicyBody (clojure.core/str v4982))))
   (clojure.core/let
    [v4982 (:tags m4981 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4982 :com.palletops.awaze.client-builder/undef)
     (.
      bean4980
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5041] (cloudformation/tag arg5041))
 v4982))))
   (clojure.core/let
    [v4982
     (:template-body m4981 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4982 :com.palletops.awaze.client-builder/undef)
     (. bean4980 setTemplateBody (clojure.core/str v4982))))
   (clojure.core/let
    [v4982
     (:resource-types m4981 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4982 :com.palletops.awaze.client-builder/undef)
     (.
      bean4980
      setResourceTypes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5042] (clojure.core/str arg5042))
 v4982))))
   (clojure.core/let
    [v4982
     (:capabilities m4981 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4982 :com.palletops.awaze.client-builder/undef)
     (.
      bean4980
      setCapabilities
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5043] (clojure.core/str arg5043))
 v4982))))
   (clojure.core/let
    [v4982
     (:on-failure m4981 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4982 :com.palletops.awaze.client-builder/undef)
     (. bean4980 setOnFailure (clojure.core/str v4982))))
   bean4980))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.ListStackResourcesRequest}
list-stack-resources-request
  [m4984]
  (clojure.core/let
   [bean4983
    (new
     com.amazonaws.services.cloudformation.model.ListStackResourcesRequest)]
   (clojure.core/let
    [v4985
     (:stack-name m4984 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4985 :com.palletops.awaze.client-builder/undef)
     (. bean4983 setStackName (clojure.core/str v4985))))
   (clojure.core/let
    [v4985
     (:next-token m4984 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4985 :com.palletops.awaze.client-builder/undef)
     (. bean4983 setNextToken (clojure.core/str v4985))))
   bean4983))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.DescribeStackResourceRequest}
describe-stack-resource-request
  [m4987]
  (clojure.core/let
   [bean4986
    (new
     com.amazonaws.services.cloudformation.model.DescribeStackResourceRequest)]
   (clojure.core/let
    [v4988
     (:stack-name m4987 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4988 :com.palletops.awaze.client-builder/undef)
     (. bean4986 setStackName (clojure.core/str v4988))))
   (clojure.core/let
    [v4988
     (:logical-resource-id
      m4987
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4988 :com.palletops.awaze.client-builder/undef)
     (. bean4986 setLogicalResourceId (clojure.core/str v4988))))
   bean4986))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.ListChangeSetsRequest}
list-change-sets-request
  [m4990]
  (clojure.core/let
   [bean4989
    (new
     com.amazonaws.services.cloudformation.model.ListChangeSetsRequest)]
   (clojure.core/let
    [v4991
     (:stack-name m4990 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4991 :com.palletops.awaze.client-builder/undef)
     (. bean4989 setStackName (clojure.core/str v4991))))
   (clojure.core/let
    [v4991
     (:next-token m4990 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4991 :com.palletops.awaze.client-builder/undef)
     (. bean4989 setNextToken (clojure.core/str v4991))))
   bean4989))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.CancelUpdateStackRequest}
cancel-update-stack-request
  [m4993]
  (clojure.core/let
   [bean4992
    (new
     com.amazonaws.services.cloudformation.model.CancelUpdateStackRequest)]
   (clojure.core/let
    [v4994
     (:stack-name m4993 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4994 :com.palletops.awaze.client-builder/undef)
     (. bean4992 setStackName (clojure.core/str v4994))))
   bean4992))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.CreateChangeSetRequest}
create-change-set-request
  [m4996]
  (clojure.core/let
   [bean4995
    (new
     com.amazonaws.services.cloudformation.model.CreateChangeSetRequest)]
   (clojure.core/let
    [v4997
     (:description m4996 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4997 :com.palletops.awaze.client-builder/undef)
     (. bean4995 setDescription (clojure.core/str v4997))))
   (clojure.core/let
    [v4997
     (:use-previous-template
      m4996
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4997 :com.palletops.awaze.client-builder/undef)
     (. bean4995 setUsePreviousTemplate (clojure.core/boolean v4997))))
   (clojure.core/let
    [v4997
     (:stack-name m4996 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4997 :com.palletops.awaze.client-builder/undef)
     (. bean4995 setStackName (clojure.core/str v4997))))
   (clojure.core/let
    [v4997
     (:notification-arns
      m4996
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4997 :com.palletops.awaze.client-builder/undef)
     (.
      bean4995
      setNotificationARNs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5044] (clojure.core/str arg5044))
 v4997))))
   (clojure.core/let
    [v4997
     (:parameters m4996 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4997 :com.palletops.awaze.client-builder/undef)
     (.
      bean4995
      setParameters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5045] (cloudformation/parameter arg5045))
 v4997))))
   (clojure.core/let
    [v4997
     (:client-token m4996 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4997 :com.palletops.awaze.client-builder/undef)
     (. bean4995 setClientToken (clojure.core/str v4997))))
   (clojure.core/let
    [v4997
     (:template-url m4996 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4997 :com.palletops.awaze.client-builder/undef)
     (. bean4995 setTemplateURL (clojure.core/str v4997))))
   (clojure.core/let
    [v4997 (:tags m4996 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4997 :com.palletops.awaze.client-builder/undef)
     (.
      bean4995
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5046] (cloudformation/tag arg5046))
 v4997))))
   (clojure.core/let
    [v4997
     (:change-set-name
      m4996
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4997 :com.palletops.awaze.client-builder/undef)
     (. bean4995 setChangeSetName (clojure.core/str v4997))))
   (clojure.core/let
    [v4997
     (:template-body m4996 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4997 :com.palletops.awaze.client-builder/undef)
     (. bean4995 setTemplateBody (clojure.core/str v4997))))
   (clojure.core/let
    [v4997
     (:resource-types m4996 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4997 :com.palletops.awaze.client-builder/undef)
     (.
      bean4995
      setResourceTypes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5047] (clojure.core/str arg5047))
 v4997))))
   (clojure.core/let
    [v4997
     (:capabilities m4996 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4997 :com.palletops.awaze.client-builder/undef)
     (.
      bean4995
      setCapabilities
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5048] (clojure.core/str arg5048))
 v4997))))
   bean4995))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.ExecuteChangeSetRequest}
execute-change-set-request
  [m4999]
  (clojure.core/let
   [bean4998
    (new
     com.amazonaws.services.cloudformation.model.ExecuteChangeSetRequest)]
   (clojure.core/let
    [v5000
     (:change-set-name
      m4999
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5000 :com.palletops.awaze.client-builder/undef)
     (. bean4998 setChangeSetName (clojure.core/str v5000))))
   (clojure.core/let
    [v5000
     (:stack-name m4999 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5000 :com.palletops.awaze.client-builder/undef)
     (. bean4998 setStackName (clojure.core/str v5000))))
   bean4998))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.DeleteChangeSetRequest}
delete-change-set-request
  [m5002]
  (clojure.core/let
   [bean5001
    (new
     com.amazonaws.services.cloudformation.model.DeleteChangeSetRequest)]
   (clojure.core/let
    [v5003
     (:change-set-name
      m5002
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5003 :com.palletops.awaze.client-builder/undef)
     (. bean5001 setChangeSetName (clojure.core/str v5003))))
   (clojure.core/let
    [v5003
     (:stack-name m5002 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5003 :com.palletops.awaze.client-builder/undef)
     (. bean5001 setStackName (clojure.core/str v5003))))
   bean5001))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.GetTemplateSummaryRequest}
get-template-summary-request
  [m5005]
  (clojure.core/let
   [bean5004
    (new
     com.amazonaws.services.cloudformation.model.GetTemplateSummaryRequest)]
   (clojure.core/let
    [v5006
     (:stack-name m5005 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5006 :com.palletops.awaze.client-builder/undef)
     (. bean5004 setStackName (clojure.core/str v5006))))
   (clojure.core/let
    [v5006
     (:template-body m5005 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5006 :com.palletops.awaze.client-builder/undef)
     (. bean5004 setTemplateBody (clojure.core/str v5006))))
   (clojure.core/let
    [v5006
     (:template-url m5005 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5006 :com.palletops.awaze.client-builder/undef)
     (. bean5004 setTemplateURL (clojure.core/str v5006))))
   bean5004))
 (clojure.core/defmulti
  cloudformation
  (clojure.core/fn
   cloudformation
   [m__1874__auto__]
   (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   cloudformation
   :continue-update-rollback
   [m5015]
   (clojure.core/let
    [credentials5016 (:credentials m5015) args5017 (:args m5015)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5018
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5016)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5018
       continueUpdateRollback
       (cloudformation/continue-update-rollback-request
        (clojure.core/nth args5017 0)))))))
  (clojure.core/defn
   continue-update-rollback-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for continueUpdateRollback"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :continue-update-rollback,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   continue-update-rollback
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call continueUpdateRollback"}
   [credentials5020 & args5021]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5022
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5020)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5022
      continueUpdateRollback
      (cloudformation/continue-update-rollback-request
       (clojure.core/nth args5021 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :describe-change-set
   [m5023]
   (clojure.core/let
    [credentials5024 (:credentials m5023) args5025 (:args m5023)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5026
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5024)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5026
       describeChangeSet
       (cloudformation/describe-change-set-request
        (clojure.core/nth args5025 0)))))))
  (clojure.core/defn
   describe-change-set-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         change-set-name
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeChangeSet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-change-set,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   describe-change-set
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         change-set-name
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeChangeSet"}
   [credentials5028 & args5029]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5030
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5028)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5030
      describeChangeSet
      (cloudformation/describe-change-set-request
       (clojure.core/nth args5029 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :set-stack-policy
   [m5031]
   (clojure.core/let
    [credentials5032 (:credentials m5031) args5033 (:args m5031)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5034
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5032)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5034
       setStackPolicy
       (cloudformation/set-stack-policy-request
        (clojure.core/nth args5033 0)))))))
  (clojure.core/defn
   set-stack-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         stack-policy-body
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         stack-policy-url]}]]),
    :doc "Generate map for setStackPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-stack-policy,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   set-stack-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         stack-policy-body
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         stack-policy-url]}]]),
    :doc "Call setStackPolicy"}
   [credentials5036 & args5037]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5038
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5036)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5038
      setStackPolicy
      (cloudformation/set-stack-policy-request
       (clojure.core/nth args5037 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :describe-stacks
   [m5049]
   (clojure.core/let
    [credentials5050 (:credentials m5049) args5051 (:args m5049)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5052
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5050)]
     (clojure.core/case
      (clojure.core/count args5051)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5052
        describeStacks
        (cloudformation/describe-stacks-request
         (clojure.core/nth args5051 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5052
        describeStacks))))))
  (clojure.core/defn
   describe-stacks-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeStacks, describeStacks"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-stacks,
     :credentials credentials__1842__auto__,
     :client :cloudformation})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-stacks,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   describe-stacks
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call describeStacks, describeStacks"}
   [credentials5054 & args5055]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5056
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5054)]
    (clojure.core/case
     (clojure.core/count args5055)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5056
       describeStacks
       (cloudformation/describe-stacks-request
        (clojure.core/nth args5055 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5056
       describeStacks))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :update-stack
   [m5057]
   (clojure.core/let
    [credentials5058 (:credentials m5057) args5059 (:args m5057)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5060
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5058)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5060
       updateStack
       (cloudformation/update-stack-request
        (clojure.core/nth args5059 0)))))))
  (clojure.core/defn
   update-stack-map
   {:arglists (quote
               [[credentials
                 {:keys [capabilities
                         use-previous-template
                         tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         notification-arns
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         stack-policy-body
                         template-body
                         resource-types
                         read-limit
                         general-progress-listener
                         clone-source
                         template-url
                         parameters
                         stack-policy-during-update-body
                         clone-root
                         stack-policy-url
                         stack-policy-during-update-url]}]]),
    :doc "Generate map for updateStack"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-stack,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   update-stack
   {:arglists (quote
               [[credentials
                 {:keys [capabilities
                         use-previous-template
                         tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         notification-arns
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         stack-policy-body
                         template-body
                         resource-types
                         read-limit
                         general-progress-listener
                         clone-source
                         template-url
                         parameters
                         stack-policy-during-update-body
                         clone-root
                         stack-policy-url
                         stack-policy-during-update-url]}]]),
    :doc "Call updateStack"}
   [credentials5062 & args5063]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5064
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5062)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5064
      updateStack
      (cloudformation/update-stack-request
       (clojure.core/nth args5063 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :estimate-template-cost
   [m5065]
   (clojure.core/let
    [credentials5066 (:credentials m5065) args5067 (:args m5065)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5068
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5066)]
     (clojure.core/case
      (clojure.core/count args5067)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5068
        estimateTemplateCost))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5068
        estimateTemplateCost
        (cloudformation/estimate-template-cost-request
         (clojure.core/nth args5067 0))))))))
  (clojure.core/defn
   estimate-template-cost-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         template-body
                         read-limit
                         general-progress-listener
                         clone-source
                         template-url
                         parameters
                         clone-root]}]]),
    :doc "Generate map for estimateTemplateCost, estimateTemplateCost"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :estimate-template-cost,
     :credentials credentials__1842__auto__,
     :client :cloudformation})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :estimate-template-cost,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   estimate-template-cost
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         template-body
                         read-limit
                         general-progress-listener
                         clone-source
                         template-url
                         parameters
                         clone-root]}]]),
    :doc "Call estimateTemplateCost, estimateTemplateCost"}
   [credentials5070 & args5071]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5072
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5070)]
    (clojure.core/case
     (clojure.core/count args5071)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5072
       estimateTemplateCost))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5072
       estimateTemplateCost
       (cloudformation/estimate-template-cost-request
        (clojure.core/nth args5071 0))))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :list-stacks
   [m5073]
   (clojure.core/let
    [credentials5074 (:credentials m5073) args5075 (:args m5073)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5076
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5074)]
     (clojure.core/case
      (clojure.core/count args5075)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5076
        listStacks
        (cloudformation/list-stacks-request
         (clojure.core/nth args5075 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5076
        listStacks))))))
  (clojure.core/defn
   list-stacks-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         stack-status-filters
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for listStacks, listStacks"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-stacks,
     :credentials credentials__1842__auto__,
     :client :cloudformation})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-stacks,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   list-stacks
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         stack-status-filters
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call listStacks, listStacks"}
   [credentials5078 & args5079]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5080
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5078)]
    (clojure.core/case
     (clojure.core/count args5079)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5080
       listStacks
       (cloudformation/list-stacks-request
        (clojure.core/nth args5079 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5080
       listStacks))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :describe-stack-events
   [m5081]
   (clojure.core/let
    [credentials5082 (:credentials m5081) args5083 (:args m5081)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5084
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5082)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5084
       describeStackEvents
       (cloudformation/describe-stack-events-request
        (clojure.core/nth args5083 0)))))))
  (clojure.core/defn
   describe-stack-events-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeStackEvents"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-stack-events,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   describe-stack-events
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeStackEvents"}
   [credentials5086 & args5087]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5088
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5086)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5088
      describeStackEvents
      (cloudformation/describe-stack-events-request
       (clojure.core/nth args5087 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :delete-stack
   [m5089]
   (clojure.core/let
    [credentials5090 (:credentials m5089) args5091 (:args m5089)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5092
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5090)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5092
       deleteStack
       (cloudformation/delete-stack-request
        (clojure.core/nth args5091 0)))))))
  (clojure.core/defn
   delete-stack-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         retain-resources
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteStack"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-stack,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   delete-stack
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         retain-resources
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteStack"}
   [credentials5094 & args5095]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5096
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5094)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5096
      deleteStack
      (cloudformation/delete-stack-request
       (clojure.core/nth args5095 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :validate-template
   [m5097]
   (clojure.core/let
    [credentials5098 (:credentials m5097) args5099 (:args m5097)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5100
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5098)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5100
       validateTemplate
       (cloudformation/validate-template-request
        (clojure.core/nth args5099 0)))))))
  (clojure.core/defn
   validate-template-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         template-body
                         read-limit
                         general-progress-listener
                         clone-source
                         template-url
                         clone-root]}]]),
    :doc "Generate map for validateTemplate"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :validate-template,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   validate-template
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         template-body
                         read-limit
                         general-progress-listener
                         clone-source
                         template-url
                         clone-root]}]]),
    :doc "Call validateTemplate"}
   [credentials5102 & args5103]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5104
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5102)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5104
      validateTemplate
      (cloudformation/validate-template-request
       (clojure.core/nth args5103 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :describe-stack-resources
   [m5105]
   (clojure.core/let
    [credentials5106 (:credentials m5105) args5107 (:args m5105)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5108
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5106)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5108
       describeStackResources
       (cloudformation/describe-stack-resources-request
        (clojure.core/nth args5107 0)))))))
  (clojure.core/defn
   describe-stack-resources-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         physical-resource-id
                         general-progress-listener
                         logical-resource-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeStackResources"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-stack-resources,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   describe-stack-resources
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         physical-resource-id
                         general-progress-listener
                         logical-resource-id
                         clone-source
                         clone-root]}]]),
    :doc "Call describeStackResources"}
   [credentials5110 & args5111]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5112
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5110)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5112
      describeStackResources
      (cloudformation/describe-stack-resources-request
       (clojure.core/nth args5111 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :describe-account-limits
   [m5113]
   (clojure.core/let
    [credentials5114 (:credentials m5113) args5115 (:args m5113)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5116
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5114)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5116
       describeAccountLimits
       (cloudformation/describe-account-limits-request
        (clojure.core/nth args5115 0)))))))
  (clojure.core/defn
   describe-account-limits-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeAccountLimits"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-account-limits,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   describe-account-limits
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeAccountLimits"}
   [credentials5118 & args5119]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5120
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5118)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5120
      describeAccountLimits
      (cloudformation/describe-account-limits-request
       (clojure.core/nth args5119 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :signal-resource
   [m5121]
   (clojure.core/let
    [credentials5122 (:credentials m5121) args5123 (:args m5121)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5124
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5122)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5124
       signalResource
       (cloudformation/signal-resource-request
        (clojure.core/nth args5123 0)))))))
  (clojure.core/defn
   signal-resource-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         status
                         general-progress-listener
                         unique-id
                         logical-resource-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for signalResource"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :signal-resource,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   signal-resource
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         status
                         general-progress-listener
                         unique-id
                         logical-resource-id
                         clone-source
                         clone-root]}]]),
    :doc "Call signalResource"}
   [credentials5126 & args5127]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5128
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5126)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5128
      signalResource
      (cloudformation/signal-resource-request
       (clojure.core/nth args5127 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :get-template
   [m5129]
   (clojure.core/let
    [credentials5130 (:credentials m5129) args5131 (:args m5129)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5132
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5130)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5132
       getTemplate
       (cloudformation/get-template-request
        (clojure.core/nth args5131 0)))))))
  (clojure.core/defn
   get-template-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getTemplate"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-template,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   get-template
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getTemplate"}
   [credentials5134 & args5135]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5136
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5134)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5136
      getTemplate
      (cloudformation/get-template-request
       (clojure.core/nth args5135 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :get-stack-policy
   [m5137]
   (clojure.core/let
    [credentials5138 (:credentials m5137) args5139 (:args m5137)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5140
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5138)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5140
       getStackPolicy
       (cloudformation/get-stack-policy-request
        (clojure.core/nth args5139 0)))))))
  (clojure.core/defn
   get-stack-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getStackPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-stack-policy,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   get-stack-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getStackPolicy"}
   [credentials5142 & args5143]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5144
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5142)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5144
      getStackPolicy
      (cloudformation/get-stack-policy-request
       (clojure.core/nth args5143 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :create-stack
   [m5145]
   (clojure.core/let
    [credentials5146 (:credentials m5145) args5147 (:args m5145)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5148
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5146)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5148
       createStack
       (cloudformation/create-stack-request
        (clojure.core/nth args5147 0)))))))
  (clojure.core/defn
   create-stack-map
   {:arglists (quote
               [[credentials
                 {:keys [capabilities
                         tags
                         disable-rollback
                         custom-request-headers
                         sdk-client-execution-timeout
                         notification-arns
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         stack-policy-body
                         template-body
                         resource-types
                         timeout-in-minutes
                         read-limit
                         on-failure
                         general-progress-listener
                         clone-source
                         template-url
                         parameters
                         clone-root
                         stack-policy-url]}]]),
    :doc "Generate map for createStack"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-stack,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   create-stack
   {:arglists (quote
               [[credentials
                 {:keys [capabilities
                         tags
                         disable-rollback
                         custom-request-headers
                         sdk-client-execution-timeout
                         notification-arns
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         stack-policy-body
                         template-body
                         resource-types
                         timeout-in-minutes
                         read-limit
                         on-failure
                         general-progress-listener
                         clone-source
                         template-url
                         parameters
                         clone-root
                         stack-policy-url]}]]),
    :doc "Call createStack"}
   [credentials5150 & args5151]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5152
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5150)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5152
      createStack
      (cloudformation/create-stack-request
       (clojure.core/nth args5151 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :list-stack-resources
   [m5153]
   (clojure.core/let
    [credentials5154 (:credentials m5153) args5155 (:args m5153)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5156
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5154)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5156
       listStackResources
       (cloudformation/list-stack-resources-request
        (clojure.core/nth args5155 0)))))))
  (clojure.core/defn
   list-stack-resources-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for listStackResources"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-stack-resources,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   list-stack-resources
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call listStackResources"}
   [credentials5158 & args5159]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5160
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5158)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5160
      listStackResources
      (cloudformation/list-stack-resources-request
       (clojure.core/nth args5159 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :describe-stack-resource
   [m5161]
   (clojure.core/let
    [credentials5162 (:credentials m5161) args5163 (:args m5161)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5164
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5162)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5164
       describeStackResource
       (cloudformation/describe-stack-resource-request
        (clojure.core/nth args5163 0)))))))
  (clojure.core/defn
   describe-stack-resource-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         logical-resource-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeStackResource"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-stack-resource,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   describe-stack-resource
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         logical-resource-id
                         clone-source
                         clone-root]}]]),
    :doc "Call describeStackResource"}
   [credentials5166 & args5167]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5168
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5166)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5168
      describeStackResource
      (cloudformation/describe-stack-resource-request
       (clojure.core/nth args5167 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :list-change-sets
   [m5169]
   (clojure.core/let
    [credentials5170 (:credentials m5169) args5171 (:args m5169)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5172
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5170)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5172
       listChangeSets
       (cloudformation/list-change-sets-request
        (clojure.core/nth args5171 0)))))))
  (clojure.core/defn
   list-change-sets-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for listChangeSets"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-change-sets,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   list-change-sets
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call listChangeSets"}
   [credentials5174 & args5175]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5176
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5174)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5176
      listChangeSets
      (cloudformation/list-change-sets-request
       (clojure.core/nth args5175 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :cancel-update-stack
   [m5177]
   (clojure.core/let
    [credentials5178 (:credentials m5177) args5179 (:args m5177)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5180
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5178)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5180
       cancelUpdateStack
       (cloudformation/cancel-update-stack-request
        (clojure.core/nth args5179 0)))))))
  (clojure.core/defn
   cancel-update-stack-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for cancelUpdateStack"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :cancel-update-stack,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   cancel-update-stack
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call cancelUpdateStack"}
   [credentials5182 & args5183]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5184
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5182)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5184
      cancelUpdateStack
      (cloudformation/cancel-update-stack-request
       (clojure.core/nth args5183 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :create-change-set
   [m5185]
   (clojure.core/let
    [credentials5186 (:credentials m5185) args5187 (:args m5185)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5188
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5186)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5188
       createChangeSet
       (cloudformation/create-change-set-request
        (clojure.core/nth args5187 0)))))))
  (clojure.core/defn
   create-change-set-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         capabilities
                         use-previous-template
                         tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         notification-arns
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         template-body
                         resource-types
                         read-limit
                         change-set-name
                         general-progress-listener
                         clone-source
                         template-url
                         client-token
                         parameters
                         clone-root]}]]),
    :doc "Generate map for createChangeSet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-change-set,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   create-change-set
   {:arglists (quote
               [[credentials
                 {:keys [description
                         capabilities
                         use-previous-template
                         tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         notification-arns
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         template-body
                         resource-types
                         read-limit
                         change-set-name
                         general-progress-listener
                         clone-source
                         template-url
                         client-token
                         parameters
                         clone-root]}]]),
    :doc "Call createChangeSet"}
   [credentials5190 & args5191]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5192
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5190)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5192
      createChangeSet
      (cloudformation/create-change-set-request
       (clojure.core/nth args5191 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :execute-change-set
   [m5193]
   (clojure.core/let
    [credentials5194 (:credentials m5193) args5195 (:args m5193)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5196
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5194)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5196
       executeChangeSet
       (cloudformation/execute-change-set-request
        (clojure.core/nth args5195 0)))))))
  (clojure.core/defn
   execute-change-set-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         change-set-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for executeChangeSet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :execute-change-set,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   execute-change-set
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         change-set-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call executeChangeSet"}
   [credentials5198 & args5199]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5200
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5198)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5200
      executeChangeSet
      (cloudformation/execute-change-set-request
       (clojure.core/nth args5199 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :delete-change-set
   [m5201]
   (clojure.core/let
    [credentials5202 (:credentials m5201) args5203 (:args m5201)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5204
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5202)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5204
       deleteChangeSet
       (cloudformation/delete-change-set-request
        (clojure.core/nth args5203 0)))))))
  (clojure.core/defn
   delete-change-set-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         change-set-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteChangeSet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-change-set,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   delete-change-set
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         change-set-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteChangeSet"}
   [credentials5206 & args5207]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5208
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5206)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5208
      deleteChangeSet
      (cloudformation/delete-change-set-request
       (clojure.core/nth args5207 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :get-template-summary
   [m5209]
   (clojure.core/let
    [credentials5210 (:credentials m5209) args5211 (:args m5209)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5212
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5210)]
     (clojure.core/case
      (clojure.core/count args5211)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5212
        getTemplateSummary
        (cloudformation/get-template-summary-request
         (clojure.core/nth args5211 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5212
        getTemplateSummary))))))
  (clojure.core/defn
   get-template-summary-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         template-body
                         read-limit
                         general-progress-listener
                         clone-source
                         template-url
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for getTemplateSummary, getTemplateSummary"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-template-summary,
     :credentials credentials__1842__auto__,
     :client :cloudformation})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-template-summary,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   get-template-summary
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         template-body
                         read-limit
                         general-progress-listener
                         clone-source
                         template-url
                         clone-root]}]
                [credentials]]),
    :doc "Call getTemplateSummary, getTemplateSummary"}
   [credentials5214 & args5215]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5216
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5214)]
    (clojure.core/case
     (clojure.core/count args5215)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5216
       getTemplateSummary
       (cloudformation/get-template-summary-request
        (clojure.core/nth args5215 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5216
       getTemplateSummary)))))))
