(ns
 com.palletops.awaze.sts
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.sts :as sts]
  [com.palletops.awaze.beans.securitytoken :as securitytoken]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :sts
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient
   credentials__1792__auto__))
 (clojure.core/defmulti
  sts
  (clojure.core/fn sts [m__1874__auto__] (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   sts
   :assume-role
   [m11128]
   (clojure.core/let
    [credentials11129 (:credentials m11128) args11130 (:args m11128)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client11131
      (com.palletops.awaze.common/aws-client :sts credentials11129)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client11131
       assumeRole
       (securitytoken/assume-role-request
        (clojure.core/nth args11130 0)))))))
  (clojure.core/defn
   assume-role-map
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         serial-number
                         custom-request-headers
                         sdk-client-execution-timeout
                         token-code
                         sdk-request-timeout
                         custom-query-parameters
                         policy
                         role-arn
                         external-id
                         read-limit
                         general-progress-listener
                         clone-source
                         role-session-name
                         clone-root]}]]),
    :doc "Generate map for assumeRole"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :assume-role,
     :credentials credentials__1842__auto__,
     :client :sts}))
  (clojure.core/defn
   assume-role
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         serial-number
                         custom-request-headers
                         sdk-client-execution-timeout
                         token-code
                         sdk-request-timeout
                         custom-query-parameters
                         policy
                         role-arn
                         external-id
                         read-limit
                         general-progress-listener
                         clone-source
                         role-session-name
                         clone-root]}]]),
    :doc "Call assumeRole"}
   [credentials11133 & args11134]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client11135
     (com.palletops.awaze.common/aws-client :sts credentials11133)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client11135
      assumeRole
      (securitytoken/assume-role-request
       (clojure.core/nth args11134 0)))))))
 (do
  (clojure.core/defmethod
   sts
   :assume-role-with-saml
   [m11136]
   (clojure.core/let
    [credentials11137 (:credentials m11136) args11138 (:args m11136)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client11139
      (com.palletops.awaze.common/aws-client :sts credentials11137)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client11139
       assumeRoleWithSAML
       (securitytoken/assume-role-with-samlrequest
        (clojure.core/nth args11138 0)))))))
  (clojure.core/defn
   assume-role-with-saml-map
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         custom-request-headers
                         sdk-client-execution-timeout
                         principal-arn
                         sdk-request-timeout
                         custom-query-parameters
                         samlassertion
                         policy
                         role-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for assumeRoleWithSAML"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :assume-role-with-saml,
     :credentials credentials__1842__auto__,
     :client :sts}))
  (clojure.core/defn
   assume-role-with-saml
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         custom-request-headers
                         sdk-client-execution-timeout
                         principal-arn
                         sdk-request-timeout
                         custom-query-parameters
                         samlassertion
                         policy
                         role-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call assumeRoleWithSAML"}
   [credentials11141 & args11142]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client11143
     (com.palletops.awaze.common/aws-client :sts credentials11141)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client11143
      assumeRoleWithSAML
      (securitytoken/assume-role-with-samlrequest
       (clojure.core/nth args11142 0)))))))
 (do
  (clojure.core/defmethod
   sts
   :assume-role-with-web-identity
   [m11144]
   (clojure.core/let
    [credentials11145 (:credentials m11144) args11146 (:args m11144)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client11147
      (com.palletops.awaze.common/aws-client :sts credentials11145)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client11147
       assumeRoleWithWebIdentity
       (securitytoken/assume-role-with-web-identity-request
        (clojure.core/nth args11146 0)))))))
  (clojure.core/defn
   assume-role-with-web-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         custom-request-headers
                         sdk-client-execution-timeout
                         provider-id
                         sdk-request-timeout
                         custom-query-parameters
                         policy
                         role-arn
                         read-limit
                         general-progress-listener
                         web-identity-token
                         clone-source
                         role-session-name
                         clone-root]}]]),
    :doc "Generate map for assumeRoleWithWebIdentity"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :assume-role-with-web-identity,
     :credentials credentials__1842__auto__,
     :client :sts}))
  (clojure.core/defn
   assume-role-with-web-identity
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         custom-request-headers
                         sdk-client-execution-timeout
                         provider-id
                         sdk-request-timeout
                         custom-query-parameters
                         policy
                         role-arn
                         read-limit
                         general-progress-listener
                         web-identity-token
                         clone-source
                         role-session-name
                         clone-root]}]]),
    :doc "Call assumeRoleWithWebIdentity"}
   [credentials11149 & args11150]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client11151
     (com.palletops.awaze.common/aws-client :sts credentials11149)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client11151
      assumeRoleWithWebIdentity
      (securitytoken/assume-role-with-web-identity-request
       (clojure.core/nth args11150 0)))))))
 (do
  (clojure.core/defmethod
   sts
   :decode-authorization-message
   [m11152]
   (clojure.core/let
    [credentials11153 (:credentials m11152) args11154 (:args m11152)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client11155
      (com.palletops.awaze.common/aws-client :sts credentials11153)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client11155
       decodeAuthorizationMessage
       (securitytoken/decode-authorization-message-request
        (clojure.core/nth args11154 0)))))))
  (clojure.core/defn
   decode-authorization-message-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         encoded-message
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for decodeAuthorizationMessage"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :decode-authorization-message,
     :credentials credentials__1842__auto__,
     :client :sts}))
  (clojure.core/defn
   decode-authorization-message
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         encoded-message
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call decodeAuthorizationMessage"}
   [credentials11157 & args11158]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client11159
     (com.palletops.awaze.common/aws-client :sts credentials11157)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client11159
      decodeAuthorizationMessage
      (securitytoken/decode-authorization-message-request
       (clojure.core/nth args11158 0)))))))
 (do
  (clojure.core/defmethod
   sts
   :get-caller-identity
   [m11160]
   (clojure.core/let
    [credentials11161 (:credentials m11160) args11162 (:args m11160)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client11163
      (com.palletops.awaze.common/aws-client :sts credentials11161)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client11163
       getCallerIdentity
       (securitytoken/get-caller-identity-request
        (clojure.core/nth args11162 0)))))))
  (clojure.core/defn
   get-caller-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getCallerIdentity"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-caller-identity,
     :credentials credentials__1842__auto__,
     :client :sts}))
  (clojure.core/defn
   get-caller-identity
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getCallerIdentity"}
   [credentials11165 & args11166]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client11167
     (com.palletops.awaze.common/aws-client :sts credentials11165)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client11167
      getCallerIdentity
      (securitytoken/get-caller-identity-request
       (clojure.core/nth args11166 0)))))))
 (do
  (clojure.core/defmethod
   sts
   :get-federation-token
   [m11168]
   (clojure.core/let
    [credentials11169 (:credentials m11168) args11170 (:args m11168)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client11171
      (com.palletops.awaze.common/aws-client :sts credentials11169)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client11171
       getFederationToken
       (securitytoken/get-federation-token-request
        (clojure.core/nth args11170 0)))))))
  (clojure.core/defn
   get-federation-token-map
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         policy
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getFederationToken"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-federation-token,
     :credentials credentials__1842__auto__,
     :client :sts}))
  (clojure.core/defn
   get-federation-token
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         policy
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getFederationToken"}
   [credentials11173 & args11174]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client11175
     (com.palletops.awaze.common/aws-client :sts credentials11173)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client11175
      getFederationToken
      (securitytoken/get-federation-token-request
       (clojure.core/nth args11174 0)))))))
 (do
  (clojure.core/defmethod
   sts
   :get-session-token
   [m11176]
   (clojure.core/let
    [credentials11177 (:credentials m11176) args11178 (:args m11176)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client11179
      (com.palletops.awaze.common/aws-client :sts credentials11177)]
     (clojure.core/case
      (clojure.core/count args11178)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client11179
        getSessionToken))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client11179
        getSessionToken
        (securitytoken/get-session-token-request
         (clojure.core/nth args11178 0))))))))
  (clojure.core/defn
   get-session-token-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [duration-seconds
                         serial-number
                         custom-request-headers
                         sdk-client-execution-timeout
                         token-code
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getSessionToken, getSessionToken"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-session-token,
     :credentials credentials__1842__auto__,
     :client :sts})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-session-token,
     :credentials credentials__1842__auto__,
     :client :sts}))
  (clojure.core/defn
   get-session-token
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [duration-seconds
                         serial-number
                         custom-request-headers
                         sdk-client-execution-timeout
                         token-code
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getSessionToken, getSessionToken"}
   [credentials11181 & args11182]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client11183
     (com.palletops.awaze.common/aws-client :sts credentials11181)]
    (clojure.core/case
     (clojure.core/count args11182)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client11183
       getSessionToken))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client11183
       getSessionToken
       (securitytoken/get-session-token-request
        (clojure.core/nth args11182 0)))))))))
