(ns
 com.palletops.awaze.sqs
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.sqs :as sqs]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :sqs
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.sqs.AmazonSQSClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.MessageAttributeValue}
message-attribute-value
  [m8524]
  (clojure.core/let
   [bean8523
    (new com.amazonaws.services.sqs.model.MessageAttributeValue)]
   (clojure.core/let
    [v8525
     (:data-type m8524 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8525 :com.palletops.awaze.client-builder/undef)
     (. bean8523 setDataType (clojure.core/str v8525))))
   (clojure.core/let
    [v8525
     (:string-value m8524 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8525 :com.palletops.awaze.client-builder/undef)
     (. bean8523 setStringValue (clojure.core/str v8525))))
   (clojure.core/let
    [v8525
     (:binary-value m8524 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8525 :com.palletops.awaze.client-builder/undef)
     (. bean8523 setBinaryValue (clojure.core/identity v8525))))
   (clojure.core/let
    [v8525
     (:string-list-values
      m8524
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8525 :com.palletops.awaze.client-builder/undef)
     (.
      bean8523
      setStringListValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8586] (clojure.core/str arg8586))
 v8525))))
   (clojure.core/let
    [v8525
     (:binary-list-values
      m8524
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8525 :com.palletops.awaze.client-builder/undef)
     (.
      bean8523
      setBinaryListValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8587] (clojure.core/identity arg8587))
 v8525))))
   bean8523))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry}
change-message-visibility-batch-request-entry
  [m8527]
  (clojure.core/let
   [bean8526
    (new
     com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry)]
   (clojure.core/let
    [v8528
     (:receipt-handle m8527 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8528 :com.palletops.awaze.client-builder/undef)
     (. bean8526 setReceiptHandle (clojure.core/str v8528))))
   (clojure.core/let
    [v8528
     (:visibility-timeout
      m8527
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8528 :com.palletops.awaze.client-builder/undef)
     (. bean8526 setVisibilityTimeout (clojure.core/int v8528))))
   (clojure.core/let
    [v8528 (:id m8527 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8528 :com.palletops.awaze.client-builder/undef)
     (. bean8526 setId (clojure.core/str v8528))))
   bean8526))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.DeleteMessageBatchRequestEntry}
delete-message-batch-request-entry
  [m8530]
  (clojure.core/let
   [bean8529
    (new
     com.amazonaws.services.sqs.model.DeleteMessageBatchRequestEntry)]
   (clojure.core/let
    [v8531
     (:receipt-handle m8530 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8531 :com.palletops.awaze.client-builder/undef)
     (. bean8529 setReceiptHandle (clojure.core/str v8531))))
   (clojure.core/let
    [v8531 (:id m8530 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8531 :com.palletops.awaze.client-builder/undef)
     (. bean8529 setId (clojure.core/str v8531))))
   bean8529))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.SendMessageBatchRequestEntry}
send-message-batch-request-entry
  [m8533]
  (clojure.core/let
   [bean8532
    (new
     com.amazonaws.services.sqs.model.SendMessageBatchRequestEntry)]
   (clojure.core/let
    [v8534
     (:message-attributes
      m8533
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8534 :com.palletops.awaze.client-builder/undef)
     (.
      bean8532
      setMessageAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg8588] (clojure.core/str arg8588))
  (clojure.core/keys v8534))
 (clojure.core/map
  (clojure.core/fn [arg8588] (sqs/message-attribute-value arg8588))
  (clojure.core/vals v8534))))))
   (clojure.core/let
    [v8534
     (:delay-seconds m8533 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8534 :com.palletops.awaze.client-builder/undef)
     (. bean8532 setDelaySeconds (clojure.core/int v8534))))
   (clojure.core/let
    [v8534
     (:message-body m8533 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8534 :com.palletops.awaze.client-builder/undef)
     (. bean8532 setMessageBody (clojure.core/str v8534))))
   (clojure.core/let
    [v8534 (:id m8533 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8534 :com.palletops.awaze.client-builder/undef)
     (. bean8532 setId (clojure.core/str v8534))))
   bean8532))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.GetQueueUrlRequest}
get-queue-url-request
  [m8536]
  (clojure.core/let
   [bean8535
    (new com.amazonaws.services.sqs.model.GetQueueUrlRequest)]
   (clojure.core/let
    [v8537
     (:queue-owner-awsaccount-id
      m8536
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8537 :com.palletops.awaze.client-builder/undef)
     (. bean8535 setQueueOwnerAWSAccountId (clojure.core/str v8537))))
   (clojure.core/let
    [v8537
     (:queue-name m8536 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8537 :com.palletops.awaze.client-builder/undef)
     (. bean8535 setQueueName (clojure.core/str v8537))))
   bean8535))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.CreateQueueRequest}
create-queue-request
  [m8539]
  (clojure.core/let
   [bean8538
    (new com.amazonaws.services.sqs.model.CreateQueueRequest)]
   (clojure.core/let
    [v8540
     (:queue-name m8539 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8540 :com.palletops.awaze.client-builder/undef)
     (. bean8538 setQueueName (clojure.core/str v8540))))
   (clojure.core/let
    [v8540
     (:attributes m8539 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8540 :com.palletops.awaze.client-builder/undef)
     (.
      bean8538
      setAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg8589] (clojure.core/str arg8589))
  (clojure.core/keys v8540))
 (clojure.core/map
  (clojure.core/fn [arg8589] (clojure.core/str arg8589))
  (clojure.core/vals v8540))))))
   bean8538))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.ListDeadLetterSourceQueuesRequest}
list-dead-letter-source-queues-request
  [m8542]
  (clojure.core/let
   [bean8541
    (new
     com.amazonaws.services.sqs.model.ListDeadLetterSourceQueuesRequest)]
   (clojure.core/let
    [v8543
     (:queue-url m8542 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8543 :com.palletops.awaze.client-builder/undef)
     (. bean8541 setQueueUrl (clojure.core/str v8543))))
   bean8541))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.RemovePermissionRequest}
remove-permission-request
  [m8545]
  (clojure.core/let
   [bean8544
    (new com.amazonaws.services.sqs.model.RemovePermissionRequest)]
   (clojure.core/let
    [v8546
     (:queue-url m8545 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8546 :com.palletops.awaze.client-builder/undef)
     (. bean8544 setQueueUrl (clojure.core/str v8546))))
   (clojure.core/let
    [v8546 (:label m8545 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8546 :com.palletops.awaze.client-builder/undef)
     (. bean8544 setLabel (clojure.core/str v8546))))
   bean8544))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.SetQueueAttributesRequest}
set-queue-attributes-request
  [m8548]
  (clojure.core/let
   [bean8547
    (new com.amazonaws.services.sqs.model.SetQueueAttributesRequest)]
   (clojure.core/let
    [v8549
     (:queue-url m8548 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8549 :com.palletops.awaze.client-builder/undef)
     (. bean8547 setQueueUrl (clojure.core/str v8549))))
   (clojure.core/let
    [v8549
     (:attributes m8548 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8549 :com.palletops.awaze.client-builder/undef)
     (.
      bean8547
      setAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg8590] (clojure.core/str arg8590))
  (clojure.core/keys v8549))
 (clojure.core/map
  (clojure.core/fn [arg8590] (clojure.core/str arg8590))
  (clojure.core/vals v8549))))))
   bean8547))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.ReceiveMessageRequest}
receive-message-request
  [m8551]
  (clojure.core/let
   [bean8550
    (new com.amazonaws.services.sqs.model.ReceiveMessageRequest)]
   (clojure.core/let
    [v8552
     (:queue-url m8551 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8552 :com.palletops.awaze.client-builder/undef)
     (. bean8550 setQueueUrl (clojure.core/str v8552))))
   (clojure.core/let
    [v8552
     (:message-attribute-names
      m8551
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8552 :com.palletops.awaze.client-builder/undef)
     (.
      bean8550
      setMessageAttributeNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8591] (clojure.core/str arg8591))
 v8552))))
   (clojure.core/let
    [v8552
     (:max-number-of-messages
      m8551
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8552 :com.palletops.awaze.client-builder/undef)
     (. bean8550 setMaxNumberOfMessages (clojure.core/int v8552))))
   (clojure.core/let
    [v8552
     (:wait-time-seconds
      m8551
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8552 :com.palletops.awaze.client-builder/undef)
     (. bean8550 setWaitTimeSeconds (clojure.core/int v8552))))
   (clojure.core/let
    [v8552
     (:visibility-timeout
      m8551
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8552 :com.palletops.awaze.client-builder/undef)
     (. bean8550 setVisibilityTimeout (clojure.core/int v8552))))
   (clojure.core/let
    [v8552
     (:attribute-names
      m8551
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8552 :com.palletops.awaze.client-builder/undef)
     (.
      bean8550
      setAttributeNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8592] (clojure.core/str arg8592))
 v8552))))
   bean8550))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.DeleteMessageRequest}
delete-message-request
  [m8554]
  (clojure.core/let
   [bean8553
    (new com.amazonaws.services.sqs.model.DeleteMessageRequest)]
   (clojure.core/let
    [v8555
     (:queue-url m8554 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8555 :com.palletops.awaze.client-builder/undef)
     (. bean8553 setQueueUrl (clojure.core/str v8555))))
   (clojure.core/let
    [v8555
     (:receipt-handle m8554 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8555 :com.palletops.awaze.client-builder/undef)
     (. bean8553 setReceiptHandle (clojure.core/str v8555))))
   bean8553))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.SendMessageRequest}
send-message-request
  [m8557]
  (clojure.core/let
   [bean8556
    (new com.amazonaws.services.sqs.model.SendMessageRequest)]
   (clojure.core/let
    [v8558
     (:message-attributes
      m8557
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8558 :com.palletops.awaze.client-builder/undef)
     (.
      bean8556
      setMessageAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg8593] (clojure.core/str arg8593))
  (clojure.core/keys v8558))
 (clojure.core/map
  (clojure.core/fn [arg8593] (sqs/message-attribute-value arg8593))
  (clojure.core/vals v8558))))))
   (clojure.core/let
    [v8558
     (:queue-url m8557 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8558 :com.palletops.awaze.client-builder/undef)
     (. bean8556 setQueueUrl (clojure.core/str v8558))))
   (clojure.core/let
    [v8558
     (:delay-seconds m8557 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8558 :com.palletops.awaze.client-builder/undef)
     (. bean8556 setDelaySeconds (clojure.core/int v8558))))
   (clojure.core/let
    [v8558
     (:message-body m8557 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8558 :com.palletops.awaze.client-builder/undef)
     (. bean8556 setMessageBody (clojure.core/str v8558))))
   bean8556))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequest}
change-message-visibility-batch-request
  [m8560]
  (clojure.core/let
   [bean8559
    (new
     com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequest)]
   (clojure.core/let
    [v8561
     (:queue-url m8560 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8561 :com.palletops.awaze.client-builder/undef)
     (. bean8559 setQueueUrl (clojure.core/str v8561))))
   (clojure.core/let
    [v8561 (:entries m8560 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8561 :com.palletops.awaze.client-builder/undef)
     (.
      bean8559
      setEntries
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg8594]
  (sqs/change-message-visibility-batch-request-entry arg8594))
 v8561))))
   bean8559))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.ChangeMessageVisibilityRequest}
change-message-visibility-request
  [m8563]
  (clojure.core/let
   [bean8562
    (new
     com.amazonaws.services.sqs.model.ChangeMessageVisibilityRequest)]
   (clojure.core/let
    [v8564
     (:queue-url m8563 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8564 :com.palletops.awaze.client-builder/undef)
     (. bean8562 setQueueUrl (clojure.core/str v8564))))
   (clojure.core/let
    [v8564
     (:receipt-handle m8563 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8564 :com.palletops.awaze.client-builder/undef)
     (. bean8562 setReceiptHandle (clojure.core/str v8564))))
   (clojure.core/let
    [v8564
     (:visibility-timeout
      m8563
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8564 :com.palletops.awaze.client-builder/undef)
     (. bean8562 setVisibilityTimeout (clojure.core/int v8564))))
   bean8562))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.ListQueuesRequest}
list-queues-request
  [m8566]
  (clojure.core/let
   [bean8565 (new com.amazonaws.services.sqs.model.ListQueuesRequest)]
   (clojure.core/let
    [v8567
     (:queue-name-prefix
      m8566
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8567 :com.palletops.awaze.client-builder/undef)
     (. bean8565 setQueueNamePrefix (clojure.core/str v8567))))
   bean8565))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.DeleteMessageBatchRequest}
delete-message-batch-request
  [m8569]
  (clojure.core/let
   [bean8568
    (new com.amazonaws.services.sqs.model.DeleteMessageBatchRequest)]
   (clojure.core/let
    [v8570
     (:queue-url m8569 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8570 :com.palletops.awaze.client-builder/undef)
     (. bean8568 setQueueUrl (clojure.core/str v8570))))
   (clojure.core/let
    [v8570 (:entries m8569 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8570 :com.palletops.awaze.client-builder/undef)
     (.
      bean8568
      setEntries
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg8667]
  (sqs/delete-message-batch-request-entry arg8667))
 v8570))))
   bean8568))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.DeleteQueueRequest}
delete-queue-request
  [m8572]
  (clojure.core/let
   [bean8571
    (new com.amazonaws.services.sqs.model.DeleteQueueRequest)]
   (clojure.core/let
    [v8573
     (:queue-url m8572 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8573 :com.palletops.awaze.client-builder/undef)
     (. bean8571 setQueueUrl (clojure.core/str v8573))))
   bean8571))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.AddPermissionRequest}
add-permission-request
  [m8575]
  (clojure.core/let
   [bean8574
    (new com.amazonaws.services.sqs.model.AddPermissionRequest)]
   (clojure.core/let
    [v8576
     (:queue-url m8575 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8576 :com.palletops.awaze.client-builder/undef)
     (. bean8574 setQueueUrl (clojure.core/str v8576))))
   (clojure.core/let
    [v8576 (:label m8575 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8576 :com.palletops.awaze.client-builder/undef)
     (. bean8574 setLabel (clojure.core/str v8576))))
   (clojure.core/let
    [v8576
     (:awsaccount-ids m8575 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8576 :com.palletops.awaze.client-builder/undef)
     (.
      bean8574
      setAWSAccountIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8668] (clojure.core/str arg8668))
 v8576))))
   (clojure.core/let
    [v8576 (:actions m8575 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8576 :com.palletops.awaze.client-builder/undef)
     (.
      bean8574
      setActions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8669] (clojure.core/str arg8669))
 v8576))))
   bean8574))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.PurgeQueueRequest}
purge-queue-request
  [m8578]
  (clojure.core/let
   [bean8577 (new com.amazonaws.services.sqs.model.PurgeQueueRequest)]
   (clojure.core/let
    [v8579
     (:queue-url m8578 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8579 :com.palletops.awaze.client-builder/undef)
     (. bean8577 setQueueUrl (clojure.core/str v8579))))
   bean8577))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.GetQueueAttributesRequest}
get-queue-attributes-request
  [m8581]
  (clojure.core/let
   [bean8580
    (new com.amazonaws.services.sqs.model.GetQueueAttributesRequest)]
   (clojure.core/let
    [v8582
     (:queue-url m8581 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8582 :com.palletops.awaze.client-builder/undef)
     (. bean8580 setQueueUrl (clojure.core/str v8582))))
   (clojure.core/let
    [v8582
     (:attribute-names
      m8581
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8582 :com.palletops.awaze.client-builder/undef)
     (.
      bean8580
      setAttributeNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8670] (clojure.core/str arg8670))
 v8582))))
   bean8580))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.SendMessageBatchRequest}
send-message-batch-request
  [m8584]
  (clojure.core/let
   [bean8583
    (new com.amazonaws.services.sqs.model.SendMessageBatchRequest)]
   (clojure.core/let
    [v8585
     (:queue-url m8584 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8585 :com.palletops.awaze.client-builder/undef)
     (. bean8583 setQueueUrl (clojure.core/str v8585))))
   (clojure.core/let
    [v8585 (:entries m8584 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8585 :com.palletops.awaze.client-builder/undef)
     (.
      bean8583
      setEntries
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg8671]
  (sqs/send-message-batch-request-entry arg8671))
 v8585))))
   bean8583))
 (clojure.core/defmulti
  sqs
  (clojure.core/fn sqs [m__1874__auto__] (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   sqs
   :get-queue-url
   [m8595]
   (clojure.core/let
    [credentials8596 (:credentials m8595) args8597 (:args m8595)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8598
      (com.palletops.awaze.common/aws-client :sqs credentials8596)]
     (clojure.core/case
      (clojure.core/count args8597)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.sqs.model.GetQueueUrlRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.sqs.model.GetQueueUrlRequest
           (clojure.core/nth args8597 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8598
           getQueueUrl
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args8597 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8598
               getQueueUrl
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getQueueUrl")
                {:args args8597}))))))))))))))
  (clojure.core/defn
   get-queue-url-map
   {:arglists (quote
               [[credentials
                 {:keys [queue-owner-awsaccount-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         queue-name
                         clone-root]}]
                [credentials string-0]]),
    :doc "Generate map for getQueueUrl, getQueueUrl"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-queue-url,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   get-queue-url
   {:arglists (quote
               [[credentials
                 {:keys [queue-owner-awsaccount-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         queue-name
                         clone-root]}]
                [credentials string-0]]),
    :doc "Call getQueueUrl, getQueueUrl"}
   [credentials8600 & args8601]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8602
     (com.palletops.awaze.common/aws-client :sqs credentials8600)]
    (clojure.core/case
     (clojure.core/count args8601)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.sqs.model.GetQueueUrlRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.sqs.model.GetQueueUrlRequest
          (clojure.core/nth args8601 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8602
          getQueueUrl
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args8601 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8602
              getQueueUrl
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getQueueUrl")
               {:args args8601}))))))))))))))
 (do
  (clojure.core/defmethod
   sqs
   :create-queue
   [m8603]
   (clojure.core/let
    [credentials8604 (:credentials m8603) args8605 (:args m8603)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8606
      (com.palletops.awaze.common/aws-client :sqs credentials8604)]
     (clojure.core/case
      (clojure.core/count args8605)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.sqs.model.CreateQueueRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.sqs.model.CreateQueueRequest
           (clojure.core/nth args8605 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8606
           createQueue
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args8605 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8606
               createQueue
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "createQueue")
                {:args args8605}))))))))))))))
  (clojure.core/defn
   create-queue-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         queue-name
                         attributes
                         clone-root]}]
                [credentials string-0]]),
    :doc "Generate map for createQueue, createQueue"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-queue,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   create-queue
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         queue-name
                         attributes
                         clone-root]}]
                [credentials string-0]]),
    :doc "Call createQueue, createQueue"}
   [credentials8608 & args8609]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8610
     (com.palletops.awaze.common/aws-client :sqs credentials8608)]
    (clojure.core/case
     (clojure.core/count args8609)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.sqs.model.CreateQueueRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.sqs.model.CreateQueueRequest
          (clojure.core/nth args8609 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8610
          createQueue
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args8609 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8610
              createQueue
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "createQueue")
               {:args args8609}))))))))))))))
 (do
  (clojure.core/defmethod
   sqs
   :list-dead-letter-source-queues
   [m8611]
   (clojure.core/let
    [credentials8612 (:credentials m8611) args8613 (:args m8611)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8614
      (com.palletops.awaze.common/aws-client :sqs credentials8612)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8614
       listDeadLetterSourceQueues
       (sqs/list-dead-letter-source-queues-request
        (clojure.core/nth args8613 0)))))))
  (clojure.core/defn
   list-dead-letter-source-queues-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Generate map for listDeadLetterSourceQueues"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-dead-letter-source-queues,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   list-dead-letter-source-queues
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Call listDeadLetterSourceQueues"}
   [credentials8616 & args8617]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8618
     (com.palletops.awaze.common/aws-client :sqs credentials8616)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8618
      listDeadLetterSourceQueues
      (sqs/list-dead-letter-source-queues-request
       (clojure.core/nth args8617 0)))))))
 (do
  (clojure.core/defmethod
   sqs
   :remove-permission
   [m8619]
   (clojure.core/let
    [credentials8620 (:credentials m8619) args8621 (:args m8619)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8622
      (com.palletops.awaze.common/aws-client :sqs credentials8620)]
     (clojure.core/case
      (clojure.core/count args8621)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8622
        removePermission
        (clojure.core/str (clojure.core/nth args8621 0))
        (clojure.core/str (clojure.core/nth args8621 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8622
        removePermission
        (sqs/remove-permission-request (clojure.core/nth args8621 0))))))))
  (clojure.core/defn
   remove-permission-map
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         label
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Generate map for removePermission, removePermission"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :remove-permission,
     :credentials credentials__1842__auto__,
     :client :sqs})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :remove-permission,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   remove-permission
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         label
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Call removePermission, removePermission"}
   [credentials8624 & args8625]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8626
     (com.palletops.awaze.common/aws-client :sqs credentials8624)]
    (clojure.core/case
     (clojure.core/count args8625)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8626
       removePermission
       (clojure.core/str (clojure.core/nth args8625 0))
       (clojure.core/str (clojure.core/nth args8625 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8626
       removePermission
       (sqs/remove-permission-request (clojure.core/nth args8625 0))))))))
 (do
  (clojure.core/defmethod
   sqs
   :set-queue-attributes
   [m8627]
   (clojure.core/let
    [credentials8628 (:credentials m8627) args8629 (:args m8627)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8630
      (com.palletops.awaze.common/aws-client :sqs credentials8628)]
     (clojure.core/case
      (clojure.core/count args8629)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8630
        setQueueAttributes
        (clojure.core/str (clojure.core/nth args8629 0))
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg8672] (clojure.core/str arg8672))
  (clojure.core/keys (clojure.core/nth args8629 1)))
 (clojure.core/map
  (clojure.core/fn [arg8672] (clojure.core/str arg8672))
  (clojure.core/vals (clojure.core/nth args8629 1))))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8630
        setQueueAttributes
        (sqs/set-queue-attributes-request
         (clojure.core/nth args8629 0))))))))
  (clojure.core/defn
   set-queue-attributes-map
   {:arglists (quote
               [[credentials string-0 map-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         attributes
                         clone-root
                         queue-url]}]]),
    :doc "Generate map for setQueueAttributes, setQueueAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-queue-attributes,
     :credentials credentials__1842__auto__,
     :client :sqs})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :set-queue-attributes,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   set-queue-attributes
   {:arglists (quote
               [[credentials string-0 map-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         attributes
                         clone-root
                         queue-url]}]]),
    :doc "Call setQueueAttributes, setQueueAttributes"}
   [credentials8632 & args8633]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8634
     (com.palletops.awaze.common/aws-client :sqs credentials8632)]
    (clojure.core/case
     (clojure.core/count args8633)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8634
       setQueueAttributes
       (clojure.core/str (clojure.core/nth args8633 0))
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg8673] (clojure.core/str arg8673))
  (clojure.core/keys (clojure.core/nth args8633 1)))
 (clojure.core/map
  (clojure.core/fn [arg8673] (clojure.core/str arg8673))
  (clojure.core/vals (clojure.core/nth args8633 1))))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8634
       setQueueAttributes
       (sqs/set-queue-attributes-request
        (clojure.core/nth args8633 0))))))))
 (do
  (clojure.core/defmethod
   sqs
   :receive-message
   [m8635]
   (clojure.core/let
    [credentials8636 (:credentials m8635) args8637 (:args m8635)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8638
      (com.palletops.awaze.common/aws-client :sqs credentials8636)]
     (clojure.core/case
      (clojure.core/count args8637)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args8637 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8638
           receiveMessage
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.sqs.model.ReceiveMessageRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.sqs.model.ReceiveMessageRequest
               (clojure.core/nth args8637 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8638
               receiveMessage
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "receiveMessage")
                {:args args8637}))))))))))))))
  (clojure.core/defn
   receive-message-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         attribute-names
                         sdk-client-execution-timeout
                         max-number-of-messages
                         sdk-request-timeout
                         message-attribute-names
                         wait-time-seconds
                         custom-query-parameters
                         visibility-timeout
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Generate map for receiveMessage, receiveMessage"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :receive-message,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   receive-message
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         attribute-names
                         sdk-client-execution-timeout
                         max-number-of-messages
                         sdk-request-timeout
                         message-attribute-names
                         wait-time-seconds
                         custom-query-parameters
                         visibility-timeout
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Call receiveMessage, receiveMessage"}
   [credentials8640 & args8641]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8642
     (com.palletops.awaze.common/aws-client :sqs credentials8640)]
    (clojure.core/case
     (clojure.core/count args8641)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args8641 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8642
          receiveMessage
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.sqs.model.ReceiveMessageRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.sqs.model.ReceiveMessageRequest
              (clojure.core/nth args8641 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8642
              receiveMessage
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "receiveMessage")
               {:args args8641}))))))))))))))
 (do
  (clojure.core/defmethod
   sqs
   :delete-message
   [m8643]
   (clojure.core/let
    [credentials8644 (:credentials m8643) args8645 (:args m8643)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8646
      (com.palletops.awaze.common/aws-client :sqs credentials8644)]
     (clojure.core/case
      (clojure.core/count args8645)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8646
        deleteMessage
        (clojure.core/str (clojure.core/nth args8645 0))
        (clojure.core/str (clojure.core/nth args8645 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8646
        deleteMessage
        (sqs/delete-message-request (clojure.core/nth args8645 0))))))))
  (clojure.core/defn
   delete-message-map
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         receipt-handle
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Generate map for deleteMessage, deleteMessage"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-message,
     :credentials credentials__1842__auto__,
     :client :sqs})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :delete-message,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   delete-message
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         receipt-handle
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Call deleteMessage, deleteMessage"}
   [credentials8648 & args8649]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8650
     (com.palletops.awaze.common/aws-client :sqs credentials8648)]
    (clojure.core/case
     (clojure.core/count args8649)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8650
       deleteMessage
       (clojure.core/str (clojure.core/nth args8649 0))
       (clojure.core/str (clojure.core/nth args8649 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8650
       deleteMessage
       (sqs/delete-message-request (clojure.core/nth args8649 0))))))))
 (do
  (clojure.core/defmethod
   sqs
   :send-message
   [m8651]
   (clojure.core/let
    [credentials8652 (:credentials m8651) args8653 (:args m8651)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8654
      (com.palletops.awaze.common/aws-client :sqs credentials8652)]
     (clojure.core/case
      (clojure.core/count args8653)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8654
        sendMessage
        (clojure.core/str (clojure.core/nth args8653 0))
        (clojure.core/str (clojure.core/nth args8653 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8654
        sendMessage
        (sqs/send-message-request (clojure.core/nth args8653 0))))))))
  (clojure.core/defn
   send-message-map
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         delay-seconds
                         sdk-request-timeout
                         message-attributes
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         message-body
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Generate map for sendMessage, sendMessage"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :send-message,
     :credentials credentials__1842__auto__,
     :client :sqs})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :send-message,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   send-message
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         delay-seconds
                         sdk-request-timeout
                         message-attributes
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         message-body
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Call sendMessage, sendMessage"}
   [credentials8656 & args8657]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8658
     (com.palletops.awaze.common/aws-client :sqs credentials8656)]
    (clojure.core/case
     (clojure.core/count args8657)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8658
       sendMessage
       (clojure.core/str (clojure.core/nth args8657 0))
       (clojure.core/str (clojure.core/nth args8657 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8658
       sendMessage
       (sqs/send-message-request (clojure.core/nth args8657 0))))))))
 (do
  (clojure.core/defmethod
   sqs
   :change-message-visibility-batch
   [m8659]
   (clojure.core/let
    [credentials8660 (:credentials m8659) args8661 (:args m8659)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8662
      (com.palletops.awaze.common/aws-client :sqs credentials8660)]
     (clojure.core/case
      (clojure.core/count args8661)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8662
        changeMessageVisibilityBatch
        (clojure.core/str (clojure.core/nth args8661 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg8738]
  (sqs/change-message-visibility-batch-request-entry arg8738))
 (clojure.core/nth args8661 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8662
        changeMessageVisibilityBatch
        (sqs/change-message-visibility-batch-request
         (clojure.core/nth args8661 0))))))))
  (clojure.core/defn
   change-message-visibility-batch-map
   {:arglists (quote
               [[credentials string-0 list-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         entries
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Generate map for changeMessageVisibilityBatch, changeMessageVisibilityBatch"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :change-message-visibility-batch,
     :credentials credentials__1842__auto__,
     :client :sqs})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :change-message-visibility-batch,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   change-message-visibility-batch
   {:arglists (quote
               [[credentials string-0 list-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         entries
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Call changeMessageVisibilityBatch, changeMessageVisibilityBatch"}
   [credentials8664 & args8665]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8666
     (com.palletops.awaze.common/aws-client :sqs credentials8664)]
    (clojure.core/case
     (clojure.core/count args8665)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8666
       changeMessageVisibilityBatch
       (clojure.core/str (clojure.core/nth args8665 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg8739]
  (sqs/change-message-visibility-batch-request-entry arg8739))
 (clojure.core/nth args8665 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8666
       changeMessageVisibilityBatch
       (sqs/change-message-visibility-batch-request
        (clojure.core/nth args8665 0))))))))
 (do
  (clojure.core/defmethod
   sqs
   :change-message-visibility
   [m8674]
   (clojure.core/let
    [credentials8675 (:credentials m8674) args8676 (:args m8674)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8677
      (com.palletops.awaze.common/aws-client :sqs credentials8675)]
     (clojure.core/case
      (clojure.core/count args8676)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8677
        changeMessageVisibility
        (sqs/change-message-visibility-request
         (clojure.core/nth args8676 0))))
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8677
        changeMessageVisibility
        (clojure.core/str (clojure.core/nth args8676 0))
        (clojure.core/str (clojure.core/nth args8676 1))
        (clojure.core/int (clojure.core/nth args8676 2))))))))
  (clojure.core/defn
   change-message-visibility-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         receipt-handle
                         sdk-request-timeout
                         custom-query-parameters
                         visibility-timeout
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]
                [credentials string-0 string-1 integer-2]]),
    :doc "Generate map for changeMessageVisibility, changeMessageVisibility"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :change-message-visibility,
     :credentials credentials__1842__auto__,
     :client :sqs})
   ([credentials__1842__auto__ a b c]
    {:args [a b c],
     :fn :change-message-visibility,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   change-message-visibility
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         receipt-handle
                         sdk-request-timeout
                         custom-query-parameters
                         visibility-timeout
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]
                [credentials string-0 string-1 integer-2]]),
    :doc "Call changeMessageVisibility, changeMessageVisibility"}
   [credentials8679 & args8680]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8681
     (com.palletops.awaze.common/aws-client :sqs credentials8679)]
    (clojure.core/case
     (clojure.core/count args8680)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8681
       changeMessageVisibility
       (sqs/change-message-visibility-request
        (clojure.core/nth args8680 0))))
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8681
       changeMessageVisibility
       (clojure.core/str (clojure.core/nth args8680 0))
       (clojure.core/str (clojure.core/nth args8680 1))
       (clojure.core/int (clojure.core/nth args8680 2))))))))
 (do
  (clojure.core/defmethod
   sqs
   :list-queues
   [m8682]
   (clojure.core/let
    [credentials8683 (:credentials m8682) args8684 (:args m8682)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8685
      (com.palletops.awaze.common/aws-client :sqs credentials8683)]
     (clojure.core/case
      (clojure.core/count args8684)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.sqs.model.ListQueuesRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.sqs.model.ListQueuesRequest
           (clojure.core/nth args8684 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8685
           listQueues
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args8684 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8685
               listQueues
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "listQueues")
                {:args args8684}))))))))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8685
        listQueues))))))
  (clojure.core/defn
   list-queues-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         queue-name-prefix
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials string-0]
                [credentials]]),
    :doc "Generate map for listQueues, listQueues, listQueues"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-queues,
     :credentials credentials__1842__auto__,
     :client :sqs})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-queues,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   list-queues
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         queue-name-prefix
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials string-0]
                [credentials]]),
    :doc "Call listQueues, listQueues, listQueues"}
   [credentials8687 & args8688]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8689
     (com.palletops.awaze.common/aws-client :sqs credentials8687)]
    (clojure.core/case
     (clojure.core/count args8688)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.sqs.model.ListQueuesRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.sqs.model.ListQueuesRequest
          (clojure.core/nth args8688 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8689
          listQueues
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args8688 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8689
              listQueues
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "listQueues")
               {:args args8688}))))))))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8689
       listQueues))))))
 (do
  (clojure.core/defmethod
   sqs
   :delete-message-batch
   [m8690]
   (clojure.core/let
    [credentials8691 (:credentials m8690) args8692 (:args m8690)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8693
      (com.palletops.awaze.common/aws-client :sqs credentials8691)]
     (clojure.core/case
      (clojure.core/count args8692)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8693
        deleteMessageBatch
        (clojure.core/str (clojure.core/nth args8692 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg8740]
  (sqs/delete-message-batch-request-entry arg8740))
 (clojure.core/nth args8692 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8693
        deleteMessageBatch
        (sqs/delete-message-batch-request
         (clojure.core/nth args8692 0))))))))
  (clojure.core/defn
   delete-message-batch-map
   {:arglists (quote
               [[credentials string-0 list-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         entries
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Generate map for deleteMessageBatch, deleteMessageBatch"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-message-batch,
     :credentials credentials__1842__auto__,
     :client :sqs})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :delete-message-batch,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   delete-message-batch
   {:arglists (quote
               [[credentials string-0 list-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         entries
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Call deleteMessageBatch, deleteMessageBatch"}
   [credentials8695 & args8696]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8697
     (com.palletops.awaze.common/aws-client :sqs credentials8695)]
    (clojure.core/case
     (clojure.core/count args8696)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8697
       deleteMessageBatch
       (clojure.core/str (clojure.core/nth args8696 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg8741]
  (sqs/delete-message-batch-request-entry arg8741))
 (clojure.core/nth args8696 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8697
       deleteMessageBatch
       (sqs/delete-message-batch-request
        (clojure.core/nth args8696 0))))))))
 (do
  (clojure.core/defmethod
   sqs
   :delete-queue
   [m8698]
   (clojure.core/let
    [credentials8699 (:credentials m8698) args8700 (:args m8698)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8701
      (com.palletops.awaze.common/aws-client :sqs credentials8699)]
     (clojure.core/case
      (clojure.core/count args8700)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.sqs.model.DeleteQueueRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.sqs.model.DeleteQueueRequest
           (clojure.core/nth args8700 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8701
           deleteQueue
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args8700 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8701
               deleteQueue
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteQueue")
                {:args args8700}))))))))))))))
  (clojure.core/defn
   delete-queue-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]
                [credentials string-0]]),
    :doc "Generate map for deleteQueue, deleteQueue"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-queue,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   delete-queue
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]
                [credentials string-0]]),
    :doc "Call deleteQueue, deleteQueue"}
   [credentials8703 & args8704]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8705
     (com.palletops.awaze.common/aws-client :sqs credentials8703)]
    (clojure.core/case
     (clojure.core/count args8704)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.sqs.model.DeleteQueueRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.sqs.model.DeleteQueueRequest
          (clojure.core/nth args8704 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8705
          deleteQueue
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args8704 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8705
              deleteQueue
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteQueue")
               {:args args8704}))))))))))))))
 (do
  (clojure.core/defmethod
   sqs
   :add-permission
   [m8706]
   (clojure.core/let
    [credentials8707 (:credentials m8706) args8708 (:args m8706)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8709
      (com.palletops.awaze.common/aws-client :sqs credentials8707)]
     (clojure.core/case
      (clojure.core/count args8708)
      4
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8709
        addPermission
        (clojure.core/str (clojure.core/nth args8708 0))
        (clojure.core/str (clojure.core/nth args8708 1))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg8742] (clojure.core/str arg8742))
 (clojure.core/nth args8708 2))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg8743] (clojure.core/str arg8743))
 (clojure.core/nth args8708 3))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8709
        addPermission
        (sqs/add-permission-request (clojure.core/nth args8708 0))))))))
  (clojure.core/defn
   add-permission-map
   {:arglists (quote
               [[credentials string-0 string-1 list-2 list-3]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         awsaccount-ids
                         sdk-request-timeout
                         custom-query-parameters
                         actions
                         read-limit
                         label
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Generate map for addPermission, addPermission"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :add-permission,
     :credentials credentials__1842__auto__,
     :client :sqs})
   ([credentials__1842__auto__ a b c d]
    {:args [a b c d],
     :fn :add-permission,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   add-permission
   {:arglists (quote
               [[credentials string-0 string-1 list-2 list-3]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         awsaccount-ids
                         sdk-request-timeout
                         custom-query-parameters
                         actions
                         read-limit
                         label
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Call addPermission, addPermission"}
   [credentials8711 & args8712]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8713
     (com.palletops.awaze.common/aws-client :sqs credentials8711)]
    (clojure.core/case
     (clojure.core/count args8712)
     4
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8713
       addPermission
       (clojure.core/str (clojure.core/nth args8712 0))
       (clojure.core/str (clojure.core/nth args8712 1))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg8744] (clojure.core/str arg8744))
 (clojure.core/nth args8712 2))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg8745] (clojure.core/str arg8745))
 (clojure.core/nth args8712 3))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8713
       addPermission
       (sqs/add-permission-request (clojure.core/nth args8712 0))))))))
 (do
  (clojure.core/defmethod
   sqs
   :purge-queue
   [m8714]
   (clojure.core/let
    [credentials8715 (:credentials m8714) args8716 (:args m8714)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8717
      (com.palletops.awaze.common/aws-client :sqs credentials8715)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8717
       purgeQueue
       (sqs/purge-queue-request (clojure.core/nth args8716 0)))))))
  (clojure.core/defn
   purge-queue-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Generate map for purgeQueue"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :purge-queue,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   purge-queue
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Call purgeQueue"}
   [credentials8719 & args8720]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8721
     (com.palletops.awaze.common/aws-client :sqs credentials8719)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8721
      purgeQueue
      (sqs/purge-queue-request (clojure.core/nth args8720 0)))))))
 (do
  (clojure.core/defmethod
   sqs
   :get-queue-attributes
   [m8722]
   (clojure.core/let
    [credentials8723 (:credentials m8722) args8724 (:args m8722)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8725
      (com.palletops.awaze.common/aws-client :sqs credentials8723)]
     (clojure.core/case
      (clojure.core/count args8724)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8725
        getQueueAttributes
        (sqs/get-queue-attributes-request
         (clojure.core/nth args8724 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8725
        getQueueAttributes
        (clojure.core/str (clojure.core/nth args8724 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg8746] (clojure.core/str arg8746))
 (clojure.core/nth args8724 1))))))))
  (clojure.core/defn
   get-queue-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         attribute-names
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]
                [credentials string-0 list-1]]),
    :doc "Generate map for getQueueAttributes, getQueueAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-queue-attributes,
     :credentials credentials__1842__auto__,
     :client :sqs})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :get-queue-attributes,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   get-queue-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         attribute-names
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]
                [credentials string-0 list-1]]),
    :doc "Call getQueueAttributes, getQueueAttributes"}
   [credentials8727 & args8728]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8729
     (com.palletops.awaze.common/aws-client :sqs credentials8727)]
    (clojure.core/case
     (clojure.core/count args8728)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8729
       getQueueAttributes
       (sqs/get-queue-attributes-request
        (clojure.core/nth args8728 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8729
       getQueueAttributes
       (clojure.core/str (clojure.core/nth args8728 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg8747] (clojure.core/str arg8747))
 (clojure.core/nth args8728 1))))))))
 (do
  (clojure.core/defmethod
   sqs
   :send-message-batch
   [m8730]
   (clojure.core/let
    [credentials8731 (:credentials m8730) args8732 (:args m8730)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8733
      (com.palletops.awaze.common/aws-client :sqs credentials8731)]
     (clojure.core/case
      (clojure.core/count args8732)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8733
        sendMessageBatch
        (sqs/send-message-batch-request (clojure.core/nth args8732 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8733
        sendMessageBatch
        (clojure.core/str (clojure.core/nth args8732 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg8748]
  (sqs/send-message-batch-request-entry arg8748))
 (clojure.core/nth args8732 1))))))))
  (clojure.core/defn
   send-message-batch-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         entries
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]
                [credentials string-0 list-1]]),
    :doc "Generate map for sendMessageBatch, sendMessageBatch"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :send-message-batch,
     :credentials credentials__1842__auto__,
     :client :sqs})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :send-message-batch,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   send-message-batch
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         entries
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]
                [credentials string-0 list-1]]),
    :doc "Call sendMessageBatch, sendMessageBatch"}
   [credentials8735 & args8736]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8737
     (com.palletops.awaze.common/aws-client :sqs credentials8735)]
    (clojure.core/case
     (clojure.core/count args8736)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8737
       sendMessageBatch
       (sqs/send-message-batch-request (clojure.core/nth args8736 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8737
       sendMessageBatch
       (clojure.core/str (clojure.core/nth args8736 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg8749]
  (sqs/send-message-batch-request-entry arg8749))
 (clojure.core/nth args8736 1)))))))))
