(ns
 com.palletops.awaze.sns
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.sns :as sns]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :sns
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.sns.AmazonSNSClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.MessageAttributeValue}
message-attribute-value
  [m6129]
  (clojure.core/let
   [bean6128
    (new com.amazonaws.services.sns.model.MessageAttributeValue)]
   (clojure.core/let
    [v6130
     (:data-type m6129 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6130 :com.palletops.awaze.client-builder/undef)
     (. bean6128 setDataType (clojure.core/str v6130))))
   (clojure.core/let
    [v6130
     (:string-value m6129 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6130 :com.palletops.awaze.client-builder/undef)
     (. bean6128 setStringValue (clojure.core/str v6130))))
   (clojure.core/let
    [v6130
     (:binary-value m6129 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6130 :com.palletops.awaze.client-builder/undef)
     (. bean6128 setBinaryValue (clojure.core/identity v6130))))
   bean6128))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.ListTopicsRequest}
list-topics-request
  [m6132]
  (clojure.core/let
   [bean6131 (new com.amazonaws.services.sns.model.ListTopicsRequest)]
   (clojure.core/let
    [v6133
     (:next-token m6132 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6133 :com.palletops.awaze.client-builder/undef)
     (. bean6131 setNextToken (clojure.core/str v6133))))
   bean6131))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.SetTopicAttributesRequest}
set-topic-attributes-request
  [m6135]
  (clojure.core/let
   [bean6134
    (new com.amazonaws.services.sns.model.SetTopicAttributesRequest)]
   (clojure.core/let
    [v6136
     (:attribute-name m6135 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6136 :com.palletops.awaze.client-builder/undef)
     (. bean6134 setAttributeName (clojure.core/str v6136))))
   (clojure.core/let
    [v6136
     (:attribute-value
      m6135
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6136 :com.palletops.awaze.client-builder/undef)
     (. bean6134 setAttributeValue (clojure.core/str v6136))))
   (clojure.core/let
    [v6136
     (:topic-arn m6135 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6136 :com.palletops.awaze.client-builder/undef)
     (. bean6134 setTopicArn (clojure.core/str v6136))))
   bean6134))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.RemovePermissionRequest}
remove-permission-request
  [m6138]
  (clojure.core/let
   [bean6137
    (new com.amazonaws.services.sns.model.RemovePermissionRequest)]
   (clojure.core/let
    [v6139 (:label m6138 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6139 :com.palletops.awaze.client-builder/undef)
     (. bean6137 setLabel (clojure.core/str v6139))))
   (clojure.core/let
    [v6139
     (:topic-arn m6138 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6139 :com.palletops.awaze.client-builder/undef)
     (. bean6137 setTopicArn (clojure.core/str v6139))))
   bean6137))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.UnsubscribeRequest}
unsubscribe-request
  [m6141]
  (clojure.core/let
   [bean6140
    (new com.amazonaws.services.sns.model.UnsubscribeRequest)]
   (clojure.core/let
    [v6142
     (:subscription-arn
      m6141
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6142 :com.palletops.awaze.client-builder/undef)
     (. bean6140 setSubscriptionArn (clojure.core/str v6142))))
   bean6140))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.DeletePlatformApplicationRequest}
delete-platform-application-request
  [m6144]
  (clojure.core/let
   [bean6143
    (new
     com.amazonaws.services.sns.model.DeletePlatformApplicationRequest)]
   (clojure.core/let
    [v6145
     (:platform-application-arn
      m6144
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6145 :com.palletops.awaze.client-builder/undef)
     (. bean6143 setPlatformApplicationArn (clojure.core/str v6145))))
   bean6143))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.DeleteEndpointRequest}
delete-endpoint-request
  [m6147]
  (clojure.core/let
   [bean6146
    (new com.amazonaws.services.sns.model.DeleteEndpointRequest)]
   (clojure.core/let
    [v6148
     (:endpoint-arn m6147 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6148 :com.palletops.awaze.client-builder/undef)
     (. bean6146 setEndpointArn (clojure.core/str v6148))))
   bean6146))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.GetSubscriptionAttributesRequest}
get-subscription-attributes-request
  [m6150]
  (clojure.core/let
   [bean6149
    (new
     com.amazonaws.services.sns.model.GetSubscriptionAttributesRequest)]
   (clojure.core/let
    [v6151
     (:subscription-arn
      m6150
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6151 :com.palletops.awaze.client-builder/undef)
     (. bean6149 setSubscriptionArn (clojure.core/str v6151))))
   bean6149))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.CreatePlatformApplicationRequest}
create-platform-application-request
  [m6153]
  (clojure.core/let
   [bean6152
    (new
     com.amazonaws.services.sns.model.CreatePlatformApplicationRequest)]
   (clojure.core/let
    [v6154
     (:platform m6153 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6154 :com.palletops.awaze.client-builder/undef)
     (. bean6152 setPlatform (clojure.core/str v6154))))
   (clojure.core/let
    [v6154
     (:attributes m6153 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6154 :com.palletops.awaze.client-builder/undef)
     (.
      bean6152
      setAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg6206] (clojure.core/str arg6206))
  (clojure.core/keys v6154))
 (clojure.core/map
  (clojure.core/fn [arg6206] (clojure.core/str arg6206))
  (clojure.core/vals v6154))))))
   (clojure.core/let
    [v6154 (:name m6153 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6154 :com.palletops.awaze.client-builder/undef)
     (. bean6152 setName (clojure.core/str v6154))))
   bean6152))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.SetPlatformApplicationAttributesRequest}
set-platform-application-attributes-request
  [m6156]
  (clojure.core/let
   [bean6155
    (new
     com.amazonaws.services.sns.model.SetPlatformApplicationAttributesRequest)]
   (clojure.core/let
    [v6157
     (:platform-application-arn
      m6156
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6157 :com.palletops.awaze.client-builder/undef)
     (. bean6155 setPlatformApplicationArn (clojure.core/str v6157))))
   (clojure.core/let
    [v6157
     (:attributes m6156 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6157 :com.palletops.awaze.client-builder/undef)
     (.
      bean6155
      setAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg6207] (clojure.core/str arg6207))
  (clojure.core/keys v6157))
 (clojure.core/map
  (clojure.core/fn [arg6207] (clojure.core/str arg6207))
  (clojure.core/vals v6157))))))
   bean6155))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.ConfirmSubscriptionRequest}
confirm-subscription-request
  [m6159]
  (clojure.core/let
   [bean6158
    (new com.amazonaws.services.sns.model.ConfirmSubscriptionRequest)]
   (clojure.core/let
    [v6160
     (:authenticate-on-unsubscribe
      m6159
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6160 :com.palletops.awaze.client-builder/undef)
     (.
      bean6158
      setAuthenticateOnUnsubscribe
      (clojure.core/str v6160))))
   (clojure.core/let
    [v6160 (:token m6159 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6160 :com.palletops.awaze.client-builder/undef)
     (. bean6158 setToken (clojure.core/str v6160))))
   (clojure.core/let
    [v6160
     (:topic-arn m6159 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6160 :com.palletops.awaze.client-builder/undef)
     (. bean6158 setTopicArn (clojure.core/str v6160))))
   bean6158))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.CreatePlatformEndpointRequest}
create-platform-endpoint-request
  [m6162]
  (clojure.core/let
   [bean6161
    (new
     com.amazonaws.services.sns.model.CreatePlatformEndpointRequest)]
   (clojure.core/let
    [v6163
     (:platform-application-arn
      m6162
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6163 :com.palletops.awaze.client-builder/undef)
     (. bean6161 setPlatformApplicationArn (clojure.core/str v6163))))
   (clojure.core/let
    [v6163
     (:custom-user-data
      m6162
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6163 :com.palletops.awaze.client-builder/undef)
     (. bean6161 setCustomUserData (clojure.core/str v6163))))
   (clojure.core/let
    [v6163 (:token m6162 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6163 :com.palletops.awaze.client-builder/undef)
     (. bean6161 setToken (clojure.core/str v6163))))
   (clojure.core/let
    [v6163
     (:attributes m6162 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6163 :com.palletops.awaze.client-builder/undef)
     (.
      bean6161
      setAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg6208] (clojure.core/str arg6208))
  (clojure.core/keys v6163))
 (clojure.core/map
  (clojure.core/fn [arg6208] (clojure.core/str arg6208))
  (clojure.core/vals v6163))))))
   bean6161))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.ListPlatformApplicationsRequest}
list-platform-applications-request
  [m6165]
  (clojure.core/let
   [bean6164
    (new
     com.amazonaws.services.sns.model.ListPlatformApplicationsRequest)]
   (clojure.core/let
    [v6166
     (:next-token m6165 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6166 :com.palletops.awaze.client-builder/undef)
     (. bean6164 setNextToken (clojure.core/str v6166))))
   bean6164))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.CreateTopicRequest}
create-topic-request
  [m6168]
  (clojure.core/let
   [bean6167
    (new com.amazonaws.services.sns.model.CreateTopicRequest)]
   (clojure.core/let
    [v6169 (:name m6168 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6169 :com.palletops.awaze.client-builder/undef)
     (. bean6167 setName (clojure.core/str v6169))))
   bean6167))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.ListEndpointsByPlatformApplicationRequest}
list-endpoints-by-platform-application-request
  [m6171]
  (clojure.core/let
   [bean6170
    (new
     com.amazonaws.services.sns.model.ListEndpointsByPlatformApplicationRequest)]
   (clojure.core/let
    [v6172
     (:platform-application-arn
      m6171
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6172 :com.palletops.awaze.client-builder/undef)
     (. bean6170 setPlatformApplicationArn (clojure.core/str v6172))))
   (clojure.core/let
    [v6172
     (:next-token m6171 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6172 :com.palletops.awaze.client-builder/undef)
     (. bean6170 setNextToken (clojure.core/str v6172))))
   bean6170))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.GetPlatformApplicationAttributesRequest}
get-platform-application-attributes-request
  [m6174]
  (clojure.core/let
   [bean6173
    (new
     com.amazonaws.services.sns.model.GetPlatformApplicationAttributesRequest)]
   (clojure.core/let
    [v6175
     (:platform-application-arn
      m6174
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6175 :com.palletops.awaze.client-builder/undef)
     (. bean6173 setPlatformApplicationArn (clojure.core/str v6175))))
   bean6173))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.SetSubscriptionAttributesRequest}
set-subscription-attributes-request
  [m6177]
  (clojure.core/let
   [bean6176
    (new
     com.amazonaws.services.sns.model.SetSubscriptionAttributesRequest)]
   (clojure.core/let
    [v6178
     (:subscription-arn
      m6177
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6178 :com.palletops.awaze.client-builder/undef)
     (. bean6176 setSubscriptionArn (clojure.core/str v6178))))
   (clojure.core/let
    [v6178
     (:attribute-name m6177 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6178 :com.palletops.awaze.client-builder/undef)
     (. bean6176 setAttributeName (clojure.core/str v6178))))
   (clojure.core/let
    [v6178
     (:attribute-value
      m6177
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6178 :com.palletops.awaze.client-builder/undef)
     (. bean6176 setAttributeValue (clojure.core/str v6178))))
   bean6176))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.AddPermissionRequest}
add-permission-request
  [m6180]
  (clojure.core/let
   [bean6179
    (new com.amazonaws.services.sns.model.AddPermissionRequest)]
   (clojure.core/let
    [v6181
     (:action-names m6180 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6181 :com.palletops.awaze.client-builder/undef)
     (.
      bean6179
      setActionNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6241] (clojure.core/str arg6241))
 v6181))))
   (clojure.core/let
    [v6181 (:label m6180 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6181 :com.palletops.awaze.client-builder/undef)
     (. bean6179 setLabel (clojure.core/str v6181))))
   (clojure.core/let
    [v6181
     (:awsaccount-ids m6180 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6181 :com.palletops.awaze.client-builder/undef)
     (.
      bean6179
      setAWSAccountIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6242] (clojure.core/str arg6242))
 v6181))))
   (clojure.core/let
    [v6181
     (:topic-arn m6180 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6181 :com.palletops.awaze.client-builder/undef)
     (. bean6179 setTopicArn (clojure.core/str v6181))))
   bean6179))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.ListSubscriptionsRequest}
list-subscriptions-request
  [m6183]
  (clojure.core/let
   [bean6182
    (new com.amazonaws.services.sns.model.ListSubscriptionsRequest)]
   (clojure.core/let
    [v6184
     (:next-token m6183 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6184 :com.palletops.awaze.client-builder/undef)
     (. bean6182 setNextToken (clojure.core/str v6184))))
   bean6182))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.GetTopicAttributesRequest}
get-topic-attributes-request
  [m6186]
  (clojure.core/let
   [bean6185
    (new com.amazonaws.services.sns.model.GetTopicAttributesRequest)]
   (clojure.core/let
    [v6187
     (:topic-arn m6186 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6187 :com.palletops.awaze.client-builder/undef)
     (. bean6185 setTopicArn (clojure.core/str v6187))))
   bean6185))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.GetEndpointAttributesRequest}
get-endpoint-attributes-request
  [m6189]
  (clojure.core/let
   [bean6188
    (new
     com.amazonaws.services.sns.model.GetEndpointAttributesRequest)]
   (clojure.core/let
    [v6190
     (:endpoint-arn m6189 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6190 :com.palletops.awaze.client-builder/undef)
     (. bean6188 setEndpointArn (clojure.core/str v6190))))
   bean6188))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.DeleteTopicRequest}
delete-topic-request
  [m6192]
  (clojure.core/let
   [bean6191
    (new com.amazonaws.services.sns.model.DeleteTopicRequest)]
   (clojure.core/let
    [v6193
     (:topic-arn m6192 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6193 :com.palletops.awaze.client-builder/undef)
     (. bean6191 setTopicArn (clojure.core/str v6193))))
   bean6191))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.SubscribeRequest}
subscribe-request
  [m6195]
  (clojure.core/let
   [bean6194 (new com.amazonaws.services.sns.model.SubscribeRequest)]
   (clojure.core/let
    [v6196
     (:endpoint m6195 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6196 :com.palletops.awaze.client-builder/undef)
     (. bean6194 setEndpoint (clojure.core/str v6196))))
   (clojure.core/let
    [v6196
     (:protocol m6195 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6196 :com.palletops.awaze.client-builder/undef)
     (. bean6194 setProtocol (clojure.core/str v6196))))
   (clojure.core/let
    [v6196
     (:topic-arn m6195 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6196 :com.palletops.awaze.client-builder/undef)
     (. bean6194 setTopicArn (clojure.core/str v6196))))
   bean6194))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.ListSubscriptionsByTopicRequest}
list-subscriptions-by-topic-request
  [m6198]
  (clojure.core/let
   [bean6197
    (new
     com.amazonaws.services.sns.model.ListSubscriptionsByTopicRequest)]
   (clojure.core/let
    [v6199
     (:next-token m6198 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6199 :com.palletops.awaze.client-builder/undef)
     (. bean6197 setNextToken (clojure.core/str v6199))))
   (clojure.core/let
    [v6199
     (:topic-arn m6198 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6199 :com.palletops.awaze.client-builder/undef)
     (. bean6197 setTopicArn (clojure.core/str v6199))))
   bean6197))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.PublishRequest}
publish-request
  [m6201]
  (clojure.core/let
   [bean6200 (new com.amazonaws.services.sns.model.PublishRequest)]
   (clojure.core/let
    [v6202
     (:message-structure
      m6201
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6202 :com.palletops.awaze.client-builder/undef)
     (. bean6200 setMessageStructure (clojure.core/str v6202))))
   (clojure.core/let
    [v6202
     (:target-arn m6201 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6202 :com.palletops.awaze.client-builder/undef)
     (. bean6200 setTargetArn (clojure.core/str v6202))))
   (clojure.core/let
    [v6202
     (:message-attributes
      m6201
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6202 :com.palletops.awaze.client-builder/undef)
     (.
      bean6200
      setMessageAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg6243] (clojure.core/str arg6243))
  (clojure.core/keys v6202))
 (clojure.core/map
  (clojure.core/fn [arg6243] (sns/message-attribute-value arg6243))
  (clojure.core/vals v6202))))))
   (clojure.core/let
    [v6202 (:message m6201 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6202 :com.palletops.awaze.client-builder/undef)
     (. bean6200 setMessage (clojure.core/str v6202))))
   (clojure.core/let
    [v6202 (:subject m6201 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6202 :com.palletops.awaze.client-builder/undef)
     (. bean6200 setSubject (clojure.core/str v6202))))
   (clojure.core/let
    [v6202
     (:topic-arn m6201 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6202 :com.palletops.awaze.client-builder/undef)
     (. bean6200 setTopicArn (clojure.core/str v6202))))
   bean6200))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.SetEndpointAttributesRequest}
set-endpoint-attributes-request
  [m6204]
  (clojure.core/let
   [bean6203
    (new
     com.amazonaws.services.sns.model.SetEndpointAttributesRequest)]
   (clojure.core/let
    [v6205
     (:endpoint-arn m6204 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6205 :com.palletops.awaze.client-builder/undef)
     (. bean6203 setEndpointArn (clojure.core/str v6205))))
   (clojure.core/let
    [v6205
     (:attributes m6204 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6205 :com.palletops.awaze.client-builder/undef)
     (.
      bean6203
      setAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg6244] (clojure.core/str arg6244))
  (clojure.core/keys v6205))
 (clojure.core/map
  (clojure.core/fn [arg6244] (clojure.core/str arg6244))
  (clojure.core/vals v6205))))))
   bean6203))
 (clojure.core/defmulti
  sns
  (clojure.core/fn sns [m__1874__auto__] (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   sns
   :list-topics
   [m6209]
   (clojure.core/let
    [credentials6210 (:credentials m6209) args6211 (:args m6209)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6212
      (com.palletops.awaze.common/aws-client :sns credentials6210)]
     (clojure.core/case
      (clojure.core/count args6211)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args6211 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6212
           listTopics
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.sns.model.ListTopicsRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.sns.model.ListTopicsRequest
               (clojure.core/nth args6211 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6212
               listTopics
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "listTopics")
                {:args args6211}))))))))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6212
        listTopics))))))
  (clojure.core/defn
   list-topics-map
   {:arglists (quote
               [[credentials string-0]
                [credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for listTopics, listTopics, listTopics"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-topics,
     :credentials credentials__1842__auto__,
     :client :sns})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-topics,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   list-topics
   {:arglists (quote
               [[credentials string-0]
                [credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call listTopics, listTopics, listTopics"}
   [credentials6214 & args6215]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6216
     (com.palletops.awaze.common/aws-client :sns credentials6214)]
    (clojure.core/case
     (clojure.core/count args6215)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args6215 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6216
          listTopics
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.sns.model.ListTopicsRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.sns.model.ListTopicsRequest
              (clojure.core/nth args6215 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6216
              listTopics
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "listTopics")
               {:args args6215}))))))))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6216
       listTopics))))))
 (do
  (clojure.core/defmethod
   sns
   :set-topic-attributes
   [m6217]
   (clojure.core/let
    [credentials6218 (:credentials m6217) args6219 (:args m6217)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6220
      (com.palletops.awaze.common/aws-client :sns credentials6218)]
     (clojure.core/case
      (clojure.core/count args6219)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6220
        setTopicAttributes
        (sns/set-topic-attributes-request
         (clojure.core/nth args6219 0))))
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6220
        setTopicAttributes
        (clojure.core/str (clojure.core/nth args6219 0))
        (clojure.core/str (clojure.core/nth args6219 1))
        (clojure.core/str (clojure.core/nth args6219 2))))))))
  (clojure.core/defn
   set-topic-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [attribute-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         attribute-value
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials string-0 string-1 string-2]]),
    :doc "Generate map for setTopicAttributes, setTopicAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-topic-attributes,
     :credentials credentials__1842__auto__,
     :client :sns})
   ([credentials__1842__auto__ a b c]
    {:args [a b c],
     :fn :set-topic-attributes,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   set-topic-attributes
   {:arglists (quote
               [[credentials
                 {:keys [attribute-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         attribute-value
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials string-0 string-1 string-2]]),
    :doc "Call setTopicAttributes, setTopicAttributes"}
   [credentials6222 & args6223]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6224
     (com.palletops.awaze.common/aws-client :sns credentials6222)]
    (clojure.core/case
     (clojure.core/count args6223)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6224
       setTopicAttributes
       (sns/set-topic-attributes-request
        (clojure.core/nth args6223 0))))
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6224
       setTopicAttributes
       (clojure.core/str (clojure.core/nth args6223 0))
       (clojure.core/str (clojure.core/nth args6223 1))
       (clojure.core/str (clojure.core/nth args6223 2))))))))
 (do
  (clojure.core/defmethod
   sns
   :remove-permission
   [m6225]
   (clojure.core/let
    [credentials6226 (:credentials m6225) args6227 (:args m6225)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6228
      (com.palletops.awaze.common/aws-client :sns credentials6226)]
     (clojure.core/case
      (clojure.core/count args6227)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6228
        removePermission
        (sns/remove-permission-request (clojure.core/nth args6227 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6228
        removePermission
        (clojure.core/str (clojure.core/nth args6227 0))
        (clojure.core/str (clojure.core/nth args6227 1))))))))
  (clojure.core/defn
   remove-permission-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         label
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials string-0 string-1]]),
    :doc "Generate map for removePermission, removePermission"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :remove-permission,
     :credentials credentials__1842__auto__,
     :client :sns})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :remove-permission,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   remove-permission
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         label
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials string-0 string-1]]),
    :doc "Call removePermission, removePermission"}
   [credentials6230 & args6231]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6232
     (com.palletops.awaze.common/aws-client :sns credentials6230)]
    (clojure.core/case
     (clojure.core/count args6231)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6232
       removePermission
       (sns/remove-permission-request (clojure.core/nth args6231 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6232
       removePermission
       (clojure.core/str (clojure.core/nth args6231 0))
       (clojure.core/str (clojure.core/nth args6231 1))))))))
 (do
  (clojure.core/defmethod
   sns
   :unsubscribe
   [m6233]
   (clojure.core/let
    [credentials6234 (:credentials m6233) args6235 (:args m6233)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6236
      (com.palletops.awaze.common/aws-client :sns credentials6234)]
     (clojure.core/case
      (clojure.core/count args6235)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.sns.model.UnsubscribeRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.sns.model.UnsubscribeRequest
           (clojure.core/nth args6235 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6236
           unsubscribe
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args6235 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6236
               unsubscribe
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "unsubscribe")
                {:args args6235}))))))))))))))
  (clojure.core/defn
   unsubscribe-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         subscription-arn]}]
                [credentials string-0]]),
    :doc "Generate map for unsubscribe, unsubscribe"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :unsubscribe,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   unsubscribe
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         subscription-arn]}]
                [credentials string-0]]),
    :doc "Call unsubscribe, unsubscribe"}
   [credentials6238 & args6239]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6240
     (com.palletops.awaze.common/aws-client :sns credentials6238)]
    (clojure.core/case
     (clojure.core/count args6239)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.sns.model.UnsubscribeRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.sns.model.UnsubscribeRequest
          (clojure.core/nth args6239 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6240
          unsubscribe
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args6239 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6240
              unsubscribe
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "unsubscribe")
               {:args args6239}))))))))))))))
 (do
  (clojure.core/defmethod
   sns
   :delete-platform-application
   [m6245]
   (clojure.core/let
    [credentials6246 (:credentials m6245) args6247 (:args m6245)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6248
      (com.palletops.awaze.common/aws-client :sns credentials6246)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6248
       deletePlatformApplication
       (sns/delete-platform-application-request
        (clojure.core/nth args6247 0)))))))
  (clojure.core/defn
   delete-platform-application-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         platform-application-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deletePlatformApplication"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-platform-application,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   delete-platform-application
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         platform-application-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deletePlatformApplication"}
   [credentials6250 & args6251]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6252
     (com.palletops.awaze.common/aws-client :sns credentials6250)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6252
      deletePlatformApplication
      (sns/delete-platform-application-request
       (clojure.core/nth args6251 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :delete-endpoint
   [m6253]
   (clojure.core/let
    [credentials6254 (:credentials m6253) args6255 (:args m6253)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6256
      (com.palletops.awaze.common/aws-client :sns credentials6254)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6256
       deleteEndpoint
       (sns/delete-endpoint-request (clojure.core/nth args6255 0)))))))
  (clojure.core/defn
   delete-endpoint-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         endpoint-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteEndpoint"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-endpoint,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   delete-endpoint
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         endpoint-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteEndpoint"}
   [credentials6258 & args6259]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6260
     (com.palletops.awaze.common/aws-client :sns credentials6258)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6260
      deleteEndpoint
      (sns/delete-endpoint-request (clojure.core/nth args6259 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :get-subscription-attributes
   [m6261]
   (clojure.core/let
    [credentials6262 (:credentials m6261) args6263 (:args m6261)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6264
      (com.palletops.awaze.common/aws-client :sns credentials6262)]
     (clojure.core/case
      (clojure.core/count args6263)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args6263 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6264
           getSubscriptionAttributes
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.sns.model.GetSubscriptionAttributesRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.sns.model.GetSubscriptionAttributesRequest
               (clojure.core/nth args6263 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6264
               getSubscriptionAttributes
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getSubscriptionAttributes")
                {:args args6263}))))))))))))))
  (clojure.core/defn
   get-subscription-attributes-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         subscription-arn]}]]),
    :doc "Generate map for getSubscriptionAttributes, getSubscriptionAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-subscription-attributes,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   get-subscription-attributes
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         subscription-arn]}]]),
    :doc "Call getSubscriptionAttributes, getSubscriptionAttributes"}
   [credentials6266 & args6267]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6268
     (com.palletops.awaze.common/aws-client :sns credentials6266)]
    (clojure.core/case
     (clojure.core/count args6267)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args6267 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6268
          getSubscriptionAttributes
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.sns.model.GetSubscriptionAttributesRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.sns.model.GetSubscriptionAttributesRequest
              (clojure.core/nth args6267 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6268
              getSubscriptionAttributes
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getSubscriptionAttributes")
               {:args args6267}))))))))))))))
 (do
  (clojure.core/defmethod
   sns
   :create-platform-application
   [m6269]
   (clojure.core/let
    [credentials6270 (:credentials m6269) args6271 (:args m6269)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6272
      (com.palletops.awaze.common/aws-client :sns credentials6270)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6272
       createPlatformApplication
       (sns/create-platform-application-request
        (clojure.core/nth args6271 0)))))))
  (clojure.core/defn
   create-platform-application-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         attributes
                         clone-root
                         platform]}]]),
    :doc "Generate map for createPlatformApplication"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-platform-application,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   create-platform-application
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         attributes
                         clone-root
                         platform]}]]),
    :doc "Call createPlatformApplication"}
   [credentials6274 & args6275]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6276
     (com.palletops.awaze.common/aws-client :sns credentials6274)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6276
      createPlatformApplication
      (sns/create-platform-application-request
       (clojure.core/nth args6275 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :set-platform-application-attributes
   [m6277]
   (clojure.core/let
    [credentials6278 (:credentials m6277) args6279 (:args m6277)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6280
      (com.palletops.awaze.common/aws-client :sns credentials6278)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6280
       setPlatformApplicationAttributes
       (sns/set-platform-application-attributes-request
        (clojure.core/nth args6279 0)))))))
  (clojure.core/defn
   set-platform-application-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         platform-application-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         attributes
                         clone-root]}]]),
    :doc "Generate map for setPlatformApplicationAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-platform-application-attributes,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   set-platform-application-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         platform-application-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         attributes
                         clone-root]}]]),
    :doc "Call setPlatformApplicationAttributes"}
   [credentials6282 & args6283]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6284
     (com.palletops.awaze.common/aws-client :sns credentials6282)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6284
      setPlatformApplicationAttributes
      (sns/set-platform-application-attributes-request
       (clojure.core/nth args6283 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :confirm-subscription
   [m6285]
   (clojure.core/let
    [credentials6286 (:credentials m6285) args6287 (:args m6285)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6288
      (com.palletops.awaze.common/aws-client :sns credentials6286)]
     (clojure.core/case
      (clojure.core/count args6287)
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6288
        confirmSubscription
        (clojure.core/str (clojure.core/nth args6287 0))
        (clojure.core/str (clojure.core/nth args6287 1))
        (clojure.core/str (clojure.core/nth args6287 2))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6288
        confirmSubscription
        (clojure.core/str (clojure.core/nth args6287 0))
        (clojure.core/str (clojure.core/nth args6287 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6288
        confirmSubscription
        (sns/confirm-subscription-request
         (clojure.core/nth args6287 0))))))))
  (clojure.core/defn
   confirm-subscription-map
   {:arglists (quote
               [[credentials string-0 string-1 string-2]
                [credentials string-0 string-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         authenticate-on-unsubscribe
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         token
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for confirmSubscription, confirmSubscription, confirmSubscription"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :confirm-subscription,
     :credentials credentials__1842__auto__,
     :client :sns})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :confirm-subscription,
     :credentials credentials__1842__auto__,
     :client :sns})
   ([credentials__1842__auto__ a b c]
    {:args [a b c],
     :fn :confirm-subscription,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   confirm-subscription
   {:arglists (quote
               [[credentials string-0 string-1 string-2]
                [credentials string-0 string-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         authenticate-on-unsubscribe
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         token
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call confirmSubscription, confirmSubscription, confirmSubscription"}
   [credentials6290 & args6291]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6292
     (com.palletops.awaze.common/aws-client :sns credentials6290)]
    (clojure.core/case
     (clojure.core/count args6291)
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6292
       confirmSubscription
       (clojure.core/str (clojure.core/nth args6291 0))
       (clojure.core/str (clojure.core/nth args6291 1))
       (clojure.core/str (clojure.core/nth args6291 2))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6292
       confirmSubscription
       (clojure.core/str (clojure.core/nth args6291 0))
       (clojure.core/str (clojure.core/nth args6291 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6292
       confirmSubscription
       (sns/confirm-subscription-request
        (clojure.core/nth args6291 0))))))))
 (do
  (clojure.core/defmethod
   sns
   :create-platform-endpoint
   [m6293]
   (clojure.core/let
    [credentials6294 (:credentials m6293) args6295 (:args m6293)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6296
      (com.palletops.awaze.common/aws-client :sns credentials6294)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6296
       createPlatformEndpoint
       (sns/create-platform-endpoint-request
        (clojure.core/nth args6295 0)))))))
  (clojure.core/defn
   create-platform-endpoint-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         platform-application-arn
                         sdk-request-timeout
                         custom-user-data
                         custom-query-parameters
                         token
                         read-limit
                         general-progress-listener
                         clone-source
                         attributes
                         clone-root]}]]),
    :doc "Generate map for createPlatformEndpoint"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-platform-endpoint,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   create-platform-endpoint
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         platform-application-arn
                         sdk-request-timeout
                         custom-user-data
                         custom-query-parameters
                         token
                         read-limit
                         general-progress-listener
                         clone-source
                         attributes
                         clone-root]}]]),
    :doc "Call createPlatformEndpoint"}
   [credentials6298 & args6299]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6300
     (com.palletops.awaze.common/aws-client :sns credentials6298)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6300
      createPlatformEndpoint
      (sns/create-platform-endpoint-request
       (clojure.core/nth args6299 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :list-platform-applications
   [m6301]
   (clojure.core/let
    [credentials6302 (:credentials m6301) args6303 (:args m6301)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6304
      (com.palletops.awaze.common/aws-client :sns credentials6302)]
     (clojure.core/case
      (clojure.core/count args6303)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6304
        listPlatformApplications))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6304
        listPlatformApplications
        (sns/list-platform-applications-request
         (clojure.core/nth args6303 0))))))))
  (clojure.core/defn
   list-platform-applications-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for listPlatformApplications, listPlatformApplications"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-platform-applications,
     :credentials credentials__1842__auto__,
     :client :sns})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-platform-applications,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   list-platform-applications
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call listPlatformApplications, listPlatformApplications"}
   [credentials6306 & args6307]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6308
     (com.palletops.awaze.common/aws-client :sns credentials6306)]
    (clojure.core/case
     (clojure.core/count args6307)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6308
       listPlatformApplications))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6308
       listPlatformApplications
       (sns/list-platform-applications-request
        (clojure.core/nth args6307 0))))))))
 (do
  (clojure.core/defmethod
   sns
   :create-topic
   [m6309]
   (clojure.core/let
    [credentials6310 (:credentials m6309) args6311 (:args m6309)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6312
      (com.palletops.awaze.common/aws-client :sns credentials6310)]
     (clojure.core/case
      (clojure.core/count args6311)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.sns.model.CreateTopicRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.sns.model.CreateTopicRequest
           (clojure.core/nth args6311 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6312
           createTopic
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args6311 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6312
               createTopic
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "createTopic")
                {:args args6311}))))))))))))))
  (clojure.core/defn
   create-topic-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials string-0]]),
    :doc "Generate map for createTopic, createTopic"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-topic,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   create-topic
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials string-0]]),
    :doc "Call createTopic, createTopic"}
   [credentials6314 & args6315]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6316
     (com.palletops.awaze.common/aws-client :sns credentials6314)]
    (clojure.core/case
     (clojure.core/count args6315)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.sns.model.CreateTopicRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.sns.model.CreateTopicRequest
          (clojure.core/nth args6315 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6316
          createTopic
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args6315 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6316
              createTopic
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "createTopic")
               {:args args6315}))))))))))))))
 (do
  (clojure.core/defmethod
   sns
   :list-endpoints-by-platform-application
   [m6317]
   (clojure.core/let
    [credentials6318 (:credentials m6317) args6319 (:args m6317)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6320
      (com.palletops.awaze.common/aws-client :sns credentials6318)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6320
       listEndpointsByPlatformApplication
       (sns/list-endpoints-by-platform-application-request
        (clojure.core/nth args6319 0)))))))
  (clojure.core/defn
   list-endpoints-by-platform-application-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         platform-application-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for listEndpointsByPlatformApplication"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-endpoints-by-platform-application,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   list-endpoints-by-platform-application
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         platform-application-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call listEndpointsByPlatformApplication"}
   [credentials6322 & args6323]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6324
     (com.palletops.awaze.common/aws-client :sns credentials6322)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6324
      listEndpointsByPlatformApplication
      (sns/list-endpoints-by-platform-application-request
       (clojure.core/nth args6323 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :get-platform-application-attributes
   [m6325]
   (clojure.core/let
    [credentials6326 (:credentials m6325) args6327 (:args m6325)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6328
      (com.palletops.awaze.common/aws-client :sns credentials6326)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6328
       getPlatformApplicationAttributes
       (sns/get-platform-application-attributes-request
        (clojure.core/nth args6327 0)))))))
  (clojure.core/defn
   get-platform-application-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         platform-application-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getPlatformApplicationAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-platform-application-attributes,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   get-platform-application-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         platform-application-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getPlatformApplicationAttributes"}
   [credentials6330 & args6331]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6332
     (com.palletops.awaze.common/aws-client :sns credentials6330)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6332
      getPlatformApplicationAttributes
      (sns/get-platform-application-attributes-request
       (clojure.core/nth args6331 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :set-subscription-attributes
   [m6333]
   (clojure.core/let
    [credentials6334 (:credentials m6333) args6335 (:args m6333)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6336
      (com.palletops.awaze.common/aws-client :sns credentials6334)]
     (clojure.core/case
      (clojure.core/count args6335)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6336
        setSubscriptionAttributes
        (sns/set-subscription-attributes-request
         (clojure.core/nth args6335 0))))
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6336
        setSubscriptionAttributes
        (clojure.core/str (clojure.core/nth args6335 0))
        (clojure.core/str (clojure.core/nth args6335 1))
        (clojure.core/str (clojure.core/nth args6335 2))))))))
  (clojure.core/defn
   set-subscription-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [attribute-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         attribute-value
                         general-progress-listener
                         clone-source
                         clone-root
                         subscription-arn]}]
                [credentials string-0 string-1 string-2]]),
    :doc "Generate map for setSubscriptionAttributes, setSubscriptionAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-subscription-attributes,
     :credentials credentials__1842__auto__,
     :client :sns})
   ([credentials__1842__auto__ a b c]
    {:args [a b c],
     :fn :set-subscription-attributes,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   set-subscription-attributes
   {:arglists (quote
               [[credentials
                 {:keys [attribute-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         attribute-value
                         general-progress-listener
                         clone-source
                         clone-root
                         subscription-arn]}]
                [credentials string-0 string-1 string-2]]),
    :doc "Call setSubscriptionAttributes, setSubscriptionAttributes"}
   [credentials6338 & args6339]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6340
     (com.palletops.awaze.common/aws-client :sns credentials6338)]
    (clojure.core/case
     (clojure.core/count args6339)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6340
       setSubscriptionAttributes
       (sns/set-subscription-attributes-request
        (clojure.core/nth args6339 0))))
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6340
       setSubscriptionAttributes
       (clojure.core/str (clojure.core/nth args6339 0))
       (clojure.core/str (clojure.core/nth args6339 1))
       (clojure.core/str (clojure.core/nth args6339 2))))))))
 (do
  (clojure.core/defmethod
   sns
   :add-permission
   [m6341]
   (clojure.core/let
    [credentials6342 (:credentials m6341) args6343 (:args m6341)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6344
      (com.palletops.awaze.common/aws-client :sns credentials6342)]
     (clojure.core/case
      (clojure.core/count args6343)
      4
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6344
        addPermission
        (clojure.core/str (clojure.core/nth args6343 0))
        (clojure.core/str (clojure.core/nth args6343 1))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg6373] (clojure.core/str arg6373))
 (clojure.core/nth args6343 2))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg6374] (clojure.core/str arg6374))
 (clojure.core/nth args6343 3))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6344
        addPermission
        (sns/add-permission-request (clojure.core/nth args6343 0))))))))
  (clojure.core/defn
   add-permission-map
   {:arglists (quote
               [[credentials string-0 string-1 list-2 list-3]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         awsaccount-ids
                         sdk-request-timeout
                         custom-query-parameters
                         action-names
                         read-limit
                         label
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for addPermission, addPermission"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :add-permission,
     :credentials credentials__1842__auto__,
     :client :sns})
   ([credentials__1842__auto__ a b c d]
    {:args [a b c d],
     :fn :add-permission,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   add-permission
   {:arglists (quote
               [[credentials string-0 string-1 list-2 list-3]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         awsaccount-ids
                         sdk-request-timeout
                         custom-query-parameters
                         action-names
                         read-limit
                         label
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call addPermission, addPermission"}
   [credentials6346 & args6347]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6348
     (com.palletops.awaze.common/aws-client :sns credentials6346)]
    (clojure.core/case
     (clojure.core/count args6347)
     4
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6348
       addPermission
       (clojure.core/str (clojure.core/nth args6347 0))
       (clojure.core/str (clojure.core/nth args6347 1))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg6375] (clojure.core/str arg6375))
 (clojure.core/nth args6347 2))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg6376] (clojure.core/str arg6376))
 (clojure.core/nth args6347 3))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6348
       addPermission
       (sns/add-permission-request (clojure.core/nth args6347 0))))))))
 (do
  (clojure.core/defmethod
   sns
   :list-subscriptions
   [m6349]
   (clojure.core/let
    [credentials6350 (:credentials m6349) args6351 (:args m6349)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6352
      (com.palletops.awaze.common/aws-client :sns credentials6350)]
     (clojure.core/case
      (clojure.core/count args6351)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args6351 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6352
           listSubscriptions
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.sns.model.ListSubscriptionsRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.sns.model.ListSubscriptionsRequest
               (clojure.core/nth args6351 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6352
               listSubscriptions
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "listSubscriptions")
                {:args args6351}))))))))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6352
        listSubscriptions))))))
  (clojure.core/defn
   list-subscriptions-map
   {:arglists (quote
               [[credentials string-0]
                [credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for listSubscriptions, listSubscriptions, listSubscriptions"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-subscriptions,
     :credentials credentials__1842__auto__,
     :client :sns})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-subscriptions,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   list-subscriptions
   {:arglists (quote
               [[credentials string-0]
                [credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call listSubscriptions, listSubscriptions, listSubscriptions"}
   [credentials6354 & args6355]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6356
     (com.palletops.awaze.common/aws-client :sns credentials6354)]
    (clojure.core/case
     (clojure.core/count args6355)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args6355 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6356
          listSubscriptions
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.sns.model.ListSubscriptionsRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.sns.model.ListSubscriptionsRequest
              (clojure.core/nth args6355 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6356
              listSubscriptions
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "listSubscriptions")
               {:args args6355}))))))))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6356
       listSubscriptions))))))
 (do
  (clojure.core/defmethod
   sns
   :get-topic-attributes
   [m6357]
   (clojure.core/let
    [credentials6358 (:credentials m6357) args6359 (:args m6357)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6360
      (com.palletops.awaze.common/aws-client :sns credentials6358)]
     (clojure.core/case
      (clojure.core/count args6359)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args6359 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6360
           getTopicAttributes
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.sns.model.GetTopicAttributesRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.sns.model.GetTopicAttributesRequest
               (clojure.core/nth args6359 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6360
               getTopicAttributes
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getTopicAttributes")
                {:args args6359}))))))))))))))
  (clojure.core/defn
   get-topic-attributes-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getTopicAttributes, getTopicAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-topic-attributes,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   get-topic-attributes
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getTopicAttributes, getTopicAttributes"}
   [credentials6362 & args6363]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6364
     (com.palletops.awaze.common/aws-client :sns credentials6362)]
    (clojure.core/case
     (clojure.core/count args6363)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args6363 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6364
          getTopicAttributes
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.sns.model.GetTopicAttributesRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.sns.model.GetTopicAttributesRequest
              (clojure.core/nth args6363 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6364
              getTopicAttributes
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getTopicAttributes")
               {:args args6363}))))))))))))))
 (do
  (clojure.core/defmethod
   sns
   :get-endpoint-attributes
   [m6365]
   (clojure.core/let
    [credentials6366 (:credentials m6365) args6367 (:args m6365)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6368
      (com.palletops.awaze.common/aws-client :sns credentials6366)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6368
       getEndpointAttributes
       (sns/get-endpoint-attributes-request
        (clojure.core/nth args6367 0)))))))
  (clojure.core/defn
   get-endpoint-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         endpoint-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getEndpointAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-endpoint-attributes,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   get-endpoint-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         endpoint-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call getEndpointAttributes"}
   [credentials6370 & args6371]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6372
     (com.palletops.awaze.common/aws-client :sns credentials6370)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6372
      getEndpointAttributes
      (sns/get-endpoint-attributes-request
       (clojure.core/nth args6371 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :delete-topic
   [m6377]
   (clojure.core/let
    [credentials6378 (:credentials m6377) args6379 (:args m6377)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6380
      (com.palletops.awaze.common/aws-client :sns credentials6378)]
     (clojure.core/case
      (clojure.core/count args6379)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.sns.model.DeleteTopicRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.sns.model.DeleteTopicRequest
           (clojure.core/nth args6379 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6380
           deleteTopic
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args6379 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6380
               deleteTopic
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteTopic")
                {:args args6379}))))))))))))))
  (clojure.core/defn
   delete-topic-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials string-0]]),
    :doc "Generate map for deleteTopic, deleteTopic"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-topic,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   delete-topic
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials string-0]]),
    :doc "Call deleteTopic, deleteTopic"}
   [credentials6382 & args6383]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6384
     (com.palletops.awaze.common/aws-client :sns credentials6382)]
    (clojure.core/case
     (clojure.core/count args6383)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.sns.model.DeleteTopicRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.sns.model.DeleteTopicRequest
          (clojure.core/nth args6383 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6384
          deleteTopic
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args6383 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6384
              deleteTopic
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteTopic")
               {:args args6383}))))))))))))))
 (do
  (clojure.core/defmethod
   sns
   :subscribe
   [m6385]
   (clojure.core/let
    [credentials6386 (:credentials m6385) args6387 (:args m6385)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6388
      (com.palletops.awaze.common/aws-client :sns credentials6386)]
     (clojure.core/case
      (clojure.core/count args6387)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6388
        subscribe
        (sns/subscribe-request (clojure.core/nth args6387 0))))
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6388
        subscribe
        (clojure.core/str (clojure.core/nth args6387 0))
        (clojure.core/str (clojure.core/nth args6387 1))
        (clojure.core/str (clojure.core/nth args6387 2))))))))
  (clojure.core/defn
   subscribe-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         protocol
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         endpoint
                         clone-root]}]
                [credentials string-0 string-1 string-2]]),
    :doc "Generate map for subscribe, subscribe"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :subscribe,
     :credentials credentials__1842__auto__,
     :client :sns})
   ([credentials__1842__auto__ a b c]
    {:args [a b c],
     :fn :subscribe,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   subscribe
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         protocol
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         endpoint
                         clone-root]}]
                [credentials string-0 string-1 string-2]]),
    :doc "Call subscribe, subscribe"}
   [credentials6390 & args6391]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6392
     (com.palletops.awaze.common/aws-client :sns credentials6390)]
    (clojure.core/case
     (clojure.core/count args6391)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6392
       subscribe
       (sns/subscribe-request (clojure.core/nth args6391 0))))
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6392
       subscribe
       (clojure.core/str (clojure.core/nth args6391 0))
       (clojure.core/str (clojure.core/nth args6391 1))
       (clojure.core/str (clojure.core/nth args6391 2))))))))
 (do
  (clojure.core/defmethod
   sns
   :list-subscriptions-by-topic
   [m6393]
   (clojure.core/let
    [credentials6394 (:credentials m6393) args6395 (:args m6393)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6396
      (com.palletops.awaze.common/aws-client :sns credentials6394)]
     (clojure.core/case
      (clojure.core/count args6395)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.sns.model.ListSubscriptionsByTopicRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.sns.model.ListSubscriptionsByTopicRequest
           (clojure.core/nth args6395 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6396
           listSubscriptionsByTopic
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args6395 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6396
               listSubscriptionsByTopic
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "listSubscriptionsByTopic")
                {:args args6395}))))))))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6396
        listSubscriptionsByTopic
        (clojure.core/str (clojure.core/nth args6395 0))
        (clojure.core/str (clojure.core/nth args6395 1))))))))
  (clojure.core/defn
   list-subscriptions-by-topic-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials string-0 string-1]
                [credentials string-0]]),
    :doc "Generate map for listSubscriptionsByTopic, listSubscriptionsByTopic, listSubscriptionsByTopic"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-subscriptions-by-topic,
     :credentials credentials__1842__auto__,
     :client :sns})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :list-subscriptions-by-topic,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   list-subscriptions-by-topic
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials string-0 string-1]
                [credentials string-0]]),
    :doc "Call listSubscriptionsByTopic, listSubscriptionsByTopic, listSubscriptionsByTopic"}
   [credentials6398 & args6399]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6400
     (com.palletops.awaze.common/aws-client :sns credentials6398)]
    (clojure.core/case
     (clojure.core/count args6399)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.sns.model.ListSubscriptionsByTopicRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.sns.model.ListSubscriptionsByTopicRequest
          (clojure.core/nth args6399 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6400
          listSubscriptionsByTopic
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args6399 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6400
              listSubscriptionsByTopic
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "listSubscriptionsByTopic")
               {:args args6399}))))))))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6400
       listSubscriptionsByTopic
       (clojure.core/str (clojure.core/nth args6399 0))
       (clojure.core/str (clojure.core/nth args6399 1))))))))
 (do
  (clojure.core/defmethod
   sns
   :publish
   [m6401]
   (clojure.core/let
    [credentials6402 (:credentials m6401) args6403 (:args m6401)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6404
      (com.palletops.awaze.common/aws-client :sns credentials6402)]
     (clojure.core/case
      (clojure.core/count args6403)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6404
        publish
        (clojure.core/str (clojure.core/nth args6403 0))
        (clojure.core/str (clojure.core/nth args6403 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6404
        publish
        (sns/publish-request (clojure.core/nth args6403 0))))
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6404
        publish
        (clojure.core/str (clojure.core/nth args6403 0))
        (clojure.core/str (clojure.core/nth args6403 1))
        (clojure.core/str (clojure.core/nth args6403 2))))))))
  (clojure.core/defn
   publish-map
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         message-attributes
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         message-structure
                         clone-source
                         subject
                         clone-root
                         message
                         target-arn]}]
                [credentials string-0 string-1 string-2]]),
    :doc "Generate map for publish, publish, publish"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :publish,
     :credentials credentials__1842__auto__,
     :client :sns})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :publish,
     :credentials credentials__1842__auto__,
     :client :sns})
   ([credentials__1842__auto__ a b c]
    {:args [a b c],
     :fn :publish,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   publish
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         message-attributes
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         message-structure
                         clone-source
                         subject
                         clone-root
                         message
                         target-arn]}]
                [credentials string-0 string-1 string-2]]),
    :doc "Call publish, publish, publish"}
   [credentials6406 & args6407]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6408
     (com.palletops.awaze.common/aws-client :sns credentials6406)]
    (clojure.core/case
     (clojure.core/count args6407)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6408
       publish
       (clojure.core/str (clojure.core/nth args6407 0))
       (clojure.core/str (clojure.core/nth args6407 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6408
       publish
       (sns/publish-request (clojure.core/nth args6407 0))))
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6408
       publish
       (clojure.core/str (clojure.core/nth args6407 0))
       (clojure.core/str (clojure.core/nth args6407 1))
       (clojure.core/str (clojure.core/nth args6407 2))))))))
 (do
  (clojure.core/defmethod
   sns
   :set-endpoint-attributes
   [m6409]
   (clojure.core/let
    [credentials6410 (:credentials m6409) args6411 (:args m6409)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6412
      (com.palletops.awaze.common/aws-client :sns credentials6410)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6412
       setEndpointAttributes
       (sns/set-endpoint-attributes-request
        (clojure.core/nth args6411 0)))))))
  (clojure.core/defn
   set-endpoint-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         endpoint-arn
                         clone-source
                         attributes
                         clone-root]}]]),
    :doc "Generate map for setEndpointAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-endpoint-attributes,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   set-endpoint-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         endpoint-arn
                         clone-source
                         attributes
                         clone-root]}]]),
    :doc "Call setEndpointAttributes"}
   [credentials6414 & args6415]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6416
     (com.palletops.awaze.common/aws-client :sns credentials6414)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6416
      setEndpointAttributes
      (sns/set-endpoint-attributes-request
       (clojure.core/nth args6415 0))))))))
