(ns
 com.palletops.awaze.simpleemail
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.simpleemail :as simpleemail]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :simpleemail
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.InvocationType}
invocation-type
  [m5215]
  (.
   com.amazonaws.services.simpleemail.model.InvocationType
   fromValue
   (clojure.core/name m5215)))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.StopScope}
stop-scope
  [m5218]
  (.
   com.amazonaws.services.simpleemail.model.StopScope
   fromValue
   (clojure.core/name m5218)))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.ReceiptFilterPolicy}
receipt-filter-policy
  [m5221]
  (.
   com.amazonaws.services.simpleemail.model.ReceiptFilterPolicy
   fromValue
   (clojure.core/name m5221)))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.ExtensionField}
extension-field
  [m5224]
  (clojure.core/let
   [bean5223
    (new com.amazonaws.services.simpleemail.model.ExtensionField)]
   (clojure.core/let
    [v5225 (:name m5224 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5225 :com.palletops.awaze.client-builder/undef)
     (. bean5223 setName (clojure.core/str v5225))))
   (clojure.core/let
    [v5225 (:value m5224 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5225 :com.palletops.awaze.client-builder/undef)
     (. bean5223 setValue (clojure.core/str v5225))))
   bean5223))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.DsnAction}
dsn-action
  [m5227]
  (.
   com.amazonaws.services.simpleemail.model.DsnAction
   fromValue
   (clojure.core/name m5227)))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.WorkmailAction}
workmail-action
  [m5230]
  (clojure.core/let
   [bean5229
    (new com.amazonaws.services.simpleemail.model.WorkmailAction)]
   (clojure.core/let
    [v5231
     (:topic-arn m5230 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5231 :com.palletops.awaze.client-builder/undef)
     (. bean5229 setTopicArn (clojure.core/str v5231))))
   (clojure.core/let
    [v5231
     (:organization-arn
      m5230
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5231 :com.palletops.awaze.client-builder/undef)
     (. bean5229 setOrganizationArn (clojure.core/str v5231))))
   bean5229))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.LambdaAction}
lambda-action
  [m5233]
  (clojure.core/let
   [bean5232
    (new com.amazonaws.services.simpleemail.model.LambdaAction)]
   (clojure.core/let
    [v5234
     (:topic-arn m5233 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5234 :com.palletops.awaze.client-builder/undef)
     (. bean5232 setTopicArn (clojure.core/str v5234))))
   (clojure.core/let
    [v5234
     (:function-arn m5233 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5234 :com.palletops.awaze.client-builder/undef)
     (. bean5232 setFunctionArn (clojure.core/str v5234))))
   (clojure.core/let
    [v5234
     (:invocation-type
      m5233
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5234 :com.palletops.awaze.client-builder/undef)
     (.
      bean5232
      setInvocationType
      (simpleemail/invocation-type v5234))))
   bean5232))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.StopAction}
stop-action
  [m5236]
  (clojure.core/let
   [bean5235
    (new com.amazonaws.services.simpleemail.model.StopAction)]
   (clojure.core/let
    [v5237
     (:topic-arn m5236 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5237 :com.palletops.awaze.client-builder/undef)
     (. bean5235 setTopicArn (clojure.core/str v5237))))
   (clojure.core/let
    [v5237 (:scope m5236 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5237 :com.palletops.awaze.client-builder/undef)
     (. bean5235 setScope (simpleemail/stop-scope v5237))))
   bean5235))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.SNSAction}
snsaction
  [m5239]
  (clojure.core/let
   [bean5238 (new com.amazonaws.services.simpleemail.model.SNSAction)]
   (clojure.core/let
    [v5240
     (:encoding m5239 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5240 :com.palletops.awaze.client-builder/undef)
     (. bean5238 setEncoding (clojure.core/str v5240))))
   (clojure.core/let
    [v5240
     (:topic-arn m5239 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5240 :com.palletops.awaze.client-builder/undef)
     (. bean5238 setTopicArn (clojure.core/str v5240))))
   bean5238))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.AddHeaderAction}
add-header-action
  [m5242]
  (clojure.core/let
   [bean5241
    (new com.amazonaws.services.simpleemail.model.AddHeaderAction)]
   (clojure.core/let
    [v5243
     (:header-name m5242 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5243 :com.palletops.awaze.client-builder/undef)
     (. bean5241 setHeaderName (clojure.core/str v5243))))
   (clojure.core/let
    [v5243
     (:header-value m5242 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5243 :com.palletops.awaze.client-builder/undef)
     (. bean5241 setHeaderValue (clojure.core/str v5243))))
   bean5241))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.S3Action}
s3action
  [m5245]
  (clojure.core/let
   [bean5244 (new com.amazonaws.services.simpleemail.model.S3Action)]
   (clojure.core/let
    [v5246
     (:topic-arn m5245 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5246 :com.palletops.awaze.client-builder/undef)
     (. bean5244 setTopicArn (clojure.core/str v5246))))
   (clojure.core/let
    [v5246
     (:bucket-name m5245 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5246 :com.palletops.awaze.client-builder/undef)
     (. bean5244 setBucketName (clojure.core/str v5246))))
   (clojure.core/let
    [v5246
     (:object-key-prefix
      m5245
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5246 :com.palletops.awaze.client-builder/undef)
     (. bean5244 setObjectKeyPrefix (clojure.core/str v5246))))
   (clojure.core/let
    [v5246
     (:kms-key-arn m5245 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5246 :com.palletops.awaze.client-builder/undef)
     (. bean5244 setKmsKeyArn (clojure.core/str v5246))))
   bean5244))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.BounceAction}
bounce-action
  [m5248]
  (clojure.core/let
   [bean5247
    (new com.amazonaws.services.simpleemail.model.BounceAction)]
   (clojure.core/let
    [v5249 (:message m5248 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5249 :com.palletops.awaze.client-builder/undef)
     (. bean5247 setMessage (clojure.core/str v5249))))
   (clojure.core/let
    [v5249
     (:status-code m5248 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5249 :com.palletops.awaze.client-builder/undef)
     (. bean5247 setStatusCode (clojure.core/str v5249))))
   (clojure.core/let
    [v5249
     (:topic-arn m5248 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5249 :com.palletops.awaze.client-builder/undef)
     (. bean5247 setTopicArn (clojure.core/str v5249))))
   (clojure.core/let
    [v5249
     (:smtp-reply-code
      m5248
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5249 :com.palletops.awaze.client-builder/undef)
     (. bean5247 setSmtpReplyCode (clojure.core/str v5249))))
   (clojure.core/let
    [v5249 (:sender m5248 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5249 :com.palletops.awaze.client-builder/undef)
     (. bean5247 setSender (clojure.core/str v5249))))
   bean5247))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.Content}
content
  [m5251]
  (clojure.core/let
   [bean5250 (new com.amazonaws.services.simpleemail.model.Content)]
   (clojure.core/let
    [v5252 (:data m5251 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5252 :com.palletops.awaze.client-builder/undef)
     (. bean5250 setData (clojure.core/str v5252))))
   (clojure.core/let
    [v5252 (:charset m5251 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5252 :com.palletops.awaze.client-builder/undef)
     (. bean5250 setCharset (clojure.core/str v5252))))
   bean5250))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.ReceiptIpFilter}
receipt-ip-filter
  [m5254]
  (clojure.core/let
   [bean5253
    (new com.amazonaws.services.simpleemail.model.ReceiptIpFilter)]
   (clojure.core/let
    [v5255 (:policy m5254 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5255 :com.palletops.awaze.client-builder/undef)
     (. bean5253 setPolicy (simpleemail/receipt-filter-policy v5255))))
   (clojure.core/let
    [v5255 (:cidr m5254 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5255 :com.palletops.awaze.client-builder/undef)
     (. bean5253 setCidr (clojure.core/str v5255))))
   bean5253))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.RecipientDsnFields}
recipient-dsn-fields
  [m5257]
  (clojure.core/let
   [bean5256
    (new com.amazonaws.services.simpleemail.model.RecipientDsnFields)]
   (clojure.core/let
    [v5258 (:status m5257 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5258 :com.palletops.awaze.client-builder/undef)
     (. bean5256 setStatus (clojure.core/str v5258))))
   (clojure.core/let
    [v5258
     (:extension-fields
      m5257
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5258 :com.palletops.awaze.client-builder/undef)
     (.
      bean5256
      setExtensionFields
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5418] (simpleemail/extension-field arg5418))
 v5258))))
   (clojure.core/let
    [v5258
     (:final-recipient
      m5257
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5258 :com.palletops.awaze.client-builder/undef)
     (. bean5256 setFinalRecipient (clojure.core/str v5258))))
   (clojure.core/let
    [v5258 (:action m5257 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5258 :com.palletops.awaze.client-builder/undef)
     (. bean5256 setAction (simpleemail/dsn-action v5258))))
   (clojure.core/let
    [v5258
     (:remote-mta m5257 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5258 :com.palletops.awaze.client-builder/undef)
     (. bean5256 setRemoteMta (clojure.core/str v5258))))
   (clojure.core/let
    [v5258
     (:diagnostic-code
      m5257
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5258 :com.palletops.awaze.client-builder/undef)
     (. bean5256 setDiagnosticCode (clojure.core/str v5258))))
   (clojure.core/let
    [v5258
     (:last-attempt-date
      m5257
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5258 :com.palletops.awaze.client-builder/undef)
     (.
      bean5256
      setLastAttemptDate
      (com.palletops.awaze.common/to-date v5258))))
   bean5256))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.TlsPolicy}
tls-policy
  [m5260]
  (.
   com.amazonaws.services.simpleemail.model.TlsPolicy
   fromValue
   (clojure.core/name m5260)))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.ReceiptAction}
receipt-action
  [m5263]
  (clojure.core/let
   [bean5262
    (new com.amazonaws.services.simpleemail.model.ReceiptAction)]
   (clojure.core/let
    [v5264
     (:workmail-action
      m5263
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5264 :com.palletops.awaze.client-builder/undef)
     (.
      bean5262
      setWorkmailAction
      (simpleemail/workmail-action v5264))))
   (clojure.core/let
    [v5264
     (:lambda-action m5263 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5264 :com.palletops.awaze.client-builder/undef)
     (. bean5262 setLambdaAction (simpleemail/lambda-action v5264))))
   (clojure.core/let
    [v5264
     (:stop-action m5263 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5264 :com.palletops.awaze.client-builder/undef)
     (. bean5262 setStopAction (simpleemail/stop-action v5264))))
   (clojure.core/let
    [v5264
     (:snsaction m5263 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5264 :com.palletops.awaze.client-builder/undef)
     (. bean5262 setSNSAction (simpleemail/snsaction v5264))))
   (clojure.core/let
    [v5264
     (:add-header-action
      m5263
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5264 :com.palletops.awaze.client-builder/undef)
     (.
      bean5262
      setAddHeaderAction
      (simpleemail/add-header-action v5264))))
   (clojure.core/let
    [v5264
     (:s3action m5263 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5264 :com.palletops.awaze.client-builder/undef)
     (. bean5262 setS3Action (simpleemail/s3action v5264))))
   (clojure.core/let
    [v5264
     (:bounce-action m5263 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5264 :com.palletops.awaze.client-builder/undef)
     (. bean5262 setBounceAction (simpleemail/bounce-action v5264))))
   bean5262))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.Body}
body
  [m5266]
  (clojure.core/let
   [bean5265 (new com.amazonaws.services.simpleemail.model.Body)]
   (clojure.core/let
    [v5267 (:text m5266 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5267 :com.palletops.awaze.client-builder/undef)
     (. bean5265 setText (simpleemail/content v5267))))
   (clojure.core/let
    [v5267 (:html m5266 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5267 :com.palletops.awaze.client-builder/undef)
     (. bean5265 setHtml (simpleemail/content v5267))))
   bean5265))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.NotificationType}
notification-type
  [m5269]
  (.
   com.amazonaws.services.simpleemail.model.NotificationType
   fromValue
   (clojure.core/name m5269)))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.ReceiptFilter}
receipt-filter
  [m5272]
  (clojure.core/let
   [bean5271
    (new com.amazonaws.services.simpleemail.model.ReceiptFilter)]
   (clojure.core/let
    [v5273
     (:ip-filter m5272 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5273 :com.palletops.awaze.client-builder/undef)
     (. bean5271 setIpFilter (simpleemail/receipt-ip-filter v5273))))
   (clojure.core/let
    [v5273 (:name m5272 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5273 :com.palletops.awaze.client-builder/undef)
     (. bean5271 setName (clojure.core/str v5273))))
   bean5271))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.MessageDsn}
message-dsn
  [m5275]
  (clojure.core/let
   [bean5274
    (new com.amazonaws.services.simpleemail.model.MessageDsn)]
   (clojure.core/let
    [v5276
     (:reporting-mta m5275 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5276 :com.palletops.awaze.client-builder/undef)
     (. bean5274 setReportingMta (clojure.core/str v5276))))
   (clojure.core/let
    [v5276
     (:arrival-date m5275 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5276 :com.palletops.awaze.client-builder/undef)
     (.
      bean5274
      setArrivalDate
      (com.palletops.awaze.common/to-date v5276))))
   (clojure.core/let
    [v5276
     (:extension-fields
      m5275
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5276 :com.palletops.awaze.client-builder/undef)
     (.
      bean5274
      setExtensionFields
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5419] (simpleemail/extension-field arg5419))
 v5276))))
   bean5274))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.BouncedRecipientInfo}
bounced-recipient-info
  [m5278]
  (clojure.core/let
   [bean5277
    (new
     com.amazonaws.services.simpleemail.model.BouncedRecipientInfo)]
   (clojure.core/let
    [v5279
     (:recipient m5278 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5279 :com.palletops.awaze.client-builder/undef)
     (. bean5277 setRecipient (clojure.core/str v5279))))
   (clojure.core/let
    [v5279
     (:bounce-type m5278 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5279 :com.palletops.awaze.client-builder/undef)
     (. bean5277 setBounceType (clojure.core/str v5279))))
   (clojure.core/let
    [v5279
     (:recipient-arn m5278 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5279 :com.palletops.awaze.client-builder/undef)
     (. bean5277 setRecipientArn (clojure.core/str v5279))))
   (clojure.core/let
    [v5279
     (:recipient-dsn-fields
      m5278
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5279 :com.palletops.awaze.client-builder/undef)
     (.
      bean5277
      setRecipientDsnFields
      (simpleemail/recipient-dsn-fields v5279))))
   bean5277))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.ReceiptRule}
receipt-rule
  [m5281]
  (clojure.core/let
   [bean5280
    (new com.amazonaws.services.simpleemail.model.ReceiptRule)]
   (clojure.core/let
    [v5282 (:enabled m5281 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5282 :com.palletops.awaze.client-builder/undef)
     (. bean5280 setEnabled (clojure.core/boolean v5282))))
   (clojure.core/let
    [v5282
     (:tls-policy m5281 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5282 :com.palletops.awaze.client-builder/undef)
     (. bean5280 setTlsPolicy (simpleemail/tls-policy v5282))))
   (clojure.core/let
    [v5282
     (:recipients m5281 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5282 :com.palletops.awaze.client-builder/undef)
     (.
      bean5280
      setRecipients
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5420] (clojure.core/str arg5420))
 v5282))))
   (clojure.core/let
    [v5282 (:actions m5281 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5282 :com.palletops.awaze.client-builder/undef)
     (.
      bean5280
      setActions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5421] (simpleemail/receipt-action arg5421))
 v5282))))
   (clojure.core/let
    [v5282
     (:scan-enabled m5281 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5282 :com.palletops.awaze.client-builder/undef)
     (. bean5280 setScanEnabled (clojure.core/boolean v5282))))
   (clojure.core/let
    [v5282 (:name m5281 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5282 :com.palletops.awaze.client-builder/undef)
     (. bean5280 setName (clojure.core/str v5282))))
   bean5280))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.Message}
message
  [m5284]
  (clojure.core/let
   [bean5283 (new com.amazonaws.services.simpleemail.model.Message)]
   (clojure.core/let
    [v5285 (:subject m5284 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5285 :com.palletops.awaze.client-builder/undef)
     (. bean5283 setSubject (simpleemail/content v5285))))
   (clojure.core/let
    [v5285 (:body m5284 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5285 :com.palletops.awaze.client-builder/undef)
     (. bean5283 setBody (simpleemail/body v5285))))
   bean5283))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.Destination}
destination
  [m5287]
  (clojure.core/let
   [bean5286
    (new com.amazonaws.services.simpleemail.model.Destination)]
   (clojure.core/let
    [v5288
     (:to-addresses m5287 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5288 :com.palletops.awaze.client-builder/undef)
     (.
      bean5286
      setToAddresses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5422] (clojure.core/str arg5422))
 v5288))))
   (clojure.core/let
    [v5288
     (:cc-addresses m5287 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5288 :com.palletops.awaze.client-builder/undef)
     (.
      bean5286
      setCcAddresses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5423] (clojure.core/str arg5423))
 v5288))))
   (clojure.core/let
    [v5288
     (:bcc-addresses m5287 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5288 :com.palletops.awaze.client-builder/undef)
     (.
      bean5286
      setBccAddresses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5424] (clojure.core/str arg5424))
 v5288))))
   bean5286))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.RawMessage}
raw-message
  [m5290]
  (clojure.core/let
   [bean5289
    (new com.amazonaws.services.simpleemail.model.RawMessage)]
   (clojure.core/let
    [v5291 (:data m5290 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5291 :com.palletops.awaze.client-builder/undef)
     (. bean5289 setData (clojure.core/identity v5291))))
   bean5289))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.IdentityType}
identity-type
  [m5293]
  (.
   com.amazonaws.services.simpleemail.model.IdentityType
   fromValue
   (clojure.core/name m5293)))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.ListReceiptRuleSetsRequest}
list-receipt-rule-sets-request
  [m5296]
  (clojure.core/let
   [bean5295
    (new
     com.amazonaws.services.simpleemail.model.ListReceiptRuleSetsRequest)]
   (clojure.core/let
    [v5297
     (:next-token m5296 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5297 :com.palletops.awaze.client-builder/undef)
     (. bean5295 setNextToken (clojure.core/str v5297))))
   bean5295))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.VerifyEmailAddressRequest}
verify-email-address-request
  [m5299]
  (clojure.core/let
   [bean5298
    (new
     com.amazonaws.services.simpleemail.model.VerifyEmailAddressRequest)]
   (clojure.core/let
    [v5300
     (:email-address m5299 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5300 :com.palletops.awaze.client-builder/undef)
     (. bean5298 setEmailAddress (clojure.core/str v5300))))
   bean5298))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.DescribeActiveReceiptRuleSetRequest}
describe-active-receipt-rule-set-request
  [m5302]
  (clojure.core/let
   [bean5301
    (new
     com.amazonaws.services.simpleemail.model.DescribeActiveReceiptRuleSetRequest)]
   bean5301))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.ListReceiptFiltersRequest}
list-receipt-filters-request
  [m5305]
  (clojure.core/let
   [bean5304
    (new
     com.amazonaws.services.simpleemail.model.ListReceiptFiltersRequest)]
   bean5304))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.DeleteIdentityRequest}
delete-identity-request
  [m5308]
  (clojure.core/let
   [bean5307
    (new
     com.amazonaws.services.simpleemail.model.DeleteIdentityRequest)]
   (clojure.core/let
    [v5309
     (:identity m5308 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5309 :com.palletops.awaze.client-builder/undef)
     (. bean5307 setIdentity (clojure.core/str v5309))))
   bean5307))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.VerifyEmailIdentityRequest}
verify-email-identity-request
  [m5311]
  (clojure.core/let
   [bean5310
    (new
     com.amazonaws.services.simpleemail.model.VerifyEmailIdentityRequest)]
   (clojure.core/let
    [v5312
     (:email-address m5311 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5312 :com.palletops.awaze.client-builder/undef)
     (. bean5310 setEmailAddress (clojure.core/str v5312))))
   bean5310))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.ListVerifiedEmailAddressesRequest}
list-verified-email-addresses-request
  [m5314]
  (clojure.core/let
   [bean5313
    (new
     com.amazonaws.services.simpleemail.model.ListVerifiedEmailAddressesRequest)]
   bean5313))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.DescribeReceiptRuleRequest}
describe-receipt-rule-request
  [m5317]
  (clojure.core/let
   [bean5316
    (new
     com.amazonaws.services.simpleemail.model.DescribeReceiptRuleRequest)]
   (clojure.core/let
    [v5318
     (:rule-set-name m5317 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5318 :com.palletops.awaze.client-builder/undef)
     (. bean5316 setRuleSetName (clojure.core/str v5318))))
   (clojure.core/let
    [v5318
     (:rule-name m5317 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5318 :com.palletops.awaze.client-builder/undef)
     (. bean5316 setRuleName (clojure.core/str v5318))))
   bean5316))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.DeleteReceiptFilterRequest}
delete-receipt-filter-request
  [m5320]
  (clojure.core/let
   [bean5319
    (new
     com.amazonaws.services.simpleemail.model.DeleteReceiptFilterRequest)]
   (clojure.core/let
    [v5321
     (:filter-name m5320 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5321 :com.palletops.awaze.client-builder/undef)
     (. bean5319 setFilterName (clojure.core/str v5321))))
   bean5319))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.GetIdentityVerificationAttributesRequest}
get-identity-verification-attributes-request
  [m5323]
  (clojure.core/let
   [bean5322
    (new
     com.amazonaws.services.simpleemail.model.GetIdentityVerificationAttributesRequest)]
   (clojure.core/let
    [v5324
     (:identities m5323 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5324 :com.palletops.awaze.client-builder/undef)
     (.
      bean5322
      setIdentities
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5425] (clojure.core/str arg5425))
 v5324))))
   bean5322))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.GetSendQuotaRequest}
get-send-quota-request
  [m5326]
  (clojure.core/let
   [bean5325
    (new com.amazonaws.services.simpleemail.model.GetSendQuotaRequest)]
   bean5325))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.CreateReceiptRuleSetRequest}
create-receipt-rule-set-request
  [m5329]
  (clojure.core/let
   [bean5328
    (new
     com.amazonaws.services.simpleemail.model.CreateReceiptRuleSetRequest)]
   (clojure.core/let
    [v5330
     (:rule-set-name m5329 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5330 :com.palletops.awaze.client-builder/undef)
     (. bean5328 setRuleSetName (clojure.core/str v5330))))
   bean5328))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.SetIdentityNotificationTopicRequest}
set-identity-notification-topic-request
  [m5332]
  (clojure.core/let
   [bean5331
    (new
     com.amazonaws.services.simpleemail.model.SetIdentityNotificationTopicRequest)]
   (clojure.core/let
    [v5333
     (:identity m5332 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5333 :com.palletops.awaze.client-builder/undef)
     (. bean5331 setIdentity (clojure.core/str v5333))))
   (clojure.core/let
    [v5333
     (:sns-topic m5332 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5333 :com.palletops.awaze.client-builder/undef)
     (. bean5331 setSnsTopic (clojure.core/str v5333))))
   (clojure.core/let
    [v5333
     (:notification-type
      m5332
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5333 :com.palletops.awaze.client-builder/undef)
     (.
      bean5331
      setNotificationType
      (simpleemail/notification-type v5333))))
   bean5331))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.VerifyDomainIdentityRequest}
verify-domain-identity-request
  [m5335]
  (clojure.core/let
   [bean5334
    (new
     com.amazonaws.services.simpleemail.model.VerifyDomainIdentityRequest)]
   (clojure.core/let
    [v5336 (:domain m5335 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5336 :com.palletops.awaze.client-builder/undef)
     (. bean5334 setDomain (clojure.core/str v5336))))
   bean5334))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.ListIdentityPoliciesRequest}
list-identity-policies-request
  [m5338]
  (clojure.core/let
   [bean5337
    (new
     com.amazonaws.services.simpleemail.model.ListIdentityPoliciesRequest)]
   (clojure.core/let
    [v5339
     (:identity m5338 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5339 :com.palletops.awaze.client-builder/undef)
     (. bean5337 setIdentity (clojure.core/str v5339))))
   bean5337))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.CreateReceiptFilterRequest}
create-receipt-filter-request
  [m5341]
  (clojure.core/let
   [bean5340
    (new
     com.amazonaws.services.simpleemail.model.CreateReceiptFilterRequest)]
   (clojure.core/let
    [v5342 (:filter m5341 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5342 :com.palletops.awaze.client-builder/undef)
     (. bean5340 setFilter (simpleemail/receipt-filter v5342))))
   bean5340))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.PutIdentityPolicyRequest}
put-identity-policy-request
  [m5344]
  (clojure.core/let
   [bean5343
    (new
     com.amazonaws.services.simpleemail.model.PutIdentityPolicyRequest)]
   (clojure.core/let
    [v5345 (:policy m5344 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5345 :com.palletops.awaze.client-builder/undef)
     (. bean5343 setPolicy (clojure.core/str v5345))))
   (clojure.core/let
    [v5345
     (:identity m5344 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5345 :com.palletops.awaze.client-builder/undef)
     (. bean5343 setIdentity (clojure.core/str v5345))))
   (clojure.core/let
    [v5345
     (:policy-name m5344 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5345 :com.palletops.awaze.client-builder/undef)
     (. bean5343 setPolicyName (clojure.core/str v5345))))
   bean5343))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.VerifyDomainDkimRequest}
verify-domain-dkim-request
  [m5347]
  (clojure.core/let
   [bean5346
    (new
     com.amazonaws.services.simpleemail.model.VerifyDomainDkimRequest)]
   (clojure.core/let
    [v5348 (:domain m5347 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5348 :com.palletops.awaze.client-builder/undef)
     (. bean5346 setDomain (clojure.core/str v5348))))
   bean5346))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.SetIdentityMailFromDomainRequest}
set-identity-mail-from-domain-request
  [m5350]
  (clojure.core/let
   [bean5349
    (new
     com.amazonaws.services.simpleemail.model.SetIdentityMailFromDomainRequest)]
   (clojure.core/let
    [v5351
     (:identity m5350 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5351 :com.palletops.awaze.client-builder/undef)
     (. bean5349 setIdentity (clojure.core/str v5351))))
   (clojure.core/let
    [v5351
     (:behavior-on-mxfailure
      m5350
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5351 :com.palletops.awaze.client-builder/undef)
     (. bean5349 setBehaviorOnMXFailure (clojure.core/str v5351))))
   (clojure.core/let
    [v5351
     (:mail-from-domain
      m5350
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5351 :com.palletops.awaze.client-builder/undef)
     (. bean5349 setMailFromDomain (clojure.core/str v5351))))
   bean5349))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.GetIdentityNotificationAttributesRequest}
get-identity-notification-attributes-request
  [m5353]
  (clojure.core/let
   [bean5352
    (new
     com.amazonaws.services.simpleemail.model.GetIdentityNotificationAttributesRequest)]
   (clojure.core/let
    [v5354
     (:identities m5353 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5354 :com.palletops.awaze.client-builder/undef)
     (.
      bean5352
      setIdentities
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5426] (clojure.core/str arg5426))
 v5354))))
   bean5352))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.DeleteReceiptRuleRequest}
delete-receipt-rule-request
  [m5356]
  (clojure.core/let
   [bean5355
    (new
     com.amazonaws.services.simpleemail.model.DeleteReceiptRuleRequest)]
   (clojure.core/let
    [v5357
     (:rule-set-name m5356 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5357 :com.palletops.awaze.client-builder/undef)
     (. bean5355 setRuleSetName (clojure.core/str v5357))))
   (clojure.core/let
    [v5357
     (:rule-name m5356 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5357 :com.palletops.awaze.client-builder/undef)
     (. bean5355 setRuleName (clojure.core/str v5357))))
   bean5355))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.ReorderReceiptRuleSetRequest}
reorder-receipt-rule-set-request
  [m5359]
  (clojure.core/let
   [bean5358
    (new
     com.amazonaws.services.simpleemail.model.ReorderReceiptRuleSetRequest)]
   (clojure.core/let
    [v5360
     (:rule-set-name m5359 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5360 :com.palletops.awaze.client-builder/undef)
     (. bean5358 setRuleSetName (clojure.core/str v5360))))
   (clojure.core/let
    [v5360
     (:rule-names m5359 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5360 :com.palletops.awaze.client-builder/undef)
     (.
      bean5358
      setRuleNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5427] (clojure.core/str arg5427))
 v5360))))
   bean5358))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.DeleteReceiptRuleSetRequest}
delete-receipt-rule-set-request
  [m5362]
  (clojure.core/let
   [bean5361
    (new
     com.amazonaws.services.simpleemail.model.DeleteReceiptRuleSetRequest)]
   (clojure.core/let
    [v5363
     (:rule-set-name m5362 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5363 :com.palletops.awaze.client-builder/undef)
     (. bean5361 setRuleSetName (clojure.core/str v5363))))
   bean5361))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.CloneReceiptRuleSetRequest}
clone-receipt-rule-set-request
  [m5365]
  (clojure.core/let
   [bean5364
    (new
     com.amazonaws.services.simpleemail.model.CloneReceiptRuleSetRequest)]
   (clojure.core/let
    [v5366
     (:rule-set-name m5365 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5366 :com.palletops.awaze.client-builder/undef)
     (. bean5364 setRuleSetName (clojure.core/str v5366))))
   (clojure.core/let
    [v5366
     (:original-rule-set-name
      m5365
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5366 :com.palletops.awaze.client-builder/undef)
     (. bean5364 setOriginalRuleSetName (clojure.core/str v5366))))
   bean5364))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.SendBounceRequest}
send-bounce-request
  [m5368]
  (clojure.core/let
   [bean5367
    (new com.amazonaws.services.simpleemail.model.SendBounceRequest)]
   (clojure.core/let
    [v5369
     (:message-dsn m5368 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5369 :com.palletops.awaze.client-builder/undef)
     (. bean5367 setMessageDsn (simpleemail/message-dsn v5369))))
   (clojure.core/let
    [v5369
     (:bounce-sender m5368 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5369 :com.palletops.awaze.client-builder/undef)
     (. bean5367 setBounceSender (clojure.core/str v5369))))
   (clojure.core/let
    [v5369
     (:explanation m5368 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5369 :com.palletops.awaze.client-builder/undef)
     (. bean5367 setExplanation (clojure.core/str v5369))))
   (clojure.core/let
    [v5369
     (:original-message-id
      m5368
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5369 :com.palletops.awaze.client-builder/undef)
     (. bean5367 setOriginalMessageId (clojure.core/str v5369))))
   (clojure.core/let
    [v5369
     (:bounced-recipient-info-list
      m5368
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5369 :com.palletops.awaze.client-builder/undef)
     (.
      bean5367
      setBouncedRecipientInfoList
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg5428]
  (simpleemail/bounced-recipient-info arg5428))
 v5369))))
   (clojure.core/let
    [v5369
     (:bounce-sender-arn
      m5368
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5369 :com.palletops.awaze.client-builder/undef)
     (. bean5367 setBounceSenderArn (clojure.core/str v5369))))
   bean5367))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.DeleteIdentityPolicyRequest}
delete-identity-policy-request
  [m5371]
  (clojure.core/let
   [bean5370
    (new
     com.amazonaws.services.simpleemail.model.DeleteIdentityPolicyRequest)]
   (clojure.core/let
    [v5372
     (:identity m5371 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5372 :com.palletops.awaze.client-builder/undef)
     (. bean5370 setIdentity (clojure.core/str v5372))))
   (clojure.core/let
    [v5372
     (:policy-name m5371 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5372 :com.palletops.awaze.client-builder/undef)
     (. bean5370 setPolicyName (clojure.core/str v5372))))
   bean5370))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.GetSendStatisticsRequest}
get-send-statistics-request
  [m5374]
  (clojure.core/let
   [bean5373
    (new
     com.amazonaws.services.simpleemail.model.GetSendStatisticsRequest)]
   bean5373))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.GetIdentityDkimAttributesRequest}
get-identity-dkim-attributes-request
  [m5377]
  (clojure.core/let
   [bean5376
    (new
     com.amazonaws.services.simpleemail.model.GetIdentityDkimAttributesRequest)]
   (clojure.core/let
    [v5378
     (:identities m5377 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5378 :com.palletops.awaze.client-builder/undef)
     (.
      bean5376
      setIdentities
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5429] (clojure.core/str arg5429))
 v5378))))
   bean5376))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.GetIdentityMailFromDomainAttributesRequest}
get-identity-mail-from-domain-attributes-request
  [m5380]
  (clojure.core/let
   [bean5379
    (new
     com.amazonaws.services.simpleemail.model.GetIdentityMailFromDomainAttributesRequest)]
   (clojure.core/let
    [v5381
     (:identities m5380 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5381 :com.palletops.awaze.client-builder/undef)
     (.
      bean5379
      setIdentities
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5430] (clojure.core/str arg5430))
 v5381))))
   bean5379))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.DeleteVerifiedEmailAddressRequest}
delete-verified-email-address-request
  [m5383]
  (clojure.core/let
   [bean5382
    (new
     com.amazonaws.services.simpleemail.model.DeleteVerifiedEmailAddressRequest)]
   (clojure.core/let
    [v5384
     (:email-address m5383 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5384 :com.palletops.awaze.client-builder/undef)
     (. bean5382 setEmailAddress (clojure.core/str v5384))))
   bean5382))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.CreateReceiptRuleRequest}
create-receipt-rule-request
  [m5386]
  (clojure.core/let
   [bean5385
    (new
     com.amazonaws.services.simpleemail.model.CreateReceiptRuleRequest)]
   (clojure.core/let
    [v5387
     (:rule-set-name m5386 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5387 :com.palletops.awaze.client-builder/undef)
     (. bean5385 setRuleSetName (clojure.core/str v5387))))
   (clojure.core/let
    [v5387 (:rule m5386 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5387 :com.palletops.awaze.client-builder/undef)
     (. bean5385 setRule (simpleemail/receipt-rule v5387))))
   (clojure.core/let
    [v5387 (:after m5386 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5387 :com.palletops.awaze.client-builder/undef)
     (. bean5385 setAfter (clojure.core/str v5387))))
   bean5385))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.DescribeReceiptRuleSetRequest}
describe-receipt-rule-set-request
  [m5389]
  (clojure.core/let
   [bean5388
    (new
     com.amazonaws.services.simpleemail.model.DescribeReceiptRuleSetRequest)]
   (clojure.core/let
    [v5390
     (:rule-set-name m5389 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5390 :com.palletops.awaze.client-builder/undef)
     (. bean5388 setRuleSetName (clojure.core/str v5390))))
   bean5388))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.GetIdentityPoliciesRequest}
get-identity-policies-request
  [m5392]
  (clojure.core/let
   [bean5391
    (new
     com.amazonaws.services.simpleemail.model.GetIdentityPoliciesRequest)]
   (clojure.core/let
    [v5393
     (:identity m5392 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5393 :com.palletops.awaze.client-builder/undef)
     (. bean5391 setIdentity (clojure.core/str v5393))))
   (clojure.core/let
    [v5393
     (:policy-names m5392 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5393 :com.palletops.awaze.client-builder/undef)
     (.
      bean5391
      setPolicyNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5431] (clojure.core/str arg5431))
 v5393))))
   bean5391))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.UpdateReceiptRuleRequest}
update-receipt-rule-request
  [m5395]
  (clojure.core/let
   [bean5394
    (new
     com.amazonaws.services.simpleemail.model.UpdateReceiptRuleRequest)]
   (clojure.core/let
    [v5396
     (:rule-set-name m5395 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5396 :com.palletops.awaze.client-builder/undef)
     (. bean5394 setRuleSetName (clojure.core/str v5396))))
   (clojure.core/let
    [v5396 (:rule m5395 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5396 :com.palletops.awaze.client-builder/undef)
     (. bean5394 setRule (simpleemail/receipt-rule v5396))))
   bean5394))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.SetReceiptRulePositionRequest}
set-receipt-rule-position-request
  [m5398]
  (clojure.core/let
   [bean5397
    (new
     com.amazonaws.services.simpleemail.model.SetReceiptRulePositionRequest)]
   (clojure.core/let
    [v5399
     (:rule-set-name m5398 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5399 :com.palletops.awaze.client-builder/undef)
     (. bean5397 setRuleSetName (clojure.core/str v5399))))
   (clojure.core/let
    [v5399
     (:rule-name m5398 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5399 :com.palletops.awaze.client-builder/undef)
     (. bean5397 setRuleName (clojure.core/str v5399))))
   (clojure.core/let
    [v5399 (:after m5398 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5399 :com.palletops.awaze.client-builder/undef)
     (. bean5397 setAfter (clojure.core/str v5399))))
   bean5397))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.SetIdentityDkimEnabledRequest}
set-identity-dkim-enabled-request
  [m5401]
  (clojure.core/let
   [bean5400
    (new
     com.amazonaws.services.simpleemail.model.SetIdentityDkimEnabledRequest)]
   (clojure.core/let
    [v5402
     (:identity m5401 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5402 :com.palletops.awaze.client-builder/undef)
     (. bean5400 setIdentity (clojure.core/str v5402))))
   (clojure.core/let
    [v5402
     (:dkim-enabled m5401 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5402 :com.palletops.awaze.client-builder/undef)
     (. bean5400 setDkimEnabled (clojure.core/boolean v5402))))
   bean5400))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.SendEmailRequest}
send-email-request
  [m5404]
  (clojure.core/let
   [bean5403
    (new com.amazonaws.services.simpleemail.model.SendEmailRequest)]
   (clojure.core/let
    [v5405 (:message m5404 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5405 :com.palletops.awaze.client-builder/undef)
     (. bean5403 setMessage (simpleemail/message v5405))))
   (clojure.core/let
    [v5405 (:source m5404 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5405 :com.palletops.awaze.client-builder/undef)
     (. bean5403 setSource (clojure.core/str v5405))))
   (clojure.core/let
    [v5405
     (:source-arn m5404 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5405 :com.palletops.awaze.client-builder/undef)
     (. bean5403 setSourceArn (clojure.core/str v5405))))
   (clojure.core/let
    [v5405
     (:return-path-arn
      m5404
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5405 :com.palletops.awaze.client-builder/undef)
     (. bean5403 setReturnPathArn (clojure.core/str v5405))))
   (clojure.core/let
    [v5405
     (:destination m5404 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5405 :com.palletops.awaze.client-builder/undef)
     (. bean5403 setDestination (simpleemail/destination v5405))))
   (clojure.core/let
    [v5405
     (:reply-to-addresses
      m5404
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5405 :com.palletops.awaze.client-builder/undef)
     (.
      bean5403
      setReplyToAddresses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5512] (clojure.core/str arg5512))
 v5405))))
   (clojure.core/let
    [v5405
     (:return-path m5404 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5405 :com.palletops.awaze.client-builder/undef)
     (. bean5403 setReturnPath (clojure.core/str v5405))))
   bean5403))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.SetIdentityFeedbackForwardingEnabledRequest}
set-identity-feedback-forwarding-enabled-request
  [m5407]
  (clojure.core/let
   [bean5406
    (new
     com.amazonaws.services.simpleemail.model.SetIdentityFeedbackForwardingEnabledRequest)]
   (clojure.core/let
    [v5408
     (:identity m5407 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5408 :com.palletops.awaze.client-builder/undef)
     (. bean5406 setIdentity (clojure.core/str v5408))))
   (clojure.core/let
    [v5408
     (:forwarding-enabled
      m5407
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5408 :com.palletops.awaze.client-builder/undef)
     (. bean5406 setForwardingEnabled (clojure.core/boolean v5408))))
   bean5406))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.SendRawEmailRequest}
send-raw-email-request
  [m5410]
  (clojure.core/let
   [bean5409
    (new com.amazonaws.services.simpleemail.model.SendRawEmailRequest)]
   (clojure.core/let
    [v5411 (:source m5410 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5411 :com.palletops.awaze.client-builder/undef)
     (. bean5409 setSource (clojure.core/str v5411))))
   (clojure.core/let
    [v5411
     (:raw-message m5410 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5411 :com.palletops.awaze.client-builder/undef)
     (. bean5409 setRawMessage (simpleemail/raw-message v5411))))
   (clojure.core/let
    [v5411
     (:destinations m5410 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5411 :com.palletops.awaze.client-builder/undef)
     (.
      bean5409
      setDestinations
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5513] (clojure.core/str arg5513))
 v5411))))
   (clojure.core/let
    [v5411
     (:from-arn m5410 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5411 :com.palletops.awaze.client-builder/undef)
     (. bean5409 setFromArn (clojure.core/str v5411))))
   (clojure.core/let
    [v5411
     (:source-arn m5410 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5411 :com.palletops.awaze.client-builder/undef)
     (. bean5409 setSourceArn (clojure.core/str v5411))))
   (clojure.core/let
    [v5411
     (:return-path-arn
      m5410
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5411 :com.palletops.awaze.client-builder/undef)
     (. bean5409 setReturnPathArn (clojure.core/str v5411))))
   bean5409))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.SetActiveReceiptRuleSetRequest}
set-active-receipt-rule-set-request
  [m5413]
  (clojure.core/let
   [bean5412
    (new
     com.amazonaws.services.simpleemail.model.SetActiveReceiptRuleSetRequest)]
   (clojure.core/let
    [v5414
     (:rule-set-name m5413 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5414 :com.palletops.awaze.client-builder/undef)
     (. bean5412 setRuleSetName (clojure.core/str v5414))))
   bean5412))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.ListIdentitiesRequest}
list-identities-request
  [m5416]
  (clojure.core/let
   [bean5415
    (new
     com.amazonaws.services.simpleemail.model.ListIdentitiesRequest)]
   (clojure.core/let
    [v5417
     (:next-token m5416 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5417 :com.palletops.awaze.client-builder/undef)
     (. bean5415 setNextToken (clojure.core/str v5417))))
   (clojure.core/let
    [v5417
     (:identity-type m5416 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5417 :com.palletops.awaze.client-builder/undef)
     (. bean5415 setIdentityType (simpleemail/identity-type v5417))))
   (clojure.core/let
    [v5417
     (:max-items m5416 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5417 :com.palletops.awaze.client-builder/undef)
     (. bean5415 setMaxItems (clojure.core/int v5417))))
   bean5415))
 (clojure.core/defmulti
  simpleemail
  (clojure.core/fn
   simpleemail
   [m__1874__auto__]
   (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   simpleemail
   :list-receipt-rule-sets
   [m5432]
   (clojure.core/let
    [credentials5433 (:credentials m5432) args5434 (:args m5432)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5435
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5433)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5435
       listReceiptRuleSets
       (simpleemail/list-receipt-rule-sets-request
        (clojure.core/nth args5434 0)))))))
  (clojure.core/defn
   list-receipt-rule-sets-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for listReceiptRuleSets"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-receipt-rule-sets,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   list-receipt-rule-sets
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call listReceiptRuleSets"}
   [credentials5437 & args5438]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5439
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5437)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5439
      listReceiptRuleSets
      (simpleemail/list-receipt-rule-sets-request
       (clojure.core/nth args5438 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :verify-email-address
   [m5440]
   (clojure.core/let
    [credentials5441 (:credentials m5440) args5442 (:args m5440)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5443
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5441)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5443
       verifyEmailAddress
       (simpleemail/verify-email-address-request
        (clojure.core/nth args5442 0)))))))
  (clojure.core/defn
   verify-email-address-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         email-address
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for verifyEmailAddress"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :verify-email-address,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   verify-email-address
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         email-address
                         clone-source
                         clone-root]}]]),
    :doc "Call verifyEmailAddress"}
   [credentials5445 & args5446]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5447
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5445)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5447
      verifyEmailAddress
      (simpleemail/verify-email-address-request
       (clojure.core/nth args5446 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :describe-active-receipt-rule-set
   [m5448]
   (clojure.core/let
    [credentials5449 (:credentials m5448) args5450 (:args m5448)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5451
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5449)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5451
       describeActiveReceiptRuleSet
       (simpleemail/describe-active-receipt-rule-set-request
        (clojure.core/nth args5450 0)))))))
  (clojure.core/defn
   describe-active-receipt-rule-set-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeActiveReceiptRuleSet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-active-receipt-rule-set,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   describe-active-receipt-rule-set
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeActiveReceiptRuleSet"}
   [credentials5453 & args5454]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5455
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5453)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5455
      describeActiveReceiptRuleSet
      (simpleemail/describe-active-receipt-rule-set-request
       (clojure.core/nth args5454 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :list-receipt-filters
   [m5456]
   (clojure.core/let
    [credentials5457 (:credentials m5456) args5458 (:args m5456)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5459
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5457)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5459
       listReceiptFilters
       (simpleemail/list-receipt-filters-request
        (clojure.core/nth args5458 0)))))))
  (clojure.core/defn
   list-receipt-filters-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listReceiptFilters"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-receipt-filters,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   list-receipt-filters
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listReceiptFilters"}
   [credentials5461 & args5462]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5463
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5461)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5463
      listReceiptFilters
      (simpleemail/list-receipt-filters-request
       (clojure.core/nth args5462 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :delete-identity
   [m5464]
   (clojure.core/let
    [credentials5465 (:credentials m5464) args5466 (:args m5464)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5467
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5465)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5467
       deleteIdentity
       (simpleemail/delete-identity-request
        (clojure.core/nth args5466 0)))))))
  (clojure.core/defn
   delete-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteIdentity"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-identity,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   delete-identity
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteIdentity"}
   [credentials5469 & args5470]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5471
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5469)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5471
      deleteIdentity
      (simpleemail/delete-identity-request
       (clojure.core/nth args5470 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :verify-email-identity
   [m5472]
   (clojure.core/let
    [credentials5473 (:credentials m5472) args5474 (:args m5472)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5475
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5473)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5475
       verifyEmailIdentity
       (simpleemail/verify-email-identity-request
        (clojure.core/nth args5474 0)))))))
  (clojure.core/defn
   verify-email-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         email-address
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for verifyEmailIdentity"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :verify-email-identity,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   verify-email-identity
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         email-address
                         clone-source
                         clone-root]}]]),
    :doc "Call verifyEmailIdentity"}
   [credentials5477 & args5478]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5479
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5477)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5479
      verifyEmailIdentity
      (simpleemail/verify-email-identity-request
       (clojure.core/nth args5478 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :list-verified-email-addresses
   [m5480]
   (clojure.core/let
    [credentials5481 (:credentials m5480) args5482 (:args m5480)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5483
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5481)]
     (clojure.core/case
      (clojure.core/count args5482)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5483
        listVerifiedEmailAddresses))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5483
        listVerifiedEmailAddresses
        (simpleemail/list-verified-email-addresses-request
         (clojure.core/nth args5482 0))))))))
  (clojure.core/defn
   list-verified-email-addresses-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listVerifiedEmailAddresses, listVerifiedEmailAddresses"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-verified-email-addresses,
     :credentials credentials__1842__auto__,
     :client :simpleemail})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-verified-email-addresses,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   list-verified-email-addresses
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listVerifiedEmailAddresses, listVerifiedEmailAddresses"}
   [credentials5485 & args5486]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5487
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5485)]
    (clojure.core/case
     (clojure.core/count args5486)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5487
       listVerifiedEmailAddresses))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5487
       listVerifiedEmailAddresses
       (simpleemail/list-verified-email-addresses-request
        (clojure.core/nth args5486 0))))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :describe-receipt-rule
   [m5488]
   (clojure.core/let
    [credentials5489 (:credentials m5488) args5490 (:args m5488)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5491
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5489)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5491
       describeReceiptRule
       (simpleemail/describe-receipt-rule-request
        (clojure.core/nth args5490 0)))))))
  (clojure.core/defn
   describe-receipt-rule-map
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         rule-name]}]]),
    :doc "Generate map for describeReceiptRule"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-receipt-rule,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   describe-receipt-rule
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         rule-name]}]]),
    :doc "Call describeReceiptRule"}
   [credentials5493 & args5494]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5495
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5493)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5495
      describeReceiptRule
      (simpleemail/describe-receipt-rule-request
       (clojure.core/nth args5494 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :delete-receipt-filter
   [m5496]
   (clojure.core/let
    [credentials5497 (:credentials m5496) args5498 (:args m5496)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5499
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5497)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5499
       deleteReceiptFilter
       (simpleemail/delete-receipt-filter-request
        (clojure.core/nth args5498 0)))))))
  (clojure.core/defn
   delete-receipt-filter-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filter-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteReceiptFilter"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-receipt-filter,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   delete-receipt-filter
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filter-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteReceiptFilter"}
   [credentials5501 & args5502]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5503
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5501)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5503
      deleteReceiptFilter
      (simpleemail/delete-receipt-filter-request
       (clojure.core/nth args5502 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :get-identity-verification-attributes
   [m5504]
   (clojure.core/let
    [credentials5505 (:credentials m5504) args5506 (:args m5504)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5507
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5505)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5507
       getIdentityVerificationAttributes
       (simpleemail/get-identity-verification-attributes-request
        (clojure.core/nth args5506 0)))))))
  (clojure.core/defn
   get-identity-verification-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         identities
                         clone-root]}]]),
    :doc "Generate map for getIdentityVerificationAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-identity-verification-attributes,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   get-identity-verification-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         identities
                         clone-root]}]]),
    :doc "Call getIdentityVerificationAttributes"}
   [credentials5509 & args5510]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5511
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5509)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5511
      getIdentityVerificationAttributes
      (simpleemail/get-identity-verification-attributes-request
       (clojure.core/nth args5510 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :get-send-quota
   [m5514]
   (clojure.core/let
    [credentials5515 (:credentials m5514) args5516 (:args m5514)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5517
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5515)]
     (clojure.core/case
      (clojure.core/count args5516)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5517
        getSendQuota
        (simpleemail/get-send-quota-request
         (clojure.core/nth args5516 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5517
        getSendQuota))))))
  (clojure.core/defn
   get-send-quota-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for getSendQuota, getSendQuota"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-send-quota,
     :credentials credentials__1842__auto__,
     :client :simpleemail})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-send-quota,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   get-send-quota
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call getSendQuota, getSendQuota"}
   [credentials5519 & args5520]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5521
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5519)]
    (clojure.core/case
     (clojure.core/count args5520)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5521
       getSendQuota
       (simpleemail/get-send-quota-request
        (clojure.core/nth args5520 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5521
       getSendQuota))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :create-receipt-rule-set
   [m5522]
   (clojure.core/let
    [credentials5523 (:credentials m5522) args5524 (:args m5522)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5525
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5523)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5525
       createReceiptRuleSet
       (simpleemail/create-receipt-rule-set-request
        (clojure.core/nth args5524 0)))))))
  (clojure.core/defn
   create-receipt-rule-set-map
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createReceiptRuleSet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-receipt-rule-set,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   create-receipt-rule-set
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createReceiptRuleSet"}
   [credentials5527 & args5528]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5529
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5527)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5529
      createReceiptRuleSet
      (simpleemail/create-receipt-rule-set-request
       (clojure.core/nth args5528 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :set-identity-notification-topic
   [m5530]
   (clojure.core/let
    [credentials5531 (:credentials m5530) args5532 (:args m5530)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5533
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5531)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5533
       setIdentityNotificationTopic
       (simpleemail/set-identity-notification-topic-request
        (clojure.core/nth args5532 0)))))))
  (clojure.core/defn
   set-identity-notification-topic-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         sns-topic
                         notification-type
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setIdentityNotificationTopic"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-identity-notification-topic,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   set-identity-notification-topic
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         sns-topic
                         notification-type
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call setIdentityNotificationTopic"}
   [credentials5535 & args5536]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5537
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5535)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5537
      setIdentityNotificationTopic
      (simpleemail/set-identity-notification-topic-request
       (clojure.core/nth args5536 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :verify-domain-identity
   [m5538]
   (clojure.core/let
    [credentials5539 (:credentials m5538) args5540 (:args m5538)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5541
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5539)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5541
       verifyDomainIdentity
       (simpleemail/verify-domain-identity-request
        (clojure.core/nth args5540 0)))))))
  (clojure.core/defn
   verify-domain-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         domain
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for verifyDomainIdentity"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :verify-domain-identity,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   verify-domain-identity
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         domain
                         clone-source
                         clone-root]}]]),
    :doc "Call verifyDomainIdentity"}
   [credentials5543 & args5544]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5545
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5543)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5545
      verifyDomainIdentity
      (simpleemail/verify-domain-identity-request
       (clojure.core/nth args5544 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :list-identity-policies
   [m5546]
   (clojure.core/let
    [credentials5547 (:credentials m5546) args5548 (:args m5546)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5549
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5547)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5549
       listIdentityPolicies
       (simpleemail/list-identity-policies-request
        (clojure.core/nth args5548 0)))))))
  (clojure.core/defn
   list-identity-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listIdentityPolicies"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-identity-policies,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   list-identity-policies
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listIdentityPolicies"}
   [credentials5551 & args5552]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5553
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5551)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5553
      listIdentityPolicies
      (simpleemail/list-identity-policies-request
       (clojure.core/nth args5552 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :create-receipt-filter
   [m5554]
   (clojure.core/let
    [credentials5555 (:credentials m5554) args5556 (:args m5554)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5557
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5555)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5557
       createReceiptFilter
       (simpleemail/create-receipt-filter-request
        (clojure.core/nth args5556 0)))))))
  (clojure.core/defn
   create-receipt-filter-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         filter
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createReceiptFilter"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-receipt-filter,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   create-receipt-filter
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         filter
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createReceiptFilter"}
   [credentials5559 & args5560]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5561
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5559)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5561
      createReceiptFilter
      (simpleemail/create-receipt-filter-request
       (clojure.core/nth args5560 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :put-identity-policy
   [m5562]
   (clojure.core/let
    [credentials5563 (:credentials m5562) args5564 (:args m5562)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5565
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5563)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5565
       putIdentityPolicy
       (simpleemail/put-identity-policy-request
        (clojure.core/nth args5564 0)))))))
  (clojure.core/defn
   put-identity-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         policy
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for putIdentityPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :put-identity-policy,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   put-identity-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         policy
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call putIdentityPolicy"}
   [credentials5567 & args5568]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5569
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5567)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5569
      putIdentityPolicy
      (simpleemail/put-identity-policy-request
       (clojure.core/nth args5568 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :verify-domain-dkim
   [m5570]
   (clojure.core/let
    [credentials5571 (:credentials m5570) args5572 (:args m5570)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5573
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5571)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5573
       verifyDomainDkim
       (simpleemail/verify-domain-dkim-request
        (clojure.core/nth args5572 0)))))))
  (clojure.core/defn
   verify-domain-dkim-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         domain
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for verifyDomainDkim"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :verify-domain-dkim,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   verify-domain-dkim
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         domain
                         clone-source
                         clone-root]}]]),
    :doc "Call verifyDomainDkim"}
   [credentials5575 & args5576]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5577
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5575)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5577
      verifyDomainDkim
      (simpleemail/verify-domain-dkim-request
       (clojure.core/nth args5576 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :set-identity-mail-from-domain
   [m5578]
   (clojure.core/let
    [credentials5579 (:credentials m5578) args5580 (:args m5578)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5581
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5579)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5581
       setIdentityMailFromDomain
       (simpleemail/set-identity-mail-from-domain-request
        (clojure.core/nth args5580 0)))))))
  (clojure.core/defn
   set-identity-mail-from-domain-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         behavior-on-mxfailure
                         clone-root
                         mail-from-domain]}]]),
    :doc "Generate map for setIdentityMailFromDomain"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-identity-mail-from-domain,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   set-identity-mail-from-domain
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         behavior-on-mxfailure
                         clone-root
                         mail-from-domain]}]]),
    :doc "Call setIdentityMailFromDomain"}
   [credentials5583 & args5584]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5585
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5583)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5585
      setIdentityMailFromDomain
      (simpleemail/set-identity-mail-from-domain-request
       (clojure.core/nth args5584 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :get-identity-notification-attributes
   [m5586]
   (clojure.core/let
    [credentials5587 (:credentials m5586) args5588 (:args m5586)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5589
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5587)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5589
       getIdentityNotificationAttributes
       (simpleemail/get-identity-notification-attributes-request
        (clojure.core/nth args5588 0)))))))
  (clojure.core/defn
   get-identity-notification-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         identities
                         clone-root]}]]),
    :doc "Generate map for getIdentityNotificationAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-identity-notification-attributes,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   get-identity-notification-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         identities
                         clone-root]}]]),
    :doc "Call getIdentityNotificationAttributes"}
   [credentials5591 & args5592]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5593
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5591)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5593
      getIdentityNotificationAttributes
      (simpleemail/get-identity-notification-attributes-request
       (clojure.core/nth args5592 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :delete-receipt-rule
   [m5594]
   (clojure.core/let
    [credentials5595 (:credentials m5594) args5596 (:args m5594)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5597
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5595)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5597
       deleteReceiptRule
       (simpleemail/delete-receipt-rule-request
        (clojure.core/nth args5596 0)))))))
  (clojure.core/defn
   delete-receipt-rule-map
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         rule-name]}]]),
    :doc "Generate map for deleteReceiptRule"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-receipt-rule,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   delete-receipt-rule
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         rule-name]}]]),
    :doc "Call deleteReceiptRule"}
   [credentials5599 & args5600]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5601
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5599)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5601
      deleteReceiptRule
      (simpleemail/delete-receipt-rule-request
       (clojure.core/nth args5600 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :reorder-receipt-rule-set
   [m5602]
   (clojure.core/let
    [credentials5603 (:credentials m5602) args5604 (:args m5602)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5605
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5603)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5605
       reorderReceiptRuleSet
       (simpleemail/reorder-receipt-rule-set-request
        (clojure.core/nth args5604 0)))))))
  (clojure.core/defn
   reorder-receipt-rule-set-map
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         rule-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for reorderReceiptRuleSet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :reorder-receipt-rule-set,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   reorder-receipt-rule-set
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         rule-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call reorderReceiptRuleSet"}
   [credentials5607 & args5608]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5609
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5607)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5609
      reorderReceiptRuleSet
      (simpleemail/reorder-receipt-rule-set-request
       (clojure.core/nth args5608 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :delete-receipt-rule-set
   [m5610]
   (clojure.core/let
    [credentials5611 (:credentials m5610) args5612 (:args m5610)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5613
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5611)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5613
       deleteReceiptRuleSet
       (simpleemail/delete-receipt-rule-set-request
        (clojure.core/nth args5612 0)))))))
  (clojure.core/defn
   delete-receipt-rule-set-map
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteReceiptRuleSet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-receipt-rule-set,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   delete-receipt-rule-set
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteReceiptRuleSet"}
   [credentials5615 & args5616]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5617
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5615)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5617
      deleteReceiptRuleSet
      (simpleemail/delete-receipt-rule-set-request
       (clojure.core/nth args5616 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :clone-receipt-rule-set
   [m5618]
   (clojure.core/let
    [credentials5619 (:credentials m5618) args5620 (:args m5618)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5621
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5619)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5621
       cloneReceiptRuleSet
       (simpleemail/clone-receipt-rule-set-request
        (clojure.core/nth args5620 0)))))))
  (clojure.core/defn
   clone-receipt-rule-set-map
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         original-rule-set-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for cloneReceiptRuleSet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :clone-receipt-rule-set,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   clone-receipt-rule-set
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         original-rule-set-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call cloneReceiptRuleSet"}
   [credentials5623 & args5624]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5625
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5623)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5625
      cloneReceiptRuleSet
      (simpleemail/clone-receipt-rule-set-request
       (clojure.core/nth args5624 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :send-bounce
   [m5626]
   (clojure.core/let
    [credentials5627 (:credentials m5626) args5628 (:args m5626)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5629
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5627)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5629
       sendBounce
       (simpleemail/send-bounce-request (clojure.core/nth args5628 0)))))))
  (clojure.core/defn
   send-bounce-map
   {:arglists (quote
               [[credentials
                 {:keys [explanation
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         bounce-sender
                         read-limit
                         bounced-recipient-info-list
                         general-progress-listener
                         message-dsn
                         original-message-id
                         clone-source
                         clone-root
                         bounce-sender-arn]}]]),
    :doc "Generate map for sendBounce"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :send-bounce,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   send-bounce
   {:arglists (quote
               [[credentials
                 {:keys [explanation
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         bounce-sender
                         read-limit
                         bounced-recipient-info-list
                         general-progress-listener
                         message-dsn
                         original-message-id
                         clone-source
                         clone-root
                         bounce-sender-arn]}]]),
    :doc "Call sendBounce"}
   [credentials5631 & args5632]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5633
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5631)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5633
      sendBounce
      (simpleemail/send-bounce-request (clojure.core/nth args5632 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :delete-identity-policy
   [m5634]
   (clojure.core/let
    [credentials5635 (:credentials m5634) args5636 (:args m5634)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5637
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5635)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5637
       deleteIdentityPolicy
       (simpleemail/delete-identity-policy-request
        (clojure.core/nth args5636 0)))))))
  (clojure.core/defn
   delete-identity-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteIdentityPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-identity-policy,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   delete-identity-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteIdentityPolicy"}
   [credentials5639 & args5640]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5641
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5639)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5641
      deleteIdentityPolicy
      (simpleemail/delete-identity-policy-request
       (clojure.core/nth args5640 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :get-send-statistics
   [m5642]
   (clojure.core/let
    [credentials5643 (:credentials m5642) args5644 (:args m5642)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5645
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5643)]
     (clojure.core/case
      (clojure.core/count args5644)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5645
        getSendStatistics))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5645
        getSendStatistics
        (simpleemail/get-send-statistics-request
         (clojure.core/nth args5644 0))))))))
  (clojure.core/defn
   get-send-statistics-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getSendStatistics, getSendStatistics"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-send-statistics,
     :credentials credentials__1842__auto__,
     :client :simpleemail})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-send-statistics,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   get-send-statistics
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getSendStatistics, getSendStatistics"}
   [credentials5647 & args5648]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5649
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5647)]
    (clojure.core/case
     (clojure.core/count args5648)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5649
       getSendStatistics))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5649
       getSendStatistics
       (simpleemail/get-send-statistics-request
        (clojure.core/nth args5648 0))))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :get-identity-dkim-attributes
   [m5650]
   (clojure.core/let
    [credentials5651 (:credentials m5650) args5652 (:args m5650)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5653
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5651)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5653
       getIdentityDkimAttributes
       (simpleemail/get-identity-dkim-attributes-request
        (clojure.core/nth args5652 0)))))))
  (clojure.core/defn
   get-identity-dkim-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         identities
                         clone-root]}]]),
    :doc "Generate map for getIdentityDkimAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-identity-dkim-attributes,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   get-identity-dkim-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         identities
                         clone-root]}]]),
    :doc "Call getIdentityDkimAttributes"}
   [credentials5655 & args5656]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5657
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5655)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5657
      getIdentityDkimAttributes
      (simpleemail/get-identity-dkim-attributes-request
       (clojure.core/nth args5656 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :get-identity-mail-from-domain-attributes
   [m5658]
   (clojure.core/let
    [credentials5659 (:credentials m5658) args5660 (:args m5658)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5661
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5659)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5661
       getIdentityMailFromDomainAttributes
       (simpleemail/get-identity-mail-from-domain-attributes-request
        (clojure.core/nth args5660 0)))))))
  (clojure.core/defn
   get-identity-mail-from-domain-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         identities
                         clone-root]}]]),
    :doc "Generate map for getIdentityMailFromDomainAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-identity-mail-from-domain-attributes,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   get-identity-mail-from-domain-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         identities
                         clone-root]}]]),
    :doc "Call getIdentityMailFromDomainAttributes"}
   [credentials5663 & args5664]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5665
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5663)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5665
      getIdentityMailFromDomainAttributes
      (simpleemail/get-identity-mail-from-domain-attributes-request
       (clojure.core/nth args5664 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :delete-verified-email-address
   [m5666]
   (clojure.core/let
    [credentials5667 (:credentials m5666) args5668 (:args m5666)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5669
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5667)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5669
       deleteVerifiedEmailAddress
       (simpleemail/delete-verified-email-address-request
        (clojure.core/nth args5668 0)))))))
  (clojure.core/defn
   delete-verified-email-address-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         email-address
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteVerifiedEmailAddress"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-verified-email-address,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   delete-verified-email-address
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         email-address
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteVerifiedEmailAddress"}
   [credentials5671 & args5672]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5673
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5671)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5673
      deleteVerifiedEmailAddress
      (simpleemail/delete-verified-email-address-request
       (clojure.core/nth args5672 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :create-receipt-rule
   [m5674]
   (clojure.core/let
    [credentials5675 (:credentials m5674) args5676 (:args m5674)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5677
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5675)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5677
       createReceiptRule
       (simpleemail/create-receipt-rule-request
        (clojure.core/nth args5676 0)))))))
  (clojure.core/defn
   create-receipt-rule-map
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         rule
                         custom-query-parameters
                         after
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createReceiptRule"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-receipt-rule,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   create-receipt-rule
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         rule
                         custom-query-parameters
                         after
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createReceiptRule"}
   [credentials5679 & args5680]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5681
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5679)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5681
      createReceiptRule
      (simpleemail/create-receipt-rule-request
       (clojure.core/nth args5680 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :describe-receipt-rule-set
   [m5682]
   (clojure.core/let
    [credentials5683 (:credentials m5682) args5684 (:args m5682)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5685
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5683)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5685
       describeReceiptRuleSet
       (simpleemail/describe-receipt-rule-set-request
        (clojure.core/nth args5684 0)))))))
  (clojure.core/defn
   describe-receipt-rule-set-map
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeReceiptRuleSet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-receipt-rule-set,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   describe-receipt-rule-set
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeReceiptRuleSet"}
   [credentials5687 & args5688]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5689
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5687)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5689
      describeReceiptRuleSet
      (simpleemail/describe-receipt-rule-set-request
       (clojure.core/nth args5688 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :get-identity-policies
   [m5690]
   (clojure.core/let
    [credentials5691 (:credentials m5690) args5692 (:args m5690)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5693
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5691)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5693
       getIdentityPolicies
       (simpleemail/get-identity-policies-request
        (clojure.core/nth args5692 0)))))))
  (clojure.core/defn
   get-identity-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getIdentityPolicies"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-identity-policies,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   get-identity-policies
   {:arglists (quote
               [[credentials
                 {:keys [policy-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getIdentityPolicies"}
   [credentials5695 & args5696]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5697
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5695)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5697
      getIdentityPolicies
      (simpleemail/get-identity-policies-request
       (clojure.core/nth args5696 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :update-receipt-rule
   [m5698]
   (clojure.core/let
    [credentials5699 (:credentials m5698) args5700 (:args m5698)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5701
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5699)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5701
       updateReceiptRule
       (simpleemail/update-receipt-rule-request
        (clojure.core/nth args5700 0)))))))
  (clojure.core/defn
   update-receipt-rule-map
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         rule
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateReceiptRule"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-receipt-rule,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   update-receipt-rule
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         rule
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateReceiptRule"}
   [credentials5703 & args5704]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5705
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5703)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5705
      updateReceiptRule
      (simpleemail/update-receipt-rule-request
       (clojure.core/nth args5704 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :set-receipt-rule-position
   [m5706]
   (clojure.core/let
    [credentials5707 (:credentials m5706) args5708 (:args m5706)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5709
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5707)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5709
       setReceiptRulePosition
       (simpleemail/set-receipt-rule-position-request
        (clojure.core/nth args5708 0)))))))
  (clojure.core/defn
   set-receipt-rule-position-map
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         after
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         rule-name]}]]),
    :doc "Generate map for setReceiptRulePosition"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-receipt-rule-position,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   set-receipt-rule-position
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         after
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         rule-name]}]]),
    :doc "Call setReceiptRulePosition"}
   [credentials5711 & args5712]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5713
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5711)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5713
      setReceiptRulePosition
      (simpleemail/set-receipt-rule-position-request
       (clojure.core/nth args5712 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :set-identity-dkim-enabled
   [m5714]
   (clojure.core/let
    [credentials5715 (:credentials m5714) args5716 (:args m5714)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5717
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5715)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5717
       setIdentityDkimEnabled
       (simpleemail/set-identity-dkim-enabled-request
        (clojure.core/nth args5716 0)))))))
  (clojure.core/defn
   set-identity-dkim-enabled-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         dkim-enabled
                         clone-root]}]]),
    :doc "Generate map for setIdentityDkimEnabled"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-identity-dkim-enabled,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   set-identity-dkim-enabled
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         dkim-enabled
                         clone-root]}]]),
    :doc "Call setIdentityDkimEnabled"}
   [credentials5719 & args5720]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5721
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5719)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5721
      setIdentityDkimEnabled
      (simpleemail/set-identity-dkim-enabled-request
       (clojure.core/nth args5720 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :send-email
   [m5722]
   (clojure.core/let
    [credentials5723 (:credentials m5722) args5724 (:args m5722)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5725
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5723)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5725
       sendEmail
       (simpleemail/send-email-request (clojure.core/nth args5724 0)))))))
  (clojure.core/defn
   send-email-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         source
                         read-limit
                         reply-to-addresses
                         source-arn
                         general-progress-listener
                         return-path-arn
                         clone-source
                         clone-root
                         destination
                         return-path
                         message]}]]),
    :doc "Generate map for sendEmail"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :send-email,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   send-email
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         source
                         read-limit
                         reply-to-addresses
                         source-arn
                         general-progress-listener
                         return-path-arn
                         clone-source
                         clone-root
                         destination
                         return-path
                         message]}]]),
    :doc "Call sendEmail"}
   [credentials5727 & args5728]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5729
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5727)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5729
      sendEmail
      (simpleemail/send-email-request (clojure.core/nth args5728 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :set-identity-feedback-forwarding-enabled
   [m5730]
   (clojure.core/let
    [credentials5731 (:credentials m5730) args5732 (:args m5730)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5733
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5731)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5733
       setIdentityFeedbackForwardingEnabled
       (simpleemail/set-identity-feedback-forwarding-enabled-request
        (clojure.core/nth args5732 0)))))))
  (clojure.core/defn
   set-identity-feedback-forwarding-enabled-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         forwarding-enabled
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setIdentityFeedbackForwardingEnabled"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-identity-feedback-forwarding-enabled,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   set-identity-feedback-forwarding-enabled
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         forwarding-enabled
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call setIdentityFeedbackForwardingEnabled"}
   [credentials5735 & args5736]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5737
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5735)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5737
      setIdentityFeedbackForwardingEnabled
      (simpleemail/set-identity-feedback-forwarding-enabled-request
       (clojure.core/nth args5736 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :send-raw-email
   [m5738]
   (clojure.core/let
    [credentials5739 (:credentials m5738) args5740 (:args m5738)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5741
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5739)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5741
       sendRawEmail
       (simpleemail/send-raw-email-request
        (clojure.core/nth args5740 0)))))))
  (clojure.core/defn
   send-raw-email-map
   {:arglists (quote
               [[credentials
                 {:keys [destinations
                         custom-request-headers
                         sdk-client-execution-timeout
                         from-arn
                         sdk-request-timeout
                         custom-query-parameters
                         source
                         read-limit
                         source-arn
                         general-progress-listener
                         return-path-arn
                         clone-source
                         raw-message
                         clone-root]}]]),
    :doc "Generate map for sendRawEmail"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :send-raw-email,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   send-raw-email
   {:arglists (quote
               [[credentials
                 {:keys [destinations
                         custom-request-headers
                         sdk-client-execution-timeout
                         from-arn
                         sdk-request-timeout
                         custom-query-parameters
                         source
                         read-limit
                         source-arn
                         general-progress-listener
                         return-path-arn
                         clone-source
                         raw-message
                         clone-root]}]]),
    :doc "Call sendRawEmail"}
   [credentials5743 & args5744]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5745
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5743)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5745
      sendRawEmail
      (simpleemail/send-raw-email-request
       (clojure.core/nth args5744 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :set-active-receipt-rule-set
   [m5746]
   (clojure.core/let
    [credentials5747 (:credentials m5746) args5748 (:args m5746)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5749
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5747)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5749
       setActiveReceiptRuleSet
       (simpleemail/set-active-receipt-rule-set-request
        (clojure.core/nth args5748 0)))))))
  (clojure.core/defn
   set-active-receipt-rule-set-map
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setActiveReceiptRuleSet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-active-receipt-rule-set,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   set-active-receipt-rule-set
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call setActiveReceiptRuleSet"}
   [credentials5751 & args5752]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5753
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5751)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5753
      setActiveReceiptRuleSet
      (simpleemail/set-active-receipt-rule-set-request
       (clojure.core/nth args5752 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :list-identities
   [m5754]
   (clojure.core/let
    [credentials5755 (:credentials m5754) args5756 (:args m5754)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5757
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5755)]
     (clojure.core/case
      (clojure.core/count args5756)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5757
        listIdentities
        (simpleemail/list-identities-request
         (clojure.core/nth args5756 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5757
        listIdentities))))))
  (clojure.core/defn
   list-identities-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         identity-type
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for listIdentities, listIdentities"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-identities,
     :credentials credentials__1842__auto__,
     :client :simpleemail})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-identities,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   list-identities
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         identity-type
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call listIdentities, listIdentities"}
   [credentials5759 & args5760]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5761
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5759)]
    (clojure.core/case
     (clojure.core/count args5760)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5761
       listIdentities
       (simpleemail/list-identities-request
        (clojure.core/nth args5760 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5761
       listIdentities)))))))
