(ns
 com.palletops.awaze.simpledb
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.simpledb :as simpledb]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :simpledb
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.simpledb.AmazonSimpleDBClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.ReplaceableAttribute}
replaceable-attribute
  [m8751]
  (clojure.core/let
   [bean8750
    (new com.amazonaws.services.simpledb.model.ReplaceableAttribute)]
   (clojure.core/let
    [v8752 (:replace m8751 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8752 :com.palletops.awaze.client-builder/undef)
     (. bean8750 setReplace (clojure.core/boolean v8752))))
   (clojure.core/let
    [v8752 (:name m8751 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8752 :com.palletops.awaze.client-builder/undef)
     (. bean8750 setName (clojure.core/str v8752))))
   (clojure.core/let
    [v8752 (:value m8751 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8752 :com.palletops.awaze.client-builder/undef)
     (. bean8750 setValue (clojure.core/str v8752))))
   bean8750))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.Attribute}
attribute
  [m8754]
  (clojure.core/let
   [bean8753 (new com.amazonaws.services.simpledb.model.Attribute)]
   (clojure.core/let
    [v8755
     (:alternate-name-encoding
      m8754
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8755 :com.palletops.awaze.client-builder/undef)
     (. bean8753 setAlternateNameEncoding (clojure.core/str v8755))))
   (clojure.core/let
    [v8755
     (:alternate-value-encoding
      m8754
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8755 :com.palletops.awaze.client-builder/undef)
     (. bean8753 setAlternateValueEncoding (clojure.core/str v8755))))
   (clojure.core/let
    [v8755 (:name m8754 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8755 :com.palletops.awaze.client-builder/undef)
     (. bean8753 setName (clojure.core/str v8755))))
   (clojure.core/let
    [v8755 (:value m8754 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8755 :com.palletops.awaze.client-builder/undef)
     (. bean8753 setValue (clojure.core/str v8755))))
   bean8753))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.ReplaceableItem}
replaceable-item
  [m8757]
  (clojure.core/let
   [bean8756
    (new com.amazonaws.services.simpledb.model.ReplaceableItem)]
   (clojure.core/let
    [v8758
     (:attributes m8757 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8758 :com.palletops.awaze.client-builder/undef)
     (.
      bean8756
      setAttributes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8795] (simpledb/replaceable-attribute arg8795))
 v8758))))
   (clojure.core/let
    [v8758 (:name m8757 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8758 :com.palletops.awaze.client-builder/undef)
     (. bean8756 setName (clojure.core/str v8758))))
   bean8756))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.DeletableItem}
deletable-item
  [m8760]
  (clojure.core/let
   [bean8759
    (new com.amazonaws.services.simpledb.model.DeletableItem)]
   (clojure.core/let
    [v8761
     (:attributes m8760 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8761 :com.palletops.awaze.client-builder/undef)
     (.
      bean8759
      setAttributes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8796] (simpledb/attribute arg8796))
 v8761))))
   (clojure.core/let
    [v8761 (:name m8760 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8761 :com.palletops.awaze.client-builder/undef)
     (. bean8759 setName (clojure.core/str v8761))))
   bean8759))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.UpdateCondition}
update-condition
  [m8763]
  (clojure.core/let
   [bean8762
    (new com.amazonaws.services.simpledb.model.UpdateCondition)]
   (clojure.core/let
    [v8764 (:exists m8763 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8764 :com.palletops.awaze.client-builder/undef)
     (. bean8762 setExists (clojure.core/boolean v8764))))
   (clojure.core/let
    [v8764 (:name m8763 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8764 :com.palletops.awaze.client-builder/undef)
     (. bean8762 setName (clojure.core/str v8764))))
   (clojure.core/let
    [v8764 (:value m8763 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8764 :com.palletops.awaze.client-builder/undef)
     (. bean8762 setValue (clojure.core/str v8764))))
   bean8762))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.ListDomainsRequest}
list-domains-request
  [m8766]
  (clojure.core/let
   [bean8765
    (new com.amazonaws.services.simpledb.model.ListDomainsRequest)]
   (clojure.core/let
    [v8767
     (:max-number-of-domains
      m8766
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8767 :com.palletops.awaze.client-builder/undef)
     (. bean8765 setMaxNumberOfDomains (clojure.core/int v8767))))
   (clojure.core/let
    [v8767
     (:next-token m8766 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8767 :com.palletops.awaze.client-builder/undef)
     (. bean8765 setNextToken (clojure.core/str v8767))))
   bean8765))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.DeleteDomainRequest}
delete-domain-request
  [m8769]
  (clojure.core/let
   [bean8768
    (new com.amazonaws.services.simpledb.model.DeleteDomainRequest)]
   (clojure.core/let
    [v8770
     (:domain-name m8769 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8770 :com.palletops.awaze.client-builder/undef)
     (. bean8768 setDomainName (clojure.core/str v8770))))
   bean8768))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.DomainMetadataRequest}
domain-metadata-request
  [m8772]
  (clojure.core/let
   [bean8771
    (new com.amazonaws.services.simpledb.model.DomainMetadataRequest)]
   (clojure.core/let
    [v8773
     (:domain-name m8772 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8773 :com.palletops.awaze.client-builder/undef)
     (. bean8771 setDomainName (clojure.core/str v8773))))
   bean8771))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.BatchPutAttributesRequest}
batch-put-attributes-request
  [m8775]
  (clojure.core/let
   [bean8774
    (new
     com.amazonaws.services.simpledb.model.BatchPutAttributesRequest)]
   (clojure.core/let
    [v8776 (:items m8775 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8776 :com.palletops.awaze.client-builder/undef)
     (.
      bean8774
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8797] (simpledb/replaceable-item arg8797))
 v8776))))
   (clojure.core/let
    [v8776
     (:domain-name m8775 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8776 :com.palletops.awaze.client-builder/undef)
     (. bean8774 setDomainName (clojure.core/str v8776))))
   bean8774))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.BatchDeleteAttributesRequest}
batch-delete-attributes-request
  [m8778]
  (clojure.core/let
   [bean8777
    (new
     com.amazonaws.services.simpledb.model.BatchDeleteAttributesRequest)]
   (clojure.core/let
    [v8779 (:items m8778 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8779 :com.palletops.awaze.client-builder/undef)
     (.
      bean8777
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8798] (simpledb/deletable-item arg8798))
 v8779))))
   (clojure.core/let
    [v8779
     (:domain-name m8778 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8779 :com.palletops.awaze.client-builder/undef)
     (. bean8777 setDomainName (clojure.core/str v8779))))
   bean8777))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.GetAttributesRequest}
get-attributes-request
  [m8781]
  (clojure.core/let
   [bean8780
    (new com.amazonaws.services.simpledb.model.GetAttributesRequest)]
   (clojure.core/let
    [v8782
     (:item-name m8781 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8782 :com.palletops.awaze.client-builder/undef)
     (. bean8780 setItemName (clojure.core/str v8782))))
   (clojure.core/let
    [v8782
     (:consistent-read
      m8781
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8782 :com.palletops.awaze.client-builder/undef)
     (. bean8780 setConsistentRead (clojure.core/boolean v8782))))
   (clojure.core/let
    [v8782
     (:domain-name m8781 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8782 :com.palletops.awaze.client-builder/undef)
     (. bean8780 setDomainName (clojure.core/str v8782))))
   (clojure.core/let
    [v8782
     (:attribute-names
      m8781
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8782 :com.palletops.awaze.client-builder/undef)
     (.
      bean8780
      setAttributeNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8799] (clojure.core/str arg8799))
 v8782))))
   bean8780))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.PutAttributesRequest}
put-attributes-request
  [m8784]
  (clojure.core/let
   [bean8783
    (new com.amazonaws.services.simpledb.model.PutAttributesRequest)]
   (clojure.core/let
    [v8785
     (:item-name m8784 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8785 :com.palletops.awaze.client-builder/undef)
     (. bean8783 setItemName (clojure.core/str v8785))))
   (clojure.core/let
    [v8785
     (:expected m8784 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8785 :com.palletops.awaze.client-builder/undef)
     (. bean8783 setExpected (simpledb/update-condition v8785))))
   (clojure.core/let
    [v8785
     (:attributes m8784 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8785 :com.palletops.awaze.client-builder/undef)
     (.
      bean8783
      setAttributes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8800] (simpledb/replaceable-attribute arg8800))
 v8785))))
   (clojure.core/let
    [v8785
     (:domain-name m8784 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8785 :com.palletops.awaze.client-builder/undef)
     (. bean8783 setDomainName (clojure.core/str v8785))))
   bean8783))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.DeleteAttributesRequest}
delete-attributes-request
  [m8787]
  (clojure.core/let
   [bean8786
    (new
     com.amazonaws.services.simpledb.model.DeleteAttributesRequest)]
   (clojure.core/let
    [v8788
     (:item-name m8787 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8788 :com.palletops.awaze.client-builder/undef)
     (. bean8786 setItemName (clojure.core/str v8788))))
   (clojure.core/let
    [v8788
     (:expected m8787 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8788 :com.palletops.awaze.client-builder/undef)
     (. bean8786 setExpected (simpledb/update-condition v8788))))
   (clojure.core/let
    [v8788
     (:attributes m8787 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8788 :com.palletops.awaze.client-builder/undef)
     (.
      bean8786
      setAttributes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8801] (simpledb/attribute arg8801))
 v8788))))
   (clojure.core/let
    [v8788
     (:domain-name m8787 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8788 :com.palletops.awaze.client-builder/undef)
     (. bean8786 setDomainName (clojure.core/str v8788))))
   bean8786))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.CreateDomainRequest}
create-domain-request
  [m8790]
  (clojure.core/let
   [bean8789
    (new com.amazonaws.services.simpledb.model.CreateDomainRequest)]
   (clojure.core/let
    [v8791
     (:domain-name m8790 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8791 :com.palletops.awaze.client-builder/undef)
     (. bean8789 setDomainName (clojure.core/str v8791))))
   bean8789))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.SelectRequest}
select-request
  [m8793]
  (clojure.core/let
   [bean8792
    (new com.amazonaws.services.simpledb.model.SelectRequest)]
   (clojure.core/let
    [v8794
     (:select-expression
      m8793
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8794 :com.palletops.awaze.client-builder/undef)
     (. bean8792 setSelectExpression (clojure.core/str v8794))))
   (clojure.core/let
    [v8794
     (:consistent-read
      m8793
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8794 :com.palletops.awaze.client-builder/undef)
     (. bean8792 setConsistentRead (clojure.core/boolean v8794))))
   (clojure.core/let
    [v8794
     (:next-token m8793 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8794 :com.palletops.awaze.client-builder/undef)
     (. bean8792 setNextToken (clojure.core/str v8794))))
   bean8792))
 (clojure.core/defmulti
  simpledb
  (clojure.core/fn simpledb [m__1874__auto__] (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   simpledb
   :list-domains
   [m8802]
   (clojure.core/let
    [credentials8803 (:credentials m8802) args8804 (:args m8802)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client8805
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials8803)]
     (clojure.core/case
      (clojure.core/count args8804)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8805
        listDomains
        (simpledb/list-domains-request (clojure.core/nth args8804 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8805
        listDomains))))))
  (clojure.core/defn
   list-domains-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-number-of-domains
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for listDomains, listDomains"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-domains,
     :credentials credentials__1842__auto__,
     :client :simpledb})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-domains,
     :credentials credentials__1842__auto__,
     :client :simpledb}))
  (clojure.core/defn
   list-domains
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-number-of-domains
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call listDomains, listDomains"}
   [credentials8807 & args8808]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client8809
     (com.palletops.awaze.common/aws-client :simpledb credentials8807)]
    (clojure.core/case
     (clojure.core/count args8808)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8809
       listDomains
       (simpledb/list-domains-request (clojure.core/nth args8808 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8809
       listDomains))))))
 (do
  (clojure.core/defmethod
   simpledb
   :delete-domain
   [m8810]
   (clojure.core/let
    [credentials8811 (:credentials m8810) args8812 (:args m8810)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client8813
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials8811)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8813
       deleteDomain
       (simpledb/delete-domain-request (clojure.core/nth args8812 0)))))))
  (clojure.core/defn
   delete-domain-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteDomain"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-domain,
     :credentials credentials__1842__auto__,
     :client :simpledb}))
  (clojure.core/defn
   delete-domain
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteDomain"}
   [credentials8815 & args8816]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client8817
     (com.palletops.awaze.common/aws-client :simpledb credentials8815)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8817
      deleteDomain
      (simpledb/delete-domain-request (clojure.core/nth args8816 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :domain-metadata
   [m8818]
   (clojure.core/let
    [credentials8819 (:credentials m8818) args8820 (:args m8818)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client8821
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials8819)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8821
       domainMetadata
       (simpledb/domain-metadata-request
        (clojure.core/nth args8820 0)))))))
  (clojure.core/defn
   domain-metadata-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for domainMetadata"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :domain-metadata,
     :credentials credentials__1842__auto__,
     :client :simpledb}))
  (clojure.core/defn
   domain-metadata
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call domainMetadata"}
   [credentials8823 & args8824]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client8825
     (com.palletops.awaze.common/aws-client :simpledb credentials8823)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8825
      domainMetadata
      (simpledb/domain-metadata-request (clojure.core/nth args8824 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :batch-put-attributes
   [m8826]
   (clojure.core/let
    [credentials8827 (:credentials m8826) args8828 (:args m8826)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client8829
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials8827)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8829
       batchPutAttributes
       (simpledb/batch-put-attributes-request
        (clojure.core/nth args8828 0)))))))
  (clojure.core/defn
   batch-put-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         items
                         clone-root]}]]),
    :doc "Generate map for batchPutAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :batch-put-attributes,
     :credentials credentials__1842__auto__,
     :client :simpledb}))
  (clojure.core/defn
   batch-put-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         items
                         clone-root]}]]),
    :doc "Call batchPutAttributes"}
   [credentials8831 & args8832]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client8833
     (com.palletops.awaze.common/aws-client :simpledb credentials8831)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8833
      batchPutAttributes
      (simpledb/batch-put-attributes-request
       (clojure.core/nth args8832 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :batch-delete-attributes
   [m8834]
   (clojure.core/let
    [credentials8835 (:credentials m8834) args8836 (:args m8834)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client8837
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials8835)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8837
       batchDeleteAttributes
       (simpledb/batch-delete-attributes-request
        (clojure.core/nth args8836 0)))))))
  (clojure.core/defn
   batch-delete-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         items
                         clone-root]}]]),
    :doc "Generate map for batchDeleteAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :batch-delete-attributes,
     :credentials credentials__1842__auto__,
     :client :simpledb}))
  (clojure.core/defn
   batch-delete-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         items
                         clone-root]}]]),
    :doc "Call batchDeleteAttributes"}
   [credentials8839 & args8840]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client8841
     (com.palletops.awaze.common/aws-client :simpledb credentials8839)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8841
      batchDeleteAttributes
      (simpledb/batch-delete-attributes-request
       (clojure.core/nth args8840 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :get-attributes
   [m8842]
   (clojure.core/let
    [credentials8843 (:credentials m8842) args8844 (:args m8842)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client8845
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials8843)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8845
       getAttributes
       (simpledb/get-attributes-request (clojure.core/nth args8844 0)))))))
  (clojure.core/defn
   get-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         attribute-names
                         sdk-client-execution-timeout
                         item-name
                         consistent-read
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-attributes,
     :credentials credentials__1842__auto__,
     :client :simpledb}))
  (clojure.core/defn
   get-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         attribute-names
                         sdk-client-execution-timeout
                         item-name
                         consistent-read
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getAttributes"}
   [credentials8847 & args8848]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client8849
     (com.palletops.awaze.common/aws-client :simpledb credentials8847)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8849
      getAttributes
      (simpledb/get-attributes-request (clojure.core/nth args8848 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :put-attributes
   [m8850]
   (clojure.core/let
    [credentials8851 (:credentials m8850) args8852 (:args m8850)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client8853
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials8851)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8853
       putAttributes
       (simpledb/put-attributes-request (clojure.core/nth args8852 0)))))))
  (clojure.core/defn
   put-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         item-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         expected
                         general-progress-listener
                         clone-source
                         attributes
                         clone-root]}]]),
    :doc "Generate map for putAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :put-attributes,
     :credentials credentials__1842__auto__,
     :client :simpledb}))
  (clojure.core/defn
   put-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         item-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         expected
                         general-progress-listener
                         clone-source
                         attributes
                         clone-root]}]]),
    :doc "Call putAttributes"}
   [credentials8855 & args8856]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client8857
     (com.palletops.awaze.common/aws-client :simpledb credentials8855)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8857
      putAttributes
      (simpledb/put-attributes-request (clojure.core/nth args8856 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :delete-attributes
   [m8858]
   (clojure.core/let
    [credentials8859 (:credentials m8858) args8860 (:args m8858)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client8861
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials8859)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8861
       deleteAttributes
       (simpledb/delete-attributes-request
        (clojure.core/nth args8860 0)))))))
  (clojure.core/defn
   delete-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         item-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         expected
                         general-progress-listener
                         clone-source
                         attributes
                         clone-root]}]]),
    :doc "Generate map for deleteAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-attributes,
     :credentials credentials__1842__auto__,
     :client :simpledb}))
  (clojure.core/defn
   delete-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         item-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         expected
                         general-progress-listener
                         clone-source
                         attributes
                         clone-root]}]]),
    :doc "Call deleteAttributes"}
   [credentials8863 & args8864]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client8865
     (com.palletops.awaze.common/aws-client :simpledb credentials8863)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8865
      deleteAttributes
      (simpledb/delete-attributes-request
       (clojure.core/nth args8864 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :create-domain
   [m8866]
   (clojure.core/let
    [credentials8867 (:credentials m8866) args8868 (:args m8866)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client8869
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials8867)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8869
       createDomain
       (simpledb/create-domain-request (clojure.core/nth args8868 0)))))))
  (clojure.core/defn
   create-domain-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createDomain"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-domain,
     :credentials credentials__1842__auto__,
     :client :simpledb}))
  (clojure.core/defn
   create-domain
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createDomain"}
   [credentials8871 & args8872]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client8873
     (com.palletops.awaze.common/aws-client :simpledb credentials8871)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8873
      createDomain
      (simpledb/create-domain-request (clojure.core/nth args8872 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :select
   [m8874]
   (clojure.core/let
    [credentials8875 (:credentials m8874) args8876 (:args m8874)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client8877
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials8875)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8877
       select
       (simpledb/select-request (clojure.core/nth args8876 0)))))))
  (clojure.core/defn
   select-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         consistent-read
                         sdk-request-timeout
                         select-expression
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for select"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :select,
     :credentials credentials__1842__auto__,
     :client :simpledb}))
  (clojure.core/defn
   select
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         consistent-read
                         sdk-request-timeout
                         select-expression
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call select"}
   [credentials8879 & args8880]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client8881
     (com.palletops.awaze.common/aws-client :simpledb credentials8879)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8881
      select
      (simpledb/select-request (clojure.core/nth args8880 0))))))))
