(ns
 com.palletops.awaze.securitytoken
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.securitytoken :as securitytoken]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :securitytoken
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.securitytoken.model.AssumeRoleRequest}
assume-role-request
  [m8447]
  (clojure.core/let
   [bean8446
    (new com.amazonaws.services.securitytoken.model.AssumeRoleRequest)]
   (clojure.core/let
    [v8448 (:policy m8447 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8448 :com.palletops.awaze.client-builder/undef)
     (. bean8446 setPolicy (clojure.core/str v8448))))
   (clojure.core/let
    [v8448
     (:role-arn m8447 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8448 :com.palletops.awaze.client-builder/undef)
     (. bean8446 setRoleArn (clojure.core/str v8448))))
   (clojure.core/let
    [v8448
     (:role-session-name
      m8447
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8448 :com.palletops.awaze.client-builder/undef)
     (. bean8446 setRoleSessionName (clojure.core/str v8448))))
   (clojure.core/let
    [v8448
     (:duration-seconds
      m8447
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8448 :com.palletops.awaze.client-builder/undef)
     (. bean8446 setDurationSeconds (clojure.core/int v8448))))
   (clojure.core/let
    [v8448
     (:external-id m8447 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8448 :com.palletops.awaze.client-builder/undef)
     (. bean8446 setExternalId (clojure.core/str v8448))))
   (clojure.core/let
    [v8448
     (:serial-number m8447 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8448 :com.palletops.awaze.client-builder/undef)
     (. bean8446 setSerialNumber (clojure.core/str v8448))))
   (clojure.core/let
    [v8448
     (:token-code m8447 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8448 :com.palletops.awaze.client-builder/undef)
     (. bean8446 setTokenCode (clojure.core/str v8448))))
   bean8446))
 (clojure.core/defn
^{:tag com.amazonaws.services.securitytoken.model.AssumeRoleWithSAMLRequest}
assume-role-with-samlrequest
  [m8450]
  (clojure.core/let
   [bean8449
    (new
     com.amazonaws.services.securitytoken.model.AssumeRoleWithSAMLRequest)]
   (clojure.core/let
    [v8451 (:policy m8450 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8451 :com.palletops.awaze.client-builder/undef)
     (. bean8449 setPolicy (clojure.core/str v8451))))
   (clojure.core/let
    [v8451
     (:role-arn m8450 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8451 :com.palletops.awaze.client-builder/undef)
     (. bean8449 setRoleArn (clojure.core/str v8451))))
   (clojure.core/let
    [v8451
     (:principal-arn m8450 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8451 :com.palletops.awaze.client-builder/undef)
     (. bean8449 setPrincipalArn (clojure.core/str v8451))))
   (clojure.core/let
    [v8451
     (:samlassertion m8450 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8451 :com.palletops.awaze.client-builder/undef)
     (. bean8449 setSAMLAssertion (clojure.core/str v8451))))
   (clojure.core/let
    [v8451
     (:duration-seconds
      m8450
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8451 :com.palletops.awaze.client-builder/undef)
     (. bean8449 setDurationSeconds (clojure.core/int v8451))))
   bean8449))
 (clojure.core/defn
^{:tag com.amazonaws.services.securitytoken.model.AssumeRoleWithWebIdentityRequest}
assume-role-with-web-identity-request
  [m8453]
  (clojure.core/let
   [bean8452
    (new
     com.amazonaws.services.securitytoken.model.AssumeRoleWithWebIdentityRequest)]
   (clojure.core/let
    [v8454 (:policy m8453 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8454 :com.palletops.awaze.client-builder/undef)
     (. bean8452 setPolicy (clojure.core/str v8454))))
   (clojure.core/let
    [v8454
     (:role-arn m8453 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8454 :com.palletops.awaze.client-builder/undef)
     (. bean8452 setRoleArn (clojure.core/str v8454))))
   (clojure.core/let
    [v8454
     (:web-identity-token
      m8453
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8454 :com.palletops.awaze.client-builder/undef)
     (. bean8452 setWebIdentityToken (clojure.core/str v8454))))
   (clojure.core/let
    [v8454
     (:provider-id m8453 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8454 :com.palletops.awaze.client-builder/undef)
     (. bean8452 setProviderId (clojure.core/str v8454))))
   (clojure.core/let
    [v8454
     (:role-session-name
      m8453
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8454 :com.palletops.awaze.client-builder/undef)
     (. bean8452 setRoleSessionName (clojure.core/str v8454))))
   (clojure.core/let
    [v8454
     (:duration-seconds
      m8453
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8454 :com.palletops.awaze.client-builder/undef)
     (. bean8452 setDurationSeconds (clojure.core/int v8454))))
   bean8452))
 (clojure.core/defn
^{:tag com.amazonaws.services.securitytoken.model.DecodeAuthorizationMessageRequest}
decode-authorization-message-request
  [m8456]
  (clojure.core/let
   [bean8455
    (new
     com.amazonaws.services.securitytoken.model.DecodeAuthorizationMessageRequest)]
   (clojure.core/let
    [v8457
     (:encoded-message
      m8456
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8457 :com.palletops.awaze.client-builder/undef)
     (. bean8455 setEncodedMessage (clojure.core/str v8457))))
   bean8455))
 (clojure.core/defn
^{:tag com.amazonaws.services.securitytoken.model.GetCallerIdentityRequest}
get-caller-identity-request
  [m8459]
  (clojure.core/let
   [bean8458
    (new
     com.amazonaws.services.securitytoken.model.GetCallerIdentityRequest)]
   bean8458))
 (clojure.core/defn
^{:tag com.amazonaws.services.securitytoken.model.GetFederationTokenRequest}
get-federation-token-request
  [m8462]
  (clojure.core/let
   [bean8461
    (new
     com.amazonaws.services.securitytoken.model.GetFederationTokenRequest)]
   (clojure.core/let
    [v8463 (:policy m8462 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8463 :com.palletops.awaze.client-builder/undef)
     (. bean8461 setPolicy (clojure.core/str v8463))))
   (clojure.core/let
    [v8463
     (:duration-seconds
      m8462
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8463 :com.palletops.awaze.client-builder/undef)
     (. bean8461 setDurationSeconds (clojure.core/int v8463))))
   (clojure.core/let
    [v8463 (:name m8462 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8463 :com.palletops.awaze.client-builder/undef)
     (. bean8461 setName (clojure.core/str v8463))))
   bean8461))
 (clojure.core/defn
^{:tag com.amazonaws.services.securitytoken.model.GetSessionTokenRequest}
get-session-token-request
  [m8465]
  (clojure.core/let
   [bean8464
    (new
     com.amazonaws.services.securitytoken.model.GetSessionTokenRequest)]
   (clojure.core/let
    [v8466
     (:duration-seconds
      m8465
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8466 :com.palletops.awaze.client-builder/undef)
     (. bean8464 setDurationSeconds (clojure.core/int v8466))))
   (clojure.core/let
    [v8466
     (:serial-number m8465 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8466 :com.palletops.awaze.client-builder/undef)
     (. bean8464 setSerialNumber (clojure.core/str v8466))))
   (clojure.core/let
    [v8466
     (:token-code m8465 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8466 :com.palletops.awaze.client-builder/undef)
     (. bean8464 setTokenCode (clojure.core/str v8466))))
   bean8464))
 (clojure.core/defmulti
  securitytoken
  (clojure.core/fn
   securitytoken
   [m__1874__auto__]
   (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   securitytoken
   :assume-role
   [m8467]
   (clojure.core/let
    [credentials8468 (:credentials m8467) args8469 (:args m8467)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client8470
      (com.palletops.awaze.common/aws-client
       :securitytoken
       credentials8468)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8470
       assumeRole
       (securitytoken/assume-role-request
        (clojure.core/nth args8469 0)))))))
  (clojure.core/defn
   assume-role-map
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         serial-number
                         custom-request-headers
                         sdk-client-execution-timeout
                         token-code
                         sdk-request-timeout
                         custom-query-parameters
                         policy
                         role-arn
                         external-id
                         read-limit
                         general-progress-listener
                         clone-source
                         role-session-name
                         clone-root]}]]),
    :doc "Generate map for assumeRole"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :assume-role,
     :credentials credentials__1842__auto__,
     :client :securitytoken}))
  (clojure.core/defn
   assume-role
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         serial-number
                         custom-request-headers
                         sdk-client-execution-timeout
                         token-code
                         sdk-request-timeout
                         custom-query-parameters
                         policy
                         role-arn
                         external-id
                         read-limit
                         general-progress-listener
                         clone-source
                         role-session-name
                         clone-root]}]]),
    :doc "Call assumeRole"}
   [credentials8472 & args8473]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client8474
     (com.palletops.awaze.common/aws-client
      :securitytoken
      credentials8472)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8474
      assumeRole
      (securitytoken/assume-role-request
       (clojure.core/nth args8473 0)))))))
 (do
  (clojure.core/defmethod
   securitytoken
   :assume-role-with-saml
   [m8475]
   (clojure.core/let
    [credentials8476 (:credentials m8475) args8477 (:args m8475)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client8478
      (com.palletops.awaze.common/aws-client
       :securitytoken
       credentials8476)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8478
       assumeRoleWithSAML
       (securitytoken/assume-role-with-samlrequest
        (clojure.core/nth args8477 0)))))))
  (clojure.core/defn
   assume-role-with-saml-map
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         custom-request-headers
                         sdk-client-execution-timeout
                         principal-arn
                         sdk-request-timeout
                         custom-query-parameters
                         samlassertion
                         policy
                         role-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for assumeRoleWithSAML"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :assume-role-with-saml,
     :credentials credentials__1842__auto__,
     :client :securitytoken}))
  (clojure.core/defn
   assume-role-with-saml
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         custom-request-headers
                         sdk-client-execution-timeout
                         principal-arn
                         sdk-request-timeout
                         custom-query-parameters
                         samlassertion
                         policy
                         role-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call assumeRoleWithSAML"}
   [credentials8480 & args8481]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client8482
     (com.palletops.awaze.common/aws-client
      :securitytoken
      credentials8480)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8482
      assumeRoleWithSAML
      (securitytoken/assume-role-with-samlrequest
       (clojure.core/nth args8481 0)))))))
 (do
  (clojure.core/defmethod
   securitytoken
   :assume-role-with-web-identity
   [m8483]
   (clojure.core/let
    [credentials8484 (:credentials m8483) args8485 (:args m8483)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client8486
      (com.palletops.awaze.common/aws-client
       :securitytoken
       credentials8484)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8486
       assumeRoleWithWebIdentity
       (securitytoken/assume-role-with-web-identity-request
        (clojure.core/nth args8485 0)))))))
  (clojure.core/defn
   assume-role-with-web-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         custom-request-headers
                         sdk-client-execution-timeout
                         provider-id
                         sdk-request-timeout
                         custom-query-parameters
                         policy
                         role-arn
                         read-limit
                         general-progress-listener
                         web-identity-token
                         clone-source
                         role-session-name
                         clone-root]}]]),
    :doc "Generate map for assumeRoleWithWebIdentity"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :assume-role-with-web-identity,
     :credentials credentials__1842__auto__,
     :client :securitytoken}))
  (clojure.core/defn
   assume-role-with-web-identity
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         custom-request-headers
                         sdk-client-execution-timeout
                         provider-id
                         sdk-request-timeout
                         custom-query-parameters
                         policy
                         role-arn
                         read-limit
                         general-progress-listener
                         web-identity-token
                         clone-source
                         role-session-name
                         clone-root]}]]),
    :doc "Call assumeRoleWithWebIdentity"}
   [credentials8488 & args8489]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client8490
     (com.palletops.awaze.common/aws-client
      :securitytoken
      credentials8488)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8490
      assumeRoleWithWebIdentity
      (securitytoken/assume-role-with-web-identity-request
       (clojure.core/nth args8489 0)))))))
 (do
  (clojure.core/defmethod
   securitytoken
   :decode-authorization-message
   [m8491]
   (clojure.core/let
    [credentials8492 (:credentials m8491) args8493 (:args m8491)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client8494
      (com.palletops.awaze.common/aws-client
       :securitytoken
       credentials8492)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8494
       decodeAuthorizationMessage
       (securitytoken/decode-authorization-message-request
        (clojure.core/nth args8493 0)))))))
  (clojure.core/defn
   decode-authorization-message-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         encoded-message
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for decodeAuthorizationMessage"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :decode-authorization-message,
     :credentials credentials__1842__auto__,
     :client :securitytoken}))
  (clojure.core/defn
   decode-authorization-message
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         encoded-message
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call decodeAuthorizationMessage"}
   [credentials8496 & args8497]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client8498
     (com.palletops.awaze.common/aws-client
      :securitytoken
      credentials8496)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8498
      decodeAuthorizationMessage
      (securitytoken/decode-authorization-message-request
       (clojure.core/nth args8497 0)))))))
 (do
  (clojure.core/defmethod
   securitytoken
   :get-caller-identity
   [m8499]
   (clojure.core/let
    [credentials8500 (:credentials m8499) args8501 (:args m8499)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client8502
      (com.palletops.awaze.common/aws-client
       :securitytoken
       credentials8500)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8502
       getCallerIdentity
       (securitytoken/get-caller-identity-request
        (clojure.core/nth args8501 0)))))))
  (clojure.core/defn
   get-caller-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getCallerIdentity"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-caller-identity,
     :credentials credentials__1842__auto__,
     :client :securitytoken}))
  (clojure.core/defn
   get-caller-identity
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getCallerIdentity"}
   [credentials8504 & args8505]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client8506
     (com.palletops.awaze.common/aws-client
      :securitytoken
      credentials8504)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8506
      getCallerIdentity
      (securitytoken/get-caller-identity-request
       (clojure.core/nth args8505 0)))))))
 (do
  (clojure.core/defmethod
   securitytoken
   :get-federation-token
   [m8507]
   (clojure.core/let
    [credentials8508 (:credentials m8507) args8509 (:args m8507)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client8510
      (com.palletops.awaze.common/aws-client
       :securitytoken
       credentials8508)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8510
       getFederationToken
       (securitytoken/get-federation-token-request
        (clojure.core/nth args8509 0)))))))
  (clojure.core/defn
   get-federation-token-map
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         policy
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getFederationToken"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-federation-token,
     :credentials credentials__1842__auto__,
     :client :securitytoken}))
  (clojure.core/defn
   get-federation-token
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         policy
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getFederationToken"}
   [credentials8512 & args8513]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client8514
     (com.palletops.awaze.common/aws-client
      :securitytoken
      credentials8512)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8514
      getFederationToken
      (securitytoken/get-federation-token-request
       (clojure.core/nth args8513 0)))))))
 (do
  (clojure.core/defmethod
   securitytoken
   :get-session-token
   [m8515]
   (clojure.core/let
    [credentials8516 (:credentials m8515) args8517 (:args m8515)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client8518
      (com.palletops.awaze.common/aws-client
       :securitytoken
       credentials8516)]
     (clojure.core/case
      (clojure.core/count args8517)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8518
        getSessionToken))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8518
        getSessionToken
        (securitytoken/get-session-token-request
         (clojure.core/nth args8517 0))))))))
  (clojure.core/defn
   get-session-token-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [duration-seconds
                         serial-number
                         custom-request-headers
                         sdk-client-execution-timeout
                         token-code
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getSessionToken, getSessionToken"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-session-token,
     :credentials credentials__1842__auto__,
     :client :securitytoken})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-session-token,
     :credentials credentials__1842__auto__,
     :client :securitytoken}))
  (clojure.core/defn
   get-session-token
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [duration-seconds
                         serial-number
                         custom-request-headers
                         sdk-client-execution-timeout
                         token-code
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getSessionToken, getSessionToken"}
   [credentials8520 & args8521]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client8522
     (com.palletops.awaze.common/aws-client
      :securitytoken
      credentials8520)]
    (clojure.core/case
     (clojure.core/count args8521)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8522
       getSessionToken))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8522
       getSessionToken
       (securitytoken/get-session-token-request
        (clojure.core/nth args8521 0)))))))))
