(ns
 com.palletops.awaze.s3
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.s3 :as s3]
  [com.palletops.awaze.beans.root :as root]
  [com.palletops.awaze.beans.metrics :as metrics]
  [com.palletops.awaze.beans.regions :as regions]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :s3
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.s3.AmazonS3Client
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.StorageClass}
storage-class
  [m13260]
  (.
   com.amazonaws.services.s3.model.StorageClass
   fromValue
   (clojure.core/name m13260)))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.CORSRule$AllowedMethods}
corsrule-allowed-methods
  [m13263]
  (.
   com.amazonaws.services.s3.model.CORSRule$AllowedMethods
   fromValue
   (clojure.core/name m13263)))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketLifecycleConfiguration$NoncurrentVersionTransition}
bucket-lifecycle-configuration-noncurrent-version-transition
  [m13266]
  (clojure.core/let
   [bean13265
    (new
     com.amazonaws.services.s3.model.BucketLifecycleConfiguration$NoncurrentVersionTransition)]
   (clojure.core/let
    [v13267
     (:storage-class m13266 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13267 :com.palletops.awaze.client-builder/undef)
     (. bean13265 setStorageClass (s3/storage-class v13267))))
   (clojure.core/let
    [v13267 (:days m13266 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13267 :com.palletops.awaze.client-builder/undef)
     (. bean13265 setDays (clojure.core/int v13267))))
   bean13265))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketLifecycleConfiguration$Transition}
bucket-lifecycle-configuration-transition
  [m13269]
  (clojure.core/let
   [bean13268
    (new
     com.amazonaws.services.s3.model.BucketLifecycleConfiguration$Transition)]
   (clojure.core/let
    [v13270 (:date m13269 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13270 :com.palletops.awaze.client-builder/undef)
     (. bean13268 setDate (com.palletops.awaze.common/to-date v13270))))
   (clojure.core/let
    [v13270
     (:storage-class m13269 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13270 :com.palletops.awaze.client-builder/undef)
     (. bean13268 setStorageClass (s3/storage-class v13270))))
   (clojure.core/let
    [v13270 (:days m13269 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13270 :com.palletops.awaze.client-builder/undef)
     (. bean13268 setDays (clojure.core/int v13270))))
   bean13268))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.AbortIncompleteMultipartUpload}
abort-incomplete-multipart-upload
  [m13272]
  (clojure.core/let
   [bean13271
    (new
     com.amazonaws.services.s3.model.AbortIncompleteMultipartUpload)]
   (clojure.core/let
    [v13273
     (:days-after-initiation
      m13272
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13273 :com.palletops.awaze.client-builder/undef)
     (. bean13271 setDaysAfterInitiation (clojure.core/int v13273))))
   bean13271))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.Owner}
owner
  [m13275]
  (clojure.core/let
   [bean13274 (new com.amazonaws.services.s3.model.Owner)]
   (clojure.core/let
    [v13276
     (:display-name m13275 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13276 :com.palletops.awaze.client-builder/undef)
     (. bean13274 setDisplayName (clojure.core/str v13276))))
   (clojure.core/let
    [v13276 (:id m13275 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13276 :com.palletops.awaze.client-builder/undef)
     (. bean13274 setId (clojure.core/str v13276))))
   bean13274))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ReplicationDestinationConfig}
replication-destination-config
  [m13278]
  (clojure.core/let
   [bean13277
    (new com.amazonaws.services.s3.model.ReplicationDestinationConfig)]
   (clojure.core/let
    [v13279
     (:storage-class m13278 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13279 :com.palletops.awaze.client-builder/undef)
     (. bean13277 setStorageClass (clojure.core/str v13279))))
   (clojure.core/let
    [v13279
     (:bucket-arn m13278 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13279 :com.palletops.awaze.client-builder/undef)
     (. bean13277 setBucketARN (clojure.core/str v13279))))
   bean13277))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.RedirectRule}
redirect-rule
  [m13281]
  (clojure.core/let
   [bean13280 (new com.amazonaws.services.s3.model.RedirectRule)]
   (clojure.core/let
    [v13282
     (:host-name m13281 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13282 :com.palletops.awaze.client-builder/undef)
     (. bean13280 setHostName (clojure.core/str v13282))))
   (clojure.core/let
    [v13282
     (:replace-key-prefix-with
      m13281
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13282 :com.palletops.awaze.client-builder/undef)
     (. bean13280 setReplaceKeyPrefixWith (clojure.core/str v13282))))
   (clojure.core/let
    [v13282
     (:replace-key-with
      m13281
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13282 :com.palletops.awaze.client-builder/undef)
     (. bean13280 setReplaceKeyWith (clojure.core/str v13282))))
   (clojure.core/let
    [v13282
     (:http-redirect-code
      m13281
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13282 :com.palletops.awaze.client-builder/undef)
     (. bean13280 setHttpRedirectCode (clojure.core/str v13282))))
   (clojure.core/let
    [v13282
     (:protocol m13281 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13282 :com.palletops.awaze.client-builder/undef)
     (. bean13280 setProtocol (clojure.core/str v13282))))
   bean13280))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.RoutingRuleCondition}
routing-rule-condition
  [m13284]
  (clojure.core/let
   [bean13283
    (new com.amazonaws.services.s3.model.RoutingRuleCondition)]
   (clojure.core/let
    [v13285
     (:key-prefix-equals
      m13284
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13285 :com.palletops.awaze.client-builder/undef)
     (. bean13283 setKeyPrefixEquals (clojure.core/str v13285))))
   (clojure.core/let
    [v13285
     (:http-error-code-returned-equals
      m13284
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13285 :com.palletops.awaze.client-builder/undef)
     (.
      bean13283
      setHttpErrorCodeReturnedEquals
      (clojure.core/str v13285))))
   bean13283))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.CORSRule}
corsrule
  [m13287]
  (clojure.core/let
   [bean13286 (new com.amazonaws.services.s3.model.CORSRule)]
   (clojure.core/let
    [v13288
     (:allowed-methods
      m13287
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13288 :com.palletops.awaze.client-builder/undef)
     (.
      bean13286
      setAllowedMethods
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13623] (s3/corsrule-allowed-methods arg13623))
 v13288))))
   (clojure.core/let
    [v13288
     (:allowed-origins
      m13287
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13288 :com.palletops.awaze.client-builder/undef)
     (.
      bean13286
      setAllowedOrigins
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13624] (clojure.core/str arg13624))
 v13288))))
   (clojure.core/let
    [v13288
     (:max-age-seconds
      m13287
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13288 :com.palletops.awaze.client-builder/undef)
     (. bean13286 setMaxAgeSeconds (clojure.core/int v13288))))
   (clojure.core/let
    [v13288
     (:exposed-headers
      m13287
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13288 :com.palletops.awaze.client-builder/undef)
     (.
      bean13286
      setExposedHeaders
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13625] (clojure.core/str arg13625))
 v13288))))
   (clojure.core/let
    [v13288
     (:allowed-headers
      m13287
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13288 :com.palletops.awaze.client-builder/undef)
     (.
      bean13286
      setAllowedHeaders
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13626] (clojure.core/str arg13626))
 v13288))))
   (clojure.core/let
    [v13288 (:id m13287 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13288 :com.palletops.awaze.client-builder/undef)
     (. bean13286 setId (clojure.core/str v13288))))
   bean13286))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketLifecycleConfiguration$Rule}
bucket-lifecycle-configuration-rule
  [m13290]
  (clojure.core/let
   [bean13289
    (new
     com.amazonaws.services.s3.model.BucketLifecycleConfiguration$Rule)]
   (clojure.core/let
    [v13291
     (:prefix m13290 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13291 :com.palletops.awaze.client-builder/undef)
     (. bean13289 setPrefix (clojure.core/str v13291))))
   (clojure.core/let
    [v13291
     (:noncurrent-version-transition
      m13290
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13291 :com.palletops.awaze.client-builder/undef)
     (.
      bean13289
      setNoncurrentVersionTransition
      (s3/bucket-lifecycle-configuration-noncurrent-version-transition
       v13291))))
   (clojure.core/let
    [v13291
     (:transitions m13290 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13291 :com.palletops.awaze.client-builder/undef)
     (.
      bean13289
      setTransitions
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg13627]
  (s3/bucket-lifecycle-configuration-transition arg13627))
 v13291))))
   (clojure.core/let
    [v13291
     (:abort-incomplete-multipart-upload
      m13290
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13291 :com.palletops.awaze.client-builder/undef)
     (.
      bean13289
      setAbortIncompleteMultipartUpload
      (s3/abort-incomplete-multipart-upload v13291))))
   (clojure.core/let
    [v13291 (:id m13290 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13291 :com.palletops.awaze.client-builder/undef)
     (. bean13289 setId (clojure.core/str v13291))))
   (clojure.core/let
    [v13291
     (:noncurrent-version-expiration-in-days
      m13290
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13291 :com.palletops.awaze.client-builder/undef)
     (.
      bean13289
      setNoncurrentVersionExpirationInDays
      (clojure.core/int v13291))))
   (clojure.core/let
    [v13291
     (:expiration-in-days
      m13290
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13291 :com.palletops.awaze.client-builder/undef)
     (. bean13289 setExpirationInDays (clojure.core/int v13291))))
   (clojure.core/let
    [v13291
     (:noncurrent-version-transitions
      m13290
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13291 :com.palletops.awaze.client-builder/undef)
     (.
      bean13289
      setNoncurrentVersionTransitions
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg13628]
  (s3/bucket-lifecycle-configuration-noncurrent-version-transition
   arg13628))
 v13291))))
   (clojure.core/let
    [v13291
     (:expiration-date
      m13290
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13291 :com.palletops.awaze.client-builder/undef)
     (.
      bean13289
      setExpirationDate
      (com.palletops.awaze.common/to-date v13291))))
   (clojure.core/let
    [v13291
     (:expired-object-delete-marker
      m13290
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13291 :com.palletops.awaze.client-builder/undef)
     (.
      bean13289
      setExpiredObjectDeleteMarker
      (clojure.core/boolean v13291))))
   (clojure.core/let
    [v13291
     (:transition m13290 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13291 :com.palletops.awaze.client-builder/undef)
     (.
      bean13289
      setTransition
      (s3/bucket-lifecycle-configuration-transition v13291))))
   (clojure.core/let
    [v13291
     (:status m13290 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13291 :com.palletops.awaze.client-builder/undef)
     (. bean13289 setStatus (clojure.core/str v13291))))
   bean13289))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketNotificationConfiguration$TopicConfiguration}
bucket-notification-configuration-topic-configuration
  [m13293]
  (clojure.core/let
   [arg13295
    nil
    arg13296
    nil
    bean13292
    (new
     com.amazonaws.services.s3.model.BucketNotificationConfiguration$TopicConfiguration
     arg13295
     arg13296)]
   bean13292))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.S3VersionSummary}
s3version-summary
  [m13298]
  (clojure.core/let
   [bean13297 (new com.amazonaws.services.s3.model.S3VersionSummary)]
   (clojure.core/let
    [v13299
     (:bucket-name m13298 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13299 :com.palletops.awaze.client-builder/undef)
     (. bean13297 setBucketName (clojure.core/str v13299))))
   (clojure.core/let
    [v13299 (:owner m13298 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13299 :com.palletops.awaze.client-builder/undef)
     (. bean13297 setOwner (s3/owner v13299))))
   (clojure.core/let
    [v13299
     (:storage-class m13298 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13299 :com.palletops.awaze.client-builder/undef)
     (. bean13297 setStorageClass (clojure.core/str v13299))))
   (clojure.core/let
    [v13299
     (:is-latest m13298 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13299 :com.palletops.awaze.client-builder/undef)
     (. bean13297 setIsLatest (clojure.core/boolean v13299))))
   (clojure.core/let
    [v13299
     (:last-modified m13298 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13299 :com.palletops.awaze.client-builder/undef)
     (.
      bean13297
      setLastModified
      (com.palletops.awaze.common/to-date v13299))))
   (clojure.core/let
    [v13299 (:key m13298 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13299 :com.palletops.awaze.client-builder/undef)
     (. bean13297 setKey (clojure.core/str v13299))))
   (clojure.core/let
    [v13299 (:etag m13298 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13299 :com.palletops.awaze.client-builder/undef)
     (. bean13297 setETag (clojure.core/str v13299))))
   (clojure.core/let
    [v13299 (:size m13298 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13299 :com.palletops.awaze.client-builder/undef)
     (. bean13297 setSize (clojure.core/long v13299))))
   (clojure.core/let
    [v13299
     (:version-id m13298 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13299 :com.palletops.awaze.client-builder/undef)
     (. bean13297 setVersionId (clojure.core/str v13299))))
   (clojure.core/let
    [v13299
     (:is-delete-marker
      m13298
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13299 :com.palletops.awaze.client-builder/undef)
     (. bean13297 setIsDeleteMarker (clojure.core/boolean v13299))))
   bean13297))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ReplicationRule}
replication-rule
  [m13301]
  (clojure.core/let
   [bean13300 (new com.amazonaws.services.s3.model.ReplicationRule)]
   (clojure.core/let
    [v13302
     (:destination-config
      m13301
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13302 :com.palletops.awaze.client-builder/undef)
     (.
      bean13300
      setDestinationConfig
      (s3/replication-destination-config v13302))))
   (clojure.core/let
    [v13302
     (:status m13301 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13302 :com.palletops.awaze.client-builder/undef)
     (. bean13300 setStatus (clojure.core/str v13302))))
   (clojure.core/let
    [v13302
     (:prefix m13301 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13302 :com.palletops.awaze.client-builder/undef)
     (. bean13300 setPrefix (clojure.core/str v13302))))
   bean13300))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.TagSet}
tag-set
  [m13304]
  (clojure.core/let
   [bean13303 (new com.amazonaws.services.s3.model.TagSet)]
   bean13303))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.RoutingRule}
routing-rule
  [m13307]
  (clojure.core/let
   [bean13306 (new com.amazonaws.services.s3.model.RoutingRule)]
   (clojure.core/let
    [v13308
     (:redirect m13307 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13308 :com.palletops.awaze.client-builder/undef)
     (. bean13306 setRedirect (s3/redirect-rule v13308))))
   (clojure.core/let
    [v13308
     (:condition m13307 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13308 :com.palletops.awaze.client-builder/undef)
     (. bean13306 setCondition (s3/routing-rule-condition v13308))))
   bean13306))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SSECustomerKey}
ssecustomer-key
  [m13310]
  (clojure.core/let
   [^{:tag java.lang.String}
    arg13312
    nil
    bean13309
    (new
     com.amazonaws.services.s3.model.SSECustomerKey
^{:tag java.lang.String}
arg13312)]
   (clojure.core/let
    [v13311 (:md5 m13310 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13311 :com.palletops.awaze.client-builder/undef)
     (. bean13309 setMd5 (clojure.core/str v13311))))
   (clojure.core/let
    [v13311
     (:algorithm m13310 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13311 :com.palletops.awaze.client-builder/undef)
     (. bean13309 setAlgorithm (clojure.core/str v13311))))
   bean13309))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketCrossOriginConfiguration}
bucket-cross-origin-configuration
  [m13314]
  (clojure.core/let
   [bean13313
    (new
     com.amazonaws.services.s3.model.BucketCrossOriginConfiguration)]
   (clojure.core/let
    [v13315 (:rules m13314 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13315 :com.palletops.awaze.client-builder/undef)
     (.
      bean13313
      setRules
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13629] (s3/corsrule arg13629))
 v13315))))
   bean13313))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketLifecycleConfiguration}
bucket-lifecycle-configuration
  [m13317]
  (clojure.core/let
   [bean13316
    (new com.amazonaws.services.s3.model.BucketLifecycleConfiguration)]
   (clojure.core/let
    [v13318 (:rules m13317 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13318 :com.palletops.awaze.client-builder/undef)
     (.
      bean13316
      setRules
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg13630]
  (s3/bucket-lifecycle-configuration-rule arg13630))
 v13318))))
   bean13316))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketNotificationConfiguration}
bucket-notification-configuration
  [m13320]
  (clojure.core/let
   [bean13319
    (new
     com.amazonaws.services.s3.model.BucketNotificationConfiguration)]
   (clojure.core/let
    [v13321
     (:topic-configurations
      m13320
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13321 :com.palletops.awaze.client-builder/undef)
     (.
      bean13319
      setTopicConfigurations
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg13631]
  (s3/bucket-notification-configuration-topic-configuration arg13631))
 v13321))))
   (clojure.core/let
    [v13321
     (:configurations
      m13320
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13321 :com.palletops.awaze.client-builder/undef)
     (.
      bean13319
      setConfigurations
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg13632] (clojure.core/str arg13632))
  (clojure.core/keys v13321))
 (clojure.core/map
  (clojure.core/fn [arg13632] arg13632)
  (clojure.core/vals v13321))))))
   bean13319))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.VersionListing}
version-listing
  [m13323]
  (clojure.core/let
   [bean13322 (new com.amazonaws.services.s3.model.VersionListing)]
   (clojure.core/let
    [v13324
     (:prefix m13323 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13324 :com.palletops.awaze.client-builder/undef)
     (. bean13322 setPrefix (clojure.core/str v13324))))
   (clojure.core/let
    [v13324
     (:next-version-id-marker
      m13323
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13324 :com.palletops.awaze.client-builder/undef)
     (. bean13322 setNextVersionIdMarker (clojure.core/str v13324))))
   (clojure.core/let
    [v13324
     (:version-summaries
      m13323
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13324 :com.palletops.awaze.client-builder/undef)
     (.
      bean13322
      setVersionSummaries
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13633] (s3/s3version-summary arg13633))
 v13324))))
   (clojure.core/let
    [v13324
     (:bucket-name m13323 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13324 :com.palletops.awaze.client-builder/undef)
     (. bean13322 setBucketName (clojure.core/str v13324))))
   (clojure.core/let
    [v13324
     (:encoding-type m13323 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13324 :com.palletops.awaze.client-builder/undef)
     (. bean13322 setEncodingType (clojure.core/str v13324))))
   (clojure.core/let
    [v13324
     (:next-key-marker
      m13323
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13324 :com.palletops.awaze.client-builder/undef)
     (. bean13322 setNextKeyMarker (clojure.core/str v13324))))
   (clojure.core/let
    [v13324
     (:max-keys m13323 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13324 :com.palletops.awaze.client-builder/undef)
     (. bean13322 setMaxKeys (clojure.core/int v13324))))
   (clojure.core/let
    [v13324
     (:truncated m13323 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13324 :com.palletops.awaze.client-builder/undef)
     (. bean13322 setTruncated (clojure.core/boolean v13324))))
   (clojure.core/let
    [v13324
     (:version-id-marker
      m13323
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13324 :com.palletops.awaze.client-builder/undef)
     (. bean13322 setVersionIdMarker (clojure.core/str v13324))))
   (clojure.core/let
    [v13324
     (:common-prefixes
      m13323
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13324 :com.palletops.awaze.client-builder/undef)
     (.
      bean13322
      setCommonPrefixes
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13634] (clojure.core/str arg13634))
 v13324))))
   (clojure.core/let
    [v13324
     (:key-marker m13323 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13324 :com.palletops.awaze.client-builder/undef)
     (. bean13322 setKeyMarker (clojure.core/str v13324))))
   (clojure.core/let
    [v13324
     (:delimiter m13323 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13324 :com.palletops.awaze.client-builder/undef)
     (. bean13322 setDelimiter (clojure.core/str v13324))))
   bean13322))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SSEAlgorithm}
ssealgorithm
  [m13326]
  (java.lang.Enum/valueOf
   com.amazonaws.services.s3.model.SSEAlgorithm
   (clojure.core/name m13326)))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ResponseHeaderOverrides}
response-header-overrides
  [m13329]
  (clojure.core/let
   [bean13328
    (new com.amazonaws.services.s3.model.ResponseHeaderOverrides)]
   (clojure.core/let
    [v13330
     (:content-type m13329 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13330 :com.palletops.awaze.client-builder/undef)
     (. bean13328 setContentType (clojure.core/str v13330))))
   (clojure.core/let
    [v13330
     (:expires m13329 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13330 :com.palletops.awaze.client-builder/undef)
     (. bean13328 setExpires (clojure.core/str v13330))))
   (clojure.core/let
    [v13330
     (:content-language
      m13329
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13330 :com.palletops.awaze.client-builder/undef)
     (. bean13328 setContentLanguage (clojure.core/str v13330))))
   (clojure.core/let
    [v13330
     (:content-encoding
      m13329
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13330 :com.palletops.awaze.client-builder/undef)
     (. bean13328 setContentEncoding (clojure.core/str v13330))))
   (clojure.core/let
    [v13330
     (:cache-control m13329 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13330 :com.palletops.awaze.client-builder/undef)
     (. bean13328 setCacheControl (clojure.core/str v13330))))
   (clojure.core/let
    [v13330
     (:content-disposition
      m13329
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13330 :com.palletops.awaze.client-builder/undef)
     (. bean13328 setContentDisposition (clojure.core/str v13330))))
   bean13328))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
canned-access-control-list
  [m13332]
  (java.lang.Enum/valueOf
   com.amazonaws.services.s3.model.CannedAccessControlList
   (clojure.core/name m13332)))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.AccessControlList}
access-control-list
  [m13335]
  (clojure.core/let
   [bean13334 (new com.amazonaws.services.s3.model.AccessControlList)]
   (clojure.core/let
    [v13336 (:owner m13335 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13336 :com.palletops.awaze.client-builder/undef)
     (. bean13334 setOwner (s3/owner v13336))))
   (clojure.core/let
    [v13336
     (:requester-charged
      m13335
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13336 :com.palletops.awaze.client-builder/undef)
     (. bean13334 setRequesterCharged (clojure.core/boolean v13336))))
   bean13334))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SSEAwsKeyManagementParams}
sseaws-key-management-params
  [m13338]
  (clojure.core/let
   [bean13337
    (new com.amazonaws.services.s3.model.SSEAwsKeyManagementParams)]
   bean13337))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ObjectMetadata}
object-metadata
  [m13341]
  (clojure.core/let
   [bean13340 (new com.amazonaws.services.s3.model.ObjectMetadata)]
   (clojure.core/let
    [v13342
     (:content-encoding
      m13341
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13342 :com.palletops.awaze.client-builder/undef)
     (. bean13340 setContentEncoding (clojure.core/str v13342))))
   (clojure.core/let
    [v13342
     (:expiration-time-rule-id
      m13341
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13342 :com.palletops.awaze.client-builder/undef)
     (. bean13340 setExpirationTimeRuleId (clojure.core/str v13342))))
   (clojure.core/let
    [v13342
     (:cache-control m13341 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13342 :com.palletops.awaze.client-builder/undef)
     (. bean13340 setCacheControl (clojure.core/str v13342))))
   (clojure.core/let
    [v13342
     (:requester-charged
      m13341
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13342 :com.palletops.awaze.client-builder/undef)
     (. bean13340 setRequesterCharged (clojure.core/boolean v13342))))
   (clojure.core/let
    [v13342
     (:restore-expiration-time
      m13341
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13342 :com.palletops.awaze.client-builder/undef)
     (.
      bean13340
      setRestoreExpirationTime
      (com.palletops.awaze.common/to-date v13342))))
   (clojure.core/let
    [v13342
     (:content-type m13341 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13342 :com.palletops.awaze.client-builder/undef)
     (. bean13340 setContentType (clojure.core/str v13342))))
   (clojure.core/let
    [v13342
     (:content-length
      m13341
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13342 :com.palletops.awaze.client-builder/undef)
     (. bean13340 setContentLength (clojure.core/long v13342))))
   (clojure.core/let
    [v13342
     (:ssecustomer-key-md5
      m13341
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13342 :com.palletops.awaze.client-builder/undef)
     (. bean13340 setSSECustomerKeyMd5 (clojure.core/str v13342))))
   (clojure.core/let
    [v13342
     (:ongoing-restore
      m13341
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13342 :com.palletops.awaze.client-builder/undef)
     (. bean13340 setOngoingRestore (clojure.core/boolean v13342))))
   (clojure.core/let
    [v13342
     (:expiration-time
      m13341
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13342 :com.palletops.awaze.client-builder/undef)
     (.
      bean13340
      setExpirationTime
      (com.palletops.awaze.common/to-date v13342))))
   (clojure.core/let
    [v13342
     (:user-metadata m13341 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13342 :com.palletops.awaze.client-builder/undef)
     (.
      bean13340
      setUserMetadata
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg13635] (clojure.core/str arg13635))
  (clojure.core/keys v13342))
 (clojure.core/map
  (clojure.core/fn [arg13635] (clojure.core/str arg13635))
  (clojure.core/vals v13342))))))
   (clojure.core/let
    [v13342
     (:content-language
      m13341
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13342 :com.palletops.awaze.client-builder/undef)
     (. bean13340 setContentLanguage (clojure.core/str v13342))))
   (clojure.core/let
    [v13342
     (:last-modified m13341 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13342 :com.palletops.awaze.client-builder/undef)
     (.
      bean13340
      setLastModified
      (com.palletops.awaze.common/to-date v13342))))
   (clojure.core/let
    [v13342
     (:content-md5 m13341 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13342 :com.palletops.awaze.client-builder/undef)
     (. bean13340 setContentMD5 (clojure.core/str v13342))))
   (clojure.core/let
    [v13342
     (:content-disposition
      m13341
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13342 :com.palletops.awaze.client-builder/undef)
     (. bean13340 setContentDisposition (clojure.core/str v13342))))
   (clojure.core/let
    [v13342
     (:server-side-encryption
      m13341
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13342 :com.palletops.awaze.client-builder/undef)
     (. bean13340 setServerSideEncryption (clojure.core/str v13342))))
   (clojure.core/let
    [v13342
     (:ssealgorithm m13341 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13342 :com.palletops.awaze.client-builder/undef)
     (. bean13340 setSSEAlgorithm (clojure.core/str v13342))))
   (clojure.core/let
    [v13342
     (:ssecustomer-algorithm
      m13341
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13342 :com.palletops.awaze.client-builder/undef)
     (. bean13340 setSSECustomerAlgorithm (clojure.core/str v13342))))
   (clojure.core/let
    [v13342
     (:http-expires-date
      m13341
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13342 :com.palletops.awaze.client-builder/undef)
     (.
      bean13340
      setHttpExpiresDate
      (com.palletops.awaze.common/to-date v13342))))
   bean13340))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.MultiFactorAuthentication}
multi-factor-authentication
  [m13344]
  (clojure.core/let
   [arg13346
    nil
    arg13347
    nil
    bean13343
    (new
     com.amazonaws.services.s3.model.MultiFactorAuthentication
     arg13346
     arg13347)]
   (clojure.core/let
    [v13345 (:token m13344 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13345 :com.palletops.awaze.client-builder/undef)
     (. bean13343 setToken (clojure.core/str v13345))))
   (clojure.core/let
    [v13345
     (:device-serial-number
      m13344
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13345 :com.palletops.awaze.client-builder/undef)
     (. bean13343 setDeviceSerialNumber (clojure.core/str v13345))))
   bean13343))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteObjectsRequest$KeyVersion}
delete-objects-request-key-version
  [m13349]
  (clojure.core/let
   [arg13351
    nil
    bean13348
    (new
     com.amazonaws.services.s3.model.DeleteObjectsRequest$KeyVersion
     arg13351)]
   bean13348))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketVersioningConfiguration}
bucket-versioning-configuration
  [m13353]
  (clojure.core/let
   [bean13352
    (new
     com.amazonaws.services.s3.model.BucketVersioningConfiguration)]
   (clojure.core/let
    [v13354
     (:mfa-delete-enabled
      m13353
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13354 :com.palletops.awaze.client-builder/undef)
     (. bean13352 setMfaDeleteEnabled (clojure.core/boolean v13354))))
   (clojure.core/let
    [v13354
     (:status m13353 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13354 :com.palletops.awaze.client-builder/undef)
     (. bean13352 setStatus (clojure.core/str v13354))))
   bean13352))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketLoggingConfiguration}
bucket-logging-configuration
  [m13356]
  (clojure.core/let
   [bean13355
    (new com.amazonaws.services.s3.model.BucketLoggingConfiguration)]
   (clojure.core/let
    [v13357
     (:destination-bucket-name
      m13356
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13357 :com.palletops.awaze.client-builder/undef)
     (. bean13355 setDestinationBucketName (clojure.core/str v13357))))
   (clojure.core/let
    [v13357
     (:log-file-prefix
      m13356
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13357 :com.palletops.awaze.client-builder/undef)
     (. bean13355 setLogFilePrefix (clojure.core/str v13357))))
   bean13355))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.S3ObjectId}
s3object-id
  [m13359]
  (clojure.core/let
   [arg13361
    nil
    arg13362
    nil
    bean13358
    (new com.amazonaws.services.s3.model.S3ObjectId arg13361 arg13362)]
   bean13358))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.PartETag}
part-etag
  [m13364]
  (clojure.core/let
   [arg13366
    0
    arg13367
    nil
    bean13363
    (new com.amazonaws.services.s3.model.PartETag arg13366 arg13367)]
   (clojure.core/let
    [v13365 (:etag m13364 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13365 :com.palletops.awaze.client-builder/undef)
     (. bean13363 setETag (clojure.core/str v13365))))
   (clojure.core/let
    [v13365
     (:part-number m13364 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13365 :com.palletops.awaze.client-builder/undef)
     (. bean13363 setPartNumber (clojure.core/int v13365))))
   bean13363))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketReplicationConfiguration}
bucket-replication-configuration
  [m13369]
  (clojure.core/let
   [bean13368
    (new
     com.amazonaws.services.s3.model.BucketReplicationConfiguration)]
   (clojure.core/let
    [v13370
     (:role-arn m13369 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13370 :com.palletops.awaze.client-builder/undef)
     (. bean13368 setRoleARN (clojure.core/str v13370))))
   (clojure.core/let
    [v13370 (:rules m13369 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13370 :com.palletops.awaze.client-builder/undef)
     (.
      bean13368
      setRules
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg13636] (clojure.core/str arg13636))
  (clojure.core/keys v13370))
 (clojure.core/map
  (clojure.core/fn [arg13636] (s3/replication-rule arg13636))
  (clojure.core/vals v13370))))))
   bean13368))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketTaggingConfiguration}
bucket-tagging-configuration
  [m13372]
  (clojure.core/let
   [bean13371
    (new com.amazonaws.services.s3.model.BucketTaggingConfiguration)]
   (clojure.core/let
    [v13373
     (:tag-sets m13372 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13373 :com.palletops.awaze.client-builder/undef)
     (.
      bean13371
      setTagSets
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg13637] (s3/tag-set arg13637))
 v13373))))
   bean13371))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ObjectListing}
object-listing
  [m13375]
  (clojure.core/let
   [bean13374 (new com.amazonaws.services.s3.model.ObjectListing)]
   (clojure.core/let
    [v13376
     (:prefix m13375 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13376 :com.palletops.awaze.client-builder/undef)
     (. bean13374 setPrefix (clojure.core/str v13376))))
   (clojure.core/let
    [v13376
     (:bucket-name m13375 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13376 :com.palletops.awaze.client-builder/undef)
     (. bean13374 setBucketName (clojure.core/str v13376))))
   (clojure.core/let
    [v13376
     (:encoding-type m13375 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13376 :com.palletops.awaze.client-builder/undef)
     (. bean13374 setEncodingType (clojure.core/str v13376))))
   (clojure.core/let
    [v13376
     (:max-keys m13375 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13376 :com.palletops.awaze.client-builder/undef)
     (. bean13374 setMaxKeys (clojure.core/int v13376))))
   (clojure.core/let
    [v13376
     (:marker m13375 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13376 :com.palletops.awaze.client-builder/undef)
     (. bean13374 setMarker (clojure.core/str v13376))))
   (clojure.core/let
    [v13376
     (:next-marker m13375 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13376 :com.palletops.awaze.client-builder/undef)
     (. bean13374 setNextMarker (clojure.core/str v13376))))
   (clojure.core/let
    [v13376
     (:truncated m13375 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13376 :com.palletops.awaze.client-builder/undef)
     (. bean13374 setTruncated (clojure.core/boolean v13376))))
   (clojure.core/let
    [v13376
     (:common-prefixes
      m13375
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13376 :com.palletops.awaze.client-builder/undef)
     (.
      bean13374
      setCommonPrefixes
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13638] (clojure.core/str arg13638))
 v13376))))
   (clojure.core/let
    [v13376
     (:delimiter m13375 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13376 :com.palletops.awaze.client-builder/undef)
     (. bean13374 setDelimiter (clojure.core/str v13376))))
   bean13374))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketWebsiteConfiguration}
bucket-website-configuration
  [m13378]
  (clojure.core/let
   [bean13377
    (new com.amazonaws.services.s3.model.BucketWebsiteConfiguration)]
   (clojure.core/let
    [v13379
     (:redirect-all-requests-to
      m13378
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13379 :com.palletops.awaze.client-builder/undef)
     (. bean13377 setRedirectAllRequestsTo (s3/redirect-rule v13379))))
   (clojure.core/let
    [v13379
     (:index-document-suffix
      m13378
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13379 :com.palletops.awaze.client-builder/undef)
     (. bean13377 setIndexDocumentSuffix (clojure.core/str v13379))))
   (clojure.core/let
    [v13379
     (:error-document
      m13378
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13379 :com.palletops.awaze.client-builder/undef)
     (. bean13377 setErrorDocument (clojure.core/str v13379))))
   (clojure.core/let
    [v13379
     (:routing-rules m13378 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13379 :com.palletops.awaze.client-builder/undef)
     (.
      bean13377
      setRoutingRules
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13639] (s3/routing-rule arg13639))
 v13379))))
   bean13377))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteBucketWebsiteConfigurationRequest}
delete-bucket-website-configuration-request
  [m13381]
  (clojure.core/let
   [arg13383
    nil
    bean13380
    (new
     com.amazonaws.services.s3.model.DeleteBucketWebsiteConfigurationRequest
     arg13383)]
   bean13380))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetObjectAclRequest}
set-object-acl-request
  [m13385]
  (clojure.core/let
   [^{:tag java.lang.String}
    arg13387
    nil
^{:tag java.lang.String}
arg13388
    nil
^{:tag com.amazonaws.services.s3.model.AccessControlList}
arg13389
    (access-control-list {})
    bean13384
    (new
     com.amazonaws.services.s3.model.SetObjectAclRequest
^{:tag java.lang.String}
arg13387
^{:tag java.lang.String}
arg13388
^{:tag com.amazonaws.services.s3.model.AccessControlList}
arg13389)]
   (clojure.core/let
    [v13386
     (:requester-pays
      m13385
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13386 :com.palletops.awaze.client-builder/undef)
     (. bean13384 setRequesterPays (clojure.core/boolean v13386))))
   bean13384))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetBucketLifecycleConfigurationRequest}
get-bucket-lifecycle-configuration-request
  [m13391]
  (clojure.core/let
   [arg13393
    nil
    bean13390
    (new
     com.amazonaws.services.s3.model.GetBucketLifecycleConfigurationRequest
     arg13393)]
   bean13390))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ListMultipartUploadsRequest}
list-multipart-uploads-request
  [m13395]
  (clojure.core/let
   [arg13397
    nil
    bean13394
    (new
     com.amazonaws.services.s3.model.ListMultipartUploadsRequest
     arg13397)]
   (clojure.core/let
    [v13396
     (:delimiter m13395 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13396 :com.palletops.awaze.client-builder/undef)
     (. bean13394 setDelimiter (clojure.core/str v13396))))
   (clojure.core/let
    [v13396
     (:key-marker m13395 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13396 :com.palletops.awaze.client-builder/undef)
     (. bean13394 setKeyMarker (clojure.core/str v13396))))
   (clojure.core/let
    [v13396
     (:encoding-type m13395 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13396 :com.palletops.awaze.client-builder/undef)
     (. bean13394 setEncodingType (clojure.core/str v13396))))
   (clojure.core/let
    [v13396
     (:max-uploads m13395 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13396 :com.palletops.awaze.client-builder/undef)
     (. bean13394 setMaxUploads (clojure.core/int v13396))))
   (clojure.core/let
    [v13396
     (:upload-id-marker
      m13395
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13396 :com.palletops.awaze.client-builder/undef)
     (. bean13394 setUploadIdMarker (clojure.core/str v13396))))
   (clojure.core/let
    [v13396
     (:prefix m13395 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13396 :com.palletops.awaze.client-builder/undef)
     (. bean13394 setPrefix (clojure.core/str v13396))))
   (clojure.core/let
    [v13396
     (:bucket-name m13395 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13396 :com.palletops.awaze.client-builder/undef)
     (. bean13394 setBucketName (clojure.core/str v13396))))
   bean13394))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetObjectMetadataRequest}
get-object-metadata-request
  [m13399]
  (clojure.core/let
   [arg13401
    nil
    arg13402
    nil
    bean13398
    (new
     com.amazonaws.services.s3.model.GetObjectMetadataRequest
     arg13401
     arg13402)]
   (clojure.core/let
    [v13400 (:key m13399 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13400 :com.palletops.awaze.client-builder/undef)
     (. bean13398 setKey (clojure.core/str v13400))))
   (clojure.core/let
    [v13400
     (:version-id m13399 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13400 :com.palletops.awaze.client-builder/undef)
     (. bean13398 setVersionId (clojure.core/str v13400))))
   (clojure.core/let
    [v13400
     (:requester-pays
      m13399
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13400 :com.palletops.awaze.client-builder/undef)
     (. bean13398 setRequesterPays (clojure.core/boolean v13400))))
   (clojure.core/let
    [v13400
     (:ssecustomer-key
      m13399
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13400 :com.palletops.awaze.client-builder/undef)
     (. bean13398 setSSECustomerKey (s3/ssecustomer-key v13400))))
   (clojure.core/let
    [v13400
     (:bucket-name m13399 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13400 :com.palletops.awaze.client-builder/undef)
     (. bean13398 setBucketName (clojure.core/str v13400))))
   bean13398))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketCrossOriginConfigurationRequest}
set-bucket-cross-origin-configuration-request
  [m13404]
  (clojure.core/let
   [arg13406
    nil
    arg13407
    (bucket-cross-origin-configuration {})
    bean13403
    (new
     com.amazonaws.services.s3.model.SetBucketCrossOriginConfigurationRequest
     arg13406
     arg13407)]
   (clojure.core/let
    [v13405
     (:cross-origin-configuration
      m13404
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13405 :com.palletops.awaze.client-builder/undef)
     (.
      bean13403
      setCrossOriginConfiguration
      (s3/bucket-cross-origin-configuration v13405))))
   (clojure.core/let
    [v13405
     (:bucket-name m13404 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13405 :com.palletops.awaze.client-builder/undef)
     (. bean13403 setBucketName (clojure.core/str v13405))))
   bean13403))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteBucketReplicationConfigurationRequest}
delete-bucket-replication-configuration-request
  [m13409]
  (clojure.core/let
   [arg13411
    nil
    bean13408
    (new
     com.amazonaws.services.s3.model.DeleteBucketReplicationConfigurationRequest
     arg13411)]
   bean13408))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketLifecycleConfigurationRequest}
set-bucket-lifecycle-configuration-request
  [m13413]
  (clojure.core/let
   [arg13415
    nil
    arg13416
    (bucket-lifecycle-configuration {})
    bean13412
    (new
     com.amazonaws.services.s3.model.SetBucketLifecycleConfigurationRequest
     arg13415
     arg13416)]
   (clojure.core/let
    [v13414
     (:lifecycle-configuration
      m13413
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13414 :com.palletops.awaze.client-builder/undef)
     (.
      bean13412
      setLifecycleConfiguration
      (s3/bucket-lifecycle-configuration v13414))))
   (clojure.core/let
    [v13414
     (:bucket-name m13413 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13414 :com.palletops.awaze.client-builder/undef)
     (. bean13412 setBucketName (clojure.core/str v13414))))
   bean13412))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketNotificationConfigurationRequest}
set-bucket-notification-configuration-request
  [m13418]
  (clojure.core/let
   [^{:tag java.lang.String}
    arg13420
    nil
^{:tag com.amazonaws.services.s3.model.BucketNotificationConfiguration}
arg13421
    (bucket-notification-configuration {})
    bean13417
    (new
     com.amazonaws.services.s3.model.SetBucketNotificationConfigurationRequest
^{:tag java.lang.String}
arg13420
^{:tag com.amazonaws.services.s3.model.BucketNotificationConfiguration}
arg13421)]
   (clojure.core/let
    [v13419
     (:notification-configuration
      m13418
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13419 :com.palletops.awaze.client-builder/undef)
     (.
      bean13417
      setNotificationConfiguration
      (s3/bucket-notification-configuration v13419))))
   (clojure.core/let
    [v13419
     (:bucket-notification-configuration
      m13418
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13419 :com.palletops.awaze.client-builder/undef)
     (.
      bean13417
      setBucketNotificationConfiguration
      (s3/bucket-notification-configuration v13419))))
   (clojure.core/let
    [v13419
     (:bucket m13418 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13419 :com.palletops.awaze.client-builder/undef)
     (. bean13417 setBucket (clojure.core/str v13419))))
   (clojure.core/let
    [v13419
     (:bucket-name m13418 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13419 :com.palletops.awaze.client-builder/undef)
     (. bean13417 setBucketName (clojure.core/str v13419))))
   bean13417))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteBucketPolicyRequest}
delete-bucket-policy-request
  [m13423]
  (clojure.core/let
   [arg13425
    nil
    bean13422
    (new
     com.amazonaws.services.s3.model.DeleteBucketPolicyRequest
     arg13425)]
   (clojure.core/let
    [v13424
     (:bucket-name m13423 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13424 :com.palletops.awaze.client-builder/undef)
     (. bean13422 setBucketName (clojure.core/str v13424))))
   bean13422))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.HeadBucketRequest}
head-bucket-request
  [m13427]
  (clojure.core/let
   [arg13429
    nil
    bean13426
    (new com.amazonaws.services.s3.model.HeadBucketRequest arg13429)]
   (clojure.core/let
    [v13428
     (:bucket-name m13427 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13428 :com.palletops.awaze.client-builder/undef)
     (. bean13426 setBucketName (clojure.core/str v13428))))
   bean13426))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.S3ClientOptions}
s3client-options
  [m13431]
  (clojure.core/let
   [bean13430 (new com.amazonaws.services.s3.S3ClientOptions)]
   (clojure.core/let
    [v13432
     (:path-style-access
      m13431
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13432 :com.palletops.awaze.client-builder/undef)
     (. bean13430 setPathStyleAccess (clojure.core/boolean v13432))))
   (clojure.core/let
    [v13432
     (:chunked-encoding-disabled
      m13431
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13432 :com.palletops.awaze.client-builder/undef)
     (.
      bean13430
      setChunkedEncodingDisabled
      (clojure.core/boolean v13432))))
   bean13430))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetBucketNotificationConfigurationRequest}
get-bucket-notification-configuration-request
  [m13434]
  (clojure.core/let
   [arg13436
    nil
    bean13433
    (new
     com.amazonaws.services.s3.model.GetBucketNotificationConfigurationRequest
     arg13436)]
   bean13433))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteBucketLifecycleConfigurationRequest}
delete-bucket-lifecycle-configuration-request
  [m13438]
  (clojure.core/let
   [arg13440
    nil
    bean13437
    (new
     com.amazonaws.services.s3.model.DeleteBucketLifecycleConfigurationRequest
     arg13440)]
   bean13437))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ListObjectsRequest}
list-objects-request
  [m13442]
  (clojure.core/let
   [bean13441
    (new com.amazonaws.services.s3.model.ListObjectsRequest)]
   (clojure.core/let
    [v13443
     (:delimiter m13442 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13443 :com.palletops.awaze.client-builder/undef)
     (. bean13441 setDelimiter (clojure.core/str v13443))))
   (clojure.core/let
    [v13443
     (:max-keys m13442 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13443 :com.palletops.awaze.client-builder/undef)
     (. bean13441 setMaxKeys (clojure.core/int v13443))))
   (clojure.core/let
    [v13443
     (:encoding-type m13442 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13443 :com.palletops.awaze.client-builder/undef)
     (. bean13441 setEncodingType (clojure.core/str v13443))))
   (clojure.core/let
    [v13443
     (:marker m13442 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13443 :com.palletops.awaze.client-builder/undef)
     (. bean13441 setMarker (clojure.core/str v13443))))
   (clojure.core/let
    [v13443
     (:prefix m13442 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13443 :com.palletops.awaze.client-builder/undef)
     (. bean13441 setPrefix (clojure.core/str v13443))))
   (clojure.core/let
    [v13443
     (:bucket-name m13442 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13443 :com.palletops.awaze.client-builder/undef)
     (. bean13441 setBucketName (clojure.core/str v13443))))
   bean13441))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.AbortMultipartUploadRequest}
abort-multipart-upload-request
  [m13445]
  (clojure.core/let
   [arg13447
    nil
    arg13448
    nil
    arg13449
    nil
    bean13444
    (new
     com.amazonaws.services.s3.model.AbortMultipartUploadRequest
     arg13447
     arg13448
     arg13449)]
   (clojure.core/let
    [v13446 (:key m13445 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13446 :com.palletops.awaze.client-builder/undef)
     (. bean13444 setKey (clojure.core/str v13446))))
   (clojure.core/let
    [v13446
     (:requester-pays
      m13445
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13446 :com.palletops.awaze.client-builder/undef)
     (. bean13444 setRequesterPays (clojure.core/boolean v13446))))
   (clojure.core/let
    [v13446
     (:upload-id m13445 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13446 :com.palletops.awaze.client-builder/undef)
     (. bean13444 setUploadId (clojure.core/str v13446))))
   (clojure.core/let
    [v13446
     (:bucket-name m13445 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13446 :com.palletops.awaze.client-builder/undef)
     (. bean13444 setBucketName (clojure.core/str v13446))))
   bean13444))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetS3AccountOwnerRequest}
get-s3account-owner-request
  [m13451]
  (clojure.core/let
   [bean13450
    (new com.amazonaws.services.s3.model.GetS3AccountOwnerRequest)]
   bean13450))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ListBucketsRequest}
list-buckets-request
  [m13454]
  (clojure.core/let
   [bean13453
    (new com.amazonaws.services.s3.model.ListBucketsRequest)]
   bean13453))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetBucketWebsiteConfigurationRequest}
get-bucket-website-configuration-request
  [m13457]
  (clojure.core/let
   [arg13459
    nil
    bean13456
    (new
     com.amazonaws.services.s3.model.GetBucketWebsiteConfigurationRequest
     arg13459)]
   (clojure.core/let
    [v13458
     (:bucket-name m13457 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13458 :com.palletops.awaze.client-builder/undef)
     (. bean13456 setBucketName (clojure.core/str v13458))))
   bean13456))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ListPartsRequest}
list-parts-request
  [m13461]
  (clojure.core/let
   [arg13463
    nil
    arg13464
    nil
    arg13465
    nil
    bean13460
    (new
     com.amazonaws.services.s3.model.ListPartsRequest
     arg13463
     arg13464
     arg13465)]
   (clojure.core/let
    [v13462 (:key m13461 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13462 :com.palletops.awaze.client-builder/undef)
     (. bean13460 setKey (clojure.core/str v13462))))
   (clojure.core/let
    [v13462
     (:requester-pays
      m13461
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13462 :com.palletops.awaze.client-builder/undef)
     (. bean13460 setRequesterPays (clojure.core/boolean v13462))))
   (clojure.core/let
    [v13462
     (:max-parts m13461 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13462 :com.palletops.awaze.client-builder/undef)
     (. bean13460 setMaxParts (clojure.core/int v13462))))
   (clojure.core/let
    [v13462
     (:part-number-marker
      m13461
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13462 :com.palletops.awaze.client-builder/undef)
     (. bean13460 setPartNumberMarker (clojure.core/int v13462))))
   (clojure.core/let
    [v13462
     (:encoding-type m13461 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13462 :com.palletops.awaze.client-builder/undef)
     (. bean13460 setEncodingType (clojure.core/str v13462))))
   (clojure.core/let
    [v13462
     (:upload-id m13461 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13462 :com.palletops.awaze.client-builder/undef)
     (. bean13460 setUploadId (clojure.core/str v13462))))
   (clojure.core/let
    [v13462
     (:bucket-name m13461 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13462 :com.palletops.awaze.client-builder/undef)
     (. bean13460 setBucketName (clojure.core/str v13462))))
   bean13460))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketAclRequest}
set-bucket-acl-request
  [m13467]
  (clojure.core/let
   [^{:tag java.lang.String}
    arg13469
    nil
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
arg13470
    (canned-access-control-list {})
    bean13466
    (new
     com.amazonaws.services.s3.model.SetBucketAclRequest
^{:tag java.lang.String}
arg13469
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
arg13470)]
   bean13466))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.CopyPartRequest}
copy-part-request
  [m13472]
  (clojure.core/let
   [bean13471 (new com.amazonaws.services.s3.model.CopyPartRequest)]
   (clojure.core/let
    [v13473
     (:first-byte m13472 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13473 :com.palletops.awaze.client-builder/undef)
     (. bean13471 setFirstByte (clojure.core/long v13473))))
   (clojure.core/let
    [v13473
     (:source-version-id
      m13472
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13473 :com.palletops.awaze.client-builder/undef)
     (. bean13471 setSourceVersionId (clojure.core/str v13473))))
   (clojure.core/let
    [v13473
     (:source-bucket-name
      m13472
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13473 :com.palletops.awaze.client-builder/undef)
     (. bean13471 setSourceBucketName (clojure.core/str v13473))))
   (clojure.core/let
    [v13473
     (:last-byte m13472 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13473 :com.palletops.awaze.client-builder/undef)
     (. bean13471 setLastByte (clojure.core/long v13473))))
   (clojure.core/let
    [v13473
     (:unmodified-since-constraint
      m13472
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13473 :com.palletops.awaze.client-builder/undef)
     (.
      bean13471
      setUnmodifiedSinceConstraint
      (com.palletops.awaze.common/to-date v13473))))
   (clojure.core/let
    [v13473
     (:modified-since-constraint
      m13472
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13473 :com.palletops.awaze.client-builder/undef)
     (.
      bean13471
      setModifiedSinceConstraint
      (com.palletops.awaze.common/to-date v13473))))
   (clojure.core/let
    [v13473
     (:destination-ssecustomer-key
      m13472
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13473 :com.palletops.awaze.client-builder/undef)
     (.
      bean13471
      setDestinationSSECustomerKey
      (s3/ssecustomer-key v13473))))
   (clojure.core/let
    [v13473
     (:destination-bucket-name
      m13472
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13473 :com.palletops.awaze.client-builder/undef)
     (. bean13471 setDestinationBucketName (clojure.core/str v13473))))
   (clojure.core/let
    [v13473
     (:part-number m13472 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13473 :com.palletops.awaze.client-builder/undef)
     (. bean13471 setPartNumber (clojure.core/int v13473))))
   (clojure.core/let
    [v13473
     (:destination-key
      m13472
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13473 :com.palletops.awaze.client-builder/undef)
     (. bean13471 setDestinationKey (clojure.core/str v13473))))
   (clojure.core/let
    [v13473
     (:matching-etag-constraints
      m13472
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13473 :com.palletops.awaze.client-builder/undef)
     (.
      bean13471
      setMatchingETagConstraints
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13640] (clojure.core/str arg13640))
 v13473))))
   (clojure.core/let
    [v13473
     (:source-key m13472 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13473 :com.palletops.awaze.client-builder/undef)
     (. bean13471 setSourceKey (clojure.core/str v13473))))
   (clojure.core/let
    [v13473
     (:source-ssecustomer-key
      m13472
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13473 :com.palletops.awaze.client-builder/undef)
     (. bean13471 setSourceSSECustomerKey (s3/ssecustomer-key v13473))))
   (clojure.core/let
    [v13473
     (:nonmatching-etag-constraints
      m13472
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13473 :com.palletops.awaze.client-builder/undef)
     (.
      bean13471
      setNonmatchingETagConstraints
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13641] (clojure.core/str arg13641))
 v13473))))
   (clojure.core/let
    [v13473
     (:upload-id m13472 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13473 :com.palletops.awaze.client-builder/undef)
     (. bean13471 setUploadId (clojure.core/str v13473))))
   bean13471))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetBucketReplicationConfigurationRequest}
get-bucket-replication-configuration-request
  [m13475]
  (clojure.core/let
   [arg13477
    nil
    bean13474
    (new
     com.amazonaws.services.s3.model.GetBucketReplicationConfigurationRequest
     arg13477)]
   bean13474))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetBucketVersioningConfigurationRequest}
get-bucket-versioning-configuration-request
  [m13479]
  (clojure.core/let
   [arg13481
    nil
    bean13478
    (new
     com.amazonaws.services.s3.model.GetBucketVersioningConfigurationRequest
     arg13481)]
   bean13478))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ListNextBatchOfVersionsRequest}
list-next-batch-of-versions-request
  [m13483]
  (clojure.core/let
   [arg13485
    (version-listing {})
    bean13482
    (new
     com.amazonaws.services.s3.model.ListNextBatchOfVersionsRequest
     arg13485)]
   (clojure.core/let
    [v13484
     (:previous-version-listing
      m13483
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13484 :com.palletops.awaze.client-builder/undef)
     (.
      bean13482
      setPreviousVersionListing
      (s3/version-listing v13484))))
   bean13482))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetBucketAclRequest}
get-bucket-acl-request
  [m13487]
  (clojure.core/let
   [arg13489
    nil
    bean13486
    (new com.amazonaws.services.s3.model.GetBucketAclRequest arg13489)]
   bean13486))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteObjectRequest}
delete-object-request
  [m13491]
  (clojure.core/let
   [arg13493
    nil
    arg13494
    nil
    bean13490
    (new
     com.amazonaws.services.s3.model.DeleteObjectRequest
     arg13493
     arg13494)]
   (clojure.core/let
    [v13492 (:key m13491 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13492 :com.palletops.awaze.client-builder/undef)
     (. bean13490 setKey (clojure.core/str v13492))))
   (clojure.core/let
    [v13492
     (:requester-pays
      m13491
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13492 :com.palletops.awaze.client-builder/undef)
     (. bean13490 setRequesterPays (clojure.core/boolean v13492))))
   (clojure.core/let
    [v13492
     (:bucket-name m13491 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13492 :com.palletops.awaze.client-builder/undef)
     (. bean13490 setBucketName (clojure.core/str v13492))))
   bean13490))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteBucketTaggingConfigurationRequest}
delete-bucket-tagging-configuration-request
  [m13496]
  (clojure.core/let
   [arg13498
    nil
    bean13495
    (new
     com.amazonaws.services.s3.model.DeleteBucketTaggingConfigurationRequest
     arg13498)]
   bean13495))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetBucketLoggingConfigurationRequest}
get-bucket-logging-configuration-request
  [m13500]
  (clojure.core/let
   [arg13502
    nil
    bean13499
    (new
     com.amazonaws.services.s3.model.GetBucketLoggingConfigurationRequest
     arg13502)]
   bean13499))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GeneratePresignedUrlRequest}
generate-presigned-url-request
  [m13504]
  (clojure.core/let
   [arg13506
    nil
    arg13507
    nil
    bean13503
    (new
     com.amazonaws.services.s3.model.GeneratePresignedUrlRequest
     arg13506
     arg13507)]
   (clojure.core/let
    [v13505
     (:expiration m13504 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13505 :com.palletops.awaze.client-builder/undef)
     (.
      bean13503
      setExpiration
      (com.palletops.awaze.common/to-date v13505))))
   (clojure.core/let
    [v13505
     (:kms-cmk-id m13504 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13505 :com.palletops.awaze.client-builder/undef)
     (. bean13503 setKmsCmkId (clojure.core/str v13505))))
   (clojure.core/let
    [v13505
     (:content-type m13504 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13505 :com.palletops.awaze.client-builder/undef)
     (. bean13503 setContentType (clojure.core/str v13505))))
   (clojure.core/let
    [v13505
     (:bucket-name m13504 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13505 :com.palletops.awaze.client-builder/undef)
     (. bean13503 setBucketName (clojure.core/str v13505))))
   (clojure.core/let
    [v13505
     (:ssecustomer-key
      m13504
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13505 :com.palletops.awaze.client-builder/undef)
     (. bean13503 setSSECustomerKey (s3/ssecustomer-key v13505))))
   (clojure.core/let
    [v13505
     (:method m13504 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13505 :com.palletops.awaze.client-builder/undef)
     (. bean13503 setMethod (root/http-method v13505))))
   (clojure.core/let
    [v13505
     (:ssecustomer-key-algorithm
      m13504
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13505 :com.palletops.awaze.client-builder/undef)
     (. bean13503 setSSECustomerKeyAlgorithm (s3/ssealgorithm v13505))))
   (clojure.core/let
    [v13505
     (:response-headers
      m13504
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13505 :com.palletops.awaze.client-builder/undef)
     (.
      bean13503
      setResponseHeaders
      (s3/response-header-overrides v13505))))
   (clojure.core/let
    [v13505
     (:zero-byte-content
      m13504
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13505 :com.palletops.awaze.client-builder/undef)
     (. bean13503 setZeroByteContent (clojure.core/boolean v13505))))
   (clojure.core/let
    [v13505 (:key m13504 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13505 :com.palletops.awaze.client-builder/undef)
     (. bean13503 setKey (clojure.core/str v13505))))
   (clojure.core/let
    [v13505
     (:ssealgorithm m13504 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13505 :com.palletops.awaze.client-builder/undef)
     (. bean13503 setSSEAlgorithm (clojure.core/str v13505))))
   (clojure.core/let
    [v13505
     (:content-md5 m13504 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13505 :com.palletops.awaze.client-builder/undef)
     (. bean13503 setContentMd5 (clojure.core/str v13505))))
   bean13503))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.CopyObjectRequest}
copy-object-request
  [m13509]
  (clojure.core/let
   [arg13511
    nil
    arg13512
    nil
    arg13513
    nil
    arg13514
    nil
    bean13508
    (new
     com.amazonaws.services.s3.model.CopyObjectRequest
     arg13511
     arg13512
     arg13513
     arg13514)]
   (clojure.core/let
    [v13510
     (:canned-access-control-list
      m13509
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13510 :com.palletops.awaze.client-builder/undef)
     (.
      bean13508
      setCannedAccessControlList
      (s3/canned-access-control-list v13510))))
   (clojure.core/let
    [v13510
     (:source-version-id
      m13509
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13510 :com.palletops.awaze.client-builder/undef)
     (. bean13508 setSourceVersionId (clojure.core/str v13510))))
   (clojure.core/let
    [v13510
     (:source-bucket-name
      m13509
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13510 :com.palletops.awaze.client-builder/undef)
     (. bean13508 setSourceBucketName (clojure.core/str v13510))))
   (clojure.core/let
    [v13510
     (:unmodified-since-constraint
      m13509
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13510 :com.palletops.awaze.client-builder/undef)
     (.
      bean13508
      setUnmodifiedSinceConstraint
      (com.palletops.awaze.common/to-date v13510))))
   (clojure.core/let
    [v13510
     (:modified-since-constraint
      m13509
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13510 :com.palletops.awaze.client-builder/undef)
     (.
      bean13508
      setModifiedSinceConstraint
      (com.palletops.awaze.common/to-date v13510))))
   (clojure.core/let
    [v13510
     (:storage-class m13509 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13510 :com.palletops.awaze.client-builder/undef)
     (. bean13508 setStorageClass (s3/storage-class v13510))))
   (clojure.core/let
    [v13510
     (:destination-ssecustomer-key
      m13509
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13510 :com.palletops.awaze.client-builder/undef)
     (.
      bean13508
      setDestinationSSECustomerKey
      (s3/ssecustomer-key v13510))))
   (clojure.core/let
    [v13510
     (:destination-bucket-name
      m13509
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13510 :com.palletops.awaze.client-builder/undef)
     (. bean13508 setDestinationBucketName (clojure.core/str v13510))))
   (clojure.core/let
    [v13510
     (:redirect-location
      m13509
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13510 :com.palletops.awaze.client-builder/undef)
     (. bean13508 setRedirectLocation (clojure.core/str v13510))))
   (clojure.core/let
    [v13510
     (:requester-pays
      m13509
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13510 :com.palletops.awaze.client-builder/undef)
     (. bean13508 setRequesterPays (clojure.core/boolean v13510))))
   (clojure.core/let
    [v13510
     (:access-control-list
      m13509
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13510 :com.palletops.awaze.client-builder/undef)
     (.
      bean13508
      setAccessControlList
      (s3/access-control-list v13510))))
   (clojure.core/let
    [v13510
     (:sseaws-key-management-params
      m13509
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13510 :com.palletops.awaze.client-builder/undef)
     (.
      bean13508
      setSSEAwsKeyManagementParams
      (s3/sseaws-key-management-params v13510))))
   (clojure.core/let
    [v13510
     (:destination-key
      m13509
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13510 :com.palletops.awaze.client-builder/undef)
     (. bean13508 setDestinationKey (clojure.core/str v13510))))
   (clojure.core/let
    [v13510
     (:matching-etag-constraints
      m13509
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13510 :com.palletops.awaze.client-builder/undef)
     (.
      bean13508
      setMatchingETagConstraints
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13642] (clojure.core/str arg13642))
 v13510))))
   (clojure.core/let
    [v13510
     (:source-key m13509 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13510 :com.palletops.awaze.client-builder/undef)
     (. bean13508 setSourceKey (clojure.core/str v13510))))
   (clojure.core/let
    [v13510
     (:source-ssecustomer-key
      m13509
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13510 :com.palletops.awaze.client-builder/undef)
     (. bean13508 setSourceSSECustomerKey (s3/ssecustomer-key v13510))))
   (clojure.core/let
    [v13510
     (:new-object-metadata
      m13509
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13510 :com.palletops.awaze.client-builder/undef)
     (. bean13508 setNewObjectMetadata (s3/object-metadata v13510))))
   (clojure.core/let
    [v13510
     (:nonmatching-etag-constraints
      m13509
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13510 :com.palletops.awaze.client-builder/undef)
     (.
      bean13508
      setNonmatchingETagConstraints
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13643] (clojure.core/str arg13643))
 v13510))))
   bean13508))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteObjectsRequest}
delete-objects-request
  [m13516]
  (clojure.core/let
   [arg13518
    nil
    bean13515
    (new
     com.amazonaws.services.s3.model.DeleteObjectsRequest
     arg13518)]
   (clojure.core/let
    [v13517
     (:requester-pays
      m13516
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13517 :com.palletops.awaze.client-builder/undef)
     (. bean13515 setRequesterPays (clojure.core/boolean v13517))))
   (clojure.core/let
    [v13517 (:mfa m13516 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13517 :com.palletops.awaze.client-builder/undef)
     (. bean13515 setMfa (s3/multi-factor-authentication v13517))))
   (clojure.core/let
    [v13517 (:quiet m13516 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13517 :com.palletops.awaze.client-builder/undef)
     (. bean13515 setQuiet (clojure.core/boolean v13517))))
   (clojure.core/let
    [v13517 (:keys m13516 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13517 :com.palletops.awaze.client-builder/undef)
     (.
      bean13515
      setKeys
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg13644]
  (s3/delete-objects-request-key-version arg13644))
 v13517))))
   (clojure.core/let
    [v13517
     (:bucket-name m13516 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13517 :com.palletops.awaze.client-builder/undef)
     (. bean13515 setBucketName (clojure.core/str v13517))))
   bean13515))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketVersioningConfigurationRequest}
set-bucket-versioning-configuration-request
  [m13520]
  (clojure.core/let
   [arg13522
    nil
    arg13523
    (bucket-versioning-configuration {})
    bean13519
    (new
     com.amazonaws.services.s3.model.SetBucketVersioningConfigurationRequest
     arg13522
     arg13523)]
   (clojure.core/let
    [v13521
     (:versioning-configuration
      m13520
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13521 :com.palletops.awaze.client-builder/undef)
     (.
      bean13519
      setVersioningConfiguration
      (s3/bucket-versioning-configuration v13521))))
   (clojure.core/let
    [v13521 (:mfa m13520 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13521 :com.palletops.awaze.client-builder/undef)
     (. bean13519 setMfa (s3/multi-factor-authentication v13521))))
   (clojure.core/let
    [v13521
     (:bucket-name m13520 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13521 :com.palletops.awaze.client-builder/undef)
     (. bean13519 setBucketName (clojure.core/str v13521))))
   bean13519))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketLoggingConfigurationRequest}
set-bucket-logging-configuration-request
  [m13525]
  (clojure.core/let
   [arg13527
    nil
    arg13528
    (bucket-logging-configuration {})
    bean13524
    (new
     com.amazonaws.services.s3.model.SetBucketLoggingConfigurationRequest
     arg13527
     arg13528)]
   (clojure.core/let
    [v13526
     (:logging-configuration
      m13525
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13526 :com.palletops.awaze.client-builder/undef)
     (.
      bean13524
      setLoggingConfiguration
      (s3/bucket-logging-configuration v13526))))
   (clojure.core/let
    [v13526
     (:bucket-name m13525 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13526 :com.palletops.awaze.client-builder/undef)
     (. bean13524 setBucketName (clojure.core/str v13526))))
   bean13524))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetObjectRequest}
get-object-request
  [m13530]
  (clojure.core/let
   [arg13532
    nil
    arg13533
    nil
    bean13529
    (new
     com.amazonaws.services.s3.model.GetObjectRequest
     arg13532
     arg13533)]
   (clojure.core/let
    [v13531
     (:progress-listener
      m13530
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13531 :com.palletops.awaze.client-builder/undef)
     (. bean13529 setProgressListener v13531)))
   (clojure.core/let
    [v13531
     (:bucket-name m13530 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13531 :com.palletops.awaze.client-builder/undef)
     (. bean13529 setBucketName (clojure.core/str v13531))))
   (clojure.core/let
    [v13531
     (:ssecustomer-key
      m13530
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13531 :com.palletops.awaze.client-builder/undef)
     (. bean13529 setSSECustomerKey (s3/ssecustomer-key v13531))))
   (clojure.core/let
    [v13531
     (:unmodified-since-constraint
      m13530
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13531 :com.palletops.awaze.client-builder/undef)
     (.
      bean13529
      setUnmodifiedSinceConstraint
      (com.palletops.awaze.common/to-date v13531))))
   (clojure.core/let
    [v13531
     (:modified-since-constraint
      m13530
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13531 :com.palletops.awaze.client-builder/undef)
     (.
      bean13529
      setModifiedSinceConstraint
      (com.palletops.awaze.common/to-date v13531))))
   (clojure.core/let
    [v13531 (:range m13530 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13531 :com.palletops.awaze.client-builder/undef)
     (. bean13529 setRange (clojure.core/long v13531))))
   (clojure.core/let
    [v13531
     (:s3object-id m13530 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13531 :com.palletops.awaze.client-builder/undef)
     (. bean13529 setS3ObjectId (s3/s3object-id v13531))))
   (clojure.core/let
    [v13531
     (:response-headers
      m13530
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13531 :com.palletops.awaze.client-builder/undef)
     (.
      bean13529
      setResponseHeaders
      (s3/response-header-overrides v13531))))
   (clojure.core/let
    [v13531
     (:requester-pays
      m13530
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13531 :com.palletops.awaze.client-builder/undef)
     (. bean13529 setRequesterPays (clojure.core/boolean v13531))))
   (clojure.core/let
    [v13531 (:key m13530 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13531 :com.palletops.awaze.client-builder/undef)
     (. bean13529 setKey (clojure.core/str v13531))))
   (clojure.core/let
    [v13531
     (:matching-etag-constraints
      m13530
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13531 :com.palletops.awaze.client-builder/undef)
     (.
      bean13529
      setMatchingETagConstraints
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13645] (clojure.core/str arg13645))
 v13531))))
   (clojure.core/let
    [v13531
     (:version-id m13530 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13531 :com.palletops.awaze.client-builder/undef)
     (. bean13529 setVersionId (clojure.core/str v13531))))
   (clojure.core/let
    [v13531
     (:nonmatching-etag-constraints
      m13530
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13531 :com.palletops.awaze.client-builder/undef)
     (.
      bean13529
      setNonmatchingETagConstraints
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13646] (clojure.core/str arg13646))
 v13531))))
   bean13529))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteBucketCrossOriginConfigurationRequest}
delete-bucket-cross-origin-configuration-request
  [m13535]
  (clojure.core/let
   [arg13537
    nil
    bean13534
    (new
     com.amazonaws.services.s3.model.DeleteBucketCrossOriginConfigurationRequest
     arg13537)]
   bean13534))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.CompleteMultipartUploadRequest}
complete-multipart-upload-request
  [m13539]
  (clojure.core/let
   [bean13538
    (new
     com.amazonaws.services.s3.model.CompleteMultipartUploadRequest)]
   (clojure.core/let
    [v13540 (:key m13539 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13540 :com.palletops.awaze.client-builder/undef)
     (. bean13538 setKey (clojure.core/str v13540))))
   (clojure.core/let
    [v13540
     (:requester-pays
      m13539
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13540 :com.palletops.awaze.client-builder/undef)
     (. bean13538 setRequesterPays (clojure.core/boolean v13540))))
   (clojure.core/let
    [v13540
     (:part-etags m13539 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13540 :com.palletops.awaze.client-builder/undef)
     (.
      bean13538
      setPartETags
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13647] (s3/part-etag arg13647))
 v13540))))
   (clojure.core/let
    [v13540
     (:upload-id m13539 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13540 :com.palletops.awaze.client-builder/undef)
     (. bean13538 setUploadId (clojure.core/str v13540))))
   (clojure.core/let
    [v13540
     (:bucket-name m13539 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13540 :com.palletops.awaze.client-builder/undef)
     (. bean13538 setBucketName (clojure.core/str v13540))))
   bean13538))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.RestoreObjectRequest}
restore-object-request
  [m13542]
  (clojure.core/let
   [arg13544
    nil
    arg13545
    nil
    bean13541
    (new
     com.amazonaws.services.s3.model.RestoreObjectRequest
     arg13544
     arg13545)]
   (clojure.core/let
    [v13543 (:key m13542 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13543 :com.palletops.awaze.client-builder/undef)
     (. bean13541 setKey (clojure.core/str v13543))))
   (clojure.core/let
    [v13543
     (:version-id m13542 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13543 :com.palletops.awaze.client-builder/undef)
     (. bean13541 setVersionId (clojure.core/str v13543))))
   (clojure.core/let
    [v13543
     (:requester-pays
      m13542
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13543 :com.palletops.awaze.client-builder/undef)
     (. bean13541 setRequesterPays (clojure.core/boolean v13543))))
   (clojure.core/let
    [v13543
     (:expiration-in-days
      m13542
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13543 :com.palletops.awaze.client-builder/undef)
     (. bean13541 setExpirationInDays (clojure.core/int v13543))))
   (clojure.core/let
    [v13543
     (:bucket-name m13542 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13543 :com.palletops.awaze.client-builder/undef)
     (. bean13541 setBucketName (clojure.core/str v13543))))
   bean13541))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetBucketPolicyRequest}
get-bucket-policy-request
  [m13547]
  (clojure.core/let
   [arg13549
    nil
    bean13546
    (new
     com.amazonaws.services.s3.model.GetBucketPolicyRequest
     arg13549)]
   (clojure.core/let
    [v13548
     (:bucket-name m13547 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13548 :com.palletops.awaze.client-builder/undef)
     (. bean13546 setBucketName (clojure.core/str v13548))))
   bean13546))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketReplicationConfigurationRequest}
set-bucket-replication-configuration-request
  [m13551]
  (clojure.core/let
   [bean13550
    (new
     com.amazonaws.services.s3.model.SetBucketReplicationConfigurationRequest)]
   (clojure.core/let
    [v13552
     (:replication-configuration
      m13551
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13552 :com.palletops.awaze.client-builder/undef)
     (.
      bean13550
      setReplicationConfiguration
      (s3/bucket-replication-configuration v13552))))
   (clojure.core/let
    [v13552
     (:bucket-name m13551 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13552 :com.palletops.awaze.client-builder/undef)
     (. bean13550 setBucketName (clojure.core/str v13552))))
   bean13550))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.Region}
region
  [m13554]
  (.
   com.amazonaws.services.s3.model.Region
   fromValue
   (clojure.core/name m13554)))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.CreateBucketRequest}
create-bucket-request
  [m13557]
  (clojure.core/let
   [arg13559
    nil
    bean13556
    (new com.amazonaws.services.s3.model.CreateBucketRequest arg13559)]
   (clojure.core/let
    [v13558
     (:canned-acl m13557 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13558 :com.palletops.awaze.client-builder/undef)
     (. bean13556 setCannedAcl (s3/canned-access-control-list v13558))))
   (clojure.core/let
    [v13558
     (:access-control-list
      m13557
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13558 :com.palletops.awaze.client-builder/undef)
     (.
      bean13556
      setAccessControlList
      (s3/access-control-list v13558))))
   (clojure.core/let
    [v13558
     (:region m13557 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13558 :com.palletops.awaze.client-builder/undef)
     (. bean13556 setRegion (clojure.core/str v13558))))
   (clojure.core/let
    [v13558
     (:bucket-name m13557 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13558 :com.palletops.awaze.client-builder/undef)
     (. bean13556 setBucketName (clojure.core/str v13558))))
   bean13556))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteVersionRequest}
delete-version-request
  [m13561]
  (clojure.core/let
   [arg13563
    nil
    arg13564
    nil
    arg13565
    nil
    bean13560
    (new
     com.amazonaws.services.s3.model.DeleteVersionRequest
     arg13563
     arg13564
     arg13565)]
   (clojure.core/let
    [v13562 (:key m13561 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13562 :com.palletops.awaze.client-builder/undef)
     (. bean13560 setKey (clojure.core/str v13562))))
   (clojure.core/let
    [v13562
     (:version-id m13561 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13562 :com.palletops.awaze.client-builder/undef)
     (. bean13560 setVersionId (clojure.core/str v13562))))
   (clojure.core/let
    [v13562 (:mfa m13561 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13562 :com.palletops.awaze.client-builder/undef)
     (. bean13560 setMfa (s3/multi-factor-authentication v13562))))
   (clojure.core/let
    [v13562
     (:bucket-name m13561 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13562 :com.palletops.awaze.client-builder/undef)
     (. bean13560 setBucketName (clojure.core/str v13562))))
   bean13560))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.PutObjectRequest}
put-object-request
  [m13567]
  (clojure.core/let
   [^{:tag java.lang.String}
    arg13569
    nil
^{:tag java.lang.String}
arg13570
    nil
^{:tag java.lang.String}
arg13571
    nil
    bean13566
    (new
     com.amazonaws.services.s3.model.PutObjectRequest
^{:tag java.lang.String}
arg13569
^{:tag java.lang.String}
arg13570
^{:tag java.lang.String}
arg13571)]
   (clojure.core/let
    [v13568
     (:requester-pays
      m13567
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13568 :com.palletops.awaze.client-builder/undef)
     (. bean13566 setRequesterPays (clojure.core/boolean v13568))))
   bean13566))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ListVersionsRequest}
list-versions-request
  [m13573]
  (clojure.core/let
   [bean13572
    (new com.amazonaws.services.s3.model.ListVersionsRequest)]
   (clojure.core/let
    [v13574
     (:delimiter m13573 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13574 :com.palletops.awaze.client-builder/undef)
     (. bean13572 setDelimiter (clojure.core/str v13574))))
   (clojure.core/let
    [v13574
     (:key-marker m13573 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13574 :com.palletops.awaze.client-builder/undef)
     (. bean13572 setKeyMarker (clojure.core/str v13574))))
   (clojure.core/let
    [v13574
     (:version-id-marker
      m13573
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13574 :com.palletops.awaze.client-builder/undef)
     (. bean13572 setVersionIdMarker (clojure.core/str v13574))))
   (clojure.core/let
    [v13574
     (:encoding-type m13573 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13574 :com.palletops.awaze.client-builder/undef)
     (. bean13572 setEncodingType (clojure.core/str v13574))))
   (clojure.core/let
    [v13574
     (:max-results m13573 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13574 :com.palletops.awaze.client-builder/undef)
     (. bean13572 setMaxResults (clojure.core/int v13574))))
   (clojure.core/let
    [v13574
     (:prefix m13573 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13574 :com.palletops.awaze.client-builder/undef)
     (. bean13572 setPrefix (clojure.core/str v13574))))
   (clojure.core/let
    [v13574
     (:bucket-name m13573 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13574 :com.palletops.awaze.client-builder/undef)
     (. bean13572 setBucketName (clojure.core/str v13574))))
   bean13572))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketTaggingConfigurationRequest}
set-bucket-tagging-configuration-request
  [m13576]
  (clojure.core/let
   [arg13578
    nil
    arg13579
    (bucket-tagging-configuration {})
    bean13575
    (new
     com.amazonaws.services.s3.model.SetBucketTaggingConfigurationRequest
     arg13578
     arg13579)]
   (clojure.core/let
    [v13577
     (:tagging-configuration
      m13576
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13577 :com.palletops.awaze.client-builder/undef)
     (.
      bean13575
      setTaggingConfiguration
      (s3/bucket-tagging-configuration v13577))))
   (clojure.core/let
    [v13577
     (:bucket-name m13576 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13577 :com.palletops.awaze.client-builder/undef)
     (. bean13575 setBucketName (clojure.core/str v13577))))
   bean13575))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetBucketCrossOriginConfigurationRequest}
get-bucket-cross-origin-configuration-request
  [m13581]
  (clojure.core/let
   [arg13583
    nil
    bean13580
    (new
     com.amazonaws.services.s3.model.GetBucketCrossOriginConfigurationRequest
     arg13583)]
   bean13580))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketPolicyRequest}
set-bucket-policy-request
  [m13585]
  (clojure.core/let
   [arg13587
    nil
    arg13588
    nil
    bean13584
    (new
     com.amazonaws.services.s3.model.SetBucketPolicyRequest
     arg13587
     arg13588)]
   (clojure.core/let
    [v13586
     (:policy-text m13585 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13586 :com.palletops.awaze.client-builder/undef)
     (. bean13584 setPolicyText (clojure.core/str v13586))))
   (clojure.core/let
    [v13586
     (:bucket-name m13585 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13586 :com.palletops.awaze.client-builder/undef)
     (. bean13584 setBucketName (clojure.core/str v13586))))
   bean13584))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ListNextBatchOfObjectsRequest}
list-next-batch-of-objects-request
  [m13590]
  (clojure.core/let
   [arg13592
    (object-listing {})
    bean13589
    (new
     com.amazonaws.services.s3.model.ListNextBatchOfObjectsRequest
     arg13592)]
   (clojure.core/let
    [v13591
     (:previous-object-listing
      m13590
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13591 :com.palletops.awaze.client-builder/undef)
     (. bean13589 setPreviousObjectListing (s3/object-listing v13591))))
   bean13589))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.InitiateMultipartUploadRequest}
initiate-multipart-upload-request
  [m13594]
  (clojure.core/let
   [arg13596
    nil
    arg13597
    nil
    bean13593
    (new
     com.amazonaws.services.s3.model.InitiateMultipartUploadRequest
     arg13596
     arg13597)]
   (clojure.core/let
    [v13595
     (:bucket-name m13594 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13595 :com.palletops.awaze.client-builder/undef)
     (. bean13593 setBucketName (clojure.core/str v13595))))
   (clojure.core/let
    [v13595
     (:ssecustomer-key
      m13594
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13595 :com.palletops.awaze.client-builder/undef)
     (. bean13593 setSSECustomerKey (s3/ssecustomer-key v13595))))
   (clojure.core/let
    [v13595
     (:canned-acl m13594 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13595 :com.palletops.awaze.client-builder/undef)
     (. bean13593 setCannedACL (s3/canned-access-control-list v13595))))
   (clojure.core/let
    [v13595
     (:storage-class m13594 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13595 :com.palletops.awaze.client-builder/undef)
     (. bean13593 setStorageClass (s3/storage-class v13595))))
   (clojure.core/let
    [v13595
     (:redirect-location
      m13594
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13595 :com.palletops.awaze.client-builder/undef)
     (. bean13593 setRedirectLocation (clojure.core/str v13595))))
   (clojure.core/let
    [v13595
     (:requester-pays
      m13594
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13595 :com.palletops.awaze.client-builder/undef)
     (. bean13593 setRequesterPays (clojure.core/boolean v13595))))
   (clojure.core/let
    [v13595
     (:object-metadata
      m13594
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13595 :com.palletops.awaze.client-builder/undef)
     (. bean13593 setObjectMetadata (s3/object-metadata v13595))))
   (clojure.core/let
    [v13595
     (:access-control-list
      m13594
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13595 :com.palletops.awaze.client-builder/undef)
     (.
      bean13593
      setAccessControlList
      (s3/access-control-list v13595))))
   (clojure.core/let
    [v13595 (:key m13594 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13595 :com.palletops.awaze.client-builder/undef)
     (. bean13593 setKey (clojure.core/str v13595))))
   (clojure.core/let
    [v13595
     (:sseaws-key-management-params
      m13594
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13595 :com.palletops.awaze.client-builder/undef)
     (.
      bean13593
      setSSEAwsKeyManagementParams
      (s3/sseaws-key-management-params v13595))))
   bean13593))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteBucketRequest}
delete-bucket-request
  [m13599]
  (clojure.core/let
   [arg13601
    nil
    bean13598
    (new com.amazonaws.services.s3.model.DeleteBucketRequest arg13601)]
   (clojure.core/let
    [v13600
     (:bucket-name m13599 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13600 :com.palletops.awaze.client-builder/undef)
     (. bean13598 setBucketName (clojure.core/str v13600))))
   bean13598))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetBucketTaggingConfigurationRequest}
get-bucket-tagging-configuration-request
  [m13603]
  (clojure.core/let
   [arg13605
    nil
    bean13602
    (new
     com.amazonaws.services.s3.model.GetBucketTaggingConfigurationRequest
     arg13605)]
   bean13602))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetBucketLocationRequest}
get-bucket-location-request
  [m13607]
  (clojure.core/let
   [arg13609
    nil
    bean13606
    (new
     com.amazonaws.services.s3.model.GetBucketLocationRequest
     arg13609)]
   (clojure.core/let
    [v13608
     (:bucket-name m13607 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13608 :com.palletops.awaze.client-builder/undef)
     (. bean13606 setBucketName (clojure.core/str v13608))))
   bean13606))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetObjectAclRequest}
get-object-acl-request
  [m13611]
  (clojure.core/let
   [arg13613
    nil
    arg13614
    nil
    bean13610
    (new
     com.amazonaws.services.s3.model.GetObjectAclRequest
     arg13613
     arg13614)]
   (clojure.core/let
    [v13612 (:key m13611 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13612 :com.palletops.awaze.client-builder/undef)
     (. bean13610 setKey (clojure.core/str v13612))))
   (clojure.core/let
    [v13612
     (:version-id m13611 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13612 :com.palletops.awaze.client-builder/undef)
     (. bean13610 setVersionId (clojure.core/str v13612))))
   (clojure.core/let
    [v13612
     (:requester-pays
      m13611
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13612 :com.palletops.awaze.client-builder/undef)
     (. bean13610 setRequesterPays (clojure.core/boolean v13612))))
   (clojure.core/let
    [v13612
     (:bucket-name m13611 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13612 :com.palletops.awaze.client-builder/undef)
     (. bean13610 setBucketName (clojure.core/str v13612))))
   bean13610))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.UploadPartRequest}
upload-part-request
  [m13616]
  (clojure.core/let
   [bean13615 (new com.amazonaws.services.s3.model.UploadPartRequest)]
   (clojure.core/let
    [v13617
     (:file-offset m13616 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13617 :com.palletops.awaze.client-builder/undef)
     (. bean13615 setFileOffset (clojure.core/long v13617))))
   (clojure.core/let
    [v13617
     (:progress-listener
      m13616
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13617 :com.palletops.awaze.client-builder/undef)
     (. bean13615 setProgressListener v13617)))
   (clojure.core/let
    [v13617
     (:bucket-name m13616 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13617 :com.palletops.awaze.client-builder/undef)
     (. bean13615 setBucketName (clojure.core/str v13617))))
   (clojure.core/let
    [v13617
     (:ssecustomer-key
      m13616
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13617 :com.palletops.awaze.client-builder/undef)
     (. bean13615 setSSECustomerKey (s3/ssecustomer-key v13617))))
   (clojure.core/let
    [v13617
     (:input-stream m13616 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13617 :com.palletops.awaze.client-builder/undef)
     (.
      bean13615
      setInputStream
      (clojure.java.io/input-stream v13617))))
   (clojure.core/let
    [v13617
     (:md5digest m13616 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13617 :com.palletops.awaze.client-builder/undef)
     (. bean13615 setMd5Digest (clojure.core/str v13617))))
   (clojure.core/let
    [v13617
     (:part-size m13616 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13617 :com.palletops.awaze.client-builder/undef)
     (. bean13615 setPartSize (clojure.core/long v13617))))
   (clojure.core/let
    [v13617
     (:requester-pays
      m13616
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13617 :com.palletops.awaze.client-builder/undef)
     (. bean13615 setRequesterPays (clojure.core/boolean v13617))))
   (clojure.core/let
    [v13617
     (:object-metadata
      m13616
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13617 :com.palletops.awaze.client-builder/undef)
     (. bean13615 setObjectMetadata (s3/object-metadata v13617))))
   (clojure.core/let
    [v13617 (:key m13616 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13617 :com.palletops.awaze.client-builder/undef)
     (. bean13615 setKey (clojure.core/str v13617))))
   (clojure.core/let
    [v13617
     (:part-number m13616 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13617 :com.palletops.awaze.client-builder/undef)
     (. bean13615 setPartNumber (clojure.core/int v13617))))
   (clojure.core/let
    [v13617 (:file m13616 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13617 :com.palletops.awaze.client-builder/undef)
     (. bean13615 setFile (clojure.java.io/file v13617))))
   (clojure.core/let
    [v13617
     (:last-part m13616 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13617 :com.palletops.awaze.client-builder/undef)
     (. bean13615 setLastPart (clojure.core/boolean v13617))))
   (clojure.core/let
    [v13617
     (:upload-id m13616 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13617 :com.palletops.awaze.client-builder/undef)
     (. bean13615 setUploadId (clojure.core/str v13617))))
   bean13615))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketWebsiteConfigurationRequest}
set-bucket-website-configuration-request
  [m13619]
  (clojure.core/let
   [arg13621
    nil
    arg13622
    (bucket-website-configuration {})
    bean13618
    (new
     com.amazonaws.services.s3.model.SetBucketWebsiteConfigurationRequest
     arg13621
     arg13622)]
   (clojure.core/let
    [v13620
     (:configuration m13619 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13620 :com.palletops.awaze.client-builder/undef)
     (.
      bean13618
      setConfiguration
      (s3/bucket-website-configuration v13620))))
   (clojure.core/let
    [v13620
     (:bucket-name m13619 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13620 :com.palletops.awaze.client-builder/undef)
     (. bean13618 setBucketName (clojure.core/str v13620))))
   bean13618))
 (clojure.core/defmulti
  s3
  (clojure.core/fn s3 [m__1874__auto__] (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   s3
   :delete-bucket-website-configuration
   [m13648]
   (clojure.core/let
    [credentials13649 (:credentials m13648) args13650 (:args m13648)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13651
      (com.palletops.awaze.common/aws-client :s3 credentials13649)]
     (clojure.core/case
      (clojure.core/count args13650)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.DeleteBucketWebsiteConfigurationRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.DeleteBucketWebsiteConfigurationRequest
           (clojure.core/nth args13650 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13651
           deleteBucketWebsiteConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13650 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13651
               deleteBucketWebsiteConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteBucketWebsiteConfiguration")
                {:args args13650}))))))))))))))
  (clojure.core/defn
   delete-bucket-website-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]
                [credentials string-0]]),
    :doc "Generate map for deleteBucketWebsiteConfiguration, deleteBucketWebsiteConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-bucket-website-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   delete-bucket-website-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]
                [credentials string-0]]),
    :doc "Call deleteBucketWebsiteConfiguration, deleteBucketWebsiteConfiguration"}
   [credentials13654 & args13655]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13657
     (com.palletops.awaze.common/aws-client :s3 credentials13654)]
    (clojure.core/case
     (clojure.core/count args13655)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.DeleteBucketWebsiteConfigurationRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.DeleteBucketWebsiteConfigurationRequest
          (clojure.core/nth args13655 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13657
          deleteBucketWebsiteConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13655 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13657
              deleteBucketWebsiteConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteBucketWebsiteConfiguration")
               {:args args13655}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :set-object-acl
   [m13658]
   (clojure.core/let
    [credentials13659 (:credentials m13658) args13660 (:args m13658)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13661
      (com.palletops.awaze.common/aws-client :s3 credentials13659)]
     (clojure.core/case
      (clojure.core/count args13660)
      5
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13660 0))
^{:tag java.lang.String}
b
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13660 1))
^{:tag java.lang.String}
c
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13660 2))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
d
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.AccessControlList
           (clojure.core/nth args13660 3))
^{:tag com.amazonaws.metrics.RequestMetricCollector}
e
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.metrics.RequestMetricCollector
           (clojure.core/nth args13660 4))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13661
           setObjectAcl
           a
           b
           c
           d
           e)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13660 0))
^{:tag java.lang.String}
b
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13660 1))
^{:tag java.lang.String}
c
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13660 2))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
d
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.CannedAccessControlList
               (clojure.core/nth args13660 3))
^{:tag com.amazonaws.metrics.RequestMetricCollector}
e
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.metrics.RequestMetricCollector
               (clojure.core/nth args13660 4))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13661
               setObjectAcl
               a
               b
               c
               d
               e)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "setObjectAcl")
                {:args args13660}))))))))))
      4
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13660 0))
^{:tag java.lang.String}
b
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13660 1))
^{:tag java.lang.String}
c
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13660 2))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
d
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.CannedAccessControlList
           (clojure.core/nth args13660 3))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13661
           setObjectAcl
           a
           b
           c
           d)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13660 0))
^{:tag java.lang.String}
b
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13660 1))
^{:tag java.lang.String}
c
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13660 2))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
d
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.AccessControlList
               (clojure.core/nth args13660 3))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13661
               setObjectAcl
               a
               b
               c
               d)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "setObjectAcl")
                {:args args13660}))))))))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13661
        setObjectAcl
        (s3/set-object-acl-request (clojure.core/nth args13660 0))))
      3
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13660 0))
^{:tag java.lang.String}
b
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13660 1))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
c
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.CannedAccessControlList
           (clojure.core/nth args13660 2))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13661
           setObjectAcl
           a
           b
           c)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13660 0))
^{:tag java.lang.String}
b
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13660 1))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
c
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.AccessControlList
               (clojure.core/nth args13660 2))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13661
               setObjectAcl
               a
               b
               c)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "setObjectAcl")
                {:args args13660}))))))))))))))
  (clojure.core/defn
   set-object-acl-map
   {:arglists (quote
               [[credentials
                 string-0
                 string-1
                 string-2
                 {:keys [grants
                         grants-as-list
                         owner
                         requester-charged]}
                 request-metric-collector-4]
                [credentials
                 string-0
                 string-1
                 string-2
                 canned-access-control-list-3]
                [credentials
                 string-0
                 string-1
                 string-2
                 canned-access-control-list-3
                 request-metric-collector-4]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         acl
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays
                         canned-acl]}]
                [credentials
                 string-0
                 string-1
                 string-2
                 {:keys [grants
                         grants-as-list
                         owner
                         requester-charged]}]
                [credentials
                 string-0
                 string-1
                 canned-access-control-list-2]
                [credentials
                 string-0
                 string-1
                 {:keys [grants
                         grants-as-list
                         owner
                         requester-charged]}]]),
    :doc "Generate map for setObjectAcl, setObjectAcl, setObjectAcl, setObjectAcl, setObjectAcl, setObjectAcl, setObjectAcl"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-object-acl,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b c]
    {:args [a b c],
     :fn :set-object-acl,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b c d]
    {:args [a b c d],
     :fn :set-object-acl,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b c d e]
    {:args [a b c d e],
     :fn :set-object-acl,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   set-object-acl
   {:arglists (quote
               [[credentials
                 string-0
                 string-1
                 string-2
                 {:keys [grants
                         grants-as-list
                         owner
                         requester-charged]}
                 request-metric-collector-4]
                [credentials
                 string-0
                 string-1
                 string-2
                 canned-access-control-list-3]
                [credentials
                 string-0
                 string-1
                 string-2
                 canned-access-control-list-3
                 request-metric-collector-4]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         acl
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays
                         canned-acl]}]
                [credentials
                 string-0
                 string-1
                 string-2
                 {:keys [grants
                         grants-as-list
                         owner
                         requester-charged]}]
                [credentials
                 string-0
                 string-1
                 canned-access-control-list-2]
                [credentials
                 string-0
                 string-1
                 {:keys [grants
                         grants-as-list
                         owner
                         requester-charged]}]]),
    :doc "Call setObjectAcl, setObjectAcl, setObjectAcl, setObjectAcl, setObjectAcl, setObjectAcl, setObjectAcl"}
   [credentials13669 & args13670]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13677
     (com.palletops.awaze.common/aws-client :s3 credentials13669)]
    (clojure.core/case
     (clojure.core/count args13670)
     5
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13670 0))
^{:tag java.lang.String}
b
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13670 1))
^{:tag java.lang.String}
c
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13670 2))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
d
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.AccessControlList
          (clojure.core/nth args13670 3))
^{:tag com.amazonaws.metrics.RequestMetricCollector}
e
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.metrics.RequestMetricCollector
          (clojure.core/nth args13670 4))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13677
          setObjectAcl
          a
          b
          c
          d
          e)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13670 0))
^{:tag java.lang.String}
b
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13670 1))
^{:tag java.lang.String}
c
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13670 2))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
d
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.CannedAccessControlList
              (clojure.core/nth args13670 3))
^{:tag com.amazonaws.metrics.RequestMetricCollector}
e
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.metrics.RequestMetricCollector
              (clojure.core/nth args13670 4))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13677
              setObjectAcl
              a
              b
              c
              d
              e)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "setObjectAcl")
               {:args args13670}))))))))))
     4
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13670 0))
^{:tag java.lang.String}
b
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13670 1))
^{:tag java.lang.String}
c
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13670 2))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
d
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.CannedAccessControlList
          (clojure.core/nth args13670 3))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13677
          setObjectAcl
          a
          b
          c
          d)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13670 0))
^{:tag java.lang.String}
b
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13670 1))
^{:tag java.lang.String}
c
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13670 2))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
d
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.AccessControlList
              (clojure.core/nth args13670 3))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13677
              setObjectAcl
              a
              b
              c
              d)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "setObjectAcl")
               {:args args13670}))))))))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13677
       setObjectAcl
       (s3/set-object-acl-request (clojure.core/nth args13670 0))))
     3
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13670 0))
^{:tag java.lang.String}
b
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13670 1))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
c
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.CannedAccessControlList
          (clojure.core/nth args13670 2))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13677
          setObjectAcl
          a
          b
          c)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13670 0))
^{:tag java.lang.String}
b
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13670 1))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
c
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.AccessControlList
              (clojure.core/nth args13670 2))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13677
              setObjectAcl
              a
              b
              c)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "setObjectAcl")
               {:args args13670}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-lifecycle-configuration
   [m13678]
   (clojure.core/let
    [credentials13679 (:credentials m13678) args13680 (:args m13678)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13681
      (com.palletops.awaze.common/aws-client :s3 credentials13679)]
     (clojure.core/case
      (clojure.core/count args13680)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13680 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13681
           getBucketLifecycleConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.GetBucketLifecycleConfigurationRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.GetBucketLifecycleConfigurationRequest
               (clojure.core/nth args13680 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13681
               getBucketLifecycleConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketLifecycleConfiguration")
                {:args args13680}))))))))))))))
  (clojure.core/defn
   get-bucket-lifecycle-configuration-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Generate map for getBucketLifecycleConfiguration, getBucketLifecycleConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-bucket-lifecycle-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-bucket-lifecycle-configuration
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Call getBucketLifecycleConfiguration, getBucketLifecycleConfiguration"}
   [credentials13684 & args13685]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13687
     (com.palletops.awaze.common/aws-client :s3 credentials13684)]
    (clojure.core/case
     (clojure.core/count args13685)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13685 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13687
          getBucketLifecycleConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.GetBucketLifecycleConfigurationRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.GetBucketLifecycleConfigurationRequest
              (clojure.core/nth args13685 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13687
              getBucketLifecycleConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketLifecycleConfiguration")
               {:args args13685}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :list-multipart-uploads
   [m13688]
   (clojure.core/let
    [credentials13689 (:credentials m13688) args13690 (:args m13688)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13691
      (com.palletops.awaze.common/aws-client :s3 credentials13689)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13691
       listMultipartUploads
       (s3/list-multipart-uploads-request
        (clojure.core/nth args13690 0)))))))
  (clojure.core/defn
   list-multipart-uploads-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         encoding-type
                         upload-id-marker
                         sdk-request-timeout
                         custom-query-parameters
                         max-uploads
                         prefix
                         delimiter
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         key-marker]}]]),
    :doc "Generate map for listMultipartUploads"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-multipart-uploads,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   list-multipart-uploads
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         encoding-type
                         upload-id-marker
                         sdk-request-timeout
                         custom-query-parameters
                         max-uploads
                         prefix
                         delimiter
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         key-marker]}]]),
    :doc "Call listMultipartUploads"}
   [credentials13694 & args13695]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13697
     (com.palletops.awaze.common/aws-client :s3 credentials13694)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13697
      listMultipartUploads
      (s3/list-multipart-uploads-request
       (clojure.core/nth args13695 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-object-metadata
   [m13698]
   (clojure.core/let
    [credentials13699 (:credentials m13698) args13700 (:args m13698)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13701
      (com.palletops.awaze.common/aws-client :s3 credentials13699)]
     (clojure.core/case
      (clojure.core/count args13700)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13701
        getObjectMetadata
        (s3/get-object-metadata-request
         (clojure.core/nth args13700 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13701
        getObjectMetadata
        (clojure.core/str (clojure.core/nth args13700 0))
        (clojure.core/str (clojure.core/nth args13700 1))))))))
  (clojure.core/defn
   get-object-metadata-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         ssecustomer-key
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays]}]
                [credentials string-0 string-1]]),
    :doc "Generate map for getObjectMetadata, getObjectMetadata"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-object-metadata,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :get-object-metadata,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-object-metadata
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         ssecustomer-key
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays]}]
                [credentials string-0 string-1]]),
    :doc "Call getObjectMetadata, getObjectMetadata"}
   [credentials13705 & args13706]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13709
     (com.palletops.awaze.common/aws-client :s3 credentials13705)]
    (clojure.core/case
     (clojure.core/count args13706)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13709
       getObjectMetadata
       (s3/get-object-metadata-request (clojure.core/nth args13706 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13709
       getObjectMetadata
       (clojure.core/str (clojure.core/nth args13706 0))
       (clojure.core/str (clojure.core/nth args13706 1))))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-cross-origin-configuration
   [m13710]
   (clojure.core/let
    [credentials13711 (:credentials m13710) args13712 (:args m13710)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13713
      (com.palletops.awaze.common/aws-client :s3 credentials13711)]
     (clojure.core/case
      (clojure.core/count args13712)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13713
        setBucketCrossOriginConfiguration
        (s3/set-bucket-cross-origin-configuration-request
         (clojure.core/nth args13712 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13713
        setBucketCrossOriginConfiguration
        (clojure.core/str (clojure.core/nth args13712 0))
        (s3/bucket-cross-origin-configuration
         (clojure.core/nth args13712 1))))))))
  (clojure.core/defn
   set-bucket-cross-origin-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         cross-origin-configuration
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]
                [credentials string-0 {:keys [rules]}]]),
    :doc "Generate map for setBucketCrossOriginConfiguration, setBucketCrossOriginConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-bucket-cross-origin-configuration,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :set-bucket-cross-origin-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   set-bucket-cross-origin-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         cross-origin-configuration
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]
                [credentials string-0 {:keys [rules]}]]),
    :doc "Call setBucketCrossOriginConfiguration, setBucketCrossOriginConfiguration"}
   [credentials13717 & args13718]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13721
     (com.palletops.awaze.common/aws-client :s3 credentials13717)]
    (clojure.core/case
     (clojure.core/count args13718)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13721
       setBucketCrossOriginConfiguration
       (s3/set-bucket-cross-origin-configuration-request
        (clojure.core/nth args13718 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13721
       setBucketCrossOriginConfiguration
       (clojure.core/str (clojure.core/nth args13718 0))
       (s3/bucket-cross-origin-configuration
        (clojure.core/nth args13718 1))))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-bucket-replication-configuration
   [m13722]
   (clojure.core/let
    [credentials13723 (:credentials m13722) args13724 (:args m13722)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13725
      (com.palletops.awaze.common/aws-client :s3 credentials13723)]
     (clojure.core/case
      (clojure.core/count args13724)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13724 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13725
           deleteBucketReplicationConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.DeleteBucketReplicationConfigurationRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.DeleteBucketReplicationConfigurationRequest
               (clojure.core/nth args13724 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13725
               deleteBucketReplicationConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteBucketReplicationConfiguration")
                {:args args13724}))))))))))))))
  (clojure.core/defn
   delete-bucket-replication-configuration-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Generate map for deleteBucketReplicationConfiguration, deleteBucketReplicationConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-bucket-replication-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   delete-bucket-replication-configuration
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Call deleteBucketReplicationConfiguration, deleteBucketReplicationConfiguration"}
   [credentials13728 & args13729]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13731
     (com.palletops.awaze.common/aws-client :s3 credentials13728)]
    (clojure.core/case
     (clojure.core/count args13729)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13729 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13731
          deleteBucketReplicationConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.DeleteBucketReplicationConfigurationRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.DeleteBucketReplicationConfigurationRequest
              (clojure.core/nth args13729 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13731
              deleteBucketReplicationConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteBucketReplicationConfiguration")
               {:args args13729}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-lifecycle-configuration
   [m13732]
   (clojure.core/let
    [credentials13733 (:credentials m13732) args13734 (:args m13732)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13735
      (com.palletops.awaze.common/aws-client :s3 credentials13733)]
     (clojure.core/case
      (clojure.core/count args13734)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13735
        setBucketLifecycleConfiguration
        (s3/set-bucket-lifecycle-configuration-request
         (clojure.core/nth args13734 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13735
        setBucketLifecycleConfiguration
        (clojure.core/str (clojure.core/nth args13734 0))
        (s3/bucket-lifecycle-configuration
         (clojure.core/nth args13734 1))))))))
  (clojure.core/defn
   set-bucket-lifecycle-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         lifecycle-configuration
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]
                [credentials string-0 {:keys [rules]}]]),
    :doc "Generate map for setBucketLifecycleConfiguration, setBucketLifecycleConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-bucket-lifecycle-configuration,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :set-bucket-lifecycle-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   set-bucket-lifecycle-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         lifecycle-configuration
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]
                [credentials string-0 {:keys [rules]}]]),
    :doc "Call setBucketLifecycleConfiguration, setBucketLifecycleConfiguration"}
   [credentials13739 & args13740]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13743
     (com.palletops.awaze.common/aws-client :s3 credentials13739)]
    (clojure.core/case
     (clojure.core/count args13740)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13743
       setBucketLifecycleConfiguration
       (s3/set-bucket-lifecycle-configuration-request
        (clojure.core/nth args13740 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13743
       setBucketLifecycleConfiguration
       (clojure.core/str (clojure.core/nth args13740 0))
       (s3/bucket-lifecycle-configuration
        (clojure.core/nth args13740 1))))))))
 (do
  (clojure.core/defmethod
   s3
   :does-object-exist
   [m13744]
   (clojure.core/let
    [credentials13745 (:credentials m13744) args13746 (:args m13744)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13747
      (com.palletops.awaze.common/aws-client :s3 credentials13745)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13747
       doesObjectExist
       (clojure.core/str (clojure.core/nth args13746 0))
       (clojure.core/str (clojure.core/nth args13746 1)))))))
  (clojure.core/defn
   does-object-exist-map
   {:arglists (quote [[credentials string-0 string-1]]),
    :doc "Generate map for doesObjectExist"}
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :does-object-exist,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   does-object-exist
   {:arglists (quote [[credentials string-0 string-1]]),
    :doc "Call doesObjectExist"}
   [credentials13749 & args13750]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13751
     (com.palletops.awaze.common/aws-client :s3 credentials13749)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13751
      doesObjectExist
      (clojure.core/str (clojure.core/nth args13750 0))
      (clojure.core/str (clojure.core/nth args13750 1)))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-notification-configuration
   [m13752]
   (clojure.core/let
    [credentials13753 (:credentials m13752) args13754 (:args m13752)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13755
      (com.palletops.awaze.common/aws-client :s3 credentials13753)]
     (clojure.core/case
      (clojure.core/count args13754)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13755
        setBucketNotificationConfiguration
        (s3/set-bucket-notification-configuration-request
         (clojure.core/nth args13754 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13755
        setBucketNotificationConfiguration
        (clojure.core/str (clojure.core/nth args13754 0))
        (s3/bucket-notification-configuration
         (clojure.core/nth args13754 1))))))))
  (clojure.core/defn
   set-bucket-notification-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         notification-configuration
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         bucket-notification-configuration
                         clone-root
                         bucket]}]
                [credentials
                 string-0
                 {:keys [configurations topic-configurations]}]]),
    :doc "Generate map for setBucketNotificationConfiguration, setBucketNotificationConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-bucket-notification-configuration,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :set-bucket-notification-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   set-bucket-notification-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         notification-configuration
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         bucket-notification-configuration
                         clone-root
                         bucket]}]
                [credentials
                 string-0
                 {:keys [configurations topic-configurations]}]]),
    :doc "Call setBucketNotificationConfiguration, setBucketNotificationConfiguration"}
   [credentials13761 & args13762]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13767
     (com.palletops.awaze.common/aws-client :s3 credentials13761)]
    (clojure.core/case
     (clojure.core/count args13762)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13767
       setBucketNotificationConfiguration
       (s3/set-bucket-notification-configuration-request
        (clojure.core/nth args13762 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13767
       setBucketNotificationConfiguration
       (clojure.core/str (clojure.core/nth args13762 0))
       (s3/bucket-notification-configuration
        (clojure.core/nth args13762 1))))))))
 (do
  (clojure.core/defmethod
   s3
   :set-object-redirect-location
   [m13768]
   (clojure.core/let
    [credentials13769 (:credentials m13768) args13770 (:args m13768)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13771
      (com.palletops.awaze.common/aws-client :s3 credentials13769)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13771
       setObjectRedirectLocation
       (clojure.core/str (clojure.core/nth args13770 0))
       (clojure.core/str (clojure.core/nth args13770 1))
       (clojure.core/str (clojure.core/nth args13770 2)))))))
  (clojure.core/defn
   set-object-redirect-location-map
   {:arglists (quote [[credentials string-0 string-1 string-2]]),
    :doc "Generate map for setObjectRedirectLocation"}
   ([credentials__1842__auto__ a b c]
    {:args [a b c],
     :fn :set-object-redirect-location,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   set-object-redirect-location
   {:arglists (quote [[credentials string-0 string-1 string-2]]),
    :doc "Call setObjectRedirectLocation"}
   [credentials13773 & args13774]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13775
     (com.palletops.awaze.common/aws-client :s3 credentials13773)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13775
      setObjectRedirectLocation
      (clojure.core/str (clojure.core/nth args13774 0))
      (clojure.core/str (clojure.core/nth args13774 1))
      (clojure.core/str (clojure.core/nth args13774 2)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-url
   [m13776]
   (clojure.core/let
    [credentials13777 (:credentials m13776) args13778 (:args m13776)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13779
      (com.palletops.awaze.common/aws-client :s3 credentials13777)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13779
       getUrl
       (clojure.core/str (clojure.core/nth args13778 0))
       (clojure.core/str (clojure.core/nth args13778 1)))))))
  (clojure.core/defn
   get-url-map
   {:arglists (quote [[credentials string-0 string-1]]),
    :doc "Generate map for getUrl"}
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :get-url,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-url
   {:arglists (quote [[credentials string-0 string-1]]),
    :doc "Call getUrl"}
   [credentials13781 & args13782]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13783
     (com.palletops.awaze.common/aws-client :s3 credentials13781)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13783
      getUrl
      (clojure.core/str (clojure.core/nth args13782 0))
      (clojure.core/str (clojure.core/nth args13782 1)))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-bucket-policy
   [m13784]
   (clojure.core/let
    [credentials13785 (:credentials m13784) args13786 (:args m13784)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13787
      (com.palletops.awaze.common/aws-client :s3 credentials13785)]
     (clojure.core/case
      (clojure.core/count args13786)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13786 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13787
           deleteBucketPolicy
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.DeleteBucketPolicyRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.DeleteBucketPolicyRequest
               (clojure.core/nth args13786 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13787
               deleteBucketPolicy
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteBucketPolicy")
                {:args args13786}))))))))))))))
  (clojure.core/defn
   delete-bucket-policy-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteBucketPolicy, deleteBucketPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-bucket-policy,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   delete-bucket-policy
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteBucketPolicy, deleteBucketPolicy"}
   [credentials13790 & args13791]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13793
     (com.palletops.awaze.common/aws-client :s3 credentials13790)]
    (clojure.core/case
     (clojure.core/count args13791)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13791 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13793
          deleteBucketPolicy
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.DeleteBucketPolicyRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.DeleteBucketPolicyRequest
              (clojure.core/nth args13791 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13793
              deleteBucketPolicy
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteBucketPolicy")
               {:args args13791}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :disable-requester-pays
   [m13794]
   (clojure.core/let
    [credentials13795 (:credentials m13794) args13796 (:args m13794)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13797
      (com.palletops.awaze.common/aws-client :s3 credentials13795)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13797
       disableRequesterPays
       (clojure.core/str (clojure.core/nth args13796 0)))))))
  (clojure.core/defn
   disable-requester-pays-map
   {:arglists (quote [[credentials string-0]]),
    :doc "Generate map for disableRequesterPays"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :disable-requester-pays,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   disable-requester-pays
   {:arglists (quote [[credentials string-0]]),
    :doc "Call disableRequesterPays"}
   [credentials13799 & args13800]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13801
     (com.palletops.awaze.common/aws-client :s3 credentials13799)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13801
      disableRequesterPays
      (clojure.core/str (clojure.core/nth args13800 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :head-bucket
   [m13802]
   (clojure.core/let
    [credentials13803 (:credentials m13802) args13804 (:args m13802)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13805
      (com.palletops.awaze.common/aws-client :s3 credentials13803)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13805
       headBucket
       (s3/head-bucket-request (clojure.core/nth args13804 0)))))))
  (clojure.core/defn
   head-bucket-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for headBucket"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :head-bucket,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   head-bucket
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Call headBucket"}
   [credentials13808 & args13809]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13811
     (com.palletops.awaze.common/aws-client :s3 credentials13808)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13811
      headBucket
      (s3/head-bucket-request (clojure.core/nth args13809 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :set-s3client-options
   [m13812]
   (clojure.core/let
    [credentials13813 (:credentials m13812) args13814 (:args m13812)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13815
      (com.palletops.awaze.common/aws-client :s3 credentials13813)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13815
       setS3ClientOptions
       (s3/s3client-options (clojure.core/nth args13814 0)))))))
  (clojure.core/defn
   set-s3client-options-map
   {:arglists (quote
               [[credentials
                 {:keys [chunked-encoding-disabled path-style-access]}]]),
    :doc "Generate map for setS3ClientOptions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-s3client-options,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   set-s3client-options
   {:arglists (quote
               [[credentials
                 {:keys [chunked-encoding-disabled path-style-access]}]]),
    :doc "Call setS3ClientOptions"}
   [credentials13817 & args13818]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13819
     (com.palletops.awaze.common/aws-client :s3 credentials13817)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13819
      setS3ClientOptions
      (s3/s3client-options (clojure.core/nth args13818 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-notification-configuration
   [m13820]
   (clojure.core/let
    [credentials13821 (:credentials m13820) args13822 (:args m13820)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13823
      (com.palletops.awaze.common/aws-client :s3 credentials13821)]
     (clojure.core/case
      (clojure.core/count args13822)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13822 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13823
           getBucketNotificationConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.GetBucketNotificationConfigurationRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.GetBucketNotificationConfigurationRequest
               (clojure.core/nth args13822 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13823
               getBucketNotificationConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketNotificationConfiguration")
                {:args args13822}))))))))))))))
  (clojure.core/defn
   get-bucket-notification-configuration-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Generate map for getBucketNotificationConfiguration, getBucketNotificationConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-bucket-notification-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-bucket-notification-configuration
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Call getBucketNotificationConfiguration, getBucketNotificationConfiguration"}
   [credentials13826 & args13827]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13829
     (com.palletops.awaze.common/aws-client :s3 credentials13826)]
    (clojure.core/case
     (clojure.core/count args13827)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13827 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13829
          getBucketNotificationConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.GetBucketNotificationConfigurationRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.GetBucketNotificationConfigurationRequest
              (clojure.core/nth args13827 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13829
              getBucketNotificationConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketNotificationConfiguration")
               {:args args13827}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-bucket-lifecycle-configuration
   [m13830]
   (clojure.core/let
    [credentials13831 (:credentials m13830) args13832 (:args m13830)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13833
      (com.palletops.awaze.common/aws-client :s3 credentials13831)]
     (clojure.core/case
      (clojure.core/count args13832)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.DeleteBucketLifecycleConfigurationRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.DeleteBucketLifecycleConfigurationRequest
           (clojure.core/nth args13832 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13833
           deleteBucketLifecycleConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13832 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13833
               deleteBucketLifecycleConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteBucketLifecycleConfiguration")
                {:args args13832}))))))))))))))
  (clojure.core/defn
   delete-bucket-lifecycle-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]
                [credentials string-0]]),
    :doc "Generate map for deleteBucketLifecycleConfiguration, deleteBucketLifecycleConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-bucket-lifecycle-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   delete-bucket-lifecycle-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]
                [credentials string-0]]),
    :doc "Call deleteBucketLifecycleConfiguration, deleteBucketLifecycleConfiguration"}
   [credentials13836 & args13837]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13839
     (com.palletops.awaze.common/aws-client :s3 credentials13836)]
    (clojure.core/case
     (clojure.core/count args13837)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.DeleteBucketLifecycleConfigurationRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.DeleteBucketLifecycleConfigurationRequest
          (clojure.core/nth args13837 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13839
          deleteBucketLifecycleConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13837 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13839
              deleteBucketLifecycleConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteBucketLifecycleConfiguration")
               {:args args13837}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :list-objects
   [m13840]
   (clojure.core/let
    [credentials13841 (:credentials m13840) args13842 (:args m13840)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13843
      (com.palletops.awaze.common/aws-client :s3 credentials13841)]
     (clojure.core/case
      (clojure.core/count args13842)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13843
        listObjects
        (clojure.core/str (clojure.core/nth args13842 0))
        (clojure.core/str (clojure.core/nth args13842 1))))
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13842 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13843
           listObjects
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.ListObjectsRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.ListObjectsRequest
               (clojure.core/nth args13842 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13843
               listObjects
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "listObjects")
                {:args args13842}))))))))))))))
  (clojure.core/defn
   list-objects-map
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         encoding-type
                         sdk-request-timeout
                         marker
                         max-keys
                         custom-query-parameters
                         prefix
                         delimiter
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listObjects, listObjects, listObjects"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-objects,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :list-objects,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   list-objects
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         encoding-type
                         sdk-request-timeout
                         marker
                         max-keys
                         custom-query-parameters
                         prefix
                         delimiter
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Call listObjects, listObjects, listObjects"}
   [credentials13845 & args13846]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13847
     (com.palletops.awaze.common/aws-client :s3 credentials13845)]
    (clojure.core/case
     (clojure.core/count args13846)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13847
       listObjects
       (clojure.core/str (clojure.core/nth args13846 0))
       (clojure.core/str (clojure.core/nth args13846 1))))
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13846 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13847
          listObjects
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.ListObjectsRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.ListObjectsRequest
              (clojure.core/nth args13846 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13847
              listObjects
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "listObjects")
               {:args args13846}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-resource-url
   [m13848]
   (clojure.core/let
    [credentials13849 (:credentials m13848) args13850 (:args m13848)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13851
      (com.palletops.awaze.common/aws-client :s3 credentials13849)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13851
       getResourceUrl
       (clojure.core/str (clojure.core/nth args13850 0))
       (clojure.core/str (clojure.core/nth args13850 1)))))))
  (clojure.core/defn
   get-resource-url-map
   {:arglists (quote [[credentials string-0 string-1]]),
    :doc "Generate map for getResourceUrl"}
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :get-resource-url,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-resource-url
   {:arglists (quote [[credentials string-0 string-1]]),
    :doc "Call getResourceUrl"}
   [credentials13853 & args13854]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13855
     (com.palletops.awaze.common/aws-client :s3 credentials13853)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13855
      getResourceUrl
      (clojure.core/str (clojure.core/nth args13854 0))
      (clojure.core/str (clojure.core/nth args13854 1)))))))
 (do
  (clojure.core/defmethod
   s3
   :enable-requester-pays
   [m13856]
   (clojure.core/let
    [credentials13857 (:credentials m13856) args13858 (:args m13856)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13859
      (com.palletops.awaze.common/aws-client :s3 credentials13857)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13859
       enableRequesterPays
       (clojure.core/str (clojure.core/nth args13858 0)))))))
  (clojure.core/defn
   enable-requester-pays-map
   {:arglists (quote [[credentials string-0]]),
    :doc "Generate map for enableRequesterPays"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :enable-requester-pays,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   enable-requester-pays
   {:arglists (quote [[credentials string-0]]),
    :doc "Call enableRequesterPays"}
   [credentials13861 & args13862]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13863
     (com.palletops.awaze.common/aws-client :s3 credentials13861)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13863
      enableRequesterPays
      (clojure.core/str (clojure.core/nth args13862 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :abort-multipart-upload
   [m13864]
   (clojure.core/let
    [credentials13865 (:credentials m13864) args13866 (:args m13864)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13867
      (com.palletops.awaze.common/aws-client :s3 credentials13865)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13867
       abortMultipartUpload
       (s3/abort-multipart-upload-request
        (clojure.core/nth args13866 0)))))))
  (clojure.core/defn
   abort-multipart-upload-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         upload-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays]}]]),
    :doc "Generate map for abortMultipartUpload"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :abort-multipart-upload,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   abort-multipart-upload
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         upload-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays]}]]),
    :doc "Call abortMultipartUpload"}
   [credentials13872 & args13873]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13877
     (com.palletops.awaze.common/aws-client :s3 credentials13872)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13877
      abortMultipartUpload
      (s3/abort-multipart-upload-request
       (clojure.core/nth args13873 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-s3account-owner
   [m13878]
   (clojure.core/let
    [credentials13879 (:credentials m13878) args13880 (:args m13878)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13881
      (com.palletops.awaze.common/aws-client :s3 credentials13879)]
     (clojure.core/case
      (clojure.core/count args13880)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13881
        getS3AccountOwner
        (s3/get-s3account-owner-request
         (clojure.core/nth args13880 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13881
        getS3AccountOwner))))))
  (clojure.core/defn
   get-s3account-owner-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for getS3AccountOwner, getS3AccountOwner"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-s3account-owner,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-s3account-owner,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-s3account-owner
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call getS3AccountOwner, getS3AccountOwner"}
   [credentials13883 & args13884]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13885
     (com.palletops.awaze.common/aws-client :s3 credentials13883)]
    (clojure.core/case
     (clojure.core/count args13884)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13885
       getS3AccountOwner
       (s3/get-s3account-owner-request (clojure.core/nth args13884 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13885
       getS3AccountOwner))))))
 (do
  (clojure.core/defmethod
   s3
   :list-buckets
   [m13886]
   (clojure.core/let
    [credentials13887 (:credentials m13886) args13888 (:args m13886)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13889
      (com.palletops.awaze.common/aws-client :s3 credentials13887)]
     (clojure.core/case
      (clojure.core/count args13888)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13889
        listBuckets
        (s3/list-buckets-request (clojure.core/nth args13888 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13889
        listBuckets))))))
  (clojure.core/defn
   list-buckets-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listBuckets, listBuckets"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-buckets,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-buckets,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   list-buckets
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listBuckets, listBuckets"}
   [credentials13891 & args13892]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13893
     (com.palletops.awaze.common/aws-client :s3 credentials13891)]
    (clojure.core/case
     (clojure.core/count args13892)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13893
       listBuckets
       (s3/list-buckets-request (clojure.core/nth args13892 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13893
       listBuckets))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-website-configuration
   [m13894]
   (clojure.core/let
    [credentials13895 (:credentials m13894) args13896 (:args m13894)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13897
      (com.palletops.awaze.common/aws-client :s3 credentials13895)]
     (clojure.core/case
      (clojure.core/count args13896)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.GetBucketWebsiteConfigurationRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.GetBucketWebsiteConfigurationRequest
           (clojure.core/nth args13896 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13897
           getBucketWebsiteConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13896 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13897
               getBucketWebsiteConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketWebsiteConfiguration")
                {:args args13896}))))))))))))))
  (clojure.core/defn
   get-bucket-website-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]
                [credentials string-0]]),
    :doc "Generate map for getBucketWebsiteConfiguration, getBucketWebsiteConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-bucket-website-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-bucket-website-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]
                [credentials string-0]]),
    :doc "Call getBucketWebsiteConfiguration, getBucketWebsiteConfiguration"}
   [credentials13900 & args13901]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13903
     (com.palletops.awaze.common/aws-client :s3 credentials13900)]
    (clojure.core/case
     (clojure.core/count args13901)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.GetBucketWebsiteConfigurationRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.GetBucketWebsiteConfigurationRequest
          (clojure.core/nth args13901 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13903
          getBucketWebsiteConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13901 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13903
              getBucketWebsiteConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketWebsiteConfiguration")
               {:args args13901}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :list-parts
   [m13904]
   (clojure.core/let
    [credentials13905 (:credentials m13904) args13906 (:args m13904)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13907
      (com.palletops.awaze.common/aws-client :s3 credentials13905)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13907
       listParts
       (s3/list-parts-request (clojure.core/nth args13906 0)))))))
  (clojure.core/defn
   list-parts-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         encoding-type
                         key
                         sdk-request-timeout
                         upload-id
                         custom-query-parameters
                         part-number-marker
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         max-parts
                         clone-root
                         requester-pays]}]]),
    :doc "Generate map for listParts"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-parts,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   list-parts
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         encoding-type
                         key
                         sdk-request-timeout
                         upload-id
                         custom-query-parameters
                         part-number-marker
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         max-parts
                         clone-root
                         requester-pays]}]]),
    :doc "Call listParts"}
   [credentials13912 & args13913]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13917
     (com.palletops.awaze.common/aws-client :s3 credentials13912)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13917
      listParts
      (s3/list-parts-request (clojure.core/nth args13913 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-acl
   [m13918]
   (clojure.core/let
    [credentials13919 (:credentials m13918) args13920 (:args m13918)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13921
      (com.palletops.awaze.common/aws-client :s3 credentials13919)]
     (clojure.core/case
      (clojure.core/count args13920)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13921
        setBucketAcl
        (s3/set-bucket-acl-request (clojure.core/nth args13920 0))))
      2
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13920 0))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
b
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.AccessControlList
           (clojure.core/nth args13920 1))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13921
           setBucketAcl
           a
           b)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13920 0))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
b
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.CannedAccessControlList
               (clojure.core/nth args13920 1))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13921
               setBucketAcl
               a
               b)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "setBucketAcl")
                {:args args13920}))))))))))
      3
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13920 0))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
b
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.AccessControlList
           (clojure.core/nth args13920 1))
^{:tag com.amazonaws.metrics.RequestMetricCollector}
c
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.metrics.RequestMetricCollector
           (clojure.core/nth args13920 2))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13921
           setBucketAcl
           a
           b
           c)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13920 0))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
b
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.CannedAccessControlList
               (clojure.core/nth args13920 1))
^{:tag com.amazonaws.metrics.RequestMetricCollector}
c
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.metrics.RequestMetricCollector
               (clojure.core/nth args13920 2))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13921
               setBucketAcl
               a
               b
               c)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "setBucketAcl")
                {:args args13920}))))))))))))))
  (clojure.core/defn
   set-bucket-acl-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         acl
                         bucket-name
                         clone-source
                         clone-root
                         canned-acl]}]
                [credentials
                 string-0
                 {:keys [grants
                         grants-as-list
                         owner
                         requester-charged]}]
                [credentials
                 string-0
                 {:keys [grants
                         grants-as-list
                         owner
                         requester-charged]}
                 request-metric-collector-2]
                [credentials string-0 canned-access-control-list-1]
                [credentials
                 string-0
                 canned-access-control-list-1
                 request-metric-collector-2]]),
    :doc "Generate map for setBucketAcl, setBucketAcl, setBucketAcl, setBucketAcl, setBucketAcl"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-bucket-acl,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :set-bucket-acl,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b c]
    {:args [a b c],
     :fn :set-bucket-acl,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   set-bucket-acl
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         acl
                         bucket-name
                         clone-source
                         clone-root
                         canned-acl]}]
                [credentials
                 string-0
                 {:keys [grants
                         grants-as-list
                         owner
                         requester-charged]}]
                [credentials
                 string-0
                 {:keys [grants
                         grants-as-list
                         owner
                         requester-charged]}
                 request-metric-collector-2]
                [credentials string-0 canned-access-control-list-1]
                [credentials
                 string-0
                 canned-access-control-list-1
                 request-metric-collector-2]]),
    :doc "Call setBucketAcl, setBucketAcl, setBucketAcl, setBucketAcl, setBucketAcl"}
   [credentials13927 & args13928]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13933
     (com.palletops.awaze.common/aws-client :s3 credentials13927)]
    (clojure.core/case
     (clojure.core/count args13928)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13933
       setBucketAcl
       (s3/set-bucket-acl-request (clojure.core/nth args13928 0))))
     2
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13928 0))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
b
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.AccessControlList
          (clojure.core/nth args13928 1))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13933
          setBucketAcl
          a
          b)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13928 0))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
b
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.CannedAccessControlList
              (clojure.core/nth args13928 1))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13933
              setBucketAcl
              a
              b)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "setBucketAcl")
               {:args args13928}))))))))))
     3
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13928 0))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
b
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.AccessControlList
          (clojure.core/nth args13928 1))
^{:tag com.amazonaws.metrics.RequestMetricCollector}
c
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.metrics.RequestMetricCollector
          (clojure.core/nth args13928 2))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13933
          setBucketAcl
          a
          b
          c)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13928 0))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
b
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.CannedAccessControlList
              (clojure.core/nth args13928 1))
^{:tag com.amazonaws.metrics.RequestMetricCollector}
c
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.metrics.RequestMetricCollector
              (clojure.core/nth args13928 2))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13933
              setBucketAcl
              a
              b
              c)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "setBucketAcl")
               {:args args13928}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :copy-part
   [m13934]
   (clojure.core/let
    [credentials13935 (:credentials m13934) args13936 (:args m13934)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13937
      (com.palletops.awaze.common/aws-client :s3 credentials13935)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13937
       copyPart
       (s3/copy-part-request (clojure.core/nth args13936 0)))))))
  (clojure.core/defn
   copy-part-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         unmodified-since-constraint
                         sdk-request-timeout
                         nonmatching-etag-constraints
                         upload-id
                         source-key
                         modified-since-constraint
                         first-byte
                         custom-query-parameters
                         destination-ssecustomer-key
                         read-limit
                         last-byte
                         destination-bucket-name
                         general-progress-listener
                         source-version-id
                         part-number
                         clone-source
                         matching-etag-constraints
                         source-bucket-name
                         clone-root
                         source-ssecustomer-key
                         destination-key]}]]),
    :doc "Generate map for copyPart"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :copy-part,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   copy-part
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         unmodified-since-constraint
                         sdk-request-timeout
                         nonmatching-etag-constraints
                         upload-id
                         source-key
                         modified-since-constraint
                         first-byte
                         custom-query-parameters
                         destination-ssecustomer-key
                         read-limit
                         last-byte
                         destination-bucket-name
                         general-progress-listener
                         source-version-id
                         part-number
                         clone-source
                         matching-etag-constraints
                         source-bucket-name
                         clone-root
                         source-ssecustomer-key
                         destination-key]}]]),
    :doc "Call copyPart"}
   [credentials13939 & args13940]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13941
     (com.palletops.awaze.common/aws-client :s3 credentials13939)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13941
      copyPart
      (s3/copy-part-request (clojure.core/nth args13940 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-replication-configuration
   [m13942]
   (clojure.core/let
    [credentials13943 (:credentials m13942) args13944 (:args m13942)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13945
      (com.palletops.awaze.common/aws-client :s3 credentials13943)]
     (clojure.core/case
      (clojure.core/count args13944)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.GetBucketReplicationConfigurationRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.GetBucketReplicationConfigurationRequest
           (clojure.core/nth args13944 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13945
           getBucketReplicationConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13944 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13945
               getBucketReplicationConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketReplicationConfiguration")
                {:args args13944}))))))))))))))
  (clojure.core/defn
   get-bucket-replication-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]
                [credentials string-0]]),
    :doc "Generate map for getBucketReplicationConfiguration, getBucketReplicationConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-bucket-replication-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-bucket-replication-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]
                [credentials string-0]]),
    :doc "Call getBucketReplicationConfiguration, getBucketReplicationConfiguration"}
   [credentials13948 & args13949]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13951
     (com.palletops.awaze.common/aws-client :s3 credentials13948)]
    (clojure.core/case
     (clojure.core/count args13949)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.GetBucketReplicationConfigurationRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.GetBucketReplicationConfigurationRequest
          (clojure.core/nth args13949 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13951
          getBucketReplicationConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13949 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13951
              getBucketReplicationConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketReplicationConfiguration")
               {:args args13949}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-versioning-configuration
   [m13952]
   (clojure.core/let
    [credentials13953 (:credentials m13952) args13954 (:args m13952)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13955
      (com.palletops.awaze.common/aws-client :s3 credentials13953)]
     (clojure.core/case
      (clojure.core/count args13954)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.GetBucketVersioningConfigurationRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.GetBucketVersioningConfigurationRequest
           (clojure.core/nth args13954 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13955
           getBucketVersioningConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13954 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13955
               getBucketVersioningConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketVersioningConfiguration")
                {:args args13954}))))))))))))))
  (clojure.core/defn
   get-bucket-versioning-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]
                [credentials string-0]]),
    :doc "Generate map for getBucketVersioningConfiguration, getBucketVersioningConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-bucket-versioning-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-bucket-versioning-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]
                [credentials string-0]]),
    :doc "Call getBucketVersioningConfiguration, getBucketVersioningConfiguration"}
   [credentials13958 & args13959]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13961
     (com.palletops.awaze.common/aws-client :s3 credentials13958)]
    (clojure.core/case
     (clojure.core/count args13959)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.GetBucketVersioningConfigurationRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.GetBucketVersioningConfigurationRequest
          (clojure.core/nth args13959 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13961
          getBucketVersioningConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13959 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13961
              getBucketVersioningConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketVersioningConfiguration")
               {:args args13959}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :list-next-batch-of-versions
   [m13962]
   (clojure.core/let
    [credentials13963 (:credentials m13962) args13964 (:args m13962)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13965
      (com.palletops.awaze.common/aws-client :s3 credentials13963)]
     (clojure.core/case
      (clojure.core/count args13964)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.VersionListing}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.VersionListing
           (clojure.core/nth args13964 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13965
           listNextBatchOfVersions
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.ListNextBatchOfVersionsRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.ListNextBatchOfVersionsRequest
               (clojure.core/nth args13964 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13965
               listNextBatchOfVersions
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "listNextBatchOfVersions")
                {:args args13964}))))))))))))))
  (clojure.core/defn
   list-next-batch-of-versions-map
   {:arglists (quote
               [[credentials
                 {:keys [encoding-type
                         common-prefixes
                         max-keys
                         next-key-marker
                         version-id-marker
                         prefix
                         delimiter
                         version-summaries
                         truncated
                         bucket-name
                         next-version-id-marker
                         key-marker]}]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         previous-version-listing
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listNextBatchOfVersions, listNextBatchOfVersions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-next-batch-of-versions,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   list-next-batch-of-versions
   {:arglists (quote
               [[credentials
                 {:keys [encoding-type
                         common-prefixes
                         max-keys
                         next-key-marker
                         version-id-marker
                         prefix
                         delimiter
                         version-summaries
                         truncated
                         bucket-name
                         next-version-id-marker
                         key-marker]}]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         previous-version-listing
                         clone-source
                         clone-root]}]]),
    :doc "Call listNextBatchOfVersions, listNextBatchOfVersions"}
   [credentials13968 & args13969]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13971
     (com.palletops.awaze.common/aws-client :s3 credentials13968)]
    (clojure.core/case
     (clojure.core/count args13969)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.VersionListing}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.VersionListing
          (clojure.core/nth args13969 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13971
          listNextBatchOfVersions
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.ListNextBatchOfVersionsRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.ListNextBatchOfVersionsRequest
              (clojure.core/nth args13969 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13971
              listNextBatchOfVersions
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "listNextBatchOfVersions")
               {:args args13969}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-acl
   [m13972]
   (clojure.core/let
    [credentials13973 (:credentials m13972) args13974 (:args m13972)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13975
      (com.palletops.awaze.common/aws-client :s3 credentials13973)]
     (clojure.core/case
      (clojure.core/count args13974)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.GetBucketAclRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.GetBucketAclRequest
           (clojure.core/nth args13974 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13975
           getBucketAcl
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13974 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13975
               getBucketAcl
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketAcl")
                {:args args13974}))))))))))))))
  (clojure.core/defn
   get-bucket-acl-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]
                [credentials string-0]]),
    :doc "Generate map for getBucketAcl, getBucketAcl"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-bucket-acl,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-bucket-acl
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]
                [credentials string-0]]),
    :doc "Call getBucketAcl, getBucketAcl"}
   [credentials13978 & args13979]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13981
     (com.palletops.awaze.common/aws-client :s3 credentials13978)]
    (clojure.core/case
     (clojure.core/count args13979)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.GetBucketAclRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.GetBucketAclRequest
          (clojure.core/nth args13979 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13981
          getBucketAcl
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13979 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13981
              getBucketAcl
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketAcl")
               {:args args13979}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-object
   [m13982]
   (clojure.core/let
    [credentials13983 (:credentials m13982) args13984 (:args m13982)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13985
      (com.palletops.awaze.common/aws-client :s3 credentials13983)]
     (clojure.core/case
      (clojure.core/count args13984)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13985
        deleteObject
        (s3/delete-object-request (clojure.core/nth args13984 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13985
        deleteObject
        (clojure.core/str (clojure.core/nth args13984 0))
        (clojure.core/str (clojure.core/nth args13984 1))))))))
  (clojure.core/defn
   delete-object-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays]}]
                [credentials string-0 string-1]]),
    :doc "Generate map for deleteObject, deleteObject"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-object,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :delete-object,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   delete-object
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays]}]
                [credentials string-0 string-1]]),
    :doc "Call deleteObject, deleteObject"}
   [credentials13989 & args13990]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13993
     (com.palletops.awaze.common/aws-client :s3 credentials13989)]
    (clojure.core/case
     (clojure.core/count args13990)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13993
       deleteObject
       (s3/delete-object-request (clojure.core/nth args13990 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13993
       deleteObject
       (clojure.core/str (clojure.core/nth args13990 0))
       (clojure.core/str (clojure.core/nth args13990 1))))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-bucket-tagging-configuration
   [m13994]
   (clojure.core/let
    [credentials13995 (:credentials m13994) args13996 (:args m13994)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13997
      (com.palletops.awaze.common/aws-client :s3 credentials13995)]
     (clojure.core/case
      (clojure.core/count args13996)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.DeleteBucketTaggingConfigurationRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.DeleteBucketTaggingConfigurationRequest
           (clojure.core/nth args13996 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13997
           deleteBucketTaggingConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13996 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13997
               deleteBucketTaggingConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteBucketTaggingConfiguration")
                {:args args13996}))))))))))))))
  (clojure.core/defn
   delete-bucket-tagging-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]
                [credentials string-0]]),
    :doc "Generate map for deleteBucketTaggingConfiguration, deleteBucketTaggingConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-bucket-tagging-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   delete-bucket-tagging-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]
                [credentials string-0]]),
    :doc "Call deleteBucketTaggingConfiguration, deleteBucketTaggingConfiguration"}
   [credentials14000 & args14001]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14003
     (com.palletops.awaze.common/aws-client :s3 credentials14000)]
    (clojure.core/case
     (clojure.core/count args14001)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.DeleteBucketTaggingConfigurationRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.DeleteBucketTaggingConfigurationRequest
          (clojure.core/nth args14001 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14003
          deleteBucketTaggingConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args14001 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14003
              deleteBucketTaggingConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteBucketTaggingConfiguration")
               {:args args14001}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-logging-configuration
   [m14004]
   (clojure.core/let
    [credentials14005 (:credentials m14004) args14006 (:args m14004)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14007
      (com.palletops.awaze.common/aws-client :s3 credentials14005)]
     (clojure.core/case
      (clojure.core/count args14006)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.GetBucketLoggingConfigurationRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.GetBucketLoggingConfigurationRequest
           (clojure.core/nth args14006 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14007
           getBucketLoggingConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args14006 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14007
               getBucketLoggingConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketLoggingConfiguration")
                {:args args14006}))))))))))))))
  (clojure.core/defn
   get-bucket-logging-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]
                [credentials string-0]]),
    :doc "Generate map for getBucketLoggingConfiguration, getBucketLoggingConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-bucket-logging-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-bucket-logging-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]
                [credentials string-0]]),
    :doc "Call getBucketLoggingConfiguration, getBucketLoggingConfiguration"}
   [credentials14010 & args14011]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14013
     (com.palletops.awaze.common/aws-client :s3 credentials14010)]
    (clojure.core/case
     (clojure.core/count args14011)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.GetBucketLoggingConfigurationRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.GetBucketLoggingConfigurationRequest
          (clojure.core/nth args14011 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14013
          getBucketLoggingConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args14011 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14013
              getBucketLoggingConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketLoggingConfiguration")
               {:args args14011}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :generate-presigned-url
   [m14014]
   (clojure.core/let
    [credentials14015 (:credentials m14014) args14016 (:args m14014)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14017
      (com.palletops.awaze.common/aws-client :s3 credentials14015)]
     (clojure.core/case
      (clojure.core/count args14016)
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14017
        generatePresignedUrl
        (clojure.core/str (clojure.core/nth args14016 0))
        (clojure.core/str (clojure.core/nth args14016 1))
        (com.palletops.awaze.common/to-date
         (clojure.core/nth args14016 2))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14017
        generatePresignedUrl
        (s3/generate-presigned-url-request
         (clojure.core/nth args14016 0))))
      4
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14017
        generatePresignedUrl
        (clojure.core/str (clojure.core/nth args14016 0))
        (clojure.core/str (clojure.core/nth args14016 1))
        (com.palletops.awaze.common/to-date
         (clojure.core/nth args14016 2))
        (root/http-method (clojure.core/nth args14016 3))))))))
  (clojure.core/defn
   generate-presigned-url-map
   {:arglists (quote
               [[credentials string-0 string-1 date-2]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         kms-cmk-id
                         key
                         method
                         sdk-request-timeout
                         expiration
                         custom-query-parameters
                         ssealgorithm
                         read-limit
                         ssecustomer-key
                         general-progress-listener
                         content-type
                         bucket-name
                         content-md5
                         clone-source
                         clone-root
                         request-parameters
                         response-headers
                         zero-byte-content]}]
                [credentials string-0 string-1 date-2 http-method-3]]),
    :doc "Generate map for generatePresignedUrl, generatePresignedUrl, generatePresignedUrl"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :generate-presigned-url,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b c]
    {:args [a b c],
     :fn :generate-presigned-url,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b c d]
    {:args [a b c d],
     :fn :generate-presigned-url,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   generate-presigned-url
   {:arglists (quote
               [[credentials string-0 string-1 date-2]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         kms-cmk-id
                         key
                         method
                         sdk-request-timeout
                         expiration
                         custom-query-parameters
                         ssealgorithm
                         read-limit
                         ssecustomer-key
                         general-progress-listener
                         content-type
                         bucket-name
                         content-md5
                         clone-source
                         clone-root
                         request-parameters
                         response-headers
                         zero-byte-content]}]
                [credentials string-0 string-1 date-2 http-method-3]]),
    :doc "Call generatePresignedUrl, generatePresignedUrl, generatePresignedUrl"}
   [credentials14021 & args14022]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14025
     (com.palletops.awaze.common/aws-client :s3 credentials14021)]
    (clojure.core/case
     (clojure.core/count args14022)
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14025
       generatePresignedUrl
       (clojure.core/str (clojure.core/nth args14022 0))
       (clojure.core/str (clojure.core/nth args14022 1))
       (com.palletops.awaze.common/to-date
        (clojure.core/nth args14022 2))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14025
       generatePresignedUrl
       (s3/generate-presigned-url-request
        (clojure.core/nth args14022 0))))
     4
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14025
       generatePresignedUrl
       (clojure.core/str (clojure.core/nth args14022 0))
       (clojure.core/str (clojure.core/nth args14022 1))
       (com.palletops.awaze.common/to-date
        (clojure.core/nth args14022 2))
       (root/http-method (clojure.core/nth args14022 3))))))))
 (do
  (clojure.core/defmethod
   s3
   :is-requester-pays-enabled
   [m14026]
   (clojure.core/let
    [credentials14027 (:credentials m14026) args14028 (:args m14026)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14029
      (com.palletops.awaze.common/aws-client :s3 credentials14027)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14029
       isRequesterPaysEnabled
       (clojure.core/str (clojure.core/nth args14028 0)))))))
  (clojure.core/defn
   is-requester-pays-enabled-map
   {:arglists (quote [[credentials string-0]]),
    :doc "Generate map for isRequesterPaysEnabled"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :is-requester-pays-enabled,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   is-requester-pays-enabled
   {:arglists (quote [[credentials string-0]]),
    :doc "Call isRequesterPaysEnabled"}
   [credentials14031 & args14032]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14033
     (com.palletops.awaze.common/aws-client :s3 credentials14031)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14033
      isRequesterPaysEnabled
      (clojure.core/str (clojure.core/nth args14032 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :copy-object
   [m14034]
   (clojure.core/let
    [credentials14035 (:credentials m14034) args14036 (:args m14034)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14037
      (com.palletops.awaze.common/aws-client :s3 credentials14035)]
     (clojure.core/case
      (clojure.core/count args14036)
      4
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14037
        copyObject
        (clojure.core/str (clojure.core/nth args14036 0))
        (clojure.core/str (clojure.core/nth args14036 1))
        (clojure.core/str (clojure.core/nth args14036 2))
        (clojure.core/str (clojure.core/nth args14036 3))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14037
        copyObject
        (s3/copy-object-request (clojure.core/nth args14036 0))))))))
  (clojure.core/defn
   copy-object-map
   {:arglists (quote
               [[credentials string-0 string-1 string-2 string-3]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         storage-class
                         unmodified-since-constraint
                         sdk-request-timeout
                         sseaws-key-management-params
                         nonmatching-etag-constraints
                         access-control-list
                         source-key
                         modified-since-constraint
                         custom-query-parameters
                         destination-ssecustomer-key
                         redirect-location
                         read-limit
                         destination-bucket-name
                         general-progress-listener
                         source-version-id
                         clone-source
                         matching-etag-constraints
                         source-bucket-name
                         clone-root
                         canned-access-control-list
                         new-object-metadata
                         source-ssecustomer-key
                         destination-key
                         requester-pays]}]]),
    :doc "Generate map for copyObject, copyObject"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :copy-object,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b c d]
    {:args [a b c d],
     :fn :copy-object,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   copy-object
   {:arglists (quote
               [[credentials string-0 string-1 string-2 string-3]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         storage-class
                         unmodified-since-constraint
                         sdk-request-timeout
                         sseaws-key-management-params
                         nonmatching-etag-constraints
                         access-control-list
                         source-key
                         modified-since-constraint
                         custom-query-parameters
                         destination-ssecustomer-key
                         redirect-location
                         read-limit
                         destination-bucket-name
                         general-progress-listener
                         source-version-id
                         clone-source
                         matching-etag-constraints
                         source-bucket-name
                         clone-root
                         canned-access-control-list
                         new-object-metadata
                         source-ssecustomer-key
                         destination-key
                         requester-pays]}]]),
    :doc "Call copyObject, copyObject"}
   [credentials14043 & args14044]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14049
     (com.palletops.awaze.common/aws-client :s3 credentials14043)]
    (clojure.core/case
     (clojure.core/count args14044)
     4
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14049
       copyObject
       (clojure.core/str (clojure.core/nth args14044 0))
       (clojure.core/str (clojure.core/nth args14044 1))
       (clojure.core/str (clojure.core/nth args14044 2))
       (clojure.core/str (clojure.core/nth args14044 3))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14049
       copyObject
       (s3/copy-object-request (clojure.core/nth args14044 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-objects
   [m14050]
   (clojure.core/let
    [credentials14051 (:credentials m14050) args14052 (:args m14050)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14053
      (com.palletops.awaze.common/aws-client :s3 credentials14051)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14053
       deleteObjects
       (s3/delete-objects-request (clojure.core/nth args14052 0)))))))
  (clojure.core/defn
   delete-objects-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         mfa
                         quiet
                         sdk-request-timeout
                         custom-query-parameters
                         keys
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays]}]]),
    :doc "Generate map for deleteObjects"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-objects,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   delete-objects
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         mfa
                         quiet
                         sdk-request-timeout
                         custom-query-parameters
                         keys
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays]}]]),
    :doc "Call deleteObjects"}
   [credentials14056 & args14057]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14059
     (com.palletops.awaze.common/aws-client :s3 credentials14056)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14059
      deleteObjects
      (s3/delete-objects-request (clojure.core/nth args14057 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-versioning-configuration
   [m14060]
   (clojure.core/let
    [credentials14061 (:credentials m14060) args14062 (:args m14060)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14063
      (com.palletops.awaze.common/aws-client :s3 credentials14061)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14063
       setBucketVersioningConfiguration
       (s3/set-bucket-versioning-configuration-request
        (clojure.core/nth args14062 0)))))))
  (clojure.core/defn
   set-bucket-versioning-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         mfa
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         versioning-configuration
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setBucketVersioningConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-bucket-versioning-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   set-bucket-versioning-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         mfa
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         versioning-configuration
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Call setBucketVersioningConfiguration"}
   [credentials14067 & args14068]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14071
     (com.palletops.awaze.common/aws-client :s3 credentials14067)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14071
      setBucketVersioningConfiguration
      (s3/set-bucket-versioning-configuration-request
       (clojure.core/nth args14068 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-logging-configuration
   [m14072]
   (clojure.core/let
    [credentials14073 (:credentials m14072) args14074 (:args m14072)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14075
      (com.palletops.awaze.common/aws-client :s3 credentials14073)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14075
       setBucketLoggingConfiguration
       (s3/set-bucket-logging-configuration-request
        (clojure.core/nth args14074 0)))))))
  (clojure.core/defn
   set-bucket-logging-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         logging-configuration
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setBucketLoggingConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-bucket-logging-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   set-bucket-logging-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         logging-configuration
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Call setBucketLoggingConfiguration"}
   [credentials14079 & args14080]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14083
     (com.palletops.awaze.common/aws-client :s3 credentials14079)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14083
      setBucketLoggingConfiguration
      (s3/set-bucket-logging-configuration-request
       (clojure.core/nth args14080 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-object
   [m14084]
   (clojure.core/let
    [credentials14085 (:credentials m14084) args14086 (:args m14084)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14087
      (com.palletops.awaze.common/aws-client :s3 credentials14085)]
     (clojure.core/case
      (clojure.core/count args14086)
      2
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.GetObjectRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.GetObjectRequest
           (clojure.core/nth args14086 0))
^{:tag java.io.File}
b
          (com.palletops.awaze.common/coerce-value-form
           java.io.File
           (clojure.core/nth args14086 1))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14087
           getObject
           a
           b)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args14086 0))
^{:tag java.lang.String}
b
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args14086 1))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14087
               getObject
               a
               b)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getObject")
                {:args args14086}))))))))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14087
        getObject
        (s3/get-object-request (clojure.core/nth args14086 0))))))))
  (clojure.core/defn
   get-object-map
   {:arglists (quote
               [[credentials {:keys []} file-1]
                [credentials string-0 string-1]
                [credentials {:keys []}]]),
    :doc "Generate map for getObject, getObject, getObject"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-object,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :get-object,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-object
   {:arglists (quote
               [[credentials {:keys []} file-1]
                [credentials string-0 string-1]
                [credentials {:keys []}]]),
    :doc "Call getObject, getObject, getObject"}
   [credentials14093 & args14094]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14099
     (com.palletops.awaze.common/aws-client :s3 credentials14093)]
    (clojure.core/case
     (clojure.core/count args14094)
     2
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.GetObjectRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.GetObjectRequest
          (clojure.core/nth args14094 0))
^{:tag java.io.File}
b
         (com.palletops.awaze.common/coerce-value-form
          java.io.File
          (clojure.core/nth args14094 1))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14099
          getObject
          a
          b)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args14094 0))
^{:tag java.lang.String}
b
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args14094 1))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14099
              getObject
              a
              b)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getObject")
               {:args args14094}))))))))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14099
       getObject
       (s3/get-object-request (clojure.core/nth args14094 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-bucket-cross-origin-configuration
   [m14100]
   (clojure.core/let
    [credentials14101 (:credentials m14100) args14102 (:args m14100)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14103
      (com.palletops.awaze.common/aws-client :s3 credentials14101)]
     (clojure.core/case
      (clojure.core/count args14102)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args14102 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14103
           deleteBucketCrossOriginConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.DeleteBucketCrossOriginConfigurationRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.DeleteBucketCrossOriginConfigurationRequest
               (clojure.core/nth args14102 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14103
               deleteBucketCrossOriginConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteBucketCrossOriginConfiguration")
                {:args args14102}))))))))))))))
  (clojure.core/defn
   delete-bucket-cross-origin-configuration-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Generate map for deleteBucketCrossOriginConfiguration, deleteBucketCrossOriginConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-bucket-cross-origin-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   delete-bucket-cross-origin-configuration
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Call deleteBucketCrossOriginConfiguration, deleteBucketCrossOriginConfiguration"}
   [credentials14106 & args14107]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14109
     (com.palletops.awaze.common/aws-client :s3 credentials14106)]
    (clojure.core/case
     (clojure.core/count args14107)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args14107 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14109
          deleteBucketCrossOriginConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.DeleteBucketCrossOriginConfigurationRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.DeleteBucketCrossOriginConfigurationRequest
              (clojure.core/nth args14107 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14109
              deleteBucketCrossOriginConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteBucketCrossOriginConfiguration")
               {:args args14107}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :complete-multipart-upload
   [m14110]
   (clojure.core/let
    [credentials14111 (:credentials m14110) args14112 (:args m14110)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14113
      (com.palletops.awaze.common/aws-client :s3 credentials14111)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14113
       completeMultipartUpload
       (s3/complete-multipart-upload-request
        (clojure.core/nth args14112 0)))))))
  (clojure.core/defn
   complete-multipart-upload-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         upload-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         part-etags
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays]}]]),
    :doc "Generate map for completeMultipartUpload"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :complete-multipart-upload,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   complete-multipart-upload
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         upload-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         part-etags
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays]}]]),
    :doc "Call completeMultipartUpload"}
   [credentials14115 & args14116]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14117
     (com.palletops.awaze.common/aws-client :s3 credentials14115)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14117
      completeMultipartUpload
      (s3/complete-multipart-upload-request
       (clojure.core/nth args14116 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :restore-object
   [m14118]
   (clojure.core/let
    [credentials14119 (:credentials m14118) args14120 (:args m14118)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14121
      (com.palletops.awaze.common/aws-client :s3 credentials14119)]
     (clojure.core/case
      (clojure.core/count args14120)
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14121
        restoreObject
        (clojure.core/str (clojure.core/nth args14120 0))
        (clojure.core/str (clojure.core/nth args14120 1))
        (clojure.core/int (clojure.core/nth args14120 2))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14121
        restoreObject
        (s3/restore-object-request (clojure.core/nth args14120 0))))))))
  (clojure.core/defn
   restore-object-map
   {:arglists (quote
               [[credentials string-0 string-1 int-2]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         expiration-in-days
                         clone-source
                         clone-root
                         requester-pays]}]]),
    :doc "Generate map for restoreObject, restoreObject"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :restore-object,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b c]
    {:args [a b c],
     :fn :restore-object,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   restore-object
   {:arglists (quote
               [[credentials string-0 string-1 int-2]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         expiration-in-days
                         clone-source
                         clone-root
                         requester-pays]}]]),
    :doc "Call restoreObject, restoreObject"}
   [credentials14125 & args14126]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14129
     (com.palletops.awaze.common/aws-client :s3 credentials14125)]
    (clojure.core/case
     (clojure.core/count args14126)
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14129
       restoreObject
       (clojure.core/str (clojure.core/nth args14126 0))
       (clojure.core/str (clojure.core/nth args14126 1))
       (clojure.core/int (clojure.core/nth args14126 2))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14129
       restoreObject
       (s3/restore-object-request (clojure.core/nth args14126 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-policy
   [m14130]
   (clojure.core/let
    [credentials14131 (:credentials m14130) args14132 (:args m14130)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14133
      (com.palletops.awaze.common/aws-client :s3 credentials14131)]
     (clojure.core/case
      (clojure.core/count args14132)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.GetBucketPolicyRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.GetBucketPolicyRequest
           (clojure.core/nth args14132 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14133
           getBucketPolicy
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args14132 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14133
               getBucketPolicy
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketPolicy")
                {:args args14132}))))))))))))))
  (clojure.core/defn
   get-bucket-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]
                [credentials string-0]]),
    :doc "Generate map for getBucketPolicy, getBucketPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-bucket-policy,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-bucket-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]
                [credentials string-0]]),
    :doc "Call getBucketPolicy, getBucketPolicy"}
   [credentials14136 & args14137]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14139
     (com.palletops.awaze.common/aws-client :s3 credentials14136)]
    (clojure.core/case
     (clojure.core/count args14137)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.GetBucketPolicyRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.GetBucketPolicyRequest
          (clojure.core/nth args14137 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14139
          getBucketPolicy
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args14137 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14139
              getBucketPolicy
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketPolicy")
               {:args args14137}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-replication-configuration
   [m14140]
   (clojure.core/let
    [credentials14141 (:credentials m14140) args14142 (:args m14140)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14143
      (com.palletops.awaze.common/aws-client :s3 credentials14141)]
     (clojure.core/case
      (clojure.core/count args14142)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14143
        setBucketReplicationConfiguration
        (s3/set-bucket-replication-configuration-request
         (clojure.core/nth args14142 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14143
        setBucketReplicationConfiguration
        (clojure.core/str (clojure.core/nth args14142 0))
        (s3/bucket-replication-configuration
         (clojure.core/nth args14142 1))))))))
  (clojure.core/defn
   set-bucket-replication-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         replication-configuration
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]
                [credentials string-0 {:keys [role-arn rules]}]]),
    :doc "Generate map for setBucketReplicationConfiguration, setBucketReplicationConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-bucket-replication-configuration,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :set-bucket-replication-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   set-bucket-replication-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         replication-configuration
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]
                [credentials string-0 {:keys [role-arn rules]}]]),
    :doc "Call setBucketReplicationConfiguration, setBucketReplicationConfiguration"}
   [credentials14145 & args14146]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14147
     (com.palletops.awaze.common/aws-client :s3 credentials14145)]
    (clojure.core/case
     (clojure.core/count args14146)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14147
       setBucketReplicationConfiguration
       (s3/set-bucket-replication-configuration-request
        (clojure.core/nth args14146 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14147
       setBucketReplicationConfiguration
       (clojure.core/str (clojure.core/nth args14146 0))
       (s3/bucket-replication-configuration
        (clojure.core/nth args14146 1))))))))
 (do
  (clojure.core/defmethod
   s3
   :create-bucket
   [m14148]
   (clojure.core/let
    [credentials14149 (:credentials m14148) args14150 (:args m14148)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14151
      (com.palletops.awaze.common/aws-client :s3 credentials14149)]
     (clojure.core/case
      (clojure.core/count args14150)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args14150 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14151
           createBucket
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.CreateBucketRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.CreateBucketRequest
               (clojure.core/nth args14150 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14151
               createBucket
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "createBucket")
                {:args args14150}))))))))))
      2
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args14150 0))
^{:tag com.amazonaws.services.s3.model.Region}
b
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.Region
           (clojure.core/nth args14150 1))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14151
           createBucket
           a
           b)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args14150 0))
^{:tag java.lang.String}
b
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args14150 1))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14151
               createBucket
               a
               b)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "createBucket")
                {:args args14150}))))))))))))))
  (clojure.core/defn
   create-bucket-map
   {:arglists (quote
               [[credentials string-0]
                [credentials string-0 region-1]
                [credentials string-0 string-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         access-control-list
                         custom-query-parameters
                         region
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         canned-acl]}]]),
    :doc "Generate map for createBucket, createBucket, createBucket, createBucket"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-bucket,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :create-bucket,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   create-bucket
   {:arglists (quote
               [[credentials string-0]
                [credentials string-0 region-1]
                [credentials string-0 string-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         access-control-list
                         custom-query-parameters
                         region
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         canned-acl]}]]),
    :doc "Call createBucket, createBucket, createBucket, createBucket"}
   [credentials14154 & args14155]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14157
     (com.palletops.awaze.common/aws-client :s3 credentials14154)]
    (clojure.core/case
     (clojure.core/count args14155)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args14155 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14157
          createBucket
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.CreateBucketRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.CreateBucketRequest
              (clojure.core/nth args14155 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14157
              createBucket
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "createBucket")
               {:args args14155}))))))))))
     2
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args14155 0))
^{:tag com.amazonaws.services.s3.model.Region}
b
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.Region
          (clojure.core/nth args14155 1))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14157
          createBucket
          a
          b)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args14155 0))
^{:tag java.lang.String}
b
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args14155 1))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14157
              createBucket
              a
              b)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "createBucket")
               {:args args14155}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-version
   [m14158]
   (clojure.core/let
    [credentials14159 (:credentials m14158) args14160 (:args m14158)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14161
      (com.palletops.awaze.common/aws-client :s3 credentials14159)]
     (clojure.core/case
      (clojure.core/count args14160)
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14161
        deleteVersion
        (clojure.core/str (clojure.core/nth args14160 0))
        (clojure.core/str (clojure.core/nth args14160 1))
        (clojure.core/str (clojure.core/nth args14160 2))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14161
        deleteVersion
        (s3/delete-version-request (clojure.core/nth args14160 0))))))))
  (clojure.core/defn
   delete-version-map
   {:arglists (quote
               [[credentials string-0 string-1 string-2]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         mfa
                         key
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteVersion, deleteVersion"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-version,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b c]
    {:args [a b c],
     :fn :delete-version,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   delete-version
   {:arglists (quote
               [[credentials string-0 string-1 string-2]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         mfa
                         key
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteVersion, deleteVersion"}
   [credentials14166 & args14167]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14171
     (com.palletops.awaze.common/aws-client :s3 credentials14166)]
    (clojure.core/case
     (clojure.core/count args14167)
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14171
       deleteVersion
       (clojure.core/str (clojure.core/nth args14167 0))
       (clojure.core/str (clojure.core/nth args14167 1))
       (clojure.core/str (clojure.core/nth args14167 2))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14171
       deleteVersion
       (s3/delete-version-request (clojure.core/nth args14167 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :put-object
   [m14172]
   (clojure.core/let
    [credentials14173 (:credentials m14172) args14174 (:args m14172)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14175
      (com.palletops.awaze.common/aws-client :s3 credentials14173)]
     (clojure.core/case
      (clojure.core/count args14174)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14175
        putObject
        (s3/put-object-request (clojure.core/nth args14174 0))))
      4
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14175
        putObject
        (clojure.core/str (clojure.core/nth args14174 0))
        (clojure.core/str (clojure.core/nth args14174 1))
        (clojure.java.io/input-stream (clojure.core/nth args14174 2))
        (s3/object-metadata (clojure.core/nth args14174 3))))
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14175
        putObject
        (clojure.core/str (clojure.core/nth args14174 0))
        (clojure.core/str (clojure.core/nth args14174 1))
        (clojure.java.io/file (clojure.core/nth args14174 2))))))))
  (clojure.core/defn
   put-object-map
   {:arglists (quote
               [[credentials
                 {:keys [input-stream
                         custom-request-headers
                         sdk-client-execution-timeout
                         key
                         progress-listener
                         storage-class
                         sdk-request-timeout
                         sseaws-key-management-params
                         access-control-list
                         file
                         custom-query-parameters
                         redirect-location
                         read-limit
                         ssecustomer-key
                         general-progress-listener
                         bucket-name
                         clone-source
                         metadata
                         clone-root
                         requester-pays
                         canned-acl]}]
                [credentials
                 string-0
                 string-1
                 input-stream-2
                 {:keys [content-language
                         raw-metadata
                         sseaws-kms-key-id
                         content-disposition
                         expiration-time-rule-id
                         user-metadata
                         storage-class
                         instance-length
                         ssecustomer-key-md5
                         ssecustomer-algorithm
                         version-id
                         server-side-encryption
                         requester-charged
                         etag
                         last-modified
                         ssealgorithm
                         cache-control
                         http-expires-date
                         content-length
                         content-type
                         restore-expiration-time
                         content-encoding
                         expiration-time
                         content-md5
                         ongoing-restore]}]
                [credentials string-0 string-1 file-2]]),
    :doc "Generate map for putObject, putObject, putObject"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :put-object,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b c]
    {:args [a b c],
     :fn :put-object,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b c d]
    {:args [a b c d],
     :fn :put-object,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   put-object
   {:arglists (quote
               [[credentials
                 {:keys [input-stream
                         custom-request-headers
                         sdk-client-execution-timeout
                         key
                         progress-listener
                         storage-class
                         sdk-request-timeout
                         sseaws-key-management-params
                         access-control-list
                         file
                         custom-query-parameters
                         redirect-location
                         read-limit
                         ssecustomer-key
                         general-progress-listener
                         bucket-name
                         clone-source
                         metadata
                         clone-root
                         requester-pays
                         canned-acl]}]
                [credentials
                 string-0
                 string-1
                 input-stream-2
                 {:keys [content-language
                         raw-metadata
                         sseaws-kms-key-id
                         content-disposition
                         expiration-time-rule-id
                         user-metadata
                         storage-class
                         instance-length
                         ssecustomer-key-md5
                         ssecustomer-algorithm
                         version-id
                         server-side-encryption
                         requester-charged
                         etag
                         last-modified
                         ssealgorithm
                         cache-control
                         http-expires-date
                         content-length
                         content-type
                         restore-expiration-time
                         content-encoding
                         expiration-time
                         content-md5
                         ongoing-restore]}]
                [credentials string-0 string-1 file-2]]),
    :doc "Call putObject, putObject, putObject"}
   [credentials14183 & args14184]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14191
     (com.palletops.awaze.common/aws-client :s3 credentials14183)]
    (clojure.core/case
     (clojure.core/count args14184)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14191
       putObject
       (s3/put-object-request (clojure.core/nth args14184 0))))
     4
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14191
       putObject
       (clojure.core/str (clojure.core/nth args14184 0))
       (clojure.core/str (clojure.core/nth args14184 1))
       (clojure.java.io/input-stream (clojure.core/nth args14184 2))
       (s3/object-metadata (clojure.core/nth args14184 3))))
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14191
       putObject
       (clojure.core/str (clojure.core/nth args14184 0))
       (clojure.core/str (clojure.core/nth args14184 1))
       (clojure.java.io/file (clojure.core/nth args14184 2))))))))
 (do
  (clojure.core/defmethod
   s3
   :list-versions
   [m14192]
   (clojure.core/let
    [credentials14193 (:credentials m14192) args14194 (:args m14192)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14195
      (com.palletops.awaze.common/aws-client :s3 credentials14193)]
     (clojure.core/case
      (clojure.core/count args14194)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14195
        listVersions
        (clojure.core/str (clojure.core/nth args14194 0))
        (clojure.core/str (clojure.core/nth args14194 1))))
      6
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14195
        listVersions
        (clojure.core/str (clojure.core/nth args14194 0))
        (clojure.core/str (clojure.core/nth args14194 1))
        (clojure.core/str (clojure.core/nth args14194 2))
        (clojure.core/str (clojure.core/nth args14194 3))
        (clojure.core/str (clojure.core/nth args14194 4))
        (clojure.core/int (clojure.core/nth args14194 5))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14195
        listVersions
        (s3/list-versions-request (clojure.core/nth args14194 0))))))))
  (clojure.core/defn
   list-versions-map
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 string-0
                 string-1
                 string-2
                 string-3
                 string-4
                 integer-5]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         encoding-type
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         version-id-marker
                         prefix
                         delimiter
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         key-marker]}]]),
    :doc "Generate map for listVersions, listVersions, listVersions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-versions,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :list-versions,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b c d e f]
    {:args [a b c d e f],
     :fn :list-versions,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   list-versions
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 string-0
                 string-1
                 string-2
                 string-3
                 string-4
                 integer-5]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         encoding-type
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         version-id-marker
                         prefix
                         delimiter
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         key-marker]}]]),
    :doc "Call listVersions, listVersions, listVersions"}
   [credentials14197 & args14198]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14199
     (com.palletops.awaze.common/aws-client :s3 credentials14197)]
    (clojure.core/case
     (clojure.core/count args14198)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14199
       listVersions
       (clojure.core/str (clojure.core/nth args14198 0))
       (clojure.core/str (clojure.core/nth args14198 1))))
     6
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14199
       listVersions
       (clojure.core/str (clojure.core/nth args14198 0))
       (clojure.core/str (clojure.core/nth args14198 1))
       (clojure.core/str (clojure.core/nth args14198 2))
       (clojure.core/str (clojure.core/nth args14198 3))
       (clojure.core/str (clojure.core/nth args14198 4))
       (clojure.core/int (clojure.core/nth args14198 5))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14199
       listVersions
       (s3/list-versions-request (clojure.core/nth args14198 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-tagging-configuration
   [m14200]
   (clojure.core/let
    [credentials14201 (:credentials m14200) args14202 (:args m14200)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14203
      (com.palletops.awaze.common/aws-client :s3 credentials14201)]
     (clojure.core/case
      (clojure.core/count args14202)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14203
        setBucketTaggingConfiguration
        (s3/set-bucket-tagging-configuration-request
         (clojure.core/nth args14202 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14203
        setBucketTaggingConfiguration
        (clojure.core/str (clojure.core/nth args14202 0))
        (s3/bucket-tagging-configuration
         (clojure.core/nth args14202 1))))))))
  (clojure.core/defn
   set-bucket-tagging-configuration-map
   {:arglists (quote
               [[credentials {:keys []}]
                [credentials string-0 {:keys []}]]),
    :doc "Generate map for setBucketTaggingConfiguration, setBucketTaggingConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-bucket-tagging-configuration,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :set-bucket-tagging-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   set-bucket-tagging-configuration
   {:arglists (quote
               [[credentials {:keys []}]
                [credentials string-0 {:keys []}]]),
    :doc "Call setBucketTaggingConfiguration, setBucketTaggingConfiguration"}
   [credentials14207 & args14208]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14211
     (com.palletops.awaze.common/aws-client :s3 credentials14207)]
    (clojure.core/case
     (clojure.core/count args14208)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14211
       setBucketTaggingConfiguration
       (s3/set-bucket-tagging-configuration-request
        (clojure.core/nth args14208 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14211
       setBucketTaggingConfiguration
       (clojure.core/str (clojure.core/nth args14208 0))
       (s3/bucket-tagging-configuration
        (clojure.core/nth args14208 1))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-cross-origin-configuration
   [m14212]
   (clojure.core/let
    [credentials14213 (:credentials m14212) args14214 (:args m14212)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14215
      (com.palletops.awaze.common/aws-client :s3 credentials14213)]
     (clojure.core/case
      (clojure.core/count args14214)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args14214 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14215
           getBucketCrossOriginConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.GetBucketCrossOriginConfigurationRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.GetBucketCrossOriginConfigurationRequest
               (clojure.core/nth args14214 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14215
               getBucketCrossOriginConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketCrossOriginConfiguration")
                {:args args14214}))))))))))))))
  (clojure.core/defn
   get-bucket-cross-origin-configuration-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Generate map for getBucketCrossOriginConfiguration, getBucketCrossOriginConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-bucket-cross-origin-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-bucket-cross-origin-configuration
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Call getBucketCrossOriginConfiguration, getBucketCrossOriginConfiguration"}
   [credentials14218 & args14219]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14221
     (com.palletops.awaze.common/aws-client :s3 credentials14218)]
    (clojure.core/case
     (clojure.core/count args14219)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args14219 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14221
          getBucketCrossOriginConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.GetBucketCrossOriginConfigurationRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.GetBucketCrossOriginConfigurationRequest
              (clojure.core/nth args14219 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14221
              getBucketCrossOriginConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketCrossOriginConfiguration")
               {:args args14219}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-policy
   [m14222]
   (clojure.core/let
    [credentials14223 (:credentials m14222) args14224 (:args m14222)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14225
      (com.palletops.awaze.common/aws-client :s3 credentials14223)]
     (clojure.core/case
      (clojure.core/count args14224)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14225
        setBucketPolicy
        (clojure.core/str (clojure.core/nth args14224 0))
        (clojure.core/str (clojure.core/nth args14224 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14225
        setBucketPolicy
        (s3/set-bucket-policy-request (clojure.core/nth args14224 0))))))))
  (clojure.core/defn
   set-bucket-policy-map
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-text
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setBucketPolicy, setBucketPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-bucket-policy,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :set-bucket-policy,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   set-bucket-policy
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-text
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Call setBucketPolicy, setBucketPolicy"}
   [credentials14229 & args14230]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14233
     (com.palletops.awaze.common/aws-client :s3 credentials14229)]
    (clojure.core/case
     (clojure.core/count args14230)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14233
       setBucketPolicy
       (clojure.core/str (clojure.core/nth args14230 0))
       (clojure.core/str (clojure.core/nth args14230 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14233
       setBucketPolicy
       (s3/set-bucket-policy-request (clojure.core/nth args14230 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :list-next-batch-of-objects
   [m14234]
   (clojure.core/let
    [credentials14235 (:credentials m14234) args14236 (:args m14234)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14237
      (com.palletops.awaze.common/aws-client :s3 credentials14235)]
     (clojure.core/case
      (clojure.core/count args14236)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.ObjectListing}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.ObjectListing
           (clojure.core/nth args14236 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14237
           listNextBatchOfObjects
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.ListNextBatchOfObjectsRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.ListNextBatchOfObjectsRequest
               (clojure.core/nth args14236 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14237
               listNextBatchOfObjects
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "listNextBatchOfObjects")
                {:args args14236}))))))))))))))
  (clojure.core/defn
   list-next-batch-of-objects-map
   {:arglists (quote
               [[credentials
                 {:keys [encoding-type
                         common-prefixes
                         marker
                         max-keys
                         object-summaries
                         prefix
                         delimiter
                         next-marker
                         truncated
                         bucket-name]}]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         previous-object-listing
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listNextBatchOfObjects, listNextBatchOfObjects"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-next-batch-of-objects,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   list-next-batch-of-objects
   {:arglists (quote
               [[credentials
                 {:keys [encoding-type
                         common-prefixes
                         marker
                         max-keys
                         object-summaries
                         prefix
                         delimiter
                         next-marker
                         truncated
                         bucket-name]}]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         previous-object-listing
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listNextBatchOfObjects, listNextBatchOfObjects"}
   [credentials14240 & args14241]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14243
     (com.palletops.awaze.common/aws-client :s3 credentials14240)]
    (clojure.core/case
     (clojure.core/count args14241)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.ObjectListing}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.ObjectListing
          (clojure.core/nth args14241 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14243
          listNextBatchOfObjects
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.ListNextBatchOfObjectsRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.ListNextBatchOfObjectsRequest
              (clojure.core/nth args14241 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14243
              listNextBatchOfObjects
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "listNextBatchOfObjects")
               {:args args14241}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :change-object-storage-class
   [m14244]
   (clojure.core/let
    [credentials14245 (:credentials m14244) args14246 (:args m14244)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14247
      (com.palletops.awaze.common/aws-client :s3 credentials14245)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14247
       changeObjectStorageClass
       (clojure.core/str (clojure.core/nth args14246 0))
       (clojure.core/str (clojure.core/nth args14246 1))
       (s3/storage-class (clojure.core/nth args14246 2)))))))
  (clojure.core/defn
   change-object-storage-class-map
   {:arglists (quote
               [[credentials string-0 string-1 storage-class-2]]),
    :doc "Generate map for changeObjectStorageClass"}
   ([credentials__1842__auto__ a b c]
    {:args [a b c],
     :fn :change-object-storage-class,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   change-object-storage-class
   {:arglists (quote
               [[credentials string-0 string-1 storage-class-2]]),
    :doc "Call changeObjectStorageClass"}
   [credentials14249 & args14250]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14251
     (com.palletops.awaze.common/aws-client :s3 credentials14249)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14251
      changeObjectStorageClass
      (clojure.core/str (clojure.core/nth args14250 0))
      (clojure.core/str (clojure.core/nth args14250 1))
      (s3/storage-class (clojure.core/nth args14250 2)))))))
 (do
  (clojure.core/defmethod
   s3
   :initiate-multipart-upload
   [m14252]
   (clojure.core/let
    [credentials14253 (:credentials m14252) args14254 (:args m14252)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14255
      (com.palletops.awaze.common/aws-client :s3 credentials14253)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14255
       initiateMultipartUpload
       (s3/initiate-multipart-upload-request
        (clojure.core/nth args14254 0)))))))
  (clojure.core/defn
   initiate-multipart-upload-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         storage-class
                         sdk-request-timeout
                         sseaws-key-management-params
                         access-control-list
                         object-metadata
                         custom-query-parameters
                         redirect-location
                         read-limit
                         ssecustomer-key
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays
                         canned-acl]}]]),
    :doc "Generate map for initiateMultipartUpload"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :initiate-multipart-upload,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   initiate-multipart-upload
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         storage-class
                         sdk-request-timeout
                         sseaws-key-management-params
                         access-control-list
                         object-metadata
                         custom-query-parameters
                         redirect-location
                         read-limit
                         ssecustomer-key
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays
                         canned-acl]}]]),
    :doc "Call initiateMultipartUpload"}
   [credentials14259 & args14260]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14263
     (com.palletops.awaze.common/aws-client :s3 credentials14259)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14263
      initiateMultipartUpload
      (s3/initiate-multipart-upload-request
       (clojure.core/nth args14260 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :set-region
   [m14264]
   (clojure.core/let
    [credentials14265 (:credentials m14264) args14266 (:args m14264)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14267
      (com.palletops.awaze.common/aws-client :s3 credentials14265)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14267
       setRegion
       (regions/region (clojure.core/nth args14266 0)))))))
  (clojure.core/defn
   set-region-map
   {:arglists (quote [[credentials region-0]]),
    :doc "Generate map for setRegion"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-region,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   set-region
   {:arglists (quote [[credentials region-0]]), :doc "Call setRegion"}
   [credentials14269 & args14270]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14271
     (com.palletops.awaze.common/aws-client :s3 credentials14269)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14271
      setRegion
      (regions/region (clojure.core/nth args14270 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-bucket
   [m14272]
   (clojure.core/let
    [credentials14273 (:credentials m14272) args14274 (:args m14272)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14275
      (com.palletops.awaze.common/aws-client :s3 credentials14273)]
     (clojure.core/case
      (clojure.core/count args14274)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.DeleteBucketRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.DeleteBucketRequest
           (clojure.core/nth args14274 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14275
           deleteBucket
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args14274 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14275
               deleteBucket
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteBucket")
                {:args args14274}))))))))))))))
  (clojure.core/defn
   delete-bucket-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]
                [credentials string-0]]),
    :doc "Generate map for deleteBucket, deleteBucket"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-bucket,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   delete-bucket
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]
                [credentials string-0]]),
    :doc "Call deleteBucket, deleteBucket"}
   [credentials14278 & args14279]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14281
     (com.palletops.awaze.common/aws-client :s3 credentials14278)]
    (clojure.core/case
     (clojure.core/count args14279)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.DeleteBucketRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.DeleteBucketRequest
          (clojure.core/nth args14279 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14281
          deleteBucket
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args14279 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14281
              deleteBucket
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteBucket")
               {:args args14279}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-tagging-configuration
   [m14282]
   (clojure.core/let
    [credentials14283 (:credentials m14282) args14284 (:args m14282)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14285
      (com.palletops.awaze.common/aws-client :s3 credentials14283)]
     (clojure.core/case
      (clojure.core/count args14284)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args14284 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14285
           getBucketTaggingConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.GetBucketTaggingConfigurationRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.GetBucketTaggingConfigurationRequest
               (clojure.core/nth args14284 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14285
               getBucketTaggingConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketTaggingConfiguration")
                {:args args14284}))))))))))))))
  (clojure.core/defn
   get-bucket-tagging-configuration-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Generate map for getBucketTaggingConfiguration, getBucketTaggingConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-bucket-tagging-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-bucket-tagging-configuration
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Call getBucketTaggingConfiguration, getBucketTaggingConfiguration"}
   [credentials14288 & args14289]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14291
     (com.palletops.awaze.common/aws-client :s3 credentials14288)]
    (clojure.core/case
     (clojure.core/count args14289)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args14289 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14291
          getBucketTaggingConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.GetBucketTaggingConfigurationRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.GetBucketTaggingConfigurationRequest
              (clojure.core/nth args14289 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14291
              getBucketTaggingConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketTaggingConfiguration")
               {:args args14289}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-location
   [m14292]
   (clojure.core/let
    [credentials14293 (:credentials m14292) args14294 (:args m14292)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14295
      (com.palletops.awaze.common/aws-client :s3 credentials14293)]
     (clojure.core/case
      (clojure.core/count args14294)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.GetBucketLocationRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.GetBucketLocationRequest
           (clojure.core/nth args14294 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14295
           getBucketLocation
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args14294 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14295
               getBucketLocation
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketLocation")
                {:args args14294}))))))))))))))
  (clojure.core/defn
   get-bucket-location-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]
                [credentials string-0]]),
    :doc "Generate map for getBucketLocation, getBucketLocation"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-bucket-location,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-bucket-location
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]
                [credentials string-0]]),
    :doc "Call getBucketLocation, getBucketLocation"}
   [credentials14298 & args14299]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14301
     (com.palletops.awaze.common/aws-client :s3 credentials14298)]
    (clojure.core/case
     (clojure.core/count args14299)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.GetBucketLocationRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.GetBucketLocationRequest
          (clojure.core/nth args14299 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14301
          getBucketLocation
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args14299 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14301
              getBucketLocation
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketLocation")
               {:args args14299}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :does-bucket-exist
   [m14302]
   (clojure.core/let
    [credentials14303 (:credentials m14302) args14304 (:args m14302)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14305
      (com.palletops.awaze.common/aws-client :s3 credentials14303)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14305
       doesBucketExist
       (clojure.core/str (clojure.core/nth args14304 0)))))))
  (clojure.core/defn
   does-bucket-exist-map
   {:arglists (quote [[credentials string-0]]),
    :doc "Generate map for doesBucketExist"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :does-bucket-exist,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   does-bucket-exist
   {:arglists (quote [[credentials string-0]]),
    :doc "Call doesBucketExist"}
   [credentials14307 & args14308]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14309
     (com.palletops.awaze.common/aws-client :s3 credentials14307)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14309
      doesBucketExist
      (clojure.core/str (clojure.core/nth args14308 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-object-acl
   [m14310]
   (clojure.core/let
    [credentials14311 (:credentials m14310) args14312 (:args m14310)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14313
      (com.palletops.awaze.common/aws-client :s3 credentials14311)]
     (clojure.core/case
      (clojure.core/count args14312)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14313
        getObjectAcl
        (clojure.core/str (clojure.core/nth args14312 0))
        (clojure.core/str (clojure.core/nth args14312 1))))
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14313
        getObjectAcl
        (clojure.core/str (clojure.core/nth args14312 0))
        (clojure.core/str (clojure.core/nth args14312 1))
        (clojure.core/str (clojure.core/nth args14312 2))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14313
        getObjectAcl
        (s3/get-object-acl-request (clojure.core/nth args14312 0))))))))
  (clojure.core/defn
   get-object-acl-map
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials string-0 string-1 string-2]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays]}]]),
    :doc "Generate map for getObjectAcl, getObjectAcl, getObjectAcl"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-object-acl,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :get-object-acl,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b c]
    {:args [a b c],
     :fn :get-object-acl,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-object-acl
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials string-0 string-1 string-2]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays]}]]),
    :doc "Call getObjectAcl, getObjectAcl, getObjectAcl"}
   [credentials14317 & args14318]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14321
     (com.palletops.awaze.common/aws-client :s3 credentials14317)]
    (clojure.core/case
     (clojure.core/count args14318)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14321
       getObjectAcl
       (clojure.core/str (clojure.core/nth args14318 0))
       (clojure.core/str (clojure.core/nth args14318 1))))
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14321
       getObjectAcl
       (clojure.core/str (clojure.core/nth args14318 0))
       (clojure.core/str (clojure.core/nth args14318 1))
       (clojure.core/str (clojure.core/nth args14318 2))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14321
       getObjectAcl
       (s3/get-object-acl-request (clojure.core/nth args14318 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :upload-part
   [m14322]
   (clojure.core/let
    [credentials14323 (:credentials m14322) args14324 (:args m14322)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14325
      (com.palletops.awaze.common/aws-client :s3 credentials14323)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14325
       uploadPart
       (s3/upload-part-request (clojure.core/nth args14324 0)))))))
  (clojure.core/defn
   upload-part-map
   {:arglists (quote
               [[credentials
                 {:keys [input-stream
                         custom-request-headers
                         sdk-client-execution-timeout
                         key
                         progress-listener
                         last-part
                         sdk-request-timeout
                         upload-id
                         file
                         object-metadata
                         custom-query-parameters
                         md5digest
                         read-limit
                         ssecustomer-key
                         general-progress-listener
                         file-offset
                         part-number
                         bucket-name
                         clone-source
                         part-size
                         clone-root
                         requester-pays]}]]),
    :doc "Generate map for uploadPart"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :upload-part,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   upload-part
   {:arglists (quote
               [[credentials
                 {:keys [input-stream
                         custom-request-headers
                         sdk-client-execution-timeout
                         key
                         progress-listener
                         last-part
                         sdk-request-timeout
                         upload-id
                         file
                         object-metadata
                         custom-query-parameters
                         md5digest
                         read-limit
                         ssecustomer-key
                         general-progress-listener
                         file-offset
                         part-number
                         bucket-name
                         clone-source
                         part-size
                         clone-root
                         requester-pays]}]]),
    :doc "Call uploadPart"}
   [credentials14327 & args14328]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14329
     (com.palletops.awaze.common/aws-client :s3 credentials14327)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14329
      uploadPart
      (s3/upload-part-request (clojure.core/nth args14328 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-website-configuration
   [m14330]
   (clojure.core/let
    [credentials14331 (:credentials m14330) args14332 (:args m14330)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14333
      (com.palletops.awaze.common/aws-client :s3 credentials14331)]
     (clojure.core/case
      (clojure.core/count args14332)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14333
        setBucketWebsiteConfiguration
        (s3/set-bucket-website-configuration-request
         (clojure.core/nth args14332 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14333
        setBucketWebsiteConfiguration
        (clojure.core/str (clojure.core/nth args14332 0))
        (s3/bucket-website-configuration
         (clojure.core/nth args14332 1))))))))
  (clojure.core/defn
   set-bucket-website-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         configuration
                         bucket-name
                         clone-source
                         clone-root]}]
                [credentials
                 string-0
                 {:keys [error-document
                         index-document-suffix
                         redirect-all-requests-to
                         routing-rules]}]]),
    :doc "Generate map for setBucketWebsiteConfiguration, setBucketWebsiteConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-bucket-website-configuration,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :set-bucket-website-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   set-bucket-website-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         configuration
                         bucket-name
                         clone-source
                         clone-root]}]
                [credentials
                 string-0
                 {:keys [error-document
                         index-document-suffix
                         redirect-all-requests-to
                         routing-rules]}]]),
    :doc "Call setBucketWebsiteConfiguration, setBucketWebsiteConfiguration"}
   [credentials14337 & args14338]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14341
     (com.palletops.awaze.common/aws-client :s3 credentials14337)]
    (clojure.core/case
     (clojure.core/count args14338)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14341
       setBucketWebsiteConfiguration
       (s3/set-bucket-website-configuration-request
        (clojure.core/nth args14338 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14341
       setBucketWebsiteConfiguration
       (clojure.core/str (clojure.core/nth args14338 0))
       (s3/bucket-website-configuration
        (clojure.core/nth args14338 1))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-region
   [m14342]
   (clojure.core/let
    [credentials14343 (:credentials m14342) args14344 (:args m14342)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14345
      (com.palletops.awaze.common/aws-client :s3 credentials14343)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14345
       getRegion)))))
  (clojure.core/defn
   get-region-map
   {:arglists (quote [[credentials]]),
    :doc "Generate map for getRegion"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-region,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-region
   {:arglists (quote [[credentials]]), :doc "Call getRegion"}
   [credentials14347 & args14348]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14349
     (com.palletops.awaze.common/aws-client :s3 credentials14347)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14349
      getRegion))))))
