(ns
 com.palletops.awaze.route53
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.route53 :as route53]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :route53
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.route53.AmazonRoute53Client
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.AliasTarget}
alias-target
  [m11185]
  (clojure.core/let
   [bean11184 (new com.amazonaws.services.route53.model.AliasTarget)]
   (clojure.core/let
    [v11186
     (:hosted-zone-id
      m11185
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11186 :com.palletops.awaze.client-builder/undef)
     (. bean11184 setHostedZoneId (clojure.core/str v11186))))
   (clojure.core/let
    [v11186
     (:evaluate-target-health
      m11185
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11186 :com.palletops.awaze.client-builder/undef)
     (.
      bean11184
      setEvaluateTargetHealth
      (clojure.core/boolean v11186))))
   (clojure.core/let
    [v11186
     (:dnsname m11185 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11186 :com.palletops.awaze.client-builder/undef)
     (. bean11184 setDNSName (clojure.core/str v11186))))
   bean11184))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ResourceRecordSetRegion}
resource-record-set-region
  [m11188]
  (.
   com.amazonaws.services.route53.model.ResourceRecordSetRegion
   fromValue
   (clojure.core/name m11188)))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ResourceRecordSetFailover}
resource-record-set-failover
  [m11191]
  (.
   com.amazonaws.services.route53.model.ResourceRecordSetFailover
   fromValue
   (clojure.core/name m11191)))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.RRType}
rrtype
  [m11194]
  (.
   com.amazonaws.services.route53.model.RRType
   fromValue
   (clojure.core/name m11194)))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ResourceRecord}
resource-record
  [m11197]
  (clojure.core/let
   [bean11196
    (new com.amazonaws.services.route53.model.ResourceRecord)]
   (clojure.core/let
    [v11198 (:value m11197 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11198 :com.palletops.awaze.client-builder/undef)
     (. bean11196 setValue (clojure.core/str v11198))))
   bean11196))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GeoLocation}
geo-location
  [m11200]
  (clojure.core/let
   [bean11199 (new com.amazonaws.services.route53.model.GeoLocation)]
   (clojure.core/let
    [v11201
     (:continent-code
      m11200
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11201 :com.palletops.awaze.client-builder/undef)
     (. bean11199 setContinentCode (clojure.core/str v11201))))
   (clojure.core/let
    [v11201
     (:country-code m11200 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11201 :com.palletops.awaze.client-builder/undef)
     (. bean11199 setCountryCode (clojure.core/str v11201))))
   (clojure.core/let
    [v11201
     (:subdivision-code
      m11200
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11201 :com.palletops.awaze.client-builder/undef)
     (. bean11199 setSubdivisionCode (clojure.core/str v11201))))
   bean11199))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ResourceRecordSet}
resource-record-set
  [m11203]
  (clojure.core/let
   [bean11202
    (new com.amazonaws.services.route53.model.ResourceRecordSet)]
   (clojure.core/let
    [v11204
     (:alias-target m11203 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11204 :com.palletops.awaze.client-builder/undef)
     (. bean11202 setAliasTarget (route53/alias-target v11204))))
   (clojure.core/let
    [v11204
     (:region m11203 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11204 :com.palletops.awaze.client-builder/undef)
     (.
      bean11202
      setRegion
      (route53/resource-record-set-region v11204))))
   (clojure.core/let
    [v11204
     (:failover m11203 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11204 :com.palletops.awaze.client-builder/undef)
     (.
      bean11202
      setFailover
      (route53/resource-record-set-failover v11204))))
   (clojure.core/let
    [v11204
     (:set-identifier
      m11203
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11204 :com.palletops.awaze.client-builder/undef)
     (. bean11202 setSetIdentifier (clojure.core/str v11204))))
   (clojure.core/let
    [v11204
     (:traffic-policy-instance-id
      m11203
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11204 :com.palletops.awaze.client-builder/undef)
     (.
      bean11202
      setTrafficPolicyInstanceId
      (clojure.core/str v11204))))
   (clojure.core/let
    [v11204 (:type m11203 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11204 :com.palletops.awaze.client-builder/undef)
     (. bean11202 setType (route53/rrtype v11204))))
   (clojure.core/let
    [v11204 (:name m11203 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11204 :com.palletops.awaze.client-builder/undef)
     (. bean11202 setName (clojure.core/str v11204))))
   (clojure.core/let
    [v11204
     (:weight m11203 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11204 :com.palletops.awaze.client-builder/undef)
     (. bean11202 setWeight (clojure.core/long v11204))))
   (clojure.core/let
    [v11204 (:ttl m11203 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11204 :com.palletops.awaze.client-builder/undef)
     (. bean11202 setTTL (clojure.core/long v11204))))
   (clojure.core/let
    [v11204
     (:health-check-id
      m11203
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11204 :com.palletops.awaze.client-builder/undef)
     (. bean11202 setHealthCheckId (clojure.core/str v11204))))
   (clojure.core/let
    [v11204
     (:resource-records
      m11203
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11204 :com.palletops.awaze.client-builder/undef)
     (.
      bean11202
      setResourceRecords
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11379] (route53/resource-record arg11379))
 v11204))))
   (clojure.core/let
    [v11204
     (:geo-location m11203 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11204 :com.palletops.awaze.client-builder/undef)
     (. bean11202 setGeoLocation (route53/geo-location v11204))))
   bean11202))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.Change}
change
  [m11206]
  (clojure.core/let
   [bean11205 (new com.amazonaws.services.route53.model.Change)]
   (clojure.core/let
    [v11207
     (:resource-record-set
      m11206
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11207 :com.palletops.awaze.client-builder/undef)
     (.
      bean11205
      setResourceRecordSet
      (route53/resource-record-set v11207))))
   (clojure.core/let
    [v11207
     (:action m11206 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11207 :com.palletops.awaze.client-builder/undef)
     (. bean11205 setAction (clojure.core/str v11207))))
   bean11205))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.VPCRegion}
vpcregion
  [m11209]
  (.
   com.amazonaws.services.route53.model.VPCRegion
   fromValue
   (clojure.core/name m11209)))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.InsufficientDataHealthStatus}
insufficient-data-health-status
  [m11212]
  (.
   com.amazonaws.services.route53.model.InsufficientDataHealthStatus
   fromValue
   (clojure.core/name m11212)))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.AlarmIdentifier}
alarm-identifier
  [m11215]
  (clojure.core/let
   [bean11214
    (new com.amazonaws.services.route53.model.AlarmIdentifier)]
   (clojure.core/let
    [v11216
     (:region m11215 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11216 :com.palletops.awaze.client-builder/undef)
     (. bean11214 setRegion (clojure.core/str v11216))))
   (clojure.core/let
    [v11216 (:name m11215 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11216 :com.palletops.awaze.client-builder/undef)
     (. bean11214 setName (clojure.core/str v11216))))
   bean11214))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ChangeBatch}
change-batch
  [m11218]
  (clojure.core/let
   [bean11217 (new com.amazonaws.services.route53.model.ChangeBatch)]
   (clojure.core/let
    [v11219
     (:comment m11218 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11219 :com.palletops.awaze.client-builder/undef)
     (. bean11217 setComment (clojure.core/str v11219))))
   (clojure.core/let
    [v11219
     (:changes m11218 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11219 :com.palletops.awaze.client-builder/undef)
     (.
      bean11217
      setChanges
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11380] (route53/change arg11380))
 v11219))))
   bean11217))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.VPC}
vpc
  [m11221]
  (clojure.core/let
   [bean11220 (new com.amazonaws.services.route53.model.VPC)]
   (clojure.core/let
    [v11222
     (:vpcregion m11221 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11222 :com.palletops.awaze.client-builder/undef)
     (. bean11220 setVPCRegion (route53/vpcregion v11222))))
   (clojure.core/let
    [v11222 (:vpcid m11221 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11222 :com.palletops.awaze.client-builder/undef)
     (. bean11220 setVPCId (clojure.core/str v11222))))
   bean11220))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.TagResourceType}
tag-resource-type
  [m11224]
  (.
   com.amazonaws.services.route53.model.TagResourceType
   fromValue
   (clojure.core/name m11224)))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.HostedZoneConfig}
hosted-zone-config
  [m11227]
  (clojure.core/let
   [bean11226
    (new com.amazonaws.services.route53.model.HostedZoneConfig)]
   (clojure.core/let
    [v11228
     (:comment m11227 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11228 :com.palletops.awaze.client-builder/undef)
     (. bean11226 setComment (clojure.core/str v11228))))
   (clojure.core/let
    [v11228
     (:private-zone m11227 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11228 :com.palletops.awaze.client-builder/undef)
     (. bean11226 setPrivateZone (clojure.core/boolean v11228))))
   bean11226))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.HealthCheckConfig}
health-check-config
  [m11230]
  (clojure.core/let
   [bean11229
    (new com.amazonaws.services.route53.model.HealthCheckConfig)]
   (clojure.core/let
    [v11231
     (:inverted m11230 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11231 :com.palletops.awaze.client-builder/undef)
     (. bean11229 setInverted (clojure.core/boolean v11231))))
   (clojure.core/let
    [v11231 (:type m11230 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11231 :com.palletops.awaze.client-builder/undef)
     (. bean11229 setType (clojure.core/str v11231))))
   (clojure.core/let
    [v11231
     (:resource-path m11230 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11231 :com.palletops.awaze.client-builder/undef)
     (. bean11229 setResourcePath (clojure.core/str v11231))))
   (clojure.core/let
    [v11231
     (:search-string m11230 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11231 :com.palletops.awaze.client-builder/undef)
     (. bean11229 setSearchString (clojure.core/str v11231))))
   (clojure.core/let
    [v11231
     (:regions m11230 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11231 :com.palletops.awaze.client-builder/undef)
     (.
      bean11229
      setRegions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11381] (clojure.core/str arg11381))
 v11231))))
   (clojure.core/let
    [v11231
     (:child-health-checks
      m11230
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11231 :com.palletops.awaze.client-builder/undef)
     (.
      bean11229
      setChildHealthChecks
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11382] (clojure.core/str arg11382))
 v11231))))
   (clojure.core/let
    [v11231 (:port m11230 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11231 :com.palletops.awaze.client-builder/undef)
     (. bean11229 setPort (clojure.core/int v11231))))
   (clojure.core/let
    [v11231
     (:health-threshold
      m11230
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11231 :com.palletops.awaze.client-builder/undef)
     (. bean11229 setHealthThreshold (clojure.core/int v11231))))
   (clojure.core/let
    [v11231
     (:request-interval
      m11230
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11231 :com.palletops.awaze.client-builder/undef)
     (. bean11229 setRequestInterval (clojure.core/int v11231))))
   (clojure.core/let
    [v11231
     (:insufficient-data-health-status
      m11230
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11231 :com.palletops.awaze.client-builder/undef)
     (.
      bean11229
      setInsufficientDataHealthStatus
      (route53/insufficient-data-health-status v11231))))
   (clojure.core/let
    [v11231
     (:ipaddress m11230 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11231 :com.palletops.awaze.client-builder/undef)
     (. bean11229 setIPAddress (clojure.core/str v11231))))
   (clojure.core/let
    [v11231
     (:fully-qualified-domain-name
      m11230
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11231 :com.palletops.awaze.client-builder/undef)
     (.
      bean11229
      setFullyQualifiedDomainName
      (clojure.core/str v11231))))
   (clojure.core/let
    [v11231
     (:alarm-identifier
      m11230
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11231 :com.palletops.awaze.client-builder/undef)
     (.
      bean11229
      setAlarmIdentifier
      (route53/alarm-identifier v11231))))
   (clojure.core/let
    [v11231
     (:enable-sni m11230 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11231 :com.palletops.awaze.client-builder/undef)
     (. bean11229 setEnableSNI (clojure.core/boolean v11231))))
   (clojure.core/let
    [v11231
     (:measure-latency
      m11230
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11231 :com.palletops.awaze.client-builder/undef)
     (. bean11229 setMeasureLatency (clojure.core/boolean v11231))))
   (clojure.core/let
    [v11231
     (:failure-threshold
      m11230
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11231 :com.palletops.awaze.client-builder/undef)
     (. bean11229 setFailureThreshold (clojure.core/int v11231))))
   bean11229))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.Tag}
tag
  [m11233]
  (clojure.core/let
   [bean11232 (new com.amazonaws.services.route53.model.Tag)]
   (clojure.core/let
    [v11234 (:key m11233 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11234 :com.palletops.awaze.client-builder/undef)
     (. bean11232 setKey (clojure.core/str v11234))))
   (clojure.core/let
    [v11234 (:value m11233 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11234 :com.palletops.awaze.client-builder/undef)
     (. bean11232 setValue (clojure.core/str v11234))))
   bean11232))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.CreateTrafficPolicyVersionRequest}
create-traffic-policy-version-request
  [m11236]
  (clojure.core/let
   [bean11235
    (new
     com.amazonaws.services.route53.model.CreateTrafficPolicyVersionRequest)]
   (clojure.core/let
    [v11237
     (:comment m11236 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11237 :com.palletops.awaze.client-builder/undef)
     (. bean11235 setComment (clojure.core/str v11237))))
   (clojure.core/let
    [v11237
     (:document m11236 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11237 :com.palletops.awaze.client-builder/undef)
     (. bean11235 setDocument (clojure.core/str v11237))))
   (clojure.core/let
    [v11237 (:id m11236 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11237 :com.palletops.awaze.client-builder/undef)
     (. bean11235 setId (clojure.core/str v11237))))
   bean11235))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.DeleteTrafficPolicyRequest}
delete-traffic-policy-request
  [m11239]
  (clojure.core/let
   [bean11238
    (new
     com.amazonaws.services.route53.model.DeleteTrafficPolicyRequest)]
   (clojure.core/let
    [v11240
     (:version m11239 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11240 :com.palletops.awaze.client-builder/undef)
     (. bean11238 setVersion (clojure.core/int v11240))))
   (clojure.core/let
    [v11240 (:id m11239 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11240 :com.palletops.awaze.client-builder/undef)
     (. bean11238 setId (clojure.core/str v11240))))
   bean11238))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ChangeResourceRecordSetsRequest}
change-resource-record-sets-request
  [m11242]
  (clojure.core/let
   [bean11241
    (new
     com.amazonaws.services.route53.model.ChangeResourceRecordSetsRequest)]
   (clojure.core/let
    [v11243
     (:hosted-zone-id
      m11242
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11243 :com.palletops.awaze.client-builder/undef)
     (. bean11241 setHostedZoneId (clojure.core/str v11243))))
   (clojure.core/let
    [v11243
     (:change-batch m11242 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11243 :com.palletops.awaze.client-builder/undef)
     (. bean11241 setChangeBatch (route53/change-batch v11243))))
   bean11241))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListTrafficPoliciesRequest}
list-traffic-policies-request
  [m11245]
  (clojure.core/let
   [bean11244
    (new
     com.amazonaws.services.route53.model.ListTrafficPoliciesRequest)]
   (clojure.core/let
    [v11246
     (:traffic-policy-id-marker
      m11245
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11246 :com.palletops.awaze.client-builder/undef)
     (. bean11244 setTrafficPolicyIdMarker (clojure.core/str v11246))))
   (clojure.core/let
    [v11246
     (:max-items m11245 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11246 :com.palletops.awaze.client-builder/undef)
     (. bean11244 setMaxItems (clojure.core/str v11246))))
   bean11244))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListTrafficPolicyInstancesByPolicyRequest}
list-traffic-policy-instances-by-policy-request
  [m11248]
  (clojure.core/let
   [bean11247
    (new
     com.amazonaws.services.route53.model.ListTrafficPolicyInstancesByPolicyRequest)]
   (clojure.core/let
    [v11249
     (:traffic-policy-id
      m11248
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11249 :com.palletops.awaze.client-builder/undef)
     (. bean11247 setTrafficPolicyId (clojure.core/str v11249))))
   (clojure.core/let
    [v11249
     (:traffic-policy-version
      m11248
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11249 :com.palletops.awaze.client-builder/undef)
     (. bean11247 setTrafficPolicyVersion (clojure.core/int v11249))))
   (clojure.core/let
    [v11249
     (:hosted-zone-id-marker
      m11248
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11249 :com.palletops.awaze.client-builder/undef)
     (. bean11247 setHostedZoneIdMarker (clojure.core/str v11249))))
   (clojure.core/let
    [v11249
     (:traffic-policy-instance-name-marker
      m11248
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11249 :com.palletops.awaze.client-builder/undef)
     (.
      bean11247
      setTrafficPolicyInstanceNameMarker
      (clojure.core/str v11249))))
   (clojure.core/let
    [v11249
     (:traffic-policy-instance-type-marker
      m11248
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11249 :com.palletops.awaze.client-builder/undef)
     (.
      bean11247
      setTrafficPolicyInstanceTypeMarker
      (route53/rrtype v11249))))
   (clojure.core/let
    [v11249
     (:max-items m11248 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11249 :com.palletops.awaze.client-builder/undef)
     (. bean11247 setMaxItems (clojure.core/str v11249))))
   bean11247))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListTrafficPolicyVersionsRequest}
list-traffic-policy-versions-request
  [m11251]
  (clojure.core/let
   [bean11250
    (new
     com.amazonaws.services.route53.model.ListTrafficPolicyVersionsRequest)]
   (clojure.core/let
    [v11252
     (:traffic-policy-version-marker
      m11251
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11252 :com.palletops.awaze.client-builder/undef)
     (.
      bean11250
      setTrafficPolicyVersionMarker
      (clojure.core/str v11252))))
   (clojure.core/let
    [v11252
     (:max-items m11251 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11252 :com.palletops.awaze.client-builder/undef)
     (. bean11250 setMaxItems (clojure.core/str v11252))))
   (clojure.core/let
    [v11252 (:id m11251 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11252 :com.palletops.awaze.client-builder/undef)
     (. bean11250 setId (clojure.core/str v11252))))
   bean11250))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListTrafficPolicyInstancesByHostedZoneRequest}
list-traffic-policy-instances-by-hosted-zone-request
  [m11254]
  (clojure.core/let
   [bean11253
    (new
     com.amazonaws.services.route53.model.ListTrafficPolicyInstancesByHostedZoneRequest)]
   (clojure.core/let
    [v11255
     (:hosted-zone-id
      m11254
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11255 :com.palletops.awaze.client-builder/undef)
     (. bean11253 setHostedZoneId (clojure.core/str v11255))))
   (clojure.core/let
    [v11255
     (:traffic-policy-instance-name-marker
      m11254
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11255 :com.palletops.awaze.client-builder/undef)
     (.
      bean11253
      setTrafficPolicyInstanceNameMarker
      (clojure.core/str v11255))))
   (clojure.core/let
    [v11255
     (:traffic-policy-instance-type-marker
      m11254
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11255 :com.palletops.awaze.client-builder/undef)
     (.
      bean11253
      setTrafficPolicyInstanceTypeMarker
      (clojure.core/str v11255))))
   (clojure.core/let
    [v11255
     (:max-items m11254 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11255 :com.palletops.awaze.client-builder/undef)
     (. bean11253 setMaxItems (clojure.core/str v11255))))
   bean11253))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.DeleteReusableDelegationSetRequest}
delete-reusable-delegation-set-request
  [m11257]
  (clojure.core/let
   [bean11256
    (new
     com.amazonaws.services.route53.model.DeleteReusableDelegationSetRequest)]
   (clojure.core/let
    [v11258 (:id m11257 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11258 :com.palletops.awaze.client-builder/undef)
     (. bean11256 setId (clojure.core/str v11258))))
   bean11256))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetReusableDelegationSetRequest}
get-reusable-delegation-set-request
  [m11260]
  (clojure.core/let
   [bean11259
    (new
     com.amazonaws.services.route53.model.GetReusableDelegationSetRequest)]
   (clojure.core/let
    [v11261 (:id m11260 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11261 :com.palletops.awaze.client-builder/undef)
     (. bean11259 setId (clojure.core/str v11261))))
   bean11259))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.DeleteHostedZoneRequest}
delete-hosted-zone-request
  [m11263]
  (clojure.core/let
   [bean11262
    (new com.amazonaws.services.route53.model.DeleteHostedZoneRequest)]
   (clojure.core/let
    [v11264 (:id m11263 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11264 :com.palletops.awaze.client-builder/undef)
     (. bean11262 setId (clojure.core/str v11264))))
   bean11262))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.AssociateVPCWithHostedZoneRequest}
associate-vpcwith-hosted-zone-request
  [m11266]
  (clojure.core/let
   [bean11265
    (new
     com.amazonaws.services.route53.model.AssociateVPCWithHostedZoneRequest)]
   (clojure.core/let
    [v11267
     (:comment m11266 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11267 :com.palletops.awaze.client-builder/undef)
     (. bean11265 setComment (clojure.core/str v11267))))
   (clojure.core/let
    [v11267
     (:hosted-zone-id
      m11266
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11267 :com.palletops.awaze.client-builder/undef)
     (. bean11265 setHostedZoneId (clojure.core/str v11267))))
   (clojure.core/let
    [v11267 (:vpc m11266 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11267 :com.palletops.awaze.client-builder/undef)
     (. bean11265 setVPC (route53/vpc v11267))))
   bean11265))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListHostedZonesRequest}
list-hosted-zones-request
  [m11269]
  (clojure.core/let
   [bean11268
    (new com.amazonaws.services.route53.model.ListHostedZonesRequest)]
   (clojure.core/let
    [v11270
     (:delegation-set-id
      m11269
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11270 :com.palletops.awaze.client-builder/undef)
     (. bean11268 setDelegationSetId (clojure.core/str v11270))))
   (clojure.core/let
    [v11270
     (:marker m11269 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11270 :com.palletops.awaze.client-builder/undef)
     (. bean11268 setMarker (clojure.core/str v11270))))
   (clojure.core/let
    [v11270
     (:max-items m11269 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11270 :com.palletops.awaze.client-builder/undef)
     (. bean11268 setMaxItems (clojure.core/str v11270))))
   bean11268))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListReusableDelegationSetsRequest}
list-reusable-delegation-sets-request
  [m11272]
  (clojure.core/let
   [bean11271
    (new
     com.amazonaws.services.route53.model.ListReusableDelegationSetsRequest)]
   (clojure.core/let
    [v11273
     (:marker m11272 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11273 :com.palletops.awaze.client-builder/undef)
     (. bean11271 setMarker (clojure.core/str v11273))))
   (clojure.core/let
    [v11273
     (:max-items m11272 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11273 :com.palletops.awaze.client-builder/undef)
     (. bean11271 setMaxItems (clojure.core/str v11273))))
   bean11271))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.DeleteTrafficPolicyInstanceRequest}
delete-traffic-policy-instance-request
  [m11275]
  (clojure.core/let
   [bean11274
    (new
     com.amazonaws.services.route53.model.DeleteTrafficPolicyInstanceRequest)]
   (clojure.core/let
    [v11276 (:id m11275 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11276 :com.palletops.awaze.client-builder/undef)
     (. bean11274 setId (clojure.core/str v11276))))
   bean11274))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetHealthCheckRequest}
get-health-check-request
  [m11278]
  (clojure.core/let
   [bean11277
    (new com.amazonaws.services.route53.model.GetHealthCheckRequest)]
   (clojure.core/let
    [v11279
     (:health-check-id
      m11278
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11279 :com.palletops.awaze.client-builder/undef)
     (. bean11277 setHealthCheckId (clojure.core/str v11279))))
   bean11277))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListTagsForResourcesRequest}
list-tags-for-resources-request
  [m11281]
  (clojure.core/let
   [bean11280
    (new
     com.amazonaws.services.route53.model.ListTagsForResourcesRequest)]
   (clojure.core/let
    [v11282
     (:resource-ids m11281 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11282 :com.palletops.awaze.client-builder/undef)
     (.
      bean11280
      setResourceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11383] (clojure.core/str arg11383))
 v11282))))
   (clojure.core/let
    [v11282
     (:resource-type m11281 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11282 :com.palletops.awaze.client-builder/undef)
     (. bean11280 setResourceType (route53/tag-resource-type v11282))))
   bean11280))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetCheckerIpRangesRequest}
get-checker-ip-ranges-request
  [m11284]
  (clojure.core/let
   [bean11283
    (new
     com.amazonaws.services.route53.model.GetCheckerIpRangesRequest)]
   bean11283))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.CreateHostedZoneRequest}
create-hosted-zone-request
  [m11287]
  (clojure.core/let
   [bean11286
    (new com.amazonaws.services.route53.model.CreateHostedZoneRequest)]
   (clojure.core/let
    [v11288 (:vpc m11287 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11288 :com.palletops.awaze.client-builder/undef)
     (. bean11286 setVPC (route53/vpc v11288))))
   (clojure.core/let
    [v11288
     (:caller-reference
      m11287
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11288 :com.palletops.awaze.client-builder/undef)
     (. bean11286 setCallerReference (clojure.core/str v11288))))
   (clojure.core/let
    [v11288
     (:hosted-zone-config
      m11287
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11288 :com.palletops.awaze.client-builder/undef)
     (.
      bean11286
      setHostedZoneConfig
      (route53/hosted-zone-config v11288))))
   (clojure.core/let
    [v11288
     (:delegation-set-id
      m11287
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11288 :com.palletops.awaze.client-builder/undef)
     (. bean11286 setDelegationSetId (clojure.core/str v11288))))
   (clojure.core/let
    [v11288 (:name m11287 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11288 :com.palletops.awaze.client-builder/undef)
     (. bean11286 setName (clojure.core/str v11288))))
   bean11286))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListChangeBatchesByHostedZoneRequest}
list-change-batches-by-hosted-zone-request
  [m11290]
  (clojure.core/let
   [bean11289
    (new
     com.amazonaws.services.route53.model.ListChangeBatchesByHostedZoneRequest)]
   (clojure.core/let
    [v11291
     (:start-date m11290 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11291 :com.palletops.awaze.client-builder/undef)
     (. bean11289 setStartDate (clojure.core/str v11291))))
   (clojure.core/let
    [v11291
     (:end-date m11290 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11291 :com.palletops.awaze.client-builder/undef)
     (. bean11289 setEndDate (clojure.core/str v11291))))
   (clojure.core/let
    [v11291
     (:hosted-zone-id
      m11290
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11291 :com.palletops.awaze.client-builder/undef)
     (. bean11289 setHostedZoneId (clojure.core/str v11291))))
   (clojure.core/let
    [v11291
     (:marker m11290 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11291 :com.palletops.awaze.client-builder/undef)
     (. bean11289 setMarker (clojure.core/str v11291))))
   (clojure.core/let
    [v11291
     (:max-items m11290 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11291 :com.palletops.awaze.client-builder/undef)
     (. bean11289 setMaxItems (clojure.core/str v11291))))
   bean11289))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.UpdateHealthCheckRequest}
update-health-check-request
  [m11293]
  (clojure.core/let
   [bean11292
    (new
     com.amazonaws.services.route53.model.UpdateHealthCheckRequest)]
   (clojure.core/let
    [v11294
     (:inverted m11293 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11294 :com.palletops.awaze.client-builder/undef)
     (. bean11292 setInverted (clojure.core/boolean v11294))))
   (clojure.core/let
    [v11294
     (:resource-path m11293 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11294 :com.palletops.awaze.client-builder/undef)
     (. bean11292 setResourcePath (clojure.core/str v11294))))
   (clojure.core/let
    [v11294
     (:search-string m11293 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11294 :com.palletops.awaze.client-builder/undef)
     (. bean11292 setSearchString (clojure.core/str v11294))))
   (clojure.core/let
    [v11294
     (:health-check-id
      m11293
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11294 :com.palletops.awaze.client-builder/undef)
     (. bean11292 setHealthCheckId (clojure.core/str v11294))))
   (clojure.core/let
    [v11294
     (:regions m11293 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11294 :com.palletops.awaze.client-builder/undef)
     (.
      bean11292
      setRegions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11384] (clojure.core/str arg11384))
 v11294))))
   (clojure.core/let
    [v11294
     (:child-health-checks
      m11293
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11294 :com.palletops.awaze.client-builder/undef)
     (.
      bean11292
      setChildHealthChecks
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11385] (clojure.core/str arg11385))
 v11294))))
   (clojure.core/let
    [v11294 (:port m11293 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11294 :com.palletops.awaze.client-builder/undef)
     (. bean11292 setPort (clojure.core/int v11294))))
   (clojure.core/let
    [v11294
     (:health-check-version
      m11293
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11294 :com.palletops.awaze.client-builder/undef)
     (. bean11292 setHealthCheckVersion (clojure.core/long v11294))))
   (clojure.core/let
    [v11294
     (:health-threshold
      m11293
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11294 :com.palletops.awaze.client-builder/undef)
     (. bean11292 setHealthThreshold (clojure.core/int v11294))))
   (clojure.core/let
    [v11294
     (:insufficient-data-health-status
      m11293
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11294 :com.palletops.awaze.client-builder/undef)
     (.
      bean11292
      setInsufficientDataHealthStatus
      (route53/insufficient-data-health-status v11294))))
   (clojure.core/let
    [v11294
     (:ipaddress m11293 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11294 :com.palletops.awaze.client-builder/undef)
     (. bean11292 setIPAddress (clojure.core/str v11294))))
   (clojure.core/let
    [v11294
     (:fully-qualified-domain-name
      m11293
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11294 :com.palletops.awaze.client-builder/undef)
     (.
      bean11292
      setFullyQualifiedDomainName
      (clojure.core/str v11294))))
   (clojure.core/let
    [v11294
     (:alarm-identifier
      m11293
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11294 :com.palletops.awaze.client-builder/undef)
     (.
      bean11292
      setAlarmIdentifier
      (route53/alarm-identifier v11294))))
   (clojure.core/let
    [v11294
     (:enable-sni m11293 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11294 :com.palletops.awaze.client-builder/undef)
     (. bean11292 setEnableSNI (clojure.core/boolean v11294))))
   (clojure.core/let
    [v11294
     (:failure-threshold
      m11293
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11294 :com.palletops.awaze.client-builder/undef)
     (. bean11292 setFailureThreshold (clojure.core/int v11294))))
   bean11292))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetHealthCheckLastFailureReasonRequest}
get-health-check-last-failure-reason-request
  [m11296]
  (clojure.core/let
   [bean11295
    (new
     com.amazonaws.services.route53.model.GetHealthCheckLastFailureReasonRequest)]
   (clojure.core/let
    [v11297
     (:health-check-id
      m11296
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11297 :com.palletops.awaze.client-builder/undef)
     (. bean11295 setHealthCheckId (clojure.core/str v11297))))
   bean11295))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.CreateHealthCheckRequest}
create-health-check-request
  [m11299]
  (clojure.core/let
   [bean11298
    (new
     com.amazonaws.services.route53.model.CreateHealthCheckRequest)]
   (clojure.core/let
    [v11300
     (:caller-reference
      m11299
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11300 :com.palletops.awaze.client-builder/undef)
     (. bean11298 setCallerReference (clojure.core/str v11300))))
   (clojure.core/let
    [v11300
     (:health-check-config
      m11299
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11300 :com.palletops.awaze.client-builder/undef)
     (.
      bean11298
      setHealthCheckConfig
      (route53/health-check-config v11300))))
   bean11298))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.CreateTrafficPolicyInstanceRequest}
create-traffic-policy-instance-request
  [m11302]
  (clojure.core/let
   [bean11301
    (new
     com.amazonaws.services.route53.model.CreateTrafficPolicyInstanceRequest)]
   (clojure.core/let
    [v11303
     (:hosted-zone-id
      m11302
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11303 :com.palletops.awaze.client-builder/undef)
     (. bean11301 setHostedZoneId (clojure.core/str v11303))))
   (clojure.core/let
    [v11303
     (:traffic-policy-id
      m11302
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11303 :com.palletops.awaze.client-builder/undef)
     (. bean11301 setTrafficPolicyId (clojure.core/str v11303))))
   (clojure.core/let
    [v11303
     (:traffic-policy-version
      m11302
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11303 :com.palletops.awaze.client-builder/undef)
     (. bean11301 setTrafficPolicyVersion (clojure.core/int v11303))))
   (clojure.core/let
    [v11303 (:ttl m11302 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11303 :com.palletops.awaze.client-builder/undef)
     (. bean11301 setTTL (clojure.core/long v11303))))
   (clojure.core/let
    [v11303 (:name m11302 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11303 :com.palletops.awaze.client-builder/undef)
     (. bean11301 setName (clojure.core/str v11303))))
   bean11301))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetChangeDetailsRequest}
get-change-details-request
  [m11305]
  (clojure.core/let
   [bean11304
    (new com.amazonaws.services.route53.model.GetChangeDetailsRequest)]
   (clojure.core/let
    [v11306 (:id m11305 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11306 :com.palletops.awaze.client-builder/undef)
     (. bean11304 setId (clojure.core/str v11306))))
   bean11304))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.CreateTrafficPolicyRequest}
create-traffic-policy-request
  [m11308]
  (clojure.core/let
   [bean11307
    (new
     com.amazonaws.services.route53.model.CreateTrafficPolicyRequest)]
   (clojure.core/let
    [v11309
     (:comment m11308 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11309 :com.palletops.awaze.client-builder/undef)
     (. bean11307 setComment (clojure.core/str v11309))))
   (clojure.core/let
    [v11309
     (:document m11308 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11309 :com.palletops.awaze.client-builder/undef)
     (. bean11307 setDocument (clojure.core/str v11309))))
   (clojure.core/let
    [v11309 (:name m11308 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11309 :com.palletops.awaze.client-builder/undef)
     (. bean11307 setName (clojure.core/str v11309))))
   bean11307))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ChangeTagsForResourceRequest}
change-tags-for-resource-request
  [m11311]
  (clojure.core/let
   [bean11310
    (new
     com.amazonaws.services.route53.model.ChangeTagsForResourceRequest)]
   (clojure.core/let
    [v11312
     (:add-tags m11311 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11312 :com.palletops.awaze.client-builder/undef)
     (.
      bean11310
      setAddTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11386] (route53/tag arg11386))
 v11312))))
   (clojure.core/let
    [v11312
     (:remove-tag-keys
      m11311
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11312 :com.palletops.awaze.client-builder/undef)
     (.
      bean11310
      setRemoveTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11387] (clojure.core/str arg11387))
 v11312))))
   (clojure.core/let
    [v11312
     (:resource-id m11311 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11312 :com.palletops.awaze.client-builder/undef)
     (. bean11310 setResourceId (clojure.core/str v11312))))
   (clojure.core/let
    [v11312
     (:resource-type m11311 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11312 :com.palletops.awaze.client-builder/undef)
     (. bean11310 setResourceType (route53/tag-resource-type v11312))))
   bean11310))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetTrafficPolicyInstanceCountRequest}
get-traffic-policy-instance-count-request
  [m11314]
  (clojure.core/let
   [bean11313
    (new
     com.amazonaws.services.route53.model.GetTrafficPolicyInstanceCountRequest)]
   bean11313))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetHealthCheckStatusRequest}
get-health-check-status-request
  [m11317]
  (clojure.core/let
   [bean11316
    (new
     com.amazonaws.services.route53.model.GetHealthCheckStatusRequest)]
   (clojure.core/let
    [v11318
     (:health-check-id
      m11317
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11318 :com.palletops.awaze.client-builder/undef)
     (. bean11316 setHealthCheckId (clojure.core/str v11318))))
   bean11316))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetChangeRequest}
get-change-request
  [m11320]
  (clojure.core/let
   [bean11319
    (new com.amazonaws.services.route53.model.GetChangeRequest)]
   (clojure.core/let
    [v11321 (:id m11320 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11321 :com.palletops.awaze.client-builder/undef)
     (. bean11319 setId (clojure.core/str v11321))))
   bean11319))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListGeoLocationsRequest}
list-geo-locations-request
  [m11323]
  (clojure.core/let
   [bean11322
    (new com.amazonaws.services.route53.model.ListGeoLocationsRequest)]
   (clojure.core/let
    [v11324
     (:start-continent-code
      m11323
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11324 :com.palletops.awaze.client-builder/undef)
     (. bean11322 setStartContinentCode (clojure.core/str v11324))))
   (clojure.core/let
    [v11324
     (:start-country-code
      m11323
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11324 :com.palletops.awaze.client-builder/undef)
     (. bean11322 setStartCountryCode (clojure.core/str v11324))))
   (clojure.core/let
    [v11324
     (:start-subdivision-code
      m11323
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11324 :com.palletops.awaze.client-builder/undef)
     (. bean11322 setStartSubdivisionCode (clojure.core/str v11324))))
   (clojure.core/let
    [v11324
     (:max-items m11323 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11324 :com.palletops.awaze.client-builder/undef)
     (. bean11322 setMaxItems (clojure.core/str v11324))))
   bean11322))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetHostedZoneCountRequest}
get-hosted-zone-count-request
  [m11326]
  (clojure.core/let
   [bean11325
    (new
     com.amazonaws.services.route53.model.GetHostedZoneCountRequest)]
   bean11325))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.UpdateHostedZoneCommentRequest}
update-hosted-zone-comment-request
  [m11329]
  (clojure.core/let
   [bean11328
    (new
     com.amazonaws.services.route53.model.UpdateHostedZoneCommentRequest)]
   (clojure.core/let
    [v11330
     (:comment m11329 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11330 :com.palletops.awaze.client-builder/undef)
     (. bean11328 setComment (clojure.core/str v11330))))
   (clojure.core/let
    [v11330 (:id m11329 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11330 :com.palletops.awaze.client-builder/undef)
     (. bean11328 setId (clojure.core/str v11330))))
   bean11328))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetHealthCheckCountRequest}
get-health-check-count-request
  [m11332]
  (clojure.core/let
   [bean11331
    (new
     com.amazonaws.services.route53.model.GetHealthCheckCountRequest)]
   bean11331))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetHostedZoneRequest}
get-hosted-zone-request
  [m11335]
  (clojure.core/let
   [bean11334
    (new com.amazonaws.services.route53.model.GetHostedZoneRequest)]
   (clojure.core/let
    [v11336 (:id m11335 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11336 :com.palletops.awaze.client-builder/undef)
     (. bean11334 setId (clojure.core/str v11336))))
   bean11334))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.UpdateTrafficPolicyCommentRequest}
update-traffic-policy-comment-request
  [m11338]
  (clojure.core/let
   [bean11337
    (new
     com.amazonaws.services.route53.model.UpdateTrafficPolicyCommentRequest)]
   (clojure.core/let
    [v11339
     (:version m11338 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11339 :com.palletops.awaze.client-builder/undef)
     (. bean11337 setVersion (clojure.core/int v11339))))
   (clojure.core/let
    [v11339
     (:comment m11338 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11339 :com.palletops.awaze.client-builder/undef)
     (. bean11337 setComment (clojure.core/str v11339))))
   (clojure.core/let
    [v11339 (:id m11338 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11339 :com.palletops.awaze.client-builder/undef)
     (. bean11337 setId (clojure.core/str v11339))))
   bean11337))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetTrafficPolicyInstanceRequest}
get-traffic-policy-instance-request
  [m11341]
  (clojure.core/let
   [bean11340
    (new
     com.amazonaws.services.route53.model.GetTrafficPolicyInstanceRequest)]
   (clojure.core/let
    [v11342 (:id m11341 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11342 :com.palletops.awaze.client-builder/undef)
     (. bean11340 setId (clojure.core/str v11342))))
   bean11340))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListHostedZonesByNameRequest}
list-hosted-zones-by-name-request
  [m11344]
  (clojure.core/let
   [bean11343
    (new
     com.amazonaws.services.route53.model.ListHostedZonesByNameRequest)]
   (clojure.core/let
    [v11345
     (:hosted-zone-id
      m11344
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11345 :com.palletops.awaze.client-builder/undef)
     (. bean11343 setHostedZoneId (clojure.core/str v11345))))
   (clojure.core/let
    [v11345
     (:max-items m11344 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11345 :com.palletops.awaze.client-builder/undef)
     (. bean11343 setMaxItems (clojure.core/str v11345))))
   (clojure.core/let
    [v11345
     (:dnsname m11344 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11345 :com.palletops.awaze.client-builder/undef)
     (. bean11343 setDNSName (clojure.core/str v11345))))
   bean11343))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetGeoLocationRequest}
get-geo-location-request
  [m11347]
  (clojure.core/let
   [bean11346
    (new com.amazonaws.services.route53.model.GetGeoLocationRequest)]
   (clojure.core/let
    [v11348
     (:continent-code
      m11347
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11348 :com.palletops.awaze.client-builder/undef)
     (. bean11346 setContinentCode (clojure.core/str v11348))))
   (clojure.core/let
    [v11348
     (:country-code m11347 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11348 :com.palletops.awaze.client-builder/undef)
     (. bean11346 setCountryCode (clojure.core/str v11348))))
   (clojure.core/let
    [v11348
     (:subdivision-code
      m11347
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11348 :com.palletops.awaze.client-builder/undef)
     (. bean11346 setSubdivisionCode (clojure.core/str v11348))))
   bean11346))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListTagsForResourceRequest}
list-tags-for-resource-request
  [m11350]
  (clojure.core/let
   [bean11349
    (new
     com.amazonaws.services.route53.model.ListTagsForResourceRequest)]
   (clojure.core/let
    [v11351
     (:resource-id m11350 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11351 :com.palletops.awaze.client-builder/undef)
     (. bean11349 setResourceId (clojure.core/str v11351))))
   (clojure.core/let
    [v11351
     (:resource-type m11350 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11351 :com.palletops.awaze.client-builder/undef)
     (. bean11349 setResourceType (clojure.core/str v11351))))
   bean11349))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.CreateReusableDelegationSetRequest}
create-reusable-delegation-set-request
  [m11353]
  (clojure.core/let
   [bean11352
    (new
     com.amazonaws.services.route53.model.CreateReusableDelegationSetRequest)]
   (clojure.core/let
    [v11354
     (:hosted-zone-id
      m11353
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11354 :com.palletops.awaze.client-builder/undef)
     (. bean11352 setHostedZoneId (clojure.core/str v11354))))
   (clojure.core/let
    [v11354
     (:caller-reference
      m11353
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11354 :com.palletops.awaze.client-builder/undef)
     (. bean11352 setCallerReference (clojure.core/str v11354))))
   bean11352))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListHealthChecksRequest}
list-health-checks-request
  [m11356]
  (clojure.core/let
   [bean11355
    (new com.amazonaws.services.route53.model.ListHealthChecksRequest)]
   (clojure.core/let
    [v11357
     (:marker m11356 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11357 :com.palletops.awaze.client-builder/undef)
     (. bean11355 setMarker (clojure.core/str v11357))))
   (clojure.core/let
    [v11357
     (:max-items m11356 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11357 :com.palletops.awaze.client-builder/undef)
     (. bean11355 setMaxItems (clojure.core/str v11357))))
   bean11355))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.UpdateTrafficPolicyInstanceRequest}
update-traffic-policy-instance-request
  [m11359]
  (clojure.core/let
   [bean11358
    (new
     com.amazonaws.services.route53.model.UpdateTrafficPolicyInstanceRequest)]
   (clojure.core/let
    [v11360
     (:traffic-policy-id
      m11359
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11360 :com.palletops.awaze.client-builder/undef)
     (. bean11358 setTrafficPolicyId (clojure.core/str v11360))))
   (clojure.core/let
    [v11360
     (:traffic-policy-version
      m11359
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11360 :com.palletops.awaze.client-builder/undef)
     (. bean11358 setTrafficPolicyVersion (clojure.core/int v11360))))
   (clojure.core/let
    [v11360 (:ttl m11359 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11360 :com.palletops.awaze.client-builder/undef)
     (. bean11358 setTTL (clojure.core/long v11360))))
   (clojure.core/let
    [v11360 (:id m11359 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11360 :com.palletops.awaze.client-builder/undef)
     (. bean11358 setId (clojure.core/str v11360))))
   bean11358))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.DeleteHealthCheckRequest}
delete-health-check-request
  [m11362]
  (clojure.core/let
   [bean11361
    (new
     com.amazonaws.services.route53.model.DeleteHealthCheckRequest)]
   (clojure.core/let
    [v11363
     (:health-check-id
      m11362
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11363 :com.palletops.awaze.client-builder/undef)
     (. bean11361 setHealthCheckId (clojure.core/str v11363))))
   bean11361))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetTrafficPolicyRequest}
get-traffic-policy-request
  [m11365]
  (clojure.core/let
   [bean11364
    (new com.amazonaws.services.route53.model.GetTrafficPolicyRequest)]
   (clojure.core/let
    [v11366
     (:version m11365 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11366 :com.palletops.awaze.client-builder/undef)
     (. bean11364 setVersion (clojure.core/int v11366))))
   (clojure.core/let
    [v11366 (:id m11365 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11366 :com.palletops.awaze.client-builder/undef)
     (. bean11364 setId (clojure.core/str v11366))))
   bean11364))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListChangeBatchesByRRSetRequest}
list-change-batches-by-rrset-request
  [m11368]
  (clojure.core/let
   [bean11367
    (new
     com.amazonaws.services.route53.model.ListChangeBatchesByRRSetRequest)]
   (clojure.core/let
    [v11369
     (:start-date m11368 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11369 :com.palletops.awaze.client-builder/undef)
     (. bean11367 setStartDate (clojure.core/str v11369))))
   (clojure.core/let
    [v11369
     (:end-date m11368 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11369 :com.palletops.awaze.client-builder/undef)
     (. bean11367 setEndDate (clojure.core/str v11369))))
   (clojure.core/let
    [v11369
     (:hosted-zone-id
      m11368
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11369 :com.palletops.awaze.client-builder/undef)
     (. bean11367 setHostedZoneId (clojure.core/str v11369))))
   (clojure.core/let
    [v11369
     (:set-identifier
      m11368
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11369 :com.palletops.awaze.client-builder/undef)
     (. bean11367 setSetIdentifier (clojure.core/str v11369))))
   (clojure.core/let
    [v11369 (:type m11368 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11369 :com.palletops.awaze.client-builder/undef)
     (. bean11367 setType (clojure.core/str v11369))))
   (clojure.core/let
    [v11369
     (:marker m11368 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11369 :com.palletops.awaze.client-builder/undef)
     (. bean11367 setMarker (clojure.core/str v11369))))
   (clojure.core/let
    [v11369
     (:max-items m11368 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11369 :com.palletops.awaze.client-builder/undef)
     (. bean11367 setMaxItems (clojure.core/str v11369))))
   (clojure.core/let
    [v11369 (:name m11368 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11369 :com.palletops.awaze.client-builder/undef)
     (. bean11367 setName (clojure.core/str v11369))))
   bean11367))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListResourceRecordSetsRequest}
list-resource-record-sets-request
  [m11371]
  (clojure.core/let
   [bean11370
    (new
     com.amazonaws.services.route53.model.ListResourceRecordSetsRequest)]
   (clojure.core/let
    [v11372
     (:hosted-zone-id
      m11371
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11372 :com.palletops.awaze.client-builder/undef)
     (. bean11370 setHostedZoneId (clojure.core/str v11372))))
   (clojure.core/let
    [v11372
     (:start-record-type
      m11371
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11372 :com.palletops.awaze.client-builder/undef)
     (. bean11370 setStartRecordType (clojure.core/str v11372))))
   (clojure.core/let
    [v11372
     (:start-record-identifier
      m11371
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11372 :com.palletops.awaze.client-builder/undef)
     (. bean11370 setStartRecordIdentifier (clojure.core/str v11372))))
   (clojure.core/let
    [v11372
     (:start-record-name
      m11371
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11372 :com.palletops.awaze.client-builder/undef)
     (. bean11370 setStartRecordName (clojure.core/str v11372))))
   (clojure.core/let
    [v11372
     (:max-items m11371 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11372 :com.palletops.awaze.client-builder/undef)
     (. bean11370 setMaxItems (clojure.core/str v11372))))
   bean11370))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.DisassociateVPCFromHostedZoneRequest}
disassociate-vpcfrom-hosted-zone-request
  [m11374]
  (clojure.core/let
   [bean11373
    (new
     com.amazonaws.services.route53.model.DisassociateVPCFromHostedZoneRequest)]
   (clojure.core/let
    [v11375
     (:comment m11374 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11375 :com.palletops.awaze.client-builder/undef)
     (. bean11373 setComment (clojure.core/str v11375))))
   (clojure.core/let
    [v11375
     (:hosted-zone-id
      m11374
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11375 :com.palletops.awaze.client-builder/undef)
     (. bean11373 setHostedZoneId (clojure.core/str v11375))))
   (clojure.core/let
    [v11375 (:vpc m11374 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11375 :com.palletops.awaze.client-builder/undef)
     (. bean11373 setVPC (route53/vpc v11375))))
   bean11373))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListTrafficPolicyInstancesRequest}
list-traffic-policy-instances-request
  [m11377]
  (clojure.core/let
   [bean11376
    (new
     com.amazonaws.services.route53.model.ListTrafficPolicyInstancesRequest)]
   (clojure.core/let
    [v11378
     (:hosted-zone-id-marker
      m11377
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11378 :com.palletops.awaze.client-builder/undef)
     (. bean11376 setHostedZoneIdMarker (clojure.core/str v11378))))
   (clojure.core/let
    [v11378
     (:traffic-policy-instance-name-marker
      m11377
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11378 :com.palletops.awaze.client-builder/undef)
     (.
      bean11376
      setTrafficPolicyInstanceNameMarker
      (clojure.core/str v11378))))
   (clojure.core/let
    [v11378
     (:traffic-policy-instance-type-marker
      m11377
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11378 :com.palletops.awaze.client-builder/undef)
     (.
      bean11376
      setTrafficPolicyInstanceTypeMarker
      (clojure.core/str v11378))))
   (clojure.core/let
    [v11378
     (:max-items m11377 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11378 :com.palletops.awaze.client-builder/undef)
     (. bean11376 setMaxItems (clojure.core/str v11378))))
   bean11376))
 (clojure.core/defmulti
  route53
  (clojure.core/fn route53 [m__1874__auto__] (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   route53
   :create-traffic-policy-version
   [m11388]
   (clojure.core/let
    [credentials11389 (:credentials m11388) args11390 (:args m11388)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11391
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11389)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11391
       createTrafficPolicyVersion
       (route53/create-traffic-policy-version-request
        (clojure.core/nth args11390 0)))))))
  (clojure.core/defn
   create-traffic-policy-version-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         document
                         read-limit
                         id
                         comment
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createTrafficPolicyVersion"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-traffic-policy-version,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   create-traffic-policy-version
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         document
                         read-limit
                         id
                         comment
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createTrafficPolicyVersion"}
   [credentials11393 & args11394]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11395
     (com.palletops.awaze.common/aws-client :route53 credentials11393)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11395
      createTrafficPolicyVersion
      (route53/create-traffic-policy-version-request
       (clojure.core/nth args11394 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :delete-traffic-policy
   [m11396]
   (clojure.core/let
    [credentials11397 (:credentials m11396) args11398 (:args m11396)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11399
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11397)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11399
       deleteTrafficPolicy
       (route53/delete-traffic-policy-request
        (clojure.core/nth args11398 0)))))))
  (clojure.core/defn
   delete-traffic-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         version
                         clone-root]}]]),
    :doc "Generate map for deleteTrafficPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-traffic-policy,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   delete-traffic-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         version
                         clone-root]}]]),
    :doc "Call deleteTrafficPolicy"}
   [credentials11401 & args11402]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11403
     (com.palletops.awaze.common/aws-client :route53 credentials11401)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11403
      deleteTrafficPolicy
      (route53/delete-traffic-policy-request
       (clojure.core/nth args11402 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :change-resource-record-sets
   [m11404]
   (clojure.core/let
    [credentials11405 (:credentials m11404) args11406 (:args m11404)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11407
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11405)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11407
       changeResourceRecordSets
       (route53/change-resource-record-sets-request
        (clojure.core/nth args11406 0)))))))
  (clojure.core/defn
   change-resource-record-sets-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         change-batch
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Generate map for changeResourceRecordSets"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :change-resource-record-sets,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   change-resource-record-sets
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         change-batch
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Call changeResourceRecordSets"}
   [credentials11409 & args11410]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11411
     (com.palletops.awaze.common/aws-client :route53 credentials11409)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11411
      changeResourceRecordSets
      (route53/change-resource-record-sets-request
       (clojure.core/nth args11410 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-traffic-policies
   [m11412]
   (clojure.core/let
    [credentials11413 (:credentials m11412) args11414 (:args m11412)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11415
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11413)]
     (clojure.core/case
      (clojure.core/count args11414)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11415
        listTrafficPolicies
        (route53/list-traffic-policies-request
         (clojure.core/nth args11414 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11415
        listTrafficPolicies))))))
  (clojure.core/defn
   list-traffic-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         max-items
                         traffic-policy-id-marker
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listTrafficPolicies, listTrafficPolicies"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-traffic-policies,
     :credentials credentials__1842__auto__,
     :client :route53})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-traffic-policies,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   list-traffic-policies
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         max-items
                         traffic-policy-id-marker
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listTrafficPolicies, listTrafficPolicies"}
   [credentials11417 & args11418]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11419
     (com.palletops.awaze.common/aws-client :route53 credentials11417)]
    (clojure.core/case
     (clojure.core/count args11418)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11419
       listTrafficPolicies
       (route53/list-traffic-policies-request
        (clojure.core/nth args11418 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11419
       listTrafficPolicies))))))
 (do
  (clojure.core/defmethod
   route53
   :list-traffic-policy-instances-by-policy
   [m11420]
   (clojure.core/let
    [credentials11421 (:credentials m11420) args11422 (:args m11420)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11423
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11421)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11423
       listTrafficPolicyInstancesByPolicy
       (route53/list-traffic-policy-instances-by-policy-request
        (clojure.core/nth args11422 0)))))))
  (clojure.core/defn
   list-traffic-policy-instances-by-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         traffic-policy-instance-type-marker
                         hosted-zone-id-marker
                         traffic-policy-version
                         traffic-policy-id
                         traffic-policy-instance-name-marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listTrafficPolicyInstancesByPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-traffic-policy-instances-by-policy,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   list-traffic-policy-instances-by-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         traffic-policy-instance-type-marker
                         hosted-zone-id-marker
                         traffic-policy-version
                         traffic-policy-id
                         traffic-policy-instance-name-marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listTrafficPolicyInstancesByPolicy"}
   [credentials11425 & args11426]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11427
     (com.palletops.awaze.common/aws-client :route53 credentials11425)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11427
      listTrafficPolicyInstancesByPolicy
      (route53/list-traffic-policy-instances-by-policy-request
       (clojure.core/nth args11426 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-traffic-policy-versions
   [m11428]
   (clojure.core/let
    [credentials11429 (:credentials m11428) args11430 (:args m11428)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11431
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11429)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11431
       listTrafficPolicyVersions
       (route53/list-traffic-policy-versions-request
        (clojure.core/nth args11430 0)))))))
  (clojure.core/defn
   list-traffic-policy-versions-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         traffic-policy-version-marker
                         custom-query-parameters
                         max-items
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listTrafficPolicyVersions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-traffic-policy-versions,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   list-traffic-policy-versions
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         traffic-policy-version-marker
                         custom-query-parameters
                         max-items
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listTrafficPolicyVersions"}
   [credentials11433 & args11434]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11435
     (com.palletops.awaze.common/aws-client :route53 credentials11433)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11435
      listTrafficPolicyVersions
      (route53/list-traffic-policy-versions-request
       (clojure.core/nth args11434 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-traffic-policy-instances-by-hosted-zone
   [m11436]
   (clojure.core/let
    [credentials11437 (:credentials m11436) args11438 (:args m11436)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11439
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11437)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11439
       listTrafficPolicyInstancesByHostedZone
       (route53/list-traffic-policy-instances-by-hosted-zone-request
        (clojure.core/nth args11438 0)))))))
  (clojure.core/defn
   list-traffic-policy-instances-by-hosted-zone-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         traffic-policy-instance-type-marker
                         traffic-policy-instance-name-marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Generate map for listTrafficPolicyInstancesByHostedZone"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-traffic-policy-instances-by-hosted-zone,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   list-traffic-policy-instances-by-hosted-zone
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         traffic-policy-instance-type-marker
                         traffic-policy-instance-name-marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Call listTrafficPolicyInstancesByHostedZone"}
   [credentials11441 & args11442]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11443
     (com.palletops.awaze.common/aws-client :route53 credentials11441)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11443
      listTrafficPolicyInstancesByHostedZone
      (route53/list-traffic-policy-instances-by-hosted-zone-request
       (clojure.core/nth args11442 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :delete-reusable-delegation-set
   [m11444]
   (clojure.core/let
    [credentials11445 (:credentials m11444) args11446 (:args m11444)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11447
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11445)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11447
       deleteReusableDelegationSet
       (route53/delete-reusable-delegation-set-request
        (clojure.core/nth args11446 0)))))))
  (clojure.core/defn
   delete-reusable-delegation-set-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteReusableDelegationSet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-reusable-delegation-set,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   delete-reusable-delegation-set
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteReusableDelegationSet"}
   [credentials11449 & args11450]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11451
     (com.palletops.awaze.common/aws-client :route53 credentials11449)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11451
      deleteReusableDelegationSet
      (route53/delete-reusable-delegation-set-request
       (clojure.core/nth args11450 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :get-reusable-delegation-set
   [m11452]
   (clojure.core/let
    [credentials11453 (:credentials m11452) args11454 (:args m11452)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11455
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11453)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11455
       getReusableDelegationSet
       (route53/get-reusable-delegation-set-request
        (clojure.core/nth args11454 0)))))))
  (clojure.core/defn
   get-reusable-delegation-set-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getReusableDelegationSet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-reusable-delegation-set,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   get-reusable-delegation-set
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getReusableDelegationSet"}
   [credentials11457 & args11458]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11459
     (com.palletops.awaze.common/aws-client :route53 credentials11457)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11459
      getReusableDelegationSet
      (route53/get-reusable-delegation-set-request
       (clojure.core/nth args11458 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :delete-hosted-zone
   [m11460]
   (clojure.core/let
    [credentials11461 (:credentials m11460) args11462 (:args m11460)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11463
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11461)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11463
       deleteHostedZone
       (route53/delete-hosted-zone-request
        (clojure.core/nth args11462 0)))))))
  (clojure.core/defn
   delete-hosted-zone-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteHostedZone"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-hosted-zone,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   delete-hosted-zone
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteHostedZone"}
   [credentials11465 & args11466]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11467
     (com.palletops.awaze.common/aws-client :route53 credentials11465)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11467
      deleteHostedZone
      (route53/delete-hosted-zone-request
       (clojure.core/nth args11466 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :associate-vpcwith-hosted-zone
   [m11468]
   (clojure.core/let
    [credentials11469 (:credentials m11468) args11470 (:args m11468)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11471
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11469)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11471
       associateVPCWithHostedZone
       (route53/associate-vpcwith-hosted-zone-request
        (clojure.core/nth args11470 0)))))))
  (clojure.core/defn
   associate-vpcwith-hosted-zone-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         vpc
                         comment
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Generate map for associateVPCWithHostedZone"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :associate-vpcwith-hosted-zone,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   associate-vpcwith-hosted-zone
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         vpc
                         comment
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Call associateVPCWithHostedZone"}
   [credentials11473 & args11474]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11475
     (com.palletops.awaze.common/aws-client :route53 credentials11473)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11475
      associateVPCWithHostedZone
      (route53/associate-vpcwith-hosted-zone-request
       (clojure.core/nth args11474 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-hosted-zones
   [m11476]
   (clojure.core/let
    [credentials11477 (:credentials m11476) args11478 (:args m11476)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11479
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11477)]
     (clojure.core/case
      (clojure.core/count args11478)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11479
        listHostedZones
        (route53/list-hosted-zones-request
         (clojure.core/nth args11478 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11479
        listHostedZones))))))
  (clojure.core/defn
   list-hosted-zones-map
   {:arglists (quote
               [[credentials
                 {:keys [delegation-set-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listHostedZones, listHostedZones"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-hosted-zones,
     :credentials credentials__1842__auto__,
     :client :route53})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-hosted-zones,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   list-hosted-zones
   {:arglists (quote
               [[credentials
                 {:keys [delegation-set-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listHostedZones, listHostedZones"}
   [credentials11481 & args11482]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11483
     (com.palletops.awaze.common/aws-client :route53 credentials11481)]
    (clojure.core/case
     (clojure.core/count args11482)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11483
       listHostedZones
       (route53/list-hosted-zones-request
        (clojure.core/nth args11482 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11483
       listHostedZones))))))
 (do
  (clojure.core/defmethod
   route53
   :list-reusable-delegation-sets
   [m11484]
   (clojure.core/let
    [credentials11485 (:credentials m11484) args11486 (:args m11484)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11487
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11485)]
     (clojure.core/case
      (clojure.core/count args11486)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11487
        listReusableDelegationSets
        (route53/list-reusable-delegation-sets-request
         (clojure.core/nth args11486 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11487
        listReusableDelegationSets))))))
  (clojure.core/defn
   list-reusable-delegation-sets-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listReusableDelegationSets, listReusableDelegationSets"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-reusable-delegation-sets,
     :credentials credentials__1842__auto__,
     :client :route53})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-reusable-delegation-sets,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   list-reusable-delegation-sets
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listReusableDelegationSets, listReusableDelegationSets"}
   [credentials11489 & args11490]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11491
     (com.palletops.awaze.common/aws-client :route53 credentials11489)]
    (clojure.core/case
     (clojure.core/count args11490)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11491
       listReusableDelegationSets
       (route53/list-reusable-delegation-sets-request
        (clojure.core/nth args11490 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11491
       listReusableDelegationSets))))))
 (do
  (clojure.core/defmethod
   route53
   :delete-traffic-policy-instance
   [m11492]
   (clojure.core/let
    [credentials11493 (:credentials m11492) args11494 (:args m11492)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11495
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11493)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11495
       deleteTrafficPolicyInstance
       (route53/delete-traffic-policy-instance-request
        (clojure.core/nth args11494 0)))))))
  (clojure.core/defn
   delete-traffic-policy-instance-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteTrafficPolicyInstance"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-traffic-policy-instance,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   delete-traffic-policy-instance
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteTrafficPolicyInstance"}
   [credentials11497 & args11498]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11499
     (com.palletops.awaze.common/aws-client :route53 credentials11497)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11499
      deleteTrafficPolicyInstance
      (route53/delete-traffic-policy-instance-request
       (clojure.core/nth args11498 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :get-health-check
   [m11500]
   (clojure.core/let
    [credentials11501 (:credentials m11500) args11502 (:args m11500)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11503
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11501)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11503
       getHealthCheck
       (route53/get-health-check-request
        (clojure.core/nth args11502 0)))))))
  (clojure.core/defn
   get-health-check-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         health-check-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getHealthCheck"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-health-check,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   get-health-check
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         health-check-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getHealthCheck"}
   [credentials11505 & args11506]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11507
     (com.palletops.awaze.common/aws-client :route53 credentials11505)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11507
      getHealthCheck
      (route53/get-health-check-request
       (clojure.core/nth args11506 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-tags-for-resources
   [m11508]
   (clojure.core/let
    [credentials11509 (:credentials m11508) args11510 (:args m11508)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11511
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11509)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11511
       listTagsForResources
       (route53/list-tags-for-resources-request
        (clojure.core/nth args11510 0)))))))
  (clojure.core/defn
   list-tags-for-resources-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         resource-ids
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         resource-type
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listTagsForResources"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-tags-for-resources,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   list-tags-for-resources
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         resource-ids
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         resource-type
                         clone-source
                         clone-root]}]]),
    :doc "Call listTagsForResources"}
   [credentials11513 & args11514]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11515
     (com.palletops.awaze.common/aws-client :route53 credentials11513)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11515
      listTagsForResources
      (route53/list-tags-for-resources-request
       (clojure.core/nth args11514 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :get-checker-ip-ranges
   [m11516]
   (clojure.core/let
    [credentials11517 (:credentials m11516) args11518 (:args m11516)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11519
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11517)]
     (clojure.core/case
      (clojure.core/count args11518)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11519
        getCheckerIpRanges
        (route53/get-checker-ip-ranges-request
         (clojure.core/nth args11518 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11519
        getCheckerIpRanges))))))
  (clojure.core/defn
   get-checker-ip-ranges-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for getCheckerIpRanges, getCheckerIpRanges"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-checker-ip-ranges,
     :credentials credentials__1842__auto__,
     :client :route53})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-checker-ip-ranges,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   get-checker-ip-ranges
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call getCheckerIpRanges, getCheckerIpRanges"}
   [credentials11521 & args11522]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11523
     (com.palletops.awaze.common/aws-client :route53 credentials11521)]
    (clojure.core/case
     (clojure.core/count args11522)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11523
       getCheckerIpRanges
       (route53/get-checker-ip-ranges-request
        (clojure.core/nth args11522 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11523
       getCheckerIpRanges))))))
 (do
  (clojure.core/defmethod
   route53
   :create-hosted-zone
   [m11524]
   (clojure.core/let
    [credentials11525 (:credentials m11524) args11526 (:args m11524)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11527
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11525)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11527
       createHostedZone
       (route53/create-hosted-zone-request
        (clojure.core/nth args11526 0)))))))
  (clojure.core/defn
   create-hosted-zone-map
   {:arglists (quote
               [[credentials
                 {:keys [caller-reference
                         delegation-set-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         hosted-zone-config
                         custom-query-parameters
                         read-limit
                         vpc
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createHostedZone"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-hosted-zone,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   create-hosted-zone
   {:arglists (quote
               [[credentials
                 {:keys [caller-reference
                         delegation-set-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         hosted-zone-config
                         custom-query-parameters
                         read-limit
                         vpc
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createHostedZone"}
   [credentials11529 & args11530]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11531
     (com.palletops.awaze.common/aws-client :route53 credentials11529)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11531
      createHostedZone
      (route53/create-hosted-zone-request
       (clojure.core/nth args11530 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-change-batches-by-hosted-zone
   [m11532]
   (clojure.core/let
    [credentials11533 (:credentials m11532) args11534 (:args m11532)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11535
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11533)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11535
       listChangeBatchesByHostedZone
       (route53/list-change-batches-by-hosted-zone-request
        (clojure.core/nth args11534 0)))))))
  (clojure.core/defn
   list-change-batches-by-hosted-zone-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         end-date
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         start-date
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Generate map for listChangeBatchesByHostedZone"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-change-batches-by-hosted-zone,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   list-change-batches-by-hosted-zone
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         end-date
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         start-date
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Call listChangeBatchesByHostedZone"}
   [credentials11537 & args11538]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11539
     (com.palletops.awaze.common/aws-client :route53 credentials11537)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11539
      listChangeBatchesByHostedZone
      (route53/list-change-batches-by-hosted-zone-request
       (clojure.core/nth args11538 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :update-health-check
   [m11540]
   (clojure.core/let
    [credentials11541 (:credentials m11540) args11542 (:args m11540)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11543
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11541)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11543
       updateHealthCheck
       (route53/update-health-check-request
        (clojure.core/nth args11542 0)))))))
  (clojure.core/defn
   update-health-check-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         fully-qualified-domain-name
                         resource-path
                         sdk-request-timeout
                         regions
                         custom-query-parameters
                         insufficient-data-health-status
                         port
                         health-threshold
                         health-check-id
                         failure-threshold
                         enable-sni
                         read-limit
                         health-check-version
                         ipaddress
                         child-health-checks
                         general-progress-listener
                         clone-source
                         search-string
                         alarm-identifier
                         clone-root
                         inverted]}]]),
    :doc "Generate map for updateHealthCheck"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-health-check,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   update-health-check
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         fully-qualified-domain-name
                         resource-path
                         sdk-request-timeout
                         regions
                         custom-query-parameters
                         insufficient-data-health-status
                         port
                         health-threshold
                         health-check-id
                         failure-threshold
                         enable-sni
                         read-limit
                         health-check-version
                         ipaddress
                         child-health-checks
                         general-progress-listener
                         clone-source
                         search-string
                         alarm-identifier
                         clone-root
                         inverted]}]]),
    :doc "Call updateHealthCheck"}
   [credentials11545 & args11546]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11547
     (com.palletops.awaze.common/aws-client :route53 credentials11545)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11547
      updateHealthCheck
      (route53/update-health-check-request
       (clojure.core/nth args11546 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :get-health-check-last-failure-reason
   [m11548]
   (clojure.core/let
    [credentials11549 (:credentials m11548) args11550 (:args m11548)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11551
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11549)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11551
       getHealthCheckLastFailureReason
       (route53/get-health-check-last-failure-reason-request
        (clojure.core/nth args11550 0)))))))
  (clojure.core/defn
   get-health-check-last-failure-reason-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         health-check-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getHealthCheckLastFailureReason"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-health-check-last-failure-reason,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   get-health-check-last-failure-reason
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         health-check-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getHealthCheckLastFailureReason"}
   [credentials11553 & args11554]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11555
     (com.palletops.awaze.common/aws-client :route53 credentials11553)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11555
      getHealthCheckLastFailureReason
      (route53/get-health-check-last-failure-reason-request
       (clojure.core/nth args11554 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :create-health-check
   [m11556]
   (clojure.core/let
    [credentials11557 (:credentials m11556) args11558 (:args m11556)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11559
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11557)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11559
       createHealthCheck
       (route53/create-health-check-request
        (clojure.core/nth args11558 0)))))))
  (clojure.core/defn
   create-health-check-map
   {:arglists (quote
               [[credentials
                 {:keys [caller-reference
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         health-check-config
                         clone-root]}]]),
    :doc "Generate map for createHealthCheck"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-health-check,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   create-health-check
   {:arglists (quote
               [[credentials
                 {:keys [caller-reference
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         health-check-config
                         clone-root]}]]),
    :doc "Call createHealthCheck"}
   [credentials11561 & args11562]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11563
     (com.palletops.awaze.common/aws-client :route53 credentials11561)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11563
      createHealthCheck
      (route53/create-health-check-request
       (clojure.core/nth args11562 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :create-traffic-policy-instance
   [m11564]
   (clojure.core/let
    [credentials11565 (:credentials m11564) args11566 (:args m11564)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11567
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11565)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11567
       createTrafficPolicyInstance
       (route53/create-traffic-policy-instance-request
        (clojure.core/nth args11566 0)))))))
  (clojure.core/defn
   create-traffic-policy-instance-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         traffic-policy-version
                         traffic-policy-id
                         custom-query-parameters
                         ttl
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Generate map for createTrafficPolicyInstance"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-traffic-policy-instance,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   create-traffic-policy-instance
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         traffic-policy-version
                         traffic-policy-id
                         custom-query-parameters
                         ttl
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Call createTrafficPolicyInstance"}
   [credentials11569 & args11570]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11571
     (com.palletops.awaze.common/aws-client :route53 credentials11569)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11571
      createTrafficPolicyInstance
      (route53/create-traffic-policy-instance-request
       (clojure.core/nth args11570 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :get-change-details
   [m11572]
   (clojure.core/let
    [credentials11573 (:credentials m11572) args11574 (:args m11572)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11575
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11573)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11575
       getChangeDetails
       (route53/get-change-details-request
        (clojure.core/nth args11574 0)))))))
  (clojure.core/defn
   get-change-details-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getChangeDetails"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-change-details,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   get-change-details
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getChangeDetails"}
   [credentials11577 & args11578]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11579
     (com.palletops.awaze.common/aws-client :route53 credentials11577)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11579
      getChangeDetails
      (route53/get-change-details-request
       (clojure.core/nth args11578 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :create-traffic-policy
   [m11580]
   (clojure.core/let
    [credentials11581 (:credentials m11580) args11582 (:args m11580)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11583
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11581)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11583
       createTrafficPolicy
       (route53/create-traffic-policy-request
        (clojure.core/nth args11582 0)))))))
  (clojure.core/defn
   create-traffic-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         document
                         read-limit
                         comment
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createTrafficPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-traffic-policy,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   create-traffic-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         document
                         read-limit
                         comment
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createTrafficPolicy"}
   [credentials11585 & args11586]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11587
     (com.palletops.awaze.common/aws-client :route53 credentials11585)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11587
      createTrafficPolicy
      (route53/create-traffic-policy-request
       (clojure.core/nth args11586 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :change-tags-for-resource
   [m11588]
   (clojure.core/let
    [credentials11589 (:credentials m11588) args11590 (:args m11588)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11591
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11589)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11591
       changeTagsForResource
       (route53/change-tags-for-resource-request
        (clojure.core/nth args11590 0)))))))
  (clojure.core/defn
   change-tags-for-resource-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         remove-tag-keys
                         resource-id
                         custom-query-parameters
                         add-tags
                         read-limit
                         general-progress-listener
                         resource-type
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for changeTagsForResource"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :change-tags-for-resource,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   change-tags-for-resource
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         remove-tag-keys
                         resource-id
                         custom-query-parameters
                         add-tags
                         read-limit
                         general-progress-listener
                         resource-type
                         clone-source
                         clone-root]}]]),
    :doc "Call changeTagsForResource"}
   [credentials11593 & args11594]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11595
     (com.palletops.awaze.common/aws-client :route53 credentials11593)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11595
      changeTagsForResource
      (route53/change-tags-for-resource-request
       (clojure.core/nth args11594 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :get-traffic-policy-instance-count
   [m11596]
   (clojure.core/let
    [credentials11597 (:credentials m11596) args11598 (:args m11596)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11599
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11597)]
     (clojure.core/case
      (clojure.core/count args11598)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11599
        getTrafficPolicyInstanceCount))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11599
        getTrafficPolicyInstanceCount
        (route53/get-traffic-policy-instance-count-request
         (clojure.core/nth args11598 0))))))))
  (clojure.core/defn
   get-traffic-policy-instance-count-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getTrafficPolicyInstanceCount, getTrafficPolicyInstanceCount"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-traffic-policy-instance-count,
     :credentials credentials__1842__auto__,
     :client :route53})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-traffic-policy-instance-count,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   get-traffic-policy-instance-count
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getTrafficPolicyInstanceCount, getTrafficPolicyInstanceCount"}
   [credentials11601 & args11602]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11603
     (com.palletops.awaze.common/aws-client :route53 credentials11601)]
    (clojure.core/case
     (clojure.core/count args11602)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11603
       getTrafficPolicyInstanceCount))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11603
       getTrafficPolicyInstanceCount
       (route53/get-traffic-policy-instance-count-request
        (clojure.core/nth args11602 0))))))))
 (do
  (clojure.core/defmethod
   route53
   :get-health-check-status
   [m11604]
   (clojure.core/let
    [credentials11605 (:credentials m11604) args11606 (:args m11604)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11607
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11605)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11607
       getHealthCheckStatus
       (route53/get-health-check-status-request
        (clojure.core/nth args11606 0)))))))
  (clojure.core/defn
   get-health-check-status-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         health-check-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getHealthCheckStatus"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-health-check-status,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   get-health-check-status
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         health-check-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getHealthCheckStatus"}
   [credentials11609 & args11610]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11611
     (com.palletops.awaze.common/aws-client :route53 credentials11609)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11611
      getHealthCheckStatus
      (route53/get-health-check-status-request
       (clojure.core/nth args11610 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :get-change
   [m11612]
   (clojure.core/let
    [credentials11613 (:credentials m11612) args11614 (:args m11612)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11615
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11613)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11615
       getChange
       (route53/get-change-request (clojure.core/nth args11614 0)))))))
  (clojure.core/defn
   get-change-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getChange"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-change,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   get-change
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getChange"}
   [credentials11617 & args11618]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11619
     (com.palletops.awaze.common/aws-client :route53 credentials11617)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11619
      getChange
      (route53/get-change-request (clojure.core/nth args11618 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-geo-locations
   [m11620]
   (clojure.core/let
    [credentials11621 (:credentials m11620) args11622 (:args m11620)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11623
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11621)]
     (clojure.core/case
      (clojure.core/count args11622)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11623
        listGeoLocations
        (route53/list-geo-locations-request
         (clojure.core/nth args11622 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11623
        listGeoLocations))))))
  (clojure.core/defn
   list-geo-locations-map
   {:arglists (quote
               [[credentials
                 {:keys [start-continent-code
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         start-country-code
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         start-subdivision-code
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listGeoLocations, listGeoLocations"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-geo-locations,
     :credentials credentials__1842__auto__,
     :client :route53})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-geo-locations,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   list-geo-locations
   {:arglists (quote
               [[credentials
                 {:keys [start-continent-code
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         start-country-code
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         start-subdivision-code
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listGeoLocations, listGeoLocations"}
   [credentials11625 & args11626]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11627
     (com.palletops.awaze.common/aws-client :route53 credentials11625)]
    (clojure.core/case
     (clojure.core/count args11626)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11627
       listGeoLocations
       (route53/list-geo-locations-request
        (clojure.core/nth args11626 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11627
       listGeoLocations))))))
 (do
  (clojure.core/defmethod
   route53
   :get-hosted-zone-count
   [m11628]
   (clojure.core/let
    [credentials11629 (:credentials m11628) args11630 (:args m11628)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11631
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11629)]
     (clojure.core/case
      (clojure.core/count args11630)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11631
        getHostedZoneCount))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11631
        getHostedZoneCount
        (route53/get-hosted-zone-count-request
         (clojure.core/nth args11630 0))))))))
  (clojure.core/defn
   get-hosted-zone-count-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getHostedZoneCount, getHostedZoneCount"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-hosted-zone-count,
     :credentials credentials__1842__auto__,
     :client :route53})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-hosted-zone-count,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   get-hosted-zone-count
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getHostedZoneCount, getHostedZoneCount"}
   [credentials11633 & args11634]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11635
     (com.palletops.awaze.common/aws-client :route53 credentials11633)]
    (clojure.core/case
     (clojure.core/count args11634)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11635
       getHostedZoneCount))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11635
       getHostedZoneCount
       (route53/get-hosted-zone-count-request
        (clojure.core/nth args11634 0))))))))
 (do
  (clojure.core/defmethod
   route53
   :update-hosted-zone-comment
   [m11636]
   (clojure.core/let
    [credentials11637 (:credentials m11636) args11638 (:args m11636)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11639
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11637)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11639
       updateHostedZoneComment
       (route53/update-hosted-zone-comment-request
        (clojure.core/nth args11638 0)))))))
  (clojure.core/defn
   update-hosted-zone-comment-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         comment
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateHostedZoneComment"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-hosted-zone-comment,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   update-hosted-zone-comment
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         comment
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateHostedZoneComment"}
   [credentials11641 & args11642]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11643
     (com.palletops.awaze.common/aws-client :route53 credentials11641)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11643
      updateHostedZoneComment
      (route53/update-hosted-zone-comment-request
       (clojure.core/nth args11642 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :get-health-check-count
   [m11644]
   (clojure.core/let
    [credentials11645 (:credentials m11644) args11646 (:args m11644)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11647
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11645)]
     (clojure.core/case
      (clojure.core/count args11646)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11647
        getHealthCheckCount))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11647
        getHealthCheckCount
        (route53/get-health-check-count-request
         (clojure.core/nth args11646 0))))))))
  (clojure.core/defn
   get-health-check-count-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getHealthCheckCount, getHealthCheckCount"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-health-check-count,
     :credentials credentials__1842__auto__,
     :client :route53})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-health-check-count,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   get-health-check-count
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getHealthCheckCount, getHealthCheckCount"}
   [credentials11649 & args11650]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11651
     (com.palletops.awaze.common/aws-client :route53 credentials11649)]
    (clojure.core/case
     (clojure.core/count args11650)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11651
       getHealthCheckCount))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11651
       getHealthCheckCount
       (route53/get-health-check-count-request
        (clojure.core/nth args11650 0))))))))
 (do
  (clojure.core/defmethod
   route53
   :get-hosted-zone
   [m11652]
   (clojure.core/let
    [credentials11653 (:credentials m11652) args11654 (:args m11652)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11655
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11653)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11655
       getHostedZone
       (route53/get-hosted-zone-request
        (clojure.core/nth args11654 0)))))))
  (clojure.core/defn
   get-hosted-zone-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getHostedZone"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-hosted-zone,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   get-hosted-zone
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getHostedZone"}
   [credentials11657 & args11658]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11659
     (com.palletops.awaze.common/aws-client :route53 credentials11657)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11659
      getHostedZone
      (route53/get-hosted-zone-request (clojure.core/nth args11658 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :update-traffic-policy-comment
   [m11660]
   (clojure.core/let
    [credentials11661 (:credentials m11660) args11662 (:args m11660)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11663
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11661)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11663
       updateTrafficPolicyComment
       (route53/update-traffic-policy-comment-request
        (clojure.core/nth args11662 0)))))))
  (clojure.core/defn
   update-traffic-policy-comment-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         comment
                         general-progress-listener
                         clone-source
                         version
                         clone-root]}]]),
    :doc "Generate map for updateTrafficPolicyComment"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-traffic-policy-comment,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   update-traffic-policy-comment
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         comment
                         general-progress-listener
                         clone-source
                         version
                         clone-root]}]]),
    :doc "Call updateTrafficPolicyComment"}
   [credentials11665 & args11666]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11667
     (com.palletops.awaze.common/aws-client :route53 credentials11665)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11667
      updateTrafficPolicyComment
      (route53/update-traffic-policy-comment-request
       (clojure.core/nth args11666 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :get-traffic-policy-instance
   [m11668]
   (clojure.core/let
    [credentials11669 (:credentials m11668) args11670 (:args m11668)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11671
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11669)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11671
       getTrafficPolicyInstance
       (route53/get-traffic-policy-instance-request
        (clojure.core/nth args11670 0)))))))
  (clojure.core/defn
   get-traffic-policy-instance-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getTrafficPolicyInstance"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-traffic-policy-instance,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   get-traffic-policy-instance
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getTrafficPolicyInstance"}
   [credentials11673 & args11674]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11675
     (com.palletops.awaze.common/aws-client :route53 credentials11673)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11675
      getTrafficPolicyInstance
      (route53/get-traffic-policy-instance-request
       (clojure.core/nth args11674 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-hosted-zones-by-name
   [m11676]
   (clojure.core/let
    [credentials11677 (:credentials m11676) args11678 (:args m11676)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11679
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11677)]
     (clojure.core/case
      (clojure.core/count args11678)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11679
        listHostedZonesByName))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11679
        listHostedZonesByName
        (route53/list-hosted-zones-by-name-request
         (clojure.core/nth args11678 0))))))))
  (clojure.core/defn
   list-hosted-zones-by-name-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         dnsname
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Generate map for listHostedZonesByName, listHostedZonesByName"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-hosted-zones-by-name,
     :credentials credentials__1842__auto__,
     :client :route53})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-hosted-zones-by-name,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   list-hosted-zones-by-name
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         dnsname
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Call listHostedZonesByName, listHostedZonesByName"}
   [credentials11681 & args11682]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11683
     (com.palletops.awaze.common/aws-client :route53 credentials11681)]
    (clojure.core/case
     (clojure.core/count args11682)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11683
       listHostedZonesByName))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11683
       listHostedZonesByName
       (route53/list-hosted-zones-by-name-request
        (clojure.core/nth args11682 0))))))))
 (do
  (clojure.core/defmethod
   route53
   :get-geo-location
   [m11684]
   (clojure.core/let
    [credentials11685 (:credentials m11684) args11686 (:args m11684)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11687
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11685)]
     (clojure.core/case
      (clojure.core/count args11686)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11687
        getGeoLocation
        (route53/get-geo-location-request
         (clojure.core/nth args11686 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11687
        getGeoLocation))))))
  (clojure.core/defn
   get-geo-location-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         country-code
                         custom-query-parameters
                         read-limit
                         subdivision-code
                         general-progress-listener
                         clone-source
                         continent-code
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for getGeoLocation, getGeoLocation"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-geo-location,
     :credentials credentials__1842__auto__,
     :client :route53})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-geo-location,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   get-geo-location
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         country-code
                         custom-query-parameters
                         read-limit
                         subdivision-code
                         general-progress-listener
                         clone-source
                         continent-code
                         clone-root]}]
                [credentials]]),
    :doc "Call getGeoLocation, getGeoLocation"}
   [credentials11689 & args11690]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11691
     (com.palletops.awaze.common/aws-client :route53 credentials11689)]
    (clojure.core/case
     (clojure.core/count args11690)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11691
       getGeoLocation
       (route53/get-geo-location-request
        (clojure.core/nth args11690 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11691
       getGeoLocation))))))
 (do
  (clojure.core/defmethod
   route53
   :list-tags-for-resource
   [m11692]
   (clojure.core/let
    [credentials11693 (:credentials m11692) args11694 (:args m11692)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11695
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11693)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11695
       listTagsForResource
       (route53/list-tags-for-resource-request
        (clojure.core/nth args11694 0)))))))
  (clojure.core/defn
   list-tags-for-resource-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         resource-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         resource-type
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listTagsForResource"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-tags-for-resource,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   list-tags-for-resource
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         resource-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         resource-type
                         clone-source
                         clone-root]}]]),
    :doc "Call listTagsForResource"}
   [credentials11697 & args11698]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11699
     (com.palletops.awaze.common/aws-client :route53 credentials11697)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11699
      listTagsForResource
      (route53/list-tags-for-resource-request
       (clojure.core/nth args11698 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :create-reusable-delegation-set
   [m11700]
   (clojure.core/let
    [credentials11701 (:credentials m11700) args11702 (:args m11700)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11703
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11701)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11703
       createReusableDelegationSet
       (route53/create-reusable-delegation-set-request
        (clojure.core/nth args11702 0)))))))
  (clojure.core/defn
   create-reusable-delegation-set-map
   {:arglists (quote
               [[credentials
                 {:keys [caller-reference
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Generate map for createReusableDelegationSet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-reusable-delegation-set,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   create-reusable-delegation-set
   {:arglists (quote
               [[credentials
                 {:keys [caller-reference
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Call createReusableDelegationSet"}
   [credentials11705 & args11706]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11707
     (com.palletops.awaze.common/aws-client :route53 credentials11705)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11707
      createReusableDelegationSet
      (route53/create-reusable-delegation-set-request
       (clojure.core/nth args11706 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-health-checks
   [m11708]
   (clojure.core/let
    [credentials11709 (:credentials m11708) args11710 (:args m11708)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11711
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11709)]
     (clojure.core/case
      (clojure.core/count args11710)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11711
        listHealthChecks
        (route53/list-health-checks-request
         (clojure.core/nth args11710 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11711
        listHealthChecks))))))
  (clojure.core/defn
   list-health-checks-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listHealthChecks, listHealthChecks"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-health-checks,
     :credentials credentials__1842__auto__,
     :client :route53})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-health-checks,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   list-health-checks
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listHealthChecks, listHealthChecks"}
   [credentials11713 & args11714]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11715
     (com.palletops.awaze.common/aws-client :route53 credentials11713)]
    (clojure.core/case
     (clojure.core/count args11714)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11715
       listHealthChecks
       (route53/list-health-checks-request
        (clojure.core/nth args11714 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11715
       listHealthChecks))))))
 (do
  (clojure.core/defmethod
   route53
   :update-traffic-policy-instance
   [m11716]
   (clojure.core/let
    [credentials11717 (:credentials m11716) args11718 (:args m11716)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11719
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11717)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11719
       updateTrafficPolicyInstance
       (route53/update-traffic-policy-instance-request
        (clojure.core/nth args11718 0)))))))
  (clojure.core/defn
   update-traffic-policy-instance-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         traffic-policy-version
                         traffic-policy-id
                         custom-query-parameters
                         ttl
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateTrafficPolicyInstance"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-traffic-policy-instance,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   update-traffic-policy-instance
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         traffic-policy-version
                         traffic-policy-id
                         custom-query-parameters
                         ttl
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateTrafficPolicyInstance"}
   [credentials11721 & args11722]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11723
     (com.palletops.awaze.common/aws-client :route53 credentials11721)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11723
      updateTrafficPolicyInstance
      (route53/update-traffic-policy-instance-request
       (clojure.core/nth args11722 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :delete-health-check
   [m11724]
   (clojure.core/let
    [credentials11725 (:credentials m11724) args11726 (:args m11724)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11727
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11725)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11727
       deleteHealthCheck
       (route53/delete-health-check-request
        (clojure.core/nth args11726 0)))))))
  (clojure.core/defn
   delete-health-check-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         health-check-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteHealthCheck"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-health-check,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   delete-health-check
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         health-check-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteHealthCheck"}
   [credentials11729 & args11730]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11731
     (com.palletops.awaze.common/aws-client :route53 credentials11729)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11731
      deleteHealthCheck
      (route53/delete-health-check-request
       (clojure.core/nth args11730 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :get-traffic-policy
   [m11732]
   (clojure.core/let
    [credentials11733 (:credentials m11732) args11734 (:args m11732)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11735
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11733)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11735
       getTrafficPolicy
       (route53/get-traffic-policy-request
        (clojure.core/nth args11734 0)))))))
  (clojure.core/defn
   get-traffic-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         version
                         clone-root]}]]),
    :doc "Generate map for getTrafficPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-traffic-policy,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   get-traffic-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         version
                         clone-root]}]]),
    :doc "Call getTrafficPolicy"}
   [credentials11737 & args11738]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11739
     (com.palletops.awaze.common/aws-client :route53 credentials11737)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11739
      getTrafficPolicy
      (route53/get-traffic-policy-request
       (clojure.core/nth args11738 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-change-batches-by-rrset
   [m11740]
   (clojure.core/let
    [credentials11741 (:credentials m11740) args11742 (:args m11740)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11743
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11741)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11743
       listChangeBatchesByRRSet
       (route53/list-change-batches-by-rrset-request
        (clojure.core/nth args11742 0)))))))
  (clojure.core/defn
   list-change-batches-by-rrset-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         end-date
                         sdk-request-timeout
                         name
                         marker
                         set-identifier
                         type
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         start-date
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Generate map for listChangeBatchesByRRSet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-change-batches-by-rrset,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   list-change-batches-by-rrset
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         end-date
                         sdk-request-timeout
                         name
                         marker
                         set-identifier
                         type
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         start-date
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Call listChangeBatchesByRRSet"}
   [credentials11745 & args11746]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11747
     (com.palletops.awaze.common/aws-client :route53 credentials11745)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11747
      listChangeBatchesByRRSet
      (route53/list-change-batches-by-rrset-request
       (clojure.core/nth args11746 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-resource-record-sets
   [m11748]
   (clojure.core/let
    [credentials11749 (:credentials m11748) args11750 (:args m11748)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11751
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11749)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11751
       listResourceRecordSets
       (route53/list-resource-record-sets-request
        (clojure.core/nth args11750 0)))))))
  (clojure.core/defn
   list-resource-record-sets-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         max-items
                         start-record-name
                         read-limit
                         general-progress-listener
                         clone-source
                         start-record-identifier
                         clone-root
                         start-record-type
                         hosted-zone-id]}]]),
    :doc "Generate map for listResourceRecordSets"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-resource-record-sets,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   list-resource-record-sets
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         max-items
                         start-record-name
                         read-limit
                         general-progress-listener
                         clone-source
                         start-record-identifier
                         clone-root
                         start-record-type
                         hosted-zone-id]}]]),
    :doc "Call listResourceRecordSets"}
   [credentials11753 & args11754]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11755
     (com.palletops.awaze.common/aws-client :route53 credentials11753)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11755
      listResourceRecordSets
      (route53/list-resource-record-sets-request
       (clojure.core/nth args11754 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :disassociate-vpcfrom-hosted-zone
   [m11756]
   (clojure.core/let
    [credentials11757 (:credentials m11756) args11758 (:args m11756)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11759
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11757)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11759
       disassociateVPCFromHostedZone
       (route53/disassociate-vpcfrom-hosted-zone-request
        (clojure.core/nth args11758 0)))))))
  (clojure.core/defn
   disassociate-vpcfrom-hosted-zone-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         vpc
                         comment
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Generate map for disassociateVPCFromHostedZone"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :disassociate-vpcfrom-hosted-zone,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   disassociate-vpcfrom-hosted-zone
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         vpc
                         comment
                         general-progress-listener
                         clone-source
                         clone-root
                         hosted-zone-id]}]]),
    :doc "Call disassociateVPCFromHostedZone"}
   [credentials11761 & args11762]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11763
     (com.palletops.awaze.common/aws-client :route53 credentials11761)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11763
      disassociateVPCFromHostedZone
      (route53/disassociate-vpcfrom-hosted-zone-request
       (clojure.core/nth args11762 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-traffic-policy-instances
   [m11764]
   (clojure.core/let
    [credentials11765 (:credentials m11764) args11766 (:args m11764)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11767
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11765)]
     (clojure.core/case
      (clojure.core/count args11766)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11767
        listTrafficPolicyInstances))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11767
        listTrafficPolicyInstances
        (route53/list-traffic-policy-instances-request
         (clojure.core/nth args11766 0))))))))
  (clojure.core/defn
   list-traffic-policy-instances-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         traffic-policy-instance-type-marker
                         hosted-zone-id-marker
                         traffic-policy-instance-name-marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listTrafficPolicyInstances, listTrafficPolicyInstances"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-traffic-policy-instances,
     :credentials credentials__1842__auto__,
     :client :route53})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-traffic-policy-instances,
     :credentials credentials__1842__auto__,
     :client :route53}))
  (clojure.core/defn
   list-traffic-policy-instances
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         traffic-policy-instance-type-marker
                         hosted-zone-id-marker
                         traffic-policy-instance-name-marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listTrafficPolicyInstances, listTrafficPolicyInstances"}
   [credentials11769 & args11770]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11771
     (com.palletops.awaze.common/aws-client :route53 credentials11769)]
    (clojure.core/case
     (clojure.core/count args11770)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11771
       listTrafficPolicyInstances))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11771
       listTrafficPolicyInstances
       (route53/list-traffic-policy-instances-request
        (clojure.core/nth args11770 0)))))))))
