(ns
 com.palletops.awaze.redshift
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.redshift :as redshift]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :redshift
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.redshift.AmazonRedshiftClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.ParameterApplyType}
parameter-apply-type
  [m8883]
  (.
   com.amazonaws.services.redshift.model.ParameterApplyType
   fromValue
   (clojure.core/name m8883)))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.Tag}
tag
  [m8886]
  (clojure.core/let
   [bean8885 (new com.amazonaws.services.redshift.model.Tag)]
   (clojure.core/let
    [v8887 (:key m8886 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8887 :com.palletops.awaze.client-builder/undef)
     (. bean8885 setKey (clojure.core/str v8887))))
   (clojure.core/let
    [v8887 (:value m8886 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8887 :com.palletops.awaze.client-builder/undef)
     (. bean8885 setValue (clojure.core/str v8887))))
   bean8885))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.SourceType}
source-type
  [m8889]
  (.
   com.amazonaws.services.redshift.model.SourceType
   fromValue
   (clojure.core/name m8889)))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.Parameter}
parameter
  [m8892]
  (clojure.core/let
   [bean8891 (new com.amazonaws.services.redshift.model.Parameter)]
   (clojure.core/let
    [v8893
     (:description m8892 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8893 :com.palletops.awaze.client-builder/undef)
     (. bean8891 setDescription (clojure.core/str v8893))))
   (clojure.core/let
    [v8893
     (:data-type m8892 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8893 :com.palletops.awaze.client-builder/undef)
     (. bean8891 setDataType (clojure.core/str v8893))))
   (clojure.core/let
    [v8893
     (:parameter-value
      m8892
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8893 :com.palletops.awaze.client-builder/undef)
     (. bean8891 setParameterValue (clojure.core/str v8893))))
   (clojure.core/let
    [v8893
     (:parameter-name m8892 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8893 :com.palletops.awaze.client-builder/undef)
     (. bean8891 setParameterName (clojure.core/str v8893))))
   (clojure.core/let
    [v8893
     (:is-modifiable m8892 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8893 :com.palletops.awaze.client-builder/undef)
     (. bean8891 setIsModifiable (clojure.core/boolean v8893))))
   (clojure.core/let
    [v8893
     (:minimum-engine-version
      m8892
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8893 :com.palletops.awaze.client-builder/undef)
     (. bean8891 setMinimumEngineVersion (clojure.core/str v8893))))
   (clojure.core/let
    [v8893
     (:apply-type m8892 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8893 :com.palletops.awaze.client-builder/undef)
     (. bean8891 setApplyType (redshift/parameter-apply-type v8893))))
   (clojure.core/let
    [v8893
     (:allowed-values m8892 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8893 :com.palletops.awaze.client-builder/undef)
     (. bean8891 setAllowedValues (clojure.core/str v8893))))
   (clojure.core/let
    [v8893 (:source m8892 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8893 :com.palletops.awaze.client-builder/undef)
     (. bean8891 setSource (clojure.core/str v8893))))
   bean8891))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeResizeRequest}
describe-resize-request
  [m8895]
  (clojure.core/let
   [bean8894
    (new com.amazonaws.services.redshift.model.DescribeResizeRequest)]
   (clojure.core/let
    [v8896
     (:cluster-identifier
      m8895
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8896 :com.palletops.awaze.client-builder/undef)
     (. bean8894 setClusterIdentifier (clojure.core/str v8896))))
   bean8894))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeClusterSnapshotsRequest}
describe-cluster-snapshots-request
  [m8898]
  (clojure.core/let
   [bean8897
    (new
     com.amazonaws.services.redshift.model.DescribeClusterSnapshotsRequest)]
   (clojure.core/let
    [v8899
     (:cluster-identifier
      m8898
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8899 :com.palletops.awaze.client-builder/undef)
     (. bean8897 setClusterIdentifier (clojure.core/str v8899))))
   (clojure.core/let
    [v8899
     (:snapshot-type m8898 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8899 :com.palletops.awaze.client-builder/undef)
     (. bean8897 setSnapshotType (clojure.core/str v8899))))
   (clojure.core/let
    [v8899 (:marker m8898 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8899 :com.palletops.awaze.client-builder/undef)
     (. bean8897 setMarker (clojure.core/str v8899))))
   (clojure.core/let
    [v8899
     (:tag-values m8898 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8899 :com.palletops.awaze.client-builder/undef)
     (.
      bean8897
      setTagValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9080] (clojure.core/str arg9080))
 v8899))))
   (clojure.core/let
    [v8899
     (:start-time m8898 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8899 :com.palletops.awaze.client-builder/undef)
     (.
      bean8897
      setStartTime
      (com.palletops.awaze.common/to-date v8899))))
   (clojure.core/let
    [v8899
     (:max-records m8898 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8899 :com.palletops.awaze.client-builder/undef)
     (. bean8897 setMaxRecords (clojure.core/int v8899))))
   (clojure.core/let
    [v8899
     (:end-time m8898 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8899 :com.palletops.awaze.client-builder/undef)
     (.
      bean8897
      setEndTime
      (com.palletops.awaze.common/to-date v8899))))
   (clojure.core/let
    [v8899
     (:snapshot-identifier
      m8898
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8899 :com.palletops.awaze.client-builder/undef)
     (. bean8897 setSnapshotIdentifier (clojure.core/str v8899))))
   (clojure.core/let
    [v8899
     (:owner-account m8898 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8899 :com.palletops.awaze.client-builder/undef)
     (. bean8897 setOwnerAccount (clojure.core/str v8899))))
   (clojure.core/let
    [v8899
     (:tag-keys m8898 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8899 :com.palletops.awaze.client-builder/undef)
     (.
      bean8897
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9081] (clojure.core/str arg9081))
 v8899))))
   bean8897))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeDefaultClusterParametersRequest}
describe-default-cluster-parameters-request
  [m8901]
  (clojure.core/let
   [bean8900
    (new
     com.amazonaws.services.redshift.model.DescribeDefaultClusterParametersRequest)]
   (clojure.core/let
    [v8902 (:marker m8901 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8902 :com.palletops.awaze.client-builder/undef)
     (. bean8900 setMarker (clojure.core/str v8902))))
   (clojure.core/let
    [v8902
     (:parameter-group-family
      m8901
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8902 :com.palletops.awaze.client-builder/undef)
     (. bean8900 setParameterGroupFamily (clojure.core/str v8902))))
   (clojure.core/let
    [v8902
     (:max-records m8901 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8902 :com.palletops.awaze.client-builder/undef)
     (. bean8900 setMaxRecords (clojure.core/int v8902))))
   bean8900))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateHsmClientCertificateRequest}
create-hsm-client-certificate-request
  [m8904]
  (clojure.core/let
   [bean8903
    (new
     com.amazonaws.services.redshift.model.CreateHsmClientCertificateRequest)]
   (clojure.core/let
    [v8905
     (:hsm-client-certificate-identifier
      m8904
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8905 :com.palletops.awaze.client-builder/undef)
     (.
      bean8903
      setHsmClientCertificateIdentifier
      (clojure.core/str v8905))))
   (clojure.core/let
    [v8905 (:tags m8904 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8905 :com.palletops.awaze.client-builder/undef)
     (.
      bean8903
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9082] (redshift/tag arg9082))
 v8905))))
   bean8903))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeClusterVersionsRequest}
describe-cluster-versions-request
  [m8907]
  (clojure.core/let
   [bean8906
    (new
     com.amazonaws.services.redshift.model.DescribeClusterVersionsRequest)]
   (clojure.core/let
    [v8908 (:marker m8907 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8908 :com.palletops.awaze.client-builder/undef)
     (. bean8906 setMarker (clojure.core/str v8908))))
   (clojure.core/let
    [v8908
     (:cluster-version
      m8907
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8908 :com.palletops.awaze.client-builder/undef)
     (. bean8906 setClusterVersion (clojure.core/str v8908))))
   (clojure.core/let
    [v8908
     (:cluster-parameter-group-family
      m8907
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8908 :com.palletops.awaze.client-builder/undef)
     (.
      bean8906
      setClusterParameterGroupFamily
      (clojure.core/str v8908))))
   (clojure.core/let
    [v8908
     (:max-records m8907 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8908 :com.palletops.awaze.client-builder/undef)
     (. bean8906 setMaxRecords (clojure.core/int v8908))))
   bean8906))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.EnableSnapshotCopyRequest}
enable-snapshot-copy-request
  [m8910]
  (clojure.core/let
   [bean8909
    (new
     com.amazonaws.services.redshift.model.EnableSnapshotCopyRequest)]
   (clojure.core/let
    [v8911
     (:destination-region
      m8910
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8911 :com.palletops.awaze.client-builder/undef)
     (. bean8909 setDestinationRegion (clojure.core/str v8911))))
   (clojure.core/let
    [v8911
     (:cluster-identifier
      m8910
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8911 :com.palletops.awaze.client-builder/undef)
     (. bean8909 setClusterIdentifier (clojure.core/str v8911))))
   (clojure.core/let
    [v8911
     (:retention-period
      m8910
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8911 :com.palletops.awaze.client-builder/undef)
     (. bean8909 setRetentionPeriod (clojure.core/int v8911))))
   (clojure.core/let
    [v8911
     (:snapshot-copy-grant-name
      m8910
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8911 :com.palletops.awaze.client-builder/undef)
     (. bean8909 setSnapshotCopyGrantName (clojure.core/str v8911))))
   bean8909))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateSnapshotCopyGrantRequest}
create-snapshot-copy-grant-request
  [m8913]
  (clojure.core/let
   [bean8912
    (new
     com.amazonaws.services.redshift.model.CreateSnapshotCopyGrantRequest)]
   (clojure.core/let
    [v8914
     (:kms-key-id m8913 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8914 :com.palletops.awaze.client-builder/undef)
     (. bean8912 setKmsKeyId (clojure.core/str v8914))))
   (clojure.core/let
    [v8914
     (:snapshot-copy-grant-name
      m8913
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8914 :com.palletops.awaze.client-builder/undef)
     (. bean8912 setSnapshotCopyGrantName (clojure.core/str v8914))))
   (clojure.core/let
    [v8914 (:tags m8913 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8914 :com.palletops.awaze.client-builder/undef)
     (.
      bean8912
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9083] (redshift/tag arg9083))
 v8914))))
   bean8912))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeClusterParameterGroupsRequest}
describe-cluster-parameter-groups-request
  [m8916]
  (clojure.core/let
   [bean8915
    (new
     com.amazonaws.services.redshift.model.DescribeClusterParameterGroupsRequest)]
   (clojure.core/let
    [v8917 (:marker m8916 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8917 :com.palletops.awaze.client-builder/undef)
     (. bean8915 setMarker (clojure.core/str v8917))))
   (clojure.core/let
    [v8917
     (:tag-keys m8916 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8917 :com.palletops.awaze.client-builder/undef)
     (.
      bean8915
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9084] (clojure.core/str arg9084))
 v8917))))
   (clojure.core/let
    [v8917
     (:tag-values m8916 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8917 :com.palletops.awaze.client-builder/undef)
     (.
      bean8915
      setTagValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9085] (clojure.core/str arg9085))
 v8917))))
   (clojure.core/let
    [v8917
     (:parameter-group-name
      m8916
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8917 :com.palletops.awaze.client-builder/undef)
     (. bean8915 setParameterGroupName (clojure.core/str v8917))))
   (clojure.core/let
    [v8917
     (:max-records m8916 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8917 :com.palletops.awaze.client-builder/undef)
     (. bean8915 setMaxRecords (clojure.core/int v8917))))
   bean8915))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteClusterParameterGroupRequest}
delete-cluster-parameter-group-request
  [m8919]
  (clojure.core/let
   [bean8918
    (new
     com.amazonaws.services.redshift.model.DeleteClusterParameterGroupRequest)]
   (clojure.core/let
    [v8920
     (:parameter-group-name
      m8919
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8920 :com.palletops.awaze.client-builder/undef)
     (. bean8918 setParameterGroupName (clojure.core/str v8920))))
   bean8918))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeEventsRequest}
describe-events-request
  [m8922]
  (clojure.core/let
   [bean8921
    (new com.amazonaws.services.redshift.model.DescribeEventsRequest)]
   (clojure.core/let
    [v8923
     (:start-time m8922 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8923 :com.palletops.awaze.client-builder/undef)
     (.
      bean8921
      setStartTime
      (com.palletops.awaze.common/to-date v8923))))
   (clojure.core/let
    [v8923
     (:end-time m8922 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8923 :com.palletops.awaze.client-builder/undef)
     (.
      bean8921
      setEndTime
      (com.palletops.awaze.common/to-date v8923))))
   (clojure.core/let
    [v8923 (:marker m8922 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8923 :com.palletops.awaze.client-builder/undef)
     (. bean8921 setMarker (clojure.core/str v8923))))
   (clojure.core/let
    [v8923
     (:source-identifier
      m8922
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8923 :com.palletops.awaze.client-builder/undef)
     (. bean8921 setSourceIdentifier (clojure.core/str v8923))))
   (clojure.core/let
    [v8923
     (:source-type m8922 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8923 :com.palletops.awaze.client-builder/undef)
     (. bean8921 setSourceType (redshift/source-type v8923))))
   (clojure.core/let
    [v8923
     (:duration m8922 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8923 :com.palletops.awaze.client-builder/undef)
     (. bean8921 setDuration (clojure.core/int v8923))))
   (clojure.core/let
    [v8923
     (:max-records m8922 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8923 :com.palletops.awaze.client-builder/undef)
     (. bean8921 setMaxRecords (clojure.core/int v8923))))
   bean8921))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeReservedNodesRequest}
describe-reserved-nodes-request
  [m8925]
  (clojure.core/let
   [bean8924
    (new
     com.amazonaws.services.redshift.model.DescribeReservedNodesRequest)]
   (clojure.core/let
    [v8926 (:marker m8925 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8926 :com.palletops.awaze.client-builder/undef)
     (. bean8924 setMarker (clojure.core/str v8926))))
   (clojure.core/let
    [v8926
     (:reserved-node-id
      m8925
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8926 :com.palletops.awaze.client-builder/undef)
     (. bean8924 setReservedNodeId (clojure.core/str v8926))))
   (clojure.core/let
    [v8926
     (:max-records m8925 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8926 :com.palletops.awaze.client-builder/undef)
     (. bean8924 setMaxRecords (clojure.core/int v8926))))
   bean8924))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.ModifyClusterIamRolesRequest}
modify-cluster-iam-roles-request
  [m8928]
  (clojure.core/let
   [bean8927
    (new
     com.amazonaws.services.redshift.model.ModifyClusterIamRolesRequest)]
   (clojure.core/let
    [v8929
     (:cluster-identifier
      m8928
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8929 :com.palletops.awaze.client-builder/undef)
     (. bean8927 setClusterIdentifier (clojure.core/str v8929))))
   (clojure.core/let
    [v8929
     (:add-iam-roles m8928 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8929 :com.palletops.awaze.client-builder/undef)
     (.
      bean8927
      setAddIamRoles
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9086] (clojure.core/str arg9086))
 v8929))))
   (clojure.core/let
    [v8929
     (:remove-iam-roles
      m8928
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8929 :com.palletops.awaze.client-builder/undef)
     (.
      bean8927
      setRemoveIamRoles
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9087] (clojure.core/str arg9087))
 v8929))))
   bean8927))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteEventSubscriptionRequest}
delete-event-subscription-request
  [m8931]
  (clojure.core/let
   [bean8930
    (new
     com.amazonaws.services.redshift.model.DeleteEventSubscriptionRequest)]
   (clojure.core/let
    [v8932
     (:subscription-name
      m8931
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8932 :com.palletops.awaze.client-builder/undef)
     (. bean8930 setSubscriptionName (clojure.core/str v8932))))
   bean8930))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.RebootClusterRequest}
reboot-cluster-request
  [m8934]
  (clojure.core/let
   [bean8933
    (new com.amazonaws.services.redshift.model.RebootClusterRequest)]
   (clojure.core/let
    [v8935
     (:cluster-identifier
      m8934
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8935 :com.palletops.awaze.client-builder/undef)
     (. bean8933 setClusterIdentifier (clojure.core/str v8935))))
   bean8933))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateClusterSecurityGroupRequest}
create-cluster-security-group-request
  [m8937]
  (clojure.core/let
   [bean8936
    (new
     com.amazonaws.services.redshift.model.CreateClusterSecurityGroupRequest)]
   (clojure.core/let
    [v8938
     (:description m8937 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8938 :com.palletops.awaze.client-builder/undef)
     (. bean8936 setDescription (clojure.core/str v8938))))
   (clojure.core/let
    [v8938
     (:cluster-security-group-name
      m8937
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8938 :com.palletops.awaze.client-builder/undef)
     (. bean8936 setClusterSecurityGroupName (clojure.core/str v8938))))
   (clojure.core/let
    [v8938 (:tags m8937 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8938 :com.palletops.awaze.client-builder/undef)
     (.
      bean8936
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9088] (redshift/tag arg9088))
 v8938))))
   bean8936))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.ModifyClusterParameterGroupRequest}
modify-cluster-parameter-group-request
  [m8940]
  (clojure.core/let
   [bean8939
    (new
     com.amazonaws.services.redshift.model.ModifyClusterParameterGroupRequest)]
   (clojure.core/let
    [v8941
     (:parameter-group-name
      m8940
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8941 :com.palletops.awaze.client-builder/undef)
     (. bean8939 setParameterGroupName (clojure.core/str v8941))))
   (clojure.core/let
    [v8941
     (:parameters m8940 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8941 :com.palletops.awaze.client-builder/undef)
     (.
      bean8939
      setParameters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9089] (redshift/parameter arg9089))
 v8941))))
   bean8939))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.ModifySnapshotCopyRetentionPeriodRequest}
modify-snapshot-copy-retention-period-request
  [m8943]
  (clojure.core/let
   [bean8942
    (new
     com.amazonaws.services.redshift.model.ModifySnapshotCopyRetentionPeriodRequest)]
   (clojure.core/let
    [v8944
     (:cluster-identifier
      m8943
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8944 :com.palletops.awaze.client-builder/undef)
     (. bean8942 setClusterIdentifier (clojure.core/str v8944))))
   (clojure.core/let
    [v8944
     (:retention-period
      m8943
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8944 :com.palletops.awaze.client-builder/undef)
     (. bean8942 setRetentionPeriod (clojure.core/int v8944))))
   bean8942))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteSnapshotCopyGrantRequest}
delete-snapshot-copy-grant-request
  [m8946]
  (clojure.core/let
   [bean8945
    (new
     com.amazonaws.services.redshift.model.DeleteSnapshotCopyGrantRequest)]
   (clojure.core/let
    [v8947
     (:snapshot-copy-grant-name
      m8946
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8947 :com.palletops.awaze.client-builder/undef)
     (. bean8945 setSnapshotCopyGrantName (clojure.core/str v8947))))
   bean8945))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.AuthorizeSnapshotAccessRequest}
authorize-snapshot-access-request
  [m8949]
  (clojure.core/let
   [bean8948
    (new
     com.amazonaws.services.redshift.model.AuthorizeSnapshotAccessRequest)]
   (clojure.core/let
    [v8950
     (:snapshot-identifier
      m8949
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8950 :com.palletops.awaze.client-builder/undef)
     (. bean8948 setSnapshotIdentifier (clojure.core/str v8950))))
   (clojure.core/let
    [v8950
     (:snapshot-cluster-identifier
      m8949
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8950 :com.palletops.awaze.client-builder/undef)
     (.
      bean8948
      setSnapshotClusterIdentifier
      (clojure.core/str v8950))))
   (clojure.core/let
    [v8950
     (:account-with-restore-access
      m8949
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8950 :com.palletops.awaze.client-builder/undef)
     (. bean8948 setAccountWithRestoreAccess (clojure.core/str v8950))))
   bean8948))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DisableLoggingRequest}
disable-logging-request
  [m8952]
  (clojure.core/let
   [bean8951
    (new com.amazonaws.services.redshift.model.DisableLoggingRequest)]
   (clojure.core/let
    [v8953
     (:cluster-identifier
      m8952
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8953 :com.palletops.awaze.client-builder/undef)
     (. bean8951 setClusterIdentifier (clojure.core/str v8953))))
   bean8951))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.ModifyClusterSubnetGroupRequest}
modify-cluster-subnet-group-request
  [m8955]
  (clojure.core/let
   [bean8954
    (new
     com.amazonaws.services.redshift.model.ModifyClusterSubnetGroupRequest)]
   (clojure.core/let
    [v8956
     (:subnet-ids m8955 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8956 :com.palletops.awaze.client-builder/undef)
     (.
      bean8954
      setSubnetIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9090] (clojure.core/str arg9090))
 v8956))))
   (clojure.core/let
    [v8956
     (:description m8955 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8956 :com.palletops.awaze.client-builder/undef)
     (. bean8954 setDescription (clojure.core/str v8956))))
   (clojure.core/let
    [v8956
     (:cluster-subnet-group-name
      m8955
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8956 :com.palletops.awaze.client-builder/undef)
     (. bean8954 setClusterSubnetGroupName (clojure.core/str v8956))))
   bean8954))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.ModifyClusterRequest}
modify-cluster-request
  [m8958]
  (clojure.core/let
   [bean8957
    (new com.amazonaws.services.redshift.model.ModifyClusterRequest)]
   (clojure.core/let
    [v8959
     (:cluster-version
      m8958
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8959 :com.palletops.awaze.client-builder/undef)
     (. bean8957 setClusterVersion (clojure.core/str v8959))))
   (clojure.core/let
    [v8959
     (:cluster-type m8958 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8959 :com.palletops.awaze.client-builder/undef)
     (. bean8957 setClusterType (clojure.core/str v8959))))
   (clojure.core/let
    [v8959
     (:cluster-identifier
      m8958
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8959 :com.palletops.awaze.client-builder/undef)
     (. bean8957 setClusterIdentifier (clojure.core/str v8959))))
   (clojure.core/let
    [v8959
     (:elastic-ip m8958 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8959 :com.palletops.awaze.client-builder/undef)
     (. bean8957 setElasticIp (clojure.core/str v8959))))
   (clojure.core/let
    [v8959
     (:allow-version-upgrade
      m8958
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8959 :com.palletops.awaze.client-builder/undef)
     (. bean8957 setAllowVersionUpgrade (clojure.core/boolean v8959))))
   (clojure.core/let
    [v8959
     (:hsm-client-certificate-identifier
      m8958
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8959 :com.palletops.awaze.client-builder/undef)
     (.
      bean8957
      setHsmClientCertificateIdentifier
      (clojure.core/str v8959))))
   (clojure.core/let
    [v8959
     (:new-cluster-identifier
      m8958
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8959 :com.palletops.awaze.client-builder/undef)
     (. bean8957 setNewClusterIdentifier (clojure.core/str v8959))))
   (clojure.core/let
    [v8959
     (:automated-snapshot-retention-period
      m8958
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8959 :com.palletops.awaze.client-builder/undef)
     (.
      bean8957
      setAutomatedSnapshotRetentionPeriod
      (clojure.core/int v8959))))
   (clojure.core/let
    [v8959
     (:master-user-password
      m8958
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8959 :com.palletops.awaze.client-builder/undef)
     (. bean8957 setMasterUserPassword (clojure.core/str v8959))))
   (clojure.core/let
    [v8959
     (:publicly-accessible
      m8958
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8959 :com.palletops.awaze.client-builder/undef)
     (. bean8957 setPubliclyAccessible (clojure.core/boolean v8959))))
   (clojure.core/let
    [v8959
     (:preferred-maintenance-window
      m8958
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8959 :com.palletops.awaze.client-builder/undef)
     (.
      bean8957
      setPreferredMaintenanceWindow
      (clojure.core/str v8959))))
   (clojure.core/let
    [v8959
     (:node-type m8958 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8959 :com.palletops.awaze.client-builder/undef)
     (. bean8957 setNodeType (clojure.core/str v8959))))
   (clojure.core/let
    [v8959
     (:hsm-configuration-identifier
      m8958
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8959 :com.palletops.awaze.client-builder/undef)
     (.
      bean8957
      setHsmConfigurationIdentifier
      (clojure.core/str v8959))))
   (clojure.core/let
    [v8959
     (:cluster-security-groups
      m8958
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8959 :com.palletops.awaze.client-builder/undef)
     (.
      bean8957
      setClusterSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9091] (clojure.core/str arg9091))
 v8959))))
   (clojure.core/let
    [v8959
     (:vpc-security-group-ids
      m8958
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8959 :com.palletops.awaze.client-builder/undef)
     (.
      bean8957
      setVpcSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9092] (clojure.core/str arg9092))
 v8959))))
   (clojure.core/let
    [v8959
     (:cluster-parameter-group-name
      m8958
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8959 :com.palletops.awaze.client-builder/undef)
     (.
      bean8957
      setClusterParameterGroupName
      (clojure.core/str v8959))))
   (clojure.core/let
    [v8959
     (:number-of-nodes
      m8958
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8959 :com.palletops.awaze.client-builder/undef)
     (. bean8957 setNumberOfNodes (clojure.core/int v8959))))
   bean8957))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.RestoreFromClusterSnapshotRequest}
restore-from-cluster-snapshot-request
  [m8961]
  (clojure.core/let
   [bean8960
    (new
     com.amazonaws.services.redshift.model.RestoreFromClusterSnapshotRequest)]
   (clojure.core/let
    [v8962
     (:cluster-subnet-group-name
      m8961
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8962 :com.palletops.awaze.client-builder/undef)
     (. bean8960 setClusterSubnetGroupName (clojure.core/str v8962))))
   (clojure.core/let
    [v8962
     (:cluster-identifier
      m8961
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8962 :com.palletops.awaze.client-builder/undef)
     (. bean8960 setClusterIdentifier (clojure.core/str v8962))))
   (clojure.core/let
    [v8962
     (:elastic-ip m8961 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8962 :com.palletops.awaze.client-builder/undef)
     (. bean8960 setElasticIp (clojure.core/str v8962))))
   (clojure.core/let
    [v8962
     (:allow-version-upgrade
      m8961
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8962 :com.palletops.awaze.client-builder/undef)
     (. bean8960 setAllowVersionUpgrade (clojure.core/boolean v8962))))
   (clojure.core/let
    [v8962
     (:additional-info
      m8961
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8962 :com.palletops.awaze.client-builder/undef)
     (. bean8960 setAdditionalInfo (clojure.core/str v8962))))
   (clojure.core/let
    [v8962
     (:hsm-client-certificate-identifier
      m8961
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8962 :com.palletops.awaze.client-builder/undef)
     (.
      bean8960
      setHsmClientCertificateIdentifier
      (clojure.core/str v8962))))
   (clojure.core/let
    [v8962
     (:availability-zone
      m8961
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8962 :com.palletops.awaze.client-builder/undef)
     (. bean8960 setAvailabilityZone (clojure.core/str v8962))))
   (clojure.core/let
    [v8962
     (:automated-snapshot-retention-period
      m8961
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8962 :com.palletops.awaze.client-builder/undef)
     (.
      bean8960
      setAutomatedSnapshotRetentionPeriod
      (clojure.core/int v8962))))
   (clojure.core/let
    [v8962
     (:publicly-accessible
      m8961
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8962 :com.palletops.awaze.client-builder/undef)
     (. bean8960 setPubliclyAccessible (clojure.core/boolean v8962))))
   (clojure.core/let
    [v8962
     (:preferred-maintenance-window
      m8961
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8962 :com.palletops.awaze.client-builder/undef)
     (.
      bean8960
      setPreferredMaintenanceWindow
      (clojure.core/str v8962))))
   (clojure.core/let
    [v8962
     (:snapshot-cluster-identifier
      m8961
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8962 :com.palletops.awaze.client-builder/undef)
     (.
      bean8960
      setSnapshotClusterIdentifier
      (clojure.core/str v8962))))
   (clojure.core/let
    [v8962
     (:iam-roles m8961 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8962 :com.palletops.awaze.client-builder/undef)
     (.
      bean8960
      setIamRoles
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9093] (clojure.core/str arg9093))
 v8962))))
   (clojure.core/let
    [v8962 (:port m8961 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8962 :com.palletops.awaze.client-builder/undef)
     (. bean8960 setPort (clojure.core/int v8962))))
   (clojure.core/let
    [v8962
     (:node-type m8961 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8962 :com.palletops.awaze.client-builder/undef)
     (. bean8960 setNodeType (clojure.core/str v8962))))
   (clojure.core/let
    [v8962
     (:hsm-configuration-identifier
      m8961
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8962 :com.palletops.awaze.client-builder/undef)
     (.
      bean8960
      setHsmConfigurationIdentifier
      (clojure.core/str v8962))))
   (clojure.core/let
    [v8962
     (:cluster-security-groups
      m8961
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8962 :com.palletops.awaze.client-builder/undef)
     (.
      bean8960
      setClusterSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9094] (clojure.core/str arg9094))
 v8962))))
   (clojure.core/let
    [v8962
     (:snapshot-identifier
      m8961
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8962 :com.palletops.awaze.client-builder/undef)
     (. bean8960 setSnapshotIdentifier (clojure.core/str v8962))))
   (clojure.core/let
    [v8962
     (:owner-account m8961 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8962 :com.palletops.awaze.client-builder/undef)
     (. bean8960 setOwnerAccount (clojure.core/str v8962))))
   (clojure.core/let
    [v8962
     (:vpc-security-group-ids
      m8961
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8962 :com.palletops.awaze.client-builder/undef)
     (.
      bean8960
      setVpcSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9095] (clojure.core/str arg9095))
 v8962))))
   (clojure.core/let
    [v8962
     (:cluster-parameter-group-name
      m8961
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8962 :com.palletops.awaze.client-builder/undef)
     (.
      bean8960
      setClusterParameterGroupName
      (clojure.core/str v8962))))
   (clojure.core/let
    [v8962
     (:kms-key-id m8961 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8962 :com.palletops.awaze.client-builder/undef)
     (. bean8960 setKmsKeyId (clojure.core/str v8962))))
   bean8960))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteHsmClientCertificateRequest}
delete-hsm-client-certificate-request
  [m8964]
  (clojure.core/let
   [bean8963
    (new
     com.amazonaws.services.redshift.model.DeleteHsmClientCertificateRequest)]
   (clojure.core/let
    [v8965
     (:hsm-client-certificate-identifier
      m8964
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8965 :com.palletops.awaze.client-builder/undef)
     (.
      bean8963
      setHsmClientCertificateIdentifier
      (clojure.core/str v8965))))
   bean8963))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateClusterRequest}
create-cluster-request
  [m8967]
  (clojure.core/let
   [bean8966
    (new com.amazonaws.services.redshift.model.CreateClusterRequest)]
   (clojure.core/let
    [v8968
     (:cluster-version
      m8967
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8968 :com.palletops.awaze.client-builder/undef)
     (. bean8966 setClusterVersion (clojure.core/str v8968))))
   (clojure.core/let
    [v8968
     (:cluster-type m8967 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8968 :com.palletops.awaze.client-builder/undef)
     (. bean8966 setClusterType (clojure.core/str v8968))))
   (clojure.core/let
    [v8968
     (:cluster-subnet-group-name
      m8967
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8968 :com.palletops.awaze.client-builder/undef)
     (. bean8966 setClusterSubnetGroupName (clojure.core/str v8968))))
   (clojure.core/let
    [v8968
     (:cluster-identifier
      m8967
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8968 :com.palletops.awaze.client-builder/undef)
     (. bean8966 setClusterIdentifier (clojure.core/str v8968))))
   (clojure.core/let
    [v8968
     (:elastic-ip m8967 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8968 :com.palletops.awaze.client-builder/undef)
     (. bean8966 setElasticIp (clojure.core/str v8968))))
   (clojure.core/let
    [v8968
     (:allow-version-upgrade
      m8967
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8968 :com.palletops.awaze.client-builder/undef)
     (. bean8966 setAllowVersionUpgrade (clojure.core/boolean v8968))))
   (clojure.core/let
    [v8968
     (:additional-info
      m8967
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8968 :com.palletops.awaze.client-builder/undef)
     (. bean8966 setAdditionalInfo (clojure.core/str v8968))))
   (clojure.core/let
    [v8968
     (:hsm-client-certificate-identifier
      m8967
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8968 :com.palletops.awaze.client-builder/undef)
     (.
      bean8966
      setHsmClientCertificateIdentifier
      (clojure.core/str v8968))))
   (clojure.core/let
    [v8968
     (:availability-zone
      m8967
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8968 :com.palletops.awaze.client-builder/undef)
     (. bean8966 setAvailabilityZone (clojure.core/str v8968))))
   (clojure.core/let
    [v8968
     (:automated-snapshot-retention-period
      m8967
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8968 :com.palletops.awaze.client-builder/undef)
     (.
      bean8966
      setAutomatedSnapshotRetentionPeriod
      (clojure.core/int v8968))))
   (clojure.core/let
    [v8968
     (:master-user-password
      m8967
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8968 :com.palletops.awaze.client-builder/undef)
     (. bean8966 setMasterUserPassword (clojure.core/str v8968))))
   (clojure.core/let
    [v8968
     (:publicly-accessible
      m8967
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8968 :com.palletops.awaze.client-builder/undef)
     (. bean8966 setPubliclyAccessible (clojure.core/boolean v8968))))
   (clojure.core/let
    [v8968
     (:preferred-maintenance-window
      m8967
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8968 :com.palletops.awaze.client-builder/undef)
     (.
      bean8966
      setPreferredMaintenanceWindow
      (clojure.core/str v8968))))
   (clojure.core/let
    [v8968
     (:iam-roles m8967 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8968 :com.palletops.awaze.client-builder/undef)
     (.
      bean8966
      setIamRoles
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9096] (clojure.core/str arg9096))
 v8968))))
   (clojure.core/let
    [v8968 (:port m8967 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8968 :com.palletops.awaze.client-builder/undef)
     (. bean8966 setPort (clojure.core/int v8968))))
   (clojure.core/let
    [v8968 (:tags m8967 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8968 :com.palletops.awaze.client-builder/undef)
     (.
      bean8966
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9097] (redshift/tag arg9097))
 v8968))))
   (clojure.core/let
    [v8968
     (:node-type m8967 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8968 :com.palletops.awaze.client-builder/undef)
     (. bean8966 setNodeType (clojure.core/str v8968))))
   (clojure.core/let
    [v8968
     (:hsm-configuration-identifier
      m8967
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8968 :com.palletops.awaze.client-builder/undef)
     (.
      bean8966
      setHsmConfigurationIdentifier
      (clojure.core/str v8968))))
   (clojure.core/let
    [v8968
     (:cluster-security-groups
      m8967
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8968 :com.palletops.awaze.client-builder/undef)
     (.
      bean8966
      setClusterSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9098] (clojure.core/str arg9098))
 v8968))))
   (clojure.core/let
    [v8968
     (:vpc-security-group-ids
      m8967
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8968 :com.palletops.awaze.client-builder/undef)
     (.
      bean8966
      setVpcSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9099] (clojure.core/str arg9099))
 v8968))))
   (clojure.core/let
    [v8968
     (:cluster-parameter-group-name
      m8967
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8968 :com.palletops.awaze.client-builder/undef)
     (.
      bean8966
      setClusterParameterGroupName
      (clojure.core/str v8968))))
   (clojure.core/let
    [v8968
     (:master-username
      m8967
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8968 :com.palletops.awaze.client-builder/undef)
     (. bean8966 setMasterUsername (clojure.core/str v8968))))
   (clojure.core/let
    [v8968 (:dbname m8967 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8968 :com.palletops.awaze.client-builder/undef)
     (. bean8966 setDBName (clojure.core/str v8968))))
   (clojure.core/let
    [v8968
     (:kms-key-id m8967 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8968 :com.palletops.awaze.client-builder/undef)
     (. bean8966 setKmsKeyId (clojure.core/str v8968))))
   (clojure.core/let
    [v8968
     (:encrypted m8967 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8968 :com.palletops.awaze.client-builder/undef)
     (. bean8966 setEncrypted (clojure.core/boolean v8968))))
   (clojure.core/let
    [v8968
     (:number-of-nodes
      m8967
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8968 :com.palletops.awaze.client-builder/undef)
     (. bean8966 setNumberOfNodes (clojure.core/int v8968))))
   bean8966))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeLoggingStatusRequest}
describe-logging-status-request
  [m8970]
  (clojure.core/let
   [bean8969
    (new
     com.amazonaws.services.redshift.model.DescribeLoggingStatusRequest)]
   (clojure.core/let
    [v8971
     (:cluster-identifier
      m8970
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8971 :com.palletops.awaze.client-builder/undef)
     (. bean8969 setClusterIdentifier (clojure.core/str v8971))))
   bean8969))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeTableRestoreStatusRequest}
describe-table-restore-status-request
  [m8973]
  (clojure.core/let
   [bean8972
    (new
     com.amazonaws.services.redshift.model.DescribeTableRestoreStatusRequest)]
   (clojure.core/let
    [v8974 (:marker m8973 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8974 :com.palletops.awaze.client-builder/undef)
     (. bean8972 setMarker (clojure.core/str v8974))))
   (clojure.core/let
    [v8974
     (:cluster-identifier
      m8973
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8974 :com.palletops.awaze.client-builder/undef)
     (. bean8972 setClusterIdentifier (clojure.core/str v8974))))
   (clojure.core/let
    [v8974
     (:table-restore-request-id
      m8973
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8974 :com.palletops.awaze.client-builder/undef)
     (. bean8972 setTableRestoreRequestId (clojure.core/str v8974))))
   (clojure.core/let
    [v8974
     (:max-records m8973 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8974 :com.palletops.awaze.client-builder/undef)
     (. bean8972 setMaxRecords (clojure.core/int v8974))))
   bean8972))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeEventCategoriesRequest}
describe-event-categories-request
  [m8976]
  (clojure.core/let
   [bean8975
    (new
     com.amazonaws.services.redshift.model.DescribeEventCategoriesRequest)]
   (clojure.core/let
    [v8977
     (:source-type m8976 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8977 :com.palletops.awaze.client-builder/undef)
     (. bean8975 setSourceType (clojure.core/str v8977))))
   bean8975))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeClusterParametersRequest}
describe-cluster-parameters-request
  [m8979]
  (clojure.core/let
   [bean8978
    (new
     com.amazonaws.services.redshift.model.DescribeClusterParametersRequest)]
   (clojure.core/let
    [v8980 (:marker m8979 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8980 :com.palletops.awaze.client-builder/undef)
     (. bean8978 setMarker (clojure.core/str v8980))))
   (clojure.core/let
    [v8980 (:source m8979 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8980 :com.palletops.awaze.client-builder/undef)
     (. bean8978 setSource (clojure.core/str v8980))))
   (clojure.core/let
    [v8980
     (:parameter-group-name
      m8979
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8980 :com.palletops.awaze.client-builder/undef)
     (. bean8978 setParameterGroupName (clojure.core/str v8980))))
   (clojure.core/let
    [v8980
     (:max-records m8979 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8980 :com.palletops.awaze.client-builder/undef)
     (. bean8978 setMaxRecords (clojure.core/int v8980))))
   bean8978))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.AuthorizeClusterSecurityGroupIngressRequest}
authorize-cluster-security-group-ingress-request
  [m8982]
  (clojure.core/let
   [bean8981
    (new
     com.amazonaws.services.redshift.model.AuthorizeClusterSecurityGroupIngressRequest)]
   (clojure.core/let
    [v8983
     (:cluster-security-group-name
      m8982
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8983 :com.palletops.awaze.client-builder/undef)
     (. bean8981 setClusterSecurityGroupName (clojure.core/str v8983))))
   (clojure.core/let
    [v8983 (:cidrip m8982 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8983 :com.palletops.awaze.client-builder/undef)
     (. bean8981 setCIDRIP (clojure.core/str v8983))))
   (clojure.core/let
    [v8983
     (:ec2security-group-name
      m8982
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8983 :com.palletops.awaze.client-builder/undef)
     (. bean8981 setEC2SecurityGroupName (clojure.core/str v8983))))
   (clojure.core/let
    [v8983
     (:ec2security-group-owner-id
      m8982
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8983 :com.palletops.awaze.client-builder/undef)
     (. bean8981 setEC2SecurityGroupOwnerId (clojure.core/str v8983))))
   bean8981))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeClustersRequest}
describe-clusters-request
  [m8985]
  (clojure.core/let
   [bean8984
    (new
     com.amazonaws.services.redshift.model.DescribeClustersRequest)]
   (clojure.core/let
    [v8986 (:marker m8985 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8986 :com.palletops.awaze.client-builder/undef)
     (. bean8984 setMarker (clojure.core/str v8986))))
   (clojure.core/let
    [v8986
     (:tag-keys m8985 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8986 :com.palletops.awaze.client-builder/undef)
     (.
      bean8984
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9100] (clojure.core/str arg9100))
 v8986))))
   (clojure.core/let
    [v8986
     (:cluster-identifier
      m8985
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8986 :com.palletops.awaze.client-builder/undef)
     (. bean8984 setClusterIdentifier (clojure.core/str v8986))))
   (clojure.core/let
    [v8986
     (:tag-values m8985 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8986 :com.palletops.awaze.client-builder/undef)
     (.
      bean8984
      setTagValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9101] (clojure.core/str arg9101))
 v8986))))
   (clojure.core/let
    [v8986
     (:max-records m8985 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8986 :com.palletops.awaze.client-builder/undef)
     (. bean8984 setMaxRecords (clojure.core/int v8986))))
   bean8984))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteClusterSubnetGroupRequest}
delete-cluster-subnet-group-request
  [m8988]
  (clojure.core/let
   [bean8987
    (new
     com.amazonaws.services.redshift.model.DeleteClusterSubnetGroupRequest)]
   (clojure.core/let
    [v8989
     (:cluster-subnet-group-name
      m8988
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8989 :com.palletops.awaze.client-builder/undef)
     (. bean8987 setClusterSubnetGroupName (clojure.core/str v8989))))
   bean8987))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeClusterSecurityGroupsRequest}
describe-cluster-security-groups-request
  [m8991]
  (clojure.core/let
   [bean8990
    (new
     com.amazonaws.services.redshift.model.DescribeClusterSecurityGroupsRequest)]
   (clojure.core/let
    [v8992 (:marker m8991 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8992 :com.palletops.awaze.client-builder/undef)
     (. bean8990 setMarker (clojure.core/str v8992))))
   (clojure.core/let
    [v8992
     (:tag-keys m8991 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8992 :com.palletops.awaze.client-builder/undef)
     (.
      bean8990
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9102] (clojure.core/str arg9102))
 v8992))))
   (clojure.core/let
    [v8992
     (:tag-values m8991 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8992 :com.palletops.awaze.client-builder/undef)
     (.
      bean8990
      setTagValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9103] (clojure.core/str arg9103))
 v8992))))
   (clojure.core/let
    [v8992
     (:cluster-security-group-name
      m8991
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8992 :com.palletops.awaze.client-builder/undef)
     (. bean8990 setClusterSecurityGroupName (clojure.core/str v8992))))
   (clojure.core/let
    [v8992
     (:max-records m8991 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8992 :com.palletops.awaze.client-builder/undef)
     (. bean8990 setMaxRecords (clojure.core/int v8992))))
   bean8990))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeTagsRequest}
describe-tags-request
  [m8994]
  (clojure.core/let
   [bean8993
    (new com.amazonaws.services.redshift.model.DescribeTagsRequest)]
   (clojure.core/let
    [v8995 (:marker m8994 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8995 :com.palletops.awaze.client-builder/undef)
     (. bean8993 setMarker (clojure.core/str v8995))))
   (clojure.core/let
    [v8995
     (:tag-keys m8994 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8995 :com.palletops.awaze.client-builder/undef)
     (.
      bean8993
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9104] (clojure.core/str arg9104))
 v8995))))
   (clojure.core/let
    [v8995
     (:resource-name m8994 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8995 :com.palletops.awaze.client-builder/undef)
     (. bean8993 setResourceName (clojure.core/str v8995))))
   (clojure.core/let
    [v8995
     (:tag-values m8994 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8995 :com.palletops.awaze.client-builder/undef)
     (.
      bean8993
      setTagValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9105] (clojure.core/str arg9105))
 v8995))))
   (clojure.core/let
    [v8995
     (:max-records m8994 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8995 :com.palletops.awaze.client-builder/undef)
     (. bean8993 setMaxRecords (clojure.core/int v8995))))
   (clojure.core/let
    [v8995
     (:resource-type m8994 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8995 :com.palletops.awaze.client-builder/undef)
     (. bean8993 setResourceType (clojure.core/str v8995))))
   bean8993))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DisableSnapshotCopyRequest}
disable-snapshot-copy-request
  [m8997]
  (clojure.core/let
   [bean8996
    (new
     com.amazonaws.services.redshift.model.DisableSnapshotCopyRequest)]
   (clojure.core/let
    [v8998
     (:cluster-identifier
      m8997
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8998 :com.palletops.awaze.client-builder/undef)
     (. bean8996 setClusterIdentifier (clojure.core/str v8998))))
   bean8996))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteTagsRequest}
delete-tags-request
  [m9000]
  (clojure.core/let
   [bean8999
    (new com.amazonaws.services.redshift.model.DeleteTagsRequest)]
   (clojure.core/let
    [v9001
     (:tag-keys m9000 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9001 :com.palletops.awaze.client-builder/undef)
     (.
      bean8999
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9106] (clojure.core/str arg9106))
 v9001))))
   (clojure.core/let
    [v9001
     (:resource-name m9000 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9001 :com.palletops.awaze.client-builder/undef)
     (. bean8999 setResourceName (clojure.core/str v9001))))
   bean8999))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.PurchaseReservedNodeOfferingRequest}
purchase-reserved-node-offering-request
  [m9003]
  (clojure.core/let
   [bean9002
    (new
     com.amazonaws.services.redshift.model.PurchaseReservedNodeOfferingRequest)]
   (clojure.core/let
    [v9004
     (:reserved-node-offering-id
      m9003
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9004 :com.palletops.awaze.client-builder/undef)
     (. bean9002 setReservedNodeOfferingId (clojure.core/str v9004))))
   (clojure.core/let
    [v9004
     (:node-count m9003 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9004 :com.palletops.awaze.client-builder/undef)
     (. bean9002 setNodeCount (clojure.core/int v9004))))
   bean9002))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteClusterSnapshotRequest}
delete-cluster-snapshot-request
  [m9006]
  (clojure.core/let
   [bean9005
    (new
     com.amazonaws.services.redshift.model.DeleteClusterSnapshotRequest)]
   (clojure.core/let
    [v9007
     (:snapshot-identifier
      m9006
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9007 :com.palletops.awaze.client-builder/undef)
     (. bean9005 setSnapshotIdentifier (clojure.core/str v9007))))
   (clojure.core/let
    [v9007
     (:snapshot-cluster-identifier
      m9006
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9007 :com.palletops.awaze.client-builder/undef)
     (.
      bean9005
      setSnapshotClusterIdentifier
      (clojure.core/str v9007))))
   bean9005))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateClusterParameterGroupRequest}
create-cluster-parameter-group-request
  [m9009]
  (clojure.core/let
   [bean9008
    (new
     com.amazonaws.services.redshift.model.CreateClusterParameterGroupRequest)]
   (clojure.core/let
    [v9010
     (:description m9009 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9010 :com.palletops.awaze.client-builder/undef)
     (. bean9008 setDescription (clojure.core/str v9010))))
   (clojure.core/let
    [v9010
     (:parameter-group-family
      m9009
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9010 :com.palletops.awaze.client-builder/undef)
     (. bean9008 setParameterGroupFamily (clojure.core/str v9010))))
   (clojure.core/let
    [v9010
     (:parameter-group-name
      m9009
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9010 :com.palletops.awaze.client-builder/undef)
     (. bean9008 setParameterGroupName (clojure.core/str v9010))))
   (clojure.core/let
    [v9010 (:tags m9009 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9010 :com.palletops.awaze.client-builder/undef)
     (.
      bean9008
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9107] (redshift/tag arg9107))
 v9010))))
   bean9008))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.RotateEncryptionKeyRequest}
rotate-encryption-key-request
  [m9012]
  (clojure.core/let
   [bean9011
    (new
     com.amazonaws.services.redshift.model.RotateEncryptionKeyRequest)]
   (clojure.core/let
    [v9013
     (:cluster-identifier
      m9012
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9013 :com.palletops.awaze.client-builder/undef)
     (. bean9011 setClusterIdentifier (clojure.core/str v9013))))
   bean9011))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeHsmClientCertificatesRequest}
describe-hsm-client-certificates-request
  [m9015]
  (clojure.core/let
   [bean9014
    (new
     com.amazonaws.services.redshift.model.DescribeHsmClientCertificatesRequest)]
   (clojure.core/let
    [v9016 (:marker m9015 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9016 :com.palletops.awaze.client-builder/undef)
     (. bean9014 setMarker (clojure.core/str v9016))))
   (clojure.core/let
    [v9016
     (:tag-keys m9015 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9016 :com.palletops.awaze.client-builder/undef)
     (.
      bean9014
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9108] (clojure.core/str arg9108))
 v9016))))
   (clojure.core/let
    [v9016
     (:tag-values m9015 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9016 :com.palletops.awaze.client-builder/undef)
     (.
      bean9014
      setTagValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9109] (clojure.core/str arg9109))
 v9016))))
   (clojure.core/let
    [v9016
     (:hsm-client-certificate-identifier
      m9015
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9016 :com.palletops.awaze.client-builder/undef)
     (.
      bean9014
      setHsmClientCertificateIdentifier
      (clojure.core/str v9016))))
   (clojure.core/let
    [v9016
     (:max-records m9015 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9016 :com.palletops.awaze.client-builder/undef)
     (. bean9014 setMaxRecords (clojure.core/int v9016))))
   bean9014))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeSnapshotCopyGrantsRequest}
describe-snapshot-copy-grants-request
  [m9018]
  (clojure.core/let
   [bean9017
    (new
     com.amazonaws.services.redshift.model.DescribeSnapshotCopyGrantsRequest)]
   (clojure.core/let
    [v9019 (:marker m9018 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9019 :com.palletops.awaze.client-builder/undef)
     (. bean9017 setMarker (clojure.core/str v9019))))
   (clojure.core/let
    [v9019
     (:tag-keys m9018 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9019 :com.palletops.awaze.client-builder/undef)
     (.
      bean9017
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9110] (clojure.core/str arg9110))
 v9019))))
   (clojure.core/let
    [v9019
     (:tag-values m9018 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9019 :com.palletops.awaze.client-builder/undef)
     (.
      bean9017
      setTagValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9111] (clojure.core/str arg9111))
 v9019))))
   (clojure.core/let
    [v9019
     (:snapshot-copy-grant-name
      m9018
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9019 :com.palletops.awaze.client-builder/undef)
     (. bean9017 setSnapshotCopyGrantName (clojure.core/str v9019))))
   (clojure.core/let
    [v9019
     (:max-records m9018 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9019 :com.palletops.awaze.client-builder/undef)
     (. bean9017 setMaxRecords (clojure.core/int v9019))))
   bean9017))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.ResetClusterParameterGroupRequest}
reset-cluster-parameter-group-request
  [m9021]
  (clojure.core/let
   [bean9020
    (new
     com.amazonaws.services.redshift.model.ResetClusterParameterGroupRequest)]
   (clojure.core/let
    [v9022
     (:parameter-group-name
      m9021
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9022 :com.palletops.awaze.client-builder/undef)
     (. bean9020 setParameterGroupName (clojure.core/str v9022))))
   (clojure.core/let
    [v9022
     (:reset-all-parameters
      m9021
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9022 :com.palletops.awaze.client-builder/undef)
     (. bean9020 setResetAllParameters (clojure.core/boolean v9022))))
   (clojure.core/let
    [v9022
     (:parameters m9021 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9022 :com.palletops.awaze.client-builder/undef)
     (.
      bean9020
      setParameters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9112] (redshift/parameter arg9112))
 v9022))))
   bean9020))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteClusterSecurityGroupRequest}
delete-cluster-security-group-request
  [m9024]
  (clojure.core/let
   [bean9023
    (new
     com.amazonaws.services.redshift.model.DeleteClusterSecurityGroupRequest)]
   (clojure.core/let
    [v9025
     (:cluster-security-group-name
      m9024
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9025 :com.palletops.awaze.client-builder/undef)
     (. bean9023 setClusterSecurityGroupName (clojure.core/str v9025))))
   bean9023))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CopyClusterSnapshotRequest}
copy-cluster-snapshot-request
  [m9027]
  (clojure.core/let
   [bean9026
    (new
     com.amazonaws.services.redshift.model.CopyClusterSnapshotRequest)]
   (clojure.core/let
    [v9028
     (:source-snapshot-identifier
      m9027
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9028 :com.palletops.awaze.client-builder/undef)
     (. bean9026 setSourceSnapshotIdentifier (clojure.core/str v9028))))
   (clojure.core/let
    [v9028
     (:source-snapshot-cluster-identifier
      m9027
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9028 :com.palletops.awaze.client-builder/undef)
     (.
      bean9026
      setSourceSnapshotClusterIdentifier
      (clojure.core/str v9028))))
   (clojure.core/let
    [v9028
     (:target-snapshot-identifier
      m9027
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9028 :com.palletops.awaze.client-builder/undef)
     (. bean9026 setTargetSnapshotIdentifier (clojure.core/str v9028))))
   bean9026))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.RestoreTableFromClusterSnapshotRequest}
restore-table-from-cluster-snapshot-request
  [m9030]
  (clojure.core/let
   [bean9029
    (new
     com.amazonaws.services.redshift.model.RestoreTableFromClusterSnapshotRequest)]
   (clojure.core/let
    [v9031
     (:snapshot-identifier
      m9030
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9031 :com.palletops.awaze.client-builder/undef)
     (. bean9029 setSnapshotIdentifier (clojure.core/str v9031))))
   (clojure.core/let
    [v9031
     (:cluster-identifier
      m9030
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9031 :com.palletops.awaze.client-builder/undef)
     (. bean9029 setClusterIdentifier (clojure.core/str v9031))))
   (clojure.core/let
    [v9031
     (:source-database-name
      m9030
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9031 :com.palletops.awaze.client-builder/undef)
     (. bean9029 setSourceDatabaseName (clojure.core/str v9031))))
   (clojure.core/let
    [v9031
     (:source-schema-name
      m9030
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9031 :com.palletops.awaze.client-builder/undef)
     (. bean9029 setSourceSchemaName (clojure.core/str v9031))))
   (clojure.core/let
    [v9031
     (:source-table-name
      m9030
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9031 :com.palletops.awaze.client-builder/undef)
     (. bean9029 setSourceTableName (clojure.core/str v9031))))
   (clojure.core/let
    [v9031
     (:target-database-name
      m9030
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9031 :com.palletops.awaze.client-builder/undef)
     (. bean9029 setTargetDatabaseName (clojure.core/str v9031))))
   (clojure.core/let
    [v9031
     (:target-schema-name
      m9030
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9031 :com.palletops.awaze.client-builder/undef)
     (. bean9029 setTargetSchemaName (clojure.core/str v9031))))
   (clojure.core/let
    [v9031
     (:new-table-name m9030 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9031 :com.palletops.awaze.client-builder/undef)
     (. bean9029 setNewTableName (clojure.core/str v9031))))
   bean9029))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.ModifyEventSubscriptionRequest}
modify-event-subscription-request
  [m9033]
  (clojure.core/let
   [bean9032
    (new
     com.amazonaws.services.redshift.model.ModifyEventSubscriptionRequest)]
   (clojure.core/let
    [v9034 (:enabled m9033 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9034 :com.palletops.awaze.client-builder/undef)
     (. bean9032 setEnabled (clojure.core/boolean v9034))))
   (clojure.core/let
    [v9034
     (:source-type m9033 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9034 :com.palletops.awaze.client-builder/undef)
     (. bean9032 setSourceType (clojure.core/str v9034))))
   (clojure.core/let
    [v9034
     (:subscription-name
      m9033
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9034 :com.palletops.awaze.client-builder/undef)
     (. bean9032 setSubscriptionName (clojure.core/str v9034))))
   (clojure.core/let
    [v9034
     (:sns-topic-arn m9033 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9034 :com.palletops.awaze.client-builder/undef)
     (. bean9032 setSnsTopicArn (clojure.core/str v9034))))
   (clojure.core/let
    [v9034
     (:source-ids m9033 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9034 :com.palletops.awaze.client-builder/undef)
     (.
      bean9032
      setSourceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9113] (clojure.core/str arg9113))
 v9034))))
   (clojure.core/let
    [v9034
     (:event-categories
      m9033
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9034 :com.palletops.awaze.client-builder/undef)
     (.
      bean9032
      setEventCategories
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9114] (clojure.core/str arg9114))
 v9034))))
   (clojure.core/let
    [v9034
     (:severity m9033 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9034 :com.palletops.awaze.client-builder/undef)
     (. bean9032 setSeverity (clojure.core/str v9034))))
   bean9032))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateHsmConfigurationRequest}
create-hsm-configuration-request
  [m9036]
  (clojure.core/let
   [bean9035
    (new
     com.amazonaws.services.redshift.model.CreateHsmConfigurationRequest)]
   (clojure.core/let
    [v9037
     (:description m9036 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9037 :com.palletops.awaze.client-builder/undef)
     (. bean9035 setDescription (clojure.core/str v9037))))
   (clojure.core/let
    [v9037
     (:hsm-configuration-identifier
      m9036
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9037 :com.palletops.awaze.client-builder/undef)
     (.
      bean9035
      setHsmConfigurationIdentifier
      (clojure.core/str v9037))))
   (clojure.core/let
    [v9037
     (:hsm-ip-address m9036 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9037 :com.palletops.awaze.client-builder/undef)
     (. bean9035 setHsmIpAddress (clojure.core/str v9037))))
   (clojure.core/let
    [v9037
     (:hsm-partition-name
      m9036
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9037 :com.palletops.awaze.client-builder/undef)
     (. bean9035 setHsmPartitionName (clojure.core/str v9037))))
   (clojure.core/let
    [v9037
     (:hsm-partition-password
      m9036
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9037 :com.palletops.awaze.client-builder/undef)
     (. bean9035 setHsmPartitionPassword (clojure.core/str v9037))))
   (clojure.core/let
    [v9037
     (:hsm-server-public-certificate
      m9036
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9037 :com.palletops.awaze.client-builder/undef)
     (.
      bean9035
      setHsmServerPublicCertificate
      (clojure.core/str v9037))))
   (clojure.core/let
    [v9037 (:tags m9036 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9037 :com.palletops.awaze.client-builder/undef)
     (.
      bean9035
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9115] (redshift/tag arg9115))
 v9037))))
   bean9035))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeHsmConfigurationsRequest}
describe-hsm-configurations-request
  [m9039]
  (clojure.core/let
   [bean9038
    (new
     com.amazonaws.services.redshift.model.DescribeHsmConfigurationsRequest)]
   (clojure.core/let
    [v9040 (:marker m9039 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9040 :com.palletops.awaze.client-builder/undef)
     (. bean9038 setMarker (clojure.core/str v9040))))
   (clojure.core/let
    [v9040
     (:tag-keys m9039 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9040 :com.palletops.awaze.client-builder/undef)
     (.
      bean9038
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9116] (clojure.core/str arg9116))
 v9040))))
   (clojure.core/let
    [v9040
     (:tag-values m9039 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9040 :com.palletops.awaze.client-builder/undef)
     (.
      bean9038
      setTagValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9117] (clojure.core/str arg9117))
 v9040))))
   (clojure.core/let
    [v9040
     (:hsm-configuration-identifier
      m9039
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9040 :com.palletops.awaze.client-builder/undef)
     (.
      bean9038
      setHsmConfigurationIdentifier
      (clojure.core/str v9040))))
   (clojure.core/let
    [v9040
     (:max-records m9039 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9040 :com.palletops.awaze.client-builder/undef)
     (. bean9038 setMaxRecords (clojure.core/int v9040))))
   bean9038))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeClusterSubnetGroupsRequest}
describe-cluster-subnet-groups-request
  [m9042]
  (clojure.core/let
   [bean9041
    (new
     com.amazonaws.services.redshift.model.DescribeClusterSubnetGroupsRequest)]
   (clojure.core/let
    [v9043 (:marker m9042 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9043 :com.palletops.awaze.client-builder/undef)
     (. bean9041 setMarker (clojure.core/str v9043))))
   (clojure.core/let
    [v9043
     (:tag-keys m9042 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9043 :com.palletops.awaze.client-builder/undef)
     (.
      bean9041
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9118] (clojure.core/str arg9118))
 v9043))))
   (clojure.core/let
    [v9043
     (:tag-values m9042 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9043 :com.palletops.awaze.client-builder/undef)
     (.
      bean9041
      setTagValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9119] (clojure.core/str arg9119))
 v9043))))
   (clojure.core/let
    [v9043
     (:cluster-subnet-group-name
      m9042
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9043 :com.palletops.awaze.client-builder/undef)
     (. bean9041 setClusterSubnetGroupName (clojure.core/str v9043))))
   (clojure.core/let
    [v9043
     (:max-records m9042 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9043 :com.palletops.awaze.client-builder/undef)
     (. bean9041 setMaxRecords (clojure.core/int v9043))))
   bean9041))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteClusterRequest}
delete-cluster-request
  [m9045]
  (clojure.core/let
   [bean9044
    (new com.amazonaws.services.redshift.model.DeleteClusterRequest)]
   (clojure.core/let
    [v9046
     (:cluster-identifier
      m9045
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9046 :com.palletops.awaze.client-builder/undef)
     (. bean9044 setClusterIdentifier (clojure.core/str v9046))))
   (clojure.core/let
    [v9046
     (:final-cluster-snapshot-identifier
      m9045
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9046 :com.palletops.awaze.client-builder/undef)
     (.
      bean9044
      setFinalClusterSnapshotIdentifier
      (clojure.core/str v9046))))
   (clojure.core/let
    [v9046
     (:skip-final-cluster-snapshot
      m9045
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9046 :com.palletops.awaze.client-builder/undef)
     (.
      bean9044
      setSkipFinalClusterSnapshot
      (clojure.core/boolean v9046))))
   bean9044))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.RevokeClusterSecurityGroupIngressRequest}
revoke-cluster-security-group-ingress-request
  [m9048]
  (clojure.core/let
   [bean9047
    (new
     com.amazonaws.services.redshift.model.RevokeClusterSecurityGroupIngressRequest)]
   (clojure.core/let
    [v9049
     (:cluster-security-group-name
      m9048
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9049 :com.palletops.awaze.client-builder/undef)
     (. bean9047 setClusterSecurityGroupName (clojure.core/str v9049))))
   (clojure.core/let
    [v9049 (:cidrip m9048 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9049 :com.palletops.awaze.client-builder/undef)
     (. bean9047 setCIDRIP (clojure.core/str v9049))))
   (clojure.core/let
    [v9049
     (:ec2security-group-name
      m9048
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9049 :com.palletops.awaze.client-builder/undef)
     (. bean9047 setEC2SecurityGroupName (clojure.core/str v9049))))
   (clojure.core/let
    [v9049
     (:ec2security-group-owner-id
      m9048
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9049 :com.palletops.awaze.client-builder/undef)
     (. bean9047 setEC2SecurityGroupOwnerId (clojure.core/str v9049))))
   bean9047))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateClusterSubnetGroupRequest}
create-cluster-subnet-group-request
  [m9051]
  (clojure.core/let
   [bean9050
    (new
     com.amazonaws.services.redshift.model.CreateClusterSubnetGroupRequest)]
   (clojure.core/let
    [v9052
     (:subnet-ids m9051 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9052 :com.palletops.awaze.client-builder/undef)
     (.
      bean9050
      setSubnetIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9120] (clojure.core/str arg9120))
 v9052))))
   (clojure.core/let
    [v9052
     (:description m9051 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9052 :com.palletops.awaze.client-builder/undef)
     (. bean9050 setDescription (clojure.core/str v9052))))
   (clojure.core/let
    [v9052
     (:cluster-subnet-group-name
      m9051
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9052 :com.palletops.awaze.client-builder/undef)
     (. bean9050 setClusterSubnetGroupName (clojure.core/str v9052))))
   (clojure.core/let
    [v9052 (:tags m9051 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9052 :com.palletops.awaze.client-builder/undef)
     (.
      bean9050
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9121] (redshift/tag arg9121))
 v9052))))
   bean9050))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateClusterSnapshotRequest}
create-cluster-snapshot-request
  [m9054]
  (clojure.core/let
   [bean9053
    (new
     com.amazonaws.services.redshift.model.CreateClusterSnapshotRequest)]
   (clojure.core/let
    [v9055
     (:snapshot-identifier
      m9054
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9055 :com.palletops.awaze.client-builder/undef)
     (. bean9053 setSnapshotIdentifier (clojure.core/str v9055))))
   (clojure.core/let
    [v9055
     (:cluster-identifier
      m9054
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9055 :com.palletops.awaze.client-builder/undef)
     (. bean9053 setClusterIdentifier (clojure.core/str v9055))))
   (clojure.core/let
    [v9055 (:tags m9054 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9055 :com.palletops.awaze.client-builder/undef)
     (.
      bean9053
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9122] (redshift/tag arg9122))
 v9055))))
   bean9053))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateTagsRequest}
create-tags-request
  [m9057]
  (clojure.core/let
   [bean9056
    (new com.amazonaws.services.redshift.model.CreateTagsRequest)]
   (clojure.core/let
    [v9058
     (:resource-name m9057 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9058 :com.palletops.awaze.client-builder/undef)
     (. bean9056 setResourceName (clojure.core/str v9058))))
   (clojure.core/let
    [v9058 (:tags m9057 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9058 :com.palletops.awaze.client-builder/undef)
     (.
      bean9056
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9123] (redshift/tag arg9123))
 v9058))))
   bean9056))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeOrderableClusterOptionsRequest}
describe-orderable-cluster-options-request
  [m9060]
  (clojure.core/let
   [bean9059
    (new
     com.amazonaws.services.redshift.model.DescribeOrderableClusterOptionsRequest)]
   (clojure.core/let
    [v9061 (:marker m9060 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9061 :com.palletops.awaze.client-builder/undef)
     (. bean9059 setMarker (clojure.core/str v9061))))
   (clojure.core/let
    [v9061
     (:node-type m9060 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9061 :com.palletops.awaze.client-builder/undef)
     (. bean9059 setNodeType (clojure.core/str v9061))))
   (clojure.core/let
    [v9061
     (:cluster-version
      m9060
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9061 :com.palletops.awaze.client-builder/undef)
     (. bean9059 setClusterVersion (clojure.core/str v9061))))
   (clojure.core/let
    [v9061
     (:max-records m9060 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9061 :com.palletops.awaze.client-builder/undef)
     (. bean9059 setMaxRecords (clojure.core/int v9061))))
   bean9059))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.EnableLoggingRequest}
enable-logging-request
  [m9063]
  (clojure.core/let
   [bean9062
    (new com.amazonaws.services.redshift.model.EnableLoggingRequest)]
   (clojure.core/let
    [v9064
     (:cluster-identifier
      m9063
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9064 :com.palletops.awaze.client-builder/undef)
     (. bean9062 setClusterIdentifier (clojure.core/str v9064))))
   (clojure.core/let
    [v9064
     (:s3key-prefix m9063 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9064 :com.palletops.awaze.client-builder/undef)
     (. bean9062 setS3KeyPrefix (clojure.core/str v9064))))
   (clojure.core/let
    [v9064
     (:bucket-name m9063 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9064 :com.palletops.awaze.client-builder/undef)
     (. bean9062 setBucketName (clojure.core/str v9064))))
   bean9062))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.RevokeSnapshotAccessRequest}
revoke-snapshot-access-request
  [m9066]
  (clojure.core/let
   [bean9065
    (new
     com.amazonaws.services.redshift.model.RevokeSnapshotAccessRequest)]
   (clojure.core/let
    [v9067
     (:snapshot-identifier
      m9066
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9067 :com.palletops.awaze.client-builder/undef)
     (. bean9065 setSnapshotIdentifier (clojure.core/str v9067))))
   (clojure.core/let
    [v9067
     (:snapshot-cluster-identifier
      m9066
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9067 :com.palletops.awaze.client-builder/undef)
     (.
      bean9065
      setSnapshotClusterIdentifier
      (clojure.core/str v9067))))
   (clojure.core/let
    [v9067
     (:account-with-restore-access
      m9066
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9067 :com.palletops.awaze.client-builder/undef)
     (. bean9065 setAccountWithRestoreAccess (clojure.core/str v9067))))
   bean9065))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeEventSubscriptionsRequest}
describe-event-subscriptions-request
  [m9069]
  (clojure.core/let
   [bean9068
    (new
     com.amazonaws.services.redshift.model.DescribeEventSubscriptionsRequest)]
   (clojure.core/let
    [v9070 (:marker m9069 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9070 :com.palletops.awaze.client-builder/undef)
     (. bean9068 setMarker (clojure.core/str v9070))))
   (clojure.core/let
    [v9070
     (:subscription-name
      m9069
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9070 :com.palletops.awaze.client-builder/undef)
     (. bean9068 setSubscriptionName (clojure.core/str v9070))))
   (clojure.core/let
    [v9070
     (:max-records m9069 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9070 :com.palletops.awaze.client-builder/undef)
     (. bean9068 setMaxRecords (clojure.core/int v9070))))
   bean9068))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeReservedNodeOfferingsRequest}
describe-reserved-node-offerings-request
  [m9072]
  (clojure.core/let
   [bean9071
    (new
     com.amazonaws.services.redshift.model.DescribeReservedNodeOfferingsRequest)]
   (clojure.core/let
    [v9073 (:marker m9072 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9073 :com.palletops.awaze.client-builder/undef)
     (. bean9071 setMarker (clojure.core/str v9073))))
   (clojure.core/let
    [v9073
     (:reserved-node-offering-id
      m9072
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9073 :com.palletops.awaze.client-builder/undef)
     (. bean9071 setReservedNodeOfferingId (clojure.core/str v9073))))
   (clojure.core/let
    [v9073
     (:max-records m9072 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9073 :com.palletops.awaze.client-builder/undef)
     (. bean9071 setMaxRecords (clojure.core/int v9073))))
   bean9071))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteHsmConfigurationRequest}
delete-hsm-configuration-request
  [m9075]
  (clojure.core/let
   [bean9074
    (new
     com.amazonaws.services.redshift.model.DeleteHsmConfigurationRequest)]
   (clojure.core/let
    [v9076
     (:hsm-configuration-identifier
      m9075
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9076 :com.palletops.awaze.client-builder/undef)
     (.
      bean9074
      setHsmConfigurationIdentifier
      (clojure.core/str v9076))))
   bean9074))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateEventSubscriptionRequest}
create-event-subscription-request
  [m9078]
  (clojure.core/let
   [bean9077
    (new
     com.amazonaws.services.redshift.model.CreateEventSubscriptionRequest)]
   (clojure.core/let
    [v9079 (:enabled m9078 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9079 :com.palletops.awaze.client-builder/undef)
     (. bean9077 setEnabled (clojure.core/boolean v9079))))
   (clojure.core/let
    [v9079
     (:source-type m9078 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9079 :com.palletops.awaze.client-builder/undef)
     (. bean9077 setSourceType (clojure.core/str v9079))))
   (clojure.core/let
    [v9079
     (:subscription-name
      m9078
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9079 :com.palletops.awaze.client-builder/undef)
     (. bean9077 setSubscriptionName (clojure.core/str v9079))))
   (clojure.core/let
    [v9079
     (:sns-topic-arn m9078 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9079 :com.palletops.awaze.client-builder/undef)
     (. bean9077 setSnsTopicArn (clojure.core/str v9079))))
   (clojure.core/let
    [v9079
     (:source-ids m9078 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9079 :com.palletops.awaze.client-builder/undef)
     (.
      bean9077
      setSourceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9220] (clojure.core/str arg9220))
 v9079))))
   (clojure.core/let
    [v9079
     (:event-categories
      m9078
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9079 :com.palletops.awaze.client-builder/undef)
     (.
      bean9077
      setEventCategories
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9221] (clojure.core/str arg9221))
 v9079))))
   (clojure.core/let
    [v9079
     (:severity m9078 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9079 :com.palletops.awaze.client-builder/undef)
     (. bean9077 setSeverity (clojure.core/str v9079))))
   (clojure.core/let
    [v9079 (:tags m9078 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9079 :com.palletops.awaze.client-builder/undef)
     (.
      bean9077
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9222] (redshift/tag arg9222))
 v9079))))
   bean9077))
 (clojure.core/defmulti
  redshift
  (clojure.core/fn redshift [m__1874__auto__] (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   redshift
   :describe-resize
   [m9124]
   (clojure.core/let
    [credentials9125 (:credentials m9124) args9126 (:args m9124)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9127
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9125)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9127
       describeResize
       (redshift/describe-resize-request
        (clojure.core/nth args9126 0)))))))
  (clojure.core/defn
   describe-resize-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeResize"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-resize,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-resize
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeResize"}
   [credentials9129 & args9130]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9131
     (com.palletops.awaze.common/aws-client :redshift credentials9129)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9131
      describeResize
      (redshift/describe-resize-request (clojure.core/nth args9130 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-cluster-snapshots
   [m9132]
   (clojure.core/let
    [credentials9133 (:credentials m9132) args9134 (:args m9132)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9135
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9133)]
     (clojure.core/case
      (clojure.core/count args9134)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9135
        describeClusterSnapshots))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9135
        describeClusterSnapshots
        (redshift/describe-cluster-snapshots-request
         (clojure.core/nth args9134 0))))))))
  (clojure.core/defn
   describe-cluster-snapshots-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         marker
                         start-time
                         tag-keys
                         custom-query-parameters
                         end-time
                         snapshot-identifier
                         read-limit
                         tag-values
                         general-progress-listener
                         owner-account
                         max-records
                         clone-source
                         snapshot-type
                         clone-root]}]]),
    :doc "Generate map for describeClusterSnapshots, describeClusterSnapshots"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-cluster-snapshots,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-cluster-snapshots,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-cluster-snapshots
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         marker
                         start-time
                         tag-keys
                         custom-query-parameters
                         end-time
                         snapshot-identifier
                         read-limit
                         tag-values
                         general-progress-listener
                         owner-account
                         max-records
                         clone-source
                         snapshot-type
                         clone-root]}]]),
    :doc "Call describeClusterSnapshots, describeClusterSnapshots"}
   [credentials9137 & args9138]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9139
     (com.palletops.awaze.common/aws-client :redshift credentials9137)]
    (clojure.core/case
     (clojure.core/count args9138)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9139
       describeClusterSnapshots))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9139
       describeClusterSnapshots
       (redshift/describe-cluster-snapshots-request
        (clojure.core/nth args9138 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-default-cluster-parameters
   [m9140]
   (clojure.core/let
    [credentials9141 (:credentials m9140) args9142 (:args m9140)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9143
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9141)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9143
       describeDefaultClusterParameters
       (redshift/describe-default-cluster-parameters-request
        (clojure.core/nth args9142 0)))))))
  (clojure.core/defn
   describe-default-cluster-parameters-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         parameter-group-family
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeDefaultClusterParameters"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-default-cluster-parameters,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-default-cluster-parameters
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         parameter-group-family
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeDefaultClusterParameters"}
   [credentials9145 & args9146]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9147
     (com.palletops.awaze.common/aws-client :redshift credentials9145)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9147
      describeDefaultClusterParameters
      (redshift/describe-default-cluster-parameters-request
       (clojure.core/nth args9146 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-hsm-client-certificate
   [m9148]
   (clojure.core/let
    [credentials9149 (:credentials m9148) args9150 (:args m9148)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9151
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9149)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9151
       createHsmClientCertificate
       (redshift/create-hsm-client-certificate-request
        (clojure.core/nth args9150 0)))))))
  (clojure.core/defn
   create-hsm-client-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         hsm-client-certificate-identifier
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createHsmClientCertificate"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-hsm-client-certificate,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   create-hsm-client-certificate
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         hsm-client-certificate-identifier
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createHsmClientCertificate"}
   [credentials9153 & args9154]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9155
     (com.palletops.awaze.common/aws-client :redshift credentials9153)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9155
      createHsmClientCertificate
      (redshift/create-hsm-client-certificate-request
       (clojure.core/nth args9154 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-cluster-versions
   [m9156]
   (clojure.core/let
    [credentials9157 (:credentials m9156) args9158 (:args m9156)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9159
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9157)]
     (clojure.core/case
      (clojure.core/count args9158)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9159
        describeClusterVersions
        (redshift/describe-cluster-versions-request
         (clojure.core/nth args9158 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9159
        describeClusterVersions))))))
  (clojure.core/defn
   describe-cluster-versions-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         cluster-version
                         custom-query-parameters
                         cluster-parameter-group-family
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeClusterVersions, describeClusterVersions"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-cluster-versions,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-cluster-versions,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-cluster-versions
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         cluster-version
                         custom-query-parameters
                         cluster-parameter-group-family
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeClusterVersions, describeClusterVersions"}
   [credentials9161 & args9162]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9163
     (com.palletops.awaze.common/aws-client :redshift credentials9161)]
    (clojure.core/case
     (clojure.core/count args9162)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9163
       describeClusterVersions
       (redshift/describe-cluster-versions-request
        (clojure.core/nth args9162 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9163
       describeClusterVersions))))))
 (do
  (clojure.core/defmethod
   redshift
   :enable-snapshot-copy
   [m9164]
   (clojure.core/let
    [credentials9165 (:credentials m9164) args9166 (:args m9164)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9167
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9165)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9167
       enableSnapshotCopy
       (redshift/enable-snapshot-copy-request
        (clojure.core/nth args9166 0)))))))
  (clojure.core/defn
   enable-snapshot-copy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         destination-region
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         retention-period
                         read-limit
                         general-progress-listener
                         clone-source
                         snapshot-copy-grant-name
                         clone-root]}]]),
    :doc "Generate map for enableSnapshotCopy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :enable-snapshot-copy,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   enable-snapshot-copy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         destination-region
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         retention-period
                         read-limit
                         general-progress-listener
                         clone-source
                         snapshot-copy-grant-name
                         clone-root]}]]),
    :doc "Call enableSnapshotCopy"}
   [credentials9169 & args9170]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9171
     (com.palletops.awaze.common/aws-client :redshift credentials9169)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9171
      enableSnapshotCopy
      (redshift/enable-snapshot-copy-request
       (clojure.core/nth args9170 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-snapshot-copy-grant
   [m9172]
   (clojure.core/let
    [credentials9173 (:credentials m9172) args9174 (:args m9172)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9175
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9173)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9175
       createSnapshotCopyGrant
       (redshift/create-snapshot-copy-grant-request
        (clojure.core/nth args9174 0)))))))
  (clojure.core/defn
   create-snapshot-copy-grant-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         kms-key-id
                         clone-source
                         snapshot-copy-grant-name
                         clone-root]}]]),
    :doc "Generate map for createSnapshotCopyGrant"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-snapshot-copy-grant,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   create-snapshot-copy-grant
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         kms-key-id
                         clone-source
                         snapshot-copy-grant-name
                         clone-root]}]]),
    :doc "Call createSnapshotCopyGrant"}
   [credentials9177 & args9178]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9179
     (com.palletops.awaze.common/aws-client :redshift credentials9177)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9179
      createSnapshotCopyGrant
      (redshift/create-snapshot-copy-grant-request
       (clojure.core/nth args9178 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-cluster-parameter-groups
   [m9180]
   (clojure.core/let
    [credentials9181 (:credentials m9180) args9182 (:args m9180)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9183
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9181)]
     (clojure.core/case
      (clojure.core/count args9182)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9183
        describeClusterParameterGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9183
        describeClusterParameterGroups
        (redshift/describe-cluster-parameter-groups-request
         (clojure.core/nth args9182 0))))))))
  (clojure.core/defn
   describe-cluster-parameter-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         parameter-group-name
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeClusterParameterGroups, describeClusterParameterGroups"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-cluster-parameter-groups,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-cluster-parameter-groups,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-cluster-parameter-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         parameter-group-name
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeClusterParameterGroups, describeClusterParameterGroups"}
   [credentials9185 & args9186]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9187
     (com.palletops.awaze.common/aws-client :redshift credentials9185)]
    (clojure.core/case
     (clojure.core/count args9186)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9187
       describeClusterParameterGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9187
       describeClusterParameterGroups
       (redshift/describe-cluster-parameter-groups-request
        (clojure.core/nth args9186 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-cluster-parameter-group
   [m9188]
   (clojure.core/let
    [credentials9189 (:credentials m9188) args9190 (:args m9188)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9191
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9189)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9191
       deleteClusterParameterGroup
       (redshift/delete-cluster-parameter-group-request
        (clojure.core/nth args9190 0)))))))
  (clojure.core/defn
   delete-cluster-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         parameter-group-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteClusterParameterGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-cluster-parameter-group,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   delete-cluster-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         parameter-group-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteClusterParameterGroup"}
   [credentials9193 & args9194]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9195
     (com.palletops.awaze.common/aws-client :redshift credentials9193)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9195
      deleteClusterParameterGroup
      (redshift/delete-cluster-parameter-group-request
       (clojure.core/nth args9194 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-events
   [m9196]
   (clojure.core/let
    [credentials9197 (:credentials m9196) args9198 (:args m9196)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9199
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9197)]
     (clojure.core/case
      (clojure.core/count args9198)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9199
        describeEvents
        (redshift/describe-events-request
         (clojure.core/nth args9198 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9199
        describeEvents))))))
  (clojure.core/defn
   describe-events-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         source-type
                         start-time
                         custom-query-parameters
                         end-time
                         duration
                         read-limit
                         source-identifier
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeEvents, describeEvents"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-events,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-events,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-events
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         source-type
                         start-time
                         custom-query-parameters
                         end-time
                         duration
                         read-limit
                         source-identifier
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeEvents, describeEvents"}
   [credentials9201 & args9202]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9203
     (com.palletops.awaze.common/aws-client :redshift credentials9201)]
    (clojure.core/case
     (clojure.core/count args9202)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9203
       describeEvents
       (redshift/describe-events-request
        (clojure.core/nth args9202 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9203
       describeEvents))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-reserved-nodes
   [m9204]
   (clojure.core/let
    [credentials9205 (:credentials m9204) args9206 (:args m9204)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9207
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9205)]
     (clojure.core/case
      (clojure.core/count args9206)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9207
        describeReservedNodes))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9207
        describeReservedNodes
        (redshift/describe-reserved-nodes-request
         (clojure.core/nth args9206 0))))))))
  (clojure.core/defn
   describe-reserved-nodes-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         reserved-node-id
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeReservedNodes, describeReservedNodes"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-reserved-nodes,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-reserved-nodes,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-reserved-nodes
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         reserved-node-id
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeReservedNodes, describeReservedNodes"}
   [credentials9209 & args9210]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9211
     (com.palletops.awaze.common/aws-client :redshift credentials9209)]
    (clojure.core/case
     (clojure.core/count args9210)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9211
       describeReservedNodes))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9211
       describeReservedNodes
       (redshift/describe-reserved-nodes-request
        (clojure.core/nth args9210 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :modify-cluster-iam-roles
   [m9212]
   (clojure.core/let
    [credentials9213 (:credentials m9212) args9214 (:args m9212)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9215
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9213)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9215
       modifyClusterIamRoles
       (redshift/modify-cluster-iam-roles-request
        (clojure.core/nth args9214 0)))))))
  (clojure.core/defn
   modify-cluster-iam-roles-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         remove-iam-roles
                         read-limit
                         add-iam-roles
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for modifyClusterIamRoles"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-cluster-iam-roles,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   modify-cluster-iam-roles
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         remove-iam-roles
                         read-limit
                         add-iam-roles
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call modifyClusterIamRoles"}
   [credentials9217 & args9218]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9219
     (com.palletops.awaze.common/aws-client :redshift credentials9217)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9219
      modifyClusterIamRoles
      (redshift/modify-cluster-iam-roles-request
       (clojure.core/nth args9218 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-event-subscription
   [m9223]
   (clojure.core/let
    [credentials9224 (:credentials m9223) args9225 (:args m9223)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9226
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9224)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9226
       deleteEventSubscription
       (redshift/delete-event-subscription-request
        (clojure.core/nth args9225 0)))))))
  (clojure.core/defn
   delete-event-subscription-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subscription-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteEventSubscription"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-event-subscription,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   delete-event-subscription
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subscription-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteEventSubscription"}
   [credentials9228 & args9229]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9230
     (com.palletops.awaze.common/aws-client :redshift credentials9228)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9230
      deleteEventSubscription
      (redshift/delete-event-subscription-request
       (clojure.core/nth args9229 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :reboot-cluster
   [m9231]
   (clojure.core/let
    [credentials9232 (:credentials m9231) args9233 (:args m9231)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9234
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9232)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9234
       rebootCluster
       (redshift/reboot-cluster-request (clojure.core/nth args9233 0)))))))
  (clojure.core/defn
   reboot-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for rebootCluster"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :reboot-cluster,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   reboot-cluster
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call rebootCluster"}
   [credentials9236 & args9237]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9238
     (com.palletops.awaze.common/aws-client :redshift credentials9236)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9238
      rebootCluster
      (redshift/reboot-cluster-request (clojure.core/nth args9237 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-cluster-security-group
   [m9239]
   (clojure.core/let
    [credentials9240 (:credentials m9239) args9241 (:args m9239)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9242
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9240)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9242
       createClusterSecurityGroup
       (redshift/create-cluster-security-group-request
        (clojure.core/nth args9241 0)))))))
  (clojure.core/defn
   create-cluster-security-group-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         cluster-security-group-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createClusterSecurityGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-cluster-security-group,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   create-cluster-security-group
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         cluster-security-group-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createClusterSecurityGroup"}
   [credentials9244 & args9245]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9246
     (com.palletops.awaze.common/aws-client :redshift credentials9244)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9246
      createClusterSecurityGroup
      (redshift/create-cluster-security-group-request
       (clojure.core/nth args9245 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :modify-cluster-parameter-group
   [m9247]
   (clojure.core/let
    [credentials9248 (:credentials m9247) args9249 (:args m9247)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9250
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9248)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9250
       modifyClusterParameterGroup
       (redshift/modify-cluster-parameter-group-request
        (clojure.core/nth args9249 0)))))))
  (clojure.core/defn
   modify-cluster-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         parameter-group-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         parameters
                         clone-root]}]]),
    :doc "Generate map for modifyClusterParameterGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-cluster-parameter-group,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   modify-cluster-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         parameter-group-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         parameters
                         clone-root]}]]),
    :doc "Call modifyClusterParameterGroup"}
   [credentials9252 & args9253]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9254
     (com.palletops.awaze.common/aws-client :redshift credentials9252)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9254
      modifyClusterParameterGroup
      (redshift/modify-cluster-parameter-group-request
       (clojure.core/nth args9253 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :modify-snapshot-copy-retention-period
   [m9255]
   (clojure.core/let
    [credentials9256 (:credentials m9255) args9257 (:args m9255)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9258
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9256)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9258
       modifySnapshotCopyRetentionPeriod
       (redshift/modify-snapshot-copy-retention-period-request
        (clojure.core/nth args9257 0)))))))
  (clojure.core/defn
   modify-snapshot-copy-retention-period-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         retention-period
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for modifySnapshotCopyRetentionPeriod"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-snapshot-copy-retention-period,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   modify-snapshot-copy-retention-period
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         retention-period
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call modifySnapshotCopyRetentionPeriod"}
   [credentials9260 & args9261]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9262
     (com.palletops.awaze.common/aws-client :redshift credentials9260)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9262
      modifySnapshotCopyRetentionPeriod
      (redshift/modify-snapshot-copy-retention-period-request
       (clojure.core/nth args9261 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-snapshot-copy-grant
   [m9263]
   (clojure.core/let
    [credentials9264 (:credentials m9263) args9265 (:args m9263)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9266
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9264)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9266
       deleteSnapshotCopyGrant
       (redshift/delete-snapshot-copy-grant-request
        (clojure.core/nth args9265 0)))))))
  (clojure.core/defn
   delete-snapshot-copy-grant-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         snapshot-copy-grant-name
                         clone-root]}]]),
    :doc "Generate map for deleteSnapshotCopyGrant"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-snapshot-copy-grant,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   delete-snapshot-copy-grant
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         snapshot-copy-grant-name
                         clone-root]}]]),
    :doc "Call deleteSnapshotCopyGrant"}
   [credentials9268 & args9269]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9270
     (com.palletops.awaze.common/aws-client :redshift credentials9268)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9270
      deleteSnapshotCopyGrant
      (redshift/delete-snapshot-copy-grant-request
       (clojure.core/nth args9269 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :authorize-snapshot-access
   [m9271]
   (clojure.core/let
    [credentials9272 (:credentials m9271) args9273 (:args m9271)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9274
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9272)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9274
       authorizeSnapshotAccess
       (redshift/authorize-snapshot-access-request
        (clojure.core/nth args9273 0)))))))
  (clojure.core/defn
   authorize-snapshot-access-map
   {:arglists (quote
               [[credentials
                 {:keys [account-with-restore-access
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         snapshot-identifier
                         read-limit
                         general-progress-listener
                         snapshot-cluster-identifier
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for authorizeSnapshotAccess"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :authorize-snapshot-access,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   authorize-snapshot-access
   {:arglists (quote
               [[credentials
                 {:keys [account-with-restore-access
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         snapshot-identifier
                         read-limit
                         general-progress-listener
                         snapshot-cluster-identifier
                         clone-source
                         clone-root]}]]),
    :doc "Call authorizeSnapshotAccess"}
   [credentials9276 & args9277]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9278
     (com.palletops.awaze.common/aws-client :redshift credentials9276)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9278
      authorizeSnapshotAccess
      (redshift/authorize-snapshot-access-request
       (clojure.core/nth args9277 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :disable-logging
   [m9279]
   (clojure.core/let
    [credentials9280 (:credentials m9279) args9281 (:args m9279)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9282
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9280)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9282
       disableLogging
       (redshift/disable-logging-request
        (clojure.core/nth args9281 0)))))))
  (clojure.core/defn
   disable-logging-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for disableLogging"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :disable-logging,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   disable-logging
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call disableLogging"}
   [credentials9284 & args9285]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9286
     (com.palletops.awaze.common/aws-client :redshift credentials9284)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9286
      disableLogging
      (redshift/disable-logging-request (clojure.core/nth args9285 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :modify-cluster-subnet-group
   [m9287]
   (clojure.core/let
    [credentials9288 (:credentials m9287) args9289 (:args m9287)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9290
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9288)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9290
       modifyClusterSubnetGroup
       (redshift/modify-cluster-subnet-group-request
        (clojure.core/nth args9289 0)))))))
  (clojure.core/defn
   modify-cluster-subnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         subnet-ids
                         general-progress-listener
                         clone-source
                         cluster-subnet-group-name
                         clone-root]}]]),
    :doc "Generate map for modifyClusterSubnetGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-cluster-subnet-group,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   modify-cluster-subnet-group
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         subnet-ids
                         general-progress-listener
                         clone-source
                         cluster-subnet-group-name
                         clone-root]}]]),
    :doc "Call modifyClusterSubnetGroup"}
   [credentials9292 & args9293]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9294
     (com.palletops.awaze.common/aws-client :redshift credentials9292)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9294
      modifyClusterSubnetGroup
      (redshift/modify-cluster-subnet-group-request
       (clojure.core/nth args9293 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :modify-cluster
   [m9295]
   (clojure.core/let
    [credentials9296 (:credentials m9295) args9297 (:args m9295)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9298
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9296)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9298
       modifyCluster
       (redshift/modify-cluster-request (clojure.core/nth args9297 0)))))))
  (clojure.core/defn
   modify-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-security-group-ids
                         hsm-configuration-identifier
                         new-cluster-identifier
                         automated-snapshot-retention-period
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         cluster-parameter-group-name
                         elastic-ip
                         allow-version-upgrade
                         cluster-identifier
                         sdk-request-timeout
                         hsm-client-certificate-identifier
                         cluster-security-groups
                         cluster-version
                         custom-query-parameters
                         node-type
                         publicly-accessible
                         number-of-nodes
                         read-limit
                         general-progress-listener
                         master-user-password
                         clone-source
                         clone-root
                         cluster-type]}]]),
    :doc "Generate map for modifyCluster"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-cluster,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   modify-cluster
   {:arglists (quote
               [[credentials
                 {:keys [vpc-security-group-ids
                         hsm-configuration-identifier
                         new-cluster-identifier
                         automated-snapshot-retention-period
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         cluster-parameter-group-name
                         elastic-ip
                         allow-version-upgrade
                         cluster-identifier
                         sdk-request-timeout
                         hsm-client-certificate-identifier
                         cluster-security-groups
                         cluster-version
                         custom-query-parameters
                         node-type
                         publicly-accessible
                         number-of-nodes
                         read-limit
                         general-progress-listener
                         master-user-password
                         clone-source
                         clone-root
                         cluster-type]}]]),
    :doc "Call modifyCluster"}
   [credentials9300 & args9301]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9302
     (com.palletops.awaze.common/aws-client :redshift credentials9300)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9302
      modifyCluster
      (redshift/modify-cluster-request (clojure.core/nth args9301 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :restore-from-cluster-snapshot
   [m9303]
   (clojure.core/let
    [credentials9304 (:credentials m9303) args9305 (:args m9303)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9306
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9304)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9306
       restoreFromClusterSnapshot
       (redshift/restore-from-cluster-snapshot-request
        (clojure.core/nth args9305 0)))))))
  (clojure.core/defn
   restore-from-cluster-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-security-group-ids
                         hsm-configuration-identifier
                         automated-snapshot-retention-period
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         cluster-parameter-group-name
                         elastic-ip
                         allow-version-upgrade
                         cluster-identifier
                         sdk-request-timeout
                         hsm-client-certificate-identifier
                         cluster-security-groups
                         custom-query-parameters
                         availability-zone
                         port
                         node-type
                         publicly-accessible
                         additional-info
                         snapshot-identifier
                         read-limit
                         general-progress-listener
                         owner-account
                         kms-key-id
                         iam-roles
                         snapshot-cluster-identifier
                         clone-source
                         cluster-subnet-group-name
                         clone-root]}]]),
    :doc "Generate map for restoreFromClusterSnapshot"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :restore-from-cluster-snapshot,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   restore-from-cluster-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [vpc-security-group-ids
                         hsm-configuration-identifier
                         automated-snapshot-retention-period
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         cluster-parameter-group-name
                         elastic-ip
                         allow-version-upgrade
                         cluster-identifier
                         sdk-request-timeout
                         hsm-client-certificate-identifier
                         cluster-security-groups
                         custom-query-parameters
                         availability-zone
                         port
                         node-type
                         publicly-accessible
                         additional-info
                         snapshot-identifier
                         read-limit
                         general-progress-listener
                         owner-account
                         kms-key-id
                         iam-roles
                         snapshot-cluster-identifier
                         clone-source
                         cluster-subnet-group-name
                         clone-root]}]]),
    :doc "Call restoreFromClusterSnapshot"}
   [credentials9308 & args9309]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9310
     (com.palletops.awaze.common/aws-client :redshift credentials9308)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9310
      restoreFromClusterSnapshot
      (redshift/restore-from-cluster-snapshot-request
       (clojure.core/nth args9309 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-hsm-client-certificate
   [m9311]
   (clojure.core/let
    [credentials9312 (:credentials m9311) args9313 (:args m9311)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9314
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9312)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9314
       deleteHsmClientCertificate
       (redshift/delete-hsm-client-certificate-request
        (clojure.core/nth args9313 0)))))))
  (clojure.core/defn
   delete-hsm-client-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         hsm-client-certificate-identifier
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteHsmClientCertificate"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-hsm-client-certificate,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   delete-hsm-client-certificate
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         hsm-client-certificate-identifier
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteHsmClientCertificate"}
   [credentials9316 & args9317]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9318
     (com.palletops.awaze.common/aws-client :redshift credentials9316)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9318
      deleteHsmClientCertificate
      (redshift/delete-hsm-client-certificate-request
       (clojure.core/nth args9317 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-cluster
   [m9319]
   (clojure.core/let
    [credentials9320 (:credentials m9319) args9321 (:args m9319)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9322
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9320)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9322
       createCluster
       (redshift/create-cluster-request (clojure.core/nth args9321 0)))))))
  (clojure.core/defn
   create-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-security-group-ids
                         tags
                         hsm-configuration-identifier
                         automated-snapshot-retention-period
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         cluster-parameter-group-name
                         master-username
                         elastic-ip
                         allow-version-upgrade
                         cluster-identifier
                         sdk-request-timeout
                         hsm-client-certificate-identifier
                         cluster-security-groups
                         cluster-version
                         custom-query-parameters
                         availability-zone
                         port
                         node-type
                         publicly-accessible
                         dbname
                         number-of-nodes
                         additional-info
                         read-limit
                         general-progress-listener
                         kms-key-id
                         iam-roles
                         master-user-password
                         clone-source
                         cluster-subnet-group-name
                         encrypted
                         clone-root
                         cluster-type]}]]),
    :doc "Generate map for createCluster"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-cluster,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   create-cluster
   {:arglists (quote
               [[credentials
                 {:keys [vpc-security-group-ids
                         tags
                         hsm-configuration-identifier
                         automated-snapshot-retention-period
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         cluster-parameter-group-name
                         master-username
                         elastic-ip
                         allow-version-upgrade
                         cluster-identifier
                         sdk-request-timeout
                         hsm-client-certificate-identifier
                         cluster-security-groups
                         cluster-version
                         custom-query-parameters
                         availability-zone
                         port
                         node-type
                         publicly-accessible
                         dbname
                         number-of-nodes
                         additional-info
                         read-limit
                         general-progress-listener
                         kms-key-id
                         iam-roles
                         master-user-password
                         clone-source
                         cluster-subnet-group-name
                         encrypted
                         clone-root
                         cluster-type]}]]),
    :doc "Call createCluster"}
   [credentials9324 & args9325]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9326
     (com.palletops.awaze.common/aws-client :redshift credentials9324)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9326
      createCluster
      (redshift/create-cluster-request (clojure.core/nth args9325 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-logging-status
   [m9327]
   (clojure.core/let
    [credentials9328 (:credentials m9327) args9329 (:args m9327)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9330
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9328)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9330
       describeLoggingStatus
       (redshift/describe-logging-status-request
        (clojure.core/nth args9329 0)))))))
  (clojure.core/defn
   describe-logging-status-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeLoggingStatus"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-logging-status,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-logging-status
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeLoggingStatus"}
   [credentials9332 & args9333]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9334
     (com.palletops.awaze.common/aws-client :redshift credentials9332)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9334
      describeLoggingStatus
      (redshift/describe-logging-status-request
       (clojure.core/nth args9333 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-table-restore-status
   [m9335]
   (clojure.core/let
    [credentials9336 (:credentials m9335) args9337 (:args m9335)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9338
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9336)]
     (clojure.core/case
      (clojure.core/count args9337)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9338
        describeTableRestoreStatus))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9338
        describeTableRestoreStatus
        (redshift/describe-table-restore-status-request
         (clojure.core/nth args9337 0))))))))
  (clojure.core/defn
   describe-table-restore-status-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         table-restore-request-id]}]]),
    :doc "Generate map for describeTableRestoreStatus, describeTableRestoreStatus"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-table-restore-status,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-table-restore-status,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-table-restore-status
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         table-restore-request-id]}]]),
    :doc "Call describeTableRestoreStatus, describeTableRestoreStatus"}
   [credentials9340 & args9341]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9342
     (com.palletops.awaze.common/aws-client :redshift credentials9340)]
    (clojure.core/case
     (clojure.core/count args9341)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9342
       describeTableRestoreStatus))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9342
       describeTableRestoreStatus
       (redshift/describe-table-restore-status-request
        (clojure.core/nth args9341 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-event-categories
   [m9343]
   (clojure.core/let
    [credentials9344 (:credentials m9343) args9345 (:args m9343)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9346
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9344)]
     (clojure.core/case
      (clojure.core/count args9345)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9346
        describeEventCategories))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9346
        describeEventCategories
        (redshift/describe-event-categories-request
         (clojure.core/nth args9345 0))))))))
  (clojure.core/defn
   describe-event-categories-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         source-type
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeEventCategories, describeEventCategories"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-event-categories,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-event-categories,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-event-categories
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         source-type
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeEventCategories, describeEventCategories"}
   [credentials9348 & args9349]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9350
     (com.palletops.awaze.common/aws-client :redshift credentials9348)]
    (clojure.core/case
     (clojure.core/count args9349)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9350
       describeEventCategories))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9350
       describeEventCategories
       (redshift/describe-event-categories-request
        (clojure.core/nth args9349 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-cluster-parameters
   [m9351]
   (clojure.core/let
    [credentials9352 (:credentials m9351) args9353 (:args m9351)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9354
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9352)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9354
       describeClusterParameters
       (redshift/describe-cluster-parameters-request
        (clojure.core/nth args9353 0)))))))
  (clojure.core/defn
   describe-cluster-parameters-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         parameter-group-name
                         custom-query-parameters
                         source
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeClusterParameters"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-cluster-parameters,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-cluster-parameters
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         parameter-group-name
                         custom-query-parameters
                         source
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeClusterParameters"}
   [credentials9356 & args9357]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9358
     (com.palletops.awaze.common/aws-client :redshift credentials9356)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9358
      describeClusterParameters
      (redshift/describe-cluster-parameters-request
       (clojure.core/nth args9357 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :authorize-cluster-security-group-ingress
   [m9359]
   (clojure.core/let
    [credentials9360 (:credentials m9359) args9361 (:args m9359)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9362
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9360)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9362
       authorizeClusterSecurityGroupIngress
       (redshift/authorize-cluster-security-group-ingress-request
        (clojure.core/nth args9361 0)))))))
  (clojure.core/defn
   authorize-cluster-security-group-ingress-map
   {:arglists (quote
               [[credentials
                 {:keys [cluster-security-group-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         cidrip
                         read-limit
                         general-progress-listener
                         ec2security-group-owner-id
                         clone-source
                         clone-root
                         ec2security-group-name]}]]),
    :doc "Generate map for authorizeClusterSecurityGroupIngress"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :authorize-cluster-security-group-ingress,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   authorize-cluster-security-group-ingress
   {:arglists (quote
               [[credentials
                 {:keys [cluster-security-group-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         cidrip
                         read-limit
                         general-progress-listener
                         ec2security-group-owner-id
                         clone-source
                         clone-root
                         ec2security-group-name]}]]),
    :doc "Call authorizeClusterSecurityGroupIngress"}
   [credentials9364 & args9365]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9366
     (com.palletops.awaze.common/aws-client :redshift credentials9364)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9366
      authorizeClusterSecurityGroupIngress
      (redshift/authorize-cluster-security-group-ingress-request
       (clojure.core/nth args9365 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-clusters
   [m9367]
   (clojure.core/let
    [credentials9368 (:credentials m9367) args9369 (:args m9367)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9370
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9368)]
     (clojure.core/case
      (clojure.core/count args9369)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9370
        describeClusters
        (redshift/describe-clusters-request
         (clojure.core/nth args9369 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9370
        describeClusters))))))
  (clojure.core/defn
   describe-clusters-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         marker
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeClusters, describeClusters"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-clusters,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-clusters,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-clusters
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         marker
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeClusters, describeClusters"}
   [credentials9372 & args9373]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9374
     (com.palletops.awaze.common/aws-client :redshift credentials9372)]
    (clojure.core/case
     (clojure.core/count args9373)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9374
       describeClusters
       (redshift/describe-clusters-request
        (clojure.core/nth args9373 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9374
       describeClusters))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-cluster-subnet-group
   [m9375]
   (clojure.core/let
    [credentials9376 (:credentials m9375) args9377 (:args m9375)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9378
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9376)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9378
       deleteClusterSubnetGroup
       (redshift/delete-cluster-subnet-group-request
        (clojure.core/nth args9377 0)))))))
  (clojure.core/defn
   delete-cluster-subnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         cluster-subnet-group-name
                         clone-root]}]]),
    :doc "Generate map for deleteClusterSubnetGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-cluster-subnet-group,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   delete-cluster-subnet-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         cluster-subnet-group-name
                         clone-root]}]]),
    :doc "Call deleteClusterSubnetGroup"}
   [credentials9380 & args9381]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9382
     (com.palletops.awaze.common/aws-client :redshift credentials9380)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9382
      deleteClusterSubnetGroup
      (redshift/delete-cluster-subnet-group-request
       (clojure.core/nth args9381 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-cluster-security-groups
   [m9383]
   (clojure.core/let
    [credentials9384 (:credentials m9383) args9385 (:args m9383)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9386
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9384)]
     (clojure.core/case
      (clojure.core/count args9385)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9386
        describeClusterSecurityGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9386
        describeClusterSecurityGroups
        (redshift/describe-cluster-security-groups-request
         (clojure.core/nth args9385 0))))))))
  (clojure.core/defn
   describe-cluster-security-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [cluster-security-group-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeClusterSecurityGroups, describeClusterSecurityGroups"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-cluster-security-groups,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-cluster-security-groups,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-cluster-security-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [cluster-security-group-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeClusterSecurityGroups, describeClusterSecurityGroups"}
   [credentials9388 & args9389]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9390
     (com.palletops.awaze.common/aws-client :redshift credentials9388)]
    (clojure.core/case
     (clojure.core/count args9389)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9390
       describeClusterSecurityGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9390
       describeClusterSecurityGroups
       (redshift/describe-cluster-security-groups-request
        (clojure.core/nth args9389 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-tags
   [m9391]
   (clojure.core/let
    [credentials9392 (:credentials m9391) args9393 (:args m9391)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9394
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9392)]
     (clojure.core/case
      (clojure.core/count args9393)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9394
        describeTags))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9394
        describeTags
        (redshift/describe-tags-request (clojure.core/nth args9393 0))))))))
  (clojure.core/defn
   describe-tags-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         tag-keys
                         resource-name
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         resource-type
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeTags, describeTags"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-tags,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-tags,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-tags
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         tag-keys
                         resource-name
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         resource-type
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeTags, describeTags"}
   [credentials9396 & args9397]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9398
     (com.palletops.awaze.common/aws-client :redshift credentials9396)]
    (clojure.core/case
     (clojure.core/count args9397)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9398
       describeTags))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9398
       describeTags
       (redshift/describe-tags-request (clojure.core/nth args9397 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :disable-snapshot-copy
   [m9399]
   (clojure.core/let
    [credentials9400 (:credentials m9399) args9401 (:args m9399)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9402
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9400)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9402
       disableSnapshotCopy
       (redshift/disable-snapshot-copy-request
        (clojure.core/nth args9401 0)))))))
  (clojure.core/defn
   disable-snapshot-copy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for disableSnapshotCopy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :disable-snapshot-copy,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   disable-snapshot-copy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call disableSnapshotCopy"}
   [credentials9404 & args9405]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9406
     (com.palletops.awaze.common/aws-client :redshift credentials9404)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9406
      disableSnapshotCopy
      (redshift/disable-snapshot-copy-request
       (clojure.core/nth args9405 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-tags
   [m9407]
   (clojure.core/let
    [credentials9408 (:credentials m9407) args9409 (:args m9407)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9410
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9408)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9410
       deleteTags
       (redshift/delete-tags-request (clojure.core/nth args9409 0)))))))
  (clojure.core/defn
   delete-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         tag-keys
                         resource-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteTags"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-tags,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   delete-tags
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         tag-keys
                         resource-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteTags"}
   [credentials9412 & args9413]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9414
     (com.palletops.awaze.common/aws-client :redshift credentials9412)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9414
      deleteTags
      (redshift/delete-tags-request (clojure.core/nth args9413 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :purchase-reserved-node-offering
   [m9415]
   (clojure.core/let
    [credentials9416 (:credentials m9415) args9417 (:args m9415)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9418
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9416)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9418
       purchaseReservedNodeOffering
       (redshift/purchase-reserved-node-offering-request
        (clojure.core/nth args9417 0)))))))
  (clojure.core/defn
   purchase-reserved-node-offering-map
   {:arglists (quote
               [[credentials
                 {:keys [node-count
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         reserved-node-offering-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for purchaseReservedNodeOffering"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :purchase-reserved-node-offering,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   purchase-reserved-node-offering
   {:arglists (quote
               [[credentials
                 {:keys [node-count
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         reserved-node-offering-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call purchaseReservedNodeOffering"}
   [credentials9420 & args9421]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9422
     (com.palletops.awaze.common/aws-client :redshift credentials9420)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9422
      purchaseReservedNodeOffering
      (redshift/purchase-reserved-node-offering-request
       (clojure.core/nth args9421 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-cluster-snapshot
   [m9423]
   (clojure.core/let
    [credentials9424 (:credentials m9423) args9425 (:args m9423)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9426
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9424)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9426
       deleteClusterSnapshot
       (redshift/delete-cluster-snapshot-request
        (clojure.core/nth args9425 0)))))))
  (clojure.core/defn
   delete-cluster-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         snapshot-identifier
                         read-limit
                         general-progress-listener
                         snapshot-cluster-identifier
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteClusterSnapshot"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-cluster-snapshot,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   delete-cluster-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         snapshot-identifier
                         read-limit
                         general-progress-listener
                         snapshot-cluster-identifier
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteClusterSnapshot"}
   [credentials9428 & args9429]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9430
     (com.palletops.awaze.common/aws-client :redshift credentials9428)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9430
      deleteClusterSnapshot
      (redshift/delete-cluster-snapshot-request
       (clojure.core/nth args9429 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-cluster-parameter-group
   [m9431]
   (clojure.core/let
    [credentials9432 (:credentials m9431) args9433 (:args m9431)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9434
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9432)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9434
       createClusterParameterGroup
       (redshift/create-cluster-parameter-group-request
        (clojure.core/nth args9433 0)))))))
  (clojure.core/defn
   create-cluster-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         parameter-group-name
                         custom-query-parameters
                         parameter-group-family
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createClusterParameterGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-cluster-parameter-group,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   create-cluster-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         parameter-group-name
                         custom-query-parameters
                         parameter-group-family
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createClusterParameterGroup"}
   [credentials9436 & args9437]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9438
     (com.palletops.awaze.common/aws-client :redshift credentials9436)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9438
      createClusterParameterGroup
      (redshift/create-cluster-parameter-group-request
       (clojure.core/nth args9437 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :rotate-encryption-key
   [m9439]
   (clojure.core/let
    [credentials9440 (:credentials m9439) args9441 (:args m9439)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9442
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9440)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9442
       rotateEncryptionKey
       (redshift/rotate-encryption-key-request
        (clojure.core/nth args9441 0)))))))
  (clojure.core/defn
   rotate-encryption-key-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for rotateEncryptionKey"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :rotate-encryption-key,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   rotate-encryption-key
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call rotateEncryptionKey"}
   [credentials9444 & args9445]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9446
     (com.palletops.awaze.common/aws-client :redshift credentials9444)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9446
      rotateEncryptionKey
      (redshift/rotate-encryption-key-request
       (clojure.core/nth args9445 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-hsm-client-certificates
   [m9447]
   (clojure.core/let
    [credentials9448 (:credentials m9447) args9449 (:args m9447)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9450
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9448)]
     (clojure.core/case
      (clojure.core/count args9449)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9450
        describeHsmClientCertificates))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9450
        describeHsmClientCertificates
        (redshift/describe-hsm-client-certificates-request
         (clojure.core/nth args9449 0))))))))
  (clojure.core/defn
   describe-hsm-client-certificates-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         hsm-client-certificate-identifier
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeHsmClientCertificates, describeHsmClientCertificates"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-hsm-client-certificates,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-hsm-client-certificates,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-hsm-client-certificates
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         hsm-client-certificate-identifier
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeHsmClientCertificates, describeHsmClientCertificates"}
   [credentials9452 & args9453]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9454
     (com.palletops.awaze.common/aws-client :redshift credentials9452)]
    (clojure.core/case
     (clojure.core/count args9453)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9454
       describeHsmClientCertificates))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9454
       describeHsmClientCertificates
       (redshift/describe-hsm-client-certificates-request
        (clojure.core/nth args9453 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-snapshot-copy-grants
   [m9455]
   (clojure.core/let
    [credentials9456 (:credentials m9455) args9457 (:args m9455)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9458
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9456)]
     (clojure.core/case
      (clojure.core/count args9457)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9458
        describeSnapshotCopyGrants))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9458
        describeSnapshotCopyGrants
        (redshift/describe-snapshot-copy-grants-request
         (clojure.core/nth args9457 0))))))))
  (clojure.core/defn
   describe-snapshot-copy-grants-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         snapshot-copy-grant-name
                         clone-root]}]]),
    :doc "Generate map for describeSnapshotCopyGrants, describeSnapshotCopyGrants"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-snapshot-copy-grants,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-snapshot-copy-grants,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-snapshot-copy-grants
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         snapshot-copy-grant-name
                         clone-root]}]]),
    :doc "Call describeSnapshotCopyGrants, describeSnapshotCopyGrants"}
   [credentials9460 & args9461]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9462
     (com.palletops.awaze.common/aws-client :redshift credentials9460)]
    (clojure.core/case
     (clojure.core/count args9461)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9462
       describeSnapshotCopyGrants))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9462
       describeSnapshotCopyGrants
       (redshift/describe-snapshot-copy-grants-request
        (clojure.core/nth args9461 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :reset-cluster-parameter-group
   [m9463]
   (clojure.core/let
    [credentials9464 (:credentials m9463) args9465 (:args m9463)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9466
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9464)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9466
       resetClusterParameterGroup
       (redshift/reset-cluster-parameter-group-request
        (clojure.core/nth args9465 0)))))))
  (clojure.core/defn
   reset-cluster-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         parameter-group-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         reset-all-parameters
                         parameters
                         clone-root]}]]),
    :doc "Generate map for resetClusterParameterGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :reset-cluster-parameter-group,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   reset-cluster-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         parameter-group-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         reset-all-parameters
                         parameters
                         clone-root]}]]),
    :doc "Call resetClusterParameterGroup"}
   [credentials9468 & args9469]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9470
     (com.palletops.awaze.common/aws-client :redshift credentials9468)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9470
      resetClusterParameterGroup
      (redshift/reset-cluster-parameter-group-request
       (clojure.core/nth args9469 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-cluster-security-group
   [m9471]
   (clojure.core/let
    [credentials9472 (:credentials m9471) args9473 (:args m9471)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9474
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9472)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9474
       deleteClusterSecurityGroup
       (redshift/delete-cluster-security-group-request
        (clojure.core/nth args9473 0)))))))
  (clojure.core/defn
   delete-cluster-security-group-map
   {:arglists (quote
               [[credentials
                 {:keys [cluster-security-group-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteClusterSecurityGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-cluster-security-group,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   delete-cluster-security-group
   {:arglists (quote
               [[credentials
                 {:keys [cluster-security-group-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteClusterSecurityGroup"}
   [credentials9476 & args9477]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9478
     (com.palletops.awaze.common/aws-client :redshift credentials9476)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9478
      deleteClusterSecurityGroup
      (redshift/delete-cluster-security-group-request
       (clojure.core/nth args9477 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :copy-cluster-snapshot
   [m9479]
   (clojure.core/let
    [credentials9480 (:credentials m9479) args9481 (:args m9479)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9482
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9480)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9482
       copyClusterSnapshot
       (redshift/copy-cluster-snapshot-request
        (clojure.core/nth args9481 0)))))))
  (clojure.core/defn
   copy-cluster-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         source-snapshot-identifier
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         source-snapshot-cluster-identifier
                         clone-source
                         target-snapshot-identifier
                         clone-root]}]]),
    :doc "Generate map for copyClusterSnapshot"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :copy-cluster-snapshot,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   copy-cluster-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         source-snapshot-identifier
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         source-snapshot-cluster-identifier
                         clone-source
                         target-snapshot-identifier
                         clone-root]}]]),
    :doc "Call copyClusterSnapshot"}
   [credentials9484 & args9485]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9486
     (com.palletops.awaze.common/aws-client :redshift credentials9484)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9486
      copyClusterSnapshot
      (redshift/copy-cluster-snapshot-request
       (clojure.core/nth args9485 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :restore-table-from-cluster-snapshot
   [m9487]
   (clojure.core/let
    [credentials9488 (:credentials m9487) args9489 (:args m9487)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9490
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9488)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9490
       restoreTableFromClusterSnapshot
       (redshift/restore-table-from-cluster-snapshot-request
        (clojure.core/nth args9489 0)))))))
  (clojure.core/defn
   restore-table-from-cluster-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         target-schema-name
                         cluster-identifier
                         source-schema-name
                         sdk-request-timeout
                         source-database-name
                         source-table-name
                         custom-query-parameters
                         new-table-name
                         snapshot-identifier
                         read-limit
                         general-progress-listener
                         clone-source
                         target-database-name
                         clone-root]}]]),
    :doc "Generate map for restoreTableFromClusterSnapshot"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :restore-table-from-cluster-snapshot,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   restore-table-from-cluster-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         target-schema-name
                         cluster-identifier
                         source-schema-name
                         sdk-request-timeout
                         source-database-name
                         source-table-name
                         custom-query-parameters
                         new-table-name
                         snapshot-identifier
                         read-limit
                         general-progress-listener
                         clone-source
                         target-database-name
                         clone-root]}]]),
    :doc "Call restoreTableFromClusterSnapshot"}
   [credentials9492 & args9493]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9494
     (com.palletops.awaze.common/aws-client :redshift credentials9492)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9494
      restoreTableFromClusterSnapshot
      (redshift/restore-table-from-cluster-snapshot-request
       (clojure.core/nth args9493 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :modify-event-subscription
   [m9495]
   (clojure.core/let
    [credentials9496 (:credentials m9495) args9497 (:args m9495)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9498
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9496)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9498
       modifyEventSubscription
       (redshift/modify-event-subscription-request
        (clojure.core/nth args9497 0)))))))
  (clojure.core/defn
   modify-event-subscription-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subscription-name
                         sdk-request-timeout
                         source-type
                         custom-query-parameters
                         source-ids
                         read-limit
                         general-progress-listener
                         severity
                         event-categories
                         clone-source
                         sns-topic-arn
                         enabled
                         clone-root]}]]),
    :doc "Generate map for modifyEventSubscription"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-event-subscription,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   modify-event-subscription
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subscription-name
                         sdk-request-timeout
                         source-type
                         custom-query-parameters
                         source-ids
                         read-limit
                         general-progress-listener
                         severity
                         event-categories
                         clone-source
                         sns-topic-arn
                         enabled
                         clone-root]}]]),
    :doc "Call modifyEventSubscription"}
   [credentials9500 & args9501]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9502
     (com.palletops.awaze.common/aws-client :redshift credentials9500)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9502
      modifyEventSubscription
      (redshift/modify-event-subscription-request
       (clojure.core/nth args9501 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-hsm-configuration
   [m9503]
   (clojure.core/let
    [credentials9504 (:credentials m9503) args9505 (:args m9503)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9506
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9504)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9506
       createHsmConfiguration
       (redshift/create-hsm-configuration-request
        (clojure.core/nth args9505 0)))))))
  (clojure.core/defn
   create-hsm-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         hsm-configuration-identifier
                         custom-request-headers
                         sdk-client-execution-timeout
                         hsm-partition-password
                         sdk-request-timeout
                         hsm-ip-address
                         custom-query-parameters
                         hsm-partition-name
                         read-limit
                         hsm-server-public-certificate
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createHsmConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-hsm-configuration,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   create-hsm-configuration
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         hsm-configuration-identifier
                         custom-request-headers
                         sdk-client-execution-timeout
                         hsm-partition-password
                         sdk-request-timeout
                         hsm-ip-address
                         custom-query-parameters
                         hsm-partition-name
                         read-limit
                         hsm-server-public-certificate
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createHsmConfiguration"}
   [credentials9508 & args9509]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9510
     (com.palletops.awaze.common/aws-client :redshift credentials9508)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9510
      createHsmConfiguration
      (redshift/create-hsm-configuration-request
       (clojure.core/nth args9509 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-hsm-configurations
   [m9511]
   (clojure.core/let
    [credentials9512 (:credentials m9511) args9513 (:args m9511)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9514
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9512)]
     (clojure.core/case
      (clojure.core/count args9513)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9514
        describeHsmConfigurations
        (redshift/describe-hsm-configurations-request
         (clojure.core/nth args9513 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9514
        describeHsmConfigurations))))))
  (clojure.core/defn
   describe-hsm-configurations-map
   {:arglists (quote
               [[credentials
                 {:keys [hsm-configuration-identifier
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeHsmConfigurations, describeHsmConfigurations"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-hsm-configurations,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-hsm-configurations,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-hsm-configurations
   {:arglists (quote
               [[credentials
                 {:keys [hsm-configuration-identifier
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeHsmConfigurations, describeHsmConfigurations"}
   [credentials9516 & args9517]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9518
     (com.palletops.awaze.common/aws-client :redshift credentials9516)]
    (clojure.core/case
     (clojure.core/count args9517)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9518
       describeHsmConfigurations
       (redshift/describe-hsm-configurations-request
        (clojure.core/nth args9517 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9518
       describeHsmConfigurations))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-cluster-subnet-groups
   [m9519]
   (clojure.core/let
    [credentials9520 (:credentials m9519) args9521 (:args m9519)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9522
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9520)]
     (clojure.core/case
      (clojure.core/count args9521)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9522
        describeClusterSubnetGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9522
        describeClusterSubnetGroups
        (redshift/describe-cluster-subnet-groups-request
         (clojure.core/nth args9521 0))))))))
  (clojure.core/defn
   describe-cluster-subnet-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         cluster-subnet-group-name
                         clone-root]}]]),
    :doc "Generate map for describeClusterSubnetGroups, describeClusterSubnetGroups"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-cluster-subnet-groups,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-cluster-subnet-groups,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-cluster-subnet-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         tag-keys
                         custom-query-parameters
                         read-limit
                         tag-values
                         general-progress-listener
                         max-records
                         clone-source
                         cluster-subnet-group-name
                         clone-root]}]]),
    :doc "Call describeClusterSubnetGroups, describeClusterSubnetGroups"}
   [credentials9524 & args9525]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9526
     (com.palletops.awaze.common/aws-client :redshift credentials9524)]
    (clojure.core/case
     (clojure.core/count args9525)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9526
       describeClusterSubnetGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9526
       describeClusterSubnetGroups
       (redshift/describe-cluster-subnet-groups-request
        (clojure.core/nth args9525 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-cluster
   [m9527]
   (clojure.core/let
    [credentials9528 (:credentials m9527) args9529 (:args m9527)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9530
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9528)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9530
       deleteCluster
       (redshift/delete-cluster-request (clojure.core/nth args9529 0)))))))
  (clojure.core/defn
   delete-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         final-cluster-snapshot-identifier
                         read-limit
                         skip-final-cluster-snapshot
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteCluster"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-cluster,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   delete-cluster
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         final-cluster-snapshot-identifier
                         read-limit
                         skip-final-cluster-snapshot
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteCluster"}
   [credentials9532 & args9533]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9534
     (com.palletops.awaze.common/aws-client :redshift credentials9532)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9534
      deleteCluster
      (redshift/delete-cluster-request (clojure.core/nth args9533 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :revoke-cluster-security-group-ingress
   [m9535]
   (clojure.core/let
    [credentials9536 (:credentials m9535) args9537 (:args m9535)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9538
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9536)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9538
       revokeClusterSecurityGroupIngress
       (redshift/revoke-cluster-security-group-ingress-request
        (clojure.core/nth args9537 0)))))))
  (clojure.core/defn
   revoke-cluster-security-group-ingress-map
   {:arglists (quote
               [[credentials
                 {:keys [cluster-security-group-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         cidrip
                         read-limit
                         general-progress-listener
                         ec2security-group-owner-id
                         clone-source
                         clone-root
                         ec2security-group-name]}]]),
    :doc "Generate map for revokeClusterSecurityGroupIngress"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :revoke-cluster-security-group-ingress,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   revoke-cluster-security-group-ingress
   {:arglists (quote
               [[credentials
                 {:keys [cluster-security-group-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         cidrip
                         read-limit
                         general-progress-listener
                         ec2security-group-owner-id
                         clone-source
                         clone-root
                         ec2security-group-name]}]]),
    :doc "Call revokeClusterSecurityGroupIngress"}
   [credentials9540 & args9541]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9542
     (com.palletops.awaze.common/aws-client :redshift credentials9540)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9542
      revokeClusterSecurityGroupIngress
      (redshift/revoke-cluster-security-group-ingress-request
       (clojure.core/nth args9541 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-cluster-subnet-group
   [m9543]
   (clojure.core/let
    [credentials9544 (:credentials m9543) args9545 (:args m9543)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9546
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9544)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9546
       createClusterSubnetGroup
       (redshift/create-cluster-subnet-group-request
        (clojure.core/nth args9545 0)))))))
  (clojure.core/defn
   create-cluster-subnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         subnet-ids
                         general-progress-listener
                         clone-source
                         cluster-subnet-group-name
                         clone-root]}]]),
    :doc "Generate map for createClusterSubnetGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-cluster-subnet-group,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   create-cluster-subnet-group
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         subnet-ids
                         general-progress-listener
                         clone-source
                         cluster-subnet-group-name
                         clone-root]}]]),
    :doc "Call createClusterSubnetGroup"}
   [credentials9548 & args9549]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9550
     (com.palletops.awaze.common/aws-client :redshift credentials9548)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9550
      createClusterSubnetGroup
      (redshift/create-cluster-subnet-group-request
       (clojure.core/nth args9549 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-cluster-snapshot
   [m9551]
   (clojure.core/let
    [credentials9552 (:credentials m9551) args9553 (:args m9551)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9554
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9552)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9554
       createClusterSnapshot
       (redshift/create-cluster-snapshot-request
        (clojure.core/nth args9553 0)))))))
  (clojure.core/defn
   create-cluster-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         snapshot-identifier
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createClusterSnapshot"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-cluster-snapshot,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   create-cluster-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         snapshot-identifier
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createClusterSnapshot"}
   [credentials9556 & args9557]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9558
     (com.palletops.awaze.common/aws-client :redshift credentials9556)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9558
      createClusterSnapshot
      (redshift/create-cluster-snapshot-request
       (clojure.core/nth args9557 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-tags
   [m9559]
   (clojure.core/let
    [credentials9560 (:credentials m9559) args9561 (:args m9559)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9562
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9560)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9562
       createTags
       (redshift/create-tags-request (clojure.core/nth args9561 0)))))))
  (clojure.core/defn
   create-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         resource-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createTags"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-tags,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   create-tags
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         resource-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createTags"}
   [credentials9564 & args9565]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9566
     (com.palletops.awaze.common/aws-client :redshift credentials9564)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9566
      createTags
      (redshift/create-tags-request (clojure.core/nth args9565 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-orderable-cluster-options
   [m9567]
   (clojure.core/let
    [credentials9568 (:credentials m9567) args9569 (:args m9567)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9570
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9568)]
     (clojure.core/case
      (clojure.core/count args9569)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9570
        describeOrderableClusterOptions))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9570
        describeOrderableClusterOptions
        (redshift/describe-orderable-cluster-options-request
         (clojure.core/nth args9569 0))))))))
  (clojure.core/defn
   describe-orderable-cluster-options-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         cluster-version
                         custom-query-parameters
                         node-type
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeOrderableClusterOptions, describeOrderableClusterOptions"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-orderable-cluster-options,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-orderable-cluster-options,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-orderable-cluster-options
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         cluster-version
                         custom-query-parameters
                         node-type
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeOrderableClusterOptions, describeOrderableClusterOptions"}
   [credentials9572 & args9573]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9574
     (com.palletops.awaze.common/aws-client :redshift credentials9572)]
    (clojure.core/case
     (clojure.core/count args9573)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9574
       describeOrderableClusterOptions))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9574
       describeOrderableClusterOptions
       (redshift/describe-orderable-cluster-options-request
        (clojure.core/nth args9573 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :enable-logging
   [m9575]
   (clojure.core/let
    [credentials9576 (:credentials m9575) args9577 (:args m9575)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9578
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9576)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9578
       enableLogging
       (redshift/enable-logging-request (clojure.core/nth args9577 0)))))))
  (clojure.core/defn
   enable-logging-map
   {:arglists (quote
               [[credentials
                 {:keys [s3key-prefix
                         custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for enableLogging"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :enable-logging,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   enable-logging
   {:arglists (quote
               [[credentials
                 {:keys [s3key-prefix
                         custom-request-headers
                         sdk-client-execution-timeout
                         cluster-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Call enableLogging"}
   [credentials9580 & args9581]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9582
     (com.palletops.awaze.common/aws-client :redshift credentials9580)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9582
      enableLogging
      (redshift/enable-logging-request (clojure.core/nth args9581 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :revoke-snapshot-access
   [m9583]
   (clojure.core/let
    [credentials9584 (:credentials m9583) args9585 (:args m9583)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9586
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9584)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9586
       revokeSnapshotAccess
       (redshift/revoke-snapshot-access-request
        (clojure.core/nth args9585 0)))))))
  (clojure.core/defn
   revoke-snapshot-access-map
   {:arglists (quote
               [[credentials
                 {:keys [account-with-restore-access
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         snapshot-identifier
                         read-limit
                         general-progress-listener
                         snapshot-cluster-identifier
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for revokeSnapshotAccess"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :revoke-snapshot-access,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   revoke-snapshot-access
   {:arglists (quote
               [[credentials
                 {:keys [account-with-restore-access
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         snapshot-identifier
                         read-limit
                         general-progress-listener
                         snapshot-cluster-identifier
                         clone-source
                         clone-root]}]]),
    :doc "Call revokeSnapshotAccess"}
   [credentials9588 & args9589]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9590
     (com.palletops.awaze.common/aws-client :redshift credentials9588)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9590
      revokeSnapshotAccess
      (redshift/revoke-snapshot-access-request
       (clojure.core/nth args9589 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-event-subscriptions
   [m9591]
   (clojure.core/let
    [credentials9592 (:credentials m9591) args9593 (:args m9591)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9594
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9592)]
     (clojure.core/case
      (clojure.core/count args9593)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9594
        describeEventSubscriptions))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9594
        describeEventSubscriptions
        (redshift/describe-event-subscriptions-request
         (clojure.core/nth args9593 0))))))))
  (clojure.core/defn
   describe-event-subscriptions-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subscription-name
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeEventSubscriptions, describeEventSubscriptions"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-event-subscriptions,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-event-subscriptions,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-event-subscriptions
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subscription-name
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeEventSubscriptions, describeEventSubscriptions"}
   [credentials9596 & args9597]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9598
     (com.palletops.awaze.common/aws-client :redshift credentials9596)]
    (clojure.core/case
     (clojure.core/count args9597)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9598
       describeEventSubscriptions))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9598
       describeEventSubscriptions
       (redshift/describe-event-subscriptions-request
        (clojure.core/nth args9597 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-reserved-node-offerings
   [m9599]
   (clojure.core/let
    [credentials9600 (:credentials m9599) args9601 (:args m9599)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9602
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9600)]
     (clojure.core/case
      (clojure.core/count args9601)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9602
        describeReservedNodeOfferings
        (redshift/describe-reserved-node-offerings-request
         (clojure.core/nth args9601 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9602
        describeReservedNodeOfferings))))))
  (clojure.core/defn
   describe-reserved-node-offerings-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         reserved-node-offering-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeReservedNodeOfferings, describeReservedNodeOfferings"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-reserved-node-offerings,
     :credentials credentials__1842__auto__,
     :client :redshift})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-reserved-node-offerings,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   describe-reserved-node-offerings
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         reserved-node-offering-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeReservedNodeOfferings, describeReservedNodeOfferings"}
   [credentials9604 & args9605]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9606
     (com.palletops.awaze.common/aws-client :redshift credentials9604)]
    (clojure.core/case
     (clojure.core/count args9605)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9606
       describeReservedNodeOfferings
       (redshift/describe-reserved-node-offerings-request
        (clojure.core/nth args9605 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9606
       describeReservedNodeOfferings))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-hsm-configuration
   [m9607]
   (clojure.core/let
    [credentials9608 (:credentials m9607) args9609 (:args m9607)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9610
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9608)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9610
       deleteHsmConfiguration
       (redshift/delete-hsm-configuration-request
        (clojure.core/nth args9609 0)))))))
  (clojure.core/defn
   delete-hsm-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [hsm-configuration-identifier
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteHsmConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-hsm-configuration,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   delete-hsm-configuration
   {:arglists (quote
               [[credentials
                 {:keys [hsm-configuration-identifier
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteHsmConfiguration"}
   [credentials9612 & args9613]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9614
     (com.palletops.awaze.common/aws-client :redshift credentials9612)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9614
      deleteHsmConfiguration
      (redshift/delete-hsm-configuration-request
       (clojure.core/nth args9613 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-event-subscription
   [m9615]
   (clojure.core/let
    [credentials9616 (:credentials m9615) args9617 (:args m9615)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client9618
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials9616)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9618
       createEventSubscription
       (redshift/create-event-subscription-request
        (clojure.core/nth args9617 0)))))))
  (clojure.core/defn
   create-event-subscription-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         subscription-name
                         sdk-request-timeout
                         source-type
                         custom-query-parameters
                         source-ids
                         read-limit
                         general-progress-listener
                         severity
                         event-categories
                         clone-source
                         sns-topic-arn
                         enabled
                         clone-root]}]]),
    :doc "Generate map for createEventSubscription"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-event-subscription,
     :credentials credentials__1842__auto__,
     :client :redshift}))
  (clojure.core/defn
   create-event-subscription
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         subscription-name
                         sdk-request-timeout
                         source-type
                         custom-query-parameters
                         source-ids
                         read-limit
                         general-progress-listener
                         severity
                         event-categories
                         clone-source
                         sns-topic-arn
                         enabled
                         clone-root]}]]),
    :doc "Call createEventSubscription"}
   [credentials9620 & args9621]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client9622
     (com.palletops.awaze.common/aws-client :redshift credentials9620)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client9622
      createEventSubscription
      (redshift/create-event-subscription-request
       (clojure.core/nth args9621 0))))))))
